package storage

// Code generated by cdproto-gen. DO NOT EDIT.

import (
	"fmt"

	"github.com/chromedp/cdproto/cdp"
	"github.com/mailru/easyjson"
	"github.com/mailru/easyjson/jlexer"
	"github.com/mailru/easyjson/jwriter"
)

// SerializedStorageKey [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#type-SerializedStorageKey
type SerializedStorageKey string

// String returns the SerializedStorageKey as string value.
func (t SerializedStorageKey) String() string {
	return string(t)
}

// Type enum of possible storage types.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#type-StorageType
type Type string

// String returns the Type as string value.
func (t Type) String() string {
	return string(t)
}

// Type values.
const (
	TypeAppcache       Type = "appcache"
	TypeCookies        Type = "cookies"
	TypeFileSystems    Type = "file_systems"
	TypeIndexeddb      Type = "indexeddb"
	TypeLocalStorage   Type = "local_storage"
	TypeShaderCache    Type = "shader_cache"
	TypeWebsql         Type = "websql"
	TypeServiceWorkers Type = "service_workers"
	TypeCacheStorage   Type = "cache_storage"
	TypeInterestGroups Type = "interest_groups"
	TypeSharedStorage  Type = "shared_storage"
	TypeStorageBuckets Type = "storage_buckets"
	TypeAll            Type = "all"
	TypeOther          Type = "other"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t Type) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t Type) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *Type) UnmarshalEasyJSON(in *jlexer.Lexer) {
	v := in.String()
	switch Type(v) {
	case TypeAppcache:
		*t = TypeAppcache
	case TypeCookies:
		*t = TypeCookies
	case TypeFileSystems:
		*t = TypeFileSystems
	case TypeIndexeddb:
		*t = TypeIndexeddb
	case TypeLocalStorage:
		*t = TypeLocalStorage
	case TypeShaderCache:
		*t = TypeShaderCache
	case TypeWebsql:
		*t = TypeWebsql
	case TypeServiceWorkers:
		*t = TypeServiceWorkers
	case TypeCacheStorage:
		*t = TypeCacheStorage
	case TypeInterestGroups:
		*t = TypeInterestGroups
	case TypeSharedStorage:
		*t = TypeSharedStorage
	case TypeStorageBuckets:
		*t = TypeStorageBuckets
	case TypeAll:
		*t = TypeAll
	case TypeOther:
		*t = TypeOther

	default:
		in.AddError(fmt.Errorf("unknown Type value: %v", v))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *Type) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}

// UsageForType usage for a storage type.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#type-UsageForType
type UsageForType struct {
	StorageType Type    `json:"storageType"` // Name of storage type.
	Usage       float64 `json:"usage"`       // Storage usage (bytes).
}

// TrustTokens pair of issuer origin and number of available (signed, but not
// used) Trust Tokens from that issuer.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#type-TrustTokens
type TrustTokens struct {
	IssuerOrigin string  `json:"issuerOrigin"`
	Count        float64 `json:"count"`
}

// InterestGroupAuctionID protected audience interest group auction
// identifier.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#type-InterestGroupAuctionId
type InterestGroupAuctionID string

// String returns the InterestGroupAuctionID as string value.
func (t InterestGroupAuctionID) String() string {
	return string(t)
}

// InterestGroupAccessType enum of interest group access types.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#type-InterestGroupAccessType
type InterestGroupAccessType string

// String returns the InterestGroupAccessType as string value.
func (t InterestGroupAccessType) String() string {
	return string(t)
}

// InterestGroupAccessType values.
const (
	InterestGroupAccessTypeJoin                  InterestGroupAccessType = "join"
	InterestGroupAccessTypeLeave                 InterestGroupAccessType = "leave"
	InterestGroupAccessTypeUpdate                InterestGroupAccessType = "update"
	InterestGroupAccessTypeLoaded                InterestGroupAccessType = "loaded"
	InterestGroupAccessTypeBid                   InterestGroupAccessType = "bid"
	InterestGroupAccessTypeWin                   InterestGroupAccessType = "win"
	InterestGroupAccessTypeAdditionalBid         InterestGroupAccessType = "additionalBid"
	InterestGroupAccessTypeAdditionalBidWin      InterestGroupAccessType = "additionalBidWin"
	InterestGroupAccessTypeTopLevelBid           InterestGroupAccessType = "topLevelBid"
	InterestGroupAccessTypeTopLevelAdditionalBid InterestGroupAccessType = "topLevelAdditionalBid"
	InterestGroupAccessTypeClear                 InterestGroupAccessType = "clear"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t InterestGroupAccessType) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t InterestGroupAccessType) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *InterestGroupAccessType) UnmarshalEasyJSON(in *jlexer.Lexer) {
	v := in.String()
	switch InterestGroupAccessType(v) {
	case InterestGroupAccessTypeJoin:
		*t = InterestGroupAccessTypeJoin
	case InterestGroupAccessTypeLeave:
		*t = InterestGroupAccessTypeLeave
	case InterestGroupAccessTypeUpdate:
		*t = InterestGroupAccessTypeUpdate
	case InterestGroupAccessTypeLoaded:
		*t = InterestGroupAccessTypeLoaded
	case InterestGroupAccessTypeBid:
		*t = InterestGroupAccessTypeBid
	case InterestGroupAccessTypeWin:
		*t = InterestGroupAccessTypeWin
	case InterestGroupAccessTypeAdditionalBid:
		*t = InterestGroupAccessTypeAdditionalBid
	case InterestGroupAccessTypeAdditionalBidWin:
		*t = InterestGroupAccessTypeAdditionalBidWin
	case InterestGroupAccessTypeTopLevelBid:
		*t = InterestGroupAccessTypeTopLevelBid
	case InterestGroupAccessTypeTopLevelAdditionalBid:
		*t = InterestGroupAccessTypeTopLevelAdditionalBid
	case InterestGroupAccessTypeClear:
		*t = InterestGroupAccessTypeClear

	default:
		in.AddError(fmt.Errorf("unknown InterestGroupAccessType value: %v", v))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *InterestGroupAccessType) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}

// InterestGroupAuctionEventType enum of auction events.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#type-InterestGroupAuctionEventType
type InterestGroupAuctionEventType string

// String returns the InterestGroupAuctionEventType as string value.
func (t InterestGroupAuctionEventType) String() string {
	return string(t)
}

// InterestGroupAuctionEventType values.
const (
	InterestGroupAuctionEventTypeStarted        InterestGroupAuctionEventType = "started"
	InterestGroupAuctionEventTypeConfigResolved InterestGroupAuctionEventType = "configResolved"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t InterestGroupAuctionEventType) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t InterestGroupAuctionEventType) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *InterestGroupAuctionEventType) UnmarshalEasyJSON(in *jlexer.Lexer) {
	v := in.String()
	switch InterestGroupAuctionEventType(v) {
	case InterestGroupAuctionEventTypeStarted:
		*t = InterestGroupAuctionEventTypeStarted
	case InterestGroupAuctionEventTypeConfigResolved:
		*t = InterestGroupAuctionEventTypeConfigResolved

	default:
		in.AddError(fmt.Errorf("unknown InterestGroupAuctionEventType value: %v", v))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *InterestGroupAuctionEventType) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}

// InterestGroupAuctionFetchType enum of network fetches auctions can do.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#type-InterestGroupAuctionFetchType
type InterestGroupAuctionFetchType string

// String returns the InterestGroupAuctionFetchType as string value.
func (t InterestGroupAuctionFetchType) String() string {
	return string(t)
}

// InterestGroupAuctionFetchType values.
const (
	InterestGroupAuctionFetchTypeBidderJs             InterestGroupAuctionFetchType = "bidderJs"
	InterestGroupAuctionFetchTypeBidderWasm           InterestGroupAuctionFetchType = "bidderWasm"
	InterestGroupAuctionFetchTypeSellerJs             InterestGroupAuctionFetchType = "sellerJs"
	InterestGroupAuctionFetchTypeBidderTrustedSignals InterestGroupAuctionFetchType = "bidderTrustedSignals"
	InterestGroupAuctionFetchTypeSellerTrustedSignals InterestGroupAuctionFetchType = "sellerTrustedSignals"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t InterestGroupAuctionFetchType) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t InterestGroupAuctionFetchType) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *InterestGroupAuctionFetchType) UnmarshalEasyJSON(in *jlexer.Lexer) {
	v := in.String()
	switch InterestGroupAuctionFetchType(v) {
	case InterestGroupAuctionFetchTypeBidderJs:
		*t = InterestGroupAuctionFetchTypeBidderJs
	case InterestGroupAuctionFetchTypeBidderWasm:
		*t = InterestGroupAuctionFetchTypeBidderWasm
	case InterestGroupAuctionFetchTypeSellerJs:
		*t = InterestGroupAuctionFetchTypeSellerJs
	case InterestGroupAuctionFetchTypeBidderTrustedSignals:
		*t = InterestGroupAuctionFetchTypeBidderTrustedSignals
	case InterestGroupAuctionFetchTypeSellerTrustedSignals:
		*t = InterestGroupAuctionFetchTypeSellerTrustedSignals

	default:
		in.AddError(fmt.Errorf("unknown InterestGroupAuctionFetchType value: %v", v))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *InterestGroupAuctionFetchType) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}

// SharedStorageAccessType enum of shared storage access types.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#type-SharedStorageAccessType
type SharedStorageAccessType string

// String returns the SharedStorageAccessType as string value.
func (t SharedStorageAccessType) String() string {
	return string(t)
}

// SharedStorageAccessType values.
const (
	SharedStorageAccessTypeDocumentAddModule      SharedStorageAccessType = "documentAddModule"
	SharedStorageAccessTypeDocumentSelectURL      SharedStorageAccessType = "documentSelectURL"
	SharedStorageAccessTypeDocumentRun            SharedStorageAccessType = "documentRun"
	SharedStorageAccessTypeDocumentSet            SharedStorageAccessType = "documentSet"
	SharedStorageAccessTypeDocumentAppend         SharedStorageAccessType = "documentAppend"
	SharedStorageAccessTypeDocumentDelete         SharedStorageAccessType = "documentDelete"
	SharedStorageAccessTypeDocumentClear          SharedStorageAccessType = "documentClear"
	SharedStorageAccessTypeDocumentGet            SharedStorageAccessType = "documentGet"
	SharedStorageAccessTypeWorkletSet             SharedStorageAccessType = "workletSet"
	SharedStorageAccessTypeWorkletAppend          SharedStorageAccessType = "workletAppend"
	SharedStorageAccessTypeWorkletDelete          SharedStorageAccessType = "workletDelete"
	SharedStorageAccessTypeWorkletClear           SharedStorageAccessType = "workletClear"
	SharedStorageAccessTypeWorkletGet             SharedStorageAccessType = "workletGet"
	SharedStorageAccessTypeWorkletKeys            SharedStorageAccessType = "workletKeys"
	SharedStorageAccessTypeWorkletEntries         SharedStorageAccessType = "workletEntries"
	SharedStorageAccessTypeWorkletLength          SharedStorageAccessType = "workletLength"
	SharedStorageAccessTypeWorkletRemainingBudget SharedStorageAccessType = "workletRemainingBudget"
	SharedStorageAccessTypeHeaderSet              SharedStorageAccessType = "headerSet"
	SharedStorageAccessTypeHeaderAppend           SharedStorageAccessType = "headerAppend"
	SharedStorageAccessTypeHeaderDelete           SharedStorageAccessType = "headerDelete"
	SharedStorageAccessTypeHeaderClear            SharedStorageAccessType = "headerClear"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t SharedStorageAccessType) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t SharedStorageAccessType) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *SharedStorageAccessType) UnmarshalEasyJSON(in *jlexer.Lexer) {
	v := in.String()
	switch SharedStorageAccessType(v) {
	case SharedStorageAccessTypeDocumentAddModule:
		*t = SharedStorageAccessTypeDocumentAddModule
	case SharedStorageAccessTypeDocumentSelectURL:
		*t = SharedStorageAccessTypeDocumentSelectURL
	case SharedStorageAccessTypeDocumentRun:
		*t = SharedStorageAccessTypeDocumentRun
	case SharedStorageAccessTypeDocumentSet:
		*t = SharedStorageAccessTypeDocumentSet
	case SharedStorageAccessTypeDocumentAppend:
		*t = SharedStorageAccessTypeDocumentAppend
	case SharedStorageAccessTypeDocumentDelete:
		*t = SharedStorageAccessTypeDocumentDelete
	case SharedStorageAccessTypeDocumentClear:
		*t = SharedStorageAccessTypeDocumentClear
	case SharedStorageAccessTypeDocumentGet:
		*t = SharedStorageAccessTypeDocumentGet
	case SharedStorageAccessTypeWorkletSet:
		*t = SharedStorageAccessTypeWorkletSet
	case SharedStorageAccessTypeWorkletAppend:
		*t = SharedStorageAccessTypeWorkletAppend
	case SharedStorageAccessTypeWorkletDelete:
		*t = SharedStorageAccessTypeWorkletDelete
	case SharedStorageAccessTypeWorkletClear:
		*t = SharedStorageAccessTypeWorkletClear
	case SharedStorageAccessTypeWorkletGet:
		*t = SharedStorageAccessTypeWorkletGet
	case SharedStorageAccessTypeWorkletKeys:
		*t = SharedStorageAccessTypeWorkletKeys
	case SharedStorageAccessTypeWorkletEntries:
		*t = SharedStorageAccessTypeWorkletEntries
	case SharedStorageAccessTypeWorkletLength:
		*t = SharedStorageAccessTypeWorkletLength
	case SharedStorageAccessTypeWorkletRemainingBudget:
		*t = SharedStorageAccessTypeWorkletRemainingBudget
	case SharedStorageAccessTypeHeaderSet:
		*t = SharedStorageAccessTypeHeaderSet
	case SharedStorageAccessTypeHeaderAppend:
		*t = SharedStorageAccessTypeHeaderAppend
	case SharedStorageAccessTypeHeaderDelete:
		*t = SharedStorageAccessTypeHeaderDelete
	case SharedStorageAccessTypeHeaderClear:
		*t = SharedStorageAccessTypeHeaderClear

	default:
		in.AddError(fmt.Errorf("unknown SharedStorageAccessType value: %v", v))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *SharedStorageAccessType) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}

// SharedStorageEntry struct for a single key-value pair in an origin's
// shared storage.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#type-SharedStorageEntry
type SharedStorageEntry struct {
	Key   string `json:"key"`
	Value string `json:"value"`
}

// SharedStorageMetadata details for an origin's shared storage.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#type-SharedStorageMetadata
type SharedStorageMetadata struct {
	CreationTime    *cdp.TimeSinceEpoch `json:"creationTime"`    // Time when the origin's shared storage was last created.
	Length          int64               `json:"length"`          // Number of key-value pairs stored in origin's shared storage.
	RemainingBudget float64             `json:"remainingBudget"` // Current amount of bits of entropy remaining in the navigation budget.
	BytesUsed       int64               `json:"bytesUsed"`       // Total number of bytes stored as key-value pairs in origin's shared storage.
}

// SharedStorageReportingMetadata pair of reporting metadata details for a
// candidate URL for selectURL().
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#type-SharedStorageReportingMetadata
type SharedStorageReportingMetadata struct {
	EventType    string `json:"eventType"`
	ReportingURL string `json:"reportingUrl"`
}

// SharedStorageURLWithMetadata bundles a candidate URL with its reporting
// metadata.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#type-SharedStorageUrlWithMetadata
type SharedStorageURLWithMetadata struct {
	URL               string                            `json:"url"`               // Spec of candidate URL.
	ReportingMetadata []*SharedStorageReportingMetadata `json:"reportingMetadata"` // Any associated reporting metadata.
}

// SharedStorageAccessParams bundles the parameters for shared storage access
// events whose presence/absence can vary according to SharedStorageAccessType.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#type-SharedStorageAccessParams
type SharedStorageAccessParams struct {
	ScriptSourceURL  string                          `json:"scriptSourceUrl,omitempty"`  // Spec of the module script URL. Present only for SharedStorageAccessType.documentAddModule.
	OperationName    string                          `json:"operationName,omitempty"`    // Name of the registered operation to be run. Present only for SharedStorageAccessType.documentRun and SharedStorageAccessType.documentSelectURL.
	SerializedData   string                          `json:"serializedData,omitempty"`   // The operation's serialized data in bytes (converted to a string). Present only for SharedStorageAccessType.documentRun and SharedStorageAccessType.documentSelectURL.
	UrlsWithMetadata []*SharedStorageURLWithMetadata `json:"urlsWithMetadata,omitempty"` // Array of candidate URLs' specs, along with any associated metadata. Present only for SharedStorageAccessType.documentSelectURL.
	Key              string                          `json:"key,omitempty"`              // Key for a specific entry in an origin's shared storage. Present only for SharedStorageAccessType.documentSet, SharedStorageAccessType.documentAppend, SharedStorageAccessType.documentDelete, SharedStorageAccessType.workletSet, SharedStorageAccessType.workletAppend, SharedStorageAccessType.workletDelete, SharedStorageAccessType.workletGet, SharedStorageAccessType.headerSet, SharedStorageAccessType.headerAppend, and SharedStorageAccessType.headerDelete.
	Value            string                          `json:"value,omitempty"`            // Value for a specific entry in an origin's shared storage. Present only for SharedStorageAccessType.documentSet, SharedStorageAccessType.documentAppend, SharedStorageAccessType.workletSet, SharedStorageAccessType.workletAppend, SharedStorageAccessType.headerSet, and SharedStorageAccessType.headerAppend.
	IgnoreIfPresent  bool                            `json:"ignoreIfPresent,omitempty"`  // Whether or not to set an entry for a key if that key is already present. Present only for SharedStorageAccessType.documentSet, SharedStorageAccessType.workletSet, and SharedStorageAccessType.headerSet.
}

// BucketsDurability [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#type-StorageBucketsDurability
type BucketsDurability string

// String returns the BucketsDurability as string value.
func (t BucketsDurability) String() string {
	return string(t)
}

// BucketsDurability values.
const (
	BucketsDurabilityRelaxed BucketsDurability = "relaxed"
	BucketsDurabilityStrict  BucketsDurability = "strict"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t BucketsDurability) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t BucketsDurability) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *BucketsDurability) UnmarshalEasyJSON(in *jlexer.Lexer) {
	v := in.String()
	switch BucketsDurability(v) {
	case BucketsDurabilityRelaxed:
		*t = BucketsDurabilityRelaxed
	case BucketsDurabilityStrict:
		*t = BucketsDurabilityStrict

	default:
		in.AddError(fmt.Errorf("unknown BucketsDurability value: %v", v))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *BucketsDurability) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}

// Bucket [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#type-StorageBucket
type Bucket struct {
	StorageKey SerializedStorageKey `json:"storageKey"`
	Name       string               `json:"name,omitempty"` // If not specified, it is the default bucket of the storageKey.
}

// BucketInfo [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#type-StorageBucketInfo
type BucketInfo struct {
	Bucket     *Bucket             `json:"bucket"`
	ID         string              `json:"id"`
	Expiration *cdp.TimeSinceEpoch `json:"expiration"`
	Quota      float64             `json:"quota"` // Storage quota (bytes).
	Persistent bool                `json:"persistent"`
	Durability BucketsDurability   `json:"durability"`
}

// AttributionReportingSourceType [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#type-AttributionReportingSourceType
type AttributionReportingSourceType string

// String returns the AttributionReportingSourceType as string value.
func (t AttributionReportingSourceType) String() string {
	return string(t)
}

// AttributionReportingSourceType values.
const (
	AttributionReportingSourceTypeNavigation AttributionReportingSourceType = "navigation"
	AttributionReportingSourceTypeEvent      AttributionReportingSourceType = "event"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t AttributionReportingSourceType) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t AttributionReportingSourceType) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *AttributionReportingSourceType) UnmarshalEasyJSON(in *jlexer.Lexer) {
	v := in.String()
	switch AttributionReportingSourceType(v) {
	case AttributionReportingSourceTypeNavigation:
		*t = AttributionReportingSourceTypeNavigation
	case AttributionReportingSourceTypeEvent:
		*t = AttributionReportingSourceTypeEvent

	default:
		in.AddError(fmt.Errorf("unknown AttributionReportingSourceType value: %v", v))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *AttributionReportingSourceType) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}

// UnsignedInt64asBase10 [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#type-UnsignedInt64AsBase10
type UnsignedInt64asBase10 string

// String returns the UnsignedInt64asBase10 as string value.
func (t UnsignedInt64asBase10) String() string {
	return string(t)
}

// UnsignedInt128asBase16 [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#type-UnsignedInt128AsBase16
type UnsignedInt128asBase16 string

// String returns the UnsignedInt128asBase16 as string value.
func (t UnsignedInt128asBase16) String() string {
	return string(t)
}

// SignedInt64asBase10 [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#type-SignedInt64AsBase10
type SignedInt64asBase10 string

// String returns the SignedInt64asBase10 as string value.
func (t SignedInt64asBase10) String() string {
	return string(t)
}

// AttributionReportingFilterDataEntry [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#type-AttributionReportingFilterDataEntry
type AttributionReportingFilterDataEntry struct {
	Key    string   `json:"key"`
	Values []string `json:"values"`
}

// AttributionReportingFilterConfig [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#type-AttributionReportingFilterConfig
type AttributionReportingFilterConfig struct {
	FilterValues   []*AttributionReportingFilterDataEntry `json:"filterValues"`
	LookbackWindow int64                                  `json:"lookbackWindow,omitempty"` // duration in seconds
}

// AttributionReportingFilterPair [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#type-AttributionReportingFilterPair
type AttributionReportingFilterPair struct {
	Filters    []*AttributionReportingFilterConfig `json:"filters"`
	NotFilters []*AttributionReportingFilterConfig `json:"notFilters"`
}

// AttributionReportingAggregationKeysEntry [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#type-AttributionReportingAggregationKeysEntry
type AttributionReportingAggregationKeysEntry struct {
	Key   string                 `json:"key"`
	Value UnsignedInt128asBase16 `json:"value"`
}

// AttributionReportingEventReportWindows [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#type-AttributionReportingEventReportWindows
type AttributionReportingEventReportWindows struct {
	Start int64   `json:"start"` // duration in seconds
	Ends  []int64 `json:"ends"`  // duration in seconds
}

// AttributionReportingTriggerSpec [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#type-AttributionReportingTriggerSpec
type AttributionReportingTriggerSpec struct {
	TriggerData        []float64                               `json:"triggerData"` // number instead of integer because not all uint32 can be represented by int
	EventReportWindows *AttributionReportingEventReportWindows `json:"eventReportWindows"`
}

// AttributionReportingTriggerDataMatching [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#type-AttributionReportingTriggerDataMatching
type AttributionReportingTriggerDataMatching string

// String returns the AttributionReportingTriggerDataMatching as string value.
func (t AttributionReportingTriggerDataMatching) String() string {
	return string(t)
}

// AttributionReportingTriggerDataMatching values.
const (
	AttributionReportingTriggerDataMatchingExact   AttributionReportingTriggerDataMatching = "exact"
	AttributionReportingTriggerDataMatchingModulus AttributionReportingTriggerDataMatching = "modulus"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t AttributionReportingTriggerDataMatching) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t AttributionReportingTriggerDataMatching) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *AttributionReportingTriggerDataMatching) UnmarshalEasyJSON(in *jlexer.Lexer) {
	v := in.String()
	switch AttributionReportingTriggerDataMatching(v) {
	case AttributionReportingTriggerDataMatchingExact:
		*t = AttributionReportingTriggerDataMatchingExact
	case AttributionReportingTriggerDataMatchingModulus:
		*t = AttributionReportingTriggerDataMatchingModulus

	default:
		in.AddError(fmt.Errorf("unknown AttributionReportingTriggerDataMatching value: %v", v))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *AttributionReportingTriggerDataMatching) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}

// AttributionReportingAggregatableDebugReportingData [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#type-AttributionReportingAggregatableDebugReportingData
type AttributionReportingAggregatableDebugReportingData struct {
	KeyPiece UnsignedInt128asBase16 `json:"keyPiece"`
	Value    float64                `json:"value"` // number instead of integer because not all uint32 can be represented by int
	Types    []string               `json:"types"`
}

// AttributionReportingAggregatableDebugReportingConfig [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#type-AttributionReportingAggregatableDebugReportingConfig
type AttributionReportingAggregatableDebugReportingConfig struct {
	Budget                       float64                                               `json:"budget,omitempty"` // number instead of integer because not all uint32 can be represented by int, only present for source registrations
	KeyPiece                     UnsignedInt128asBase16                                `json:"keyPiece"`
	DebugData                    []*AttributionReportingAggregatableDebugReportingData `json:"debugData"`
	AggregationCoordinatorOrigin string                                                `json:"aggregationCoordinatorOrigin,omitempty"`
}

// AttributionScopesData [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#type-AttributionScopesData
type AttributionScopesData struct {
	Values         []string `json:"values"`
	Limit          float64  `json:"limit"` // number instead of integer because not all uint32 can be represented by int
	MaxEventStates float64  `json:"maxEventStates"`
}

// AttributionReportingSourceRegistration [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#type-AttributionReportingSourceRegistration
type AttributionReportingSourceRegistration struct {
	Time                             *cdp.TimeSinceEpoch                                   `json:"time"`
	Expiry                           int64                                                 `json:"expiry"` // duration in seconds
	TriggerSpecs                     []*AttributionReportingTriggerSpec                    `json:"triggerSpecs"`
	AggregatableReportWindow         int64                                                 `json:"aggregatableReportWindow"` // duration in seconds
	Type                             AttributionReportingSourceType                        `json:"type"`
	SourceOrigin                     string                                                `json:"sourceOrigin"`
	ReportingOrigin                  string                                                `json:"reportingOrigin"`
	DestinationSites                 []string                                              `json:"destinationSites"`
	EventID                          UnsignedInt64asBase10                                 `json:"eventId"`
	Priority                         SignedInt64asBase10                                   `json:"priority"`
	FilterData                       []*AttributionReportingFilterDataEntry                `json:"filterData"`
	AggregationKeys                  []*AttributionReportingAggregationKeysEntry           `json:"aggregationKeys"`
	DebugKey                         UnsignedInt64asBase10                                 `json:"debugKey,omitempty"`
	TriggerDataMatching              AttributionReportingTriggerDataMatching               `json:"triggerDataMatching"`
	DestinationLimitPriority         SignedInt64asBase10                                   `json:"destinationLimitPriority"`
	AggregatableDebugReportingConfig *AttributionReportingAggregatableDebugReportingConfig `json:"aggregatableDebugReportingConfig"`
	ScopesData                       *AttributionScopesData                                `json:"scopesData,omitempty"`
}

// AttributionReportingSourceRegistrationResult [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#type-AttributionReportingSourceRegistrationResult
type AttributionReportingSourceRegistrationResult string

// String returns the AttributionReportingSourceRegistrationResult as string value.
func (t AttributionReportingSourceRegistrationResult) String() string {
	return string(t)
}

// AttributionReportingSourceRegistrationResult values.
const (
	AttributionReportingSourceRegistrationResultSuccess                                AttributionReportingSourceRegistrationResult = "success"
	AttributionReportingSourceRegistrationResultInternalError                          AttributionReportingSourceRegistrationResult = "internalError"
	AttributionReportingSourceRegistrationResultInsufficientSourceCapacity             AttributionReportingSourceRegistrationResult = "insufficientSourceCapacity"
	AttributionReportingSourceRegistrationResultInsufficientUniqueDestinationCapacity  AttributionReportingSourceRegistrationResult = "insufficientUniqueDestinationCapacity"
	AttributionReportingSourceRegistrationResultExcessiveReportingOrigins              AttributionReportingSourceRegistrationResult = "excessiveReportingOrigins"
	AttributionReportingSourceRegistrationResultProhibitedByBrowserPolicy              AttributionReportingSourceRegistrationResult = "prohibitedByBrowserPolicy"
	AttributionReportingSourceRegistrationResultSuccessNoised                          AttributionReportingSourceRegistrationResult = "successNoised"
	AttributionReportingSourceRegistrationResultDestinationReportingLimitReached       AttributionReportingSourceRegistrationResult = "destinationReportingLimitReached"
	AttributionReportingSourceRegistrationResultDestinationGlobalLimitReached          AttributionReportingSourceRegistrationResult = "destinationGlobalLimitReached"
	AttributionReportingSourceRegistrationResultDestinationBothLimitsReached           AttributionReportingSourceRegistrationResult = "destinationBothLimitsReached"
	AttributionReportingSourceRegistrationResultReportingOriginsPerSiteLimitReached    AttributionReportingSourceRegistrationResult = "reportingOriginsPerSiteLimitReached"
	AttributionReportingSourceRegistrationResultExceedsMaxChannelCapacity              AttributionReportingSourceRegistrationResult = "exceedsMaxChannelCapacity"
	AttributionReportingSourceRegistrationResultExceedsMaxScopesChannelCapacity        AttributionReportingSourceRegistrationResult = "exceedsMaxScopesChannelCapacity"
	AttributionReportingSourceRegistrationResultExceedsMaxTriggerStateCardinality      AttributionReportingSourceRegistrationResult = "exceedsMaxTriggerStateCardinality"
	AttributionReportingSourceRegistrationResultExceedsMaxEventStatesLimit             AttributionReportingSourceRegistrationResult = "exceedsMaxEventStatesLimit"
	AttributionReportingSourceRegistrationResultDestinationPerDayReportingLimitReached AttributionReportingSourceRegistrationResult = "destinationPerDayReportingLimitReached"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t AttributionReportingSourceRegistrationResult) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t AttributionReportingSourceRegistrationResult) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *AttributionReportingSourceRegistrationResult) UnmarshalEasyJSON(in *jlexer.Lexer) {
	v := in.String()
	switch AttributionReportingSourceRegistrationResult(v) {
	case AttributionReportingSourceRegistrationResultSuccess:
		*t = AttributionReportingSourceRegistrationResultSuccess
	case AttributionReportingSourceRegistrationResultInternalError:
		*t = AttributionReportingSourceRegistrationResultInternalError
	case AttributionReportingSourceRegistrationResultInsufficientSourceCapacity:
		*t = AttributionReportingSourceRegistrationResultInsufficientSourceCapacity
	case AttributionReportingSourceRegistrationResultInsufficientUniqueDestinationCapacity:
		*t = AttributionReportingSourceRegistrationResultInsufficientUniqueDestinationCapacity
	case AttributionReportingSourceRegistrationResultExcessiveReportingOrigins:
		*t = AttributionReportingSourceRegistrationResultExcessiveReportingOrigins
	case AttributionReportingSourceRegistrationResultProhibitedByBrowserPolicy:
		*t = AttributionReportingSourceRegistrationResultProhibitedByBrowserPolicy
	case AttributionReportingSourceRegistrationResultSuccessNoised:
		*t = AttributionReportingSourceRegistrationResultSuccessNoised
	case AttributionReportingSourceRegistrationResultDestinationReportingLimitReached:
		*t = AttributionReportingSourceRegistrationResultDestinationReportingLimitReached
	case AttributionReportingSourceRegistrationResultDestinationGlobalLimitReached:
		*t = AttributionReportingSourceRegistrationResultDestinationGlobalLimitReached
	case AttributionReportingSourceRegistrationResultDestinationBothLimitsReached:
		*t = AttributionReportingSourceRegistrationResultDestinationBothLimitsReached
	case AttributionReportingSourceRegistrationResultReportingOriginsPerSiteLimitReached:
		*t = AttributionReportingSourceRegistrationResultReportingOriginsPerSiteLimitReached
	case AttributionReportingSourceRegistrationResultExceedsMaxChannelCapacity:
		*t = AttributionReportingSourceRegistrationResultExceedsMaxChannelCapacity
	case AttributionReportingSourceRegistrationResultExceedsMaxScopesChannelCapacity:
		*t = AttributionReportingSourceRegistrationResultExceedsMaxScopesChannelCapacity
	case AttributionReportingSourceRegistrationResultExceedsMaxTriggerStateCardinality:
		*t = AttributionReportingSourceRegistrationResultExceedsMaxTriggerStateCardinality
	case AttributionReportingSourceRegistrationResultExceedsMaxEventStatesLimit:
		*t = AttributionReportingSourceRegistrationResultExceedsMaxEventStatesLimit
	case AttributionReportingSourceRegistrationResultDestinationPerDayReportingLimitReached:
		*t = AttributionReportingSourceRegistrationResultDestinationPerDayReportingLimitReached

	default:
		in.AddError(fmt.Errorf("unknown AttributionReportingSourceRegistrationResult value: %v", v))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *AttributionReportingSourceRegistrationResult) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}

// AttributionReportingSourceRegistrationTimeConfig [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#type-AttributionReportingSourceRegistrationTimeConfig
type AttributionReportingSourceRegistrationTimeConfig string

// String returns the AttributionReportingSourceRegistrationTimeConfig as string value.
func (t AttributionReportingSourceRegistrationTimeConfig) String() string {
	return string(t)
}

// AttributionReportingSourceRegistrationTimeConfig values.
const (
	AttributionReportingSourceRegistrationTimeConfigInclude AttributionReportingSourceRegistrationTimeConfig = "include"
	AttributionReportingSourceRegistrationTimeConfigExclude AttributionReportingSourceRegistrationTimeConfig = "exclude"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t AttributionReportingSourceRegistrationTimeConfig) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t AttributionReportingSourceRegistrationTimeConfig) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *AttributionReportingSourceRegistrationTimeConfig) UnmarshalEasyJSON(in *jlexer.Lexer) {
	v := in.String()
	switch AttributionReportingSourceRegistrationTimeConfig(v) {
	case AttributionReportingSourceRegistrationTimeConfigInclude:
		*t = AttributionReportingSourceRegistrationTimeConfigInclude
	case AttributionReportingSourceRegistrationTimeConfigExclude:
		*t = AttributionReportingSourceRegistrationTimeConfigExclude

	default:
		in.AddError(fmt.Errorf("unknown AttributionReportingSourceRegistrationTimeConfig value: %v", v))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *AttributionReportingSourceRegistrationTimeConfig) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}

// AttributionReportingAggregatableValueDictEntry [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#type-AttributionReportingAggregatableValueDictEntry
type AttributionReportingAggregatableValueDictEntry struct {
	Key         string                `json:"key"`
	Value       float64               `json:"value"` // number instead of integer because not all uint32 can be represented by int
	FilteringID UnsignedInt64asBase10 `json:"filteringId"`
}

// AttributionReportingAggregatableValueEntry [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#type-AttributionReportingAggregatableValueEntry
type AttributionReportingAggregatableValueEntry struct {
	Values  []*AttributionReportingAggregatableValueDictEntry `json:"values"`
	Filters *AttributionReportingFilterPair                   `json:"filters"`
}

// AttributionReportingEventTriggerData [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#type-AttributionReportingEventTriggerData
type AttributionReportingEventTriggerData struct {
	Data     UnsignedInt64asBase10           `json:"data"`
	Priority SignedInt64asBase10             `json:"priority"`
	DedupKey UnsignedInt64asBase10           `json:"dedupKey,omitempty"`
	Filters  *AttributionReportingFilterPair `json:"filters"`
}

// AttributionReportingAggregatableTriggerData [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#type-AttributionReportingAggregatableTriggerData
type AttributionReportingAggregatableTriggerData struct {
	KeyPiece   UnsignedInt128asBase16          `json:"keyPiece"`
	SourceKeys []string                        `json:"sourceKeys"`
	Filters    *AttributionReportingFilterPair `json:"filters"`
}

// AttributionReportingAggregatableDedupKey [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#type-AttributionReportingAggregatableDedupKey
type AttributionReportingAggregatableDedupKey struct {
	DedupKey UnsignedInt64asBase10           `json:"dedupKey,omitempty"`
	Filters  *AttributionReportingFilterPair `json:"filters"`
}

// AttributionReportingTriggerRegistration [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#type-AttributionReportingTriggerRegistration
type AttributionReportingTriggerRegistration struct {
	Filters                          *AttributionReportingFilterPair                       `json:"filters"`
	DebugKey                         UnsignedInt64asBase10                                 `json:"debugKey,omitempty"`
	AggregatableDedupKeys            []*AttributionReportingAggregatableDedupKey           `json:"aggregatableDedupKeys"`
	EventTriggerData                 []*AttributionReportingEventTriggerData               `json:"eventTriggerData"`
	AggregatableTriggerData          []*AttributionReportingAggregatableTriggerData        `json:"aggregatableTriggerData"`
	AggregatableValues               []*AttributionReportingAggregatableValueEntry         `json:"aggregatableValues"`
	AggregatableFilteringIDMaxBytes  int64                                                 `json:"aggregatableFilteringIdMaxBytes"`
	DebugReporting                   bool                                                  `json:"debugReporting"`
	AggregationCoordinatorOrigin     string                                                `json:"aggregationCoordinatorOrigin,omitempty"`
	SourceRegistrationTimeConfig     AttributionReportingSourceRegistrationTimeConfig      `json:"sourceRegistrationTimeConfig"`
	TriggerContextID                 string                                                `json:"triggerContextId,omitempty"`
	AggregatableDebugReportingConfig *AttributionReportingAggregatableDebugReportingConfig `json:"aggregatableDebugReportingConfig"`
	Scopes                           []string                                              `json:"scopes"`
}

// AttributionReportingEventLevelResult [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#type-AttributionReportingEventLevelResult
type AttributionReportingEventLevelResult string

// String returns the AttributionReportingEventLevelResult as string value.
func (t AttributionReportingEventLevelResult) String() string {
	return string(t)
}

// AttributionReportingEventLevelResult values.
const (
	AttributionReportingEventLevelResultSuccess                             AttributionReportingEventLevelResult = "success"
	AttributionReportingEventLevelResultSuccessDroppedLowerPriority         AttributionReportingEventLevelResult = "successDroppedLowerPriority"
	AttributionReportingEventLevelResultInternalError                       AttributionReportingEventLevelResult = "internalError"
	AttributionReportingEventLevelResultNoCapacityForAttributionDestination AttributionReportingEventLevelResult = "noCapacityForAttributionDestination"
	AttributionReportingEventLevelResultNoMatchingSources                   AttributionReportingEventLevelResult = "noMatchingSources"
	AttributionReportingEventLevelResultDeduplicated                        AttributionReportingEventLevelResult = "deduplicated"
	AttributionReportingEventLevelResultExcessiveAttributions               AttributionReportingEventLevelResult = "excessiveAttributions"
	AttributionReportingEventLevelResultPriorityTooLow                      AttributionReportingEventLevelResult = "priorityTooLow"
	AttributionReportingEventLevelResultNeverAttributedSource               AttributionReportingEventLevelResult = "neverAttributedSource"
	AttributionReportingEventLevelResultExcessiveReportingOrigins           AttributionReportingEventLevelResult = "excessiveReportingOrigins"
	AttributionReportingEventLevelResultNoMatchingSourceFilterData          AttributionReportingEventLevelResult = "noMatchingSourceFilterData"
	AttributionReportingEventLevelResultProhibitedByBrowserPolicy           AttributionReportingEventLevelResult = "prohibitedByBrowserPolicy"
	AttributionReportingEventLevelResultNoMatchingConfigurations            AttributionReportingEventLevelResult = "noMatchingConfigurations"
	AttributionReportingEventLevelResultExcessiveReports                    AttributionReportingEventLevelResult = "excessiveReports"
	AttributionReportingEventLevelResultFalselyAttributedSource             AttributionReportingEventLevelResult = "falselyAttributedSource"
	AttributionReportingEventLevelResultReportWindowPassed                  AttributionReportingEventLevelResult = "reportWindowPassed"
	AttributionReportingEventLevelResultNotRegistered                       AttributionReportingEventLevelResult = "notRegistered"
	AttributionReportingEventLevelResultReportWindowNotStarted              AttributionReportingEventLevelResult = "reportWindowNotStarted"
	AttributionReportingEventLevelResultNoMatchingTriggerData               AttributionReportingEventLevelResult = "noMatchingTriggerData"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t AttributionReportingEventLevelResult) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t AttributionReportingEventLevelResult) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *AttributionReportingEventLevelResult) UnmarshalEasyJSON(in *jlexer.Lexer) {
	v := in.String()
	switch AttributionReportingEventLevelResult(v) {
	case AttributionReportingEventLevelResultSuccess:
		*t = AttributionReportingEventLevelResultSuccess
	case AttributionReportingEventLevelResultSuccessDroppedLowerPriority:
		*t = AttributionReportingEventLevelResultSuccessDroppedLowerPriority
	case AttributionReportingEventLevelResultInternalError:
		*t = AttributionReportingEventLevelResultInternalError
	case AttributionReportingEventLevelResultNoCapacityForAttributionDestination:
		*t = AttributionReportingEventLevelResultNoCapacityForAttributionDestination
	case AttributionReportingEventLevelResultNoMatchingSources:
		*t = AttributionReportingEventLevelResultNoMatchingSources
	case AttributionReportingEventLevelResultDeduplicated:
		*t = AttributionReportingEventLevelResultDeduplicated
	case AttributionReportingEventLevelResultExcessiveAttributions:
		*t = AttributionReportingEventLevelResultExcessiveAttributions
	case AttributionReportingEventLevelResultPriorityTooLow:
		*t = AttributionReportingEventLevelResultPriorityTooLow
	case AttributionReportingEventLevelResultNeverAttributedSource:
		*t = AttributionReportingEventLevelResultNeverAttributedSource
	case AttributionReportingEventLevelResultExcessiveReportingOrigins:
		*t = AttributionReportingEventLevelResultExcessiveReportingOrigins
	case AttributionReportingEventLevelResultNoMatchingSourceFilterData:
		*t = AttributionReportingEventLevelResultNoMatchingSourceFilterData
	case AttributionReportingEventLevelResultProhibitedByBrowserPolicy:
		*t = AttributionReportingEventLevelResultProhibitedByBrowserPolicy
	case AttributionReportingEventLevelResultNoMatchingConfigurations:
		*t = AttributionReportingEventLevelResultNoMatchingConfigurations
	case AttributionReportingEventLevelResultExcessiveReports:
		*t = AttributionReportingEventLevelResultExcessiveReports
	case AttributionReportingEventLevelResultFalselyAttributedSource:
		*t = AttributionReportingEventLevelResultFalselyAttributedSource
	case AttributionReportingEventLevelResultReportWindowPassed:
		*t = AttributionReportingEventLevelResultReportWindowPassed
	case AttributionReportingEventLevelResultNotRegistered:
		*t = AttributionReportingEventLevelResultNotRegistered
	case AttributionReportingEventLevelResultReportWindowNotStarted:
		*t = AttributionReportingEventLevelResultReportWindowNotStarted
	case AttributionReportingEventLevelResultNoMatchingTriggerData:
		*t = AttributionReportingEventLevelResultNoMatchingTriggerData

	default:
		in.AddError(fmt.Errorf("unknown AttributionReportingEventLevelResult value: %v", v))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *AttributionReportingEventLevelResult) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}

// AttributionReportingAggregatableResult [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#type-AttributionReportingAggregatableResult
type AttributionReportingAggregatableResult string

// String returns the AttributionReportingAggregatableResult as string value.
func (t AttributionReportingAggregatableResult) String() string {
	return string(t)
}

// AttributionReportingAggregatableResult values.
const (
	AttributionReportingAggregatableResultSuccess                             AttributionReportingAggregatableResult = "success"
	AttributionReportingAggregatableResultInternalError                       AttributionReportingAggregatableResult = "internalError"
	AttributionReportingAggregatableResultNoCapacityForAttributionDestination AttributionReportingAggregatableResult = "noCapacityForAttributionDestination"
	AttributionReportingAggregatableResultNoMatchingSources                   AttributionReportingAggregatableResult = "noMatchingSources"
	AttributionReportingAggregatableResultExcessiveAttributions               AttributionReportingAggregatableResult = "excessiveAttributions"
	AttributionReportingAggregatableResultExcessiveReportingOrigins           AttributionReportingAggregatableResult = "excessiveReportingOrigins"
	AttributionReportingAggregatableResultNoHistograms                        AttributionReportingAggregatableResult = "noHistograms"
	AttributionReportingAggregatableResultInsufficientBudget                  AttributionReportingAggregatableResult = "insufficientBudget"
	AttributionReportingAggregatableResultNoMatchingSourceFilterData          AttributionReportingAggregatableResult = "noMatchingSourceFilterData"
	AttributionReportingAggregatableResultNotRegistered                       AttributionReportingAggregatableResult = "notRegistered"
	AttributionReportingAggregatableResultProhibitedByBrowserPolicy           AttributionReportingAggregatableResult = "prohibitedByBrowserPolicy"
	AttributionReportingAggregatableResultDeduplicated                        AttributionReportingAggregatableResult = "deduplicated"
	AttributionReportingAggregatableResultReportWindowPassed                  AttributionReportingAggregatableResult = "reportWindowPassed"
	AttributionReportingAggregatableResultExcessiveReports                    AttributionReportingAggregatableResult = "excessiveReports"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t AttributionReportingAggregatableResult) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t AttributionReportingAggregatableResult) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *AttributionReportingAggregatableResult) UnmarshalEasyJSON(in *jlexer.Lexer) {
	v := in.String()
	switch AttributionReportingAggregatableResult(v) {
	case AttributionReportingAggregatableResultSuccess:
		*t = AttributionReportingAggregatableResultSuccess
	case AttributionReportingAggregatableResultInternalError:
		*t = AttributionReportingAggregatableResultInternalError
	case AttributionReportingAggregatableResultNoCapacityForAttributionDestination:
		*t = AttributionReportingAggregatableResultNoCapacityForAttributionDestination
	case AttributionReportingAggregatableResultNoMatchingSources:
		*t = AttributionReportingAggregatableResultNoMatchingSources
	case AttributionReportingAggregatableResultExcessiveAttributions:
		*t = AttributionReportingAggregatableResultExcessiveAttributions
	case AttributionReportingAggregatableResultExcessiveReportingOrigins:
		*t = AttributionReportingAggregatableResultExcessiveReportingOrigins
	case AttributionReportingAggregatableResultNoHistograms:
		*t = AttributionReportingAggregatableResultNoHistograms
	case AttributionReportingAggregatableResultInsufficientBudget:
		*t = AttributionReportingAggregatableResultInsufficientBudget
	case AttributionReportingAggregatableResultNoMatchingSourceFilterData:
		*t = AttributionReportingAggregatableResultNoMatchingSourceFilterData
	case AttributionReportingAggregatableResultNotRegistered:
		*t = AttributionReportingAggregatableResultNotRegistered
	case AttributionReportingAggregatableResultProhibitedByBrowserPolicy:
		*t = AttributionReportingAggregatableResultProhibitedByBrowserPolicy
	case AttributionReportingAggregatableResultDeduplicated:
		*t = AttributionReportingAggregatableResultDeduplicated
	case AttributionReportingAggregatableResultReportWindowPassed:
		*t = AttributionReportingAggregatableResultReportWindowPassed
	case AttributionReportingAggregatableResultExcessiveReports:
		*t = AttributionReportingAggregatableResultExcessiveReports

	default:
		in.AddError(fmt.Errorf("unknown AttributionReportingAggregatableResult value: %v", v))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *AttributionReportingAggregatableResult) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}

// RelatedWebsiteSet a single Related Website Set object.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#type-RelatedWebsiteSet
type RelatedWebsiteSet struct {
	PrimarySites    []string `json:"primarySites"`    // The primary site of this set, along with the ccTLDs if there is any.
	AssociatedSites []string `json:"associatedSites"` // The associated sites of this set, along with the ccTLDs if there is any.
	ServiceSites    []string `json:"serviceSites"`    // The service sites of this set, along with the ccTLDs if there is any.
}
