/*
 * Decompiled with CFR 0.152.
 */
package io.bazel.worker;

import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import src.main.kotlin.io.bazel.worker.GcScheduler;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\n\u001a\u00020\u000bH\u0016R\u0014\u0010\u0005\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lio/bazel/worker/CpuTimeBasedGcScheduler;", "Lsrc/main/kotlin/io/bazel/worker/GcScheduler;", "cpuUsageBeforeGc", "Ljava/time/Duration;", "(Ljava/time/Duration;)V", "cpuTime", "getCpuTime", "()Ljava/time/Duration;", "cpuTimeAtLastGc", "Ljava/util/concurrent/atomic/AtomicReference;", "maybePerformGc", "", "Companion", "src_main_kotlin_io_bazel_worker-worker"})
public final class CpuTimeBasedGcScheduler
implements GcScheduler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Duration cpuUsageBeforeGc;
    @NotNull
    private final AtomicReference<Duration> cpuTimeAtLastGc;
    @NotNull
    private static final OperatingSystemMXBean bean;

    public CpuTimeBasedGcScheduler(@NotNull Duration cpuUsageBeforeGc) {
        Intrinsics.checkNotNullParameter(cpuUsageBeforeGc, "cpuUsageBeforeGc");
        this.cpuUsageBeforeGc = cpuUsageBeforeGc;
        this.cpuTimeAtLastGc = new AtomicReference<Duration>(this.getCpuTime());
    }

    private final Duration getCpuTime() {
        Duration duration;
        if (this.cpuUsageBeforeGc.isZero()) {
            Duration duration2 = Duration.ZERO;
            duration = duration2;
            Intrinsics.checkNotNullExpressionValue(duration2, "ZERO");
        } else {
            Duration duration3 = Duration.ofNanos(bean.getProcessCpuTime());
            duration = duration3;
            Intrinsics.checkNotNullExpressionValue(duration3, "ofNanos(bean.processCpuTime)");
        }
        return duration;
    }

    @Override
    public void maybePerformGc() {
        Duration lastCpuTime;
        Duration currentCpuTime;
        if (!this.cpuUsageBeforeGc.isZero() && (currentCpuTime = this.getCpuTime()).minus(lastCpuTime = this.cpuTimeAtLastGc.get()).compareTo(this.cpuUsageBeforeGc) > 0 && this.cpuTimeAtLastGc.compareAndSet(lastCpuTime, currentCpuTime)) {
            System.gc();
            this.cpuTimeAtLastGc.compareAndSet(currentCpuTime, this.getCpuTime());
        }
    }

    static {
        java.lang.management.OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
        Intrinsics.checkNotNull(operatingSystemMXBean, "null cannot be cast to non-null type com.sun.management.OperatingSystemMXBean");
        bean = (OperatingSystemMXBean)operatingSystemMXBean;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/bazel/worker/CpuTimeBasedGcScheduler$Companion;", "", "()V", "bean", "Lcom/sun/management/OperatingSystemMXBean;", "src_main_kotlin_io_bazel_worker-worker"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

