/*========================== begin_copyright_notice ============================

Copyright (C) 2024 Intel Corporation

SPDX-License-Identifier: MIT

============================= end_copyright_notice ===========================*/
/*
// ALGORITHM DESCRIPTION:
//
//      HIGH LEVEL OVERVIEW
//
//      Calculate z = (x*x+y*y)
//      Calculate reciplicle sqrt (z)
//      Calculate error = z*(rsqrt(z)*rsqrt(z)) - 1
//      Calculate fixing part p with polynom
//      Fix answer with sqrt(z) = z * rsqrt(z) + error * p * z
//
//      ALGORITHM DETAILS
//
//    Multiprecision branch for _HA_ only
//      Remove sigm from both arguments
//      Find maximum (_x) and minimum (_y) (by abs value) between arguments
//      Split _x int _a and _b for multiprecision
//      If _x >> _y we will we will not split _y for multiprecision
//      all _y will be put into lower part (_d) and higher part (_c = 0)
//      Fixing _hilo_mask for the case _x >> _y
//      Split _y into _c and _d for multiprecision with fixed mask
//
//      compute Hi and Lo parts of _z = _x*_x + _y*_y
//
//      _zHi = _a*_a + _c*_c
//      _zLo = (_x + _a)*_b + _d*_y + _d*_c
//      _z = _zHi + _zLo
//
//    No multiprecision branch for _LA_ and _EP_
//      _z = _VARG1 * _VARG1 + _VARG2 * _VARG2
//
//    Check _z exponent to be withing borders [3BC ; 441] else goto Callout
//
//    _s  ~ 1.0/sqrt(_z)
//    _s2 ~ 1.0/(sqrt(_z)*sqrt(_z)) ~ 1.0/_z = (1.0/_z + O)
//    _e[rror]  =  (1.0/_z + O) * _z - 1.0
//    calculate fixing part _p
//    _p = (((_POLY_C5*_e + _POLY_C4)*_e +_POLY_C3)*_e +_POLY_C2)*_e + _POLY_C1
//    some parts of polynom are skipped for lower flav
//
//    result = _z * (1.0/sqrt(_z) + O) + _p * _e[rror] * _z
//
// --
//
*/
#include "../imf.h"
#pragma OPENCL FP_CONTRACT OFF
typedef struct {
  unsigned long _dHiLoMask;
  unsigned long _dAbsMask;
  unsigned long _dOne;
  unsigned long _POLY_C5;
  unsigned long _POLY_C4;
  unsigned long _POLY_C3;
  unsigned long _POLY_C2;
  unsigned long _POLY_C1;
  unsigned int _LargeDiffMask;
  unsigned int _LowBoundary;
  unsigned int _HighBoundary;
  unsigned long _lExpBound_uisa;
  unsigned long _lExpBound;
  unsigned long _dHalf;
} __ocl_svml_internal_dhypot_la_data_t;
static __ocl_svml_internal_dhypot_la_data_t __ocl_svml_internal_dhypot_la_data =
    {
        /* legacy algorithm */
        0xffffc00000000000uL, /* _dHiLoMask     */
        0x7fffffffffffffffuL, /* _dAbsMask      */
        0x3FF0000000000000uL, /* _dOne          */
        0xBFCF800000000000uL, /* _POLY_C5            */
        0x3FD1800000000000uL, /* _POLY_C4            */
        0xBFD4000000000000uL, /* _POLY_C3            */
        0x3FD8000000000000uL, /* _POLY_C2            */
        0xBFE0000000000000uL, /* _POLY_C1            */
        0x00600000u,          /* _LargeDiffMask */
        0x3BC00000u,          /* _LowBoundary   */
        0x44100000u,          /* _HighBoundary  */
        /* fma based algorithm*/
        0x407ff00000000000uL, /* _lExpBound_uisa */
        0x404f800000000000uL, /* _lExpBound      */
        0x3FE0000000000000uL, /* _dHalf          */
};                            /* _VAPI_DATA_TYPE */
static __constant _iml_v2_dp_union_t __dhypot_la__vmldHypotHATab[517] = {
    0x00000000, 0x3FF00000, /* RSQRT[  0] = +1.0000000000000000e+00 */
    0x00000000, 0x3FEFF000, /* RSQRT[  1] = +9.9804687500000000e-01 */
    0x00000000, 0x3FEFE000, /* RSQRT[  2] = +9.9609375000000000e-01 */
    0x00000000, 0x3FEFD000, /* RSQRT[  3] = +9.9414062500000000e-01 */
    0x00000000, 0x3FEFC000, /* RSQRT[  4] = +9.9218750000000000e-01 */
    0x00000000, 0x3FEFB000, /* RSQRT[  5] = +9.9023437500000000e-01 */
    0x00000000, 0x3FEFA000, /* RSQRT[  6] = +9.8828125000000000e-01 */
    0x00000000, 0x3FEF9400, /* RSQRT[  7] = +9.8681640625000000e-01 */
    0x00000000, 0x3FEF8400, /* RSQRT[  8] = +9.8486328125000000e-01 */
    0x00000000, 0x3FEF7400, /* RSQRT[  9] = +9.8291015625000000e-01 */
    0x00000000, 0x3FEF6400, /* RSQRT[ 10] = +9.8095703125000000e-01 */
    0x00000000, 0x3FEF5400, /* RSQRT[ 11] = +9.7900390625000000e-01 */
    0x00000000, 0x3FEF4800, /* RSQRT[ 12] = +9.7753906250000000e-01 */
    0x00000000, 0x3FEF3800, /* RSQRT[ 13] = +9.7558593750000000e-01 */
    0x00000000, 0x3FEF2800, /* RSQRT[ 14] = +9.7363281250000000e-01 */
    0x00000000, 0x3FEF1C00, /* RSQRT[ 15] = +9.7216796875000000e-01 */
    0x00000000, 0x3FEF0C00, /* RSQRT[ 16] = +9.7021484375000000e-01 */
    0x00000000, 0x3FEEFC00, /* RSQRT[ 17] = +9.6826171875000000e-01 */
    0x00000000, 0x3FEEF000, /* RSQRT[ 18] = +9.6679687500000000e-01 */
    0x00000000, 0x3FEEE000, /* RSQRT[ 19] = +9.6484375000000000e-01 */
    0x00000000, 0x3FEED000, /* RSQRT[ 20] = +9.6289062500000000e-01 */
    0x00000000, 0x3FEEC400, /* RSQRT[ 21] = +9.6142578125000000e-01 */
    0x00000000, 0x3FEEB400, /* RSQRT[ 22] = +9.5947265625000000e-01 */
    0x00000000, 0x3FEEA800, /* RSQRT[ 23] = +9.5800781250000000e-01 */
    0x00000000, 0x3FEE9800, /* RSQRT[ 24] = +9.5605468750000000e-01 */
    0x00000000, 0x3FEE8C00, /* RSQRT[ 25] = +9.5458984375000000e-01 */
    0x00000000, 0x3FEE7C00, /* RSQRT[ 26] = +9.5263671875000000e-01 */
    0x00000000, 0x3FEE7000, /* RSQRT[ 27] = +9.5117187500000000e-01 */
    0x00000000, 0x3FEE6000, /* RSQRT[ 28] = +9.4921875000000000e-01 */
    0x00000000, 0x3FEE5400, /* RSQRT[ 29] = +9.4775390625000000e-01 */
    0x00000000, 0x3FEE4800, /* RSQRT[ 30] = +9.4628906250000000e-01 */
    0x00000000, 0x3FEE3800, /* RSQRT[ 31] = +9.4433593750000000e-01 */
    0x00000000, 0x3FEE2C00, /* RSQRT[ 32] = +9.4287109375000000e-01 */
    0x00000000, 0x3FEE2000, /* RSQRT[ 33] = +9.4140625000000000e-01 */
    0x00000000, 0x3FEE1000, /* RSQRT[ 34] = +9.3945312500000000e-01 */
    0x00000000, 0x3FEE0400, /* RSQRT[ 35] = +9.3798828125000000e-01 */
    0x00000000, 0x3FEDF800, /* RSQRT[ 36] = +9.3652343750000000e-01 */
    0x00000000, 0x3FEDE800, /* RSQRT[ 37] = +9.3457031250000000e-01 */
    0x00000000, 0x3FEDDC00, /* RSQRT[ 38] = +9.3310546875000000e-01 */
    0x00000000, 0x3FEDD000, /* RSQRT[ 39] = +9.3164062500000000e-01 */
    0x00000000, 0x3FEDC400, /* RSQRT[ 40] = +9.3017578125000000e-01 */
    0x00000000, 0x3FEDB400, /* RSQRT[ 41] = +9.2822265625000000e-01 */
    0x00000000, 0x3FEDA800, /* RSQRT[ 42] = +9.2675781250000000e-01 */
    0x00000000, 0x3FED9C00, /* RSQRT[ 43] = +9.2529296875000000e-01 */
    0x00000000, 0x3FED9000, /* RSQRT[ 44] = +9.2382812500000000e-01 */
    0x00000000, 0x3FED8400, /* RSQRT[ 45] = +9.2236328125000000e-01 */
    0x00000000, 0x3FED7800, /* RSQRT[ 46] = +9.2089843750000000e-01 */
    0x00000000, 0x3FED6800, /* RSQRT[ 47] = +9.1894531250000000e-01 */
    0x00000000, 0x3FED5C00, /* RSQRT[ 48] = +9.1748046875000000e-01 */
    0x00000000, 0x3FED5000, /* RSQRT[ 49] = +9.1601562500000000e-01 */
    0x00000000, 0x3FED4400, /* RSQRT[ 50] = +9.1455078125000000e-01 */
    0x00000000, 0x3FED3800, /* RSQRT[ 51] = +9.1308593750000000e-01 */
    0x00000000, 0x3FED2C00, /* RSQRT[ 52] = +9.1162109375000000e-01 */
    0x00000000, 0x3FED2000, /* RSQRT[ 53] = +9.1015625000000000e-01 */
    0x00000000, 0x3FED1400, /* RSQRT[ 54] = +9.0869140625000000e-01 */
    0x00000000, 0x3FED0800, /* RSQRT[ 55] = +9.0722656250000000e-01 */
    0x00000000, 0x3FECFC00, /* RSQRT[ 56] = +9.0576171875000000e-01 */
    0x00000000, 0x3FECF000, /* RSQRT[ 57] = +9.0429687500000000e-01 */
    0x00000000, 0x3FECE400, /* RSQRT[ 58] = +9.0283203125000000e-01 */
    0x00000000, 0x3FECD800, /* RSQRT[ 59] = +9.0136718750000000e-01 */
    0x00000000, 0x3FECCC00, /* RSQRT[ 60] = +8.9990234375000000e-01 */
    0x00000000, 0x3FECC000, /* RSQRT[ 61] = +8.9843750000000000e-01 */
    0x00000000, 0x3FECB800, /* RSQRT[ 62] = +8.9746093750000000e-01 */
    0x00000000, 0x3FECAC00, /* RSQRT[ 63] = +8.9599609375000000e-01 */
    0x00000000, 0x3FECA000, /* RSQRT[ 64] = +8.9453125000000000e-01 */
    0x00000000, 0x3FEC9400, /* RSQRT[ 65] = +8.9306640625000000e-01 */
    0x00000000, 0x3FEC8800, /* RSQRT[ 66] = +8.9160156250000000e-01 */
    0x00000000, 0x3FEC7C00, /* RSQRT[ 67] = +8.9013671875000000e-01 */
    0x00000000, 0x3FEC7000, /* RSQRT[ 68] = +8.8867187500000000e-01 */
    0x00000000, 0x3FEC6800, /* RSQRT[ 69] = +8.8769531250000000e-01 */
    0x00000000, 0x3FEC5C00, /* RSQRT[ 70] = +8.8623046875000000e-01 */
    0x00000000, 0x3FEC5000, /* RSQRT[ 71] = +8.8476562500000000e-01 */
    0x00000000, 0x3FEC4400, /* RSQRT[ 72] = +8.8330078125000000e-01 */
    0x00000000, 0x3FEC3C00, /* RSQRT[ 73] = +8.8232421875000000e-01 */
    0x00000000, 0x3FEC3000, /* RSQRT[ 74] = +8.8085937500000000e-01 */
    0x00000000, 0x3FEC2400, /* RSQRT[ 75] = +8.7939453125000000e-01 */
    0x00000000, 0x3FEC1800, /* RSQRT[ 76] = +8.7792968750000000e-01 */
    0x00000000, 0x3FEC1000, /* RSQRT[ 77] = +8.7695312500000000e-01 */
    0x00000000, 0x3FEC0400, /* RSQRT[ 78] = +8.7548828125000000e-01 */
    0x00000000, 0x3FEBF800, /* RSQRT[ 79] = +8.7402343750000000e-01 */
    0x00000000, 0x3FEBF000, /* RSQRT[ 80] = +8.7304687500000000e-01 */
    0x00000000, 0x3FEBE400, /* RSQRT[ 81] = +8.7158203125000000e-01 */
    0x00000000, 0x3FEBD800, /* RSQRT[ 82] = +8.7011718750000000e-01 */
    0x00000000, 0x3FEBD000, /* RSQRT[ 83] = +8.6914062500000000e-01 */
    0x00000000, 0x3FEBC400, /* RSQRT[ 84] = +8.6767578125000000e-01 */
    0x00000000, 0x3FEBB800, /* RSQRT[ 85] = +8.6621093750000000e-01 */
    0x00000000, 0x3FEBB000, /* RSQRT[ 86] = +8.6523437500000000e-01 */
    0x00000000, 0x3FEBA400, /* RSQRT[ 87] = +8.6376953125000000e-01 */
    0x00000000, 0x3FEB9C00, /* RSQRT[ 88] = +8.6279296875000000e-01 */
    0x00000000, 0x3FEB9000, /* RSQRT[ 89] = +8.6132812500000000e-01 */
    0x00000000, 0x3FEB8800, /* RSQRT[ 90] = +8.6035156250000000e-01 */
    0x00000000, 0x3FEB7C00, /* RSQRT[ 91] = +8.5888671875000000e-01 */
    0x00000000, 0x3FEB7400, /* RSQRT[ 92] = +8.5791015625000000e-01 */
    0x00000000, 0x3FEB6800, /* RSQRT[ 93] = +8.5644531250000000e-01 */
    0x00000000, 0x3FEB6000, /* RSQRT[ 94] = +8.5546875000000000e-01 */
    0x00000000, 0x3FEB5400, /* RSQRT[ 95] = +8.5400390625000000e-01 */
    0x00000000, 0x3FEB4C00, /* RSQRT[ 96] = +8.5302734375000000e-01 */
    0x00000000, 0x3FEB4000, /* RSQRT[ 97] = +8.5156250000000000e-01 */
    0x00000000, 0x3FEB3800, /* RSQRT[ 98] = +8.5058593750000000e-01 */
    0x00000000, 0x3FEB2C00, /* RSQRT[ 99] = +8.4912109375000000e-01 */
    0x00000000, 0x3FEB2400, /* RSQRT[100] = +8.4814453125000000e-01 */
    0x00000000, 0x3FEB1800, /* RSQRT[101] = +8.4667968750000000e-01 */
    0x00000000, 0x3FEB1000, /* RSQRT[102] = +8.4570312500000000e-01 */
    0x00000000, 0x3FEB0400, /* RSQRT[103] = +8.4423828125000000e-01 */
    0x00000000, 0x3FEAFC00, /* RSQRT[104] = +8.4326171875000000e-01 */
    0x00000000, 0x3FEAF400, /* RSQRT[105] = +8.4228515625000000e-01 */
    0x00000000, 0x3FEAE800, /* RSQRT[106] = +8.4082031250000000e-01 */
    0x00000000, 0x3FEAE000, /* RSQRT[107] = +8.3984375000000000e-01 */
    0x00000000, 0x3FEAD800, /* RSQRT[108] = +8.3886718750000000e-01 */
    0x00000000, 0x3FEACC00, /* RSQRT[109] = +8.3740234375000000e-01 */
    0x00000000, 0x3FEAC400, /* RSQRT[110] = +8.3642578125000000e-01 */
    0x00000000, 0x3FEAB800, /* RSQRT[111] = +8.3496093750000000e-01 */
    0x00000000, 0x3FEAB000, /* RSQRT[112] = +8.3398437500000000e-01 */
    0x00000000, 0x3FEAA800, /* RSQRT[113] = +8.3300781250000000e-01 */
    0x00000000, 0x3FEAA000, /* RSQRT[114] = +8.3203125000000000e-01 */
    0x00000000, 0x3FEA9400, /* RSQRT[115] = +8.3056640625000000e-01 */
    0x00000000, 0x3FEA8C00, /* RSQRT[116] = +8.2958984375000000e-01 */
    0x00000000, 0x3FEA8400, /* RSQRT[117] = +8.2861328125000000e-01 */
    0x00000000, 0x3FEA7800, /* RSQRT[118] = +8.2714843750000000e-01 */
    0x00000000, 0x3FEA7000, /* RSQRT[119] = +8.2617187500000000e-01 */
    0x00000000, 0x3FEA6800, /* RSQRT[120] = +8.2519531250000000e-01 */
    0x00000000, 0x3FEA6000, /* RSQRT[121] = +8.2421875000000000e-01 */
    0x00000000, 0x3FEA5400, /* RSQRT[122] = +8.2275390625000000e-01 */
    0x00000000, 0x3FEA4C00, /* RSQRT[123] = +8.2177734375000000e-01 */
    0x00000000, 0x3FEA4400, /* RSQRT[124] = +8.2080078125000000e-01 */
    0x00000000, 0x3FEA3C00, /* RSQRT[125] = +8.1982421875000000e-01 */
    0x00000000, 0x3FEA3400, /* RSQRT[126] = +8.1884765625000000e-01 */
    0x00000000, 0x3FEA2800, /* RSQRT[127] = +8.1738281250000000e-01 */
    0x00000000, 0x3FEA2000, /* RSQRT[128] = +8.1640625000000000e-01 */
    0x00000000, 0x3FEA1800, /* RSQRT[129] = +8.1542968750000000e-01 */
    0x00000000, 0x3FEA1000, /* RSQRT[130] = +8.1445312500000000e-01 */
    0x00000000, 0x3FEA0800, /* RSQRT[131] = +8.1347656250000000e-01 */
    0x00000000, 0x3FEA0000, /* RSQRT[132] = +8.1250000000000000e-01 */
    0x00000000, 0x3FE9F400, /* RSQRT[133] = +8.1103515625000000e-01 */
    0x00000000, 0x3FE9EC00, /* RSQRT[134] = +8.1005859375000000e-01 */
    0x00000000, 0x3FE9E400, /* RSQRT[135] = +8.0908203125000000e-01 */
    0x00000000, 0x3FE9DC00, /* RSQRT[136] = +8.0810546875000000e-01 */
    0x00000000, 0x3FE9D400, /* RSQRT[137] = +8.0712890625000000e-01 */
    0x00000000, 0x3FE9CC00, /* RSQRT[138] = +8.0615234375000000e-01 */
    0x00000000, 0x3FE9C400, /* RSQRT[139] = +8.0517578125000000e-01 */
    0x00000000, 0x3FE9BC00, /* RSQRT[140] = +8.0419921875000000e-01 */
    0x00000000, 0x3FE9B400, /* RSQRT[141] = +8.0322265625000000e-01 */
    0x00000000, 0x3FE9AC00, /* RSQRT[142] = +8.0224609375000000e-01 */
    0x00000000, 0x3FE9A000, /* RSQRT[143] = +8.0078125000000000e-01 */
    0x00000000, 0x3FE99800, /* RSQRT[144] = +7.9980468750000000e-01 */
    0x00000000, 0x3FE99000, /* RSQRT[145] = +7.9882812500000000e-01 */
    0x00000000, 0x3FE98800, /* RSQRT[146] = +7.9785156250000000e-01 */
    0x00000000, 0x3FE98000, /* RSQRT[147] = +7.9687500000000000e-01 */
    0x00000000, 0x3FE97800, /* RSQRT[148] = +7.9589843750000000e-01 */
    0x00000000, 0x3FE97000, /* RSQRT[149] = +7.9492187500000000e-01 */
    0x00000000, 0x3FE96800, /* RSQRT[150] = +7.9394531250000000e-01 */
    0x00000000, 0x3FE96000, /* RSQRT[151] = +7.9296875000000000e-01 */
    0x00000000, 0x3FE95800, /* RSQRT[152] = +7.9199218750000000e-01 */
    0x00000000, 0x3FE95000, /* RSQRT[153] = +7.9101562500000000e-01 */
    0x00000000, 0x3FE94800, /* RSQRT[154] = +7.9003906250000000e-01 */
    0x00000000, 0x3FE94000, /* RSQRT[155] = +7.8906250000000000e-01 */
    0x00000000, 0x3FE93800, /* RSQRT[156] = +7.8808593750000000e-01 */
    0x00000000, 0x3FE93000, /* RSQRT[157] = +7.8710937500000000e-01 */
    0x00000000, 0x3FE92800, /* RSQRT[158] = +7.8613281250000000e-01 */
    0x00000000, 0x3FE92400, /* RSQRT[159] = +7.8564453125000000e-01 */
    0x00000000, 0x3FE91C00, /* RSQRT[160] = +7.8466796875000000e-01 */
    0x00000000, 0x3FE91400, /* RSQRT[161] = +7.8369140625000000e-01 */
    0x00000000, 0x3FE90C00, /* RSQRT[162] = +7.8271484375000000e-01 */
    0x00000000, 0x3FE90400, /* RSQRT[163] = +7.8173828125000000e-01 */
    0x00000000, 0x3FE8FC00, /* RSQRT[164] = +7.8076171875000000e-01 */
    0x00000000, 0x3FE8F400, /* RSQRT[165] = +7.7978515625000000e-01 */
    0x00000000, 0x3FE8EC00, /* RSQRT[166] = +7.7880859375000000e-01 */
    0x00000000, 0x3FE8E400, /* RSQRT[167] = +7.7783203125000000e-01 */
    0x00000000, 0x3FE8DC00, /* RSQRT[168] = +7.7685546875000000e-01 */
    0x00000000, 0x3FE8D400, /* RSQRT[169] = +7.7587890625000000e-01 */
    0x00000000, 0x3FE8D000, /* RSQRT[170] = +7.7539062500000000e-01 */
    0x00000000, 0x3FE8C800, /* RSQRT[171] = +7.7441406250000000e-01 */
    0x00000000, 0x3FE8C000, /* RSQRT[172] = +7.7343750000000000e-01 */
    0x00000000, 0x3FE8B800, /* RSQRT[173] = +7.7246093750000000e-01 */
    0x00000000, 0x3FE8B000, /* RSQRT[174] = +7.7148437500000000e-01 */
    0x00000000, 0x3FE8A800, /* RSQRT[175] = +7.7050781250000000e-01 */
    0x00000000, 0x3FE8A400, /* RSQRT[176] = +7.7001953125000000e-01 */
    0x00000000, 0x3FE89C00, /* RSQRT[177] = +7.6904296875000000e-01 */
    0x00000000, 0x3FE89400, /* RSQRT[178] = +7.6806640625000000e-01 */
    0x00000000, 0x3FE88C00, /* RSQRT[179] = +7.6708984375000000e-01 */
    0x00000000, 0x3FE88400, /* RSQRT[180] = +7.6611328125000000e-01 */
    0x00000000, 0x3FE88000, /* RSQRT[181] = +7.6562500000000000e-01 */
    0x00000000, 0x3FE87800, /* RSQRT[182] = +7.6464843750000000e-01 */
    0x00000000, 0x3FE87000, /* RSQRT[183] = +7.6367187500000000e-01 */
    0x00000000, 0x3FE86800, /* RSQRT[184] = +7.6269531250000000e-01 */
    0x00000000, 0x3FE86000, /* RSQRT[185] = +7.6171875000000000e-01 */
    0x00000000, 0x3FE85C00, /* RSQRT[186] = +7.6123046875000000e-01 */
    0x00000000, 0x3FE85400, /* RSQRT[187] = +7.6025390625000000e-01 */
    0x00000000, 0x3FE84C00, /* RSQRT[188] = +7.5927734375000000e-01 */
    0x00000000, 0x3FE84400, /* RSQRT[189] = +7.5830078125000000e-01 */
    0x00000000, 0x3FE84000, /* RSQRT[190] = +7.5781250000000000e-01 */
    0x00000000, 0x3FE83800, /* RSQRT[191] = +7.5683593750000000e-01 */
    0x00000000, 0x3FE83000, /* RSQRT[192] = +7.5585937500000000e-01 */
    0x00000000, 0x3FE82800, /* RSQRT[193] = +7.5488281250000000e-01 */
    0x00000000, 0x3FE82400, /* RSQRT[194] = +7.5439453125000000e-01 */
    0x00000000, 0x3FE81C00, /* RSQRT[195] = +7.5341796875000000e-01 */
    0x00000000, 0x3FE81400, /* RSQRT[196] = +7.5244140625000000e-01 */
    0x00000000, 0x3FE81000, /* RSQRT[197] = +7.5195312500000000e-01 */
    0x00000000, 0x3FE80800, /* RSQRT[198] = +7.5097656250000000e-01 */
    0x00000000, 0x3FE80000, /* RSQRT[199] = +7.5000000000000000e-01 */
    0x00000000, 0x3FE7FC00, /* RSQRT[200] = +7.4951171875000000e-01 */
    0x00000000, 0x3FE7F400, /* RSQRT[201] = +7.4853515625000000e-01 */
    0x00000000, 0x3FE7EC00, /* RSQRT[202] = +7.4755859375000000e-01 */
    0x00000000, 0x3FE7E400, /* RSQRT[203] = +7.4658203125000000e-01 */
    0x00000000, 0x3FE7E000, /* RSQRT[204] = +7.4609375000000000e-01 */
    0x00000000, 0x3FE7D800, /* RSQRT[205] = +7.4511718750000000e-01 */
    0x00000000, 0x3FE7D400, /* RSQRT[206] = +7.4462890625000000e-01 */
    0x00000000, 0x3FE7CC00, /* RSQRT[207] = +7.4365234375000000e-01 */
    0x00000000, 0x3FE7C400, /* RSQRT[208] = +7.4267578125000000e-01 */
    0x00000000, 0x3FE7C000, /* RSQRT[209] = +7.4218750000000000e-01 */
    0x00000000, 0x3FE7B800, /* RSQRT[210] = +7.4121093750000000e-01 */
    0x00000000, 0x3FE7B000, /* RSQRT[211] = +7.4023437500000000e-01 */
    0x00000000, 0x3FE7AC00, /* RSQRT[212] = +7.3974609375000000e-01 */
    0x00000000, 0x3FE7A400, /* RSQRT[213] = +7.3876953125000000e-01 */
    0x00000000, 0x3FE79C00, /* RSQRT[214] = +7.3779296875000000e-01 */
    0x00000000, 0x3FE79800, /* RSQRT[215] = +7.3730468750000000e-01 */
    0x00000000, 0x3FE79000, /* RSQRT[216] = +7.3632812500000000e-01 */
    0x00000000, 0x3FE78C00, /* RSQRT[217] = +7.3583984375000000e-01 */
    0x00000000, 0x3FE78400, /* RSQRT[218] = +7.3486328125000000e-01 */
    0x00000000, 0x3FE77C00, /* RSQRT[219] = +7.3388671875000000e-01 */
    0x00000000, 0x3FE77800, /* RSQRT[220] = +7.3339843750000000e-01 */
    0x00000000, 0x3FE77000, /* RSQRT[221] = +7.3242187500000000e-01 */
    0x00000000, 0x3FE76C00, /* RSQRT[222] = +7.3193359375000000e-01 */
    0x00000000, 0x3FE76400, /* RSQRT[223] = +7.3095703125000000e-01 */
    0x00000000, 0x3FE76000, /* RSQRT[224] = +7.3046875000000000e-01 */
    0x00000000, 0x3FE75800, /* RSQRT[225] = +7.2949218750000000e-01 */
    0x00000000, 0x3FE75400, /* RSQRT[226] = +7.2900390625000000e-01 */
    0x00000000, 0x3FE74C00, /* RSQRT[227] = +7.2802734375000000e-01 */
    0x00000000, 0x3FE74400, /* RSQRT[228] = +7.2705078125000000e-01 */
    0x00000000, 0x3FE74000, /* RSQRT[229] = +7.2656250000000000e-01 */
    0x00000000, 0x3FE73800, /* RSQRT[230] = +7.2558593750000000e-01 */
    0x00000000, 0x3FE73400, /* RSQRT[231] = +7.2509765625000000e-01 */
    0x00000000, 0x3FE72C00, /* RSQRT[232] = +7.2412109375000000e-01 */
    0x00000000, 0x3FE72800, /* RSQRT[233] = +7.2363281250000000e-01 */
    0x00000000, 0x3FE72000, /* RSQRT[234] = +7.2265625000000000e-01 */
    0x00000000, 0x3FE71C00, /* RSQRT[235] = +7.2216796875000000e-01 */
    0x00000000, 0x3FE71400, /* RSQRT[236] = +7.2119140625000000e-01 */
    0x00000000, 0x3FE71000, /* RSQRT[237] = +7.2070312500000000e-01 */
    0x00000000, 0x3FE70800, /* RSQRT[238] = +7.1972656250000000e-01 */
    0x00000000, 0x3FE70400, /* RSQRT[239] = +7.1923828125000000e-01 */
    0x00000000, 0x3FE6FC00, /* RSQRT[240] = +7.1826171875000000e-01 */
    0x00000000, 0x3FE6F800, /* RSQRT[241] = +7.1777343750000000e-01 */
    0x00000000, 0x3FE6F000, /* RSQRT[242] = +7.1679687500000000e-01 */
    0x00000000, 0x3FE6EC00, /* RSQRT[243] = +7.1630859375000000e-01 */
    0x00000000, 0x3FE6E400, /* RSQRT[244] = +7.1533203125000000e-01 */
    0x00000000, 0x3FE6E000, /* RSQRT[245] = +7.1484375000000000e-01 */
    0x00000000, 0x3FE6DC00, /* RSQRT[246] = +7.1435546875000000e-01 */
    0x00000000, 0x3FE6D400, /* RSQRT[247] = +7.1337890625000000e-01 */
    0x00000000, 0x3FE6D000, /* RSQRT[248] = +7.1289062500000000e-01 */
    0x00000000, 0x3FE6C800, /* RSQRT[249] = +7.1191406250000000e-01 */
    0x00000000, 0x3FE6C400, /* RSQRT[250] = +7.1142578125000000e-01 */
    0x00000000, 0x3FE6BC00, /* RSQRT[251] = +7.1044921875000000e-01 */
    0x00000000, 0x3FE6B800, /* RSQRT[252] = +7.0996093750000000e-01 */
    0x00000000, 0x3FE6B000, /* RSQRT[253] = +7.0898437500000000e-01 */
    0x00000000, 0x3FE6AC00, /* RSQRT[254] = +7.0849609375000000e-01 */
    0x00000000, 0x3FE6A800, /* RSQRT[255] = +7.0800781250000000e-01 */
    0x00000000, 0x3FE6A000, /* RSQRT[256] = +7.0703125000000000e-01 */
    0x00000000, 0x3FE69400, /* RSQRT[257] = +7.0556640625000000e-01 */
    0x00000000, 0x3FE68C00, /* RSQRT[258] = +7.0458984375000000e-01 */
    0x00000000, 0x3FE68000, /* RSQRT[259] = +7.0312500000000000e-01 */
    0x00000000, 0x3FE67400, /* RSQRT[260] = +7.0166015625000000e-01 */
    0x00000000, 0x3FE66800, /* RSQRT[261] = +7.0019531250000000e-01 */
    0x00000000, 0x3FE65C00, /* RSQRT[262] = +6.9873046875000000e-01 */
    0x00000000, 0x3FE65400, /* RSQRT[263] = +6.9775390625000000e-01 */
    0x00000000, 0x3FE64800, /* RSQRT[264] = +6.9628906250000000e-01 */
    0x00000000, 0x3FE63C00, /* RSQRT[265] = +6.9482421875000000e-01 */
    0x00000000, 0x3FE63400, /* RSQRT[266] = +6.9384765625000000e-01 */
    0x00000000, 0x3FE62800, /* RSQRT[267] = +6.9238281250000000e-01 */
    0x00000000, 0x3FE61C00, /* RSQRT[268] = +6.9091796875000000e-01 */
    0x00000000, 0x3FE61400, /* RSQRT[269] = +6.8994140625000000e-01 */
    0x00000000, 0x3FE60800, /* RSQRT[270] = +6.8847656250000000e-01 */
    0x00000000, 0x3FE60000, /* RSQRT[271] = +6.8750000000000000e-01 */
    0x00000000, 0x3FE5F400, /* RSQRT[272] = +6.8603515625000000e-01 */
    0x00000000, 0x3FE5E800, /* RSQRT[273] = +6.8457031250000000e-01 */
    0x00000000, 0x3FE5E000, /* RSQRT[274] = +6.8359375000000000e-01 */
    0x00000000, 0x3FE5D400, /* RSQRT[275] = +6.8212890625000000e-01 */
    0x00000000, 0x3FE5CC00, /* RSQRT[276] = +6.8115234375000000e-01 */
    0x00000000, 0x3FE5C000, /* RSQRT[277] = +6.7968750000000000e-01 */
    0x00000000, 0x3FE5B800, /* RSQRT[278] = +6.7871093750000000e-01 */
    0x00000000, 0x3FE5AC00, /* RSQRT[279] = +6.7724609375000000e-01 */
    0x00000000, 0x3FE5A400, /* RSQRT[280] = +6.7626953125000000e-01 */
    0x00000000, 0x3FE59800, /* RSQRT[281] = +6.7480468750000000e-01 */
    0x00000000, 0x3FE59000, /* RSQRT[282] = +6.7382812500000000e-01 */
    0x00000000, 0x3FE58400, /* RSQRT[283] = +6.7236328125000000e-01 */
    0x00000000, 0x3FE57C00, /* RSQRT[284] = +6.7138671875000000e-01 */
    0x00000000, 0x3FE57400, /* RSQRT[285] = +6.7041015625000000e-01 */
    0x00000000, 0x3FE56800, /* RSQRT[286] = +6.6894531250000000e-01 */
    0x00000000, 0x3FE56000, /* RSQRT[287] = +6.6796875000000000e-01 */
    0x00000000, 0x3FE55400, /* RSQRT[288] = +6.6650390625000000e-01 */
    0x00000000, 0x3FE54C00, /* RSQRT[289] = +6.6552734375000000e-01 */
    0x00000000, 0x3FE54400, /* RSQRT[290] = +6.6455078125000000e-01 */
    0x00000000, 0x3FE53800, /* RSQRT[291] = +6.6308593750000000e-01 */
    0x00000000, 0x3FE53000, /* RSQRT[292] = +6.6210937500000000e-01 */
    0x00000000, 0x3FE52800, /* RSQRT[293] = +6.6113281250000000e-01 */
    0x00000000, 0x3FE51C00, /* RSQRT[294] = +6.5966796875000000e-01 */
    0x00000000, 0x3FE51400, /* RSQRT[295] = +6.5869140625000000e-01 */
    0x00000000, 0x3FE50C00, /* RSQRT[296] = +6.5771484375000000e-01 */
    0x00000000, 0x3FE50000, /* RSQRT[297] = +6.5625000000000000e-01 */
    0x00000000, 0x3FE4F800, /* RSQRT[298] = +6.5527343750000000e-01 */
    0x00000000, 0x3FE4F000, /* RSQRT[299] = +6.5429687500000000e-01 */
    0x00000000, 0x3FE4E800, /* RSQRT[300] = +6.5332031250000000e-01 */
    0x00000000, 0x3FE4E000, /* RSQRT[301] = +6.5234375000000000e-01 */
    0x00000000, 0x3FE4D400, /* RSQRT[302] = +6.5087890625000000e-01 */
    0x00000000, 0x3FE4CC00, /* RSQRT[303] = +6.4990234375000000e-01 */
    0x00000000, 0x3FE4C400, /* RSQRT[304] = +6.4892578125000000e-01 */
    0x00000000, 0x3FE4BC00, /* RSQRT[305] = +6.4794921875000000e-01 */
    0x00000000, 0x3FE4B400, /* RSQRT[306] = +6.4697265625000000e-01 */
    0x00000000, 0x3FE4A800, /* RSQRT[307] = +6.4550781250000000e-01 */
    0x00000000, 0x3FE4A000, /* RSQRT[308] = +6.4453125000000000e-01 */
    0x00000000, 0x3FE49800, /* RSQRT[309] = +6.4355468750000000e-01 */
    0x00000000, 0x3FE49000, /* RSQRT[310] = +6.4257812500000000e-01 */
    0x00000000, 0x3FE48800, /* RSQRT[311] = +6.4160156250000000e-01 */
    0x00000000, 0x3FE48000, /* RSQRT[312] = +6.4062500000000000e-01 */
    0x00000000, 0x3FE47800, /* RSQRT[313] = +6.3964843750000000e-01 */
    0x00000000, 0x3FE47000, /* RSQRT[314] = +6.3867187500000000e-01 */
    0x00000000, 0x3FE46800, /* RSQRT[315] = +6.3769531250000000e-01 */
    0x00000000, 0x3FE45C00, /* RSQRT[316] = +6.3623046875000000e-01 */
    0x00000000, 0x3FE45400, /* RSQRT[317] = +6.3525390625000000e-01 */
    0x00000000, 0x3FE44C00, /* RSQRT[318] = +6.3427734375000000e-01 */
    0x00000000, 0x3FE44400, /* RSQRT[319] = +6.3330078125000000e-01 */
    0x00000000, 0x3FE43C00, /* RSQRT[320] = +6.3232421875000000e-01 */
    0x00000000, 0x3FE43400, /* RSQRT[321] = +6.3134765625000000e-01 */
    0x00000000, 0x3FE42C00, /* RSQRT[322] = +6.3037109375000000e-01 */
    0x00000000, 0x3FE42400, /* RSQRT[323] = +6.2939453125000000e-01 */
    0x00000000, 0x3FE41C00, /* RSQRT[324] = +6.2841796875000000e-01 */
    0x00000000, 0x3FE41400, /* RSQRT[325] = +6.2744140625000000e-01 */
    0x00000000, 0x3FE40C00, /* RSQRT[326] = +6.2646484375000000e-01 */
    0x00000000, 0x3FE40400, /* RSQRT[327] = +6.2548828125000000e-01 */
    0x00000000, 0x3FE3FC00, /* RSQRT[328] = +6.2451171875000000e-01 */
    0x00000000, 0x3FE3F400, /* RSQRT[329] = +6.2353515625000000e-01 */
    0x00000000, 0x3FE3EC00, /* RSQRT[330] = +6.2255859375000000e-01 */
    0x00000000, 0x3FE3E800, /* RSQRT[331] = +6.2207031250000000e-01 */
    0x00000000, 0x3FE3E000, /* RSQRT[332] = +6.2109375000000000e-01 */
    0x00000000, 0x3FE3D800, /* RSQRT[333] = +6.2011718750000000e-01 */
    0x00000000, 0x3FE3D000, /* RSQRT[334] = +6.1914062500000000e-01 */
    0x00000000, 0x3FE3C800, /* RSQRT[335] = +6.1816406250000000e-01 */
    0x00000000, 0x3FE3C000, /* RSQRT[336] = +6.1718750000000000e-01 */
    0x00000000, 0x3FE3B800, /* RSQRT[337] = +6.1621093750000000e-01 */
    0x00000000, 0x3FE3B000, /* RSQRT[338] = +6.1523437500000000e-01 */
    0x00000000, 0x3FE3A800, /* RSQRT[339] = +6.1425781250000000e-01 */
    0x00000000, 0x3FE3A400, /* RSQRT[340] = +6.1376953125000000e-01 */
    0x00000000, 0x3FE39C00, /* RSQRT[341] = +6.1279296875000000e-01 */
    0x00000000, 0x3FE39400, /* RSQRT[342] = +6.1181640625000000e-01 */
    0x00000000, 0x3FE38C00, /* RSQRT[343] = +6.1083984375000000e-01 */
    0x00000000, 0x3FE38400, /* RSQRT[344] = +6.0986328125000000e-01 */
    0x00000000, 0x3FE37C00, /* RSQRT[345] = +6.0888671875000000e-01 */
    0x00000000, 0x3FE37800, /* RSQRT[346] = +6.0839843750000000e-01 */
    0x00000000, 0x3FE37000, /* RSQRT[347] = +6.0742187500000000e-01 */
    0x00000000, 0x3FE36800, /* RSQRT[348] = +6.0644531250000000e-01 */
    0x00000000, 0x3FE36000, /* RSQRT[349] = +6.0546875000000000e-01 */
    0x00000000, 0x3FE35C00, /* RSQRT[350] = +6.0498046875000000e-01 */
    0x00000000, 0x3FE35400, /* RSQRT[351] = +6.0400390625000000e-01 */
    0x00000000, 0x3FE34C00, /* RSQRT[352] = +6.0302734375000000e-01 */
    0x00000000, 0x3FE34400, /* RSQRT[353] = +6.0205078125000000e-01 */
    0x00000000, 0x3FE33C00, /* RSQRT[354] = +6.0107421875000000e-01 */
    0x00000000, 0x3FE33800, /* RSQRT[355] = +6.0058593750000000e-01 */
    0x00000000, 0x3FE33000, /* RSQRT[356] = +5.9960937500000000e-01 */
    0x00000000, 0x3FE32800, /* RSQRT[357] = +5.9863281250000000e-01 */
    0x00000000, 0x3FE32400, /* RSQRT[358] = +5.9814453125000000e-01 */
    0x00000000, 0x3FE31C00, /* RSQRT[359] = +5.9716796875000000e-01 */
    0x00000000, 0x3FE31400, /* RSQRT[360] = +5.9619140625000000e-01 */
    0x00000000, 0x3FE30C00, /* RSQRT[361] = +5.9521484375000000e-01 */
    0x00000000, 0x3FE30800, /* RSQRT[362] = +5.9472656250000000e-01 */
    0x00000000, 0x3FE30000, /* RSQRT[363] = +5.9375000000000000e-01 */
    0x00000000, 0x3FE2F800, /* RSQRT[364] = +5.9277343750000000e-01 */
    0x00000000, 0x3FE2F400, /* RSQRT[365] = +5.9228515625000000e-01 */
    0x00000000, 0x3FE2EC00, /* RSQRT[366] = +5.9130859375000000e-01 */
    0x00000000, 0x3FE2E400, /* RSQRT[367] = +5.9033203125000000e-01 */
    0x00000000, 0x3FE2E000, /* RSQRT[368] = +5.8984375000000000e-01 */
    0x00000000, 0x3FE2D800, /* RSQRT[369] = +5.8886718750000000e-01 */
    0x00000000, 0x3FE2D400, /* RSQRT[370] = +5.8837890625000000e-01 */
    0x00000000, 0x3FE2CC00, /* RSQRT[371] = +5.8740234375000000e-01 */
    0x00000000, 0x3FE2C400, /* RSQRT[372] = +5.8642578125000000e-01 */
    0x00000000, 0x3FE2C000, /* RSQRT[373] = +5.8593750000000000e-01 */
    0x00000000, 0x3FE2B800, /* RSQRT[374] = +5.8496093750000000e-01 */
    0x00000000, 0x3FE2B400, /* RSQRT[375] = +5.8447265625000000e-01 */
    0x00000000, 0x3FE2AC00, /* RSQRT[376] = +5.8349609375000000e-01 */
    0x00000000, 0x3FE2A400, /* RSQRT[377] = +5.8251953125000000e-01 */
    0x00000000, 0x3FE2A000, /* RSQRT[378] = +5.8203125000000000e-01 */
    0x00000000, 0x3FE29800, /* RSQRT[379] = +5.8105468750000000e-01 */
    0x00000000, 0x3FE29400, /* RSQRT[380] = +5.8056640625000000e-01 */
    0x00000000, 0x3FE28C00, /* RSQRT[381] = +5.7958984375000000e-01 */
    0x00000000, 0x3FE28800, /* RSQRT[382] = +5.7910156250000000e-01 */
    0x00000000, 0x3FE28000, /* RSQRT[383] = +5.7812500000000000e-01 */
    0x00000000, 0x3FE27800, /* RSQRT[384] = +5.7714843750000000e-01 */
    0x00000000, 0x3FE27400, /* RSQRT[385] = +5.7666015625000000e-01 */
    0x00000000, 0x3FE26C00, /* RSQRT[386] = +5.7568359375000000e-01 */
    0x00000000, 0x3FE26800, /* RSQRT[387] = +5.7519531250000000e-01 */
    0x00000000, 0x3FE26000, /* RSQRT[388] = +5.7421875000000000e-01 */
    0x00000000, 0x3FE25C00, /* RSQRT[389] = +5.7373046875000000e-01 */
    0x00000000, 0x3FE25400, /* RSQRT[390] = +5.7275390625000000e-01 */
    0x00000000, 0x3FE25000, /* RSQRT[391] = +5.7226562500000000e-01 */
    0x00000000, 0x3FE24800, /* RSQRT[392] = +5.7128906250000000e-01 */
    0x00000000, 0x3FE24400, /* RSQRT[393] = +5.7080078125000000e-01 */
    0x00000000, 0x3FE23C00, /* RSQRT[394] = +5.6982421875000000e-01 */
    0x00000000, 0x3FE23800, /* RSQRT[395] = +5.6933593750000000e-01 */
    0x00000000, 0x3FE23000, /* RSQRT[396] = +5.6835937500000000e-01 */
    0x00000000, 0x3FE22C00, /* RSQRT[397] = +5.6787109375000000e-01 */
    0x00000000, 0x3FE22400, /* RSQRT[398] = +5.6689453125000000e-01 */
    0x00000000, 0x3FE22000, /* RSQRT[399] = +5.6640625000000000e-01 */
    0x00000000, 0x3FE21C00, /* RSQRT[400] = +5.6591796875000000e-01 */
    0x00000000, 0x3FE21400, /* RSQRT[401] = +5.6494140625000000e-01 */
    0x00000000, 0x3FE21000, /* RSQRT[402] = +5.6445312500000000e-01 */
    0x00000000, 0x3FE20800, /* RSQRT[403] = +5.6347656250000000e-01 */
    0x00000000, 0x3FE20400, /* RSQRT[404] = +5.6298828125000000e-01 */
    0x00000000, 0x3FE1FC00, /* RSQRT[405] = +5.6201171875000000e-01 */
    0x00000000, 0x3FE1F800, /* RSQRT[406] = +5.6152343750000000e-01 */
    0x00000000, 0x3FE1F400, /* RSQRT[407] = +5.6103515625000000e-01 */
    0x00000000, 0x3FE1EC00, /* RSQRT[408] = +5.6005859375000000e-01 */
    0x00000000, 0x3FE1E800, /* RSQRT[409] = +5.5957031250000000e-01 */
    0x00000000, 0x3FE1E000, /* RSQRT[410] = +5.5859375000000000e-01 */
    0x00000000, 0x3FE1DC00, /* RSQRT[411] = +5.5810546875000000e-01 */
    0x00000000, 0x3FE1D800, /* RSQRT[412] = +5.5761718750000000e-01 */
    0x00000000, 0x3FE1D000, /* RSQRT[413] = +5.5664062500000000e-01 */
    0x00000000, 0x3FE1CC00, /* RSQRT[414] = +5.5615234375000000e-01 */
    0x00000000, 0x3FE1C400, /* RSQRT[415] = +5.5517578125000000e-01 */
    0x00000000, 0x3FE1C000, /* RSQRT[416] = +5.5468750000000000e-01 */
    0x00000000, 0x3FE1BC00, /* RSQRT[417] = +5.5419921875000000e-01 */
    0x00000000, 0x3FE1B400, /* RSQRT[418] = +5.5322265625000000e-01 */
    0x00000000, 0x3FE1B000, /* RSQRT[419] = +5.5273437500000000e-01 */
    0x00000000, 0x3FE1AC00, /* RSQRT[420] = +5.5224609375000000e-01 */
    0x00000000, 0x3FE1A400, /* RSQRT[421] = +5.5126953125000000e-01 */
    0x00000000, 0x3FE1A000, /* RSQRT[422] = +5.5078125000000000e-01 */
    0x00000000, 0x3FE19C00, /* RSQRT[423] = +5.5029296875000000e-01 */
    0x00000000, 0x3FE19400, /* RSQRT[424] = +5.4931640625000000e-01 */
    0x00000000, 0x3FE19000, /* RSQRT[425] = +5.4882812500000000e-01 */
    0x00000000, 0x3FE18C00, /* RSQRT[426] = +5.4833984375000000e-01 */
    0x00000000, 0x3FE18400, /* RSQRT[427] = +5.4736328125000000e-01 */
    0x00000000, 0x3FE18000, /* RSQRT[428] = +5.4687500000000000e-01 */
    0x00000000, 0x3FE17C00, /* RSQRT[429] = +5.4638671875000000e-01 */
    0x00000000, 0x3FE17400, /* RSQRT[430] = +5.4541015625000000e-01 */
    0x00000000, 0x3FE17000, /* RSQRT[431] = +5.4492187500000000e-01 */
    0x00000000, 0x3FE16C00, /* RSQRT[432] = +5.4443359375000000e-01 */
    0x00000000, 0x3FE16800, /* RSQRT[433] = +5.4394531250000000e-01 */
    0x00000000, 0x3FE16000, /* RSQRT[434] = +5.4296875000000000e-01 */
    0x00000000, 0x3FE15C00, /* RSQRT[435] = +5.4248046875000000e-01 */
    0x00000000, 0x3FE15800, /* RSQRT[436] = +5.4199218750000000e-01 */
    0x00000000, 0x3FE15000, /* RSQRT[437] = +5.4101562500000000e-01 */
    0x00000000, 0x3FE14C00, /* RSQRT[438] = +5.4052734375000000e-01 */
    0x00000000, 0x3FE14800, /* RSQRT[439] = +5.4003906250000000e-01 */
    0x00000000, 0x3FE14400, /* RSQRT[440] = +5.3955078125000000e-01 */
    0x00000000, 0x3FE13C00, /* RSQRT[441] = +5.3857421875000000e-01 */
    0x00000000, 0x3FE13800, /* RSQRT[442] = +5.3808593750000000e-01 */
    0x00000000, 0x3FE13400, /* RSQRT[443] = +5.3759765625000000e-01 */
    0x00000000, 0x3FE13000, /* RSQRT[444] = +5.3710937500000000e-01 */
    0x00000000, 0x3FE12800, /* RSQRT[445] = +5.3613281250000000e-01 */
    0x00000000, 0x3FE12400, /* RSQRT[446] = +5.3564453125000000e-01 */
    0x00000000, 0x3FE12000, /* RSQRT[447] = +5.3515625000000000e-01 */
    0x00000000, 0x3FE11C00, /* RSQRT[448] = +5.3466796875000000e-01 */
    0x00000000, 0x3FE11400, /* RSQRT[449] = +5.3369140625000000e-01 */
    0x00000000, 0x3FE11000, /* RSQRT[450] = +5.3320312500000000e-01 */
    0x00000000, 0x3FE10C00, /* RSQRT[451] = +5.3271484375000000e-01 */
    0x00000000, 0x3FE10800, /* RSQRT[452] = +5.3222656250000000e-01 */
    0x00000000, 0x3FE10400, /* RSQRT[453] = +5.3173828125000000e-01 */
    0x00000000, 0x3FE0FC00, /* RSQRT[454] = +5.3076171875000000e-01 */
    0x00000000, 0x3FE0F800, /* RSQRT[455] = +5.3027343750000000e-01 */
    0x00000000, 0x3FE0F400, /* RSQRT[456] = +5.2978515625000000e-01 */
    0x00000000, 0x3FE0F000, /* RSQRT[457] = +5.2929687500000000e-01 */
    0x00000000, 0x3FE0EC00, /* RSQRT[458] = +5.2880859375000000e-01 */
    0x00000000, 0x3FE0E800, /* RSQRT[459] = +5.2832031250000000e-01 */
    0x00000000, 0x3FE0E000, /* RSQRT[460] = +5.2734375000000000e-01 */
    0x00000000, 0x3FE0DC00, /* RSQRT[461] = +5.2685546875000000e-01 */
    0x00000000, 0x3FE0D800, /* RSQRT[462] = +5.2636718750000000e-01 */
    0x00000000, 0x3FE0D400, /* RSQRT[463] = +5.2587890625000000e-01 */
    0x00000000, 0x3FE0D000, /* RSQRT[464] = +5.2539062500000000e-01 */
    0x00000000, 0x3FE0CC00, /* RSQRT[465] = +5.2490234375000000e-01 */
    0x00000000, 0x3FE0C400, /* RSQRT[466] = +5.2392578125000000e-01 */
    0x00000000, 0x3FE0C000, /* RSQRT[467] = +5.2343750000000000e-01 */
    0x00000000, 0x3FE0BC00, /* RSQRT[468] = +5.2294921875000000e-01 */
    0x00000000, 0x3FE0B800, /* RSQRT[469] = +5.2246093750000000e-01 */
    0x00000000, 0x3FE0B400, /* RSQRT[470] = +5.2197265625000000e-01 */
    0x00000000, 0x3FE0B000, /* RSQRT[471] = +5.2148437500000000e-01 */
    0x00000000, 0x3FE0AC00, /* RSQRT[472] = +5.2099609375000000e-01 */
    0x00000000, 0x3FE0A400, /* RSQRT[473] = +5.2001953125000000e-01 */
    0x00000000, 0x3FE0A000, /* RSQRT[474] = +5.1953125000000000e-01 */
    0x00000000, 0x3FE09C00, /* RSQRT[475] = +5.1904296875000000e-01 */
    0x00000000, 0x3FE09800, /* RSQRT[476] = +5.1855468750000000e-01 */
    0x00000000, 0x3FE09400, /* RSQRT[477] = +5.1806640625000000e-01 */
    0x00000000, 0x3FE09000, /* RSQRT[478] = +5.1757812500000000e-01 */
    0x00000000, 0x3FE08C00, /* RSQRT[479] = +5.1708984375000000e-01 */
    0x00000000, 0x3FE08800, /* RSQRT[480] = +5.1660156250000000e-01 */
    0x00000000, 0x3FE08000, /* RSQRT[481] = +5.1562500000000000e-01 */
    0x00000000, 0x3FE07C00, /* RSQRT[482] = +5.1513671875000000e-01 */
    0x00000000, 0x3FE07800, /* RSQRT[483] = +5.1464843750000000e-01 */
    0x00000000, 0x3FE07400, /* RSQRT[484] = +5.1416015625000000e-01 */
    0x00000000, 0x3FE07000, /* RSQRT[485] = +5.1367187500000000e-01 */
    0x00000000, 0x3FE06C00, /* RSQRT[486] = +5.1318359375000000e-01 */
    0x00000000, 0x3FE06800, /* RSQRT[487] = +5.1269531250000000e-01 */
    0x00000000, 0x3FE06400, /* RSQRT[488] = +5.1220703125000000e-01 */
    0x00000000, 0x3FE06000, /* RSQRT[489] = +5.1171875000000000e-01 */
    0x00000000, 0x3FE05C00, /* RSQRT[490] = +5.1123046875000000e-01 */
    0x00000000, 0x3FE05800, /* RSQRT[491] = +5.1074218750000000e-01 */
    0x00000000, 0x3FE05400, /* RSQRT[492] = +5.1025390625000000e-01 */
    0x00000000, 0x3FE05000, /* RSQRT[493] = +5.0976562500000000e-01 */
    0x00000000, 0x3FE04800, /* RSQRT[494] = +5.0878906250000000e-01 */
    0x00000000, 0x3FE04400, /* RSQRT[495] = +5.0830078125000000e-01 */
    0x00000000, 0x3FE04000, /* RSQRT[496] = +5.0781250000000000e-01 */
    0x00000000, 0x3FE03C00, /* RSQRT[497] = +5.0732421875000000e-01 */
    0x00000000, 0x3FE03800, /* RSQRT[498] = +5.0683593750000000e-01 */
    0x00000000, 0x3FE03400, /* RSQRT[499] = +5.0634765625000000e-01 */
    0x00000000, 0x3FE03000, /* RSQRT[500] = +5.0585937500000000e-01 */
    0x00000000, 0x3FE02C00, /* RSQRT[501] = +5.0537109375000000e-01 */
    0x00000000, 0x3FE02800, /* RSQRT[502] = +5.0488281250000000e-01 */
    0x00000000, 0x3FE02400, /* RSQRT[503] = +5.0439453125000000e-01 */
    0x00000000, 0x3FE02000, /* RSQRT[504] = +5.0390625000000000e-01 */
    0x00000000, 0x3FE01C00, /* RSQRT[505] = +5.0341796875000000e-01 */
    0x00000000, 0x3FE01800, /* RSQRT[506] = +5.0292968750000000e-01 */
    0x00000000, 0x3FE01400, /* RSQRT[507] = +5.0244140625000000e-01 */
    0x00000000, 0x3FE01000, /* RSQRT[508] = +5.0195312500000000e-01 */
    0x00000000, 0x3FE00C00, /* RSQRT[509] = +5.0146484375000000e-01 */
    0x00000000, 0x3FE00800, /* RSQRT[510] = +5.0097656250000000e-01 */
    0x00000000, 0x3FE00400, /* RSQRT[511] = +5.0048828125000000e-01 */
    /* Other constants */
    0x00000000, 0x00000000, /* ZERO = 0.0 */
    0x00000000, 0x3FE00000, /* ONEHALF = 0.5 */
    0x00000000, 0x3FF00000, /* ONETWO(0) = 1.0 */
    0x00000000, 0x40000000, /* ONETWO(1) = 2.0 */
    0x02000000, 0x41A00000, /* RS_MuL = 2^27+1 */
};
__attribute__((always_inline)) inline int
__ocl_svml_internal_dhypot_la(double *a, double *b, double *r) {
  double v1, v2;
  double mantissa, y;
  double TwoPowN;
  double TwoPowM2N;
  double TwoPowNScale;
  double x;
  double h, s, d, a1, a2, z;
  double sHi, sLo, a1Hi, a2Hi, a1Lo, a2Lo, zHi, zLo;
  double d_sum;
  int i, j;
  int L, M, N;
  int unscale;
  double dbl_scale;
  int nRet = 0;
  i = 0;
  {
    /* Filter out INFs and NaNs */
    if ((((((_iml_v2_dp_union_t *)&(a[0]))->dwords.hi_dword >> 20) & 0x7FF) !=
         0x7FF) &&
        (((((_iml_v2_dp_union_t *)&(b[0]))->dwords.hi_dword >> 20) & 0x7FF) !=
         0x7FF)) {
      /* Here if a[i] is finite */
      /* Check if zero argument */
      if ((a[0]) != ((__constant double *)__dhypot_la__vmldHypotHATab)[512] ||
          (b[0]) != ((__constant double *)__dhypot_la__vmldHypotHATab)[512]) {
        /* Path 5). "Main" path.                   */
        /* Here if argument is finite */
        a1 = (a[0]);
        a2 = (b[0]);
        (((_iml_v2_dp_union_t *)&a1)->dwords.hi_dword =
             (((_iml_v2_dp_union_t *)&a1)->dwords.hi_dword & 0x7FFFFFFF) |
             ((_iml_uint32_t)(0) << 31));
        (((_iml_v2_dp_union_t *)&a2)->dwords.hi_dword =
             (((_iml_v2_dp_union_t *)&a2)->dwords.hi_dword & 0x7FFFFFFF) |
             ((_iml_uint32_t)(0) << 31));
        if (a1 < a2) {
          z = a1;
          a1 = a2;
          a2 = z;
        }
        unscale =
            1025 - ((((_iml_v2_dp_union_t *)&a1)->dwords.hi_dword >> 20) & 0x7FF);
        /* denormal fix without branch */
        unscale -= (unscale > 1000) * 23;
        dbl_scale = ((__constant double *)__dhypot_la__vmldHypotHATab)[512];
        (((_iml_v2_dp_union_t *)&dbl_scale)->dwords.hi_dword =
             (((_iml_v2_dp_union_t *)&dbl_scale)->dwords.hi_dword & 0x800FFFFF) |
             (((_iml_uint32_t)((unscale + 1023)) & 0x7FF) << 20));
        a1 *= dbl_scale;
        a2 *= dbl_scale;
        v1 = __spirv_ocl_fma(
            (a1), (((__constant double *)__dhypot_la__vmldHypotHATab)[516]),
            0.0);
        v2 = __spirv_ocl_fma((v1), 1.0, -(a1));
        v1 = __spirv_ocl_fma((v1), 1.0, -(v2));
        v2 = __spirv_ocl_fma((a1), 1.0, -(v1));
        a1Hi = v1;
        a1Lo = v2;
        ;
        if (((((_iml_v2_dp_union_t *)&a1)->dwords.hi_dword >> 20) & 0x7FF) -
                ((((_iml_v2_dp_union_t *)&a2)->dwords.hi_dword >> 20) & 0x7FF) >
            0x006) {
          a2Hi = ((__constant double *)__dhypot_la__vmldHypotHATab)[512];
          a2Lo = a2;
        } else {
          v1 = __spirv_ocl_fma(
              (a2), (((__constant double *)__dhypot_la__vmldHypotHATab)[516]),
              0.0);
          v2 = __spirv_ocl_fma((v1), 1.0, -(a2));
          v1 = __spirv_ocl_fma((v1), 1.0, -(v2));
          v2 = __spirv_ocl_fma((a2), 1.0, -(v1));
          a2Hi = v1;
          a2Lo = v2;
          ;
        }
        zHi = (a1Hi * a1Hi) + (a2Hi * a2Hi);
        zLo = (a1Lo * (a1 + a1Hi) + (a2Lo * a2)) + (a2Hi * a2Lo);
        /* Default value of unscale */
        d_sum = zHi + zLo;
        /* Reducing x to y */
        /* Represent x as x = 2^M * mantissa */
        /* Store the order of x */
        M = ((((_iml_v2_dp_union_t *)&d_sum)->dwords.hi_dword >> 20) & 0x7FF) -
            0x3FF;
        /* Keep only significand of x, zero the exponent */
        mantissa = d_sum;
        (((_iml_v2_dp_union_t *)&mantissa)->dwords.hi_dword =
             (((_iml_v2_dp_union_t *)&mantissa)->dwords.hi_dword & 0x800FFFFF) |
             (((_iml_uint32_t)(0x3FF) & 0x7FF) << 20));
        /* Represent x as x = 2^(2*N) * y */
        L = M & 1;
        N = (M - L) >> 1;
        y = mantissa *
            ((__constant double *)__dhypot_la__vmldHypotHATab)[514 + (L)];
        /* Construct 2^N */
        TwoPowN = ((__constant double *)__dhypot_la__vmldHypotHATab)[514 + (0)];
        (((_iml_v2_dp_union_t *)&TwoPowN)->dwords.hi_dword =
             (((_iml_v2_dp_union_t *)&TwoPowN)->dwords.hi_dword & 0x800FFFFF) |
             (((_iml_uint32_t)(N + 0x3FF) & 0x7FF) << 20));
        /* Construct 2^(-2*N) */
        TwoPowM2N =
            ((__constant double *)__dhypot_la__vmldHypotHATab)[514 + (0)];
        (((_iml_v2_dp_union_t *)&TwoPowM2N)->dwords.hi_dword =
             (((_iml_v2_dp_union_t *)&TwoPowM2N)->dwords.hi_dword & 0x800FFFFF) |
             (((_iml_uint32_t)(-2 * N + 0x3FF) & 0x7FF) << 20));
        /* Construct 2^(-unscale) */
        TwoPowNScale =
            ((__constant double *)__dhypot_la__vmldHypotHATab)[514 + (0)];
        (((_iml_v2_dp_union_t *)&TwoPowNScale)->dwords.hi_dword =
             (((_iml_v2_dp_union_t *)&TwoPowNScale)->dwords.hi_dword &
              0x800FFFFF) |
             (((_iml_uint32_t)(0x3FF - unscale) & 0x7FF) << 20));
        /* Obtain j */
        j = (((_iml_v2_dp_union_t *)&mantissa)->dwords.hi_dword & 0x000FFFFF) >>
            12;
        j = j + (L << 8);
        /* Get 0.5 / sqrt(y) initial approximation */
        h = ((__constant double *)__dhypot_la__vmldHypotHATab)[513] *
            ((__constant double *)__dhypot_la__vmldHypotHATab)[(j)];
        /* Get sqrt(y) initial approximation */
        s = y * ((__constant double *)__dhypot_la__vmldHypotHATab)[(j)];
        /* Correction term */
        d = ((__constant double *)__dhypot_la__vmldHypotHATab)[513] - s * h;
        /* First iteration */
        h = h + (d * h);
        s = s + (d * s);
        d = ((__constant double *)__dhypot_la__vmldHypotHATab)[513] - (s * h);
        /* Second iteration */
        h = h + (d * h);
        s = s + (d * s);
        d = ((__constant double *)__dhypot_la__vmldHypotHATab)[513] - s * h;
        /* Third iteration */
        h = h + (d * h);
        s = s + (d * s);
        /* Calculating d := y - (sHi + sLo) * (sHi + sLo) */
        /* Split s into sHi + sLo */
        v1 = __spirv_ocl_fma(
            (s), (((__constant double *)__dhypot_la__vmldHypotHATab)[516]),
            0.0);
        v2 = __spirv_ocl_fma((v1), 1.0, -(s));
        v1 = __spirv_ocl_fma((v1), 1.0, -(v2));
        v2 = __spirv_ocl_fma((s), 1.0, -(v1));
        sHi = v1;
        sLo = v2;
        ;
        d = (zHi * TwoPowM2N) - (sHi * sHi);
        d -= (((__constant double *)__dhypot_la__vmldHypotHATab)[514 + (1)] *
              sHi) *
             sLo;
        d -= (sLo * sLo);
        d += (zLo * TwoPowM2N);
        /* Final iteration */
        s = s + (d * h);
        /* Result scaling back: r[i] := s * 2^(N - unscale) */
        r[i] = (s * TwoPowN) * TwoPowNScale;
      } else {
        /* Path 3). Here if |a[i]| = |b[i]| = 0 */
        r[i] = ((__constant double *)__dhypot_la__vmldHypotHATab)[512];
      }
    }
    /* One of arguments is not finite */
    else {
      /* If 1st argument is finite */
      if ((((((_iml_v2_dp_union_t *)&(a[0]))->dwords.hi_dword >> 20) & 0x7FF) !=
           0x7FF)) {
        r[i] = (b[0]) * (b[0]);
      } else {
        /* If 2nd argument is finite */
        if ((((((_iml_v2_dp_union_t *)&(b[0]))->dwords.hi_dword >> 20) & 0x7FF) !=
             0x7FF)) {
          r[i] = (a[0]) * (a[0]);
        } else {
          /* If both arguments are NaNs */
          if (!(((((_iml_v2_dp_union_t *)&(a[0]))->dwords.hi_dword & 0x000FFFFF) ==
                 0) &&
                ((((_iml_v2_dp_union_t *)&(a[0]))->dwords.lo_dword) == 0)) &&
              !(((((_iml_v2_dp_union_t *)&(b[0]))->dwords.hi_dword & 0x000FFFFF) ==
                 0) &&
                ((((_iml_v2_dp_union_t *)&(b[0]))->dwords.lo_dword) == 0))) {
            r[i] = (a[0]) * (b[0]);
          } else {
            /* If 1st argument is Inf */
            if ((((((_iml_v2_dp_union_t *)&(a[0]))->dwords.hi_dword &
                   0x000FFFFF) == 0) &&
                 ((((_iml_v2_dp_union_t *)&(a[0]))->dwords.lo_dword) == 0))) {
              {
                /* Return Inf */
                r[i] = (a[0]) * (a[0]);
              }
            }
            /* If 2nd argument is Inf */
            else {
              {
                /* Return Inf */
                r[i] = (b[0]) * (b[0]);
              }
            }
          }
        }
      }
    }
  }
  return nRet;
}
double __ocl_svml_hypot_la(double x, double y) {
  double r;
  unsigned int vm;
  double va1;
  double va2;
  double vr1;
  va1 = x;
  va2 = y;
  {
    double _x;
    double _y;
    double _abs_arg1;
    double _abs_arg2;
    double _hilo_mask;
    double _abs_mask;
    double _one;
    double _a;
    double _b;
    double _c;
    double _d;
    double _z;
    double _zHi;
    double _zLo;
    double _s;
    double _s2;
    double _e;
    double _p;
    double _POLY_C5;
    double _POLY_C4;
    double _POLY_C3;
    double _POLY_C2;
    double _POLY_C1;
    double _res;
    /* ----------------------- Defines ------------------------- */
    /* -------------------- Implementation --------------------- */
    _hilo_mask = as_double(__ocl_svml_internal_dhypot_la_data._dHiLoMask);
    _abs_mask = as_double(__ocl_svml_internal_dhypot_la_data._dAbsMask);
    _one = as_double(__ocl_svml_internal_dhypot_la_data._dOne);
    _POLY_C5 = as_double(__ocl_svml_internal_dhypot_la_data._POLY_C5);
    _POLY_C4 = as_double(__ocl_svml_internal_dhypot_la_data._POLY_C4);
    _POLY_C3 = as_double(__ocl_svml_internal_dhypot_la_data._POLY_C3);
    _POLY_C2 = as_double(__ocl_svml_internal_dhypot_la_data._POLY_C2);
    _POLY_C1 = as_double(__ocl_svml_internal_dhypot_la_data._POLY_C1);
    /* Multiprecision branch for _HA_ only */
    /* _z = _VARG1 * _VARG1 + _VARG2 * _VARG2                              */
    _z = (va1 * va1);
    _z = __spirv_ocl_fma(va2, va2, _z);
    {
      unsigned long _zl;
      double _zd;
      unsigned int _zi;
      unsigned int _low_limit;
      unsigned int _high_limit;
      _low_limit = (__ocl_svml_internal_dhypot_la_data._LowBoundary);
      _high_limit = (__ocl_svml_internal_dhypot_la_data._HighBoundary);
      _zl = as_ulong(_z);
      _zi = ((unsigned int)((unsigned long)_zl >> 32));
      _low_limit = ((unsigned int)(-(signed int)((signed int)_zi <
                                                 (signed int)_low_limit)));
      _high_limit = ((unsigned int)(-(signed int)((signed int)_zi >
                                                  (signed int)_high_limit)));
      _zi = (_low_limit | _high_limit);
      _zl = (((unsigned long)(unsigned int)_zi << 32) |
             (unsigned long)(unsigned int)_zi);
      vm = 0;
      vm = _zl;
      /* Avoid INVALID exception for zero arguments */
      _zd = as_double(_zl);
      _z = as_double((((~as_ulong(_zd)) & as_ulong(_z)) |
                      (as_ulong(_zd) & as_ulong(_one))));
    }
    /* _s  ~ 1.0/sqrt(_z)                       */
    /* _s2 ~ 1.0/(sqrt(_z)*sqrt(_z)) ~ 1.0/_z   */
    _s = ((double)(1.0f / __spirv_ocl_sqrt((float)(_z))));
    _s2 = (_s * _s);
    /* _e[rror]  ~  (1.0/_z + O) * _z - 1.0     */
    _e = __spirv_ocl_fma(_z, _s2, -(_one));
    /* calculate fixing part _p                         */
    /* _p = (((_POLY_C5*_e + _POLY_C4)*_e +_POLY_C3)*_e +_POLY_C2)*_e + _POLY_C1
     */
    /* some parts of polynom are skipped for lower flav */
    _p = __spirv_ocl_fma(_POLY_C4, _e, _POLY_C3);
    _p = __spirv_ocl_fma(_p, _e, _POLY_C2);
    _p = __spirv_ocl_fma(_p, _e, _POLY_C1);
    /* result = _z * (1.0/sqrt(_z) + O) + _p * _e[rror] * _z    */
    _p = (_p * _e);
    _p = (_p * _s);
    _p = (_p * _z);
    vr1 = __spirv_ocl_fma(_z, _s, _p);
    /* -------------- The end of implementation ---------------- */
  }
  if (__builtin_expect((vm) != 0, 0)) {
    double __cout_a1;
    double __cout_a2;
    double __cout_r1;
    ((double *)&__cout_a1)[0] = va1;
    ((double *)&__cout_a2)[0] = va2;
    ((double *)&__cout_r1)[0] = vr1;
    __ocl_svml_internal_dhypot_la(&__cout_a1, &__cout_a2, &__cout_r1);
    vr1 = ((double *)&__cout_r1)[0];
  }
  r = vr1;
  return r;
}
