/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.api;

import java.io.IOException;
import java.util.Arrays;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.signal.core.util.Base64;
import org.whispersystems.signalservice.api.push.UsernameLinkComponents;
import org.whispersystems.signalservice.api.util.UuidUtil;

public final class UsernameLinkUrl {
    private static final Pattern URL_REGEX = Pattern.compile("(https://)?signal.me/?#eu/([a-zA-Z0-9+\\-_/]+)");
    private static final String BASE_URL = "https://signal.me/#eu/";
    private final String url;
    private final UsernameLinkComponents usernameLinkComponents;

    public static UsernameLinkUrl fromUri(String url) throws InvalidUsernameLinkException {
        byte[] allBytes;
        Matcher matcher = URL_REGEX.matcher(url);
        if (!matcher.matches()) {
            throw new InvalidUsernameLinkException("Invalid username link");
        }
        String path = matcher.group(2);
        try {
            allBytes = Base64.decode((String)path);
        }
        catch (IOException e) {
            throw new InvalidUsernameLinkException("Invalid base64 encoding");
        }
        if (allBytes.length != 48) {
            throw new InvalidUsernameLinkException("Invalid username link");
        }
        byte[] entropy = Arrays.copyOfRange(allBytes, 0, 32);
        byte[] serverId = Arrays.copyOfRange(allBytes, 32, allBytes.length);
        UUID serverIdUuid = UuidUtil.parseOrNull((byte[])serverId);
        if (serverIdUuid == null) {
            throw new InvalidUsernameLinkException("Invalid serverId");
        }
        return new UsernameLinkUrl(new UsernameLinkComponents(entropy, serverIdUuid));
    }

    public UsernameLinkUrl(UsernameLinkComponents usernameLinkComponents) {
        this.usernameLinkComponents = usernameLinkComponents;
        this.url = UsernameLinkUrl.createUrl(usernameLinkComponents);
    }

    private static String createUrl(UsernameLinkComponents usernameLinkComponents) {
        byte[] entropy = usernameLinkComponents.getEntropy();
        byte[] serverId = UuidUtil.toByteArray((UUID)usernameLinkComponents.getServerId());
        byte[] combined = new byte[entropy.length + serverId.length];
        System.arraycopy(entropy, 0, combined, 0, entropy.length);
        System.arraycopy(serverId, 0, combined, entropy.length, serverId.length);
        String base64 = Base64.encodeUrlSafeWithoutPadding((byte[])combined);
        return BASE_URL + base64;
    }

    public String getUrl() {
        return this.url;
    }

    public UsernameLinkComponents getComponents() {
        return this.usernameLinkComponents;
    }

    public static final class InvalidUsernameLinkException
    extends Exception {
        public InvalidUsernameLinkException(String message) {
            super(message);
        }

        public InvalidUsernameLinkException(Throwable cause) {
            super(cause);
        }
    }
}

