/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class TokenProcessor {
    private static TokenProcessor instance = new TokenProcessor();

    public static TokenProcessor getInstance() {
        return instance;
    }

    protected TokenProcessor() {
    }

    public synchronized boolean isTokenValid(HttpServletRequest request) {
        return this.isTokenValid(request, false);
    }

    public synchronized boolean isTokenValid(HttpServletRequest request, boolean reset) {
        String token;
        HttpSession session = request.getSession(false);
        if (session == null) {
            return false;
        }
        String saved = (String)session.getAttribute("org.apache.struts.action.TOKEN");
        if (saved == null) {
            return false;
        }
        if (reset) {
            this.resetToken(request);
        }
        if ((token = request.getParameter("org.apache.struts.taglib.html.TOKEN")) == null) {
            return false;
        }
        return saved.equals(token);
    }

    public synchronized void resetToken(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            return;
        }
        session.removeAttribute("org.apache.struts.action.TOKEN");
    }

    public synchronized void saveToken(HttpServletRequest request) {
        HttpSession session = request.getSession();
        String token = this.generateToken(request);
        if (token != null) {
            session.setAttribute("org.apache.struts.action.TOKEN", (Object)token);
        }
    }

    public String generateToken(HttpServletRequest request) {
        HttpSession session = request.getSession();
        try {
            byte[] id = session.getId().getBytes();
            byte[] now = new Long(System.currentTimeMillis()).toString().getBytes();
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(id);
            md.update(now);
            return this.toHex(md.digest());
        }
        catch (IllegalStateException e) {
            return null;
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    public String toHex(byte[] buffer) {
        StringBuffer sb = new StringBuffer();
        String s = null;
        int i = 0;
        while (i < buffer.length) {
            s = Integer.toHexString(buffer[i] & 0xFF);
            if (s.length() < 2) {
                sb.append('0');
            }
            sb.append(s);
            ++i;
        }
        return sb.toString();
    }
}

