import type { CodeGeneratorRequest, DescFile } from "@bufbuild/protobuf";
import { FeatureSetDefaults } from "@bufbuild/protobuf";
import type { FileInfo, GeneratedFile } from "./generated-file.js";
import type { RuntimeImports } from "./runtime-imports.js";
import type { Target } from "./target.js";
import type { ParsedParameter } from "./parameter.js";
/**
 * Schema describes the files and types that the plugin is requested to
 * generate.
 */
export interface Schema {
    /**
     * The files we are asked to generate.
     */
    readonly files: readonly DescFile[];
    /**
     * All files contained in the code generator request.
     */
    readonly allFiles: readonly DescFile[];
    /**
     * The plugin option `target`. A code generator should support all targets.
     */
    readonly targets: readonly Target[];
    /**
     * Provides some symbols from the runtime library @bufbuild/protobuf.
     */
    readonly runtime: RuntimeImports;
    /**
     * Generate a new file with the given name.
     */
    generateFile(name: string): GeneratedFile;
    /**
     * The original google.protobuf.compiler.CodeGeneratorRequest.
     */
    readonly proto: CodeGeneratorRequest;
}
interface SchemaController extends Schema {
    getFileInfo: () => FileInfo[];
    prepareGenerate(target: Target): void;
}
export declare function createSchema(request: CodeGeneratorRequest, parameter: ParsedParameter, pluginName: string, pluginVersion: string, featureSetDefaults: FeatureSetDefaults | undefined): SchemaController;
export {};
