## Setting up prerequisites

Currently, only Ubuntu 18.04+ is officially supported as primary development environment.

There are several dependencies, that should be installed manually. The following list is the absolute minimum for building:

- `gcc` or any C99-compliant compiler (native or cross, e.g., arm-none-eabi)
- `cmake` >= `3.10`

Several scripts and tools help the building and development process, thus it is recommended to have the following installed as well:

- `bash` >= `4.3.11`
- `cppcheck` >= `2.7`
- `clang-format-15`
- `python` >= `3.10`

```bash
sudo apt-get install gcc gcc-arm-none-eabi cmake cppcheck clang-format-15 python
```

To make our scripts run correctly, several shell utilities should be available on the system:

- `awk`
- `bc`
- `find`
- `sed`

## Building JerryScript

**To build debug version for Linux**

```bash
python tools/build.py --debug
```

**To build debug version for Linux without LTO (Link Time Optimization)**

```bash
python tools/build.py --debug --lto=off
```

**To enable more verbose outputs for debugging**

```bash
tools/build.py --debug --logging=on --error-messages=on --line-info=on
```

**Add custom arguments to CMake**

```bash
python tools/build.py --cmake-param=CMAKE_PARAM
```

**Set a profile mode (es.next, minimal)**

```bash
python tools/build.py --profile=es.next|minimal
```

See also the related [README.md](../jerry-core/profiles/README.md).

**Use (compiler-default, external) libc**

The default libc is the compiler-default libc but you can use an external libc as well:

- compiler-default libc:

```bash
python tools/build.py
```

- external libc:

```bash
python tools/build.py --compile-flag="-nostdlib -I/path/to/ext-libc/include" --link-lib="ext-c"
```

**Add toolchain file**

The ```cmake``` dir already contains some usable toolchain files, which you can use in the following format:

```bash
python tools/build.py --toolchain=TOOLCHAIN
```

For example the cross-compile to RaspberryPi 2 is something like this:

```bash
python tools/build.py --toolchain=cmake/toolchain_linux_armv7l.cmake
```

**Use system memory allocator**

```bash
python tools/build.py --system-allocator=on
```

*Note*: System allocator is only supported on 32 bit systems.

**Enable 32bit compressed pointers**

```bash
python tools/build.py --cpointer-32bit=on
```

*Note*: There is no compression/decompression on 32 bit systems, if enabled.

**Change default heap size (512K)**

```bash
python tools/build.py --mem-heap=256
```

If you would like to use more than 512K, then you must enable the 32 bit compressed pointers.

```bash
python tools/build.py --cpointer-32bit=on --mem-heap=1024
```

*Note*: The heap size will be allocated statically at compile time, when JerryScript memory
allocator is used.

**To build with libfuzzer support**

```bash
CC=clang python tools/build.py --libfuzzer=on --compile-flag=-fsanitize=address --lto=off
```

Check the documentation of libfuzzer to get the runtime settings of the created fuzzer
binary: https://llvm.org/docs/LibFuzzer.html.

**To get a list of all the available buildoptions for Linux**

```bash
python tools/build.py --help
```

## Checking patch

```bash
python tools/run-tests.py --precommit
```

### Running only one type of test

**To run build option tests**

```bash
python tools/run-tests.py --buildoption-test
```

**To run unittests**

```bash
python tools/run-tests.py --unittests
```

**To run jerry-tests**

```bash
python tools/run-tests.py --jerry-tests
```

**To run signed-off check**

```bash
python tools/run-tests.py --check-signed-off
```

**To run cppcheck**

```bash
python tools/run-tests.py --check-cppcheck
```

**To run format check**

```bash
python tools/run-tests.py --check-format
```

**To get a list of all the available test options**

```bash
python tools/run-tests.py --help
```
