# [RustCrypto]: RFC6979 Deterministic Signatures

[![crate][crate-image]][crate-link]
[![Docs][docs-image]][docs-link]
[![Build Status][build-image]][build-link]
![Apache2/MIT licensed][license-image]
![MSRV][rustc-image]
[![Project Chat][chat-image]][chat-link]

Pure Rust implementation of RFC6979: Deterministic Usage of the
Digital Signature Algorithm (DSA) and Elliptic Curve Digital Signature Algorithm (ECDSA).

Algorithm described in RFC 6979 § 3.2:
<https://tools.ietf.org/html/rfc6979#section-3>

[Documentation][docs-link]

## Minimum Supported Rust Version

This crate requires **Rust 1.57** at a minimum.

We may change the MSRV in the future, but it will be accompanied by a minor
version bump.

## License

All crates licensed under either of

 * [Apache License, Version 2.0](http://www.apache.org/licenses/LICENSE-2.0)
 * [MIT license](http://opensource.org/licenses/MIT)

at your option.

### Contribution

Unless you explicitly state otherwise, any contribution intentionally submitted
for inclusion in the work by you, as defined in the Apache-2.0 license, shall be
dual licensed as above, without any additional terms or conditions.

[//]: # (badges)

[crate-image]: https://buildstats.info/crate/rfc6979
[crate-link]: https://crates.io/crates/rfc6979
[docs-image]: https://docs.rs/rfc6979/badge.svg
[docs-link]: https://docs.rs/rfc6979/
[build-image]: https://github.com/RustCrypto/signatures/actions/workflows/rfc6979.yml/badge.svg
[build-link]: https://github.com/RustCrypto/signatures/actions/workflows/rfc6979.yml
[license-image]: https://img.shields.io/badge/license-Apache2.0/MIT-blue.svg
[rustc-image]: https://img.shields.io/badge/rustc-1.57+-blue.svg
[chat-image]: https://img.shields.io/badge/zulip-join_chat-blue.svg
[chat-link]: https://rustcrypto.zulipchat.com/#narrow/stream/260048-signatures

[//]: # (links)

[RustCrypto]: https://github.com/RustCrypto
