// Code generated by go-swagger; DO NOT EDIT.

//
// Copyright 2021 The Sigstore Authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package entries

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/sigstore/rekor/pkg/generated/models"
)

// SearchLogQueryReader is a Reader for the SearchLogQuery structure.
type SearchLogQueryReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SearchLogQueryReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSearchLogQueryOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewSearchLogQueryBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 422:
		result := NewSearchLogQueryUnprocessableEntity()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		result := NewSearchLogQueryDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSearchLogQueryOK creates a SearchLogQueryOK with default headers values
func NewSearchLogQueryOK() *SearchLogQueryOK {
	return &SearchLogQueryOK{}
}

/*
SearchLogQueryOK describes a response with status code 200, with default header values.

Returns zero or more entries from the transparency log, according to how many were included in request query
*/
type SearchLogQueryOK struct {
	Payload []models.LogEntry
}

// IsSuccess returns true when this search log query o k response has a 2xx status code
func (o *SearchLogQueryOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this search log query o k response has a 3xx status code
func (o *SearchLogQueryOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this search log query o k response has a 4xx status code
func (o *SearchLogQueryOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this search log query o k response has a 5xx status code
func (o *SearchLogQueryOK) IsServerError() bool {
	return false
}

// IsCode returns true when this search log query o k response a status code equal to that given
func (o *SearchLogQueryOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the search log query o k response
func (o *SearchLogQueryOK) Code() int {
	return 200
}

func (o *SearchLogQueryOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /api/v1/log/entries/retrieve][%d] searchLogQueryOK %s", 200, payload)
}

func (o *SearchLogQueryOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /api/v1/log/entries/retrieve][%d] searchLogQueryOK %s", 200, payload)
}

func (o *SearchLogQueryOK) GetPayload() []models.LogEntry {
	return o.Payload
}

func (o *SearchLogQueryOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSearchLogQueryBadRequest creates a SearchLogQueryBadRequest with default headers values
func NewSearchLogQueryBadRequest() *SearchLogQueryBadRequest {
	return &SearchLogQueryBadRequest{}
}

/*
SearchLogQueryBadRequest describes a response with status code 400, with default header values.

The content supplied to the server was invalid
*/
type SearchLogQueryBadRequest struct {
	Payload *models.Error
}

// IsSuccess returns true when this search log query bad request response has a 2xx status code
func (o *SearchLogQueryBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this search log query bad request response has a 3xx status code
func (o *SearchLogQueryBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this search log query bad request response has a 4xx status code
func (o *SearchLogQueryBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this search log query bad request response has a 5xx status code
func (o *SearchLogQueryBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this search log query bad request response a status code equal to that given
func (o *SearchLogQueryBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the search log query bad request response
func (o *SearchLogQueryBadRequest) Code() int {
	return 400
}

func (o *SearchLogQueryBadRequest) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /api/v1/log/entries/retrieve][%d] searchLogQueryBadRequest %s", 400, payload)
}

func (o *SearchLogQueryBadRequest) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /api/v1/log/entries/retrieve][%d] searchLogQueryBadRequest %s", 400, payload)
}

func (o *SearchLogQueryBadRequest) GetPayload() *models.Error {
	return o.Payload
}

func (o *SearchLogQueryBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSearchLogQueryUnprocessableEntity creates a SearchLogQueryUnprocessableEntity with default headers values
func NewSearchLogQueryUnprocessableEntity() *SearchLogQueryUnprocessableEntity {
	return &SearchLogQueryUnprocessableEntity{}
}

/*
SearchLogQueryUnprocessableEntity describes a response with status code 422, with default header values.

The server understood the request but is unable to process the contained instructions
*/
type SearchLogQueryUnprocessableEntity struct {
	Payload *models.Error
}

// IsSuccess returns true when this search log query unprocessable entity response has a 2xx status code
func (o *SearchLogQueryUnprocessableEntity) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this search log query unprocessable entity response has a 3xx status code
func (o *SearchLogQueryUnprocessableEntity) IsRedirect() bool {
	return false
}

// IsClientError returns true when this search log query unprocessable entity response has a 4xx status code
func (o *SearchLogQueryUnprocessableEntity) IsClientError() bool {
	return true
}

// IsServerError returns true when this search log query unprocessable entity response has a 5xx status code
func (o *SearchLogQueryUnprocessableEntity) IsServerError() bool {
	return false
}

// IsCode returns true when this search log query unprocessable entity response a status code equal to that given
func (o *SearchLogQueryUnprocessableEntity) IsCode(code int) bool {
	return code == 422
}

// Code gets the status code for the search log query unprocessable entity response
func (o *SearchLogQueryUnprocessableEntity) Code() int {
	return 422
}

func (o *SearchLogQueryUnprocessableEntity) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /api/v1/log/entries/retrieve][%d] searchLogQueryUnprocessableEntity %s", 422, payload)
}

func (o *SearchLogQueryUnprocessableEntity) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /api/v1/log/entries/retrieve][%d] searchLogQueryUnprocessableEntity %s", 422, payload)
}

func (o *SearchLogQueryUnprocessableEntity) GetPayload() *models.Error {
	return o.Payload
}

func (o *SearchLogQueryUnprocessableEntity) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSearchLogQueryDefault creates a SearchLogQueryDefault with default headers values
func NewSearchLogQueryDefault(code int) *SearchLogQueryDefault {
	return &SearchLogQueryDefault{
		_statusCode: code,
	}
}

/*
SearchLogQueryDefault describes a response with status code -1, with default header values.

There was an internal error in the server while processing the request
*/
type SearchLogQueryDefault struct {
	_statusCode int

	Payload *models.Error
}

// IsSuccess returns true when this search log query default response has a 2xx status code
func (o *SearchLogQueryDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this search log query default response has a 3xx status code
func (o *SearchLogQueryDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this search log query default response has a 4xx status code
func (o *SearchLogQueryDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this search log query default response has a 5xx status code
func (o *SearchLogQueryDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this search log query default response a status code equal to that given
func (o *SearchLogQueryDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the search log query default response
func (o *SearchLogQueryDefault) Code() int {
	return o._statusCode
}

func (o *SearchLogQueryDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /api/v1/log/entries/retrieve][%d] searchLogQuery default %s", o._statusCode, payload)
}

func (o *SearchLogQueryDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /api/v1/log/entries/retrieve][%d] searchLogQuery default %s", o._statusCode, payload)
}

func (o *SearchLogQueryDefault) GetPayload() *models.Error {
	return o.Payload
}

func (o *SearchLogQueryDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
