# 🌱 PlantUML Support

Thank you for using PlantUML! If you need assistance or have questions, please refer to the following resources:

## Where to Get Support

### GitHub Issues

- For reporting bugs or issues, open an [issue on GitHub](https://github.com/plantuml/plantuml/issues).
	- When submitting an issue, provide clear steps to reproduce the problem and include your PlantUML version.
- Before creating a new issue, search the existing ones on [GitHub](https://github.com/plantuml/plantuml/issues) to see if your problem has already been addressed.

### Community Forum

- Visit our [Community Forum](https://forum.plantuml.net/) for discussions, FAQs, and community support.
- Check for existing threads to see if your question has already been answered.

### Discord

- Feel free to ask questions on our official [Discord](https://discord.com/invite/sXhzexAQGh) server.

## Asking Questions

If you have a question about using PlantUML:

- Search through the [official documentation](https://plantuml.com/) and available resources before asking.
- Feel free to ask questions on the GitHub issues or the Community Forum after performing initial research.
- Provide as much detail as possible when asking questions to receive effective assistance.

## Contributing

We welcome contributions to PlantUML! If you're interested in contributing:

### Reporting Bugs

- Ensure you're using the latest version and search for existing issues on GitHub or the Community Forum before reporting a bug.
- Submit a bug report on [GitHub](https://github.com/plantuml/plantuml/issues) with clear steps to reproduce and your environment details.

### Suggesting Enhancements

- Search existing enhancement suggestions on GitHub or the Community Forum before submitting a new one.
- Submit your enhancement suggestion with a clear title and detailed description on [GitHub](https://github.com/plantuml/plantuml/issues).

### Your First Code Contribution

- Review our [contributing guide](CONTRIBUTING.md) to get started with code contributions.
- If you're new to contributing, consider tackling issues labeled as 'good first issue' or 'help wanted'.

## Additional Resources

- For comprehensive documentation, refer to the [official PlantUML Javadoc](https://plantuml.github.io/plantuml/javadoc).
- See also the [_Jacoco_ Code Coverage Report](https://plantuml.github.io/plantuml/jacoco).
- Explore the [GitHub issues](https://github.com/plantuml/plantuml/issues/) for discussions and known problems.

## 🧑‍🤝‍🧑 Community Support

Feel free to engage with the PlantUML community on GitHub and the Community Forum.

Thank you for being a part of the PlantUML community!
