// Code generated by internal/gen/main.go. DO NOT EDIT.

package displaywidth

import "github.com/clipperhouse/stringish"

// property represents the properties of a character as bit flags
// The underlying type is uint8 since we only use 4 bits for flags.
type property uint8

const (
	// Always 2 wide
	_East_Asian_Full_Wide property = 1 << iota
	// Width depends on EastAsianWidth option
	_East_Asian_Ambiguous
	// Width depends on EastAsianWidth and StrictEmojiNeutral options
	_Emoji
	// Always 0 width, includes combining marks, control characters, non-printable, etc
	_ZeroWidth
)

// lookup returns the trie value for the first UTF-8 encoding in s and
// the width in bytes of this encoding. The size will be 0 if s does not
// hold enough bytes to complete the encoding. len(s) must be greater than 0.
func lookup[T stringish.Interface](s T) (v uint8, sz int) {
	c0 := s[0]
	switch {
	case c0 < 0x80: // is ASCII
		return stringWidthValues[c0], 1
	case c0 < 0xC2:
		return 0, 1 // Illegal UTF-8: not a starter, not ASCII.
	case c0 < 0xE0: // 2-byte UTF-8
		if len(s) < 2 {
			return 0, 0
		}
		i := stringWidthIndex[c0]
		c1 := s[1]
		if c1 < 0x80 || 0xC0 <= c1 {
			return 0, 1 // Illegal UTF-8: not a continuation byte.
		}
		return lookupValue(uint32(i), c1), 2
	case c0 < 0xF0: // 3-byte UTF-8
		if len(s) < 3 {
			return 0, 0
		}
		i := stringWidthIndex[c0]
		c1 := s[1]
		if c1 < 0x80 || 0xC0 <= c1 {
			return 0, 1 // Illegal UTF-8: not a continuation byte.
		}
		o := uint32(i)<<6 + uint32(c1)
		i = stringWidthIndex[o]
		c2 := s[2]
		if c2 < 0x80 || 0xC0 <= c2 {
			return 0, 2 // Illegal UTF-8: not a continuation byte.
		}
		return lookupValue(uint32(i), c2), 3
	case c0 < 0xF8: // 4-byte UTF-8
		if len(s) < 4 {
			return 0, 0
		}
		i := stringWidthIndex[c0]
		c1 := s[1]
		if c1 < 0x80 || 0xC0 <= c1 {
			return 0, 1 // Illegal UTF-8: not a continuation byte.
		}
		o := uint32(i)<<6 + uint32(c1)
		i = stringWidthIndex[o]
		c2 := s[2]
		if c2 < 0x80 || 0xC0 <= c2 {
			return 0, 2 // Illegal UTF-8: not a continuation byte.
		}
		o = uint32(i)<<6 + uint32(c2)
		i = stringWidthIndex[o]
		c3 := s[3]
		if c3 < 0x80 || 0xC0 <= c3 {
			return 0, 3 // Illegal UTF-8: not a continuation byte.
		}
		return lookupValue(uint32(i), c3), 4
	}
	// Illegal rune
	return 0, 1
}

// stringWidthTrie. Total size: 18432 bytes (18.00 KiB). Checksum: dea3fa00409f1ec3.
// type stringWidthTrie struct { }

// func newStringWidthTrie(i int) *stringWidthTrie {
// 	return &stringWidthTrie{}
// }

// lookupValue determines the type of block n and looks up the value for b.
func lookupValue(n uint32, b byte) uint8 {
	switch {
	default:
		return uint8(stringWidthValues[n<<6+uint32(b)])
	}
}

// stringWidthValues: 257 blocks, 16448 entries, 16448 bytes
// The third block is the zero block.
var stringWidthValues = [16448]uint8{
	// Block 0x0, offset 0x0
	// Block 0x1, offset 0x40
	// Block 0x2, offset 0x80
	// Block 0x3, offset 0xc0
	0xc0: 0x0008, 0xc1: 0x0008, 0xc2: 0x0008, 0xc3: 0x0008, 0xc4: 0x0008, 0xc5: 0x0008,
	0xc6: 0x0008, 0xc7: 0x0008, 0xc8: 0x0008, 0xc9: 0x0008, 0xca: 0x0008, 0xcb: 0x0008,
	0xcc: 0x0008, 0xcd: 0x0008, 0xce: 0x0008, 0xcf: 0x0008, 0xd0: 0x0008, 0xd1: 0x0008,
	0xd2: 0x0008, 0xd3: 0x0008, 0xd4: 0x0008, 0xd5: 0x0008, 0xd6: 0x0008, 0xd7: 0x0008,
	0xd8: 0x0008, 0xd9: 0x0008, 0xda: 0x0008, 0xdb: 0x0008, 0xdc: 0x0008, 0xdd: 0x0008,
	0xde: 0x0008, 0xdf: 0x0008, 0xe1: 0x0002,
	0xe4: 0x0002, 0xe7: 0x0002, 0xe8: 0x0002,
	0xea: 0x0002, 0xed: 0x000a, 0xee: 0x0002,
	0xf0: 0x0002, 0xf1: 0x0002, 0xf2: 0x0002, 0xf3: 0x0002, 0xf4: 0x0002,
	0xf6: 0x0002, 0xf7: 0x0002, 0xf8: 0x0002, 0xf9: 0x0002, 0xfa: 0x0002,
	0xfc: 0x0002, 0xfd: 0x0002, 0xfe: 0x0002, 0xff: 0x0002,
	// Block 0x4, offset 0x100
	0x106: 0x0002,
	0x110: 0x0002,
	0x117: 0x0002,
	0x118: 0x0002,
	0x11e: 0x0002, 0x11f: 0x0002, 0x120: 0x0002, 0x121: 0x0002,
	0x126: 0x0002, 0x128: 0x0002, 0x129: 0x0002,
	0x12a: 0x0002, 0x12c: 0x0002, 0x12d: 0x0002,
	0x130: 0x0002, 0x132: 0x0002, 0x133: 0x0002,
	0x137: 0x0002, 0x138: 0x0002, 0x139: 0x0002, 0x13a: 0x0002,
	0x13c: 0x0002, 0x13e: 0x0002,
	// Block 0x5, offset 0x140
	0x141: 0x0002,
	0x151: 0x0002,
	0x153: 0x0002,
	0x15b: 0x0002,
	0x166: 0x0002, 0x167: 0x0002,
	0x16b: 0x0002,
	0x171: 0x0002, 0x172: 0x0002, 0x173: 0x0002,
	0x178: 0x0002,
	0x17f: 0x0002,
	// Block 0x6, offset 0x180
	0x180: 0x0002, 0x181: 0x0002, 0x182: 0x0002, 0x184: 0x0002,
	0x188: 0x0002, 0x189: 0x0002, 0x18a: 0x0002, 0x18b: 0x0002,
	0x18d: 0x0002,
	0x192: 0x0002, 0x193: 0x0002,
	0x1a6: 0x0002, 0x1a7: 0x0002,
	0x1ab: 0x0002,
	// Block 0x7, offset 0x1c0
	0x1ce: 0x0002, 0x1d0: 0x0002,
	0x1d2: 0x0002, 0x1d4: 0x0002, 0x1d6: 0x0002,
	0x1d8: 0x0002, 0x1da: 0x0002, 0x1dc: 0x0002,
	// Block 0x8, offset 0x200
	0x211: 0x0002,
	0x221: 0x0002,
	// Block 0x9, offset 0x240
	0x244: 0x0002,
	0x247: 0x0002, 0x249: 0x0002, 0x24a: 0x0002, 0x24b: 0x0002,
	0x24d: 0x0002, 0x250: 0x0002,
	0x258: 0x0002, 0x259: 0x0002, 0x25a: 0x0002, 0x25b: 0x0002, 0x25d: 0x0002,
	0x25f: 0x0002,
	// Block 0xa, offset 0x280
	0x280: 0x000a, 0x281: 0x000a, 0x282: 0x000a, 0x283: 0x000a, 0x284: 0x000a, 0x285: 0x000a,
	0x286: 0x000a, 0x287: 0x000a, 0x288: 0x000a, 0x289: 0x000a, 0x28a: 0x000a, 0x28b: 0x000a,
	0x28c: 0x000a, 0x28d: 0x000a, 0x28e: 0x000a, 0x28f: 0x000a, 0x290: 0x000a, 0x291: 0x000a,
	0x292: 0x000a, 0x293: 0x000a, 0x294: 0x000a, 0x295: 0x000a, 0x296: 0x000a, 0x297: 0x000a,
	0x298: 0x000a, 0x299: 0x000a, 0x29a: 0x000a, 0x29b: 0x000a, 0x29c: 0x000a, 0x29d: 0x000a,
	0x29e: 0x000a, 0x29f: 0x000a, 0x2a0: 0x000a, 0x2a1: 0x000a, 0x2a2: 0x000a, 0x2a3: 0x000a,
	0x2a4: 0x000a, 0x2a5: 0x000a, 0x2a6: 0x000a, 0x2a7: 0x000a, 0x2a8: 0x000a, 0x2a9: 0x000a,
	0x2aa: 0x000a, 0x2ab: 0x000a, 0x2ac: 0x000a, 0x2ad: 0x000a, 0x2ae: 0x000a, 0x2af: 0x000a,
	0x2b0: 0x000a, 0x2b1: 0x000a, 0x2b2: 0x000a, 0x2b3: 0x000a, 0x2b4: 0x000a, 0x2b5: 0x000a,
	0x2b6: 0x000a, 0x2b7: 0x000a, 0x2b8: 0x000a, 0x2b9: 0x000a, 0x2ba: 0x000a, 0x2bb: 0x000a,
	0x2bc: 0x000a, 0x2bd: 0x000a, 0x2be: 0x000a, 0x2bf: 0x000a,
	// Block 0xb, offset 0x2c0
	0x2c0: 0x000a, 0x2c1: 0x000a, 0x2c2: 0x000a, 0x2c3: 0x000a, 0x2c4: 0x000a, 0x2c5: 0x000a,
	0x2c6: 0x000a, 0x2c7: 0x000a, 0x2c8: 0x000a, 0x2c9: 0x000a, 0x2ca: 0x000a, 0x2cb: 0x000a,
	0x2cc: 0x000a, 0x2cd: 0x000a, 0x2ce: 0x000a, 0x2cf: 0x000a, 0x2d0: 0x000a, 0x2d1: 0x000a,
	0x2d2: 0x000a, 0x2d3: 0x000a, 0x2d4: 0x000a, 0x2d5: 0x000a, 0x2d6: 0x000a, 0x2d7: 0x000a,
	0x2d8: 0x000a, 0x2d9: 0x000a, 0x2da: 0x000a, 0x2db: 0x000a, 0x2dc: 0x000a, 0x2dd: 0x000a,
	0x2de: 0x000a, 0x2df: 0x000a, 0x2e0: 0x000a, 0x2e1: 0x000a, 0x2e2: 0x000a, 0x2e3: 0x000a,
	0x2e4: 0x000a, 0x2e5: 0x000a, 0x2e6: 0x000a, 0x2e7: 0x000a, 0x2e8: 0x000a, 0x2e9: 0x000a,
	0x2ea: 0x000a, 0x2eb: 0x000a, 0x2ec: 0x000a, 0x2ed: 0x000a, 0x2ee: 0x000a, 0x2ef: 0x000a,
	// Block 0xc, offset 0x300
	0x311: 0x0002,
	0x312: 0x0002, 0x313: 0x0002, 0x314: 0x0002, 0x315: 0x0002, 0x316: 0x0002, 0x317: 0x0002,
	0x318: 0x0002, 0x319: 0x0002, 0x31a: 0x0002, 0x31b: 0x0002, 0x31c: 0x0002, 0x31d: 0x0002,
	0x31e: 0x0002, 0x31f: 0x0002, 0x320: 0x0002, 0x321: 0x0002, 0x323: 0x0002,
	0x324: 0x0002, 0x325: 0x0002, 0x326: 0x0002, 0x327: 0x0002, 0x328: 0x0002, 0x329: 0x0002,
	0x331: 0x0002, 0x332: 0x0002, 0x333: 0x0002, 0x334: 0x0002, 0x335: 0x0002,
	0x336: 0x0002, 0x337: 0x0002, 0x338: 0x0002, 0x339: 0x0002, 0x33a: 0x0002, 0x33b: 0x0002,
	0x33c: 0x0002, 0x33d: 0x0002, 0x33e: 0x0002, 0x33f: 0x0002,
	// Block 0xd, offset 0x340
	0x340: 0x0002, 0x341: 0x0002, 0x343: 0x0002, 0x344: 0x0002, 0x345: 0x0002,
	0x346: 0x0002, 0x347: 0x0002, 0x348: 0x0002, 0x349: 0x0002,
	// Block 0xe, offset 0x380
	0x381: 0x0002,
	0x390: 0x0002, 0x391: 0x0002,
	0x392: 0x0002, 0x393: 0x0002, 0x394: 0x0002, 0x395: 0x0002, 0x396: 0x0002, 0x397: 0x0002,
	0x398: 0x0002, 0x399: 0x0002, 0x39a: 0x0002, 0x39b: 0x0002, 0x39c: 0x0002, 0x39d: 0x0002,
	0x39e: 0x0002, 0x39f: 0x0002, 0x3a0: 0x0002, 0x3a1: 0x0002, 0x3a2: 0x0002, 0x3a3: 0x0002,
	0x3a4: 0x0002, 0x3a5: 0x0002, 0x3a6: 0x0002, 0x3a7: 0x0002, 0x3a8: 0x0002, 0x3a9: 0x0002,
	0x3aa: 0x0002, 0x3ab: 0x0002, 0x3ac: 0x0002, 0x3ad: 0x0002, 0x3ae: 0x0002, 0x3af: 0x0002,
	0x3b0: 0x0002, 0x3b1: 0x0002, 0x3b2: 0x0002, 0x3b3: 0x0002, 0x3b4: 0x0002, 0x3b5: 0x0002,
	0x3b6: 0x0002, 0x3b7: 0x0002, 0x3b8: 0x0002, 0x3b9: 0x0002, 0x3ba: 0x0002, 0x3bb: 0x0002,
	0x3bc: 0x0002, 0x3bd: 0x0002, 0x3be: 0x0002, 0x3bf: 0x0002,
	// Block 0xf, offset 0x3c0
	0x3c0: 0x0002, 0x3c1: 0x0002, 0x3c2: 0x0002, 0x3c3: 0x0002, 0x3c4: 0x0002, 0x3c5: 0x0002,
	0x3c6: 0x0002, 0x3c7: 0x0002, 0x3c8: 0x0002, 0x3c9: 0x0002, 0x3ca: 0x0002, 0x3cb: 0x0002,
	0x3cc: 0x0002, 0x3cd: 0x0002, 0x3ce: 0x0002, 0x3cf: 0x0002, 0x3d1: 0x0002,
	// Block 0x10, offset 0x400
	0x403: 0x0008, 0x404: 0x0008, 0x405: 0x0008,
	0x406: 0x0008, 0x407: 0x0008, 0x408: 0x0008, 0x409: 0x0008,
	// Block 0x11, offset 0x440
	0x451: 0x0008,
	0x452: 0x0008, 0x453: 0x0008, 0x454: 0x0008, 0x455: 0x0008, 0x456: 0x0008, 0x457: 0x0008,
	0x458: 0x0008, 0x459: 0x0008, 0x45a: 0x0008, 0x45b: 0x0008, 0x45c: 0x0008, 0x45d: 0x0008,
	0x45e: 0x0008, 0x45f: 0x0008, 0x460: 0x0008, 0x461: 0x0008, 0x462: 0x0008, 0x463: 0x0008,
	0x464: 0x0008, 0x465: 0x0008, 0x466: 0x0008, 0x467: 0x0008, 0x468: 0x0008, 0x469: 0x0008,
	0x46a: 0x0008, 0x46b: 0x0008, 0x46c: 0x0008, 0x46d: 0x0008, 0x46e: 0x0008, 0x46f: 0x0008,
	0x470: 0x0008, 0x471: 0x0008, 0x472: 0x0008, 0x473: 0x0008, 0x474: 0x0008, 0x475: 0x0008,
	0x476: 0x0008, 0x477: 0x0008, 0x478: 0x0008, 0x479: 0x0008, 0x47a: 0x0008, 0x47b: 0x0008,
	0x47c: 0x0008, 0x47d: 0x0008, 0x47f: 0x0008,
	// Block 0x12, offset 0x480
	0x481: 0x0008, 0x482: 0x0008, 0x484: 0x0008, 0x485: 0x0008,
	0x487: 0x0008,
	// Block 0x13, offset 0x4c0
	0x4c0: 0x0008, 0x4c1: 0x0008, 0x4c2: 0x0008, 0x4c3: 0x0008, 0x4c4: 0x0008, 0x4c5: 0x0008,
	0x4d0: 0x0008, 0x4d1: 0x0008,
	0x4d2: 0x0008, 0x4d3: 0x0008, 0x4d4: 0x0008, 0x4d5: 0x0008, 0x4d6: 0x0008, 0x4d7: 0x0008,
	0x4d8: 0x0008, 0x4d9: 0x0008, 0x4da: 0x0008, 0x4dc: 0x0008,
	// Block 0x14, offset 0x500
	0x50b: 0x0008,
	0x50c: 0x0008, 0x50d: 0x0008, 0x50e: 0x0008, 0x50f: 0x0008, 0x510: 0x0008, 0x511: 0x0008,
	0x512: 0x0008, 0x513: 0x0008, 0x514: 0x0008, 0x515: 0x0008, 0x516: 0x0008, 0x517: 0x0008,
	0x518: 0x0008, 0x519: 0x0008, 0x51a: 0x0008, 0x51b: 0x0008, 0x51c: 0x0008, 0x51d: 0x0008,
	0x51e: 0x0008, 0x51f: 0x0008,
	0x530: 0x0008,
	// Block 0x15, offset 0x540
	0x556: 0x0008, 0x557: 0x0008,
	0x558: 0x0008, 0x559: 0x0008, 0x55a: 0x0008, 0x55b: 0x0008, 0x55c: 0x0008, 0x55d: 0x0008,
	0x55f: 0x0008, 0x560: 0x0008, 0x561: 0x0008, 0x562: 0x0008, 0x563: 0x0008,
	0x564: 0x0008, 0x567: 0x0008, 0x568: 0x0008,
	0x56a: 0x0008, 0x56b: 0x0008, 0x56c: 0x0008, 0x56d: 0x0008,
	// Block 0x16, offset 0x580
	0x58f: 0x0008, 0x591: 0x0008,
	0x5b0: 0x0008, 0x5b1: 0x0008, 0x5b2: 0x0008, 0x5b3: 0x0008, 0x5b4: 0x0008, 0x5b5: 0x0008,
	0x5b6: 0x0008, 0x5b7: 0x0008, 0x5b8: 0x0008, 0x5b9: 0x0008, 0x5ba: 0x0008, 0x5bb: 0x0008,
	0x5bc: 0x0008, 0x5bd: 0x0008, 0x5be: 0x0008, 0x5bf: 0x0008,
	// Block 0x17, offset 0x5c0
	0x5c0: 0x0008, 0x5c1: 0x0008, 0x5c2: 0x0008, 0x5c3: 0x0008, 0x5c4: 0x0008, 0x5c5: 0x0008,
	0x5c6: 0x0008, 0x5c7: 0x0008, 0x5c8: 0x0008, 0x5c9: 0x0008, 0x5ca: 0x0008,
	// Block 0x18, offset 0x600
	0x626: 0x0008, 0x627: 0x0008, 0x628: 0x0008, 0x629: 0x0008,
	0x62a: 0x0008, 0x62b: 0x0008, 0x62c: 0x0008, 0x62d: 0x0008, 0x62e: 0x0008, 0x62f: 0x0008,
	0x630: 0x0008,
	// Block 0x19, offset 0x640
	0x66b: 0x0008, 0x66c: 0x0008, 0x66d: 0x0008, 0x66e: 0x0008, 0x66f: 0x0008,
	0x670: 0x0008, 0x671: 0x0008, 0x672: 0x0008, 0x673: 0x0008,
	0x67d: 0x0008,
	// Block 0x1a, offset 0x680
	0x696: 0x0008, 0x697: 0x0008,
	0x698: 0x0008, 0x699: 0x0008, 0x69b: 0x0008, 0x69c: 0x0008, 0x69d: 0x0008,
	0x69e: 0x0008, 0x69f: 0x0008, 0x6a0: 0x0008, 0x6a1: 0x0008, 0x6a2: 0x0008, 0x6a3: 0x0008,
	0x6a5: 0x0008, 0x6a6: 0x0008, 0x6a7: 0x0008, 0x6a9: 0x0008,
	0x6aa: 0x0008, 0x6ab: 0x0008, 0x6ac: 0x0008, 0x6ad: 0x0008,
	// Block 0x1b, offset 0x6c0
	0x6d9: 0x0008, 0x6da: 0x0008, 0x6db: 0x0008,
	// Block 0x1c, offset 0x700
	0x710: 0x0008, 0x711: 0x0008,
	0x718: 0x0008, 0x719: 0x0008, 0x71a: 0x0008, 0x71b: 0x0008, 0x71c: 0x0008, 0x71d: 0x0008,
	0x71e: 0x0008, 0x71f: 0x0008,
	// Block 0x1d, offset 0x740
	0x74a: 0x0008, 0x74b: 0x0008,
	0x74c: 0x0008, 0x74d: 0x0008, 0x74e: 0x0008, 0x74f: 0x0008, 0x750: 0x0008, 0x751: 0x0008,
	0x752: 0x0008, 0x753: 0x0008, 0x754: 0x0008, 0x755: 0x0008, 0x756: 0x0008, 0x757: 0x0008,
	0x758: 0x0008, 0x759: 0x0008, 0x75a: 0x0008, 0x75b: 0x0008, 0x75c: 0x0008, 0x75d: 0x0008,
	0x75e: 0x0008, 0x75f: 0x0008, 0x760: 0x0008, 0x761: 0x0008, 0x762: 0x0008, 0x763: 0x0008,
	0x764: 0x0008, 0x765: 0x0008, 0x766: 0x0008, 0x767: 0x0008, 0x768: 0x0008, 0x769: 0x0008,
	0x76a: 0x0008, 0x76b: 0x0008, 0x76c: 0x0008, 0x76d: 0x0008, 0x76e: 0x0008, 0x76f: 0x0008,
	0x770: 0x0008, 0x771: 0x0008, 0x772: 0x0008, 0x773: 0x0008, 0x774: 0x0008, 0x775: 0x0008,
	0x776: 0x0008, 0x777: 0x0008, 0x778: 0x0008, 0x779: 0x0008, 0x77a: 0x0008, 0x77b: 0x0008,
	0x77c: 0x0008, 0x77d: 0x0008, 0x77e: 0x0008, 0x77f: 0x0008,
	// Block 0x1e, offset 0x780
	0x780: 0x0008, 0x781: 0x0008, 0x782: 0x0008,
	0x7ba: 0x0008,
	0x7bc: 0x0008,
	// Block 0x1f, offset 0x7c0
	0x7c1: 0x0008, 0x7c2: 0x0008, 0x7c3: 0x0008, 0x7c4: 0x0008, 0x7c5: 0x0008,
	0x7c6: 0x0008, 0x7c7: 0x0008, 0x7c8: 0x0008,
	0x7cd: 0x0008, 0x7d1: 0x0008,
	0x7d2: 0x0008, 0x7d3: 0x0008, 0x7d4: 0x0008, 0x7d5: 0x0008, 0x7d6: 0x0008, 0x7d7: 0x0008,
	0x7e2: 0x0008, 0x7e3: 0x0008,
	// Block 0x20, offset 0x800
	0x801: 0x0008,
	0x83c: 0x0008,
	// Block 0x21, offset 0x840
	0x841: 0x0008, 0x842: 0x0008, 0x843: 0x0008, 0x844: 0x0008,
	0x84d: 0x0008,
	0x862: 0x0008, 0x863: 0x0008,
	0x87e: 0x0008,
	// Block 0x22, offset 0x880
	0x881: 0x0008, 0x882: 0x0008,
	0x8bc: 0x0008,
	// Block 0x23, offset 0x8c0
	0x8c1: 0x0008, 0x8c2: 0x0008,
	0x8c7: 0x0008, 0x8c8: 0x0008, 0x8cb: 0x0008,
	0x8cc: 0x0008, 0x8cd: 0x0008, 0x8d1: 0x0008,
	0x8f0: 0x0008, 0x8f1: 0x0008, 0x8f5: 0x0008,
	// Block 0x24, offset 0x900
	0x901: 0x0008, 0x902: 0x0008, 0x903: 0x0008, 0x904: 0x0008, 0x905: 0x0008,
	0x907: 0x0008, 0x908: 0x0008,
	0x90d: 0x0008,
	0x922: 0x0008, 0x923: 0x0008,
	0x93a: 0x0008, 0x93b: 0x0008,
	0x93c: 0x0008, 0x93d: 0x0008, 0x93e: 0x0008, 0x93f: 0x0008,
	// Block 0x25, offset 0x940
	0x941: 0x0008,
	0x97c: 0x0008, 0x97f: 0x0008,
	// Block 0x26, offset 0x980
	0x981: 0x0008, 0x982: 0x0008, 0x983: 0x0008, 0x984: 0x0008,
	0x98d: 0x0008,
	0x995: 0x0008, 0x996: 0x0008,
	0x9a2: 0x0008, 0x9a3: 0x0008,
	// Block 0x27, offset 0x9c0
	0x9c2: 0x0008,
	// Block 0x28, offset 0xa00
	0xa00: 0x0008,
	0xa0d: 0x0008,
	// Block 0x29, offset 0xa40
	0xa40: 0x0008, 0xa44: 0x0008,
	0xa7c: 0x0008, 0xa7e: 0x0008, 0xa7f: 0x0008,
	// Block 0x2a, offset 0xa80
	0xa80: 0x0008,
	0xa86: 0x0008, 0xa87: 0x0008, 0xa88: 0x0008, 0xa8a: 0x0008, 0xa8b: 0x0008,
	0xa8c: 0x0008, 0xa8d: 0x0008,
	0xa95: 0x0008, 0xa96: 0x0008,
	0xaa2: 0x0008, 0xaa3: 0x0008,
	// Block 0x2b, offset 0xac0
	0xac6: 0x0008,
	0xacc: 0x0008, 0xacd: 0x0008,
	0xae2: 0x0008, 0xae3: 0x0008,
	// Block 0x2c, offset 0xb00
	0xb00: 0x0008, 0xb01: 0x0008,
	0xb3b: 0x0008,
	0xb3c: 0x0008,
	// Block 0x2d, offset 0xb40
	0xb41: 0x0008, 0xb42: 0x0008, 0xb43: 0x0008, 0xb44: 0x0008,
	0xb4d: 0x0008,
	0xb62: 0x0008, 0xb63: 0x0008,
	// Block 0x2e, offset 0xb80
	0xb81: 0x0008,
	// Block 0x2f, offset 0xbc0
	0xbca: 0x0008,
	0xbd2: 0x0008, 0xbd3: 0x0008, 0xbd4: 0x0008, 0xbd6: 0x0008,
	// Block 0x30, offset 0xc00
	0xc31: 0x0008, 0xc34: 0x0008, 0xc35: 0x0008,
	0xc36: 0x0008, 0xc37: 0x0008, 0xc38: 0x0008, 0xc39: 0x0008, 0xc3a: 0x0008,
	// Block 0x31, offset 0xc40
	0xc47: 0x0008, 0xc48: 0x0008, 0xc49: 0x0008, 0xc4a: 0x0008, 0xc4b: 0x0008,
	0xc4c: 0x0008, 0xc4d: 0x0008, 0xc4e: 0x0008,
	// Block 0x32, offset 0xc80
	0xcb1: 0x0008, 0xcb4: 0x0008, 0xcb5: 0x0008,
	0xcb6: 0x0008, 0xcb7: 0x0008, 0xcb8: 0x0008, 0xcb9: 0x0008, 0xcba: 0x0008, 0xcbb: 0x0008,
	0xcbc: 0x0008,
	// Block 0x33, offset 0xcc0
	0xcc8: 0x0008, 0xcc9: 0x0008, 0xcca: 0x0008, 0xccb: 0x0008,
	0xccc: 0x0008, 0xccd: 0x0008, 0xcce: 0x0008,
	// Block 0x34, offset 0xd00
	0xd18: 0x0008, 0xd19: 0x0008,
	0xd35: 0x0008,
	0xd37: 0x0008, 0xd39: 0x0008,
	// Block 0x35, offset 0xd40
	0xd71: 0x0008, 0xd72: 0x0008, 0xd73: 0x0008, 0xd74: 0x0008, 0xd75: 0x0008,
	0xd76: 0x0008, 0xd77: 0x0008, 0xd78: 0x0008, 0xd79: 0x0008, 0xd7a: 0x0008, 0xd7b: 0x0008,
	0xd7c: 0x0008, 0xd7d: 0x0008, 0xd7e: 0x0008,
	// Block 0x36, offset 0xd80
	0xd80: 0x0008, 0xd81: 0x0008, 0xd82: 0x0008, 0xd83: 0x0008, 0xd84: 0x0008,
	0xd86: 0x0008, 0xd87: 0x0008,
	0xd8d: 0x0008, 0xd8e: 0x0008, 0xd8f: 0x0008, 0xd90: 0x0008, 0xd91: 0x0008,
	0xd92: 0x0008, 0xd93: 0x0008, 0xd94: 0x0008, 0xd95: 0x0008, 0xd96: 0x0008, 0xd97: 0x0008,
	0xd99: 0x0008, 0xd9a: 0x0008, 0xd9b: 0x0008, 0xd9c: 0x0008, 0xd9d: 0x0008,
	0xd9e: 0x0008, 0xd9f: 0x0008, 0xda0: 0x0008, 0xda1: 0x0008, 0xda2: 0x0008, 0xda3: 0x0008,
	0xda4: 0x0008, 0xda5: 0x0008, 0xda6: 0x0008, 0xda7: 0x0008, 0xda8: 0x0008, 0xda9: 0x0008,
	0xdaa: 0x0008, 0xdab: 0x0008, 0xdac: 0x0008, 0xdad: 0x0008, 0xdae: 0x0008, 0xdaf: 0x0008,
	0xdb0: 0x0008, 0xdb1: 0x0008, 0xdb2: 0x0008, 0xdb3: 0x0008, 0xdb4: 0x0008, 0xdb5: 0x0008,
	0xdb6: 0x0008, 0xdb7: 0x0008, 0xdb8: 0x0008, 0xdb9: 0x0008, 0xdba: 0x0008, 0xdbb: 0x0008,
	0xdbc: 0x0008,
	// Block 0x37, offset 0xdc0
	0xdc6: 0x0008,
	// Block 0x38, offset 0xe00
	0xe2d: 0x0008, 0xe2e: 0x0008, 0xe2f: 0x0008,
	0xe30: 0x0008, 0xe32: 0x0008, 0xe33: 0x0008, 0xe34: 0x0008, 0xe35: 0x0008,
	0xe36: 0x0008, 0xe37: 0x0008, 0xe39: 0x0008, 0xe3a: 0x0008,
	0xe3d: 0x0008, 0xe3e: 0x0008,
	// Block 0x39, offset 0xe40
	0xe58: 0x0008, 0xe59: 0x0008,
	0xe5e: 0x0008, 0xe5f: 0x0008, 0xe60: 0x0008,
	0xe71: 0x0008, 0xe72: 0x0008, 0xe73: 0x0008, 0xe74: 0x0008,
	// Block 0x3a, offset 0xe80
	0xe82: 0x0008, 0xe85: 0x0008,
	0xe86: 0x0008,
	0xe8d: 0x0008,
	0xe9d: 0x0008,
	// Block 0x3b, offset 0xec0
	0xec0: 0x0001, 0xec1: 0x0001, 0xec2: 0x0001, 0xec3: 0x0001, 0xec4: 0x0001, 0xec5: 0x0001,
	0xec6: 0x0001, 0xec7: 0x0001, 0xec8: 0x0001, 0xec9: 0x0001, 0xeca: 0x0001, 0xecb: 0x0001,
	0xecc: 0x0001, 0xecd: 0x0001, 0xece: 0x0001, 0xecf: 0x0001, 0xed0: 0x0001, 0xed1: 0x0001,
	0xed2: 0x0001, 0xed3: 0x0001, 0xed4: 0x0001, 0xed5: 0x0001, 0xed6: 0x0001, 0xed7: 0x0001,
	0xed8: 0x0001, 0xed9: 0x0001, 0xeda: 0x0001, 0xedb: 0x0001, 0xedc: 0x0001, 0xedd: 0x0001,
	0xede: 0x0001, 0xedf: 0x0001, 0xee0: 0x0001, 0xee1: 0x0001, 0xee2: 0x0001, 0xee3: 0x0001,
	0xee4: 0x0001, 0xee5: 0x0001, 0xee6: 0x0001, 0xee7: 0x0001, 0xee8: 0x0001, 0xee9: 0x0001,
	0xeea: 0x0001, 0xeeb: 0x0001, 0xeec: 0x0001, 0xeed: 0x0001, 0xeee: 0x0001, 0xeef: 0x0001,
	0xef0: 0x0001, 0xef1: 0x0001, 0xef2: 0x0001, 0xef3: 0x0001, 0xef4: 0x0001, 0xef5: 0x0001,
	0xef6: 0x0001, 0xef7: 0x0001, 0xef8: 0x0001, 0xef9: 0x0001, 0xefa: 0x0001, 0xefb: 0x0001,
	0xefc: 0x0001, 0xefd: 0x0001, 0xefe: 0x0001, 0xeff: 0x0001,
	// Block 0x3c, offset 0xf00
	0xf00: 0x0001, 0xf01: 0x0001, 0xf02: 0x0001, 0xf03: 0x0001, 0xf04: 0x0001, 0xf05: 0x0001,
	0xf06: 0x0001, 0xf07: 0x0001, 0xf08: 0x0001, 0xf09: 0x0001, 0xf0a: 0x0001, 0xf0b: 0x0001,
	0xf0c: 0x0001, 0xf0d: 0x0001, 0xf0e: 0x0001, 0xf0f: 0x0001, 0xf10: 0x0001, 0xf11: 0x0001,
	0xf12: 0x0001, 0xf13: 0x0001, 0xf14: 0x0001, 0xf15: 0x0001, 0xf16: 0x0001, 0xf17: 0x0001,
	0xf18: 0x0001, 0xf19: 0x0001, 0xf1a: 0x0001, 0xf1b: 0x0001, 0xf1c: 0x0001, 0xf1d: 0x0001,
	0xf1e: 0x0001, 0xf1f: 0x0001,
	// Block 0x3d, offset 0xf40
	0xf5d: 0x0008,
	0xf5e: 0x0008, 0xf5f: 0x0008,
	// Block 0x3e, offset 0xf80
	0xf92: 0x0008, 0xf93: 0x0008, 0xf94: 0x0008,
	0xfb2: 0x0008, 0xfb3: 0x0008,
	// Block 0x3f, offset 0xfc0
	0xfd2: 0x0008, 0xfd3: 0x0008,
	0xff2: 0x0008, 0xff3: 0x0008,
	// Block 0x40, offset 0x1000
	0x1034: 0x0008, 0x1035: 0x0008,
	0x1037: 0x0008, 0x1038: 0x0008, 0x1039: 0x0008, 0x103a: 0x0008, 0x103b: 0x0008,
	0x103c: 0x0008, 0x103d: 0x0008,
	// Block 0x41, offset 0x1040
	0x1046: 0x0008, 0x1049: 0x0008, 0x104a: 0x0008, 0x104b: 0x0008,
	0x104c: 0x0008, 0x104d: 0x0008, 0x104e: 0x0008, 0x104f: 0x0008, 0x1050: 0x0008, 0x1051: 0x0008,
	0x1052: 0x0008, 0x1053: 0x0008,
	0x105d: 0x0008,
	// Block 0x42, offset 0x1080
	0x108b: 0x0008,
	0x108c: 0x0008, 0x108d: 0x0008, 0x108e: 0x0008, 0x108f: 0x0008,
	// Block 0x43, offset 0x10c0
	0x10c5: 0x0008,
	0x10c6: 0x0008,
	0x10e9: 0x0008,
	// Block 0x44, offset 0x1100
	0x1120: 0x0008, 0x1121: 0x0008, 0x1122: 0x0008,
	0x1127: 0x0008, 0x1128: 0x0008,
	0x1132: 0x0008,
	0x1139: 0x0008, 0x113a: 0x0008, 0x113b: 0x0008,
	// Block 0x45, offset 0x1140
	0x1157: 0x0008,
	0x1158: 0x0008, 0x115b: 0x0008,
	// Block 0x46, offset 0x1180
	0x1196: 0x0008,
	0x1198: 0x0008, 0x1199: 0x0008, 0x119a: 0x0008, 0x119b: 0x0008, 0x119c: 0x0008, 0x119d: 0x0008,
	0x119e: 0x0008, 0x11a0: 0x0008, 0x11a2: 0x0008,
	0x11a5: 0x0008, 0x11a6: 0x0008, 0x11a7: 0x0008, 0x11a8: 0x0008, 0x11a9: 0x0008,
	0x11aa: 0x0008, 0x11ab: 0x0008, 0x11ac: 0x0008,
	0x11b3: 0x0008, 0x11b4: 0x0008, 0x11b5: 0x0008,
	0x11b6: 0x0008, 0x11b7: 0x0008, 0x11b8: 0x0008, 0x11b9: 0x0008, 0x11ba: 0x0008, 0x11bb: 0x0008,
	0x11bc: 0x0008, 0x11bf: 0x0008,
	// Block 0x47, offset 0x11c0
	0x11f0: 0x0008, 0x11f1: 0x0008, 0x11f2: 0x0008, 0x11f3: 0x0008, 0x11f4: 0x0008, 0x11f5: 0x0008,
	0x11f6: 0x0008, 0x11f7: 0x0008, 0x11f8: 0x0008, 0x11f9: 0x0008, 0x11fa: 0x0008, 0x11fb: 0x0008,
	0x11fc: 0x0008, 0x11fd: 0x0008, 0x11fe: 0x0008, 0x11ff: 0x0008,
	// Block 0x48, offset 0x1200
	0x1200: 0x0008, 0x1201: 0x0008, 0x1202: 0x0008, 0x1203: 0x0008, 0x1204: 0x0008, 0x1205: 0x0008,
	0x1206: 0x0008, 0x1207: 0x0008, 0x1208: 0x0008, 0x1209: 0x0008, 0x120a: 0x0008, 0x120b: 0x0008,
	0x120c: 0x0008, 0x120d: 0x0008, 0x120e: 0x0008,
	// Block 0x49, offset 0x1240
	0x1240: 0x0008, 0x1241: 0x0008, 0x1242: 0x0008, 0x1243: 0x0008,
	0x1274: 0x0008,
	0x1276: 0x0008, 0x1277: 0x0008, 0x1278: 0x0008, 0x1279: 0x0008, 0x127a: 0x0008,
	0x127c: 0x0008,
	// Block 0x4a, offset 0x1280
	0x1282: 0x0008,
	0x12ab: 0x0008, 0x12ac: 0x0008, 0x12ad: 0x0008, 0x12ae: 0x0008, 0x12af: 0x0008,
	0x12b0: 0x0008, 0x12b1: 0x0008, 0x12b2: 0x0008, 0x12b3: 0x0008,
	// Block 0x4b, offset 0x12c0
	0x12c0: 0x0008, 0x12c1: 0x0008,
	0x12e2: 0x0008, 0x12e3: 0x0008,
	0x12e4: 0x0008, 0x12e5: 0x0008, 0x12e8: 0x0008, 0x12e9: 0x0008,
	0x12eb: 0x0008, 0x12ec: 0x0008, 0x12ed: 0x0008,
	// Block 0x4c, offset 0x1300
	0x1326: 0x0008, 0x1328: 0x0008, 0x1329: 0x0008,
	0x132d: 0x0008, 0x132f: 0x0008,
	0x1330: 0x0008, 0x1331: 0x0008,
	// Block 0x4d, offset 0x1340
	0x136c: 0x0008, 0x136d: 0x0008, 0x136e: 0x0008, 0x136f: 0x0008,
	0x1370: 0x0008, 0x1371: 0x0008, 0x1372: 0x0008, 0x1373: 0x0008,
	0x1376: 0x0008, 0x1377: 0x0008,
	// Block 0x4e, offset 0x1380
	0x1390: 0x0008, 0x1391: 0x0008,
	0x1392: 0x0008, 0x1394: 0x0008, 0x1395: 0x0008, 0x1396: 0x0008, 0x1397: 0x0008,
	0x1398: 0x0008, 0x1399: 0x0008, 0x139a: 0x0008, 0x139b: 0x0008, 0x139c: 0x0008, 0x139d: 0x0008,
	0x139e: 0x0008, 0x139f: 0x0008, 0x13a0: 0x0008, 0x13a2: 0x0008, 0x13a3: 0x0008,
	0x13a4: 0x0008, 0x13a5: 0x0008, 0x13a6: 0x0008, 0x13a7: 0x0008, 0x13a8: 0x0008,
	0x13ad: 0x0008,
	0x13b4: 0x0008,
	0x13b8: 0x0008, 0x13b9: 0x0008,
	// Block 0x4f, offset 0x13c0
	0x13c0: 0x0008, 0x13c1: 0x0008, 0x13c2: 0x0008, 0x13c3: 0x0008, 0x13c4: 0x0008, 0x13c5: 0x0008,
	0x13c6: 0x0008, 0x13c7: 0x0008, 0x13c8: 0x0008, 0x13c9: 0x0008, 0x13ca: 0x0008, 0x13cb: 0x0008,
	0x13cc: 0x0008, 0x13cd: 0x0008, 0x13ce: 0x0008, 0x13cf: 0x0008, 0x13d0: 0x0008, 0x13d1: 0x0008,
	0x13d2: 0x0008, 0x13d3: 0x0008, 0x13d4: 0x0008, 0x13d5: 0x0008, 0x13d6: 0x0008, 0x13d7: 0x0008,
	0x13d8: 0x0008, 0x13d9: 0x0008, 0x13da: 0x0008, 0x13db: 0x0008, 0x13dc: 0x0008, 0x13dd: 0x0008,
	0x13de: 0x0008, 0x13df: 0x0008, 0x13e0: 0x0008, 0x13e1: 0x0008, 0x13e2: 0x0008, 0x13e3: 0x0008,
	0x13e4: 0x0008, 0x13e5: 0x0008, 0x13e6: 0x0008, 0x13e7: 0x0008, 0x13e8: 0x0008, 0x13e9: 0x0008,
	0x13ea: 0x0008, 0x13eb: 0x0008, 0x13ec: 0x0008, 0x13ed: 0x0008, 0x13ee: 0x0008, 0x13ef: 0x0008,
	0x13f0: 0x0008, 0x13f1: 0x0008, 0x13f2: 0x0008, 0x13f3: 0x0008, 0x13f4: 0x0008, 0x13f5: 0x0008,
	0x13f6: 0x0008, 0x13f7: 0x0008, 0x13f8: 0x0008, 0x13f9: 0x0008, 0x13fa: 0x0008, 0x13fb: 0x0008,
	0x13fc: 0x0008, 0x13fd: 0x0008, 0x13fe: 0x0008, 0x13ff: 0x0008,
	// Block 0x50, offset 0x1400
	0x140b: 0x0008,
	0x140c: 0x0008, 0x140d: 0x0008, 0x140e: 0x0008, 0x140f: 0x0008, 0x1410: 0x0002,
	0x1413: 0x0002, 0x1414: 0x0002, 0x1415: 0x0002, 0x1416: 0x0002,
	0x1418: 0x0002, 0x1419: 0x0002, 0x141c: 0x0002, 0x141d: 0x0002,
	0x1420: 0x0002, 0x1421: 0x0002, 0x1422: 0x0002,
	0x1424: 0x0002, 0x1425: 0x0002, 0x1426: 0x0002, 0x1427: 0x0002, 0x1428: 0x0008, 0x1429: 0x0008,
	0x142a: 0x0008, 0x142b: 0x0008, 0x142c: 0x0008, 0x142d: 0x0008, 0x142e: 0x0008,
	0x1430: 0x0002, 0x1432: 0x0002, 0x1433: 0x0002, 0x1435: 0x0002,
	0x143b: 0x0002,
	0x143c: 0x0004, 0x143e: 0x0002,
	// Block 0x51, offset 0x1440
	0x1449: 0x0004,
	0x1460: 0x0008, 0x1461: 0x0008, 0x1462: 0x0008, 0x1463: 0x0008,
	0x1464: 0x0008, 0x1466: 0x0008, 0x1467: 0x0008, 0x1468: 0x0008, 0x1469: 0x0008,
	0x146a: 0x0008, 0x146b: 0x0008, 0x146c: 0x0008, 0x146d: 0x0008, 0x146e: 0x0008, 0x146f: 0x0008,
	0x1474: 0x0002,
	0x147f: 0x0002,
	// Block 0x52, offset 0x1480
	0x1481: 0x0002, 0x1482: 0x0002, 0x1483: 0x0002, 0x1484: 0x0002,
	0x14ac: 0x0002,
	// Block 0x53, offset 0x14c0
	0x14d0: 0x0008, 0x14d1: 0x0008,
	0x14d2: 0x0008, 0x14d3: 0x0008, 0x14d4: 0x0008, 0x14d5: 0x0008, 0x14d6: 0x0008, 0x14d7: 0x0008,
	0x14d8: 0x0008, 0x14d9: 0x0008, 0x14da: 0x0008, 0x14db: 0x0008, 0x14dc: 0x0008, 0x14dd: 0x0008,
	0x14de: 0x0008, 0x14df: 0x0008, 0x14e0: 0x0008, 0x14e1: 0x0008, 0x14e2: 0x0008, 0x14e3: 0x0008,
	0x14e4: 0x0008, 0x14e5: 0x0008, 0x14e6: 0x0008, 0x14e7: 0x0008, 0x14e8: 0x0008, 0x14e9: 0x0008,
	0x14ea: 0x0008, 0x14eb: 0x0008, 0x14ec: 0x0008, 0x14ed: 0x0008, 0x14ee: 0x0008, 0x14ef: 0x0008,
	0x14f0: 0x0008,
	// Block 0x54, offset 0x1500
	0x1503: 0x0002, 0x1505: 0x0002,
	0x1509: 0x0002,
	0x1513: 0x0002, 0x1516: 0x0002,
	0x1521: 0x0002, 0x1522: 0x0006,
	0x1526: 0x0002,
	0x152b: 0x0002,
	0x1539: 0x0004,
	// Block 0x55, offset 0x1540
	0x1553: 0x0002, 0x1554: 0x0002,
	0x155b: 0x0002, 0x155c: 0x0002, 0x155d: 0x0002,
	0x155e: 0x0002, 0x1560: 0x0002, 0x1561: 0x0002, 0x1562: 0x0002, 0x1563: 0x0002,
	0x1564: 0x0002, 0x1565: 0x0002, 0x1566: 0x0002, 0x1567: 0x0002, 0x1568: 0x0002, 0x1569: 0x0002,
	0x156a: 0x0002, 0x156b: 0x0002,
	0x1570: 0x0002, 0x1571: 0x0002, 0x1572: 0x0002, 0x1573: 0x0002, 0x1574: 0x0002, 0x1575: 0x0002,
	0x1576: 0x0002, 0x1577: 0x0002, 0x1578: 0x0002, 0x1579: 0x0002,
	// Block 0x56, offset 0x1580
	0x1589: 0x0002,
	0x1590: 0x0002, 0x1591: 0x0002,
	0x1592: 0x0002, 0x1593: 0x0002, 0x1594: 0x0006, 0x1595: 0x0006, 0x1596: 0x0006, 0x1597: 0x0006,
	0x1598: 0x0006, 0x1599: 0x0006,
	0x15a9: 0x0004,
	0x15aa: 0x0004,
	0x15b8: 0x0002, 0x15b9: 0x0002,
	// Block 0x57, offset 0x15c0
	0x15d2: 0x0002, 0x15d4: 0x0002,
	0x15e7: 0x0002,
	// Block 0x58, offset 0x1600
	0x1600: 0x0002, 0x1602: 0x0002, 0x1603: 0x0002,
	0x1607: 0x0002, 0x1608: 0x0002, 0x160b: 0x0002,
	0x160f: 0x0002, 0x1611: 0x0002,
	0x1615: 0x0002,
	0x161a: 0x0002, 0x161d: 0x0002,
	0x161e: 0x0002, 0x161f: 0x0002, 0x1620: 0x0002, 0x1623: 0x0002,
	0x1625: 0x0002, 0x1627: 0x0002, 0x1628: 0x0002, 0x1629: 0x0002,
	0x162a: 0x0002, 0x162b: 0x0002, 0x162c: 0x0002, 0x162e: 0x0002,
	0x1634: 0x0002, 0x1635: 0x0002,
	0x1636: 0x0002, 0x1637: 0x0002,
	0x163c: 0x0002, 0x163d: 0x0002,
	// Block 0x59, offset 0x1640
	0x1648: 0x0002,
	0x164c: 0x0002,
	0x1652: 0x0002,
	0x1660: 0x0002, 0x1661: 0x0002,
	0x1664: 0x0002, 0x1665: 0x0002, 0x1666: 0x0002, 0x1667: 0x0002,
	0x166a: 0x0002, 0x166b: 0x0002, 0x166e: 0x0002, 0x166f: 0x0002,
	// Block 0x5a, offset 0x1680
	0x1682: 0x0002, 0x1683: 0x0002,
	0x1686: 0x0002, 0x1687: 0x0002,
	0x1695: 0x0002,
	0x1699: 0x0002,
	0x16a5: 0x0002,
	0x16bf: 0x0002,
	// Block 0x5b, offset 0x16c0
	0x16d2: 0x0002,
	0x16da: 0x0005, 0x16db: 0x0005,
	0x16e8: 0x0004, 0x16e9: 0x0001,
	0x16ea: 0x0001,
	// Block 0x5c, offset 0x1700
	0x1708: 0x0004,
	// Block 0x5d, offset 0x1740
	0x174f: 0x0004,
	0x1769: 0x0005,
	0x176a: 0x0005, 0x176b: 0x0005, 0x176c: 0x0005, 0x176d: 0x0004, 0x176e: 0x0004, 0x176f: 0x0004,
	0x1770: 0x0005, 0x1771: 0x0004, 0x1772: 0x0004, 0x1773: 0x0005,
	0x1778: 0x0004, 0x1779: 0x0004, 0x177a: 0x0004,
	// Block 0x5e, offset 0x1780
	0x17a0: 0x0002, 0x17a1: 0x0002, 0x17a2: 0x0002, 0x17a3: 0x0002,
	0x17a4: 0x0002, 0x17a5: 0x0002, 0x17a6: 0x0002, 0x17a7: 0x0002, 0x17a8: 0x0002, 0x17a9: 0x0002,
	0x17aa: 0x0002, 0x17ab: 0x0002, 0x17ac: 0x0002, 0x17ad: 0x0002, 0x17ae: 0x0002, 0x17af: 0x0002,
	0x17b0: 0x0002, 0x17b1: 0x0002, 0x17b2: 0x0002, 0x17b3: 0x0002, 0x17b4: 0x0002, 0x17b5: 0x0002,
	0x17b6: 0x0002, 0x17b7: 0x0002, 0x17b8: 0x0002, 0x17b9: 0x0002, 0x17ba: 0x0002, 0x17bb: 0x0002,
	0x17bc: 0x0002, 0x17bd: 0x0002, 0x17be: 0x0002, 0x17bf: 0x0002,
	// Block 0x5f, offset 0x17c0
	0x17c0: 0x0002, 0x17c1: 0x0002, 0x17c2: 0x0002, 0x17c3: 0x0002, 0x17c4: 0x0002, 0x17c5: 0x0002,
	0x17c6: 0x0002, 0x17c7: 0x0002, 0x17c8: 0x0002, 0x17c9: 0x0002, 0x17ca: 0x0002, 0x17cb: 0x0002,
	0x17cc: 0x0002, 0x17cd: 0x0002, 0x17ce: 0x0002, 0x17cf: 0x0002, 0x17d0: 0x0002, 0x17d1: 0x0002,
	0x17d2: 0x0002, 0x17d3: 0x0002, 0x17d4: 0x0002, 0x17d5: 0x0002, 0x17d6: 0x0002, 0x17d7: 0x0002,
	0x17d8: 0x0002, 0x17d9: 0x0002, 0x17da: 0x0002, 0x17db: 0x0002, 0x17dc: 0x0002, 0x17dd: 0x0002,
	0x17de: 0x0002, 0x17df: 0x0002, 0x17e0: 0x0002, 0x17e1: 0x0002, 0x17e2: 0x0002, 0x17e3: 0x0002,
	0x17e4: 0x0002, 0x17e5: 0x0002, 0x17e6: 0x0002, 0x17e7: 0x0002, 0x17e8: 0x0002, 0x17e9: 0x0002,
	0x17ea: 0x0002, 0x17eb: 0x0002, 0x17ec: 0x0002, 0x17ed: 0x0002, 0x17ee: 0x0002, 0x17ef: 0x0002,
	0x17f0: 0x0002, 0x17f1: 0x0002, 0x17f2: 0x0002, 0x17f3: 0x0002, 0x17f4: 0x0002, 0x17f5: 0x0002,
	0x17f6: 0x0002, 0x17f7: 0x0002, 0x17f8: 0x0002, 0x17f9: 0x0002, 0x17fa: 0x0002, 0x17fb: 0x0002,
	0x17fc: 0x0002, 0x17fd: 0x0002, 0x17fe: 0x0002, 0x17ff: 0x0002,
	// Block 0x60, offset 0x1800
	0x1800: 0x0002, 0x1801: 0x0002, 0x1802: 0x0006, 0x1803: 0x0002, 0x1804: 0x0002, 0x1805: 0x0002,
	0x1806: 0x0002, 0x1807: 0x0002, 0x1808: 0x0002, 0x1809: 0x0002, 0x180a: 0x0002, 0x180b: 0x0002,
	0x180c: 0x0002, 0x180d: 0x0002, 0x180e: 0x0002, 0x180f: 0x0002, 0x1810: 0x0002, 0x1811: 0x0002,
	0x1812: 0x0002, 0x1813: 0x0002, 0x1814: 0x0002, 0x1815: 0x0002, 0x1816: 0x0002, 0x1817: 0x0002,
	0x1818: 0x0002, 0x1819: 0x0002, 0x181a: 0x0002, 0x181b: 0x0002, 0x181c: 0x0002, 0x181d: 0x0002,
	0x181e: 0x0002, 0x181f: 0x0002, 0x1820: 0x0002, 0x1821: 0x0002, 0x1822: 0x0002, 0x1823: 0x0002,
	0x1824: 0x0002, 0x1825: 0x0002, 0x1826: 0x0002, 0x1827: 0x0002, 0x1828: 0x0002, 0x1829: 0x0002,
	0x182b: 0x0002, 0x182c: 0x0002, 0x182d: 0x0002, 0x182e: 0x0002, 0x182f: 0x0002,
	0x1830: 0x0002, 0x1831: 0x0002, 0x1832: 0x0002, 0x1833: 0x0002, 0x1834: 0x0002, 0x1835: 0x0002,
	0x1836: 0x0002, 0x1837: 0x0002, 0x1838: 0x0002, 0x1839: 0x0002, 0x183a: 0x0002, 0x183b: 0x0002,
	0x183c: 0x0002, 0x183d: 0x0002, 0x183e: 0x0002, 0x183f: 0x0002,
	// Block 0x61, offset 0x1840
	0x1840: 0x0002, 0x1841: 0x0002, 0x1842: 0x0002, 0x1843: 0x0002, 0x1844: 0x0002, 0x1845: 0x0002,
	0x1846: 0x0002, 0x1847: 0x0002, 0x1848: 0x0002, 0x1849: 0x0002, 0x184a: 0x0002, 0x184b: 0x0002,
	0x1850: 0x0002, 0x1851: 0x0002,
	0x1852: 0x0002, 0x1853: 0x0002, 0x1854: 0x0002, 0x1855: 0x0002, 0x1856: 0x0002, 0x1857: 0x0002,
	0x1858: 0x0002, 0x1859: 0x0002, 0x185a: 0x0002, 0x185b: 0x0002, 0x185c: 0x0002, 0x185d: 0x0002,
	0x185e: 0x0002, 0x185f: 0x0002, 0x1860: 0x0002, 0x1861: 0x0002, 0x1862: 0x0002, 0x1863: 0x0002,
	0x1864: 0x0002, 0x1865: 0x0002, 0x1866: 0x0002, 0x1867: 0x0002, 0x1868: 0x0002, 0x1869: 0x0002,
	0x186a: 0x0002, 0x186b: 0x0002, 0x186c: 0x0002, 0x186d: 0x0002, 0x186e: 0x0002, 0x186f: 0x0002,
	0x1870: 0x0002, 0x1871: 0x0002, 0x1872: 0x0002, 0x1873: 0x0002,
	// Block 0x62, offset 0x1880
	0x1880: 0x0002, 0x1881: 0x0002, 0x1882: 0x0002, 0x1883: 0x0002, 0x1884: 0x0002, 0x1885: 0x0002,
	0x1886: 0x0002, 0x1887: 0x0002, 0x1888: 0x0002, 0x1889: 0x0002, 0x188a: 0x0002, 0x188b: 0x0002,
	0x188c: 0x0002, 0x188d: 0x0002, 0x188e: 0x0002, 0x188f: 0x0002,
	0x1892: 0x0002, 0x1893: 0x0002, 0x1894: 0x0002, 0x1895: 0x0002,
	0x18a0: 0x0002, 0x18a1: 0x0002, 0x18a3: 0x0002,
	0x18a4: 0x0002, 0x18a5: 0x0002, 0x18a6: 0x0002, 0x18a7: 0x0002, 0x18a8: 0x0002, 0x18a9: 0x0002,
	0x18aa: 0x0004, 0x18ab: 0x0004,
	0x18b2: 0x0002, 0x18b3: 0x0002,
	0x18b6: 0x0006, 0x18b7: 0x0002,
	0x18bc: 0x0002, 0x18bd: 0x0002,
	// Block 0x63, offset 0x18c0
	0x18c0: 0x0006, 0x18c1: 0x0002,
	0x18c6: 0x0002, 0x18c7: 0x0002, 0x18c8: 0x0002, 0x18cb: 0x0002,
	0x18ce: 0x0002, 0x18cf: 0x0002, 0x18d0: 0x0002, 0x18d1: 0x0002,
	0x18e2: 0x0002, 0x18e3: 0x0002,
	0x18e4: 0x0002, 0x18e5: 0x0002,
	0x18ef: 0x0002,
	0x18fb: 0x0004,
	0x18fc: 0x0004, 0x18fd: 0x0005, 0x18fe: 0x0005,
	// Block 0x64, offset 0x1900
	0x1900: 0x0004, 0x1901: 0x0004, 0x1902: 0x0004, 0x1903: 0x0004, 0x1904: 0x0004, 0x1905: 0x0006,
	0x1906: 0x0002, 0x1907: 0x0004, 0x1908: 0x0004, 0x1909: 0x0006, 0x190a: 0x0004, 0x190b: 0x0004,
	0x190c: 0x0004, 0x190d: 0x0004, 0x190e: 0x0006, 0x190f: 0x0006, 0x1910: 0x0004, 0x1911: 0x0004,
	0x1912: 0x0004, 0x1914: 0x0005, 0x1915: 0x0005, 0x1916: 0x0004, 0x1917: 0x0004,
	0x1918: 0x0004, 0x1919: 0x0004, 0x191a: 0x0004, 0x191b: 0x0004, 0x191c: 0x0006, 0x191d: 0x0004,
	0x191e: 0x0006, 0x191f: 0x0004, 0x1920: 0x0004, 0x1921: 0x0004, 0x1922: 0x0004, 0x1923: 0x0004,
	0x1924: 0x0004, 0x1925: 0x0004, 0x1926: 0x0004, 0x1927: 0x0004, 0x1928: 0x0004, 0x1929: 0x0004,
	0x192a: 0x0004, 0x192b: 0x0004, 0x192c: 0x0004, 0x192d: 0x0004, 0x192e: 0x0004, 0x192f: 0x0004,
	0x1930: 0x0004, 0x1931: 0x0004, 0x1932: 0x0004, 0x1933: 0x0004, 0x1934: 0x0004, 0x1935: 0x0004,
	0x1936: 0x0004, 0x1937: 0x0004, 0x1938: 0x0004, 0x1939: 0x0004, 0x193a: 0x0004, 0x193b: 0x0004,
	0x193c: 0x0004, 0x193d: 0x0004, 0x193e: 0x0004, 0x193f: 0x0004,
	// Block 0x65, offset 0x1940
	0x1940: 0x0006, 0x1941: 0x0004, 0x1942: 0x0006, 0x1943: 0x0004, 0x1944: 0x0004, 0x1945: 0x0004,
	0x1946: 0x0004, 0x1947: 0x0004, 0x1948: 0x0005, 0x1949: 0x0005, 0x194a: 0x0005, 0x194b: 0x0005,
	0x194c: 0x0005, 0x194d: 0x0005, 0x194e: 0x0005, 0x194f: 0x0005, 0x1950: 0x0005, 0x1951: 0x0005,
	0x1952: 0x0005, 0x1953: 0x0005, 0x1954: 0x0004, 0x1955: 0x0004, 0x1956: 0x0004, 0x1957: 0x0004,
	0x1958: 0x0004, 0x1959: 0x0004, 0x195a: 0x0004, 0x195b: 0x0004, 0x195c: 0x0004, 0x195d: 0x0004,
	0x195e: 0x0004, 0x195f: 0x0004, 0x1960: 0x0006, 0x1961: 0x0006, 0x1962: 0x0004, 0x1963: 0x0006,
	0x1964: 0x0006, 0x1965: 0x0006, 0x1966: 0x0004, 0x1967: 0x0006, 0x1968: 0x0006, 0x1969: 0x0006,
	0x196a: 0x0006, 0x196b: 0x0004, 0x196c: 0x0006, 0x196d: 0x0006, 0x196e: 0x0004, 0x196f: 0x0006,
	0x1970: 0x0004, 0x1971: 0x0004, 0x1972: 0x0004, 0x1973: 0x0004, 0x1974: 0x0004, 0x1975: 0x0004,
	0x1976: 0x0004, 0x1977: 0x0004, 0x1978: 0x0004, 0x1979: 0x0004, 0x197a: 0x0004, 0x197b: 0x0004,
	0x197c: 0x0004, 0x197d: 0x0004, 0x197e: 0x0004, 0x197f: 0x0005,
	// Block 0x66, offset 0x1980
	0x1980: 0x0004, 0x1981: 0x0004, 0x1982: 0x0004, 0x1983: 0x0004, 0x1984: 0x0004, 0x1985: 0x0004,
	0x1990: 0x0004, 0x1991: 0x0004,
	0x1992: 0x0004, 0x1993: 0x0005, 0x1994: 0x0004, 0x1995: 0x0004, 0x1996: 0x0004, 0x1997: 0x0004,
	0x1998: 0x0004, 0x1999: 0x0004, 0x199a: 0x0004, 0x199b: 0x0004, 0x199c: 0x0004, 0x199d: 0x0004,
	0x199e: 0x0006, 0x199f: 0x0006, 0x19a0: 0x0004, 0x19a1: 0x0005, 0x19a2: 0x0004, 0x19a3: 0x0004,
	0x19a4: 0x0004, 0x19a5: 0x0004, 0x19a6: 0x0004, 0x19a7: 0x0004, 0x19a8: 0x0004, 0x19a9: 0x0004,
	0x19aa: 0x0005, 0x19ab: 0x0005, 0x19ac: 0x0004, 0x19ad: 0x0004, 0x19ae: 0x0004, 0x19af: 0x0004,
	0x19b0: 0x0004, 0x19b1: 0x0004, 0x19b2: 0x0004, 0x19b3: 0x0004, 0x19b4: 0x0004, 0x19b5: 0x0004,
	0x19b6: 0x0004, 0x19b7: 0x0004, 0x19b8: 0x0004, 0x19b9: 0x0004, 0x19ba: 0x0004, 0x19bb: 0x0004,
	0x19bc: 0x0004, 0x19bd: 0x0005, 0x19be: 0x0005, 0x19bf: 0x0006,
	// Block 0x67, offset 0x19c0
	0x19c0: 0x0004, 0x19c1: 0x0004, 0x19c2: 0x0004, 0x19c3: 0x0004, 0x19c4: 0x0005, 0x19c5: 0x0005,
	0x19c6: 0x0006, 0x19c7: 0x0006, 0x19c8: 0x0006, 0x19c9: 0x0006, 0x19ca: 0x0006, 0x19cb: 0x0006,
	0x19cc: 0x0006, 0x19cd: 0x0006, 0x19ce: 0x0005, 0x19cf: 0x0006, 0x19d0: 0x0006, 0x19d1: 0x0006,
	0x19d2: 0x0006, 0x19d3: 0x0006, 0x19d4: 0x0005, 0x19d5: 0x0006, 0x19d6: 0x0006, 0x19d7: 0x0006,
	0x19d8: 0x0006, 0x19d9: 0x0006, 0x19da: 0x0006, 0x19db: 0x0006, 0x19dc: 0x0006, 0x19dd: 0x0006,
	0x19de: 0x0006, 0x19df: 0x0006, 0x19e0: 0x0006, 0x19e1: 0x0006, 0x19e2: 0x0004, 0x19e3: 0x0006,
	0x19e4: 0x0004, 0x19e5: 0x0004, 0x19e6: 0x0004, 0x19e7: 0x0004, 0x19e8: 0x0006, 0x19e9: 0x0006,
	0x19ea: 0x0005, 0x19eb: 0x0006, 0x19ec: 0x0006, 0x19ed: 0x0006, 0x19ee: 0x0006, 0x19ef: 0x0006,
	0x19f0: 0x0006, 0x19f1: 0x0006, 0x19f2: 0x0005, 0x19f3: 0x0005, 0x19f4: 0x0006, 0x19f5: 0x0005,
	0x19f6: 0x0006, 0x19f7: 0x0006, 0x19f8: 0x0006, 0x19f9: 0x0006, 0x19fa: 0x0005, 0x19fb: 0x0006,
	0x19fc: 0x0006, 0x19fd: 0x0005, 0x19fe: 0x0006, 0x19ff: 0x0006,
	// Block 0x68, offset 0x1a00
	0x1a00: 0x0004, 0x1a01: 0x0004, 0x1a02: 0x0004, 0x1a03: 0x0004, 0x1a04: 0x0004, 0x1a05: 0x0005,
	0x1a08: 0x0004, 0x1a09: 0x0004, 0x1a0a: 0x0005, 0x1a0b: 0x0005,
	0x1a0c: 0x0004, 0x1a0d: 0x0004, 0x1a0e: 0x0004, 0x1a0f: 0x0004, 0x1a10: 0x0004, 0x1a11: 0x0004,
	0x1a12: 0x0004, 0x1a14: 0x0004, 0x1a16: 0x0004,
	0x1a1d: 0x0004,
	0x1a21: 0x0004,
	0x1a28: 0x0005,
	0x1a33: 0x0004, 0x1a34: 0x0004,
	0x1a3d: 0x0002,
	// Block 0x69, offset 0x1a40
	0x1a44: 0x0004,
	0x1a47: 0x0004,
	0x1a4c: 0x0005, 0x1a4e: 0x0005,
	0x1a53: 0x0005, 0x1a54: 0x0005, 0x1a55: 0x0005, 0x1a57: 0x0005,
	0x1a63: 0x0004,
	0x1a64: 0x0004, 0x1a65: 0x0004, 0x1a66: 0x0004, 0x1a67: 0x0004,
	0x1a76: 0x0002, 0x1a77: 0x0002, 0x1a78: 0x0002, 0x1a79: 0x0002, 0x1a7a: 0x0002, 0x1a7b: 0x0002,
	0x1a7c: 0x0002, 0x1a7d: 0x0002, 0x1a7e: 0x0002, 0x1a7f: 0x0002,
	// Block 0x6a, offset 0x1a80
	0x1a95: 0x0005, 0x1a96: 0x0005, 0x1a97: 0x0005,
	0x1aa1: 0x0004,
	0x1ab0: 0x0005,
	0x1abf: 0x0005,
	// Block 0x6b, offset 0x1ac0
	0x1af4: 0x0004, 0x1af5: 0x0004,
	// Block 0x6c, offset 0x1b00
	0x1b05: 0x0004,
	0x1b06: 0x0004, 0x1b07: 0x0004,
	0x1b1b: 0x0005, 0x1b1c: 0x0005,
	// Block 0x6d, offset 0x1b40
	0x1b50: 0x0005,
	0x1b55: 0x0005, 0x1b56: 0x0002, 0x1b57: 0x0002,
	0x1b58: 0x0002, 0x1b59: 0x0002,
	// Block 0x6e, offset 0x1b80
	0x1baf: 0x0008,
	0x1bb0: 0x0008, 0x1bb1: 0x0008,
	// Block 0x6f, offset 0x1bc0
	0x1bff: 0x0008,
	// Block 0x70, offset 0x1c00
	0x1c20: 0x0008, 0x1c21: 0x0008, 0x1c22: 0x0008, 0x1c23: 0x0008,
	0x1c24: 0x0008, 0x1c25: 0x0008, 0x1c26: 0x0008, 0x1c27: 0x0008, 0x1c28: 0x0008, 0x1c29: 0x0008,
	0x1c2a: 0x0008, 0x1c2b: 0x0008, 0x1c2c: 0x0008, 0x1c2d: 0x0008, 0x1c2e: 0x0008, 0x1c2f: 0x0008,
	0x1c30: 0x0008, 0x1c31: 0x0008, 0x1c32: 0x0008, 0x1c33: 0x0008, 0x1c34: 0x0008, 0x1c35: 0x0008,
	0x1c36: 0x0008, 0x1c37: 0x0008, 0x1c38: 0x0008, 0x1c39: 0x0008, 0x1c3a: 0x0008, 0x1c3b: 0x0008,
	0x1c3c: 0x0008, 0x1c3d: 0x0008, 0x1c3e: 0x0008, 0x1c3f: 0x0008,
	// Block 0x71, offset 0x1c40
	0x1c40: 0x0001, 0x1c41: 0x0001, 0x1c42: 0x0001, 0x1c43: 0x0001, 0x1c44: 0x0001, 0x1c45: 0x0001,
	0x1c46: 0x0001, 0x1c47: 0x0001, 0x1c48: 0x0001, 0x1c49: 0x0001, 0x1c4a: 0x0001, 0x1c4b: 0x0001,
	0x1c4c: 0x0001, 0x1c4d: 0x0001, 0x1c4e: 0x0001, 0x1c4f: 0x0001, 0x1c50: 0x0001, 0x1c51: 0x0001,
	0x1c52: 0x0001, 0x1c53: 0x0001, 0x1c54: 0x0001, 0x1c55: 0x0001, 0x1c56: 0x0001, 0x1c57: 0x0001,
	0x1c58: 0x0001, 0x1c59: 0x0001, 0x1c5b: 0x0001, 0x1c5c: 0x0001, 0x1c5d: 0x0001,
	0x1c5e: 0x0001, 0x1c5f: 0x0001, 0x1c60: 0x0001, 0x1c61: 0x0001, 0x1c62: 0x0001, 0x1c63: 0x0001,
	0x1c64: 0x0001, 0x1c65: 0x0001, 0x1c66: 0x0001, 0x1c67: 0x0001, 0x1c68: 0x0001, 0x1c69: 0x0001,
	0x1c6a: 0x0001, 0x1c6b: 0x0001, 0x1c6c: 0x0001, 0x1c6d: 0x0001, 0x1c6e: 0x0001, 0x1c6f: 0x0001,
	0x1c70: 0x0001, 0x1c71: 0x0001, 0x1c72: 0x0001, 0x1c73: 0x0001, 0x1c74: 0x0001, 0x1c75: 0x0001,
	0x1c76: 0x0001, 0x1c77: 0x0001, 0x1c78: 0x0001, 0x1c79: 0x0001, 0x1c7a: 0x0001, 0x1c7b: 0x0001,
	0x1c7c: 0x0001, 0x1c7d: 0x0001, 0x1c7e: 0x0001, 0x1c7f: 0x0001,
	// Block 0x72, offset 0x1c80
	0x1c80: 0x0001, 0x1c81: 0x0001, 0x1c82: 0x0001, 0x1c83: 0x0001, 0x1c84: 0x0001, 0x1c85: 0x0001,
	0x1c86: 0x0001, 0x1c87: 0x0001, 0x1c88: 0x0001, 0x1c89: 0x0001, 0x1c8a: 0x0001, 0x1c8b: 0x0001,
	0x1c8c: 0x0001, 0x1c8d: 0x0001, 0x1c8e: 0x0001, 0x1c8f: 0x0001, 0x1c90: 0x0001, 0x1c91: 0x0001,
	0x1c92: 0x0001, 0x1c93: 0x0001, 0x1c94: 0x0001, 0x1c95: 0x0001, 0x1c96: 0x0001, 0x1c97: 0x0001,
	0x1c98: 0x0001, 0x1c99: 0x0001, 0x1c9a: 0x0001, 0x1c9b: 0x0001, 0x1c9c: 0x0001, 0x1c9d: 0x0001,
	0x1c9e: 0x0001, 0x1c9f: 0x0001, 0x1ca0: 0x0001, 0x1ca1: 0x0001, 0x1ca2: 0x0001, 0x1ca3: 0x0001,
	0x1ca4: 0x0001, 0x1ca5: 0x0001, 0x1ca6: 0x0001, 0x1ca7: 0x0001, 0x1ca8: 0x0001, 0x1ca9: 0x0001,
	0x1caa: 0x0001, 0x1cab: 0x0001, 0x1cac: 0x0001, 0x1cad: 0x0001, 0x1cae: 0x0001, 0x1caf: 0x0001,
	0x1cb0: 0x0001, 0x1cb1: 0x0001, 0x1cb2: 0x0001, 0x1cb3: 0x0001,
	// Block 0x73, offset 0x1cc0
	0x1cc0: 0x0001, 0x1cc1: 0x0001, 0x1cc2: 0x0001, 0x1cc3: 0x0001, 0x1cc4: 0x0001, 0x1cc5: 0x0001,
	0x1cc6: 0x0001, 0x1cc7: 0x0001, 0x1cc8: 0x0001, 0x1cc9: 0x0001, 0x1cca: 0x0001, 0x1ccb: 0x0001,
	0x1ccc: 0x0001, 0x1ccd: 0x0001, 0x1cce: 0x0001, 0x1ccf: 0x0001, 0x1cd0: 0x0001, 0x1cd1: 0x0001,
	0x1cd2: 0x0001, 0x1cd3: 0x0001, 0x1cd4: 0x0001, 0x1cd5: 0x0001,
	0x1cf0: 0x0001, 0x1cf1: 0x0001, 0x1cf2: 0x0001, 0x1cf3: 0x0001, 0x1cf4: 0x0001, 0x1cf5: 0x0001,
	0x1cf6: 0x0001, 0x1cf7: 0x0001, 0x1cf8: 0x0001, 0x1cf9: 0x0001, 0x1cfa: 0x0001, 0x1cfb: 0x0001,
	0x1cfc: 0x0001, 0x1cfd: 0x0001, 0x1cfe: 0x0001, 0x1cff: 0x0001,
	// Block 0x74, offset 0x1d00
	0x1d00: 0x0001, 0x1d01: 0x0001, 0x1d02: 0x0001, 0x1d03: 0x0001, 0x1d04: 0x0001, 0x1d05: 0x0001,
	0x1d06: 0x0001, 0x1d07: 0x0001, 0x1d08: 0x0001, 0x1d09: 0x0001, 0x1d0a: 0x0001, 0x1d0b: 0x0001,
	0x1d0c: 0x0001, 0x1d0d: 0x0001, 0x1d0e: 0x0001, 0x1d0f: 0x0001, 0x1d10: 0x0001, 0x1d11: 0x0001,
	0x1d12: 0x0001, 0x1d13: 0x0001, 0x1d14: 0x0001, 0x1d15: 0x0001, 0x1d16: 0x0001, 0x1d17: 0x0001,
	0x1d18: 0x0001, 0x1d19: 0x0001, 0x1d1a: 0x0001, 0x1d1b: 0x0001, 0x1d1c: 0x0001, 0x1d1d: 0x0001,
	0x1d1e: 0x0001, 0x1d1f: 0x0001, 0x1d20: 0x0001, 0x1d21: 0x0001, 0x1d22: 0x0001, 0x1d23: 0x0001,
	0x1d24: 0x0001, 0x1d25: 0x0001, 0x1d26: 0x0001, 0x1d27: 0x0001, 0x1d28: 0x0001, 0x1d29: 0x0001,
	0x1d2a: 0x0009, 0x1d2b: 0x0009, 0x1d2c: 0x0009, 0x1d2d: 0x0009, 0x1d2e: 0x0001, 0x1d2f: 0x0001,
	0x1d30: 0x0005, 0x1d31: 0x0001, 0x1d32: 0x0001, 0x1d33: 0x0001, 0x1d34: 0x0001, 0x1d35: 0x0001,
	0x1d36: 0x0001, 0x1d37: 0x0001, 0x1d38: 0x0001, 0x1d39: 0x0001, 0x1d3a: 0x0001, 0x1d3b: 0x0001,
	0x1d3c: 0x0001, 0x1d3d: 0x0005, 0x1d3e: 0x0001,
	// Block 0x75, offset 0x1d40
	0x1d41: 0x0001, 0x1d42: 0x0001, 0x1d43: 0x0001, 0x1d44: 0x0001, 0x1d45: 0x0001,
	0x1d46: 0x0001, 0x1d47: 0x0001, 0x1d48: 0x0001, 0x1d49: 0x0001, 0x1d4a: 0x0001, 0x1d4b: 0x0001,
	0x1d4c: 0x0001, 0x1d4d: 0x0001, 0x1d4e: 0x0001, 0x1d4f: 0x0001, 0x1d50: 0x0001, 0x1d51: 0x0001,
	0x1d52: 0x0001, 0x1d53: 0x0001, 0x1d54: 0x0001, 0x1d55: 0x0001, 0x1d56: 0x0001, 0x1d57: 0x0001,
	0x1d58: 0x0001, 0x1d59: 0x0001, 0x1d5a: 0x0001, 0x1d5b: 0x0001, 0x1d5c: 0x0001, 0x1d5d: 0x0001,
	0x1d5e: 0x0001, 0x1d5f: 0x0001, 0x1d60: 0x0001, 0x1d61: 0x0001, 0x1d62: 0x0001, 0x1d63: 0x0001,
	0x1d64: 0x0001, 0x1d65: 0x0001, 0x1d66: 0x0001, 0x1d67: 0x0001, 0x1d68: 0x0001, 0x1d69: 0x0001,
	0x1d6a: 0x0001, 0x1d6b: 0x0001, 0x1d6c: 0x0001, 0x1d6d: 0x0001, 0x1d6e: 0x0001, 0x1d6f: 0x0001,
	0x1d70: 0x0001, 0x1d71: 0x0001, 0x1d72: 0x0001, 0x1d73: 0x0001, 0x1d74: 0x0001, 0x1d75: 0x0001,
	0x1d76: 0x0001, 0x1d77: 0x0001, 0x1d78: 0x0001, 0x1d79: 0x0001, 0x1d7a: 0x0001, 0x1d7b: 0x0001,
	0x1d7c: 0x0001, 0x1d7d: 0x0001, 0x1d7e: 0x0001, 0x1d7f: 0x0001,
	// Block 0x76, offset 0x1d80
	0x1d80: 0x0001, 0x1d81: 0x0001, 0x1d82: 0x0001, 0x1d83: 0x0001, 0x1d84: 0x0001, 0x1d85: 0x0001,
	0x1d86: 0x0001, 0x1d87: 0x0001, 0x1d88: 0x0001, 0x1d89: 0x0001, 0x1d8a: 0x0001, 0x1d8b: 0x0001,
	0x1d8c: 0x0001, 0x1d8d: 0x0001, 0x1d8e: 0x0001, 0x1d8f: 0x0001, 0x1d90: 0x0001, 0x1d91: 0x0001,
	0x1d92: 0x0001, 0x1d93: 0x0001, 0x1d94: 0x0001, 0x1d95: 0x0001, 0x1d96: 0x0001,
	0x1d99: 0x0009, 0x1d9a: 0x0009, 0x1d9b: 0x0001, 0x1d9c: 0x0001, 0x1d9d: 0x0001,
	0x1d9e: 0x0001, 0x1d9f: 0x0001, 0x1da0: 0x0001, 0x1da1: 0x0001, 0x1da2: 0x0001, 0x1da3: 0x0001,
	0x1da4: 0x0001, 0x1da5: 0x0001, 0x1da6: 0x0001, 0x1da7: 0x0001, 0x1da8: 0x0001, 0x1da9: 0x0001,
	0x1daa: 0x0001, 0x1dab: 0x0001, 0x1dac: 0x0001, 0x1dad: 0x0001, 0x1dae: 0x0001, 0x1daf: 0x0001,
	0x1db0: 0x0001, 0x1db1: 0x0001, 0x1db2: 0x0001, 0x1db3: 0x0001, 0x1db4: 0x0001, 0x1db5: 0x0001,
	0x1db6: 0x0001, 0x1db7: 0x0001, 0x1db8: 0x0001, 0x1db9: 0x0001, 0x1dba: 0x0001, 0x1dbb: 0x0001,
	0x1dbc: 0x0001, 0x1dbd: 0x0001, 0x1dbe: 0x0001, 0x1dbf: 0x0001,
	// Block 0x77, offset 0x1dc0
	0x1dc5: 0x0001,
	0x1dc6: 0x0001, 0x1dc7: 0x0001, 0x1dc8: 0x0001, 0x1dc9: 0x0001, 0x1dca: 0x0001, 0x1dcb: 0x0001,
	0x1dcc: 0x0001, 0x1dcd: 0x0001, 0x1dce: 0x0001, 0x1dcf: 0x0001, 0x1dd0: 0x0001, 0x1dd1: 0x0001,
	0x1dd2: 0x0001, 0x1dd3: 0x0001, 0x1dd4: 0x0001, 0x1dd5: 0x0001, 0x1dd6: 0x0001, 0x1dd7: 0x0001,
	0x1dd8: 0x0001, 0x1dd9: 0x0001, 0x1dda: 0x0001, 0x1ddb: 0x0001, 0x1ddc: 0x0001, 0x1ddd: 0x0001,
	0x1dde: 0x0001, 0x1ddf: 0x0001, 0x1de0: 0x0001, 0x1de1: 0x0001, 0x1de2: 0x0001, 0x1de3: 0x0001,
	0x1de4: 0x0001, 0x1de5: 0x0001, 0x1de6: 0x0001, 0x1de7: 0x0001, 0x1de8: 0x0001, 0x1de9: 0x0001,
	0x1dea: 0x0001, 0x1deb: 0x0001, 0x1dec: 0x0001, 0x1ded: 0x0001, 0x1dee: 0x0001, 0x1def: 0x0001,
	0x1df1: 0x0001, 0x1df2: 0x0001, 0x1df3: 0x0001, 0x1df4: 0x0001, 0x1df5: 0x0001,
	0x1df6: 0x0001, 0x1df7: 0x0001, 0x1df8: 0x0001, 0x1df9: 0x0001, 0x1dfa: 0x0001, 0x1dfb: 0x0001,
	0x1dfc: 0x0001, 0x1dfd: 0x0001, 0x1dfe: 0x0001, 0x1dff: 0x0001,
	// Block 0x78, offset 0x1e00
	0x1e00: 0x0001, 0x1e01: 0x0001, 0x1e02: 0x0001, 0x1e03: 0x0001, 0x1e04: 0x0001, 0x1e05: 0x0001,
	0x1e06: 0x0001, 0x1e07: 0x0001, 0x1e08: 0x0001, 0x1e09: 0x0001, 0x1e0a: 0x0001, 0x1e0b: 0x0001,
	0x1e0c: 0x0001, 0x1e0d: 0x0001, 0x1e0e: 0x0001, 0x1e10: 0x0001, 0x1e11: 0x0001,
	0x1e12: 0x0001, 0x1e13: 0x0001, 0x1e14: 0x0001, 0x1e15: 0x0001, 0x1e16: 0x0001, 0x1e17: 0x0001,
	0x1e18: 0x0001, 0x1e19: 0x0001, 0x1e1a: 0x0001, 0x1e1b: 0x0001, 0x1e1c: 0x0001, 0x1e1d: 0x0001,
	0x1e1e: 0x0001, 0x1e1f: 0x0001, 0x1e20: 0x0001, 0x1e21: 0x0001, 0x1e22: 0x0001, 0x1e23: 0x0001,
	0x1e24: 0x0001, 0x1e25: 0x0001, 0x1e26: 0x0001, 0x1e27: 0x0001, 0x1e28: 0x0001, 0x1e29: 0x0001,
	0x1e2a: 0x0001, 0x1e2b: 0x0001, 0x1e2c: 0x0001, 0x1e2d: 0x0001, 0x1e2e: 0x0001, 0x1e2f: 0x0001,
	0x1e30: 0x0001, 0x1e31: 0x0001, 0x1e32: 0x0001, 0x1e33: 0x0001, 0x1e34: 0x0001, 0x1e35: 0x0001,
	0x1e36: 0x0001, 0x1e37: 0x0001, 0x1e38: 0x0001, 0x1e39: 0x0001, 0x1e3a: 0x0001, 0x1e3b: 0x0001,
	0x1e3c: 0x0001, 0x1e3d: 0x0001, 0x1e3e: 0x0001, 0x1e3f: 0x0001,
	// Block 0x79, offset 0x1e40
	0x1e40: 0x0001, 0x1e41: 0x0001, 0x1e42: 0x0001, 0x1e43: 0x0001, 0x1e44: 0x0001, 0x1e45: 0x0001,
	0x1e46: 0x0001, 0x1e47: 0x0001, 0x1e48: 0x0001, 0x1e49: 0x0001, 0x1e4a: 0x0001, 0x1e4b: 0x0001,
	0x1e4c: 0x0001, 0x1e4d: 0x0001, 0x1e4e: 0x0001, 0x1e4f: 0x0001, 0x1e50: 0x0001, 0x1e51: 0x0001,
	0x1e52: 0x0001, 0x1e53: 0x0001, 0x1e54: 0x0001, 0x1e55: 0x0001, 0x1e56: 0x0001, 0x1e57: 0x0001,
	0x1e58: 0x0001, 0x1e59: 0x0001, 0x1e5a: 0x0001, 0x1e5b: 0x0001, 0x1e5c: 0x0001, 0x1e5d: 0x0001,
	0x1e5e: 0x0001, 0x1e5f: 0x0001, 0x1e60: 0x0001, 0x1e61: 0x0001, 0x1e62: 0x0001, 0x1e63: 0x0001,
	0x1e6f: 0x0001,
	0x1e70: 0x0001, 0x1e71: 0x0001, 0x1e72: 0x0001, 0x1e73: 0x0001, 0x1e74: 0x0001, 0x1e75: 0x0001,
	0x1e76: 0x0001, 0x1e77: 0x0001, 0x1e78: 0x0001, 0x1e79: 0x0001, 0x1e7a: 0x0001, 0x1e7b: 0x0001,
	0x1e7c: 0x0001, 0x1e7d: 0x0001, 0x1e7e: 0x0001, 0x1e7f: 0x0001,
	// Block 0x7a, offset 0x1e80
	0x1e80: 0x0001, 0x1e81: 0x0001, 0x1e82: 0x0001, 0x1e83: 0x0001, 0x1e84: 0x0001, 0x1e85: 0x0001,
	0x1e86: 0x0001, 0x1e87: 0x0001, 0x1e88: 0x0001, 0x1e89: 0x0001, 0x1e8a: 0x0001, 0x1e8b: 0x0001,
	0x1e8c: 0x0001, 0x1e8d: 0x0001, 0x1e8e: 0x0001, 0x1e8f: 0x0001, 0x1e90: 0x0001, 0x1e91: 0x0001,
	0x1e92: 0x0001, 0x1e93: 0x0001, 0x1e94: 0x0001, 0x1e95: 0x0001, 0x1e96: 0x0001, 0x1e97: 0x0001,
	0x1e98: 0x0001, 0x1e99: 0x0001, 0x1e9a: 0x0001, 0x1e9b: 0x0001, 0x1e9c: 0x0001, 0x1e9d: 0x0001,
	0x1e9e: 0x0001, 0x1ea0: 0x0001, 0x1ea1: 0x0001, 0x1ea2: 0x0001, 0x1ea3: 0x0001,
	0x1ea4: 0x0001, 0x1ea5: 0x0001, 0x1ea6: 0x0001, 0x1ea7: 0x0001, 0x1ea8: 0x0001, 0x1ea9: 0x0001,
	0x1eaa: 0x0001, 0x1eab: 0x0001, 0x1eac: 0x0001, 0x1ead: 0x0001, 0x1eae: 0x0001, 0x1eaf: 0x0001,
	0x1eb0: 0x0001, 0x1eb1: 0x0001, 0x1eb2: 0x0001, 0x1eb3: 0x0001, 0x1eb4: 0x0001, 0x1eb5: 0x0001,
	0x1eb6: 0x0001, 0x1eb7: 0x0001, 0x1eb8: 0x0001, 0x1eb9: 0x0001, 0x1eba: 0x0001, 0x1ebb: 0x0001,
	0x1ebc: 0x0001, 0x1ebd: 0x0001, 0x1ebe: 0x0001, 0x1ebf: 0x0001,
	// Block 0x7b, offset 0x1ec0
	0x1ec0: 0x0001, 0x1ec1: 0x0001, 0x1ec2: 0x0001, 0x1ec3: 0x0001, 0x1ec4: 0x0001, 0x1ec5: 0x0001,
	0x1ec6: 0x0001, 0x1ec7: 0x0001, 0x1ec8: 0x0002, 0x1ec9: 0x0002, 0x1eca: 0x0002, 0x1ecb: 0x0002,
	0x1ecc: 0x0002, 0x1ecd: 0x0002, 0x1ece: 0x0002, 0x1ecf: 0x0002, 0x1ed0: 0x0001, 0x1ed1: 0x0001,
	0x1ed2: 0x0001, 0x1ed3: 0x0001, 0x1ed4: 0x0001, 0x1ed5: 0x0001, 0x1ed6: 0x0001, 0x1ed7: 0x0001,
	0x1ed8: 0x0001, 0x1ed9: 0x0001, 0x1eda: 0x0001, 0x1edb: 0x0001, 0x1edc: 0x0001, 0x1edd: 0x0001,
	0x1ede: 0x0001, 0x1edf: 0x0001, 0x1ee0: 0x0001, 0x1ee1: 0x0001, 0x1ee2: 0x0001, 0x1ee3: 0x0001,
	0x1ee4: 0x0001, 0x1ee5: 0x0001, 0x1ee6: 0x0001, 0x1ee7: 0x0001, 0x1ee8: 0x0001, 0x1ee9: 0x0001,
	0x1eea: 0x0001, 0x1eeb: 0x0001, 0x1eec: 0x0001, 0x1eed: 0x0001, 0x1eee: 0x0001, 0x1eef: 0x0001,
	0x1ef0: 0x0001, 0x1ef1: 0x0001, 0x1ef2: 0x0001, 0x1ef3: 0x0001, 0x1ef4: 0x0001, 0x1ef5: 0x0001,
	0x1ef6: 0x0001, 0x1ef7: 0x0001, 0x1ef8: 0x0001, 0x1ef9: 0x0001, 0x1efa: 0x0001, 0x1efb: 0x0001,
	0x1efc: 0x0001, 0x1efd: 0x0001, 0x1efe: 0x0001, 0x1eff: 0x0001,
	// Block 0x7c, offset 0x1f00
	0x1f00: 0x0001, 0x1f01: 0x0001, 0x1f02: 0x0001, 0x1f03: 0x0001, 0x1f04: 0x0001, 0x1f05: 0x0001,
	0x1f06: 0x0001, 0x1f07: 0x0001, 0x1f08: 0x0001, 0x1f09: 0x0001, 0x1f0a: 0x0001, 0x1f0b: 0x0001,
	0x1f0c: 0x0001, 0x1f0d: 0x0001, 0x1f0e: 0x0001, 0x1f0f: 0x0001, 0x1f10: 0x0001, 0x1f11: 0x0001,
	0x1f12: 0x0001, 0x1f13: 0x0001, 0x1f14: 0x0001, 0x1f15: 0x0001, 0x1f16: 0x0001, 0x1f17: 0x0005,
	0x1f18: 0x0001, 0x1f19: 0x0005, 0x1f1a: 0x0001, 0x1f1b: 0x0001, 0x1f1c: 0x0001, 0x1f1d: 0x0001,
	0x1f1e: 0x0001, 0x1f1f: 0x0001, 0x1f20: 0x0001, 0x1f21: 0x0001, 0x1f22: 0x0001, 0x1f23: 0x0001,
	0x1f24: 0x0001, 0x1f25: 0x0001, 0x1f26: 0x0001, 0x1f27: 0x0001, 0x1f28: 0x0001, 0x1f29: 0x0001,
	0x1f2a: 0x0001, 0x1f2b: 0x0001, 0x1f2c: 0x0001, 0x1f2d: 0x0001, 0x1f2e: 0x0001, 0x1f2f: 0x0001,
	0x1f30: 0x0001, 0x1f31: 0x0001, 0x1f32: 0x0001, 0x1f33: 0x0001, 0x1f34: 0x0001, 0x1f35: 0x0001,
	0x1f36: 0x0001, 0x1f37: 0x0001, 0x1f38: 0x0001, 0x1f39: 0x0001, 0x1f3a: 0x0001, 0x1f3b: 0x0001,
	0x1f3c: 0x0001, 0x1f3d: 0x0001, 0x1f3e: 0x0001, 0x1f3f: 0x0001,
	// Block 0x7d, offset 0x1f40
	0x1f40: 0x0001, 0x1f41: 0x0001, 0x1f42: 0x0001, 0x1f43: 0x0001, 0x1f44: 0x0001, 0x1f45: 0x0001,
	0x1f46: 0x0001, 0x1f47: 0x0001, 0x1f48: 0x0001, 0x1f49: 0x0001, 0x1f4a: 0x0001, 0x1f4b: 0x0001,
	0x1f4c: 0x0001, 0x1f50: 0x0001, 0x1f51: 0x0001,
	0x1f52: 0x0001, 0x1f53: 0x0001, 0x1f54: 0x0001, 0x1f55: 0x0001, 0x1f56: 0x0001, 0x1f57: 0x0001,
	0x1f58: 0x0001, 0x1f59: 0x0001, 0x1f5a: 0x0001, 0x1f5b: 0x0001, 0x1f5c: 0x0001, 0x1f5d: 0x0001,
	0x1f5e: 0x0001, 0x1f5f: 0x0001, 0x1f60: 0x0001, 0x1f61: 0x0001, 0x1f62: 0x0001, 0x1f63: 0x0001,
	0x1f64: 0x0001, 0x1f65: 0x0001, 0x1f66: 0x0001, 0x1f67: 0x0001, 0x1f68: 0x0001, 0x1f69: 0x0001,
	0x1f6a: 0x0001, 0x1f6b: 0x0001, 0x1f6c: 0x0001, 0x1f6d: 0x0001, 0x1f6e: 0x0001, 0x1f6f: 0x0001,
	0x1f70: 0x0001, 0x1f71: 0x0001, 0x1f72: 0x0001, 0x1f73: 0x0001, 0x1f74: 0x0001, 0x1f75: 0x0001,
	0x1f76: 0x0001, 0x1f77: 0x0001, 0x1f78: 0x0001, 0x1f79: 0x0001, 0x1f7a: 0x0001, 0x1f7b: 0x0001,
	0x1f7c: 0x0001, 0x1f7d: 0x0001, 0x1f7e: 0x0001, 0x1f7f: 0x0001,
	// Block 0x7e, offset 0x1f80
	0x1f80: 0x0001, 0x1f81: 0x0001, 0x1f82: 0x0001, 0x1f83: 0x0001, 0x1f84: 0x0001, 0x1f85: 0x0001,
	0x1f86: 0x0001,
	// Block 0x7f, offset 0x1fc0
	0x1fef: 0x0008,
	0x1ff0: 0x0008, 0x1ff1: 0x0008, 0x1ff2: 0x0008, 0x1ff4: 0x0008, 0x1ff5: 0x0008,
	0x1ff6: 0x0008, 0x1ff7: 0x0008, 0x1ff8: 0x0008, 0x1ff9: 0x0008, 0x1ffa: 0x0008, 0x1ffb: 0x0008,
	0x1ffc: 0x0008, 0x1ffd: 0x0008,
	// Block 0x80, offset 0x2000
	0x201e: 0x0008, 0x201f: 0x0008,
	// Block 0x81, offset 0x2040
	0x2070: 0x0008, 0x2071: 0x0008,
	// Block 0x82, offset 0x2080
	0x2082: 0x0008,
	0x2086: 0x0008, 0x208b: 0x0008,
	0x20a5: 0x0008, 0x20a6: 0x0008,
	0x20ac: 0x0008,
	// Block 0x83, offset 0x20c0
	0x20c4: 0x0008, 0x20c5: 0x0008,
	0x20e0: 0x0008, 0x20e1: 0x0008, 0x20e2: 0x0008, 0x20e3: 0x0008,
	0x20e4: 0x0008, 0x20e5: 0x0008, 0x20e6: 0x0008, 0x20e7: 0x0008, 0x20e8: 0x0008, 0x20e9: 0x0008,
	0x20ea: 0x0008, 0x20eb: 0x0008, 0x20ec: 0x0008, 0x20ed: 0x0008, 0x20ee: 0x0008, 0x20ef: 0x0008,
	0x20f0: 0x0008, 0x20f1: 0x0008,
	0x20ff: 0x0008,
	// Block 0x84, offset 0x2100
	0x2126: 0x0008, 0x2127: 0x0008, 0x2128: 0x0008, 0x2129: 0x0008,
	0x212a: 0x0008, 0x212b: 0x0008, 0x212c: 0x0008, 0x212d: 0x0008,
	// Block 0x85, offset 0x2140
	0x2147: 0x0008, 0x2148: 0x0008, 0x2149: 0x0008, 0x214a: 0x0008, 0x214b: 0x0008,
	0x214c: 0x0008, 0x214d: 0x0008, 0x214e: 0x0008, 0x214f: 0x0008, 0x2150: 0x0008, 0x2151: 0x0008,
	0x2160: 0x0001, 0x2161: 0x0001, 0x2162: 0x0001, 0x2163: 0x0001,
	0x2164: 0x0001, 0x2165: 0x0001, 0x2166: 0x0001, 0x2167: 0x0001, 0x2168: 0x0001, 0x2169: 0x0001,
	0x216a: 0x0001, 0x216b: 0x0001, 0x216c: 0x0001, 0x216d: 0x0001, 0x216e: 0x0001, 0x216f: 0x0001,
	0x2170: 0x0001, 0x2171: 0x0001, 0x2172: 0x0001, 0x2173: 0x0001, 0x2174: 0x0001, 0x2175: 0x0001,
	0x2176: 0x0001, 0x2177: 0x0001, 0x2178: 0x0001, 0x2179: 0x0001, 0x217a: 0x0001, 0x217b: 0x0001,
	0x217c: 0x0001,
	// Block 0x86, offset 0x2180
	0x2180: 0x0008, 0x2181: 0x0008, 0x2182: 0x0008,
	0x21b3: 0x0008,
	0x21b6: 0x0008, 0x21b7: 0x0008, 0x21b8: 0x0008, 0x21b9: 0x0008,
	0x21bc: 0x0008, 0x21bd: 0x0008,
	// Block 0x87, offset 0x21c0
	0x21e5: 0x0008,
	// Block 0x88, offset 0x2200
	0x2229: 0x0008,
	0x222a: 0x0008, 0x222b: 0x0008, 0x222c: 0x0008, 0x222d: 0x0008, 0x222e: 0x0008,
	0x2231: 0x0008, 0x2232: 0x0008, 0x2235: 0x0008,
	0x2236: 0x0008,
	// Block 0x89, offset 0x2240
	0x2243: 0x0008,
	0x224c: 0x0008,
	0x227c: 0x0008,
	// Block 0x8a, offset 0x2280
	0x22b0: 0x0008, 0x22b2: 0x0008, 0x22b3: 0x0008, 0x22b4: 0x0008,
	0x22b7: 0x0008, 0x22b8: 0x0008,
	0x22be: 0x0008, 0x22bf: 0x0008,
	// Block 0x8b, offset 0x22c0
	0x22c1: 0x0008,
	0x22ec: 0x0008, 0x22ed: 0x0008,
	0x22f6: 0x0008,
	// Block 0x8c, offset 0x2300
	0x2325: 0x0008, 0x2328: 0x0008,
	0x232d: 0x0008,
	// Block 0x8d, offset 0x2340
	0x2340: 0x0001, 0x2341: 0x0001, 0x2342: 0x0001, 0x2343: 0x0001, 0x2344: 0x0001, 0x2345: 0x0001,
	0x2346: 0x0001, 0x2347: 0x0001, 0x2348: 0x0001, 0x2349: 0x0001, 0x234a: 0x0001, 0x234b: 0x0001,
	0x234c: 0x0001, 0x234d: 0x0001, 0x234e: 0x0001, 0x234f: 0x0001, 0x2350: 0x0001, 0x2351: 0x0001,
	0x2352: 0x0001, 0x2353: 0x0001, 0x2354: 0x0001, 0x2355: 0x0001, 0x2356: 0x0001, 0x2357: 0x0001,
	0x2358: 0x0001, 0x2359: 0x0001, 0x235a: 0x0001, 0x235b: 0x0001, 0x235c: 0x0001, 0x235d: 0x0001,
	0x235e: 0x0001, 0x235f: 0x0001, 0x2360: 0x0001, 0x2361: 0x0001, 0x2362: 0x0001, 0x2363: 0x0001,
	// Block 0x8e, offset 0x2380
	0x239e: 0x0008,
	// Block 0x8f, offset 0x23c0
	0x23c0: 0x000a, 0x23c1: 0x000a, 0x23c2: 0x000a, 0x23c3: 0x000a, 0x23c4: 0x000a, 0x23c5: 0x000a,
	0x23c6: 0x000a, 0x23c7: 0x000a, 0x23c8: 0x000a, 0x23c9: 0x000a, 0x23ca: 0x000a, 0x23cb: 0x000a,
	0x23cc: 0x000a, 0x23cd: 0x000a, 0x23ce: 0x000a, 0x23cf: 0x000a, 0x23d0: 0x0001, 0x23d1: 0x0001,
	0x23d2: 0x0001, 0x23d3: 0x0001, 0x23d4: 0x0001, 0x23d5: 0x0001, 0x23d6: 0x0001, 0x23d7: 0x0001,
	0x23d8: 0x0001, 0x23d9: 0x0001,
	0x23e0: 0x0008, 0x23e1: 0x0008, 0x23e2: 0x0008, 0x23e3: 0x0008,
	0x23e4: 0x0008, 0x23e5: 0x0008, 0x23e6: 0x0008, 0x23e7: 0x0008, 0x23e8: 0x0008, 0x23e9: 0x0008,
	0x23ea: 0x0008, 0x23eb: 0x0008, 0x23ec: 0x0008, 0x23ed: 0x0008, 0x23ee: 0x0008, 0x23ef: 0x0008,
	0x23f0: 0x0001, 0x23f1: 0x0001, 0x23f2: 0x0001, 0x23f3: 0x0001, 0x23f4: 0x0001, 0x23f5: 0x0001,
	0x23f6: 0x0001, 0x23f7: 0x0001, 0x23f8: 0x0001, 0x23f9: 0x0001, 0x23fa: 0x0001, 0x23fb: 0x0001,
	0x23fc: 0x0001, 0x23fd: 0x0001, 0x23fe: 0x0001, 0x23ff: 0x0001,
	// Block 0x90, offset 0x2400
	0x2400: 0x0001, 0x2401: 0x0001, 0x2402: 0x0001, 0x2403: 0x0001, 0x2404: 0x0001, 0x2405: 0x0001,
	0x2406: 0x0001, 0x2407: 0x0001, 0x2408: 0x0001, 0x2409: 0x0001, 0x240a: 0x0001, 0x240b: 0x0001,
	0x240c: 0x0001, 0x240d: 0x0001, 0x240e: 0x0001, 0x240f: 0x0001, 0x2410: 0x0001, 0x2411: 0x0001,
	0x2412: 0x0001, 0x2414: 0x0001, 0x2415: 0x0001, 0x2416: 0x0001, 0x2417: 0x0001,
	0x2418: 0x0001, 0x2419: 0x0001, 0x241a: 0x0001, 0x241b: 0x0001, 0x241c: 0x0001, 0x241d: 0x0001,
	0x241e: 0x0001, 0x241f: 0x0001, 0x2420: 0x0001, 0x2421: 0x0001, 0x2422: 0x0001, 0x2423: 0x0001,
	0x2424: 0x0001, 0x2425: 0x0001, 0x2426: 0x0001, 0x2428: 0x0001, 0x2429: 0x0001,
	0x242a: 0x0001, 0x242b: 0x0001,
	// Block 0x91, offset 0x2440
	0x2440: 0x0001, 0x2441: 0x0001, 0x2442: 0x0001, 0x2443: 0x0001, 0x2444: 0x0001, 0x2445: 0x0001,
	0x2446: 0x0001, 0x2447: 0x0001, 0x2448: 0x0001, 0x2449: 0x0001, 0x244a: 0x0001, 0x244b: 0x0001,
	0x244c: 0x0001, 0x244d: 0x0001, 0x244e: 0x0001, 0x244f: 0x0001, 0x2450: 0x0001, 0x2451: 0x0001,
	0x2452: 0x0001, 0x2453: 0x0001, 0x2454: 0x0001, 0x2455: 0x0001, 0x2456: 0x0001, 0x2457: 0x0001,
	0x2458: 0x0001, 0x2459: 0x0001, 0x245a: 0x0001, 0x245b: 0x0001, 0x245c: 0x0001, 0x245d: 0x0001,
	0x245e: 0x0001, 0x245f: 0x0001, 0x2460: 0x0001,
	// Block 0x92, offset 0x2480
	0x24a0: 0x0001, 0x24a1: 0x0001, 0x24a2: 0x0001, 0x24a3: 0x0001,
	0x24a4: 0x0001, 0x24a5: 0x0001, 0x24a6: 0x0001,
	0x24b9: 0x0008, 0x24ba: 0x0008, 0x24bb: 0x0008,
	0x24be: 0x0008, 0x24bf: 0x0008,
	// Block 0x93, offset 0x24c0
	0x24fd: 0x0008,
	// Block 0x94, offset 0x2500
	0x2520: 0x0008,
	// Block 0x95, offset 0x2540
	0x2576: 0x0008, 0x2577: 0x0008, 0x2578: 0x0008, 0x2579: 0x0008, 0x257a: 0x0008,
	// Block 0x96, offset 0x2580
	0x2581: 0x0008, 0x2582: 0x0008, 0x2583: 0x0008, 0x2585: 0x0008,
	0x2586: 0x0008,
	0x258c: 0x0008, 0x258d: 0x0008, 0x258e: 0x0008, 0x258f: 0x0008,
	0x25b8: 0x0008, 0x25b9: 0x0008, 0x25ba: 0x0008,
	0x25bf: 0x0008,
	// Block 0x97, offset 0x25c0
	0x25e5: 0x0008, 0x25e6: 0x0008,
	// Block 0x98, offset 0x2600
	0x2624: 0x0008, 0x2625: 0x0008, 0x2626: 0x0008, 0x2627: 0x0008,
	// Block 0x99, offset 0x2640
	0x266b: 0x0008, 0x266c: 0x0008,
	// Block 0x9a, offset 0x2680
	0x26bd: 0x0008, 0x26be: 0x0008, 0x26bf: 0x0008,
	// Block 0x9b, offset 0x26c0
	0x26c6: 0x0008, 0x26c7: 0x0008, 0x26c8: 0x0008, 0x26c9: 0x0008, 0x26ca: 0x0008, 0x26cb: 0x0008,
	0x26cc: 0x0008, 0x26cd: 0x0008, 0x26ce: 0x0008, 0x26cf: 0x0008, 0x26d0: 0x0008,
	// Block 0x9c, offset 0x2700
	0x2702: 0x0008, 0x2703: 0x0008, 0x2704: 0x0008, 0x2705: 0x0008,
	// Block 0x9d, offset 0x2740
	0x2741: 0x0008,
	0x2778: 0x0008, 0x2779: 0x0008, 0x277a: 0x0008, 0x277b: 0x0008,
	0x277c: 0x0008, 0x277d: 0x0008, 0x277e: 0x0008, 0x277f: 0x0008,
	// Block 0x9e, offset 0x2780
	0x2780: 0x0008, 0x2781: 0x0008, 0x2782: 0x0008, 0x2783: 0x0008, 0x2784: 0x0008, 0x2785: 0x0008,
	0x2786: 0x0008,
	0x27b0: 0x0008, 0x27b3: 0x0008, 0x27b4: 0x0008,
	0x27bf: 0x0008,
	// Block 0x9f, offset 0x27c0
	0x27c0: 0x0008, 0x27c1: 0x0008,
	0x27f3: 0x0008, 0x27f4: 0x0008, 0x27f5: 0x0008,
	0x27f6: 0x0008, 0x27f9: 0x0008, 0x27fa: 0x0008,
	0x27fd: 0x0008,
	// Block 0xa0, offset 0x2800
	0x2802: 0x0008,
	0x280d: 0x0008,
	// Block 0xa1, offset 0x2840
	0x2840: 0x0008, 0x2841: 0x0008, 0x2842: 0x0008,
	0x2867: 0x0008, 0x2868: 0x0008, 0x2869: 0x0008,
	0x286a: 0x0008, 0x286b: 0x0008, 0x286d: 0x0008, 0x286e: 0x0008, 0x286f: 0x0008,
	0x2870: 0x0008, 0x2871: 0x0008, 0x2872: 0x0008, 0x2873: 0x0008, 0x2874: 0x0008,
	// Block 0xa2, offset 0x2880
	0x28b3: 0x0008,
	// Block 0xa3, offset 0x28c0
	0x28c0: 0x0008, 0x28c1: 0x0008,
	0x28f6: 0x0008, 0x28f7: 0x0008, 0x28f8: 0x0008, 0x28f9: 0x0008, 0x28fa: 0x0008, 0x28fb: 0x0008,
	0x28fc: 0x0008, 0x28fd: 0x0008, 0x28fe: 0x0008,
	// Block 0xa4, offset 0x2900
	0x2909: 0x0008, 0x290a: 0x0008, 0x290b: 0x0008,
	0x290c: 0x0008, 0x290f: 0x0008,
	// Block 0xa5, offset 0x2940
	0x296f: 0x0008,
	0x2970: 0x0008, 0x2971: 0x0008, 0x2974: 0x0008,
	0x2976: 0x0008, 0x2977: 0x0008,
	0x297e: 0x0008,
	// Block 0xa6, offset 0x2980
	0x299f: 0x0008, 0x29a3: 0x0008,
	0x29a4: 0x0008, 0x29a5: 0x0008, 0x29a6: 0x0008, 0x29a7: 0x0008, 0x29a8: 0x0008, 0x29a9: 0x0008,
	0x29aa: 0x0008,
	// Block 0xa7, offset 0x29c0
	0x29c0: 0x0008,
	0x29e6: 0x0008, 0x29e7: 0x0008, 0x29e8: 0x0008, 0x29e9: 0x0008,
	0x29ea: 0x0008, 0x29eb: 0x0008, 0x29ec: 0x0008,
	0x29f0: 0x0008, 0x29f1: 0x0008, 0x29f2: 0x0008, 0x29f3: 0x0008, 0x29f4: 0x0008,
	// Block 0xa8, offset 0x2a00
	0x2a38: 0x0008, 0x2a39: 0x0008, 0x2a3a: 0x0008, 0x2a3b: 0x0008,
	0x2a3c: 0x0008, 0x2a3d: 0x0008, 0x2a3e: 0x0008, 0x2a3f: 0x0008,
	// Block 0xa9, offset 0x2a40
	0x2a42: 0x0008, 0x2a43: 0x0008, 0x2a44: 0x0008,
	0x2a46: 0x0008,
	0x2a5e: 0x0008,
	// Block 0xaa, offset 0x2a80
	0x2ab3: 0x0008, 0x2ab4: 0x0008, 0x2ab5: 0x0008,
	0x2ab6: 0x0008, 0x2ab7: 0x0008, 0x2ab8: 0x0008, 0x2aba: 0x0008,
	0x2abf: 0x0008,
	// Block 0xab, offset 0x2ac0
	0x2ac0: 0x0008, 0x2ac2: 0x0008, 0x2ac3: 0x0008,
	// Block 0xac, offset 0x2b00
	0x2b32: 0x0008, 0x2b33: 0x0008, 0x2b34: 0x0008, 0x2b35: 0x0008,
	0x2b3c: 0x0008, 0x2b3d: 0x0008, 0x2b3f: 0x0008,
	// Block 0xad, offset 0x2b40
	0x2b40: 0x0008,
	0x2b5c: 0x0008, 0x2b5d: 0x0008,
	// Block 0xae, offset 0x2b80
	0x2bb3: 0x0008, 0x2bb4: 0x0008, 0x2bb5: 0x0008,
	0x2bb6: 0x0008, 0x2bb7: 0x0008, 0x2bb8: 0x0008, 0x2bb9: 0x0008, 0x2bba: 0x0008,
	0x2bbd: 0x0008, 0x2bbf: 0x0008,
	// Block 0xaf, offset 0x2bc0
	0x2bc0: 0x0008,
	// Block 0xb0, offset 0x2c00
	0x2c2b: 0x0008, 0x2c2d: 0x0008,
	0x2c30: 0x0008, 0x2c31: 0x0008, 0x2c32: 0x0008, 0x2c33: 0x0008, 0x2c34: 0x0008, 0x2c35: 0x0008,
	0x2c37: 0x0008,
	// Block 0xb1, offset 0x2c40
	0x2c5d: 0x0008,
	0x2c5e: 0x0008, 0x2c5f: 0x0008, 0x2c62: 0x0008, 0x2c63: 0x0008,
	0x2c64: 0x0008, 0x2c65: 0x0008, 0x2c67: 0x0008, 0x2c68: 0x0008, 0x2c69: 0x0008,
	0x2c6a: 0x0008, 0x2c6b: 0x0008,
	// Block 0xb2, offset 0x2c80
	0x2caf: 0x0008,
	0x2cb0: 0x0008, 0x2cb1: 0x0008, 0x2cb2: 0x0008, 0x2cb3: 0x0008, 0x2cb4: 0x0008, 0x2cb5: 0x0008,
	0x2cb6: 0x0008, 0x2cb7: 0x0008, 0x2cb9: 0x0008, 0x2cba: 0x0008,
	// Block 0xb3, offset 0x2cc0
	0x2cfb: 0x0008,
	0x2cfc: 0x0008, 0x2cfe: 0x0008,
	// Block 0xb4, offset 0x2d00
	0x2d03: 0x0008,
	// Block 0xb5, offset 0x2d40
	0x2d54: 0x0008, 0x2d55: 0x0008, 0x2d56: 0x0008, 0x2d57: 0x0008,
	0x2d5a: 0x0008, 0x2d5b: 0x0008,
	0x2d60: 0x0008,
	// Block 0xb6, offset 0x2d80
	0x2d81: 0x0008, 0x2d82: 0x0008, 0x2d83: 0x0008, 0x2d84: 0x0008, 0x2d85: 0x0008,
	0x2d86: 0x0008, 0x2d87: 0x0008, 0x2d88: 0x0008, 0x2d89: 0x0008, 0x2d8a: 0x0008,
	0x2db3: 0x0008, 0x2db4: 0x0008, 0x2db5: 0x0008,
	0x2db6: 0x0008, 0x2db7: 0x0008, 0x2db8: 0x0008, 0x2dbb: 0x0008,
	0x2dbc: 0x0008, 0x2dbd: 0x0008, 0x2dbe: 0x0008,
	// Block 0xb7, offset 0x2dc0
	0x2dc7: 0x0008,
	0x2dd1: 0x0008,
	0x2dd2: 0x0008, 0x2dd3: 0x0008, 0x2dd4: 0x0008, 0x2dd5: 0x0008, 0x2dd6: 0x0008,
	0x2dd9: 0x0008, 0x2dda: 0x0008, 0x2ddb: 0x0008,
	// Block 0xb8, offset 0x2e00
	0x2e0a: 0x0008, 0x2e0b: 0x0008,
	0x2e0c: 0x0008, 0x2e0d: 0x0008, 0x2e0e: 0x0008, 0x2e0f: 0x0008, 0x2e10: 0x0008, 0x2e11: 0x0008,
	0x2e12: 0x0008, 0x2e13: 0x0008, 0x2e14: 0x0008, 0x2e15: 0x0008, 0x2e16: 0x0008,
	0x2e18: 0x0008, 0x2e19: 0x0008,
	// Block 0xb9, offset 0x2e40
	0x2e70: 0x0008, 0x2e71: 0x0008, 0x2e72: 0x0008, 0x2e73: 0x0008, 0x2e74: 0x0008, 0x2e75: 0x0008,
	0x2e76: 0x0008, 0x2e78: 0x0008, 0x2e79: 0x0008, 0x2e7a: 0x0008, 0x2e7b: 0x0008,
	0x2e7c: 0x0008, 0x2e7d: 0x0008, 0x2e7f: 0x0008,
	// Block 0xba, offset 0x2e80
	0x2e92: 0x0008, 0x2e93: 0x0008, 0x2e94: 0x0008, 0x2e95: 0x0008, 0x2e96: 0x0008, 0x2e97: 0x0008,
	0x2e98: 0x0008, 0x2e99: 0x0008, 0x2e9a: 0x0008, 0x2e9b: 0x0008, 0x2e9c: 0x0008, 0x2e9d: 0x0008,
	0x2e9e: 0x0008, 0x2e9f: 0x0008, 0x2ea0: 0x0008, 0x2ea1: 0x0008, 0x2ea2: 0x0008, 0x2ea3: 0x0008,
	0x2ea4: 0x0008, 0x2ea5: 0x0008, 0x2ea6: 0x0008, 0x2ea7: 0x0008,
	0x2eaa: 0x0008, 0x2eab: 0x0008, 0x2eac: 0x0008, 0x2ead: 0x0008, 0x2eae: 0x0008, 0x2eaf: 0x0008,
	0x2eb0: 0x0008, 0x2eb2: 0x0008, 0x2eb3: 0x0008, 0x2eb5: 0x0008,
	0x2eb6: 0x0008,
	// Block 0xbb, offset 0x2ec0
	0x2ef1: 0x0008, 0x2ef2: 0x0008, 0x2ef3: 0x0008, 0x2ef4: 0x0008, 0x2ef5: 0x0008,
	0x2ef6: 0x0008, 0x2efa: 0x0008,
	0x2efc: 0x0008, 0x2efd: 0x0008, 0x2eff: 0x0008,
	// Block 0xbc, offset 0x2f00
	0x2f00: 0x0008, 0x2f01: 0x0008, 0x2f02: 0x0008, 0x2f03: 0x0008, 0x2f04: 0x0008, 0x2f05: 0x0008,
	0x2f07: 0x0008,
	// Block 0xbd, offset 0x2f40
	0x2f50: 0x0008, 0x2f51: 0x0008,
	0x2f55: 0x0008, 0x2f57: 0x0008,
	// Block 0xbe, offset 0x2f80
	0x2fb3: 0x0008, 0x2fb4: 0x0008,
	// Block 0xbf, offset 0x2fc0
	0x2fc0: 0x0008, 0x2fc1: 0x0008,
	0x2ff6: 0x0008, 0x2ff7: 0x0008, 0x2ff8: 0x0008, 0x2ff9: 0x0008, 0x2ffa: 0x0008,
	// Block 0xc0, offset 0x3000
	0x3000: 0x0008, 0x3002: 0x0008,
	// Block 0xc1, offset 0x3040
	0x3040: 0x0008,
	0x3047: 0x0008, 0x3048: 0x0008, 0x3049: 0x0008, 0x304a: 0x0008, 0x304b: 0x0008,
	0x304c: 0x0008, 0x304d: 0x0008, 0x304e: 0x0008, 0x304f: 0x0008, 0x3050: 0x0008, 0x3051: 0x0008,
	0x3052: 0x0008, 0x3053: 0x0008, 0x3054: 0x0008, 0x3055: 0x0008,
	// Block 0xc2, offset 0x3080
	0x30b0: 0x0008, 0x30b1: 0x0008, 0x30b2: 0x0008, 0x30b3: 0x0008, 0x30b4: 0x0008,
	// Block 0xc3, offset 0x30c0
	0x30f0: 0x0008, 0x30f1: 0x0008, 0x30f2: 0x0008, 0x30f3: 0x0008, 0x30f4: 0x0008, 0x30f5: 0x0008,
	0x30f6: 0x0008,
	// Block 0xc4, offset 0x3100
	0x310f: 0x0008,
	// Block 0xc5, offset 0x3140
	0x314f: 0x0008, 0x3150: 0x0008, 0x3151: 0x0008,
	0x3152: 0x0008,
	// Block 0xc6, offset 0x3180
	0x31a0: 0x0001, 0x31a1: 0x0001, 0x31a2: 0x0001, 0x31a3: 0x0001,
	0x31a4: 0x0009,
	0x31b0: 0x0001, 0x31b1: 0x0001,
	// Block 0xc7, offset 0x31c0
	0x31c0: 0x0001, 0x31c1: 0x0001, 0x31c2: 0x0001, 0x31c3: 0x0001, 0x31c4: 0x0001, 0x31c5: 0x0001,
	0x31c6: 0x0001, 0x31c7: 0x0001, 0x31c8: 0x0001, 0x31c9: 0x0001, 0x31ca: 0x0001, 0x31cb: 0x0001,
	0x31cc: 0x0001, 0x31cd: 0x0001, 0x31ce: 0x0001, 0x31cf: 0x0001, 0x31d0: 0x0001, 0x31d1: 0x0001,
	0x31d2: 0x0001, 0x31d3: 0x0001, 0x31d4: 0x0001, 0x31d5: 0x0001, 0x31d6: 0x0001, 0x31d7: 0x0001,
	0x31d8: 0x0001, 0x31d9: 0x0001, 0x31da: 0x0001, 0x31db: 0x0001, 0x31dc: 0x0001, 0x31dd: 0x0001,
	0x31de: 0x0001, 0x31df: 0x0001, 0x31e0: 0x0001, 0x31e1: 0x0001, 0x31e2: 0x0001, 0x31e3: 0x0001,
	0x31e4: 0x0001, 0x31e5: 0x0001, 0x31e6: 0x0001, 0x31e7: 0x0001, 0x31e8: 0x0001, 0x31e9: 0x0001,
	0x31ea: 0x0001, 0x31eb: 0x0001, 0x31ec: 0x0001, 0x31ed: 0x0001, 0x31ee: 0x0001, 0x31ef: 0x0001,
	0x31f0: 0x0001, 0x31f1: 0x0001, 0x31f2: 0x0001, 0x31f3: 0x0001, 0x31f4: 0x0001, 0x31f5: 0x0001,
	0x31f6: 0x0001, 0x31f7: 0x0001,
	// Block 0xc8, offset 0x3200
	0x3200: 0x0001, 0x3201: 0x0001, 0x3202: 0x0001, 0x3203: 0x0001, 0x3204: 0x0001, 0x3205: 0x0001,
	0x3206: 0x0001, 0x3207: 0x0001, 0x3208: 0x0001, 0x3209: 0x0001, 0x320a: 0x0001, 0x320b: 0x0001,
	0x320c: 0x0001, 0x320d: 0x0001, 0x320e: 0x0001, 0x320f: 0x0001, 0x3210: 0x0001, 0x3211: 0x0001,
	0x3212: 0x0001, 0x3213: 0x0001, 0x3214: 0x0001, 0x3215: 0x0001,
	// Block 0xc9, offset 0x3240
	0x3240: 0x0001, 0x3241: 0x0001, 0x3242: 0x0001, 0x3243: 0x0001, 0x3244: 0x0001, 0x3245: 0x0001,
	0x3246: 0x0001, 0x3247: 0x0001, 0x3248: 0x0001,
	// Block 0xca, offset 0x3280
	0x32b0: 0x0001, 0x32b1: 0x0001, 0x32b2: 0x0001, 0x32b3: 0x0001, 0x32b5: 0x0001,
	0x32b6: 0x0001, 0x32b7: 0x0001, 0x32b8: 0x0001, 0x32b9: 0x0001, 0x32ba: 0x0001, 0x32bb: 0x0001,
	0x32bd: 0x0001, 0x32be: 0x0001,
	// Block 0xcb, offset 0x32c0
	0x32c0: 0x0001, 0x32c1: 0x0001, 0x32c2: 0x0001, 0x32c3: 0x0001, 0x32c4: 0x0001, 0x32c5: 0x0001,
	0x32c6: 0x0001, 0x32c7: 0x0001, 0x32c8: 0x0001, 0x32c9: 0x0001, 0x32ca: 0x0001, 0x32cb: 0x0001,
	0x32cc: 0x0001, 0x32cd: 0x0001, 0x32ce: 0x0001, 0x32cf: 0x0001, 0x32d0: 0x0001, 0x32d1: 0x0001,
	0x32d2: 0x0001, 0x32d3: 0x0001, 0x32d4: 0x0001, 0x32d5: 0x0001, 0x32d6: 0x0001, 0x32d7: 0x0001,
	0x32d8: 0x0001, 0x32d9: 0x0001, 0x32da: 0x0001, 0x32db: 0x0001, 0x32dc: 0x0001, 0x32dd: 0x0001,
	0x32de: 0x0001, 0x32df: 0x0001, 0x32e0: 0x0001, 0x32e1: 0x0001, 0x32e2: 0x0001,
	0x32f2: 0x0001,
	// Block 0xcc, offset 0x3300
	0x3310: 0x0001, 0x3311: 0x0001,
	0x3312: 0x0001, 0x3315: 0x0001,
	0x3324: 0x0001, 0x3325: 0x0001, 0x3326: 0x0001, 0x3327: 0x0001,
	0x3330: 0x0001, 0x3331: 0x0001, 0x3332: 0x0001, 0x3333: 0x0001, 0x3334: 0x0001, 0x3335: 0x0001,
	0x3336: 0x0001, 0x3337: 0x0001, 0x3338: 0x0001, 0x3339: 0x0001, 0x333a: 0x0001, 0x333b: 0x0001,
	0x333c: 0x0001, 0x333d: 0x0001, 0x333e: 0x0001, 0x333f: 0x0001,
	// Block 0xcd, offset 0x3340
	0x3340: 0x0001, 0x3341: 0x0001, 0x3342: 0x0001, 0x3343: 0x0001, 0x3344: 0x0001, 0x3345: 0x0001,
	0x3346: 0x0001, 0x3347: 0x0001, 0x3348: 0x0001, 0x3349: 0x0001, 0x334a: 0x0001, 0x334b: 0x0001,
	0x334c: 0x0001, 0x334d: 0x0001, 0x334e: 0x0001, 0x334f: 0x0001, 0x3350: 0x0001, 0x3351: 0x0001,
	0x3352: 0x0001, 0x3353: 0x0001, 0x3354: 0x0001, 0x3355: 0x0001, 0x3356: 0x0001, 0x3357: 0x0001,
	0x3358: 0x0001, 0x3359: 0x0001, 0x335a: 0x0001, 0x335b: 0x0001, 0x335c: 0x0001, 0x335d: 0x0001,
	0x335e: 0x0001, 0x335f: 0x0001, 0x3360: 0x0001, 0x3361: 0x0001, 0x3362: 0x0001, 0x3363: 0x0001,
	0x3364: 0x0001, 0x3365: 0x0001, 0x3366: 0x0001, 0x3367: 0x0001, 0x3368: 0x0001, 0x3369: 0x0001,
	0x336a: 0x0001, 0x336b: 0x0001, 0x336c: 0x0001, 0x336d: 0x0001, 0x336e: 0x0001, 0x336f: 0x0001,
	0x3370: 0x0001, 0x3371: 0x0001, 0x3372: 0x0001, 0x3373: 0x0001, 0x3374: 0x0001, 0x3375: 0x0001,
	0x3376: 0x0001, 0x3377: 0x0001, 0x3378: 0x0001, 0x3379: 0x0001, 0x337a: 0x0001, 0x337b: 0x0001,
	// Block 0xce, offset 0x3380
	0x339d: 0x0008,
	0x339e: 0x0008, 0x33a0: 0x0008, 0x33a1: 0x0008, 0x33a2: 0x0008, 0x33a3: 0x0008,
	// Block 0xcf, offset 0x33c0
	0x33c0: 0x0008, 0x33c1: 0x0008, 0x33c2: 0x0008, 0x33c3: 0x0008, 0x33c4: 0x0008, 0x33c5: 0x0008,
	0x33c6: 0x0008, 0x33c7: 0x0008, 0x33c8: 0x0008, 0x33c9: 0x0008, 0x33ca: 0x0008, 0x33cb: 0x0008,
	0x33cc: 0x0008, 0x33cd: 0x0008, 0x33ce: 0x0008, 0x33cf: 0x0008, 0x33d0: 0x0008, 0x33d1: 0x0008,
	0x33d2: 0x0008, 0x33d3: 0x0008, 0x33d4: 0x0008, 0x33d5: 0x0008, 0x33d6: 0x0008, 0x33d7: 0x0008,
	0x33d8: 0x0008, 0x33d9: 0x0008, 0x33da: 0x0008, 0x33db: 0x0008, 0x33dc: 0x0008, 0x33dd: 0x0008,
	0x33de: 0x0008, 0x33df: 0x0008, 0x33e0: 0x0008, 0x33e1: 0x0008, 0x33e2: 0x0008, 0x33e3: 0x0008,
	0x33e4: 0x0008, 0x33e5: 0x0008, 0x33e6: 0x0008, 0x33e7: 0x0008, 0x33e8: 0x0008, 0x33e9: 0x0008,
	0x33ea: 0x0008, 0x33eb: 0x0008, 0x33ec: 0x0008, 0x33ed: 0x0008,
	0x33f0: 0x0008, 0x33f1: 0x0008, 0x33f2: 0x0008, 0x33f3: 0x0008, 0x33f4: 0x0008, 0x33f5: 0x0008,
	0x33f6: 0x0008, 0x33f7: 0x0008, 0x33f8: 0x0008, 0x33f9: 0x0008, 0x33fa: 0x0008, 0x33fb: 0x0008,
	0x33fc: 0x0008, 0x33fd: 0x0008, 0x33fe: 0x0008, 0x33ff: 0x0008,
	// Block 0xd0, offset 0x3400
	0x3400: 0x0008, 0x3401: 0x0008, 0x3402: 0x0008, 0x3403: 0x0008, 0x3404: 0x0008, 0x3405: 0x0008,
	0x3406: 0x0008,
	// Block 0xd1, offset 0x3440
	0x3467: 0x0008, 0x3468: 0x0008, 0x3469: 0x0008,
	0x3473: 0x0008, 0x3474: 0x0008, 0x3475: 0x0008,
	0x3476: 0x0008, 0x3477: 0x0008, 0x3478: 0x0008, 0x3479: 0x0008, 0x347a: 0x0008, 0x347b: 0x0008,
	0x347c: 0x0008, 0x347d: 0x0008, 0x347e: 0x0008, 0x347f: 0x0008,
	// Block 0xd2, offset 0x3480
	0x3480: 0x0008, 0x3481: 0x0008, 0x3482: 0x0008, 0x3485: 0x0008,
	0x3486: 0x0008, 0x3487: 0x0008, 0x3488: 0x0008, 0x3489: 0x0008, 0x348a: 0x0008, 0x348b: 0x0008,
	0x34aa: 0x0008, 0x34ab: 0x0008, 0x34ac: 0x0008, 0x34ad: 0x0008,
	// Block 0xd3, offset 0x34c0
	0x34c2: 0x0008, 0x34c3: 0x0008, 0x34c4: 0x0008,
	// Block 0xd4, offset 0x3500
	0x3500: 0x0008, 0x3501: 0x0008, 0x3502: 0x0008, 0x3503: 0x0008, 0x3504: 0x0008, 0x3505: 0x0008,
	0x3506: 0x0008, 0x3507: 0x0008, 0x3508: 0x0008, 0x3509: 0x0008, 0x350a: 0x0008, 0x350b: 0x0008,
	0x350c: 0x0008, 0x350d: 0x0008, 0x350e: 0x0008, 0x350f: 0x0008, 0x3510: 0x0008, 0x3511: 0x0008,
	0x3512: 0x0008, 0x3513: 0x0008, 0x3514: 0x0008, 0x3515: 0x0008, 0x3516: 0x0008, 0x3517: 0x0008,
	0x3518: 0x0008, 0x3519: 0x0008, 0x351a: 0x0008, 0x351b: 0x0008, 0x351c: 0x0008, 0x351d: 0x0008,
	0x351e: 0x0008, 0x351f: 0x0008, 0x3520: 0x0008, 0x3521: 0x0008, 0x3522: 0x0008, 0x3523: 0x0008,
	0x3524: 0x0008, 0x3525: 0x0008, 0x3526: 0x0008, 0x3527: 0x0008, 0x3528: 0x0008, 0x3529: 0x0008,
	0x352a: 0x0008, 0x352b: 0x0008, 0x352c: 0x0008, 0x352d: 0x0008, 0x352e: 0x0008, 0x352f: 0x0008,
	0x3530: 0x0008, 0x3531: 0x0008, 0x3532: 0x0008, 0x3533: 0x0008, 0x3534: 0x0008, 0x3535: 0x0008,
	0x3536: 0x0008, 0x353b: 0x0008,
	0x353c: 0x0008, 0x353d: 0x0008, 0x353e: 0x0008, 0x353f: 0x0008,
	// Block 0xd5, offset 0x3540
	0x3540: 0x0008, 0x3541: 0x0008, 0x3542: 0x0008, 0x3543: 0x0008, 0x3544: 0x0008, 0x3545: 0x0008,
	0x3546: 0x0008, 0x3547: 0x0008, 0x3548: 0x0008, 0x3549: 0x0008, 0x354a: 0x0008, 0x354b: 0x0008,
	0x354c: 0x0008, 0x354d: 0x0008, 0x354e: 0x0008, 0x354f: 0x0008, 0x3550: 0x0008, 0x3551: 0x0008,
	0x3552: 0x0008, 0x3553: 0x0008, 0x3554: 0x0008, 0x3555: 0x0008, 0x3556: 0x0008, 0x3557: 0x0008,
	0x3558: 0x0008, 0x3559: 0x0008, 0x355a: 0x0008, 0x355b: 0x0008, 0x355c: 0x0008, 0x355d: 0x0008,
	0x355e: 0x0008, 0x355f: 0x0008, 0x3560: 0x0008, 0x3561: 0x0008, 0x3562: 0x0008, 0x3563: 0x0008,
	0x3564: 0x0008, 0x3565: 0x0008, 0x3566: 0x0008, 0x3567: 0x0008, 0x3568: 0x0008, 0x3569: 0x0008,
	0x356a: 0x0008, 0x356b: 0x0008, 0x356c: 0x0008,
	0x3575: 0x0008,
	// Block 0xd6, offset 0x3580
	0x3584: 0x0008,
	0x359b: 0x0008, 0x359c: 0x0008, 0x359d: 0x0008,
	0x359e: 0x0008, 0x359f: 0x0008, 0x35a1: 0x0008, 0x35a2: 0x0008, 0x35a3: 0x0008,
	0x35a4: 0x0008, 0x35a5: 0x0008, 0x35a6: 0x0008, 0x35a7: 0x0008, 0x35a8: 0x0008, 0x35a9: 0x0008,
	0x35aa: 0x0008, 0x35ab: 0x0008, 0x35ac: 0x0008, 0x35ad: 0x0008, 0x35ae: 0x0008, 0x35af: 0x0008,
	// Block 0xd7, offset 0x35c0
	0x35c0: 0x0008, 0x35c1: 0x0008, 0x35c2: 0x0008, 0x35c3: 0x0008, 0x35c4: 0x0008, 0x35c5: 0x0008,
	0x35c6: 0x0008, 0x35c8: 0x0008, 0x35c9: 0x0008, 0x35ca: 0x0008, 0x35cb: 0x0008,
	0x35cc: 0x0008, 0x35cd: 0x0008, 0x35ce: 0x0008, 0x35cf: 0x0008, 0x35d0: 0x0008, 0x35d1: 0x0008,
	0x35d2: 0x0008, 0x35d3: 0x0008, 0x35d4: 0x0008, 0x35d5: 0x0008, 0x35d6: 0x0008, 0x35d7: 0x0008,
	0x35d8: 0x0008, 0x35db: 0x0008, 0x35dc: 0x0008, 0x35dd: 0x0008,
	0x35de: 0x0008, 0x35df: 0x0008, 0x35e0: 0x0008, 0x35e1: 0x0008, 0x35e3: 0x0008,
	0x35e4: 0x0008, 0x35e6: 0x0008, 0x35e7: 0x0008, 0x35e8: 0x0008, 0x35e9: 0x0008,
	0x35ea: 0x0008,
	// Block 0xd8, offset 0x3600
	0x362e: 0x0008,
	// Block 0xd9, offset 0x3640
	0x366c: 0x0008, 0x366d: 0x0008, 0x366e: 0x0008, 0x366f: 0x0008,
	// Block 0xda, offset 0x3680
	0x3690: 0x0008, 0x3691: 0x0008,
	0x3692: 0x0008, 0x3693: 0x0008, 0x3694: 0x0008, 0x3695: 0x0008, 0x3696: 0x0008,
	// Block 0xdb, offset 0x36c0
	0x36c4: 0x0008, 0x36c5: 0x0008,
	0x36c6: 0x0008, 0x36c7: 0x0008, 0x36c8: 0x0008, 0x36c9: 0x0008, 0x36ca: 0x0008,
	// Block 0xdc, offset 0x3700
	0x3700: 0x0004, 0x3701: 0x0004, 0x3702: 0x0004, 0x3703: 0x0004, 0x3704: 0x0005, 0x3705: 0x0004,
	0x3706: 0x0004, 0x3707: 0x0004, 0x3708: 0x0004, 0x3709: 0x0004, 0x370a: 0x0004, 0x370b: 0x0004,
	0x370c: 0x0004, 0x370d: 0x0004, 0x370e: 0x0004, 0x370f: 0x0004, 0x3710: 0x0004, 0x3711: 0x0004,
	0x3712: 0x0004, 0x3713: 0x0004, 0x3714: 0x0004, 0x3715: 0x0004, 0x3716: 0x0004, 0x3717: 0x0004,
	0x3718: 0x0004, 0x3719: 0x0004, 0x371a: 0x0004, 0x371b: 0x0004, 0x371c: 0x0004, 0x371d: 0x0004,
	0x371e: 0x0004, 0x371f: 0x0004, 0x3720: 0x0004, 0x3721: 0x0004, 0x3722: 0x0004, 0x3723: 0x0004,
	0x3724: 0x0004, 0x3725: 0x0004, 0x3726: 0x0004, 0x3727: 0x0004, 0x3728: 0x0004, 0x3729: 0x0004,
	0x372a: 0x0004, 0x372b: 0x0004, 0x372c: 0x0004, 0x372d: 0x0004, 0x372e: 0x0004, 0x372f: 0x0004,
	0x3730: 0x0004, 0x3731: 0x0004, 0x3732: 0x0004, 0x3733: 0x0004, 0x3734: 0x0004, 0x3735: 0x0004,
	0x3736: 0x0004, 0x3737: 0x0004, 0x3738: 0x0004, 0x3739: 0x0004, 0x373a: 0x0004, 0x373b: 0x0004,
	0x373c: 0x0004, 0x373d: 0x0004, 0x373e: 0x0004, 0x373f: 0x0004,
	// Block 0xdd, offset 0x3740
	0x3740: 0x0004, 0x3741: 0x0004, 0x3742: 0x0004, 0x3743: 0x0004, 0x3744: 0x0004, 0x3745: 0x0004,
	0x3746: 0x0004, 0x3747: 0x0004, 0x3748: 0x0004, 0x3749: 0x0004, 0x374a: 0x0004, 0x374b: 0x0004,
	0x374c: 0x0004, 0x374d: 0x0004, 0x374e: 0x0004, 0x374f: 0x0004, 0x3750: 0x0004, 0x3751: 0x0004,
	0x3752: 0x0004, 0x3753: 0x0004, 0x3754: 0x0004, 0x3755: 0x0004, 0x3756: 0x0004, 0x3757: 0x0004,
	0x3758: 0x0004, 0x3759: 0x0004, 0x375a: 0x0004, 0x375b: 0x0004, 0x375c: 0x0004, 0x375d: 0x0004,
	0x375e: 0x0004, 0x375f: 0x0004, 0x3760: 0x0004, 0x3761: 0x0004, 0x3762: 0x0004, 0x3763: 0x0004,
	0x3764: 0x0004, 0x3765: 0x0004, 0x3766: 0x0004, 0x3767: 0x0004, 0x3768: 0x0004, 0x3769: 0x0004,
	0x376a: 0x0004, 0x376b: 0x0004, 0x376c: 0x0004, 0x376d: 0x0004, 0x376e: 0x0004, 0x376f: 0x0004,
	0x3770: 0x0004, 0x3771: 0x0004, 0x3772: 0x0004, 0x3773: 0x0004, 0x3774: 0x0004, 0x3775: 0x0004,
	0x3776: 0x0004, 0x3777: 0x0004, 0x3778: 0x0004, 0x3779: 0x0004, 0x377a: 0x0004, 0x377b: 0x0004,
	0x377c: 0x0004, 0x377d: 0x0004, 0x377e: 0x0004, 0x377f: 0x0004,
	// Block 0xde, offset 0x3780
	0x3780: 0x0004, 0x3781: 0x0004, 0x3782: 0x0004, 0x3783: 0x0004, 0x3784: 0x0004, 0x3785: 0x0004,
	0x3786: 0x0004, 0x3787: 0x0004, 0x3788: 0x0004, 0x3789: 0x0004, 0x378a: 0x0004, 0x378b: 0x0004,
	0x378c: 0x0004, 0x378d: 0x0004, 0x378e: 0x0004, 0x378f: 0x0005, 0x3790: 0x0004, 0x3791: 0x0004,
	0x3792: 0x0004, 0x3793: 0x0004, 0x3794: 0x0004, 0x3795: 0x0004, 0x3796: 0x0004, 0x3797: 0x0004,
	0x3798: 0x0004, 0x3799: 0x0004, 0x379a: 0x0004, 0x379b: 0x0004, 0x379c: 0x0004, 0x379d: 0x0004,
	0x379e: 0x0004, 0x379f: 0x0004, 0x37a0: 0x0004, 0x37a1: 0x0004, 0x37a2: 0x0004, 0x37a3: 0x0004,
	0x37a4: 0x0004, 0x37a5: 0x0004, 0x37a6: 0x0004, 0x37a7: 0x0004, 0x37a8: 0x0004, 0x37a9: 0x0004,
	0x37aa: 0x0004, 0x37ab: 0x0004, 0x37ac: 0x0004, 0x37ad: 0x0004, 0x37ae: 0x0004, 0x37af: 0x0004,
	0x37b0: 0x0004, 0x37b1: 0x0004, 0x37b2: 0x0004, 0x37b3: 0x0004, 0x37b4: 0x0004, 0x37b5: 0x0004,
	0x37b6: 0x0004, 0x37b7: 0x0004, 0x37b8: 0x0004, 0x37b9: 0x0004, 0x37ba: 0x0004, 0x37bb: 0x0004,
	0x37bc: 0x0004, 0x37bd: 0x0004, 0x37be: 0x0004, 0x37bf: 0x0004,
	// Block 0xdf, offset 0x37c0
	0x37c0: 0x0002, 0x37c1: 0x0002, 0x37c2: 0x0002, 0x37c3: 0x0002, 0x37c4: 0x0002, 0x37c5: 0x0002,
	0x37c6: 0x0002, 0x37c7: 0x0002, 0x37c8: 0x0002, 0x37c9: 0x0002, 0x37ca: 0x0002,
	0x37cd: 0x0004, 0x37ce: 0x0004, 0x37cf: 0x0004, 0x37d0: 0x0002, 0x37d1: 0x0002,
	0x37d2: 0x0002, 0x37d3: 0x0002, 0x37d4: 0x0002, 0x37d5: 0x0002, 0x37d6: 0x0002, 0x37d7: 0x0002,
	0x37d8: 0x0002, 0x37d9: 0x0002, 0x37da: 0x0002, 0x37db: 0x0002, 0x37dc: 0x0002, 0x37dd: 0x0002,
	0x37de: 0x0002, 0x37df: 0x0002, 0x37e0: 0x0002, 0x37e1: 0x0002, 0x37e2: 0x0002, 0x37e3: 0x0002,
	0x37e4: 0x0002, 0x37e5: 0x0002, 0x37e6: 0x0002, 0x37e7: 0x0002, 0x37e8: 0x0002, 0x37e9: 0x0002,
	0x37ea: 0x0002, 0x37eb: 0x0002, 0x37ec: 0x0002, 0x37ed: 0x0002, 0x37ef: 0x0004,
	0x37f0: 0x0002, 0x37f1: 0x0002, 0x37f2: 0x0002, 0x37f3: 0x0002, 0x37f4: 0x0002, 0x37f5: 0x0002,
	0x37f6: 0x0002, 0x37f7: 0x0002, 0x37f8: 0x0002, 0x37f9: 0x0002, 0x37fa: 0x0002, 0x37fb: 0x0002,
	0x37fc: 0x0002, 0x37fd: 0x0002, 0x37fe: 0x0002, 0x37ff: 0x0002,
	// Block 0xe0, offset 0x3800
	0x3800: 0x0002, 0x3801: 0x0002, 0x3802: 0x0002, 0x3803: 0x0002, 0x3804: 0x0002, 0x3805: 0x0002,
	0x3806: 0x0002, 0x3807: 0x0002, 0x3808: 0x0002, 0x3809: 0x0002, 0x380a: 0x0002, 0x380b: 0x0002,
	0x380c: 0x0002, 0x380d: 0x0002, 0x380e: 0x0002, 0x380f: 0x0002, 0x3810: 0x0002, 0x3811: 0x0002,
	0x3812: 0x0002, 0x3813: 0x0002, 0x3814: 0x0002, 0x3815: 0x0002, 0x3816: 0x0002, 0x3817: 0x0002,
	0x3818: 0x0002, 0x3819: 0x0002, 0x381a: 0x0002, 0x381b: 0x0002, 0x381c: 0x0002, 0x381d: 0x0002,
	0x381e: 0x0002, 0x381f: 0x0002, 0x3820: 0x0002, 0x3821: 0x0002, 0x3822: 0x0002, 0x3823: 0x0002,
	0x3824: 0x0002, 0x3825: 0x0002, 0x3826: 0x0002, 0x3827: 0x0002, 0x3828: 0x0002, 0x3829: 0x0002,
	0x382c: 0x0004, 0x382d: 0x0004, 0x382e: 0x0004, 0x382f: 0x0004,
	0x3830: 0x0006, 0x3831: 0x0006, 0x3832: 0x0002, 0x3833: 0x0002, 0x3834: 0x0002, 0x3835: 0x0002,
	0x3836: 0x0002, 0x3837: 0x0002, 0x3838: 0x0002, 0x3839: 0x0002, 0x383a: 0x0002, 0x383b: 0x0002,
	0x383c: 0x0002, 0x383d: 0x0002, 0x383e: 0x0006, 0x383f: 0x0006,
	// Block 0xe1, offset 0x3840
	0x3840: 0x0002, 0x3841: 0x0002, 0x3842: 0x0002, 0x3843: 0x0002, 0x3844: 0x0002, 0x3845: 0x0002,
	0x3846: 0x0002, 0x3847: 0x0002, 0x3848: 0x0002, 0x3849: 0x0002, 0x384a: 0x0002, 0x384b: 0x0002,
	0x384c: 0x0002, 0x384d: 0x0002, 0x384e: 0x0005, 0x384f: 0x0002, 0x3850: 0x0002, 0x3851: 0x0005,
	0x3852: 0x0005, 0x3853: 0x0005, 0x3854: 0x0005, 0x3855: 0x0005, 0x3856: 0x0005, 0x3857: 0x0005,
	0x3858: 0x0005, 0x3859: 0x0005, 0x385a: 0x0005, 0x385b: 0x0002, 0x385c: 0x0002, 0x385d: 0x0002,
	0x385e: 0x0002, 0x385f: 0x0002, 0x3860: 0x0002, 0x3861: 0x0002, 0x3862: 0x0002, 0x3863: 0x0002,
	0x3864: 0x0002, 0x3865: 0x0002, 0x3866: 0x0002, 0x3867: 0x0002, 0x3868: 0x0002, 0x3869: 0x0002,
	0x386a: 0x0002, 0x386b: 0x0002, 0x386c: 0x0002, 0x386d: 0x0004, 0x386e: 0x0004, 0x386f: 0x0004,
	0x3870: 0x0004, 0x3871: 0x0004, 0x3872: 0x0004, 0x3873: 0x0004, 0x3874: 0x0004, 0x3875: 0x0004,
	0x3876: 0x0004, 0x3877: 0x0004, 0x3878: 0x0004, 0x3879: 0x0004, 0x387a: 0x0004, 0x387b: 0x0004,
	0x387c: 0x0004, 0x387d: 0x0004, 0x387e: 0x0004, 0x387f: 0x0004,
	// Block 0xe2, offset 0x3880
	0x3880: 0x0004, 0x3881: 0x0004, 0x3882: 0x0004, 0x3883: 0x0004, 0x3884: 0x0004, 0x3885: 0x0004,
	0x3886: 0x0004, 0x3887: 0x0004, 0x3888: 0x0004, 0x3889: 0x0004, 0x388a: 0x0004, 0x388b: 0x0004,
	0x388c: 0x0004, 0x388d: 0x0004, 0x388e: 0x0004, 0x388f: 0x0004, 0x3890: 0x0004, 0x3891: 0x0004,
	0x3892: 0x0004, 0x3893: 0x0004, 0x3894: 0x0004, 0x3895: 0x0004, 0x3896: 0x0004, 0x3897: 0x0004,
	0x3898: 0x0004, 0x3899: 0x0004, 0x389a: 0x0004, 0x389b: 0x0004, 0x389c: 0x0004, 0x389d: 0x0004,
	0x389e: 0x0004, 0x389f: 0x0004, 0x38a0: 0x0004, 0x38a1: 0x0004, 0x38a2: 0x0004, 0x38a3: 0x0004,
	0x38a4: 0x0004, 0x38a5: 0x0004,
	// Block 0xe3, offset 0x38c0
	0x38c0: 0x0001, 0x38c1: 0x0005, 0x38c2: 0x0005, 0x38c3: 0x0004, 0x38c4: 0x0004, 0x38c5: 0x0004,
	0x38c6: 0x0004, 0x38c7: 0x0004, 0x38c8: 0x0004, 0x38c9: 0x0004, 0x38ca: 0x0004, 0x38cb: 0x0004,
	0x38cc: 0x0004, 0x38cd: 0x0004, 0x38ce: 0x0004, 0x38cf: 0x0004, 0x38d0: 0x0001, 0x38d1: 0x0001,
	0x38d2: 0x0001, 0x38d3: 0x0001, 0x38d4: 0x0001, 0x38d5: 0x0001, 0x38d6: 0x0001, 0x38d7: 0x0001,
	0x38d8: 0x0001, 0x38d9: 0x0001, 0x38da: 0x0005, 0x38db: 0x0001, 0x38dc: 0x0001, 0x38dd: 0x0001,
	0x38de: 0x0001, 0x38df: 0x0001, 0x38e0: 0x0001, 0x38e1: 0x0001, 0x38e2: 0x0001, 0x38e3: 0x0001,
	0x38e4: 0x0001, 0x38e5: 0x0001, 0x38e6: 0x0001, 0x38e7: 0x0001, 0x38e8: 0x0001, 0x38e9: 0x0001,
	0x38ea: 0x0001, 0x38eb: 0x0001, 0x38ec: 0x0001, 0x38ed: 0x0001, 0x38ee: 0x0001, 0x38ef: 0x0005,
	0x38f0: 0x0001, 0x38f1: 0x0001, 0x38f2: 0x0005, 0x38f3: 0x0005, 0x38f4: 0x0005, 0x38f5: 0x0005,
	0x38f6: 0x0005, 0x38f7: 0x0005, 0x38f8: 0x0005, 0x38f9: 0x0005, 0x38fa: 0x0005, 0x38fb: 0x0001,
	0x38fc: 0x0004, 0x38fd: 0x0004, 0x38fe: 0x0004, 0x38ff: 0x0004,
	// Block 0xe4, offset 0x3900
	0x3900: 0x0001, 0x3901: 0x0001, 0x3902: 0x0001, 0x3903: 0x0001, 0x3904: 0x0001, 0x3905: 0x0001,
	0x3906: 0x0001, 0x3907: 0x0001, 0x3908: 0x0001, 0x3909: 0x0004, 0x390a: 0x0004, 0x390b: 0x0004,
	0x390c: 0x0004, 0x390d: 0x0004, 0x390e: 0x0004, 0x390f: 0x0004, 0x3910: 0x0005, 0x3911: 0x0005,
	0x3912: 0x0004, 0x3913: 0x0004, 0x3914: 0x0004, 0x3915: 0x0004, 0x3916: 0x0004, 0x3917: 0x0004,
	0x3918: 0x0004, 0x3919: 0x0004, 0x391a: 0x0004, 0x391b: 0x0004, 0x391c: 0x0004, 0x391d: 0x0004,
	0x391e: 0x0004, 0x391f: 0x0004, 0x3920: 0x0005, 0x3921: 0x0005, 0x3922: 0x0005, 0x3923: 0x0005,
	0x3924: 0x0005, 0x3925: 0x0005, 0x3926: 0x0004, 0x3927: 0x0004, 0x3928: 0x0004, 0x3929: 0x0004,
	0x392a: 0x0004, 0x392b: 0x0004, 0x392c: 0x0004, 0x392d: 0x0004, 0x392e: 0x0004, 0x392f: 0x0004,
	0x3930: 0x0004, 0x3931: 0x0004, 0x3932: 0x0004, 0x3933: 0x0004, 0x3934: 0x0004, 0x3935: 0x0004,
	0x3936: 0x0004, 0x3937: 0x0004, 0x3938: 0x0004, 0x3939: 0x0004, 0x393a: 0x0004, 0x393b: 0x0004,
	0x393c: 0x0004, 0x393d: 0x0004, 0x393e: 0x0004, 0x393f: 0x0004,
	// Block 0xe5, offset 0x3940
	0x3940: 0x0005, 0x3941: 0x0005, 0x3942: 0x0005, 0x3943: 0x0005, 0x3944: 0x0005, 0x3945: 0x0005,
	0x3946: 0x0005, 0x3947: 0x0005, 0x3948: 0x0005, 0x3949: 0x0005, 0x394a: 0x0005, 0x394b: 0x0005,
	0x394c: 0x0005, 0x394d: 0x0005, 0x394e: 0x0005, 0x394f: 0x0005, 0x3950: 0x0005, 0x3951: 0x0005,
	0x3952: 0x0005, 0x3953: 0x0005, 0x3954: 0x0005, 0x3955: 0x0005, 0x3956: 0x0005, 0x3957: 0x0005,
	0x3958: 0x0005, 0x3959: 0x0005, 0x395a: 0x0005, 0x395b: 0x0005, 0x395c: 0x0005, 0x395d: 0x0005,
	0x395e: 0x0005, 0x395f: 0x0005, 0x3960: 0x0005, 0x3961: 0x0004, 0x3962: 0x0004, 0x3963: 0x0004,
	0x3964: 0x0004, 0x3965: 0x0004, 0x3966: 0x0004, 0x3967: 0x0004, 0x3968: 0x0004, 0x3969: 0x0004,
	0x396a: 0x0004, 0x396b: 0x0004, 0x396c: 0x0004, 0x396d: 0x0005, 0x396e: 0x0005, 0x396f: 0x0005,
	0x3970: 0x0005, 0x3971: 0x0005, 0x3972: 0x0005, 0x3973: 0x0005, 0x3974: 0x0005, 0x3975: 0x0005,
	0x3976: 0x0004, 0x3977: 0x0005, 0x3978: 0x0005, 0x3979: 0x0005, 0x397a: 0x0005, 0x397b: 0x0005,
	0x397c: 0x0005, 0x397d: 0x0005, 0x397e: 0x0005, 0x397f: 0x0005,
	// Block 0xe6, offset 0x3980
	0x3980: 0x0005, 0x3981: 0x0005, 0x3982: 0x0005, 0x3983: 0x0005, 0x3984: 0x0005, 0x3985: 0x0005,
	0x3986: 0x0005, 0x3987: 0x0005, 0x3988: 0x0005, 0x3989: 0x0005, 0x398a: 0x0005, 0x398b: 0x0005,
	0x398c: 0x0005, 0x398d: 0x0005, 0x398e: 0x0005, 0x398f: 0x0005, 0x3990: 0x0005, 0x3991: 0x0005,
	0x3992: 0x0005, 0x3993: 0x0005, 0x3994: 0x0005, 0x3995: 0x0005, 0x3996: 0x0005, 0x3997: 0x0005,
	0x3998: 0x0005, 0x3999: 0x0005, 0x399a: 0x0005, 0x399b: 0x0005, 0x399c: 0x0005, 0x399d: 0x0005,
	0x399e: 0x0005, 0x399f: 0x0005, 0x39a0: 0x0005, 0x39a1: 0x0005, 0x39a2: 0x0005, 0x39a3: 0x0005,
	0x39a4: 0x0005, 0x39a5: 0x0005, 0x39a6: 0x0005, 0x39a7: 0x0005, 0x39a8: 0x0005, 0x39a9: 0x0005,
	0x39aa: 0x0005, 0x39ab: 0x0005, 0x39ac: 0x0005, 0x39ad: 0x0005, 0x39ae: 0x0005, 0x39af: 0x0005,
	0x39b0: 0x0005, 0x39b1: 0x0005, 0x39b2: 0x0005, 0x39b3: 0x0005, 0x39b4: 0x0005, 0x39b5: 0x0005,
	0x39b6: 0x0005, 0x39b7: 0x0005, 0x39b8: 0x0005, 0x39b9: 0x0005, 0x39ba: 0x0005, 0x39bb: 0x0005,
	0x39bc: 0x0005, 0x39bd: 0x0004, 0x39be: 0x0005, 0x39bf: 0x0005,
	// Block 0xe7, offset 0x39c0
	0x39c0: 0x0005, 0x39c1: 0x0005, 0x39c2: 0x0005, 0x39c3: 0x0005, 0x39c4: 0x0005, 0x39c5: 0x0005,
	0x39c6: 0x0005, 0x39c7: 0x0005, 0x39c8: 0x0005, 0x39c9: 0x0005, 0x39ca: 0x0005, 0x39cb: 0x0005,
	0x39cc: 0x0005, 0x39cd: 0x0005, 0x39ce: 0x0005, 0x39cf: 0x0005, 0x39d0: 0x0005, 0x39d1: 0x0005,
	0x39d2: 0x0005, 0x39d3: 0x0005, 0x39d4: 0x0004, 0x39d5: 0x0004, 0x39d6: 0x0004, 0x39d7: 0x0004,
	0x39d8: 0x0004, 0x39d9: 0x0004, 0x39da: 0x0004, 0x39db: 0x0004, 0x39dc: 0x0004, 0x39dd: 0x0004,
	0x39de: 0x0004, 0x39df: 0x0004, 0x39e0: 0x0005, 0x39e1: 0x0005, 0x39e2: 0x0005, 0x39e3: 0x0005,
	0x39e4: 0x0005, 0x39e5: 0x0005, 0x39e6: 0x0005, 0x39e7: 0x0005, 0x39e8: 0x0005, 0x39e9: 0x0005,
	0x39ea: 0x0005, 0x39eb: 0x0005, 0x39ec: 0x0005, 0x39ed: 0x0005, 0x39ee: 0x0005, 0x39ef: 0x0005,
	0x39f0: 0x0005, 0x39f1: 0x0005, 0x39f2: 0x0005, 0x39f3: 0x0005, 0x39f4: 0x0005, 0x39f5: 0x0005,
	0x39f6: 0x0005, 0x39f7: 0x0005, 0x39f8: 0x0005, 0x39f9: 0x0005, 0x39fa: 0x0005, 0x39fb: 0x0005,
	0x39fc: 0x0005, 0x39fd: 0x0005, 0x39fe: 0x0005, 0x39ff: 0x0005,
	// Block 0xe8, offset 0x3a00
	0x3a00: 0x0005, 0x3a01: 0x0005, 0x3a02: 0x0005, 0x3a03: 0x0005, 0x3a04: 0x0005, 0x3a05: 0x0005,
	0x3a06: 0x0005, 0x3a07: 0x0005, 0x3a08: 0x0005, 0x3a09: 0x0005, 0x3a0a: 0x0005, 0x3a0b: 0x0004,
	0x3a0c: 0x0004, 0x3a0d: 0x0004, 0x3a0e: 0x0004, 0x3a0f: 0x0005, 0x3a10: 0x0005, 0x3a11: 0x0005,
	0x3a12: 0x0005, 0x3a13: 0x0005, 0x3a14: 0x0004, 0x3a15: 0x0004, 0x3a16: 0x0004, 0x3a17: 0x0004,
	0x3a18: 0x0004, 0x3a19: 0x0004, 0x3a1a: 0x0004, 0x3a1b: 0x0004, 0x3a1c: 0x0004, 0x3a1d: 0x0004,
	0x3a1e: 0x0004, 0x3a1f: 0x0004, 0x3a20: 0x0005, 0x3a21: 0x0005, 0x3a22: 0x0005, 0x3a23: 0x0005,
	0x3a24: 0x0005, 0x3a25: 0x0005, 0x3a26: 0x0005, 0x3a27: 0x0005, 0x3a28: 0x0005, 0x3a29: 0x0005,
	0x3a2a: 0x0005, 0x3a2b: 0x0005, 0x3a2c: 0x0005, 0x3a2d: 0x0005, 0x3a2e: 0x0005, 0x3a2f: 0x0005,
	0x3a30: 0x0005, 0x3a31: 0x0004, 0x3a32: 0x0004, 0x3a33: 0x0004, 0x3a34: 0x0005, 0x3a35: 0x0004,
	0x3a36: 0x0004, 0x3a37: 0x0004, 0x3a38: 0x0005, 0x3a39: 0x0005, 0x3a3a: 0x0005, 0x3a3b: 0x0001,
	0x3a3c: 0x0001, 0x3a3d: 0x0001, 0x3a3e: 0x0001, 0x3a3f: 0x0001,
	// Block 0xe9, offset 0x3a40
	0x3a40: 0x0005, 0x3a41: 0x0005, 0x3a42: 0x0005, 0x3a43: 0x0005, 0x3a44: 0x0005, 0x3a45: 0x0005,
	0x3a46: 0x0005, 0x3a47: 0x0005, 0x3a48: 0x0005, 0x3a49: 0x0005, 0x3a4a: 0x0005, 0x3a4b: 0x0005,
	0x3a4c: 0x0005, 0x3a4d: 0x0005, 0x3a4e: 0x0005, 0x3a4f: 0x0005, 0x3a50: 0x0005, 0x3a51: 0x0005,
	0x3a52: 0x0005, 0x3a53: 0x0005, 0x3a54: 0x0005, 0x3a55: 0x0005, 0x3a56: 0x0005, 0x3a57: 0x0005,
	0x3a58: 0x0005, 0x3a59: 0x0005, 0x3a5a: 0x0005, 0x3a5b: 0x0005, 0x3a5c: 0x0005, 0x3a5d: 0x0005,
	0x3a5e: 0x0005, 0x3a5f: 0x0005, 0x3a60: 0x0005, 0x3a61: 0x0005, 0x3a62: 0x0005, 0x3a63: 0x0005,
	0x3a64: 0x0005, 0x3a65: 0x0005, 0x3a66: 0x0005, 0x3a67: 0x0005, 0x3a68: 0x0005, 0x3a69: 0x0005,
	0x3a6a: 0x0005, 0x3a6b: 0x0005, 0x3a6c: 0x0005, 0x3a6d: 0x0005, 0x3a6e: 0x0005, 0x3a6f: 0x0005,
	0x3a70: 0x0005, 0x3a71: 0x0005, 0x3a72: 0x0005, 0x3a73: 0x0005, 0x3a74: 0x0005, 0x3a75: 0x0005,
	0x3a76: 0x0005, 0x3a77: 0x0005, 0x3a78: 0x0005, 0x3a79: 0x0005, 0x3a7a: 0x0005, 0x3a7b: 0x0005,
	0x3a7c: 0x0005, 0x3a7d: 0x0005, 0x3a7e: 0x0005, 0x3a7f: 0x0004,
	// Block 0xea, offset 0x3a80
	0x3a80: 0x0005, 0x3a81: 0x0004, 0x3a82: 0x0005, 0x3a83: 0x0005, 0x3a84: 0x0005, 0x3a85: 0x0005,
	0x3a86: 0x0005, 0x3a87: 0x0005, 0x3a88: 0x0005, 0x3a89: 0x0005, 0x3a8a: 0x0005, 0x3a8b: 0x0005,
	0x3a8c: 0x0005, 0x3a8d: 0x0005, 0x3a8e: 0x0005, 0x3a8f: 0x0005, 0x3a90: 0x0005, 0x3a91: 0x0005,
	0x3a92: 0x0005, 0x3a93: 0x0005, 0x3a94: 0x0005, 0x3a95: 0x0005, 0x3a96: 0x0005, 0x3a97: 0x0005,
	0x3a98: 0x0005, 0x3a99: 0x0005, 0x3a9a: 0x0005, 0x3a9b: 0x0005, 0x3a9c: 0x0005, 0x3a9d: 0x0005,
	0x3a9e: 0x0005, 0x3a9f: 0x0005, 0x3aa0: 0x0005, 0x3aa1: 0x0005, 0x3aa2: 0x0005, 0x3aa3: 0x0005,
	0x3aa4: 0x0005, 0x3aa5: 0x0005, 0x3aa6: 0x0005, 0x3aa7: 0x0005, 0x3aa8: 0x0005, 0x3aa9: 0x0005,
	0x3aaa: 0x0005, 0x3aab: 0x0005, 0x3aac: 0x0005, 0x3aad: 0x0005, 0x3aae: 0x0005, 0x3aaf: 0x0005,
	0x3ab0: 0x0005, 0x3ab1: 0x0005, 0x3ab2: 0x0005, 0x3ab3: 0x0005, 0x3ab4: 0x0005, 0x3ab5: 0x0005,
	0x3ab6: 0x0005, 0x3ab7: 0x0005, 0x3ab8: 0x0005, 0x3ab9: 0x0005, 0x3aba: 0x0005, 0x3abb: 0x0005,
	0x3abc: 0x0005, 0x3abd: 0x0005, 0x3abe: 0x0005, 0x3abf: 0x0005,
	// Block 0xeb, offset 0x3ac0
	0x3ac0: 0x0005, 0x3ac1: 0x0005, 0x3ac2: 0x0005, 0x3ac3: 0x0005, 0x3ac4: 0x0005, 0x3ac5: 0x0005,
	0x3ac6: 0x0005, 0x3ac7: 0x0005, 0x3ac8: 0x0005, 0x3ac9: 0x0005, 0x3aca: 0x0005, 0x3acb: 0x0005,
	0x3acc: 0x0005, 0x3acd: 0x0005, 0x3ace: 0x0005, 0x3acf: 0x0005, 0x3ad0: 0x0005, 0x3ad1: 0x0005,
	0x3ad2: 0x0005, 0x3ad3: 0x0005, 0x3ad4: 0x0005, 0x3ad5: 0x0005, 0x3ad6: 0x0005, 0x3ad7: 0x0005,
	0x3ad8: 0x0005, 0x3ad9: 0x0005, 0x3ada: 0x0005, 0x3adb: 0x0005, 0x3adc: 0x0005, 0x3add: 0x0005,
	0x3ade: 0x0005, 0x3adf: 0x0005, 0x3ae0: 0x0005, 0x3ae1: 0x0005, 0x3ae2: 0x0005, 0x3ae3: 0x0005,
	0x3ae4: 0x0005, 0x3ae5: 0x0005, 0x3ae6: 0x0005, 0x3ae7: 0x0005, 0x3ae8: 0x0005, 0x3ae9: 0x0005,
	0x3aea: 0x0005, 0x3aeb: 0x0005, 0x3aec: 0x0005, 0x3aed: 0x0005, 0x3aee: 0x0005, 0x3aef: 0x0005,
	0x3af0: 0x0005, 0x3af1: 0x0005, 0x3af2: 0x0005, 0x3af3: 0x0005, 0x3af4: 0x0005, 0x3af5: 0x0005,
	0x3af6: 0x0005, 0x3af7: 0x0005, 0x3af8: 0x0005, 0x3af9: 0x0005, 0x3afa: 0x0005, 0x3afb: 0x0005,
	0x3afc: 0x0005, 0x3afd: 0x0005, 0x3afe: 0x0005, 0x3aff: 0x0005,
	// Block 0xec, offset 0x3b00
	0x3b00: 0x0005, 0x3b01: 0x0005, 0x3b02: 0x0005, 0x3b03: 0x0005, 0x3b04: 0x0005, 0x3b05: 0x0005,
	0x3b06: 0x0005, 0x3b07: 0x0005, 0x3b08: 0x0005, 0x3b09: 0x0005, 0x3b0a: 0x0005, 0x3b0b: 0x0005,
	0x3b0c: 0x0005, 0x3b0d: 0x0005, 0x3b0e: 0x0005, 0x3b0f: 0x0005, 0x3b10: 0x0005, 0x3b11: 0x0005,
	0x3b12: 0x0005, 0x3b13: 0x0005, 0x3b14: 0x0005, 0x3b15: 0x0005, 0x3b16: 0x0005, 0x3b17: 0x0005,
	0x3b18: 0x0005, 0x3b19: 0x0005, 0x3b1a: 0x0005, 0x3b1b: 0x0005, 0x3b1c: 0x0005, 0x3b1d: 0x0005,
	0x3b1e: 0x0005, 0x3b1f: 0x0005, 0x3b20: 0x0005, 0x3b21: 0x0005, 0x3b22: 0x0005, 0x3b23: 0x0005,
	0x3b24: 0x0005, 0x3b25: 0x0005, 0x3b26: 0x0005, 0x3b27: 0x0005, 0x3b28: 0x0005, 0x3b29: 0x0005,
	0x3b2a: 0x0005, 0x3b2b: 0x0005, 0x3b2c: 0x0005, 0x3b2d: 0x0005, 0x3b2e: 0x0005, 0x3b2f: 0x0005,
	0x3b30: 0x0005, 0x3b31: 0x0005, 0x3b32: 0x0005, 0x3b33: 0x0005, 0x3b34: 0x0005, 0x3b35: 0x0005,
	0x3b36: 0x0005, 0x3b37: 0x0005, 0x3b38: 0x0005, 0x3b39: 0x0005, 0x3b3a: 0x0005, 0x3b3b: 0x0005,
	0x3b3c: 0x0005, 0x3b3d: 0x0004, 0x3b3e: 0x0004, 0x3b3f: 0x0005,
	// Block 0xed, offset 0x3b40
	0x3b40: 0x0005, 0x3b41: 0x0005, 0x3b42: 0x0005, 0x3b43: 0x0005, 0x3b44: 0x0005, 0x3b45: 0x0005,
	0x3b46: 0x0005, 0x3b47: 0x0005, 0x3b48: 0x0005, 0x3b49: 0x0005, 0x3b4a: 0x0005, 0x3b4b: 0x0005,
	0x3b4c: 0x0005, 0x3b4d: 0x0005, 0x3b4e: 0x0005, 0x3b4f: 0x0005, 0x3b50: 0x0005, 0x3b51: 0x0005,
	0x3b52: 0x0005, 0x3b53: 0x0005, 0x3b54: 0x0005, 0x3b55: 0x0005, 0x3b56: 0x0005, 0x3b57: 0x0005,
	0x3b58: 0x0005, 0x3b59: 0x0005, 0x3b5a: 0x0005, 0x3b5b: 0x0005, 0x3b5c: 0x0005, 0x3b5d: 0x0005,
	0x3b5e: 0x0005, 0x3b5f: 0x0005, 0x3b60: 0x0005, 0x3b61: 0x0005, 0x3b62: 0x0005, 0x3b63: 0x0005,
	0x3b64: 0x0005, 0x3b65: 0x0005, 0x3b66: 0x0005, 0x3b67: 0x0005, 0x3b68: 0x0005, 0x3b69: 0x0005,
	0x3b6a: 0x0005, 0x3b6b: 0x0005, 0x3b6c: 0x0005, 0x3b6d: 0x0005, 0x3b6e: 0x0005, 0x3b6f: 0x0005,
	0x3b70: 0x0005, 0x3b71: 0x0005, 0x3b72: 0x0005, 0x3b73: 0x0005, 0x3b74: 0x0005, 0x3b75: 0x0005,
	0x3b76: 0x0005, 0x3b77: 0x0005, 0x3b78: 0x0005, 0x3b79: 0x0005, 0x3b7a: 0x0005, 0x3b7b: 0x0005,
	0x3b7c: 0x0005, 0x3b7d: 0x0005,
	// Block 0xee, offset 0x3b80
	0x3b86: 0x0004, 0x3b87: 0x0004, 0x3b88: 0x0004, 0x3b89: 0x0004, 0x3b8a: 0x0004, 0x3b8b: 0x0005,
	0x3b8c: 0x0005, 0x3b8d: 0x0005, 0x3b8e: 0x0005, 0x3b8f: 0x0004, 0x3b90: 0x0005, 0x3b91: 0x0005,
	0x3b92: 0x0005, 0x3b93: 0x0005, 0x3b94: 0x0005, 0x3b95: 0x0005, 0x3b96: 0x0005, 0x3b97: 0x0005,
	0x3b98: 0x0005, 0x3b99: 0x0005, 0x3b9a: 0x0005, 0x3b9b: 0x0005, 0x3b9c: 0x0005, 0x3b9d: 0x0005,
	0x3b9e: 0x0005, 0x3b9f: 0x0005, 0x3ba0: 0x0005, 0x3ba1: 0x0005, 0x3ba2: 0x0005, 0x3ba3: 0x0005,
	0x3ba4: 0x0005, 0x3ba5: 0x0005, 0x3ba6: 0x0005, 0x3ba7: 0x0005, 0x3ba8: 0x0004, 0x3ba9: 0x0004,
	0x3baa: 0x0004, 0x3bab: 0x0004, 0x3bac: 0x0004, 0x3bad: 0x0004, 0x3bae: 0x0004, 0x3baf: 0x0004,
	0x3bb0: 0x0004, 0x3bb1: 0x0004, 0x3bb2: 0x0004, 0x3bb3: 0x0004, 0x3bb4: 0x0004, 0x3bb5: 0x0004,
	0x3bb6: 0x0004, 0x3bb7: 0x0004, 0x3bb8: 0x0004, 0x3bb9: 0x0004, 0x3bba: 0x0005, 0x3bbb: 0x0004,
	0x3bbc: 0x0004, 0x3bbd: 0x0004, 0x3bbe: 0x0004, 0x3bbf: 0x0004,
	// Block 0xef, offset 0x3bc0
	0x3bc0: 0x0004, 0x3bc1: 0x0004, 0x3bc2: 0x0004, 0x3bc3: 0x0004, 0x3bc4: 0x0004, 0x3bc5: 0x0004,
	0x3bc6: 0x0004, 0x3bc7: 0x0004, 0x3bc8: 0x0004, 0x3bc9: 0x0004, 0x3bca: 0x0004, 0x3bcb: 0x0004,
	0x3bcc: 0x0004, 0x3bcd: 0x0004, 0x3bce: 0x0004, 0x3bcf: 0x0004, 0x3bd0: 0x0004, 0x3bd1: 0x0004,
	0x3bd2: 0x0004, 0x3bd3: 0x0004, 0x3bd4: 0x0004, 0x3bd5: 0x0005, 0x3bd6: 0x0005, 0x3bd7: 0x0004,
	0x3bd8: 0x0004, 0x3bd9: 0x0004, 0x3bda: 0x0004, 0x3bdb: 0x0004, 0x3bdc: 0x0004, 0x3bdd: 0x0004,
	0x3bde: 0x0004, 0x3bdf: 0x0004, 0x3be0: 0x0004, 0x3be1: 0x0004, 0x3be2: 0x0004, 0x3be3: 0x0004,
	0x3be4: 0x0005, 0x3be5: 0x0004, 0x3be6: 0x0004, 0x3be7: 0x0004, 0x3be8: 0x0004, 0x3be9: 0x0004,
	0x3bea: 0x0004, 0x3beb: 0x0004, 0x3bec: 0x0004, 0x3bed: 0x0004, 0x3bee: 0x0004, 0x3bef: 0x0004,
	0x3bf0: 0x0004, 0x3bf1: 0x0004, 0x3bf2: 0x0004, 0x3bf3: 0x0004, 0x3bf4: 0x0004, 0x3bf5: 0x0004,
	0x3bf6: 0x0004, 0x3bf7: 0x0004, 0x3bf8: 0x0004, 0x3bf9: 0x0004, 0x3bfa: 0x0004, 0x3bfb: 0x0004,
	0x3bfc: 0x0004, 0x3bfd: 0x0004, 0x3bfe: 0x0004, 0x3bff: 0x0004,
	// Block 0xf0, offset 0x3c00
	0x3c00: 0x0004, 0x3c01: 0x0004, 0x3c02: 0x0004, 0x3c03: 0x0004, 0x3c04: 0x0004, 0x3c05: 0x0004,
	0x3c06: 0x0004, 0x3c07: 0x0004, 0x3c08: 0x0004, 0x3c09: 0x0004, 0x3c0a: 0x0004, 0x3c0b: 0x0004,
	0x3c0c: 0x0004, 0x3c0d: 0x0004, 0x3c0e: 0x0004, 0x3c0f: 0x0004, 0x3c10: 0x0004, 0x3c11: 0x0004,
	0x3c12: 0x0004, 0x3c13: 0x0004, 0x3c14: 0x0004, 0x3c15: 0x0004, 0x3c16: 0x0004, 0x3c17: 0x0004,
	0x3c18: 0x0004, 0x3c19: 0x0004, 0x3c1a: 0x0004, 0x3c1b: 0x0004, 0x3c1c: 0x0004, 0x3c1d: 0x0004,
	0x3c1e: 0x0004, 0x3c1f: 0x0004, 0x3c20: 0x0004, 0x3c21: 0x0004, 0x3c22: 0x0004, 0x3c23: 0x0004,
	0x3c24: 0x0004, 0x3c25: 0x0004, 0x3c26: 0x0004, 0x3c27: 0x0004, 0x3c28: 0x0004, 0x3c29: 0x0004,
	0x3c2a: 0x0004, 0x3c2b: 0x0004, 0x3c2c: 0x0004, 0x3c2d: 0x0004, 0x3c2e: 0x0004, 0x3c2f: 0x0004,
	0x3c30: 0x0004, 0x3c31: 0x0004, 0x3c32: 0x0004, 0x3c33: 0x0004, 0x3c34: 0x0004, 0x3c35: 0x0004,
	0x3c36: 0x0004, 0x3c37: 0x0004, 0x3c38: 0x0004, 0x3c39: 0x0004, 0x3c3a: 0x0004, 0x3c3b: 0x0005,
	0x3c3c: 0x0005, 0x3c3d: 0x0005, 0x3c3e: 0x0005, 0x3c3f: 0x0005,
	// Block 0xf1, offset 0x3c40
	0x3c40: 0x0005, 0x3c41: 0x0005, 0x3c42: 0x0005, 0x3c43: 0x0005, 0x3c44: 0x0005, 0x3c45: 0x0005,
	0x3c46: 0x0005, 0x3c47: 0x0005, 0x3c48: 0x0005, 0x3c49: 0x0005, 0x3c4a: 0x0005, 0x3c4b: 0x0005,
	0x3c4c: 0x0005, 0x3c4d: 0x0005, 0x3c4e: 0x0005, 0x3c4f: 0x0005,
	// Block 0xf2, offset 0x3c80
	0x3c80: 0x0005, 0x3c81: 0x0005, 0x3c82: 0x0005, 0x3c83: 0x0005, 0x3c84: 0x0005, 0x3c85: 0x0005,
	0x3c86: 0x0004, 0x3c87: 0x0004, 0x3c88: 0x0004, 0x3c89: 0x0004, 0x3c8a: 0x0004, 0x3c8b: 0x0004,
	0x3c8c: 0x0005, 0x3c8d: 0x0004, 0x3c8e: 0x0004, 0x3c8f: 0x0004, 0x3c90: 0x0005, 0x3c91: 0x0005,
	0x3c92: 0x0005, 0x3c93: 0x0004, 0x3c94: 0x0004, 0x3c95: 0x0005, 0x3c96: 0x0005, 0x3c97: 0x0005,
	0x3c98: 0x0004, 0x3c99: 0x0004, 0x3c9a: 0x0004, 0x3c9b: 0x0004, 0x3c9c: 0x0005, 0x3c9d: 0x0005,
	0x3c9e: 0x0005, 0x3c9f: 0x0005, 0x3ca0: 0x0004, 0x3ca1: 0x0004, 0x3ca2: 0x0004, 0x3ca3: 0x0004,
	0x3ca4: 0x0004, 0x3ca5: 0x0004, 0x3ca6: 0x0004, 0x3ca7: 0x0004, 0x3ca8: 0x0004, 0x3ca9: 0x0004,
	0x3caa: 0x0004, 0x3cab: 0x0005, 0x3cac: 0x0005, 0x3cad: 0x0004, 0x3cae: 0x0004, 0x3caf: 0x0004,
	0x3cb0: 0x0004, 0x3cb1: 0x0004, 0x3cb2: 0x0004, 0x3cb3: 0x0004, 0x3cb4: 0x0005, 0x3cb5: 0x0005,
	0x3cb6: 0x0005, 0x3cb7: 0x0005, 0x3cb8: 0x0005, 0x3cb9: 0x0005, 0x3cba: 0x0005, 0x3cbb: 0x0005,
	0x3cbc: 0x0005, 0x3cbd: 0x0004, 0x3cbe: 0x0004, 0x3cbf: 0x0004,
	// Block 0xf3, offset 0x3cc0
	0x3cf4: 0x0004, 0x3cf5: 0x0004,
	0x3cf6: 0x0004, 0x3cf7: 0x0004, 0x3cf8: 0x0004, 0x3cf9: 0x0004, 0x3cfa: 0x0004, 0x3cfb: 0x0004,
	0x3cfc: 0x0004, 0x3cfd: 0x0004, 0x3cfe: 0x0004, 0x3cff: 0x0004,
	// Block 0xf4, offset 0x3d00
	0x3d15: 0x0004, 0x3d16: 0x0004, 0x3d17: 0x0004,
	0x3d18: 0x0004, 0x3d19: 0x0004, 0x3d1a: 0x0004, 0x3d1b: 0x0004, 0x3d1c: 0x0004, 0x3d1d: 0x0004,
	0x3d1e: 0x0004, 0x3d1f: 0x0004, 0x3d20: 0x0005, 0x3d21: 0x0005, 0x3d22: 0x0005, 0x3d23: 0x0005,
	0x3d24: 0x0005, 0x3d25: 0x0005, 0x3d26: 0x0005, 0x3d27: 0x0005, 0x3d28: 0x0005, 0x3d29: 0x0005,
	0x3d2a: 0x0005, 0x3d2b: 0x0005, 0x3d2c: 0x0004, 0x3d2d: 0x0004, 0x3d2e: 0x0004, 0x3d2f: 0x0004,
	0x3d30: 0x0005, 0x3d31: 0x0004, 0x3d32: 0x0004, 0x3d33: 0x0004, 0x3d34: 0x0004, 0x3d35: 0x0004,
	0x3d36: 0x0004, 0x3d37: 0x0004, 0x3d38: 0x0004, 0x3d39: 0x0004, 0x3d3a: 0x0004, 0x3d3b: 0x0004,
	0x3d3c: 0x0004, 0x3d3d: 0x0004, 0x3d3e: 0x0004, 0x3d3f: 0x0004,
	// Block 0xf5, offset 0x3d40
	0x3d4c: 0x0004, 0x3d4d: 0x0004, 0x3d4e: 0x0004, 0x3d4f: 0x0004,
	// Block 0xf6, offset 0x3d80
	0x3d88: 0x0004, 0x3d89: 0x0004, 0x3d8a: 0x0004, 0x3d8b: 0x0004,
	0x3d8c: 0x0004, 0x3d8d: 0x0004, 0x3d8e: 0x0004, 0x3d8f: 0x0004,
	0x3d9a: 0x0004, 0x3d9b: 0x0004, 0x3d9c: 0x0004, 0x3d9d: 0x0004,
	0x3d9e: 0x0004, 0x3d9f: 0x0004,
	// Block 0xf7, offset 0x3dc0
	0x3dc8: 0x0004, 0x3dc9: 0x0004, 0x3dca: 0x0004, 0x3dcb: 0x0004,
	0x3dcc: 0x0004, 0x3dcd: 0x0004, 0x3dce: 0x0004, 0x3dcf: 0x0004,
	0x3dee: 0x0004, 0x3def: 0x0004,
	0x3df0: 0x0004, 0x3df1: 0x0004, 0x3df2: 0x0004, 0x3df3: 0x0004, 0x3df4: 0x0004, 0x3df5: 0x0004,
	0x3df6: 0x0004, 0x3df7: 0x0004, 0x3df8: 0x0004, 0x3df9: 0x0004, 0x3dfa: 0x0004, 0x3dfb: 0x0004,
	0x3dfc: 0x0004, 0x3dfd: 0x0004, 0x3dfe: 0x0004, 0x3dff: 0x0004,
	// Block 0xf8, offset 0x3e00
	0x3e0c: 0x0005, 0x3e0d: 0x0005, 0x3e0e: 0x0005, 0x3e0f: 0x0005, 0x3e10: 0x0005, 0x3e11: 0x0005,
	0x3e12: 0x0005, 0x3e13: 0x0005, 0x3e14: 0x0005, 0x3e15: 0x0005, 0x3e16: 0x0005, 0x3e17: 0x0005,
	0x3e18: 0x0005, 0x3e19: 0x0005, 0x3e1a: 0x0005, 0x3e1b: 0x0005, 0x3e1c: 0x0005, 0x3e1d: 0x0005,
	0x3e1e: 0x0005, 0x3e1f: 0x0005, 0x3e20: 0x0005, 0x3e21: 0x0005, 0x3e22: 0x0005, 0x3e23: 0x0005,
	0x3e24: 0x0005, 0x3e25: 0x0005, 0x3e26: 0x0005, 0x3e27: 0x0005, 0x3e28: 0x0005, 0x3e29: 0x0005,
	0x3e2a: 0x0005, 0x3e2b: 0x0005, 0x3e2c: 0x0005, 0x3e2d: 0x0005, 0x3e2e: 0x0005, 0x3e2f: 0x0005,
	0x3e30: 0x0005, 0x3e31: 0x0005, 0x3e32: 0x0005, 0x3e33: 0x0005, 0x3e34: 0x0005, 0x3e35: 0x0005,
	0x3e36: 0x0005, 0x3e37: 0x0005, 0x3e38: 0x0005, 0x3e39: 0x0005, 0x3e3a: 0x0005,
	0x3e3c: 0x0005, 0x3e3d: 0x0005, 0x3e3e: 0x0005, 0x3e3f: 0x0005,
	// Block 0xf9, offset 0x3e40
	0x3e40: 0x0005, 0x3e41: 0x0005, 0x3e42: 0x0005, 0x3e43: 0x0005, 0x3e44: 0x0005, 0x3e45: 0x0005,
	0x3e47: 0x0005, 0x3e48: 0x0005, 0x3e49: 0x0005, 0x3e4a: 0x0005, 0x3e4b: 0x0005,
	0x3e4c: 0x0005, 0x3e4d: 0x0005, 0x3e4e: 0x0005, 0x3e4f: 0x0005, 0x3e50: 0x0005, 0x3e51: 0x0005,
	0x3e52: 0x0005, 0x3e53: 0x0005, 0x3e54: 0x0005, 0x3e55: 0x0005, 0x3e56: 0x0005, 0x3e57: 0x0005,
	0x3e58: 0x0005, 0x3e59: 0x0005, 0x3e5a: 0x0005, 0x3e5b: 0x0005, 0x3e5c: 0x0005, 0x3e5d: 0x0005,
	0x3e5e: 0x0005, 0x3e5f: 0x0005, 0x3e60: 0x0005, 0x3e61: 0x0005, 0x3e62: 0x0005, 0x3e63: 0x0005,
	0x3e64: 0x0005, 0x3e65: 0x0005, 0x3e66: 0x0005, 0x3e67: 0x0005, 0x3e68: 0x0005, 0x3e69: 0x0005,
	0x3e6a: 0x0005, 0x3e6b: 0x0005, 0x3e6c: 0x0005, 0x3e6d: 0x0005, 0x3e6e: 0x0005, 0x3e6f: 0x0005,
	0x3e70: 0x0005, 0x3e71: 0x0005, 0x3e72: 0x0005, 0x3e73: 0x0005, 0x3e74: 0x0005, 0x3e75: 0x0005,
	0x3e76: 0x0005, 0x3e77: 0x0005, 0x3e78: 0x0005, 0x3e79: 0x0005, 0x3e7a: 0x0005, 0x3e7b: 0x0005,
	0x3e7c: 0x0005, 0x3e7d: 0x0005, 0x3e7e: 0x0005, 0x3e7f: 0x0005,
	// Block 0xfa, offset 0x3e80
	0x3e80: 0x0004, 0x3e81: 0x0004, 0x3e82: 0x0004, 0x3e83: 0x0004, 0x3e84: 0x0004, 0x3e85: 0x0004,
	0x3e86: 0x0004, 0x3e87: 0x0004, 0x3e88: 0x0004, 0x3e89: 0x0004, 0x3e8a: 0x0004, 0x3e8b: 0x0004,
	0x3e8c: 0x0004, 0x3e8d: 0x0004, 0x3e8e: 0x0004, 0x3e8f: 0x0004, 0x3e90: 0x0004, 0x3e91: 0x0004,
	0x3e92: 0x0004, 0x3e93: 0x0004, 0x3e94: 0x0004, 0x3e95: 0x0004, 0x3e96: 0x0004, 0x3e97: 0x0004,
	0x3e98: 0x0004, 0x3e99: 0x0004, 0x3e9a: 0x0004, 0x3e9b: 0x0004, 0x3e9c: 0x0004, 0x3e9d: 0x0004,
	0x3e9e: 0x0004, 0x3e9f: 0x0004, 0x3ea0: 0x0004, 0x3ea1: 0x0004, 0x3ea2: 0x0004, 0x3ea3: 0x0004,
	0x3ea4: 0x0004, 0x3ea5: 0x0004, 0x3ea6: 0x0004, 0x3ea7: 0x0004, 0x3ea8: 0x0004, 0x3ea9: 0x0004,
	0x3eaa: 0x0004, 0x3eab: 0x0004, 0x3eac: 0x0004, 0x3ead: 0x0004, 0x3eae: 0x0004, 0x3eaf: 0x0004,
	0x3eb0: 0x0005, 0x3eb1: 0x0005, 0x3eb2: 0x0005, 0x3eb3: 0x0005, 0x3eb4: 0x0005, 0x3eb5: 0x0005,
	0x3eb6: 0x0005, 0x3eb7: 0x0005, 0x3eb8: 0x0005, 0x3eb9: 0x0005, 0x3eba: 0x0005, 0x3ebb: 0x0005,
	0x3ebc: 0x0005, 0x3ebd: 0x0004, 0x3ebe: 0x0004, 0x3ebf: 0x0004,
	// Block 0xfb, offset 0x3ec0
	0x3ec0: 0x0005, 0x3ec1: 0x0005, 0x3ec2: 0x0005, 0x3ec3: 0x0005, 0x3ec4: 0x0005, 0x3ec5: 0x0005,
	0x3ec6: 0x0005, 0x3ec7: 0x0005, 0x3ec8: 0x0005, 0x3ec9: 0x0004, 0x3eca: 0x0004, 0x3ecb: 0x0004,
	0x3ecc: 0x0004, 0x3ecd: 0x0004, 0x3ece: 0x0004, 0x3ecf: 0x0004, 0x3ed0: 0x0005, 0x3ed1: 0x0005,
	0x3ed2: 0x0005, 0x3ed3: 0x0005, 0x3ed4: 0x0005, 0x3ed5: 0x0005, 0x3ed6: 0x0005, 0x3ed7: 0x0005,
	0x3ed8: 0x0005, 0x3ed9: 0x0005, 0x3eda: 0x0005, 0x3edb: 0x0005, 0x3edc: 0x0005, 0x3edd: 0x0005,
	0x3ede: 0x0005, 0x3edf: 0x0005, 0x3ee0: 0x0005, 0x3ee1: 0x0005, 0x3ee2: 0x0005, 0x3ee3: 0x0005,
	0x3ee4: 0x0005, 0x3ee5: 0x0005, 0x3ee6: 0x0005, 0x3ee7: 0x0005, 0x3ee8: 0x0005, 0x3ee9: 0x0005,
	0x3eea: 0x0005, 0x3eeb: 0x0005, 0x3eec: 0x0005, 0x3eed: 0x0005, 0x3eee: 0x0005, 0x3eef: 0x0005,
	0x3ef0: 0x0005, 0x3ef1: 0x0005, 0x3ef2: 0x0005, 0x3ef3: 0x0005, 0x3ef4: 0x0005, 0x3ef5: 0x0005,
	0x3ef6: 0x0005, 0x3ef7: 0x0005, 0x3ef8: 0x0005, 0x3ef9: 0x0005, 0x3efa: 0x0005, 0x3efb: 0x0005,
	0x3efc: 0x0005, 0x3efd: 0x0005, 0x3efe: 0x0004, 0x3eff: 0x0005,
	// Block 0xfc, offset 0x3f00
	0x3f00: 0x0005, 0x3f01: 0x0005, 0x3f02: 0x0005, 0x3f03: 0x0005, 0x3f04: 0x0005, 0x3f05: 0x0005,
	0x3f06: 0x0004, 0x3f07: 0x0004, 0x3f08: 0x0004, 0x3f09: 0x0004, 0x3f0a: 0x0004, 0x3f0b: 0x0004,
	0x3f0c: 0x0004, 0x3f0d: 0x0004, 0x3f0e: 0x0005, 0x3f0f: 0x0005, 0x3f10: 0x0005, 0x3f11: 0x0005,
	0x3f12: 0x0005, 0x3f13: 0x0005, 0x3f14: 0x0005, 0x3f15: 0x0005, 0x3f16: 0x0005, 0x3f17: 0x0005,
	0x3f18: 0x0005, 0x3f19: 0x0005, 0x3f1a: 0x0005, 0x3f1b: 0x0005, 0x3f1c: 0x0004, 0x3f1d: 0x0004,
	0x3f1e: 0x0004, 0x3f1f: 0x0004, 0x3f20: 0x0005, 0x3f21: 0x0005, 0x3f22: 0x0005, 0x3f23: 0x0005,
	0x3f24: 0x0005, 0x3f25: 0x0005, 0x3f26: 0x0005, 0x3f27: 0x0005, 0x3f28: 0x0005, 0x3f29: 0x0004,
	0x3f2a: 0x0004, 0x3f2b: 0x0004, 0x3f2c: 0x0004, 0x3f2d: 0x0004, 0x3f2e: 0x0004, 0x3f2f: 0x0004,
	0x3f30: 0x0005, 0x3f31: 0x0005, 0x3f32: 0x0005, 0x3f33: 0x0005, 0x3f34: 0x0005, 0x3f35: 0x0005,
	0x3f36: 0x0005, 0x3f37: 0x0005, 0x3f38: 0x0005, 0x3f39: 0x0004, 0x3f3a: 0x0004, 0x3f3b: 0x0004,
	0x3f3c: 0x0004, 0x3f3d: 0x0004, 0x3f3e: 0x0004, 0x3f3f: 0x0004,
	// Block 0xfd, offset 0x3f40
	0x3f40: 0x0004, 0x3f41: 0x0004, 0x3f42: 0x0004, 0x3f43: 0x0004, 0x3f44: 0x0004, 0x3f45: 0x0004,
	0x3f46: 0x0004, 0x3f47: 0x0004, 0x3f48: 0x0004, 0x3f49: 0x0004, 0x3f4a: 0x0004, 0x3f4b: 0x0004,
	0x3f4c: 0x0004, 0x3f4d: 0x0004, 0x3f4e: 0x0004, 0x3f4f: 0x0004, 0x3f50: 0x0004, 0x3f51: 0x0004,
	0x3f52: 0x0004, 0x3f53: 0x0004, 0x3f54: 0x0004, 0x3f55: 0x0004, 0x3f56: 0x0004, 0x3f57: 0x0004,
	0x3f58: 0x0004, 0x3f59: 0x0004, 0x3f5a: 0x0004, 0x3f5b: 0x0004, 0x3f5c: 0x0004, 0x3f5d: 0x0004,
	0x3f5e: 0x0004, 0x3f5f: 0x0004, 0x3f60: 0x0004, 0x3f61: 0x0004, 0x3f62: 0x0004, 0x3f63: 0x0004,
	0x3f64: 0x0004, 0x3f65: 0x0004, 0x3f66: 0x0004, 0x3f67: 0x0004, 0x3f68: 0x0004, 0x3f69: 0x0004,
	0x3f6a: 0x0004, 0x3f6b: 0x0004, 0x3f6c: 0x0004, 0x3f6d: 0x0004, 0x3f6e: 0x0004, 0x3f6f: 0x0004,
	0x3f70: 0x0004, 0x3f71: 0x0004, 0x3f72: 0x0004, 0x3f73: 0x0004, 0x3f74: 0x0004, 0x3f75: 0x0004,
	0x3f76: 0x0004, 0x3f77: 0x0004, 0x3f78: 0x0004, 0x3f79: 0x0004, 0x3f7a: 0x0004, 0x3f7b: 0x0004,
	0x3f7c: 0x0004, 0x3f7d: 0x0004,
	// Block 0xfe, offset 0x3f80
	0x3f80: 0x0001, 0x3f81: 0x0001, 0x3f82: 0x0001, 0x3f83: 0x0001, 0x3f84: 0x0001, 0x3f85: 0x0001,
	0x3f86: 0x0001, 0x3f87: 0x0001, 0x3f88: 0x0001, 0x3f89: 0x0001, 0x3f8a: 0x0001, 0x3f8b: 0x0001,
	0x3f8c: 0x0001, 0x3f8d: 0x0001, 0x3f8e: 0x0001, 0x3f8f: 0x0001, 0x3f90: 0x0001, 0x3f91: 0x0001,
	0x3f92: 0x0001, 0x3f93: 0x0001, 0x3f94: 0x0001, 0x3f95: 0x0001, 0x3f96: 0x0001, 0x3f97: 0x0001,
	0x3f98: 0x0001, 0x3f99: 0x0001, 0x3f9a: 0x0001, 0x3f9b: 0x0001, 0x3f9c: 0x0001, 0x3f9d: 0x0001,
	0x3f9e: 0x0001, 0x3f9f: 0x0001, 0x3fa0: 0x0001, 0x3fa1: 0x0001, 0x3fa2: 0x0001, 0x3fa3: 0x0001,
	0x3fa4: 0x0001, 0x3fa5: 0x0001, 0x3fa6: 0x0001, 0x3fa7: 0x0001, 0x3fa8: 0x0001, 0x3fa9: 0x0001,
	0x3faa: 0x0001, 0x3fab: 0x0001, 0x3fac: 0x0001, 0x3fad: 0x0001, 0x3fae: 0x0001, 0x3faf: 0x0001,
	0x3fb0: 0x0001, 0x3fb1: 0x0001, 0x3fb2: 0x0001, 0x3fb3: 0x0001, 0x3fb4: 0x0001, 0x3fb5: 0x0001,
	0x3fb6: 0x0001, 0x3fb7: 0x0001, 0x3fb8: 0x0001, 0x3fb9: 0x0001, 0x3fba: 0x0001, 0x3fbb: 0x0001,
	0x3fbc: 0x0001, 0x3fbd: 0x0001,
	// Block 0xff, offset 0x3fc0
	0x3fc1: 0x0008,
	0x3fe0: 0x0008, 0x3fe1: 0x0008, 0x3fe2: 0x0008, 0x3fe3: 0x0008,
	0x3fe4: 0x0008, 0x3fe5: 0x0008, 0x3fe6: 0x0008, 0x3fe7: 0x0008, 0x3fe8: 0x0008, 0x3fe9: 0x0008,
	0x3fea: 0x0008, 0x3feb: 0x0008, 0x3fec: 0x0008, 0x3fed: 0x0008, 0x3fee: 0x0008, 0x3fef: 0x0008,
	0x3ff0: 0x0008, 0x3ff1: 0x0008, 0x3ff2: 0x0008, 0x3ff3: 0x0008, 0x3ff4: 0x0008, 0x3ff5: 0x0008,
	0x3ff6: 0x0008, 0x3ff7: 0x0008, 0x3ff8: 0x0008, 0x3ff9: 0x0008, 0x3ffa: 0x0008, 0x3ffb: 0x0008,
	0x3ffc: 0x0008, 0x3ffd: 0x0008, 0x3ffe: 0x0008, 0x3fff: 0x0008,
	// Block 0x100, offset 0x4000
	0x4000: 0x0002, 0x4001: 0x0002, 0x4002: 0x0002, 0x4003: 0x0002, 0x4004: 0x0002, 0x4005: 0x0002,
	0x4006: 0x0002, 0x4007: 0x0002, 0x4008: 0x0002, 0x4009: 0x0002, 0x400a: 0x0002, 0x400b: 0x0002,
	0x400c: 0x0002, 0x400d: 0x0002, 0x400e: 0x0002, 0x400f: 0x0002, 0x4010: 0x0002, 0x4011: 0x0002,
	0x4012: 0x0002, 0x4013: 0x0002, 0x4014: 0x0002, 0x4015: 0x0002, 0x4016: 0x0002, 0x4017: 0x0002,
	0x4018: 0x0002, 0x4019: 0x0002, 0x401a: 0x0002, 0x401b: 0x0002, 0x401c: 0x0002, 0x401d: 0x0002,
	0x401e: 0x0002, 0x401f: 0x0002, 0x4020: 0x0002, 0x4021: 0x0002, 0x4022: 0x0002, 0x4023: 0x0002,
	0x4024: 0x0002, 0x4025: 0x0002, 0x4026: 0x0002, 0x4027: 0x0002, 0x4028: 0x0002, 0x4029: 0x0002,
	0x402a: 0x0002, 0x402b: 0x0002, 0x402c: 0x0002, 0x402d: 0x0002, 0x402e: 0x0002, 0x402f: 0x0002,
	0x4030: 0x0002, 0x4031: 0x0002, 0x4032: 0x0002, 0x4033: 0x0002, 0x4034: 0x0002, 0x4035: 0x0002,
	0x4036: 0x0002, 0x4037: 0x0002, 0x4038: 0x0002, 0x4039: 0x0002, 0x403a: 0x0002, 0x403b: 0x0002,
	0x403c: 0x0002, 0x403d: 0x0002,
}

// stringWidthIndex: 31 blocks, 1984 entries, 1984 bytes
// Block 0 is the zero block.
var stringWidthIndex = [1984]uint8{
	// Block 0x0, offset 0x0
	// Block 0x1, offset 0x40
	// Block 0x2, offset 0x80
	// Block 0x3, offset 0xc0
	0xc2: 0x01, 0xc3: 0x02, 0xc4: 0x03, 0xc5: 0x04, 0xc7: 0x05,
	0xc9: 0x06, 0xcb: 0x07, 0xcc: 0x08, 0xcd: 0x09, 0xce: 0x0a, 0xcf: 0x0b,
	0xd0: 0x0c, 0xd1: 0x0d, 0xd2: 0x0e, 0xd6: 0x0f, 0xd7: 0x10,
	0xd8: 0x11, 0xd9: 0x12, 0xdb: 0x13, 0xdc: 0x14, 0xdd: 0x15, 0xde: 0x16, 0xdf: 0x17,
	0xe0: 0x02, 0xe1: 0x03, 0xe2: 0x04, 0xe3: 0x05, 0xe4: 0x06, 0xe5: 0x07, 0xe6: 0x07, 0xe7: 0x07,
	0xe8: 0x07, 0xe9: 0x07, 0xea: 0x08, 0xeb: 0x07, 0xec: 0x07, 0xed: 0x09, 0xee: 0x0a, 0xef: 0x0b,
	0xf0: 0x18, 0xf3: 0x1b, 0xf4: 0x1c,
	// Block 0x4, offset 0x100
	0x120: 0x18, 0x121: 0x19, 0x122: 0x1a, 0x123: 0x1b, 0x124: 0x1c, 0x125: 0x1d, 0x126: 0x1e, 0x127: 0x1f,
	0x128: 0x20, 0x129: 0x21, 0x12a: 0x20, 0x12b: 0x22, 0x12c: 0x23, 0x12d: 0x24, 0x12e: 0x25, 0x12f: 0x26,
	0x130: 0x27, 0x131: 0x28, 0x132: 0x23, 0x133: 0x29, 0x134: 0x2a, 0x135: 0x2b, 0x136: 0x2c, 0x137: 0x2d,
	0x138: 0x2e, 0x139: 0x2f, 0x13a: 0x30, 0x13b: 0x31, 0x13c: 0x32, 0x13d: 0x33, 0x13e: 0x34, 0x13f: 0x35,
	// Block 0x5, offset 0x140
	0x140: 0x36, 0x141: 0x37, 0x142: 0x38, 0x144: 0x39, 0x145: 0x3a,
	0x14d: 0x3b,
	0x15c: 0x3c, 0x15d: 0x3d, 0x15e: 0x3e, 0x15f: 0x3f,
	0x160: 0x40, 0x162: 0x41, 0x164: 0x42,
	0x168: 0x43, 0x169: 0x44, 0x16a: 0x45, 0x16b: 0x46, 0x16c: 0x47, 0x16d: 0x48, 0x16e: 0x49, 0x16f: 0x4a,
	0x170: 0x4b, 0x173: 0x4c, 0x177: 0x4d,
	// Block 0x6, offset 0x180
	0x180: 0x4e, 0x181: 0x4f, 0x182: 0x50, 0x183: 0x51, 0x184: 0x52, 0x185: 0x53, 0x186: 0x54, 0x187: 0x55,
	0x188: 0x56, 0x189: 0x57, 0x18a: 0x58, 0x18c: 0x59, 0x18e: 0x5a, 0x18f: 0x5b,
	0x191: 0x5c, 0x192: 0x5d, 0x193: 0x5e, 0x194: 0x5d, 0x195: 0x5f, 0x196: 0x60, 0x197: 0x61,
	0x198: 0x62, 0x199: 0x63, 0x19a: 0x64, 0x19b: 0x65, 0x19c: 0x66, 0x19d: 0x67, 0x19e: 0x68,
	0x1a4: 0x69,
	0x1ac: 0x6a, 0x1ad: 0x6b,
	0x1b3: 0x6c, 0x1b5: 0x6d, 0x1b7: 0x6e,
	0x1ba: 0x6f, 0x1bb: 0x70, 0x1bc: 0x39, 0x1bd: 0x39, 0x1be: 0x39, 0x1bf: 0x71,
	// Block 0x7, offset 0x1c0
	0x1c0: 0x72, 0x1c1: 0x73, 0x1c2: 0x74, 0x1c3: 0x39, 0x1c4: 0x75, 0x1c5: 0x39, 0x1c6: 0x76, 0x1c7: 0x77,
	0x1c8: 0x78, 0x1c9: 0x79, 0x1ca: 0x7a, 0x1cb: 0x39, 0x1cc: 0x39, 0x1cd: 0x39, 0x1ce: 0x39, 0x1cf: 0x39,
	0x1d0: 0x39, 0x1d1: 0x39, 0x1d2: 0x39, 0x1d3: 0x39, 0x1d4: 0x39, 0x1d5: 0x39, 0x1d6: 0x39, 0x1d7: 0x39,
	0x1d8: 0x39, 0x1d9: 0x39, 0x1da: 0x39, 0x1db: 0x39, 0x1dc: 0x39, 0x1dd: 0x39, 0x1de: 0x39, 0x1df: 0x39,
	0x1e0: 0x39, 0x1e1: 0x39, 0x1e2: 0x39, 0x1e3: 0x39, 0x1e4: 0x39, 0x1e5: 0x39, 0x1e6: 0x39, 0x1e7: 0x39,
	0x1e8: 0x39, 0x1e9: 0x39, 0x1ea: 0x39, 0x1eb: 0x39, 0x1ec: 0x39, 0x1ed: 0x39, 0x1ee: 0x39, 0x1ef: 0x39,
	0x1f0: 0x39, 0x1f1: 0x39, 0x1f2: 0x39, 0x1f3: 0x39, 0x1f4: 0x39, 0x1f5: 0x39, 0x1f6: 0x39, 0x1f7: 0x39,
	0x1f8: 0x39, 0x1f9: 0x39, 0x1fa: 0x39, 0x1fb: 0x39, 0x1fc: 0x39, 0x1fd: 0x39, 0x1fe: 0x39, 0x1ff: 0x39,
	// Block 0x8, offset 0x200
	0x200: 0x39, 0x201: 0x39, 0x202: 0x39, 0x203: 0x39, 0x204: 0x39, 0x205: 0x39, 0x206: 0x39, 0x207: 0x39,
	0x208: 0x39, 0x209: 0x39, 0x20a: 0x39, 0x20b: 0x39, 0x20c: 0x39, 0x20d: 0x39, 0x20e: 0x39, 0x20f: 0x39,
	0x210: 0x39, 0x211: 0x39, 0x212: 0x39, 0x213: 0x39, 0x214: 0x39, 0x215: 0x39, 0x216: 0x39, 0x217: 0x39,
	0x218: 0x39, 0x219: 0x39, 0x21a: 0x39, 0x21b: 0x39, 0x21c: 0x39, 0x21d: 0x39, 0x21e: 0x39, 0x21f: 0x39,
	0x220: 0x39, 0x221: 0x39, 0x222: 0x39, 0x223: 0x39, 0x224: 0x39, 0x225: 0x39, 0x226: 0x39, 0x227: 0x39,
	0x228: 0x39, 0x229: 0x39, 0x22a: 0x39, 0x22b: 0x39, 0x22c: 0x39, 0x22d: 0x39, 0x22e: 0x39, 0x22f: 0x39,
	0x230: 0x39, 0x231: 0x39, 0x232: 0x39, 0x233: 0x39, 0x234: 0x39, 0x235: 0x39, 0x236: 0x39,
	0x238: 0x39, 0x239: 0x39, 0x23a: 0x39, 0x23b: 0x39, 0x23c: 0x39, 0x23d: 0x39, 0x23e: 0x39, 0x23f: 0x39,
	// Block 0x9, offset 0x240
	0x240: 0x39, 0x241: 0x39, 0x242: 0x39, 0x243: 0x39, 0x244: 0x39, 0x245: 0x39, 0x246: 0x39, 0x247: 0x39,
	0x248: 0x39, 0x249: 0x39, 0x24a: 0x39, 0x24b: 0x39, 0x24c: 0x39, 0x24d: 0x39, 0x24e: 0x39, 0x24f: 0x39,
	0x250: 0x39, 0x251: 0x39, 0x252: 0x39, 0x253: 0x39, 0x254: 0x39, 0x255: 0x39, 0x256: 0x39, 0x257: 0x39,
	0x258: 0x39, 0x259: 0x39, 0x25a: 0x39, 0x25b: 0x39, 0x25c: 0x39, 0x25d: 0x39, 0x25e: 0x39, 0x25f: 0x39,
	0x260: 0x39, 0x261: 0x39, 0x262: 0x39, 0x263: 0x39, 0x264: 0x39, 0x265: 0x39, 0x266: 0x39, 0x267: 0x39,
	0x268: 0x39, 0x269: 0x39, 0x26a: 0x39, 0x26b: 0x39, 0x26c: 0x39, 0x26d: 0x39, 0x26e: 0x39, 0x26f: 0x39,
	0x270: 0x39, 0x271: 0x39, 0x272: 0x39, 0x273: 0x39, 0x274: 0x39, 0x275: 0x39, 0x276: 0x39, 0x277: 0x39,
	0x278: 0x39, 0x279: 0x39, 0x27a: 0x39, 0x27b: 0x39, 0x27c: 0x39, 0x27d: 0x39, 0x27e: 0x39, 0x27f: 0x39,
	// Block 0xa, offset 0x280
	0x280: 0x39, 0x281: 0x39, 0x282: 0x39, 0x283: 0x39, 0x284: 0x39, 0x285: 0x39, 0x286: 0x39, 0x287: 0x39,
	0x288: 0x39, 0x289: 0x39, 0x28a: 0x39, 0x28b: 0x39, 0x28c: 0x39, 0x28d: 0x39, 0x28e: 0x39, 0x28f: 0x39,
	0x290: 0x39, 0x291: 0x39, 0x292: 0x7b, 0x293: 0x7c,
	0x299: 0x7d, 0x29a: 0x7e, 0x29b: 0x7f,
	0x2a0: 0x80, 0x2a3: 0x81, 0x2a4: 0x82, 0x2a5: 0x83, 0x2a6: 0x84, 0x2a7: 0x85,
	0x2a8: 0x86, 0x2a9: 0x87, 0x2aa: 0x88, 0x2ab: 0x89, 0x2af: 0x8a,
	0x2b0: 0x39, 0x2b1: 0x39, 0x2b2: 0x39, 0x2b3: 0x39, 0x2b4: 0x39, 0x2b5: 0x39, 0x2b6: 0x39, 0x2b7: 0x39,
	0x2b8: 0x39, 0x2b9: 0x39, 0x2ba: 0x39, 0x2bb: 0x39, 0x2bc: 0x39, 0x2bd: 0x39, 0x2be: 0x39, 0x2bf: 0x39,
	// Block 0xb, offset 0x2c0
	0x2c0: 0x39, 0x2c1: 0x39, 0x2c2: 0x39, 0x2c3: 0x39, 0x2c4: 0x39, 0x2c5: 0x39, 0x2c6: 0x39, 0x2c7: 0x39,
	0x2c8: 0x39, 0x2c9: 0x39, 0x2ca: 0x39, 0x2cb: 0x39, 0x2cc: 0x39, 0x2cd: 0x39, 0x2ce: 0x39, 0x2cf: 0x39,
	0x2d0: 0x39, 0x2d1: 0x39, 0x2d2: 0x39, 0x2d3: 0x39, 0x2d4: 0x39, 0x2d5: 0x39, 0x2d6: 0x39, 0x2d7: 0x39,
	0x2d8: 0x39, 0x2d9: 0x39, 0x2da: 0x39, 0x2db: 0x39, 0x2dc: 0x39, 0x2dd: 0x39, 0x2de: 0x8b,
	// Block 0xc, offset 0x300
	0x300: 0x5d, 0x301: 0x5d, 0x302: 0x5d, 0x303: 0x5d, 0x304: 0x5d, 0x305: 0x5d, 0x306: 0x5d, 0x307: 0x5d,
	0x308: 0x5d, 0x309: 0x5d, 0x30a: 0x5d, 0x30b: 0x5d, 0x30c: 0x5d, 0x30d: 0x5d, 0x30e: 0x5d, 0x30f: 0x5d,
	0x310: 0x5d, 0x311: 0x5d, 0x312: 0x5d, 0x313: 0x5d, 0x314: 0x5d, 0x315: 0x5d, 0x316: 0x5d, 0x317: 0x5d,
	0x318: 0x5d, 0x319: 0x5d, 0x31a: 0x5d, 0x31b: 0x5d, 0x31c: 0x5d, 0x31d: 0x5d, 0x31e: 0x5d, 0x31f: 0x5d,
	0x320: 0x5d, 0x321: 0x5d, 0x322: 0x5d, 0x323: 0x5d, 0x324: 0x5d, 0x325: 0x5d, 0x326: 0x5d, 0x327: 0x5d,
	0x328: 0x5d, 0x329: 0x5d, 0x32a: 0x5d, 0x32b: 0x5d, 0x32c: 0x5d, 0x32d: 0x5d, 0x32e: 0x5d, 0x32f: 0x5d,
	0x330: 0x5d, 0x331: 0x5d, 0x332: 0x5d, 0x333: 0x5d, 0x334: 0x5d, 0x335: 0x5d, 0x336: 0x5d, 0x337: 0x5d,
	0x338: 0x5d, 0x339: 0x5d, 0x33a: 0x5d, 0x33b: 0x5d, 0x33c: 0x5d, 0x33d: 0x5d, 0x33e: 0x5d, 0x33f: 0x5d,
	// Block 0xd, offset 0x340
	0x340: 0x5d, 0x341: 0x5d, 0x342: 0x5d, 0x343: 0x5d, 0x344: 0x5d, 0x345: 0x5d, 0x346: 0x5d, 0x347: 0x5d,
	0x348: 0x5d, 0x349: 0x5d, 0x34a: 0x5d, 0x34b: 0x5d, 0x34c: 0x5d, 0x34d: 0x5d, 0x34e: 0x5d, 0x34f: 0x5d,
	0x350: 0x5d, 0x351: 0x5d, 0x352: 0x5d, 0x353: 0x5d, 0x354: 0x5d, 0x355: 0x5d, 0x356: 0x5d, 0x357: 0x5d,
	0x358: 0x5d, 0x359: 0x5d, 0x35a: 0x5d, 0x35b: 0x5d, 0x35c: 0x5d, 0x35d: 0x5d, 0x35e: 0x5d, 0x35f: 0x5d,
	0x360: 0x5d, 0x361: 0x5d, 0x362: 0x5d, 0x363: 0x5d, 0x364: 0x39, 0x365: 0x39, 0x366: 0x39, 0x367: 0x39,
	0x368: 0x39, 0x369: 0x39, 0x36a: 0x39, 0x36b: 0x39, 0x36c: 0x8c,
	0x378: 0x8d, 0x379: 0x8e, 0x37b: 0x6d, 0x37c: 0x73, 0x37d: 0x8f, 0x37f: 0x90,
	// Block 0xe, offset 0x380
	0x387: 0x91,
	0x38b: 0x92, 0x38d: 0x93,
	0x3a8: 0x94, 0x3ab: 0x95,
	0x3b4: 0x96,
	0x3ba: 0x97, 0x3bb: 0x98, 0x3bd: 0x99, 0x3be: 0x9a,
	// Block 0xf, offset 0x3c0
	0x3c0: 0x9b, 0x3c1: 0x9c, 0x3c2: 0x9d, 0x3c3: 0x9e, 0x3c4: 0x9f, 0x3c5: 0xa0, 0x3c6: 0xa1, 0x3c7: 0xa2,
	0x3c8: 0xa3, 0x3c9: 0x2c, 0x3cb: 0xa4, 0x3cc: 0x2a, 0x3cd: 0xa5,
	0x3d0: 0xa6, 0x3d1: 0xa7, 0x3d2: 0xa8, 0x3d3: 0xa9, 0x3d6: 0xaa, 0x3d7: 0xab,
	0x3d8: 0xac, 0x3d9: 0xad, 0x3da: 0xae, 0x3dc: 0xaf,
	0x3e0: 0xb0, 0x3e4: 0xb1, 0x3e5: 0xb2, 0x3e7: 0xb3,
	0x3e8: 0xb4, 0x3e9: 0xb5, 0x3ea: 0xb6,
	0x3f0: 0xb7, 0x3f2: 0xb8, 0x3f4: 0xb9, 0x3f5: 0xba, 0x3f6: 0xbb,
	0x3fb: 0xbc, 0x3fc: 0xbd, 0x3fd: 0xbe,
	// Block 0x10, offset 0x400
	0x410: 0x45, 0x411: 0xbf,
	// Block 0x11, offset 0x440
	0x46b: 0xc0, 0x46c: 0xc1,
	0x47d: 0xc2, 0x47e: 0xc3, 0x47f: 0xc4,
	// Block 0x12, offset 0x480
	0x480: 0x39, 0x481: 0x39, 0x482: 0x39, 0x483: 0x39, 0x484: 0x39, 0x485: 0x39, 0x486: 0x39, 0x487: 0x39,
	0x488: 0x39, 0x489: 0x39, 0x48a: 0x39, 0x48b: 0x39, 0x48c: 0x39, 0x48d: 0x39, 0x48e: 0x39, 0x48f: 0x39,
	0x490: 0x39, 0x491: 0x39, 0x492: 0x39, 0x493: 0x39, 0x494: 0x39, 0x495: 0x39, 0x496: 0x39, 0x497: 0x39,
	0x498: 0x39, 0x499: 0x39, 0x49a: 0x39, 0x49b: 0x39, 0x49c: 0x39, 0x49d: 0x39, 0x49e: 0x39, 0x49f: 0xc5,
	0x4a0: 0x39, 0x4a1: 0x39, 0x4a2: 0x39, 0x4a3: 0x39, 0x4a4: 0x39, 0x4a5: 0x39, 0x4a6: 0x39, 0x4a7: 0x39,
	0x4a8: 0x39, 0x4a9: 0x39, 0x4aa: 0x39, 0x4ab: 0x39, 0x4ac: 0x39, 0x4ad: 0x39, 0x4ae: 0x39, 0x4af: 0x39,
	0x4b0: 0x39, 0x4b1: 0x39, 0x4b2: 0x39, 0x4b3: 0xc6, 0x4b4: 0xc7,
	// Block 0x13, offset 0x4c0
	0x4ff: 0xc8,
	// Block 0x14, offset 0x500
	0x500: 0x39, 0x501: 0x39, 0x502: 0x39, 0x503: 0x39, 0x504: 0xc9, 0x505: 0xca, 0x506: 0x39, 0x507: 0x39,
	0x508: 0x39, 0x509: 0x39, 0x50a: 0x39, 0x50b: 0xcb,
	0x532: 0xcc,
	// Block 0x15, offset 0x540
	0x57c: 0xcd, 0x57d: 0xce,
	// Block 0x16, offset 0x580
	0x585: 0xcf, 0x586: 0xd0,
	0x589: 0xd1,
	0x5a8: 0xd2, 0x5a9: 0xd3, 0x5aa: 0xd4,
	// Block 0x17, offset 0x5c0
	0x5c0: 0xd5, 0x5c2: 0xc2, 0x5c4: 0xc1,
	0x5ca: 0xd6, 0x5cb: 0xd7,
	0x5d3: 0xd7,
	0x5e3: 0xd8, 0x5e5: 0xd9,
	// Block 0x18, offset 0x600
	0x600: 0xda, 0x601: 0xdb, 0x602: 0xdb, 0x603: 0xdc, 0x604: 0xdd, 0x605: 0xde, 0x606: 0xdf, 0x607: 0xe0,
	0x608: 0xe1, 0x609: 0xe2, 0x60a: 0xdb, 0x60b: 0xdb, 0x60c: 0xe3, 0x60d: 0xe4, 0x60e: 0xe5, 0x60f: 0xe6,
	0x610: 0xe7, 0x611: 0xe8, 0x612: 0xe9, 0x613: 0xea, 0x614: 0xeb, 0x615: 0xec, 0x616: 0xed, 0x617: 0xee,
	0x618: 0xe9, 0x619: 0xef, 0x61a: 0xe9, 0x61b: 0xf0, 0x61d: 0xf1, 0x61f: 0xf2,
	0x620: 0xf3, 0x621: 0xf4, 0x622: 0xf5, 0x623: 0xdb, 0x624: 0xf6, 0x625: 0xf7, 0x626: 0xe9, 0x627: 0xe9,
	0x628: 0xdb, 0x629: 0xf8, 0x62a: 0xf9, 0x62b: 0xfa,
	0x630: 0xdb, 0x631: 0xdb, 0x632: 0xdb, 0x633: 0xdb, 0x634: 0xdb, 0x635: 0xdb, 0x636: 0xdb, 0x637: 0xdb,
	0x638: 0xdb, 0x639: 0xdb, 0x63a: 0xdb, 0x63b: 0xdb, 0x63c: 0xdb, 0x63d: 0xdb, 0x63e: 0xdb, 0x63f: 0xfb,
	// Block 0x19, offset 0x640
	0x640: 0x39, 0x641: 0x39, 0x642: 0x39, 0x643: 0x39, 0x644: 0x39, 0x645: 0x39, 0x646: 0x39, 0x647: 0x39,
	0x648: 0x39, 0x649: 0x39, 0x64a: 0x39, 0x64b: 0x39, 0x64c: 0x39, 0x64d: 0x39, 0x64e: 0x39, 0x64f: 0x39,
	0x650: 0x39, 0x651: 0x39, 0x652: 0x39, 0x653: 0x39, 0x654: 0x39, 0x655: 0x39, 0x656: 0x39, 0x657: 0x39,
	0x658: 0x39, 0x659: 0x39, 0x65a: 0x39, 0x65b: 0x39, 0x65c: 0x39, 0x65d: 0x39, 0x65e: 0x39, 0x65f: 0x39,
	0x660: 0x39, 0x661: 0x39, 0x662: 0x39, 0x663: 0x39, 0x664: 0x39, 0x665: 0x39, 0x666: 0x39, 0x667: 0x39,
	0x668: 0x39, 0x669: 0x39, 0x66a: 0x39, 0x66b: 0x39, 0x66c: 0x39, 0x66d: 0x39, 0x66e: 0x39, 0x66f: 0x39,
	0x670: 0x39, 0x671: 0x39, 0x672: 0x39, 0x673: 0x39, 0x674: 0x39, 0x675: 0x39, 0x676: 0x39, 0x677: 0x39,
	0x678: 0x39, 0x679: 0x39, 0x67a: 0x39, 0x67b: 0x39, 0x67c: 0x39, 0x67d: 0x39, 0x67e: 0x39, 0x67f: 0xfc,
	// Block 0x1a, offset 0x680
	0x690: 0x0c, 0x691: 0x0d, 0x693: 0x0e, 0x696: 0x0f, 0x697: 0x07,
	0x698: 0x10, 0x69a: 0x11, 0x69b: 0x12, 0x69c: 0x13, 0x69d: 0x14, 0x69e: 0x15, 0x69f: 0x16,
	0x6a0: 0x07, 0x6a1: 0x07, 0x6a2: 0x07, 0x6a3: 0x07, 0x6a4: 0x07, 0x6a5: 0x07, 0x6a6: 0x07, 0x6a7: 0x07,
	0x6a8: 0x07, 0x6a9: 0x07, 0x6aa: 0x07, 0x6ab: 0x07, 0x6ac: 0x07, 0x6ad: 0x07, 0x6ae: 0x07, 0x6af: 0x17,
	0x6b0: 0x07, 0x6b1: 0x07, 0x6b2: 0x07, 0x6b3: 0x07, 0x6b4: 0x07, 0x6b5: 0x07, 0x6b6: 0x07, 0x6b7: 0x07,
	0x6b8: 0x07, 0x6b9: 0x07, 0x6ba: 0x07, 0x6bb: 0x07, 0x6bc: 0x07, 0x6bd: 0x07, 0x6be: 0x07, 0x6bf: 0x17,
	// Block 0x1b, offset 0x6c0
	0x6c0: 0xfd, 0x6c1: 0x4d, 0x6c4: 0x08, 0x6c5: 0x08, 0x6c6: 0x08, 0x6c7: 0x09,
	// Block 0x1c, offset 0x700
	0x700: 0x5d, 0x701: 0x5d, 0x702: 0x5d, 0x703: 0x5d, 0x704: 0x5d, 0x705: 0x5d, 0x706: 0x5d, 0x707: 0x5d,
	0x708: 0x5d, 0x709: 0x5d, 0x70a: 0x5d, 0x70b: 0x5d, 0x70c: 0x5d, 0x70d: 0x5d, 0x70e: 0x5d, 0x70f: 0x5d,
	0x710: 0x5d, 0x711: 0x5d, 0x712: 0x5d, 0x713: 0x5d, 0x714: 0x5d, 0x715: 0x5d, 0x716: 0x5d, 0x717: 0x5d,
	0x718: 0x5d, 0x719: 0x5d, 0x71a: 0x5d, 0x71b: 0x5d, 0x71c: 0x5d, 0x71d: 0x5d, 0x71e: 0x5d, 0x71f: 0x5d,
	0x720: 0x5d, 0x721: 0x5d, 0x722: 0x5d, 0x723: 0x5d, 0x724: 0x5d, 0x725: 0x5d, 0x726: 0x5d, 0x727: 0x5d,
	0x728: 0x5d, 0x729: 0x5d, 0x72a: 0x5d, 0x72b: 0x5d, 0x72c: 0x5d, 0x72d: 0x5d, 0x72e: 0x5d, 0x72f: 0x5d,
	0x730: 0x5d, 0x731: 0x5d, 0x732: 0x5d, 0x733: 0x5d, 0x734: 0x5d, 0x735: 0x5d, 0x736: 0x5d, 0x737: 0x5d,
	0x738: 0x5d, 0x739: 0x5d, 0x73a: 0x5d, 0x73b: 0x5d, 0x73c: 0x5d, 0x73d: 0x5d, 0x73e: 0x5d, 0x73f: 0xfe,
	// Block 0x1d, offset 0x740
	0x760: 0x19,
	0x770: 0x0a, 0x771: 0x0a, 0x772: 0x0a, 0x773: 0x0a, 0x774: 0x0a, 0x775: 0x0a, 0x776: 0x0a, 0x777: 0x0a,
	0x778: 0x0a, 0x779: 0x0a, 0x77a: 0x0a, 0x77b: 0x0a, 0x77c: 0x0a, 0x77d: 0x0a, 0x77e: 0x0a, 0x77f: 0x1a,
	// Block 0x1e, offset 0x780
	0x780: 0x0a, 0x781: 0x0a, 0x782: 0x0a, 0x783: 0x0a, 0x784: 0x0a, 0x785: 0x0a, 0x786: 0x0a, 0x787: 0x0a,
	0x788: 0x0a, 0x789: 0x0a, 0x78a: 0x0a, 0x78b: 0x0a, 0x78c: 0x0a, 0x78d: 0x0a, 0x78e: 0x0a, 0x78f: 0x1a,
}
