#[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
#[inline]
pub unsafe fn CreateNamedPropertyStore() -> windows_core::Result<super::super::UI::Shell::PropertiesSystem::INamedPropertyStore> {
    windows_targets::link!("mf.dll" "system" fn CreateNamedPropertyStore(ppstore : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        CreateNamedPropertyStore(&mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
#[inline]
pub unsafe fn CreatePropertyStore() -> windows_core::Result<super::super::UI::Shell::PropertiesSystem::IPropertyStore> {
    windows_targets::link!("mfplat.dll" "system" fn CreatePropertyStore(ppstore : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        CreatePropertyStore(&mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn DXVA2CreateDirect3DDeviceManager9(presettoken: *mut u32, ppdevicemanager: *mut Option<IDirect3DDeviceManager9>) -> windows_core::Result<()> {
    windows_targets::link!("dxva2.dll" "system" fn DXVA2CreateDirect3DDeviceManager9(presettoken : *mut u32, ppdevicemanager : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe { DXVA2CreateDirect3DDeviceManager9(presettoken as _, core::mem::transmute(ppdevicemanager)).ok() }
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
#[inline]
pub unsafe fn DXVA2CreateVideoService<P0>(pdd: P0, riid: *const windows_core::GUID, ppservice: *mut *mut core::ffi::c_void) -> windows_core::Result<()>
where
    P0: windows_core::Param<super::super::Graphics::Direct3D9::IDirect3DDevice9>,
{
    windows_targets::link!("dxva2.dll" "system" fn DXVA2CreateVideoService(pdd : * mut core::ffi::c_void, riid : *const windows_core::GUID, ppservice : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe { DXVA2CreateVideoService(pdd.param().abi(), riid, ppservice as _).ok() }
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
#[inline]
pub unsafe fn DXVAHD_CreateDevice<P0>(pd3ddevice: P0, pcontentdesc: *const DXVAHD_CONTENT_DESC, usage: DXVAHD_DEVICE_USAGE, pplugin: Option<PDXVAHDSW_Plugin>) -> windows_core::Result<IDXVAHD_Device>
where
    P0: windows_core::Param<super::super::Graphics::Direct3D9::IDirect3DDevice9Ex>,
{
    windows_targets::link!("dxva2.dll" "system" fn DXVAHD_CreateDevice(pd3ddevice : * mut core::ffi::c_void, pcontentdesc : *const DXVAHD_CONTENT_DESC, usage : DXVAHD_DEVICE_USAGE, pplugin : PDXVAHDSW_Plugin, ppdevice : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        DXVAHD_CreateDevice(pd3ddevice.param().abi(), pcontentdesc, usage, pplugin.unwrap_or(core::mem::zeroed()) as _, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFAddPeriodicCallback<P1>(callback: MFPERIODICCALLBACK, pcontext: P1, pdwkey: Option<*mut u32>) -> windows_core::Result<()>
where
    P1: windows_core::Param<windows_core::IUnknown>,
{
    windows_targets::link!("mfplat.dll" "system" fn MFAddPeriodicCallback(callback : MFPERIODICCALLBACK, pcontext : * mut core::ffi::c_void, pdwkey : *mut u32) -> windows_core::HRESULT);
    unsafe { MFAddPeriodicCallback(callback, pcontext.param().abi(), pdwkey.unwrap_or(core::mem::zeroed()) as _).ok() }
}
#[inline]
pub unsafe fn MFAllocateSerialWorkQueue(dwworkqueue: u32) -> windows_core::Result<u32> {
    windows_targets::link!("mfplat.dll" "system" fn MFAllocateSerialWorkQueue(dwworkqueue : u32, pdwworkqueue : *mut u32) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFAllocateSerialWorkQueue(dwworkqueue, &mut result__).map(|| core::mem::transmute(result__))
    }
}
#[inline]
pub unsafe fn MFAllocateWorkQueue() -> windows_core::Result<u32> {
    windows_targets::link!("mfplat.dll" "system" fn MFAllocateWorkQueue(pdwworkqueue : *mut u32) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFAllocateWorkQueue(&mut result__).map(|| core::mem::transmute(result__))
    }
}
#[inline]
pub unsafe fn MFAllocateWorkQueueEx(workqueuetype: MFASYNC_WORKQUEUE_TYPE) -> windows_core::Result<u32> {
    windows_targets::link!("mfplat.dll" "system" fn MFAllocateWorkQueueEx(workqueuetype : MFASYNC_WORKQUEUE_TYPE, pdwworkqueue : *mut u32) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFAllocateWorkQueueEx(workqueuetype, &mut result__).map(|| core::mem::transmute(result__))
    }
}
#[inline]
pub unsafe fn MFAverageTimePerFrameToFrameRate(unaveragetimeperframe: u64, punnumerator: *mut u32, pundenominator: *mut u32) -> windows_core::Result<()> {
    windows_targets::link!("mfplat.dll" "system" fn MFAverageTimePerFrameToFrameRate(unaveragetimeperframe : u64, punnumerator : *mut u32, pundenominator : *mut u32) -> windows_core::HRESULT);
    unsafe { MFAverageTimePerFrameToFrameRate(unaveragetimeperframe, punnumerator as _, pundenominator as _).ok() }
}
#[inline]
pub unsafe fn MFBeginCreateFile<P3, P4, P5>(accessmode: MF_FILE_ACCESSMODE, openmode: MF_FILE_OPENMODE, fflags: MF_FILE_FLAGS, pwszfilepath: P3, pcallback: P4, pstate: P5) -> windows_core::Result<windows_core::IUnknown>
where
    P3: windows_core::Param<windows_core::PCWSTR>,
    P4: windows_core::Param<IMFAsyncCallback>,
    P5: windows_core::Param<windows_core::IUnknown>,
{
    windows_targets::link!("mfplat.dll" "system" fn MFBeginCreateFile(accessmode : MF_FILE_ACCESSMODE, openmode : MF_FILE_OPENMODE, fflags : MF_FILE_FLAGS, pwszfilepath : windows_core::PCWSTR, pcallback : * mut core::ffi::c_void, pstate : * mut core::ffi::c_void, ppcancelcookie : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFBeginCreateFile(accessmode, openmode, fflags, pwszfilepath.param().abi(), pcallback.param().abi(), pstate.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFBeginRegisterWorkQueueWithMMCSS<P1, P3, P4>(dwworkqueueid: u32, wszclass: P1, dwtaskid: u32, pdonecallback: P3, pdonestate: P4) -> windows_core::Result<()>
where
    P1: windows_core::Param<windows_core::PCWSTR>,
    P3: windows_core::Param<IMFAsyncCallback>,
    P4: windows_core::Param<windows_core::IUnknown>,
{
    windows_targets::link!("mfplat.dll" "system" fn MFBeginRegisterWorkQueueWithMMCSS(dwworkqueueid : u32, wszclass : windows_core::PCWSTR, dwtaskid : u32, pdonecallback : * mut core::ffi::c_void, pdonestate : * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe { MFBeginRegisterWorkQueueWithMMCSS(dwworkqueueid, wszclass.param().abi(), dwtaskid, pdonecallback.param().abi(), pdonestate.param().abi()).ok() }
}
#[inline]
pub unsafe fn MFBeginRegisterWorkQueueWithMMCSSEx<P1, P4, P5>(dwworkqueueid: u32, wszclass: P1, dwtaskid: u32, lpriority: i32, pdonecallback: P4, pdonestate: P5) -> windows_core::Result<()>
where
    P1: windows_core::Param<windows_core::PCWSTR>,
    P4: windows_core::Param<IMFAsyncCallback>,
    P5: windows_core::Param<windows_core::IUnknown>,
{
    windows_targets::link!("mfplat.dll" "system" fn MFBeginRegisterWorkQueueWithMMCSSEx(dwworkqueueid : u32, wszclass : windows_core::PCWSTR, dwtaskid : u32, lpriority : i32, pdonecallback : * mut core::ffi::c_void, pdonestate : * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe { MFBeginRegisterWorkQueueWithMMCSSEx(dwworkqueueid, wszclass.param().abi(), dwtaskid, lpriority, pdonecallback.param().abi(), pdonestate.param().abi()).ok() }
}
#[inline]
pub unsafe fn MFBeginUnregisterWorkQueueWithMMCSS<P1, P2>(dwworkqueueid: u32, pdonecallback: P1, pdonestate: P2) -> windows_core::Result<()>
where
    P1: windows_core::Param<IMFAsyncCallback>,
    P2: windows_core::Param<windows_core::IUnknown>,
{
    windows_targets::link!("mfplat.dll" "system" fn MFBeginUnregisterWorkQueueWithMMCSS(dwworkqueueid : u32, pdonecallback : * mut core::ffi::c_void, pdonestate : * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe { MFBeginUnregisterWorkQueueWithMMCSS(dwworkqueueid, pdonecallback.param().abi(), pdonestate.param().abi()).ok() }
}
#[cfg(feature = "Win32_Graphics_Gdi")]
#[inline]
pub unsafe fn MFCalculateBitmapImageSize(pbmih: *const super::super::Graphics::Gdi::BITMAPINFOHEADER, cbbufsize: u32, pcbimagesize: *mut u32, pbknown: Option<*mut super::super::Foundation::BOOL>) -> windows_core::Result<()> {
    windows_targets::link!("mfplat.dll" "system" fn MFCalculateBitmapImageSize(pbmih : *const super::super::Graphics::Gdi:: BITMAPINFOHEADER, cbbufsize : u32, pcbimagesize : *mut u32, pbknown : *mut super::super::Foundation:: BOOL) -> windows_core::HRESULT);
    unsafe { MFCalculateBitmapImageSize(pbmih, cbbufsize, pcbimagesize as _, pbknown.unwrap_or(core::mem::zeroed()) as _).ok() }
}
#[inline]
pub unsafe fn MFCalculateImageSize(guidsubtype: *const windows_core::GUID, unwidth: u32, unheight: u32) -> windows_core::Result<u32> {
    windows_targets::link!("mfplat.dll" "system" fn MFCalculateImageSize(guidsubtype : *const windows_core::GUID, unwidth : u32, unheight : u32, pcbimagesize : *mut u32) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCalculateImageSize(guidsubtype, unwidth, unheight, &mut result__).map(|| core::mem::transmute(result__))
    }
}
#[inline]
pub unsafe fn MFCancelCreateFile<P0>(pcancelcookie: P0) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::IUnknown>,
{
    windows_targets::link!("mfplat.dll" "system" fn MFCancelCreateFile(pcancelcookie : * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe { MFCancelCreateFile(pcancelcookie.param().abi()).ok() }
}
#[inline]
pub unsafe fn MFCancelWorkItem(key: u64) -> windows_core::Result<()> {
    windows_targets::link!("mfplat.dll" "system" fn MFCancelWorkItem(key : u64) -> windows_core::HRESULT);
    unsafe { MFCancelWorkItem(key).ok() }
}
#[inline]
pub unsafe fn MFCombineSamples<P0, P1>(psample: P0, psampletoadd: P1, dwmaxmergeddurationinms: u32) -> windows_core::Result<super::super::Foundation::BOOL>
where
    P0: windows_core::Param<IMFSample>,
    P1: windows_core::Param<IMFSample>,
{
    windows_targets::link!("mfplat.dll" "system" fn MFCombineSamples(psample : * mut core::ffi::c_void, psampletoadd : * mut core::ffi::c_void, dwmaxmergeddurationinms : u32, pmerged : *mut super::super::Foundation:: BOOL) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCombineSamples(psample.param().abi(), psampletoadd.param().abi(), dwmaxmergeddurationinms, &mut result__).map(|| core::mem::transmute(result__))
    }
}
#[inline]
pub unsafe fn MFCompareFullToPartialMediaType<P0, P1>(pmftypefull: P0, pmftypepartial: P1) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<IMFMediaType>,
    P1: windows_core::Param<IMFMediaType>,
{
    windows_targets::link!("mfplat.dll" "system" fn MFCompareFullToPartialMediaType(pmftypefull : * mut core::ffi::c_void, pmftypepartial : * mut core::ffi::c_void) -> super::super::Foundation:: BOOL);
    unsafe { MFCompareFullToPartialMediaType(pmftypefull.param().abi(), pmftypepartial.param().abi()) }
}
#[inline]
pub unsafe fn MFConvertColorInfoFromDXVA(ptoformat: *mut MFVIDEOFORMAT, dwfromdxva: u32) -> windows_core::Result<()> {
    windows_targets::link!("mfplat.dll" "system" fn MFConvertColorInfoFromDXVA(ptoformat : *mut MFVIDEOFORMAT, dwfromdxva : u32) -> windows_core::HRESULT);
    unsafe { MFConvertColorInfoFromDXVA(ptoformat as _, dwfromdxva).ok() }
}
#[inline]
pub unsafe fn MFConvertColorInfoToDXVA(pdwtodxva: *mut u32, pfromformat: *const MFVIDEOFORMAT) -> windows_core::Result<()> {
    windows_targets::link!("mfplat.dll" "system" fn MFConvertColorInfoToDXVA(pdwtodxva : *mut u32, pfromformat : *const MFVIDEOFORMAT) -> windows_core::HRESULT);
    unsafe { MFConvertColorInfoToDXVA(pdwtodxva as _, pfromformat).ok() }
}
#[inline]
pub unsafe fn MFConvertFromFP16Array(pdest: *mut f32, psrc: *const u16, dwcount: u32) -> windows_core::Result<()> {
    windows_targets::link!("mfplat.dll" "system" fn MFConvertFromFP16Array(pdest : *mut f32, psrc : *const u16, dwcount : u32) -> windows_core::HRESULT);
    unsafe { MFConvertFromFP16Array(pdest as _, psrc, dwcount).ok() }
}
#[inline]
pub unsafe fn MFConvertToFP16Array(pdest: *mut u16, psrc: *const f32, dwcount: u32) -> windows_core::Result<()> {
    windows_targets::link!("mfplat.dll" "system" fn MFConvertToFP16Array(pdest : *mut u16, psrc : *const f32, dwcount : u32) -> windows_core::HRESULT);
    unsafe { MFConvertToFP16Array(pdest as _, psrc, dwcount).ok() }
}
#[inline]
pub unsafe fn MFCopyImage(pdest: *mut u8, ldeststride: i32, psrc: *const u8, lsrcstride: i32, dwwidthinbytes: u32, dwlines: u32) -> windows_core::Result<()> {
    windows_targets::link!("mfplat.dll" "system" fn MFCopyImage(pdest : *mut u8, ldeststride : i32, psrc : *const u8, lsrcstride : i32, dwwidthinbytes : u32, dwlines : u32) -> windows_core::HRESULT);
    unsafe { MFCopyImage(pdest as _, ldeststride, psrc, lsrcstride, dwwidthinbytes, dwlines).ok() }
}
#[inline]
pub unsafe fn MFCreate2DMediaBuffer(dwwidth: u32, dwheight: u32, dwfourcc: u32, fbottomup: bool) -> windows_core::Result<IMFMediaBuffer> {
    windows_targets::link!("mfplat.dll" "system" fn MFCreate2DMediaBuffer(dwwidth : u32, dwheight : u32, dwfourcc : u32, fbottomup : super::super::Foundation:: BOOL, ppbuffer : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreate2DMediaBuffer(dwwidth, dwheight, dwfourcc, fbottomup.into(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreate3GPMediaSink<P0, P1, P2>(pibytestream: P0, pvideomediatype: P1, paudiomediatype: P2) -> windows_core::Result<IMFMediaSink>
where
    P0: windows_core::Param<IMFByteStream>,
    P1: windows_core::Param<IMFMediaType>,
    P2: windows_core::Param<IMFMediaType>,
{
    windows_targets::link!("mf.dll" "system" fn MFCreate3GPMediaSink(pibytestream : * mut core::ffi::c_void, pvideomediatype : * mut core::ffi::c_void, paudiomediatype : * mut core::ffi::c_void, ppimediasink : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreate3GPMediaSink(pibytestream.param().abi(), pvideomediatype.param().abi(), paudiomediatype.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreateAC3MediaSink<P0, P1>(ptargetbytestream: P0, paudiomediatype: P1) -> windows_core::Result<IMFMediaSink>
where
    P0: windows_core::Param<IMFByteStream>,
    P1: windows_core::Param<IMFMediaType>,
{
    windows_targets::link!("mf.dll" "system" fn MFCreateAC3MediaSink(ptargetbytestream : * mut core::ffi::c_void, paudiomediatype : * mut core::ffi::c_void, ppmediasink : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateAC3MediaSink(ptargetbytestream.param().abi(), paudiomediatype.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreateADTSMediaSink<P0, P1>(ptargetbytestream: P0, paudiomediatype: P1) -> windows_core::Result<IMFMediaSink>
where
    P0: windows_core::Param<IMFByteStream>,
    P1: windows_core::Param<IMFMediaType>,
{
    windows_targets::link!("mf.dll" "system" fn MFCreateADTSMediaSink(ptargetbytestream : * mut core::ffi::c_void, paudiomediatype : * mut core::ffi::c_void, ppmediasink : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateADTSMediaSink(ptargetbytestream.param().abi(), paudiomediatype.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreateAMMediaTypeFromMFMediaType<P0>(pmftype: P0, guidformatblocktype: windows_core::GUID, ppamtype: *mut *mut AM_MEDIA_TYPE) -> windows_core::Result<()>
where
    P0: windows_core::Param<IMFMediaType>,
{
    windows_targets::link!("mfplat.dll" "system" fn MFCreateAMMediaTypeFromMFMediaType(pmftype : * mut core::ffi::c_void, guidformatblocktype : windows_core::GUID, ppamtype : *mut *mut AM_MEDIA_TYPE) -> windows_core::HRESULT);
    unsafe { MFCreateAMMediaTypeFromMFMediaType(pmftype.param().abi(), core::mem::transmute(guidformatblocktype), ppamtype as _).ok() }
}
#[inline]
pub unsafe fn MFCreateASFContentInfo() -> windows_core::Result<IMFASFContentInfo> {
    windows_targets::link!("mf.dll" "system" fn MFCreateASFContentInfo(ppicontentinfo : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateASFContentInfo(&mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreateASFIndexer() -> windows_core::Result<IMFASFIndexer> {
    windows_targets::link!("mf.dll" "system" fn MFCreateASFIndexer(ppiindexer : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateASFIndexer(&mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreateASFIndexerByteStream<P0>(picontentbytestream: P0, cbindexstartoffset: u64) -> windows_core::Result<IMFByteStream>
where
    P0: windows_core::Param<IMFByteStream>,
{
    windows_targets::link!("mf.dll" "system" fn MFCreateASFIndexerByteStream(picontentbytestream : * mut core::ffi::c_void, cbindexstartoffset : u64, piindexbytestream : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateASFIndexerByteStream(picontentbytestream.param().abi(), cbindexstartoffset, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreateASFMediaSink<P0>(pibytestream: P0) -> windows_core::Result<IMFMediaSink>
where
    P0: windows_core::Param<IMFByteStream>,
{
    windows_targets::link!("mf.dll" "system" fn MFCreateASFMediaSink(pibytestream : * mut core::ffi::c_void, ppimediasink : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateASFMediaSink(pibytestream.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreateASFMediaSinkActivate<P0, P1>(pwszfilename: P0, pcontentinfo: P1) -> windows_core::Result<IMFActivate>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<IMFASFContentInfo>,
{
    windows_targets::link!("mf.dll" "system" fn MFCreateASFMediaSinkActivate(pwszfilename : windows_core::PCWSTR, pcontentinfo : * mut core::ffi::c_void, ppiactivate : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateASFMediaSinkActivate(pwszfilename.param().abi(), pcontentinfo.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreateASFMultiplexer() -> windows_core::Result<IMFASFMultiplexer> {
    windows_targets::link!("mf.dll" "system" fn MFCreateASFMultiplexer(ppimultiplexer : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateASFMultiplexer(&mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreateASFProfile() -> windows_core::Result<IMFASFProfile> {
    windows_targets::link!("mf.dll" "system" fn MFCreateASFProfile(ppiprofile : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateASFProfile(&mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreateASFProfileFromPresentationDescriptor<P0>(pipd: P0) -> windows_core::Result<IMFASFProfile>
where
    P0: windows_core::Param<IMFPresentationDescriptor>,
{
    windows_targets::link!("mf.dll" "system" fn MFCreateASFProfileFromPresentationDescriptor(pipd : * mut core::ffi::c_void, ppiprofile : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateASFProfileFromPresentationDescriptor(pipd.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreateASFSplitter() -> windows_core::Result<IMFASFSplitter> {
    windows_targets::link!("mf.dll" "system" fn MFCreateASFSplitter(ppisplitter : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateASFSplitter(&mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreateASFStreamSelector<P0>(piasfprofile: P0) -> windows_core::Result<IMFASFStreamSelector>
where
    P0: windows_core::Param<IMFASFProfile>,
{
    windows_targets::link!("mf.dll" "system" fn MFCreateASFStreamSelector(piasfprofile : * mut core::ffi::c_void, ppselector : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateASFStreamSelector(piasfprofile.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreateASFStreamingMediaSink<P0>(pibytestream: P0) -> windows_core::Result<IMFMediaSink>
where
    P0: windows_core::Param<IMFByteStream>,
{
    windows_targets::link!("mf.dll" "system" fn MFCreateASFStreamingMediaSink(pibytestream : * mut core::ffi::c_void, ppimediasink : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateASFStreamingMediaSink(pibytestream.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreateASFStreamingMediaSinkActivate<P0, P1>(pbytestreamactivate: P0, pcontentinfo: P1) -> windows_core::Result<IMFActivate>
where
    P0: windows_core::Param<IMFActivate>,
    P1: windows_core::Param<IMFASFContentInfo>,
{
    windows_targets::link!("mf.dll" "system" fn MFCreateASFStreamingMediaSinkActivate(pbytestreamactivate : * mut core::ffi::c_void, pcontentinfo : * mut core::ffi::c_void, ppiactivate : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateASFStreamingMediaSinkActivate(pbytestreamactivate.param().abi(), pcontentinfo.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreateAVIMediaSink<P0, P1, P2>(pibytestream: P0, pvideomediatype: P1, paudiomediatype: P2) -> windows_core::Result<IMFMediaSink>
where
    P0: windows_core::Param<IMFByteStream>,
    P1: windows_core::Param<IMFMediaType>,
    P2: windows_core::Param<IMFMediaType>,
{
    windows_targets::link!("mfsrcsnk.dll" "system" fn MFCreateAVIMediaSink(pibytestream : * mut core::ffi::c_void, pvideomediatype : * mut core::ffi::c_void, paudiomediatype : * mut core::ffi::c_void, ppimediasink : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateAVIMediaSink(pibytestream.param().abi(), pvideomediatype.param().abi(), paudiomediatype.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreateAggregateSource<P0>(psourcecollection: P0) -> windows_core::Result<IMFMediaSource>
where
    P0: windows_core::Param<IMFCollection>,
{
    windows_targets::link!("mf.dll" "system" fn MFCreateAggregateSource(psourcecollection : * mut core::ffi::c_void, ppaggsource : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateAggregateSource(psourcecollection.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreateAlignedMemoryBuffer(cbmaxlength: u32, cbaligment: u32) -> windows_core::Result<IMFMediaBuffer> {
    windows_targets::link!("mfplat.dll" "system" fn MFCreateAlignedMemoryBuffer(cbmaxlength : u32, cbaligment : u32, ppbuffer : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateAlignedMemoryBuffer(cbmaxlength, cbaligment, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreateAsyncResult<P0, P1, P2>(punkobject: P0, pcallback: P1, punkstate: P2) -> windows_core::Result<IMFAsyncResult>
where
    P0: windows_core::Param<windows_core::IUnknown>,
    P1: windows_core::Param<IMFAsyncCallback>,
    P2: windows_core::Param<windows_core::IUnknown>,
{
    windows_targets::link!("mfplat.dll" "system" fn MFCreateAsyncResult(punkobject : * mut core::ffi::c_void, pcallback : * mut core::ffi::c_void, punkstate : * mut core::ffi::c_void, ppasyncresult : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateAsyncResult(punkobject.param().abi(), pcallback.param().abi(), punkstate.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreateAttributes(ppmfattributes: *mut Option<IMFAttributes>, cinitialsize: u32) -> windows_core::Result<()> {
    windows_targets::link!("mfplat.dll" "system" fn MFCreateAttributes(ppmfattributes : *mut * mut core::ffi::c_void, cinitialsize : u32) -> windows_core::HRESULT);
    unsafe { MFCreateAttributes(core::mem::transmute(ppmfattributes), cinitialsize).ok() }
}
#[cfg(feature = "Win32_Media_Audio")]
#[inline]
pub unsafe fn MFCreateAudioMediaType(paudioformat: *const super::Audio::WAVEFORMATEX) -> windows_core::Result<IMFAudioMediaType> {
    windows_targets::link!("mfplat.dll" "system" fn MFCreateAudioMediaType(paudioformat : *const super::Audio:: WAVEFORMATEX, ppiaudiomediatype : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateAudioMediaType(paudioformat, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreateAudioRenderer<P0>(paudioattributes: P0) -> windows_core::Result<IMFMediaSink>
where
    P0: windows_core::Param<IMFAttributes>,
{
    windows_targets::link!("mf.dll" "system" fn MFCreateAudioRenderer(paudioattributes : * mut core::ffi::c_void, ppsink : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateAudioRenderer(paudioattributes.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreateAudioRendererActivate() -> windows_core::Result<IMFActivate> {
    windows_targets::link!("mf.dll" "system" fn MFCreateAudioRendererActivate(ppactivate : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateAudioRendererActivate(&mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreateCameraControlMonitor<P0, P1>(symboliclink: P0, callback: P1) -> windows_core::Result<IMFCameraControlMonitor>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<IMFCameraControlNotify>,
{
    windows_targets::link!("mfsensorgroup.dll" "system" fn MFCreateCameraControlMonitor(symboliclink : windows_core::PCWSTR, callback : * mut core::ffi::c_void, ppcameracontrolmonitor : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateCameraControlMonitor(symboliclink.param().abi(), callback.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreateCameraOcclusionStateMonitor<P0, P1>(symboliclink: P0, callback: P1) -> windows_core::Result<IMFCameraOcclusionStateMonitor>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<IMFCameraOcclusionStateReportCallback>,
{
    windows_targets::link!("mfsensorgroup.dll" "system" fn MFCreateCameraOcclusionStateMonitor(symboliclink : windows_core::PCWSTR, callback : * mut core::ffi::c_void, occlusionstatemonitor : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateCameraOcclusionStateMonitor(symboliclink.param().abi(), callback.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreateCollection() -> windows_core::Result<IMFCollection> {
    windows_targets::link!("mfplat.dll" "system" fn MFCreateCollection(ppimfcollection : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateCollection(&mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreateContentDecryptorContext<P1, P2>(guidmediaprotectionsystemid: *const windows_core::GUID, pd3dmanager: P1, pcontentprotectiondevice: P2) -> windows_core::Result<IMFContentDecryptorContext>
where
    P1: windows_core::Param<IMFDXGIDeviceManager>,
    P2: windows_core::Param<IMFContentProtectionDevice>,
{
    windows_targets::link!("mfplat.dll" "system" fn MFCreateContentDecryptorContext(guidmediaprotectionsystemid : *const windows_core::GUID, pd3dmanager : * mut core::ffi::c_void, pcontentprotectiondevice : * mut core::ffi::c_void, ppcontentdecryptorcontext : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateContentDecryptorContext(guidmediaprotectionsystemid, pd3dmanager.param().abi(), pcontentprotectiondevice.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreateContentProtectionDevice(protectionsystemid: *const windows_core::GUID) -> windows_core::Result<IMFContentProtectionDevice> {
    windows_targets::link!("mfplat.dll" "system" fn MFCreateContentProtectionDevice(protectionsystemid : *const windows_core::GUID, contentprotectiondevice : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateContentProtectionDevice(protectionsystemid, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreateCredentialCache() -> windows_core::Result<IMFNetCredentialCache> {
    windows_targets::link!("mf.dll" "system" fn MFCreateCredentialCache(ppcache : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateCredentialCache(&mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
#[inline]
pub unsafe fn MFCreateD3D12SynchronizationObject<P0>(pdevice: P0, riid: *const windows_core::GUID, ppvsyncobject: *mut *mut core::ffi::c_void) -> windows_core::Result<()>
where
    P0: windows_core::Param<super::super::Graphics::Direct3D12::ID3D12Device>,
{
    windows_targets::link!("mfplat.dll" "system" fn MFCreateD3D12SynchronizationObject(pdevice : * mut core::ffi::c_void, riid : *const windows_core::GUID, ppvsyncobject : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe { MFCreateD3D12SynchronizationObject(pdevice.param().abi(), riid, ppvsyncobject as _).ok() }
}
#[inline]
pub unsafe fn MFCreateDXGIDeviceManager(resettoken: *mut u32, ppdevicemanager: *mut Option<IMFDXGIDeviceManager>) -> windows_core::Result<()> {
    windows_targets::link!("mfplat.dll" "system" fn MFCreateDXGIDeviceManager(resettoken : *mut u32, ppdevicemanager : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe { MFCreateDXGIDeviceManager(resettoken as _, core::mem::transmute(ppdevicemanager)).ok() }
}
#[inline]
pub unsafe fn MFCreateDXGISurfaceBuffer<P1>(riid: *const windows_core::GUID, punksurface: P1, usubresourceindex: u32, fbottomupwhenlinear: bool) -> windows_core::Result<IMFMediaBuffer>
where
    P1: windows_core::Param<windows_core::IUnknown>,
{
    windows_targets::link!("mfplat.dll" "system" fn MFCreateDXGISurfaceBuffer(riid : *const windows_core::GUID, punksurface : * mut core::ffi::c_void, usubresourceindex : u32, fbottomupwhenlinear : super::super::Foundation:: BOOL, ppbuffer : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateDXGISurfaceBuffer(riid, punksurface.param().abi(), usubresourceindex, fbottomupwhenlinear.into(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreateDXSurfaceBuffer<P1>(riid: *const windows_core::GUID, punksurface: P1, fbottomupwhenlinear: bool) -> windows_core::Result<IMFMediaBuffer>
where
    P1: windows_core::Param<windows_core::IUnknown>,
{
    windows_targets::link!("mfplat.dll" "system" fn MFCreateDXSurfaceBuffer(riid : *const windows_core::GUID, punksurface : * mut core::ffi::c_void, fbottomupwhenlinear : super::super::Foundation:: BOOL, ppbuffer : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateDXSurfaceBuffer(riid, punksurface.param().abi(), fbottomupwhenlinear.into(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreateDeviceSource<P0>(pattributes: P0) -> windows_core::Result<IMFMediaSource>
where
    P0: windows_core::Param<IMFAttributes>,
{
    windows_targets::link!("mf.dll" "system" fn MFCreateDeviceSource(pattributes : * mut core::ffi::c_void, ppsource : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateDeviceSource(pattributes.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreateDeviceSourceActivate<P0>(pattributes: P0) -> windows_core::Result<IMFActivate>
where
    P0: windows_core::Param<IMFAttributes>,
{
    windows_targets::link!("mf.dll" "system" fn MFCreateDeviceSourceActivate(pattributes : * mut core::ffi::c_void, ppactivate : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateDeviceSourceActivate(pattributes.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn MFCreateEncryptedMediaExtensionsStoreActivate<P0, P1, P2>(pmphost: P0, objectstream: P1, classid: P2) -> windows_core::Result<IMFActivate>
where
    P0: windows_core::Param<IMFPMPHostApp>,
    P1: windows_core::Param<super::super::System::Com::IStream>,
    P2: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("mf.dll" "system" fn MFCreateEncryptedMediaExtensionsStoreActivate(pmphost : * mut core::ffi::c_void, objectstream : * mut core::ffi::c_void, classid : windows_core::PCWSTR, activate : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateEncryptedMediaExtensionsStoreActivate(pmphost.param().abi(), objectstream.param().abi(), classid.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreateEventQueue() -> windows_core::Result<IMFMediaEventQueue> {
    windows_targets::link!("mfplat.dll" "system" fn MFCreateEventQueue(ppmediaeventqueue : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateEventQueue(&mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreateExtendedCameraIntrinsicModel(distortionmodeltype: MFCameraIntrinsic_DistortionModelType) -> windows_core::Result<IMFExtendedCameraIntrinsicModel> {
    windows_targets::link!("mfcore.dll" "system" fn MFCreateExtendedCameraIntrinsicModel(distortionmodeltype : MFCameraIntrinsic_DistortionModelType, ppextendedcameraintrinsicmodel : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateExtendedCameraIntrinsicModel(distortionmodeltype, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreateExtendedCameraIntrinsics() -> windows_core::Result<IMFExtendedCameraIntrinsics> {
    windows_targets::link!("mfcore.dll" "system" fn MFCreateExtendedCameraIntrinsics(ppextendedcameraintrinsics : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateExtendedCameraIntrinsics(&mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreateFMPEG4MediaSink<P0, P1, P2>(pibytestream: P0, pvideomediatype: P1, paudiomediatype: P2) -> windows_core::Result<IMFMediaSink>
where
    P0: windows_core::Param<IMFByteStream>,
    P1: windows_core::Param<IMFMediaType>,
    P2: windows_core::Param<IMFMediaType>,
{
    windows_targets::link!("mf.dll" "system" fn MFCreateFMPEG4MediaSink(pibytestream : * mut core::ffi::c_void, pvideomediatype : * mut core::ffi::c_void, paudiomediatype : * mut core::ffi::c_void, ppimediasink : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateFMPEG4MediaSink(pibytestream.param().abi(), pvideomediatype.param().abi(), paudiomediatype.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreateFile<P3>(accessmode: MF_FILE_ACCESSMODE, openmode: MF_FILE_OPENMODE, fflags: MF_FILE_FLAGS, pwszfileurl: P3) -> windows_core::Result<IMFByteStream>
where
    P3: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("mfplat.dll" "system" fn MFCreateFile(accessmode : MF_FILE_ACCESSMODE, openmode : MF_FILE_OPENMODE, fflags : MF_FILE_FLAGS, pwszfileurl : windows_core::PCWSTR, ppibytestream : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateFile(accessmode, openmode, fflags, pwszfileurl.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[cfg(feature = "Win32_Media_DxMediaObjects")]
#[inline]
pub unsafe fn MFCreateLegacyMediaBufferOnMFMediaBuffer<P0, P1>(psample: P0, pmfmediabuffer: P1, cboffset: u32) -> windows_core::Result<super::DxMediaObjects::IMediaBuffer>
where
    P0: windows_core::Param<IMFSample>,
    P1: windows_core::Param<IMFMediaBuffer>,
{
    windows_targets::link!("mfplat.dll" "system" fn MFCreateLegacyMediaBufferOnMFMediaBuffer(psample : * mut core::ffi::c_void, pmfmediabuffer : * mut core::ffi::c_void, cboffset : u32, ppmediabuffer : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateLegacyMediaBufferOnMFMediaBuffer(psample.param().abi(), pmfmediabuffer.param().abi(), cboffset, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn MFCreateMFByteStreamOnStream<P0>(pstream: P0) -> windows_core::Result<IMFByteStream>
where
    P0: windows_core::Param<super::super::System::Com::IStream>,
{
    windows_targets::link!("mfplat.dll" "system" fn MFCreateMFByteStreamOnStream(pstream : * mut core::ffi::c_void, ppbytestream : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateMFByteStreamOnStream(pstream.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreateMFByteStreamOnStreamEx<P0>(punkstream: P0) -> windows_core::Result<IMFByteStream>
where
    P0: windows_core::Param<windows_core::IUnknown>,
{
    windows_targets::link!("mfplat.dll" "system" fn MFCreateMFByteStreamOnStreamEx(punkstream : * mut core::ffi::c_void, ppbytestream : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateMFByteStreamOnStreamEx(punkstream.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreateMFByteStreamWrapper<P0>(pstream: P0) -> windows_core::Result<IMFByteStream>
where
    P0: windows_core::Param<IMFByteStream>,
{
    windows_targets::link!("mfplat.dll" "system" fn MFCreateMFByteStreamWrapper(pstream : * mut core::ffi::c_void, ppstreamwrapper : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateMFByteStreamWrapper(pstream.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreateMFVideoFormatFromMFMediaType<P0>(pmftype: P0, ppmfvf: *mut *mut MFVIDEOFORMAT, pcbsize: Option<*mut u32>) -> windows_core::Result<()>
where
    P0: windows_core::Param<IMFMediaType>,
{
    windows_targets::link!("mfplat.dll" "system" fn MFCreateMFVideoFormatFromMFMediaType(pmftype : * mut core::ffi::c_void, ppmfvf : *mut *mut MFVIDEOFORMAT, pcbsize : *mut u32) -> windows_core::HRESULT);
    unsafe { MFCreateMFVideoFormatFromMFMediaType(pmftype.param().abi(), ppmfvf as _, pcbsize.unwrap_or(core::mem::zeroed()) as _).ok() }
}
#[inline]
pub unsafe fn MFCreateMP3MediaSink<P0>(ptargetbytestream: P0) -> windows_core::Result<IMFMediaSink>
where
    P0: windows_core::Param<IMFByteStream>,
{
    windows_targets::link!("mf.dll" "system" fn MFCreateMP3MediaSink(ptargetbytestream : * mut core::ffi::c_void, ppmediasink : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateMP3MediaSink(ptargetbytestream.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreateMPEG4MediaSink<P0, P1, P2>(pibytestream: P0, pvideomediatype: P1, paudiomediatype: P2) -> windows_core::Result<IMFMediaSink>
where
    P0: windows_core::Param<IMFByteStream>,
    P1: windows_core::Param<IMFMediaType>,
    P2: windows_core::Param<IMFMediaType>,
{
    windows_targets::link!("mf.dll" "system" fn MFCreateMPEG4MediaSink(pibytestream : * mut core::ffi::c_void, pvideomediatype : * mut core::ffi::c_void, paudiomediatype : * mut core::ffi::c_void, ppimediasink : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateMPEG4MediaSink(pibytestream.param().abi(), pvideomediatype.param().abi(), paudiomediatype.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreateMediaBufferFromMediaType<P0>(pmediatype: P0, llduration: i64, dwminlength: u32, dwminalignment: u32) -> windows_core::Result<IMFMediaBuffer>
where
    P0: windows_core::Param<IMFMediaType>,
{
    windows_targets::link!("mfplat.dll" "system" fn MFCreateMediaBufferFromMediaType(pmediatype : * mut core::ffi::c_void, llduration : i64, dwminlength : u32, dwminalignment : u32, ppbuffer : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateMediaBufferFromMediaType(pmediatype.param().abi(), llduration, dwminlength, dwminalignment, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreateMediaBufferWrapper<P0>(pbuffer: P0, cboffset: u32, dwlength: u32) -> windows_core::Result<IMFMediaBuffer>
where
    P0: windows_core::Param<IMFMediaBuffer>,
{
    windows_targets::link!("mfplat.dll" "system" fn MFCreateMediaBufferWrapper(pbuffer : * mut core::ffi::c_void, cboffset : u32, dwlength : u32, ppbuffer : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateMediaBufferWrapper(pbuffer.param().abi(), cboffset, dwlength, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[cfg(all(feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Variant"))]
#[inline]
pub unsafe fn MFCreateMediaEvent(met: u32, guidextendedtype: *const windows_core::GUID, hrstatus: windows_core::HRESULT, pvvalue: Option<*const super::super::System::Com::StructuredStorage::PROPVARIANT>) -> windows_core::Result<IMFMediaEvent> {
    windows_targets::link!("mfplat.dll" "system" fn MFCreateMediaEvent(met : u32, guidextendedtype : *const windows_core::GUID, hrstatus : windows_core::HRESULT, pvvalue : *const super::super::System::Com::StructuredStorage:: PROPVARIANT, ppevent : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateMediaEvent(met, guidextendedtype, hrstatus, pvvalue.unwrap_or(core::mem::zeroed()) as _, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreateMediaExtensionActivate<P0, P1>(szactivatableclassid: P0, pconfiguration: P1, riid: *const windows_core::GUID, ppvobject: *mut *mut core::ffi::c_void) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::IUnknown>,
{
    windows_targets::link!("mfplat.dll" "system" fn MFCreateMediaExtensionActivate(szactivatableclassid : windows_core::PCWSTR, pconfiguration : * mut core::ffi::c_void, riid : *const windows_core::GUID, ppvobject : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe { MFCreateMediaExtensionActivate(szactivatableclassid.param().abi(), pconfiguration.param().abi(), riid, ppvobject as _).ok() }
}
#[inline]
pub unsafe fn MFCreateMediaSession<P0>(pconfiguration: P0) -> windows_core::Result<IMFMediaSession>
where
    P0: windows_core::Param<IMFAttributes>,
{
    windows_targets::link!("mf.dll" "system" fn MFCreateMediaSession(pconfiguration : * mut core::ffi::c_void, ppmediasession : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateMediaSession(pconfiguration.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreateMediaType() -> windows_core::Result<IMFMediaType> {
    windows_targets::link!("mfplat.dll" "system" fn MFCreateMediaType(ppmftype : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateMediaType(&mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreateMediaTypeFromProperties<P0>(punkstream: P0) -> windows_core::Result<IMFMediaType>
where
    P0: windows_core::Param<windows_core::IUnknown>,
{
    windows_targets::link!("mfplat.dll" "system" fn MFCreateMediaTypeFromProperties(punkstream : * mut core::ffi::c_void, ppmediatype : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateMediaTypeFromProperties(punkstream.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreateMediaTypeFromRepresentation(guidrepresentation: windows_core::GUID, pvrepresentation: *const core::ffi::c_void) -> windows_core::Result<IMFMediaType> {
    windows_targets::link!("mfplat.dll" "system" fn MFCreateMediaTypeFromRepresentation(guidrepresentation : windows_core::GUID, pvrepresentation : *const core::ffi::c_void, ppimediatype : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateMediaTypeFromRepresentation(core::mem::transmute(guidrepresentation), pvrepresentation, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreateMemoryBuffer(cbmaxlength: u32) -> windows_core::Result<IMFMediaBuffer> {
    windows_targets::link!("mfplat.dll" "system" fn MFCreateMemoryBuffer(cbmaxlength : u32, ppbuffer : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateMemoryBuffer(cbmaxlength, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreateMuxSink<P1, P2>(guidoutputsubtype: windows_core::GUID, poutputattributes: P1, poutputbytestream: P2) -> windows_core::Result<IMFMediaSink>
where
    P1: windows_core::Param<IMFAttributes>,
    P2: windows_core::Param<IMFByteStream>,
{
    windows_targets::link!("mf.dll" "system" fn MFCreateMuxSink(guidoutputsubtype : windows_core::GUID, poutputattributes : * mut core::ffi::c_void, poutputbytestream : * mut core::ffi::c_void, ppmuxsink : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateMuxSink(core::mem::transmute(guidoutputsubtype), poutputattributes.param().abi(), poutputbytestream.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreateMuxStreamAttributes<P0>(pattributestomux: P0) -> windows_core::Result<IMFAttributes>
where
    P0: windows_core::Param<IMFCollection>,
{
    windows_targets::link!("mfplat.dll" "system" fn MFCreateMuxStreamAttributes(pattributestomux : * mut core::ffi::c_void, ppmuxattribs : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateMuxStreamAttributes(pattributestomux.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreateMuxStreamMediaType<P0>(pmediatypestomux: P0) -> windows_core::Result<IMFMediaType>
where
    P0: windows_core::Param<IMFCollection>,
{
    windows_targets::link!("mfplat.dll" "system" fn MFCreateMuxStreamMediaType(pmediatypestomux : * mut core::ffi::c_void, ppmuxmediatype : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateMuxStreamMediaType(pmediatypestomux.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreateMuxStreamSample<P0>(psamplestomux: P0) -> windows_core::Result<IMFSample>
where
    P0: windows_core::Param<IMFCollection>,
{
    windows_targets::link!("mfplat.dll" "system" fn MFCreateMuxStreamSample(psamplestomux : * mut core::ffi::c_void, ppmuxsample : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateMuxStreamSample(psamplestomux.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreateNetSchemePlugin(riid: *const windows_core::GUID, ppvhandler: *mut *mut core::ffi::c_void) -> windows_core::Result<()> {
    windows_targets::link!("mf.dll" "system" fn MFCreateNetSchemePlugin(riid : *const windows_core::GUID, ppvhandler : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe { MFCreateNetSchemePlugin(riid, ppvhandler as _).ok() }
}
#[inline]
pub unsafe fn MFCreatePMPMediaSession<P1>(dwcreationflags: u32, pconfiguration: P1, ppmediasession: *mut Option<IMFMediaSession>, ppenableractivate: Option<*mut Option<IMFActivate>>) -> windows_core::Result<()>
where
    P1: windows_core::Param<IMFAttributes>,
{
    windows_targets::link!("mf.dll" "system" fn MFCreatePMPMediaSession(dwcreationflags : u32, pconfiguration : * mut core::ffi::c_void, ppmediasession : *mut * mut core::ffi::c_void, ppenableractivate : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe { MFCreatePMPMediaSession(dwcreationflags, pconfiguration.param().abi(), core::mem::transmute(ppmediasession), ppenableractivate.unwrap_or(core::mem::zeroed()) as _).ok() }
}
#[inline]
pub unsafe fn MFCreatePMPServer(dwcreationflags: u32) -> windows_core::Result<IMFPMPServer> {
    windows_targets::link!("mf.dll" "system" fn MFCreatePMPServer(dwcreationflags : u32, pppmpserver : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreatePMPServer(dwcreationflags, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreatePresentationClock() -> windows_core::Result<IMFPresentationClock> {
    windows_targets::link!("mf.dll" "system" fn MFCreatePresentationClock(pppresentationclock : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreatePresentationClock(&mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreatePresentationDescriptor(apstreamdescriptors: Option<&[Option<IMFStreamDescriptor>]>) -> windows_core::Result<IMFPresentationDescriptor> {
    windows_targets::link!("mfplat.dll" "system" fn MFCreatePresentationDescriptor(cstreamdescriptors : u32, apstreamdescriptors : *const * mut core::ffi::c_void, pppresentationdescriptor : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreatePresentationDescriptor(apstreamdescriptors.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(apstreamdescriptors.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreatePresentationDescriptorFromASFProfile<P0>(piprofile: P0) -> windows_core::Result<IMFPresentationDescriptor>
where
    P0: windows_core::Param<IMFASFProfile>,
{
    windows_targets::link!("mf.dll" "system" fn MFCreatePresentationDescriptorFromASFProfile(piprofile : * mut core::ffi::c_void, ppipd : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreatePresentationDescriptorFromASFProfile(piprofile.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreatePropertiesFromMediaType<P0>(pmediatype: P0, riid: *const windows_core::GUID, ppv: *mut *mut core::ffi::c_void) -> windows_core::Result<()>
where
    P0: windows_core::Param<IMFMediaType>,
{
    windows_targets::link!("mfplat.dll" "system" fn MFCreatePropertiesFromMediaType(pmediatype : * mut core::ffi::c_void, riid : *const windows_core::GUID, ppv : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe { MFCreatePropertiesFromMediaType(pmediatype.param().abi(), riid, ppv as _).ok() }
}
#[inline]
pub unsafe fn MFCreateProtectedEnvironmentAccess() -> windows_core::Result<IMFProtectedEnvironmentAccess> {
    windows_targets::link!("mf.dll" "system" fn MFCreateProtectedEnvironmentAccess(ppaccess : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateProtectedEnvironmentAccess(&mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
#[inline]
pub unsafe fn MFCreateProxyLocator<P0, P1>(pszprotocol: P0, pproxyconfig: P1) -> windows_core::Result<IMFNetProxyLocator>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<super::super::UI::Shell::PropertiesSystem::IPropertyStore>,
{
    windows_targets::link!("mf.dll" "system" fn MFCreateProxyLocator(pszprotocol : windows_core::PCWSTR, pproxyconfig : * mut core::ffi::c_void, ppproxylocator : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateProxyLocator(pszprotocol.param().abi(), pproxyconfig.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreateRelativePanelWatcher<P0, P1>(videodeviceid: P0, displaymonitordeviceid: P1) -> windows_core::Result<IMFRelativePanelWatcher>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("mfsensorgroup.dll" "system" fn MFCreateRelativePanelWatcher(videodeviceid : windows_core::PCWSTR, displaymonitordeviceid : windows_core::PCWSTR, pprelativepanelwatcher : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateRelativePanelWatcher(videodeviceid.param().abi(), displaymonitordeviceid.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreateRemoteDesktopPlugin() -> windows_core::Result<IMFRemoteDesktopPlugin> {
    windows_targets::link!("mf.dll" "system" fn MFCreateRemoteDesktopPlugin(ppplugin : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateRemoteDesktopPlugin(&mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreateSample() -> windows_core::Result<IMFSample> {
    windows_targets::link!("mfplat.dll" "system" fn MFCreateSample(ppimfsample : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateSample(&mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreateSampleCopierMFT() -> windows_core::Result<IMFTransform> {
    windows_targets::link!("mf.dll" "system" fn MFCreateSampleCopierMFT(ppcopiermft : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateSampleCopierMFT(&mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreateSampleGrabberSinkActivate<P0, P1>(pimfmediatype: P0, pimfsamplegrabbersinkcallback: P1) -> windows_core::Result<IMFActivate>
where
    P0: windows_core::Param<IMFMediaType>,
    P1: windows_core::Param<IMFSampleGrabberSinkCallback>,
{
    windows_targets::link!("mf.dll" "system" fn MFCreateSampleGrabberSinkActivate(pimfmediatype : * mut core::ffi::c_void, pimfsamplegrabbersinkcallback : * mut core::ffi::c_void, ppiactivate : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateSampleGrabberSinkActivate(pimfmediatype.param().abi(), pimfsamplegrabbersinkcallback.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreateSensorActivityMonitor<P0>(pcallback: P0) -> windows_core::Result<IMFSensorActivityMonitor>
where
    P0: windows_core::Param<IMFSensorActivitiesReportCallback>,
{
    windows_targets::link!("mfsensorgroup.dll" "system" fn MFCreateSensorActivityMonitor(pcallback : * mut core::ffi::c_void, ppactivitymonitor : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateSensorActivityMonitor(pcallback.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreateSensorGroup<P0>(sensorgroupsymboliclink: P0) -> windows_core::Result<IMFSensorGroup>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("mfsensorgroup.dll" "system" fn MFCreateSensorGroup(sensorgroupsymboliclink : windows_core::PCWSTR, ppsensorgroup : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateSensorGroup(sensorgroupsymboliclink.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreateSensorProfile<P2>(profiletype: *const windows_core::GUID, profileindex: u32, constraints: P2) -> windows_core::Result<IMFSensorProfile>
where
    P2: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("mfsensorgroup.dll" "system" fn MFCreateSensorProfile(profiletype : *const windows_core::GUID, profileindex : u32, constraints : windows_core::PCWSTR, ppprofile : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateSensorProfile(profiletype, profileindex, constraints.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreateSensorProfileCollection() -> windows_core::Result<IMFSensorProfileCollection> {
    windows_targets::link!("mfsensorgroup.dll" "system" fn MFCreateSensorProfileCollection(ppsensorprofile : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateSensorProfileCollection(&mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreateSensorStream<P1, P2>(streamid: u32, pattributes: P1, pmediatypecollection: P2) -> windows_core::Result<IMFSensorStream>
where
    P1: windows_core::Param<IMFAttributes>,
    P2: windows_core::Param<IMFCollection>,
{
    windows_targets::link!("mfsensorgroup.dll" "system" fn MFCreateSensorStream(streamid : u32, pattributes : * mut core::ffi::c_void, pmediatypecollection : * mut core::ffi::c_void, ppstream : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateSensorStream(streamid, pattributes.param().abi(), pmediatypecollection.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[cfg(all(feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Variant"))]
#[inline]
pub unsafe fn MFCreateSequencerSegmentOffset(dwid: u32, hnsoffset: i64) -> windows_core::Result<super::super::System::Com::StructuredStorage::PROPVARIANT> {
    windows_targets::link!("mf.dll" "system" fn MFCreateSequencerSegmentOffset(dwid : u32, hnsoffset : i64, pvarsegmentoffset : *mut super::super::System::Com::StructuredStorage:: PROPVARIANT) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateSequencerSegmentOffset(dwid, hnsoffset, &mut result__).map(|| core::mem::transmute(result__))
    }
}
#[inline]
pub unsafe fn MFCreateSequencerSource<P0>(preserved: P0) -> windows_core::Result<IMFSequencerSource>
where
    P0: windows_core::Param<windows_core::IUnknown>,
{
    windows_targets::link!("mf.dll" "system" fn MFCreateSequencerSource(preserved : * mut core::ffi::c_void, ppsequencersource : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateSequencerSource(preserved.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreateSimpleTypeHandler() -> windows_core::Result<IMFMediaTypeHandler> {
    windows_targets::link!("mf.dll" "system" fn MFCreateSimpleTypeHandler(pphandler : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateSimpleTypeHandler(&mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreateSinkWriterFromMediaSink<P0, P1>(pmediasink: P0, pattributes: P1) -> windows_core::Result<IMFSinkWriter>
where
    P0: windows_core::Param<IMFMediaSink>,
    P1: windows_core::Param<IMFAttributes>,
{
    windows_targets::link!("mfreadwrite.dll" "system" fn MFCreateSinkWriterFromMediaSink(pmediasink : * mut core::ffi::c_void, pattributes : * mut core::ffi::c_void, ppsinkwriter : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateSinkWriterFromMediaSink(pmediasink.param().abi(), pattributes.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreateSinkWriterFromURL<P0, P1, P2>(pwszoutputurl: P0, pbytestream: P1, pattributes: P2) -> windows_core::Result<IMFSinkWriter>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<IMFByteStream>,
    P2: windows_core::Param<IMFAttributes>,
{
    windows_targets::link!("mfreadwrite.dll" "system" fn MFCreateSinkWriterFromURL(pwszoutputurl : windows_core::PCWSTR, pbytestream : * mut core::ffi::c_void, pattributes : * mut core::ffi::c_void, ppsinkwriter : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateSinkWriterFromURL(pwszoutputurl.param().abi(), pbytestream.param().abi(), pattributes.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreateSourceReaderFromByteStream<P0, P1>(pbytestream: P0, pattributes: P1) -> windows_core::Result<IMFSourceReader>
where
    P0: windows_core::Param<IMFByteStream>,
    P1: windows_core::Param<IMFAttributes>,
{
    windows_targets::link!("mfreadwrite.dll" "system" fn MFCreateSourceReaderFromByteStream(pbytestream : * mut core::ffi::c_void, pattributes : * mut core::ffi::c_void, ppsourcereader : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateSourceReaderFromByteStream(pbytestream.param().abi(), pattributes.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreateSourceReaderFromMediaSource<P0, P1>(pmediasource: P0, pattributes: P1) -> windows_core::Result<IMFSourceReader>
where
    P0: windows_core::Param<IMFMediaSource>,
    P1: windows_core::Param<IMFAttributes>,
{
    windows_targets::link!("mfreadwrite.dll" "system" fn MFCreateSourceReaderFromMediaSource(pmediasource : * mut core::ffi::c_void, pattributes : * mut core::ffi::c_void, ppsourcereader : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateSourceReaderFromMediaSource(pmediasource.param().abi(), pattributes.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreateSourceReaderFromURL<P0, P1>(pwszurl: P0, pattributes: P1) -> windows_core::Result<IMFSourceReader>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<IMFAttributes>,
{
    windows_targets::link!("mfreadwrite.dll" "system" fn MFCreateSourceReaderFromURL(pwszurl : windows_core::PCWSTR, pattributes : * mut core::ffi::c_void, ppsourcereader : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateSourceReaderFromURL(pwszurl.param().abi(), pattributes.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreateSourceResolver() -> windows_core::Result<IMFSourceResolver> {
    windows_targets::link!("mfplat.dll" "system" fn MFCreateSourceResolver(ppisourceresolver : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateSourceResolver(&mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreateStandardQualityManager() -> windows_core::Result<IMFQualityManager> {
    windows_targets::link!("mf.dll" "system" fn MFCreateStandardQualityManager(ppqualitymanager : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateStandardQualityManager(&mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreateStreamDescriptor(dwstreamidentifier: u32, apmediatypes: &[Option<IMFMediaType>]) -> windows_core::Result<IMFStreamDescriptor> {
    windows_targets::link!("mfplat.dll" "system" fn MFCreateStreamDescriptor(dwstreamidentifier : u32, cmediatypes : u32, apmediatypes : *const * mut core::ffi::c_void, ppdescriptor : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateStreamDescriptor(dwstreamidentifier, apmediatypes.len().try_into().unwrap(), core::mem::transmute(apmediatypes.as_ptr()), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn MFCreateStreamOnMFByteStream<P0>(pbytestream: P0) -> windows_core::Result<super::super::System::Com::IStream>
where
    P0: windows_core::Param<IMFByteStream>,
{
    windows_targets::link!("mfplat.dll" "system" fn MFCreateStreamOnMFByteStream(pbytestream : * mut core::ffi::c_void, ppstream : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateStreamOnMFByteStream(pbytestream.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreateStreamOnMFByteStreamEx<P0>(pbytestream: P0, riid: *const windows_core::GUID, ppv: *mut *mut core::ffi::c_void) -> windows_core::Result<()>
where
    P0: windows_core::Param<IMFByteStream>,
{
    windows_targets::link!("mfplat.dll" "system" fn MFCreateStreamOnMFByteStreamEx(pbytestream : * mut core::ffi::c_void, riid : *const windows_core::GUID, ppv : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe { MFCreateStreamOnMFByteStreamEx(pbytestream.param().abi(), riid, ppv as _).ok() }
}
#[inline]
pub unsafe fn MFCreateSystemTimeSource() -> windows_core::Result<IMFPresentationTimeSource> {
    windows_targets::link!("mfplat.dll" "system" fn MFCreateSystemTimeSource(ppsystemtimesource : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateSystemTimeSource(&mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreateTempFile(accessmode: MF_FILE_ACCESSMODE, openmode: MF_FILE_OPENMODE, fflags: MF_FILE_FLAGS) -> windows_core::Result<IMFByteStream> {
    windows_targets::link!("mfplat.dll" "system" fn MFCreateTempFile(accessmode : MF_FILE_ACCESSMODE, openmode : MF_FILE_OPENMODE, fflags : MF_FILE_FLAGS, ppibytestream : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateTempFile(accessmode, openmode, fflags, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreateTopoLoader() -> windows_core::Result<IMFTopoLoader> {
    windows_targets::link!("mf.dll" "system" fn MFCreateTopoLoader(ppobj : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateTopoLoader(&mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreateTopology() -> windows_core::Result<IMFTopology> {
    windows_targets::link!("mf.dll" "system" fn MFCreateTopology(pptopo : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateTopology(&mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreateTopologyNode(nodetype: MF_TOPOLOGY_TYPE) -> windows_core::Result<IMFTopologyNode> {
    windows_targets::link!("mf.dll" "system" fn MFCreateTopologyNode(nodetype : MF_TOPOLOGY_TYPE, ppnode : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateTopologyNode(nodetype, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreateTrackedSample() -> windows_core::Result<IMFTrackedSample> {
    windows_targets::link!("mfplat.dll" "system" fn MFCreateTrackedSample(ppmfsample : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateTrackedSample(&mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreateTranscodeProfile() -> windows_core::Result<IMFTranscodeProfile> {
    windows_targets::link!("mf.dll" "system" fn MFCreateTranscodeProfile(pptranscodeprofile : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateTranscodeProfile(&mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreateTranscodeSinkActivate() -> windows_core::Result<IMFActivate> {
    windows_targets::link!("mf.dll" "system" fn MFCreateTranscodeSinkActivate(ppactivate : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateTranscodeSinkActivate(&mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreateTranscodeTopology<P0, P1, P2>(psrc: P0, pwszoutputfilepath: P1, pprofile: P2) -> windows_core::Result<IMFTopology>
where
    P0: windows_core::Param<IMFMediaSource>,
    P1: windows_core::Param<windows_core::PCWSTR>,
    P2: windows_core::Param<IMFTranscodeProfile>,
{
    windows_targets::link!("mf.dll" "system" fn MFCreateTranscodeTopology(psrc : * mut core::ffi::c_void, pwszoutputfilepath : windows_core::PCWSTR, pprofile : * mut core::ffi::c_void, pptranscodetopo : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateTranscodeTopology(psrc.param().abi(), pwszoutputfilepath.param().abi(), pprofile.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreateTranscodeTopologyFromByteStream<P0, P1, P2>(psrc: P0, poutputstream: P1, pprofile: P2) -> windows_core::Result<IMFTopology>
where
    P0: windows_core::Param<IMFMediaSource>,
    P1: windows_core::Param<IMFByteStream>,
    P2: windows_core::Param<IMFTranscodeProfile>,
{
    windows_targets::link!("mf.dll" "system" fn MFCreateTranscodeTopologyFromByteStream(psrc : * mut core::ffi::c_void, poutputstream : * mut core::ffi::c_void, pprofile : * mut core::ffi::c_void, pptranscodetopo : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateTranscodeTopologyFromByteStream(psrc.param().abi(), poutputstream.param().abi(), pprofile.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreateTransformActivate() -> windows_core::Result<IMFActivate> {
    windows_targets::link!("mfplat.dll" "system" fn MFCreateTransformActivate(ppactivate : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateTransformActivate(&mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreateVideoMediaType(pvideoformat: *const MFVIDEOFORMAT) -> windows_core::Result<IMFVideoMediaType> {
    windows_targets::link!("mfplat.dll" "system" fn MFCreateVideoMediaType(pvideoformat : *const MFVIDEOFORMAT, ppivideomediatype : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateVideoMediaType(pvideoformat, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[cfg(feature = "Win32_Graphics_Gdi")]
#[inline]
pub unsafe fn MFCreateVideoMediaTypeFromBitMapInfoHeader(pbmihbitmapinfoheader: *const super::super::Graphics::Gdi::BITMAPINFOHEADER, dwpixelaspectratiox: u32, dwpixelaspectratioy: u32, interlacemode: MFVideoInterlaceMode, videoflags: u64, qwframespersecondnumerator: u64, qwframesperseconddenominator: u64, dwmaxbitrate: u32) -> windows_core::Result<IMFVideoMediaType> {
    windows_targets::link!("mfplat.dll" "system" fn MFCreateVideoMediaTypeFromBitMapInfoHeader(pbmihbitmapinfoheader : *const super::super::Graphics::Gdi:: BITMAPINFOHEADER, dwpixelaspectratiox : u32, dwpixelaspectratioy : u32, interlacemode : MFVideoInterlaceMode, videoflags : u64, qwframespersecondnumerator : u64, qwframesperseconddenominator : u64, dwmaxbitrate : u32, ppivideomediatype : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateVideoMediaTypeFromBitMapInfoHeader(pbmihbitmapinfoheader, dwpixelaspectratiox, dwpixelaspectratioy, interlacemode, videoflags, qwframespersecondnumerator, qwframesperseconddenominator, dwmaxbitrate, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[cfg(feature = "Win32_Graphics_Gdi")]
#[inline]
pub unsafe fn MFCreateVideoMediaTypeFromBitMapInfoHeaderEx(pbmihbitmapinfoheader: *const super::super::Graphics::Gdi::BITMAPINFOHEADER, cbbitmapinfoheader: u32, dwpixelaspectratiox: u32, dwpixelaspectratioy: u32, interlacemode: MFVideoInterlaceMode, videoflags: u64, dwframespersecondnumerator: u32, dwframesperseconddenominator: u32, dwmaxbitrate: u32) -> windows_core::Result<IMFVideoMediaType> {
    windows_targets::link!("mfplat.dll" "system" fn MFCreateVideoMediaTypeFromBitMapInfoHeaderEx(pbmihbitmapinfoheader : *const super::super::Graphics::Gdi:: BITMAPINFOHEADER, cbbitmapinfoheader : u32, dwpixelaspectratiox : u32, dwpixelaspectratioy : u32, interlacemode : MFVideoInterlaceMode, videoflags : u64, dwframespersecondnumerator : u32, dwframesperseconddenominator : u32, dwmaxbitrate : u32, ppivideomediatype : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateVideoMediaTypeFromBitMapInfoHeaderEx(pbmihbitmapinfoheader, cbbitmapinfoheader, dwpixelaspectratiox, dwpixelaspectratioy, interlacemode, videoflags, dwframespersecondnumerator, dwframesperseconddenominator, dwmaxbitrate, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreateVideoMediaTypeFromSubtype(pamsubtype: *const windows_core::GUID) -> windows_core::Result<IMFVideoMediaType> {
    windows_targets::link!("mfplat.dll" "system" fn MFCreateVideoMediaTypeFromSubtype(pamsubtype : *const windows_core::GUID, ppivideomediatype : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateVideoMediaTypeFromSubtype(pamsubtype, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreateVideoMixer<P0>(powner: P0, riiddevice: *const windows_core::GUID, riid: *const windows_core::GUID, ppv: *mut *mut core::ffi::c_void) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::IUnknown>,
{
    windows_targets::link!("evr.dll" "system" fn MFCreateVideoMixer(powner : * mut core::ffi::c_void, riiddevice : *const windows_core::GUID, riid : *const windows_core::GUID, ppv : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe { MFCreateVideoMixer(powner.param().abi(), riiddevice, riid, ppv as _).ok() }
}
#[inline]
pub unsafe fn MFCreateVideoMixerAndPresenter<P0, P1>(pmixerowner: P0, ppresenterowner: P1, riidmixer: *const windows_core::GUID, ppvvideomixer: *mut *mut core::ffi::c_void, riidpresenter: *const windows_core::GUID, ppvvideopresenter: *mut *mut core::ffi::c_void) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::IUnknown>,
    P1: windows_core::Param<windows_core::IUnknown>,
{
    windows_targets::link!("evr.dll" "system" fn MFCreateVideoMixerAndPresenter(pmixerowner : * mut core::ffi::c_void, ppresenterowner : * mut core::ffi::c_void, riidmixer : *const windows_core::GUID, ppvvideomixer : *mut *mut core::ffi::c_void, riidpresenter : *const windows_core::GUID, ppvvideopresenter : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe { MFCreateVideoMixerAndPresenter(pmixerowner.param().abi(), ppresenterowner.param().abi(), riidmixer, ppvvideomixer as _, riidpresenter, ppvvideopresenter as _).ok() }
}
#[inline]
pub unsafe fn MFCreateVideoPresenter<P0>(powner: P0, riiddevice: *const windows_core::GUID, riid: *const windows_core::GUID, ppvideopresenter: *mut *mut core::ffi::c_void) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::IUnknown>,
{
    windows_targets::link!("evr.dll" "system" fn MFCreateVideoPresenter(powner : * mut core::ffi::c_void, riiddevice : *const windows_core::GUID, riid : *const windows_core::GUID, ppvideopresenter : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe { MFCreateVideoPresenter(powner.param().abi(), riiddevice, riid, ppvideopresenter as _).ok() }
}
#[inline]
pub unsafe fn MFCreateVideoRenderer(riidrenderer: *const windows_core::GUID, ppvideorenderer: *mut *mut core::ffi::c_void) -> windows_core::Result<()> {
    windows_targets::link!("mf.dll" "system" fn MFCreateVideoRenderer(riidrenderer : *const windows_core::GUID, ppvideorenderer : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe { MFCreateVideoRenderer(riidrenderer, ppvideorenderer as _).ok() }
}
#[inline]
pub unsafe fn MFCreateVideoRendererActivate(hwndvideo: super::super::Foundation::HWND) -> windows_core::Result<IMFActivate> {
    windows_targets::link!("mf.dll" "system" fn MFCreateVideoRendererActivate(hwndvideo : super::super::Foundation:: HWND, ppactivate : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateVideoRendererActivate(hwndvideo, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreateVideoSampleAllocator(riid: *const windows_core::GUID, ppsampleallocator: *mut *mut core::ffi::c_void) -> windows_core::Result<()> {
    windows_targets::link!("evr.dll" "system" fn MFCreateVideoSampleAllocator(riid : *const windows_core::GUID, ppsampleallocator : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe { MFCreateVideoSampleAllocator(riid, ppsampleallocator as _).ok() }
}
#[inline]
pub unsafe fn MFCreateVideoSampleAllocatorEx(riid: *const windows_core::GUID, ppsampleallocator: *mut *mut core::ffi::c_void) -> windows_core::Result<()> {
    windows_targets::link!("mfplat.dll" "system" fn MFCreateVideoSampleAllocatorEx(riid : *const windows_core::GUID, ppsampleallocator : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe { MFCreateVideoSampleAllocatorEx(riid, ppsampleallocator as _).ok() }
}
#[inline]
pub unsafe fn MFCreateVideoSampleFromSurface<P0>(punksurface: P0) -> windows_core::Result<IMFSample>
where
    P0: windows_core::Param<windows_core::IUnknown>,
{
    windows_targets::link!("evr.dll" "system" fn MFCreateVideoSampleFromSurface(punksurface : * mut core::ffi::c_void, ppsample : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateVideoSampleFromSurface(punksurface.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreateVirtualCamera<P3, P4>(r#type: MFVirtualCameraType, lifetime: MFVirtualCameraLifetime, access: MFVirtualCameraAccess, friendlyname: P3, sourceid: P4, categories: Option<&[windows_core::GUID]>) -> windows_core::Result<IMFVirtualCamera>
where
    P3: windows_core::Param<windows_core::PCWSTR>,
    P4: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("mfsensorgroup.dll" "system" fn MFCreateVirtualCamera(r#type : MFVirtualCameraType, lifetime : MFVirtualCameraLifetime, access : MFVirtualCameraAccess, friendlyname : windows_core::PCWSTR, sourceid : windows_core::PCWSTR, categories : *const windows_core::GUID, categorycount : u32, virtualcamera : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateVirtualCamera(r#type, lifetime, access, friendlyname.param().abi(), sourceid.param().abi(), core::mem::transmute(categories.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), categories.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreateWAVEMediaSink<P0, P1>(ptargetbytestream: P0, paudiomediatype: P1) -> windows_core::Result<IMFMediaSink>
where
    P0: windows_core::Param<IMFByteStream>,
    P1: windows_core::Param<IMFMediaType>,
{
    windows_targets::link!("mfsrcsnk.dll" "system" fn MFCreateWAVEMediaSink(ptargetbytestream : * mut core::ffi::c_void, paudiomediatype : * mut core::ffi::c_void, ppmediasink : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateWAVEMediaSink(ptargetbytestream.param().abi(), paudiomediatype.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFCreateWICBitmapBuffer<P1>(riid: *const windows_core::GUID, punksurface: P1) -> windows_core::Result<IMFMediaBuffer>
where
    P1: windows_core::Param<windows_core::IUnknown>,
{
    windows_targets::link!("mfplat.dll" "system" fn MFCreateWICBitmapBuffer(riid : *const windows_core::GUID, punksurface : * mut core::ffi::c_void, ppbuffer : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateWICBitmapBuffer(riid, punksurface.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
#[inline]
pub unsafe fn MFCreateWMAEncoderActivate<P0, P1>(pmediatype: P0, pencodingconfigurationproperties: P1) -> windows_core::Result<IMFActivate>
where
    P0: windows_core::Param<IMFMediaType>,
    P1: windows_core::Param<super::super::UI::Shell::PropertiesSystem::IPropertyStore>,
{
    windows_targets::link!("mf.dll" "system" fn MFCreateWMAEncoderActivate(pmediatype : * mut core::ffi::c_void, pencodingconfigurationproperties : * mut core::ffi::c_void, ppactivate : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateWMAEncoderActivate(pmediatype.param().abi(), pencodingconfigurationproperties.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
#[inline]
pub unsafe fn MFCreateWMVEncoderActivate<P0, P1>(pmediatype: P0, pencodingconfigurationproperties: P1) -> windows_core::Result<IMFActivate>
where
    P0: windows_core::Param<IMFMediaType>,
    P1: windows_core::Param<super::super::UI::Shell::PropertiesSystem::IPropertyStore>,
{
    windows_targets::link!("mf.dll" "system" fn MFCreateWMVEncoderActivate(pmediatype : * mut core::ffi::c_void, pencodingconfigurationproperties : * mut core::ffi::c_void, ppactivate : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFCreateWMVEncoderActivate(pmediatype.param().abi(), pencodingconfigurationproperties.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[cfg(feature = "Win32_Media_Audio")]
#[inline]
pub unsafe fn MFCreateWaveFormatExFromMFMediaType<P0>(pmftype: P0, ppwf: *mut *mut super::Audio::WAVEFORMATEX, pcbsize: Option<*mut u32>, flags: u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<IMFMediaType>,
{
    windows_targets::link!("mfplat.dll" "system" fn MFCreateWaveFormatExFromMFMediaType(pmftype : * mut core::ffi::c_void, ppwf : *mut *mut super::Audio:: WAVEFORMATEX, pcbsize : *mut u32, flags : u32) -> windows_core::HRESULT);
    unsafe { MFCreateWaveFormatExFromMFMediaType(pmftype.param().abi(), ppwf as _, pcbsize.unwrap_or(core::mem::zeroed()) as _, flags).ok() }
}
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn MFDeserializeAttributesFromStream<P0, P2>(pattr: P0, dwoptions: u32, pstm: P2) -> windows_core::Result<()>
where
    P0: windows_core::Param<IMFAttributes>,
    P2: windows_core::Param<super::super::System::Com::IStream>,
{
    windows_targets::link!("mfplat.dll" "system" fn MFDeserializeAttributesFromStream(pattr : * mut core::ffi::c_void, dwoptions : u32, pstm : * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe { MFDeserializeAttributesFromStream(pattr.param().abi(), dwoptions, pstm.param().abi()).ok() }
}
#[inline]
pub unsafe fn MFDeserializePresentationDescriptor(pbdata: &[u8]) -> windows_core::Result<IMFPresentationDescriptor> {
    windows_targets::link!("mfplat.dll" "system" fn MFDeserializePresentationDescriptor(cbdata : u32, pbdata : *const u8, pppd : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFDeserializePresentationDescriptor(pbdata.len().try_into().unwrap(), core::mem::transmute(pbdata.as_ptr()), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFEndCreateFile<P0>(presult: P0) -> windows_core::Result<IMFByteStream>
where
    P0: windows_core::Param<IMFAsyncResult>,
{
    windows_targets::link!("mfplat.dll" "system" fn MFEndCreateFile(presult : * mut core::ffi::c_void, ppfile : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFEndCreateFile(presult.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFEndRegisterWorkQueueWithMMCSS<P0>(presult: P0) -> windows_core::Result<u32>
where
    P0: windows_core::Param<IMFAsyncResult>,
{
    windows_targets::link!("mfplat.dll" "system" fn MFEndRegisterWorkQueueWithMMCSS(presult : * mut core::ffi::c_void, pdwtaskid : *mut u32) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFEndRegisterWorkQueueWithMMCSS(presult.param().abi(), &mut result__).map(|| core::mem::transmute(result__))
    }
}
#[inline]
pub unsafe fn MFEndUnregisterWorkQueueWithMMCSS<P0>(presult: P0) -> windows_core::Result<()>
where
    P0: windows_core::Param<IMFAsyncResult>,
{
    windows_targets::link!("mfplat.dll" "system" fn MFEndUnregisterWorkQueueWithMMCSS(presult : * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe { MFEndUnregisterWorkQueueWithMMCSS(presult.param().abi()).ok() }
}
#[inline]
pub unsafe fn MFEnumDeviceSources<P0>(pattributes: P0, pppsourceactivate: *mut *mut Option<IMFActivate>, pcsourceactivate: *mut u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<IMFAttributes>,
{
    windows_targets::link!("mf.dll" "system" fn MFEnumDeviceSources(pattributes : * mut core::ffi::c_void, pppsourceactivate : *mut *mut * mut core::ffi::c_void, pcsourceactivate : *mut u32) -> windows_core::HRESULT);
    unsafe { MFEnumDeviceSources(pattributes.param().abi(), pppsourceactivate as _, pcsourceactivate as _).ok() }
}
#[inline]
pub unsafe fn MFFrameRateToAverageTimePerFrame(unnumerator: u32, undenominator: u32) -> windows_core::Result<u64> {
    windows_targets::link!("mfplat.dll" "system" fn MFFrameRateToAverageTimePerFrame(unnumerator : u32, undenominator : u32, punaveragetimeperframe : *mut u64) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFFrameRateToAverageTimePerFrame(unnumerator, undenominator, &mut result__).map(|| core::mem::transmute(result__))
    }
}
#[inline]
pub unsafe fn MFGetAttributesAsBlob<P0>(pattributes: P0, pbuf: &mut [u8]) -> windows_core::Result<()>
where
    P0: windows_core::Param<IMFAttributes>,
{
    windows_targets::link!("mfplat.dll" "system" fn MFGetAttributesAsBlob(pattributes : * mut core::ffi::c_void, pbuf : *mut u8, cbbufsize : u32) -> windows_core::HRESULT);
    unsafe { MFGetAttributesAsBlob(pattributes.param().abi(), core::mem::transmute(pbuf.as_ptr()), pbuf.len().try_into().unwrap()).ok() }
}
#[inline]
pub unsafe fn MFGetAttributesAsBlobSize<P0>(pattributes: P0) -> windows_core::Result<u32>
where
    P0: windows_core::Param<IMFAttributes>,
{
    windows_targets::link!("mfplat.dll" "system" fn MFGetAttributesAsBlobSize(pattributes : * mut core::ffi::c_void, pcbbufsize : *mut u32) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFGetAttributesAsBlobSize(pattributes.param().abi(), &mut result__).map(|| core::mem::transmute(result__))
    }
}
#[inline]
pub unsafe fn MFGetContentProtectionSystemCLSID(guidprotectionsystemid: *const windows_core::GUID) -> windows_core::Result<windows_core::GUID> {
    windows_targets::link!("mfplat.dll" "system" fn MFGetContentProtectionSystemCLSID(guidprotectionsystemid : *const windows_core::GUID, pclsid : *mut windows_core::GUID) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFGetContentProtectionSystemCLSID(guidprotectionsystemid, &mut result__).map(|| core::mem::transmute(result__))
    }
}
#[inline]
pub unsafe fn MFGetLocalId(verifier: &[u8]) -> windows_core::Result<windows_core::PWSTR> {
    windows_targets::link!("mf.dll" "system" fn MFGetLocalId(verifier : *const u8, size : u32, id : *mut windows_core::PWSTR) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFGetLocalId(core::mem::transmute(verifier.as_ptr()), verifier.len().try_into().unwrap(), &mut result__).map(|| core::mem::transmute(result__))
    }
}
#[inline]
pub unsafe fn MFGetMFTMerit<P0>(pmft: P0, verifier: &[u8]) -> windows_core::Result<u32>
where
    P0: windows_core::Param<windows_core::IUnknown>,
{
    windows_targets::link!("mfplat.dll" "system" fn MFGetMFTMerit(pmft : * mut core::ffi::c_void, cbverifier : u32, verifier : *const u8, merit : *mut u32) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFGetMFTMerit(pmft.param().abi(), verifier.len().try_into().unwrap(), core::mem::transmute(verifier.as_ptr()), &mut result__).map(|| core::mem::transmute(result__))
    }
}
#[inline]
pub unsafe fn MFGetPlaneSize(format: u32, dwwidth: u32, dwheight: u32) -> windows_core::Result<u32> {
    windows_targets::link!("evr.dll" "system" fn MFGetPlaneSize(format : u32, dwwidth : u32, dwheight : u32, pdwplanesize : *mut u32) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFGetPlaneSize(format, dwwidth, dwheight, &mut result__).map(|| core::mem::transmute(result__))
    }
}
#[inline]
pub unsafe fn MFGetPluginControl() -> windows_core::Result<IMFPluginControl> {
    windows_targets::link!("mfplat.dll" "system" fn MFGetPluginControl(ppplugincontrol : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFGetPluginControl(&mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFGetService<P0>(punkobject: P0, guidservice: *const windows_core::GUID, riid: *const windows_core::GUID, ppvobject: *mut *mut core::ffi::c_void) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::IUnknown>,
{
    windows_targets::link!("mf.dll" "system" fn MFGetService(punkobject : * mut core::ffi::c_void, guidservice : *const windows_core::GUID, riid : *const windows_core::GUID, ppvobject : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe { MFGetService(punkobject.param().abi(), guidservice, riid, ppvobject as _).ok() }
}
#[inline]
pub unsafe fn MFGetStrideForBitmapInfoHeader(format: u32, dwwidth: u32) -> windows_core::Result<i32> {
    windows_targets::link!("mfplat.dll" "system" fn MFGetStrideForBitmapInfoHeader(format : u32, dwwidth : u32, pstride : *mut i32) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFGetStrideForBitmapInfoHeader(format, dwwidth, &mut result__).map(|| core::mem::transmute(result__))
    }
}
#[cfg(all(feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Variant"))]
#[inline]
pub unsafe fn MFGetSupportedMimeTypes() -> windows_core::Result<super::super::System::Com::StructuredStorage::PROPVARIANT> {
    windows_targets::link!("mfplat.dll" "system" fn MFGetSupportedMimeTypes(ppropvarmimetypearray : *mut super::super::System::Com::StructuredStorage:: PROPVARIANT) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFGetSupportedMimeTypes(&mut result__).map(|| core::mem::transmute(result__))
    }
}
#[cfg(all(feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Variant"))]
#[inline]
pub unsafe fn MFGetSupportedSchemes() -> windows_core::Result<super::super::System::Com::StructuredStorage::PROPVARIANT> {
    windows_targets::link!("mfplat.dll" "system" fn MFGetSupportedSchemes(ppropvarschemearray : *mut super::super::System::Com::StructuredStorage:: PROPVARIANT) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFGetSupportedSchemes(&mut result__).map(|| core::mem::transmute(result__))
    }
}
#[inline]
pub unsafe fn MFGetSystemId() -> windows_core::Result<IMFSystemId> {
    windows_targets::link!("mf.dll" "system" fn MFGetSystemId(ppid : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFGetSystemId(&mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFGetSystemTime() -> i64 {
    windows_targets::link!("mfplat.dll" "system" fn MFGetSystemTime() -> i64);
    unsafe { MFGetSystemTime() }
}
#[inline]
pub unsafe fn MFGetTimerPeriodicity() -> windows_core::Result<u32> {
    windows_targets::link!("mfplat.dll" "system" fn MFGetTimerPeriodicity(periodicity : *mut u32) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFGetTimerPeriodicity(&mut result__).map(|| core::mem::transmute(result__))
    }
}
#[inline]
pub unsafe fn MFGetTopoNodeCurrentType<P0>(pnode: P0, dwstreamindex: u32, foutput: bool) -> windows_core::Result<IMFMediaType>
where
    P0: windows_core::Param<IMFTopologyNode>,
{
    windows_targets::link!("mf.dll" "system" fn MFGetTopoNodeCurrentType(pnode : * mut core::ffi::c_void, dwstreamindex : u32, foutput : super::super::Foundation:: BOOL, pptype : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFGetTopoNodeCurrentType(pnode.param().abi(), dwstreamindex, foutput.into(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFGetUncompressedVideoFormat(pvideoformat: *const MFVIDEOFORMAT) -> u32 {
    windows_targets::link!("mfplat.dll" "system" fn MFGetUncompressedVideoFormat(pvideoformat : *const MFVIDEOFORMAT) -> u32);
    unsafe { MFGetUncompressedVideoFormat(pvideoformat) }
}
#[inline]
pub unsafe fn MFGetWorkQueueMMCSSClass(dwworkqueueid: u32, pwszclass: Option<windows_core::PWSTR>, pcchclass: *mut u32) -> windows_core::Result<()> {
    windows_targets::link!("mfplat.dll" "system" fn MFGetWorkQueueMMCSSClass(dwworkqueueid : u32, pwszclass : windows_core::PWSTR, pcchclass : *mut u32) -> windows_core::HRESULT);
    unsafe { MFGetWorkQueueMMCSSClass(dwworkqueueid, pwszclass.unwrap_or(core::mem::zeroed()) as _, pcchclass as _).ok() }
}
#[inline]
pub unsafe fn MFGetWorkQueueMMCSSPriority(dwworkqueueid: u32) -> windows_core::Result<i32> {
    windows_targets::link!("mfplat.dll" "system" fn MFGetWorkQueueMMCSSPriority(dwworkqueueid : u32, lpriority : *mut i32) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFGetWorkQueueMMCSSPriority(dwworkqueueid, &mut result__).map(|| core::mem::transmute(result__))
    }
}
#[inline]
pub unsafe fn MFGetWorkQueueMMCSSTaskId(dwworkqueueid: u32) -> windows_core::Result<u32> {
    windows_targets::link!("mfplat.dll" "system" fn MFGetWorkQueueMMCSSTaskId(dwworkqueueid : u32, pdwtaskid : *mut u32) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFGetWorkQueueMMCSSTaskId(dwworkqueueid, &mut result__).map(|| core::mem::transmute(result__))
    }
}
#[inline]
pub unsafe fn MFHeapAlloc<P2>(nsize: usize, dwflags: u32, pszfile: P2, line: i32, eat: EAllocationType) -> *mut core::ffi::c_void
where
    P2: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("mfplat.dll" "system" fn MFHeapAlloc(nsize : usize, dwflags : u32, pszfile : windows_core::PCSTR, line : i32, eat : EAllocationType) -> *mut core::ffi::c_void);
    unsafe { MFHeapAlloc(nsize, dwflags, pszfile.param().abi(), line, eat) }
}
#[inline]
pub unsafe fn MFHeapFree(pv: *mut core::ffi::c_void) {
    windows_targets::link!("mfplat.dll" "system" fn MFHeapFree(pv : *mut core::ffi::c_void));
    unsafe { MFHeapFree(pv as _) }
}
#[inline]
pub unsafe fn MFInitAMMediaTypeFromMFMediaType<P0>(pmftype: P0, guidformatblocktype: windows_core::GUID, pamtype: *mut AM_MEDIA_TYPE) -> windows_core::Result<()>
where
    P0: windows_core::Param<IMFMediaType>,
{
    windows_targets::link!("mfplat.dll" "system" fn MFInitAMMediaTypeFromMFMediaType(pmftype : * mut core::ffi::c_void, guidformatblocktype : windows_core::GUID, pamtype : *mut AM_MEDIA_TYPE) -> windows_core::HRESULT);
    unsafe { MFInitAMMediaTypeFromMFMediaType(pmftype.param().abi(), core::mem::transmute(guidformatblocktype), core::mem::transmute(pamtype)).ok() }
}
#[inline]
pub unsafe fn MFInitAttributesFromBlob<P0>(pattributes: P0, pbuf: &[u8]) -> windows_core::Result<()>
where
    P0: windows_core::Param<IMFAttributes>,
{
    windows_targets::link!("mfplat.dll" "system" fn MFInitAttributesFromBlob(pattributes : * mut core::ffi::c_void, pbuf : *const u8, cbbufsize : u32) -> windows_core::HRESULT);
    unsafe { MFInitAttributesFromBlob(pattributes.param().abi(), core::mem::transmute(pbuf.as_ptr()), pbuf.len().try_into().unwrap()).ok() }
}
#[inline]
pub unsafe fn MFInitMediaTypeFromAMMediaType<P0>(pmftype: P0, pamtype: *const AM_MEDIA_TYPE) -> windows_core::Result<()>
where
    P0: windows_core::Param<IMFMediaType>,
{
    windows_targets::link!("mfplat.dll" "system" fn MFInitMediaTypeFromAMMediaType(pmftype : * mut core::ffi::c_void, pamtype : *const AM_MEDIA_TYPE) -> windows_core::HRESULT);
    unsafe { MFInitMediaTypeFromAMMediaType(pmftype.param().abi(), core::mem::transmute(pamtype)).ok() }
}
#[inline]
pub unsafe fn MFInitMediaTypeFromMFVideoFormat<P0>(pmftype: P0, pmfvf: *const MFVIDEOFORMAT, cbbufsize: u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<IMFMediaType>,
{
    windows_targets::link!("mfplat.dll" "system" fn MFInitMediaTypeFromMFVideoFormat(pmftype : * mut core::ffi::c_void, pmfvf : *const MFVIDEOFORMAT, cbbufsize : u32) -> windows_core::HRESULT);
    unsafe { MFInitMediaTypeFromMFVideoFormat(pmftype.param().abi(), pmfvf, cbbufsize).ok() }
}
#[cfg(feature = "Win32_Graphics_Gdi")]
#[inline]
pub unsafe fn MFInitMediaTypeFromMPEG1VideoInfo<P0>(pmftype: P0, pmp1vi: *const MPEG1VIDEOINFO, cbbufsize: u32, psubtype: Option<*const windows_core::GUID>) -> windows_core::Result<()>
where
    P0: windows_core::Param<IMFMediaType>,
{
    windows_targets::link!("mfplat.dll" "system" fn MFInitMediaTypeFromMPEG1VideoInfo(pmftype : * mut core::ffi::c_void, pmp1vi : *const MPEG1VIDEOINFO, cbbufsize : u32, psubtype : *const windows_core::GUID) -> windows_core::HRESULT);
    unsafe { MFInitMediaTypeFromMPEG1VideoInfo(pmftype.param().abi(), pmp1vi, cbbufsize, psubtype.unwrap_or(core::mem::zeroed()) as _).ok() }
}
#[cfg(feature = "Win32_Graphics_Gdi")]
#[inline]
pub unsafe fn MFInitMediaTypeFromMPEG2VideoInfo<P0>(pmftype: P0, pmp2vi: *const MPEG2VIDEOINFO, cbbufsize: u32, psubtype: Option<*const windows_core::GUID>) -> windows_core::Result<()>
where
    P0: windows_core::Param<IMFMediaType>,
{
    windows_targets::link!("mfplat.dll" "system" fn MFInitMediaTypeFromMPEG2VideoInfo(pmftype : * mut core::ffi::c_void, pmp2vi : *const MPEG2VIDEOINFO, cbbufsize : u32, psubtype : *const windows_core::GUID) -> windows_core::HRESULT);
    unsafe { MFInitMediaTypeFromMPEG2VideoInfo(pmftype.param().abi(), pmp2vi, cbbufsize, psubtype.unwrap_or(core::mem::zeroed()) as _).ok() }
}
#[cfg(feature = "Win32_Graphics_Gdi")]
#[inline]
pub unsafe fn MFInitMediaTypeFromVideoInfoHeader<P0>(pmftype: P0, pvih: *const VIDEOINFOHEADER, cbbufsize: u32, psubtype: Option<*const windows_core::GUID>) -> windows_core::Result<()>
where
    P0: windows_core::Param<IMFMediaType>,
{
    windows_targets::link!("mfplat.dll" "system" fn MFInitMediaTypeFromVideoInfoHeader(pmftype : * mut core::ffi::c_void, pvih : *const VIDEOINFOHEADER, cbbufsize : u32, psubtype : *const windows_core::GUID) -> windows_core::HRESULT);
    unsafe { MFInitMediaTypeFromVideoInfoHeader(pmftype.param().abi(), pvih, cbbufsize, psubtype.unwrap_or(core::mem::zeroed()) as _).ok() }
}
#[cfg(feature = "Win32_Graphics_Gdi")]
#[inline]
pub unsafe fn MFInitMediaTypeFromVideoInfoHeader2<P0>(pmftype: P0, pvih2: *const VIDEOINFOHEADER2, cbbufsize: u32, psubtype: Option<*const windows_core::GUID>) -> windows_core::Result<()>
where
    P0: windows_core::Param<IMFMediaType>,
{
    windows_targets::link!("mfplat.dll" "system" fn MFInitMediaTypeFromVideoInfoHeader2(pmftype : * mut core::ffi::c_void, pvih2 : *const VIDEOINFOHEADER2, cbbufsize : u32, psubtype : *const windows_core::GUID) -> windows_core::HRESULT);
    unsafe { MFInitMediaTypeFromVideoInfoHeader2(pmftype.param().abi(), pvih2, cbbufsize, psubtype.unwrap_or(core::mem::zeroed()) as _).ok() }
}
#[cfg(feature = "Win32_Media_Audio")]
#[inline]
pub unsafe fn MFInitMediaTypeFromWaveFormatEx<P0>(pmftype: P0, pwaveformat: *const super::Audio::WAVEFORMATEX, cbbufsize: u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<IMFMediaType>,
{
    windows_targets::link!("mfplat.dll" "system" fn MFInitMediaTypeFromWaveFormatEx(pmftype : * mut core::ffi::c_void, pwaveformat : *const super::Audio:: WAVEFORMATEX, cbbufsize : u32) -> windows_core::HRESULT);
    unsafe { MFInitMediaTypeFromWaveFormatEx(pmftype.param().abi(), pwaveformat, cbbufsize).ok() }
}
#[inline]
pub unsafe fn MFInitVideoFormat(pvideoformat: *const MFVIDEOFORMAT, r#type: MFStandardVideoFormat) -> windows_core::Result<()> {
    windows_targets::link!("mfplat.dll" "system" fn MFInitVideoFormat(pvideoformat : *const MFVIDEOFORMAT, r#type : MFStandardVideoFormat) -> windows_core::HRESULT);
    unsafe { MFInitVideoFormat(pvideoformat, r#type).ok() }
}
#[inline]
pub unsafe fn MFInitVideoFormat_RGB(pvideoformat: *const MFVIDEOFORMAT, dwwidth: u32, dwheight: u32, d3dfmt: u32) -> windows_core::Result<()> {
    windows_targets::link!("mfplat.dll" "system" fn MFInitVideoFormat_RGB(pvideoformat : *const MFVIDEOFORMAT, dwwidth : u32, dwheight : u32, d3dfmt : u32) -> windows_core::HRESULT);
    unsafe { MFInitVideoFormat_RGB(pvideoformat, dwwidth, dwheight, d3dfmt).ok() }
}
#[inline]
pub unsafe fn MFInvokeCallback<P0>(pasyncresult: P0) -> windows_core::Result<()>
where
    P0: windows_core::Param<IMFAsyncResult>,
{
    windows_targets::link!("mfplat.dll" "system" fn MFInvokeCallback(pasyncresult : * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe { MFInvokeCallback(pasyncresult.param().abi()).ok() }
}
#[inline]
pub unsafe fn MFIsContentProtectionDeviceSupported(protectionsystemid: *const windows_core::GUID) -> windows_core::Result<super::super::Foundation::BOOL> {
    windows_targets::link!("mfplat.dll" "system" fn MFIsContentProtectionDeviceSupported(protectionsystemid : *const windows_core::GUID, issupported : *mut super::super::Foundation:: BOOL) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFIsContentProtectionDeviceSupported(protectionsystemid, &mut result__).map(|| core::mem::transmute(result__))
    }
}
#[inline]
pub unsafe fn MFIsFormatYUV(format: u32) -> super::super::Foundation::BOOL {
    windows_targets::link!("evr.dll" "system" fn MFIsFormatYUV(format : u32) -> super::super::Foundation:: BOOL);
    unsafe { MFIsFormatYUV(format) }
}
#[inline]
pub unsafe fn MFIsVirtualCameraTypeSupported(r#type: MFVirtualCameraType) -> windows_core::Result<super::super::Foundation::BOOL> {
    windows_targets::link!("mfsensorgroup.dll" "system" fn MFIsVirtualCameraTypeSupported(r#type : MFVirtualCameraType, supported : *mut super::super::Foundation:: BOOL) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFIsVirtualCameraTypeSupported(r#type, &mut result__).map(|| core::mem::transmute(result__))
    }
}
#[inline]
pub unsafe fn MFLoadSignedLibrary<P0>(pszname: P0) -> windows_core::Result<IMFSignedLibrary>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("mf.dll" "system" fn MFLoadSignedLibrary(pszname : windows_core::PCWSTR, pplib : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFLoadSignedLibrary(pszname.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFLockDXGIDeviceManager(presettoken: Option<*mut u32>, ppmanager: *mut Option<IMFDXGIDeviceManager>) -> windows_core::Result<()> {
    windows_targets::link!("mfplat.dll" "system" fn MFLockDXGIDeviceManager(presettoken : *mut u32, ppmanager : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe { MFLockDXGIDeviceManager(presettoken.unwrap_or(core::mem::zeroed()) as _, core::mem::transmute(ppmanager)).ok() }
}
#[inline]
pub unsafe fn MFLockPlatform() -> windows_core::Result<()> {
    windows_targets::link!("mfplat.dll" "system" fn MFLockPlatform() -> windows_core::HRESULT);
    unsafe { MFLockPlatform().ok() }
}
#[inline]
pub unsafe fn MFLockSharedWorkQueue<P0>(wszclass: P0, basepriority: i32, pdwtaskid: *mut u32, pid: *mut u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("mfplat.dll" "system" fn MFLockSharedWorkQueue(wszclass : windows_core::PCWSTR, basepriority : i32, pdwtaskid : *mut u32, pid : *mut u32) -> windows_core::HRESULT);
    unsafe { MFLockSharedWorkQueue(wszclass.param().abi(), basepriority, pdwtaskid as _, pid as _).ok() }
}
#[inline]
pub unsafe fn MFLockWorkQueue(dwworkqueue: u32) -> windows_core::Result<()> {
    windows_targets::link!("mfplat.dll" "system" fn MFLockWorkQueue(dwworkqueue : u32) -> windows_core::HRESULT);
    unsafe { MFLockWorkQueue(dwworkqueue).ok() }
}
#[cfg(feature = "Win32_Graphics_Dxgi_Common")]
#[inline]
pub unsafe fn MFMapDX9FormatToDXGIFormat(dx9: u32) -> super::super::Graphics::Dxgi::Common::DXGI_FORMAT {
    windows_targets::link!("mfplat.dll" "system" fn MFMapDX9FormatToDXGIFormat(dx9 : u32) -> super::super::Graphics::Dxgi::Common:: DXGI_FORMAT);
    unsafe { MFMapDX9FormatToDXGIFormat(dx9) }
}
#[cfg(feature = "Win32_Graphics_Dxgi_Common")]
#[inline]
pub unsafe fn MFMapDXGIFormatToDX9Format(dx11: super::super::Graphics::Dxgi::Common::DXGI_FORMAT) -> u32 {
    windows_targets::link!("mfplat.dll" "system" fn MFMapDXGIFormatToDX9Format(dx11 : super::super::Graphics::Dxgi::Common:: DXGI_FORMAT) -> u32);
    unsafe { MFMapDXGIFormatToDX9Format(dx11) }
}
#[inline]
pub unsafe fn MFPCreateMediaPlayer<P0, P3>(pwszurl: P0, fstartplayback: bool, creationoptions: MFP_CREATION_OPTIONS, pcallback: P3, hwnd: Option<super::super::Foundation::HWND>, ppmediaplayer: Option<*mut Option<IMFPMediaPlayer>>) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P3: windows_core::Param<IMFPMediaPlayerCallback>,
{
    windows_targets::link!("mfplay.dll" "system" fn MFPCreateMediaPlayer(pwszurl : windows_core::PCWSTR, fstartplayback : super::super::Foundation:: BOOL, creationoptions : MFP_CREATION_OPTIONS, pcallback : * mut core::ffi::c_void, hwnd : super::super::Foundation:: HWND, ppmediaplayer : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe { MFPCreateMediaPlayer(pwszurl.param().abi(), fstartplayback.into(), creationoptions, pcallback.param().abi(), hwnd.unwrap_or(core::mem::zeroed()) as _, ppmediaplayer.unwrap_or(core::mem::zeroed()) as _).ok() }
}
#[inline]
pub unsafe fn MFPutWaitingWorkItem<P2>(hevent: super::super::Foundation::HANDLE, priority: i32, presult: P2, pkey: Option<*mut u64>) -> windows_core::Result<()>
where
    P2: windows_core::Param<IMFAsyncResult>,
{
    windows_targets::link!("mfplat.dll" "system" fn MFPutWaitingWorkItem(hevent : super::super::Foundation:: HANDLE, priority : i32, presult : * mut core::ffi::c_void, pkey : *mut u64) -> windows_core::HRESULT);
    unsafe { MFPutWaitingWorkItem(hevent, priority, presult.param().abi(), pkey.unwrap_or(core::mem::zeroed()) as _).ok() }
}
#[inline]
pub unsafe fn MFPutWorkItem<P1, P2>(dwqueue: u32, pcallback: P1, pstate: P2) -> windows_core::Result<()>
where
    P1: windows_core::Param<IMFAsyncCallback>,
    P2: windows_core::Param<windows_core::IUnknown>,
{
    windows_targets::link!("mfplat.dll" "system" fn MFPutWorkItem(dwqueue : u32, pcallback : * mut core::ffi::c_void, pstate : * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe { MFPutWorkItem(dwqueue, pcallback.param().abi(), pstate.param().abi()).ok() }
}
#[inline]
pub unsafe fn MFPutWorkItem2<P2, P3>(dwqueue: u32, priority: i32, pcallback: P2, pstate: P3) -> windows_core::Result<()>
where
    P2: windows_core::Param<IMFAsyncCallback>,
    P3: windows_core::Param<windows_core::IUnknown>,
{
    windows_targets::link!("mfplat.dll" "system" fn MFPutWorkItem2(dwqueue : u32, priority : i32, pcallback : * mut core::ffi::c_void, pstate : * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe { MFPutWorkItem2(dwqueue, priority, pcallback.param().abi(), pstate.param().abi()).ok() }
}
#[inline]
pub unsafe fn MFPutWorkItemEx<P1>(dwqueue: u32, presult: P1) -> windows_core::Result<()>
where
    P1: windows_core::Param<IMFAsyncResult>,
{
    windows_targets::link!("mfplat.dll" "system" fn MFPutWorkItemEx(dwqueue : u32, presult : * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe { MFPutWorkItemEx(dwqueue, presult.param().abi()).ok() }
}
#[inline]
pub unsafe fn MFPutWorkItemEx2<P2>(dwqueue: u32, priority: i32, presult: P2) -> windows_core::Result<()>
where
    P2: windows_core::Param<IMFAsyncResult>,
{
    windows_targets::link!("mfplat.dll" "system" fn MFPutWorkItemEx2(dwqueue : u32, priority : i32, presult : * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe { MFPutWorkItemEx2(dwqueue, priority, presult.param().abi()).ok() }
}
#[inline]
pub unsafe fn MFRegisterLocalByteStreamHandler<P0, P1, P2>(szfileextension: P0, szmimetype: P1, pactivate: P2) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
    P2: windows_core::Param<IMFActivate>,
{
    windows_targets::link!("mfplat.dll" "system" fn MFRegisterLocalByteStreamHandler(szfileextension : windows_core::PCWSTR, szmimetype : windows_core::PCWSTR, pactivate : * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe { MFRegisterLocalByteStreamHandler(szfileextension.param().abi(), szmimetype.param().abi(), pactivate.param().abi()).ok() }
}
#[inline]
pub unsafe fn MFRegisterLocalSchemeHandler<P0, P1>(szscheme: P0, pactivate: P1) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<IMFActivate>,
{
    windows_targets::link!("mfplat.dll" "system" fn MFRegisterLocalSchemeHandler(szscheme : windows_core::PCWSTR, pactivate : * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe { MFRegisterLocalSchemeHandler(szscheme.param().abi(), pactivate.param().abi()).ok() }
}
#[inline]
pub unsafe fn MFRegisterPlatformWithMMCSS<P0>(wszclass: P0, pdwtaskid: *mut u32, lpriority: i32) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("mfplat.dll" "system" fn MFRegisterPlatformWithMMCSS(wszclass : windows_core::PCWSTR, pdwtaskid : *mut u32, lpriority : i32) -> windows_core::HRESULT);
    unsafe { MFRegisterPlatformWithMMCSS(wszclass.param().abi(), pdwtaskid as _, lpriority).ok() }
}
#[inline]
pub unsafe fn MFRemovePeriodicCallback(dwkey: u32) -> windows_core::Result<()> {
    windows_targets::link!("mfplat.dll" "system" fn MFRemovePeriodicCallback(dwkey : u32) -> windows_core::HRESULT);
    unsafe { MFRemovePeriodicCallback(dwkey).ok() }
}
#[inline]
pub unsafe fn MFRequireProtectedEnvironment<P0>(ppresentationdescriptor: P0) -> windows_core::Result<()>
where
    P0: windows_core::Param<IMFPresentationDescriptor>,
{
    windows_targets::link!("mf.dll" "system" fn MFRequireProtectedEnvironment(ppresentationdescriptor : * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe { MFRequireProtectedEnvironment(ppresentationdescriptor.param().abi()).ok() }
}
#[inline]
pub unsafe fn MFScheduleWorkItem<P0, P1>(pcallback: P0, pstate: P1, timeout: i64, pkey: Option<*mut u64>) -> windows_core::Result<()>
where
    P0: windows_core::Param<IMFAsyncCallback>,
    P1: windows_core::Param<windows_core::IUnknown>,
{
    windows_targets::link!("mfplat.dll" "system" fn MFScheduleWorkItem(pcallback : * mut core::ffi::c_void, pstate : * mut core::ffi::c_void, timeout : i64, pkey : *mut u64) -> windows_core::HRESULT);
    unsafe { MFScheduleWorkItem(pcallback.param().abi(), pstate.param().abi(), timeout, pkey.unwrap_or(core::mem::zeroed()) as _).ok() }
}
#[inline]
pub unsafe fn MFScheduleWorkItemEx<P0>(presult: P0, timeout: i64, pkey: Option<*mut u64>) -> windows_core::Result<()>
where
    P0: windows_core::Param<IMFAsyncResult>,
{
    windows_targets::link!("mfplat.dll" "system" fn MFScheduleWorkItemEx(presult : * mut core::ffi::c_void, timeout : i64, pkey : *mut u64) -> windows_core::HRESULT);
    unsafe { MFScheduleWorkItemEx(presult.param().abi(), timeout, pkey.unwrap_or(core::mem::zeroed()) as _).ok() }
}
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn MFSerializeAttributesToStream<P0, P2>(pattr: P0, dwoptions: u32, pstm: P2) -> windows_core::Result<()>
where
    P0: windows_core::Param<IMFAttributes>,
    P2: windows_core::Param<super::super::System::Com::IStream>,
{
    windows_targets::link!("mfplat.dll" "system" fn MFSerializeAttributesToStream(pattr : * mut core::ffi::c_void, dwoptions : u32, pstm : * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe { MFSerializeAttributesToStream(pattr.param().abi(), dwoptions, pstm.param().abi()).ok() }
}
#[inline]
pub unsafe fn MFSerializePresentationDescriptor<P0>(ppd: P0, pcbdata: *mut u32, ppbdata: *mut *mut u8) -> windows_core::Result<()>
where
    P0: windows_core::Param<IMFPresentationDescriptor>,
{
    windows_targets::link!("mfplat.dll" "system" fn MFSerializePresentationDescriptor(ppd : * mut core::ffi::c_void, pcbdata : *mut u32, ppbdata : *mut *mut u8) -> windows_core::HRESULT);
    unsafe { MFSerializePresentationDescriptor(ppd.param().abi(), pcbdata as _, ppbdata as _).ok() }
}
#[inline]
pub unsafe fn MFShutdown() -> windows_core::Result<()> {
    windows_targets::link!("mfplat.dll" "system" fn MFShutdown() -> windows_core::HRESULT);
    unsafe { MFShutdown().ok() }
}
#[inline]
pub unsafe fn MFShutdownObject<P0>(punk: P0) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::IUnknown>,
{
    windows_targets::link!("mf.dll" "system" fn MFShutdownObject(punk : * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe { MFShutdownObject(punk.param().abi()).ok() }
}
#[inline]
pub unsafe fn MFSplitSample<P0>(psample: P0, poutputsamples: &mut [Option<IMFSample>], pdwoutputsamplecount: *mut u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<IMFSample>,
{
    windows_targets::link!("mfplat.dll" "system" fn MFSplitSample(psample : * mut core::ffi::c_void, poutputsamples : *mut * mut core::ffi::c_void, dwoutputsamplemaxcount : u32, pdwoutputsamplecount : *mut u32) -> windows_core::HRESULT);
    unsafe { MFSplitSample(psample.param().abi(), core::mem::transmute(poutputsamples.as_ptr()), poutputsamples.len().try_into().unwrap(), pdwoutputsamplecount as _).ok() }
}
#[inline]
pub unsafe fn MFStartup(version: u32, dwflags: u32) -> windows_core::Result<()> {
    windows_targets::link!("mfplat.dll" "system" fn MFStartup(version : u32, dwflags : u32) -> windows_core::HRESULT);
    unsafe { MFStartup(version, dwflags).ok() }
}
#[inline]
pub unsafe fn MFTEnum<P4>(guidcategory: windows_core::GUID, flags: u32, pinputtype: Option<*const MFT_REGISTER_TYPE_INFO>, poutputtype: Option<*const MFT_REGISTER_TYPE_INFO>, pattributes: P4, ppclsidmft: *mut *mut windows_core::GUID, pcmfts: *mut u32) -> windows_core::Result<()>
where
    P4: windows_core::Param<IMFAttributes>,
{
    windows_targets::link!("mfplat.dll" "system" fn MFTEnum(guidcategory : windows_core::GUID, flags : u32, pinputtype : *const MFT_REGISTER_TYPE_INFO, poutputtype : *const MFT_REGISTER_TYPE_INFO, pattributes : * mut core::ffi::c_void, ppclsidmft : *mut *mut windows_core::GUID, pcmfts : *mut u32) -> windows_core::HRESULT);
    unsafe { MFTEnum(core::mem::transmute(guidcategory), flags, pinputtype.unwrap_or(core::mem::zeroed()) as _, poutputtype.unwrap_or(core::mem::zeroed()) as _, pattributes.param().abi(), ppclsidmft as _, pcmfts as _).ok() }
}
#[inline]
pub unsafe fn MFTEnum2<P4>(guidcategory: windows_core::GUID, flags: MFT_ENUM_FLAG, pinputtype: Option<*const MFT_REGISTER_TYPE_INFO>, poutputtype: Option<*const MFT_REGISTER_TYPE_INFO>, pattributes: P4, pppmftactivate: *mut *mut Option<IMFActivate>, pnummftactivate: *mut u32) -> windows_core::Result<()>
where
    P4: windows_core::Param<IMFAttributes>,
{
    windows_targets::link!("mfplat.dll" "system" fn MFTEnum2(guidcategory : windows_core::GUID, flags : u32, pinputtype : *const MFT_REGISTER_TYPE_INFO, poutputtype : *const MFT_REGISTER_TYPE_INFO, pattributes : * mut core::ffi::c_void, pppmftactivate : *mut *mut * mut core::ffi::c_void, pnummftactivate : *mut u32) -> windows_core::HRESULT);
    unsafe { MFTEnum2(core::mem::transmute(guidcategory), flags.0 as _, pinputtype.unwrap_or(core::mem::zeroed()) as _, poutputtype.unwrap_or(core::mem::zeroed()) as _, pattributes.param().abi(), pppmftactivate as _, pnummftactivate as _).ok() }
}
#[inline]
pub unsafe fn MFTEnumEx(guidcategory: windows_core::GUID, flags: MFT_ENUM_FLAG, pinputtype: Option<*const MFT_REGISTER_TYPE_INFO>, poutputtype: Option<*const MFT_REGISTER_TYPE_INFO>, pppmftactivate: *mut *mut Option<IMFActivate>, pnummftactivate: *mut u32) -> windows_core::Result<()> {
    windows_targets::link!("mfplat.dll" "system" fn MFTEnumEx(guidcategory : windows_core::GUID, flags : u32, pinputtype : *const MFT_REGISTER_TYPE_INFO, poutputtype : *const MFT_REGISTER_TYPE_INFO, pppmftactivate : *mut *mut * mut core::ffi::c_void, pnummftactivate : *mut u32) -> windows_core::HRESULT);
    unsafe { MFTEnumEx(core::mem::transmute(guidcategory), flags.0 as _, pinputtype.unwrap_or(core::mem::zeroed()) as _, poutputtype.unwrap_or(core::mem::zeroed()) as _, pppmftactivate as _, pnummftactivate as _).ok() }
}
#[inline]
pub unsafe fn MFTGetInfo(clsidmft: windows_core::GUID, pszname: Option<*mut windows_core::PWSTR>, ppinputtypes: Option<*mut *mut MFT_REGISTER_TYPE_INFO>, pcinputtypes: Option<*mut u32>, ppoutputtypes: Option<*mut *mut MFT_REGISTER_TYPE_INFO>, pcoutputtypes: Option<*mut u32>, ppattributes: Option<*mut Option<IMFAttributes>>) -> windows_core::Result<()> {
    windows_targets::link!("mfplat.dll" "system" fn MFTGetInfo(clsidmft : windows_core::GUID, pszname : *mut windows_core::PWSTR, ppinputtypes : *mut *mut MFT_REGISTER_TYPE_INFO, pcinputtypes : *mut u32, ppoutputtypes : *mut *mut MFT_REGISTER_TYPE_INFO, pcoutputtypes : *mut u32, ppattributes : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe { MFTGetInfo(core::mem::transmute(clsidmft), pszname.unwrap_or(core::mem::zeroed()) as _, ppinputtypes.unwrap_or(core::mem::zeroed()) as _, pcinputtypes.unwrap_or(core::mem::zeroed()) as _, ppoutputtypes.unwrap_or(core::mem::zeroed()) as _, pcoutputtypes.unwrap_or(core::mem::zeroed()) as _, ppattributes.unwrap_or(core::mem::zeroed()) as _).ok() }
}
#[inline]
pub unsafe fn MFTRegister<P2, P8>(clsidmft: windows_core::GUID, guidcategory: windows_core::GUID, pszname: P2, flags: u32, pinputtypes: Option<&[MFT_REGISTER_TYPE_INFO]>, poutputtypes: Option<&[MFT_REGISTER_TYPE_INFO]>, pattributes: P8) -> windows_core::Result<()>
where
    P2: windows_core::Param<windows_core::PCWSTR>,
    P8: windows_core::Param<IMFAttributes>,
{
    windows_targets::link!("mfplat.dll" "system" fn MFTRegister(clsidmft : windows_core::GUID, guidcategory : windows_core::GUID, pszname : windows_core::PCWSTR, flags : u32, cinputtypes : u32, pinputtypes : *const MFT_REGISTER_TYPE_INFO, coutputtypes : u32, poutputtypes : *const MFT_REGISTER_TYPE_INFO, pattributes : * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe { MFTRegister(core::mem::transmute(clsidmft), core::mem::transmute(guidcategory), pszname.param().abi(), flags, pinputtypes.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(pinputtypes.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), poutputtypes.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(poutputtypes.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), pattributes.param().abi()).ok() }
}
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn MFTRegisterLocal<P0, P2>(pclassfactory: P0, guidcategory: *const windows_core::GUID, pszname: P2, flags: u32, pinputtypes: Option<&[MFT_REGISTER_TYPE_INFO]>, poutputtypes: Option<&[MFT_REGISTER_TYPE_INFO]>) -> windows_core::Result<()>
where
    P0: windows_core::Param<super::super::System::Com::IClassFactory>,
    P2: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("mfplat.dll" "system" fn MFTRegisterLocal(pclassfactory : * mut core::ffi::c_void, guidcategory : *const windows_core::GUID, pszname : windows_core::PCWSTR, flags : u32, cinputtypes : u32, pinputtypes : *const MFT_REGISTER_TYPE_INFO, coutputtypes : u32, poutputtypes : *const MFT_REGISTER_TYPE_INFO) -> windows_core::HRESULT);
    unsafe { MFTRegisterLocal(pclassfactory.param().abi(), guidcategory, pszname.param().abi(), flags, pinputtypes.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(pinputtypes.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), poutputtypes.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(poutputtypes.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr()))).ok() }
}
#[inline]
pub unsafe fn MFTRegisterLocalByCLSID<P2>(clisdmft: *const windows_core::GUID, guidcategory: *const windows_core::GUID, pszname: P2, flags: u32, pinputtypes: Option<&[MFT_REGISTER_TYPE_INFO]>, poutputtypes: Option<&[MFT_REGISTER_TYPE_INFO]>) -> windows_core::Result<()>
where
    P2: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("mfplat.dll" "system" fn MFTRegisterLocalByCLSID(clisdmft : *const windows_core::GUID, guidcategory : *const windows_core::GUID, pszname : windows_core::PCWSTR, flags : u32, cinputtypes : u32, pinputtypes : *const MFT_REGISTER_TYPE_INFO, coutputtypes : u32, poutputtypes : *const MFT_REGISTER_TYPE_INFO) -> windows_core::HRESULT);
    unsafe { MFTRegisterLocalByCLSID(clisdmft, guidcategory, pszname.param().abi(), flags, pinputtypes.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(pinputtypes.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), poutputtypes.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(poutputtypes.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr()))).ok() }
}
#[inline]
pub unsafe fn MFTUnregister(clsidmft: windows_core::GUID) -> windows_core::Result<()> {
    windows_targets::link!("mfplat.dll" "system" fn MFTUnregister(clsidmft : windows_core::GUID) -> windows_core::HRESULT);
    unsafe { MFTUnregister(core::mem::transmute(clsidmft)).ok() }
}
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn MFTUnregisterLocal<P0>(pclassfactory: P0) -> windows_core::Result<()>
where
    P0: windows_core::Param<super::super::System::Com::IClassFactory>,
{
    windows_targets::link!("mfplat.dll" "system" fn MFTUnregisterLocal(pclassfactory : * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe { MFTUnregisterLocal(pclassfactory.param().abi()).ok() }
}
#[inline]
pub unsafe fn MFTUnregisterLocalByCLSID(clsidmft: windows_core::GUID) -> windows_core::Result<()> {
    windows_targets::link!("mfplat.dll" "system" fn MFTUnregisterLocalByCLSID(clsidmft : windows_core::GUID) -> windows_core::HRESULT);
    unsafe { MFTUnregisterLocalByCLSID(core::mem::transmute(clsidmft)).ok() }
}
#[inline]
pub unsafe fn MFTranscodeGetAudioOutputAvailableTypes<P2>(guidsubtype: *const windows_core::GUID, dwmftflags: u32, pcodecconfig: P2) -> windows_core::Result<IMFCollection>
where
    P2: windows_core::Param<IMFAttributes>,
{
    windows_targets::link!("mf.dll" "system" fn MFTranscodeGetAudioOutputAvailableTypes(guidsubtype : *const windows_core::GUID, dwmftflags : u32, pcodecconfig : * mut core::ffi::c_void, ppavailabletypes : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFTranscodeGetAudioOutputAvailableTypes(guidsubtype, dwmftflags, pcodecconfig.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFUnlockDXGIDeviceManager() -> windows_core::Result<()> {
    windows_targets::link!("mfplat.dll" "system" fn MFUnlockDXGIDeviceManager() -> windows_core::HRESULT);
    unsafe { MFUnlockDXGIDeviceManager().ok() }
}
#[inline]
pub unsafe fn MFUnlockPlatform() -> windows_core::Result<()> {
    windows_targets::link!("mfplat.dll" "system" fn MFUnlockPlatform() -> windows_core::HRESULT);
    unsafe { MFUnlockPlatform().ok() }
}
#[inline]
pub unsafe fn MFUnlockWorkQueue(dwworkqueue: u32) -> windows_core::Result<()> {
    windows_targets::link!("mfplat.dll" "system" fn MFUnlockWorkQueue(dwworkqueue : u32) -> windows_core::HRESULT);
    unsafe { MFUnlockWorkQueue(dwworkqueue).ok() }
}
#[inline]
pub unsafe fn MFUnregisterPlatformFromMMCSS() -> windows_core::Result<()> {
    windows_targets::link!("mfplat.dll" "system" fn MFUnregisterPlatformFromMMCSS() -> windows_core::HRESULT);
    unsafe { MFUnregisterPlatformFromMMCSS().ok() }
}
#[inline]
pub unsafe fn MFUnwrapMediaType<P0>(pwrap: P0) -> windows_core::Result<IMFMediaType>
where
    P0: windows_core::Param<IMFMediaType>,
{
    windows_targets::link!("mfplat.dll" "system" fn MFUnwrapMediaType(pwrap : * mut core::ffi::c_void, pporig : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFUnwrapMediaType(pwrap.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFValidateMediaTypeSize(formattype: windows_core::GUID, pblock: Option<&[u8]>) -> windows_core::Result<()> {
    windows_targets::link!("mfplat.dll" "system" fn MFValidateMediaTypeSize(formattype : windows_core::GUID, pblock : *const u8, cbsize : u32) -> windows_core::HRESULT);
    unsafe { MFValidateMediaTypeSize(core::mem::transmute(formattype), core::mem::transmute(pblock.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), pblock.as_deref().map_or(0, |slice| slice.len().try_into().unwrap())).ok() }
}
#[inline]
pub unsafe fn MFWrapMediaType<P0>(porig: P0, majortype: *const windows_core::GUID, subtype: *const windows_core::GUID) -> windows_core::Result<IMFMediaType>
where
    P0: windows_core::Param<IMFMediaType>,
{
    windows_targets::link!("mfplat.dll" "system" fn MFWrapMediaType(porig : * mut core::ffi::c_void, majortype : *const windows_core::GUID, subtype : *const windows_core::GUID, ppwrap : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        MFWrapMediaType(porig.param().abi(), majortype, subtype, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn MFllMulDiv(a: i64, b: i64, c: i64, d: i64) -> i64 {
    windows_targets::link!("mfplat.dll" "system" fn MFllMulDiv(a : i64, b : i64, c : i64, d : i64) -> i64);
    unsafe { MFllMulDiv(a, b, c, d) }
}
#[inline]
pub unsafe fn OPMGetVideoOutputForTarget(padapterluid: *const super::super::Foundation::LUID, vidpntarget: u32, vos: OPM_VIDEO_OUTPUT_SEMANTICS) -> windows_core::Result<IOPMVideoOutput> {
    windows_targets::link!("dxva2.dll" "system" fn OPMGetVideoOutputForTarget(padapterluid : *const super::super::Foundation:: LUID, vidpntarget : u32, vos : OPM_VIDEO_OUTPUT_SEMANTICS, ppopmvideooutput : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        OPMGetVideoOutputForTarget(padapterluid, vidpntarget, vos, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[cfg(feature = "Win32_Graphics_Gdi")]
#[inline]
pub unsafe fn OPMGetVideoOutputsFromHMONITOR(hmonitor: super::super::Graphics::Gdi::HMONITOR, vos: OPM_VIDEO_OUTPUT_SEMANTICS, pulnumvideooutputs: *mut u32, pppopmvideooutputarray: *mut *mut Option<IOPMVideoOutput>) -> windows_core::Result<()> {
    windows_targets::link!("dxva2.dll" "system" fn OPMGetVideoOutputsFromHMONITOR(hmonitor : super::super::Graphics::Gdi:: HMONITOR, vos : OPM_VIDEO_OUTPUT_SEMANTICS, pulnumvideooutputs : *mut u32, pppopmvideooutputarray : *mut *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe { OPMGetVideoOutputsFromHMONITOR(hmonitor, vos, pulnumvideooutputs as _, pppopmvideooutputarray as _).ok() }
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
#[inline]
pub unsafe fn OPMGetVideoOutputsFromIDirect3DDevice9Object<P0>(pdirect3ddevice9: P0, vos: OPM_VIDEO_OUTPUT_SEMANTICS, pulnumvideooutputs: *mut u32, pppopmvideooutputarray: *mut *mut Option<IOPMVideoOutput>) -> windows_core::Result<()>
where
    P0: windows_core::Param<super::super::Graphics::Direct3D9::IDirect3DDevice9>,
{
    windows_targets::link!("dxva2.dll" "system" fn OPMGetVideoOutputsFromIDirect3DDevice9Object(pdirect3ddevice9 : * mut core::ffi::c_void, vos : OPM_VIDEO_OUTPUT_SEMANTICS, pulnumvideooutputs : *mut u32, pppopmvideooutputarray : *mut *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe { OPMGetVideoOutputsFromIDirect3DDevice9Object(pdirect3ddevice9.param().abi(), vos, pulnumvideooutputs as _, pppopmvideooutputarray as _).ok() }
}
#[inline]
pub unsafe fn OPMXboxEnableHDCP(hdcptype: OPM_HDCP_TYPE) -> windows_core::Result<()> {
    windows_targets::link!("opmxbox.dll" "system" fn OPMXboxEnableHDCP(hdcptype : OPM_HDCP_TYPE) -> windows_core::HRESULT);
    unsafe { OPMXboxEnableHDCP(hdcptype).ok() }
}
#[inline]
pub unsafe fn OPMXboxGetHDCPStatus(phdcpstatus: *mut OPM_HDCP_STATUS) -> windows_core::Result<()> {
    windows_targets::link!("opmxbox.dll" "system" fn OPMXboxGetHDCPStatus(phdcpstatus : *mut OPM_HDCP_STATUS) -> windows_core::HRESULT);
    unsafe { OPMXboxGetHDCPStatus(phdcpstatus as _).ok() }
}
#[inline]
pub unsafe fn OPMXboxGetHDCPStatusAndType(phdcpstatus: *mut OPM_HDCP_STATUS, phdcptype: *mut OPM_HDCP_TYPE) -> windows_core::Result<()> {
    windows_targets::link!("opmxbox.dll" "system" fn OPMXboxGetHDCPStatusAndType(phdcpstatus : *mut OPM_HDCP_STATUS, phdcptype : *mut OPM_HDCP_TYPE) -> windows_core::HRESULT);
    unsafe { OPMXboxGetHDCPStatusAndType(phdcpstatus as _, phdcptype as _).ok() }
}
pub const AACMFTEncoder: windows_core::GUID = windows_core::GUID::from_u128(0x93af0c51_2275_45d2_a35b_f2ba21caed00);
pub const ACCESSMODE_READ: FILE_ACCESSMODE = FILE_ACCESSMODE(1i32);
pub const ACCESSMODE_READWRITE: FILE_ACCESSMODE = FILE_ACCESSMODE(3i32);
pub const ACCESSMODE_WRITE: FILE_ACCESSMODE = FILE_ACCESSMODE(2i32);
pub const ACCESSMODE_WRITE_EXCLUSIVE: FILE_ACCESSMODE = FILE_ACCESSMODE(4i32);
pub const ADAPTIVE_ARRAY_AND_AEC: AEC_SYSTEM_MODE = AEC_SYSTEM_MODE(3i32);
pub const ADAPTIVE_ARRAY_ONLY: AEC_SYSTEM_MODE = AEC_SYSTEM_MODE(1i32);
pub const AEC_CAPTURE_STREAM: AEC_INPUT_STREAM = AEC_INPUT_STREAM(0i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct AEC_INPUT_STREAM(pub i32);
pub const AEC_MAX_SYSTEM_MODES: u32 = 6u32;
pub const AEC_REFERENCE_STREAM: AEC_INPUT_STREAM = AEC_INPUT_STREAM(1i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct AEC_SYSTEM_MODE(pub i32);
pub const AEC_VAD_DISABLED: AEC_VAD_MODE = AEC_VAD_MODE(0i32);
pub const AEC_VAD_FOR_AGC: AEC_VAD_MODE = AEC_VAD_MODE(2i32);
pub const AEC_VAD_FOR_SILENCE_SUPPRESSION: AEC_VAD_MODE = AEC_VAD_MODE(3i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct AEC_VAD_MODE(pub i32);
pub const AEC_VAD_NORMAL: AEC_VAD_MODE = AEC_VAD_MODE(1i32);
pub const ALawCodecWrapper: windows_core::GUID = windows_core::GUID::from_u128(0x36cb6e0c_78c1_42b2_9943_846262f31786);
pub const AMMPEG2_27MhzTimebase: MPEG2VIDEOINFO_FLAGS = MPEG2VIDEOINFO_FLAGS(256u32);
pub const AMMPEG2_DSS_UserData: MPEG2VIDEOINFO_FLAGS = MPEG2VIDEOINFO_FLAGS(64u32);
pub const AMMPEG2_DVB_UserData: MPEG2VIDEOINFO_FLAGS = MPEG2VIDEOINFO_FLAGS(128u32);
pub const AMMPEG2_DVDLine21Field1: MPEG2VIDEOINFO_FLAGS = MPEG2VIDEOINFO_FLAGS(2u32);
pub const AMMPEG2_DVDLine21Field2: MPEG2VIDEOINFO_FLAGS = MPEG2VIDEOINFO_FLAGS(4u32);
pub const AMMPEG2_DoPanScan: MPEG2VIDEOINFO_FLAGS = MPEG2VIDEOINFO_FLAGS(1u32);
pub const AMMPEG2_FilmCameraMode: MPEG2VIDEOINFO_FLAGS = MPEG2VIDEOINFO_FLAGS(16u32);
pub const AMMPEG2_LetterboxAnalogOut: MPEG2VIDEOINFO_FLAGS = MPEG2VIDEOINFO_FLAGS(32u32);
pub const AMMPEG2_SourceIsLetterboxed: MPEG2VIDEOINFO_FLAGS = MPEG2VIDEOINFO_FLAGS(8u32);
pub const AMMPEG2_WidescreenAnalogOut: MPEG2VIDEOINFO_FLAGS = MPEG2VIDEOINFO_FLAGS(512u32);
pub const AMPROPSETID_Pin: windows_core::GUID = windows_core::GUID::from_u128(0x9b00f101_1567_11d1_b3f1_00aa003761c5);
#[repr(C)]
#[derive(Clone, Debug, PartialEq)]
pub struct AM_MEDIA_TYPE {
    pub majortype: windows_core::GUID,
    pub subtype: windows_core::GUID,
    pub bFixedSizeSamples: super::super::Foundation::BOOL,
    pub bTemporalCompression: super::super::Foundation::BOOL,
    pub lSampleSize: u32,
    pub formattype: windows_core::GUID,
    pub pUnk: core::mem::ManuallyDrop<Option<windows_core::IUnknown>>,
    pub cbFormat: u32,
    pub pbFormat: *mut u8,
}
impl Default for AM_MEDIA_TYPE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const AM_MEDIA_TYPE_REPRESENTATION: windows_core::GUID = windows_core::GUID::from_u128(0xe2e42ad2_132c_491e_a268_3c7c2dca181f);
#[repr(C, packed(1))]
#[derive(Clone, Copy)]
pub struct ASF_FLAT_PICTURE {
    pub bPictureType: u8,
    pub dwDataLen: u32,
}
impl Default for ASF_FLAT_PICTURE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C, packed(1))]
#[derive(Clone, Copy)]
pub struct ASF_FLAT_SYNCHRONISED_LYRICS {
    pub bTimeStampFormat: u8,
    pub bContentType: u8,
    pub dwLyricsLen: u32,
}
impl Default for ASF_FLAT_SYNCHRONISED_LYRICS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct ASF_INDEX_DESCRIPTOR {
    pub Identifier: ASF_INDEX_IDENTIFIER,
    pub cPerEntryBytes: u16,
    pub szDescription: [u16; 32],
    pub dwInterval: u32,
}
impl Default for ASF_INDEX_DESCRIPTOR {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct ASF_INDEX_IDENTIFIER {
    pub guidIndexType: windows_core::GUID,
    pub wStreamNumber: u16,
}
impl Default for ASF_INDEX_IDENTIFIER {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct ASF_MUX_STATISTICS {
    pub cFramesWritten: u32,
    pub cFramesDropped: u32,
}
impl Default for ASF_MUX_STATISTICS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct ASF_SELECTION_STATUS(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct ASF_STATUSFLAGS(pub i32);
pub const ASF_STATUSFLAGS_INCOMPLETE: ASF_STATUSFLAGS = ASF_STATUSFLAGS(1i32);
pub const ASF_STATUSFLAGS_NONFATAL_ERROR: ASF_STATUSFLAGS = ASF_STATUSFLAGS(2i32);
pub const ASF_STATUS_ALLDATAUNITS: ASF_SELECTION_STATUS = ASF_SELECTION_STATUS(2i32);
pub const ASF_STATUS_CLEANPOINTSONLY: ASF_SELECTION_STATUS = ASF_SELECTION_STATUS(1i32);
pub const ASF_STATUS_NOTSELECTED: ASF_SELECTION_STATUS = ASF_SELECTION_STATUS(0i32);
pub const AVENC_H263V_LEVELCOUNT: u32 = 8u32;
pub const AVENC_H264V_LEVELCOUNT: u32 = 16u32;
pub const AVENC_H264V_MAX_MBBITS: u32 = 3200u32;
pub const AVEncAudioInputContent_Music: eAVEncAudioInputContent = eAVEncAudioInputContent(2i32);
pub const AVEncAudioInputContent_Unknown: eAVEncAudioInputContent = eAVEncAudioInputContent(0i32);
pub const AVEncAudioInputContent_Voice: eAVEncAudioInputContent = eAVEncAudioInputContent(1i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AecQualityMetrics_Struct {
    pub i64Timestamp: i64,
    pub ConvergenceFlag: u8,
    pub MicClippedFlag: u8,
    pub MicSilenceFlag: u8,
    pub PstvFeadbackFlag: u8,
    pub SpkClippedFlag: u8,
    pub SpkMuteFlag: u8,
    pub GlitchFlag: u8,
    pub DoubleTalkFlag: u8,
    pub uGlitchCount: u32,
    pub uMicClipCount: u32,
    pub fDuration: f32,
    pub fTSVariance: f32,
    pub fTSDriftRate: f32,
    pub fVoiceLevel: f32,
    pub fNoiseLevel: f32,
    pub fERLE: f32,
    pub fAvgERLE: f32,
    pub dwReserved: u32,
}
impl Default for AecQualityMetrics_Struct {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const CAC3DecMediaObject: windows_core::GUID = windows_core::GUID::from_u128(0x03d7c802_ecfa_47d9_b268_5fb3e310dee4);
pub const CAPTION_FORMAT_ATSC: windows_core::GUID = windows_core::GUID::from_u128(0x3ed9cb31_fd10_4ade_bccc_fb9105d2f3ef);
pub const CAPTION_FORMAT_DIRECTV: windows_core::GUID = windows_core::GUID::from_u128(0xe9ca1ce7_915e_47be_9bb9_bf1d8a13a5ec);
pub const CAPTION_FORMAT_DVB: windows_core::GUID = windows_core::GUID::from_u128(0x12230db4_ff2a_447e_bb88_6841c416d068);
pub const CAPTION_FORMAT_ECHOSTAR: windows_core::GUID = windows_core::GUID::from_u128(0xebb1a262_1158_4b99_ae80_92ac776952c4);
pub const CClusterDetectorDmo: windows_core::GUID = windows_core::GUID::from_u128(0x36e820c4_165a_4521_863c_619e1160d4d4);
pub const CColorControlDmo: windows_core::GUID = windows_core::GUID::from_u128(0x798059f0_89ca_4160_b325_aeb48efe4f9a);
pub const CColorConvertDMO: windows_core::GUID = windows_core::GUID::from_u128(0x98230571_0087_4204_b020_3282538e57d3);
pub const CColorLegalizerDmo: windows_core::GUID = windows_core::GUID::from_u128(0xfdfaa753_e48e_4e33_9c74_98a27fc6726a);
pub const CDTVAudDecoderDS: windows_core::GUID = windows_core::GUID::from_u128(0x8e269032_fe03_4753_9b17_18253c21722e);
pub const CDTVVidDecoderDS: windows_core::GUID = windows_core::GUID::from_u128(0x64777dc8_4e24_4beb_9d19_60a35be1daaf);
pub const CDVDecoderMediaObject: windows_core::GUID = windows_core::GUID::from_u128(0xe54709c5_1e17_4c8d_94e7_478940433584);
pub const CDVEncoderMediaObject: windows_core::GUID = windows_core::GUID::from_u128(0xc82ae729_c327_4cce_914d_8171fefebefb);
pub const CDeColorConvMediaObject: windows_core::GUID = windows_core::GUID::from_u128(0x49034c05_f43c_400f_84c1_90a683195a3a);
pub const CFrameInterpDMO: windows_core::GUID = windows_core::GUID::from_u128(0x0a7cfe1b_6ab5_4334_9ed8_3f97cb37daa1);
pub const CFrameRateConvertDmo: windows_core::GUID = windows_core::GUID::from_u128(0x01f36ce2_0907_4d8b_979d_f151be91c883);
pub const CInterlaceMediaObject: windows_core::GUID = windows_core::GUID::from_u128(0xb5a89c80_4901_407b_9abc_90d9a644bb46);
pub const CLSID_ACMWrapper: windows_core::GUID = windows_core::GUID::from_u128(0x6a08cf80_0e18_11cf_a24d_0020afd79767);
pub const CLSID_ATSCNetworkPropertyPage: windows_core::GUID = windows_core::GUID::from_u128(0xe3444d16_5ac4_4386_88df_13fd230e1dda);
pub const CLSID_ATSCNetworkProvider: windows_core::GUID = windows_core::GUID::from_u128(0x0dad2fdd_5fd7_11d3_8f50_00c04f7971e2);
pub const CLSID_AVICo: windows_core::GUID = windows_core::GUID::from_u128(0xd76e2820_1563_11cf_ac98_00aa004c0fa9);
pub const CLSID_AVIDec: windows_core::GUID = windows_core::GUID::from_u128(0xcf49d4e0_1115_11ce_b03a_0020af0ba770);
pub const CLSID_AVIDoc: windows_core::GUID = windows_core::GUID::from_u128(0xd3588ab0_0781_11ce_b03a_0020af0ba770);
pub const CLSID_AVIDraw: windows_core::GUID = windows_core::GUID::from_u128(0xa888df60_1e90_11cf_ac98_00aa004c0fa9);
pub const CLSID_AVIMIDIRender: windows_core::GUID = windows_core::GUID::from_u128(0x07b65360_c445_11ce_afde_00aa006c14f4);
pub const CLSID_ActiveMovieCategories: windows_core::GUID = windows_core::GUID::from_u128(0xda4e3da0_d07d_11d0_bd50_00a0c911ce86);
pub const CLSID_AllocPresenter: windows_core::GUID = windows_core::GUID::from_u128(0x99d54f63_1a69_41ae_aa4d_c976eb3f0713);
pub const CLSID_AllocPresenterDDXclMode: windows_core::GUID = windows_core::GUID::from_u128(0x4444ac9e_242e_471b_a3c7_45dcd46352bc);
pub const CLSID_AnalogVideoDecoderPropertyPage: windows_core::GUID = windows_core::GUID::from_u128(0x71f96466_78f3_11d0_a18c_00a0c9118956);
pub const CLSID_AsyncReader: windows_core::GUID = windows_core::GUID::from_u128(0xe436ebb5_524f_11ce_9f53_0020af0ba770);
pub const CLSID_AudioCompressorCategory: windows_core::GUID = windows_core::GUID::from_u128(0x33d9a761_90c8_11d0_bd43_00a0c911ce86);
pub const CLSID_AudioInputDeviceCategory: windows_core::GUID = windows_core::GUID::from_u128(0x33d9a762_90c8_11d0_bd43_00a0c911ce86);
pub const CLSID_AudioInputMixerProperties: windows_core::GUID = windows_core::GUID::from_u128(0x2ca8ca52_3c3f_11d2_b73d_00c04fb6bd3d);
pub const CLSID_AudioProperties: windows_core::GUID = windows_core::GUID::from_u128(0x05589faf_c356_11ce_bf01_00aa0055595a);
pub const CLSID_AudioRecord: windows_core::GUID = windows_core::GUID::from_u128(0xe30629d2_27e5_11ce_875d_00608cb78066);
pub const CLSID_AudioRender: windows_core::GUID = windows_core::GUID::from_u128(0xe30629d1_27e5_11ce_875d_00608cb78066);
pub const CLSID_AudioRendererAdvancedProperties: windows_core::GUID = windows_core::GUID::from_u128(0x37e92a92_d9aa_11d2_bf84_8ef2b1555aed);
pub const CLSID_AudioRendererCategory: windows_core::GUID = windows_core::GUID::from_u128(0xe0f158e1_cb04_11d0_bd4e_00a0c911ce86);
pub const CLSID_AudioResamplerMediaObject: windows_core::GUID = windows_core::GUID::from_u128(0xf447b69e_1884_4a7e_8055_346f74d6edb3);
pub const CLSID_AviDest: windows_core::GUID = windows_core::GUID::from_u128(0xe2510970_f137_11ce_8b67_00aa00a3f1a6);
pub const CLSID_AviMuxProptyPage: windows_core::GUID = windows_core::GUID::from_u128(0xc647b5c0_157c_11d0_bd23_00a0c911ce86);
pub const CLSID_AviMuxProptyPage1: windows_core::GUID = windows_core::GUID::from_u128(0x0a9ae910_85c0_11d0_bd42_00a0c911ce86);
pub const CLSID_AviReader: windows_core::GUID = windows_core::GUID::from_u128(0x1b544c21_fd0b_11ce_8c63_00aa0044b51e);
pub const CLSID_AviSplitter: windows_core::GUID = windows_core::GUID::from_u128(0x1b544c20_fd0b_11ce_8c63_00aa0044b51e);
pub const CLSID_CAcmCoClassManager: windows_core::GUID = windows_core::GUID::from_u128(0x33d9a761_90c8_11d0_bd43_00a0c911ce86);
pub const CLSID_CAsfTocParser: windows_core::GUID = windows_core::GUID::from_u128(0x9b77c0f2_8735_46c5_b90f_5f0b303ef6ab);
pub const CLSID_CAviTocParser: windows_core::GUID = windows_core::GUID::from_u128(0x3adce5cc_13c8_4573_b328_ed438eb694f9);
pub const CLSID_CCAFilter: windows_core::GUID = windows_core::GUID::from_u128(0x3d07a539_35ca_447c_9b05_8d85ce924f9e);
pub const CLSID_CClusterDetectorEx: windows_core::GUID = windows_core::GUID::from_u128(0x47354492_827e_4b8a_b318_c80eba1381f0);
pub const CLSID_CDeviceMoniker: windows_core::GUID = windows_core::GUID::from_u128(0x4315d437_5b8c_11d0_bd3b_00a0c911ce86);
pub const CLSID_CFileClient: windows_core::GUID = windows_core::GUID::from_u128(0xbfccd195_1244_4840_ab44_480975c4ffe4);
pub const CLSID_CFileIo: windows_core::GUID = windows_core::GUID::from_u128(0x11993195_1244_4840_ab44_480975c4ffe4);
pub const CLSID_CIcmCoClassManager: windows_core::GUID = windows_core::GUID::from_u128(0x33d9a760_90c8_11d0_bd43_00a0c911ce86);
pub const CLSID_CMidiOutClassManager: windows_core::GUID = windows_core::GUID::from_u128(0x4efe2452_168a_11d1_bc76_00c04fb9453b);
pub const CLSID_CMpegAudioCodec: windows_core::GUID = windows_core::GUID::from_u128(0x4a2286e0_7bef_11ce_9bd9_0000e202599c);
pub const CLSID_CMpegVideoCodec: windows_core::GUID = windows_core::GUID::from_u128(0xfeb50740_7bef_11ce_9bd9_0000e202599c);
pub const CLSID_CQzFilterClassManager: windows_core::GUID = windows_core::GUID::from_u128(0x083863f1_70de_11d0_bd40_00a0c911ce86);
pub const CLSID_CToc: windows_core::GUID = windows_core::GUID::from_u128(0x4fe24495_28ce_4920_a4c4_e556e1f0df2a);
pub const CLSID_CTocCollection: windows_core::GUID = windows_core::GUID::from_u128(0x5058292d_a244_4840_ab44_480975c4ffe4);
pub const CLSID_CTocEntry: windows_core::GUID = windows_core::GUID::from_u128(0xf22f5e05_585c_4def_8523_6555cfbc0cb3);
pub const CLSID_CTocEntryList: windows_core::GUID = windows_core::GUID::from_u128(0x3a8cccbc_0efd_43a3_b838_f38a552ba237);
pub const CLSID_CTocParser: windows_core::GUID = windows_core::GUID::from_u128(0x499eaeea_2737_4849_8bb6_47f107eaf358);
pub const CLSID_CVidCapClassManager: windows_core::GUID = windows_core::GUID::from_u128(0x860bb310_5d01_11d0_bd3b_00a0c911ce86);
pub const CLSID_CWaveOutClassManager: windows_core::GUID = windows_core::GUID::from_u128(0xe0f158e1_cb04_11d0_bd4e_00a0c911ce86);
pub const CLSID_CWaveinClassManager: windows_core::GUID = windows_core::GUID::from_u128(0x33d9a762_90c8_11d0_bd43_00a0c911ce86);
pub const CLSID_CameraConfigurationManager: windows_core::GUID = windows_core::GUID::from_u128(0x6c92b540_5854_4a17_92b6_ac89c96e9683);
pub const CLSID_CameraControlPropertyPage: windows_core::GUID = windows_core::GUID::from_u128(0x71f96465_78f3_11d0_a18c_00a0c9118956);
pub const CLSID_CaptionsFilter: windows_core::GUID = windows_core::GUID::from_u128(0x2f7ee4b6_6ff5_4eb4_b24a_2bfc41117171);
pub const CLSID_CaptureGraphBuilder: windows_core::GUID = windows_core::GUID::from_u128(0xbf87b6e0_8c27_11d0_b3f0_00aa003761c5);
pub const CLSID_CaptureGraphBuilder2: windows_core::GUID = windows_core::GUID::from_u128(0xbf87b6e1_8c27_11d0_b3f0_00aa003761c5);
pub const CLSID_CaptureProperties: windows_core::GUID = windows_core::GUID::from_u128(0x1b544c22_fd0b_11ce_8c63_00aa0044b51f);
pub const CLSID_Colour: windows_core::GUID = windows_core::GUID::from_u128(0x1643e180_90f5_11ce_97d5_00aa0055595a);
pub const CLSID_CreateMediaExtensionObject: windows_core::GUID = windows_core::GUID::from_u128(0xef65a54d_0788_45b8_8b14_bc0f6a6b5137);
pub const CLSID_CrossbarFilterPropertyPage: windows_core::GUID = windows_core::GUID::from_u128(0x71f96461_78f3_11d0_a18c_00a0c9118956);
pub const CLSID_DShowTVEFilter: windows_core::GUID = windows_core::GUID::from_u128(0x05500280_faa5_4df9_8246_bfc23ac5cea8);
pub const CLSID_DSoundRender: windows_core::GUID = windows_core::GUID::from_u128(0x79376820_07d0_11cf_a24d_0020afd79767);
pub const CLSID_DVBCNetworkProvider: windows_core::GUID = windows_core::GUID::from_u128(0xdc0c0fe7_0485_4266_b93f_68fbf80ed834);
pub const CLSID_DVBSNetworkProvider: windows_core::GUID = windows_core::GUID::from_u128(0xfa4b375a_45b4_4d45_8440_263957b11623);
pub const CLSID_DVBTNetworkProvider: windows_core::GUID = windows_core::GUID::from_u128(0x216c62df_6d7f_4e9a_8571_05f14edb766a);
pub const CLSID_DVDHWDecodersCategory: windows_core::GUID = windows_core::GUID::from_u128(0x2721ae20_7e70_11d0_a5d6_28db04c10000);
pub const CLSID_DVDNavigator: windows_core::GUID = windows_core::GUID::from_u128(0x9b8c4620_2c1a_11d0_8493_00a02438ad48);
pub const CLSID_DVDState: windows_core::GUID = windows_core::GUID::from_u128(0xf963c5cf_a659_4a93_9638_caf3cd277d13);
pub const CLSID_DVDecPropertiesPage: windows_core::GUID = windows_core::GUID::from_u128(0x101193c0_0bfe_11d0_af91_00aa00b67a42);
pub const CLSID_DVEncPropertiesPage: windows_core::GUID = windows_core::GUID::from_u128(0x4150f050_bb6f_11d0_afb9_00aa00b67a42);
pub const CLSID_DVMux: windows_core::GUID = windows_core::GUID::from_u128(0x129d7e40_c10d_11d0_afb9_00aa00b67a42);
pub const CLSID_DVMuxPropertyPage: windows_core::GUID = windows_core::GUID::from_u128(0x4db880e0_c10d_11d0_afb9_00aa00b67a42);
pub const CLSID_DVSplitter: windows_core::GUID = windows_core::GUID::from_u128(0x4eb31670_9fc6_11cf_af6e_00aa00b67a42);
pub const CLSID_DVVideoCodec: windows_core::GUID = windows_core::GUID::from_u128(0xb1b77c00_c3e4_11cf_af79_00aa00b67a42);
pub const CLSID_DVVideoEnc: windows_core::GUID = windows_core::GUID::from_u128(0x13aa3650_bb6f_11d0_afb9_00aa00b67a42);
pub const CLSID_DeviceControlCategory: windows_core::GUID = windows_core::GUID::from_u128(0xcc7bfb46_f175_11d1_a392_00e0291f3959);
pub const CLSID_DirectDrawProperties: windows_core::GUID = windows_core::GUID::from_u128(0x944d4c00_dd52_11ce_bf0e_00aa0055595a);
pub const CLSID_DirectShowPluginControl: windows_core::GUID = windows_core::GUID::from_u128(0x8670c736_f614_427b_8ada_bbadc587194b);
pub const CLSID_Dither: windows_core::GUID = windows_core::GUID::from_u128(0x1da08500_9edc_11cf_bc10_00aa00ac74f6);
pub const CLSID_DtvCcFilter: windows_core::GUID = windows_core::GUID::from_u128(0xfb056ba0_2502_45b9_8e86_2b40de84ad29);
pub const CLSID_DvdGraphBuilder: windows_core::GUID = windows_core::GUID::from_u128(0xfcc152b7_f372_11d0_8e00_00c04fd7c08b);
pub const CLSID_EVRPlaybackPipelineOptimizer: windows_core::GUID = windows_core::GUID::from_u128(0x62079164_233b_41f8_a80f_f01705f514a8);
pub const CLSID_EVRTearlessWindowPresenter9: windows_core::GUID = windows_core::GUID::from_u128(0xa0a7a57b_59b2_4919_a694_add0a526c373);
pub const CLSID_EnhancedVideoRenderer: windows_core::GUID = windows_core::GUID::from_u128(0xfa10746c_9b63_4b6c_bc49_fc300ea5f256);
pub const CLSID_FGControl: windows_core::GUID = windows_core::GUID::from_u128(0xe436ebb4_524f_11ce_9f53_0020af0ba770);
pub const CLSID_FileSource: windows_core::GUID = windows_core::GUID::from_u128(0x701722e0_8ae3_11ce_a85c_00aa002feab5);
pub const CLSID_FileWriter: windows_core::GUID = windows_core::GUID::from_u128(0x8596e5f0_0da5_11d0_bd21_00a0c911ce86);
pub const CLSID_FilterGraph: windows_core::GUID = windows_core::GUID::from_u128(0xe436ebb3_524f_11ce_9f53_0020af0ba770);
pub const CLSID_FilterGraphNoThread: windows_core::GUID = windows_core::GUID::from_u128(0xe436ebb8_524f_11ce_9f53_0020af0ba770);
pub const CLSID_FilterGraphPrivateThread: windows_core::GUID = windows_core::GUID::from_u128(0xa3ecbc41_581a_4476_b693_a63340462d8b);
pub const CLSID_FilterMapper: windows_core::GUID = windows_core::GUID::from_u128(0xe436ebb2_524f_11ce_9f53_0020af0ba770);
pub const CLSID_FilterMapper2: windows_core::GUID = windows_core::GUID::from_u128(0xcda42200_bd88_11d0_bd4e_00a0c911ce86);
pub const CLSID_FrameServerNetworkCameraSource: windows_core::GUID = windows_core::GUID::from_u128(0x7a213aa7_866f_414a_8c1a_275c7283a395);
pub const CLSID_HttpSchemePlugin: windows_core::GUID = windows_core::GUID::from_u128(0x44cb442b_9da9_49df_b3fd_023777b16e50);
pub const CLSID_ICodecAPIProxy: windows_core::GUID = windows_core::GUID::from_u128(0x7ff0997a_1999_4286_a73c_622b8814e7eb);
pub const CLSID_IVideoEncoderCodecAPIProxy: windows_core::GUID = windows_core::GUID::from_u128(0xb05dabd9_56e5_4fdc_afa4_8a47e91f1c9c);
pub const CLSID_IVideoEncoderProxy: windows_core::GUID = windows_core::GUID::from_u128(0xb43c4eec_8c32_4791_9102_508ada5ee8e7);
pub const CLSID_InfTee: windows_core::GUID = windows_core::GUID::from_u128(0xf8388a40_d5bb_11d0_be5a_0080c706568e);
pub const CLSID_LegacyAmFilterCategory: windows_core::GUID = windows_core::GUID::from_u128(0x083863f1_70de_11d0_bd40_00a0c911ce86);
pub const CLSID_Line21Decoder: windows_core::GUID = windows_core::GUID::from_u128(0x6e8d4a20_310c_11d0_b79a_00aa003767a7);
pub const CLSID_Line21Decoder2: windows_core::GUID = windows_core::GUID::from_u128(0xe4206432_01a1_4bee_b3e1_3702c8edc574);
pub const CLSID_MFByteStreamProxyClassFactory: windows_core::GUID = windows_core::GUID::from_u128(0x770e8e77_4916_441c_a9a7_b342d0eebc71);
pub const CLSID_MFCaptureEngine: windows_core::GUID = windows_core::GUID::from_u128(0xefce38d3_8914_4674_a7df_ae1b3d654b8a);
pub const CLSID_MFCaptureEngineClassFactory: windows_core::GUID = windows_core::GUID::from_u128(0xefce38d3_8914_4674_a7df_ae1b3d654b8a);
pub const CLSID_MFImageSharingEngineClassFactory: windows_core::GUID = windows_core::GUID::from_u128(0xb22c3339_87f3_4059_a0c5_037aa9707eaf);
pub const CLSID_MFMediaEngineClassFactory: windows_core::GUID = windows_core::GUID::from_u128(0xb44392da_499b_446b_a4cb_005fead0e6d5);
pub const CLSID_MFMediaSharingEngineClassFactory: windows_core::GUID = windows_core::GUID::from_u128(0xf8e307fb_6d45_4ad3_9993_66cd5a529659);
pub const CLSID_MFReadWriteClassFactory: windows_core::GUID = windows_core::GUID::from_u128(0x48e2ed0f_98c2_4a37_bed5_166312ddd83f);
pub const CLSID_MFSinkWriter: windows_core::GUID = windows_core::GUID::from_u128(0xa3bbfb17_8273_4e52_9e0e_9739dc887990);
pub const CLSID_MFSourceReader: windows_core::GUID = windows_core::GUID::from_u128(0x1777133c_0881_411b_a577_ad545f0714c4);
pub const CLSID_MFSourceResolver: windows_core::GUID = windows_core::GUID::from_u128(0x90eab60f_e43a_4188_bcc4_e47fdf04868c);
pub const CLSID_MFVideoMixer9: windows_core::GUID = windows_core::GUID::from_u128(0xe474e05a_ab65_4f6a_827c_218b1baaf31f);
pub const CLSID_MFVideoPresenter9: windows_core::GUID = windows_core::GUID::from_u128(0x98455561_5136_4d28_ab08_4cee40ea2781);
pub const CLSID_MJPGEnc: windows_core::GUID = windows_core::GUID::from_u128(0xb80ab0a0_7416_11d2_9eeb_006008039e37);
pub const CLSID_MMSPLITTER: windows_core::GUID = windows_core::GUID::from_u128(0x3ae86b20_7be8_11d1_abe6_00a0c905f375);
pub const CLSID_MOVReader: windows_core::GUID = windows_core::GUID::from_u128(0x44584800_f8ee_11ce_b2d4_00dd01101b85);
pub const CLSID_MP3DecMediaObject: windows_core::GUID = windows_core::GUID::from_u128(0xbbeea841_0a63_4f52_a7ab_a9b3a84ed38a);
pub const CLSID_MPEG1Doc: windows_core::GUID = windows_core::GUID::from_u128(0xe4bbd160_4269_11ce_838d_00aa0055595a);
pub const CLSID_MPEG1PacketPlayer: windows_core::GUID = windows_core::GUID::from_u128(0x26c25940_4ca9_11ce_a828_00aa002feab5);
pub const CLSID_MPEG1Splitter: windows_core::GUID = windows_core::GUID::from_u128(0x336475d0_942a_11ce_a870_00aa002feab5);
pub const CLSID_MPEG2ByteStreamPlugin: windows_core::GUID = windows_core::GUID::from_u128(0x40871c59_ab40_471f_8dc3_1f259d862479);
pub const CLSID_MPEG2DLNASink: windows_core::GUID = windows_core::GUID::from_u128(0xfa5fe7c5_6a1d_4b11_b41f_f959d6c76500);
pub const CLSID_MPEG2Demultiplexer: windows_core::GUID = windows_core::GUID::from_u128(0xafb6c280_2c41_11d3_8a60_0000f81e0e4a);
pub const CLSID_MPEG2Demultiplexer_NoClock: windows_core::GUID = windows_core::GUID::from_u128(0x687d3367_3644_467a_adfe_6cd7a85c4a2c);
pub const CLSID_MSAACDecMFT: windows_core::GUID = windows_core::GUID::from_u128(0x32d186a7_218f_4c75_8876_dd77273a8999);
pub const CLSID_MSDDPlusDecMFT: windows_core::GUID = windows_core::GUID::from_u128(0x177c0afe_900b_48d4_9e4c_57add250b3d4);
pub const CLSID_MSH264DecoderMFT: windows_core::GUID = windows_core::GUID::from_u128(0x62ce7e72_4c71_4d20_b15d_452831a87d9d);
pub const CLSID_MSH264EncoderMFT: windows_core::GUID = windows_core::GUID::from_u128(0x6ca50344_051a_4ded_9779_a43305165e35);
pub const CLSID_MSH265DecoderMFT: windows_core::GUID = windows_core::GUID::from_u128(0x420a51a3_d605_430c_b4fc_45274fa6c562);
pub const CLSID_MSMPEGAudDecMFT: windows_core::GUID = windows_core::GUID::from_u128(0x70707b39_b2ca_4015_abea_f8447d22d88b);
pub const CLSID_MSMPEGDecoderMFT: windows_core::GUID = windows_core::GUID::from_u128(0x2d709e52_123f_49b5_9cbc_9af5cde28fb9);
pub const CLSID_MSOpusDecoder: windows_core::GUID = windows_core::GUID::from_u128(0x63e17c10_2d43_4c42_8fe3_8d8b63e46a6a);
pub const CLSID_MSVPxDecoder: windows_core::GUID = windows_core::GUID::from_u128(0xe3aaf548_c9a4_4c6e_234d_5ada374b0000);
pub const CLSID_MediaEncoderCategory: windows_core::GUID = windows_core::GUID::from_u128(0x7d22e920_5ca9_4787_8c2b_a6779bd11781);
pub const CLSID_MediaMultiplexerCategory: windows_core::GUID = windows_core::GUID::from_u128(0x236c9559_adce_4736_bf72_bab34e392196);
pub const CLSID_MediaPropertyBag: windows_core::GUID = windows_core::GUID::from_u128(0xcdbd8d00_c193_11d0_bd4e_00a0c911ce86);
pub const CLSID_MemoryAllocator: windows_core::GUID = windows_core::GUID::from_u128(0x1e651cc0_b199_11d0_8212_00c04fc32c45);
pub const CLSID_MidiRendererCategory: windows_core::GUID = windows_core::GUID::from_u128(0x4efe2452_168a_11d1_bc76_00c04fb9453b);
pub const CLSID_MjpegDec: windows_core::GUID = windows_core::GUID::from_u128(0x301056d0_6dff_11d2_9eeb_006008039e37);
pub const CLSID_ModexRenderer: windows_core::GUID = windows_core::GUID::from_u128(0x07167665_5011_11cf_bf33_00aa0055595a);
pub const CLSID_Mpeg2VideoStreamAnalyzer: windows_core::GUID = windows_core::GUID::from_u128(0x6cfad761_735d_4aa5_8afc_af91a7d61eba);
pub const CLSID_NetSchemePlugin: windows_core::GUID = windows_core::GUID::from_u128(0xe9f4ebab_d97b_463e_a2b1_c54ee3f9414d);
pub const CLSID_NetworkProvider: windows_core::GUID = windows_core::GUID::from_u128(0xb2f3a67c_29da_4c78_8831_091ed509a475);
pub const CLSID_OverlayMixer: windows_core::GUID = windows_core::GUID::from_u128(0xcd8743a1_3736_11d0_9e69_00c04fd7c15b);
pub const CLSID_PerformanceProperties: windows_core::GUID = windows_core::GUID::from_u128(0x59ce6880_acf8_11cf_b56e_0080c7c4b68a);
pub const CLSID_PersistMonikerPID: windows_core::GUID = windows_core::GUID::from_u128(0xe436ebb7_524f_11ce_9f53_0020af0ba770);
pub const CLSID_PlayToSourceClassFactory: windows_core::GUID = windows_core::GUID::from_u128(0xda17539a_3dc3_42c1_a749_a183b51f085e);
pub const CLSID_ProtoFilterGraph: windows_core::GUID = windows_core::GUID::from_u128(0xe436ebb0_524f_11ce_9f53_0020af0ba770);
pub const CLSID_QTDec: windows_core::GUID = windows_core::GUID::from_u128(0xfdfe9681_74a3_11d0_afa7_00aa00b67a42);
pub const CLSID_QualityProperties: windows_core::GUID = windows_core::GUID::from_u128(0x418afb70_f8b8_11ce_aac6_0020af0b99a3);
pub const CLSID_QuickTimeParser: windows_core::GUID = windows_core::GUID::from_u128(0xd51bd5a0_7548_11cf_a520_0080c77ef58a);
pub const CLSID_SBE2File: windows_core::GUID = windows_core::GUID::from_u128(0x93a094d7_51e8_485b_904a_8d6b97dc6b39);
pub const CLSID_SBE2FileScan: windows_core::GUID = windows_core::GUID::from_u128(0x3e458037_0ca6_41aa_a594_2aa6c02d709b);
pub const CLSID_SBE2MediaTypeProfile: windows_core::GUID = windows_core::GUID::from_u128(0x1f26a602_2b5c_4b63_b8e8_9ea5c1a7dc2e);
pub const CLSID_SBE2Sink: windows_core::GUID = windows_core::GUID::from_u128(0xe2448508_95da_4205_9a27_7ec81e723b1a);
pub const CLSID_SeekingPassThru: windows_core::GUID = windows_core::GUID::from_u128(0x060af76c_68dd_11d0_8fc1_00c04fd9189d);
pub const CLSID_SmartTee: windows_core::GUID = windows_core::GUID::from_u128(0xcc58e280_8aa1_11d1_b3f1_00aa003761c5);
pub const CLSID_StreamBufferComposeRecording: windows_core::GUID = windows_core::GUID::from_u128(0xd682c4ba_a90a_42fe_b9e1_03109849c423);
pub const CLSID_StreamBufferConfig: windows_core::GUID = windows_core::GUID::from_u128(0xfa8a68b2_c864_4ba2_ad53_d3876a87494b);
pub const CLSID_StreamBufferPropertyHandler: windows_core::GUID = windows_core::GUID::from_u128(0xe37a73f8_fb01_43dc_914e_aaee76095ab9);
pub const CLSID_StreamBufferRecordingAttributes: windows_core::GUID = windows_core::GUID::from_u128(0xccaa63ac_1057_4778_ae92_1206ab9acee6);
pub const CLSID_StreamBufferSink: windows_core::GUID = windows_core::GUID::from_u128(0x2db47ae5_cf39_43c2_b4d6_0cd8d90946f4);
pub const CLSID_StreamBufferSource: windows_core::GUID = windows_core::GUID::from_u128(0xc9f5fe02_f851_4eb5_99ee_ad602af1e619);
pub const CLSID_StreamBufferThumbnailHandler: windows_core::GUID = windows_core::GUID::from_u128(0x713790ee_5ee1_45ba_8070_a1337d2762fa);
pub const CLSID_SubtitlesFilter: windows_core::GUID = windows_core::GUID::from_u128(0x9f22cfea_ce07_41ab_8ba0_c7364af90af9);
pub const CLSID_SystemClock: windows_core::GUID = windows_core::GUID::from_u128(0xe436ebb1_524f_11ce_9f53_0020af0ba770);
pub const CLSID_SystemDeviceEnum: windows_core::GUID = windows_core::GUID::from_u128(0x62be5d10_60eb_11d0_bd3b_00a0c911ce86);
pub const CLSID_TVAudioFilterPropertyPage: windows_core::GUID = windows_core::GUID::from_u128(0x71f96463_78f3_11d0_a18c_00a0c9118956);
pub const CLSID_TVEFilterCCProperties: windows_core::GUID = windows_core::GUID::from_u128(0x05500282_faa5_4df9_8246_bfc23ac5cea8);
pub const CLSID_TVEFilterStatsProperties: windows_core::GUID = windows_core::GUID::from_u128(0x05500283_faa5_4df9_8246_bfc23ac5cea8);
pub const CLSID_TVEFilterTuneProperties: windows_core::GUID = windows_core::GUID::from_u128(0x05500281_faa5_4df9_8246_bfc23ac5cea8);
pub const CLSID_TVTunerFilterPropertyPage: windows_core::GUID = windows_core::GUID::from_u128(0x266eee41_6c63_11cf_8a03_00aa006ecb65);
pub const CLSID_TextRender: windows_core::GUID = windows_core::GUID::from_u128(0xe30629d3_27e5_11ce_875d_00608cb78066);
pub const CLSID_TransmitCategory: windows_core::GUID = windows_core::GUID::from_u128(0xcc7bfb41_f175_11d1_a392_00e0291f3959);
pub const CLSID_URLReader: windows_core::GUID = windows_core::GUID::from_u128(0xe436ebb6_524f_11ce_9f53_0020af0ba770);
pub const CLSID_UrlmonSchemePlugin: windows_core::GUID = windows_core::GUID::from_u128(0x9ec4b4f9_3029_45ad_947b_344de2a249e2);
pub const CLSID_VBISurfaces: windows_core::GUID = windows_core::GUID::from_u128(0x814b9800_1c88_11d1_bad9_00609744111a);
pub const CLSID_VPObject: windows_core::GUID = windows_core::GUID::from_u128(0xce292861_fc88_11d0_9e69_00c04fd7c15b);
pub const CLSID_VPVBIObject: windows_core::GUID = windows_core::GUID::from_u128(0x814b9801_1c88_11d1_bad9_00609744111a);
pub const CLSID_VfwCapture: windows_core::GUID = windows_core::GUID::from_u128(0x1b544c22_fd0b_11ce_8c63_00aa0044b51e);
pub const CLSID_VideoCompressorCategory: windows_core::GUID = windows_core::GUID::from_u128(0x33d9a760_90c8_11d0_bd43_00a0c911ce86);
pub const CLSID_VideoInputDeviceCategory: windows_core::GUID = windows_core::GUID::from_u128(0x860bb310_5d01_11d0_bd3b_00a0c911ce86);
pub const CLSID_VideoMixingRenderer: windows_core::GUID = windows_core::GUID::from_u128(0xb87beb7b_8d29_423f_ae4d_6582c10175ac);
pub const CLSID_VideoMixingRenderer9: windows_core::GUID = windows_core::GUID::from_u128(0x51b4abf3_748f_4e3b_a276_c828330e926a);
pub const CLSID_VideoPortManager: windows_core::GUID = windows_core::GUID::from_u128(0x6f26a6cd_967b_47fd_874a_7aed2c9d25a2);
pub const CLSID_VideoProcAmpPropertyPage: windows_core::GUID = windows_core::GUID::from_u128(0x71f96464_78f3_11d0_a18c_00a0c9118956);
pub const CLSID_VideoProcessorMFT: windows_core::GUID = windows_core::GUID::from_u128(0x88753b26_5b24_49bd_b2e7_0c445c78c982);
pub const CLSID_VideoRenderer: windows_core::GUID = windows_core::GUID::from_u128(0x70e102b0_5556_11ce_97c0_00aa0055595a);
pub const CLSID_VideoRendererDefault: windows_core::GUID = windows_core::GUID::from_u128(0x6bc1cffa_8fc1_4261_ac22_cfb4cc38db50);
pub const CLSID_VideoStreamConfigPropertyPage: windows_core::GUID = windows_core::GUID::from_u128(0x71f96467_78f3_11d0_a18c_00a0c9118956);
pub const CLSID_WMADecMediaObject: windows_core::GUID = windows_core::GUID::from_u128(0x2eeb4adf_4578_4d10_bca7_bb955f56320a);
pub const CLSID_WMAsfReader: windows_core::GUID = windows_core::GUID::from_u128(0x187463a0_5bb7_11d3_acbe_0080c75e246e);
pub const CLSID_WMAsfWriter: windows_core::GUID = windows_core::GUID::from_u128(0x7c23220e_55bb_11d3_8b16_00c04fb6bd3d);
pub const CLSID_WMDRMSystemID: windows_core::GUID = windows_core::GUID::from_u128(0x8948bb22_11bd_4796_93e3_974d1b575678);
pub const CLSID_WMVDecoderMFT: windows_core::GUID = windows_core::GUID::from_u128(0x82d353df_90bd_4382_8bc2_3f6192b76e34);
pub const CLSID_WSTDecoder: windows_core::GUID = windows_core::GUID::from_u128(0x70bc06e0_5666_11d3_a184_00105aef9f33);
pub const CLSID_WstDecoderPropertyPage: windows_core::GUID = windows_core::GUID::from_u128(0x04e27f80_91e4_11d3_a184_00105aef9f33);
pub const CMP3DecMediaObject: windows_core::GUID = windows_core::GUID::from_u128(0xbbeea841_0a63_4f52_a7ab_a9b3a84ed38a);
pub const CMPEG2AudDecoderDS: windows_core::GUID = windows_core::GUID::from_u128(0xe1f1a0b8_beee_490d_ba7c_066c40b5e2b9);
pub const CMPEG2AudioEncoderMFT: windows_core::GUID = windows_core::GUID::from_u128(0x46a4dd5c_73f8_4304_94df_308f760974f4);
pub const CMPEG2EncoderAudioDS: windows_core::GUID = windows_core::GUID::from_u128(0xacd453bc_c58a_44d1_bbf5_bfb325be2d78);
pub const CMPEG2EncoderDS: windows_core::GUID = windows_core::GUID::from_u128(0x5f5aff4a_2f7f_4279_88c2_cd88eb39d144);
pub const CMPEG2EncoderVideoDS: windows_core::GUID = windows_core::GUID::from_u128(0x42150cd9_ca9a_4ea5_9939_30ee037f6e74);
pub const CMPEG2VidDecoderDS: windows_core::GUID = windows_core::GUID::from_u128(0x212690fb_83e5_4526_8fd7_74478b7939cd);
pub const CMPEG2VideoEncoderMFT: windows_core::GUID = windows_core::GUID::from_u128(0xe6335f02_80b7_4dc4_adfa_dfe7210d20d5);
pub const CMPEGAACDecMediaObject: windows_core::GUID = windows_core::GUID::from_u128(0x8dde1772_edad_41c3_b4be_1f30fb4ee0d6);
pub const CMSAACDecMFT: windows_core::GUID = windows_core::GUID::from_u128(0x32d186a7_218f_4c75_8876_dd77273a8999);
pub const CMSAC3Enc: windows_core::GUID = windows_core::GUID::from_u128(0xc6b400e2_20a7_4e58_a2fe_24619682ce6c);
pub const CMSALACDecMFT: windows_core::GUID = windows_core::GUID::from_u128(0xc0cd7d12_31fc_4bbc_b363_7322ee3e1879);
pub const CMSALACEncMFT: windows_core::GUID = windows_core::GUID::from_u128(0x9ab6a28c_748e_4b6a_bfff_cc443b8e8fb4);
pub const CMSDDPlusDecMFT: windows_core::GUID = windows_core::GUID::from_u128(0x177c0afe_900b_48d4_9e4c_57add250b3d4);
pub const CMSDolbyDigitalEncMFT: windows_core::GUID = windows_core::GUID::from_u128(0xac3315c9_f481_45d7_826c_0b406c1f64b8);
pub const CMSFLACDecMFT: windows_core::GUID = windows_core::GUID::from_u128(0x6b0b3e6b_a2c5_4514_8055_afe8a95242d9);
pub const CMSFLACEncMFT: windows_core::GUID = windows_core::GUID::from_u128(0x128509e9_c44e_45dc_95e9_c255b8f466a6);
pub const CMSH263EncoderMFT: windows_core::GUID = windows_core::GUID::from_u128(0xbc47fcfe_98a0_4f27_bb07_698af24f2b38);
pub const CMSH264DecoderMFT: windows_core::GUID = windows_core::GUID::from_u128(0x62ce7e72_4c71_4d20_b15d_452831a87d9d);
pub const CMSH264EncoderMFT: windows_core::GUID = windows_core::GUID::from_u128(0x6ca50344_051a_4ded_9779_a43305165e35);
pub const CMSH264RemuxMFT: windows_core::GUID = windows_core::GUID::from_u128(0x05a47ebb_8bf0_4cbf_ad2f_3b71d75866f5);
pub const CMSH265EncoderMFT: windows_core::GUID = windows_core::GUID::from_u128(0xf2f84074_8bca_40bd_9159_e880f673dd3b);
pub const CMSMPEGAudDecMFT: windows_core::GUID = windows_core::GUID::from_u128(0x70707b39_b2ca_4015_abea_f8447d22d88b);
pub const CMSMPEGDecoderMFT: windows_core::GUID = windows_core::GUID::from_u128(0x2d709e52_123f_49b5_9cbc_9af5cde28fb9);
pub const CMSOpusDecMFT: windows_core::GUID = windows_core::GUID::from_u128(0x63e17c10_2d43_4c42_8fe3_8d8b63e46a6a);
pub const CMSSCDecMediaObject: windows_core::GUID = windows_core::GUID::from_u128(0x7bafb3b1_d8f4_4279_9253_27da423108de);
pub const CMSSCEncMediaObject: windows_core::GUID = windows_core::GUID::from_u128(0x8cb9cc06_d139_4ae6_8bb4_41e612e141d5);
pub const CMSSCEncMediaObject2: windows_core::GUID = windows_core::GUID::from_u128(0xf7ffe0a0_a4f5_44b5_949e_15ed2bc66f9d);
pub const CMSVPXEncoderMFT: windows_core::GUID = windows_core::GUID::from_u128(0xaeb6c755_2546_4881_82cc_e15ae5ebff3d);
pub const CMSVideoDSPMFT: windows_core::GUID = windows_core::GUID::from_u128(0x51571744_7fe4_4ff2_a498_2dc34ff74f1b);
pub const CMpeg2DecMediaObject: windows_core::GUID = windows_core::GUID::from_u128(0x863d66cd_cdce_4617_b47f_c8929cfc28a6);
pub const CMpeg43DecMediaObject: windows_core::GUID = windows_core::GUID::from_u128(0xcba9e78b_49a3_49ea_93d4_6bcba8c4de07);
pub const CMpeg4DecMediaObject: windows_core::GUID = windows_core::GUID::from_u128(0xf371728a_6052_4d47_827c_d039335dfe0a);
pub const CMpeg4EncMediaObject: windows_core::GUID = windows_core::GUID::from_u128(0x24f258d8_c651_4042_93e4_ca654abb682c);
pub const CMpeg4sDecMFT: windows_core::GUID = windows_core::GUID::from_u128(0x5686a0d9_fe39_409f_9dff_3fdbc849f9f5);
pub const CMpeg4sDecMediaObject: windows_core::GUID = windows_core::GUID::from_u128(0x2a11bae2_fe6e_4249_864b_9e9ed6e8dbc2);
pub const CMpeg4sEncMediaObject: windows_core::GUID = windows_core::GUID::from_u128(0x6ec5a7be_d81e_4f9e_ada3_cd1bf262b6d8);
pub const CNokiaAACCCDecMediaObject: windows_core::GUID = windows_core::GUID::from_u128(0xeabf7a6f_ccba_4d60_8620_b152cc977263);
pub const CNokiaAACDecMediaObject: windows_core::GUID = windows_core::GUID::from_u128(0x3cb2bde4_4e29_4c44_a73e_2d7c2c46d6ec);
pub const CODECAPI_ALLSETTINGS: windows_core::GUID = windows_core::GUID::from_u128(0x6a577e92_83e1_4113_adc2_4fcec32f83a1);
pub const CODECAPI_AUDIO_ENCODER: windows_core::GUID = windows_core::GUID::from_u128(0xb9d19a3e_f897_429c_bc46_8138b7272b2d);
pub const CODECAPI_AVAudioChannelConfig: windows_core::GUID = windows_core::GUID::from_u128(0x17f89cb3_c38d_4368_9ede_63b94d177f9f);
pub const CODECAPI_AVAudioChannelCount: windows_core::GUID = windows_core::GUID::from_u128(0x1d3583c4_1583_474e_b71a_5ee463c198e4);
pub const CODECAPI_AVAudioSampleRate: windows_core::GUID = windows_core::GUID::from_u128(0x971d2723_1acb_42e7_855c_520a4b70a5f2);
pub const CODECAPI_AVDDSurroundMode: windows_core::GUID = windows_core::GUID::from_u128(0x99f2f386_98d1_4452_a163_abc78a6eb770);
pub const CODECAPI_AVDSPLoudnessEqualization: windows_core::GUID = windows_core::GUID::from_u128(0x8afd1a15_1812_4cbf_9319_433a5b2a3b27);
pub const CODECAPI_AVDSPSpeakerFill: windows_core::GUID = windows_core::GUID::from_u128(0x5612bca1_56da_4582_8da1_ca8090f92768);
pub const CODECAPI_AVDecAACDownmixMode: windows_core::GUID = windows_core::GUID::from_u128(0x01274475_f6bb_4017_b084_81a763c942d4);
pub const CODECAPI_AVDecAudioDualMono: windows_core::GUID = windows_core::GUID::from_u128(0x4a52cda8_30f8_4216_be0f_ba0b2025921d);
pub const CODECAPI_AVDecAudioDualMonoReproMode: windows_core::GUID = windows_core::GUID::from_u128(0xa5106186_cc94_4bc9_8cd9_aa2f61f6807e);
pub const CODECAPI_AVDecCommonInputFormat: windows_core::GUID = windows_core::GUID::from_u128(0xe5005239_bd89_4be3_9c0f_5dde317988cc);
pub const CODECAPI_AVDecCommonMeanBitRate: windows_core::GUID = windows_core::GUID::from_u128(0x59488217_007a_4f7a_8e41_5c48b1eac5c6);
pub const CODECAPI_AVDecCommonMeanBitRateInterval: windows_core::GUID = windows_core::GUID::from_u128(0x0ee437c6_38a7_4c5c_944c_68ab42116b85);
pub const CODECAPI_AVDecCommonOutputFormat: windows_core::GUID = windows_core::GUID::from_u128(0x3c790028_c0ce_4256_b1a2_1b0fc8b1dcdc);
pub const CODECAPI_AVDecDDDynamicRangeScaleHigh: windows_core::GUID = windows_core::GUID::from_u128(0x50196c21_1f33_4af5_b296_11426d6c8789);
pub const CODECAPI_AVDecDDDynamicRangeScaleLow: windows_core::GUID = windows_core::GUID::from_u128(0x044e62e4_11a5_42d5_a3b2_3bb2c7c2d7cf);
pub const CODECAPI_AVDecDDMatrixDecodingMode: windows_core::GUID = windows_core::GUID::from_u128(0xddc811a5_04ed_4bf3_a0ca_d00449f9355f);
pub const CODECAPI_AVDecDDOperationalMode: windows_core::GUID = windows_core::GUID::from_u128(0xd6d6c6d1_064e_4fdd_a40e_3ecbfcb7ebd0);
pub const CODECAPI_AVDecDDStereoDownMixMode: windows_core::GUID = windows_core::GUID::from_u128(0x6ce4122c_3ee9_4182_b4ae_c10fc088649d);
pub const CODECAPI_AVDecDisableVideoPostProcessing: windows_core::GUID = windows_core::GUID::from_u128(0xf8749193_667a_4f2c_a9e8_5d4af924f08f);
pub const CODECAPI_AVDecHEAACDynamicRangeControl: windows_core::GUID = windows_core::GUID::from_u128(0x287c8abe_69a4_4d39_8080_d3d9712178a0);
pub const CODECAPI_AVDecMmcssClass: windows_core::GUID = windows_core::GUID::from_u128(0xe0ad4828_df66_4893_9f33_788aa4ec4082);
pub const CODECAPI_AVDecNumWorkerThreads: windows_core::GUID = windows_core::GUID::from_u128(0x9561c3e8_ea9e_4435_9b1e_a93e691894d8);
pub const CODECAPI_AVDecSoftwareDynamicFormatChange: windows_core::GUID = windows_core::GUID::from_u128(0x862e2f0a_507b_47ff_af47_01e2624298b7);
pub const CODECAPI_AVDecVideoAcceleration_H264: windows_core::GUID = windows_core::GUID::from_u128(0xf7db8a2f_4f48_4ee8_ae31_8b6ebe558ae2);
pub const CODECAPI_AVDecVideoAcceleration_MPEG2: windows_core::GUID = windows_core::GUID::from_u128(0xf7db8a2e_4f48_4ee8_ae31_8b6ebe558ae2);
pub const CODECAPI_AVDecVideoAcceleration_VC1: windows_core::GUID = windows_core::GUID::from_u128(0xf7db8a30_4f48_4ee8_ae31_8b6ebe558ae2);
pub const CODECAPI_AVDecVideoCodecType: windows_core::GUID = windows_core::GUID::from_u128(0x434528e5_21f0_46b6_b62c_9b1b6b658cd1);
pub const CODECAPI_AVDecVideoDXVABusEncryption: windows_core::GUID = windows_core::GUID::from_u128(0x42153c8b_fd0b_4765_a462_ddd9e8bcc388);
pub const CODECAPI_AVDecVideoDXVAMode: windows_core::GUID = windows_core::GUID::from_u128(0xf758f09e_7337_4ae7_8387_73dc2d54e67d);
pub const CODECAPI_AVDecVideoDropPicWithMissingRef: windows_core::GUID = windows_core::GUID::from_u128(0xf8226383_14c2_4567_9734_5004e96ff887);
pub const CODECAPI_AVDecVideoFastDecodeMode: windows_core::GUID = windows_core::GUID::from_u128(0x6b529f7d_d3b1_49c6_a999_9ec6911bedbf);
pub const CODECAPI_AVDecVideoH264ErrorConcealment: windows_core::GUID = windows_core::GUID::from_u128(0xececace8_3436_462c_9294_cd7bacd758a9);
pub const CODECAPI_AVDecVideoImageSize: windows_core::GUID = windows_core::GUID::from_u128(0x5ee5747c_6801_4cab_aaf1_6248fa841ba4);
pub const CODECAPI_AVDecVideoInputScanType: windows_core::GUID = windows_core::GUID::from_u128(0x38477e1f_0ea7_42cd_8cd1_130ced57c580);
pub const CODECAPI_AVDecVideoMPEG2ErrorConcealment: windows_core::GUID = windows_core::GUID::from_u128(0x9d2bfe18_728d_48d2_b358_bc7e436c6674);
pub const CODECAPI_AVDecVideoMaxCodedHeight: windows_core::GUID = windows_core::GUID::from_u128(0x7262a16a_d2dc_4e75_9ba8_65c0c6d32b13);
pub const CODECAPI_AVDecVideoMaxCodedWidth: windows_core::GUID = windows_core::GUID::from_u128(0x5ae557b8_77af_41f5_9fa6_4db2fe1d4bca);
pub const CODECAPI_AVDecVideoPixelAspectRatio: windows_core::GUID = windows_core::GUID::from_u128(0xb0cf8245_f32d_41df_b02c_87bd304d12ab);
pub const CODECAPI_AVDecVideoProcDeinterlaceCSC: windows_core::GUID = windows_core::GUID::from_u128(0xf7db8a31_4f48_4ee8_ae31_8b6ebe558ae2);
pub const CODECAPI_AVDecVideoSWPowerLevel: windows_core::GUID = windows_core::GUID::from_u128(0xfb5d2347_4dd8_4509_aed0_db5fa9aa93f4);
pub const CODECAPI_AVDecVideoSoftwareDeinterlaceMode: windows_core::GUID = windows_core::GUID::from_u128(0x0c08d1ce_9ced_4540_bae3_ceb380141109);
pub const CODECAPI_AVDecVideoThumbnailGenerationMode: windows_core::GUID = windows_core::GUID::from_u128(0x2efd8eee_1150_4328_9cf5_66dce933fcf4);
pub const CODECAPI_AVEnableInLoopDeblockFilter: windows_core::GUID = windows_core::GUID::from_u128(0xd2e8e399_0623_4bf3_92a8_4d1818529ded);
pub const CODECAPI_AVEncAACEnableVBR: windows_core::GUID = windows_core::GUID::from_u128(0xe836bb98_fca3_44b6_9a39_24786be41be1);
pub const CODECAPI_AVEncAdaptiveMode: windows_core::GUID = windows_core::GUID::from_u128(0x4419b185_da1f_4f53_bc76_097d0c1efb1e);
pub const CODECAPI_AVEncAudioDualMono: windows_core::GUID = windows_core::GUID::from_u128(0x3648126b_a3e8_4329_9b3a_5ce566a43bd3);
pub const CODECAPI_AVEncAudioInputContent: windows_core::GUID = windows_core::GUID::from_u128(0x3e226c2b_60b9_4a39_b00b_a7b40f70d566);
pub const CODECAPI_AVEncAudioIntervalToEncode: windows_core::GUID = windows_core::GUID::from_u128(0x866e4b4d_725a_467c_bb01_b496b23b25f9);
pub const CODECAPI_AVEncAudioIntervalToSkip: windows_core::GUID = windows_core::GUID::from_u128(0x88c15f94_c38c_4796_a9e8_96e967983f26);
pub const CODECAPI_AVEncAudioMapDestChannel0: windows_core::GUID = windows_core::GUID::from_u128(0xbc5d0b60_df6a_4e16_9803_b82007a30c8d);
pub const CODECAPI_AVEncAudioMapDestChannel1: windows_core::GUID = windows_core::GUID::from_u128(0xbc5d0b61_df6a_4e16_9803_b82007a30c8d);
pub const CODECAPI_AVEncAudioMapDestChannel10: windows_core::GUID = windows_core::GUID::from_u128(0xbc5d0b6a_df6a_4e16_9803_b82007a30c8d);
pub const CODECAPI_AVEncAudioMapDestChannel11: windows_core::GUID = windows_core::GUID::from_u128(0xbc5d0b6b_df6a_4e16_9803_b82007a30c8d);
pub const CODECAPI_AVEncAudioMapDestChannel12: windows_core::GUID = windows_core::GUID::from_u128(0xbc5d0b6c_df6a_4e16_9803_b82007a30c8d);
pub const CODECAPI_AVEncAudioMapDestChannel13: windows_core::GUID = windows_core::GUID::from_u128(0xbc5d0b6d_df6a_4e16_9803_b82007a30c8d);
pub const CODECAPI_AVEncAudioMapDestChannel14: windows_core::GUID = windows_core::GUID::from_u128(0xbc5d0b6e_df6a_4e16_9803_b82007a30c8d);
pub const CODECAPI_AVEncAudioMapDestChannel15: windows_core::GUID = windows_core::GUID::from_u128(0xbc5d0b6f_df6a_4e16_9803_b82007a30c8d);
pub const CODECAPI_AVEncAudioMapDestChannel2: windows_core::GUID = windows_core::GUID::from_u128(0xbc5d0b62_df6a_4e16_9803_b82007a30c8d);
pub const CODECAPI_AVEncAudioMapDestChannel3: windows_core::GUID = windows_core::GUID::from_u128(0xbc5d0b63_df6a_4e16_9803_b82007a30c8d);
pub const CODECAPI_AVEncAudioMapDestChannel4: windows_core::GUID = windows_core::GUID::from_u128(0xbc5d0b64_df6a_4e16_9803_b82007a30c8d);
pub const CODECAPI_AVEncAudioMapDestChannel5: windows_core::GUID = windows_core::GUID::from_u128(0xbc5d0b65_df6a_4e16_9803_b82007a30c8d);
pub const CODECAPI_AVEncAudioMapDestChannel6: windows_core::GUID = windows_core::GUID::from_u128(0xbc5d0b66_df6a_4e16_9803_b82007a30c8d);
pub const CODECAPI_AVEncAudioMapDestChannel7: windows_core::GUID = windows_core::GUID::from_u128(0xbc5d0b67_df6a_4e16_9803_b82007a30c8d);
pub const CODECAPI_AVEncAudioMapDestChannel8: windows_core::GUID = windows_core::GUID::from_u128(0xbc5d0b68_df6a_4e16_9803_b82007a30c8d);
pub const CODECAPI_AVEncAudioMapDestChannel9: windows_core::GUID = windows_core::GUID::from_u128(0xbc5d0b69_df6a_4e16_9803_b82007a30c8d);
pub const CODECAPI_AVEncAudioMeanBitRate: windows_core::GUID = windows_core::GUID::from_u128(0x921295bb_4fca_4679_aab8_9e2a1d753384);
pub const CODECAPI_AVEncChromaEncodeMode: windows_core::GUID = windows_core::GUID::from_u128(0x8a47ab5a_4798_4c93_b5a5_554f9a3b9f50);
pub const CODECAPI_AVEncChromaUpdateTime: windows_core::GUID = windows_core::GUID::from_u128(0x4b4fd998_4274_40bb_8ee4_07553e7e2d3a);
pub const CODECAPI_AVEncCodecType: windows_core::GUID = windows_core::GUID::from_u128(0x08af4ac1_f3f2_4c74_9dcf_37f2ec79f826);
pub const CODECAPI_AVEncCommonAllowFrameDrops: windows_core::GUID = windows_core::GUID::from_u128(0xd8477dcb_9598_48e3_8d0c_752bf206093e);
pub const CODECAPI_AVEncCommonBufferInLevel: windows_core::GUID = windows_core::GUID::from_u128(0xd9c5c8db_fc74_4064_94e9_cd19f947ed45);
pub const CODECAPI_AVEncCommonBufferOutLevel: windows_core::GUID = windows_core::GUID::from_u128(0xccae7f49_d0bc_4e3d_a57e_fb5740140069);
pub const CODECAPI_AVEncCommonBufferSize: windows_core::GUID = windows_core::GUID::from_u128(0x0db96574_b6a4_4c8b_8106_3773de0310cd);
pub const CODECAPI_AVEncCommonFormatConstraint: windows_core::GUID = windows_core::GUID::from_u128(0x57cbb9b8_116f_4951_b40c_c2a035ed8f17);
pub const CODECAPI_AVEncCommonLowLatency: windows_core::GUID = windows_core::GUID::from_u128(0x9d3ecd55_89e8_490a_970a_0c9548d5a56e);
pub const CODECAPI_AVEncCommonMaxBitRate: windows_core::GUID = windows_core::GUID::from_u128(0x9651eae4_39b9_4ebf_85ef_d7f444ec7465);
pub const CODECAPI_AVEncCommonMeanBitRate: windows_core::GUID = windows_core::GUID::from_u128(0xf7222374_2144_4815_b550_a37f8e12ee52);
pub const CODECAPI_AVEncCommonMeanBitRateInterval: windows_core::GUID = windows_core::GUID::from_u128(0xbfaa2f0c_cb82_4bc0_8474_f06a8a0d0258);
pub const CODECAPI_AVEncCommonMinBitRate: windows_core::GUID = windows_core::GUID::from_u128(0x101405b2_2083_4034_a806_efbeddd7c9ff);
pub const CODECAPI_AVEncCommonMultipassMode: windows_core::GUID = windows_core::GUID::from_u128(0x22533d4c_47e1_41b5_9352_a2b7780e7ac4);
pub const CODECAPI_AVEncCommonPassEnd: windows_core::GUID = windows_core::GUID::from_u128(0x0e3d01bc_c85c_467d_8b60_c41012ee3bf6);
pub const CODECAPI_AVEncCommonPassStart: windows_core::GUID = windows_core::GUID::from_u128(0x6a67739f_4eb5_4385_9928_f276a939ef95);
pub const CODECAPI_AVEncCommonQuality: windows_core::GUID = windows_core::GUID::from_u128(0xfcbf57a3_7ea5_4b0c_9644_69b40c39c391);
pub const CODECAPI_AVEncCommonQualityVsSpeed: windows_core::GUID = windows_core::GUID::from_u128(0x98332df8_03cd_476b_89fa_3f9e442dec9f);
pub const CODECAPI_AVEncCommonRateControlMode: windows_core::GUID = windows_core::GUID::from_u128(0x1c0608e9_370c_4710_8a58_cb6181c42423);
pub const CODECAPI_AVEncCommonRealTime: windows_core::GUID = windows_core::GUID::from_u128(0x143a0ff6_a131_43da_b81e_98fbb8ec378e);
pub const CODECAPI_AVEncCommonStreamEndHandling: windows_core::GUID = windows_core::GUID::from_u128(0x6aad30af_6ba8_4ccc_8fca_18d19beaeb1c);
pub const CODECAPI_AVEncCommonTranscodeEncodingProfile: windows_core::GUID = windows_core::GUID::from_u128(0x6947787c_f508_4ea9_b1e9_a1fe3a49fbc9);
pub const CODECAPI_AVEncDDAtoDConverterType: windows_core::GUID = windows_core::GUID::from_u128(0x719f9612_81a1_47e0_9a05_d94ad5fca948);
pub const CODECAPI_AVEncDDCentreDownMixLevel: windows_core::GUID = windows_core::GUID::from_u128(0xe285072c_c958_4a81_afd2_e5e0daf1b148);
pub const CODECAPI_AVEncDDChannelBWLowPassFilter: windows_core::GUID = windows_core::GUID::from_u128(0xe197821d_d2e7_43e2_ad2c_00582f518545);
pub const CODECAPI_AVEncDDCopyright: windows_core::GUID = windows_core::GUID::from_u128(0x8694f076_cd75_481d_a5c6_a904dcc828f0);
pub const CODECAPI_AVEncDDDCHighPassFilter: windows_core::GUID = windows_core::GUID::from_u128(0x9565239f_861c_4ac8_bfda_e00cb4db8548);
pub const CODECAPI_AVEncDDDialogNormalization: windows_core::GUID = windows_core::GUID::from_u128(0xd7055acf_f125_437d_a704_79c79f0404a8);
pub const CODECAPI_AVEncDDDigitalDeemphasis: windows_core::GUID = windows_core::GUID::from_u128(0xe024a2c2_947c_45ac_87d8_f1030c5c0082);
pub const CODECAPI_AVEncDDDynamicRangeCompressionControl: windows_core::GUID = windows_core::GUID::from_u128(0xcfc2ff6d_79b8_4b8d_a8aa_a0c9bd1c2940);
pub const CODECAPI_AVEncDDHeadphoneMode: windows_core::GUID = windows_core::GUID::from_u128(0x4052dbec_52f5_42f5_9b00_d134b1341b9d);
pub const CODECAPI_AVEncDDLFELowPassFilter: windows_core::GUID = windows_core::GUID::from_u128(0xd3b80f6f_9d15_45e5_91be_019c3fab1f01);
pub const CODECAPI_AVEncDDLoRoCenterMixLvl_x10: windows_core::GUID = windows_core::GUID::from_u128(0x1cfba222_25b3_4bf4_9bfd_e7111267858c);
pub const CODECAPI_AVEncDDLoRoSurroundMixLvl_x10: windows_core::GUID = windows_core::GUID::from_u128(0xe725cff6_eb56_40c7_8450_2b9367e91555);
pub const CODECAPI_AVEncDDLtRtCenterMixLvl_x10: windows_core::GUID = windows_core::GUID::from_u128(0xdca128a2_491f_4600_b2da_76e3344b4197);
pub const CODECAPI_AVEncDDLtRtSurroundMixLvl_x10: windows_core::GUID = windows_core::GUID::from_u128(0x212246c7_3d2c_4dfa_bc21_652a9098690d);
pub const CODECAPI_AVEncDDOriginalBitstream: windows_core::GUID = windows_core::GUID::from_u128(0x966ae800_5bd3_4ff9_95b9_d30566273856);
pub const CODECAPI_AVEncDDPreferredStereoDownMixMode: windows_core::GUID = windows_core::GUID::from_u128(0x7f4e6b31_9185_403d_b0a2_763743e6f063);
pub const CODECAPI_AVEncDDProductionInfoExists: windows_core::GUID = windows_core::GUID::from_u128(0xb0b7fe5f_b6ab_4f40_964d_8d91f17c19e8);
pub const CODECAPI_AVEncDDProductionMixLevel: windows_core::GUID = windows_core::GUID::from_u128(0x301d103a_cbf9_4776_8899_7c15b461ab26);
pub const CODECAPI_AVEncDDProductionRoomType: windows_core::GUID = windows_core::GUID::from_u128(0xdad7ad60_23d8_4ab7_a284_556986d8a6fe);
pub const CODECAPI_AVEncDDRFPreEmphasisFilter: windows_core::GUID = windows_core::GUID::from_u128(0x21af44c0_244e_4f3d_a2cc_3d3068b2e73f);
pub const CODECAPI_AVEncDDService: windows_core::GUID = windows_core::GUID::from_u128(0xd2e1bec7_5172_4d2a_a50e_2f3b82b1ddf8);
pub const CODECAPI_AVEncDDSurround3dBAttenuation: windows_core::GUID = windows_core::GUID::from_u128(0x4d43b99d_31e2_48b9_bf2e_5cbf1a572784);
pub const CODECAPI_AVEncDDSurround90DegreeePhaseShift: windows_core::GUID = windows_core::GUID::from_u128(0x25ecec9d_3553_42c0_bb56_d25792104f80);
pub const CODECAPI_AVEncDDSurroundDownMixLevel: windows_core::GUID = windows_core::GUID::from_u128(0x7b20d6e5_0bcf_4273_a487_506b047997e9);
pub const CODECAPI_AVEncDDSurroundExMode: windows_core::GUID = windows_core::GUID::from_u128(0x91607cee_dbdd_4eb6_bca2_aadfafa3dd68);
pub const CODECAPI_AVEncEnableVideoProcessing: windows_core::GUID = windows_core::GUID::from_u128(0x006f4bf6_0ea3_4d42_8702_b5d8be0f7a92);
pub const CODECAPI_AVEncH264CABACEnable: windows_core::GUID = windows_core::GUID::from_u128(0xee6cad62_d305_4248_a50e_e1b255f7caf8);
pub const CODECAPI_AVEncH264PPSID: windows_core::GUID = windows_core::GUID::from_u128(0xbfe29ec2_056c_4d68_a38d_ae5944c8582e);
pub const CODECAPI_AVEncH264SPSID: windows_core::GUID = windows_core::GUID::from_u128(0x50f38f51_2b79_40e3_b39c_7e9fa0770501);
pub const CODECAPI_AVEncInputVideoSystem: windows_core::GUID = windows_core::GUID::from_u128(0xbede146d_b616_4dc7_92b2_f5d9fa9298f7);
pub const CODECAPI_AVEncLowPowerEncoder: windows_core::GUID = windows_core::GUID::from_u128(0xb668d582_8bad_4f6a_9141_375a95358b6d);
pub const CODECAPI_AVEncMP12MuxDVDNavPacks: windows_core::GUID = windows_core::GUID::from_u128(0xc7607ced_8cf1_4a99_83a1_ee5461be3574);
pub const CODECAPI_AVEncMP12MuxEarliestPTS: windows_core::GUID = windows_core::GUID::from_u128(0x157232b6_f809_474e_9464_a7f93014a817);
pub const CODECAPI_AVEncMP12MuxInitialSCR: windows_core::GUID = windows_core::GUID::from_u128(0x3433ad21_1b91_4a0b_b190_2b77063b63a4);
pub const CODECAPI_AVEncMP12MuxLargestPacketSize: windows_core::GUID = windows_core::GUID::from_u128(0x35ceb711_f461_4b92_a4ef_17b6841ed254);
pub const CODECAPI_AVEncMP12MuxMuxRate: windows_core::GUID = windows_core::GUID::from_u128(0xee047c72_4bdb_4a9d_8e21_41926c823da7);
pub const CODECAPI_AVEncMP12MuxNumStreams: windows_core::GUID = windows_core::GUID::from_u128(0xf7164a41_dced_4659_a8f2_fb693f2a4cd0);
pub const CODECAPI_AVEncMP12MuxPackSize: windows_core::GUID = windows_core::GUID::from_u128(0xf916053a_1ce8_4faf_aa0b_ba31c80034b8);
pub const CODECAPI_AVEncMP12MuxPacketOverhead: windows_core::GUID = windows_core::GUID::from_u128(0xe40bd720_3955_4453_acf9_b79132a38fa0);
pub const CODECAPI_AVEncMP12MuxSysAudioLock: windows_core::GUID = windows_core::GUID::from_u128(0x0fbb5752_1d43_47bf_bd79_f2293d8ce337);
pub const CODECAPI_AVEncMP12MuxSysCSPS: windows_core::GUID = windows_core::GUID::from_u128(0x7952ff45_9c0d_4822_bc82_8ad772e02993);
pub const CODECAPI_AVEncMP12MuxSysFixed: windows_core::GUID = windows_core::GUID::from_u128(0xcefb987e_894f_452e_8f89_a4ef8cec063a);
pub const CODECAPI_AVEncMP12MuxSysRateBound: windows_core::GUID = windows_core::GUID::from_u128(0x05f0428a_ee30_489d_ae28_205c72446710);
pub const CODECAPI_AVEncMP12MuxSysSTDBufferBound: windows_core::GUID = windows_core::GUID::from_u128(0x35746903_b545_43e7_bb35_c5e0a7d5093c);
pub const CODECAPI_AVEncMP12MuxSysVideoLock: windows_core::GUID = windows_core::GUID::from_u128(0xb8296408_2430_4d37_a2a1_95b3e435a91d);
pub const CODECAPI_AVEncMP12MuxTargetPacketizer: windows_core::GUID = windows_core::GUID::from_u128(0xd862212a_2015_45dd_9a32_1b3aa88205a0);
pub const CODECAPI_AVEncMP12PktzCopyright: windows_core::GUID = windows_core::GUID::from_u128(0xc8f4b0c1_094c_43c7_8e68_a595405a6ef8);
pub const CODECAPI_AVEncMP12PktzInitialPTS: windows_core::GUID = windows_core::GUID::from_u128(0x2a4f2065_9a63_4d20_ae22_0a1bc896a315);
pub const CODECAPI_AVEncMP12PktzOriginal: windows_core::GUID = windows_core::GUID::from_u128(0x6b178416_31b9_4964_94cb_6bff866cdf83);
pub const CODECAPI_AVEncMP12PktzPacketSize: windows_core::GUID = windows_core::GUID::from_u128(0xab71347a_1332_4dde_a0e5_ccf7da8a0f22);
pub const CODECAPI_AVEncMP12PktzSTDBuffer: windows_core::GUID = windows_core::GUID::from_u128(0x0b751bd0_819e_478c_9435_75208926b377);
pub const CODECAPI_AVEncMP12PktzStreamID: windows_core::GUID = windows_core::GUID::from_u128(0xc834d038_f5e8_4408_9b60_88f36493fedf);
pub const CODECAPI_AVEncMPACodingMode: windows_core::GUID = windows_core::GUID::from_u128(0xb16ade03_4b93_43d7_a550_90b4fe224537);
pub const CODECAPI_AVEncMPACopyright: windows_core::GUID = windows_core::GUID::from_u128(0xa6ae762a_d0a9_4454_b8ef_f2dbeefdd3bd);
pub const CODECAPI_AVEncMPAEmphasisType: windows_core::GUID = windows_core::GUID::from_u128(0x2d59fcda_bf4e_4ed6_b5df_5b03b36b0a1f);
pub const CODECAPI_AVEncMPAEnableRedundancyProtection: windows_core::GUID = windows_core::GUID::from_u128(0x5e54b09e_b2e7_4973_a89b_0b3650a3beda);
pub const CODECAPI_AVEncMPALayer: windows_core::GUID = windows_core::GUID::from_u128(0x9d377230_f91b_453d_9ce0_78445414c22d);
pub const CODECAPI_AVEncMPAOriginalBitstream: windows_core::GUID = windows_core::GUID::from_u128(0x3cfb7855_9cc9_47ff_b829_b36786c92346);
pub const CODECAPI_AVEncMPAPrivateUserBit: windows_core::GUID = windows_core::GUID::from_u128(0xafa505ce_c1e3_4e3d_851b_61b700e5e6cc);
pub const CODECAPI_AVEncMPVAddSeqEndCode: windows_core::GUID = windows_core::GUID::from_u128(0xa823178f_57df_4c7a_b8fd_e5ec8887708d);
pub const CODECAPI_AVEncMPVDefaultBPictureCount: windows_core::GUID = windows_core::GUID::from_u128(0x8d390aac_dc5c_4200_b57f_814d04babab2);
pub const CODECAPI_AVEncMPVFrameFieldMode: windows_core::GUID = windows_core::GUID::from_u128(0xacb5de96_7b93_4c2f_8825_b0295fa93bf4);
pub const CODECAPI_AVEncMPVGOPOpen: windows_core::GUID = windows_core::GUID::from_u128(0xb1d5d4a6_3300_49b1_ae61_a09937ab0e49);
pub const CODECAPI_AVEncMPVGOPSInSeq: windows_core::GUID = windows_core::GUID::from_u128(0x993410d4_2691_4192_9978_98dc2603669f);
pub const CODECAPI_AVEncMPVGOPSize: windows_core::GUID = windows_core::GUID::from_u128(0x95f31b26_95a4_41aa_9303_246a7fc6eef1);
pub const CODECAPI_AVEncMPVGOPSizeMax: windows_core::GUID = windows_core::GUID::from_u128(0xfe7de4c4_1936_4fe2_bdf7_1f18ca1d001f);
pub const CODECAPI_AVEncMPVGOPSizeMin: windows_core::GUID = windows_core::GUID::from_u128(0x7155cf20_d440_4852_ad0f_9c4abfe37a6a);
pub const CODECAPI_AVEncMPVGenerateHeaderPicDispExt: windows_core::GUID = windows_core::GUID::from_u128(0xc6412f84_c03f_4f40_a00c_4293df8395bb);
pub const CODECAPI_AVEncMPVGenerateHeaderPicExt: windows_core::GUID = windows_core::GUID::from_u128(0x1b8464ab_944f_45f0_b74e_3a58dad11f37);
pub const CODECAPI_AVEncMPVGenerateHeaderSeqDispExt: windows_core::GUID = windows_core::GUID::from_u128(0x6437aa6f_5a3c_4de9_8a16_53d9c4ad326f);
pub const CODECAPI_AVEncMPVGenerateHeaderSeqExt: windows_core::GUID = windows_core::GUID::from_u128(0xd5e78611_082d_4e6b_98af_0f51ab139222);
pub const CODECAPI_AVEncMPVGenerateHeaderSeqScaleExt: windows_core::GUID = windows_core::GUID::from_u128(0x0722d62f_dd59_4a86_9cd5_644f8e2653d8);
pub const CODECAPI_AVEncMPVIntraDCPrecision: windows_core::GUID = windows_core::GUID::from_u128(0xa0116151_cbc8_4af3_97dc_d00cceb82d79);
pub const CODECAPI_AVEncMPVIntraVLCTable: windows_core::GUID = windows_core::GUID::from_u128(0xa2b83ff5_1a99_405a_af95_c5997d558d3a);
pub const CODECAPI_AVEncMPVLevel: windows_core::GUID = windows_core::GUID::from_u128(0x6ee40c40_a60c_41ef_8f50_37c2249e2cb3);
pub const CODECAPI_AVEncMPVProfile: windows_core::GUID = windows_core::GUID::from_u128(0xdabb534a_1d99_4284_975a_d90e2239baa1);
pub const CODECAPI_AVEncMPVQScaleType: windows_core::GUID = windows_core::GUID::from_u128(0x2b79ebb7_f484_4af7_bb58_a2a188c5cbbe);
pub const CODECAPI_AVEncMPVQuantMatrixChromaIntra: windows_core::GUID = windows_core::GUID::from_u128(0x9eb9ecd4_018d_4ffd_8f2d_39e49f07b17a);
pub const CODECAPI_AVEncMPVQuantMatrixChromaNonIntra: windows_core::GUID = windows_core::GUID::from_u128(0x1415b6b1_362a_4338_ba9a_1ef58703c05b);
pub const CODECAPI_AVEncMPVQuantMatrixIntra: windows_core::GUID = windows_core::GUID::from_u128(0x9bea04f3_6621_442c_8ba1_3ac378979698);
pub const CODECAPI_AVEncMPVQuantMatrixNonIntra: windows_core::GUID = windows_core::GUID::from_u128(0x87f441d8_0997_4beb_a08e_8573d409cf75);
pub const CODECAPI_AVEncMPVScanPattern: windows_core::GUID = windows_core::GUID::from_u128(0x7f8a478e_7bbb_4ae2_b2fc_96d17fc4a2d6);
pub const CODECAPI_AVEncMPVSceneDetection: windows_core::GUID = windows_core::GUID::from_u128(0x552799f1_db4c_405b_8a3a_c93f2d0674dc);
pub const CODECAPI_AVEncMPVUseConcealmentMotionVectors: windows_core::GUID = windows_core::GUID::from_u128(0xec770cf3_6908_4b4b_aa30_7fb986214fea);
pub const CODECAPI_AVEncMaxFrameRate: windows_core::GUID = windows_core::GUID::from_u128(0xb98e1b31_19fa_4d4f_9931_d6a5b8aab93c);
pub const CODECAPI_AVEncMuxOutputStreamType: windows_core::GUID = windows_core::GUID::from_u128(0xcedd9e8f_34d3_44db_a1d8_f81520254f3e);
pub const CODECAPI_AVEncNoInputCopy: windows_core::GUID = windows_core::GUID::from_u128(0xd2b46a2a_e8ee_4ec5_869e_449b6c62c81a);
pub const CODECAPI_AVEncNumWorkerThreads: windows_core::GUID = windows_core::GUID::from_u128(0xb0c8bf60_16f7_4951_a30b_1db1609293d6);
pub const CODECAPI_AVEncProgressiveUpdateTime: windows_core::GUID = windows_core::GUID::from_u128(0x649faf66_afc6_4828_8fdc_0771cd9ab17d);
pub const CODECAPI_AVEncSliceControlMode: windows_core::GUID = windows_core::GUID::from_u128(0xe9e782ef_5f18_44c9_a90b_e9c3c2c17b0b);
pub const CODECAPI_AVEncSliceControlSize: windows_core::GUID = windows_core::GUID::from_u128(0x92f51df3_07a5_4172_aefe_c69ca3b60e35);
pub const CODECAPI_AVEncSliceGenerationMode: windows_core::GUID = windows_core::GUID::from_u128(0x8a6bc67f_9497_4286_b46b_02db8d60edbc);
pub const CODECAPI_AVEncStatAudioAverageBPS: windows_core::GUID = windows_core::GUID::from_u128(0xca6724db_7059_4351_8b43_f82198826a14);
pub const CODECAPI_AVEncStatAudioAveragePCMValue: windows_core::GUID = windows_core::GUID::from_u128(0x979272f8_d17f_4e32_bb73_4e731c68ba2d);
pub const CODECAPI_AVEncStatAudioPeakPCMValue: windows_core::GUID = windows_core::GUID::from_u128(0xdce7fd34_dc00_4c16_821b_35d9eb00fb1a);
pub const CODECAPI_AVEncStatAverageBPS: windows_core::GUID = windows_core::GUID::from_u128(0xca6724db_7059_4351_8b43_f82198826a14);
pub const CODECAPI_AVEncStatCommonCompletedPasses: windows_core::GUID = windows_core::GUID::from_u128(0x3e5de533_9df7_438c_854f_9f7dd3683d34);
pub const CODECAPI_AVEncStatHardwareBandwidthUtilitization: windows_core::GUID = windows_core::GUID::from_u128(0x0124ba9b_dc41_4826_b45f_18ac01b3d5a8);
pub const CODECAPI_AVEncStatHardwareProcessorUtilitization: windows_core::GUID = windows_core::GUID::from_u128(0x995dc027_cb95_49e6_b91b_5967753cdcb8);
pub const CODECAPI_AVEncStatMPVSkippedEmptyFrames: windows_core::GUID = windows_core::GUID::from_u128(0x32195fd3_590d_4812_a7ed_6d639a1f9711);
pub const CODECAPI_AVEncStatVideoCodedFrames: windows_core::GUID = windows_core::GUID::from_u128(0xd47f8d61_6f5a_4a26_bb9f_cd9518462bcd);
pub const CODECAPI_AVEncStatVideoOutputFrameRate: windows_core::GUID = windows_core::GUID::from_u128(0xbe747849_9ab4_4a63_98fe_f143f04f8ee9);
pub const CODECAPI_AVEncStatVideoTotalFrames: windows_core::GUID = windows_core::GUID::from_u128(0xfdaa9916_119a_4222_9ad6_3f7cab99cc8b);
pub const CODECAPI_AVEncStatWMVCBAvg: windows_core::GUID = windows_core::GUID::from_u128(0x6aa6229f_d602_4b9d_b68c_c1ad78884bef);
pub const CODECAPI_AVEncStatWMVCBMax: windows_core::GUID = windows_core::GUID::from_u128(0xe976bef8_00fe_44b4_b625_8f238bc03499);
pub const CODECAPI_AVEncStatWMVDecoderComplexityProfile: windows_core::GUID = windows_core::GUID::from_u128(0x89e69fc3_0f9b_436c_974a_df821227c90d);
pub const CODECAPI_AVEncTileColumns: windows_core::GUID = windows_core::GUID::from_u128(0xb4b31205_01e8_452c_b876_8c6506545925);
pub const CODECAPI_AVEncTileRows: windows_core::GUID = windows_core::GUID::from_u128(0xfbc650fc_41ab_4f9b_84b5_065be9cd99ee);
pub const CODECAPI_AVEncVideoCBRMotionTradeoff: windows_core::GUID = windows_core::GUID::from_u128(0x0d49451e_18d5_4367_a4ef_3240df1693c4);
pub const CODECAPI_AVEncVideoCTBSize: windows_core::GUID = windows_core::GUID::from_u128(0xd47db8b2_e73b_4cb9_8c3e_bd877d06d77b);
pub const CODECAPI_AVEncVideoCodedVideoAccessUnitSize: windows_core::GUID = windows_core::GUID::from_u128(0xb4b10c15_14a7_4ce8_b173_dc90a0b4fcdb);
pub const CODECAPI_AVEncVideoConsecutiveFramesForLayer: windows_core::GUID = windows_core::GUID::from_u128(0x0af35522_d984_45ae_bbb8_53933e0ab1b5);
pub const CODECAPI_AVEncVideoContentType: windows_core::GUID = windows_core::GUID::from_u128(0x66117aca_eb77_459d_930c_a48d9d0683fc);
pub const CODECAPI_AVEncVideoDefaultUpperFieldDominant: windows_core::GUID = windows_core::GUID::from_u128(0x810167c4_0bc1_47ca_8fc2_57055a1474a5);
pub const CODECAPI_AVEncVideoDirtyRectEnabled: windows_core::GUID = windows_core::GUID::from_u128(0x8acb8fdd_5e0c_4c66_8729_b8f629ab04fb);
pub const CODECAPI_AVEncVideoDisplayDimension: windows_core::GUID = windows_core::GUID::from_u128(0xde053668_f4ec_47a9_86d0_836770f0c1d5);
pub const CODECAPI_AVEncVideoEncodeDimension: windows_core::GUID = windows_core::GUID::from_u128(0x1074df28_7e0f_47a4_a453_cdd73870f5ce);
pub const CODECAPI_AVEncVideoEncodeFrameTypeQP: windows_core::GUID = windows_core::GUID::from_u128(0xaa70b610_e03f_450c_ad07_07314e639ce7);
pub const CODECAPI_AVEncVideoEncodeOffsetOrigin: windows_core::GUID = windows_core::GUID::from_u128(0x6bc098fe_a71a_4454_852e_4d2ddeb2cd24);
pub const CODECAPI_AVEncVideoEncodeQP: windows_core::GUID = windows_core::GUID::from_u128(0x2cb5696b_23fb_4ce1_a0f9_ef5b90fd55ca);
pub const CODECAPI_AVEncVideoFieldSwap: windows_core::GUID = windows_core::GUID::from_u128(0xfefd7569_4e0a_49f2_9f2b_360ea48c19a2);
pub const CODECAPI_AVEncVideoForceKeyFrame: windows_core::GUID = windows_core::GUID::from_u128(0x398c1b98_8353_475a_9ef2_8f265d260345);
pub const CODECAPI_AVEncVideoForceSourceScanType: windows_core::GUID = windows_core::GUID::from_u128(0x1ef2065f_058a_4765_a4fc_8a864c103012);
pub const CODECAPI_AVEncVideoGradualIntraRefresh: windows_core::GUID = windows_core::GUID::from_u128(0x8f347dee_cb0d_49ba_b462_db6927ee2101);
pub const CODECAPI_AVEncVideoHeaderDropFrame: windows_core::GUID = windows_core::GUID::from_u128(0x6ed9e124_7925_43fe_971b_e019f62222b4);
pub const CODECAPI_AVEncVideoHeaderFrames: windows_core::GUID = windows_core::GUID::from_u128(0xafd5f567_5c1b_4adc_bdaf_735610381436);
pub const CODECAPI_AVEncVideoHeaderHours: windows_core::GUID = windows_core::GUID::from_u128(0x2acc7702_e2da_4158_bf9b_88880129d740);
pub const CODECAPI_AVEncVideoHeaderMinutes: windows_core::GUID = windows_core::GUID::from_u128(0xdc1a99ce_0307_408b_880b_b8348ee8ca7f);
pub const CODECAPI_AVEncVideoHeaderSeconds: windows_core::GUID = windows_core::GUID::from_u128(0x4a2e1a05_a780_4f58_8120_9a449d69656b);
pub const CODECAPI_AVEncVideoInputChromaResolution: windows_core::GUID = windows_core::GUID::from_u128(0xbb0cec33_16f1_47b0_8a88_37815bee1739);
pub const CODECAPI_AVEncVideoInputChromaSubsampling: windows_core::GUID = windows_core::GUID::from_u128(0xa8e73a39_4435_4ec3_a6ea_98300f4b36f7);
pub const CODECAPI_AVEncVideoInputColorLighting: windows_core::GUID = windows_core::GUID::from_u128(0x46a99549_0015_4a45_9c30_1d5cfa258316);
pub const CODECAPI_AVEncVideoInputColorNominalRange: windows_core::GUID = windows_core::GUID::from_u128(0x16cf25c6_a2a6_48e9_ae80_21aec41d427e);
pub const CODECAPI_AVEncVideoInputColorPrimaries: windows_core::GUID = windows_core::GUID::from_u128(0xc24d783f_7ce6_4278_90ab_28a4f1e5f86c);
pub const CODECAPI_AVEncVideoInputColorTransferFunction: windows_core::GUID = windows_core::GUID::from_u128(0x8c056111_a9c3_4b08_a0a0_ce13f8a27c75);
pub const CODECAPI_AVEncVideoInputColorTransferMatrix: windows_core::GUID = windows_core::GUID::from_u128(0x52ed68b9_72d5_4089_958d_f5405d55081c);
pub const CODECAPI_AVEncVideoInstantTemporalUpSwitching: windows_core::GUID = windows_core::GUID::from_u128(0xa3308307_0d96_4ba4_b1f0_b91a5e49df10);
pub const CODECAPI_AVEncVideoIntraLayerPrediction: windows_core::GUID = windows_core::GUID::from_u128(0xd3af46b8_bf47_44bb_a283_69f0b0228ff9);
pub const CODECAPI_AVEncVideoInverseTelecineEnable: windows_core::GUID = windows_core::GUID::from_u128(0x2ea9098b_e76d_4ccd_a030_d3b889c1b64c);
pub const CODECAPI_AVEncVideoInverseTelecineThreshold: windows_core::GUID = windows_core::GUID::from_u128(0x40247d84_e895_497f_b44c_b74560acfe27);
pub const CODECAPI_AVEncVideoLTRBufferControl: windows_core::GUID = windows_core::GUID::from_u128(0xa4a0e93d_4cbc_444c_89f4_826d310e92a7);
pub const CODECAPI_AVEncVideoMarkLTRFrame: windows_core::GUID = windows_core::GUID::from_u128(0xe42f4748_a06d_4ef9_8cea_3d05fde3bd3b);
pub const CODECAPI_AVEncVideoMaxCTBSize: windows_core::GUID = windows_core::GUID::from_u128(0x822363ff_cec8_43e5_92fd_e097488485e9);
pub const CODECAPI_AVEncVideoMaxKeyframeDistance: windows_core::GUID = windows_core::GUID::from_u128(0x2987123a_ba93_4704_b489_ec1e5f25292c);
pub const CODECAPI_AVEncVideoMaxNumRefFrame: windows_core::GUID = windows_core::GUID::from_u128(0x964829ed_94f9_43b4_b74d_ef40944b69a0);
pub const CODECAPI_AVEncVideoMaxNumRefFrameForLayer: windows_core::GUID = windows_core::GUID::from_u128(0x3141c639_6329_40d1_b7e7_2f0e3ac18e02);
pub const CODECAPI_AVEncVideoMaxQP: windows_core::GUID = windows_core::GUID::from_u128(0x3daf6f66_a6a7_45e0_a8e5_f2743f46a3a2);
pub const CODECAPI_AVEncVideoMaxTemporalLayers: windows_core::GUID = windows_core::GUID::from_u128(0x9c668cfe_08e1_424a_934e_b764b064802a);
pub const CODECAPI_AVEncVideoMeanAbsoluteDifference: windows_core::GUID = windows_core::GUID::from_u128(0xe5c0c10f_81a4_422d_8c3f_b474a4581336);
pub const CODECAPI_AVEncVideoMinQP: windows_core::GUID = windows_core::GUID::from_u128(0x0ee22c6a_a37c_4568_b5f1_9d4c2b3ab886);
pub const CODECAPI_AVEncVideoNoOfFieldsToEncode: windows_core::GUID = windows_core::GUID::from_u128(0x61e4bbe2_4ee0_40e7_80ab_51ddeebe6291);
pub const CODECAPI_AVEncVideoNoOfFieldsToSkip: windows_core::GUID = windows_core::GUID::from_u128(0xa97e1240_1427_4c16_a7f7_3dcfd8ba4cc5);
pub const CODECAPI_AVEncVideoNumGOPsPerIDR: windows_core::GUID = windows_core::GUID::from_u128(0x83bc5bdb_5b89_4521_8f66_33151c373176);
pub const CODECAPI_AVEncVideoOutputChromaResolution: windows_core::GUID = windows_core::GUID::from_u128(0x6097b4c9_7c1d_4e64_bfcc_9e9765318ae7);
pub const CODECAPI_AVEncVideoOutputChromaSubsampling: windows_core::GUID = windows_core::GUID::from_u128(0xfa561c6c_7d17_44f0_83c9_32ed12e96343);
pub const CODECAPI_AVEncVideoOutputColorLighting: windows_core::GUID = windows_core::GUID::from_u128(0x0e5aaac6_ace6_4c5c_998e_1a8c9c6c0f89);
pub const CODECAPI_AVEncVideoOutputColorNominalRange: windows_core::GUID = windows_core::GUID::from_u128(0x972835ed_87b5_4e95_9500_c73958566e54);
pub const CODECAPI_AVEncVideoOutputColorPrimaries: windows_core::GUID = windows_core::GUID::from_u128(0xbe95907c_9d04_4921_8985_a6d6d87d1a6c);
pub const CODECAPI_AVEncVideoOutputColorTransferFunction: windows_core::GUID = windows_core::GUID::from_u128(0x4a7f884a_ea11_460d_bf57_b88bc75900de);
pub const CODECAPI_AVEncVideoOutputColorTransferMatrix: windows_core::GUID = windows_core::GUID::from_u128(0xa9b90444_af40_4310_8fbe_ed6d933f892b);
pub const CODECAPI_AVEncVideoOutputFrameRate: windows_core::GUID = windows_core::GUID::from_u128(0xea85e7c3_9567_4d99_87c4_02c1c278ca7c);
pub const CODECAPI_AVEncVideoOutputFrameRateConversion: windows_core::GUID = windows_core::GUID::from_u128(0x8c068bf4_369a_4ba3_82fd_b2518fb3396e);
pub const CODECAPI_AVEncVideoOutputScanType: windows_core::GUID = windows_core::GUID::from_u128(0x460b5576_842e_49ab_a62d_b36f7312c9db);
pub const CODECAPI_AVEncVideoPixelAspectRatio: windows_core::GUID = windows_core::GUID::from_u128(0x3cdc718f_b3e9_4eb6_a57f_cf1f1b321b87);
pub const CODECAPI_AVEncVideoROIEnabled: windows_core::GUID = windows_core::GUID::from_u128(0xd74f7f18_44dd_4b85_aba3_05d9f42a8280);
pub const CODECAPI_AVEncVideoRateControlParams: windows_core::GUID = windows_core::GUID::from_u128(0x87d43767_7645_44ec_b438_d3322fbca29f);
pub const CODECAPI_AVEncVideoSelectLayer: windows_core::GUID = windows_core::GUID::from_u128(0xeb1084f5_6aaa_4914_bb2f_6147227f12e7);
pub const CODECAPI_AVEncVideoSourceFilmContent: windows_core::GUID = windows_core::GUID::from_u128(0x1791c64b_ccfc_4827_a0ed_2557793b2b1c);
pub const CODECAPI_AVEncVideoSourceIsBW: windows_core::GUID = windows_core::GUID::from_u128(0x42ffc49b_1812_4fdc_8d24_7054c521e6eb);
pub const CODECAPI_AVEncVideoSupportedControls: windows_core::GUID = windows_core::GUID::from_u128(0xd3f40fdd_77b9_473d_8196_061259e69cff);
pub const CODECAPI_AVEncVideoTemporalLayerCount: windows_core::GUID = windows_core::GUID::from_u128(0x19caebff_b74d_4cfd_8c27_c2f9d97d5f52);
pub const CODECAPI_AVEncVideoUsage: windows_core::GUID = windows_core::GUID::from_u128(0x1f636849_5dc1_49f1_b1d8_ce3cf62ea385);
pub const CODECAPI_AVEncVideoUseLTRFrame: windows_core::GUID = windows_core::GUID::from_u128(0x00752db8_55f7_4f80_895b_27639195f2ad);
pub const CODECAPI_AVEncWMVDecoderComplexity: windows_core::GUID = windows_core::GUID::from_u128(0xf32c0dab_f3cb_4217_b79f_8762768b5f67);
pub const CODECAPI_AVEncWMVInterlacedEncoding: windows_core::GUID = windows_core::GUID::from_u128(0xe3d00f8a_c6f5_4e14_a588_0ec87a726f9b);
pub const CODECAPI_AVEncWMVKeyFrameBufferLevelMarker: windows_core::GUID = windows_core::GUID::from_u128(0x51ff1115_33ac_426c_a1b1_09321bdf96b4);
pub const CODECAPI_AVEncWMVKeyFrameDistance: windows_core::GUID = windows_core::GUID::from_u128(0x5569055e_e268_4771_b83e_9555ea28aed3);
pub const CODECAPI_AVEncWMVProduceDummyFrames: windows_core::GUID = windows_core::GUID::from_u128(0xd669d001_183c_42e3_a3ca_2f4586d2396c);
pub const CODECAPI_AVLowLatencyMode: windows_core::GUID = windows_core::GUID::from_u128(0x9c27891a_ed7a_40e1_88e8_b22727a024ee);
pub const CODECAPI_AVPriorityControl: windows_core::GUID = windows_core::GUID::from_u128(0x54ba3dc8_bdde_4329_b187_2018bc5c2ba1);
pub const CODECAPI_AVRealtimeControl: windows_core::GUID = windows_core::GUID::from_u128(0x6f440632_c4ad_4bf7_9e52_456942b454b0);
pub const CODECAPI_AVScenarioInfo: windows_core::GUID = windows_core::GUID::from_u128(0xb28a6e64_3ff9_446a_8a4b_0d7a53413236);
pub const CODECAPI_CHANGELISTS: windows_core::GUID = windows_core::GUID::from_u128(0x62b12acf_f6b0_47d9_9456_96f22c4e0b9d);
pub const CODECAPI_CURRENTCHANGELIST: windows_core::GUID = windows_core::GUID::from_u128(0x1cb14e83_7d72_4657_83fd_47a2c5b9d13d);
pub const CODECAPI_GUID_AVDecAudioInputAAC: windows_core::GUID = windows_core::GUID::from_u128(0x97df7828_b94a_47e2_a4bc_51194db22a4d);
pub const CODECAPI_GUID_AVDecAudioInputDTS: windows_core::GUID = windows_core::GUID::from_u128(0x600bc0ca_6a1f_4e91_b241_1bbeb1cb19e0);
pub const CODECAPI_GUID_AVDecAudioInputDolby: windows_core::GUID = windows_core::GUID::from_u128(0x8e4228a0_f000_4e0b_8f54_ab8d24ad61a2);
pub const CODECAPI_GUID_AVDecAudioInputDolbyDigitalPlus: windows_core::GUID = windows_core::GUID::from_u128(0x0803e185_8f5d_47f5_9908_19a5bbc9fe34);
pub const CODECAPI_GUID_AVDecAudioInputHEAAC: windows_core::GUID = windows_core::GUID::from_u128(0x16efb4aa_330e_4f5c_98a8_cf6ac55cbe60);
pub const CODECAPI_GUID_AVDecAudioInputMPEG: windows_core::GUID = windows_core::GUID::from_u128(0x91106f36_02c5_4f75_9719_3b7abf75e1f6);
pub const CODECAPI_GUID_AVDecAudioInputPCM: windows_core::GUID = windows_core::GUID::from_u128(0xf2421da5_bbb4_4cd5_a996_933c6b5d1347);
pub const CODECAPI_GUID_AVDecAudioInputWMA: windows_core::GUID = windows_core::GUID::from_u128(0xc95e8dcf_4058_4204_8c42_cb24d91e4b9b);
pub const CODECAPI_GUID_AVDecAudioInputWMAPro: windows_core::GUID = windows_core::GUID::from_u128(0x0128b7c7_da72_4fe3_bef8_5c52e3557704);
pub const CODECAPI_GUID_AVDecAudioOutputFormat_PCM: windows_core::GUID = windows_core::GUID::from_u128(0x696e1d31_548f_4036_825f_7026c60011bd);
pub const CODECAPI_GUID_AVDecAudioOutputFormat_PCM_Headphones: windows_core::GUID = windows_core::GUID::from_u128(0x696e1d34_548f_4036_825f_7026c60011bd);
pub const CODECAPI_GUID_AVDecAudioOutputFormat_PCM_Stereo_Auto: windows_core::GUID = windows_core::GUID::from_u128(0x696e1d35_548f_4036_825f_7026c60011bd);
pub const CODECAPI_GUID_AVDecAudioOutputFormat_PCM_Stereo_MatrixEncoded: windows_core::GUID = windows_core::GUID::from_u128(0x696e1d30_548f_4036_825f_7026c60011bd);
pub const CODECAPI_GUID_AVDecAudioOutputFormat_SPDIF_Bitstream: windows_core::GUID = windows_core::GUID::from_u128(0x696e1d33_548f_4036_825f_7026c60011bd);
pub const CODECAPI_GUID_AVDecAudioOutputFormat_SPDIF_PCM: windows_core::GUID = windows_core::GUID::from_u128(0x696e1d32_548f_4036_825f_7026c60011bd);
pub const CODECAPI_GUID_AVEncCommonFormatATSC: windows_core::GUID = windows_core::GUID::from_u128(0x8d7b897c_a019_4670_aa76_2edcac7ac296);
pub const CODECAPI_GUID_AVEncCommonFormatDVB: windows_core::GUID = windows_core::GUID::from_u128(0x71830d8f_6c33_430d_844b_c2705baae6db);
pub const CODECAPI_GUID_AVEncCommonFormatDVD_DashVR: windows_core::GUID = windows_core::GUID::from_u128(0xe55199d6_044c_4dae_a488_531ed306235b);
pub const CODECAPI_GUID_AVEncCommonFormatDVD_PlusVR: windows_core::GUID = windows_core::GUID::from_u128(0xe74c6f2e_ec37_478d_9af4_a5e135b6271c);
pub const CODECAPI_GUID_AVEncCommonFormatDVD_V: windows_core::GUID = windows_core::GUID::from_u128(0xcc9598c4_e7fe_451d_b1ca_761bc840b7f3);
pub const CODECAPI_GUID_AVEncCommonFormatHighMAT: windows_core::GUID = windows_core::GUID::from_u128(0x1eabe760_fb2b_4928_90d1_78db88eee889);
pub const CODECAPI_GUID_AVEncCommonFormatHighMPV: windows_core::GUID = windows_core::GUID::from_u128(0xa2d25db8_b8f9_42c2_8bc7_0b93cf604788);
pub const CODECAPI_GUID_AVEncCommonFormatMP3: windows_core::GUID = windows_core::GUID::from_u128(0x349733cd_eb08_4dc2_8197_e49835ef828b);
pub const CODECAPI_GUID_AVEncCommonFormatSVCD: windows_core::GUID = windows_core::GUID::from_u128(0x51d85818_8220_448c_8066_d69bed16c9ad);
pub const CODECAPI_GUID_AVEncCommonFormatUnSpecified: windows_core::GUID = windows_core::GUID::from_u128(0xaf46a35a_6024_4525_a48a_094b97f5b3c2);
pub const CODECAPI_GUID_AVEncCommonFormatVCD: windows_core::GUID = windows_core::GUID::from_u128(0x95035bf7_9d90_40ff_ad5c_5cf8cf71ca1d);
pub const CODECAPI_GUID_AVEncDTS: windows_core::GUID = windows_core::GUID::from_u128(0x45fbcaa2_5e6e_4ab0_8893_5903bee93acf);
pub const CODECAPI_GUID_AVEncDTSHD: windows_core::GUID = windows_core::GUID::from_u128(0x2052e630_469d_4bfb_80ca_1d656e7e918f);
pub const CODECAPI_GUID_AVEncDV: windows_core::GUID = windows_core::GUID::from_u128(0x09b769c7_3329_44fb_8954_fa30937d3d5a);
pub const CODECAPI_GUID_AVEncDolbyDigitalConsumer: windows_core::GUID = windows_core::GUID::from_u128(0xc1a7bf6c_0059_4bfa_94ef_ef747a768d52);
pub const CODECAPI_GUID_AVEncDolbyDigitalPlus: windows_core::GUID = windows_core::GUID::from_u128(0x698d1b80_f7dd_415c_971c_42492a2056c6);
pub const CODECAPI_GUID_AVEncDolbyDigitalPro: windows_core::GUID = windows_core::GUID::from_u128(0xf5be76cc_0ff8_40eb_9cb1_bba94004d44f);
pub const CODECAPI_GUID_AVEncH264Video: windows_core::GUID = windows_core::GUID::from_u128(0x95044eab_31b3_47de_8e75_38a42bb03e28);
pub const CODECAPI_GUID_AVEncMLP: windows_core::GUID = windows_core::GUID::from_u128(0x05f73e29_f0d1_431e_a41c_a47432ec5a66);
pub const CODECAPI_GUID_AVEncMPEG1Audio: windows_core::GUID = windows_core::GUID::from_u128(0xd4dd1362_cd4a_4cd6_8138_b94db4542b04);
pub const CODECAPI_GUID_AVEncMPEG1Video: windows_core::GUID = windows_core::GUID::from_u128(0xc8dafefe_da1e_4774_b27d_11830c16b1fe);
pub const CODECAPI_GUID_AVEncMPEG2Audio: windows_core::GUID = windows_core::GUID::from_u128(0xee4cbb1f_9c3f_4770_92b5_fcb7c2a8d381);
pub const CODECAPI_GUID_AVEncMPEG2Video: windows_core::GUID = windows_core::GUID::from_u128(0x046dc19a_6677_4aaa_a31d_c1ab716f4560);
pub const CODECAPI_GUID_AVEncPCM: windows_core::GUID = windows_core::GUID::from_u128(0x844be7f4_26cf_4779_b386_cc05d187990c);
pub const CODECAPI_GUID_AVEncSDDS: windows_core::GUID = windows_core::GUID::from_u128(0x1dc1b82f_11c8_4c71_b7b6_ee3eb9bc2b94);
pub const CODECAPI_GUID_AVEncWMALossless: windows_core::GUID = windows_core::GUID::from_u128(0x55ca7265_23d8_4761_9031_b74fbe12f4c1);
pub const CODECAPI_GUID_AVEncWMAPro: windows_core::GUID = windows_core::GUID::from_u128(0x1955f90c_33f7_4a68_ab81_53f5657125c4);
pub const CODECAPI_GUID_AVEncWMAVoice: windows_core::GUID = windows_core::GUID::from_u128(0x13ed18cb_50e8_4276_a288_a6aa228382d9);
pub const CODECAPI_GUID_AVEncWMV: windows_core::GUID = windows_core::GUID::from_u128(0x4e0fef9b_1d43_41bd_b8bd_4d7bf7457a2a);
pub const CODECAPI_GUID_AVEndMPEG4Video: windows_core::GUID = windows_core::GUID::from_u128(0xdd37b12a_9503_4f8b_b8d0_324a00c0a1cf);
pub const CODECAPI_GetOPMContext: windows_core::GUID = windows_core::GUID::from_u128(0x2f036c05_4c14_4689_8839_294c6d73e053);
pub const CODECAPI_SETALLDEFAULTS: windows_core::GUID = windows_core::GUID::from_u128(0x6c5e6a7c_acf8_4f55_a999_1a628109051b);
pub const CODECAPI_SUPPORTSEVENTS: windows_core::GUID = windows_core::GUID::from_u128(0x0581af97_7693_4dbd_9dca_3f9ebd6585a1);
pub const CODECAPI_SetHDCPManagerContext: windows_core::GUID = windows_core::GUID::from_u128(0x6d2d1fc8_3dc9_47eb_a1a2_471c80cd60d0);
pub const CODECAPI_VIDEO_ENCODER: windows_core::GUID = windows_core::GUID::from_u128(0x7112e8e1_3d03_47ef_8e60_03f1cf537301);
pub const CODECAPI_VideoEncoderDisplayContentType: windows_core::GUID = windows_core::GUID::from_u128(0x79b90b27_f4b1_42dc_9dd7_cdaf8135c400);
pub const COPP_ProtectionType_ACP: i32 = 2i32;
pub const COPP_ProtectionType_CGMSA: i32 = 4i32;
pub const COPP_ProtectionType_HDCP: i32 = 1i32;
pub const COPP_ProtectionType_Mask: i32 = -2147483641i32;
pub const COPP_ProtectionType_None: i32 = 0i32;
pub const COPP_ProtectionType_Reserved: i32 = 2147483640i32;
pub const COPP_ProtectionType_Unknown: i32 = -2147483648i32;
pub const CPK_DS_AC3Decoder: windows_core::GUID = windows_core::GUID::from_u128(0x6c9c69d6_0ffc_4481_afdb_cdf1c79c6f3e);
pub const CPK_DS_MPEG2Decoder: windows_core::GUID = windows_core::GUID::from_u128(0x9910c5cd_95c9_4e06_865a_efa1c8016bf4);
pub const CResamplerMediaObject: windows_core::GUID = windows_core::GUID::from_u128(0xf447b69e_1884_4a7e_8055_346f74d6edb3);
pub const CResizerDMO: windows_core::GUID = windows_core::GUID::from_u128(0x1ea1ea14_48f4_4054_ad1a_e8aee10ac805);
pub const CResizerMediaObject: windows_core::GUID = windows_core::GUID::from_u128(0xd3ec8b8b_7728_4fd8_9fe0_7b67d19f73a3);
pub const CShotDetectorDmo: windows_core::GUID = windows_core::GUID::from_u128(0x56aefacd_110c_4397_9292_b0a0c61b6750);
pub const CSmpteTransformsDmo: windows_core::GUID = windows_core::GUID::from_u128(0xbde6388b_da25_485d_ba7f_fabc28b20318);
pub const CThumbnailGeneratorDmo: windows_core::GUID = windows_core::GUID::from_u128(0x559c6bad_1ea8_4963_a087_8a6810f9218b);
pub const CTocGeneratorDmo: windows_core::GUID = windows_core::GUID::from_u128(0x4dda1941_77a0_4fb1_a518_e2185041d70c);
pub const CVodafoneAACCCDecMediaObject: windows_core::GUID = windows_core::GUID::from_u128(0x7e76bf7f_c993_4e26_8fab_470a70c0d59c);
pub const CVodafoneAACDecMediaObject: windows_core::GUID = windows_core::GUID::from_u128(0x7f36f942_dcf3_4d82_9289_5b1820278f7c);
pub const CWMADecMediaObject: windows_core::GUID = windows_core::GUID::from_u128(0x2eeb4adf_4578_4d10_bca7_bb955f56320a);
pub const CWMAEncMediaObject: windows_core::GUID = windows_core::GUID::from_u128(0x70f598e9_f4ab_495a_99e2_a7c4d3d89abf);
pub const CWMATransMediaObject: windows_core::GUID = windows_core::GUID::from_u128(0xedcad9cb_3127_40df_b527_0152ccb3f6f5);
pub const CWMAudioAEC: windows_core::GUID = windows_core::GUID::from_u128(0x745057c7_f353_4f2d_a7ee_58434477730e);
pub const CWMAudioCAPXGFXAPO: windows_core::GUID = windows_core::GUID::from_u128(0x13ab3ebd_137e_4903_9d89_60be8277fd17);
pub const CWMAudioCAPXLFXAPO: windows_core::GUID = windows_core::GUID::from_u128(0xc9453e73_8c5c_4463_9984_af8bab2f5447);
pub const CWMAudioGFXAPO: windows_core::GUID = windows_core::GUID::from_u128(0x637c490d_eee3_4c0a_973f_371958802da2);
pub const CWMAudioLFXAPO: windows_core::GUID = windows_core::GUID::from_u128(0x62dc1a93_ae24_464c_a43e_452f824c4250);
pub const CWMAudioSpdTxDMO: windows_core::GUID = windows_core::GUID::from_u128(0x5210f8e4_b0bb_47c3_a8d9_7b2282cc79ed);
pub const CWMSPDecMediaObject: windows_core::GUID = windows_core::GUID::from_u128(0x874131cb_4ecc_443b_8948_746b89595d20);
pub const CWMSPEncMediaObject: windows_core::GUID = windows_core::GUID::from_u128(0x67841b03_c689_4188_ad3f_4c9ebeec710b);
pub const CWMSPEncMediaObject2: windows_core::GUID = windows_core::GUID::from_u128(0x1f1f4e1a_2252_4063_84bb_eee75f8856d5);
pub const CWMTDecMediaObject: windows_core::GUID = windows_core::GUID::from_u128(0xf9dbc64e_2dd0_45dd_9b52_66642ef94431);
pub const CWMTEncMediaObject: windows_core::GUID = windows_core::GUID::from_u128(0x60b67652_e46b_4e44_8609_f74bffdc083c);
pub const CWMV9EncMediaObject: windows_core::GUID = windows_core::GUID::from_u128(0xd23b90d0_144f_46bd_841d_59e4eb19dc59);
pub const CWMVDecMediaObject: windows_core::GUID = windows_core::GUID::from_u128(0x82d353df_90bd_4382_8bc2_3f6192b76e34);
pub const CWMVEncMediaObject2: windows_core::GUID = windows_core::GUID::from_u128(0x96b57cdd_8966_410c_bb1f_c97eea765c04);
pub const CWMVXEncMediaObject: windows_core::GUID = windows_core::GUID::from_u128(0x7e320092_596a_41b2_bbeb_175d10504eb6);
pub const CWVC1DecMediaObject: windows_core::GUID = windows_core::GUID::from_u128(0xc9bfbccf_e60e_4588_a3df_5a03b1fd9585);
pub const CWVC1EncMediaObject: windows_core::GUID = windows_core::GUID::from_u128(0x44653d0d_8cca_41e7_baca_884337b747ac);
pub const CZuneAACCCDecMediaObject: windows_core::GUID = windows_core::GUID::from_u128(0xa74e98f2_52d6_4b4e_885b_e0a6ca4f187a);
pub const CZuneM4S2DecMediaObject: windows_core::GUID = windows_core::GUID::from_u128(0xc56fc25c_0fc6_404a_9503_b10bf51a8ab9);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct CodecAPIEventData {
    pub guid: windows_core::GUID,
    pub dataLength: u32,
    pub reserved: [u32; 3],
}
impl Default for CodecAPIEventData {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct D3D12_BITSTREAM_ENCRYPTION_TYPE(pub i32);
pub const D3D12_BITSTREAM_ENCRYPTION_TYPE_NONE: D3D12_BITSTREAM_ENCRYPTION_TYPE = D3D12_BITSTREAM_ENCRYPTION_TYPE(0i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_FEATURE_DATA_VIDEO_ARCHITECTURE {
    pub IOCoherent: super::super::Foundation::BOOL,
}
impl Default for D3D12_FEATURE_DATA_VIDEO_ARCHITECTURE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Dxgi_Common")]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_FEATURE_DATA_VIDEO_DECODER_HEAP_SIZE {
    pub VideoDecoderHeapDesc: D3D12_VIDEO_DECODER_HEAP_DESC,
    pub MemoryPoolL0Size: u64,
    pub MemoryPoolL1Size: u64,
}
#[cfg(feature = "Win32_Graphics_Dxgi_Common")]
impl Default for D3D12_FEATURE_DATA_VIDEO_DECODER_HEAP_SIZE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Dxgi_Common")]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_FEATURE_DATA_VIDEO_DECODER_HEAP_SIZE1 {
    pub VideoDecoderHeapDesc: D3D12_VIDEO_DECODER_HEAP_DESC,
    pub Protected: super::super::Foundation::BOOL,
    pub MemoryPoolL0Size: u64,
    pub MemoryPoolL1Size: u64,
}
#[cfg(feature = "Win32_Graphics_Dxgi_Common")]
impl Default for D3D12_FEATURE_DATA_VIDEO_DECODER_HEAP_SIZE1 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Dxgi_Common")]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_FEATURE_DATA_VIDEO_DECODE_CONVERSION_SUPPORT {
    pub NodeIndex: u32,
    pub Configuration: D3D12_VIDEO_DECODE_CONFIGURATION,
    pub DecodeSample: D3D12_VIDEO_SAMPLE,
    pub OutputFormat: D3D12_VIDEO_FORMAT,
    pub FrameRate: super::super::Graphics::Dxgi::Common::DXGI_RATIONAL,
    pub BitRate: u32,
    pub SupportFlags: D3D12_VIDEO_DECODE_CONVERSION_SUPPORT_FLAGS,
    pub ScaleSupport: D3D12_VIDEO_SCALE_SUPPORT,
}
#[cfg(feature = "Win32_Graphics_Dxgi_Common")]
impl Default for D3D12_FEATURE_DATA_VIDEO_DECODE_CONVERSION_SUPPORT {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Dxgi_Common")]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_FEATURE_DATA_VIDEO_DECODE_FORMATS {
    pub NodeIndex: u32,
    pub Configuration: D3D12_VIDEO_DECODE_CONFIGURATION,
    pub FormatCount: u32,
    pub pOutputFormats: *mut super::super::Graphics::Dxgi::Common::DXGI_FORMAT,
}
#[cfg(feature = "Win32_Graphics_Dxgi_Common")]
impl Default for D3D12_FEATURE_DATA_VIDEO_DECODE_FORMATS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_FEATURE_DATA_VIDEO_DECODE_FORMAT_COUNT {
    pub NodeIndex: u32,
    pub Configuration: D3D12_VIDEO_DECODE_CONFIGURATION,
    pub FormatCount: u32,
}
impl Default for D3D12_FEATURE_DATA_VIDEO_DECODE_FORMAT_COUNT {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Dxgi_Common")]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_FEATURE_DATA_VIDEO_DECODE_HISTOGRAM {
    pub NodeIndex: u32,
    pub DecodeProfile: windows_core::GUID,
    pub Width: u32,
    pub Height: u32,
    pub DecodeFormat: super::super::Graphics::Dxgi::Common::DXGI_FORMAT,
    pub Components: D3D12_VIDEO_DECODE_HISTOGRAM_COMPONENT_FLAGS,
    pub BinCount: u32,
    pub CounterBitDepth: u32,
}
#[cfg(feature = "Win32_Graphics_Dxgi_Common")]
impl Default for D3D12_FEATURE_DATA_VIDEO_DECODE_HISTOGRAM {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_FEATURE_DATA_VIDEO_DECODE_PROFILES {
    pub NodeIndex: u32,
    pub ProfileCount: u32,
    pub pProfiles: *mut windows_core::GUID,
}
impl Default for D3D12_FEATURE_DATA_VIDEO_DECODE_PROFILES {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_FEATURE_DATA_VIDEO_DECODE_PROFILE_COUNT {
    pub NodeIndex: u32,
    pub ProfileCount: u32,
}
impl Default for D3D12_FEATURE_DATA_VIDEO_DECODE_PROFILE_COUNT {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_FEATURE_DATA_VIDEO_DECODE_PROTECTED_RESOURCES {
    pub NodeIndex: u32,
    pub Configuration: D3D12_VIDEO_DECODE_CONFIGURATION,
    pub SupportFlags: D3D12_VIDEO_PROTECTED_RESOURCE_SUPPORT_FLAGS,
}
impl Default for D3D12_FEATURE_DATA_VIDEO_DECODE_PROTECTED_RESOURCES {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Dxgi_Common")]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_FEATURE_DATA_VIDEO_DECODE_SUPPORT {
    pub NodeIndex: u32,
    pub Configuration: D3D12_VIDEO_DECODE_CONFIGURATION,
    pub Width: u32,
    pub Height: u32,
    pub DecodeFormat: super::super::Graphics::Dxgi::Common::DXGI_FORMAT,
    pub FrameRate: super::super::Graphics::Dxgi::Common::DXGI_RATIONAL,
    pub BitRate: u32,
    pub SupportFlags: D3D12_VIDEO_DECODE_SUPPORT_FLAGS,
    pub ConfigurationFlags: D3D12_VIDEO_DECODE_CONFIGURATION_FLAGS,
    pub DecodeTier: D3D12_VIDEO_DECODE_TIER,
}
#[cfg(feature = "Win32_Graphics_Dxgi_Common")]
impl Default for D3D12_FEATURE_DATA_VIDEO_DECODE_SUPPORT {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_FEATURE_DATA_VIDEO_ENCODER_CODEC {
    pub NodeIndex: u32,
    pub Codec: D3D12_VIDEO_ENCODER_CODEC,
    pub IsSupported: super::super::Foundation::BOOL,
}
impl Default for D3D12_FEATURE_DATA_VIDEO_ENCODER_CODEC {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub struct D3D12_FEATURE_DATA_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT {
    pub NodeIndex: u32,
    pub Codec: D3D12_VIDEO_ENCODER_CODEC,
    pub Profile: D3D12_VIDEO_ENCODER_PROFILE_DESC,
    pub IsSupported: super::super::Foundation::BOOL,
    pub CodecSupportLimits: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT,
}
impl Default for D3D12_FEATURE_DATA_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub struct D3D12_FEATURE_DATA_VIDEO_ENCODER_CODEC_PICTURE_CONTROL_SUPPORT {
    pub NodeIndex: u32,
    pub Codec: D3D12_VIDEO_ENCODER_CODEC,
    pub Profile: D3D12_VIDEO_ENCODER_PROFILE_DESC,
    pub IsSupported: super::super::Foundation::BOOL,
    pub PictureSupport: D3D12_VIDEO_ENCODER_CODEC_PICTURE_CONTROL_SUPPORT,
}
impl Default for D3D12_FEATURE_DATA_VIDEO_ENCODER_CODEC_PICTURE_CONTROL_SUPPORT {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub struct D3D12_FEATURE_DATA_VIDEO_ENCODER_FRAME_SUBREGION_LAYOUT_CONFIG {
    pub NodeIndex: u32,
    pub Codec: D3D12_VIDEO_ENCODER_CODEC,
    pub Profile: D3D12_VIDEO_ENCODER_PROFILE_DESC,
    pub Level: D3D12_VIDEO_ENCODER_LEVEL_SETTING,
    pub SubregionMode: D3D12_VIDEO_ENCODER_FRAME_SUBREGION_LAYOUT_MODE,
    pub FrameResolution: D3D12_VIDEO_ENCODER_PICTURE_RESOLUTION_DESC,
    pub CodecSupport: D3D12_VIDEO_ENCODER_FRAME_SUBREGION_LAYOUT_CONFIG_SUPPORT,
    pub IsSupported: super::super::Foundation::BOOL,
}
impl Default for D3D12_FEATURE_DATA_VIDEO_ENCODER_FRAME_SUBREGION_LAYOUT_CONFIG {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub struct D3D12_FEATURE_DATA_VIDEO_ENCODER_FRAME_SUBREGION_LAYOUT_MODE {
    pub NodeIndex: u32,
    pub Codec: D3D12_VIDEO_ENCODER_CODEC,
    pub Profile: D3D12_VIDEO_ENCODER_PROFILE_DESC,
    pub Level: D3D12_VIDEO_ENCODER_LEVEL_SETTING,
    pub SubregionMode: D3D12_VIDEO_ENCODER_FRAME_SUBREGION_LAYOUT_MODE,
    pub IsSupported: super::super::Foundation::BOOL,
}
impl Default for D3D12_FEATURE_DATA_VIDEO_ENCODER_FRAME_SUBREGION_LAYOUT_MODE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub struct D3D12_FEATURE_DATA_VIDEO_ENCODER_HEAP_SIZE {
    pub HeapDesc: D3D12_VIDEO_ENCODER_HEAP_DESC,
    pub IsSupported: super::super::Foundation::BOOL,
    pub MemoryPoolL0Size: u64,
    pub MemoryPoolL1Size: u64,
}
impl Default for D3D12_FEATURE_DATA_VIDEO_ENCODER_HEAP_SIZE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Dxgi_Common")]
#[derive(Clone, Copy)]
pub struct D3D12_FEATURE_DATA_VIDEO_ENCODER_INPUT_FORMAT {
    pub NodeIndex: u32,
    pub Codec: D3D12_VIDEO_ENCODER_CODEC,
    pub Profile: D3D12_VIDEO_ENCODER_PROFILE_DESC,
    pub Format: super::super::Graphics::Dxgi::Common::DXGI_FORMAT,
    pub IsSupported: super::super::Foundation::BOOL,
}
#[cfg(feature = "Win32_Graphics_Dxgi_Common")]
impl Default for D3D12_FEATURE_DATA_VIDEO_ENCODER_INPUT_FORMAT {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub struct D3D12_FEATURE_DATA_VIDEO_ENCODER_INTRA_REFRESH_MODE {
    pub NodeIndex: u32,
    pub Codec: D3D12_VIDEO_ENCODER_CODEC,
    pub Profile: D3D12_VIDEO_ENCODER_PROFILE_DESC,
    pub Level: D3D12_VIDEO_ENCODER_LEVEL_SETTING,
    pub IntraRefreshMode: D3D12_VIDEO_ENCODER_INTRA_REFRESH_MODE,
    pub IsSupported: super::super::Foundation::BOOL,
}
impl Default for D3D12_FEATURE_DATA_VIDEO_ENCODER_INTRA_REFRESH_MODE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_FEATURE_DATA_VIDEO_ENCODER_OUTPUT_RESOLUTION {
    pub NodeIndex: u32,
    pub Codec: D3D12_VIDEO_ENCODER_CODEC,
    pub ResolutionRatiosCount: u32,
    pub IsSupported: super::super::Foundation::BOOL,
    pub MinResolutionSupported: D3D12_VIDEO_ENCODER_PICTURE_RESOLUTION_DESC,
    pub MaxResolutionSupported: D3D12_VIDEO_ENCODER_PICTURE_RESOLUTION_DESC,
    pub ResolutionWidthMultipleRequirement: u32,
    pub ResolutionHeightMultipleRequirement: u32,
    pub pResolutionRatios: *mut D3D12_VIDEO_ENCODER_PICTURE_RESOLUTION_RATIO_DESC,
}
impl Default for D3D12_FEATURE_DATA_VIDEO_ENCODER_OUTPUT_RESOLUTION {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_FEATURE_DATA_VIDEO_ENCODER_OUTPUT_RESOLUTION_RATIOS_COUNT {
    pub NodeIndex: u32,
    pub Codec: D3D12_VIDEO_ENCODER_CODEC,
    pub ResolutionRatiosCount: u32,
}
impl Default for D3D12_FEATURE_DATA_VIDEO_ENCODER_OUTPUT_RESOLUTION_RATIOS_COUNT {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub struct D3D12_FEATURE_DATA_VIDEO_ENCODER_PROFILE_LEVEL {
    pub NodeIndex: u32,
    pub Codec: D3D12_VIDEO_ENCODER_CODEC,
    pub Profile: D3D12_VIDEO_ENCODER_PROFILE_DESC,
    pub IsSupported: super::super::Foundation::BOOL,
    pub MinSupportedLevel: D3D12_VIDEO_ENCODER_LEVEL_SETTING,
    pub MaxSupportedLevel: D3D12_VIDEO_ENCODER_LEVEL_SETTING,
}
impl Default for D3D12_FEATURE_DATA_VIDEO_ENCODER_PROFILE_LEVEL {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_FEATURE_DATA_VIDEO_ENCODER_RATE_CONTROL_MODE {
    pub NodeIndex: u32,
    pub Codec: D3D12_VIDEO_ENCODER_CODEC,
    pub RateControlMode: D3D12_VIDEO_ENCODER_RATE_CONTROL_MODE,
    pub IsSupported: super::super::Foundation::BOOL,
}
impl Default for D3D12_FEATURE_DATA_VIDEO_ENCODER_RATE_CONTROL_MODE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_FEATURE_DATA_VIDEO_ENCODER_RESOLUTION_SUPPORT_LIMITS {
    pub MaxSubregionsNumber: u32,
    pub MaxIntraRefreshFrameDuration: u32,
    pub SubregionBlockPixelsSize: u32,
    pub QPMapRegionPixelsSize: u32,
}
impl Default for D3D12_FEATURE_DATA_VIDEO_ENCODER_RESOLUTION_SUPPORT_LIMITS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Dxgi_Common")]
#[derive(Clone, Copy)]
pub struct D3D12_FEATURE_DATA_VIDEO_ENCODER_RESOURCE_REQUIREMENTS {
    pub NodeIndex: u32,
    pub Codec: D3D12_VIDEO_ENCODER_CODEC,
    pub Profile: D3D12_VIDEO_ENCODER_PROFILE_DESC,
    pub InputFormat: super::super::Graphics::Dxgi::Common::DXGI_FORMAT,
    pub PictureTargetResolution: D3D12_VIDEO_ENCODER_PICTURE_RESOLUTION_DESC,
    pub IsSupported: super::super::Foundation::BOOL,
    pub CompressedBitstreamBufferAccessAlignment: u32,
    pub EncoderMetadataBufferAccessAlignment: u32,
    pub MaxEncoderOutputMetadataBufferSize: u32,
}
#[cfg(feature = "Win32_Graphics_Dxgi_Common")]
impl Default for D3D12_FEATURE_DATA_VIDEO_ENCODER_RESOURCE_REQUIREMENTS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Dxgi_Common")]
#[derive(Clone, Copy)]
pub struct D3D12_FEATURE_DATA_VIDEO_ENCODER_SUPPORT {
    pub NodeIndex: u32,
    pub Codec: D3D12_VIDEO_ENCODER_CODEC,
    pub InputFormat: super::super::Graphics::Dxgi::Common::DXGI_FORMAT,
    pub CodecConfiguration: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION,
    pub CodecGopSequence: D3D12_VIDEO_ENCODER_SEQUENCE_GOP_STRUCTURE,
    pub RateControl: D3D12_VIDEO_ENCODER_RATE_CONTROL,
    pub IntraRefresh: D3D12_VIDEO_ENCODER_INTRA_REFRESH_MODE,
    pub SubregionFrameEncoding: D3D12_VIDEO_ENCODER_FRAME_SUBREGION_LAYOUT_MODE,
    pub ResolutionsListCount: u32,
    pub pResolutionList: *const D3D12_VIDEO_ENCODER_PICTURE_RESOLUTION_DESC,
    pub MaxReferenceFramesInDPB: u32,
    pub ValidationFlags: D3D12_VIDEO_ENCODER_VALIDATION_FLAGS,
    pub SupportFlags: D3D12_VIDEO_ENCODER_SUPPORT_FLAGS,
    pub SuggestedProfile: D3D12_VIDEO_ENCODER_PROFILE_DESC,
    pub SuggestedLevel: D3D12_VIDEO_ENCODER_LEVEL_SETTING,
    pub pResolutionDependentSupport: *mut D3D12_FEATURE_DATA_VIDEO_ENCODER_RESOLUTION_SUPPORT_LIMITS,
}
#[cfg(feature = "Win32_Graphics_Dxgi_Common")]
impl Default for D3D12_FEATURE_DATA_VIDEO_ENCODER_SUPPORT {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Dxgi_Common")]
#[derive(Clone, Copy)]
pub struct D3D12_FEATURE_DATA_VIDEO_ENCODER_SUPPORT1 {
    pub NodeIndex: u32,
    pub Codec: D3D12_VIDEO_ENCODER_CODEC,
    pub InputFormat: super::super::Graphics::Dxgi::Common::DXGI_FORMAT,
    pub CodecConfiguration: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION,
    pub CodecGopSequence: D3D12_VIDEO_ENCODER_SEQUENCE_GOP_STRUCTURE,
    pub RateControl: D3D12_VIDEO_ENCODER_RATE_CONTROL,
    pub IntraRefresh: D3D12_VIDEO_ENCODER_INTRA_REFRESH_MODE,
    pub SubregionFrameEncoding: D3D12_VIDEO_ENCODER_FRAME_SUBREGION_LAYOUT_MODE,
    pub ResolutionsListCount: u32,
    pub pResolutionList: *const D3D12_VIDEO_ENCODER_PICTURE_RESOLUTION_DESC,
    pub MaxReferenceFramesInDPB: u32,
    pub ValidationFlags: D3D12_VIDEO_ENCODER_VALIDATION_FLAGS,
    pub SupportFlags: D3D12_VIDEO_ENCODER_SUPPORT_FLAGS,
    pub SuggestedProfile: D3D12_VIDEO_ENCODER_PROFILE_DESC,
    pub SuggestedLevel: D3D12_VIDEO_ENCODER_LEVEL_SETTING,
    pub pResolutionDependentSupport: *mut D3D12_FEATURE_DATA_VIDEO_ENCODER_RESOLUTION_SUPPORT_LIMITS,
    pub SubregionFrameEncodingData: D3D12_VIDEO_ENCODER_PICTURE_CONTROL_SUBREGIONS_LAYOUT_DATA,
    pub MaxQualityVsSpeed: u32,
}
#[cfg(feature = "Win32_Graphics_Dxgi_Common")]
impl Default for D3D12_FEATURE_DATA_VIDEO_ENCODER_SUPPORT1 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Direct3D12")]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_FEATURE_DATA_VIDEO_EXTENSION_COMMANDS {
    pub NodeIndex: u32,
    pub CommandCount: u32,
    pub pCommandInfos: *mut D3D12_VIDEO_EXTENSION_COMMAND_INFO,
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
impl Default for D3D12_FEATURE_DATA_VIDEO_EXTENSION_COMMANDS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_FEATURE_DATA_VIDEO_EXTENSION_COMMAND_COUNT {
    pub NodeIndex: u32,
    pub CommandCount: u32,
}
impl Default for D3D12_FEATURE_DATA_VIDEO_EXTENSION_COMMAND_COUNT {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_FEATURE_DATA_VIDEO_EXTENSION_COMMAND_PARAMETERS {
    pub CommandId: windows_core::GUID,
    pub Stage: D3D12_VIDEO_EXTENSION_COMMAND_PARAMETER_STAGE,
    pub ParameterCount: u32,
    pub pParameterInfos: *mut D3D12_VIDEO_EXTENSION_COMMAND_PARAMETER_INFO,
}
impl Default for D3D12_FEATURE_DATA_VIDEO_EXTENSION_COMMAND_PARAMETERS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_FEATURE_DATA_VIDEO_EXTENSION_COMMAND_PARAMETER_COUNT {
    pub CommandId: windows_core::GUID,
    pub Stage: D3D12_VIDEO_EXTENSION_COMMAND_PARAMETER_STAGE,
    pub ParameterCount: u32,
    pub ParameterPacking: u32,
}
impl Default for D3D12_FEATURE_DATA_VIDEO_EXTENSION_COMMAND_PARAMETER_COUNT {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_FEATURE_DATA_VIDEO_EXTENSION_COMMAND_SIZE {
    pub NodeIndex: u32,
    pub CommandId: windows_core::GUID,
    pub pCreationParameters: *const core::ffi::c_void,
    pub CreationParametersSizeInBytes: usize,
    pub MemoryPoolL0Size: u64,
    pub MemoryPoolL1Size: u64,
}
impl Default for D3D12_FEATURE_DATA_VIDEO_EXTENSION_COMMAND_SIZE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_FEATURE_DATA_VIDEO_EXTENSION_COMMAND_SUPPORT {
    pub NodeIndex: u32,
    pub CommandId: windows_core::GUID,
    pub pInputData: *const core::ffi::c_void,
    pub InputDataSizeInBytes: usize,
    pub pOutputData: *mut core::ffi::c_void,
    pub OutputDataSizeInBytes: usize,
}
impl Default for D3D12_FEATURE_DATA_VIDEO_EXTENSION_COMMAND_SUPPORT {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_FEATURE_DATA_VIDEO_FEATURE_AREA_SUPPORT {
    pub NodeIndex: u32,
    pub VideoDecodeSupport: super::super::Foundation::BOOL,
    pub VideoProcessSupport: super::super::Foundation::BOOL,
    pub VideoEncodeSupport: super::super::Foundation::BOOL,
}
impl Default for D3D12_FEATURE_DATA_VIDEO_FEATURE_AREA_SUPPORT {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Dxgi_Common")]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_FEATURE_DATA_VIDEO_MOTION_ESTIMATOR {
    pub NodeIndex: u32,
    pub InputFormat: super::super::Graphics::Dxgi::Common::DXGI_FORMAT,
    pub BlockSizeFlags: D3D12_VIDEO_MOTION_ESTIMATOR_SEARCH_BLOCK_SIZE_FLAGS,
    pub PrecisionFlags: D3D12_VIDEO_MOTION_ESTIMATOR_VECTOR_PRECISION_FLAGS,
    pub SizeRange: D3D12_VIDEO_SIZE_RANGE,
}
#[cfg(feature = "Win32_Graphics_Dxgi_Common")]
impl Default for D3D12_FEATURE_DATA_VIDEO_MOTION_ESTIMATOR {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_FEATURE_DATA_VIDEO_MOTION_ESTIMATOR_PROTECTED_RESOURCES {
    pub NodeIndex: u32,
    pub SupportFlags: D3D12_VIDEO_PROTECTED_RESOURCE_SUPPORT_FLAGS,
}
impl Default for D3D12_FEATURE_DATA_VIDEO_MOTION_ESTIMATOR_PROTECTED_RESOURCES {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Dxgi_Common")]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_FEATURE_DATA_VIDEO_MOTION_ESTIMATOR_SIZE {
    pub NodeIndex: u32,
    pub InputFormat: super::super::Graphics::Dxgi::Common::DXGI_FORMAT,
    pub BlockSize: D3D12_VIDEO_MOTION_ESTIMATOR_SEARCH_BLOCK_SIZE,
    pub Precision: D3D12_VIDEO_MOTION_ESTIMATOR_VECTOR_PRECISION,
    pub SizeRange: D3D12_VIDEO_SIZE_RANGE,
    pub Protected: super::super::Foundation::BOOL,
    pub MotionVectorHeapMemoryPoolL0Size: u64,
    pub MotionVectorHeapMemoryPoolL1Size: u64,
    pub MotionEstimatorMemoryPoolL0Size: u64,
    pub MotionEstimatorMemoryPoolL1Size: u64,
}
#[cfg(feature = "Win32_Graphics_Dxgi_Common")]
impl Default for D3D12_FEATURE_DATA_VIDEO_MOTION_ESTIMATOR_SIZE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Dxgi_Common")]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_FEATURE_DATA_VIDEO_PROCESSOR_SIZE {
    pub NodeMask: u32,
    pub pOutputStreamDesc: *const D3D12_VIDEO_PROCESS_OUTPUT_STREAM_DESC,
    pub NumInputStreamDescs: u32,
    pub pInputStreamDescs: *const D3D12_VIDEO_PROCESS_INPUT_STREAM_DESC,
    pub MemoryPoolL0Size: u64,
    pub MemoryPoolL1Size: u64,
}
#[cfg(feature = "Win32_Graphics_Dxgi_Common")]
impl Default for D3D12_FEATURE_DATA_VIDEO_PROCESSOR_SIZE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Dxgi_Common")]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_FEATURE_DATA_VIDEO_PROCESSOR_SIZE1 {
    pub NodeMask: u32,
    pub pOutputStreamDesc: *const D3D12_VIDEO_PROCESS_OUTPUT_STREAM_DESC,
    pub NumInputStreamDescs: u32,
    pub pInputStreamDescs: *const D3D12_VIDEO_PROCESS_INPUT_STREAM_DESC,
    pub Protected: super::super::Foundation::BOOL,
    pub MemoryPoolL0Size: u64,
    pub MemoryPoolL1Size: u64,
}
#[cfg(feature = "Win32_Graphics_Dxgi_Common")]
impl Default for D3D12_FEATURE_DATA_VIDEO_PROCESSOR_SIZE1 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_FEATURE_DATA_VIDEO_PROCESS_MAX_INPUT_STREAMS {
    pub NodeIndex: u32,
    pub MaxInputStreams: u32,
}
impl Default for D3D12_FEATURE_DATA_VIDEO_PROCESS_MAX_INPUT_STREAMS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_FEATURE_DATA_VIDEO_PROCESS_PROTECTED_RESOURCES {
    pub NodeIndex: u32,
    pub SupportFlags: D3D12_VIDEO_PROTECTED_RESOURCE_SUPPORT_FLAGS,
}
impl Default for D3D12_FEATURE_DATA_VIDEO_PROCESS_PROTECTED_RESOURCES {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Dxgi_Common")]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_FEATURE_DATA_VIDEO_PROCESS_REFERENCE_INFO {
    pub NodeIndex: u32,
    pub DeinterlaceMode: D3D12_VIDEO_PROCESS_DEINTERLACE_FLAGS,
    pub Filters: D3D12_VIDEO_PROCESS_FILTER_FLAGS,
    pub FeatureSupport: D3D12_VIDEO_PROCESS_FEATURE_FLAGS,
    pub InputFrameRate: super::super::Graphics::Dxgi::Common::DXGI_RATIONAL,
    pub OutputFrameRate: super::super::Graphics::Dxgi::Common::DXGI_RATIONAL,
    pub EnableAutoProcessing: super::super::Foundation::BOOL,
    pub PastFrames: u32,
    pub FutureFrames: u32,
}
#[cfg(feature = "Win32_Graphics_Dxgi_Common")]
impl Default for D3D12_FEATURE_DATA_VIDEO_PROCESS_REFERENCE_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Dxgi_Common")]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_FEATURE_DATA_VIDEO_PROCESS_SUPPORT {
    pub NodeIndex: u32,
    pub InputSample: D3D12_VIDEO_SAMPLE,
    pub InputFieldType: D3D12_VIDEO_FIELD_TYPE,
    pub InputStereoFormat: D3D12_VIDEO_FRAME_STEREO_FORMAT,
    pub InputFrameRate: super::super::Graphics::Dxgi::Common::DXGI_RATIONAL,
    pub OutputFormat: D3D12_VIDEO_FORMAT,
    pub OutputStereoFormat: D3D12_VIDEO_FRAME_STEREO_FORMAT,
    pub OutputFrameRate: super::super::Graphics::Dxgi::Common::DXGI_RATIONAL,
    pub SupportFlags: D3D12_VIDEO_PROCESS_SUPPORT_FLAGS,
    pub ScaleSupport: D3D12_VIDEO_SCALE_SUPPORT,
    pub FeatureSupport: D3D12_VIDEO_PROCESS_FEATURE_FLAGS,
    pub DeinterlaceSupport: D3D12_VIDEO_PROCESS_DEINTERLACE_FLAGS,
    pub AutoProcessingSupport: D3D12_VIDEO_PROCESS_AUTO_PROCESSING_FLAGS,
    pub FilterSupport: D3D12_VIDEO_PROCESS_FILTER_FLAGS,
    pub FilterRangeSupport: [D3D12_VIDEO_PROCESS_FILTER_RANGE; 32],
}
#[cfg(feature = "Win32_Graphics_Dxgi_Common")]
impl Default for D3D12_FEATURE_DATA_VIDEO_PROCESS_SUPPORT {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct D3D12_FEATURE_VIDEO(pub i32);
pub const D3D12_FEATURE_VIDEO_ARCHITECTURE: D3D12_FEATURE_VIDEO = D3D12_FEATURE_VIDEO(17i32);
pub const D3D12_FEATURE_VIDEO_DECODER_HEAP_SIZE: D3D12_FEATURE_VIDEO = D3D12_FEATURE_VIDEO(8i32);
pub const D3D12_FEATURE_VIDEO_DECODER_HEAP_SIZE1: D3D12_FEATURE_VIDEO = D3D12_FEATURE_VIDEO(31i32);
pub const D3D12_FEATURE_VIDEO_DECODE_CONVERSION_SUPPORT: D3D12_FEATURE_VIDEO = D3D12_FEATURE_VIDEO(3i32);
pub const D3D12_FEATURE_VIDEO_DECODE_FORMATS: D3D12_FEATURE_VIDEO = D3D12_FEATURE_VIDEO(2i32);
pub const D3D12_FEATURE_VIDEO_DECODE_FORMAT_COUNT: D3D12_FEATURE_VIDEO = D3D12_FEATURE_VIDEO(11i32);
pub const D3D12_FEATURE_VIDEO_DECODE_HISTOGRAM: D3D12_FEATURE_VIDEO = D3D12_FEATURE_VIDEO(18i32);
pub const D3D12_FEATURE_VIDEO_DECODE_PROFILES: D3D12_FEATURE_VIDEO = D3D12_FEATURE_VIDEO(1i32);
pub const D3D12_FEATURE_VIDEO_DECODE_PROFILE_COUNT: D3D12_FEATURE_VIDEO = D3D12_FEATURE_VIDEO(10i32);
pub const D3D12_FEATURE_VIDEO_DECODE_PROTECTED_RESOURCES: D3D12_FEATURE_VIDEO = D3D12_FEATURE_VIDEO(28i32);
pub const D3D12_FEATURE_VIDEO_DECODE_SUPPORT: D3D12_FEATURE_VIDEO = D3D12_FEATURE_VIDEO(0i32);
pub const D3D12_FEATURE_VIDEO_ENCODER_CODEC: D3D12_FEATURE_VIDEO = D3D12_FEATURE_VIDEO(33i32);
pub const D3D12_FEATURE_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT: D3D12_FEATURE_VIDEO = D3D12_FEATURE_VIDEO(42i32);
pub const D3D12_FEATURE_VIDEO_ENCODER_CODEC_PICTURE_CONTROL_SUPPORT: D3D12_FEATURE_VIDEO = D3D12_FEATURE_VIDEO(44i32);
pub const D3D12_FEATURE_VIDEO_ENCODER_FRAME_SUBREGION_LAYOUT_CONFIG: D3D12_FEATURE_VIDEO = D3D12_FEATURE_VIDEO(46i32);
pub const D3D12_FEATURE_VIDEO_ENCODER_FRAME_SUBREGION_LAYOUT_MODE: D3D12_FEATURE_VIDEO = D3D12_FEATURE_VIDEO(40i32);
pub const D3D12_FEATURE_VIDEO_ENCODER_HEAP_SIZE: D3D12_FEATURE_VIDEO = D3D12_FEATURE_VIDEO(41i32);
pub const D3D12_FEATURE_VIDEO_ENCODER_INPUT_FORMAT: D3D12_FEATURE_VIDEO = D3D12_FEATURE_VIDEO(37i32);
pub const D3D12_FEATURE_VIDEO_ENCODER_INTRA_REFRESH_MODE: D3D12_FEATURE_VIDEO = D3D12_FEATURE_VIDEO(39i32);
pub const D3D12_FEATURE_VIDEO_ENCODER_OUTPUT_RESOLUTION: D3D12_FEATURE_VIDEO = D3D12_FEATURE_VIDEO(36i32);
pub const D3D12_FEATURE_VIDEO_ENCODER_OUTPUT_RESOLUTION_RATIOS_COUNT: D3D12_FEATURE_VIDEO = D3D12_FEATURE_VIDEO(35i32);
pub const D3D12_FEATURE_VIDEO_ENCODER_PROFILE_LEVEL: D3D12_FEATURE_VIDEO = D3D12_FEATURE_VIDEO(34i32);
pub const D3D12_FEATURE_VIDEO_ENCODER_RATE_CONTROL_MODE: D3D12_FEATURE_VIDEO = D3D12_FEATURE_VIDEO(38i32);
pub const D3D12_FEATURE_VIDEO_ENCODER_RESOURCE_REQUIREMENTS: D3D12_FEATURE_VIDEO = D3D12_FEATURE_VIDEO(45i32);
pub const D3D12_FEATURE_VIDEO_ENCODER_SUPPORT: D3D12_FEATURE_VIDEO = D3D12_FEATURE_VIDEO(43i32);
pub const D3D12_FEATURE_VIDEO_ENCODER_SUPPORT1: D3D12_FEATURE_VIDEO = D3D12_FEATURE_VIDEO(47i32);
pub const D3D12_FEATURE_VIDEO_EXTENSION_COMMANDS: D3D12_FEATURE_VIDEO = D3D12_FEATURE_VIDEO(23i32);
pub const D3D12_FEATURE_VIDEO_EXTENSION_COMMAND_COUNT: D3D12_FEATURE_VIDEO = D3D12_FEATURE_VIDEO(22i32);
pub const D3D12_FEATURE_VIDEO_EXTENSION_COMMAND_PARAMETERS: D3D12_FEATURE_VIDEO = D3D12_FEATURE_VIDEO(25i32);
pub const D3D12_FEATURE_VIDEO_EXTENSION_COMMAND_PARAMETER_COUNT: D3D12_FEATURE_VIDEO = D3D12_FEATURE_VIDEO(24i32);
pub const D3D12_FEATURE_VIDEO_EXTENSION_COMMAND_SIZE: D3D12_FEATURE_VIDEO = D3D12_FEATURE_VIDEO(27i32);
pub const D3D12_FEATURE_VIDEO_EXTENSION_COMMAND_SUPPORT: D3D12_FEATURE_VIDEO = D3D12_FEATURE_VIDEO(26i32);
pub const D3D12_FEATURE_VIDEO_FEATURE_AREA_SUPPORT: D3D12_FEATURE_VIDEO = D3D12_FEATURE_VIDEO(19i32);
pub const D3D12_FEATURE_VIDEO_MOTION_ESTIMATOR: D3D12_FEATURE_VIDEO = D3D12_FEATURE_VIDEO(20i32);
pub const D3D12_FEATURE_VIDEO_MOTION_ESTIMATOR_PROTECTED_RESOURCES: D3D12_FEATURE_VIDEO = D3D12_FEATURE_VIDEO(30i32);
pub const D3D12_FEATURE_VIDEO_MOTION_ESTIMATOR_SIZE: D3D12_FEATURE_VIDEO = D3D12_FEATURE_VIDEO(21i32);
pub const D3D12_FEATURE_VIDEO_PROCESSOR_SIZE: D3D12_FEATURE_VIDEO = D3D12_FEATURE_VIDEO(9i32);
pub const D3D12_FEATURE_VIDEO_PROCESSOR_SIZE1: D3D12_FEATURE_VIDEO = D3D12_FEATURE_VIDEO(32i32);
pub const D3D12_FEATURE_VIDEO_PROCESS_MAX_INPUT_STREAMS: D3D12_FEATURE_VIDEO = D3D12_FEATURE_VIDEO(6i32);
pub const D3D12_FEATURE_VIDEO_PROCESS_PROTECTED_RESOURCES: D3D12_FEATURE_VIDEO = D3D12_FEATURE_VIDEO(29i32);
pub const D3D12_FEATURE_VIDEO_PROCESS_REFERENCE_INFO: D3D12_FEATURE_VIDEO = D3D12_FEATURE_VIDEO(7i32);
pub const D3D12_FEATURE_VIDEO_PROCESS_SUPPORT: D3D12_FEATURE_VIDEO = D3D12_FEATURE_VIDEO(5i32);
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Dxgi_Common")]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_QUERY_DATA_VIDEO_DECODE_STATISTICS {
    pub Status: u64,
    pub NumMacroblocksAffected: u64,
    pub FrameRate: super::super::Graphics::Dxgi::Common::DXGI_RATIONAL,
    pub BitRate: u32,
}
#[cfg(feature = "Win32_Graphics_Dxgi_Common")]
impl Default for D3D12_QUERY_DATA_VIDEO_DECODE_STATISTICS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Direct3D12")]
#[derive(Clone, Debug, PartialEq)]
pub struct D3D12_RESOLVE_VIDEO_MOTION_VECTOR_HEAP_INPUT {
    pub pMotionVectorHeap: core::mem::ManuallyDrop<Option<ID3D12VideoMotionVectorHeap>>,
    pub PixelWidth: u32,
    pub PixelHeight: u32,
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
impl Default for D3D12_RESOLVE_VIDEO_MOTION_VECTOR_HEAP_INPUT {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Direct3D12")]
#[derive(Clone, Debug, PartialEq)]
pub struct D3D12_RESOLVE_VIDEO_MOTION_VECTOR_HEAP_OUTPUT {
    pub pMotionVectorTexture2D: core::mem::ManuallyDrop<Option<super::super::Graphics::Direct3D12::ID3D12Resource>>,
    pub MotionVectorCoordinate: D3D12_RESOURCE_COORDINATE,
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
impl Default for D3D12_RESOLVE_VIDEO_MOTION_VECTOR_HEAP_OUTPUT {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_RESOURCE_COORDINATE {
    pub X: u64,
    pub Y: u32,
    pub Z: u32,
    pub SubresourceIndex: u32,
}
impl Default for D3D12_RESOURCE_COORDINATE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_VIDEO_DECODER_DESC {
    pub NodeMask: u32,
    pub Configuration: D3D12_VIDEO_DECODE_CONFIGURATION,
}
impl Default for D3D12_VIDEO_DECODER_DESC {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Dxgi_Common")]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_VIDEO_DECODER_HEAP_DESC {
    pub NodeMask: u32,
    pub Configuration: D3D12_VIDEO_DECODE_CONFIGURATION,
    pub DecodeWidth: u32,
    pub DecodeHeight: u32,
    pub Format: super::super::Graphics::Dxgi::Common::DXGI_FORMAT,
    pub FrameRate: super::super::Graphics::Dxgi::Common::DXGI_RATIONAL,
    pub BitRate: u32,
    pub MaxDecodePictureBufferCount: u32,
}
#[cfg(feature = "Win32_Graphics_Dxgi_Common")]
impl Default for D3D12_VIDEO_DECODER_HEAP_DESC {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct D3D12_VIDEO_DECODE_ARGUMENT_TYPE(pub i32);
pub const D3D12_VIDEO_DECODE_ARGUMENT_TYPE_HUFFMAN_TABLE: D3D12_VIDEO_DECODE_ARGUMENT_TYPE = D3D12_VIDEO_DECODE_ARGUMENT_TYPE(3i32);
pub const D3D12_VIDEO_DECODE_ARGUMENT_TYPE_INVERSE_QUANTIZATION_MATRIX: D3D12_VIDEO_DECODE_ARGUMENT_TYPE = D3D12_VIDEO_DECODE_ARGUMENT_TYPE(1i32);
pub const D3D12_VIDEO_DECODE_ARGUMENT_TYPE_PICTURE_PARAMETERS: D3D12_VIDEO_DECODE_ARGUMENT_TYPE = D3D12_VIDEO_DECODE_ARGUMENT_TYPE(0i32);
pub const D3D12_VIDEO_DECODE_ARGUMENT_TYPE_SLICE_CONTROL: D3D12_VIDEO_DECODE_ARGUMENT_TYPE = D3D12_VIDEO_DECODE_ARGUMENT_TYPE(2i32);
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Direct3D12")]
#[derive(Clone, Debug, PartialEq)]
pub struct D3D12_VIDEO_DECODE_COMPRESSED_BITSTREAM {
    pub pBuffer: core::mem::ManuallyDrop<Option<super::super::Graphics::Direct3D12::ID3D12Resource>>,
    pub Offset: u64,
    pub Size: u64,
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
impl Default for D3D12_VIDEO_DECODE_COMPRESSED_BITSTREAM {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_VIDEO_DECODE_CONFIGURATION {
    pub DecodeProfile: windows_core::GUID,
    pub BitstreamEncryption: D3D12_BITSTREAM_ENCRYPTION_TYPE,
    pub InterlaceType: D3D12_VIDEO_FRAME_CODED_INTERLACE_TYPE,
}
impl Default for D3D12_VIDEO_DECODE_CONFIGURATION {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct D3D12_VIDEO_DECODE_CONFIGURATION_FLAGS(pub i32);
impl D3D12_VIDEO_DECODE_CONFIGURATION_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for D3D12_VIDEO_DECODE_CONFIGURATION_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for D3D12_VIDEO_DECODE_CONFIGURATION_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for D3D12_VIDEO_DECODE_CONFIGURATION_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for D3D12_VIDEO_DECODE_CONFIGURATION_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for D3D12_VIDEO_DECODE_CONFIGURATION_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
pub const D3D12_VIDEO_DECODE_CONFIGURATION_FLAG_ALLOW_RESOLUTION_CHANGE_ON_NON_KEY_FRAME: D3D12_VIDEO_DECODE_CONFIGURATION_FLAGS = D3D12_VIDEO_DECODE_CONFIGURATION_FLAGS(8i32);
pub const D3D12_VIDEO_DECODE_CONFIGURATION_FLAG_HEIGHT_ALIGNMENT_MULTIPLE_32_REQUIRED: D3D12_VIDEO_DECODE_CONFIGURATION_FLAGS = D3D12_VIDEO_DECODE_CONFIGURATION_FLAGS(1i32);
pub const D3D12_VIDEO_DECODE_CONFIGURATION_FLAG_NONE: D3D12_VIDEO_DECODE_CONFIGURATION_FLAGS = D3D12_VIDEO_DECODE_CONFIGURATION_FLAGS(0i32);
pub const D3D12_VIDEO_DECODE_CONFIGURATION_FLAG_POST_PROCESSING_SUPPORTED: D3D12_VIDEO_DECODE_CONFIGURATION_FLAGS = D3D12_VIDEO_DECODE_CONFIGURATION_FLAGS(2i32);
pub const D3D12_VIDEO_DECODE_CONFIGURATION_FLAG_REFERENCE_ONLY_ALLOCATIONS_REQUIRED: D3D12_VIDEO_DECODE_CONFIGURATION_FLAGS = D3D12_VIDEO_DECODE_CONFIGURATION_FLAGS(4i32);
#[repr(C)]
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
#[derive(Clone, Debug, PartialEq)]
pub struct D3D12_VIDEO_DECODE_CONVERSION_ARGUMENTS {
    pub Enable: super::super::Foundation::BOOL,
    pub pReferenceTexture2D: core::mem::ManuallyDrop<Option<super::super::Graphics::Direct3D12::ID3D12Resource>>,
    pub ReferenceSubresource: u32,
    pub OutputColorSpace: super::super::Graphics::Dxgi::Common::DXGI_COLOR_SPACE_TYPE,
    pub DecodeColorSpace: super::super::Graphics::Dxgi::Common::DXGI_COLOR_SPACE_TYPE,
}
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
impl Default for D3D12_VIDEO_DECODE_CONVERSION_ARGUMENTS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
#[derive(Clone, Debug, PartialEq)]
pub struct D3D12_VIDEO_DECODE_CONVERSION_ARGUMENTS1 {
    pub Enable: super::super::Foundation::BOOL,
    pub pReferenceTexture2D: core::mem::ManuallyDrop<Option<super::super::Graphics::Direct3D12::ID3D12Resource>>,
    pub ReferenceSubresource: u32,
    pub OutputColorSpace: super::super::Graphics::Dxgi::Common::DXGI_COLOR_SPACE_TYPE,
    pub DecodeColorSpace: super::super::Graphics::Dxgi::Common::DXGI_COLOR_SPACE_TYPE,
    pub OutputWidth: u32,
    pub OutputHeight: u32,
}
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
impl Default for D3D12_VIDEO_DECODE_CONVERSION_ARGUMENTS1 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct D3D12_VIDEO_DECODE_CONVERSION_SUPPORT_FLAGS(pub i32);
impl D3D12_VIDEO_DECODE_CONVERSION_SUPPORT_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for D3D12_VIDEO_DECODE_CONVERSION_SUPPORT_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for D3D12_VIDEO_DECODE_CONVERSION_SUPPORT_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for D3D12_VIDEO_DECODE_CONVERSION_SUPPORT_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for D3D12_VIDEO_DECODE_CONVERSION_SUPPORT_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for D3D12_VIDEO_DECODE_CONVERSION_SUPPORT_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
pub const D3D12_VIDEO_DECODE_CONVERSION_SUPPORT_FLAG_NONE: D3D12_VIDEO_DECODE_CONVERSION_SUPPORT_FLAGS = D3D12_VIDEO_DECODE_CONVERSION_SUPPORT_FLAGS(0i32);
pub const D3D12_VIDEO_DECODE_CONVERSION_SUPPORT_FLAG_SUPPORTED: D3D12_VIDEO_DECODE_CONVERSION_SUPPORT_FLAGS = D3D12_VIDEO_DECODE_CONVERSION_SUPPORT_FLAGS(1i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_VIDEO_DECODE_FRAME_ARGUMENT {
    pub Type: D3D12_VIDEO_DECODE_ARGUMENT_TYPE,
    pub Size: u32,
    pub pData: *mut core::ffi::c_void,
}
impl Default for D3D12_VIDEO_DECODE_FRAME_ARGUMENT {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct D3D12_VIDEO_DECODE_HISTOGRAM_COMPONENT(pub i32);
pub const D3D12_VIDEO_DECODE_HISTOGRAM_COMPONENT_A: D3D12_VIDEO_DECODE_HISTOGRAM_COMPONENT = D3D12_VIDEO_DECODE_HISTOGRAM_COMPONENT(3i32);
pub const D3D12_VIDEO_DECODE_HISTOGRAM_COMPONENT_B: D3D12_VIDEO_DECODE_HISTOGRAM_COMPONENT = D3D12_VIDEO_DECODE_HISTOGRAM_COMPONENT(2i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct D3D12_VIDEO_DECODE_HISTOGRAM_COMPONENT_FLAGS(pub i32);
impl D3D12_VIDEO_DECODE_HISTOGRAM_COMPONENT_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for D3D12_VIDEO_DECODE_HISTOGRAM_COMPONENT_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for D3D12_VIDEO_DECODE_HISTOGRAM_COMPONENT_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for D3D12_VIDEO_DECODE_HISTOGRAM_COMPONENT_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for D3D12_VIDEO_DECODE_HISTOGRAM_COMPONENT_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for D3D12_VIDEO_DECODE_HISTOGRAM_COMPONENT_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
pub const D3D12_VIDEO_DECODE_HISTOGRAM_COMPONENT_FLAG_A: D3D12_VIDEO_DECODE_HISTOGRAM_COMPONENT_FLAGS = D3D12_VIDEO_DECODE_HISTOGRAM_COMPONENT_FLAGS(8i32);
pub const D3D12_VIDEO_DECODE_HISTOGRAM_COMPONENT_FLAG_B: D3D12_VIDEO_DECODE_HISTOGRAM_COMPONENT_FLAGS = D3D12_VIDEO_DECODE_HISTOGRAM_COMPONENT_FLAGS(4i32);
pub const D3D12_VIDEO_DECODE_HISTOGRAM_COMPONENT_FLAG_G: D3D12_VIDEO_DECODE_HISTOGRAM_COMPONENT_FLAGS = D3D12_VIDEO_DECODE_HISTOGRAM_COMPONENT_FLAGS(2i32);
pub const D3D12_VIDEO_DECODE_HISTOGRAM_COMPONENT_FLAG_NONE: D3D12_VIDEO_DECODE_HISTOGRAM_COMPONENT_FLAGS = D3D12_VIDEO_DECODE_HISTOGRAM_COMPONENT_FLAGS(0i32);
pub const D3D12_VIDEO_DECODE_HISTOGRAM_COMPONENT_FLAG_R: D3D12_VIDEO_DECODE_HISTOGRAM_COMPONENT_FLAGS = D3D12_VIDEO_DECODE_HISTOGRAM_COMPONENT_FLAGS(1i32);
pub const D3D12_VIDEO_DECODE_HISTOGRAM_COMPONENT_FLAG_U: D3D12_VIDEO_DECODE_HISTOGRAM_COMPONENT_FLAGS = D3D12_VIDEO_DECODE_HISTOGRAM_COMPONENT_FLAGS(2i32);
pub const D3D12_VIDEO_DECODE_HISTOGRAM_COMPONENT_FLAG_V: D3D12_VIDEO_DECODE_HISTOGRAM_COMPONENT_FLAGS = D3D12_VIDEO_DECODE_HISTOGRAM_COMPONENT_FLAGS(4i32);
pub const D3D12_VIDEO_DECODE_HISTOGRAM_COMPONENT_FLAG_Y: D3D12_VIDEO_DECODE_HISTOGRAM_COMPONENT_FLAGS = D3D12_VIDEO_DECODE_HISTOGRAM_COMPONENT_FLAGS(1i32);
pub const D3D12_VIDEO_DECODE_HISTOGRAM_COMPONENT_G: D3D12_VIDEO_DECODE_HISTOGRAM_COMPONENT = D3D12_VIDEO_DECODE_HISTOGRAM_COMPONENT(1i32);
pub const D3D12_VIDEO_DECODE_HISTOGRAM_COMPONENT_R: D3D12_VIDEO_DECODE_HISTOGRAM_COMPONENT = D3D12_VIDEO_DECODE_HISTOGRAM_COMPONENT(0i32);
pub const D3D12_VIDEO_DECODE_HISTOGRAM_COMPONENT_U: D3D12_VIDEO_DECODE_HISTOGRAM_COMPONENT = D3D12_VIDEO_DECODE_HISTOGRAM_COMPONENT(1i32);
pub const D3D12_VIDEO_DECODE_HISTOGRAM_COMPONENT_V: D3D12_VIDEO_DECODE_HISTOGRAM_COMPONENT = D3D12_VIDEO_DECODE_HISTOGRAM_COMPONENT(2i32);
pub const D3D12_VIDEO_DECODE_HISTOGRAM_COMPONENT_Y: D3D12_VIDEO_DECODE_HISTOGRAM_COMPONENT = D3D12_VIDEO_DECODE_HISTOGRAM_COMPONENT(0i32);
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Direct3D12")]
#[derive(Clone, Debug, PartialEq)]
pub struct D3D12_VIDEO_DECODE_INPUT_STREAM_ARGUMENTS {
    pub NumFrameArguments: u32,
    pub FrameArguments: [D3D12_VIDEO_DECODE_FRAME_ARGUMENT; 10],
    pub ReferenceFrames: D3D12_VIDEO_DECODE_REFERENCE_FRAMES,
    pub CompressedBitstream: D3D12_VIDEO_DECODE_COMPRESSED_BITSTREAM,
    pub pHeap: core::mem::ManuallyDrop<Option<ID3D12VideoDecoderHeap>>,
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
impl Default for D3D12_VIDEO_DECODE_INPUT_STREAM_ARGUMENTS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Direct3D12")]
#[derive(Clone, Debug, PartialEq)]
pub struct D3D12_VIDEO_DECODE_OUTPUT_HISTOGRAM {
    pub Offset: u64,
    pub pBuffer: core::mem::ManuallyDrop<Option<super::super::Graphics::Direct3D12::ID3D12Resource>>,
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
impl Default for D3D12_VIDEO_DECODE_OUTPUT_HISTOGRAM {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
#[derive(Clone, Debug, PartialEq)]
pub struct D3D12_VIDEO_DECODE_OUTPUT_STREAM_ARGUMENTS {
    pub pOutputTexture2D: core::mem::ManuallyDrop<Option<super::super::Graphics::Direct3D12::ID3D12Resource>>,
    pub OutputSubresource: u32,
    pub ConversionArguments: D3D12_VIDEO_DECODE_CONVERSION_ARGUMENTS,
}
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
impl Default for D3D12_VIDEO_DECODE_OUTPUT_STREAM_ARGUMENTS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
#[derive(Clone, Debug, PartialEq)]
pub struct D3D12_VIDEO_DECODE_OUTPUT_STREAM_ARGUMENTS1 {
    pub pOutputTexture2D: core::mem::ManuallyDrop<Option<super::super::Graphics::Direct3D12::ID3D12Resource>>,
    pub OutputSubresource: u32,
    pub ConversionArguments: D3D12_VIDEO_DECODE_CONVERSION_ARGUMENTS1,
    pub Histograms: [D3D12_VIDEO_DECODE_OUTPUT_HISTOGRAM; 4],
}
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
impl Default for D3D12_VIDEO_DECODE_OUTPUT_STREAM_ARGUMENTS1 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const D3D12_VIDEO_DECODE_PROFILE_AV1_12BIT_PROFILE2: windows_core::GUID = windows_core::GUID::from_u128(0x17127009_a00f_4ce1_994e_bf4081f6f3f0);
pub const D3D12_VIDEO_DECODE_PROFILE_AV1_12BIT_PROFILE2_420: windows_core::GUID = windows_core::GUID::from_u128(0x2d80bed6_9cac_4835_9e91_327bbc4f9ee8);
pub const D3D12_VIDEO_DECODE_PROFILE_AV1_PROFILE0: windows_core::GUID = windows_core::GUID::from_u128(0xb8be4ccb_cf53_46ba_8d59_d6b8a6da5d2a);
pub const D3D12_VIDEO_DECODE_PROFILE_AV1_PROFILE1: windows_core::GUID = windows_core::GUID::from_u128(0x6936ff0f_45b1_4163_9cc1_646ef6946108);
pub const D3D12_VIDEO_DECODE_PROFILE_AV1_PROFILE2: windows_core::GUID = windows_core::GUID::from_u128(0x0c5f2aa1_e541_4089_bb7b_98110a19d7c8);
pub const D3D12_VIDEO_DECODE_PROFILE_H264: windows_core::GUID = windows_core::GUID::from_u128(0x1b81be68_a0c7_11d3_b984_00c04f2e73c5);
pub const D3D12_VIDEO_DECODE_PROFILE_H264_MULTIVIEW: windows_core::GUID = windows_core::GUID::from_u128(0x705b9d82_76cf_49d6_b7e6_ac8872db013c);
pub const D3D12_VIDEO_DECODE_PROFILE_H264_STEREO: windows_core::GUID = windows_core::GUID::from_u128(0xf9aaccbb_c2b6_4cfc_8779_5707b1760552);
pub const D3D12_VIDEO_DECODE_PROFILE_H264_STEREO_PROGRESSIVE: windows_core::GUID = windows_core::GUID::from_u128(0xd79be8da_0cf1_4c81_b82a_69a4e236f43d);
pub const D3D12_VIDEO_DECODE_PROFILE_HEVC_MAIN: windows_core::GUID = windows_core::GUID::from_u128(0x5b11d51b_2f4c_4452_bcc3_09f2a1160cc0);
pub const D3D12_VIDEO_DECODE_PROFILE_HEVC_MAIN10: windows_core::GUID = windows_core::GUID::from_u128(0x107af0e0_ef1a_4d19_aba8_67a163073d13);
pub const D3D12_VIDEO_DECODE_PROFILE_HEVC_MAIN10_422: windows_core::GUID = windows_core::GUID::from_u128(0x0bac4fe5_1532_4429_a854_f84de04953db);
pub const D3D12_VIDEO_DECODE_PROFILE_HEVC_MAIN10_444: windows_core::GUID = windows_core::GUID::from_u128(0x0dabeffa_4458_4602_bc03_0795659d617c);
pub const D3D12_VIDEO_DECODE_PROFILE_HEVC_MAIN10_EXT: windows_core::GUID = windows_core::GUID::from_u128(0x9cc55490_e37c_4932_8684_4920f9f6409c);
pub const D3D12_VIDEO_DECODE_PROFILE_HEVC_MAIN12: windows_core::GUID = windows_core::GUID::from_u128(0x1a72925f_0c2c_4f15_96fb_b17d1473603f);
pub const D3D12_VIDEO_DECODE_PROFILE_HEVC_MAIN12_422: windows_core::GUID = windows_core::GUID::from_u128(0x55bcac81_f311_4093_a7d0_1cbc0b849bee);
pub const D3D12_VIDEO_DECODE_PROFILE_HEVC_MAIN12_444: windows_core::GUID = windows_core::GUID::from_u128(0x9798634d_fe9d_48e5_b4da_dbec45b3df01);
pub const D3D12_VIDEO_DECODE_PROFILE_HEVC_MAIN16: windows_core::GUID = windows_core::GUID::from_u128(0xa4fbdbb0_a113_482b_a232_635cc0697f6d);
pub const D3D12_VIDEO_DECODE_PROFILE_HEVC_MAIN_444: windows_core::GUID = windows_core::GUID::from_u128(0x4008018f_f537_4b36_98cf_61af8a2c1a33);
pub const D3D12_VIDEO_DECODE_PROFILE_HEVC_MONOCHROME: windows_core::GUID = windows_core::GUID::from_u128(0x0685b993_3d8c_43a0_8b28_d74c2d6899a4);
pub const D3D12_VIDEO_DECODE_PROFILE_HEVC_MONOCHROME10: windows_core::GUID = windows_core::GUID::from_u128(0x142a1d0f_69dd_4ec9_8591_b12ffcb91a29);
pub const D3D12_VIDEO_DECODE_PROFILE_JPEG_VLD_420: windows_core::GUID = windows_core::GUID::from_u128(0xcf782c83_bef5_4a2c_87cb_6019e7b175ac);
pub const D3D12_VIDEO_DECODE_PROFILE_JPEG_VLD_422: windows_core::GUID = windows_core::GUID::from_u128(0xf04df417_eee2_4067_a778_f35c15ab9721);
pub const D3D12_VIDEO_DECODE_PROFILE_JPEG_VLD_444: windows_core::GUID = windows_core::GUID::from_u128(0x4cd00e17_89ba_48ef_b9f9_edcb82713f65);
pub const D3D12_VIDEO_DECODE_PROFILE_MJPEG_VLD_420: windows_core::GUID = windows_core::GUID::from_u128(0x725cb506_0c29_43c4_9440_8e9397903a04);
pub const D3D12_VIDEO_DECODE_PROFILE_MJPEG_VLD_422: windows_core::GUID = windows_core::GUID::from_u128(0x5b77b9cd_1a35_4c30_9fd8_ef4b60c035dd);
pub const D3D12_VIDEO_DECODE_PROFILE_MJPEG_VLD_444: windows_core::GUID = windows_core::GUID::from_u128(0xd95161f9_0d44_47e6_bcf5_1bfbfb268f97);
pub const D3D12_VIDEO_DECODE_PROFILE_MJPEG_VLD_4444: windows_core::GUID = windows_core::GUID::from_u128(0xc91748d5_fd18_4aca_9db3_3a6634ab547d);
pub const D3D12_VIDEO_DECODE_PROFILE_MPEG1_AND_MPEG2: windows_core::GUID = windows_core::GUID::from_u128(0x86695f12_340e_4f04_9fd3_9253dd327460);
pub const D3D12_VIDEO_DECODE_PROFILE_MPEG2: windows_core::GUID = windows_core::GUID::from_u128(0xee27417f_5e28_4e65_beea_1d26b508adc9);
pub const D3D12_VIDEO_DECODE_PROFILE_MPEG4PT2_ADVSIMPLE_NOGMC: windows_core::GUID = windows_core::GUID::from_u128(0xed418a9f_010d_4eda_9ae3_9a65358d8d2e);
pub const D3D12_VIDEO_DECODE_PROFILE_MPEG4PT2_SIMPLE: windows_core::GUID = windows_core::GUID::from_u128(0xefd64d74_c9e8_41d7_a5e9_e9b0e39fa319);
pub const D3D12_VIDEO_DECODE_PROFILE_VC1: windows_core::GUID = windows_core::GUID::from_u128(0x1b81bea3_a0c7_11d3_b984_00c04f2e73c5);
pub const D3D12_VIDEO_DECODE_PROFILE_VC1_D2010: windows_core::GUID = windows_core::GUID::from_u128(0x1b81bea4_a0c7_11d3_b984_00c04f2e73c5);
pub const D3D12_VIDEO_DECODE_PROFILE_VP8: windows_core::GUID = windows_core::GUID::from_u128(0x90b899ea_3a62_4705_88b3_8df04b2744e7);
pub const D3D12_VIDEO_DECODE_PROFILE_VP9: windows_core::GUID = windows_core::GUID::from_u128(0x463707f8_a1d0_4585_876d_83aa6d60b89e);
pub const D3D12_VIDEO_DECODE_PROFILE_VP9_10BIT_PROFILE2: windows_core::GUID = windows_core::GUID::from_u128(0xa4c749ef_6ecf_48aa_8448_50a7a1165ff7);
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Direct3D12")]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_VIDEO_DECODE_REFERENCE_FRAMES {
    pub NumTexture2Ds: u32,
    pub ppTexture2Ds: *mut Option<super::super::Graphics::Direct3D12::ID3D12Resource>,
    pub pSubresources: *mut u32,
    pub ppHeaps: *mut Option<ID3D12VideoDecoderHeap>,
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
impl Default for D3D12_VIDEO_DECODE_REFERENCE_FRAMES {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct D3D12_VIDEO_DECODE_STATUS(pub i32);
pub const D3D12_VIDEO_DECODE_STATUS_CONTINUE: D3D12_VIDEO_DECODE_STATUS = D3D12_VIDEO_DECODE_STATUS(1i32);
pub const D3D12_VIDEO_DECODE_STATUS_CONTINUE_SKIP_DISPLAY: D3D12_VIDEO_DECODE_STATUS = D3D12_VIDEO_DECODE_STATUS(2i32);
pub const D3D12_VIDEO_DECODE_STATUS_OK: D3D12_VIDEO_DECODE_STATUS = D3D12_VIDEO_DECODE_STATUS(0i32);
pub const D3D12_VIDEO_DECODE_STATUS_RATE_EXCEEDED: D3D12_VIDEO_DECODE_STATUS = D3D12_VIDEO_DECODE_STATUS(4i32);
pub const D3D12_VIDEO_DECODE_STATUS_RESTART: D3D12_VIDEO_DECODE_STATUS = D3D12_VIDEO_DECODE_STATUS(3i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct D3D12_VIDEO_DECODE_SUPPORT_FLAGS(pub i32);
impl D3D12_VIDEO_DECODE_SUPPORT_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for D3D12_VIDEO_DECODE_SUPPORT_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for D3D12_VIDEO_DECODE_SUPPORT_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for D3D12_VIDEO_DECODE_SUPPORT_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for D3D12_VIDEO_DECODE_SUPPORT_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for D3D12_VIDEO_DECODE_SUPPORT_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
pub const D3D12_VIDEO_DECODE_SUPPORT_FLAG_NONE: D3D12_VIDEO_DECODE_SUPPORT_FLAGS = D3D12_VIDEO_DECODE_SUPPORT_FLAGS(0i32);
pub const D3D12_VIDEO_DECODE_SUPPORT_FLAG_SUPPORTED: D3D12_VIDEO_DECODE_SUPPORT_FLAGS = D3D12_VIDEO_DECODE_SUPPORT_FLAGS(1i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct D3D12_VIDEO_DECODE_TIER(pub i32);
pub const D3D12_VIDEO_DECODE_TIER_1: D3D12_VIDEO_DECODE_TIER = D3D12_VIDEO_DECODE_TIER(1i32);
pub const D3D12_VIDEO_DECODE_TIER_2: D3D12_VIDEO_DECODE_TIER = D3D12_VIDEO_DECODE_TIER(2i32);
pub const D3D12_VIDEO_DECODE_TIER_3: D3D12_VIDEO_DECODE_TIER = D3D12_VIDEO_DECODE_TIER(3i32);
pub const D3D12_VIDEO_DECODE_TIER_NOT_SUPPORTED: D3D12_VIDEO_DECODE_TIER = D3D12_VIDEO_DECODE_TIER(0i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_AV1_CDEF_CONFIG {
    pub CdefBits: u64,
    pub CdefDampingMinus3: u64,
    pub CdefYPriStrength: [u64; 8],
    pub CdefUVPriStrength: [u64; 8],
    pub CdefYSecStrength: [u64; 8],
    pub CdefUVSecStrength: [u64; 8],
}
impl Default for D3D12_VIDEO_ENCODER_AV1_CDEF_CONFIG {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_AV1_CODEC_CONFIGURATION {
    pub FeatureFlags: D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAGS,
    pub OrderHintBitsMinus1: u32,
}
impl Default for D3D12_VIDEO_ENCODER_AV1_CODEC_CONFIGURATION {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_AV1_CODEC_CONFIGURATION_SUPPORT {
    pub SupportedFeatureFlags: D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAGS,
    pub RequiredFeatureFlags: D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAGS,
    pub SupportedInterpolationFilters: D3D12_VIDEO_ENCODER_AV1_INTERPOLATION_FILTERS_FLAGS,
    pub SupportedRestorationParams: [D3D12_VIDEO_ENCODER_AV1_RESTORATION_SUPPORT_FLAGS; 9],
    pub SupportedSegmentationModes: D3D12_VIDEO_ENCODER_AV1_SEGMENTATION_MODE_FLAGS,
    pub SupportedTxModes: [D3D12_VIDEO_ENCODER_AV1_TX_MODE_FLAGS; 4],
    pub SegmentationBlockSize: D3D12_VIDEO_ENCODER_AV1_SEGMENTATION_BLOCK_SIZE,
    pub PostEncodeValuesFlags: D3D12_VIDEO_ENCODER_AV1_POST_ENCODE_VALUES_FLAGS,
    pub MaxTemporalLayers: u32,
    pub MaxSpatialLayers: u32,
}
impl Default for D3D12_VIDEO_ENCODER_AV1_CODEC_CONFIGURATION_SUPPORT {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_AV1_COMP_PREDICTION_TYPE(pub i32);
pub const D3D12_VIDEO_ENCODER_AV1_COMP_PREDICTION_TYPE_COMPOUND_REFERENCE: D3D12_VIDEO_ENCODER_AV1_COMP_PREDICTION_TYPE = D3D12_VIDEO_ENCODER_AV1_COMP_PREDICTION_TYPE(1i32);
pub const D3D12_VIDEO_ENCODER_AV1_COMP_PREDICTION_TYPE_SINGLE_REFERENCE: D3D12_VIDEO_ENCODER_AV1_COMP_PREDICTION_TYPE = D3D12_VIDEO_ENCODER_AV1_COMP_PREDICTION_TYPE(0i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAGS(pub i32);
impl D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
pub const D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAG_128x128_SUPERBLOCK: D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAGS = D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAGS(1i32);
pub const D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAG_ALLOW_HIGH_PRECISION_MV: D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAGS = D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAGS(8388608i32);
pub const D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAG_AUTO_SEGMENTATION: D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAGS = D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAGS(65536i32);
pub const D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAG_CDEF_FILTERING: D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAGS = D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAGS(4096i32);
pub const D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAG_CUSTOM_SEGMENTATION: D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAGS = D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAGS(131072i32);
pub const D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAG_DELTA_LF_PARAMS: D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAGS = D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAGS(33554432i32);
pub const D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAG_DUAL_FILTER: D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAGS = D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAGS(64i32);
pub const D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAG_FILTER_INTRA: D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAGS = D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAGS(2i32);
pub const D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAG_FORCED_INTEGER_MOTION_VECTORS: D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAGS = D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAGS(256i32);
pub const D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAG_FRAME_REFERENCE_MOTION_VECTORS: D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAGS = D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAGS(16384i32);
pub const D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAG_INTERINTRA_COMPOUND: D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAGS = D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAGS(8i32);
pub const D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAG_INTRA_BLOCK_COPY: D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAGS = D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAGS(8192i32);
pub const D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAG_INTRA_EDGE_FILTER: D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAGS = D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAGS(4i32);
pub const D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAG_JNT_COMP: D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAGS = D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAGS(128i32);
pub const D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAG_LOOP_FILTER_DELTAS: D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAGS = D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAGS(262144i32);
pub const D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAG_LOOP_RESTORATION_FILTER: D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAGS = D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAGS(1024i32);
pub const D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAG_MASKED_COMPOUND: D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAGS = D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAGS(16i32);
pub const D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAG_MOTION_MODE_SWITCHABLE: D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAGS = D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAGS(4194304i32);
pub const D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAG_NONE: D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAGS = D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAGS(0i32);
pub const D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAG_ORDER_HINT_TOOLS: D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAGS = D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAGS(32768i32);
pub const D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAG_PALETTE_ENCODING: D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAGS = D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAGS(2048i32);
pub const D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAG_QUANTIZATION_DELTAS: D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAGS = D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAGS(524288i32);
pub const D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAG_QUANTIZATION_MATRIX: D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAGS = D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAGS(1048576i32);
pub const D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAG_REDUCED_TX_SET: D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAGS = D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAGS(2097152i32);
pub const D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAG_SKIP_MODE_PRESENT: D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAGS = D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAGS(16777216i32);
pub const D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAG_SUPER_RESOLUTION: D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAGS = D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAGS(512i32);
pub const D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAG_WARPED_MOTION: D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAGS = D3D12_VIDEO_ENCODER_AV1_FEATURE_FLAGS(32i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_AV1_FRAME_SUBREGION_LAYOUT_CONFIG_SUPPORT {
    pub Use128SuperBlocks: super::super::Foundation::BOOL,
    pub TilesConfiguration: D3D12_VIDEO_ENCODER_AV1_PICTURE_CONTROL_SUBREGIONS_LAYOUT_DATA_TILES,
    pub ValidationFlags: D3D12_VIDEO_ENCODER_AV1_FRAME_SUBREGION_LAYOUT_CONFIG_VALIDATION_FLAGS,
    pub MinTileRows: u32,
    pub MaxTileRows: u32,
    pub MinTileCols: u32,
    pub MaxTileCols: u32,
    pub MinTileWidth: u32,
    pub MaxTileWidth: u32,
    pub MinTileArea: u32,
    pub MaxTileArea: u32,
    pub TileSizeBytesMinus1: u32,
}
impl Default for D3D12_VIDEO_ENCODER_AV1_FRAME_SUBREGION_LAYOUT_CONFIG_SUPPORT {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_AV1_FRAME_SUBREGION_LAYOUT_CONFIG_VALIDATION_FLAGS(pub i32);
impl D3D12_VIDEO_ENCODER_AV1_FRAME_SUBREGION_LAYOUT_CONFIG_VALIDATION_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for D3D12_VIDEO_ENCODER_AV1_FRAME_SUBREGION_LAYOUT_CONFIG_VALIDATION_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for D3D12_VIDEO_ENCODER_AV1_FRAME_SUBREGION_LAYOUT_CONFIG_VALIDATION_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for D3D12_VIDEO_ENCODER_AV1_FRAME_SUBREGION_LAYOUT_CONFIG_VALIDATION_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for D3D12_VIDEO_ENCODER_AV1_FRAME_SUBREGION_LAYOUT_CONFIG_VALIDATION_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for D3D12_VIDEO_ENCODER_AV1_FRAME_SUBREGION_LAYOUT_CONFIG_VALIDATION_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
pub const D3D12_VIDEO_ENCODER_AV1_FRAME_SUBREGION_LAYOUT_CONFIG_VALIDATION_FLAG_AREA: D3D12_VIDEO_ENCODER_AV1_FRAME_SUBREGION_LAYOUT_CONFIG_VALIDATION_FLAGS = D3D12_VIDEO_ENCODER_AV1_FRAME_SUBREGION_LAYOUT_CONFIG_VALIDATION_FLAGS(64i32);
pub const D3D12_VIDEO_ENCODER_AV1_FRAME_SUBREGION_LAYOUT_CONFIG_VALIDATION_FLAG_CODEC_CONSTRAINT: D3D12_VIDEO_ENCODER_AV1_FRAME_SUBREGION_LAYOUT_CONFIG_VALIDATION_FLAGS = D3D12_VIDEO_ENCODER_AV1_FRAME_SUBREGION_LAYOUT_CONFIG_VALIDATION_FLAGS(2i32);
pub const D3D12_VIDEO_ENCODER_AV1_FRAME_SUBREGION_LAYOUT_CONFIG_VALIDATION_FLAG_COLS_COUNT: D3D12_VIDEO_ENCODER_AV1_FRAME_SUBREGION_LAYOUT_CONFIG_VALIDATION_FLAGS = D3D12_VIDEO_ENCODER_AV1_FRAME_SUBREGION_LAYOUT_CONFIG_VALIDATION_FLAGS(16i32);
pub const D3D12_VIDEO_ENCODER_AV1_FRAME_SUBREGION_LAYOUT_CONFIG_VALIDATION_FLAG_HARDWARE_CONSTRAINT: D3D12_VIDEO_ENCODER_AV1_FRAME_SUBREGION_LAYOUT_CONFIG_VALIDATION_FLAGS = D3D12_VIDEO_ENCODER_AV1_FRAME_SUBREGION_LAYOUT_CONFIG_VALIDATION_FLAGS(4i32);
pub const D3D12_VIDEO_ENCODER_AV1_FRAME_SUBREGION_LAYOUT_CONFIG_VALIDATION_FLAG_NONE: D3D12_VIDEO_ENCODER_AV1_FRAME_SUBREGION_LAYOUT_CONFIG_VALIDATION_FLAGS = D3D12_VIDEO_ENCODER_AV1_FRAME_SUBREGION_LAYOUT_CONFIG_VALIDATION_FLAGS(0i32);
pub const D3D12_VIDEO_ENCODER_AV1_FRAME_SUBREGION_LAYOUT_CONFIG_VALIDATION_FLAG_NOT_SPECIFIED: D3D12_VIDEO_ENCODER_AV1_FRAME_SUBREGION_LAYOUT_CONFIG_VALIDATION_FLAGS = D3D12_VIDEO_ENCODER_AV1_FRAME_SUBREGION_LAYOUT_CONFIG_VALIDATION_FLAGS(1i32);
pub const D3D12_VIDEO_ENCODER_AV1_FRAME_SUBREGION_LAYOUT_CONFIG_VALIDATION_FLAG_ROWS_COUNT: D3D12_VIDEO_ENCODER_AV1_FRAME_SUBREGION_LAYOUT_CONFIG_VALIDATION_FLAGS = D3D12_VIDEO_ENCODER_AV1_FRAME_SUBREGION_LAYOUT_CONFIG_VALIDATION_FLAGS(8i32);
pub const D3D12_VIDEO_ENCODER_AV1_FRAME_SUBREGION_LAYOUT_CONFIG_VALIDATION_FLAG_TOTAL_TILES: D3D12_VIDEO_ENCODER_AV1_FRAME_SUBREGION_LAYOUT_CONFIG_VALIDATION_FLAGS = D3D12_VIDEO_ENCODER_AV1_FRAME_SUBREGION_LAYOUT_CONFIG_VALIDATION_FLAGS(128i32);
pub const D3D12_VIDEO_ENCODER_AV1_FRAME_SUBREGION_LAYOUT_CONFIG_VALIDATION_FLAG_WIDTH: D3D12_VIDEO_ENCODER_AV1_FRAME_SUBREGION_LAYOUT_CONFIG_VALIDATION_FLAGS = D3D12_VIDEO_ENCODER_AV1_FRAME_SUBREGION_LAYOUT_CONFIG_VALIDATION_FLAGS(32i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_AV1_FRAME_TYPE(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_AV1_FRAME_TYPE_FLAGS(pub i32);
impl D3D12_VIDEO_ENCODER_AV1_FRAME_TYPE_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for D3D12_VIDEO_ENCODER_AV1_FRAME_TYPE_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for D3D12_VIDEO_ENCODER_AV1_FRAME_TYPE_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for D3D12_VIDEO_ENCODER_AV1_FRAME_TYPE_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for D3D12_VIDEO_ENCODER_AV1_FRAME_TYPE_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for D3D12_VIDEO_ENCODER_AV1_FRAME_TYPE_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
pub const D3D12_VIDEO_ENCODER_AV1_FRAME_TYPE_FLAG_INTER_FRAME: D3D12_VIDEO_ENCODER_AV1_FRAME_TYPE_FLAGS = D3D12_VIDEO_ENCODER_AV1_FRAME_TYPE_FLAGS(2i32);
pub const D3D12_VIDEO_ENCODER_AV1_FRAME_TYPE_FLAG_INTRA_ONLY_FRAME: D3D12_VIDEO_ENCODER_AV1_FRAME_TYPE_FLAGS = D3D12_VIDEO_ENCODER_AV1_FRAME_TYPE_FLAGS(4i32);
pub const D3D12_VIDEO_ENCODER_AV1_FRAME_TYPE_FLAG_KEY_FRAME: D3D12_VIDEO_ENCODER_AV1_FRAME_TYPE_FLAGS = D3D12_VIDEO_ENCODER_AV1_FRAME_TYPE_FLAGS(1i32);
pub const D3D12_VIDEO_ENCODER_AV1_FRAME_TYPE_FLAG_NONE: D3D12_VIDEO_ENCODER_AV1_FRAME_TYPE_FLAGS = D3D12_VIDEO_ENCODER_AV1_FRAME_TYPE_FLAGS(0i32);
pub const D3D12_VIDEO_ENCODER_AV1_FRAME_TYPE_FLAG_SWITCH_FRAME: D3D12_VIDEO_ENCODER_AV1_FRAME_TYPE_FLAGS = D3D12_VIDEO_ENCODER_AV1_FRAME_TYPE_FLAGS(8i32);
pub const D3D12_VIDEO_ENCODER_AV1_FRAME_TYPE_INTER_FRAME: D3D12_VIDEO_ENCODER_AV1_FRAME_TYPE = D3D12_VIDEO_ENCODER_AV1_FRAME_TYPE(1i32);
pub const D3D12_VIDEO_ENCODER_AV1_FRAME_TYPE_INTRA_ONLY_FRAME: D3D12_VIDEO_ENCODER_AV1_FRAME_TYPE = D3D12_VIDEO_ENCODER_AV1_FRAME_TYPE(2i32);
pub const D3D12_VIDEO_ENCODER_AV1_FRAME_TYPE_KEY_FRAME: D3D12_VIDEO_ENCODER_AV1_FRAME_TYPE = D3D12_VIDEO_ENCODER_AV1_FRAME_TYPE(0i32);
pub const D3D12_VIDEO_ENCODER_AV1_FRAME_TYPE_SWITCH_FRAME: D3D12_VIDEO_ENCODER_AV1_FRAME_TYPE = D3D12_VIDEO_ENCODER_AV1_FRAME_TYPE(3i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_AV1_INTERPOLATION_FILTERS(pub i32);
pub const D3D12_VIDEO_ENCODER_AV1_INTERPOLATION_FILTERS_BILINEAR: D3D12_VIDEO_ENCODER_AV1_INTERPOLATION_FILTERS = D3D12_VIDEO_ENCODER_AV1_INTERPOLATION_FILTERS(3i32);
pub const D3D12_VIDEO_ENCODER_AV1_INTERPOLATION_FILTERS_EIGHTTAP: D3D12_VIDEO_ENCODER_AV1_INTERPOLATION_FILTERS = D3D12_VIDEO_ENCODER_AV1_INTERPOLATION_FILTERS(0i32);
pub const D3D12_VIDEO_ENCODER_AV1_INTERPOLATION_FILTERS_EIGHTTAP_SHARP: D3D12_VIDEO_ENCODER_AV1_INTERPOLATION_FILTERS = D3D12_VIDEO_ENCODER_AV1_INTERPOLATION_FILTERS(2i32);
pub const D3D12_VIDEO_ENCODER_AV1_INTERPOLATION_FILTERS_EIGHTTAP_SMOOTH: D3D12_VIDEO_ENCODER_AV1_INTERPOLATION_FILTERS = D3D12_VIDEO_ENCODER_AV1_INTERPOLATION_FILTERS(1i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_AV1_INTERPOLATION_FILTERS_FLAGS(pub i32);
impl D3D12_VIDEO_ENCODER_AV1_INTERPOLATION_FILTERS_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for D3D12_VIDEO_ENCODER_AV1_INTERPOLATION_FILTERS_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for D3D12_VIDEO_ENCODER_AV1_INTERPOLATION_FILTERS_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for D3D12_VIDEO_ENCODER_AV1_INTERPOLATION_FILTERS_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for D3D12_VIDEO_ENCODER_AV1_INTERPOLATION_FILTERS_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for D3D12_VIDEO_ENCODER_AV1_INTERPOLATION_FILTERS_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
pub const D3D12_VIDEO_ENCODER_AV1_INTERPOLATION_FILTERS_FLAG_BILINEAR: D3D12_VIDEO_ENCODER_AV1_INTERPOLATION_FILTERS_FLAGS = D3D12_VIDEO_ENCODER_AV1_INTERPOLATION_FILTERS_FLAGS(8i32);
pub const D3D12_VIDEO_ENCODER_AV1_INTERPOLATION_FILTERS_FLAG_EIGHTTAP: D3D12_VIDEO_ENCODER_AV1_INTERPOLATION_FILTERS_FLAGS = D3D12_VIDEO_ENCODER_AV1_INTERPOLATION_FILTERS_FLAGS(1i32);
pub const D3D12_VIDEO_ENCODER_AV1_INTERPOLATION_FILTERS_FLAG_EIGHTTAP_SHARP: D3D12_VIDEO_ENCODER_AV1_INTERPOLATION_FILTERS_FLAGS = D3D12_VIDEO_ENCODER_AV1_INTERPOLATION_FILTERS_FLAGS(4i32);
pub const D3D12_VIDEO_ENCODER_AV1_INTERPOLATION_FILTERS_FLAG_EIGHTTAP_SMOOTH: D3D12_VIDEO_ENCODER_AV1_INTERPOLATION_FILTERS_FLAGS = D3D12_VIDEO_ENCODER_AV1_INTERPOLATION_FILTERS_FLAGS(2i32);
pub const D3D12_VIDEO_ENCODER_AV1_INTERPOLATION_FILTERS_FLAG_NONE: D3D12_VIDEO_ENCODER_AV1_INTERPOLATION_FILTERS_FLAGS = D3D12_VIDEO_ENCODER_AV1_INTERPOLATION_FILTERS_FLAGS(0i32);
pub const D3D12_VIDEO_ENCODER_AV1_INTERPOLATION_FILTERS_FLAG_SWITCHABLE: D3D12_VIDEO_ENCODER_AV1_INTERPOLATION_FILTERS_FLAGS = D3D12_VIDEO_ENCODER_AV1_INTERPOLATION_FILTERS_FLAGS(16i32);
pub const D3D12_VIDEO_ENCODER_AV1_INTERPOLATION_FILTERS_SWITCHABLE: D3D12_VIDEO_ENCODER_AV1_INTERPOLATION_FILTERS = D3D12_VIDEO_ENCODER_AV1_INTERPOLATION_FILTERS(4i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_AV1_LEVELS(pub i32);
pub const D3D12_VIDEO_ENCODER_AV1_LEVELS_2_0: D3D12_VIDEO_ENCODER_AV1_LEVELS = D3D12_VIDEO_ENCODER_AV1_LEVELS(0i32);
pub const D3D12_VIDEO_ENCODER_AV1_LEVELS_2_1: D3D12_VIDEO_ENCODER_AV1_LEVELS = D3D12_VIDEO_ENCODER_AV1_LEVELS(1i32);
pub const D3D12_VIDEO_ENCODER_AV1_LEVELS_2_2: D3D12_VIDEO_ENCODER_AV1_LEVELS = D3D12_VIDEO_ENCODER_AV1_LEVELS(2i32);
pub const D3D12_VIDEO_ENCODER_AV1_LEVELS_2_3: D3D12_VIDEO_ENCODER_AV1_LEVELS = D3D12_VIDEO_ENCODER_AV1_LEVELS(3i32);
pub const D3D12_VIDEO_ENCODER_AV1_LEVELS_3_0: D3D12_VIDEO_ENCODER_AV1_LEVELS = D3D12_VIDEO_ENCODER_AV1_LEVELS(4i32);
pub const D3D12_VIDEO_ENCODER_AV1_LEVELS_3_1: D3D12_VIDEO_ENCODER_AV1_LEVELS = D3D12_VIDEO_ENCODER_AV1_LEVELS(5i32);
pub const D3D12_VIDEO_ENCODER_AV1_LEVELS_3_2: D3D12_VIDEO_ENCODER_AV1_LEVELS = D3D12_VIDEO_ENCODER_AV1_LEVELS(6i32);
pub const D3D12_VIDEO_ENCODER_AV1_LEVELS_3_3: D3D12_VIDEO_ENCODER_AV1_LEVELS = D3D12_VIDEO_ENCODER_AV1_LEVELS(7i32);
pub const D3D12_VIDEO_ENCODER_AV1_LEVELS_4_0: D3D12_VIDEO_ENCODER_AV1_LEVELS = D3D12_VIDEO_ENCODER_AV1_LEVELS(8i32);
pub const D3D12_VIDEO_ENCODER_AV1_LEVELS_4_1: D3D12_VIDEO_ENCODER_AV1_LEVELS = D3D12_VIDEO_ENCODER_AV1_LEVELS(9i32);
pub const D3D12_VIDEO_ENCODER_AV1_LEVELS_4_2: D3D12_VIDEO_ENCODER_AV1_LEVELS = D3D12_VIDEO_ENCODER_AV1_LEVELS(10i32);
pub const D3D12_VIDEO_ENCODER_AV1_LEVELS_4_3: D3D12_VIDEO_ENCODER_AV1_LEVELS = D3D12_VIDEO_ENCODER_AV1_LEVELS(11i32);
pub const D3D12_VIDEO_ENCODER_AV1_LEVELS_5_0: D3D12_VIDEO_ENCODER_AV1_LEVELS = D3D12_VIDEO_ENCODER_AV1_LEVELS(12i32);
pub const D3D12_VIDEO_ENCODER_AV1_LEVELS_5_1: D3D12_VIDEO_ENCODER_AV1_LEVELS = D3D12_VIDEO_ENCODER_AV1_LEVELS(13i32);
pub const D3D12_VIDEO_ENCODER_AV1_LEVELS_5_2: D3D12_VIDEO_ENCODER_AV1_LEVELS = D3D12_VIDEO_ENCODER_AV1_LEVELS(14i32);
pub const D3D12_VIDEO_ENCODER_AV1_LEVELS_5_3: D3D12_VIDEO_ENCODER_AV1_LEVELS = D3D12_VIDEO_ENCODER_AV1_LEVELS(15i32);
pub const D3D12_VIDEO_ENCODER_AV1_LEVELS_6_0: D3D12_VIDEO_ENCODER_AV1_LEVELS = D3D12_VIDEO_ENCODER_AV1_LEVELS(16i32);
pub const D3D12_VIDEO_ENCODER_AV1_LEVELS_6_1: D3D12_VIDEO_ENCODER_AV1_LEVELS = D3D12_VIDEO_ENCODER_AV1_LEVELS(17i32);
pub const D3D12_VIDEO_ENCODER_AV1_LEVELS_6_2: D3D12_VIDEO_ENCODER_AV1_LEVELS = D3D12_VIDEO_ENCODER_AV1_LEVELS(18i32);
pub const D3D12_VIDEO_ENCODER_AV1_LEVELS_6_3: D3D12_VIDEO_ENCODER_AV1_LEVELS = D3D12_VIDEO_ENCODER_AV1_LEVELS(19i32);
pub const D3D12_VIDEO_ENCODER_AV1_LEVELS_7_0: D3D12_VIDEO_ENCODER_AV1_LEVELS = D3D12_VIDEO_ENCODER_AV1_LEVELS(20i32);
pub const D3D12_VIDEO_ENCODER_AV1_LEVELS_7_1: D3D12_VIDEO_ENCODER_AV1_LEVELS = D3D12_VIDEO_ENCODER_AV1_LEVELS(21i32);
pub const D3D12_VIDEO_ENCODER_AV1_LEVELS_7_2: D3D12_VIDEO_ENCODER_AV1_LEVELS = D3D12_VIDEO_ENCODER_AV1_LEVELS(22i32);
pub const D3D12_VIDEO_ENCODER_AV1_LEVELS_7_3: D3D12_VIDEO_ENCODER_AV1_LEVELS = D3D12_VIDEO_ENCODER_AV1_LEVELS(23i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_AV1_LEVEL_TIER_CONSTRAINTS {
    pub Level: D3D12_VIDEO_ENCODER_AV1_LEVELS,
    pub Tier: D3D12_VIDEO_ENCODER_AV1_TIER,
}
impl Default for D3D12_VIDEO_ENCODER_AV1_LEVEL_TIER_CONSTRAINTS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_AV1_PICTURE_CONTROL_CODEC_DATA {
    pub Flags: D3D12_VIDEO_ENCODER_AV1_PICTURE_CONTROL_FLAGS,
    pub FrameType: D3D12_VIDEO_ENCODER_AV1_FRAME_TYPE,
    pub CompoundPredictionType: D3D12_VIDEO_ENCODER_AV1_COMP_PREDICTION_TYPE,
    pub InterpolationFilter: D3D12_VIDEO_ENCODER_AV1_INTERPOLATION_FILTERS,
    pub FrameRestorationConfig: D3D12_VIDEO_ENCODER_AV1_RESTORATION_CONFIG,
    pub TxMode: D3D12_VIDEO_ENCODER_AV1_TX_MODE,
    pub SuperResDenominator: u32,
    pub OrderHint: u32,
    pub PictureIndex: u32,
    pub TemporalLayerIndexPlus1: u32,
    pub SpatialLayerIndexPlus1: u32,
    pub ReferenceFramesReconPictureDescriptors: [D3D12_VIDEO_ENCODER_AV1_REFERENCE_PICTURE_DESCRIPTOR; 8],
    pub ReferenceIndices: [u32; 7],
    pub PrimaryRefFrame: u32,
    pub RefreshFrameFlags: u32,
    pub LoopFilter: D3D12_VIDEO_ENCODER_CODEC_AV1_LOOP_FILTER_CONFIG,
    pub LoopFilterDelta: D3D12_VIDEO_ENCODER_CODEC_AV1_LOOP_FILTER_DELTA_CONFIG,
    pub Quantization: D3D12_VIDEO_ENCODER_CODEC_AV1_QUANTIZATION_CONFIG,
    pub QuantizationDelta: D3D12_VIDEO_ENCODER_CODEC_AV1_QUANTIZATION_DELTA_CONFIG,
    pub CDEF: D3D12_VIDEO_ENCODER_AV1_CDEF_CONFIG,
    pub QPMapValuesCount: u32,
    pub pRateControlQPMap: *mut i16,
    pub CustomSegmentation: D3D12_VIDEO_ENCODER_AV1_SEGMENTATION_CONFIG,
    pub CustomSegmentsMap: D3D12_VIDEO_ENCODER_AV1_SEGMENTATION_MAP,
}
impl Default for D3D12_VIDEO_ENCODER_AV1_PICTURE_CONTROL_CODEC_DATA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_AV1_PICTURE_CONTROL_FLAGS(pub i32);
impl D3D12_VIDEO_ENCODER_AV1_PICTURE_CONTROL_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for D3D12_VIDEO_ENCODER_AV1_PICTURE_CONTROL_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for D3D12_VIDEO_ENCODER_AV1_PICTURE_CONTROL_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for D3D12_VIDEO_ENCODER_AV1_PICTURE_CONTROL_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for D3D12_VIDEO_ENCODER_AV1_PICTURE_CONTROL_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for D3D12_VIDEO_ENCODER_AV1_PICTURE_CONTROL_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
pub const D3D12_VIDEO_ENCODER_AV1_PICTURE_CONTROL_FLAG_ALLOW_HIGH_PRECISION_MV: D3D12_VIDEO_ENCODER_AV1_PICTURE_CONTROL_FLAGS = D3D12_VIDEO_ENCODER_AV1_PICTURE_CONTROL_FLAGS(16384i32);
pub const D3D12_VIDEO_ENCODER_AV1_PICTURE_CONTROL_FLAG_ALLOW_INTRA_BLOCK_COPY: D3D12_VIDEO_ENCODER_AV1_PICTURE_CONTROL_FLAGS = D3D12_VIDEO_ENCODER_AV1_PICTURE_CONTROL_FLAGS(64i32);
pub const D3D12_VIDEO_ENCODER_AV1_PICTURE_CONTROL_FLAG_DISABLE_CDF_UPDATE: D3D12_VIDEO_ENCODER_AV1_PICTURE_CONTROL_FLAGS = D3D12_VIDEO_ENCODER_AV1_PICTURE_CONTROL_FLAGS(2i32);
pub const D3D12_VIDEO_ENCODER_AV1_PICTURE_CONTROL_FLAG_DISABLE_FRAME_END_UPDATE_CDF: D3D12_VIDEO_ENCODER_AV1_PICTURE_CONTROL_FLAGS = D3D12_VIDEO_ENCODER_AV1_PICTURE_CONTROL_FLAGS(256i32);
pub const D3D12_VIDEO_ENCODER_AV1_PICTURE_CONTROL_FLAG_ENABLE_ERROR_RESILIENT_MODE: D3D12_VIDEO_ENCODER_AV1_PICTURE_CONTROL_FLAGS = D3D12_VIDEO_ENCODER_AV1_PICTURE_CONTROL_FLAGS(1i32);
pub const D3D12_VIDEO_ENCODER_AV1_PICTURE_CONTROL_FLAG_ENABLE_FRAME_SEGMENTATION_AUTO: D3D12_VIDEO_ENCODER_AV1_PICTURE_CONTROL_FLAGS = D3D12_VIDEO_ENCODER_AV1_PICTURE_CONTROL_FLAGS(512i32);
pub const D3D12_VIDEO_ENCODER_AV1_PICTURE_CONTROL_FLAG_ENABLE_FRAME_SEGMENTATION_CUSTOM: D3D12_VIDEO_ENCODER_AV1_PICTURE_CONTROL_FLAGS = D3D12_VIDEO_ENCODER_AV1_PICTURE_CONTROL_FLAGS(1024i32);
pub const D3D12_VIDEO_ENCODER_AV1_PICTURE_CONTROL_FLAG_ENABLE_PALETTE_ENCODING: D3D12_VIDEO_ENCODER_AV1_PICTURE_CONTROL_FLAGS = D3D12_VIDEO_ENCODER_AV1_PICTURE_CONTROL_FLAGS(4i32);
pub const D3D12_VIDEO_ENCODER_AV1_PICTURE_CONTROL_FLAG_ENABLE_SKIP_MODE: D3D12_VIDEO_ENCODER_AV1_PICTURE_CONTROL_FLAGS = D3D12_VIDEO_ENCODER_AV1_PICTURE_CONTROL_FLAGS(8i32);
pub const D3D12_VIDEO_ENCODER_AV1_PICTURE_CONTROL_FLAG_ENABLE_WARPED_MOTION: D3D12_VIDEO_ENCODER_AV1_PICTURE_CONTROL_FLAGS = D3D12_VIDEO_ENCODER_AV1_PICTURE_CONTROL_FLAGS(2048i32);
pub const D3D12_VIDEO_ENCODER_AV1_PICTURE_CONTROL_FLAG_FORCE_INTEGER_MOTION_VECTORS: D3D12_VIDEO_ENCODER_AV1_PICTURE_CONTROL_FLAGS = D3D12_VIDEO_ENCODER_AV1_PICTURE_CONTROL_FLAGS(32i32);
pub const D3D12_VIDEO_ENCODER_AV1_PICTURE_CONTROL_FLAG_FRAME_REFERENCE_MOTION_VECTORS: D3D12_VIDEO_ENCODER_AV1_PICTURE_CONTROL_FLAGS = D3D12_VIDEO_ENCODER_AV1_PICTURE_CONTROL_FLAGS(16i32);
pub const D3D12_VIDEO_ENCODER_AV1_PICTURE_CONTROL_FLAG_MOTION_MODE_SWITCHABLE: D3D12_VIDEO_ENCODER_AV1_PICTURE_CONTROL_FLAGS = D3D12_VIDEO_ENCODER_AV1_PICTURE_CONTROL_FLAGS(8192i32);
pub const D3D12_VIDEO_ENCODER_AV1_PICTURE_CONTROL_FLAG_NONE: D3D12_VIDEO_ENCODER_AV1_PICTURE_CONTROL_FLAGS = D3D12_VIDEO_ENCODER_AV1_PICTURE_CONTROL_FLAGS(0i32);
pub const D3D12_VIDEO_ENCODER_AV1_PICTURE_CONTROL_FLAG_REDUCED_TX_SET: D3D12_VIDEO_ENCODER_AV1_PICTURE_CONTROL_FLAGS = D3D12_VIDEO_ENCODER_AV1_PICTURE_CONTROL_FLAGS(4096i32);
pub const D3D12_VIDEO_ENCODER_AV1_PICTURE_CONTROL_FLAG_USE_SUPER_RESOLUTION: D3D12_VIDEO_ENCODER_AV1_PICTURE_CONTROL_FLAGS = D3D12_VIDEO_ENCODER_AV1_PICTURE_CONTROL_FLAGS(128i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_AV1_PICTURE_CONTROL_SUBREGIONS_LAYOUT_DATA_TILES {
    pub RowCount: u64,
    pub ColCount: u64,
    pub RowHeights: [u64; 64],
    pub ColWidths: [u64; 64],
    pub ContextUpdateTileId: u64,
}
impl Default for D3D12_VIDEO_ENCODER_AV1_PICTURE_CONTROL_SUBREGIONS_LAYOUT_DATA_TILES {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_AV1_POST_ENCODE_VALUES {
    pub CompoundPredictionType: u64,
    pub LoopFilter: D3D12_VIDEO_ENCODER_CODEC_AV1_LOOP_FILTER_CONFIG,
    pub LoopFilterDelta: D3D12_VIDEO_ENCODER_CODEC_AV1_LOOP_FILTER_DELTA_CONFIG,
    pub Quantization: D3D12_VIDEO_ENCODER_CODEC_AV1_QUANTIZATION_CONFIG,
    pub QuantizationDelta: D3D12_VIDEO_ENCODER_CODEC_AV1_QUANTIZATION_DELTA_CONFIG,
    pub CDEF: D3D12_VIDEO_ENCODER_AV1_CDEF_CONFIG,
    pub SegmentationConfig: D3D12_VIDEO_ENCODER_AV1_SEGMENTATION_CONFIG,
    pub PrimaryRefFrame: u64,
    pub ReferenceIndices: [u64; 7],
}
impl Default for D3D12_VIDEO_ENCODER_AV1_POST_ENCODE_VALUES {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_AV1_POST_ENCODE_VALUES_FLAGS(pub i32);
impl D3D12_VIDEO_ENCODER_AV1_POST_ENCODE_VALUES_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for D3D12_VIDEO_ENCODER_AV1_POST_ENCODE_VALUES_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for D3D12_VIDEO_ENCODER_AV1_POST_ENCODE_VALUES_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for D3D12_VIDEO_ENCODER_AV1_POST_ENCODE_VALUES_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for D3D12_VIDEO_ENCODER_AV1_POST_ENCODE_VALUES_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for D3D12_VIDEO_ENCODER_AV1_POST_ENCODE_VALUES_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
pub const D3D12_VIDEO_ENCODER_AV1_POST_ENCODE_VALUES_FLAG_CDEF_DATA: D3D12_VIDEO_ENCODER_AV1_POST_ENCODE_VALUES_FLAGS = D3D12_VIDEO_ENCODER_AV1_POST_ENCODE_VALUES_FLAGS(16i32);
pub const D3D12_VIDEO_ENCODER_AV1_POST_ENCODE_VALUES_FLAG_COMPOUND_PREDICTION_MODE: D3D12_VIDEO_ENCODER_AV1_POST_ENCODE_VALUES_FLAGS = D3D12_VIDEO_ENCODER_AV1_POST_ENCODE_VALUES_FLAGS(64i32);
pub const D3D12_VIDEO_ENCODER_AV1_POST_ENCODE_VALUES_FLAG_CONTEXT_UPDATE_TILE_ID: D3D12_VIDEO_ENCODER_AV1_POST_ENCODE_VALUES_FLAGS = D3D12_VIDEO_ENCODER_AV1_POST_ENCODE_VALUES_FLAGS(32i32);
pub const D3D12_VIDEO_ENCODER_AV1_POST_ENCODE_VALUES_FLAG_LOOP_FILTER: D3D12_VIDEO_ENCODER_AV1_POST_ENCODE_VALUES_FLAGS = D3D12_VIDEO_ENCODER_AV1_POST_ENCODE_VALUES_FLAGS(4i32);
pub const D3D12_VIDEO_ENCODER_AV1_POST_ENCODE_VALUES_FLAG_LOOP_FILTER_DELTA: D3D12_VIDEO_ENCODER_AV1_POST_ENCODE_VALUES_FLAGS = D3D12_VIDEO_ENCODER_AV1_POST_ENCODE_VALUES_FLAGS(8i32);
pub const D3D12_VIDEO_ENCODER_AV1_POST_ENCODE_VALUES_FLAG_NONE: D3D12_VIDEO_ENCODER_AV1_POST_ENCODE_VALUES_FLAGS = D3D12_VIDEO_ENCODER_AV1_POST_ENCODE_VALUES_FLAGS(0i32);
pub const D3D12_VIDEO_ENCODER_AV1_POST_ENCODE_VALUES_FLAG_PRIMARY_REF_FRAME: D3D12_VIDEO_ENCODER_AV1_POST_ENCODE_VALUES_FLAGS = D3D12_VIDEO_ENCODER_AV1_POST_ENCODE_VALUES_FLAGS(128i32);
pub const D3D12_VIDEO_ENCODER_AV1_POST_ENCODE_VALUES_FLAG_QUANTIZATION: D3D12_VIDEO_ENCODER_AV1_POST_ENCODE_VALUES_FLAGS = D3D12_VIDEO_ENCODER_AV1_POST_ENCODE_VALUES_FLAGS(1i32);
pub const D3D12_VIDEO_ENCODER_AV1_POST_ENCODE_VALUES_FLAG_QUANTIZATION_DELTA: D3D12_VIDEO_ENCODER_AV1_POST_ENCODE_VALUES_FLAGS = D3D12_VIDEO_ENCODER_AV1_POST_ENCODE_VALUES_FLAGS(2i32);
pub const D3D12_VIDEO_ENCODER_AV1_POST_ENCODE_VALUES_FLAG_REFERENCE_INDICES: D3D12_VIDEO_ENCODER_AV1_POST_ENCODE_VALUES_FLAGS = D3D12_VIDEO_ENCODER_AV1_POST_ENCODE_VALUES_FLAGS(256i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_AV1_PROFILE(pub i32);
pub const D3D12_VIDEO_ENCODER_AV1_PROFILE_HIGH: D3D12_VIDEO_ENCODER_AV1_PROFILE = D3D12_VIDEO_ENCODER_AV1_PROFILE(1i32);
pub const D3D12_VIDEO_ENCODER_AV1_PROFILE_MAIN: D3D12_VIDEO_ENCODER_AV1_PROFILE = D3D12_VIDEO_ENCODER_AV1_PROFILE(0i32);
pub const D3D12_VIDEO_ENCODER_AV1_PROFILE_PROFESSIONAL: D3D12_VIDEO_ENCODER_AV1_PROFILE = D3D12_VIDEO_ENCODER_AV1_PROFILE(2i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_AV1_REFERENCE_PICTURE_DESCRIPTOR {
    pub ReconstructedPictureResourceIndex: u32,
    pub TemporalLayerIndexPlus1: u32,
    pub SpatialLayerIndexPlus1: u32,
    pub FrameType: D3D12_VIDEO_ENCODER_AV1_FRAME_TYPE,
    pub WarpedMotionInfo: D3D12_VIDEO_ENCODER_AV1_REFERENCE_PICTURE_WARPED_MOTION_INFO,
    pub OrderHint: u32,
    pub PictureIndex: u32,
}
impl Default for D3D12_VIDEO_ENCODER_AV1_REFERENCE_PICTURE_DESCRIPTOR {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_AV1_REFERENCE_PICTURE_WARPED_MOTION_INFO {
    pub TransformationType: D3D12_VIDEO_ENCODER_AV1_REFERENCE_WARPED_MOTION_TRANSFORMATION,
    pub TransformationMatrix: [i32; 8],
    pub InvalidAffineSet: super::super::Foundation::BOOL,
}
impl Default for D3D12_VIDEO_ENCODER_AV1_REFERENCE_PICTURE_WARPED_MOTION_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_AV1_REFERENCE_WARPED_MOTION_TRANSFORMATION(pub i32);
pub const D3D12_VIDEO_ENCODER_AV1_REFERENCE_WARPED_MOTION_TRANSFORMATION_AFFINE: D3D12_VIDEO_ENCODER_AV1_REFERENCE_WARPED_MOTION_TRANSFORMATION = D3D12_VIDEO_ENCODER_AV1_REFERENCE_WARPED_MOTION_TRANSFORMATION(3i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_AV1_REFERENCE_WARPED_MOTION_TRANSFORMATION_FLAGS(pub i32);
impl D3D12_VIDEO_ENCODER_AV1_REFERENCE_WARPED_MOTION_TRANSFORMATION_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for D3D12_VIDEO_ENCODER_AV1_REFERENCE_WARPED_MOTION_TRANSFORMATION_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for D3D12_VIDEO_ENCODER_AV1_REFERENCE_WARPED_MOTION_TRANSFORMATION_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for D3D12_VIDEO_ENCODER_AV1_REFERENCE_WARPED_MOTION_TRANSFORMATION_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for D3D12_VIDEO_ENCODER_AV1_REFERENCE_WARPED_MOTION_TRANSFORMATION_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for D3D12_VIDEO_ENCODER_AV1_REFERENCE_WARPED_MOTION_TRANSFORMATION_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
pub const D3D12_VIDEO_ENCODER_AV1_REFERENCE_WARPED_MOTION_TRANSFORMATION_FLAG_AFFINE: D3D12_VIDEO_ENCODER_AV1_REFERENCE_WARPED_MOTION_TRANSFORMATION_FLAGS = D3D12_VIDEO_ENCODER_AV1_REFERENCE_WARPED_MOTION_TRANSFORMATION_FLAGS(8i32);
pub const D3D12_VIDEO_ENCODER_AV1_REFERENCE_WARPED_MOTION_TRANSFORMATION_FLAG_IDENTITY: D3D12_VIDEO_ENCODER_AV1_REFERENCE_WARPED_MOTION_TRANSFORMATION_FLAGS = D3D12_VIDEO_ENCODER_AV1_REFERENCE_WARPED_MOTION_TRANSFORMATION_FLAGS(1i32);
pub const D3D12_VIDEO_ENCODER_AV1_REFERENCE_WARPED_MOTION_TRANSFORMATION_FLAG_NONE: D3D12_VIDEO_ENCODER_AV1_REFERENCE_WARPED_MOTION_TRANSFORMATION_FLAGS = D3D12_VIDEO_ENCODER_AV1_REFERENCE_WARPED_MOTION_TRANSFORMATION_FLAGS(0i32);
pub const D3D12_VIDEO_ENCODER_AV1_REFERENCE_WARPED_MOTION_TRANSFORMATION_FLAG_ROTZOOM: D3D12_VIDEO_ENCODER_AV1_REFERENCE_WARPED_MOTION_TRANSFORMATION_FLAGS = D3D12_VIDEO_ENCODER_AV1_REFERENCE_WARPED_MOTION_TRANSFORMATION_FLAGS(4i32);
pub const D3D12_VIDEO_ENCODER_AV1_REFERENCE_WARPED_MOTION_TRANSFORMATION_FLAG_TRANSLATION: D3D12_VIDEO_ENCODER_AV1_REFERENCE_WARPED_MOTION_TRANSFORMATION_FLAGS = D3D12_VIDEO_ENCODER_AV1_REFERENCE_WARPED_MOTION_TRANSFORMATION_FLAGS(2i32);
pub const D3D12_VIDEO_ENCODER_AV1_REFERENCE_WARPED_MOTION_TRANSFORMATION_IDENTITY: D3D12_VIDEO_ENCODER_AV1_REFERENCE_WARPED_MOTION_TRANSFORMATION = D3D12_VIDEO_ENCODER_AV1_REFERENCE_WARPED_MOTION_TRANSFORMATION(0i32);
pub const D3D12_VIDEO_ENCODER_AV1_REFERENCE_WARPED_MOTION_TRANSFORMATION_ROTZOOM: D3D12_VIDEO_ENCODER_AV1_REFERENCE_WARPED_MOTION_TRANSFORMATION = D3D12_VIDEO_ENCODER_AV1_REFERENCE_WARPED_MOTION_TRANSFORMATION(2i32);
pub const D3D12_VIDEO_ENCODER_AV1_REFERENCE_WARPED_MOTION_TRANSFORMATION_TRANSLATION: D3D12_VIDEO_ENCODER_AV1_REFERENCE_WARPED_MOTION_TRANSFORMATION = D3D12_VIDEO_ENCODER_AV1_REFERENCE_WARPED_MOTION_TRANSFORMATION(1i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_AV1_RESTORATION_CONFIG {
    pub FrameRestorationType: [D3D12_VIDEO_ENCODER_AV1_RESTORATION_TYPE; 3],
    pub LoopRestorationPixelSize: [D3D12_VIDEO_ENCODER_AV1_RESTORATION_TILESIZE; 3],
}
impl Default for D3D12_VIDEO_ENCODER_AV1_RESTORATION_CONFIG {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_AV1_RESTORATION_SUPPORT_FLAGS(pub i32);
impl D3D12_VIDEO_ENCODER_AV1_RESTORATION_SUPPORT_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for D3D12_VIDEO_ENCODER_AV1_RESTORATION_SUPPORT_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for D3D12_VIDEO_ENCODER_AV1_RESTORATION_SUPPORT_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for D3D12_VIDEO_ENCODER_AV1_RESTORATION_SUPPORT_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for D3D12_VIDEO_ENCODER_AV1_RESTORATION_SUPPORT_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for D3D12_VIDEO_ENCODER_AV1_RESTORATION_SUPPORT_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
pub const D3D12_VIDEO_ENCODER_AV1_RESTORATION_SUPPORT_FLAG_128x128: D3D12_VIDEO_ENCODER_AV1_RESTORATION_SUPPORT_FLAGS = D3D12_VIDEO_ENCODER_AV1_RESTORATION_SUPPORT_FLAGS(4i32);
pub const D3D12_VIDEO_ENCODER_AV1_RESTORATION_SUPPORT_FLAG_256x256: D3D12_VIDEO_ENCODER_AV1_RESTORATION_SUPPORT_FLAGS = D3D12_VIDEO_ENCODER_AV1_RESTORATION_SUPPORT_FLAGS(8i32);
pub const D3D12_VIDEO_ENCODER_AV1_RESTORATION_SUPPORT_FLAG_32x32: D3D12_VIDEO_ENCODER_AV1_RESTORATION_SUPPORT_FLAGS = D3D12_VIDEO_ENCODER_AV1_RESTORATION_SUPPORT_FLAGS(1i32);
pub const D3D12_VIDEO_ENCODER_AV1_RESTORATION_SUPPORT_FLAG_64x64: D3D12_VIDEO_ENCODER_AV1_RESTORATION_SUPPORT_FLAGS = D3D12_VIDEO_ENCODER_AV1_RESTORATION_SUPPORT_FLAGS(2i32);
pub const D3D12_VIDEO_ENCODER_AV1_RESTORATION_SUPPORT_FLAG_NOT_SUPPORTED: D3D12_VIDEO_ENCODER_AV1_RESTORATION_SUPPORT_FLAGS = D3D12_VIDEO_ENCODER_AV1_RESTORATION_SUPPORT_FLAGS(0i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_AV1_RESTORATION_TILESIZE(pub i32);
pub const D3D12_VIDEO_ENCODER_AV1_RESTORATION_TILESIZE_128x128: D3D12_VIDEO_ENCODER_AV1_RESTORATION_TILESIZE = D3D12_VIDEO_ENCODER_AV1_RESTORATION_TILESIZE(3i32);
pub const D3D12_VIDEO_ENCODER_AV1_RESTORATION_TILESIZE_256x256: D3D12_VIDEO_ENCODER_AV1_RESTORATION_TILESIZE = D3D12_VIDEO_ENCODER_AV1_RESTORATION_TILESIZE(4i32);
pub const D3D12_VIDEO_ENCODER_AV1_RESTORATION_TILESIZE_32x32: D3D12_VIDEO_ENCODER_AV1_RESTORATION_TILESIZE = D3D12_VIDEO_ENCODER_AV1_RESTORATION_TILESIZE(1i32);
pub const D3D12_VIDEO_ENCODER_AV1_RESTORATION_TILESIZE_64x64: D3D12_VIDEO_ENCODER_AV1_RESTORATION_TILESIZE = D3D12_VIDEO_ENCODER_AV1_RESTORATION_TILESIZE(2i32);
pub const D3D12_VIDEO_ENCODER_AV1_RESTORATION_TILESIZE_DISABLED: D3D12_VIDEO_ENCODER_AV1_RESTORATION_TILESIZE = D3D12_VIDEO_ENCODER_AV1_RESTORATION_TILESIZE(0i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_AV1_RESTORATION_TYPE(pub i32);
pub const D3D12_VIDEO_ENCODER_AV1_RESTORATION_TYPE_DISABLED: D3D12_VIDEO_ENCODER_AV1_RESTORATION_TYPE = D3D12_VIDEO_ENCODER_AV1_RESTORATION_TYPE(0i32);
pub const D3D12_VIDEO_ENCODER_AV1_RESTORATION_TYPE_SGRPROJ: D3D12_VIDEO_ENCODER_AV1_RESTORATION_TYPE = D3D12_VIDEO_ENCODER_AV1_RESTORATION_TYPE(3i32);
pub const D3D12_VIDEO_ENCODER_AV1_RESTORATION_TYPE_SWITCHABLE: D3D12_VIDEO_ENCODER_AV1_RESTORATION_TYPE = D3D12_VIDEO_ENCODER_AV1_RESTORATION_TYPE(1i32);
pub const D3D12_VIDEO_ENCODER_AV1_RESTORATION_TYPE_WIENER: D3D12_VIDEO_ENCODER_AV1_RESTORATION_TYPE = D3D12_VIDEO_ENCODER_AV1_RESTORATION_TYPE(2i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_AV1_SEGMENTATION_BLOCK_SIZE(pub i32);
pub const D3D12_VIDEO_ENCODER_AV1_SEGMENTATION_BLOCK_SIZE_16x16: D3D12_VIDEO_ENCODER_AV1_SEGMENTATION_BLOCK_SIZE = D3D12_VIDEO_ENCODER_AV1_SEGMENTATION_BLOCK_SIZE(2i32);
pub const D3D12_VIDEO_ENCODER_AV1_SEGMENTATION_BLOCK_SIZE_32x32: D3D12_VIDEO_ENCODER_AV1_SEGMENTATION_BLOCK_SIZE = D3D12_VIDEO_ENCODER_AV1_SEGMENTATION_BLOCK_SIZE(3i32);
pub const D3D12_VIDEO_ENCODER_AV1_SEGMENTATION_BLOCK_SIZE_4x4: D3D12_VIDEO_ENCODER_AV1_SEGMENTATION_BLOCK_SIZE = D3D12_VIDEO_ENCODER_AV1_SEGMENTATION_BLOCK_SIZE(0i32);
pub const D3D12_VIDEO_ENCODER_AV1_SEGMENTATION_BLOCK_SIZE_64x64: D3D12_VIDEO_ENCODER_AV1_SEGMENTATION_BLOCK_SIZE = D3D12_VIDEO_ENCODER_AV1_SEGMENTATION_BLOCK_SIZE(4i32);
pub const D3D12_VIDEO_ENCODER_AV1_SEGMENTATION_BLOCK_SIZE_8x8: D3D12_VIDEO_ENCODER_AV1_SEGMENTATION_BLOCK_SIZE = D3D12_VIDEO_ENCODER_AV1_SEGMENTATION_BLOCK_SIZE(1i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_AV1_SEGMENTATION_CONFIG {
    pub UpdateMap: u64,
    pub TemporalUpdate: u64,
    pub UpdateData: u64,
    pub NumSegments: u64,
    pub SegmentsData: [D3D12_VIDEO_ENCODER_AV1_SEGMENT_DATA; 8],
}
impl Default for D3D12_VIDEO_ENCODER_AV1_SEGMENTATION_CONFIG {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_AV1_SEGMENTATION_MAP {
    pub SegmentsMapByteSize: u32,
    pub pSegmentsMap: *mut u8,
}
impl Default for D3D12_VIDEO_ENCODER_AV1_SEGMENTATION_MAP {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_AV1_SEGMENTATION_MODE(pub i32);
pub const D3D12_VIDEO_ENCODER_AV1_SEGMENTATION_MODE_ALT_GLOBALMV: D3D12_VIDEO_ENCODER_AV1_SEGMENTATION_MODE = D3D12_VIDEO_ENCODER_AV1_SEGMENTATION_MODE(8i32);
pub const D3D12_VIDEO_ENCODER_AV1_SEGMENTATION_MODE_ALT_LF_U: D3D12_VIDEO_ENCODER_AV1_SEGMENTATION_MODE = D3D12_VIDEO_ENCODER_AV1_SEGMENTATION_MODE(4i32);
pub const D3D12_VIDEO_ENCODER_AV1_SEGMENTATION_MODE_ALT_LF_V: D3D12_VIDEO_ENCODER_AV1_SEGMENTATION_MODE = D3D12_VIDEO_ENCODER_AV1_SEGMENTATION_MODE(5i32);
pub const D3D12_VIDEO_ENCODER_AV1_SEGMENTATION_MODE_ALT_LF_Y_H: D3D12_VIDEO_ENCODER_AV1_SEGMENTATION_MODE = D3D12_VIDEO_ENCODER_AV1_SEGMENTATION_MODE(3i32);
pub const D3D12_VIDEO_ENCODER_AV1_SEGMENTATION_MODE_ALT_LF_Y_V: D3D12_VIDEO_ENCODER_AV1_SEGMENTATION_MODE = D3D12_VIDEO_ENCODER_AV1_SEGMENTATION_MODE(2i32);
pub const D3D12_VIDEO_ENCODER_AV1_SEGMENTATION_MODE_ALT_Q: D3D12_VIDEO_ENCODER_AV1_SEGMENTATION_MODE = D3D12_VIDEO_ENCODER_AV1_SEGMENTATION_MODE(1i32);
pub const D3D12_VIDEO_ENCODER_AV1_SEGMENTATION_MODE_ALT_REF_FRAME: D3D12_VIDEO_ENCODER_AV1_SEGMENTATION_MODE = D3D12_VIDEO_ENCODER_AV1_SEGMENTATION_MODE(6i32);
pub const D3D12_VIDEO_ENCODER_AV1_SEGMENTATION_MODE_ALT_SKIP: D3D12_VIDEO_ENCODER_AV1_SEGMENTATION_MODE = D3D12_VIDEO_ENCODER_AV1_SEGMENTATION_MODE(7i32);
pub const D3D12_VIDEO_ENCODER_AV1_SEGMENTATION_MODE_DISABLED: D3D12_VIDEO_ENCODER_AV1_SEGMENTATION_MODE = D3D12_VIDEO_ENCODER_AV1_SEGMENTATION_MODE(0i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_AV1_SEGMENTATION_MODE_FLAGS(pub i32);
impl D3D12_VIDEO_ENCODER_AV1_SEGMENTATION_MODE_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for D3D12_VIDEO_ENCODER_AV1_SEGMENTATION_MODE_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for D3D12_VIDEO_ENCODER_AV1_SEGMENTATION_MODE_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for D3D12_VIDEO_ENCODER_AV1_SEGMENTATION_MODE_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for D3D12_VIDEO_ENCODER_AV1_SEGMENTATION_MODE_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for D3D12_VIDEO_ENCODER_AV1_SEGMENTATION_MODE_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
pub const D3D12_VIDEO_ENCODER_AV1_SEGMENTATION_MODE_FLAG_ALT_GLOBALMV: D3D12_VIDEO_ENCODER_AV1_SEGMENTATION_MODE_FLAGS = D3D12_VIDEO_ENCODER_AV1_SEGMENTATION_MODE_FLAGS(256i32);
pub const D3D12_VIDEO_ENCODER_AV1_SEGMENTATION_MODE_FLAG_ALT_LF_U: D3D12_VIDEO_ENCODER_AV1_SEGMENTATION_MODE_FLAGS = D3D12_VIDEO_ENCODER_AV1_SEGMENTATION_MODE_FLAGS(16i32);
pub const D3D12_VIDEO_ENCODER_AV1_SEGMENTATION_MODE_FLAG_ALT_LF_V: D3D12_VIDEO_ENCODER_AV1_SEGMENTATION_MODE_FLAGS = D3D12_VIDEO_ENCODER_AV1_SEGMENTATION_MODE_FLAGS(32i32);
pub const D3D12_VIDEO_ENCODER_AV1_SEGMENTATION_MODE_FLAG_ALT_LF_Y_H: D3D12_VIDEO_ENCODER_AV1_SEGMENTATION_MODE_FLAGS = D3D12_VIDEO_ENCODER_AV1_SEGMENTATION_MODE_FLAGS(8i32);
pub const D3D12_VIDEO_ENCODER_AV1_SEGMENTATION_MODE_FLAG_ALT_LF_Y_V: D3D12_VIDEO_ENCODER_AV1_SEGMENTATION_MODE_FLAGS = D3D12_VIDEO_ENCODER_AV1_SEGMENTATION_MODE_FLAGS(4i32);
pub const D3D12_VIDEO_ENCODER_AV1_SEGMENTATION_MODE_FLAG_ALT_Q: D3D12_VIDEO_ENCODER_AV1_SEGMENTATION_MODE_FLAGS = D3D12_VIDEO_ENCODER_AV1_SEGMENTATION_MODE_FLAGS(2i32);
pub const D3D12_VIDEO_ENCODER_AV1_SEGMENTATION_MODE_FLAG_ALT_SKIP: D3D12_VIDEO_ENCODER_AV1_SEGMENTATION_MODE_FLAGS = D3D12_VIDEO_ENCODER_AV1_SEGMENTATION_MODE_FLAGS(128i32);
pub const D3D12_VIDEO_ENCODER_AV1_SEGMENTATION_MODE_FLAG_DISABLED: D3D12_VIDEO_ENCODER_AV1_SEGMENTATION_MODE_FLAGS = D3D12_VIDEO_ENCODER_AV1_SEGMENTATION_MODE_FLAGS(1i32);
pub const D3D12_VIDEO_ENCODER_AV1_SEGMENTATION_MODE_FLAG_NONE: D3D12_VIDEO_ENCODER_AV1_SEGMENTATION_MODE_FLAGS = D3D12_VIDEO_ENCODER_AV1_SEGMENTATION_MODE_FLAGS(0i32);
pub const D3D12_VIDEO_ENCODER_AV1_SEGMENTATION_MODE_FLAG_REF_FRAME: D3D12_VIDEO_ENCODER_AV1_SEGMENTATION_MODE_FLAGS = D3D12_VIDEO_ENCODER_AV1_SEGMENTATION_MODE_FLAGS(64i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_AV1_SEGMENT_DATA {
    pub EnabledFeatures: u64,
    pub FeatureValue: [i64; 8],
}
impl Default for D3D12_VIDEO_ENCODER_AV1_SEGMENT_DATA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_AV1_SEQUENCE_STRUCTURE {
    pub IntraDistance: u32,
    pub InterFramePeriod: u32,
}
impl Default for D3D12_VIDEO_ENCODER_AV1_SEQUENCE_STRUCTURE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_AV1_TIER(pub i32);
pub const D3D12_VIDEO_ENCODER_AV1_TIER_HIGH: D3D12_VIDEO_ENCODER_AV1_TIER = D3D12_VIDEO_ENCODER_AV1_TIER(1i32);
pub const D3D12_VIDEO_ENCODER_AV1_TIER_MAIN: D3D12_VIDEO_ENCODER_AV1_TIER = D3D12_VIDEO_ENCODER_AV1_TIER(0i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_AV1_TX_MODE(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_AV1_TX_MODE_FLAGS(pub i32);
impl D3D12_VIDEO_ENCODER_AV1_TX_MODE_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for D3D12_VIDEO_ENCODER_AV1_TX_MODE_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for D3D12_VIDEO_ENCODER_AV1_TX_MODE_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for D3D12_VIDEO_ENCODER_AV1_TX_MODE_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for D3D12_VIDEO_ENCODER_AV1_TX_MODE_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for D3D12_VIDEO_ENCODER_AV1_TX_MODE_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
pub const D3D12_VIDEO_ENCODER_AV1_TX_MODE_FLAG_LARGEST: D3D12_VIDEO_ENCODER_AV1_TX_MODE_FLAGS = D3D12_VIDEO_ENCODER_AV1_TX_MODE_FLAGS(2i32);
pub const D3D12_VIDEO_ENCODER_AV1_TX_MODE_FLAG_NONE: D3D12_VIDEO_ENCODER_AV1_TX_MODE_FLAGS = D3D12_VIDEO_ENCODER_AV1_TX_MODE_FLAGS(0i32);
pub const D3D12_VIDEO_ENCODER_AV1_TX_MODE_FLAG_ONLY4x4: D3D12_VIDEO_ENCODER_AV1_TX_MODE_FLAGS = D3D12_VIDEO_ENCODER_AV1_TX_MODE_FLAGS(1i32);
pub const D3D12_VIDEO_ENCODER_AV1_TX_MODE_FLAG_SELECT: D3D12_VIDEO_ENCODER_AV1_TX_MODE_FLAGS = D3D12_VIDEO_ENCODER_AV1_TX_MODE_FLAGS(4i32);
pub const D3D12_VIDEO_ENCODER_AV1_TX_MODE_LARGEST: D3D12_VIDEO_ENCODER_AV1_TX_MODE = D3D12_VIDEO_ENCODER_AV1_TX_MODE(1i32);
pub const D3D12_VIDEO_ENCODER_AV1_TX_MODE_ONLY4x4: D3D12_VIDEO_ENCODER_AV1_TX_MODE = D3D12_VIDEO_ENCODER_AV1_TX_MODE(0i32);
pub const D3D12_VIDEO_ENCODER_AV1_TX_MODE_SELECT: D3D12_VIDEO_ENCODER_AV1_TX_MODE = D3D12_VIDEO_ENCODER_AV1_TX_MODE(2i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_CODEC(pub i32);
pub const D3D12_VIDEO_ENCODER_CODEC_AV1: D3D12_VIDEO_ENCODER_CODEC = D3D12_VIDEO_ENCODER_CODEC(2i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_CODEC_AV1_LOOP_FILTER_CONFIG {
    pub LoopFilterLevel: [u64; 2],
    pub LoopFilterLevelU: u64,
    pub LoopFilterLevelV: u64,
    pub LoopFilterSharpnessLevel: u64,
    pub LoopFilterDeltaEnabled: u64,
    pub UpdateRefDelta: u64,
    pub RefDeltas: [i64; 8],
    pub UpdateModeDelta: u64,
    pub ModeDeltas: [i64; 2],
}
impl Default for D3D12_VIDEO_ENCODER_CODEC_AV1_LOOP_FILTER_CONFIG {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_CODEC_AV1_LOOP_FILTER_DELTA_CONFIG {
    pub DeltaLFPresent: u64,
    pub DeltaLFMulti: u64,
    pub DeltaLFRes: u64,
}
impl Default for D3D12_VIDEO_ENCODER_CODEC_AV1_LOOP_FILTER_DELTA_CONFIG {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_CODEC_AV1_PICTURE_CONTROL_SUPPORT {
    pub PredictionMode: D3D12_VIDEO_ENCODER_AV1_COMP_PREDICTION_TYPE,
    pub MaxUniqueReferencesPerFrame: u32,
    pub SupportedFrameTypes: D3D12_VIDEO_ENCODER_AV1_FRAME_TYPE_FLAGS,
    pub SupportedReferenceWarpedMotionFlags: D3D12_VIDEO_ENCODER_AV1_REFERENCE_WARPED_MOTION_TRANSFORMATION_FLAGS,
}
impl Default for D3D12_VIDEO_ENCODER_CODEC_AV1_PICTURE_CONTROL_SUPPORT {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_CODEC_AV1_QUANTIZATION_CONFIG {
    pub BaseQIndex: u64,
    pub YDCDeltaQ: i64,
    pub UDCDeltaQ: i64,
    pub UACDeltaQ: i64,
    pub VDCDeltaQ: i64,
    pub VACDeltaQ: i64,
    pub UsingQMatrix: u64,
    pub QMY: u64,
    pub QMU: u64,
    pub QMV: u64,
}
impl Default for D3D12_VIDEO_ENCODER_CODEC_AV1_QUANTIZATION_CONFIG {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_CODEC_AV1_QUANTIZATION_DELTA_CONFIG {
    pub DeltaQPresent: u64,
    pub DeltaQRes: u64,
}
impl Default for D3D12_VIDEO_ENCODER_CODEC_AV1_QUANTIZATION_DELTA_CONFIG {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub struct D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION {
    pub DataSize: u32,
    pub Anonymous: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_0,
}
impl Default for D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_0 {
    pub pH264Config: *mut D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264,
    pub pHEVCConfig: *mut D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC,
    pub pAV1Config: *mut D3D12_VIDEO_ENCODER_AV1_CODEC_CONFIGURATION,
}
impl Default for D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264 {
    pub ConfigurationFlags: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264_FLAGS,
    pub DirectModeConfig: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264_DIRECT_MODES,
    pub DisableDeblockingFilterConfig: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264_SLICES_DEBLOCKING_MODES,
}
impl Default for D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264_DIRECT_MODES(pub i32);
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264_DIRECT_MODES_DISABLED: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264_DIRECT_MODES = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264_DIRECT_MODES(0i32);
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264_DIRECT_MODES_SPATIAL: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264_DIRECT_MODES = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264_DIRECT_MODES(2i32);
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264_DIRECT_MODES_TEMPORAL: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264_DIRECT_MODES = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264_DIRECT_MODES(1i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264_FLAGS(pub i32);
impl D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264_FLAG_ALLOW_REQUEST_INTRA_CONSTRAINED_SLICES: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264_FLAGS = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264_FLAGS(8i32);
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264_FLAG_ENABLE_CABAC_ENCODING: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264_FLAGS = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264_FLAGS(4i32);
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264_FLAG_NONE: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264_FLAGS = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264_FLAGS(0i32);
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264_FLAG_USE_ADAPTIVE_8x8_TRANSFORM: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264_FLAGS = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264_FLAGS(2i32);
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264_FLAG_USE_CONSTRAINED_INTRAPREDICTION: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264_FLAGS = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264_FLAGS(1i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264_SLICES_DEBLOCKING_MODES(pub i32);
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264_SLICES_DEBLOCKING_MODE_0_ALL_LUMA_CHROMA_SLICE_BLOCK_EDGES_ALWAYS_FILTERED: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264_SLICES_DEBLOCKING_MODES = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264_SLICES_DEBLOCKING_MODES(0i32);
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264_SLICES_DEBLOCKING_MODE_1_DISABLE_ALL_SLICE_BLOCK_EDGES: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264_SLICES_DEBLOCKING_MODES = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264_SLICES_DEBLOCKING_MODES(1i32);
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264_SLICES_DEBLOCKING_MODE_2_DISABLE_SLICE_BOUNDARIES_BLOCKS: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264_SLICES_DEBLOCKING_MODES = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264_SLICES_DEBLOCKING_MODES(2i32);
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264_SLICES_DEBLOCKING_MODE_3_USE_TWO_STAGE_DEBLOCKING: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264_SLICES_DEBLOCKING_MODES = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264_SLICES_DEBLOCKING_MODES(3i32);
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264_SLICES_DEBLOCKING_MODE_4_DISABLE_CHROMA_BLOCK_EDGES: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264_SLICES_DEBLOCKING_MODES = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264_SLICES_DEBLOCKING_MODES(4i32);
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264_SLICES_DEBLOCKING_MODE_5_DISABLE_CHROMA_BLOCK_EDGES_AND_LUMA_BOUNDARIES: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264_SLICES_DEBLOCKING_MODES = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264_SLICES_DEBLOCKING_MODES(5i32);
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264_SLICES_DEBLOCKING_MODE_6_DISABLE_CHROMA_BLOCK_EDGES_AND_USE_LUMA_TWO_STAGE_DEBLOCKING: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264_SLICES_DEBLOCKING_MODES = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264_SLICES_DEBLOCKING_MODES(6i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264_SLICES_DEBLOCKING_MODE_FLAGS(pub i32);
impl D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264_SLICES_DEBLOCKING_MODE_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264_SLICES_DEBLOCKING_MODE_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264_SLICES_DEBLOCKING_MODE_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264_SLICES_DEBLOCKING_MODE_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264_SLICES_DEBLOCKING_MODE_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264_SLICES_DEBLOCKING_MODE_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264_SLICES_DEBLOCKING_MODE_FLAG_0_ALL_LUMA_CHROMA_SLICE_BLOCK_EDGES_ALWAYS_FILTERED: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264_SLICES_DEBLOCKING_MODE_FLAGS = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264_SLICES_DEBLOCKING_MODE_FLAGS(1i32);
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264_SLICES_DEBLOCKING_MODE_FLAG_1_DISABLE_ALL_SLICE_BLOCK_EDGES: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264_SLICES_DEBLOCKING_MODE_FLAGS = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264_SLICES_DEBLOCKING_MODE_FLAGS(2i32);
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264_SLICES_DEBLOCKING_MODE_FLAG_2_DISABLE_SLICE_BOUNDARIES_BLOCKS: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264_SLICES_DEBLOCKING_MODE_FLAGS = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264_SLICES_DEBLOCKING_MODE_FLAGS(4i32);
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264_SLICES_DEBLOCKING_MODE_FLAG_3_USE_TWO_STAGE_DEBLOCKING: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264_SLICES_DEBLOCKING_MODE_FLAGS = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264_SLICES_DEBLOCKING_MODE_FLAGS(8i32);
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264_SLICES_DEBLOCKING_MODE_FLAG_4_DISABLE_CHROMA_BLOCK_EDGES: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264_SLICES_DEBLOCKING_MODE_FLAGS = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264_SLICES_DEBLOCKING_MODE_FLAGS(16i32);
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264_SLICES_DEBLOCKING_MODE_FLAG_5_DISABLE_CHROMA_BLOCK_EDGES_AND_LUMA_BOUNDARIES: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264_SLICES_DEBLOCKING_MODE_FLAGS = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264_SLICES_DEBLOCKING_MODE_FLAGS(32i32);
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264_SLICES_DEBLOCKING_MODE_FLAG_6_DISABLE_CHROMA_BLOCK_EDGES_AND_USE_LUMA_TWO_STAGE_DEBLOCKING: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264_SLICES_DEBLOCKING_MODE_FLAGS = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264_SLICES_DEBLOCKING_MODE_FLAGS(64i32);
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264_SLICES_DEBLOCKING_MODE_FLAG_NONE: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264_SLICES_DEBLOCKING_MODE_FLAGS = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264_SLICES_DEBLOCKING_MODE_FLAGS(0i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC {
    pub ConfigurationFlags: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_FLAGS,
    pub MinLumaCodingUnitSize: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_CUSIZE,
    pub MaxLumaCodingUnitSize: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_CUSIZE,
    pub MinLumaTransformUnitSize: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_TUSIZE,
    pub MaxLumaTransformUnitSize: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_TUSIZE,
    pub max_transform_hierarchy_depth_inter: u8,
    pub max_transform_hierarchy_depth_intra: u8,
}
impl Default for D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_CUSIZE(pub i32);
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_CUSIZE_16x16: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_CUSIZE = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_CUSIZE(1i32);
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_CUSIZE_32x32: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_CUSIZE = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_CUSIZE(2i32);
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_CUSIZE_64x64: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_CUSIZE = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_CUSIZE(3i32);
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_CUSIZE_8x8: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_CUSIZE = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_CUSIZE(0i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_FLAGS(pub i32);
impl D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_FLAG_ALLOW_REQUEST_INTRA_CONSTRAINED_SLICES: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_FLAGS = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_FLAGS(2i32);
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_FLAG_CABAC_BYPASS_ALIGNMENT: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_FLAGS = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_FLAGS(32768i32);
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_FLAG_DISABLE_LOOP_FILTER_ACROSS_SLICES: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_FLAGS = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_FLAGS(1i32);
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_FLAG_ENABLE_LONG_TERM_REFERENCES: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_FLAGS = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_FLAGS(8i32);
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_FLAG_ENABLE_SAO_FILTER: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_FLAGS = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_FLAGS(4i32);
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_FLAG_ENABLE_TRANSFORM_SKIPPING: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_FLAGS = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_FLAGS(32i32);
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_FLAG_EXPLICIT_RDPCM: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_FLAGS = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_FLAGS(1024i32);
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_FLAG_EXTENDED_PRECISION_PROCESSING: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_FLAGS = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_FLAGS(2048i32);
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_FLAG_HIGH_PRECISION_OFFSETS: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_FLAGS = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_FLAGS(8192i32);
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_FLAG_IMPLICIT_RDPCM: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_FLAGS = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_FLAGS(512i32);
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_FLAG_INTRA_SMOOTHING_DISABLED: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_FLAGS = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_FLAGS(4096i32);
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_FLAG_NONE: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_FLAGS = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_FLAGS(0i32);
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_FLAG_PERSISTENT_RICE_ADAPTATION: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_FLAGS = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_FLAGS(16384i32);
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_FLAG_SEPARATE_COLOUR_PLANE: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_FLAGS = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_FLAGS(65536i32);
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_FLAG_TRANSFORM_SKIP_CONTEXT: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_FLAGS = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_FLAGS(256i32);
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_FLAG_TRANSFORM_SKIP_ROTATION: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_FLAGS = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_FLAGS(128i32);
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_FLAG_USE_ASYMETRIC_MOTION_PARTITION: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_FLAGS = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_FLAGS(16i32);
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_FLAG_USE_CONSTRAINED_INTRAPREDICTION: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_FLAGS = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_FLAGS(64i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_TUSIZE(pub i32);
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_TUSIZE_16x16: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_TUSIZE = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_TUSIZE(2i32);
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_TUSIZE_32x32: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_TUSIZE = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_TUSIZE(3i32);
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_TUSIZE_4x4: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_TUSIZE = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_TUSIZE(0i32);
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_TUSIZE_8x8: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_TUSIZE = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_TUSIZE(1i32);
#[repr(C)]
#[derive(Clone, Copy)]
pub struct D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT {
    pub DataSize: u32,
    pub Anonymous: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_0,
}
impl Default for D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_0 {
    pub pH264Support: *mut D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_H264,
    pub pHEVCSupport: *mut D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC,
    pub pHEVCSupport1: *mut D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC1,
    pub pAV1Support: *mut D3D12_VIDEO_ENCODER_AV1_CODEC_CONFIGURATION_SUPPORT,
}
impl Default for D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_H264 {
    pub SupportFlags: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_H264_FLAGS,
    pub DisableDeblockingFilterSupportedModes: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_H264_SLICES_DEBLOCKING_MODE_FLAGS,
}
impl Default for D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_H264 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_H264_FLAGS(pub i32);
impl D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_H264_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_H264_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_H264_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_H264_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_H264_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_H264_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_H264_FLAG_ADAPTIVE_8x8_TRANSFORM_ENCODING_SUPPORT: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_H264_FLAGS = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_H264_FLAGS(8i32);
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_H264_FLAG_BFRAME_LTR_COMBINED_SUPPORT: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_H264_FLAGS = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_H264_FLAGS(4i32);
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_H264_FLAG_CABAC_ENCODING_SUPPORT: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_H264_FLAGS = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_H264_FLAGS(1i32);
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_H264_FLAG_CONSTRAINED_INTRAPREDICTION_SUPPORT: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_H264_FLAGS = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_H264_FLAGS(64i32);
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_H264_FLAG_DIRECT_SPATIAL_ENCODING_SUPPORT: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_H264_FLAGS = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_H264_FLAGS(16i32);
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_H264_FLAG_DIRECT_TEMPORAL_ENCODING_SUPPORT: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_H264_FLAGS = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_H264_FLAGS(32i32);
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_H264_FLAG_INTRA_SLICE_CONSTRAINED_ENCODING_SUPPORT: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_H264_FLAGS = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_H264_FLAGS(2i32);
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_H264_FLAG_NONE: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_H264_FLAGS = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_H264_FLAGS(0i32);
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_H264_FLAG_NUM_REF_IDX_ACTIVE_OVERRIDE_FLAG_SLICE_SUPPORT: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_H264_FLAGS = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_H264_FLAGS(128i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC {
    pub SupportFlags: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAGS,
    pub MinLumaCodingUnitSize: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_CUSIZE,
    pub MaxLumaCodingUnitSize: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_CUSIZE,
    pub MinLumaTransformUnitSize: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_TUSIZE,
    pub MaxLumaTransformUnitSize: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_TUSIZE,
    pub max_transform_hierarchy_depth_inter: u8,
    pub max_transform_hierarchy_depth_intra: u8,
}
impl Default for D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC1 {
    pub SupportFlags: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAGS,
    pub MinLumaCodingUnitSize: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_CUSIZE,
    pub MaxLumaCodingUnitSize: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_CUSIZE,
    pub MinLumaTransformUnitSize: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_TUSIZE,
    pub MaxLumaTransformUnitSize: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_HEVC_TUSIZE,
    pub max_transform_hierarchy_depth_inter: u8,
    pub max_transform_hierarchy_depth_intra: u8,
    pub allowed_diff_cu_chroma_qp_offset_depth_values: u32,
    pub allowed_log2_sao_offset_scale_luma_values: u32,
    pub allowed_log2_sao_offset_scale_chroma_values: u32,
    pub allowed_log2_max_transform_skip_block_size_minus2_values: u32,
    pub allowed_chroma_qp_offset_list_len_minus1_values: u32,
    pub allowed_cb_qp_offset_list_values: [u32; 6],
    pub allowed_cr_qp_offset_list_values: [u32; 6],
    pub SupportFlags1: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAGS1,
}
impl Default for D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC1 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAG1_NONE: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAGS1 = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAGS1(0i32);
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAG1_SEPARATE_COLOUR_PLANE_REQUIRED: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAGS1 = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAGS1(2i32);
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAG1_SEPARATE_COLOUR_PLANE_SUPPORT: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAGS1 = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAGS1(1i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAGS(pub i32);
impl D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAGS1(pub i32);
impl D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAGS1 {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAGS1 {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAGS1 {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAGS1 {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAGS1 {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAGS1 {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAG_ASYMETRIC_MOTION_PARTITION_REQUIRED: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAGS = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAGS(32i32);
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAG_ASYMETRIC_MOTION_PARTITION_SUPPORT: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAGS = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAGS(16i32);
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAG_BFRAME_LTR_COMBINED_SUPPORT: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAGS = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAGS(1i32);
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAG_CABAC_BYPASS_ALIGNMENT_ENABLED_REQUIRED: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAGS = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAGS(134217728i32);
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAG_CABAC_BYPASS_ALIGNMENT_ENABLED_SUPPORT: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAGS = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAGS(67108864i32);
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAG_CHROMA_QP_OFFSET_LIST_ENABLED_FLAG_REQUIRED: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAGS = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAGS(-2147483648i32);
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAG_CHROMA_QP_OFFSET_LIST_ENABLED_FLAG_SUPPORT: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAGS = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAGS(1073741824i32);
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAG_CONSTRAINED_INTRAPREDICTION_SUPPORT: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAGS = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAGS(4i32);
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAG_CROSS_COMPONENT_PREDICTION_ENABLED_FLAG_REQUIRED: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAGS = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAGS(536870912i32);
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAG_CROSS_COMPONENT_PREDICTION_ENABLED_FLAG_SUPPORT: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAGS = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAGS(268435456i32);
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAG_DISABLING_LOOP_FILTER_ACROSS_SLICES_SUPPORT: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAGS = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAGS(128i32);
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAG_EXPLICIT_RDPCM_ENABLED_REQUIRED: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAGS = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAGS(131072i32);
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAG_EXPLICIT_RDPCM_ENABLED_SUPPORT: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAGS = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAGS(65536i32);
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAG_EXTENDED_PRECISION_PROCESSING_REQUIRED: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAGS = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAGS(524288i32);
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAG_EXTENDED_PRECISION_PROCESSING_SUPPORT: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAGS = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAGS(262144i32);
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAG_HIGH_PRECISION_OFFSETS_ENABLED_REQUIRED: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAGS = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAGS(8388608i32);
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAG_HIGH_PRECISION_OFFSETS_ENABLED_SUPPORT: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAGS = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAGS(4194304i32);
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAG_IMPLICIT_RDPCM_ENABLED_REQUIRED: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAGS = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAGS(32768i32);
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAG_IMPLICIT_RDPCM_ENABLED_SUPPORT: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAGS = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAGS(16384i32);
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAG_INTRA_SLICE_CONSTRAINED_ENCODING_SUPPORT: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAGS = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAGS(2i32);
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAG_INTRA_SMOOTHING_DISABLED_REQUIRED: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAGS = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAGS(2097152i32);
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAG_INTRA_SMOOTHING_DISABLED_SUPPORT: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAGS = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAGS(1048576i32);
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAG_NONE: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAGS = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAGS(0i32);
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAG_NUM_REF_IDX_ACTIVE_OVERRIDE_FLAG_SLICE_SUPPORT: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAGS = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAGS(512i32);
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAG_PERSISTENT_RICE_ADAPTATION_ENABLED_REQUIRED: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAGS = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAGS(33554432i32);
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAG_PERSISTENT_RICE_ADAPTATION_ENABLED_SUPPORT: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAGS = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAGS(16777216i32);
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAG_P_FRAMES_IMPLEMENTED_AS_LOW_DELAY_B_FRAMES: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAGS = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAGS(256i32);
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAG_SAO_FILTER_SUPPORT: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAGS = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAGS(8i32);
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAG_TRANSFORM_SKIP_CONTEXT_ENABLED_REQUIRED: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAGS = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAGS(8192i32);
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAG_TRANSFORM_SKIP_CONTEXT_ENABLED_SUPPORT: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAGS = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAGS(4096i32);
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAG_TRANSFORM_SKIP_ROTATION_ENABLED_REQUIRED: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAGS = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAGS(2048i32);
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAG_TRANSFORM_SKIP_ROTATION_ENABLED_SUPPORT: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAGS = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAGS(1024i32);
pub const D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAG_TRANSFORM_SKIP_SUPPORT: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAGS = D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION_SUPPORT_HEVC_FLAGS(64i32);
pub const D3D12_VIDEO_ENCODER_CODEC_H264: D3D12_VIDEO_ENCODER_CODEC = D3D12_VIDEO_ENCODER_CODEC(0i32);
pub const D3D12_VIDEO_ENCODER_CODEC_HEVC: D3D12_VIDEO_ENCODER_CODEC = D3D12_VIDEO_ENCODER_CODEC(1i32);
#[repr(C)]
#[derive(Clone, Copy)]
pub struct D3D12_VIDEO_ENCODER_CODEC_PICTURE_CONTROL_SUPPORT {
    pub DataSize: u32,
    pub Anonymous: D3D12_VIDEO_ENCODER_CODEC_PICTURE_CONTROL_SUPPORT_0,
}
impl Default for D3D12_VIDEO_ENCODER_CODEC_PICTURE_CONTROL_SUPPORT {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union D3D12_VIDEO_ENCODER_CODEC_PICTURE_CONTROL_SUPPORT_0 {
    pub pH264Support: *mut D3D12_VIDEO_ENCODER_CODEC_PICTURE_CONTROL_SUPPORT_H264,
    pub pHEVCSupport: *mut D3D12_VIDEO_ENCODER_CODEC_PICTURE_CONTROL_SUPPORT_HEVC,
    pub pAV1Support: *mut D3D12_VIDEO_ENCODER_CODEC_AV1_PICTURE_CONTROL_SUPPORT,
}
impl Default for D3D12_VIDEO_ENCODER_CODEC_PICTURE_CONTROL_SUPPORT_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_CODEC_PICTURE_CONTROL_SUPPORT_H264 {
    pub MaxL0ReferencesForP: u32,
    pub MaxL0ReferencesForB: u32,
    pub MaxL1ReferencesForB: u32,
    pub MaxLongTermReferences: u32,
    pub MaxDPBCapacity: u32,
}
impl Default for D3D12_VIDEO_ENCODER_CODEC_PICTURE_CONTROL_SUPPORT_H264 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_CODEC_PICTURE_CONTROL_SUPPORT_HEVC {
    pub MaxL0ReferencesForP: u32,
    pub MaxL0ReferencesForB: u32,
    pub MaxL1ReferencesForB: u32,
    pub MaxLongTermReferences: u32,
    pub MaxDPBCapacity: u32,
}
impl Default for D3D12_VIDEO_ENCODER_CODEC_PICTURE_CONTROL_SUPPORT_HEVC {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Direct3D12")]
#[derive(Clone, Debug, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_COMPRESSED_BITSTREAM {
    pub pBuffer: core::mem::ManuallyDrop<Option<super::super::Graphics::Direct3D12::ID3D12Resource>>,
    pub FrameStartOffset: u64,
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
impl Default for D3D12_VIDEO_ENCODER_COMPRESSED_BITSTREAM {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Dxgi_Common")]
#[derive(Clone, Copy)]
pub struct D3D12_VIDEO_ENCODER_DESC {
    pub NodeMask: u32,
    pub Flags: D3D12_VIDEO_ENCODER_FLAGS,
    pub EncodeCodec: D3D12_VIDEO_ENCODER_CODEC,
    pub EncodeProfile: D3D12_VIDEO_ENCODER_PROFILE_DESC,
    pub InputFormat: super::super::Graphics::Dxgi::Common::DXGI_FORMAT,
    pub CodecConfiguration: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION,
    pub MaxMotionEstimationPrecision: D3D12_VIDEO_ENCODER_MOTION_ESTIMATION_PRECISION_MODE,
}
#[cfg(feature = "Win32_Graphics_Dxgi_Common")]
impl Default for D3D12_VIDEO_ENCODER_DESC {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
pub struct D3D12_VIDEO_ENCODER_ENCODEFRAME_INPUT_ARGUMENTS {
    pub SequenceControlDesc: D3D12_VIDEO_ENCODER_SEQUENCE_CONTROL_DESC,
    pub PictureControlDesc: D3D12_VIDEO_ENCODER_PICTURE_CONTROL_DESC,
    pub pInputFrame: core::mem::ManuallyDrop<Option<super::super::Graphics::Direct3D12::ID3D12Resource>>,
    pub InputFrameSubresource: u32,
    pub CurrentFrameBitstreamMetadataSize: u32,
}
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
impl Clone for D3D12_VIDEO_ENCODER_ENCODEFRAME_INPUT_ARGUMENTS {
    fn clone(&self) -> Self {
        unsafe { core::mem::transmute_copy(self) }
    }
}
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
impl Default for D3D12_VIDEO_ENCODER_ENCODEFRAME_INPUT_ARGUMENTS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Direct3D12")]
#[derive(Clone, Debug, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_ENCODEFRAME_OUTPUT_ARGUMENTS {
    pub Bitstream: D3D12_VIDEO_ENCODER_COMPRESSED_BITSTREAM,
    pub ReconstructedPicture: D3D12_VIDEO_ENCODER_RECONSTRUCTED_PICTURE,
    pub EncoderOutputMetadata: D3D12_VIDEO_ENCODER_ENCODE_OPERATION_METADATA_BUFFER,
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
impl Default for D3D12_VIDEO_ENCODER_ENCODEFRAME_OUTPUT_ARGUMENTS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_ENCODE_ERROR_FLAGS(pub i32);
impl D3D12_VIDEO_ENCODER_ENCODE_ERROR_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for D3D12_VIDEO_ENCODER_ENCODE_ERROR_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for D3D12_VIDEO_ENCODER_ENCODE_ERROR_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for D3D12_VIDEO_ENCODER_ENCODE_ERROR_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for D3D12_VIDEO_ENCODER_ENCODE_ERROR_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for D3D12_VIDEO_ENCODER_ENCODE_ERROR_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
pub const D3D12_VIDEO_ENCODER_ENCODE_ERROR_FLAG_CODEC_PICTURE_CONTROL_NOT_SUPPORTED: D3D12_VIDEO_ENCODER_ENCODE_ERROR_FLAGS = D3D12_VIDEO_ENCODER_ENCODE_ERROR_FLAGS(1i32);
pub const D3D12_VIDEO_ENCODER_ENCODE_ERROR_FLAG_INVALID_METADATA_BUFFER_SOURCE: D3D12_VIDEO_ENCODER_ENCODE_ERROR_FLAGS = D3D12_VIDEO_ENCODER_ENCODE_ERROR_FLAGS(16i32);
pub const D3D12_VIDEO_ENCODER_ENCODE_ERROR_FLAG_INVALID_REFERENCE_PICTURES: D3D12_VIDEO_ENCODER_ENCODE_ERROR_FLAGS = D3D12_VIDEO_ENCODER_ENCODE_ERROR_FLAGS(4i32);
pub const D3D12_VIDEO_ENCODER_ENCODE_ERROR_FLAG_NO_ERROR: D3D12_VIDEO_ENCODER_ENCODE_ERROR_FLAGS = D3D12_VIDEO_ENCODER_ENCODE_ERROR_FLAGS(0i32);
pub const D3D12_VIDEO_ENCODER_ENCODE_ERROR_FLAG_RECONFIGURATION_REQUEST_NOT_SUPPORTED: D3D12_VIDEO_ENCODER_ENCODE_ERROR_FLAGS = D3D12_VIDEO_ENCODER_ENCODE_ERROR_FLAGS(8i32);
pub const D3D12_VIDEO_ENCODER_ENCODE_ERROR_FLAG_SUBREGION_LAYOUT_CONFIGURATION_NOT_SUPPORTED: D3D12_VIDEO_ENCODER_ENCODE_ERROR_FLAGS = D3D12_VIDEO_ENCODER_ENCODE_ERROR_FLAGS(2i32);
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Direct3D12")]
#[derive(Clone, Debug, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_ENCODE_OPERATION_METADATA_BUFFER {
    pub pBuffer: core::mem::ManuallyDrop<Option<super::super::Graphics::Direct3D12::ID3D12Resource>>,
    pub Offset: u64,
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
impl Default for D3D12_VIDEO_ENCODER_ENCODE_OPERATION_METADATA_BUFFER {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_FLAGS(pub i32);
impl D3D12_VIDEO_ENCODER_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for D3D12_VIDEO_ENCODER_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for D3D12_VIDEO_ENCODER_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for D3D12_VIDEO_ENCODER_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for D3D12_VIDEO_ENCODER_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for D3D12_VIDEO_ENCODER_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
pub const D3D12_VIDEO_ENCODER_FLAG_NONE: D3D12_VIDEO_ENCODER_FLAGS = D3D12_VIDEO_ENCODER_FLAGS(0i32);
#[repr(C)]
#[derive(Clone, Copy)]
pub struct D3D12_VIDEO_ENCODER_FRAME_SUBREGION_LAYOUT_CONFIG_SUPPORT {
    pub DataSize: u32,
    pub Anonymous: D3D12_VIDEO_ENCODER_FRAME_SUBREGION_LAYOUT_CONFIG_SUPPORT_0,
}
impl Default for D3D12_VIDEO_ENCODER_FRAME_SUBREGION_LAYOUT_CONFIG_SUPPORT {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union D3D12_VIDEO_ENCODER_FRAME_SUBREGION_LAYOUT_CONFIG_SUPPORT_0 {
    pub pAV1Support: *mut D3D12_VIDEO_ENCODER_AV1_FRAME_SUBREGION_LAYOUT_CONFIG_SUPPORT,
}
impl Default for D3D12_VIDEO_ENCODER_FRAME_SUBREGION_LAYOUT_CONFIG_SUPPORT_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_FRAME_SUBREGION_LAYOUT_MODE(pub i32);
pub const D3D12_VIDEO_ENCODER_FRAME_SUBREGION_LAYOUT_MODE_BYTES_PER_SUBREGION: D3D12_VIDEO_ENCODER_FRAME_SUBREGION_LAYOUT_MODE = D3D12_VIDEO_ENCODER_FRAME_SUBREGION_LAYOUT_MODE(1i32);
pub const D3D12_VIDEO_ENCODER_FRAME_SUBREGION_LAYOUT_MODE_CONFIGURABLE_GRID_PARTITION: D3D12_VIDEO_ENCODER_FRAME_SUBREGION_LAYOUT_MODE = D3D12_VIDEO_ENCODER_FRAME_SUBREGION_LAYOUT_MODE(6i32);
pub const D3D12_VIDEO_ENCODER_FRAME_SUBREGION_LAYOUT_MODE_FULL_FRAME: D3D12_VIDEO_ENCODER_FRAME_SUBREGION_LAYOUT_MODE = D3D12_VIDEO_ENCODER_FRAME_SUBREGION_LAYOUT_MODE(0i32);
pub const D3D12_VIDEO_ENCODER_FRAME_SUBREGION_LAYOUT_MODE_SQUARE_UNITS_PER_SUBREGION_ROW_UNALIGNED: D3D12_VIDEO_ENCODER_FRAME_SUBREGION_LAYOUT_MODE = D3D12_VIDEO_ENCODER_FRAME_SUBREGION_LAYOUT_MODE(2i32);
pub const D3D12_VIDEO_ENCODER_FRAME_SUBREGION_LAYOUT_MODE_UNIFORM_GRID_PARTITION: D3D12_VIDEO_ENCODER_FRAME_SUBREGION_LAYOUT_MODE = D3D12_VIDEO_ENCODER_FRAME_SUBREGION_LAYOUT_MODE(5i32);
pub const D3D12_VIDEO_ENCODER_FRAME_SUBREGION_LAYOUT_MODE_UNIFORM_PARTITIONING_ROWS_PER_SUBREGION: D3D12_VIDEO_ENCODER_FRAME_SUBREGION_LAYOUT_MODE = D3D12_VIDEO_ENCODER_FRAME_SUBREGION_LAYOUT_MODE(3i32);
pub const D3D12_VIDEO_ENCODER_FRAME_SUBREGION_LAYOUT_MODE_UNIFORM_PARTITIONING_SUBREGIONS_PER_FRAME: D3D12_VIDEO_ENCODER_FRAME_SUBREGION_LAYOUT_MODE = D3D12_VIDEO_ENCODER_FRAME_SUBREGION_LAYOUT_MODE(4i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_FRAME_SUBREGION_METADATA {
    pub bSize: u64,
    pub bStartOffset: u64,
    pub bHeaderSize: u64,
}
impl Default for D3D12_VIDEO_ENCODER_FRAME_SUBREGION_METADATA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_FRAME_TYPE_H264(pub i32);
pub const D3D12_VIDEO_ENCODER_FRAME_TYPE_H264_B_FRAME: D3D12_VIDEO_ENCODER_FRAME_TYPE_H264 = D3D12_VIDEO_ENCODER_FRAME_TYPE_H264(2i32);
pub const D3D12_VIDEO_ENCODER_FRAME_TYPE_H264_IDR_FRAME: D3D12_VIDEO_ENCODER_FRAME_TYPE_H264 = D3D12_VIDEO_ENCODER_FRAME_TYPE_H264(3i32);
pub const D3D12_VIDEO_ENCODER_FRAME_TYPE_H264_I_FRAME: D3D12_VIDEO_ENCODER_FRAME_TYPE_H264 = D3D12_VIDEO_ENCODER_FRAME_TYPE_H264(0i32);
pub const D3D12_VIDEO_ENCODER_FRAME_TYPE_H264_P_FRAME: D3D12_VIDEO_ENCODER_FRAME_TYPE_H264 = D3D12_VIDEO_ENCODER_FRAME_TYPE_H264(1i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_FRAME_TYPE_HEVC(pub i32);
pub const D3D12_VIDEO_ENCODER_FRAME_TYPE_HEVC_B_FRAME: D3D12_VIDEO_ENCODER_FRAME_TYPE_HEVC = D3D12_VIDEO_ENCODER_FRAME_TYPE_HEVC(2i32);
pub const D3D12_VIDEO_ENCODER_FRAME_TYPE_HEVC_IDR_FRAME: D3D12_VIDEO_ENCODER_FRAME_TYPE_HEVC = D3D12_VIDEO_ENCODER_FRAME_TYPE_HEVC(3i32);
pub const D3D12_VIDEO_ENCODER_FRAME_TYPE_HEVC_I_FRAME: D3D12_VIDEO_ENCODER_FRAME_TYPE_HEVC = D3D12_VIDEO_ENCODER_FRAME_TYPE_HEVC(0i32);
pub const D3D12_VIDEO_ENCODER_FRAME_TYPE_HEVC_P_FRAME: D3D12_VIDEO_ENCODER_FRAME_TYPE_HEVC = D3D12_VIDEO_ENCODER_FRAME_TYPE_HEVC(1i32);
#[repr(C)]
#[derive(Clone, Copy)]
pub struct D3D12_VIDEO_ENCODER_HEAP_DESC {
    pub NodeMask: u32,
    pub Flags: D3D12_VIDEO_ENCODER_HEAP_FLAGS,
    pub EncodeCodec: D3D12_VIDEO_ENCODER_CODEC,
    pub EncodeProfile: D3D12_VIDEO_ENCODER_PROFILE_DESC,
    pub EncodeLevel: D3D12_VIDEO_ENCODER_LEVEL_SETTING,
    pub ResolutionsListCount: u32,
    pub pResolutionList: *const D3D12_VIDEO_ENCODER_PICTURE_RESOLUTION_DESC,
}
impl Default for D3D12_VIDEO_ENCODER_HEAP_DESC {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_HEAP_FLAGS(pub i32);
impl D3D12_VIDEO_ENCODER_HEAP_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for D3D12_VIDEO_ENCODER_HEAP_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for D3D12_VIDEO_ENCODER_HEAP_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for D3D12_VIDEO_ENCODER_HEAP_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for D3D12_VIDEO_ENCODER_HEAP_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for D3D12_VIDEO_ENCODER_HEAP_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
pub const D3D12_VIDEO_ENCODER_HEAP_FLAG_NONE: D3D12_VIDEO_ENCODER_HEAP_FLAGS = D3D12_VIDEO_ENCODER_HEAP_FLAGS(0i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_INTRA_REFRESH {
    pub Mode: D3D12_VIDEO_ENCODER_INTRA_REFRESH_MODE,
    pub IntraRefreshDuration: u32,
}
impl Default for D3D12_VIDEO_ENCODER_INTRA_REFRESH {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_INTRA_REFRESH_MODE(pub i32);
pub const D3D12_VIDEO_ENCODER_INTRA_REFRESH_MODE_NONE: D3D12_VIDEO_ENCODER_INTRA_REFRESH_MODE = D3D12_VIDEO_ENCODER_INTRA_REFRESH_MODE(0i32);
pub const D3D12_VIDEO_ENCODER_INTRA_REFRESH_MODE_ROW_BASED: D3D12_VIDEO_ENCODER_INTRA_REFRESH_MODE = D3D12_VIDEO_ENCODER_INTRA_REFRESH_MODE(1i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_LEVELS_H264(pub i32);
pub const D3D12_VIDEO_ENCODER_LEVELS_H264_1: D3D12_VIDEO_ENCODER_LEVELS_H264 = D3D12_VIDEO_ENCODER_LEVELS_H264(0i32);
pub const D3D12_VIDEO_ENCODER_LEVELS_H264_11: D3D12_VIDEO_ENCODER_LEVELS_H264 = D3D12_VIDEO_ENCODER_LEVELS_H264(2i32);
pub const D3D12_VIDEO_ENCODER_LEVELS_H264_12: D3D12_VIDEO_ENCODER_LEVELS_H264 = D3D12_VIDEO_ENCODER_LEVELS_H264(3i32);
pub const D3D12_VIDEO_ENCODER_LEVELS_H264_13: D3D12_VIDEO_ENCODER_LEVELS_H264 = D3D12_VIDEO_ENCODER_LEVELS_H264(4i32);
pub const D3D12_VIDEO_ENCODER_LEVELS_H264_1b: D3D12_VIDEO_ENCODER_LEVELS_H264 = D3D12_VIDEO_ENCODER_LEVELS_H264(1i32);
pub const D3D12_VIDEO_ENCODER_LEVELS_H264_2: D3D12_VIDEO_ENCODER_LEVELS_H264 = D3D12_VIDEO_ENCODER_LEVELS_H264(5i32);
pub const D3D12_VIDEO_ENCODER_LEVELS_H264_21: D3D12_VIDEO_ENCODER_LEVELS_H264 = D3D12_VIDEO_ENCODER_LEVELS_H264(6i32);
pub const D3D12_VIDEO_ENCODER_LEVELS_H264_22: D3D12_VIDEO_ENCODER_LEVELS_H264 = D3D12_VIDEO_ENCODER_LEVELS_H264(7i32);
pub const D3D12_VIDEO_ENCODER_LEVELS_H264_3: D3D12_VIDEO_ENCODER_LEVELS_H264 = D3D12_VIDEO_ENCODER_LEVELS_H264(8i32);
pub const D3D12_VIDEO_ENCODER_LEVELS_H264_31: D3D12_VIDEO_ENCODER_LEVELS_H264 = D3D12_VIDEO_ENCODER_LEVELS_H264(9i32);
pub const D3D12_VIDEO_ENCODER_LEVELS_H264_32: D3D12_VIDEO_ENCODER_LEVELS_H264 = D3D12_VIDEO_ENCODER_LEVELS_H264(10i32);
pub const D3D12_VIDEO_ENCODER_LEVELS_H264_4: D3D12_VIDEO_ENCODER_LEVELS_H264 = D3D12_VIDEO_ENCODER_LEVELS_H264(11i32);
pub const D3D12_VIDEO_ENCODER_LEVELS_H264_41: D3D12_VIDEO_ENCODER_LEVELS_H264 = D3D12_VIDEO_ENCODER_LEVELS_H264(12i32);
pub const D3D12_VIDEO_ENCODER_LEVELS_H264_42: D3D12_VIDEO_ENCODER_LEVELS_H264 = D3D12_VIDEO_ENCODER_LEVELS_H264(13i32);
pub const D3D12_VIDEO_ENCODER_LEVELS_H264_5: D3D12_VIDEO_ENCODER_LEVELS_H264 = D3D12_VIDEO_ENCODER_LEVELS_H264(14i32);
pub const D3D12_VIDEO_ENCODER_LEVELS_H264_51: D3D12_VIDEO_ENCODER_LEVELS_H264 = D3D12_VIDEO_ENCODER_LEVELS_H264(15i32);
pub const D3D12_VIDEO_ENCODER_LEVELS_H264_52: D3D12_VIDEO_ENCODER_LEVELS_H264 = D3D12_VIDEO_ENCODER_LEVELS_H264(16i32);
pub const D3D12_VIDEO_ENCODER_LEVELS_H264_6: D3D12_VIDEO_ENCODER_LEVELS_H264 = D3D12_VIDEO_ENCODER_LEVELS_H264(17i32);
pub const D3D12_VIDEO_ENCODER_LEVELS_H264_61: D3D12_VIDEO_ENCODER_LEVELS_H264 = D3D12_VIDEO_ENCODER_LEVELS_H264(18i32);
pub const D3D12_VIDEO_ENCODER_LEVELS_H264_62: D3D12_VIDEO_ENCODER_LEVELS_H264 = D3D12_VIDEO_ENCODER_LEVELS_H264(19i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_LEVELS_HEVC(pub i32);
pub const D3D12_VIDEO_ENCODER_LEVELS_HEVC_1: D3D12_VIDEO_ENCODER_LEVELS_HEVC = D3D12_VIDEO_ENCODER_LEVELS_HEVC(0i32);
pub const D3D12_VIDEO_ENCODER_LEVELS_HEVC_2: D3D12_VIDEO_ENCODER_LEVELS_HEVC = D3D12_VIDEO_ENCODER_LEVELS_HEVC(1i32);
pub const D3D12_VIDEO_ENCODER_LEVELS_HEVC_21: D3D12_VIDEO_ENCODER_LEVELS_HEVC = D3D12_VIDEO_ENCODER_LEVELS_HEVC(2i32);
pub const D3D12_VIDEO_ENCODER_LEVELS_HEVC_3: D3D12_VIDEO_ENCODER_LEVELS_HEVC = D3D12_VIDEO_ENCODER_LEVELS_HEVC(3i32);
pub const D3D12_VIDEO_ENCODER_LEVELS_HEVC_31: D3D12_VIDEO_ENCODER_LEVELS_HEVC = D3D12_VIDEO_ENCODER_LEVELS_HEVC(4i32);
pub const D3D12_VIDEO_ENCODER_LEVELS_HEVC_4: D3D12_VIDEO_ENCODER_LEVELS_HEVC = D3D12_VIDEO_ENCODER_LEVELS_HEVC(5i32);
pub const D3D12_VIDEO_ENCODER_LEVELS_HEVC_41: D3D12_VIDEO_ENCODER_LEVELS_HEVC = D3D12_VIDEO_ENCODER_LEVELS_HEVC(6i32);
pub const D3D12_VIDEO_ENCODER_LEVELS_HEVC_5: D3D12_VIDEO_ENCODER_LEVELS_HEVC = D3D12_VIDEO_ENCODER_LEVELS_HEVC(7i32);
pub const D3D12_VIDEO_ENCODER_LEVELS_HEVC_51: D3D12_VIDEO_ENCODER_LEVELS_HEVC = D3D12_VIDEO_ENCODER_LEVELS_HEVC(8i32);
pub const D3D12_VIDEO_ENCODER_LEVELS_HEVC_52: D3D12_VIDEO_ENCODER_LEVELS_HEVC = D3D12_VIDEO_ENCODER_LEVELS_HEVC(9i32);
pub const D3D12_VIDEO_ENCODER_LEVELS_HEVC_6: D3D12_VIDEO_ENCODER_LEVELS_HEVC = D3D12_VIDEO_ENCODER_LEVELS_HEVC(10i32);
pub const D3D12_VIDEO_ENCODER_LEVELS_HEVC_61: D3D12_VIDEO_ENCODER_LEVELS_HEVC = D3D12_VIDEO_ENCODER_LEVELS_HEVC(11i32);
pub const D3D12_VIDEO_ENCODER_LEVELS_HEVC_62: D3D12_VIDEO_ENCODER_LEVELS_HEVC = D3D12_VIDEO_ENCODER_LEVELS_HEVC(12i32);
#[repr(C)]
#[derive(Clone, Copy)]
pub struct D3D12_VIDEO_ENCODER_LEVEL_SETTING {
    pub DataSize: u32,
    pub Anonymous: D3D12_VIDEO_ENCODER_LEVEL_SETTING_0,
}
impl Default for D3D12_VIDEO_ENCODER_LEVEL_SETTING {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union D3D12_VIDEO_ENCODER_LEVEL_SETTING_0 {
    pub pH264LevelSetting: *mut D3D12_VIDEO_ENCODER_LEVELS_H264,
    pub pHEVCLevelSetting: *mut D3D12_VIDEO_ENCODER_LEVEL_TIER_CONSTRAINTS_HEVC,
    pub pAV1LevelSetting: *mut D3D12_VIDEO_ENCODER_AV1_LEVEL_TIER_CONSTRAINTS,
}
impl Default for D3D12_VIDEO_ENCODER_LEVEL_SETTING_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_LEVEL_TIER_CONSTRAINTS_HEVC {
    pub Level: D3D12_VIDEO_ENCODER_LEVELS_HEVC,
    pub Tier: D3D12_VIDEO_ENCODER_TIER_HEVC,
}
impl Default for D3D12_VIDEO_ENCODER_LEVEL_TIER_CONSTRAINTS_HEVC {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_MOTION_ESTIMATION_PRECISION_MODE(pub i32);
pub const D3D12_VIDEO_ENCODER_MOTION_ESTIMATION_PRECISION_MODE_EIGHTH_PIXEL: D3D12_VIDEO_ENCODER_MOTION_ESTIMATION_PRECISION_MODE = D3D12_VIDEO_ENCODER_MOTION_ESTIMATION_PRECISION_MODE(4i32);
pub const D3D12_VIDEO_ENCODER_MOTION_ESTIMATION_PRECISION_MODE_FULL_PIXEL: D3D12_VIDEO_ENCODER_MOTION_ESTIMATION_PRECISION_MODE = D3D12_VIDEO_ENCODER_MOTION_ESTIMATION_PRECISION_MODE(1i32);
pub const D3D12_VIDEO_ENCODER_MOTION_ESTIMATION_PRECISION_MODE_HALF_PIXEL: D3D12_VIDEO_ENCODER_MOTION_ESTIMATION_PRECISION_MODE = D3D12_VIDEO_ENCODER_MOTION_ESTIMATION_PRECISION_MODE(2i32);
pub const D3D12_VIDEO_ENCODER_MOTION_ESTIMATION_PRECISION_MODE_MAXIMUM: D3D12_VIDEO_ENCODER_MOTION_ESTIMATION_PRECISION_MODE = D3D12_VIDEO_ENCODER_MOTION_ESTIMATION_PRECISION_MODE(0i32);
pub const D3D12_VIDEO_ENCODER_MOTION_ESTIMATION_PRECISION_MODE_QUARTER_PIXEL: D3D12_VIDEO_ENCODER_MOTION_ESTIMATION_PRECISION_MODE = D3D12_VIDEO_ENCODER_MOTION_ESTIMATION_PRECISION_MODE(3i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_OUTPUT_METADATA {
    pub EncodeErrorFlags: u64,
    pub EncodeStats: D3D12_VIDEO_ENCODER_OUTPUT_METADATA_STATISTICS,
    pub EncodedBitstreamWrittenBytesCount: u64,
    pub WrittenSubregionsCount: u64,
}
impl Default for D3D12_VIDEO_ENCODER_OUTPUT_METADATA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_OUTPUT_METADATA_STATISTICS {
    pub AverageQP: u64,
    pub IntraCodingUnitsCount: u64,
    pub InterCodingUnitsCount: u64,
    pub SkipCodingUnitsCount: u64,
    pub AverageMotionEstimationXDirection: u64,
    pub AverageMotionEstimationYDirection: u64,
}
impl Default for D3D12_VIDEO_ENCODER_OUTPUT_METADATA_STATISTICS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub struct D3D12_VIDEO_ENCODER_PICTURE_CONTROL_CODEC_DATA {
    pub DataSize: u32,
    pub Anonymous: D3D12_VIDEO_ENCODER_PICTURE_CONTROL_CODEC_DATA_0,
}
impl Default for D3D12_VIDEO_ENCODER_PICTURE_CONTROL_CODEC_DATA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union D3D12_VIDEO_ENCODER_PICTURE_CONTROL_CODEC_DATA_0 {
    pub pH264PicData: *mut D3D12_VIDEO_ENCODER_PICTURE_CONTROL_CODEC_DATA_H264,
    pub pHEVCPicData: *mut D3D12_VIDEO_ENCODER_PICTURE_CONTROL_CODEC_DATA_HEVC,
    pub pHEVCPicData1: *mut D3D12_VIDEO_ENCODER_PICTURE_CONTROL_CODEC_DATA_HEVC1,
    pub pAV1PicData: *mut D3D12_VIDEO_ENCODER_AV1_PICTURE_CONTROL_CODEC_DATA,
}
impl Default for D3D12_VIDEO_ENCODER_PICTURE_CONTROL_CODEC_DATA_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_PICTURE_CONTROL_CODEC_DATA_H264 {
    pub Flags: D3D12_VIDEO_ENCODER_PICTURE_CONTROL_CODEC_DATA_H264_FLAGS,
    pub FrameType: D3D12_VIDEO_ENCODER_FRAME_TYPE_H264,
    pub pic_parameter_set_id: u32,
    pub idr_pic_id: u32,
    pub PictureOrderCountNumber: u32,
    pub FrameDecodingOrderNumber: u32,
    pub TemporalLayerIndex: u32,
    pub List0ReferenceFramesCount: u32,
    pub pList0ReferenceFrames: *mut u32,
    pub List1ReferenceFramesCount: u32,
    pub pList1ReferenceFrames: *mut u32,
    pub ReferenceFramesReconPictureDescriptorsCount: u32,
    pub pReferenceFramesReconPictureDescriptors: *mut D3D12_VIDEO_ENCODER_REFERENCE_PICTURE_DESCRIPTOR_H264,
    pub adaptive_ref_pic_marking_mode_flag: u8,
    pub RefPicMarkingOperationsCommandsCount: u32,
    pub pRefPicMarkingOperationsCommands: *mut D3D12_VIDEO_ENCODER_PICTURE_CONTROL_CODEC_DATA_H264_REFERENCE_PICTURE_MARKING_OPERATION,
    pub List0RefPicModificationsCount: u32,
    pub pList0RefPicModifications: *mut D3D12_VIDEO_ENCODER_PICTURE_CONTROL_CODEC_DATA_H264_REFERENCE_PICTURE_LIST_MODIFICATION_OPERATION,
    pub List1RefPicModificationsCount: u32,
    pub pList1RefPicModifications: *mut D3D12_VIDEO_ENCODER_PICTURE_CONTROL_CODEC_DATA_H264_REFERENCE_PICTURE_LIST_MODIFICATION_OPERATION,
    pub QPMapValuesCount: u32,
    pub pRateControlQPMap: *mut i8,
}
impl Default for D3D12_VIDEO_ENCODER_PICTURE_CONTROL_CODEC_DATA_H264 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_PICTURE_CONTROL_CODEC_DATA_H264_FLAGS(pub i32);
impl D3D12_VIDEO_ENCODER_PICTURE_CONTROL_CODEC_DATA_H264_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for D3D12_VIDEO_ENCODER_PICTURE_CONTROL_CODEC_DATA_H264_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for D3D12_VIDEO_ENCODER_PICTURE_CONTROL_CODEC_DATA_H264_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for D3D12_VIDEO_ENCODER_PICTURE_CONTROL_CODEC_DATA_H264_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for D3D12_VIDEO_ENCODER_PICTURE_CONTROL_CODEC_DATA_H264_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for D3D12_VIDEO_ENCODER_PICTURE_CONTROL_CODEC_DATA_H264_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
pub const D3D12_VIDEO_ENCODER_PICTURE_CONTROL_CODEC_DATA_H264_FLAG_NONE: D3D12_VIDEO_ENCODER_PICTURE_CONTROL_CODEC_DATA_H264_FLAGS = D3D12_VIDEO_ENCODER_PICTURE_CONTROL_CODEC_DATA_H264_FLAGS(0i32);
pub const D3D12_VIDEO_ENCODER_PICTURE_CONTROL_CODEC_DATA_H264_FLAG_REQUEST_INTRA_CONSTRAINED_SLICES: D3D12_VIDEO_ENCODER_PICTURE_CONTROL_CODEC_DATA_H264_FLAGS = D3D12_VIDEO_ENCODER_PICTURE_CONTROL_CODEC_DATA_H264_FLAGS(1i32);
pub const D3D12_VIDEO_ENCODER_PICTURE_CONTROL_CODEC_DATA_H264_FLAG_REQUEST_NUM_REF_IDX_ACTIVE_OVERRIDE_FLAG_SLICE: D3D12_VIDEO_ENCODER_PICTURE_CONTROL_CODEC_DATA_H264_FLAGS = D3D12_VIDEO_ENCODER_PICTURE_CONTROL_CODEC_DATA_H264_FLAGS(2i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_PICTURE_CONTROL_CODEC_DATA_H264_REFERENCE_PICTURE_LIST_MODIFICATION_OPERATION {
    pub modification_of_pic_nums_idc: u8,
    pub abs_diff_pic_num_minus1: u32,
    pub long_term_pic_num: u32,
}
impl Default for D3D12_VIDEO_ENCODER_PICTURE_CONTROL_CODEC_DATA_H264_REFERENCE_PICTURE_LIST_MODIFICATION_OPERATION {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_PICTURE_CONTROL_CODEC_DATA_H264_REFERENCE_PICTURE_MARKING_OPERATION {
    pub memory_management_control_operation: u8,
    pub difference_of_pic_nums_minus1: u32,
    pub long_term_pic_num: u32,
    pub long_term_frame_idx: u32,
    pub max_long_term_frame_idx_plus1: u32,
}
impl Default for D3D12_VIDEO_ENCODER_PICTURE_CONTROL_CODEC_DATA_H264_REFERENCE_PICTURE_MARKING_OPERATION {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_PICTURE_CONTROL_CODEC_DATA_HEVC {
    pub Flags: D3D12_VIDEO_ENCODER_PICTURE_CONTROL_CODEC_DATA_HEVC_FLAGS,
    pub FrameType: D3D12_VIDEO_ENCODER_FRAME_TYPE_HEVC,
    pub slice_pic_parameter_set_id: u32,
    pub PictureOrderCountNumber: u32,
    pub TemporalLayerIndex: u32,
    pub List0ReferenceFramesCount: u32,
    pub pList0ReferenceFrames: *mut u32,
    pub List1ReferenceFramesCount: u32,
    pub pList1ReferenceFrames: *mut u32,
    pub ReferenceFramesReconPictureDescriptorsCount: u32,
    pub pReferenceFramesReconPictureDescriptors: *mut D3D12_VIDEO_ENCODER_REFERENCE_PICTURE_DESCRIPTOR_HEVC,
    pub List0RefPicModificationsCount: u32,
    pub pList0RefPicModifications: *mut u32,
    pub List1RefPicModificationsCount: u32,
    pub pList1RefPicModifications: *mut u32,
    pub QPMapValuesCount: u32,
    pub pRateControlQPMap: *mut i8,
}
impl Default for D3D12_VIDEO_ENCODER_PICTURE_CONTROL_CODEC_DATA_HEVC {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_PICTURE_CONTROL_CODEC_DATA_HEVC1 {
    pub Flags: D3D12_VIDEO_ENCODER_PICTURE_CONTROL_CODEC_DATA_HEVC_FLAGS,
    pub FrameType: D3D12_VIDEO_ENCODER_FRAME_TYPE_HEVC,
    pub slice_pic_parameter_set_id: u32,
    pub PictureOrderCountNumber: u32,
    pub TemporalLayerIndex: u32,
    pub List0ReferenceFramesCount: u32,
    pub pList0ReferenceFrames: *mut u32,
    pub List1ReferenceFramesCount: u32,
    pub pList1ReferenceFrames: *mut u32,
    pub ReferenceFramesReconPictureDescriptorsCount: u32,
    pub pReferenceFramesReconPictureDescriptors: *mut D3D12_VIDEO_ENCODER_REFERENCE_PICTURE_DESCRIPTOR_HEVC,
    pub List0RefPicModificationsCount: u32,
    pub pList0RefPicModifications: *mut u32,
    pub List1RefPicModificationsCount: u32,
    pub pList1RefPicModifications: *mut u32,
    pub QPMapValuesCount: u32,
    pub pRateControlQPMap: *mut i8,
    pub diff_cu_chroma_qp_offset_depth: u8,
    pub log2_sao_offset_scale_luma: u8,
    pub log2_sao_offset_scale_chroma: u8,
    pub log2_max_transform_skip_block_size_minus2: u8,
    pub chroma_qp_offset_list_len_minus1: u8,
    pub cb_qp_offset_list: [i8; 6],
    pub cr_qp_offset_list: [i8; 6],
}
impl Default for D3D12_VIDEO_ENCODER_PICTURE_CONTROL_CODEC_DATA_HEVC1 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_PICTURE_CONTROL_CODEC_DATA_HEVC_FLAGS(pub i32);
impl D3D12_VIDEO_ENCODER_PICTURE_CONTROL_CODEC_DATA_HEVC_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for D3D12_VIDEO_ENCODER_PICTURE_CONTROL_CODEC_DATA_HEVC_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for D3D12_VIDEO_ENCODER_PICTURE_CONTROL_CODEC_DATA_HEVC_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for D3D12_VIDEO_ENCODER_PICTURE_CONTROL_CODEC_DATA_HEVC_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for D3D12_VIDEO_ENCODER_PICTURE_CONTROL_CODEC_DATA_HEVC_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for D3D12_VIDEO_ENCODER_PICTURE_CONTROL_CODEC_DATA_HEVC_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
pub const D3D12_VIDEO_ENCODER_PICTURE_CONTROL_CODEC_DATA_HEVC_FLAG_CHROMA_QP_OFFSET_LIST: D3D12_VIDEO_ENCODER_PICTURE_CONTROL_CODEC_DATA_HEVC_FLAGS = D3D12_VIDEO_ENCODER_PICTURE_CONTROL_CODEC_DATA_HEVC_FLAGS(8i32);
pub const D3D12_VIDEO_ENCODER_PICTURE_CONTROL_CODEC_DATA_HEVC_FLAG_CROSS_COMPONENT_PREDICTION: D3D12_VIDEO_ENCODER_PICTURE_CONTROL_CODEC_DATA_HEVC_FLAGS = D3D12_VIDEO_ENCODER_PICTURE_CONTROL_CODEC_DATA_HEVC_FLAGS(4i32);
pub const D3D12_VIDEO_ENCODER_PICTURE_CONTROL_CODEC_DATA_HEVC_FLAG_NONE: D3D12_VIDEO_ENCODER_PICTURE_CONTROL_CODEC_DATA_HEVC_FLAGS = D3D12_VIDEO_ENCODER_PICTURE_CONTROL_CODEC_DATA_HEVC_FLAGS(0i32);
pub const D3D12_VIDEO_ENCODER_PICTURE_CONTROL_CODEC_DATA_HEVC_FLAG_REQUEST_INTRA_CONSTRAINED_SLICES: D3D12_VIDEO_ENCODER_PICTURE_CONTROL_CODEC_DATA_HEVC_FLAGS = D3D12_VIDEO_ENCODER_PICTURE_CONTROL_CODEC_DATA_HEVC_FLAGS(1i32);
pub const D3D12_VIDEO_ENCODER_PICTURE_CONTROL_CODEC_DATA_HEVC_FLAG_REQUEST_NUM_REF_IDX_ACTIVE_OVERRIDE_FLAG_SLICE: D3D12_VIDEO_ENCODER_PICTURE_CONTROL_CODEC_DATA_HEVC_FLAGS = D3D12_VIDEO_ENCODER_PICTURE_CONTROL_CODEC_DATA_HEVC_FLAGS(2i32);
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Direct3D12")]
#[derive(Clone, Copy)]
pub struct D3D12_VIDEO_ENCODER_PICTURE_CONTROL_DESC {
    pub IntraRefreshFrameIndex: u32,
    pub Flags: D3D12_VIDEO_ENCODER_PICTURE_CONTROL_FLAGS,
    pub PictureControlCodecData: D3D12_VIDEO_ENCODER_PICTURE_CONTROL_CODEC_DATA,
    pub ReferenceFrames: D3D12_VIDEO_ENCODE_REFERENCE_FRAMES,
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
impl Default for D3D12_VIDEO_ENCODER_PICTURE_CONTROL_DESC {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_PICTURE_CONTROL_FLAGS(pub i32);
impl D3D12_VIDEO_ENCODER_PICTURE_CONTROL_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for D3D12_VIDEO_ENCODER_PICTURE_CONTROL_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for D3D12_VIDEO_ENCODER_PICTURE_CONTROL_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for D3D12_VIDEO_ENCODER_PICTURE_CONTROL_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for D3D12_VIDEO_ENCODER_PICTURE_CONTROL_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for D3D12_VIDEO_ENCODER_PICTURE_CONTROL_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
pub const D3D12_VIDEO_ENCODER_PICTURE_CONTROL_FLAG_NONE: D3D12_VIDEO_ENCODER_PICTURE_CONTROL_FLAGS = D3D12_VIDEO_ENCODER_PICTURE_CONTROL_FLAGS(0i32);
pub const D3D12_VIDEO_ENCODER_PICTURE_CONTROL_FLAG_USED_AS_REFERENCE_PICTURE: D3D12_VIDEO_ENCODER_PICTURE_CONTROL_FLAGS = D3D12_VIDEO_ENCODER_PICTURE_CONTROL_FLAGS(1i32);
#[repr(C)]
#[derive(Clone, Copy)]
pub struct D3D12_VIDEO_ENCODER_PICTURE_CONTROL_SUBREGIONS_LAYOUT_DATA {
    pub DataSize: u32,
    pub Anonymous: D3D12_VIDEO_ENCODER_PICTURE_CONTROL_SUBREGIONS_LAYOUT_DATA_0,
}
impl Default for D3D12_VIDEO_ENCODER_PICTURE_CONTROL_SUBREGIONS_LAYOUT_DATA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union D3D12_VIDEO_ENCODER_PICTURE_CONTROL_SUBREGIONS_LAYOUT_DATA_0 {
    pub pSlicesPartition_H264: *const D3D12_VIDEO_ENCODER_PICTURE_CONTROL_SUBREGIONS_LAYOUT_DATA_SLICES,
    pub pSlicesPartition_HEVC: *const D3D12_VIDEO_ENCODER_PICTURE_CONTROL_SUBREGIONS_LAYOUT_DATA_SLICES,
    pub pTilesPartition_AV1: *const D3D12_VIDEO_ENCODER_AV1_PICTURE_CONTROL_SUBREGIONS_LAYOUT_DATA_TILES,
}
impl Default for D3D12_VIDEO_ENCODER_PICTURE_CONTROL_SUBREGIONS_LAYOUT_DATA_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub struct D3D12_VIDEO_ENCODER_PICTURE_CONTROL_SUBREGIONS_LAYOUT_DATA_SLICES {
    pub Anonymous: D3D12_VIDEO_ENCODER_PICTURE_CONTROL_SUBREGIONS_LAYOUT_DATA_SLICES_0,
}
impl Default for D3D12_VIDEO_ENCODER_PICTURE_CONTROL_SUBREGIONS_LAYOUT_DATA_SLICES {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union D3D12_VIDEO_ENCODER_PICTURE_CONTROL_SUBREGIONS_LAYOUT_DATA_SLICES_0 {
    pub MaxBytesPerSlice: u32,
    pub NumberOfCodingUnitsPerSlice: u32,
    pub NumberOfRowsPerSlice: u32,
    pub NumberOfSlicesPerFrame: u32,
}
impl Default for D3D12_VIDEO_ENCODER_PICTURE_CONTROL_SUBREGIONS_LAYOUT_DATA_SLICES_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_PICTURE_RESOLUTION_DESC {
    pub Width: u32,
    pub Height: u32,
}
impl Default for D3D12_VIDEO_ENCODER_PICTURE_RESOLUTION_DESC {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_PICTURE_RESOLUTION_RATIO_DESC {
    pub WidthRatio: u32,
    pub HeightRatio: u32,
}
impl Default for D3D12_VIDEO_ENCODER_PICTURE_RESOLUTION_RATIO_DESC {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub struct D3D12_VIDEO_ENCODER_PROFILE_DESC {
    pub DataSize: u32,
    pub Anonymous: D3D12_VIDEO_ENCODER_PROFILE_DESC_0,
}
impl Default for D3D12_VIDEO_ENCODER_PROFILE_DESC {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union D3D12_VIDEO_ENCODER_PROFILE_DESC_0 {
    pub pH264Profile: *mut D3D12_VIDEO_ENCODER_PROFILE_H264,
    pub pHEVCProfile: *mut D3D12_VIDEO_ENCODER_PROFILE_HEVC,
    pub pAV1Profile: *mut D3D12_VIDEO_ENCODER_AV1_PROFILE,
}
impl Default for D3D12_VIDEO_ENCODER_PROFILE_DESC_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_PROFILE_H264(pub i32);
pub const D3D12_VIDEO_ENCODER_PROFILE_H264_HIGH: D3D12_VIDEO_ENCODER_PROFILE_H264 = D3D12_VIDEO_ENCODER_PROFILE_H264(1i32);
pub const D3D12_VIDEO_ENCODER_PROFILE_H264_HIGH_10: D3D12_VIDEO_ENCODER_PROFILE_H264 = D3D12_VIDEO_ENCODER_PROFILE_H264(2i32);
pub const D3D12_VIDEO_ENCODER_PROFILE_H264_MAIN: D3D12_VIDEO_ENCODER_PROFILE_H264 = D3D12_VIDEO_ENCODER_PROFILE_H264(0i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_PROFILE_HEVC(pub i32);
pub const D3D12_VIDEO_ENCODER_PROFILE_HEVC_MAIN: D3D12_VIDEO_ENCODER_PROFILE_HEVC = D3D12_VIDEO_ENCODER_PROFILE_HEVC(0i32);
pub const D3D12_VIDEO_ENCODER_PROFILE_HEVC_MAIN10: D3D12_VIDEO_ENCODER_PROFILE_HEVC = D3D12_VIDEO_ENCODER_PROFILE_HEVC(1i32);
pub const D3D12_VIDEO_ENCODER_PROFILE_HEVC_MAIN10_422: D3D12_VIDEO_ENCODER_PROFILE_HEVC = D3D12_VIDEO_ENCODER_PROFILE_HEVC(3i32);
pub const D3D12_VIDEO_ENCODER_PROFILE_HEVC_MAIN10_444: D3D12_VIDEO_ENCODER_PROFILE_HEVC = D3D12_VIDEO_ENCODER_PROFILE_HEVC(6i32);
pub const D3D12_VIDEO_ENCODER_PROFILE_HEVC_MAIN12: D3D12_VIDEO_ENCODER_PROFILE_HEVC = D3D12_VIDEO_ENCODER_PROFILE_HEVC(2i32);
pub const D3D12_VIDEO_ENCODER_PROFILE_HEVC_MAIN12_422: D3D12_VIDEO_ENCODER_PROFILE_HEVC = D3D12_VIDEO_ENCODER_PROFILE_HEVC(4i32);
pub const D3D12_VIDEO_ENCODER_PROFILE_HEVC_MAIN12_444: D3D12_VIDEO_ENCODER_PROFILE_HEVC = D3D12_VIDEO_ENCODER_PROFILE_HEVC(7i32);
pub const D3D12_VIDEO_ENCODER_PROFILE_HEVC_MAIN16_444: D3D12_VIDEO_ENCODER_PROFILE_HEVC = D3D12_VIDEO_ENCODER_PROFILE_HEVC(8i32);
pub const D3D12_VIDEO_ENCODER_PROFILE_HEVC_MAIN_444: D3D12_VIDEO_ENCODER_PROFILE_HEVC = D3D12_VIDEO_ENCODER_PROFILE_HEVC(5i32);
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Dxgi_Common")]
#[derive(Clone, Copy)]
pub struct D3D12_VIDEO_ENCODER_RATE_CONTROL {
    pub Mode: D3D12_VIDEO_ENCODER_RATE_CONTROL_MODE,
    pub Flags: D3D12_VIDEO_ENCODER_RATE_CONTROL_FLAGS,
    pub ConfigParams: D3D12_VIDEO_ENCODER_RATE_CONTROL_CONFIGURATION_PARAMS,
    pub TargetFrameRate: super::super::Graphics::Dxgi::Common::DXGI_RATIONAL,
}
#[cfg(feature = "Win32_Graphics_Dxgi_Common")]
impl Default for D3D12_VIDEO_ENCODER_RATE_CONTROL {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_RATE_CONTROL_ABSOLUTE_QP_MAP {
    pub QualityVsSpeed: u32,
}
impl Default for D3D12_VIDEO_ENCODER_RATE_CONTROL_ABSOLUTE_QP_MAP {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_RATE_CONTROL_CBR {
    pub InitialQP: u32,
    pub MinQP: u32,
    pub MaxQP: u32,
    pub MaxFrameBitSize: u64,
    pub TargetBitRate: u64,
    pub VBVCapacity: u64,
    pub InitialVBVFullness: u64,
}
impl Default for D3D12_VIDEO_ENCODER_RATE_CONTROL_CBR {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_RATE_CONTROL_CBR1 {
    pub InitialQP: u32,
    pub MinQP: u32,
    pub MaxQP: u32,
    pub MaxFrameBitSize: u64,
    pub TargetBitRate: u64,
    pub VBVCapacity: u64,
    pub InitialVBVFullness: u64,
    pub QualityVsSpeed: u32,
}
impl Default for D3D12_VIDEO_ENCODER_RATE_CONTROL_CBR1 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub struct D3D12_VIDEO_ENCODER_RATE_CONTROL_CONFIGURATION_PARAMS {
    pub DataSize: u32,
    pub Anonymous: D3D12_VIDEO_ENCODER_RATE_CONTROL_CONFIGURATION_PARAMS_0,
}
impl Default for D3D12_VIDEO_ENCODER_RATE_CONTROL_CONFIGURATION_PARAMS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union D3D12_VIDEO_ENCODER_RATE_CONTROL_CONFIGURATION_PARAMS_0 {
    pub pConfiguration_CQP: *const D3D12_VIDEO_ENCODER_RATE_CONTROL_CQP,
    pub pConfiguration_CBR: *const D3D12_VIDEO_ENCODER_RATE_CONTROL_CBR,
    pub pConfiguration_VBR: *const D3D12_VIDEO_ENCODER_RATE_CONTROL_VBR,
    pub pConfiguration_QVBR: *const D3D12_VIDEO_ENCODER_RATE_CONTROL_QVBR,
    pub pConfiguration_CQP1: *const D3D12_VIDEO_ENCODER_RATE_CONTROL_CQP1,
    pub pConfiguration_CBR1: *const D3D12_VIDEO_ENCODER_RATE_CONTROL_CBR1,
    pub pConfiguration_VBR1: *const D3D12_VIDEO_ENCODER_RATE_CONTROL_VBR1,
    pub pConfiguration_QVBR1: *const D3D12_VIDEO_ENCODER_RATE_CONTROL_QVBR1,
    pub pConfiguration_AbsoluteQPMap: *const D3D12_VIDEO_ENCODER_RATE_CONTROL_ABSOLUTE_QP_MAP,
}
impl Default for D3D12_VIDEO_ENCODER_RATE_CONTROL_CONFIGURATION_PARAMS_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_RATE_CONTROL_CQP {
    pub ConstantQP_FullIntracodedFrame: u32,
    pub ConstantQP_InterPredictedFrame_PrevRefOnly: u32,
    pub ConstantQP_InterPredictedFrame_BiDirectionalRef: u32,
}
impl Default for D3D12_VIDEO_ENCODER_RATE_CONTROL_CQP {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_RATE_CONTROL_CQP1 {
    pub ConstantQP_FullIntracodedFrame: u32,
    pub ConstantQP_InterPredictedFrame_PrevRefOnly: u32,
    pub ConstantQP_InterPredictedFrame_BiDirectionalRef: u32,
    pub QualityVsSpeed: u32,
}
impl Default for D3D12_VIDEO_ENCODER_RATE_CONTROL_CQP1 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_RATE_CONTROL_FLAGS(pub i32);
impl D3D12_VIDEO_ENCODER_RATE_CONTROL_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for D3D12_VIDEO_ENCODER_RATE_CONTROL_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for D3D12_VIDEO_ENCODER_RATE_CONTROL_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for D3D12_VIDEO_ENCODER_RATE_CONTROL_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for D3D12_VIDEO_ENCODER_RATE_CONTROL_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for D3D12_VIDEO_ENCODER_RATE_CONTROL_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
pub const D3D12_VIDEO_ENCODER_RATE_CONTROL_FLAG_ENABLE_DELTA_QP: D3D12_VIDEO_ENCODER_RATE_CONTROL_FLAGS = D3D12_VIDEO_ENCODER_RATE_CONTROL_FLAGS(1i32);
pub const D3D12_VIDEO_ENCODER_RATE_CONTROL_FLAG_ENABLE_EXTENSION1_SUPPORT: D3D12_VIDEO_ENCODER_RATE_CONTROL_FLAGS = D3D12_VIDEO_ENCODER_RATE_CONTROL_FLAGS(64i32);
pub const D3D12_VIDEO_ENCODER_RATE_CONTROL_FLAG_ENABLE_FRAME_ANALYSIS: D3D12_VIDEO_ENCODER_RATE_CONTROL_FLAGS = D3D12_VIDEO_ENCODER_RATE_CONTROL_FLAGS(2i32);
pub const D3D12_VIDEO_ENCODER_RATE_CONTROL_FLAG_ENABLE_INITIAL_QP: D3D12_VIDEO_ENCODER_RATE_CONTROL_FLAGS = D3D12_VIDEO_ENCODER_RATE_CONTROL_FLAGS(8i32);
pub const D3D12_VIDEO_ENCODER_RATE_CONTROL_FLAG_ENABLE_MAX_FRAME_SIZE: D3D12_VIDEO_ENCODER_RATE_CONTROL_FLAGS = D3D12_VIDEO_ENCODER_RATE_CONTROL_FLAGS(16i32);
pub const D3D12_VIDEO_ENCODER_RATE_CONTROL_FLAG_ENABLE_QP_RANGE: D3D12_VIDEO_ENCODER_RATE_CONTROL_FLAGS = D3D12_VIDEO_ENCODER_RATE_CONTROL_FLAGS(4i32);
pub const D3D12_VIDEO_ENCODER_RATE_CONTROL_FLAG_ENABLE_QUALITY_VS_SPEED: D3D12_VIDEO_ENCODER_RATE_CONTROL_FLAGS = D3D12_VIDEO_ENCODER_RATE_CONTROL_FLAGS(128i32);
pub const D3D12_VIDEO_ENCODER_RATE_CONTROL_FLAG_ENABLE_VBV_SIZES: D3D12_VIDEO_ENCODER_RATE_CONTROL_FLAGS = D3D12_VIDEO_ENCODER_RATE_CONTROL_FLAGS(32i32);
pub const D3D12_VIDEO_ENCODER_RATE_CONTROL_FLAG_NONE: D3D12_VIDEO_ENCODER_RATE_CONTROL_FLAGS = D3D12_VIDEO_ENCODER_RATE_CONTROL_FLAGS(0i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_RATE_CONTROL_MODE(pub i32);
pub const D3D12_VIDEO_ENCODER_RATE_CONTROL_MODE_ABSOLUTE_QP_MAP: D3D12_VIDEO_ENCODER_RATE_CONTROL_MODE = D3D12_VIDEO_ENCODER_RATE_CONTROL_MODE(0i32);
pub const D3D12_VIDEO_ENCODER_RATE_CONTROL_MODE_CBR: D3D12_VIDEO_ENCODER_RATE_CONTROL_MODE = D3D12_VIDEO_ENCODER_RATE_CONTROL_MODE(2i32);
pub const D3D12_VIDEO_ENCODER_RATE_CONTROL_MODE_CQP: D3D12_VIDEO_ENCODER_RATE_CONTROL_MODE = D3D12_VIDEO_ENCODER_RATE_CONTROL_MODE(1i32);
pub const D3D12_VIDEO_ENCODER_RATE_CONTROL_MODE_QVBR: D3D12_VIDEO_ENCODER_RATE_CONTROL_MODE = D3D12_VIDEO_ENCODER_RATE_CONTROL_MODE(4i32);
pub const D3D12_VIDEO_ENCODER_RATE_CONTROL_MODE_VBR: D3D12_VIDEO_ENCODER_RATE_CONTROL_MODE = D3D12_VIDEO_ENCODER_RATE_CONTROL_MODE(3i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_RATE_CONTROL_QVBR {
    pub InitialQP: u32,
    pub MinQP: u32,
    pub MaxQP: u32,
    pub MaxFrameBitSize: u64,
    pub TargetAvgBitRate: u64,
    pub PeakBitRate: u64,
    pub ConstantQualityTarget: u32,
}
impl Default for D3D12_VIDEO_ENCODER_RATE_CONTROL_QVBR {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_RATE_CONTROL_QVBR1 {
    pub InitialQP: u32,
    pub MinQP: u32,
    pub MaxQP: u32,
    pub MaxFrameBitSize: u64,
    pub TargetAvgBitRate: u64,
    pub PeakBitRate: u64,
    pub ConstantQualityTarget: u32,
    pub VBVCapacity: u64,
    pub InitialVBVFullness: u64,
    pub QualityVsSpeed: u32,
}
impl Default for D3D12_VIDEO_ENCODER_RATE_CONTROL_QVBR1 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_RATE_CONTROL_VBR {
    pub InitialQP: u32,
    pub MinQP: u32,
    pub MaxQP: u32,
    pub MaxFrameBitSize: u64,
    pub TargetAvgBitRate: u64,
    pub PeakBitRate: u64,
    pub VBVCapacity: u64,
    pub InitialVBVFullness: u64,
}
impl Default for D3D12_VIDEO_ENCODER_RATE_CONTROL_VBR {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_RATE_CONTROL_VBR1 {
    pub InitialQP: u32,
    pub MinQP: u32,
    pub MaxQP: u32,
    pub MaxFrameBitSize: u64,
    pub TargetAvgBitRate: u64,
    pub PeakBitRate: u64,
    pub VBVCapacity: u64,
    pub InitialVBVFullness: u64,
    pub QualityVsSpeed: u32,
}
impl Default for D3D12_VIDEO_ENCODER_RATE_CONTROL_VBR1 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Direct3D12")]
#[derive(Clone, Debug, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_RECONSTRUCTED_PICTURE {
    pub pReconstructedPicture: core::mem::ManuallyDrop<Option<super::super::Graphics::Direct3D12::ID3D12Resource>>,
    pub ReconstructedPictureSubresource: u32,
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
impl Default for D3D12_VIDEO_ENCODER_RECONSTRUCTED_PICTURE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_REFERENCE_PICTURE_DESCRIPTOR_H264 {
    pub ReconstructedPictureResourceIndex: u32,
    pub IsLongTermReference: super::super::Foundation::BOOL,
    pub LongTermPictureIdx: u32,
    pub PictureOrderCountNumber: u32,
    pub FrameDecodingOrderNumber: u32,
    pub TemporalLayerIndex: u32,
}
impl Default for D3D12_VIDEO_ENCODER_REFERENCE_PICTURE_DESCRIPTOR_H264 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_REFERENCE_PICTURE_DESCRIPTOR_HEVC {
    pub ReconstructedPictureResourceIndex: u32,
    pub IsRefUsedByCurrentPic: super::super::Foundation::BOOL,
    pub IsLongTermReference: super::super::Foundation::BOOL,
    pub PictureOrderCountNumber: u32,
    pub TemporalLayerIndex: u32,
}
impl Default for D3D12_VIDEO_ENCODER_REFERENCE_PICTURE_DESCRIPTOR_HEVC {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
pub struct D3D12_VIDEO_ENCODER_RESOLVE_METADATA_INPUT_ARGUMENTS {
    pub EncoderCodec: D3D12_VIDEO_ENCODER_CODEC,
    pub EncoderProfile: D3D12_VIDEO_ENCODER_PROFILE_DESC,
    pub EncoderInputFormat: super::super::Graphics::Dxgi::Common::DXGI_FORMAT,
    pub EncodedPictureEffectiveResolution: D3D12_VIDEO_ENCODER_PICTURE_RESOLUTION_DESC,
    pub HWLayoutMetadata: D3D12_VIDEO_ENCODER_ENCODE_OPERATION_METADATA_BUFFER,
}
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
impl Clone for D3D12_VIDEO_ENCODER_RESOLVE_METADATA_INPUT_ARGUMENTS {
    fn clone(&self) -> Self {
        unsafe { core::mem::transmute_copy(self) }
    }
}
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
impl Default for D3D12_VIDEO_ENCODER_RESOLVE_METADATA_INPUT_ARGUMENTS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Direct3D12")]
#[derive(Clone, Debug, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_RESOLVE_METADATA_OUTPUT_ARGUMENTS {
    pub ResolvedLayoutMetadata: D3D12_VIDEO_ENCODER_ENCODE_OPERATION_METADATA_BUFFER,
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
impl Default for D3D12_VIDEO_ENCODER_RESOLVE_METADATA_OUTPUT_ARGUMENTS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Dxgi_Common")]
#[derive(Clone, Copy)]
pub struct D3D12_VIDEO_ENCODER_SEQUENCE_CONTROL_DESC {
    pub Flags: D3D12_VIDEO_ENCODER_SEQUENCE_CONTROL_FLAGS,
    pub IntraRefreshConfig: D3D12_VIDEO_ENCODER_INTRA_REFRESH,
    pub RateControl: D3D12_VIDEO_ENCODER_RATE_CONTROL,
    pub PictureTargetResolution: D3D12_VIDEO_ENCODER_PICTURE_RESOLUTION_DESC,
    pub SelectedLayoutMode: D3D12_VIDEO_ENCODER_FRAME_SUBREGION_LAYOUT_MODE,
    pub FrameSubregionsLayoutData: D3D12_VIDEO_ENCODER_PICTURE_CONTROL_SUBREGIONS_LAYOUT_DATA,
    pub CodecGopSequence: D3D12_VIDEO_ENCODER_SEQUENCE_GOP_STRUCTURE,
}
#[cfg(feature = "Win32_Graphics_Dxgi_Common")]
impl Default for D3D12_VIDEO_ENCODER_SEQUENCE_CONTROL_DESC {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_SEQUENCE_CONTROL_FLAGS(pub i32);
impl D3D12_VIDEO_ENCODER_SEQUENCE_CONTROL_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for D3D12_VIDEO_ENCODER_SEQUENCE_CONTROL_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for D3D12_VIDEO_ENCODER_SEQUENCE_CONTROL_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for D3D12_VIDEO_ENCODER_SEQUENCE_CONTROL_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for D3D12_VIDEO_ENCODER_SEQUENCE_CONTROL_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for D3D12_VIDEO_ENCODER_SEQUENCE_CONTROL_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
pub const D3D12_VIDEO_ENCODER_SEQUENCE_CONTROL_FLAG_GOP_SEQUENCE_CHANGE: D3D12_VIDEO_ENCODER_SEQUENCE_CONTROL_FLAGS = D3D12_VIDEO_ENCODER_SEQUENCE_CONTROL_FLAGS(16i32);
pub const D3D12_VIDEO_ENCODER_SEQUENCE_CONTROL_FLAG_NONE: D3D12_VIDEO_ENCODER_SEQUENCE_CONTROL_FLAGS = D3D12_VIDEO_ENCODER_SEQUENCE_CONTROL_FLAGS(0i32);
pub const D3D12_VIDEO_ENCODER_SEQUENCE_CONTROL_FLAG_RATE_CONTROL_CHANGE: D3D12_VIDEO_ENCODER_SEQUENCE_CONTROL_FLAGS = D3D12_VIDEO_ENCODER_SEQUENCE_CONTROL_FLAGS(2i32);
pub const D3D12_VIDEO_ENCODER_SEQUENCE_CONTROL_FLAG_REQUEST_INTRA_REFRESH: D3D12_VIDEO_ENCODER_SEQUENCE_CONTROL_FLAGS = D3D12_VIDEO_ENCODER_SEQUENCE_CONTROL_FLAGS(8i32);
pub const D3D12_VIDEO_ENCODER_SEQUENCE_CONTROL_FLAG_RESOLUTION_CHANGE: D3D12_VIDEO_ENCODER_SEQUENCE_CONTROL_FLAGS = D3D12_VIDEO_ENCODER_SEQUENCE_CONTROL_FLAGS(1i32);
pub const D3D12_VIDEO_ENCODER_SEQUENCE_CONTROL_FLAG_SUBREGION_LAYOUT_CHANGE: D3D12_VIDEO_ENCODER_SEQUENCE_CONTROL_FLAGS = D3D12_VIDEO_ENCODER_SEQUENCE_CONTROL_FLAGS(4i32);
#[repr(C)]
#[derive(Clone, Copy)]
pub struct D3D12_VIDEO_ENCODER_SEQUENCE_GOP_STRUCTURE {
    pub DataSize: u32,
    pub Anonymous: D3D12_VIDEO_ENCODER_SEQUENCE_GOP_STRUCTURE_0,
}
impl Default for D3D12_VIDEO_ENCODER_SEQUENCE_GOP_STRUCTURE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union D3D12_VIDEO_ENCODER_SEQUENCE_GOP_STRUCTURE_0 {
    pub pH264GroupOfPictures: *mut D3D12_VIDEO_ENCODER_SEQUENCE_GOP_STRUCTURE_H264,
    pub pHEVCGroupOfPictures: *mut D3D12_VIDEO_ENCODER_SEQUENCE_GOP_STRUCTURE_HEVC,
    pub pAV1SequenceStructure: *mut D3D12_VIDEO_ENCODER_AV1_SEQUENCE_STRUCTURE,
}
impl Default for D3D12_VIDEO_ENCODER_SEQUENCE_GOP_STRUCTURE_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_SEQUENCE_GOP_STRUCTURE_H264 {
    pub GOPLength: u32,
    pub PPicturePeriod: u32,
    pub pic_order_cnt_type: u8,
    pub log2_max_frame_num_minus4: u8,
    pub log2_max_pic_order_cnt_lsb_minus4: u8,
}
impl Default for D3D12_VIDEO_ENCODER_SEQUENCE_GOP_STRUCTURE_H264 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_SEQUENCE_GOP_STRUCTURE_HEVC {
    pub GOPLength: u32,
    pub PPicturePeriod: u32,
    pub log2_max_pic_order_cnt_lsb_minus4: u8,
}
impl Default for D3D12_VIDEO_ENCODER_SEQUENCE_GOP_STRUCTURE_HEVC {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_SUPPORT_FLAGS(pub i32);
impl D3D12_VIDEO_ENCODER_SUPPORT_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for D3D12_VIDEO_ENCODER_SUPPORT_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for D3D12_VIDEO_ENCODER_SUPPORT_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for D3D12_VIDEO_ENCODER_SUPPORT_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for D3D12_VIDEO_ENCODER_SUPPORT_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for D3D12_VIDEO_ENCODER_SUPPORT_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
pub const D3D12_VIDEO_ENCODER_SUPPORT_FLAG_GENERAL_SUPPORT_OK: D3D12_VIDEO_ENCODER_SUPPORT_FLAGS = D3D12_VIDEO_ENCODER_SUPPORT_FLAGS(1i32);
pub const D3D12_VIDEO_ENCODER_SUPPORT_FLAG_MOTION_ESTIMATION_PRECISION_MODE_LIMIT_AVAILABLE: D3D12_VIDEO_ENCODER_SUPPORT_FLAGS = D3D12_VIDEO_ENCODER_SUPPORT_FLAGS(4096i32);
pub const D3D12_VIDEO_ENCODER_SUPPORT_FLAG_NONE: D3D12_VIDEO_ENCODER_SUPPORT_FLAGS = D3D12_VIDEO_ENCODER_SUPPORT_FLAGS(0i32);
pub const D3D12_VIDEO_ENCODER_SUPPORT_FLAG_RATE_CONTROL_ADJUSTABLE_QP_RANGE_AVAILABLE: D3D12_VIDEO_ENCODER_SUPPORT_FLAGS = D3D12_VIDEO_ENCODER_SUPPORT_FLAGS(256i32);
pub const D3D12_VIDEO_ENCODER_SUPPORT_FLAG_RATE_CONTROL_DELTA_QP_AVAILABLE: D3D12_VIDEO_ENCODER_SUPPORT_FLAGS = D3D12_VIDEO_ENCODER_SUPPORT_FLAGS(64i32);
pub const D3D12_VIDEO_ENCODER_SUPPORT_FLAG_RATE_CONTROL_EXTENSION1_SUPPORT: D3D12_VIDEO_ENCODER_SUPPORT_FLAGS = D3D12_VIDEO_ENCODER_SUPPORT_FLAGS(8192i32);
pub const D3D12_VIDEO_ENCODER_SUPPORT_FLAG_RATE_CONTROL_FRAME_ANALYSIS_AVAILABLE: D3D12_VIDEO_ENCODER_SUPPORT_FLAGS = D3D12_VIDEO_ENCODER_SUPPORT_FLAGS(16i32);
pub const D3D12_VIDEO_ENCODER_SUPPORT_FLAG_RATE_CONTROL_INITIAL_QP_AVAILABLE: D3D12_VIDEO_ENCODER_SUPPORT_FLAGS = D3D12_VIDEO_ENCODER_SUPPORT_FLAGS(512i32);
pub const D3D12_VIDEO_ENCODER_SUPPORT_FLAG_RATE_CONTROL_MAX_FRAME_SIZE_AVAILABLE: D3D12_VIDEO_ENCODER_SUPPORT_FLAGS = D3D12_VIDEO_ENCODER_SUPPORT_FLAGS(1024i32);
pub const D3D12_VIDEO_ENCODER_SUPPORT_FLAG_RATE_CONTROL_QUALITY_VS_SPEED_AVAILABLE: D3D12_VIDEO_ENCODER_SUPPORT_FLAGS = D3D12_VIDEO_ENCODER_SUPPORT_FLAGS(16384i32);
pub const D3D12_VIDEO_ENCODER_SUPPORT_FLAG_RATE_CONTROL_RECONFIGURATION_AVAILABLE: D3D12_VIDEO_ENCODER_SUPPORT_FLAGS = D3D12_VIDEO_ENCODER_SUPPORT_FLAGS(2i32);
pub const D3D12_VIDEO_ENCODER_SUPPORT_FLAG_RATE_CONTROL_VBV_SIZE_CONFIG_AVAILABLE: D3D12_VIDEO_ENCODER_SUPPORT_FLAGS = D3D12_VIDEO_ENCODER_SUPPORT_FLAGS(8i32);
pub const D3D12_VIDEO_ENCODER_SUPPORT_FLAG_READABLE_RECONSTRUCTED_PICTURE_LAYOUT_AVAILABLE: D3D12_VIDEO_ENCODER_SUPPORT_FLAGS = D3D12_VIDEO_ENCODER_SUPPORT_FLAGS(32768i32);
pub const D3D12_VIDEO_ENCODER_SUPPORT_FLAG_RECONSTRUCTED_FRAMES_REQUIRE_TEXTURE_ARRAYS: D3D12_VIDEO_ENCODER_SUPPORT_FLAGS = D3D12_VIDEO_ENCODER_SUPPORT_FLAGS(32i32);
pub const D3D12_VIDEO_ENCODER_SUPPORT_FLAG_RESOLUTION_RECONFIGURATION_AVAILABLE: D3D12_VIDEO_ENCODER_SUPPORT_FLAGS = D3D12_VIDEO_ENCODER_SUPPORT_FLAGS(4i32);
pub const D3D12_VIDEO_ENCODER_SUPPORT_FLAG_SEQUENCE_GOP_RECONFIGURATION_AVAILABLE: D3D12_VIDEO_ENCODER_SUPPORT_FLAGS = D3D12_VIDEO_ENCODER_SUPPORT_FLAGS(2048i32);
pub const D3D12_VIDEO_ENCODER_SUPPORT_FLAG_SUBREGION_LAYOUT_RECONFIGURATION_AVAILABLE: D3D12_VIDEO_ENCODER_SUPPORT_FLAGS = D3D12_VIDEO_ENCODER_SUPPORT_FLAGS(128i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_TIER_HEVC(pub i32);
pub const D3D12_VIDEO_ENCODER_TIER_HEVC_HIGH: D3D12_VIDEO_ENCODER_TIER_HEVC = D3D12_VIDEO_ENCODER_TIER_HEVC(1i32);
pub const D3D12_VIDEO_ENCODER_TIER_HEVC_MAIN: D3D12_VIDEO_ENCODER_TIER_HEVC = D3D12_VIDEO_ENCODER_TIER_HEVC(0i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct D3D12_VIDEO_ENCODER_VALIDATION_FLAGS(pub i32);
impl D3D12_VIDEO_ENCODER_VALIDATION_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for D3D12_VIDEO_ENCODER_VALIDATION_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for D3D12_VIDEO_ENCODER_VALIDATION_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for D3D12_VIDEO_ENCODER_VALIDATION_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for D3D12_VIDEO_ENCODER_VALIDATION_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for D3D12_VIDEO_ENCODER_VALIDATION_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
pub const D3D12_VIDEO_ENCODER_VALIDATION_FLAG_CODEC_CONFIGURATION_NOT_SUPPORTED: D3D12_VIDEO_ENCODER_VALIDATION_FLAGS = D3D12_VIDEO_ENCODER_VALIDATION_FLAGS(16i32);
pub const D3D12_VIDEO_ENCODER_VALIDATION_FLAG_CODEC_NOT_SUPPORTED: D3D12_VIDEO_ENCODER_VALIDATION_FLAGS = D3D12_VIDEO_ENCODER_VALIDATION_FLAGS(1i32);
pub const D3D12_VIDEO_ENCODER_VALIDATION_FLAG_GOP_STRUCTURE_NOT_SUPPORTED: D3D12_VIDEO_ENCODER_VALIDATION_FLAGS = D3D12_VIDEO_ENCODER_VALIDATION_FLAGS(2048i32);
pub const D3D12_VIDEO_ENCODER_VALIDATION_FLAG_INPUT_FORMAT_NOT_SUPPORTED: D3D12_VIDEO_ENCODER_VALIDATION_FLAGS = D3D12_VIDEO_ENCODER_VALIDATION_FLAGS(8i32);
pub const D3D12_VIDEO_ENCODER_VALIDATION_FLAG_INTRA_REFRESH_MODE_NOT_SUPPORTED: D3D12_VIDEO_ENCODER_VALIDATION_FLAGS = D3D12_VIDEO_ENCODER_VALIDATION_FLAGS(128i32);
pub const D3D12_VIDEO_ENCODER_VALIDATION_FLAG_NONE: D3D12_VIDEO_ENCODER_VALIDATION_FLAGS = D3D12_VIDEO_ENCODER_VALIDATION_FLAGS(0i32);
pub const D3D12_VIDEO_ENCODER_VALIDATION_FLAG_RATE_CONTROL_CONFIGURATION_NOT_SUPPORTED: D3D12_VIDEO_ENCODER_VALIDATION_FLAGS = D3D12_VIDEO_ENCODER_VALIDATION_FLAGS(64i32);
pub const D3D12_VIDEO_ENCODER_VALIDATION_FLAG_RATE_CONTROL_MODE_NOT_SUPPORTED: D3D12_VIDEO_ENCODER_VALIDATION_FLAGS = D3D12_VIDEO_ENCODER_VALIDATION_FLAGS(32i32);
pub const D3D12_VIDEO_ENCODER_VALIDATION_FLAG_RESOLUTION_NOT_SUPPORTED_IN_LIST: D3D12_VIDEO_ENCODER_VALIDATION_FLAGS = D3D12_VIDEO_ENCODER_VALIDATION_FLAGS(512i32);
pub const D3D12_VIDEO_ENCODER_VALIDATION_FLAG_SUBREGION_LAYOUT_DATA_NOT_SUPPORTED: D3D12_VIDEO_ENCODER_VALIDATION_FLAGS = D3D12_VIDEO_ENCODER_VALIDATION_FLAGS(4096i32);
pub const D3D12_VIDEO_ENCODER_VALIDATION_FLAG_SUBREGION_LAYOUT_MODE_NOT_SUPPORTED: D3D12_VIDEO_ENCODER_VALIDATION_FLAGS = D3D12_VIDEO_ENCODER_VALIDATION_FLAGS(256i32);
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Direct3D12")]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_VIDEO_ENCODE_REFERENCE_FRAMES {
    pub NumTexture2Ds: u32,
    pub ppTexture2Ds: *mut Option<super::super::Graphics::Direct3D12::ID3D12Resource>,
    pub pSubresources: *mut u32,
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
impl Default for D3D12_VIDEO_ENCODE_REFERENCE_FRAMES {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_VIDEO_EXTENSION_COMMAND_DESC {
    pub NodeMask: u32,
    pub CommandId: windows_core::GUID,
}
impl Default for D3D12_VIDEO_EXTENSION_COMMAND_DESC {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Direct3D12")]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_VIDEO_EXTENSION_COMMAND_INFO {
    pub CommandId: windows_core::GUID,
    pub Name: windows_core::PCWSTR,
    pub CommandListSupportFlags: super::super::Graphics::Direct3D12::D3D12_COMMAND_LIST_SUPPORT_FLAGS,
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
impl Default for D3D12_VIDEO_EXTENSION_COMMAND_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct D3D12_VIDEO_EXTENSION_COMMAND_PARAMETER_FLAGS(pub i32);
impl D3D12_VIDEO_EXTENSION_COMMAND_PARAMETER_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for D3D12_VIDEO_EXTENSION_COMMAND_PARAMETER_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for D3D12_VIDEO_EXTENSION_COMMAND_PARAMETER_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for D3D12_VIDEO_EXTENSION_COMMAND_PARAMETER_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for D3D12_VIDEO_EXTENSION_COMMAND_PARAMETER_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for D3D12_VIDEO_EXTENSION_COMMAND_PARAMETER_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
pub const D3D12_VIDEO_EXTENSION_COMMAND_PARAMETER_FLAG_NONE: D3D12_VIDEO_EXTENSION_COMMAND_PARAMETER_FLAGS = D3D12_VIDEO_EXTENSION_COMMAND_PARAMETER_FLAGS(0i32);
pub const D3D12_VIDEO_EXTENSION_COMMAND_PARAMETER_FLAG_READ: D3D12_VIDEO_EXTENSION_COMMAND_PARAMETER_FLAGS = D3D12_VIDEO_EXTENSION_COMMAND_PARAMETER_FLAGS(1i32);
pub const D3D12_VIDEO_EXTENSION_COMMAND_PARAMETER_FLAG_WRITE: D3D12_VIDEO_EXTENSION_COMMAND_PARAMETER_FLAGS = D3D12_VIDEO_EXTENSION_COMMAND_PARAMETER_FLAGS(2i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_VIDEO_EXTENSION_COMMAND_PARAMETER_INFO {
    pub Name: windows_core::PCWSTR,
    pub Type: D3D12_VIDEO_EXTENSION_COMMAND_PARAMETER_TYPE,
    pub Flags: D3D12_VIDEO_EXTENSION_COMMAND_PARAMETER_FLAGS,
}
impl Default for D3D12_VIDEO_EXTENSION_COMMAND_PARAMETER_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct D3D12_VIDEO_EXTENSION_COMMAND_PARAMETER_STAGE(pub i32);
pub const D3D12_VIDEO_EXTENSION_COMMAND_PARAMETER_STAGE_CAPS_INPUT: D3D12_VIDEO_EXTENSION_COMMAND_PARAMETER_STAGE = D3D12_VIDEO_EXTENSION_COMMAND_PARAMETER_STAGE(3i32);
pub const D3D12_VIDEO_EXTENSION_COMMAND_PARAMETER_STAGE_CAPS_OUTPUT: D3D12_VIDEO_EXTENSION_COMMAND_PARAMETER_STAGE = D3D12_VIDEO_EXTENSION_COMMAND_PARAMETER_STAGE(4i32);
pub const D3D12_VIDEO_EXTENSION_COMMAND_PARAMETER_STAGE_CREATION: D3D12_VIDEO_EXTENSION_COMMAND_PARAMETER_STAGE = D3D12_VIDEO_EXTENSION_COMMAND_PARAMETER_STAGE(0i32);
pub const D3D12_VIDEO_EXTENSION_COMMAND_PARAMETER_STAGE_DEVICE_EXECUTE_INPUT: D3D12_VIDEO_EXTENSION_COMMAND_PARAMETER_STAGE = D3D12_VIDEO_EXTENSION_COMMAND_PARAMETER_STAGE(5i32);
pub const D3D12_VIDEO_EXTENSION_COMMAND_PARAMETER_STAGE_DEVICE_EXECUTE_OUTPUT: D3D12_VIDEO_EXTENSION_COMMAND_PARAMETER_STAGE = D3D12_VIDEO_EXTENSION_COMMAND_PARAMETER_STAGE(6i32);
pub const D3D12_VIDEO_EXTENSION_COMMAND_PARAMETER_STAGE_EXECUTION: D3D12_VIDEO_EXTENSION_COMMAND_PARAMETER_STAGE = D3D12_VIDEO_EXTENSION_COMMAND_PARAMETER_STAGE(2i32);
pub const D3D12_VIDEO_EXTENSION_COMMAND_PARAMETER_STAGE_INITIALIZATION: D3D12_VIDEO_EXTENSION_COMMAND_PARAMETER_STAGE = D3D12_VIDEO_EXTENSION_COMMAND_PARAMETER_STAGE(1i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct D3D12_VIDEO_EXTENSION_COMMAND_PARAMETER_TYPE(pub i32);
pub const D3D12_VIDEO_EXTENSION_COMMAND_PARAMETER_TYPE_DOUBLE: D3D12_VIDEO_EXTENSION_COMMAND_PARAMETER_TYPE = D3D12_VIDEO_EXTENSION_COMMAND_PARAMETER_TYPE(9i32);
pub const D3D12_VIDEO_EXTENSION_COMMAND_PARAMETER_TYPE_FLOAT: D3D12_VIDEO_EXTENSION_COMMAND_PARAMETER_TYPE = D3D12_VIDEO_EXTENSION_COMMAND_PARAMETER_TYPE(8i32);
pub const D3D12_VIDEO_EXTENSION_COMMAND_PARAMETER_TYPE_RESOURCE: D3D12_VIDEO_EXTENSION_COMMAND_PARAMETER_TYPE = D3D12_VIDEO_EXTENSION_COMMAND_PARAMETER_TYPE(10i32);
pub const D3D12_VIDEO_EXTENSION_COMMAND_PARAMETER_TYPE_SINT16: D3D12_VIDEO_EXTENSION_COMMAND_PARAMETER_TYPE = D3D12_VIDEO_EXTENSION_COMMAND_PARAMETER_TYPE(5i32);
pub const D3D12_VIDEO_EXTENSION_COMMAND_PARAMETER_TYPE_SINT32: D3D12_VIDEO_EXTENSION_COMMAND_PARAMETER_TYPE = D3D12_VIDEO_EXTENSION_COMMAND_PARAMETER_TYPE(6i32);
pub const D3D12_VIDEO_EXTENSION_COMMAND_PARAMETER_TYPE_SINT64: D3D12_VIDEO_EXTENSION_COMMAND_PARAMETER_TYPE = D3D12_VIDEO_EXTENSION_COMMAND_PARAMETER_TYPE(7i32);
pub const D3D12_VIDEO_EXTENSION_COMMAND_PARAMETER_TYPE_SINT8: D3D12_VIDEO_EXTENSION_COMMAND_PARAMETER_TYPE = D3D12_VIDEO_EXTENSION_COMMAND_PARAMETER_TYPE(4i32);
pub const D3D12_VIDEO_EXTENSION_COMMAND_PARAMETER_TYPE_UINT16: D3D12_VIDEO_EXTENSION_COMMAND_PARAMETER_TYPE = D3D12_VIDEO_EXTENSION_COMMAND_PARAMETER_TYPE(1i32);
pub const D3D12_VIDEO_EXTENSION_COMMAND_PARAMETER_TYPE_UINT32: D3D12_VIDEO_EXTENSION_COMMAND_PARAMETER_TYPE = D3D12_VIDEO_EXTENSION_COMMAND_PARAMETER_TYPE(2i32);
pub const D3D12_VIDEO_EXTENSION_COMMAND_PARAMETER_TYPE_UINT64: D3D12_VIDEO_EXTENSION_COMMAND_PARAMETER_TYPE = D3D12_VIDEO_EXTENSION_COMMAND_PARAMETER_TYPE(3i32);
pub const D3D12_VIDEO_EXTENSION_COMMAND_PARAMETER_TYPE_UINT8: D3D12_VIDEO_EXTENSION_COMMAND_PARAMETER_TYPE = D3D12_VIDEO_EXTENSION_COMMAND_PARAMETER_TYPE(0i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct D3D12_VIDEO_FIELD_TYPE(pub i32);
pub const D3D12_VIDEO_FIELD_TYPE_INTERLACED_BOTTOM_FIELD_FIRST: D3D12_VIDEO_FIELD_TYPE = D3D12_VIDEO_FIELD_TYPE(2i32);
pub const D3D12_VIDEO_FIELD_TYPE_INTERLACED_TOP_FIELD_FIRST: D3D12_VIDEO_FIELD_TYPE = D3D12_VIDEO_FIELD_TYPE(1i32);
pub const D3D12_VIDEO_FIELD_TYPE_NONE: D3D12_VIDEO_FIELD_TYPE = D3D12_VIDEO_FIELD_TYPE(0i32);
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Dxgi_Common")]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_VIDEO_FORMAT {
    pub Format: super::super::Graphics::Dxgi::Common::DXGI_FORMAT,
    pub ColorSpace: super::super::Graphics::Dxgi::Common::DXGI_COLOR_SPACE_TYPE,
}
#[cfg(feature = "Win32_Graphics_Dxgi_Common")]
impl Default for D3D12_VIDEO_FORMAT {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct D3D12_VIDEO_FRAME_CODED_INTERLACE_TYPE(pub i32);
pub const D3D12_VIDEO_FRAME_CODED_INTERLACE_TYPE_FIELD_BASED: D3D12_VIDEO_FRAME_CODED_INTERLACE_TYPE = D3D12_VIDEO_FRAME_CODED_INTERLACE_TYPE(1i32);
pub const D3D12_VIDEO_FRAME_CODED_INTERLACE_TYPE_NONE: D3D12_VIDEO_FRAME_CODED_INTERLACE_TYPE = D3D12_VIDEO_FRAME_CODED_INTERLACE_TYPE(0i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct D3D12_VIDEO_FRAME_STEREO_FORMAT(pub i32);
pub const D3D12_VIDEO_FRAME_STEREO_FORMAT_HORIZONTAL: D3D12_VIDEO_FRAME_STEREO_FORMAT = D3D12_VIDEO_FRAME_STEREO_FORMAT(2i32);
pub const D3D12_VIDEO_FRAME_STEREO_FORMAT_MONO: D3D12_VIDEO_FRAME_STEREO_FORMAT = D3D12_VIDEO_FRAME_STEREO_FORMAT(1i32);
pub const D3D12_VIDEO_FRAME_STEREO_FORMAT_NONE: D3D12_VIDEO_FRAME_STEREO_FORMAT = D3D12_VIDEO_FRAME_STEREO_FORMAT(0i32);
pub const D3D12_VIDEO_FRAME_STEREO_FORMAT_SEPARATE: D3D12_VIDEO_FRAME_STEREO_FORMAT = D3D12_VIDEO_FRAME_STEREO_FORMAT(4i32);
pub const D3D12_VIDEO_FRAME_STEREO_FORMAT_VERTICAL: D3D12_VIDEO_FRAME_STEREO_FORMAT = D3D12_VIDEO_FRAME_STEREO_FORMAT(3i32);
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Dxgi_Common")]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_VIDEO_MOTION_ESTIMATOR_DESC {
    pub NodeMask: u32,
    pub InputFormat: super::super::Graphics::Dxgi::Common::DXGI_FORMAT,
    pub BlockSize: D3D12_VIDEO_MOTION_ESTIMATOR_SEARCH_BLOCK_SIZE,
    pub Precision: D3D12_VIDEO_MOTION_ESTIMATOR_VECTOR_PRECISION,
    pub SizeRange: D3D12_VIDEO_SIZE_RANGE,
}
#[cfg(feature = "Win32_Graphics_Dxgi_Common")]
impl Default for D3D12_VIDEO_MOTION_ESTIMATOR_DESC {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Direct3D12")]
#[derive(Clone, Debug, PartialEq)]
pub struct D3D12_VIDEO_MOTION_ESTIMATOR_INPUT {
    pub pInputTexture2D: core::mem::ManuallyDrop<Option<super::super::Graphics::Direct3D12::ID3D12Resource>>,
    pub InputSubresourceIndex: u32,
    pub pReferenceTexture2D: core::mem::ManuallyDrop<Option<super::super::Graphics::Direct3D12::ID3D12Resource>>,
    pub ReferenceSubresourceIndex: u32,
    pub pHintMotionVectorHeap: core::mem::ManuallyDrop<Option<ID3D12VideoMotionVectorHeap>>,
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
impl Default for D3D12_VIDEO_MOTION_ESTIMATOR_INPUT {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Direct3D12")]
#[derive(Clone, Debug, PartialEq)]
pub struct D3D12_VIDEO_MOTION_ESTIMATOR_OUTPUT {
    pub pMotionVectorHeap: core::mem::ManuallyDrop<Option<ID3D12VideoMotionVectorHeap>>,
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
impl Default for D3D12_VIDEO_MOTION_ESTIMATOR_OUTPUT {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct D3D12_VIDEO_MOTION_ESTIMATOR_SEARCH_BLOCK_SIZE(pub i32);
pub const D3D12_VIDEO_MOTION_ESTIMATOR_SEARCH_BLOCK_SIZE_16X16: D3D12_VIDEO_MOTION_ESTIMATOR_SEARCH_BLOCK_SIZE = D3D12_VIDEO_MOTION_ESTIMATOR_SEARCH_BLOCK_SIZE(1i32);
pub const D3D12_VIDEO_MOTION_ESTIMATOR_SEARCH_BLOCK_SIZE_8X8: D3D12_VIDEO_MOTION_ESTIMATOR_SEARCH_BLOCK_SIZE = D3D12_VIDEO_MOTION_ESTIMATOR_SEARCH_BLOCK_SIZE(0i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct D3D12_VIDEO_MOTION_ESTIMATOR_SEARCH_BLOCK_SIZE_FLAGS(pub i32);
impl D3D12_VIDEO_MOTION_ESTIMATOR_SEARCH_BLOCK_SIZE_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for D3D12_VIDEO_MOTION_ESTIMATOR_SEARCH_BLOCK_SIZE_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for D3D12_VIDEO_MOTION_ESTIMATOR_SEARCH_BLOCK_SIZE_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for D3D12_VIDEO_MOTION_ESTIMATOR_SEARCH_BLOCK_SIZE_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for D3D12_VIDEO_MOTION_ESTIMATOR_SEARCH_BLOCK_SIZE_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for D3D12_VIDEO_MOTION_ESTIMATOR_SEARCH_BLOCK_SIZE_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
pub const D3D12_VIDEO_MOTION_ESTIMATOR_SEARCH_BLOCK_SIZE_FLAG_16X16: D3D12_VIDEO_MOTION_ESTIMATOR_SEARCH_BLOCK_SIZE_FLAGS = D3D12_VIDEO_MOTION_ESTIMATOR_SEARCH_BLOCK_SIZE_FLAGS(2i32);
pub const D3D12_VIDEO_MOTION_ESTIMATOR_SEARCH_BLOCK_SIZE_FLAG_8X8: D3D12_VIDEO_MOTION_ESTIMATOR_SEARCH_BLOCK_SIZE_FLAGS = D3D12_VIDEO_MOTION_ESTIMATOR_SEARCH_BLOCK_SIZE_FLAGS(1i32);
pub const D3D12_VIDEO_MOTION_ESTIMATOR_SEARCH_BLOCK_SIZE_FLAG_NONE: D3D12_VIDEO_MOTION_ESTIMATOR_SEARCH_BLOCK_SIZE_FLAGS = D3D12_VIDEO_MOTION_ESTIMATOR_SEARCH_BLOCK_SIZE_FLAGS(0i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct D3D12_VIDEO_MOTION_ESTIMATOR_VECTOR_PRECISION(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct D3D12_VIDEO_MOTION_ESTIMATOR_VECTOR_PRECISION_FLAGS(pub i32);
impl D3D12_VIDEO_MOTION_ESTIMATOR_VECTOR_PRECISION_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for D3D12_VIDEO_MOTION_ESTIMATOR_VECTOR_PRECISION_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for D3D12_VIDEO_MOTION_ESTIMATOR_VECTOR_PRECISION_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for D3D12_VIDEO_MOTION_ESTIMATOR_VECTOR_PRECISION_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for D3D12_VIDEO_MOTION_ESTIMATOR_VECTOR_PRECISION_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for D3D12_VIDEO_MOTION_ESTIMATOR_VECTOR_PRECISION_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
pub const D3D12_VIDEO_MOTION_ESTIMATOR_VECTOR_PRECISION_FLAG_NONE: D3D12_VIDEO_MOTION_ESTIMATOR_VECTOR_PRECISION_FLAGS = D3D12_VIDEO_MOTION_ESTIMATOR_VECTOR_PRECISION_FLAGS(0i32);
pub const D3D12_VIDEO_MOTION_ESTIMATOR_VECTOR_PRECISION_FLAG_QUARTER_PEL: D3D12_VIDEO_MOTION_ESTIMATOR_VECTOR_PRECISION_FLAGS = D3D12_VIDEO_MOTION_ESTIMATOR_VECTOR_PRECISION_FLAGS(1i32);
pub const D3D12_VIDEO_MOTION_ESTIMATOR_VECTOR_PRECISION_QUARTER_PEL: D3D12_VIDEO_MOTION_ESTIMATOR_VECTOR_PRECISION = D3D12_VIDEO_MOTION_ESTIMATOR_VECTOR_PRECISION(0i32);
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Dxgi_Common")]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_VIDEO_MOTION_VECTOR_HEAP_DESC {
    pub NodeMask: u32,
    pub InputFormat: super::super::Graphics::Dxgi::Common::DXGI_FORMAT,
    pub BlockSize: D3D12_VIDEO_MOTION_ESTIMATOR_SEARCH_BLOCK_SIZE,
    pub Precision: D3D12_VIDEO_MOTION_ESTIMATOR_VECTOR_PRECISION,
    pub SizeRange: D3D12_VIDEO_SIZE_RANGE,
}
#[cfg(feature = "Win32_Graphics_Dxgi_Common")]
impl Default for D3D12_VIDEO_MOTION_VECTOR_HEAP_DESC {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_VIDEO_PROCESS_ALPHA_BLENDING {
    pub Enable: super::super::Foundation::BOOL,
    pub Alpha: f32,
}
impl Default for D3D12_VIDEO_PROCESS_ALPHA_BLENDING {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct D3D12_VIDEO_PROCESS_ALPHA_FILL_MODE(pub i32);
pub const D3D12_VIDEO_PROCESS_ALPHA_FILL_MODE_BACKGROUND: D3D12_VIDEO_PROCESS_ALPHA_FILL_MODE = D3D12_VIDEO_PROCESS_ALPHA_FILL_MODE(1i32);
pub const D3D12_VIDEO_PROCESS_ALPHA_FILL_MODE_DESTINATION: D3D12_VIDEO_PROCESS_ALPHA_FILL_MODE = D3D12_VIDEO_PROCESS_ALPHA_FILL_MODE(2i32);
pub const D3D12_VIDEO_PROCESS_ALPHA_FILL_MODE_OPAQUE: D3D12_VIDEO_PROCESS_ALPHA_FILL_MODE = D3D12_VIDEO_PROCESS_ALPHA_FILL_MODE(0i32);
pub const D3D12_VIDEO_PROCESS_ALPHA_FILL_MODE_SOURCE_STREAM: D3D12_VIDEO_PROCESS_ALPHA_FILL_MODE = D3D12_VIDEO_PROCESS_ALPHA_FILL_MODE(3i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct D3D12_VIDEO_PROCESS_AUTO_PROCESSING_FLAGS(pub u32);
impl D3D12_VIDEO_PROCESS_AUTO_PROCESSING_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for D3D12_VIDEO_PROCESS_AUTO_PROCESSING_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for D3D12_VIDEO_PROCESS_AUTO_PROCESSING_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for D3D12_VIDEO_PROCESS_AUTO_PROCESSING_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for D3D12_VIDEO_PROCESS_AUTO_PROCESSING_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for D3D12_VIDEO_PROCESS_AUTO_PROCESSING_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
pub const D3D12_VIDEO_PROCESS_AUTO_PROCESSING_FLAG_ANAMORPHIC_SCALING: D3D12_VIDEO_PROCESS_AUTO_PROCESSING_FLAGS = D3D12_VIDEO_PROCESS_AUTO_PROCESSING_FLAGS(128u32);
pub const D3D12_VIDEO_PROCESS_AUTO_PROCESSING_FLAG_COLOR_CORRECTION: D3D12_VIDEO_PROCESS_AUTO_PROCESSING_FLAGS = D3D12_VIDEO_PROCESS_AUTO_PROCESSING_FLAGS(8u32);
pub const D3D12_VIDEO_PROCESS_AUTO_PROCESSING_FLAG_CUSTOM: D3D12_VIDEO_PROCESS_AUTO_PROCESSING_FLAGS = D3D12_VIDEO_PROCESS_AUTO_PROCESSING_FLAGS(2147483648u32);
pub const D3D12_VIDEO_PROCESS_AUTO_PROCESSING_FLAG_DENOISE: D3D12_VIDEO_PROCESS_AUTO_PROCESSING_FLAGS = D3D12_VIDEO_PROCESS_AUTO_PROCESSING_FLAGS(1u32);
pub const D3D12_VIDEO_PROCESS_AUTO_PROCESSING_FLAG_DERINGING: D3D12_VIDEO_PROCESS_AUTO_PROCESSING_FLAGS = D3D12_VIDEO_PROCESS_AUTO_PROCESSING_FLAGS(2u32);
pub const D3D12_VIDEO_PROCESS_AUTO_PROCESSING_FLAG_EDGE_ENHANCEMENT: D3D12_VIDEO_PROCESS_AUTO_PROCESSING_FLAGS = D3D12_VIDEO_PROCESS_AUTO_PROCESSING_FLAGS(4u32);
pub const D3D12_VIDEO_PROCESS_AUTO_PROCESSING_FLAG_FLESH_TONE_MAPPING: D3D12_VIDEO_PROCESS_AUTO_PROCESSING_FLAGS = D3D12_VIDEO_PROCESS_AUTO_PROCESSING_FLAGS(16u32);
pub const D3D12_VIDEO_PROCESS_AUTO_PROCESSING_FLAG_IMAGE_STABILIZATION: D3D12_VIDEO_PROCESS_AUTO_PROCESSING_FLAGS = D3D12_VIDEO_PROCESS_AUTO_PROCESSING_FLAGS(32u32);
pub const D3D12_VIDEO_PROCESS_AUTO_PROCESSING_FLAG_NONE: D3D12_VIDEO_PROCESS_AUTO_PROCESSING_FLAGS = D3D12_VIDEO_PROCESS_AUTO_PROCESSING_FLAGS(0u32);
pub const D3D12_VIDEO_PROCESS_AUTO_PROCESSING_FLAG_SUPER_RESOLUTION: D3D12_VIDEO_PROCESS_AUTO_PROCESSING_FLAGS = D3D12_VIDEO_PROCESS_AUTO_PROCESSING_FLAGS(64u32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct D3D12_VIDEO_PROCESS_DEINTERLACE_FLAGS(pub u32);
impl D3D12_VIDEO_PROCESS_DEINTERLACE_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for D3D12_VIDEO_PROCESS_DEINTERLACE_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for D3D12_VIDEO_PROCESS_DEINTERLACE_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for D3D12_VIDEO_PROCESS_DEINTERLACE_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for D3D12_VIDEO_PROCESS_DEINTERLACE_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for D3D12_VIDEO_PROCESS_DEINTERLACE_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
pub const D3D12_VIDEO_PROCESS_DEINTERLACE_FLAG_BOB: D3D12_VIDEO_PROCESS_DEINTERLACE_FLAGS = D3D12_VIDEO_PROCESS_DEINTERLACE_FLAGS(1u32);
pub const D3D12_VIDEO_PROCESS_DEINTERLACE_FLAG_CUSTOM: D3D12_VIDEO_PROCESS_DEINTERLACE_FLAGS = D3D12_VIDEO_PROCESS_DEINTERLACE_FLAGS(2147483648u32);
pub const D3D12_VIDEO_PROCESS_DEINTERLACE_FLAG_NONE: D3D12_VIDEO_PROCESS_DEINTERLACE_FLAGS = D3D12_VIDEO_PROCESS_DEINTERLACE_FLAGS(0u32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct D3D12_VIDEO_PROCESS_FEATURE_FLAGS(pub i32);
impl D3D12_VIDEO_PROCESS_FEATURE_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for D3D12_VIDEO_PROCESS_FEATURE_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for D3D12_VIDEO_PROCESS_FEATURE_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for D3D12_VIDEO_PROCESS_FEATURE_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for D3D12_VIDEO_PROCESS_FEATURE_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for D3D12_VIDEO_PROCESS_FEATURE_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
pub const D3D12_VIDEO_PROCESS_FEATURE_FLAG_ALPHA_BLENDING: D3D12_VIDEO_PROCESS_FEATURE_FLAGS = D3D12_VIDEO_PROCESS_FEATURE_FLAGS(32i32);
pub const D3D12_VIDEO_PROCESS_FEATURE_FLAG_ALPHA_FILL: D3D12_VIDEO_PROCESS_FEATURE_FLAGS = D3D12_VIDEO_PROCESS_FEATURE_FLAGS(1i32);
pub const D3D12_VIDEO_PROCESS_FEATURE_FLAG_FLIP: D3D12_VIDEO_PROCESS_FEATURE_FLAGS = D3D12_VIDEO_PROCESS_FEATURE_FLAGS(16i32);
pub const D3D12_VIDEO_PROCESS_FEATURE_FLAG_LUMA_KEY: D3D12_VIDEO_PROCESS_FEATURE_FLAGS = D3D12_VIDEO_PROCESS_FEATURE_FLAGS(2i32);
pub const D3D12_VIDEO_PROCESS_FEATURE_FLAG_NONE: D3D12_VIDEO_PROCESS_FEATURE_FLAGS = D3D12_VIDEO_PROCESS_FEATURE_FLAGS(0i32);
pub const D3D12_VIDEO_PROCESS_FEATURE_FLAG_PIXEL_ASPECT_RATIO: D3D12_VIDEO_PROCESS_FEATURE_FLAGS = D3D12_VIDEO_PROCESS_FEATURE_FLAGS(64i32);
pub const D3D12_VIDEO_PROCESS_FEATURE_FLAG_ROTATION: D3D12_VIDEO_PROCESS_FEATURE_FLAGS = D3D12_VIDEO_PROCESS_FEATURE_FLAGS(8i32);
pub const D3D12_VIDEO_PROCESS_FEATURE_FLAG_STEREO: D3D12_VIDEO_PROCESS_FEATURE_FLAGS = D3D12_VIDEO_PROCESS_FEATURE_FLAGS(4i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct D3D12_VIDEO_PROCESS_FILTER(pub i32);
pub const D3D12_VIDEO_PROCESS_FILTER_ANAMORPHIC_SCALING: D3D12_VIDEO_PROCESS_FILTER = D3D12_VIDEO_PROCESS_FILTER(6i32);
pub const D3D12_VIDEO_PROCESS_FILTER_BRIGHTNESS: D3D12_VIDEO_PROCESS_FILTER = D3D12_VIDEO_PROCESS_FILTER(0i32);
pub const D3D12_VIDEO_PROCESS_FILTER_CONTRAST: D3D12_VIDEO_PROCESS_FILTER = D3D12_VIDEO_PROCESS_FILTER(1i32);
pub const D3D12_VIDEO_PROCESS_FILTER_EDGE_ENHANCEMENT: D3D12_VIDEO_PROCESS_FILTER = D3D12_VIDEO_PROCESS_FILTER(5i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct D3D12_VIDEO_PROCESS_FILTER_FLAGS(pub i32);
impl D3D12_VIDEO_PROCESS_FILTER_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for D3D12_VIDEO_PROCESS_FILTER_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for D3D12_VIDEO_PROCESS_FILTER_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for D3D12_VIDEO_PROCESS_FILTER_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for D3D12_VIDEO_PROCESS_FILTER_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for D3D12_VIDEO_PROCESS_FILTER_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
pub const D3D12_VIDEO_PROCESS_FILTER_FLAG_ANAMORPHIC_SCALING: D3D12_VIDEO_PROCESS_FILTER_FLAGS = D3D12_VIDEO_PROCESS_FILTER_FLAGS(64i32);
pub const D3D12_VIDEO_PROCESS_FILTER_FLAG_BRIGHTNESS: D3D12_VIDEO_PROCESS_FILTER_FLAGS = D3D12_VIDEO_PROCESS_FILTER_FLAGS(1i32);
pub const D3D12_VIDEO_PROCESS_FILTER_FLAG_CONTRAST: D3D12_VIDEO_PROCESS_FILTER_FLAGS = D3D12_VIDEO_PROCESS_FILTER_FLAGS(2i32);
pub const D3D12_VIDEO_PROCESS_FILTER_FLAG_EDGE_ENHANCEMENT: D3D12_VIDEO_PROCESS_FILTER_FLAGS = D3D12_VIDEO_PROCESS_FILTER_FLAGS(32i32);
pub const D3D12_VIDEO_PROCESS_FILTER_FLAG_HUE: D3D12_VIDEO_PROCESS_FILTER_FLAGS = D3D12_VIDEO_PROCESS_FILTER_FLAGS(4i32);
pub const D3D12_VIDEO_PROCESS_FILTER_FLAG_NOISE_REDUCTION: D3D12_VIDEO_PROCESS_FILTER_FLAGS = D3D12_VIDEO_PROCESS_FILTER_FLAGS(16i32);
pub const D3D12_VIDEO_PROCESS_FILTER_FLAG_NONE: D3D12_VIDEO_PROCESS_FILTER_FLAGS = D3D12_VIDEO_PROCESS_FILTER_FLAGS(0i32);
pub const D3D12_VIDEO_PROCESS_FILTER_FLAG_SATURATION: D3D12_VIDEO_PROCESS_FILTER_FLAGS = D3D12_VIDEO_PROCESS_FILTER_FLAGS(8i32);
pub const D3D12_VIDEO_PROCESS_FILTER_FLAG_STEREO_ADJUSTMENT: D3D12_VIDEO_PROCESS_FILTER_FLAGS = D3D12_VIDEO_PROCESS_FILTER_FLAGS(128i32);
pub const D3D12_VIDEO_PROCESS_FILTER_HUE: D3D12_VIDEO_PROCESS_FILTER = D3D12_VIDEO_PROCESS_FILTER(2i32);
pub const D3D12_VIDEO_PROCESS_FILTER_NOISE_REDUCTION: D3D12_VIDEO_PROCESS_FILTER = D3D12_VIDEO_PROCESS_FILTER(4i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_VIDEO_PROCESS_FILTER_RANGE {
    pub Minimum: i32,
    pub Maximum: i32,
    pub Default: i32,
    pub Multiplier: f32,
}
impl Default for D3D12_VIDEO_PROCESS_FILTER_RANGE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const D3D12_VIDEO_PROCESS_FILTER_SATURATION: D3D12_VIDEO_PROCESS_FILTER = D3D12_VIDEO_PROCESS_FILTER(3i32);
pub const D3D12_VIDEO_PROCESS_FILTER_STEREO_ADJUSTMENT: D3D12_VIDEO_PROCESS_FILTER = D3D12_VIDEO_PROCESS_FILTER(7i32);
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Direct3D12")]
#[derive(Clone, Debug, PartialEq)]
pub struct D3D12_VIDEO_PROCESS_INPUT_STREAM {
    pub pTexture2D: core::mem::ManuallyDrop<Option<super::super::Graphics::Direct3D12::ID3D12Resource>>,
    pub Subresource: u32,
    pub ReferenceSet: D3D12_VIDEO_PROCESS_REFERENCE_SET,
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
impl Default for D3D12_VIDEO_PROCESS_INPUT_STREAM {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Direct3D12")]
#[derive(Clone, Debug, PartialEq)]
pub struct D3D12_VIDEO_PROCESS_INPUT_STREAM_ARGUMENTS {
    pub InputStream: [D3D12_VIDEO_PROCESS_INPUT_STREAM; 2],
    pub Transform: D3D12_VIDEO_PROCESS_TRANSFORM,
    pub Flags: D3D12_VIDEO_PROCESS_INPUT_STREAM_FLAGS,
    pub RateInfo: D3D12_VIDEO_PROCESS_INPUT_STREAM_RATE,
    pub FilterLevels: [i32; 32],
    pub AlphaBlending: D3D12_VIDEO_PROCESS_ALPHA_BLENDING,
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
impl Default for D3D12_VIDEO_PROCESS_INPUT_STREAM_ARGUMENTS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Direct3D12")]
#[derive(Clone, Debug, PartialEq)]
pub struct D3D12_VIDEO_PROCESS_INPUT_STREAM_ARGUMENTS1 {
    pub InputStream: [D3D12_VIDEO_PROCESS_INPUT_STREAM; 2],
    pub Transform: D3D12_VIDEO_PROCESS_TRANSFORM,
    pub Flags: D3D12_VIDEO_PROCESS_INPUT_STREAM_FLAGS,
    pub RateInfo: D3D12_VIDEO_PROCESS_INPUT_STREAM_RATE,
    pub FilterLevels: [i32; 32],
    pub AlphaBlending: D3D12_VIDEO_PROCESS_ALPHA_BLENDING,
    pub FieldType: D3D12_VIDEO_FIELD_TYPE,
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
impl Default for D3D12_VIDEO_PROCESS_INPUT_STREAM_ARGUMENTS1 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Dxgi_Common")]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_VIDEO_PROCESS_INPUT_STREAM_DESC {
    pub Format: super::super::Graphics::Dxgi::Common::DXGI_FORMAT,
    pub ColorSpace: super::super::Graphics::Dxgi::Common::DXGI_COLOR_SPACE_TYPE,
    pub SourceAspectRatio: super::super::Graphics::Dxgi::Common::DXGI_RATIONAL,
    pub DestinationAspectRatio: super::super::Graphics::Dxgi::Common::DXGI_RATIONAL,
    pub FrameRate: super::super::Graphics::Dxgi::Common::DXGI_RATIONAL,
    pub SourceSizeRange: D3D12_VIDEO_SIZE_RANGE,
    pub DestinationSizeRange: D3D12_VIDEO_SIZE_RANGE,
    pub EnableOrientation: super::super::Foundation::BOOL,
    pub FilterFlags: D3D12_VIDEO_PROCESS_FILTER_FLAGS,
    pub StereoFormat: D3D12_VIDEO_FRAME_STEREO_FORMAT,
    pub FieldType: D3D12_VIDEO_FIELD_TYPE,
    pub DeinterlaceMode: D3D12_VIDEO_PROCESS_DEINTERLACE_FLAGS,
    pub EnableAlphaBlending: super::super::Foundation::BOOL,
    pub LumaKey: D3D12_VIDEO_PROCESS_LUMA_KEY,
    pub NumPastFrames: u32,
    pub NumFutureFrames: u32,
    pub EnableAutoProcessing: super::super::Foundation::BOOL,
}
#[cfg(feature = "Win32_Graphics_Dxgi_Common")]
impl Default for D3D12_VIDEO_PROCESS_INPUT_STREAM_DESC {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct D3D12_VIDEO_PROCESS_INPUT_STREAM_FLAGS(pub i32);
impl D3D12_VIDEO_PROCESS_INPUT_STREAM_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for D3D12_VIDEO_PROCESS_INPUT_STREAM_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for D3D12_VIDEO_PROCESS_INPUT_STREAM_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for D3D12_VIDEO_PROCESS_INPUT_STREAM_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for D3D12_VIDEO_PROCESS_INPUT_STREAM_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for D3D12_VIDEO_PROCESS_INPUT_STREAM_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
pub const D3D12_VIDEO_PROCESS_INPUT_STREAM_FLAG_FRAME_DISCONTINUITY: D3D12_VIDEO_PROCESS_INPUT_STREAM_FLAGS = D3D12_VIDEO_PROCESS_INPUT_STREAM_FLAGS(1i32);
pub const D3D12_VIDEO_PROCESS_INPUT_STREAM_FLAG_FRAME_REPEAT: D3D12_VIDEO_PROCESS_INPUT_STREAM_FLAGS = D3D12_VIDEO_PROCESS_INPUT_STREAM_FLAGS(2i32);
pub const D3D12_VIDEO_PROCESS_INPUT_STREAM_FLAG_NONE: D3D12_VIDEO_PROCESS_INPUT_STREAM_FLAGS = D3D12_VIDEO_PROCESS_INPUT_STREAM_FLAGS(0i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_VIDEO_PROCESS_INPUT_STREAM_RATE {
    pub OutputIndex: u32,
    pub InputFrameOrField: u32,
}
impl Default for D3D12_VIDEO_PROCESS_INPUT_STREAM_RATE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_VIDEO_PROCESS_LUMA_KEY {
    pub Enable: super::super::Foundation::BOOL,
    pub Lower: f32,
    pub Upper: f32,
}
impl Default for D3D12_VIDEO_PROCESS_LUMA_KEY {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct D3D12_VIDEO_PROCESS_ORIENTATION(pub i32);
pub const D3D12_VIDEO_PROCESS_ORIENTATION_CLOCKWISE_180: D3D12_VIDEO_PROCESS_ORIENTATION = D3D12_VIDEO_PROCESS_ORIENTATION(4i32);
pub const D3D12_VIDEO_PROCESS_ORIENTATION_CLOCKWISE_270: D3D12_VIDEO_PROCESS_ORIENTATION = D3D12_VIDEO_PROCESS_ORIENTATION(6i32);
pub const D3D12_VIDEO_PROCESS_ORIENTATION_CLOCKWISE_270_FLIP_HORIZONTAL: D3D12_VIDEO_PROCESS_ORIENTATION = D3D12_VIDEO_PROCESS_ORIENTATION(7i32);
pub const D3D12_VIDEO_PROCESS_ORIENTATION_CLOCKWISE_90: D3D12_VIDEO_PROCESS_ORIENTATION = D3D12_VIDEO_PROCESS_ORIENTATION(2i32);
pub const D3D12_VIDEO_PROCESS_ORIENTATION_CLOCKWISE_90_FLIP_HORIZONTAL: D3D12_VIDEO_PROCESS_ORIENTATION = D3D12_VIDEO_PROCESS_ORIENTATION(3i32);
pub const D3D12_VIDEO_PROCESS_ORIENTATION_DEFAULT: D3D12_VIDEO_PROCESS_ORIENTATION = D3D12_VIDEO_PROCESS_ORIENTATION(0i32);
pub const D3D12_VIDEO_PROCESS_ORIENTATION_FLIP_HORIZONTAL: D3D12_VIDEO_PROCESS_ORIENTATION = D3D12_VIDEO_PROCESS_ORIENTATION(1i32);
pub const D3D12_VIDEO_PROCESS_ORIENTATION_FLIP_VERTICAL: D3D12_VIDEO_PROCESS_ORIENTATION = D3D12_VIDEO_PROCESS_ORIENTATION(5i32);
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Direct3D12")]
#[derive(Clone, Debug, PartialEq)]
pub struct D3D12_VIDEO_PROCESS_OUTPUT_STREAM {
    pub pTexture2D: core::mem::ManuallyDrop<Option<super::super::Graphics::Direct3D12::ID3D12Resource>>,
    pub Subresource: u32,
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
impl Default for D3D12_VIDEO_PROCESS_OUTPUT_STREAM {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Direct3D12")]
#[derive(Clone, Debug, PartialEq)]
pub struct D3D12_VIDEO_PROCESS_OUTPUT_STREAM_ARGUMENTS {
    pub OutputStream: [D3D12_VIDEO_PROCESS_OUTPUT_STREAM; 2],
    pub TargetRectangle: super::super::Foundation::RECT,
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
impl Default for D3D12_VIDEO_PROCESS_OUTPUT_STREAM_ARGUMENTS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Dxgi_Common")]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_VIDEO_PROCESS_OUTPUT_STREAM_DESC {
    pub Format: super::super::Graphics::Dxgi::Common::DXGI_FORMAT,
    pub ColorSpace: super::super::Graphics::Dxgi::Common::DXGI_COLOR_SPACE_TYPE,
    pub AlphaFillMode: D3D12_VIDEO_PROCESS_ALPHA_FILL_MODE,
    pub AlphaFillModeSourceStreamIndex: u32,
    pub BackgroundColor: [f32; 4],
    pub FrameRate: super::super::Graphics::Dxgi::Common::DXGI_RATIONAL,
    pub EnableStereo: super::super::Foundation::BOOL,
}
#[cfg(feature = "Win32_Graphics_Dxgi_Common")]
impl Default for D3D12_VIDEO_PROCESS_OUTPUT_STREAM_DESC {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Direct3D12")]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_VIDEO_PROCESS_REFERENCE_SET {
    pub NumPastFrames: u32,
    pub ppPastFrames: *mut Option<super::super::Graphics::Direct3D12::ID3D12Resource>,
    pub pPastSubresources: *mut u32,
    pub NumFutureFrames: u32,
    pub ppFutureFrames: *mut Option<super::super::Graphics::Direct3D12::ID3D12Resource>,
    pub pFutureSubresources: *mut u32,
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
impl Default for D3D12_VIDEO_PROCESS_REFERENCE_SET {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct D3D12_VIDEO_PROCESS_SUPPORT_FLAGS(pub i32);
impl D3D12_VIDEO_PROCESS_SUPPORT_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for D3D12_VIDEO_PROCESS_SUPPORT_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for D3D12_VIDEO_PROCESS_SUPPORT_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for D3D12_VIDEO_PROCESS_SUPPORT_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for D3D12_VIDEO_PROCESS_SUPPORT_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for D3D12_VIDEO_PROCESS_SUPPORT_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
pub const D3D12_VIDEO_PROCESS_SUPPORT_FLAG_NONE: D3D12_VIDEO_PROCESS_SUPPORT_FLAGS = D3D12_VIDEO_PROCESS_SUPPORT_FLAGS(0i32);
pub const D3D12_VIDEO_PROCESS_SUPPORT_FLAG_SUPPORTED: D3D12_VIDEO_PROCESS_SUPPORT_FLAGS = D3D12_VIDEO_PROCESS_SUPPORT_FLAGS(1i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_VIDEO_PROCESS_TRANSFORM {
    pub SourceRectangle: super::super::Foundation::RECT,
    pub DestinationRectangle: super::super::Foundation::RECT,
    pub Orientation: D3D12_VIDEO_PROCESS_ORIENTATION,
}
impl Default for D3D12_VIDEO_PROCESS_TRANSFORM {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct D3D12_VIDEO_PROTECTED_RESOURCE_SUPPORT_FLAGS(pub i32);
impl D3D12_VIDEO_PROTECTED_RESOURCE_SUPPORT_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for D3D12_VIDEO_PROTECTED_RESOURCE_SUPPORT_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for D3D12_VIDEO_PROTECTED_RESOURCE_SUPPORT_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for D3D12_VIDEO_PROTECTED_RESOURCE_SUPPORT_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for D3D12_VIDEO_PROTECTED_RESOURCE_SUPPORT_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for D3D12_VIDEO_PROTECTED_RESOURCE_SUPPORT_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
pub const D3D12_VIDEO_PROTECTED_RESOURCE_SUPPORT_FLAG_NONE: D3D12_VIDEO_PROTECTED_RESOURCE_SUPPORT_FLAGS = D3D12_VIDEO_PROTECTED_RESOURCE_SUPPORT_FLAGS(0i32);
pub const D3D12_VIDEO_PROTECTED_RESOURCE_SUPPORT_FLAG_SUPPORTED: D3D12_VIDEO_PROTECTED_RESOURCE_SUPPORT_FLAGS = D3D12_VIDEO_PROTECTED_RESOURCE_SUPPORT_FLAGS(1i32);
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Dxgi_Common")]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_VIDEO_SAMPLE {
    pub Width: u32,
    pub Height: u32,
    pub Format: D3D12_VIDEO_FORMAT,
}
#[cfg(feature = "Win32_Graphics_Dxgi_Common")]
impl Default for D3D12_VIDEO_SAMPLE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_VIDEO_SCALE_SUPPORT {
    pub OutputSizeRange: D3D12_VIDEO_SIZE_RANGE,
    pub Flags: D3D12_VIDEO_SCALE_SUPPORT_FLAGS,
}
impl Default for D3D12_VIDEO_SCALE_SUPPORT {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct D3D12_VIDEO_SCALE_SUPPORT_FLAGS(pub i32);
impl D3D12_VIDEO_SCALE_SUPPORT_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for D3D12_VIDEO_SCALE_SUPPORT_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for D3D12_VIDEO_SCALE_SUPPORT_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for D3D12_VIDEO_SCALE_SUPPORT_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for D3D12_VIDEO_SCALE_SUPPORT_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for D3D12_VIDEO_SCALE_SUPPORT_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
pub const D3D12_VIDEO_SCALE_SUPPORT_FLAG_EVEN_DIMENSIONS_ONLY: D3D12_VIDEO_SCALE_SUPPORT_FLAGS = D3D12_VIDEO_SCALE_SUPPORT_FLAGS(2i32);
pub const D3D12_VIDEO_SCALE_SUPPORT_FLAG_NONE: D3D12_VIDEO_SCALE_SUPPORT_FLAGS = D3D12_VIDEO_SCALE_SUPPORT_FLAGS(0i32);
pub const D3D12_VIDEO_SCALE_SUPPORT_FLAG_POW2_ONLY: D3D12_VIDEO_SCALE_SUPPORT_FLAGS = D3D12_VIDEO_SCALE_SUPPORT_FLAGS(1i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3D12_VIDEO_SIZE_RANGE {
    pub MaxWidth: u32,
    pub MaxHeight: u32,
    pub MinWidth: u32,
    pub MinHeight: u32,
}
impl Default for D3D12_VIDEO_SIZE_RANGE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C, packed(4))]
#[cfg(target_arch = "x86")]
#[derive(Clone, Copy)]
pub struct D3DCONTENTPROTECTIONCAPS {
    pub Caps: u32,
    pub KeyExchangeType: windows_core::GUID,
    pub BufferAlignmentStart: u32,
    pub BlockAlignmentSize: u32,
    pub ProtectedMemorySize: u64,
}
#[cfg(target_arch = "x86")]
impl Default for D3DCONTENTPROTECTIONCAPS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(any(target_arch = "aarch64", target_arch = "arm64ec", target_arch = "x86_64"))]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3DCONTENTPROTECTIONCAPS {
    pub Caps: u32,
    pub KeyExchangeType: windows_core::GUID,
    pub BufferAlignmentStart: u32,
    pub BlockAlignmentSize: u32,
    pub ProtectedMemorySize: u64,
}
#[cfg(any(target_arch = "aarch64", target_arch = "arm64ec", target_arch = "x86_64"))]
impl Default for D3DCONTENTPROTECTIONCAPS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct D3DOVERLAYCAPS {
    pub Caps: u32,
    pub MaxOverlayDisplayWidth: u32,
    pub MaxOverlayDisplayHeight: u32,
}
impl Default for D3DOVERLAYCAPS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Debug, PartialEq)]
pub struct DEVICE_INFO {
    pub pFriendlyDeviceName: core::mem::ManuallyDrop<windows_core::BSTR>,
    pub pUniqueDeviceName: core::mem::ManuallyDrop<windows_core::BSTR>,
    pub pManufacturerName: core::mem::ManuallyDrop<windows_core::BSTR>,
    pub pModelName: core::mem::ManuallyDrop<windows_core::BSTR>,
    pub pIconURL: core::mem::ManuallyDrop<windows_core::BSTR>,
}
impl Default for DEVICE_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const DEVPKEY_DeviceInterface_IsVirtualCamera: super::super::Foundation::DEVPROPKEY = super::super::Foundation::DEVPROPKEY { fmtid: windows_core::GUID::from_u128(0x6edc630d_c2e3_43b7_b2d1_20525a1af120), pid: 3 };
pub const DEVPKEY_DeviceInterface_IsWindowsCameraEffectAvailable: super::super::Foundation::DEVPROPKEY = super::super::Foundation::DEVPROPKEY { fmtid: windows_core::GUID::from_u128(0x6edc630d_c2e3_43b7_b2d1_20525a1af120), pid: 4 };
pub const DEVPKEY_DeviceInterface_VirtualCameraAssociatedCameras: super::super::Foundation::DEVPROPKEY = super::super::Foundation::DEVPROPKEY { fmtid: windows_core::GUID::from_u128(0x6edc630d_c2e3_43b7_b2d1_20525a1af120), pid: 5 };
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DIRTYRECT_INFO {
    pub FrameNumber: u32,
    pub NumDirtyRects: u32,
    pub DirtyRects: [super::super::Foundation::RECT; 1],
}
impl Default for DIRTYRECT_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const DSATTRIB_CAPTURE_STREAMTIME: windows_core::GUID = windows_core::GUID::from_u128(0x0c1a5614_30cd_4f40_bcbf_d03e52306207);
pub const DSATTRIB_CC_CONTAINER_INFO: windows_core::GUID = windows_core::GUID::from_u128(0xe7e050fb_dd5d_40dd_9915_35dcb81bdc8a);
pub const DSATTRIB_DSHOW_STREAM_DESC: windows_core::GUID = windows_core::GUID::from_u128(0x5fb5673b_0a2a_4565_827b_6853fd75e611);
pub const DSATTRIB_OptionalVideoAttributes: windows_core::GUID = windows_core::GUID::from_u128(0x5a5f08ca_55c2_4033_92ab_55db8f781226);
pub const DSATTRIB_PBDATAG_ATTRIBUTE: windows_core::GUID = windows_core::GUID::from_u128(0xe0b56679_12b9_43cc_b7df_578caa5a7b63);
pub const DSATTRIB_PicSampleSeq: windows_core::GUID = windows_core::GUID::from_u128(0x2f5bae02_7b8f_4f60_82d6_e4ea2f1f4c99);
pub const DSATTRIB_SAMPLE_LIVE_STREAM_TIME: windows_core::GUID = windows_core::GUID::from_u128(0x892cd111_72f3_411d_8b91_a9e9123ac29a);
pub const DSATTRIB_TRANSPORT_PROPERTIES: windows_core::GUID = windows_core::GUID::from_u128(0xb622f612_47ad_4671_ad6c_05a98e65de3a);
pub const DSATTRIB_UDCRTag: windows_core::GUID = windows_core::GUID::from_u128(0xeb7836ca_14ff_4919_bce7_3af12319e50c);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DXVA2_AES_CTR_IV {
    pub IV: u64,
    pub Count: u64,
}
impl Default for DXVA2_AES_CTR_IV {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DXVA2_AYUVSample16 {
    pub Cr: u16,
    pub Cb: u16,
    pub Y: u16,
    pub Alpha: u16,
}
impl Default for DXVA2_AYUVSample16 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DXVA2_AYUVSample8 {
    pub Cr: u8,
    pub Cb: u8,
    pub Y: u8,
    pub Alpha: u8,
}
impl Default for DXVA2_AYUVSample8 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const DXVA2_BitStreamDateBufferType: DXVA2_BufferfType = DXVA2_BufferfType(6i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DXVA2_BufferfType(pub i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DXVA2_ConfigPictureDecode {
    pub guidConfigBitstreamEncryption: windows_core::GUID,
    pub guidConfigMBcontrolEncryption: windows_core::GUID,
    pub guidConfigResidDiffEncryption: windows_core::GUID,
    pub ConfigBitstreamRaw: u32,
    pub ConfigMBcontrolRasterOrder: u32,
    pub ConfigResidDiffHost: u32,
    pub ConfigSpatialResid8: u32,
    pub ConfigResid8Subtraction: u32,
    pub ConfigSpatialHost8or9Clipping: u32,
    pub ConfigSpatialResidInterleaved: u32,
    pub ConfigIntraResidUnsigned: u32,
    pub ConfigResidDiffAccelerator: u32,
    pub ConfigHostInverseScan: u32,
    pub ConfigSpecificIDCT: u32,
    pub Config4GroupedCoefs: u32,
    pub ConfigMinRenderTargetBuffCount: u16,
    pub ConfigDecoderSpecific: u16,
}
impl Default for DXVA2_ConfigPictureDecode {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const DXVA2_DECODE_GET_DRIVER_HANDLE: u32 = 1829u32;
pub const DXVA2_DECODE_SPECIFY_ENCRYPTED_BLOCKS: u32 = 1828u32;
pub const DXVA2_DeblockingControlBufferType: DXVA2_BufferfType = DXVA2_BufferfType(3i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DXVA2_DecodeBufferDesc {
    pub CompressedBufferType: u32,
    pub BufferIndex: u32,
    pub DataOffset: u32,
    pub DataSize: u32,
    pub FirstMBaddress: u32,
    pub NumMBsInBuffer: u32,
    pub Width: u32,
    pub Height: u32,
    pub Stride: u32,
    pub ReservedBits: u32,
    pub pvPVPState: *mut core::ffi::c_void,
}
impl Default for DXVA2_DecodeBufferDesc {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DXVA2_DecodeExecuteParams {
    pub NumCompBuffers: u32,
    pub pCompressedBuffers: *mut DXVA2_DecodeBufferDesc,
    pub pExtensionData: *mut DXVA2_DecodeExtensionData,
}
impl Default for DXVA2_DecodeExecuteParams {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DXVA2_DecodeExtensionData {
    pub Function: u32,
    pub pPrivateInputData: *mut core::ffi::c_void,
    pub PrivateInputDataSize: u32,
    pub pPrivateOutputData: *mut core::ffi::c_void,
    pub PrivateOutputDataSize: u32,
}
impl Default for DXVA2_DecodeExtensionData {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DXVA2_DeinterlaceTech(pub i32);
pub const DXVA2_DeinterlaceTech_BOBLineReplicate: DXVA2_DeinterlaceTech = DXVA2_DeinterlaceTech(1i32);
pub const DXVA2_DeinterlaceTech_BOBVerticalStretch: DXVA2_DeinterlaceTech = DXVA2_DeinterlaceTech(2i32);
pub const DXVA2_DeinterlaceTech_BOBVerticalStretch4Tap: DXVA2_DeinterlaceTech = DXVA2_DeinterlaceTech(4i32);
pub const DXVA2_DeinterlaceTech_EdgeFiltering: DXVA2_DeinterlaceTech = DXVA2_DeinterlaceTech(16i32);
pub const DXVA2_DeinterlaceTech_FieldAdaptive: DXVA2_DeinterlaceTech = DXVA2_DeinterlaceTech(32i32);
pub const DXVA2_DeinterlaceTech_InverseTelecine: DXVA2_DeinterlaceTech = DXVA2_DeinterlaceTech(256i32);
pub const DXVA2_DeinterlaceTech_Mask: DXVA2_DeinterlaceTech = DXVA2_DeinterlaceTech(511i32);
pub const DXVA2_DeinterlaceTech_MedianFiltering: DXVA2_DeinterlaceTech = DXVA2_DeinterlaceTech(8i32);
pub const DXVA2_DeinterlaceTech_MotionVectorSteered: DXVA2_DeinterlaceTech = DXVA2_DeinterlaceTech(128i32);
pub const DXVA2_DeinterlaceTech_PixelAdaptive: DXVA2_DeinterlaceTech = DXVA2_DeinterlaceTech(64i32);
pub const DXVA2_DeinterlaceTech_Unknown: DXVA2_DeinterlaceTech = DXVA2_DeinterlaceTech(0i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DXVA2_DestData(pub i32);
pub const DXVA2_DestData_Mask: DXVA2_DestData = DXVA2_DestData(65535i32);
pub const DXVA2_DestData_RFF: DXVA2_DestData = DXVA2_DestData(1i32);
pub const DXVA2_DestData_RFF_TFF_Present: DXVA2_DestData = DXVA2_DestData(4i32);
pub const DXVA2_DestData_TFF: DXVA2_DestData = DXVA2_DestData(2i32);
pub const DXVA2_DetailFilterChromaLevel: DXVA2_FilterType = DXVA2_FilterType(10i32);
pub const DXVA2_DetailFilterChromaRadius: DXVA2_FilterType = DXVA2_FilterType(12i32);
pub const DXVA2_DetailFilterChromaThreshold: DXVA2_FilterType = DXVA2_FilterType(11i32);
pub const DXVA2_DetailFilterLumaLevel: DXVA2_FilterType = DXVA2_FilterType(7i32);
pub const DXVA2_DetailFilterLumaRadius: DXVA2_FilterType = DXVA2_FilterType(9i32);
pub const DXVA2_DetailFilterLumaThreshold: DXVA2_FilterType = DXVA2_FilterType(8i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DXVA2_DetailFilterTech(pub i32);
pub const DXVA2_DetailFilterTech_Edge: DXVA2_DetailFilterTech = DXVA2_DetailFilterTech(2i32);
pub const DXVA2_DetailFilterTech_Mask: DXVA2_DetailFilterTech = DXVA2_DetailFilterTech(7i32);
pub const DXVA2_DetailFilterTech_Sharpening: DXVA2_DetailFilterTech = DXVA2_DetailFilterTech(4i32);
pub const DXVA2_DetailFilterTech_Unknown: DXVA2_DetailFilterTech = DXVA2_DetailFilterTech(1i32);
pub const DXVA2_DetailFilterTech_Unsupported: DXVA2_DetailFilterTech = DXVA2_DetailFilterTech(0i32);
pub const DXVA2_E_NEW_VIDEO_DEVICE: windows_core::HRESULT = windows_core::HRESULT(0x80041001_u32 as _);
pub const DXVA2_E_NOT_AVAILABLE: windows_core::HRESULT = windows_core::HRESULT(0x80041003_u32 as _);
pub const DXVA2_E_NOT_INITIALIZED: windows_core::HRESULT = windows_core::HRESULT(0x80041000_u32 as _);
pub const DXVA2_E_VIDEO_DEVICE_LOCKED: windows_core::HRESULT = windows_core::HRESULT(0x80041002_u32 as _);
#[repr(C)]
#[derive(Clone, Copy)]
pub struct DXVA2_ExtendedFormat {
    pub Anonymous: DXVA2_ExtendedFormat_0,
}
impl Default for DXVA2_ExtendedFormat {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union DXVA2_ExtendedFormat_0 {
    pub Anonymous: DXVA2_ExtendedFormat_0_0,
    pub value: u32,
}
impl Default for DXVA2_ExtendedFormat_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DXVA2_ExtendedFormat_0_0 {
    pub _bitfield: u32,
}
impl Default for DXVA2_ExtendedFormat_0_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const DXVA2_FilmGrainBuffer: DXVA2_BufferfType = DXVA2_BufferfType(8i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DXVA2_FilterType(pub i32);
#[repr(C)]
#[derive(Clone, Copy)]
pub struct DXVA2_FilterValues {
    pub Level: DXVA2_Fixed32,
    pub Threshold: DXVA2_Fixed32,
    pub Radius: DXVA2_Fixed32,
}
impl Default for DXVA2_FilterValues {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub struct DXVA2_Fixed32 {
    pub Anonymous: DXVA2_Fixed32_0,
}
impl Default for DXVA2_Fixed32 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union DXVA2_Fixed32_0 {
    pub Anonymous: DXVA2_Fixed32_0_0,
    pub ll: i32,
}
impl Default for DXVA2_Fixed32_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DXVA2_Fixed32_0_0 {
    pub Fraction: u16,
    pub Value: i16,
}
impl Default for DXVA2_Fixed32_0_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DXVA2_Frequency {
    pub Numerator: u32,
    pub Denominator: u32,
}
impl Default for DXVA2_Frequency {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const DXVA2_InverseQuantizationMatrixBufferType: DXVA2_BufferfType = DXVA2_BufferfType(4i32);
pub const DXVA2_MacroBlockControlBufferType: DXVA2_BufferfType = DXVA2_BufferfType(1i32);
pub const DXVA2_ModeH264_A: windows_core::GUID = windows_core::GUID::from_u128(0x1b81be64_a0c7_11d3_b984_00c04f2e73c5);
pub const DXVA2_ModeH264_B: windows_core::GUID = windows_core::GUID::from_u128(0x1b81be65_a0c7_11d3_b984_00c04f2e73c5);
pub const DXVA2_ModeH264_C: windows_core::GUID = windows_core::GUID::from_u128(0x1b81be66_a0c7_11d3_b984_00c04f2e73c5);
pub const DXVA2_ModeH264_D: windows_core::GUID = windows_core::GUID::from_u128(0x1b81be67_a0c7_11d3_b984_00c04f2e73c5);
pub const DXVA2_ModeH264_E: windows_core::GUID = windows_core::GUID::from_u128(0x1b81be68_a0c7_11d3_b984_00c04f2e73c5);
pub const DXVA2_ModeH264_F: windows_core::GUID = windows_core::GUID::from_u128(0x1b81be69_a0c7_11d3_b984_00c04f2e73c5);
pub const DXVA2_ModeH264_VLD_Multiview_NoFGT: windows_core::GUID = windows_core::GUID::from_u128(0x705b9d82_76cf_49d6_b7e6_ac8872db013c);
pub const DXVA2_ModeH264_VLD_Stereo_NoFGT: windows_core::GUID = windows_core::GUID::from_u128(0xf9aaccbb_c2b6_4cfc_8779_5707b1760552);
pub const DXVA2_ModeH264_VLD_Stereo_Progressive_NoFGT: windows_core::GUID = windows_core::GUID::from_u128(0xd79be8da_0cf1_4c81_b82a_69a4e236f43d);
pub const DXVA2_ModeH264_VLD_WithFMOASO_NoFGT: windows_core::GUID = windows_core::GUID::from_u128(0xd5f04ff9_3418_45d8_9561_32a76aae2ddd);
pub const DXVA2_ModeHEVC_VLD_Main: windows_core::GUID = windows_core::GUID::from_u128(0x5b11d51b_2f4c_4452_bcc3_09f2a1160cc0);
pub const DXVA2_ModeHEVC_VLD_Main10: windows_core::GUID = windows_core::GUID::from_u128(0x107af0e0_ef1a_4d19_aba8_67a163073d13);
pub const DXVA2_ModeMPEG1_VLD: windows_core::GUID = windows_core::GUID::from_u128(0x6f3ec719_3735_42cc_8063_65cc3cb36616);
pub const DXVA2_ModeMPEG2_IDCT: windows_core::GUID = windows_core::GUID::from_u128(0xbf22ad00_03ea_4690_8077_473346209b7e);
pub const DXVA2_ModeMPEG2_MoComp: windows_core::GUID = windows_core::GUID::from_u128(0xe6a9f44b_61b0_4563_9ea4_63d2a3c6fe66);
pub const DXVA2_ModeMPEG2_VLD: windows_core::GUID = windows_core::GUID::from_u128(0xee27417f_5e28_4e65_beea_1d26b508adc9);
pub const DXVA2_ModeMPEG2and1_VLD: windows_core::GUID = windows_core::GUID::from_u128(0x86695f12_340e_4f04_9fd3_9253dd327460);
pub const DXVA2_ModeMPEG4pt2_VLD_AdvSimple_GMC: windows_core::GUID = windows_core::GUID::from_u128(0xab998b5b_4258_44a9_9feb_94e597a6baae);
pub const DXVA2_ModeMPEG4pt2_VLD_AdvSimple_NoGMC: windows_core::GUID = windows_core::GUID::from_u128(0xed418a9f_010d_4eda_9ae3_9a65358d8d2e);
pub const DXVA2_ModeMPEG4pt2_VLD_Simple: windows_core::GUID = windows_core::GUID::from_u128(0xefd64d74_c9e8_41d7_a5e9_e9b0e39fa319);
pub const DXVA2_ModeVC1_A: windows_core::GUID = windows_core::GUID::from_u128(0x1b81bea0_a0c7_11d3_b984_00c04f2e73c5);
pub const DXVA2_ModeVC1_B: windows_core::GUID = windows_core::GUID::from_u128(0x1b81bea1_a0c7_11d3_b984_00c04f2e73c5);
pub const DXVA2_ModeVC1_C: windows_core::GUID = windows_core::GUID::from_u128(0x1b81bea2_a0c7_11d3_b984_00c04f2e73c5);
pub const DXVA2_ModeVC1_D: windows_core::GUID = windows_core::GUID::from_u128(0x1b81bea3_a0c7_11d3_b984_00c04f2e73c5);
pub const DXVA2_ModeVC1_D2010: windows_core::GUID = windows_core::GUID::from_u128(0x1b81bea4_a0c7_11d3_b984_00c04f2e73c5);
pub const DXVA2_ModeVP8_VLD: windows_core::GUID = windows_core::GUID::from_u128(0x90b899ea_3a62_4705_88b3_8df04b2744e7);
pub const DXVA2_ModeVP9_VLD_10bit_Profile2: windows_core::GUID = windows_core::GUID::from_u128(0xa4c749ef_6ecf_48aa_8448_50a7a1165ff7);
pub const DXVA2_ModeVP9_VLD_Profile0: windows_core::GUID = windows_core::GUID::from_u128(0x463707f8_a1d0_4585_876d_83aa6d60b89e);
pub const DXVA2_ModeWMV8_A: windows_core::GUID = windows_core::GUID::from_u128(0x1b81be80_a0c7_11d3_b984_00c04f2e73c5);
pub const DXVA2_ModeWMV8_B: windows_core::GUID = windows_core::GUID::from_u128(0x1b81be81_a0c7_11d3_b984_00c04f2e73c5);
pub const DXVA2_ModeWMV9_A: windows_core::GUID = windows_core::GUID::from_u128(0x1b81be90_a0c7_11d3_b984_00c04f2e73c5);
pub const DXVA2_ModeWMV9_B: windows_core::GUID = windows_core::GUID::from_u128(0x1b81be91_a0c7_11d3_b984_00c04f2e73c5);
pub const DXVA2_ModeWMV9_C: windows_core::GUID = windows_core::GUID::from_u128(0x1b81be94_a0c7_11d3_b984_00c04f2e73c5);
pub const DXVA2_MotionVectorBuffer: DXVA2_BufferfType = DXVA2_BufferfType(7i32);
pub const DXVA2_NoEncrypt: windows_core::GUID = windows_core::GUID::from_u128(0x1b81bed0_a0c7_11d3_b984_00c04f2e73c5);
pub const DXVA2_NoiseFilterChromaLevel: DXVA2_FilterType = DXVA2_FilterType(4i32);
pub const DXVA2_NoiseFilterChromaRadius: DXVA2_FilterType = DXVA2_FilterType(6i32);
pub const DXVA2_NoiseFilterChromaThreshold: DXVA2_FilterType = DXVA2_FilterType(5i32);
pub const DXVA2_NoiseFilterLumaLevel: DXVA2_FilterType = DXVA2_FilterType(1i32);
pub const DXVA2_NoiseFilterLumaRadius: DXVA2_FilterType = DXVA2_FilterType(3i32);
pub const DXVA2_NoiseFilterLumaThreshold: DXVA2_FilterType = DXVA2_FilterType(2i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DXVA2_NoiseFilterTech(pub i32);
pub const DXVA2_NoiseFilterTech_BlockNoise: DXVA2_NoiseFilterTech = DXVA2_NoiseFilterTech(8i32);
pub const DXVA2_NoiseFilterTech_Mask: DXVA2_NoiseFilterTech = DXVA2_NoiseFilterTech(31i32);
pub const DXVA2_NoiseFilterTech_Median: DXVA2_NoiseFilterTech = DXVA2_NoiseFilterTech(2i32);
pub const DXVA2_NoiseFilterTech_MosquitoNoise: DXVA2_NoiseFilterTech = DXVA2_NoiseFilterTech(16i32);
pub const DXVA2_NoiseFilterTech_Temporal: DXVA2_NoiseFilterTech = DXVA2_NoiseFilterTech(4i32);
pub const DXVA2_NoiseFilterTech_Unknown: DXVA2_NoiseFilterTech = DXVA2_NoiseFilterTech(1i32);
pub const DXVA2_NoiseFilterTech_Unsupported: DXVA2_NoiseFilterTech = DXVA2_NoiseFilterTech(0i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DXVA2_NominalRange(pub i32);
pub const DXVA2_NominalRangeMask: DXVA2_NominalRange = DXVA2_NominalRange(7i32);
pub const DXVA2_NominalRange_0_255: DXVA2_NominalRange = DXVA2_NominalRange(1i32);
pub const DXVA2_NominalRange_16_235: DXVA2_NominalRange = DXVA2_NominalRange(2i32);
pub const DXVA2_NominalRange_48_208: DXVA2_NominalRange = DXVA2_NominalRange(3i32);
pub const DXVA2_NominalRange_Normal: DXVA2_NominalRange = DXVA2_NominalRange(1i32);
pub const DXVA2_NominalRange_Unknown: DXVA2_NominalRange = DXVA2_NominalRange(0i32);
pub const DXVA2_NominalRange_Wide: DXVA2_NominalRange = DXVA2_NominalRange(2i32);
pub const DXVA2_PictureParametersBufferType: DXVA2_BufferfType = DXVA2_BufferfType(0i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DXVA2_ProcAmp(pub i32);
#[repr(C)]
#[derive(Clone, Copy)]
pub struct DXVA2_ProcAmpValues {
    pub Brightness: DXVA2_Fixed32,
    pub Contrast: DXVA2_Fixed32,
    pub Hue: DXVA2_Fixed32,
    pub Saturation: DXVA2_Fixed32,
}
impl Default for DXVA2_ProcAmpValues {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const DXVA2_ProcAmp_Brightness: DXVA2_ProcAmp = DXVA2_ProcAmp(1i32);
pub const DXVA2_ProcAmp_Contrast: DXVA2_ProcAmp = DXVA2_ProcAmp(2i32);
pub const DXVA2_ProcAmp_Hue: DXVA2_ProcAmp = DXVA2_ProcAmp(4i32);
pub const DXVA2_ProcAmp_Mask: DXVA2_ProcAmp = DXVA2_ProcAmp(15i32);
pub const DXVA2_ProcAmp_None: DXVA2_ProcAmp = DXVA2_ProcAmp(0i32);
pub const DXVA2_ProcAmp_Saturation: DXVA2_ProcAmp = DXVA2_ProcAmp(8i32);
pub const DXVA2_ResidualDifferenceBufferType: DXVA2_BufferfType = DXVA2_BufferfType(2i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DXVA2_SampleData(pub i32);
pub const DXVA2_SampleData_Mask: DXVA2_SampleData = DXVA2_SampleData(65535i32);
pub const DXVA2_SampleData_RFF: DXVA2_SampleData = DXVA2_SampleData(1i32);
pub const DXVA2_SampleData_RFF_TFF_Present: DXVA2_SampleData = DXVA2_SampleData(4i32);
pub const DXVA2_SampleData_TFF: DXVA2_SampleData = DXVA2_SampleData(2i32);
pub const DXVA2_SampleFieldInterleavedEvenFirst: DXVA2_SampleFormat = DXVA2_SampleFormat(3i32);
pub const DXVA2_SampleFieldInterleavedOddFirst: DXVA2_SampleFormat = DXVA2_SampleFormat(4i32);
pub const DXVA2_SampleFieldSingleEven: DXVA2_SampleFormat = DXVA2_SampleFormat(5i32);
pub const DXVA2_SampleFieldSingleOdd: DXVA2_SampleFormat = DXVA2_SampleFormat(6i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DXVA2_SampleFormat(pub i32);
pub const DXVA2_SampleFormatMask: DXVA2_SampleFormat = DXVA2_SampleFormat(255i32);
pub const DXVA2_SampleProgressiveFrame: DXVA2_SampleFormat = DXVA2_SampleFormat(2i32);
pub const DXVA2_SampleSubStream: DXVA2_SampleFormat = DXVA2_SampleFormat(7i32);
pub const DXVA2_SampleUnknown: DXVA2_SampleFormat = DXVA2_SampleFormat(0i32);
pub const DXVA2_SliceControlBufferType: DXVA2_BufferfType = DXVA2_BufferfType(5i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DXVA2_SurfaceType(pub i32);
pub const DXVA2_SurfaceType_D3DRenderTargetTexture: DXVA2_SurfaceType = DXVA2_SurfaceType(2i32);
pub const DXVA2_SurfaceType_DecoderRenderTarget: DXVA2_SurfaceType = DXVA2_SurfaceType(0i32);
pub const DXVA2_SurfaceType_ProcessorRenderTarget: DXVA2_SurfaceType = DXVA2_SurfaceType(1i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DXVA2_VPDev(pub i32);
pub const DXVA2_VPDev_EmulatedDXVA1: DXVA2_VPDev = DXVA2_VPDev(2i32);
pub const DXVA2_VPDev_HardwareDevice: DXVA2_VPDev = DXVA2_VPDev(1i32);
pub const DXVA2_VPDev_Mask: DXVA2_VPDev = DXVA2_VPDev(7i32);
pub const DXVA2_VPDev_SoftwareDevice: DXVA2_VPDev = DXVA2_VPDev(4i32);
#[repr(C)]
#[derive(Clone, Copy)]
pub struct DXVA2_ValueRange {
    pub MinValue: DXVA2_Fixed32,
    pub MaxValue: DXVA2_Fixed32,
    pub DefaultValue: DXVA2_Fixed32,
    pub StepSize: DXVA2_Fixed32,
}
impl Default for DXVA2_ValueRange {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DXVA2_VideoChromaSubSampling(pub i32);
pub const DXVA2_VideoChromaSubsamplingMask: DXVA2_VideoChromaSubSampling = DXVA2_VideoChromaSubSampling(15i32);
pub const DXVA2_VideoChromaSubsampling_Cosited: DXVA2_VideoChromaSubSampling = DXVA2_VideoChromaSubSampling(7i32);
pub const DXVA2_VideoChromaSubsampling_DV_PAL: DXVA2_VideoChromaSubSampling = DXVA2_VideoChromaSubSampling(6i32);
pub const DXVA2_VideoChromaSubsampling_Horizontally_Cosited: DXVA2_VideoChromaSubSampling = DXVA2_VideoChromaSubSampling(4i32);
pub const DXVA2_VideoChromaSubsampling_MPEG1: DXVA2_VideoChromaSubSampling = DXVA2_VideoChromaSubSampling(1i32);
pub const DXVA2_VideoChromaSubsampling_MPEG2: DXVA2_VideoChromaSubSampling = DXVA2_VideoChromaSubSampling(5i32);
pub const DXVA2_VideoChromaSubsampling_ProgressiveChroma: DXVA2_VideoChromaSubSampling = DXVA2_VideoChromaSubSampling(8i32);
pub const DXVA2_VideoChromaSubsampling_Unknown: DXVA2_VideoChromaSubSampling = DXVA2_VideoChromaSubSampling(0i32);
pub const DXVA2_VideoChromaSubsampling_Vertically_AlignedChromaPlanes: DXVA2_VideoChromaSubSampling = DXVA2_VideoChromaSubSampling(1i32);
pub const DXVA2_VideoChromaSubsampling_Vertically_Cosited: DXVA2_VideoChromaSubSampling = DXVA2_VideoChromaSubSampling(2i32);
pub const DXVA2_VideoDecoderRenderTarget: DXVA2_VideoRenderTargetType = DXVA2_VideoRenderTargetType(0i32);
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Direct3D9")]
#[derive(Clone, Copy)]
pub struct DXVA2_VideoDesc {
    pub SampleWidth: u32,
    pub SampleHeight: u32,
    pub SampleFormat: DXVA2_ExtendedFormat,
    pub Format: super::super::Graphics::Direct3D9::D3DFORMAT,
    pub InputSampleFreq: DXVA2_Frequency,
    pub OutputFrameFreq: DXVA2_Frequency,
    pub UABProtectionLevel: u32,
    pub Reserved: u32,
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl Default for DXVA2_VideoDesc {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DXVA2_VideoLighting(pub i32);
pub const DXVA2_VideoLightingMask: DXVA2_VideoLighting = DXVA2_VideoLighting(15i32);
pub const DXVA2_VideoLighting_Unknown: DXVA2_VideoLighting = DXVA2_VideoLighting(0i32);
pub const DXVA2_VideoLighting_bright: DXVA2_VideoLighting = DXVA2_VideoLighting(1i32);
pub const DXVA2_VideoLighting_dark: DXVA2_VideoLighting = DXVA2_VideoLighting(4i32);
pub const DXVA2_VideoLighting_dim: DXVA2_VideoLighting = DXVA2_VideoLighting(3i32);
pub const DXVA2_VideoLighting_office: DXVA2_VideoLighting = DXVA2_VideoLighting(2i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DXVA2_VideoPrimaries(pub i32);
pub const DXVA2_VideoPrimariesMask: DXVA2_VideoPrimaries = DXVA2_VideoPrimaries(31i32);
pub const DXVA2_VideoPrimaries_BT470_2_SysBG: DXVA2_VideoPrimaries = DXVA2_VideoPrimaries(4i32);
pub const DXVA2_VideoPrimaries_BT470_2_SysM: DXVA2_VideoPrimaries = DXVA2_VideoPrimaries(3i32);
pub const DXVA2_VideoPrimaries_BT709: DXVA2_VideoPrimaries = DXVA2_VideoPrimaries(2i32);
pub const DXVA2_VideoPrimaries_EBU3213: DXVA2_VideoPrimaries = DXVA2_VideoPrimaries(7i32);
pub const DXVA2_VideoPrimaries_SMPTE170M: DXVA2_VideoPrimaries = DXVA2_VideoPrimaries(5i32);
pub const DXVA2_VideoPrimaries_SMPTE240M: DXVA2_VideoPrimaries = DXVA2_VideoPrimaries(6i32);
pub const DXVA2_VideoPrimaries_SMPTE_C: DXVA2_VideoPrimaries = DXVA2_VideoPrimaries(8i32);
pub const DXVA2_VideoPrimaries_Unknown: DXVA2_VideoPrimaries = DXVA2_VideoPrimaries(0i32);
pub const DXVA2_VideoPrimaries_reserved: DXVA2_VideoPrimaries = DXVA2_VideoPrimaries(1i32);
pub const DXVA2_VideoProcBobDevice: windows_core::GUID = windows_core::GUID::from_u128(0x335aa36e_7884_43a4_9c91_7f87faf3e37e);
pub const DXVA2_VideoProcProgressiveDevice: windows_core::GUID = windows_core::GUID::from_u128(0x5a54a0c9_c7ec_4bd9_8ede_f3c75dc4393b);
pub const DXVA2_VideoProcSoftwareDevice: windows_core::GUID = windows_core::GUID::from_u128(0x4553d47f_ee7e_4e3f_9475_dbf1376c4810);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DXVA2_VideoProcess(pub i32);
#[repr(C)]
#[derive(Clone, Copy)]
pub struct DXVA2_VideoProcessBltParams {
    pub TargetFrame: i64,
    pub TargetRect: super::super::Foundation::RECT,
    pub ConstrictionSize: super::super::Foundation::SIZE,
    pub StreamingFlags: u32,
    pub BackgroundColor: DXVA2_AYUVSample16,
    pub DestFormat: DXVA2_ExtendedFormat,
    pub ProcAmpValues: DXVA2_ProcAmpValues,
    pub Alpha: DXVA2_Fixed32,
    pub NoiseFilterLuma: DXVA2_FilterValues,
    pub NoiseFilterChroma: DXVA2_FilterValues,
    pub DetailFilterLuma: DXVA2_FilterValues,
    pub DetailFilterChroma: DXVA2_FilterValues,
    pub DestData: u32,
}
impl Default for DXVA2_VideoProcessBltParams {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const DXVA2_VideoProcess_AlphaBlend: DXVA2_VideoProcess = DXVA2_VideoProcess(8i32);
pub const DXVA2_VideoProcess_AlphaBlendExtended: DXVA2_VideoProcess = DXVA2_VideoProcess(256i32);
pub const DXVA2_VideoProcess_Constriction: DXVA2_VideoProcess = DXVA2_VideoProcess(512i32);
pub const DXVA2_VideoProcess_DetailFilter: DXVA2_VideoProcess = DXVA2_VideoProcess(2048i32);
pub const DXVA2_VideoProcess_GammaCompensated: DXVA2_VideoProcess = DXVA2_VideoProcess(16384i32);
pub const DXVA2_VideoProcess_LinearScaling: DXVA2_VideoProcess = DXVA2_VideoProcess(8192i32);
pub const DXVA2_VideoProcess_MaintainsOriginalFieldData: DXVA2_VideoProcess = DXVA2_VideoProcess(32768i32);
pub const DXVA2_VideoProcess_Mask: DXVA2_VideoProcess = DXVA2_VideoProcess(65535i32);
pub const DXVA2_VideoProcess_NoiseFilter: DXVA2_VideoProcess = DXVA2_VideoProcess(1024i32);
pub const DXVA2_VideoProcess_None: DXVA2_VideoProcess = DXVA2_VideoProcess(0i32);
pub const DXVA2_VideoProcess_PlanarAlpha: DXVA2_VideoProcess = DXVA2_VideoProcess(4096i32);
pub const DXVA2_VideoProcess_StretchX: DXVA2_VideoProcess = DXVA2_VideoProcess(2i32);
pub const DXVA2_VideoProcess_StretchY: DXVA2_VideoProcess = DXVA2_VideoProcess(4i32);
pub const DXVA2_VideoProcess_SubRects: DXVA2_VideoProcess = DXVA2_VideoProcess(16i32);
pub const DXVA2_VideoProcess_SubStreams: DXVA2_VideoProcess = DXVA2_VideoProcess(32i32);
pub const DXVA2_VideoProcess_SubStreamsExtended: DXVA2_VideoProcess = DXVA2_VideoProcess(64i32);
pub const DXVA2_VideoProcess_YUV2RGB: DXVA2_VideoProcess = DXVA2_VideoProcess(1i32);
pub const DXVA2_VideoProcess_YUV2RGBExtended: DXVA2_VideoProcess = DXVA2_VideoProcess(128i32);
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Direct3D9")]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DXVA2_VideoProcessorCaps {
    pub DeviceCaps: u32,
    pub InputPool: super::super::Graphics::Direct3D9::D3DPOOL,
    pub NumForwardRefSamples: u32,
    pub NumBackwardRefSamples: u32,
    pub Reserved: u32,
    pub DeinterlaceTechnology: u32,
    pub ProcAmpControlCaps: u32,
    pub VideoProcessorOperations: u32,
    pub NoiseFilterTechnology: u32,
    pub DetailFilterTechnology: u32,
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl Default for DXVA2_VideoProcessorCaps {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const DXVA2_VideoProcessorRenderTarget: DXVA2_VideoRenderTargetType = DXVA2_VideoRenderTargetType(1i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DXVA2_VideoRenderTargetType(pub i32);
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Direct3D9")]
pub struct DXVA2_VideoSample {
    pub Start: i64,
    pub End: i64,
    pub SampleFormat: DXVA2_ExtendedFormat,
    pub SrcSurface: core::mem::ManuallyDrop<Option<super::super::Graphics::Direct3D9::IDirect3DSurface9>>,
    pub SrcRect: super::super::Foundation::RECT,
    pub DstRect: super::super::Foundation::RECT,
    pub Pal: [DXVA2_AYUVSample8; 16],
    pub PlanarAlpha: DXVA2_Fixed32,
    pub SampleData: u32,
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl Clone for DXVA2_VideoSample {
    fn clone(&self) -> Self {
        unsafe { core::mem::transmute_copy(self) }
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl Default for DXVA2_VideoSample {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const DXVA2_VideoSoftwareRenderTarget: DXVA2_VideoRenderTargetType = DXVA2_VideoRenderTargetType(2i32);
pub const DXVA2_VideoTransFuncMask: DXVA2_VideoTransferFunction = DXVA2_VideoTransferFunction(31i32);
pub const DXVA2_VideoTransFunc_10: DXVA2_VideoTransferFunction = DXVA2_VideoTransferFunction(1i32);
pub const DXVA2_VideoTransFunc_18: DXVA2_VideoTransferFunction = DXVA2_VideoTransferFunction(2i32);
pub const DXVA2_VideoTransFunc_20: DXVA2_VideoTransferFunction = DXVA2_VideoTransferFunction(3i32);
pub const DXVA2_VideoTransFunc_22: DXVA2_VideoTransferFunction = DXVA2_VideoTransferFunction(4i32);
pub const DXVA2_VideoTransFunc_240M: DXVA2_VideoTransferFunction = DXVA2_VideoTransferFunction(6i32);
pub const DXVA2_VideoTransFunc_28: DXVA2_VideoTransferFunction = DXVA2_VideoTransferFunction(8i32);
pub const DXVA2_VideoTransFunc_709: DXVA2_VideoTransferFunction = DXVA2_VideoTransferFunction(5i32);
pub const DXVA2_VideoTransFunc_Unknown: DXVA2_VideoTransferFunction = DXVA2_VideoTransferFunction(0i32);
pub const DXVA2_VideoTransFunc_sRGB: DXVA2_VideoTransferFunction = DXVA2_VideoTransferFunction(7i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DXVA2_VideoTransferFunction(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DXVA2_VideoTransferMatrix(pub i32);
pub const DXVA2_VideoTransferMatrixMask: DXVA2_VideoTransferMatrix = DXVA2_VideoTransferMatrix(7i32);
pub const DXVA2_VideoTransferMatrix_BT601: DXVA2_VideoTransferMatrix = DXVA2_VideoTransferMatrix(2i32);
pub const DXVA2_VideoTransferMatrix_BT709: DXVA2_VideoTransferMatrix = DXVA2_VideoTransferMatrix(1i32);
pub const DXVA2_VideoTransferMatrix_SMPTE240M: DXVA2_VideoTransferMatrix = DXVA2_VideoTransferMatrix(3i32);
pub const DXVA2_VideoTransferMatrix_Unknown: DXVA2_VideoTransferMatrix = DXVA2_VideoTransferMatrix(0i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DXVABufferInfo {
    pub pCompSurface: *mut core::ffi::c_void,
    pub DataOffset: u32,
    pub DataSize: u32,
}
impl Default for DXVABufferInfo {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Direct3D9")]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DXVACompBufferInfo {
    pub NumCompBuffers: u32,
    pub WidthToCreate: u32,
    pub HeightToCreate: u32,
    pub BytesToAllocate: u32,
    pub Usage: u32,
    pub Pool: super::super::Graphics::Direct3D9::D3DPOOL,
    pub Format: super::super::Graphics::Direct3D9::D3DFORMAT,
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl Default for DXVACompBufferInfo {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const DXVAHDControlGuid: windows_core::GUID = windows_core::GUID::from_u128(0xa0386e75_f70c_464c_a9ce_33c44e091623);
pub const DXVAHDETWGUID_CREATEVIDEOPROCESSOR: windows_core::GUID = windows_core::GUID::from_u128(0x681e3d1e_5674_4fb3_a503_2f2055e91f60);
pub const DXVAHDETWGUID_DESTROYVIDEOPROCESSOR: windows_core::GUID = windows_core::GUID::from_u128(0xf943f0a0_3f16_43e0_8093_105a986aa5f1);
pub const DXVAHDETWGUID_VIDEOPROCESSBLTHD: windows_core::GUID = windows_core::GUID::from_u128(0xbef3d435_78c7_4de3_9707_cd1b083b160a);
pub const DXVAHDETWGUID_VIDEOPROCESSBLTHD_STREAM: windows_core::GUID = windows_core::GUID::from_u128(0x27ae473e_a5fc_4be5_b4e3_f24994d3c495);
pub const DXVAHDETWGUID_VIDEOPROCESSBLTSTATE: windows_core::GUID = windows_core::GUID::from_u128(0x76c94b5a_193f_4692_9484_a4d999da81a8);
pub const DXVAHDETWGUID_VIDEOPROCESSSTREAMSTATE: windows_core::GUID = windows_core::GUID::from_u128(0x262c0b02_209d_47ed_94d8_82ae02b84aa7);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DXVAHDETW_CREATEVIDEOPROCESSOR {
    pub pObject: u64,
    pub pD3D9Ex: u64,
    pub VPGuid: windows_core::GUID,
}
impl Default for DXVAHDETW_CREATEVIDEOPROCESSOR {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DXVAHDETW_DESTROYVIDEOPROCESSOR {
    pub pObject: u64,
}
impl Default for DXVAHDETW_DESTROYVIDEOPROCESSOR {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Direct3D9")]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DXVAHDETW_VIDEOPROCESSBLTHD {
    pub pObject: u64,
    pub pOutputSurface: u64,
    pub TargetRect: super::super::Foundation::RECT,
    pub OutputFormat: super::super::Graphics::Direct3D9::D3DFORMAT,
    pub ColorSpace: u32,
    pub OutputFrame: u32,
    pub StreamCount: u32,
    pub Enter: super::super::Foundation::BOOL,
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl Default for DXVAHDETW_VIDEOPROCESSBLTHD {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Direct3D9")]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DXVAHDETW_VIDEOPROCESSBLTHD_STREAM {
    pub pObject: u64,
    pub pInputSurface: u64,
    pub SourceRect: super::super::Foundation::RECT,
    pub DestinationRect: super::super::Foundation::RECT,
    pub InputFormat: super::super::Graphics::Direct3D9::D3DFORMAT,
    pub FrameFormat: DXVAHD_FRAME_FORMAT,
    pub ColorSpace: u32,
    pub StreamNumber: u32,
    pub OutputIndex: u32,
    pub InputFrameOrField: u32,
    pub PastFrames: u32,
    pub FutureFrames: u32,
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl Default for DXVAHDETW_VIDEOPROCESSBLTHD_STREAM {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DXVAHDETW_VIDEOPROCESSBLTSTATE {
    pub pObject: u64,
    pub State: DXVAHD_BLT_STATE,
    pub DataSize: u32,
    pub SetState: super::super::Foundation::BOOL,
}
impl Default for DXVAHDETW_VIDEOPROCESSBLTSTATE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DXVAHDETW_VIDEOPROCESSSTREAMSTATE {
    pub pObject: u64,
    pub StreamNumber: u32,
    pub State: DXVAHD_STREAM_STATE,
    pub DataSize: u32,
    pub SetState: super::super::Foundation::BOOL,
}
impl Default for DXVAHDETW_VIDEOPROCESSSTREAMSTATE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Direct3D9")]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DXVAHDSW_CALLBACKS {
    pub CreateDevice: PDXVAHDSW_CreateDevice,
    pub ProposeVideoPrivateFormat: PDXVAHDSW_ProposeVideoPrivateFormat,
    pub GetVideoProcessorDeviceCaps: PDXVAHDSW_GetVideoProcessorDeviceCaps,
    pub GetVideoProcessorOutputFormats: PDXVAHDSW_GetVideoProcessorOutputFormats,
    pub GetVideoProcessorInputFormats: PDXVAHDSW_GetVideoProcessorInputFormats,
    pub GetVideoProcessorCaps: PDXVAHDSW_GetVideoProcessorCaps,
    pub GetVideoProcessorCustomRates: PDXVAHDSW_GetVideoProcessorCustomRates,
    pub GetVideoProcessorFilterRange: PDXVAHDSW_GetVideoProcessorFilterRange,
    pub DestroyDevice: PDXVAHDSW_DestroyDevice,
    pub CreateVideoProcessor: PDXVAHDSW_CreateVideoProcessor,
    pub SetVideoProcessBltState: PDXVAHDSW_SetVideoProcessBltState,
    pub GetVideoProcessBltStatePrivate: PDXVAHDSW_GetVideoProcessBltStatePrivate,
    pub SetVideoProcessStreamState: PDXVAHDSW_SetVideoProcessStreamState,
    pub GetVideoProcessStreamStatePrivate: PDXVAHDSW_GetVideoProcessStreamStatePrivate,
    pub VideoProcessBltHD: PDXVAHDSW_VideoProcessBltHD,
    pub DestroyVideoProcessor: PDXVAHDSW_DestroyVideoProcessor,
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl Default for DXVAHDSW_CALLBACKS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DXVAHD_ALPHA_FILL_MODE(pub i32);
pub const DXVAHD_ALPHA_FILL_MODE_BACKGROUND: DXVAHD_ALPHA_FILL_MODE = DXVAHD_ALPHA_FILL_MODE(1i32);
pub const DXVAHD_ALPHA_FILL_MODE_DESTINATION: DXVAHD_ALPHA_FILL_MODE = DXVAHD_ALPHA_FILL_MODE(2i32);
pub const DXVAHD_ALPHA_FILL_MODE_OPAQUE: DXVAHD_ALPHA_FILL_MODE = DXVAHD_ALPHA_FILL_MODE(0i32);
pub const DXVAHD_ALPHA_FILL_MODE_SOURCE_STREAM: DXVAHD_ALPHA_FILL_MODE = DXVAHD_ALPHA_FILL_MODE(3i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DXVAHD_BLT_STATE(pub i32);
pub const DXVAHD_BLT_STATE_ALPHA_FILL: DXVAHD_BLT_STATE = DXVAHD_BLT_STATE(3i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DXVAHD_BLT_STATE_ALPHA_FILL_DATA {
    pub Mode: DXVAHD_ALPHA_FILL_MODE,
    pub StreamNumber: u32,
}
impl Default for DXVAHD_BLT_STATE_ALPHA_FILL_DATA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const DXVAHD_BLT_STATE_BACKGROUND_COLOR: DXVAHD_BLT_STATE = DXVAHD_BLT_STATE(1i32);
#[repr(C)]
#[derive(Clone, Copy)]
pub struct DXVAHD_BLT_STATE_BACKGROUND_COLOR_DATA {
    pub YCbCr: super::super::Foundation::BOOL,
    pub BackgroundColor: DXVAHD_COLOR,
}
impl Default for DXVAHD_BLT_STATE_BACKGROUND_COLOR_DATA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const DXVAHD_BLT_STATE_CONSTRICTION: DXVAHD_BLT_STATE = DXVAHD_BLT_STATE(4i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DXVAHD_BLT_STATE_CONSTRICTION_DATA {
    pub Enable: super::super::Foundation::BOOL,
    pub Size: super::super::Foundation::SIZE,
}
impl Default for DXVAHD_BLT_STATE_CONSTRICTION_DATA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const DXVAHD_BLT_STATE_OUTPUT_COLOR_SPACE: DXVAHD_BLT_STATE = DXVAHD_BLT_STATE(2i32);
#[repr(C)]
#[derive(Clone, Copy)]
pub struct DXVAHD_BLT_STATE_OUTPUT_COLOR_SPACE_DATA {
    pub Anonymous: DXVAHD_BLT_STATE_OUTPUT_COLOR_SPACE_DATA_0,
}
impl Default for DXVAHD_BLT_STATE_OUTPUT_COLOR_SPACE_DATA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union DXVAHD_BLT_STATE_OUTPUT_COLOR_SPACE_DATA_0 {
    pub Anonymous: DXVAHD_BLT_STATE_OUTPUT_COLOR_SPACE_DATA_0_0,
    pub Value: u32,
}
impl Default for DXVAHD_BLT_STATE_OUTPUT_COLOR_SPACE_DATA_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DXVAHD_BLT_STATE_OUTPUT_COLOR_SPACE_DATA_0_0 {
    pub _bitfield: u32,
}
impl Default for DXVAHD_BLT_STATE_OUTPUT_COLOR_SPACE_DATA_0_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const DXVAHD_BLT_STATE_PRIVATE: DXVAHD_BLT_STATE = DXVAHD_BLT_STATE(1000i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DXVAHD_BLT_STATE_PRIVATE_DATA {
    pub Guid: windows_core::GUID,
    pub DataSize: u32,
    pub pData: *mut core::ffi::c_void,
}
impl Default for DXVAHD_BLT_STATE_PRIVATE_DATA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const DXVAHD_BLT_STATE_TARGET_RECT: DXVAHD_BLT_STATE = DXVAHD_BLT_STATE(0i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DXVAHD_BLT_STATE_TARGET_RECT_DATA {
    pub Enable: super::super::Foundation::BOOL,
    pub TargetRect: super::super::Foundation::RECT,
}
impl Default for DXVAHD_BLT_STATE_TARGET_RECT_DATA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union DXVAHD_COLOR {
    pub RGB: DXVAHD_COLOR_RGBA,
    pub YCbCr: DXVAHD_COLOR_YCbCrA,
}
impl Default for DXVAHD_COLOR {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DXVAHD_COLOR_RGBA {
    pub R: f32,
    pub G: f32,
    pub B: f32,
    pub A: f32,
}
impl Default for DXVAHD_COLOR_RGBA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DXVAHD_COLOR_YCbCrA {
    pub Y: f32,
    pub Cb: f32,
    pub Cr: f32,
    pub A: f32,
}
impl Default for DXVAHD_COLOR_YCbCrA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DXVAHD_CONTENT_DESC {
    pub InputFrameFormat: DXVAHD_FRAME_FORMAT,
    pub InputFrameRate: DXVAHD_RATIONAL,
    pub InputWidth: u32,
    pub InputHeight: u32,
    pub OutputFrameRate: DXVAHD_RATIONAL,
    pub OutputWidth: u32,
    pub OutputHeight: u32,
}
impl Default for DXVAHD_CONTENT_DESC {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DXVAHD_CUSTOM_RATE_DATA {
    pub CustomRate: DXVAHD_RATIONAL,
    pub OutputFrames: u32,
    pub InputInterlaced: super::super::Foundation::BOOL,
    pub InputFramesOrFields: u32,
}
impl Default for DXVAHD_CUSTOM_RATE_DATA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DXVAHD_DEVICE_CAPS(pub i32);
pub const DXVAHD_DEVICE_CAPS_LINEAR_SPACE: DXVAHD_DEVICE_CAPS = DXVAHD_DEVICE_CAPS(1i32);
pub const DXVAHD_DEVICE_CAPS_RGB_RANGE_CONVERSION: DXVAHD_DEVICE_CAPS = DXVAHD_DEVICE_CAPS(4i32);
pub const DXVAHD_DEVICE_CAPS_YCbCr_MATRIX_CONVERSION: DXVAHD_DEVICE_CAPS = DXVAHD_DEVICE_CAPS(8i32);
pub const DXVAHD_DEVICE_CAPS_xvYCC: DXVAHD_DEVICE_CAPS = DXVAHD_DEVICE_CAPS(2i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DXVAHD_DEVICE_TYPE(pub i32);
pub const DXVAHD_DEVICE_TYPE_HARDWARE: DXVAHD_DEVICE_TYPE = DXVAHD_DEVICE_TYPE(0i32);
pub const DXVAHD_DEVICE_TYPE_OTHER: DXVAHD_DEVICE_TYPE = DXVAHD_DEVICE_TYPE(3i32);
pub const DXVAHD_DEVICE_TYPE_REFERENCE: DXVAHD_DEVICE_TYPE = DXVAHD_DEVICE_TYPE(2i32);
pub const DXVAHD_DEVICE_TYPE_SOFTWARE: DXVAHD_DEVICE_TYPE = DXVAHD_DEVICE_TYPE(1i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DXVAHD_DEVICE_USAGE(pub i32);
pub const DXVAHD_DEVICE_USAGE_OPTIMAL_QUALITY: DXVAHD_DEVICE_USAGE = DXVAHD_DEVICE_USAGE(2i32);
pub const DXVAHD_DEVICE_USAGE_OPTIMAL_SPEED: DXVAHD_DEVICE_USAGE = DXVAHD_DEVICE_USAGE(1i32);
pub const DXVAHD_DEVICE_USAGE_PLAYBACK_NORMAL: DXVAHD_DEVICE_USAGE = DXVAHD_DEVICE_USAGE(0i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DXVAHD_FEATURE_CAPS(pub i32);
pub const DXVAHD_FEATURE_CAPS_ALPHA_FILL: DXVAHD_FEATURE_CAPS = DXVAHD_FEATURE_CAPS(1i32);
pub const DXVAHD_FEATURE_CAPS_ALPHA_PALETTE: DXVAHD_FEATURE_CAPS = DXVAHD_FEATURE_CAPS(8i32);
pub const DXVAHD_FEATURE_CAPS_CONSTRICTION: DXVAHD_FEATURE_CAPS = DXVAHD_FEATURE_CAPS(2i32);
pub const DXVAHD_FEATURE_CAPS_LUMA_KEY: DXVAHD_FEATURE_CAPS = DXVAHD_FEATURE_CAPS(4i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DXVAHD_FILTER(pub i32);
pub const DXVAHD_FILTER_ANAMORPHIC_SCALING: DXVAHD_FILTER = DXVAHD_FILTER(6i32);
pub const DXVAHD_FILTER_BRIGHTNESS: DXVAHD_FILTER = DXVAHD_FILTER(0i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DXVAHD_FILTER_CAPS(pub i32);
pub const DXVAHD_FILTER_CAPS_ANAMORPHIC_SCALING: DXVAHD_FILTER_CAPS = DXVAHD_FILTER_CAPS(64i32);
pub const DXVAHD_FILTER_CAPS_BRIGHTNESS: DXVAHD_FILTER_CAPS = DXVAHD_FILTER_CAPS(1i32);
pub const DXVAHD_FILTER_CAPS_CONTRAST: DXVAHD_FILTER_CAPS = DXVAHD_FILTER_CAPS(2i32);
pub const DXVAHD_FILTER_CAPS_EDGE_ENHANCEMENT: DXVAHD_FILTER_CAPS = DXVAHD_FILTER_CAPS(32i32);
pub const DXVAHD_FILTER_CAPS_HUE: DXVAHD_FILTER_CAPS = DXVAHD_FILTER_CAPS(4i32);
pub const DXVAHD_FILTER_CAPS_NOISE_REDUCTION: DXVAHD_FILTER_CAPS = DXVAHD_FILTER_CAPS(16i32);
pub const DXVAHD_FILTER_CAPS_SATURATION: DXVAHD_FILTER_CAPS = DXVAHD_FILTER_CAPS(8i32);
pub const DXVAHD_FILTER_CONTRAST: DXVAHD_FILTER = DXVAHD_FILTER(1i32);
pub const DXVAHD_FILTER_EDGE_ENHANCEMENT: DXVAHD_FILTER = DXVAHD_FILTER(5i32);
pub const DXVAHD_FILTER_HUE: DXVAHD_FILTER = DXVAHD_FILTER(2i32);
pub const DXVAHD_FILTER_NOISE_REDUCTION: DXVAHD_FILTER = DXVAHD_FILTER(4i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DXVAHD_FILTER_RANGE_DATA {
    pub Minimum: i32,
    pub Maximum: i32,
    pub Default: i32,
    pub Multiplier: f32,
}
impl Default for DXVAHD_FILTER_RANGE_DATA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const DXVAHD_FILTER_SATURATION: DXVAHD_FILTER = DXVAHD_FILTER(3i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DXVAHD_FRAME_FORMAT(pub i32);
pub const DXVAHD_FRAME_FORMAT_INTERLACED_BOTTOM_FIELD_FIRST: DXVAHD_FRAME_FORMAT = DXVAHD_FRAME_FORMAT(2i32);
pub const DXVAHD_FRAME_FORMAT_INTERLACED_TOP_FIELD_FIRST: DXVAHD_FRAME_FORMAT = DXVAHD_FRAME_FORMAT(1i32);
pub const DXVAHD_FRAME_FORMAT_PROGRESSIVE: DXVAHD_FRAME_FORMAT = DXVAHD_FRAME_FORMAT(0i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DXVAHD_INPUT_FORMAT_CAPS(pub i32);
pub const DXVAHD_INPUT_FORMAT_CAPS_PALETTE_INTERLACED: DXVAHD_INPUT_FORMAT_CAPS = DXVAHD_INPUT_FORMAT_CAPS(8i32);
pub const DXVAHD_INPUT_FORMAT_CAPS_RGB_INTERLACED: DXVAHD_INPUT_FORMAT_CAPS = DXVAHD_INPUT_FORMAT_CAPS(1i32);
pub const DXVAHD_INPUT_FORMAT_CAPS_RGB_LUMA_KEY: DXVAHD_INPUT_FORMAT_CAPS = DXVAHD_INPUT_FORMAT_CAPS(4i32);
pub const DXVAHD_INPUT_FORMAT_CAPS_RGB_PROCAMP: DXVAHD_INPUT_FORMAT_CAPS = DXVAHD_INPUT_FORMAT_CAPS(2i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DXVAHD_ITELECINE_CAPS(pub i32);
pub const DXVAHD_ITELECINE_CAPS_22: DXVAHD_ITELECINE_CAPS = DXVAHD_ITELECINE_CAPS(2i32);
pub const DXVAHD_ITELECINE_CAPS_222222222223: DXVAHD_ITELECINE_CAPS = DXVAHD_ITELECINE_CAPS(256i32);
pub const DXVAHD_ITELECINE_CAPS_2224: DXVAHD_ITELECINE_CAPS = DXVAHD_ITELECINE_CAPS(4i32);
pub const DXVAHD_ITELECINE_CAPS_2332: DXVAHD_ITELECINE_CAPS = DXVAHD_ITELECINE_CAPS(8i32);
pub const DXVAHD_ITELECINE_CAPS_32: DXVAHD_ITELECINE_CAPS = DXVAHD_ITELECINE_CAPS(1i32);
pub const DXVAHD_ITELECINE_CAPS_32322: DXVAHD_ITELECINE_CAPS = DXVAHD_ITELECINE_CAPS(16i32);
pub const DXVAHD_ITELECINE_CAPS_55: DXVAHD_ITELECINE_CAPS = DXVAHD_ITELECINE_CAPS(32i32);
pub const DXVAHD_ITELECINE_CAPS_64: DXVAHD_ITELECINE_CAPS = DXVAHD_ITELECINE_CAPS(64i32);
pub const DXVAHD_ITELECINE_CAPS_87: DXVAHD_ITELECINE_CAPS = DXVAHD_ITELECINE_CAPS(128i32);
pub const DXVAHD_ITELECINE_CAPS_OTHER: DXVAHD_ITELECINE_CAPS = DXVAHD_ITELECINE_CAPS(-2147483648i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DXVAHD_OUTPUT_RATE(pub i32);
pub const DXVAHD_OUTPUT_RATE_CUSTOM: DXVAHD_OUTPUT_RATE = DXVAHD_OUTPUT_RATE(2i32);
pub const DXVAHD_OUTPUT_RATE_HALF: DXVAHD_OUTPUT_RATE = DXVAHD_OUTPUT_RATE(1i32);
pub const DXVAHD_OUTPUT_RATE_NORMAL: DXVAHD_OUTPUT_RATE = DXVAHD_OUTPUT_RATE(0i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DXVAHD_PROCESSOR_CAPS(pub i32);
pub const DXVAHD_PROCESSOR_CAPS_DEINTERLACE_ADAPTIVE: DXVAHD_PROCESSOR_CAPS = DXVAHD_PROCESSOR_CAPS(4i32);
pub const DXVAHD_PROCESSOR_CAPS_DEINTERLACE_BLEND: DXVAHD_PROCESSOR_CAPS = DXVAHD_PROCESSOR_CAPS(1i32);
pub const DXVAHD_PROCESSOR_CAPS_DEINTERLACE_BOB: DXVAHD_PROCESSOR_CAPS = DXVAHD_PROCESSOR_CAPS(2i32);
pub const DXVAHD_PROCESSOR_CAPS_DEINTERLACE_MOTION_COMPENSATION: DXVAHD_PROCESSOR_CAPS = DXVAHD_PROCESSOR_CAPS(8i32);
pub const DXVAHD_PROCESSOR_CAPS_FRAME_RATE_CONVERSION: DXVAHD_PROCESSOR_CAPS = DXVAHD_PROCESSOR_CAPS(32i32);
pub const DXVAHD_PROCESSOR_CAPS_INVERSE_TELECINE: DXVAHD_PROCESSOR_CAPS = DXVAHD_PROCESSOR_CAPS(16i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DXVAHD_RATIONAL {
    pub Numerator: u32,
    pub Denominator: u32,
}
impl Default for DXVAHD_RATIONAL {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Direct3D9")]
#[derive(Clone, Debug, PartialEq)]
pub struct DXVAHD_STREAM_DATA {
    pub Enable: super::super::Foundation::BOOL,
    pub OutputIndex: u32,
    pub InputFrameOrField: u32,
    pub PastFrames: u32,
    pub FutureFrames: u32,
    pub ppPastSurfaces: *mut Option<super::super::Graphics::Direct3D9::IDirect3DSurface9>,
    pub pInputSurface: core::mem::ManuallyDrop<Option<super::super::Graphics::Direct3D9::IDirect3DSurface9>>,
    pub ppFutureSurfaces: *mut Option<super::super::Graphics::Direct3D9::IDirect3DSurface9>,
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl Default for DXVAHD_STREAM_DATA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DXVAHD_STREAM_STATE(pub i32);
pub const DXVAHD_STREAM_STATE_ALPHA: DXVAHD_STREAM_STATE = DXVAHD_STREAM_STATE(6i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DXVAHD_STREAM_STATE_ALPHA_DATA {
    pub Enable: super::super::Foundation::BOOL,
    pub Alpha: f32,
}
impl Default for DXVAHD_STREAM_STATE_ALPHA_DATA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const DXVAHD_STREAM_STATE_ASPECT_RATIO: DXVAHD_STREAM_STATE = DXVAHD_STREAM_STATE(9i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DXVAHD_STREAM_STATE_ASPECT_RATIO_DATA {
    pub Enable: super::super::Foundation::BOOL,
    pub SourceAspectRatio: DXVAHD_RATIONAL,
    pub DestinationAspectRatio: DXVAHD_RATIONAL,
}
impl Default for DXVAHD_STREAM_STATE_ASPECT_RATIO_DATA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const DXVAHD_STREAM_STATE_D3DFORMAT: DXVAHD_STREAM_STATE = DXVAHD_STREAM_STATE(0i32);
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Direct3D9")]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DXVAHD_STREAM_STATE_D3DFORMAT_DATA {
    pub Format: super::super::Graphics::Direct3D9::D3DFORMAT,
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl Default for DXVAHD_STREAM_STATE_D3DFORMAT_DATA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const DXVAHD_STREAM_STATE_DESTINATION_RECT: DXVAHD_STREAM_STATE = DXVAHD_STREAM_STATE(5i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DXVAHD_STREAM_STATE_DESTINATION_RECT_DATA {
    pub Enable: super::super::Foundation::BOOL,
    pub DestinationRect: super::super::Foundation::RECT,
}
impl Default for DXVAHD_STREAM_STATE_DESTINATION_RECT_DATA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const DXVAHD_STREAM_STATE_FILTER_ANAMORPHIC_SCALING: DXVAHD_STREAM_STATE = DXVAHD_STREAM_STATE(106i32);
pub const DXVAHD_STREAM_STATE_FILTER_BRIGHTNESS: DXVAHD_STREAM_STATE = DXVAHD_STREAM_STATE(100i32);
pub const DXVAHD_STREAM_STATE_FILTER_CONTRAST: DXVAHD_STREAM_STATE = DXVAHD_STREAM_STATE(101i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DXVAHD_STREAM_STATE_FILTER_DATA {
    pub Enable: super::super::Foundation::BOOL,
    pub Level: i32,
}
impl Default for DXVAHD_STREAM_STATE_FILTER_DATA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const DXVAHD_STREAM_STATE_FILTER_EDGE_ENHANCEMENT: DXVAHD_STREAM_STATE = DXVAHD_STREAM_STATE(105i32);
pub const DXVAHD_STREAM_STATE_FILTER_HUE: DXVAHD_STREAM_STATE = DXVAHD_STREAM_STATE(102i32);
pub const DXVAHD_STREAM_STATE_FILTER_NOISE_REDUCTION: DXVAHD_STREAM_STATE = DXVAHD_STREAM_STATE(104i32);
pub const DXVAHD_STREAM_STATE_FILTER_SATURATION: DXVAHD_STREAM_STATE = DXVAHD_STREAM_STATE(103i32);
pub const DXVAHD_STREAM_STATE_FRAME_FORMAT: DXVAHD_STREAM_STATE = DXVAHD_STREAM_STATE(1i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DXVAHD_STREAM_STATE_FRAME_FORMAT_DATA {
    pub FrameFormat: DXVAHD_FRAME_FORMAT,
}
impl Default for DXVAHD_STREAM_STATE_FRAME_FORMAT_DATA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const DXVAHD_STREAM_STATE_INPUT_COLOR_SPACE: DXVAHD_STREAM_STATE = DXVAHD_STREAM_STATE(2i32);
#[repr(C)]
#[derive(Clone, Copy)]
pub struct DXVAHD_STREAM_STATE_INPUT_COLOR_SPACE_DATA {
    pub Anonymous: DXVAHD_STREAM_STATE_INPUT_COLOR_SPACE_DATA_0,
}
impl Default for DXVAHD_STREAM_STATE_INPUT_COLOR_SPACE_DATA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union DXVAHD_STREAM_STATE_INPUT_COLOR_SPACE_DATA_0 {
    pub Anonymous: DXVAHD_STREAM_STATE_INPUT_COLOR_SPACE_DATA_0_0,
    pub Value: u32,
}
impl Default for DXVAHD_STREAM_STATE_INPUT_COLOR_SPACE_DATA_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DXVAHD_STREAM_STATE_INPUT_COLOR_SPACE_DATA_0_0 {
    pub _bitfield: u32,
}
impl Default for DXVAHD_STREAM_STATE_INPUT_COLOR_SPACE_DATA_0_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const DXVAHD_STREAM_STATE_LUMA_KEY: DXVAHD_STREAM_STATE = DXVAHD_STREAM_STATE(8i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DXVAHD_STREAM_STATE_LUMA_KEY_DATA {
    pub Enable: super::super::Foundation::BOOL,
    pub Lower: f32,
    pub Upper: f32,
}
impl Default for DXVAHD_STREAM_STATE_LUMA_KEY_DATA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const DXVAHD_STREAM_STATE_OUTPUT_RATE: DXVAHD_STREAM_STATE = DXVAHD_STREAM_STATE(3i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DXVAHD_STREAM_STATE_OUTPUT_RATE_DATA {
    pub RepeatFrame: super::super::Foundation::BOOL,
    pub OutputRate: DXVAHD_OUTPUT_RATE,
    pub CustomRate: DXVAHD_RATIONAL,
}
impl Default for DXVAHD_STREAM_STATE_OUTPUT_RATE_DATA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const DXVAHD_STREAM_STATE_PALETTE: DXVAHD_STREAM_STATE = DXVAHD_STREAM_STATE(7i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DXVAHD_STREAM_STATE_PALETTE_DATA {
    pub Count: u32,
    pub pEntries: *mut u32,
}
impl Default for DXVAHD_STREAM_STATE_PALETTE_DATA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const DXVAHD_STREAM_STATE_PRIVATE: DXVAHD_STREAM_STATE = DXVAHD_STREAM_STATE(1000i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DXVAHD_STREAM_STATE_PRIVATE_DATA {
    pub Guid: windows_core::GUID,
    pub DataSize: u32,
    pub pData: *mut core::ffi::c_void,
}
impl Default for DXVAHD_STREAM_STATE_PRIVATE_DATA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const DXVAHD_STREAM_STATE_PRIVATE_IVTC: windows_core::GUID = windows_core::GUID::from_u128(0x9c601e3c_0f33_414c_a739_99540ee42da5);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DXVAHD_STREAM_STATE_PRIVATE_IVTC_DATA {
    pub Enable: super::super::Foundation::BOOL,
    pub ITelecineFlags: u32,
    pub Frames: u32,
    pub InputField: u32,
}
impl Default for DXVAHD_STREAM_STATE_PRIVATE_IVTC_DATA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const DXVAHD_STREAM_STATE_SOURCE_RECT: DXVAHD_STREAM_STATE = DXVAHD_STREAM_STATE(4i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DXVAHD_STREAM_STATE_SOURCE_RECT_DATA {
    pub Enable: super::super::Foundation::BOOL,
    pub SourceRect: super::super::Foundation::RECT,
}
impl Default for DXVAHD_STREAM_STATE_SOURCE_RECT_DATA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DXVAHD_SURFACE_TYPE(pub i32);
pub const DXVAHD_SURFACE_TYPE_VIDEO_INPUT: DXVAHD_SURFACE_TYPE = DXVAHD_SURFACE_TYPE(0i32);
pub const DXVAHD_SURFACE_TYPE_VIDEO_INPUT_PRIVATE: DXVAHD_SURFACE_TYPE = DXVAHD_SURFACE_TYPE(1i32);
pub const DXVAHD_SURFACE_TYPE_VIDEO_OUTPUT: DXVAHD_SURFACE_TYPE = DXVAHD_SURFACE_TYPE(2i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DXVAHD_VPCAPS {
    pub VPGuid: windows_core::GUID,
    pub PastFrames: u32,
    pub FutureFrames: u32,
    pub ProcessorCaps: u32,
    pub ITelecineCaps: u32,
    pub CustomRateCount: u32,
}
impl Default for DXVAHD_VPCAPS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Direct3D9")]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DXVAHD_VPDEVCAPS {
    pub DeviceType: DXVAHD_DEVICE_TYPE,
    pub DeviceCaps: u32,
    pub FeatureCaps: u32,
    pub FilterCaps: u32,
    pub InputFormatCaps: u32,
    pub InputPool: super::super::Graphics::Direct3D9::D3DPOOL,
    pub OutputFormatCount: u32,
    pub InputFormatCount: u32,
    pub VideoProcessorCount: u32,
    pub MaxInputStreams: u32,
    pub MaxStreamStates: u32,
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl Default for DXVAHD_VPDEVCAPS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Direct3D9")]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DXVAUncompDataInfo {
    pub UncompWidth: u32,
    pub UncompHeight: u32,
    pub UncompFormat: super::super::Graphics::Direct3D9::D3DFORMAT,
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl Default for DXVAUncompDataInfo {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DXVA_AYUVsample2 {
    pub bCrValue: u8,
    pub bCbValue: u8,
    pub bY_Value: u8,
    pub bSampleAlpha8: u8,
}
impl Default for DXVA_AYUVsample2 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C, packed(1))]
#[derive(Clone, Copy)]
pub struct DXVA_BufferDescription {
    pub dwTypeIndex: u32,
    pub dwBufferIndex: u32,
    pub dwDataOffset: u32,
    pub dwDataSize: u32,
    pub dwFirstMBaddress: u32,
    pub dwNumMBsInBuffer: u32,
    pub dwWidth: u32,
    pub dwHeight: u32,
    pub dwStride: u32,
    pub dwReservedBits: u32,
}
impl Default for DXVA_BufferDescription {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DXVA_COPPCommand {
    pub macKDI: windows_core::GUID,
    pub guidCommandID: windows_core::GUID,
    pub dwSequence: u32,
    pub cbSizeData: u32,
    pub CommandData: [u8; 4056],
}
impl Default for DXVA_COPPCommand {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DXVA_COPPSignature {
    pub Signature: [u8; 256],
}
impl Default for DXVA_COPPSignature {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DXVA_COPPStatusInput {
    pub rApp: windows_core::GUID,
    pub guidStatusRequestID: windows_core::GUID,
    pub dwSequence: u32,
    pub cbSizeData: u32,
    pub StatusData: [u8; 4056],
}
impl Default for DXVA_COPPStatusInput {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DXVA_COPPStatusOutput {
    pub macKDI: windows_core::GUID,
    pub cbSizeData: u32,
    pub COPPStatus: [u8; 4076],
}
impl Default for DXVA_COPPStatusOutput {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C, packed(1))]
#[derive(Clone, Copy)]
pub struct DXVA_ConfigPictureDecode {
    pub dwFunction: u32,
    pub dwReservedBits: [u32; 3],
    pub guidConfigBitstreamEncryption: windows_core::GUID,
    pub guidConfigMBcontrolEncryption: windows_core::GUID,
    pub guidConfigResidDiffEncryption: windows_core::GUID,
    pub bConfigBitstreamRaw: u8,
    pub bConfigMBcontrolRasterOrder: u8,
    pub bConfigResidDiffHost: u8,
    pub bConfigSpatialResid8: u8,
    pub bConfigResid8Subtraction: u8,
    pub bConfigSpatialHost8or9Clipping: u8,
    pub bConfigSpatialResidInterleaved: u8,
    pub bConfigIntraResidUnsigned: u8,
    pub bConfigResidDiffAccelerator: u8,
    pub bConfigHostInverseScan: u8,
    pub bConfigSpecificIDCT: u8,
    pub bConfig4GroupedCoefs: u8,
}
impl Default for DXVA_ConfigPictureDecode {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DXVA_DeinterlaceBlt {
    pub Size: u32,
    pub Reserved: u32,
    pub rtTarget: i64,
    pub DstRect: super::super::Foundation::RECT,
    pub SrcRect: super::super::Foundation::RECT,
    pub NumSourceSurfaces: u32,
    pub Alpha: f32,
    pub Source: [DXVA_VideoSample; 32],
}
impl Default for DXVA_DeinterlaceBlt {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DXVA_DeinterlaceBltEx {
    pub Size: u32,
    pub BackgroundColor: DXVA_AYUVsample2,
    pub rcTarget: super::super::Foundation::RECT,
    pub rtTarget: i64,
    pub NumSourceSurfaces: u32,
    pub Alpha: f32,
    pub Source: [DXVA_VideoSample2; 32],
    pub DestinationFormat: u32,
    pub DestinationFlags: u32,
}
impl Default for DXVA_DeinterlaceBltEx {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(any(target_arch = "aarch64", target_arch = "arm64ec", target_arch = "x86_64"))]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DXVA_DeinterlaceBltEx32 {
    pub Size: u32,
    pub BackgroundColor: DXVA_AYUVsample2,
    pub rcTarget: super::super::Foundation::RECT,
    pub rtTarget: i64,
    pub NumSourceSurfaces: u32,
    pub Alpha: f32,
    pub Source: [DXVA_VideoSample32; 32],
    pub DestinationFormat: u32,
    pub DestinationFlags: u32,
}
#[cfg(any(target_arch = "aarch64", target_arch = "arm64ec", target_arch = "x86_64"))]
impl Default for DXVA_DeinterlaceBltEx32 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Direct3D9")]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DXVA_DeinterlaceCaps {
    pub Size: u32,
    pub NumPreviousOutputFrames: u32,
    pub InputPool: u32,
    pub NumForwardRefSamples: u32,
    pub NumBackwardRefSamples: u32,
    pub d3dOutputFormat: super::super::Graphics::Direct3D9::D3DFORMAT,
    pub VideoProcessingCaps: DXVA_VideoProcessCaps,
    pub DeinterlaceTechnology: DXVA_DeinterlaceTech,
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl Default for DXVA_DeinterlaceCaps {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DXVA_DeinterlaceQueryAvailableModes {
    pub Size: u32,
    pub NumGuids: u32,
    pub Guids: [windows_core::GUID; 32],
}
impl Default for DXVA_DeinterlaceQueryAvailableModes {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Direct3D9")]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DXVA_DeinterlaceQueryModeCaps {
    pub Size: u32,
    pub Guid: windows_core::GUID,
    pub VideoDesc: DXVA_VideoDesc,
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl Default for DXVA_DeinterlaceQueryModeCaps {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DXVA_DeinterlaceTech(pub i32);
pub const DXVA_DeinterlaceTech_BOBLineReplicate: DXVA_DeinterlaceTech = DXVA_DeinterlaceTech(1i32);
pub const DXVA_DeinterlaceTech_BOBVerticalStretch: DXVA_DeinterlaceTech = DXVA_DeinterlaceTech(2i32);
pub const DXVA_DeinterlaceTech_BOBVerticalStretch4Tap: DXVA_DeinterlaceTech = DXVA_DeinterlaceTech(256i32);
pub const DXVA_DeinterlaceTech_EdgeFiltering: DXVA_DeinterlaceTech = DXVA_DeinterlaceTech(16i32);
pub const DXVA_DeinterlaceTech_FieldAdaptive: DXVA_DeinterlaceTech = DXVA_DeinterlaceTech(32i32);
pub const DXVA_DeinterlaceTech_MedianFiltering: DXVA_DeinterlaceTech = DXVA_DeinterlaceTech(4i32);
pub const DXVA_DeinterlaceTech_MotionVectorSteered: DXVA_DeinterlaceTech = DXVA_DeinterlaceTech(128i32);
pub const DXVA_DeinterlaceTech_PixelAdaptive: DXVA_DeinterlaceTech = DXVA_DeinterlaceTech(64i32);
pub const DXVA_DeinterlaceTech_Unknown: DXVA_DeinterlaceTech = DXVA_DeinterlaceTech(0i32);
pub const DXVA_DestinationFlagMask: DXVA_DestinationFlags = DXVA_DestinationFlags(15i32);
pub const DXVA_DestinationFlag_Alpha_Changed: DXVA_DestinationFlags = DXVA_DestinationFlags(8i32);
pub const DXVA_DestinationFlag_Background_Changed: DXVA_DestinationFlags = DXVA_DestinationFlags(1i32);
pub const DXVA_DestinationFlag_ColorData_Changed: DXVA_DestinationFlags = DXVA_DestinationFlags(4i32);
pub const DXVA_DestinationFlag_TargetRect_Changed: DXVA_DestinationFlags = DXVA_DestinationFlags(2i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DXVA_DestinationFlags(pub i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DXVA_ExtendedFormat {
    pub _bitfield: u32,
}
impl Default for DXVA_ExtendedFormat {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DXVA_Frequency {
    pub Numerator: u32,
    pub Denominator: u32,
}
impl Default for DXVA_Frequency {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DXVA_NominalRange(pub i32);
pub const DXVA_NominalRangeMask: DXVA_NominalRange = DXVA_NominalRange(28672i32);
pub const DXVA_NominalRangeShift: DXVA_NominalRange = DXVA_NominalRange(12i32);
pub const DXVA_NominalRange_0_255: DXVA_NominalRange = DXVA_NominalRange(1i32);
pub const DXVA_NominalRange_16_235: DXVA_NominalRange = DXVA_NominalRange(2i32);
pub const DXVA_NominalRange_48_208: DXVA_NominalRange = DXVA_NominalRange(3i32);
pub const DXVA_NominalRange_Normal: DXVA_NominalRange = DXVA_NominalRange(1i32);
pub const DXVA_NominalRange_Unknown: DXVA_NominalRange = DXVA_NominalRange(0i32);
pub const DXVA_NominalRange_Wide: DXVA_NominalRange = DXVA_NominalRange(2i32);
#[repr(C, packed(1))]
#[derive(Clone, Copy)]
pub struct DXVA_PictureParameters {
    pub wDecodedPictureIndex: u16,
    pub wDeblockedPictureIndex: u16,
    pub wForwardRefPictureIndex: u16,
    pub wBackwardRefPictureIndex: u16,
    pub wPicWidthInMBminus1: u16,
    pub wPicHeightInMBminus1: u16,
    pub bMacroblockWidthMinus1: u8,
    pub bMacroblockHeightMinus1: u8,
    pub bBlockWidthMinus1: u8,
    pub bBlockHeightMinus1: u8,
    pub bBPPminus1: u8,
    pub bPicStructure: u8,
    pub bSecondField: u8,
    pub bPicIntra: u8,
    pub bPicBackwardPrediction: u8,
    pub bBidirectionalAveragingMode: u8,
    pub bMVprecisionAndChromaRelation: u8,
    pub bChromaFormat: u8,
    pub bPicScanFixed: u8,
    pub bPicScanMethod: u8,
    pub bPicReadbackRequests: u8,
    pub bRcontrol: u8,
    pub bPicSpatialResid8: u8,
    pub bPicOverflowBlocks: u8,
    pub bPicExtrapolation: u8,
    pub bPicDeblocked: u8,
    pub bPicDeblockConfined: u8,
    pub bPic4MVallowed: u8,
    pub bPicOBMC: u8,
    pub bPicBinPB: u8,
    pub bMV_RPS: u8,
    pub bReservedBits: u8,
    pub wBitstreamFcodes: u16,
    pub wBitstreamPCEelements: u16,
    pub bBitstreamConcealmentNeed: u8,
    pub bBitstreamConcealmentMethod: u8,
}
impl Default for DXVA_PictureParameters {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DXVA_ProcAmpControlBlt {
    pub Size: u32,
    pub DstRect: super::super::Foundation::RECT,
    pub SrcRect: super::super::Foundation::RECT,
    pub Alpha: f32,
    pub Brightness: f32,
    pub Contrast: f32,
    pub Hue: f32,
    pub Saturation: f32,
}
impl Default for DXVA_ProcAmpControlBlt {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Direct3D9")]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DXVA_ProcAmpControlCaps {
    pub Size: u32,
    pub InputPool: u32,
    pub d3dOutputFormat: super::super::Graphics::Direct3D9::D3DFORMAT,
    pub ProcAmpControlProps: u32,
    pub VideoProcessingCaps: u32,
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl Default for DXVA_ProcAmpControlCaps {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DXVA_ProcAmpControlProp(pub i32);
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Direct3D9")]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DXVA_ProcAmpControlQueryRange {
    pub Size: u32,
    pub ProcAmpControlProp: DXVA_ProcAmpControlProp,
    pub VideoDesc: DXVA_VideoDesc,
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl Default for DXVA_ProcAmpControlQueryRange {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const DXVA_ProcAmp_Brightness: DXVA_ProcAmpControlProp = DXVA_ProcAmpControlProp(1i32);
pub const DXVA_ProcAmp_Contrast: DXVA_ProcAmpControlProp = DXVA_ProcAmpControlProp(2i32);
pub const DXVA_ProcAmp_Hue: DXVA_ProcAmpControlProp = DXVA_ProcAmpControlProp(4i32);
pub const DXVA_ProcAmp_None: DXVA_ProcAmpControlProp = DXVA_ProcAmpControlProp(0i32);
pub const DXVA_ProcAmp_Saturation: DXVA_ProcAmpControlProp = DXVA_ProcAmpControlProp(8i32);
pub const DXVA_SampleFieldInterleavedEvenFirst: DXVA_SampleFormat = DXVA_SampleFormat(3i32);
pub const DXVA_SampleFieldInterleavedOddFirst: DXVA_SampleFormat = DXVA_SampleFormat(4i32);
pub const DXVA_SampleFieldSingleEven: DXVA_SampleFormat = DXVA_SampleFormat(5i32);
pub const DXVA_SampleFieldSingleOdd: DXVA_SampleFormat = DXVA_SampleFormat(6i32);
pub const DXVA_SampleFlag_ColorData_Changed: DXVA_SampleFlags = DXVA_SampleFlags(8i32);
pub const DXVA_SampleFlag_DstRect_Changed: DXVA_SampleFlags = DXVA_SampleFlags(4i32);
pub const DXVA_SampleFlag_Palette_Changed: DXVA_SampleFlags = DXVA_SampleFlags(1i32);
pub const DXVA_SampleFlag_SrcRect_Changed: DXVA_SampleFlags = DXVA_SampleFlags(2i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DXVA_SampleFlags(pub i32);
pub const DXVA_SampleFlagsMask: DXVA_SampleFlags = DXVA_SampleFlags(15i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DXVA_SampleFormat(pub i32);
pub const DXVA_SampleFormatMask: DXVA_SampleFormat = DXVA_SampleFormat(255i32);
pub const DXVA_SamplePreviousFrame: DXVA_SampleFormat = DXVA_SampleFormat(1i32);
pub const DXVA_SampleProgressiveFrame: DXVA_SampleFormat = DXVA_SampleFormat(2i32);
pub const DXVA_SampleSubStream: DXVA_SampleFormat = DXVA_SampleFormat(7i32);
pub const DXVA_SampleUnknown: DXVA_SampleFormat = DXVA_SampleFormat(0i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DXVA_VideoChromaSubsampling(pub i32);
pub const DXVA_VideoChromaSubsamplingMask: DXVA_VideoChromaSubsampling = DXVA_VideoChromaSubsampling(3840i32);
pub const DXVA_VideoChromaSubsamplingShift: DXVA_VideoChromaSubsampling = DXVA_VideoChromaSubsampling(8i32);
pub const DXVA_VideoChromaSubsampling_Cosited: DXVA_VideoChromaSubsampling = DXVA_VideoChromaSubsampling(7i32);
pub const DXVA_VideoChromaSubsampling_DV_PAL: DXVA_VideoChromaSubsampling = DXVA_VideoChromaSubsampling(6i32);
pub const DXVA_VideoChromaSubsampling_Horizontally_Cosited: DXVA_VideoChromaSubsampling = DXVA_VideoChromaSubsampling(4i32);
pub const DXVA_VideoChromaSubsampling_MPEG1: DXVA_VideoChromaSubsampling = DXVA_VideoChromaSubsampling(1i32);
pub const DXVA_VideoChromaSubsampling_MPEG2: DXVA_VideoChromaSubsampling = DXVA_VideoChromaSubsampling(5i32);
pub const DXVA_VideoChromaSubsampling_ProgressiveChroma: DXVA_VideoChromaSubsampling = DXVA_VideoChromaSubsampling(8i32);
pub const DXVA_VideoChromaSubsampling_Unknown: DXVA_VideoChromaSubsampling = DXVA_VideoChromaSubsampling(0i32);
pub const DXVA_VideoChromaSubsampling_Vertically_AlignedChromaPlanes: DXVA_VideoChromaSubsampling = DXVA_VideoChromaSubsampling(1i32);
pub const DXVA_VideoChromaSubsampling_Vertically_Cosited: DXVA_VideoChromaSubsampling = DXVA_VideoChromaSubsampling(2i32);
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Direct3D9")]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DXVA_VideoDesc {
    pub Size: u32,
    pub SampleWidth: u32,
    pub SampleHeight: u32,
    pub SampleFormat: u32,
    pub d3dFormat: super::super::Graphics::Direct3D9::D3DFORMAT,
    pub InputSampleFreq: DXVA_Frequency,
    pub OutputFrameFreq: DXVA_Frequency,
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl Default for DXVA_VideoDesc {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DXVA_VideoLighting(pub i32);
pub const DXVA_VideoLightingMask: DXVA_VideoLighting = DXVA_VideoLighting(3932160i32);
pub const DXVA_VideoLightingShift: DXVA_VideoLighting = DXVA_VideoLighting(18i32);
pub const DXVA_VideoLighting_Unknown: DXVA_VideoLighting = DXVA_VideoLighting(0i32);
pub const DXVA_VideoLighting_bright: DXVA_VideoLighting = DXVA_VideoLighting(1i32);
pub const DXVA_VideoLighting_dark: DXVA_VideoLighting = DXVA_VideoLighting(4i32);
pub const DXVA_VideoLighting_dim: DXVA_VideoLighting = DXVA_VideoLighting(3i32);
pub const DXVA_VideoLighting_office: DXVA_VideoLighting = DXVA_VideoLighting(2i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DXVA_VideoPrimaries(pub i32);
pub const DXVA_VideoPrimariesMask: DXVA_VideoPrimaries = DXVA_VideoPrimaries(130023424i32);
pub const DXVA_VideoPrimariesShift: DXVA_VideoPrimaries = DXVA_VideoPrimaries(22i32);
pub const DXVA_VideoPrimaries_BT470_2_SysBG: DXVA_VideoPrimaries = DXVA_VideoPrimaries(4i32);
pub const DXVA_VideoPrimaries_BT470_2_SysM: DXVA_VideoPrimaries = DXVA_VideoPrimaries(3i32);
pub const DXVA_VideoPrimaries_BT709: DXVA_VideoPrimaries = DXVA_VideoPrimaries(2i32);
pub const DXVA_VideoPrimaries_EBU3213: DXVA_VideoPrimaries = DXVA_VideoPrimaries(7i32);
pub const DXVA_VideoPrimaries_SMPTE170M: DXVA_VideoPrimaries = DXVA_VideoPrimaries(5i32);
pub const DXVA_VideoPrimaries_SMPTE240M: DXVA_VideoPrimaries = DXVA_VideoPrimaries(6i32);
pub const DXVA_VideoPrimaries_SMPTE_C: DXVA_VideoPrimaries = DXVA_VideoPrimaries(8i32);
pub const DXVA_VideoPrimaries_Unknown: DXVA_VideoPrimaries = DXVA_VideoPrimaries(0i32);
pub const DXVA_VideoPrimaries_reserved: DXVA_VideoPrimaries = DXVA_VideoPrimaries(1i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DXVA_VideoProcessCaps(pub i32);
pub const DXVA_VideoProcess_AlphaBlend: DXVA_VideoProcessCaps = DXVA_VideoProcessCaps(8i32);
pub const DXVA_VideoProcess_AlphaBlendExtended: DXVA_VideoProcessCaps = DXVA_VideoProcessCaps(256i32);
pub const DXVA_VideoProcess_None: DXVA_VideoProcessCaps = DXVA_VideoProcessCaps(0i32);
pub const DXVA_VideoProcess_StretchX: DXVA_VideoProcessCaps = DXVA_VideoProcessCaps(2i32);
pub const DXVA_VideoProcess_StretchY: DXVA_VideoProcessCaps = DXVA_VideoProcessCaps(4i32);
pub const DXVA_VideoProcess_SubRects: DXVA_VideoProcessCaps = DXVA_VideoProcessCaps(16i32);
pub const DXVA_VideoProcess_SubStreams: DXVA_VideoProcessCaps = DXVA_VideoProcessCaps(32i32);
pub const DXVA_VideoProcess_SubStreamsExtended: DXVA_VideoProcessCaps = DXVA_VideoProcessCaps(64i32);
pub const DXVA_VideoProcess_YUV2RGB: DXVA_VideoProcessCaps = DXVA_VideoProcessCaps(1i32);
pub const DXVA_VideoProcess_YUV2RGBExtended: DXVA_VideoProcessCaps = DXVA_VideoProcessCaps(128i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DXVA_VideoPropertyRange {
    pub MinValue: f32,
    pub MaxValue: f32,
    pub DefaultValue: f32,
    pub StepSize: f32,
}
impl Default for DXVA_VideoPropertyRange {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DXVA_VideoSample {
    pub rtStart: i64,
    pub rtEnd: i64,
    pub SampleFormat: DXVA_SampleFormat,
    pub lpDDSSrcSurface: *mut core::ffi::c_void,
}
impl Default for DXVA_VideoSample {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(target_arch = "x86")]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DXVA_VideoSample2 {
    pub rtStart: i64,
    pub rtEnd: i64,
    pub SampleFormat: u32,
    pub SampleFlags: u32,
    pub lpDDSSrcSurface: *mut core::ffi::c_void,
    pub rcSrc: super::super::Foundation::RECT,
    pub rcDst: super::super::Foundation::RECT,
    pub Palette: [DXVA_AYUVsample2; 16],
}
#[cfg(target_arch = "x86")]
impl Default for DXVA_VideoSample2 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(any(target_arch = "aarch64", target_arch = "arm64ec", target_arch = "x86_64"))]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DXVA_VideoSample2 {
    pub Size: u32,
    pub Reserved: u32,
    pub rtStart: i64,
    pub rtEnd: i64,
    pub SampleFormat: u32,
    pub SampleFlags: u32,
    pub lpDDSSrcSurface: *mut core::ffi::c_void,
    pub rcSrc: super::super::Foundation::RECT,
    pub rcDst: super::super::Foundation::RECT,
    pub Palette: [DXVA_AYUVsample2; 16],
}
#[cfg(any(target_arch = "aarch64", target_arch = "arm64ec", target_arch = "x86_64"))]
impl Default for DXVA_VideoSample2 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(any(target_arch = "aarch64", target_arch = "arm64ec", target_arch = "x86_64"))]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DXVA_VideoSample32 {
    pub rtStart: i64,
    pub rtEnd: i64,
    pub SampleFormat: u32,
    pub SampleFlags: u32,
    pub lpDDSSrcSurface: u32,
    pub rcSrc: super::super::Foundation::RECT,
    pub rcDst: super::super::Foundation::RECT,
    pub Palette: [DXVA_AYUVsample2; 16],
}
#[cfg(any(target_arch = "aarch64", target_arch = "arm64ec", target_arch = "x86_64"))]
impl Default for DXVA_VideoSample32 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const DXVA_VideoTransFuncMask: DXVA_VideoTransferFunction = DXVA_VideoTransferFunction(-134217728i32);
pub const DXVA_VideoTransFuncShift: DXVA_VideoTransferFunction = DXVA_VideoTransferFunction(27i32);
pub const DXVA_VideoTransFunc_10: DXVA_VideoTransferFunction = DXVA_VideoTransferFunction(1i32);
pub const DXVA_VideoTransFunc_18: DXVA_VideoTransferFunction = DXVA_VideoTransferFunction(2i32);
pub const DXVA_VideoTransFunc_20: DXVA_VideoTransferFunction = DXVA_VideoTransferFunction(3i32);
pub const DXVA_VideoTransFunc_22: DXVA_VideoTransferFunction = DXVA_VideoTransferFunction(4i32);
pub const DXVA_VideoTransFunc_22_240M: DXVA_VideoTransferFunction = DXVA_VideoTransferFunction(6i32);
pub const DXVA_VideoTransFunc_22_709: DXVA_VideoTransferFunction = DXVA_VideoTransferFunction(5i32);
pub const DXVA_VideoTransFunc_22_8bit_sRGB: DXVA_VideoTransferFunction = DXVA_VideoTransferFunction(7i32);
pub const DXVA_VideoTransFunc_28: DXVA_VideoTransferFunction = DXVA_VideoTransferFunction(8i32);
pub const DXVA_VideoTransFunc_Unknown: DXVA_VideoTransferFunction = DXVA_VideoTransferFunction(0i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DXVA_VideoTransferFunction(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DXVA_VideoTransferMatrix(pub i32);
pub const DXVA_VideoTransferMatrixMask: DXVA_VideoTransferMatrix = DXVA_VideoTransferMatrix(229376i32);
pub const DXVA_VideoTransferMatrixShift: DXVA_VideoTransferMatrix = DXVA_VideoTransferMatrix(15i32);
pub const DXVA_VideoTransferMatrix_BT601: DXVA_VideoTransferMatrix = DXVA_VideoTransferMatrix(2i32);
pub const DXVA_VideoTransferMatrix_BT709: DXVA_VideoTransferMatrix = DXVA_VideoTransferMatrix(1i32);
pub const DXVA_VideoTransferMatrix_SMPTE240M: DXVA_VideoTransferMatrix = DXVA_VideoTransferMatrix(3i32);
pub const DXVA_VideoTransferMatrix_Unknown: DXVA_VideoTransferMatrix = DXVA_VideoTransferMatrix(0i32);
pub const DXVAp_DeinterlaceBobDevice: windows_core::GUID = windows_core::GUID::from_u128(0x335aa36e_7884_43a4_9c91_7f87faf3e37e);
pub const DXVAp_DeinterlaceContainerDevice: windows_core::GUID = windows_core::GUID::from_u128(0x0e85cb93_3046_4ff0_aecc_d58cb5f035fd);
pub const DXVAp_ModeMPEG2_A: windows_core::GUID = windows_core::GUID::from_u128(0x1b81be0a_a0c7_11d3_b984_00c04f2e73c5);
pub const DXVAp_ModeMPEG2_C: windows_core::GUID = windows_core::GUID::from_u128(0x1b81be0c_a0c7_11d3_b984_00c04f2e73c5);
pub const DXVAp_NoEncrypt: windows_core::GUID = windows_core::GUID::from_u128(0x1b81bed0_a0c7_11d3_b984_00c04f2e73c5);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DeviceStreamState(pub i32);
pub const DeviceStreamState_Disabled: DeviceStreamState = DeviceStreamState(3i32);
pub const DeviceStreamState_Pause: DeviceStreamState = DeviceStreamState(1i32);
pub const DeviceStreamState_Run: DeviceStreamState = DeviceStreamState(2i32);
pub const DeviceStreamState_Stop: DeviceStreamState = DeviceStreamState(0i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DigitalWindowSetting {
    pub OriginX: f64,
    pub OriginY: f64,
    pub WindowSize: f64,
}
impl Default for DigitalWindowSetting {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const DistanceToFocalPlane: MFDepthMeasurement = MFDepthMeasurement(0i32);
pub const DistanceToOpticalCenter: MFDepthMeasurement = MFDepthMeasurement(1i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct EAllocationType(pub i32);
pub const ENCAPIPARAM_BITRATE: windows_core::GUID = windows_core::GUID::from_u128(0x49cc4c43_ca83_4ad4_a9af_f3696af666df);
pub const ENCAPIPARAM_BITRATE_MODE: windows_core::GUID = windows_core::GUID::from_u128(0xee5fb25c_c713_40d1_9d58_c0d7241e250f);
pub const ENCAPIPARAM_PEAK_BITRATE: windows_core::GUID = windows_core::GUID::from_u128(0x703f16a9_3d48_44a1_b077_018dff915d19);
pub const ENCAPIPARAM_SAP_MODE: windows_core::GUID = windows_core::GUID::from_u128(0x0c0171db_fefc_4af7_9991_a5657c191cd1);
pub const EVRConfig_ForceBatching: windows_core::GUID = windows_core::GUID::from_u128(0xe447df09_10ca_4d17_b17e_6a840f8a3a4c);
pub const EVRConfig_ForceBob: windows_core::GUID = windows_core::GUID::from_u128(0xe447df01_10ca_4d17_b17e_6a840f8a3a4c);
pub const EVRConfig_ForceHalfInterlace: windows_core::GUID = windows_core::GUID::from_u128(0xe447df05_10ca_4d17_b17e_6a840f8a3a4c);
pub const EVRConfig_ForceScaling: windows_core::GUID = windows_core::GUID::from_u128(0xe447df07_10ca_4d17_b17e_6a840f8a3a4c);
pub const EVRConfig_ForceThrottle: windows_core::GUID = windows_core::GUID::from_u128(0xe447df03_10ca_4d17_b17e_6a840f8a3a4c);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct EVRFilterConfigPrefs(pub i32);
pub const EVRFilterConfigPrefs_EnableQoS: EVRFilterConfigPrefs = EVRFilterConfigPrefs(1i32);
pub const EVRFilterConfigPrefs_Mask: EVRFilterConfigPrefs = EVRFilterConfigPrefs(1i32);
pub const E_TOCPARSER_INVALIDASFFILE: windows_core::HRESULT = windows_core::HRESULT(0x99000001_u32 as _);
pub const E_TOCPARSER_INVALIDRIFFFILE: windows_core::HRESULT = windows_core::HRESULT(0x99000002_u32 as _);
pub const FACILITY_MF: u32 = 13u32;
pub const FACILITY_MF_WIN32: u32 = 7u32;
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct FILE_ACCESSMODE(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct FILE_OPENMODE(pub i32);
pub const FORMAT_525WSS: windows_core::GUID = windows_core::GUID::from_u128(0xc7ecf04d_4582_4869_9abb_bfb523b62edf);
pub const FORMAT_AnalogVideo: windows_core::GUID = windows_core::GUID::from_u128(0x0482dde0_7817_11cf_8a03_00aa006ecb65);
pub const FORMAT_CAPTIONED_H264VIDEO: windows_core::GUID = windows_core::GUID::from_u128(0xa4efc024_873e_4da3_898b_474ddbd79fd0);
pub const FORMAT_CAPTIONED_MPEG2VIDEO: windows_core::GUID = windows_core::GUID::from_u128(0x7ab2ada2_81b6_4f14_b3c8_d0c486393b67);
pub const FORMAT_CC_CONTAINER: windows_core::GUID = windows_core::GUID::from_u128(0x50997a4a_e508_4054_a2b2_10ff0ac1a69a);
pub const FORMAT_DvInfo: windows_core::GUID = windows_core::GUID::from_u128(0x05589f84_c356_11ce_bf01_00aa0055595a);
pub const FORMAT_MFVideoFormat: windows_core::GUID = windows_core::GUID::from_u128(0xaed4ab2d_7326_43cb_9464_c879cab9c43d);
pub const FORMAT_MPEGStreams: windows_core::GUID = windows_core::GUID::from_u128(0x05589f83_c356_11ce_bf01_00aa0055595a);
pub const FORMAT_MPEGVideo: windows_core::GUID = windows_core::GUID::from_u128(0x05589f82_c356_11ce_bf01_00aa0055595a);
pub const FORMAT_None: windows_core::GUID = windows_core::GUID::from_u128(0x0f6417d6_c318_11d0_a43f_00a0c9223196);
pub const FORMAT_VideoInfo: windows_core::GUID = windows_core::GUID::from_u128(0x05589f80_c356_11ce_bf01_00aa0055595a);
pub const FORMAT_VideoInfo2: windows_core::GUID = windows_core::GUID::from_u128(0xf72a76a0_eb0a_11d0_ace4_0000c0cc16ba);
pub const FORMAT_WaveFormatEx: windows_core::GUID = windows_core::GUID::from_u128(0x05589f81_c356_11ce_bf01_00aa0055595a);
pub const GUID_NativeDeviceService: windows_core::GUID = windows_core::GUID::from_u128(0xef71e53c_52f4_43c5_b86a_ad6cb216a61e);
pub const GUID_PlayToService: windows_core::GUID = windows_core::GUID::from_u128(0xf6a8ff9d_9e14_41c9_bf0f_120a2b3ce120);
windows_core::imp::define_interface!(IAdvancedMediaCapture, IAdvancedMediaCapture_Vtbl, 0xd0751585_d216_4344_b5bf_463b68f977bb);
windows_core::imp::interface_hierarchy!(IAdvancedMediaCapture, windows_core::IUnknown);
impl IAdvancedMediaCapture {
    pub unsafe fn GetAdvancedMediaCaptureSettings(&self) -> windows_core::Result<IAdvancedMediaCaptureSettings> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetAdvancedMediaCaptureSettings)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
}
#[repr(C)]
pub struct IAdvancedMediaCapture_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetAdvancedMediaCaptureSettings: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
pub trait IAdvancedMediaCapture_Impl: windows_core::IUnknownImpl {
    fn GetAdvancedMediaCaptureSettings(&self) -> windows_core::Result<IAdvancedMediaCaptureSettings>;
}
impl IAdvancedMediaCapture_Vtbl {
    pub const fn new<Identity: IAdvancedMediaCapture_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetAdvancedMediaCaptureSettings<Identity: IAdvancedMediaCapture_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, value: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAdvancedMediaCapture_Impl::GetAdvancedMediaCaptureSettings(this) {
                    Ok(ok__) => {
                        value.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetAdvancedMediaCaptureSettings: GetAdvancedMediaCaptureSettings::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAdvancedMediaCapture as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IAdvancedMediaCapture {}
windows_core::imp::define_interface!(IAdvancedMediaCaptureInitializationSettings, IAdvancedMediaCaptureInitializationSettings_Vtbl, 0x3de21209_8ba6_4f2a_a577_2819b56ff14d);
windows_core::imp::interface_hierarchy!(IAdvancedMediaCaptureInitializationSettings, windows_core::IUnknown);
impl IAdvancedMediaCaptureInitializationSettings {
    pub unsafe fn SetDirectxDeviceManager<P0>(&self, value: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IMFDXGIDeviceManager>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetDirectxDeviceManager)(windows_core::Interface::as_raw(self), value.param().abi()).ok() }
    }
}
#[repr(C)]
pub struct IAdvancedMediaCaptureInitializationSettings_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub SetDirectxDeviceManager: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
}
pub trait IAdvancedMediaCaptureInitializationSettings_Impl: windows_core::IUnknownImpl {
    fn SetDirectxDeviceManager(&self, value: windows_core::Ref<'_, IMFDXGIDeviceManager>) -> windows_core::Result<()>;
}
impl IAdvancedMediaCaptureInitializationSettings_Vtbl {
    pub const fn new<Identity: IAdvancedMediaCaptureInitializationSettings_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn SetDirectxDeviceManager<Identity: IAdvancedMediaCaptureInitializationSettings_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, value: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAdvancedMediaCaptureInitializationSettings_Impl::SetDirectxDeviceManager(this, core::mem::transmute_copy(&value)).into()
            }
        }
        Self { base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(), SetDirectxDeviceManager: SetDirectxDeviceManager::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAdvancedMediaCaptureInitializationSettings as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IAdvancedMediaCaptureInitializationSettings {}
windows_core::imp::define_interface!(IAdvancedMediaCaptureSettings, IAdvancedMediaCaptureSettings_Vtbl, 0x24e0485f_a33e_4aa1_b564_6019b1d14f65);
windows_core::imp::interface_hierarchy!(IAdvancedMediaCaptureSettings, windows_core::IUnknown);
impl IAdvancedMediaCaptureSettings {
    pub unsafe fn GetDirectxDeviceManager(&self) -> windows_core::Result<IMFDXGIDeviceManager> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetDirectxDeviceManager)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
}
#[repr(C)]
pub struct IAdvancedMediaCaptureSettings_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetDirectxDeviceManager: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
pub trait IAdvancedMediaCaptureSettings_Impl: windows_core::IUnknownImpl {
    fn GetDirectxDeviceManager(&self) -> windows_core::Result<IMFDXGIDeviceManager>;
}
impl IAdvancedMediaCaptureSettings_Vtbl {
    pub const fn new<Identity: IAdvancedMediaCaptureSettings_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetDirectxDeviceManager<Identity: IAdvancedMediaCaptureSettings_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, value: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAdvancedMediaCaptureSettings_Impl::GetDirectxDeviceManager(this) {
                    Ok(ok__) => {
                        value.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self { base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(), GetDirectxDeviceManager: GetDirectxDeviceManager::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAdvancedMediaCaptureSettings as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IAdvancedMediaCaptureSettings {}
windows_core::imp::define_interface!(IAudioSourceProvider, IAudioSourceProvider_Vtbl, 0xebbaf249_afc2_4582_91c6_b60df2e84954);
windows_core::imp::interface_hierarchy!(IAudioSourceProvider, windows_core::IUnknown);
impl IAudioSourceProvider {
    pub unsafe fn ProvideInput(&self, dwsamplecount: u32, pdwchannelcount: *mut u32, pinterleavedaudiodata: Option<*mut f32>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).ProvideInput)(windows_core::Interface::as_raw(self), dwsamplecount, pdwchannelcount as _, pinterleavedaudiodata.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
}
#[repr(C)]
pub struct IAudioSourceProvider_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub ProvideInput: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut u32, *mut f32) -> windows_core::HRESULT,
}
pub trait IAudioSourceProvider_Impl: windows_core::IUnknownImpl {
    fn ProvideInput(&self, dwsamplecount: u32, pdwchannelcount: *mut u32, pinterleavedaudiodata: *mut f32) -> windows_core::Result<()>;
}
impl IAudioSourceProvider_Vtbl {
    pub const fn new<Identity: IAudioSourceProvider_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn ProvideInput<Identity: IAudioSourceProvider_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwsamplecount: u32, pdwchannelcount: *mut u32, pinterleavedaudiodata: *mut f32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAudioSourceProvider_Impl::ProvideInput(this, core::mem::transmute_copy(&dwsamplecount), core::mem::transmute_copy(&pdwchannelcount), core::mem::transmute_copy(&pinterleavedaudiodata)).into()
            }
        }
        Self { base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(), ProvideInput: ProvideInput::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAudioSourceProvider as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IAudioSourceProvider {}
windows_core::imp::define_interface!(IClusterDetector, IClusterDetector_Vtbl, 0x3f07f7b7_c680_41d9_9423_915107ec9ff9);
windows_core::imp::interface_hierarchy!(IClusterDetector, windows_core::IUnknown);
impl IClusterDetector {
    pub unsafe fn Initialize(&self, wbaseentrylevel: u16, wclusterentrylevel: u16) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Initialize)(windows_core::Interface::as_raw(self), wbaseentrylevel, wclusterentrylevel).ok() }
    }
    pub unsafe fn Detect<P3>(&self, dwmaxnumclusters: u32, fminclusterduration: f32, fmaxclusterduration: f32, psrctoc: P3) -> windows_core::Result<IToc>
    where
        P3: windows_core::Param<IToc>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).Detect)(windows_core::Interface::as_raw(self), dwmaxnumclusters, fminclusterduration, fmaxclusterduration, psrctoc.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
}
#[repr(C)]
pub struct IClusterDetector_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub Initialize: unsafe extern "system" fn(*mut core::ffi::c_void, u16, u16) -> windows_core::HRESULT,
    pub Detect: unsafe extern "system" fn(*mut core::ffi::c_void, u32, f32, f32, *mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
pub trait IClusterDetector_Impl: windows_core::IUnknownImpl {
    fn Initialize(&self, wbaseentrylevel: u16, wclusterentrylevel: u16) -> windows_core::Result<()>;
    fn Detect(&self, dwmaxnumclusters: u32, fminclusterduration: f32, fmaxclusterduration: f32, psrctoc: windows_core::Ref<'_, IToc>) -> windows_core::Result<IToc>;
}
impl IClusterDetector_Vtbl {
    pub const fn new<Identity: IClusterDetector_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn Initialize<Identity: IClusterDetector_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, wbaseentrylevel: u16, wclusterentrylevel: u16) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IClusterDetector_Impl::Initialize(this, core::mem::transmute_copy(&wbaseentrylevel), core::mem::transmute_copy(&wclusterentrylevel)).into()
            }
        }
        unsafe extern "system" fn Detect<Identity: IClusterDetector_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwmaxnumclusters: u32, fminclusterduration: f32, fmaxclusterduration: f32, psrctoc: *mut core::ffi::c_void, ppdsttoc: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IClusterDetector_Impl::Detect(this, core::mem::transmute_copy(&dwmaxnumclusters), core::mem::transmute_copy(&fminclusterduration), core::mem::transmute_copy(&fmaxclusterduration), core::mem::transmute_copy(&psrctoc)) {
                    Ok(ok__) => {
                        ppdsttoc.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self { base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(), Initialize: Initialize::<Identity, OFFSET>, Detect: Detect::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IClusterDetector as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IClusterDetector {}
windows_core::imp::define_interface!(ICodecAPI, ICodecAPI_Vtbl, 0x901db4c7_31ce_41a2_85dc_8fa0bf41b8da);
windows_core::imp::interface_hierarchy!(ICodecAPI, windows_core::IUnknown);
impl ICodecAPI {
    pub unsafe fn IsSupported(&self, api: *const windows_core::GUID) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).IsSupported)(windows_core::Interface::as_raw(self), api).ok() }
    }
    pub unsafe fn IsModifiable(&self, api: *const windows_core::GUID) -> windows_core::HRESULT {
        unsafe { (windows_core::Interface::vtable(self).IsModifiable)(windows_core::Interface::as_raw(self), api) }
    }
    #[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub unsafe fn GetParameterRange(&self, api: *const windows_core::GUID, valuemin: *mut super::super::System::Variant::VARIANT, valuemax: *mut super::super::System::Variant::VARIANT, steppingdelta: *mut super::super::System::Variant::VARIANT) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetParameterRange)(windows_core::Interface::as_raw(self), api, core::mem::transmute(valuemin), core::mem::transmute(valuemax), core::mem::transmute(steppingdelta)).ok() }
    }
    #[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub unsafe fn GetParameterValues(&self, api: *const windows_core::GUID, values: *mut *mut super::super::System::Variant::VARIANT, valuescount: *mut u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetParameterValues)(windows_core::Interface::as_raw(self), api, values as _, valuescount as _).ok() }
    }
    #[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub unsafe fn GetDefaultValue(&self, api: *const windows_core::GUID) -> windows_core::Result<super::super::System::Variant::VARIANT> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetDefaultValue)(windows_core::Interface::as_raw(self), api, &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub unsafe fn GetValue(&self, api: *const windows_core::GUID) -> windows_core::Result<super::super::System::Variant::VARIANT> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetValue)(windows_core::Interface::as_raw(self), api, &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub unsafe fn SetValue(&self, api: *const windows_core::GUID, value: *const super::super::System::Variant::VARIANT) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetValue)(windows_core::Interface::as_raw(self), api, core::mem::transmute(value)).ok() }
    }
    pub unsafe fn RegisterForEvent(&self, api: *const windows_core::GUID, userdata: isize) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).RegisterForEvent)(windows_core::Interface::as_raw(self), api, userdata).ok() }
    }
    pub unsafe fn UnregisterForEvent(&self, api: *const windows_core::GUID) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).UnregisterForEvent)(windows_core::Interface::as_raw(self), api).ok() }
    }
    pub unsafe fn SetAllDefaults(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetAllDefaults)(windows_core::Interface::as_raw(self)).ok() }
    }
    #[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub unsafe fn SetValueWithNotify(&self, api: *const windows_core::GUID, value: *const super::super::System::Variant::VARIANT, changedparam: *mut *mut windows_core::GUID, changedparamcount: *mut u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetValueWithNotify)(windows_core::Interface::as_raw(self), api, core::mem::transmute(value), changedparam as _, changedparamcount as _).ok() }
    }
    pub unsafe fn SetAllDefaultsWithNotify(&self, changedparam: *mut *mut windows_core::GUID, changedparamcount: *mut u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetAllDefaultsWithNotify)(windows_core::Interface::as_raw(self), changedparam as _, changedparamcount as _).ok() }
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetAllSettings<P0>(&self, __midl__icodecapi0000: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::System::Com::IStream>,
    {
        unsafe { (windows_core::Interface::vtable(self).GetAllSettings)(windows_core::Interface::as_raw(self), __midl__icodecapi0000.param().abi()).ok() }
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn SetAllSettings<P0>(&self, __midl__icodecapi0001: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::System::Com::IStream>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetAllSettings)(windows_core::Interface::as_raw(self), __midl__icodecapi0001.param().abi()).ok() }
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn SetAllSettingsWithNotify<P0>(&self, __midl__icodecapi0002: P0, changedparam: *mut *mut windows_core::GUID, changedparamcount: *mut u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::System::Com::IStream>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetAllSettingsWithNotify)(windows_core::Interface::as_raw(self), __midl__icodecapi0002.param().abi(), changedparam as _, changedparamcount as _).ok() }
    }
}
#[repr(C)]
pub struct ICodecAPI_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub IsSupported: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID) -> windows_core::HRESULT,
    pub IsModifiable: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID) -> windows_core::HRESULT,
    #[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub GetParameterRange: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID, *mut super::super::System::Variant::VARIANT, *mut super::super::System::Variant::VARIANT, *mut super::super::System::Variant::VARIANT) -> windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant")))]
    GetParameterRange: usize,
    #[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub GetParameterValues: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID, *mut *mut super::super::System::Variant::VARIANT, *mut u32) -> windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant")))]
    GetParameterValues: usize,
    #[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub GetDefaultValue: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID, *mut super::super::System::Variant::VARIANT) -> windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant")))]
    GetDefaultValue: usize,
    #[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub GetValue: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID, *mut super::super::System::Variant::VARIANT) -> windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant")))]
    GetValue: usize,
    #[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub SetValue: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID, *const super::super::System::Variant::VARIANT) -> windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant")))]
    SetValue: usize,
    pub RegisterForEvent: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID, isize) -> windows_core::HRESULT,
    pub UnregisterForEvent: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID) -> windows_core::HRESULT,
    pub SetAllDefaults: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub SetValueWithNotify: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID, *const super::super::System::Variant::VARIANT, *mut *mut windows_core::GUID, *mut u32) -> windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant")))]
    SetValueWithNotify: usize,
    pub SetAllDefaultsWithNotify: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut windows_core::GUID, *mut u32) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub GetAllSettings: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    GetAllSettings: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub SetAllSettings: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    SetAllSettings: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub SetAllSettingsWithNotify: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut *mut windows_core::GUID, *mut u32) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    SetAllSettingsWithNotify: usize,
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
pub trait ICodecAPI_Impl: windows_core::IUnknownImpl {
    fn IsSupported(&self, api: *const windows_core::GUID) -> windows_core::Result<()>;
    fn IsModifiable(&self, api: *const windows_core::GUID) -> windows_core::HRESULT;
    fn GetParameterRange(&self, api: *const windows_core::GUID, valuemin: *mut super::super::System::Variant::VARIANT, valuemax: *mut super::super::System::Variant::VARIANT, steppingdelta: *mut super::super::System::Variant::VARIANT) -> windows_core::Result<()>;
    fn GetParameterValues(&self, api: *const windows_core::GUID, values: *mut *mut super::super::System::Variant::VARIANT, valuescount: *mut u32) -> windows_core::Result<()>;
    fn GetDefaultValue(&self, api: *const windows_core::GUID) -> windows_core::Result<super::super::System::Variant::VARIANT>;
    fn GetValue(&self, api: *const windows_core::GUID) -> windows_core::Result<super::super::System::Variant::VARIANT>;
    fn SetValue(&self, api: *const windows_core::GUID, value: *const super::super::System::Variant::VARIANT) -> windows_core::Result<()>;
    fn RegisterForEvent(&self, api: *const windows_core::GUID, userdata: isize) -> windows_core::Result<()>;
    fn UnregisterForEvent(&self, api: *const windows_core::GUID) -> windows_core::Result<()>;
    fn SetAllDefaults(&self) -> windows_core::Result<()>;
    fn SetValueWithNotify(&self, api: *const windows_core::GUID, value: *const super::super::System::Variant::VARIANT, changedparam: *mut *mut windows_core::GUID, changedparamcount: *mut u32) -> windows_core::Result<()>;
    fn SetAllDefaultsWithNotify(&self, changedparam: *mut *mut windows_core::GUID, changedparamcount: *mut u32) -> windows_core::Result<()>;
    fn GetAllSettings(&self, __midl__icodecapi0000: windows_core::Ref<'_, super::super::System::Com::IStream>) -> windows_core::Result<()>;
    fn SetAllSettings(&self, __midl__icodecapi0001: windows_core::Ref<'_, super::super::System::Com::IStream>) -> windows_core::Result<()>;
    fn SetAllSettingsWithNotify(&self, __midl__icodecapi0002: windows_core::Ref<'_, super::super::System::Com::IStream>, changedparam: *mut *mut windows_core::GUID, changedparamcount: *mut u32) -> windows_core::Result<()>;
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl ICodecAPI_Vtbl {
    pub const fn new<Identity: ICodecAPI_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn IsSupported<Identity: ICodecAPI_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, api: *const windows_core::GUID) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ICodecAPI_Impl::IsSupported(this, core::mem::transmute_copy(&api)).into()
            }
        }
        unsafe extern "system" fn IsModifiable<Identity: ICodecAPI_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, api: *const windows_core::GUID) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ICodecAPI_Impl::IsModifiable(this, core::mem::transmute_copy(&api))
            }
        }
        unsafe extern "system" fn GetParameterRange<Identity: ICodecAPI_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, api: *const windows_core::GUID, valuemin: *mut super::super::System::Variant::VARIANT, valuemax: *mut super::super::System::Variant::VARIANT, steppingdelta: *mut super::super::System::Variant::VARIANT) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ICodecAPI_Impl::GetParameterRange(this, core::mem::transmute_copy(&api), core::mem::transmute_copy(&valuemin), core::mem::transmute_copy(&valuemax), core::mem::transmute_copy(&steppingdelta)).into()
            }
        }
        unsafe extern "system" fn GetParameterValues<Identity: ICodecAPI_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, api: *const windows_core::GUID, values: *mut *mut super::super::System::Variant::VARIANT, valuescount: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ICodecAPI_Impl::GetParameterValues(this, core::mem::transmute_copy(&api), core::mem::transmute_copy(&values), core::mem::transmute_copy(&valuescount)).into()
            }
        }
        unsafe extern "system" fn GetDefaultValue<Identity: ICodecAPI_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, api: *const windows_core::GUID, value: *mut super::super::System::Variant::VARIANT) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match ICodecAPI_Impl::GetDefaultValue(this, core::mem::transmute_copy(&api)) {
                    Ok(ok__) => {
                        value.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetValue<Identity: ICodecAPI_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, api: *const windows_core::GUID, value: *mut super::super::System::Variant::VARIANT) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match ICodecAPI_Impl::GetValue(this, core::mem::transmute_copy(&api)) {
                    Ok(ok__) => {
                        value.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetValue<Identity: ICodecAPI_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, api: *const windows_core::GUID, value: *const super::super::System::Variant::VARIANT) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ICodecAPI_Impl::SetValue(this, core::mem::transmute_copy(&api), core::mem::transmute_copy(&value)).into()
            }
        }
        unsafe extern "system" fn RegisterForEvent<Identity: ICodecAPI_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, api: *const windows_core::GUID, userdata: isize) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ICodecAPI_Impl::RegisterForEvent(this, core::mem::transmute_copy(&api), core::mem::transmute_copy(&userdata)).into()
            }
        }
        unsafe extern "system" fn UnregisterForEvent<Identity: ICodecAPI_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, api: *const windows_core::GUID) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ICodecAPI_Impl::UnregisterForEvent(this, core::mem::transmute_copy(&api)).into()
            }
        }
        unsafe extern "system" fn SetAllDefaults<Identity: ICodecAPI_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ICodecAPI_Impl::SetAllDefaults(this).into()
            }
        }
        unsafe extern "system" fn SetValueWithNotify<Identity: ICodecAPI_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, api: *const windows_core::GUID, value: *const super::super::System::Variant::VARIANT, changedparam: *mut *mut windows_core::GUID, changedparamcount: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ICodecAPI_Impl::SetValueWithNotify(this, core::mem::transmute_copy(&api), core::mem::transmute_copy(&value), core::mem::transmute_copy(&changedparam), core::mem::transmute_copy(&changedparamcount)).into()
            }
        }
        unsafe extern "system" fn SetAllDefaultsWithNotify<Identity: ICodecAPI_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, changedparam: *mut *mut windows_core::GUID, changedparamcount: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ICodecAPI_Impl::SetAllDefaultsWithNotify(this, core::mem::transmute_copy(&changedparam), core::mem::transmute_copy(&changedparamcount)).into()
            }
        }
        unsafe extern "system" fn GetAllSettings<Identity: ICodecAPI_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, __midl__icodecapi0000: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ICodecAPI_Impl::GetAllSettings(this, core::mem::transmute_copy(&__midl__icodecapi0000)).into()
            }
        }
        unsafe extern "system" fn SetAllSettings<Identity: ICodecAPI_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, __midl__icodecapi0001: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ICodecAPI_Impl::SetAllSettings(this, core::mem::transmute_copy(&__midl__icodecapi0001)).into()
            }
        }
        unsafe extern "system" fn SetAllSettingsWithNotify<Identity: ICodecAPI_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, __midl__icodecapi0002: *mut core::ffi::c_void, changedparam: *mut *mut windows_core::GUID, changedparamcount: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ICodecAPI_Impl::SetAllSettingsWithNotify(this, core::mem::transmute_copy(&__midl__icodecapi0002), core::mem::transmute_copy(&changedparam), core::mem::transmute_copy(&changedparamcount)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            IsSupported: IsSupported::<Identity, OFFSET>,
            IsModifiable: IsModifiable::<Identity, OFFSET>,
            GetParameterRange: GetParameterRange::<Identity, OFFSET>,
            GetParameterValues: GetParameterValues::<Identity, OFFSET>,
            GetDefaultValue: GetDefaultValue::<Identity, OFFSET>,
            GetValue: GetValue::<Identity, OFFSET>,
            SetValue: SetValue::<Identity, OFFSET>,
            RegisterForEvent: RegisterForEvent::<Identity, OFFSET>,
            UnregisterForEvent: UnregisterForEvent::<Identity, OFFSET>,
            SetAllDefaults: SetAllDefaults::<Identity, OFFSET>,
            SetValueWithNotify: SetValueWithNotify::<Identity, OFFSET>,
            SetAllDefaultsWithNotify: SetAllDefaultsWithNotify::<Identity, OFFSET>,
            GetAllSettings: GetAllSettings::<Identity, OFFSET>,
            SetAllSettings: SetAllSettings::<Identity, OFFSET>,
            SetAllSettingsWithNotify: SetAllSettingsWithNotify::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<ICodecAPI as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl windows_core::RuntimeName for ICodecAPI {}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
windows_core::imp::define_interface!(ID3D12VideoDecodeCommandList, ID3D12VideoDecodeCommandList_Vtbl, 0x3b60536e_ad29_4e64_a269_f853837e5e53);
#[cfg(feature = "Win32_Graphics_Direct3D12")]
impl core::ops::Deref for ID3D12VideoDecodeCommandList {
    type Target = super::super::Graphics::Direct3D12::ID3D12CommandList;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
windows_core::imp::interface_hierarchy!(ID3D12VideoDecodeCommandList, windows_core::IUnknown, super::super::Graphics::Direct3D12::ID3D12Object, super::super::Graphics::Direct3D12::ID3D12DeviceChild, super::super::Graphics::Direct3D12::ID3D12CommandList);
#[cfg(feature = "Win32_Graphics_Direct3D12")]
impl ID3D12VideoDecodeCommandList {
    pub unsafe fn Close(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Close)(windows_core::Interface::as_raw(self)).ok() }
    }
    #[cfg(feature = "Win32_Graphics_Direct3D12")]
    pub unsafe fn Reset<P0>(&self, pallocator: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Graphics::Direct3D12::ID3D12CommandAllocator>,
    {
        unsafe { (windows_core::Interface::vtable(self).Reset)(windows_core::Interface::as_raw(self), pallocator.param().abi()).ok() }
    }
    pub unsafe fn ClearState(&self) {
        unsafe { (windows_core::Interface::vtable(self).ClearState)(windows_core::Interface::as_raw(self)) }
    }
    #[cfg(feature = "Win32_Graphics_Direct3D12")]
    pub unsafe fn ResourceBarrier(&self, pbarriers: &[super::super::Graphics::Direct3D12::D3D12_RESOURCE_BARRIER]) {
        unsafe { (windows_core::Interface::vtable(self).ResourceBarrier)(windows_core::Interface::as_raw(self), pbarriers.len().try_into().unwrap(), core::mem::transmute(pbarriers.as_ptr())) }
    }
    #[cfg(feature = "Win32_Graphics_Direct3D12")]
    pub unsafe fn DiscardResource<P0>(&self, presource: P0, pregion: Option<*const super::super::Graphics::Direct3D12::D3D12_DISCARD_REGION>)
    where
        P0: windows_core::Param<super::super::Graphics::Direct3D12::ID3D12Resource>,
    {
        unsafe { (windows_core::Interface::vtable(self).DiscardResource)(windows_core::Interface::as_raw(self), presource.param().abi(), pregion.unwrap_or(core::mem::zeroed()) as _) }
    }
    #[cfg(feature = "Win32_Graphics_Direct3D12")]
    pub unsafe fn BeginQuery<P0>(&self, pqueryheap: P0, r#type: super::super::Graphics::Direct3D12::D3D12_QUERY_TYPE, index: u32)
    where
        P0: windows_core::Param<super::super::Graphics::Direct3D12::ID3D12QueryHeap>,
    {
        unsafe { (windows_core::Interface::vtable(self).BeginQuery)(windows_core::Interface::as_raw(self), pqueryheap.param().abi(), r#type, index) }
    }
    #[cfg(feature = "Win32_Graphics_Direct3D12")]
    pub unsafe fn EndQuery<P0>(&self, pqueryheap: P0, r#type: super::super::Graphics::Direct3D12::D3D12_QUERY_TYPE, index: u32)
    where
        P0: windows_core::Param<super::super::Graphics::Direct3D12::ID3D12QueryHeap>,
    {
        unsafe { (windows_core::Interface::vtable(self).EndQuery)(windows_core::Interface::as_raw(self), pqueryheap.param().abi(), r#type, index) }
    }
    #[cfg(feature = "Win32_Graphics_Direct3D12")]
    pub unsafe fn ResolveQueryData<P0, P4>(&self, pqueryheap: P0, r#type: super::super::Graphics::Direct3D12::D3D12_QUERY_TYPE, startindex: u32, numqueries: u32, pdestinationbuffer: P4, aligneddestinationbufferoffset: u64)
    where
        P0: windows_core::Param<super::super::Graphics::Direct3D12::ID3D12QueryHeap>,
        P4: windows_core::Param<super::super::Graphics::Direct3D12::ID3D12Resource>,
    {
        unsafe { (windows_core::Interface::vtable(self).ResolveQueryData)(windows_core::Interface::as_raw(self), pqueryheap.param().abi(), r#type, startindex, numqueries, pdestinationbuffer.param().abi(), aligneddestinationbufferoffset) }
    }
    #[cfg(feature = "Win32_Graphics_Direct3D12")]
    pub unsafe fn SetPredication<P0>(&self, pbuffer: P0, alignedbufferoffset: u64, operation: super::super::Graphics::Direct3D12::D3D12_PREDICATION_OP)
    where
        P0: windows_core::Param<super::super::Graphics::Direct3D12::ID3D12Resource>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetPredication)(windows_core::Interface::as_raw(self), pbuffer.param().abi(), alignedbufferoffset, operation) }
    }
    pub unsafe fn SetMarker(&self, metadata: u32, pdata: Option<*const core::ffi::c_void>, size: u32) {
        unsafe { (windows_core::Interface::vtable(self).SetMarker)(windows_core::Interface::as_raw(self), metadata, pdata.unwrap_or(core::mem::zeroed()) as _, size) }
    }
    pub unsafe fn BeginEvent(&self, metadata: u32, pdata: Option<*const core::ffi::c_void>, size: u32) {
        unsafe { (windows_core::Interface::vtable(self).BeginEvent)(windows_core::Interface::as_raw(self), metadata, pdata.unwrap_or(core::mem::zeroed()) as _, size) }
    }
    pub unsafe fn EndEvent(&self) {
        unsafe { (windows_core::Interface::vtable(self).EndEvent)(windows_core::Interface::as_raw(self)) }
    }
    #[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
    pub unsafe fn DecodeFrame<P0>(&self, pdecoder: P0, poutputarguments: *const D3D12_VIDEO_DECODE_OUTPUT_STREAM_ARGUMENTS, pinputarguments: *const D3D12_VIDEO_DECODE_INPUT_STREAM_ARGUMENTS)
    where
        P0: windows_core::Param<ID3D12VideoDecoder>,
    {
        unsafe { (windows_core::Interface::vtable(self).DecodeFrame)(windows_core::Interface::as_raw(self), pdecoder.param().abi(), core::mem::transmute(poutputarguments), core::mem::transmute(pinputarguments)) }
    }
    #[cfg(feature = "Win32_Graphics_Direct3D12")]
    pub unsafe fn WriteBufferImmediate(&self, count: u32, pparams: *const super::super::Graphics::Direct3D12::D3D12_WRITEBUFFERIMMEDIATE_PARAMETER, pmodes: Option<*const super::super::Graphics::Direct3D12::D3D12_WRITEBUFFERIMMEDIATE_MODE>) {
        unsafe { (windows_core::Interface::vtable(self).WriteBufferImmediate)(windows_core::Interface::as_raw(self), count, pparams, pmodes.unwrap_or(core::mem::zeroed()) as _) }
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
#[repr(C)]
pub struct ID3D12VideoDecodeCommandList_Vtbl {
    pub base__: super::super::Graphics::Direct3D12::ID3D12CommandList_Vtbl,
    pub Close: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_Graphics_Direct3D12")]
    pub Reset: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Direct3D12"))]
    Reset: usize,
    pub ClearState: unsafe extern "system" fn(*mut core::ffi::c_void),
    #[cfg(feature = "Win32_Graphics_Direct3D12")]
    pub ResourceBarrier: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const super::super::Graphics::Direct3D12::D3D12_RESOURCE_BARRIER),
    #[cfg(not(feature = "Win32_Graphics_Direct3D12"))]
    ResourceBarrier: usize,
    #[cfg(feature = "Win32_Graphics_Direct3D12")]
    pub DiscardResource: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *const super::super::Graphics::Direct3D12::D3D12_DISCARD_REGION),
    #[cfg(not(feature = "Win32_Graphics_Direct3D12"))]
    DiscardResource: usize,
    #[cfg(feature = "Win32_Graphics_Direct3D12")]
    pub BeginQuery: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, super::super::Graphics::Direct3D12::D3D12_QUERY_TYPE, u32),
    #[cfg(not(feature = "Win32_Graphics_Direct3D12"))]
    BeginQuery: usize,
    #[cfg(feature = "Win32_Graphics_Direct3D12")]
    pub EndQuery: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, super::super::Graphics::Direct3D12::D3D12_QUERY_TYPE, u32),
    #[cfg(not(feature = "Win32_Graphics_Direct3D12"))]
    EndQuery: usize,
    #[cfg(feature = "Win32_Graphics_Direct3D12")]
    pub ResolveQueryData: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, super::super::Graphics::Direct3D12::D3D12_QUERY_TYPE, u32, u32, *mut core::ffi::c_void, u64),
    #[cfg(not(feature = "Win32_Graphics_Direct3D12"))]
    ResolveQueryData: usize,
    #[cfg(feature = "Win32_Graphics_Direct3D12")]
    pub SetPredication: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, u64, super::super::Graphics::Direct3D12::D3D12_PREDICATION_OP),
    #[cfg(not(feature = "Win32_Graphics_Direct3D12"))]
    SetPredication: usize,
    pub SetMarker: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const core::ffi::c_void, u32),
    pub BeginEvent: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const core::ffi::c_void, u32),
    pub EndEvent: unsafe extern "system" fn(*mut core::ffi::c_void),
    #[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
    pub DecodeFrame: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *const D3D12_VIDEO_DECODE_OUTPUT_STREAM_ARGUMENTS, *const D3D12_VIDEO_DECODE_INPUT_STREAM_ARGUMENTS),
    #[cfg(not(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common")))]
    DecodeFrame: usize,
    #[cfg(feature = "Win32_Graphics_Direct3D12")]
    pub WriteBufferImmediate: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const super::super::Graphics::Direct3D12::D3D12_WRITEBUFFERIMMEDIATE_PARAMETER, *const super::super::Graphics::Direct3D12::D3D12_WRITEBUFFERIMMEDIATE_MODE),
    #[cfg(not(feature = "Win32_Graphics_Direct3D12"))]
    WriteBufferImmediate: usize,
}
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
pub trait ID3D12VideoDecodeCommandList_Impl: super::super::Graphics::Direct3D12::ID3D12CommandList_Impl {
    fn Close(&self) -> windows_core::Result<()>;
    fn Reset(&self, pallocator: windows_core::Ref<'_, super::super::Graphics::Direct3D12::ID3D12CommandAllocator>) -> windows_core::Result<()>;
    fn ClearState(&self);
    fn ResourceBarrier(&self, numbarriers: u32, pbarriers: *const super::super::Graphics::Direct3D12::D3D12_RESOURCE_BARRIER);
    fn DiscardResource(&self, presource: windows_core::Ref<'_, super::super::Graphics::Direct3D12::ID3D12Resource>, pregion: *const super::super::Graphics::Direct3D12::D3D12_DISCARD_REGION);
    fn BeginQuery(&self, pqueryheap: windows_core::Ref<'_, super::super::Graphics::Direct3D12::ID3D12QueryHeap>, r#type: super::super::Graphics::Direct3D12::D3D12_QUERY_TYPE, index: u32);
    fn EndQuery(&self, pqueryheap: windows_core::Ref<'_, super::super::Graphics::Direct3D12::ID3D12QueryHeap>, r#type: super::super::Graphics::Direct3D12::D3D12_QUERY_TYPE, index: u32);
    fn ResolveQueryData(&self, pqueryheap: windows_core::Ref<'_, super::super::Graphics::Direct3D12::ID3D12QueryHeap>, r#type: super::super::Graphics::Direct3D12::D3D12_QUERY_TYPE, startindex: u32, numqueries: u32, pdestinationbuffer: windows_core::Ref<'_, super::super::Graphics::Direct3D12::ID3D12Resource>, aligneddestinationbufferoffset: u64);
    fn SetPredication(&self, pbuffer: windows_core::Ref<'_, super::super::Graphics::Direct3D12::ID3D12Resource>, alignedbufferoffset: u64, operation: super::super::Graphics::Direct3D12::D3D12_PREDICATION_OP);
    fn SetMarker(&self, metadata: u32, pdata: *const core::ffi::c_void, size: u32);
    fn BeginEvent(&self, metadata: u32, pdata: *const core::ffi::c_void, size: u32);
    fn EndEvent(&self);
    fn DecodeFrame(&self, pdecoder: windows_core::Ref<'_, ID3D12VideoDecoder>, poutputarguments: *const D3D12_VIDEO_DECODE_OUTPUT_STREAM_ARGUMENTS, pinputarguments: *const D3D12_VIDEO_DECODE_INPUT_STREAM_ARGUMENTS);
    fn WriteBufferImmediate(&self, count: u32, pparams: *const super::super::Graphics::Direct3D12::D3D12_WRITEBUFFERIMMEDIATE_PARAMETER, pmodes: *const super::super::Graphics::Direct3D12::D3D12_WRITEBUFFERIMMEDIATE_MODE);
}
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
impl ID3D12VideoDecodeCommandList_Vtbl {
    pub const fn new<Identity: ID3D12VideoDecodeCommandList_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn Close<Identity: ID3D12VideoDecodeCommandList_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoDecodeCommandList_Impl::Close(this).into()
            }
        }
        unsafe extern "system" fn Reset<Identity: ID3D12VideoDecodeCommandList_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pallocator: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoDecodeCommandList_Impl::Reset(this, core::mem::transmute_copy(&pallocator)).into()
            }
        }
        unsafe extern "system" fn ClearState<Identity: ID3D12VideoDecodeCommandList_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoDecodeCommandList_Impl::ClearState(this)
            }
        }
        unsafe extern "system" fn ResourceBarrier<Identity: ID3D12VideoDecodeCommandList_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, numbarriers: u32, pbarriers: *const super::super::Graphics::Direct3D12::D3D12_RESOURCE_BARRIER) {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoDecodeCommandList_Impl::ResourceBarrier(this, core::mem::transmute_copy(&numbarriers), core::mem::transmute_copy(&pbarriers))
            }
        }
        unsafe extern "system" fn DiscardResource<Identity: ID3D12VideoDecodeCommandList_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, presource: *mut core::ffi::c_void, pregion: *const super::super::Graphics::Direct3D12::D3D12_DISCARD_REGION) {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoDecodeCommandList_Impl::DiscardResource(this, core::mem::transmute_copy(&presource), core::mem::transmute_copy(&pregion))
            }
        }
        unsafe extern "system" fn BeginQuery<Identity: ID3D12VideoDecodeCommandList_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pqueryheap: *mut core::ffi::c_void, r#type: super::super::Graphics::Direct3D12::D3D12_QUERY_TYPE, index: u32) {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoDecodeCommandList_Impl::BeginQuery(this, core::mem::transmute_copy(&pqueryheap), core::mem::transmute_copy(&r#type), core::mem::transmute_copy(&index))
            }
        }
        unsafe extern "system" fn EndQuery<Identity: ID3D12VideoDecodeCommandList_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pqueryheap: *mut core::ffi::c_void, r#type: super::super::Graphics::Direct3D12::D3D12_QUERY_TYPE, index: u32) {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoDecodeCommandList_Impl::EndQuery(this, core::mem::transmute_copy(&pqueryheap), core::mem::transmute_copy(&r#type), core::mem::transmute_copy(&index))
            }
        }
        unsafe extern "system" fn ResolveQueryData<Identity: ID3D12VideoDecodeCommandList_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pqueryheap: *mut core::ffi::c_void, r#type: super::super::Graphics::Direct3D12::D3D12_QUERY_TYPE, startindex: u32, numqueries: u32, pdestinationbuffer: *mut core::ffi::c_void, aligneddestinationbufferoffset: u64) {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoDecodeCommandList_Impl::ResolveQueryData(this, core::mem::transmute_copy(&pqueryheap), core::mem::transmute_copy(&r#type), core::mem::transmute_copy(&startindex), core::mem::transmute_copy(&numqueries), core::mem::transmute_copy(&pdestinationbuffer), core::mem::transmute_copy(&aligneddestinationbufferoffset))
            }
        }
        unsafe extern "system" fn SetPredication<Identity: ID3D12VideoDecodeCommandList_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbuffer: *mut core::ffi::c_void, alignedbufferoffset: u64, operation: super::super::Graphics::Direct3D12::D3D12_PREDICATION_OP) {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoDecodeCommandList_Impl::SetPredication(this, core::mem::transmute_copy(&pbuffer), core::mem::transmute_copy(&alignedbufferoffset), core::mem::transmute_copy(&operation))
            }
        }
        unsafe extern "system" fn SetMarker<Identity: ID3D12VideoDecodeCommandList_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, metadata: u32, pdata: *const core::ffi::c_void, size: u32) {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoDecodeCommandList_Impl::SetMarker(this, core::mem::transmute_copy(&metadata), core::mem::transmute_copy(&pdata), core::mem::transmute_copy(&size))
            }
        }
        unsafe extern "system" fn BeginEvent<Identity: ID3D12VideoDecodeCommandList_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, metadata: u32, pdata: *const core::ffi::c_void, size: u32) {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoDecodeCommandList_Impl::BeginEvent(this, core::mem::transmute_copy(&metadata), core::mem::transmute_copy(&pdata), core::mem::transmute_copy(&size))
            }
        }
        unsafe extern "system" fn EndEvent<Identity: ID3D12VideoDecodeCommandList_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoDecodeCommandList_Impl::EndEvent(this)
            }
        }
        unsafe extern "system" fn DecodeFrame<Identity: ID3D12VideoDecodeCommandList_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pdecoder: *mut core::ffi::c_void, poutputarguments: *const D3D12_VIDEO_DECODE_OUTPUT_STREAM_ARGUMENTS, pinputarguments: *const D3D12_VIDEO_DECODE_INPUT_STREAM_ARGUMENTS) {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoDecodeCommandList_Impl::DecodeFrame(this, core::mem::transmute_copy(&pdecoder), core::mem::transmute_copy(&poutputarguments), core::mem::transmute_copy(&pinputarguments))
            }
        }
        unsafe extern "system" fn WriteBufferImmediate<Identity: ID3D12VideoDecodeCommandList_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, count: u32, pparams: *const super::super::Graphics::Direct3D12::D3D12_WRITEBUFFERIMMEDIATE_PARAMETER, pmodes: *const super::super::Graphics::Direct3D12::D3D12_WRITEBUFFERIMMEDIATE_MODE) {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoDecodeCommandList_Impl::WriteBufferImmediate(this, core::mem::transmute_copy(&count), core::mem::transmute_copy(&pparams), core::mem::transmute_copy(&pmodes))
            }
        }
        Self {
            base__: super::super::Graphics::Direct3D12::ID3D12CommandList_Vtbl::new::<Identity, OFFSET>(),
            Close: Close::<Identity, OFFSET>,
            Reset: Reset::<Identity, OFFSET>,
            ClearState: ClearState::<Identity, OFFSET>,
            ResourceBarrier: ResourceBarrier::<Identity, OFFSET>,
            DiscardResource: DiscardResource::<Identity, OFFSET>,
            BeginQuery: BeginQuery::<Identity, OFFSET>,
            EndQuery: EndQuery::<Identity, OFFSET>,
            ResolveQueryData: ResolveQueryData::<Identity, OFFSET>,
            SetPredication: SetPredication::<Identity, OFFSET>,
            SetMarker: SetMarker::<Identity, OFFSET>,
            BeginEvent: BeginEvent::<Identity, OFFSET>,
            EndEvent: EndEvent::<Identity, OFFSET>,
            DecodeFrame: DecodeFrame::<Identity, OFFSET>,
            WriteBufferImmediate: WriteBufferImmediate::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<ID3D12VideoDecodeCommandList as windows_core::Interface>::IID || iid == &<super::super::Graphics::Direct3D12::ID3D12Object as windows_core::Interface>::IID || iid == &<super::super::Graphics::Direct3D12::ID3D12DeviceChild as windows_core::Interface>::IID || iid == &<super::super::Graphics::Direct3D12::ID3D12CommandList as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
impl windows_core::RuntimeName for ID3D12VideoDecodeCommandList {}
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
unsafe impl Send for ID3D12VideoDecodeCommandList {}
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
unsafe impl Sync for ID3D12VideoDecodeCommandList {}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
windows_core::imp::define_interface!(ID3D12VideoDecodeCommandList1, ID3D12VideoDecodeCommandList1_Vtbl, 0xd52f011b_b56e_453c_a05a_a7f311c8f472);
#[cfg(feature = "Win32_Graphics_Direct3D12")]
impl core::ops::Deref for ID3D12VideoDecodeCommandList1 {
    type Target = ID3D12VideoDecodeCommandList;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
windows_core::imp::interface_hierarchy!(ID3D12VideoDecodeCommandList1, windows_core::IUnknown, super::super::Graphics::Direct3D12::ID3D12Object, super::super::Graphics::Direct3D12::ID3D12DeviceChild, super::super::Graphics::Direct3D12::ID3D12CommandList, ID3D12VideoDecodeCommandList);
#[cfg(feature = "Win32_Graphics_Direct3D12")]
impl ID3D12VideoDecodeCommandList1 {
    #[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
    pub unsafe fn DecodeFrame1<P0>(&self, pdecoder: P0, poutputarguments: *const D3D12_VIDEO_DECODE_OUTPUT_STREAM_ARGUMENTS1, pinputarguments: *const D3D12_VIDEO_DECODE_INPUT_STREAM_ARGUMENTS)
    where
        P0: windows_core::Param<ID3D12VideoDecoder>,
    {
        unsafe { (windows_core::Interface::vtable(self).DecodeFrame1)(windows_core::Interface::as_raw(self), pdecoder.param().abi(), core::mem::transmute(poutputarguments), core::mem::transmute(pinputarguments)) }
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
#[repr(C)]
pub struct ID3D12VideoDecodeCommandList1_Vtbl {
    pub base__: ID3D12VideoDecodeCommandList_Vtbl,
    #[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
    pub DecodeFrame1: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *const D3D12_VIDEO_DECODE_OUTPUT_STREAM_ARGUMENTS1, *const D3D12_VIDEO_DECODE_INPUT_STREAM_ARGUMENTS),
    #[cfg(not(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common")))]
    DecodeFrame1: usize,
}
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
pub trait ID3D12VideoDecodeCommandList1_Impl: ID3D12VideoDecodeCommandList_Impl {
    fn DecodeFrame1(&self, pdecoder: windows_core::Ref<'_, ID3D12VideoDecoder>, poutputarguments: *const D3D12_VIDEO_DECODE_OUTPUT_STREAM_ARGUMENTS1, pinputarguments: *const D3D12_VIDEO_DECODE_INPUT_STREAM_ARGUMENTS);
}
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
impl ID3D12VideoDecodeCommandList1_Vtbl {
    pub const fn new<Identity: ID3D12VideoDecodeCommandList1_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn DecodeFrame1<Identity: ID3D12VideoDecodeCommandList1_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pdecoder: *mut core::ffi::c_void, poutputarguments: *const D3D12_VIDEO_DECODE_OUTPUT_STREAM_ARGUMENTS1, pinputarguments: *const D3D12_VIDEO_DECODE_INPUT_STREAM_ARGUMENTS) {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoDecodeCommandList1_Impl::DecodeFrame1(this, core::mem::transmute_copy(&pdecoder), core::mem::transmute_copy(&poutputarguments), core::mem::transmute_copy(&pinputarguments))
            }
        }
        Self { base__: ID3D12VideoDecodeCommandList_Vtbl::new::<Identity, OFFSET>(), DecodeFrame1: DecodeFrame1::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<ID3D12VideoDecodeCommandList1 as windows_core::Interface>::IID || iid == &<super::super::Graphics::Direct3D12::ID3D12Object as windows_core::Interface>::IID || iid == &<super::super::Graphics::Direct3D12::ID3D12DeviceChild as windows_core::Interface>::IID || iid == &<super::super::Graphics::Direct3D12::ID3D12CommandList as windows_core::Interface>::IID || iid == &<ID3D12VideoDecodeCommandList as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
impl windows_core::RuntimeName for ID3D12VideoDecodeCommandList1 {}
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
unsafe impl Send for ID3D12VideoDecodeCommandList1 {}
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
unsafe impl Sync for ID3D12VideoDecodeCommandList1 {}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
windows_core::imp::define_interface!(ID3D12VideoDecodeCommandList2, ID3D12VideoDecodeCommandList2_Vtbl, 0x6e120880_c114_4153_8036_d247051e1729);
#[cfg(feature = "Win32_Graphics_Direct3D12")]
impl core::ops::Deref for ID3D12VideoDecodeCommandList2 {
    type Target = ID3D12VideoDecodeCommandList1;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
windows_core::imp::interface_hierarchy!(ID3D12VideoDecodeCommandList2, windows_core::IUnknown, super::super::Graphics::Direct3D12::ID3D12Object, super::super::Graphics::Direct3D12::ID3D12DeviceChild, super::super::Graphics::Direct3D12::ID3D12CommandList, ID3D12VideoDecodeCommandList, ID3D12VideoDecodeCommandList1);
#[cfg(feature = "Win32_Graphics_Direct3D12")]
impl ID3D12VideoDecodeCommandList2 {
    #[cfg(feature = "Win32_Graphics_Direct3D12")]
    pub unsafe fn SetProtectedResourceSession<P0>(&self, pprotectedresourcesession: P0)
    where
        P0: windows_core::Param<super::super::Graphics::Direct3D12::ID3D12ProtectedResourceSession>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetProtectedResourceSession)(windows_core::Interface::as_raw(self), pprotectedresourcesession.param().abi()) }
    }
    #[cfg(feature = "Win32_Graphics_Direct3D12")]
    pub unsafe fn InitializeExtensionCommand<P0>(&self, pextensioncommand: P0, pinitializationparameters: *const core::ffi::c_void, initializationparameterssizeinbytes: usize)
    where
        P0: windows_core::Param<ID3D12VideoExtensionCommand>,
    {
        unsafe { (windows_core::Interface::vtable(self).InitializeExtensionCommand)(windows_core::Interface::as_raw(self), pextensioncommand.param().abi(), pinitializationparameters, initializationparameterssizeinbytes) }
    }
    #[cfg(feature = "Win32_Graphics_Direct3D12")]
    pub unsafe fn ExecuteExtensionCommand<P0>(&self, pextensioncommand: P0, pexecutionparameters: *const core::ffi::c_void, executionparameterssizeinbytes: usize)
    where
        P0: windows_core::Param<ID3D12VideoExtensionCommand>,
    {
        unsafe { (windows_core::Interface::vtable(self).ExecuteExtensionCommand)(windows_core::Interface::as_raw(self), pextensioncommand.param().abi(), pexecutionparameters, executionparameterssizeinbytes) }
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
#[repr(C)]
pub struct ID3D12VideoDecodeCommandList2_Vtbl {
    pub base__: ID3D12VideoDecodeCommandList1_Vtbl,
    #[cfg(feature = "Win32_Graphics_Direct3D12")]
    pub SetProtectedResourceSession: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void),
    #[cfg(not(feature = "Win32_Graphics_Direct3D12"))]
    SetProtectedResourceSession: usize,
    #[cfg(feature = "Win32_Graphics_Direct3D12")]
    pub InitializeExtensionCommand: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *const core::ffi::c_void, usize),
    #[cfg(not(feature = "Win32_Graphics_Direct3D12"))]
    InitializeExtensionCommand: usize,
    #[cfg(feature = "Win32_Graphics_Direct3D12")]
    pub ExecuteExtensionCommand: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *const core::ffi::c_void, usize),
    #[cfg(not(feature = "Win32_Graphics_Direct3D12"))]
    ExecuteExtensionCommand: usize,
}
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
pub trait ID3D12VideoDecodeCommandList2_Impl: ID3D12VideoDecodeCommandList1_Impl {
    fn SetProtectedResourceSession(&self, pprotectedresourcesession: windows_core::Ref<'_, super::super::Graphics::Direct3D12::ID3D12ProtectedResourceSession>);
    fn InitializeExtensionCommand(&self, pextensioncommand: windows_core::Ref<'_, ID3D12VideoExtensionCommand>, pinitializationparameters: *const core::ffi::c_void, initializationparameterssizeinbytes: usize);
    fn ExecuteExtensionCommand(&self, pextensioncommand: windows_core::Ref<'_, ID3D12VideoExtensionCommand>, pexecutionparameters: *const core::ffi::c_void, executionparameterssizeinbytes: usize);
}
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
impl ID3D12VideoDecodeCommandList2_Vtbl {
    pub const fn new<Identity: ID3D12VideoDecodeCommandList2_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn SetProtectedResourceSession<Identity: ID3D12VideoDecodeCommandList2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pprotectedresourcesession: *mut core::ffi::c_void) {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoDecodeCommandList2_Impl::SetProtectedResourceSession(this, core::mem::transmute_copy(&pprotectedresourcesession))
            }
        }
        unsafe extern "system" fn InitializeExtensionCommand<Identity: ID3D12VideoDecodeCommandList2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pextensioncommand: *mut core::ffi::c_void, pinitializationparameters: *const core::ffi::c_void, initializationparameterssizeinbytes: usize) {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoDecodeCommandList2_Impl::InitializeExtensionCommand(this, core::mem::transmute_copy(&pextensioncommand), core::mem::transmute_copy(&pinitializationparameters), core::mem::transmute_copy(&initializationparameterssizeinbytes))
            }
        }
        unsafe extern "system" fn ExecuteExtensionCommand<Identity: ID3D12VideoDecodeCommandList2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pextensioncommand: *mut core::ffi::c_void, pexecutionparameters: *const core::ffi::c_void, executionparameterssizeinbytes: usize) {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoDecodeCommandList2_Impl::ExecuteExtensionCommand(this, core::mem::transmute_copy(&pextensioncommand), core::mem::transmute_copy(&pexecutionparameters), core::mem::transmute_copy(&executionparameterssizeinbytes))
            }
        }
        Self {
            base__: ID3D12VideoDecodeCommandList1_Vtbl::new::<Identity, OFFSET>(),
            SetProtectedResourceSession: SetProtectedResourceSession::<Identity, OFFSET>,
            InitializeExtensionCommand: InitializeExtensionCommand::<Identity, OFFSET>,
            ExecuteExtensionCommand: ExecuteExtensionCommand::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<ID3D12VideoDecodeCommandList2 as windows_core::Interface>::IID || iid == &<super::super::Graphics::Direct3D12::ID3D12Object as windows_core::Interface>::IID || iid == &<super::super::Graphics::Direct3D12::ID3D12DeviceChild as windows_core::Interface>::IID || iid == &<super::super::Graphics::Direct3D12::ID3D12CommandList as windows_core::Interface>::IID || iid == &<ID3D12VideoDecodeCommandList as windows_core::Interface>::IID || iid == &<ID3D12VideoDecodeCommandList1 as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
impl windows_core::RuntimeName for ID3D12VideoDecodeCommandList2 {}
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
unsafe impl Send for ID3D12VideoDecodeCommandList2 {}
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
unsafe impl Sync for ID3D12VideoDecodeCommandList2 {}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
windows_core::imp::define_interface!(ID3D12VideoDecodeCommandList3, ID3D12VideoDecodeCommandList3_Vtbl, 0x2aee8c37_9562_42da_8abf_61efeb2e4513);
#[cfg(feature = "Win32_Graphics_Direct3D12")]
impl core::ops::Deref for ID3D12VideoDecodeCommandList3 {
    type Target = ID3D12VideoDecodeCommandList2;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
windows_core::imp::interface_hierarchy!(ID3D12VideoDecodeCommandList3, windows_core::IUnknown, super::super::Graphics::Direct3D12::ID3D12Object, super::super::Graphics::Direct3D12::ID3D12DeviceChild, super::super::Graphics::Direct3D12::ID3D12CommandList, ID3D12VideoDecodeCommandList, ID3D12VideoDecodeCommandList1, ID3D12VideoDecodeCommandList2);
#[cfg(feature = "Win32_Graphics_Direct3D12")]
impl ID3D12VideoDecodeCommandList3 {
    #[cfg(feature = "Win32_Graphics_Direct3D12")]
    pub unsafe fn Barrier(&self, pbarriergroups: &[super::super::Graphics::Direct3D12::D3D12_BARRIER_GROUP]) {
        unsafe { (windows_core::Interface::vtable(self).Barrier)(windows_core::Interface::as_raw(self), pbarriergroups.len().try_into().unwrap(), core::mem::transmute(pbarriergroups.as_ptr())) }
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
#[repr(C)]
pub struct ID3D12VideoDecodeCommandList3_Vtbl {
    pub base__: ID3D12VideoDecodeCommandList2_Vtbl,
    #[cfg(feature = "Win32_Graphics_Direct3D12")]
    pub Barrier: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const super::super::Graphics::Direct3D12::D3D12_BARRIER_GROUP),
    #[cfg(not(feature = "Win32_Graphics_Direct3D12"))]
    Barrier: usize,
}
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
pub trait ID3D12VideoDecodeCommandList3_Impl: ID3D12VideoDecodeCommandList2_Impl {
    fn Barrier(&self, numbarriergroups: u32, pbarriergroups: *const super::super::Graphics::Direct3D12::D3D12_BARRIER_GROUP);
}
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
impl ID3D12VideoDecodeCommandList3_Vtbl {
    pub const fn new<Identity: ID3D12VideoDecodeCommandList3_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn Barrier<Identity: ID3D12VideoDecodeCommandList3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, numbarriergroups: u32, pbarriergroups: *const super::super::Graphics::Direct3D12::D3D12_BARRIER_GROUP) {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoDecodeCommandList3_Impl::Barrier(this, core::mem::transmute_copy(&numbarriergroups), core::mem::transmute_copy(&pbarriergroups))
            }
        }
        Self { base__: ID3D12VideoDecodeCommandList2_Vtbl::new::<Identity, OFFSET>(), Barrier: Barrier::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<ID3D12VideoDecodeCommandList3 as windows_core::Interface>::IID || iid == &<super::super::Graphics::Direct3D12::ID3D12Object as windows_core::Interface>::IID || iid == &<super::super::Graphics::Direct3D12::ID3D12DeviceChild as windows_core::Interface>::IID || iid == &<super::super::Graphics::Direct3D12::ID3D12CommandList as windows_core::Interface>::IID || iid == &<ID3D12VideoDecodeCommandList as windows_core::Interface>::IID || iid == &<ID3D12VideoDecodeCommandList1 as windows_core::Interface>::IID || iid == &<ID3D12VideoDecodeCommandList2 as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
impl windows_core::RuntimeName for ID3D12VideoDecodeCommandList3 {}
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
unsafe impl Send for ID3D12VideoDecodeCommandList3 {}
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
unsafe impl Sync for ID3D12VideoDecodeCommandList3 {}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
windows_core::imp::define_interface!(ID3D12VideoDecoder, ID3D12VideoDecoder_Vtbl, 0xc59b6bdc_7720_4074_a136_17a156037470);
#[cfg(feature = "Win32_Graphics_Direct3D12")]
impl core::ops::Deref for ID3D12VideoDecoder {
    type Target = super::super::Graphics::Direct3D12::ID3D12Pageable;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
windows_core::imp::interface_hierarchy!(ID3D12VideoDecoder, windows_core::IUnknown, super::super::Graphics::Direct3D12::ID3D12Object, super::super::Graphics::Direct3D12::ID3D12DeviceChild, super::super::Graphics::Direct3D12::ID3D12Pageable);
#[cfg(feature = "Win32_Graphics_Direct3D12")]
impl ID3D12VideoDecoder {
    pub unsafe fn GetDesc(&self) -> D3D12_VIDEO_DECODER_DESC {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetDesc)(windows_core::Interface::as_raw(self), &mut result__);
            result__
        }
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
#[repr(C)]
pub struct ID3D12VideoDecoder_Vtbl {
    pub base__: super::super::Graphics::Direct3D12::ID3D12Pageable_Vtbl,
    pub GetDesc: unsafe extern "system" fn(*mut core::ffi::c_void, *mut D3D12_VIDEO_DECODER_DESC),
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
pub trait ID3D12VideoDecoder_Impl: super::super::Graphics::Direct3D12::ID3D12Pageable_Impl {
    fn GetDesc(&self) -> D3D12_VIDEO_DECODER_DESC;
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
impl ID3D12VideoDecoder_Vtbl {
    pub const fn new<Identity: ID3D12VideoDecoder_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetDesc<Identity: ID3D12VideoDecoder_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, result__: *mut D3D12_VIDEO_DECODER_DESC) {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                *result__ = ID3D12VideoDecoder_Impl::GetDesc(this)
            }
        }
        Self { base__: super::super::Graphics::Direct3D12::ID3D12Pageable_Vtbl::new::<Identity, OFFSET>(), GetDesc: GetDesc::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<ID3D12VideoDecoder as windows_core::Interface>::IID || iid == &<super::super::Graphics::Direct3D12::ID3D12Object as windows_core::Interface>::IID || iid == &<super::super::Graphics::Direct3D12::ID3D12DeviceChild as windows_core::Interface>::IID || iid == &<super::super::Graphics::Direct3D12::ID3D12Pageable as windows_core::Interface>::IID
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
impl windows_core::RuntimeName for ID3D12VideoDecoder {}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
unsafe impl Send for ID3D12VideoDecoder {}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
unsafe impl Sync for ID3D12VideoDecoder {}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
windows_core::imp::define_interface!(ID3D12VideoDecoder1, ID3D12VideoDecoder1_Vtbl, 0x79a2e5fb_ccd2_469a_9fde_195d10951f7e);
#[cfg(feature = "Win32_Graphics_Direct3D12")]
impl core::ops::Deref for ID3D12VideoDecoder1 {
    type Target = ID3D12VideoDecoder;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
windows_core::imp::interface_hierarchy!(ID3D12VideoDecoder1, windows_core::IUnknown, super::super::Graphics::Direct3D12::ID3D12Object, super::super::Graphics::Direct3D12::ID3D12DeviceChild, super::super::Graphics::Direct3D12::ID3D12Pageable, ID3D12VideoDecoder);
#[cfg(feature = "Win32_Graphics_Direct3D12")]
impl ID3D12VideoDecoder1 {
    pub unsafe fn GetProtectedResourceSession<T>(&self, result__: *mut Option<T>) -> windows_core::Result<()>
    where
        T: windows_core::Interface,
    {
        unsafe { (windows_core::Interface::vtable(self).GetProtectedResourceSession)(windows_core::Interface::as_raw(self), &T::IID, result__ as *mut _ as *mut _).ok() }
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
#[repr(C)]
pub struct ID3D12VideoDecoder1_Vtbl {
    pub base__: ID3D12VideoDecoder_Vtbl,
    pub GetProtectedResourceSession: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
pub trait ID3D12VideoDecoder1_Impl: ID3D12VideoDecoder_Impl {
    fn GetProtectedResourceSession(&self, riid: *const windows_core::GUID, ppprotectedsession: *mut *mut core::ffi::c_void) -> windows_core::Result<()>;
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
impl ID3D12VideoDecoder1_Vtbl {
    pub const fn new<Identity: ID3D12VideoDecoder1_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetProtectedResourceSession<Identity: ID3D12VideoDecoder1_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, riid: *const windows_core::GUID, ppprotectedsession: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoDecoder1_Impl::GetProtectedResourceSession(this, core::mem::transmute_copy(&riid), core::mem::transmute_copy(&ppprotectedsession)).into()
            }
        }
        Self { base__: ID3D12VideoDecoder_Vtbl::new::<Identity, OFFSET>(), GetProtectedResourceSession: GetProtectedResourceSession::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<ID3D12VideoDecoder1 as windows_core::Interface>::IID || iid == &<super::super::Graphics::Direct3D12::ID3D12Object as windows_core::Interface>::IID || iid == &<super::super::Graphics::Direct3D12::ID3D12DeviceChild as windows_core::Interface>::IID || iid == &<super::super::Graphics::Direct3D12::ID3D12Pageable as windows_core::Interface>::IID || iid == &<ID3D12VideoDecoder as windows_core::Interface>::IID
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
impl windows_core::RuntimeName for ID3D12VideoDecoder1 {}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
unsafe impl Send for ID3D12VideoDecoder1 {}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
unsafe impl Sync for ID3D12VideoDecoder1 {}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
windows_core::imp::define_interface!(ID3D12VideoDecoderHeap, ID3D12VideoDecoderHeap_Vtbl, 0x0946b7c9_ebf6_4047_bb73_8683e27dbb1f);
#[cfg(feature = "Win32_Graphics_Direct3D12")]
impl core::ops::Deref for ID3D12VideoDecoderHeap {
    type Target = super::super::Graphics::Direct3D12::ID3D12Pageable;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
windows_core::imp::interface_hierarchy!(ID3D12VideoDecoderHeap, windows_core::IUnknown, super::super::Graphics::Direct3D12::ID3D12Object, super::super::Graphics::Direct3D12::ID3D12DeviceChild, super::super::Graphics::Direct3D12::ID3D12Pageable);
#[cfg(feature = "Win32_Graphics_Direct3D12")]
impl ID3D12VideoDecoderHeap {
    #[cfg(feature = "Win32_Graphics_Dxgi_Common")]
    pub unsafe fn GetDesc(&self) -> D3D12_VIDEO_DECODER_HEAP_DESC {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetDesc)(windows_core::Interface::as_raw(self), &mut result__);
            result__
        }
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
#[repr(C)]
pub struct ID3D12VideoDecoderHeap_Vtbl {
    pub base__: super::super::Graphics::Direct3D12::ID3D12Pageable_Vtbl,
    #[cfg(feature = "Win32_Graphics_Dxgi_Common")]
    pub GetDesc: unsafe extern "system" fn(*mut core::ffi::c_void, *mut D3D12_VIDEO_DECODER_HEAP_DESC),
    #[cfg(not(feature = "Win32_Graphics_Dxgi_Common"))]
    GetDesc: usize,
}
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
pub trait ID3D12VideoDecoderHeap_Impl: super::super::Graphics::Direct3D12::ID3D12Pageable_Impl {
    fn GetDesc(&self) -> D3D12_VIDEO_DECODER_HEAP_DESC;
}
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
impl ID3D12VideoDecoderHeap_Vtbl {
    pub const fn new<Identity: ID3D12VideoDecoderHeap_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetDesc<Identity: ID3D12VideoDecoderHeap_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, result__: *mut D3D12_VIDEO_DECODER_HEAP_DESC) {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                *result__ = ID3D12VideoDecoderHeap_Impl::GetDesc(this)
            }
        }
        Self { base__: super::super::Graphics::Direct3D12::ID3D12Pageable_Vtbl::new::<Identity, OFFSET>(), GetDesc: GetDesc::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<ID3D12VideoDecoderHeap as windows_core::Interface>::IID || iid == &<super::super::Graphics::Direct3D12::ID3D12Object as windows_core::Interface>::IID || iid == &<super::super::Graphics::Direct3D12::ID3D12DeviceChild as windows_core::Interface>::IID || iid == &<super::super::Graphics::Direct3D12::ID3D12Pageable as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
impl windows_core::RuntimeName for ID3D12VideoDecoderHeap {}
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
unsafe impl Send for ID3D12VideoDecoderHeap {}
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
unsafe impl Sync for ID3D12VideoDecoderHeap {}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
windows_core::imp::define_interface!(ID3D12VideoDecoderHeap1, ID3D12VideoDecoderHeap1_Vtbl, 0xda1d98c5_539f_41b2_bf6b_1198a03b6d26);
#[cfg(feature = "Win32_Graphics_Direct3D12")]
impl core::ops::Deref for ID3D12VideoDecoderHeap1 {
    type Target = ID3D12VideoDecoderHeap;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
windows_core::imp::interface_hierarchy!(ID3D12VideoDecoderHeap1, windows_core::IUnknown, super::super::Graphics::Direct3D12::ID3D12Object, super::super::Graphics::Direct3D12::ID3D12DeviceChild, super::super::Graphics::Direct3D12::ID3D12Pageable, ID3D12VideoDecoderHeap);
#[cfg(feature = "Win32_Graphics_Direct3D12")]
impl ID3D12VideoDecoderHeap1 {
    pub unsafe fn GetProtectedResourceSession<T>(&self, result__: *mut Option<T>) -> windows_core::Result<()>
    where
        T: windows_core::Interface,
    {
        unsafe { (windows_core::Interface::vtable(self).GetProtectedResourceSession)(windows_core::Interface::as_raw(self), &T::IID, result__ as *mut _ as *mut _).ok() }
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
#[repr(C)]
pub struct ID3D12VideoDecoderHeap1_Vtbl {
    pub base__: ID3D12VideoDecoderHeap_Vtbl,
    pub GetProtectedResourceSession: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
pub trait ID3D12VideoDecoderHeap1_Impl: ID3D12VideoDecoderHeap_Impl {
    fn GetProtectedResourceSession(&self, riid: *const windows_core::GUID, ppprotectedsession: *mut *mut core::ffi::c_void) -> windows_core::Result<()>;
}
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
impl ID3D12VideoDecoderHeap1_Vtbl {
    pub const fn new<Identity: ID3D12VideoDecoderHeap1_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetProtectedResourceSession<Identity: ID3D12VideoDecoderHeap1_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, riid: *const windows_core::GUID, ppprotectedsession: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoDecoderHeap1_Impl::GetProtectedResourceSession(this, core::mem::transmute_copy(&riid), core::mem::transmute_copy(&ppprotectedsession)).into()
            }
        }
        Self { base__: ID3D12VideoDecoderHeap_Vtbl::new::<Identity, OFFSET>(), GetProtectedResourceSession: GetProtectedResourceSession::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<ID3D12VideoDecoderHeap1 as windows_core::Interface>::IID || iid == &<super::super::Graphics::Direct3D12::ID3D12Object as windows_core::Interface>::IID || iid == &<super::super::Graphics::Direct3D12::ID3D12DeviceChild as windows_core::Interface>::IID || iid == &<super::super::Graphics::Direct3D12::ID3D12Pageable as windows_core::Interface>::IID || iid == &<ID3D12VideoDecoderHeap as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
impl windows_core::RuntimeName for ID3D12VideoDecoderHeap1 {}
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
unsafe impl Send for ID3D12VideoDecoderHeap1 {}
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
unsafe impl Sync for ID3D12VideoDecoderHeap1 {}
windows_core::imp::define_interface!(ID3D12VideoDevice, ID3D12VideoDevice_Vtbl, 0x1f052807_0b46_4acc_8a89_364f793718a4);
windows_core::imp::interface_hierarchy!(ID3D12VideoDevice, windows_core::IUnknown);
impl ID3D12VideoDevice {
    pub unsafe fn CheckFeatureSupport(&self, featurevideo: D3D12_FEATURE_VIDEO, pfeaturesupportdata: *mut core::ffi::c_void, featuresupportdatasize: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).CheckFeatureSupport)(windows_core::Interface::as_raw(self), featurevideo, pfeaturesupportdata as _, featuresupportdatasize).ok() }
    }
    pub unsafe fn CreateVideoDecoder<T>(&self, pdesc: *const D3D12_VIDEO_DECODER_DESC) -> windows_core::Result<T>
    where
        T: windows_core::Interface,
    {
        let mut result__ = core::ptr::null_mut();
        unsafe { (windows_core::Interface::vtable(self).CreateVideoDecoder)(windows_core::Interface::as_raw(self), pdesc, &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__)) }
    }
    #[cfg(feature = "Win32_Graphics_Dxgi_Common")]
    pub unsafe fn CreateVideoDecoderHeap<T>(&self, pvideodecoderheapdesc: *const D3D12_VIDEO_DECODER_HEAP_DESC) -> windows_core::Result<T>
    where
        T: windows_core::Interface,
    {
        let mut result__ = core::ptr::null_mut();
        unsafe { (windows_core::Interface::vtable(self).CreateVideoDecoderHeap)(windows_core::Interface::as_raw(self), pvideodecoderheapdesc, &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__)) }
    }
    #[cfg(feature = "Win32_Graphics_Dxgi_Common")]
    pub unsafe fn CreateVideoProcessor<T>(&self, nodemask: u32, poutputstreamdesc: *const D3D12_VIDEO_PROCESS_OUTPUT_STREAM_DESC, pinputstreamdescs: &[D3D12_VIDEO_PROCESS_INPUT_STREAM_DESC]) -> windows_core::Result<T>
    where
        T: windows_core::Interface,
    {
        let mut result__ = core::ptr::null_mut();
        unsafe { (windows_core::Interface::vtable(self).CreateVideoProcessor)(windows_core::Interface::as_raw(self), nodemask, poutputstreamdesc, pinputstreamdescs.len().try_into().unwrap(), core::mem::transmute(pinputstreamdescs.as_ptr()), &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__)) }
    }
}
#[repr(C)]
pub struct ID3D12VideoDevice_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub CheckFeatureSupport: unsafe extern "system" fn(*mut core::ffi::c_void, D3D12_FEATURE_VIDEO, *mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub CreateVideoDecoder: unsafe extern "system" fn(*mut core::ffi::c_void, *const D3D12_VIDEO_DECODER_DESC, *const windows_core::GUID, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_Graphics_Dxgi_Common")]
    pub CreateVideoDecoderHeap: unsafe extern "system" fn(*mut core::ffi::c_void, *const D3D12_VIDEO_DECODER_HEAP_DESC, *const windows_core::GUID, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Dxgi_Common"))]
    CreateVideoDecoderHeap: usize,
    #[cfg(feature = "Win32_Graphics_Dxgi_Common")]
    pub CreateVideoProcessor: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const D3D12_VIDEO_PROCESS_OUTPUT_STREAM_DESC, u32, *const D3D12_VIDEO_PROCESS_INPUT_STREAM_DESC, *const windows_core::GUID, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Dxgi_Common"))]
    CreateVideoProcessor: usize,
}
#[cfg(feature = "Win32_Graphics_Dxgi_Common")]
pub trait ID3D12VideoDevice_Impl: windows_core::IUnknownImpl {
    fn CheckFeatureSupport(&self, featurevideo: D3D12_FEATURE_VIDEO, pfeaturesupportdata: *mut core::ffi::c_void, featuresupportdatasize: u32) -> windows_core::Result<()>;
    fn CreateVideoDecoder(&self, pdesc: *const D3D12_VIDEO_DECODER_DESC, riid: *const windows_core::GUID, ppvideodecoder: *mut *mut core::ffi::c_void) -> windows_core::Result<()>;
    fn CreateVideoDecoderHeap(&self, pvideodecoderheapdesc: *const D3D12_VIDEO_DECODER_HEAP_DESC, riid: *const windows_core::GUID, ppvideodecoderheap: *mut *mut core::ffi::c_void) -> windows_core::Result<()>;
    fn CreateVideoProcessor(&self, nodemask: u32, poutputstreamdesc: *const D3D12_VIDEO_PROCESS_OUTPUT_STREAM_DESC, numinputstreamdescs: u32, pinputstreamdescs: *const D3D12_VIDEO_PROCESS_INPUT_STREAM_DESC, riid: *const windows_core::GUID, ppvideoprocessor: *mut *mut core::ffi::c_void) -> windows_core::Result<()>;
}
#[cfg(feature = "Win32_Graphics_Dxgi_Common")]
impl ID3D12VideoDevice_Vtbl {
    pub const fn new<Identity: ID3D12VideoDevice_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn CheckFeatureSupport<Identity: ID3D12VideoDevice_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, featurevideo: D3D12_FEATURE_VIDEO, pfeaturesupportdata: *mut core::ffi::c_void, featuresupportdatasize: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoDevice_Impl::CheckFeatureSupport(this, core::mem::transmute_copy(&featurevideo), core::mem::transmute_copy(&pfeaturesupportdata), core::mem::transmute_copy(&featuresupportdatasize)).into()
            }
        }
        unsafe extern "system" fn CreateVideoDecoder<Identity: ID3D12VideoDevice_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pdesc: *const D3D12_VIDEO_DECODER_DESC, riid: *const windows_core::GUID, ppvideodecoder: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoDevice_Impl::CreateVideoDecoder(this, core::mem::transmute_copy(&pdesc), core::mem::transmute_copy(&riid), core::mem::transmute_copy(&ppvideodecoder)).into()
            }
        }
        unsafe extern "system" fn CreateVideoDecoderHeap<Identity: ID3D12VideoDevice_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pvideodecoderheapdesc: *const D3D12_VIDEO_DECODER_HEAP_DESC, riid: *const windows_core::GUID, ppvideodecoderheap: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoDevice_Impl::CreateVideoDecoderHeap(this, core::mem::transmute_copy(&pvideodecoderheapdesc), core::mem::transmute_copy(&riid), core::mem::transmute_copy(&ppvideodecoderheap)).into()
            }
        }
        unsafe extern "system" fn CreateVideoProcessor<Identity: ID3D12VideoDevice_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, nodemask: u32, poutputstreamdesc: *const D3D12_VIDEO_PROCESS_OUTPUT_STREAM_DESC, numinputstreamdescs: u32, pinputstreamdescs: *const D3D12_VIDEO_PROCESS_INPUT_STREAM_DESC, riid: *const windows_core::GUID, ppvideoprocessor: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoDevice_Impl::CreateVideoProcessor(this, core::mem::transmute_copy(&nodemask), core::mem::transmute_copy(&poutputstreamdesc), core::mem::transmute_copy(&numinputstreamdescs), core::mem::transmute_copy(&pinputstreamdescs), core::mem::transmute_copy(&riid), core::mem::transmute_copy(&ppvideoprocessor)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            CheckFeatureSupport: CheckFeatureSupport::<Identity, OFFSET>,
            CreateVideoDecoder: CreateVideoDecoder::<Identity, OFFSET>,
            CreateVideoDecoderHeap: CreateVideoDecoderHeap::<Identity, OFFSET>,
            CreateVideoProcessor: CreateVideoProcessor::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<ID3D12VideoDevice as windows_core::Interface>::IID
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi_Common")]
impl windows_core::RuntimeName for ID3D12VideoDevice {}
#[cfg(feature = "Win32_Graphics_Dxgi_Common")]
unsafe impl Send for ID3D12VideoDevice {}
#[cfg(feature = "Win32_Graphics_Dxgi_Common")]
unsafe impl Sync for ID3D12VideoDevice {}
windows_core::imp::define_interface!(ID3D12VideoDevice1, ID3D12VideoDevice1_Vtbl, 0x981611ad_a144_4c83_9890_f30e26d658ab);
impl core::ops::Deref for ID3D12VideoDevice1 {
    type Target = ID3D12VideoDevice;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(ID3D12VideoDevice1, windows_core::IUnknown, ID3D12VideoDevice);
impl ID3D12VideoDevice1 {
    #[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
    pub unsafe fn CreateVideoMotionEstimator<P1, T>(&self, pdesc: *const D3D12_VIDEO_MOTION_ESTIMATOR_DESC, pprotectedresourcesession: P1) -> windows_core::Result<T>
    where
        P1: windows_core::Param<super::super::Graphics::Direct3D12::ID3D12ProtectedResourceSession>,
        T: windows_core::Interface,
    {
        let mut result__ = core::ptr::null_mut();
        unsafe { (windows_core::Interface::vtable(self).CreateVideoMotionEstimator)(windows_core::Interface::as_raw(self), pdesc, pprotectedresourcesession.param().abi(), &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__)) }
    }
    #[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
    pub unsafe fn CreateVideoMotionVectorHeap<P1, T>(&self, pdesc: *const D3D12_VIDEO_MOTION_VECTOR_HEAP_DESC, pprotectedresourcesession: P1) -> windows_core::Result<T>
    where
        P1: windows_core::Param<super::super::Graphics::Direct3D12::ID3D12ProtectedResourceSession>,
        T: windows_core::Interface,
    {
        let mut result__ = core::ptr::null_mut();
        unsafe { (windows_core::Interface::vtable(self).CreateVideoMotionVectorHeap)(windows_core::Interface::as_raw(self), pdesc, pprotectedresourcesession.param().abi(), &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__)) }
    }
}
#[repr(C)]
pub struct ID3D12VideoDevice1_Vtbl {
    pub base__: ID3D12VideoDevice_Vtbl,
    #[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
    pub CreateVideoMotionEstimator: unsafe extern "system" fn(*mut core::ffi::c_void, *const D3D12_VIDEO_MOTION_ESTIMATOR_DESC, *mut core::ffi::c_void, *const windows_core::GUID, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common")))]
    CreateVideoMotionEstimator: usize,
    #[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
    pub CreateVideoMotionVectorHeap: unsafe extern "system" fn(*mut core::ffi::c_void, *const D3D12_VIDEO_MOTION_VECTOR_HEAP_DESC, *mut core::ffi::c_void, *const windows_core::GUID, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common")))]
    CreateVideoMotionVectorHeap: usize,
}
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
pub trait ID3D12VideoDevice1_Impl: ID3D12VideoDevice_Impl {
    fn CreateVideoMotionEstimator(&self, pdesc: *const D3D12_VIDEO_MOTION_ESTIMATOR_DESC, pprotectedresourcesession: windows_core::Ref<'_, super::super::Graphics::Direct3D12::ID3D12ProtectedResourceSession>, riid: *const windows_core::GUID, ppvideomotionestimator: *mut *mut core::ffi::c_void) -> windows_core::Result<()>;
    fn CreateVideoMotionVectorHeap(&self, pdesc: *const D3D12_VIDEO_MOTION_VECTOR_HEAP_DESC, pprotectedresourcesession: windows_core::Ref<'_, super::super::Graphics::Direct3D12::ID3D12ProtectedResourceSession>, riid: *const windows_core::GUID, ppvideomotionvectorheap: *mut *mut core::ffi::c_void) -> windows_core::Result<()>;
}
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
impl ID3D12VideoDevice1_Vtbl {
    pub const fn new<Identity: ID3D12VideoDevice1_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn CreateVideoMotionEstimator<Identity: ID3D12VideoDevice1_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pdesc: *const D3D12_VIDEO_MOTION_ESTIMATOR_DESC, pprotectedresourcesession: *mut core::ffi::c_void, riid: *const windows_core::GUID, ppvideomotionestimator: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoDevice1_Impl::CreateVideoMotionEstimator(this, core::mem::transmute_copy(&pdesc), core::mem::transmute_copy(&pprotectedresourcesession), core::mem::transmute_copy(&riid), core::mem::transmute_copy(&ppvideomotionestimator)).into()
            }
        }
        unsafe extern "system" fn CreateVideoMotionVectorHeap<Identity: ID3D12VideoDevice1_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pdesc: *const D3D12_VIDEO_MOTION_VECTOR_HEAP_DESC, pprotectedresourcesession: *mut core::ffi::c_void, riid: *const windows_core::GUID, ppvideomotionvectorheap: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoDevice1_Impl::CreateVideoMotionVectorHeap(this, core::mem::transmute_copy(&pdesc), core::mem::transmute_copy(&pprotectedresourcesession), core::mem::transmute_copy(&riid), core::mem::transmute_copy(&ppvideomotionvectorheap)).into()
            }
        }
        Self {
            base__: ID3D12VideoDevice_Vtbl::new::<Identity, OFFSET>(),
            CreateVideoMotionEstimator: CreateVideoMotionEstimator::<Identity, OFFSET>,
            CreateVideoMotionVectorHeap: CreateVideoMotionVectorHeap::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<ID3D12VideoDevice1 as windows_core::Interface>::IID || iid == &<ID3D12VideoDevice as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
impl windows_core::RuntimeName for ID3D12VideoDevice1 {}
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
unsafe impl Send for ID3D12VideoDevice1 {}
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
unsafe impl Sync for ID3D12VideoDevice1 {}
windows_core::imp::define_interface!(ID3D12VideoDevice2, ID3D12VideoDevice2_Vtbl, 0xf019ac49_f838_4a95_9b17_579437c8f513);
impl core::ops::Deref for ID3D12VideoDevice2 {
    type Target = ID3D12VideoDevice1;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(ID3D12VideoDevice2, windows_core::IUnknown, ID3D12VideoDevice, ID3D12VideoDevice1);
impl ID3D12VideoDevice2 {
    #[cfg(feature = "Win32_Graphics_Direct3D12")]
    pub unsafe fn CreateVideoDecoder1<P1, T>(&self, pdesc: *const D3D12_VIDEO_DECODER_DESC, pprotectedresourcesession: P1) -> windows_core::Result<T>
    where
        P1: windows_core::Param<super::super::Graphics::Direct3D12::ID3D12ProtectedResourceSession>,
        T: windows_core::Interface,
    {
        let mut result__ = core::ptr::null_mut();
        unsafe { (windows_core::Interface::vtable(self).CreateVideoDecoder1)(windows_core::Interface::as_raw(self), pdesc, pprotectedresourcesession.param().abi(), &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__)) }
    }
    #[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
    pub unsafe fn CreateVideoDecoderHeap1<P1, T>(&self, pvideodecoderheapdesc: *const D3D12_VIDEO_DECODER_HEAP_DESC, pprotectedresourcesession: P1) -> windows_core::Result<T>
    where
        P1: windows_core::Param<super::super::Graphics::Direct3D12::ID3D12ProtectedResourceSession>,
        T: windows_core::Interface,
    {
        let mut result__ = core::ptr::null_mut();
        unsafe { (windows_core::Interface::vtable(self).CreateVideoDecoderHeap1)(windows_core::Interface::as_raw(self), pvideodecoderheapdesc, pprotectedresourcesession.param().abi(), &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__)) }
    }
    #[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
    pub unsafe fn CreateVideoProcessor1<P4, T>(&self, nodemask: u32, poutputstreamdesc: *const D3D12_VIDEO_PROCESS_OUTPUT_STREAM_DESC, pinputstreamdescs: &[D3D12_VIDEO_PROCESS_INPUT_STREAM_DESC], pprotectedresourcesession: P4) -> windows_core::Result<T>
    where
        P4: windows_core::Param<super::super::Graphics::Direct3D12::ID3D12ProtectedResourceSession>,
        T: windows_core::Interface,
    {
        let mut result__ = core::ptr::null_mut();
        unsafe { (windows_core::Interface::vtable(self).CreateVideoProcessor1)(windows_core::Interface::as_raw(self), nodemask, poutputstreamdesc, pinputstreamdescs.len().try_into().unwrap(), core::mem::transmute(pinputstreamdescs.as_ptr()), pprotectedresourcesession.param().abi(), &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__)) }
    }
    #[cfg(feature = "Win32_Graphics_Direct3D12")]
    pub unsafe fn CreateVideoExtensionCommand<P3, T>(&self, pdesc: *const D3D12_VIDEO_EXTENSION_COMMAND_DESC, pcreationparameters: *const core::ffi::c_void, creationparametersdatasizeinbytes: usize, pprotectedresourcesession: P3) -> windows_core::Result<T>
    where
        P3: windows_core::Param<super::super::Graphics::Direct3D12::ID3D12ProtectedResourceSession>,
        T: windows_core::Interface,
    {
        let mut result__ = core::ptr::null_mut();
        unsafe { (windows_core::Interface::vtable(self).CreateVideoExtensionCommand)(windows_core::Interface::as_raw(self), pdesc, pcreationparameters, creationparametersdatasizeinbytes, pprotectedresourcesession.param().abi(), &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__)) }
    }
    #[cfg(feature = "Win32_Graphics_Direct3D12")]
    pub unsafe fn ExecuteExtensionCommand<P0>(&self, pextensioncommand: P0, pexecutionparameters: *const core::ffi::c_void, executionparameterssizeinbytes: usize, poutputdata: *mut core::ffi::c_void, outputdatasizeinbytes: usize) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ID3D12VideoExtensionCommand>,
    {
        unsafe { (windows_core::Interface::vtable(self).ExecuteExtensionCommand)(windows_core::Interface::as_raw(self), pextensioncommand.param().abi(), pexecutionparameters, executionparameterssizeinbytes, poutputdata as _, outputdatasizeinbytes).ok() }
    }
}
#[repr(C)]
pub struct ID3D12VideoDevice2_Vtbl {
    pub base__: ID3D12VideoDevice1_Vtbl,
    #[cfg(feature = "Win32_Graphics_Direct3D12")]
    pub CreateVideoDecoder1: unsafe extern "system" fn(*mut core::ffi::c_void, *const D3D12_VIDEO_DECODER_DESC, *mut core::ffi::c_void, *const windows_core::GUID, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Direct3D12"))]
    CreateVideoDecoder1: usize,
    #[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
    pub CreateVideoDecoderHeap1: unsafe extern "system" fn(*mut core::ffi::c_void, *const D3D12_VIDEO_DECODER_HEAP_DESC, *mut core::ffi::c_void, *const windows_core::GUID, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common")))]
    CreateVideoDecoderHeap1: usize,
    #[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
    pub CreateVideoProcessor1: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const D3D12_VIDEO_PROCESS_OUTPUT_STREAM_DESC, u32, *const D3D12_VIDEO_PROCESS_INPUT_STREAM_DESC, *mut core::ffi::c_void, *const windows_core::GUID, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common")))]
    CreateVideoProcessor1: usize,
    #[cfg(feature = "Win32_Graphics_Direct3D12")]
    pub CreateVideoExtensionCommand: unsafe extern "system" fn(*mut core::ffi::c_void, *const D3D12_VIDEO_EXTENSION_COMMAND_DESC, *const core::ffi::c_void, usize, *mut core::ffi::c_void, *const windows_core::GUID, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Direct3D12"))]
    CreateVideoExtensionCommand: usize,
    #[cfg(feature = "Win32_Graphics_Direct3D12")]
    pub ExecuteExtensionCommand: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *const core::ffi::c_void, usize, *mut core::ffi::c_void, usize) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Direct3D12"))]
    ExecuteExtensionCommand: usize,
}
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
pub trait ID3D12VideoDevice2_Impl: ID3D12VideoDevice1_Impl {
    fn CreateVideoDecoder1(&self, pdesc: *const D3D12_VIDEO_DECODER_DESC, pprotectedresourcesession: windows_core::Ref<'_, super::super::Graphics::Direct3D12::ID3D12ProtectedResourceSession>, riid: *const windows_core::GUID, ppvideodecoder: *mut *mut core::ffi::c_void) -> windows_core::Result<()>;
    fn CreateVideoDecoderHeap1(&self, pvideodecoderheapdesc: *const D3D12_VIDEO_DECODER_HEAP_DESC, pprotectedresourcesession: windows_core::Ref<'_, super::super::Graphics::Direct3D12::ID3D12ProtectedResourceSession>, riid: *const windows_core::GUID, ppvideodecoderheap: *mut *mut core::ffi::c_void) -> windows_core::Result<()>;
    fn CreateVideoProcessor1(&self, nodemask: u32, poutputstreamdesc: *const D3D12_VIDEO_PROCESS_OUTPUT_STREAM_DESC, numinputstreamdescs: u32, pinputstreamdescs: *const D3D12_VIDEO_PROCESS_INPUT_STREAM_DESC, pprotectedresourcesession: windows_core::Ref<'_, super::super::Graphics::Direct3D12::ID3D12ProtectedResourceSession>, riid: *const windows_core::GUID, ppvideoprocessor: *mut *mut core::ffi::c_void) -> windows_core::Result<()>;
    fn CreateVideoExtensionCommand(&self, pdesc: *const D3D12_VIDEO_EXTENSION_COMMAND_DESC, pcreationparameters: *const core::ffi::c_void, creationparametersdatasizeinbytes: usize, pprotectedresourcesession: windows_core::Ref<'_, super::super::Graphics::Direct3D12::ID3D12ProtectedResourceSession>, riid: *const windows_core::GUID, ppvideoextensioncommand: *mut *mut core::ffi::c_void) -> windows_core::Result<()>;
    fn ExecuteExtensionCommand(&self, pextensioncommand: windows_core::Ref<'_, ID3D12VideoExtensionCommand>, pexecutionparameters: *const core::ffi::c_void, executionparameterssizeinbytes: usize, poutputdata: *mut core::ffi::c_void, outputdatasizeinbytes: usize) -> windows_core::Result<()>;
}
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
impl ID3D12VideoDevice2_Vtbl {
    pub const fn new<Identity: ID3D12VideoDevice2_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn CreateVideoDecoder1<Identity: ID3D12VideoDevice2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pdesc: *const D3D12_VIDEO_DECODER_DESC, pprotectedresourcesession: *mut core::ffi::c_void, riid: *const windows_core::GUID, ppvideodecoder: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoDevice2_Impl::CreateVideoDecoder1(this, core::mem::transmute_copy(&pdesc), core::mem::transmute_copy(&pprotectedresourcesession), core::mem::transmute_copy(&riid), core::mem::transmute_copy(&ppvideodecoder)).into()
            }
        }
        unsafe extern "system" fn CreateVideoDecoderHeap1<Identity: ID3D12VideoDevice2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pvideodecoderheapdesc: *const D3D12_VIDEO_DECODER_HEAP_DESC, pprotectedresourcesession: *mut core::ffi::c_void, riid: *const windows_core::GUID, ppvideodecoderheap: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoDevice2_Impl::CreateVideoDecoderHeap1(this, core::mem::transmute_copy(&pvideodecoderheapdesc), core::mem::transmute_copy(&pprotectedresourcesession), core::mem::transmute_copy(&riid), core::mem::transmute_copy(&ppvideodecoderheap)).into()
            }
        }
        unsafe extern "system" fn CreateVideoProcessor1<Identity: ID3D12VideoDevice2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, nodemask: u32, poutputstreamdesc: *const D3D12_VIDEO_PROCESS_OUTPUT_STREAM_DESC, numinputstreamdescs: u32, pinputstreamdescs: *const D3D12_VIDEO_PROCESS_INPUT_STREAM_DESC, pprotectedresourcesession: *mut core::ffi::c_void, riid: *const windows_core::GUID, ppvideoprocessor: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoDevice2_Impl::CreateVideoProcessor1(this, core::mem::transmute_copy(&nodemask), core::mem::transmute_copy(&poutputstreamdesc), core::mem::transmute_copy(&numinputstreamdescs), core::mem::transmute_copy(&pinputstreamdescs), core::mem::transmute_copy(&pprotectedresourcesession), core::mem::transmute_copy(&riid), core::mem::transmute_copy(&ppvideoprocessor)).into()
            }
        }
        unsafe extern "system" fn CreateVideoExtensionCommand<Identity: ID3D12VideoDevice2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pdesc: *const D3D12_VIDEO_EXTENSION_COMMAND_DESC, pcreationparameters: *const core::ffi::c_void, creationparametersdatasizeinbytes: usize, pprotectedresourcesession: *mut core::ffi::c_void, riid: *const windows_core::GUID, ppvideoextensioncommand: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoDevice2_Impl::CreateVideoExtensionCommand(this, core::mem::transmute_copy(&pdesc), core::mem::transmute_copy(&pcreationparameters), core::mem::transmute_copy(&creationparametersdatasizeinbytes), core::mem::transmute_copy(&pprotectedresourcesession), core::mem::transmute_copy(&riid), core::mem::transmute_copy(&ppvideoextensioncommand)).into()
            }
        }
        unsafe extern "system" fn ExecuteExtensionCommand<Identity: ID3D12VideoDevice2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pextensioncommand: *mut core::ffi::c_void, pexecutionparameters: *const core::ffi::c_void, executionparameterssizeinbytes: usize, poutputdata: *mut core::ffi::c_void, outputdatasizeinbytes: usize) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoDevice2_Impl::ExecuteExtensionCommand(this, core::mem::transmute_copy(&pextensioncommand), core::mem::transmute_copy(&pexecutionparameters), core::mem::transmute_copy(&executionparameterssizeinbytes), core::mem::transmute_copy(&poutputdata), core::mem::transmute_copy(&outputdatasizeinbytes)).into()
            }
        }
        Self {
            base__: ID3D12VideoDevice1_Vtbl::new::<Identity, OFFSET>(),
            CreateVideoDecoder1: CreateVideoDecoder1::<Identity, OFFSET>,
            CreateVideoDecoderHeap1: CreateVideoDecoderHeap1::<Identity, OFFSET>,
            CreateVideoProcessor1: CreateVideoProcessor1::<Identity, OFFSET>,
            CreateVideoExtensionCommand: CreateVideoExtensionCommand::<Identity, OFFSET>,
            ExecuteExtensionCommand: ExecuteExtensionCommand::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<ID3D12VideoDevice2 as windows_core::Interface>::IID || iid == &<ID3D12VideoDevice as windows_core::Interface>::IID || iid == &<ID3D12VideoDevice1 as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
impl windows_core::RuntimeName for ID3D12VideoDevice2 {}
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
unsafe impl Send for ID3D12VideoDevice2 {}
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
unsafe impl Sync for ID3D12VideoDevice2 {}
windows_core::imp::define_interface!(ID3D12VideoDevice3, ID3D12VideoDevice3_Vtbl, 0x4243adb4_3a32_4666_973c_0ccc5625dc44);
impl core::ops::Deref for ID3D12VideoDevice3 {
    type Target = ID3D12VideoDevice2;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(ID3D12VideoDevice3, windows_core::IUnknown, ID3D12VideoDevice, ID3D12VideoDevice1, ID3D12VideoDevice2);
impl ID3D12VideoDevice3 {
    #[cfg(feature = "Win32_Graphics_Dxgi_Common")]
    pub unsafe fn CreateVideoEncoder<T>(&self, pdesc: *const D3D12_VIDEO_ENCODER_DESC) -> windows_core::Result<T>
    where
        T: windows_core::Interface,
    {
        let mut result__ = core::ptr::null_mut();
        unsafe { (windows_core::Interface::vtable(self).CreateVideoEncoder)(windows_core::Interface::as_raw(self), pdesc, &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__)) }
    }
    pub unsafe fn CreateVideoEncoderHeap<T>(&self, pdesc: *const D3D12_VIDEO_ENCODER_HEAP_DESC) -> windows_core::Result<T>
    where
        T: windows_core::Interface,
    {
        let mut result__ = core::ptr::null_mut();
        unsafe { (windows_core::Interface::vtable(self).CreateVideoEncoderHeap)(windows_core::Interface::as_raw(self), pdesc, &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__)) }
    }
}
#[repr(C)]
pub struct ID3D12VideoDevice3_Vtbl {
    pub base__: ID3D12VideoDevice2_Vtbl,
    #[cfg(feature = "Win32_Graphics_Dxgi_Common")]
    pub CreateVideoEncoder: unsafe extern "system" fn(*mut core::ffi::c_void, *const D3D12_VIDEO_ENCODER_DESC, *const windows_core::GUID, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Dxgi_Common"))]
    CreateVideoEncoder: usize,
    pub CreateVideoEncoderHeap: unsafe extern "system" fn(*mut core::ffi::c_void, *const D3D12_VIDEO_ENCODER_HEAP_DESC, *const windows_core::GUID, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
pub trait ID3D12VideoDevice3_Impl: ID3D12VideoDevice2_Impl {
    fn CreateVideoEncoder(&self, pdesc: *const D3D12_VIDEO_ENCODER_DESC, riid: *const windows_core::GUID, ppvideoencoder: *mut *mut core::ffi::c_void) -> windows_core::Result<()>;
    fn CreateVideoEncoderHeap(&self, pdesc: *const D3D12_VIDEO_ENCODER_HEAP_DESC, riid: *const windows_core::GUID, ppvideoencoderheap: *mut *mut core::ffi::c_void) -> windows_core::Result<()>;
}
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
impl ID3D12VideoDevice3_Vtbl {
    pub const fn new<Identity: ID3D12VideoDevice3_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn CreateVideoEncoder<Identity: ID3D12VideoDevice3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pdesc: *const D3D12_VIDEO_ENCODER_DESC, riid: *const windows_core::GUID, ppvideoencoder: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoDevice3_Impl::CreateVideoEncoder(this, core::mem::transmute_copy(&pdesc), core::mem::transmute_copy(&riid), core::mem::transmute_copy(&ppvideoencoder)).into()
            }
        }
        unsafe extern "system" fn CreateVideoEncoderHeap<Identity: ID3D12VideoDevice3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pdesc: *const D3D12_VIDEO_ENCODER_HEAP_DESC, riid: *const windows_core::GUID, ppvideoencoderheap: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoDevice3_Impl::CreateVideoEncoderHeap(this, core::mem::transmute_copy(&pdesc), core::mem::transmute_copy(&riid), core::mem::transmute_copy(&ppvideoencoderheap)).into()
            }
        }
        Self {
            base__: ID3D12VideoDevice2_Vtbl::new::<Identity, OFFSET>(),
            CreateVideoEncoder: CreateVideoEncoder::<Identity, OFFSET>,
            CreateVideoEncoderHeap: CreateVideoEncoderHeap::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<ID3D12VideoDevice3 as windows_core::Interface>::IID || iid == &<ID3D12VideoDevice as windows_core::Interface>::IID || iid == &<ID3D12VideoDevice1 as windows_core::Interface>::IID || iid == &<ID3D12VideoDevice2 as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
impl windows_core::RuntimeName for ID3D12VideoDevice3 {}
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
unsafe impl Send for ID3D12VideoDevice3 {}
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
unsafe impl Sync for ID3D12VideoDevice3 {}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
windows_core::imp::define_interface!(ID3D12VideoEncodeCommandList, ID3D12VideoEncodeCommandList_Vtbl, 0x8455293a_0cbd_4831_9b39_fbdbab724723);
#[cfg(feature = "Win32_Graphics_Direct3D12")]
impl core::ops::Deref for ID3D12VideoEncodeCommandList {
    type Target = super::super::Graphics::Direct3D12::ID3D12CommandList;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
windows_core::imp::interface_hierarchy!(ID3D12VideoEncodeCommandList, windows_core::IUnknown, super::super::Graphics::Direct3D12::ID3D12Object, super::super::Graphics::Direct3D12::ID3D12DeviceChild, super::super::Graphics::Direct3D12::ID3D12CommandList);
#[cfg(feature = "Win32_Graphics_Direct3D12")]
impl ID3D12VideoEncodeCommandList {
    pub unsafe fn Close(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Close)(windows_core::Interface::as_raw(self)).ok() }
    }
    #[cfg(feature = "Win32_Graphics_Direct3D12")]
    pub unsafe fn Reset<P0>(&self, pallocator: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Graphics::Direct3D12::ID3D12CommandAllocator>,
    {
        unsafe { (windows_core::Interface::vtable(self).Reset)(windows_core::Interface::as_raw(self), pallocator.param().abi()).ok() }
    }
    pub unsafe fn ClearState(&self) {
        unsafe { (windows_core::Interface::vtable(self).ClearState)(windows_core::Interface::as_raw(self)) }
    }
    #[cfg(feature = "Win32_Graphics_Direct3D12")]
    pub unsafe fn ResourceBarrier(&self, pbarriers: &[super::super::Graphics::Direct3D12::D3D12_RESOURCE_BARRIER]) {
        unsafe { (windows_core::Interface::vtable(self).ResourceBarrier)(windows_core::Interface::as_raw(self), pbarriers.len().try_into().unwrap(), core::mem::transmute(pbarriers.as_ptr())) }
    }
    #[cfg(feature = "Win32_Graphics_Direct3D12")]
    pub unsafe fn DiscardResource<P0>(&self, presource: P0, pregion: Option<*const super::super::Graphics::Direct3D12::D3D12_DISCARD_REGION>)
    where
        P0: windows_core::Param<super::super::Graphics::Direct3D12::ID3D12Resource>,
    {
        unsafe { (windows_core::Interface::vtable(self).DiscardResource)(windows_core::Interface::as_raw(self), presource.param().abi(), pregion.unwrap_or(core::mem::zeroed()) as _) }
    }
    #[cfg(feature = "Win32_Graphics_Direct3D12")]
    pub unsafe fn BeginQuery<P0>(&self, pqueryheap: P0, r#type: super::super::Graphics::Direct3D12::D3D12_QUERY_TYPE, index: u32)
    where
        P0: windows_core::Param<super::super::Graphics::Direct3D12::ID3D12QueryHeap>,
    {
        unsafe { (windows_core::Interface::vtable(self).BeginQuery)(windows_core::Interface::as_raw(self), pqueryheap.param().abi(), r#type, index) }
    }
    #[cfg(feature = "Win32_Graphics_Direct3D12")]
    pub unsafe fn EndQuery<P0>(&self, pqueryheap: P0, r#type: super::super::Graphics::Direct3D12::D3D12_QUERY_TYPE, index: u32)
    where
        P0: windows_core::Param<super::super::Graphics::Direct3D12::ID3D12QueryHeap>,
    {
        unsafe { (windows_core::Interface::vtable(self).EndQuery)(windows_core::Interface::as_raw(self), pqueryheap.param().abi(), r#type, index) }
    }
    #[cfg(feature = "Win32_Graphics_Direct3D12")]
    pub unsafe fn ResolveQueryData<P0, P4>(&self, pqueryheap: P0, r#type: super::super::Graphics::Direct3D12::D3D12_QUERY_TYPE, startindex: u32, numqueries: u32, pdestinationbuffer: P4, aligneddestinationbufferoffset: u64)
    where
        P0: windows_core::Param<super::super::Graphics::Direct3D12::ID3D12QueryHeap>,
        P4: windows_core::Param<super::super::Graphics::Direct3D12::ID3D12Resource>,
    {
        unsafe { (windows_core::Interface::vtable(self).ResolveQueryData)(windows_core::Interface::as_raw(self), pqueryheap.param().abi(), r#type, startindex, numqueries, pdestinationbuffer.param().abi(), aligneddestinationbufferoffset) }
    }
    #[cfg(feature = "Win32_Graphics_Direct3D12")]
    pub unsafe fn SetPredication<P0>(&self, pbuffer: P0, alignedbufferoffset: u64, operation: super::super::Graphics::Direct3D12::D3D12_PREDICATION_OP)
    where
        P0: windows_core::Param<super::super::Graphics::Direct3D12::ID3D12Resource>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetPredication)(windows_core::Interface::as_raw(self), pbuffer.param().abi(), alignedbufferoffset, operation) }
    }
    pub unsafe fn SetMarker(&self, metadata: u32, pdata: Option<*const core::ffi::c_void>, size: u32) {
        unsafe { (windows_core::Interface::vtable(self).SetMarker)(windows_core::Interface::as_raw(self), metadata, pdata.unwrap_or(core::mem::zeroed()) as _, size) }
    }
    pub unsafe fn BeginEvent(&self, metadata: u32, pdata: Option<*const core::ffi::c_void>, size: u32) {
        unsafe { (windows_core::Interface::vtable(self).BeginEvent)(windows_core::Interface::as_raw(self), metadata, pdata.unwrap_or(core::mem::zeroed()) as _, size) }
    }
    pub unsafe fn EndEvent(&self) {
        unsafe { (windows_core::Interface::vtable(self).EndEvent)(windows_core::Interface::as_raw(self)) }
    }
    #[cfg(feature = "Win32_Graphics_Direct3D12")]
    pub unsafe fn EstimateMotion<P0>(&self, pmotionestimator: P0, poutputarguments: *const D3D12_VIDEO_MOTION_ESTIMATOR_OUTPUT, pinputarguments: *const D3D12_VIDEO_MOTION_ESTIMATOR_INPUT)
    where
        P0: windows_core::Param<ID3D12VideoMotionEstimator>,
    {
        unsafe { (windows_core::Interface::vtable(self).EstimateMotion)(windows_core::Interface::as_raw(self), pmotionestimator.param().abi(), core::mem::transmute(poutputarguments), core::mem::transmute(pinputarguments)) }
    }
    #[cfg(feature = "Win32_Graphics_Direct3D12")]
    pub unsafe fn ResolveMotionVectorHeap(&self, poutputarguments: *const D3D12_RESOLVE_VIDEO_MOTION_VECTOR_HEAP_OUTPUT, pinputarguments: *const D3D12_RESOLVE_VIDEO_MOTION_VECTOR_HEAP_INPUT) {
        unsafe { (windows_core::Interface::vtable(self).ResolveMotionVectorHeap)(windows_core::Interface::as_raw(self), core::mem::transmute(poutputarguments), core::mem::transmute(pinputarguments)) }
    }
    #[cfg(feature = "Win32_Graphics_Direct3D12")]
    pub unsafe fn WriteBufferImmediate(&self, count: u32, pparams: *const super::super::Graphics::Direct3D12::D3D12_WRITEBUFFERIMMEDIATE_PARAMETER, pmodes: Option<*const super::super::Graphics::Direct3D12::D3D12_WRITEBUFFERIMMEDIATE_MODE>) {
        unsafe { (windows_core::Interface::vtable(self).WriteBufferImmediate)(windows_core::Interface::as_raw(self), count, pparams, pmodes.unwrap_or(core::mem::zeroed()) as _) }
    }
    #[cfg(feature = "Win32_Graphics_Direct3D12")]
    pub unsafe fn SetProtectedResourceSession<P0>(&self, pprotectedresourcesession: P0)
    where
        P0: windows_core::Param<super::super::Graphics::Direct3D12::ID3D12ProtectedResourceSession>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetProtectedResourceSession)(windows_core::Interface::as_raw(self), pprotectedresourcesession.param().abi()) }
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
#[repr(C)]
pub struct ID3D12VideoEncodeCommandList_Vtbl {
    pub base__: super::super::Graphics::Direct3D12::ID3D12CommandList_Vtbl,
    pub Close: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_Graphics_Direct3D12")]
    pub Reset: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Direct3D12"))]
    Reset: usize,
    pub ClearState: unsafe extern "system" fn(*mut core::ffi::c_void),
    #[cfg(feature = "Win32_Graphics_Direct3D12")]
    pub ResourceBarrier: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const super::super::Graphics::Direct3D12::D3D12_RESOURCE_BARRIER),
    #[cfg(not(feature = "Win32_Graphics_Direct3D12"))]
    ResourceBarrier: usize,
    #[cfg(feature = "Win32_Graphics_Direct3D12")]
    pub DiscardResource: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *const super::super::Graphics::Direct3D12::D3D12_DISCARD_REGION),
    #[cfg(not(feature = "Win32_Graphics_Direct3D12"))]
    DiscardResource: usize,
    #[cfg(feature = "Win32_Graphics_Direct3D12")]
    pub BeginQuery: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, super::super::Graphics::Direct3D12::D3D12_QUERY_TYPE, u32),
    #[cfg(not(feature = "Win32_Graphics_Direct3D12"))]
    BeginQuery: usize,
    #[cfg(feature = "Win32_Graphics_Direct3D12")]
    pub EndQuery: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, super::super::Graphics::Direct3D12::D3D12_QUERY_TYPE, u32),
    #[cfg(not(feature = "Win32_Graphics_Direct3D12"))]
    EndQuery: usize,
    #[cfg(feature = "Win32_Graphics_Direct3D12")]
    pub ResolveQueryData: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, super::super::Graphics::Direct3D12::D3D12_QUERY_TYPE, u32, u32, *mut core::ffi::c_void, u64),
    #[cfg(not(feature = "Win32_Graphics_Direct3D12"))]
    ResolveQueryData: usize,
    #[cfg(feature = "Win32_Graphics_Direct3D12")]
    pub SetPredication: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, u64, super::super::Graphics::Direct3D12::D3D12_PREDICATION_OP),
    #[cfg(not(feature = "Win32_Graphics_Direct3D12"))]
    SetPredication: usize,
    pub SetMarker: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const core::ffi::c_void, u32),
    pub BeginEvent: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const core::ffi::c_void, u32),
    pub EndEvent: unsafe extern "system" fn(*mut core::ffi::c_void),
    #[cfg(feature = "Win32_Graphics_Direct3D12")]
    pub EstimateMotion: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *const D3D12_VIDEO_MOTION_ESTIMATOR_OUTPUT, *const D3D12_VIDEO_MOTION_ESTIMATOR_INPUT),
    #[cfg(not(feature = "Win32_Graphics_Direct3D12"))]
    EstimateMotion: usize,
    #[cfg(feature = "Win32_Graphics_Direct3D12")]
    pub ResolveMotionVectorHeap: unsafe extern "system" fn(*mut core::ffi::c_void, *const D3D12_RESOLVE_VIDEO_MOTION_VECTOR_HEAP_OUTPUT, *const D3D12_RESOLVE_VIDEO_MOTION_VECTOR_HEAP_INPUT),
    #[cfg(not(feature = "Win32_Graphics_Direct3D12"))]
    ResolveMotionVectorHeap: usize,
    #[cfg(feature = "Win32_Graphics_Direct3D12")]
    pub WriteBufferImmediate: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const super::super::Graphics::Direct3D12::D3D12_WRITEBUFFERIMMEDIATE_PARAMETER, *const super::super::Graphics::Direct3D12::D3D12_WRITEBUFFERIMMEDIATE_MODE),
    #[cfg(not(feature = "Win32_Graphics_Direct3D12"))]
    WriteBufferImmediate: usize,
    #[cfg(feature = "Win32_Graphics_Direct3D12")]
    pub SetProtectedResourceSession: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void),
    #[cfg(not(feature = "Win32_Graphics_Direct3D12"))]
    SetProtectedResourceSession: usize,
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
pub trait ID3D12VideoEncodeCommandList_Impl: super::super::Graphics::Direct3D12::ID3D12CommandList_Impl {
    fn Close(&self) -> windows_core::Result<()>;
    fn Reset(&self, pallocator: windows_core::Ref<'_, super::super::Graphics::Direct3D12::ID3D12CommandAllocator>) -> windows_core::Result<()>;
    fn ClearState(&self);
    fn ResourceBarrier(&self, numbarriers: u32, pbarriers: *const super::super::Graphics::Direct3D12::D3D12_RESOURCE_BARRIER);
    fn DiscardResource(&self, presource: windows_core::Ref<'_, super::super::Graphics::Direct3D12::ID3D12Resource>, pregion: *const super::super::Graphics::Direct3D12::D3D12_DISCARD_REGION);
    fn BeginQuery(&self, pqueryheap: windows_core::Ref<'_, super::super::Graphics::Direct3D12::ID3D12QueryHeap>, r#type: super::super::Graphics::Direct3D12::D3D12_QUERY_TYPE, index: u32);
    fn EndQuery(&self, pqueryheap: windows_core::Ref<'_, super::super::Graphics::Direct3D12::ID3D12QueryHeap>, r#type: super::super::Graphics::Direct3D12::D3D12_QUERY_TYPE, index: u32);
    fn ResolveQueryData(&self, pqueryheap: windows_core::Ref<'_, super::super::Graphics::Direct3D12::ID3D12QueryHeap>, r#type: super::super::Graphics::Direct3D12::D3D12_QUERY_TYPE, startindex: u32, numqueries: u32, pdestinationbuffer: windows_core::Ref<'_, super::super::Graphics::Direct3D12::ID3D12Resource>, aligneddestinationbufferoffset: u64);
    fn SetPredication(&self, pbuffer: windows_core::Ref<'_, super::super::Graphics::Direct3D12::ID3D12Resource>, alignedbufferoffset: u64, operation: super::super::Graphics::Direct3D12::D3D12_PREDICATION_OP);
    fn SetMarker(&self, metadata: u32, pdata: *const core::ffi::c_void, size: u32);
    fn BeginEvent(&self, metadata: u32, pdata: *const core::ffi::c_void, size: u32);
    fn EndEvent(&self);
    fn EstimateMotion(&self, pmotionestimator: windows_core::Ref<'_, ID3D12VideoMotionEstimator>, poutputarguments: *const D3D12_VIDEO_MOTION_ESTIMATOR_OUTPUT, pinputarguments: *const D3D12_VIDEO_MOTION_ESTIMATOR_INPUT);
    fn ResolveMotionVectorHeap(&self, poutputarguments: *const D3D12_RESOLVE_VIDEO_MOTION_VECTOR_HEAP_OUTPUT, pinputarguments: *const D3D12_RESOLVE_VIDEO_MOTION_VECTOR_HEAP_INPUT);
    fn WriteBufferImmediate(&self, count: u32, pparams: *const super::super::Graphics::Direct3D12::D3D12_WRITEBUFFERIMMEDIATE_PARAMETER, pmodes: *const super::super::Graphics::Direct3D12::D3D12_WRITEBUFFERIMMEDIATE_MODE);
    fn SetProtectedResourceSession(&self, pprotectedresourcesession: windows_core::Ref<'_, super::super::Graphics::Direct3D12::ID3D12ProtectedResourceSession>);
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
impl ID3D12VideoEncodeCommandList_Vtbl {
    pub const fn new<Identity: ID3D12VideoEncodeCommandList_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn Close<Identity: ID3D12VideoEncodeCommandList_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoEncodeCommandList_Impl::Close(this).into()
            }
        }
        unsafe extern "system" fn Reset<Identity: ID3D12VideoEncodeCommandList_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pallocator: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoEncodeCommandList_Impl::Reset(this, core::mem::transmute_copy(&pallocator)).into()
            }
        }
        unsafe extern "system" fn ClearState<Identity: ID3D12VideoEncodeCommandList_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoEncodeCommandList_Impl::ClearState(this)
            }
        }
        unsafe extern "system" fn ResourceBarrier<Identity: ID3D12VideoEncodeCommandList_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, numbarriers: u32, pbarriers: *const super::super::Graphics::Direct3D12::D3D12_RESOURCE_BARRIER) {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoEncodeCommandList_Impl::ResourceBarrier(this, core::mem::transmute_copy(&numbarriers), core::mem::transmute_copy(&pbarriers))
            }
        }
        unsafe extern "system" fn DiscardResource<Identity: ID3D12VideoEncodeCommandList_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, presource: *mut core::ffi::c_void, pregion: *const super::super::Graphics::Direct3D12::D3D12_DISCARD_REGION) {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoEncodeCommandList_Impl::DiscardResource(this, core::mem::transmute_copy(&presource), core::mem::transmute_copy(&pregion))
            }
        }
        unsafe extern "system" fn BeginQuery<Identity: ID3D12VideoEncodeCommandList_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pqueryheap: *mut core::ffi::c_void, r#type: super::super::Graphics::Direct3D12::D3D12_QUERY_TYPE, index: u32) {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoEncodeCommandList_Impl::BeginQuery(this, core::mem::transmute_copy(&pqueryheap), core::mem::transmute_copy(&r#type), core::mem::transmute_copy(&index))
            }
        }
        unsafe extern "system" fn EndQuery<Identity: ID3D12VideoEncodeCommandList_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pqueryheap: *mut core::ffi::c_void, r#type: super::super::Graphics::Direct3D12::D3D12_QUERY_TYPE, index: u32) {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoEncodeCommandList_Impl::EndQuery(this, core::mem::transmute_copy(&pqueryheap), core::mem::transmute_copy(&r#type), core::mem::transmute_copy(&index))
            }
        }
        unsafe extern "system" fn ResolveQueryData<Identity: ID3D12VideoEncodeCommandList_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pqueryheap: *mut core::ffi::c_void, r#type: super::super::Graphics::Direct3D12::D3D12_QUERY_TYPE, startindex: u32, numqueries: u32, pdestinationbuffer: *mut core::ffi::c_void, aligneddestinationbufferoffset: u64) {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoEncodeCommandList_Impl::ResolveQueryData(this, core::mem::transmute_copy(&pqueryheap), core::mem::transmute_copy(&r#type), core::mem::transmute_copy(&startindex), core::mem::transmute_copy(&numqueries), core::mem::transmute_copy(&pdestinationbuffer), core::mem::transmute_copy(&aligneddestinationbufferoffset))
            }
        }
        unsafe extern "system" fn SetPredication<Identity: ID3D12VideoEncodeCommandList_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbuffer: *mut core::ffi::c_void, alignedbufferoffset: u64, operation: super::super::Graphics::Direct3D12::D3D12_PREDICATION_OP) {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoEncodeCommandList_Impl::SetPredication(this, core::mem::transmute_copy(&pbuffer), core::mem::transmute_copy(&alignedbufferoffset), core::mem::transmute_copy(&operation))
            }
        }
        unsafe extern "system" fn SetMarker<Identity: ID3D12VideoEncodeCommandList_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, metadata: u32, pdata: *const core::ffi::c_void, size: u32) {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoEncodeCommandList_Impl::SetMarker(this, core::mem::transmute_copy(&metadata), core::mem::transmute_copy(&pdata), core::mem::transmute_copy(&size))
            }
        }
        unsafe extern "system" fn BeginEvent<Identity: ID3D12VideoEncodeCommandList_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, metadata: u32, pdata: *const core::ffi::c_void, size: u32) {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoEncodeCommandList_Impl::BeginEvent(this, core::mem::transmute_copy(&metadata), core::mem::transmute_copy(&pdata), core::mem::transmute_copy(&size))
            }
        }
        unsafe extern "system" fn EndEvent<Identity: ID3D12VideoEncodeCommandList_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoEncodeCommandList_Impl::EndEvent(this)
            }
        }
        unsafe extern "system" fn EstimateMotion<Identity: ID3D12VideoEncodeCommandList_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pmotionestimator: *mut core::ffi::c_void, poutputarguments: *const D3D12_VIDEO_MOTION_ESTIMATOR_OUTPUT, pinputarguments: *const D3D12_VIDEO_MOTION_ESTIMATOR_INPUT) {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoEncodeCommandList_Impl::EstimateMotion(this, core::mem::transmute_copy(&pmotionestimator), core::mem::transmute_copy(&poutputarguments), core::mem::transmute_copy(&pinputarguments))
            }
        }
        unsafe extern "system" fn ResolveMotionVectorHeap<Identity: ID3D12VideoEncodeCommandList_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, poutputarguments: *const D3D12_RESOLVE_VIDEO_MOTION_VECTOR_HEAP_OUTPUT, pinputarguments: *const D3D12_RESOLVE_VIDEO_MOTION_VECTOR_HEAP_INPUT) {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoEncodeCommandList_Impl::ResolveMotionVectorHeap(this, core::mem::transmute_copy(&poutputarguments), core::mem::transmute_copy(&pinputarguments))
            }
        }
        unsafe extern "system" fn WriteBufferImmediate<Identity: ID3D12VideoEncodeCommandList_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, count: u32, pparams: *const super::super::Graphics::Direct3D12::D3D12_WRITEBUFFERIMMEDIATE_PARAMETER, pmodes: *const super::super::Graphics::Direct3D12::D3D12_WRITEBUFFERIMMEDIATE_MODE) {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoEncodeCommandList_Impl::WriteBufferImmediate(this, core::mem::transmute_copy(&count), core::mem::transmute_copy(&pparams), core::mem::transmute_copy(&pmodes))
            }
        }
        unsafe extern "system" fn SetProtectedResourceSession<Identity: ID3D12VideoEncodeCommandList_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pprotectedresourcesession: *mut core::ffi::c_void) {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoEncodeCommandList_Impl::SetProtectedResourceSession(this, core::mem::transmute_copy(&pprotectedresourcesession))
            }
        }
        Self {
            base__: super::super::Graphics::Direct3D12::ID3D12CommandList_Vtbl::new::<Identity, OFFSET>(),
            Close: Close::<Identity, OFFSET>,
            Reset: Reset::<Identity, OFFSET>,
            ClearState: ClearState::<Identity, OFFSET>,
            ResourceBarrier: ResourceBarrier::<Identity, OFFSET>,
            DiscardResource: DiscardResource::<Identity, OFFSET>,
            BeginQuery: BeginQuery::<Identity, OFFSET>,
            EndQuery: EndQuery::<Identity, OFFSET>,
            ResolveQueryData: ResolveQueryData::<Identity, OFFSET>,
            SetPredication: SetPredication::<Identity, OFFSET>,
            SetMarker: SetMarker::<Identity, OFFSET>,
            BeginEvent: BeginEvent::<Identity, OFFSET>,
            EndEvent: EndEvent::<Identity, OFFSET>,
            EstimateMotion: EstimateMotion::<Identity, OFFSET>,
            ResolveMotionVectorHeap: ResolveMotionVectorHeap::<Identity, OFFSET>,
            WriteBufferImmediate: WriteBufferImmediate::<Identity, OFFSET>,
            SetProtectedResourceSession: SetProtectedResourceSession::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<ID3D12VideoEncodeCommandList as windows_core::Interface>::IID || iid == &<super::super::Graphics::Direct3D12::ID3D12Object as windows_core::Interface>::IID || iid == &<super::super::Graphics::Direct3D12::ID3D12DeviceChild as windows_core::Interface>::IID || iid == &<super::super::Graphics::Direct3D12::ID3D12CommandList as windows_core::Interface>::IID
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
impl windows_core::RuntimeName for ID3D12VideoEncodeCommandList {}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
unsafe impl Send for ID3D12VideoEncodeCommandList {}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
unsafe impl Sync for ID3D12VideoEncodeCommandList {}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
windows_core::imp::define_interface!(ID3D12VideoEncodeCommandList1, ID3D12VideoEncodeCommandList1_Vtbl, 0x94971eca_2bdb_4769_88cf_3675ea757ebc);
#[cfg(feature = "Win32_Graphics_Direct3D12")]
impl core::ops::Deref for ID3D12VideoEncodeCommandList1 {
    type Target = ID3D12VideoEncodeCommandList;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
windows_core::imp::interface_hierarchy!(ID3D12VideoEncodeCommandList1, windows_core::IUnknown, super::super::Graphics::Direct3D12::ID3D12Object, super::super::Graphics::Direct3D12::ID3D12DeviceChild, super::super::Graphics::Direct3D12::ID3D12CommandList, ID3D12VideoEncodeCommandList);
#[cfg(feature = "Win32_Graphics_Direct3D12")]
impl ID3D12VideoEncodeCommandList1 {
    #[cfg(feature = "Win32_Graphics_Direct3D12")]
    pub unsafe fn InitializeExtensionCommand<P0>(&self, pextensioncommand: P0, pinitializationparameters: *const core::ffi::c_void, initializationparameterssizeinbytes: usize)
    where
        P0: windows_core::Param<ID3D12VideoExtensionCommand>,
    {
        unsafe { (windows_core::Interface::vtable(self).InitializeExtensionCommand)(windows_core::Interface::as_raw(self), pextensioncommand.param().abi(), pinitializationparameters, initializationparameterssizeinbytes) }
    }
    #[cfg(feature = "Win32_Graphics_Direct3D12")]
    pub unsafe fn ExecuteExtensionCommand<P0>(&self, pextensioncommand: P0, pexecutionparameters: *const core::ffi::c_void, executionparameterssizeinbytes: usize)
    where
        P0: windows_core::Param<ID3D12VideoExtensionCommand>,
    {
        unsafe { (windows_core::Interface::vtable(self).ExecuteExtensionCommand)(windows_core::Interface::as_raw(self), pextensioncommand.param().abi(), pexecutionparameters, executionparameterssizeinbytes) }
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
#[repr(C)]
pub struct ID3D12VideoEncodeCommandList1_Vtbl {
    pub base__: ID3D12VideoEncodeCommandList_Vtbl,
    #[cfg(feature = "Win32_Graphics_Direct3D12")]
    pub InitializeExtensionCommand: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *const core::ffi::c_void, usize),
    #[cfg(not(feature = "Win32_Graphics_Direct3D12"))]
    InitializeExtensionCommand: usize,
    #[cfg(feature = "Win32_Graphics_Direct3D12")]
    pub ExecuteExtensionCommand: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *const core::ffi::c_void, usize),
    #[cfg(not(feature = "Win32_Graphics_Direct3D12"))]
    ExecuteExtensionCommand: usize,
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
pub trait ID3D12VideoEncodeCommandList1_Impl: ID3D12VideoEncodeCommandList_Impl {
    fn InitializeExtensionCommand(&self, pextensioncommand: windows_core::Ref<'_, ID3D12VideoExtensionCommand>, pinitializationparameters: *const core::ffi::c_void, initializationparameterssizeinbytes: usize);
    fn ExecuteExtensionCommand(&self, pextensioncommand: windows_core::Ref<'_, ID3D12VideoExtensionCommand>, pexecutionparameters: *const core::ffi::c_void, executionparameterssizeinbytes: usize);
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
impl ID3D12VideoEncodeCommandList1_Vtbl {
    pub const fn new<Identity: ID3D12VideoEncodeCommandList1_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn InitializeExtensionCommand<Identity: ID3D12VideoEncodeCommandList1_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pextensioncommand: *mut core::ffi::c_void, pinitializationparameters: *const core::ffi::c_void, initializationparameterssizeinbytes: usize) {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoEncodeCommandList1_Impl::InitializeExtensionCommand(this, core::mem::transmute_copy(&pextensioncommand), core::mem::transmute_copy(&pinitializationparameters), core::mem::transmute_copy(&initializationparameterssizeinbytes))
            }
        }
        unsafe extern "system" fn ExecuteExtensionCommand<Identity: ID3D12VideoEncodeCommandList1_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pextensioncommand: *mut core::ffi::c_void, pexecutionparameters: *const core::ffi::c_void, executionparameterssizeinbytes: usize) {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoEncodeCommandList1_Impl::ExecuteExtensionCommand(this, core::mem::transmute_copy(&pextensioncommand), core::mem::transmute_copy(&pexecutionparameters), core::mem::transmute_copy(&executionparameterssizeinbytes))
            }
        }
        Self {
            base__: ID3D12VideoEncodeCommandList_Vtbl::new::<Identity, OFFSET>(),
            InitializeExtensionCommand: InitializeExtensionCommand::<Identity, OFFSET>,
            ExecuteExtensionCommand: ExecuteExtensionCommand::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<ID3D12VideoEncodeCommandList1 as windows_core::Interface>::IID || iid == &<super::super::Graphics::Direct3D12::ID3D12Object as windows_core::Interface>::IID || iid == &<super::super::Graphics::Direct3D12::ID3D12DeviceChild as windows_core::Interface>::IID || iid == &<super::super::Graphics::Direct3D12::ID3D12CommandList as windows_core::Interface>::IID || iid == &<ID3D12VideoEncodeCommandList as windows_core::Interface>::IID
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
impl windows_core::RuntimeName for ID3D12VideoEncodeCommandList1 {}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
unsafe impl Send for ID3D12VideoEncodeCommandList1 {}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
unsafe impl Sync for ID3D12VideoEncodeCommandList1 {}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
windows_core::imp::define_interface!(ID3D12VideoEncodeCommandList2, ID3D12VideoEncodeCommandList2_Vtbl, 0x895491e2_e701_46a9_9a1f_8d3480ed867a);
#[cfg(feature = "Win32_Graphics_Direct3D12")]
impl core::ops::Deref for ID3D12VideoEncodeCommandList2 {
    type Target = ID3D12VideoEncodeCommandList1;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
windows_core::imp::interface_hierarchy!(ID3D12VideoEncodeCommandList2, windows_core::IUnknown, super::super::Graphics::Direct3D12::ID3D12Object, super::super::Graphics::Direct3D12::ID3D12DeviceChild, super::super::Graphics::Direct3D12::ID3D12CommandList, ID3D12VideoEncodeCommandList, ID3D12VideoEncodeCommandList1);
#[cfg(feature = "Win32_Graphics_Direct3D12")]
impl ID3D12VideoEncodeCommandList2 {
    #[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
    pub unsafe fn EncodeFrame<P0, P1>(&self, pencoder: P0, pheap: P1, pinputarguments: *const D3D12_VIDEO_ENCODER_ENCODEFRAME_INPUT_ARGUMENTS, poutputarguments: *const D3D12_VIDEO_ENCODER_ENCODEFRAME_OUTPUT_ARGUMENTS)
    where
        P0: windows_core::Param<ID3D12VideoEncoder>,
        P1: windows_core::Param<ID3D12VideoEncoderHeap>,
    {
        unsafe { (windows_core::Interface::vtable(self).EncodeFrame)(windows_core::Interface::as_raw(self), pencoder.param().abi(), pheap.param().abi(), core::mem::transmute(pinputarguments), core::mem::transmute(poutputarguments)) }
    }
    #[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
    pub unsafe fn ResolveEncoderOutputMetadata(&self, pinputarguments: *const D3D12_VIDEO_ENCODER_RESOLVE_METADATA_INPUT_ARGUMENTS, poutputarguments: *const D3D12_VIDEO_ENCODER_RESOLVE_METADATA_OUTPUT_ARGUMENTS) {
        unsafe { (windows_core::Interface::vtable(self).ResolveEncoderOutputMetadata)(windows_core::Interface::as_raw(self), core::mem::transmute(pinputarguments), core::mem::transmute(poutputarguments)) }
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
#[repr(C)]
pub struct ID3D12VideoEncodeCommandList2_Vtbl {
    pub base__: ID3D12VideoEncodeCommandList1_Vtbl,
    #[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
    pub EncodeFrame: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut core::ffi::c_void, *const D3D12_VIDEO_ENCODER_ENCODEFRAME_INPUT_ARGUMENTS, *const D3D12_VIDEO_ENCODER_ENCODEFRAME_OUTPUT_ARGUMENTS),
    #[cfg(not(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common")))]
    EncodeFrame: usize,
    #[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
    pub ResolveEncoderOutputMetadata: unsafe extern "system" fn(*mut core::ffi::c_void, *const D3D12_VIDEO_ENCODER_RESOLVE_METADATA_INPUT_ARGUMENTS, *const D3D12_VIDEO_ENCODER_RESOLVE_METADATA_OUTPUT_ARGUMENTS),
    #[cfg(not(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common")))]
    ResolveEncoderOutputMetadata: usize,
}
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
pub trait ID3D12VideoEncodeCommandList2_Impl: ID3D12VideoEncodeCommandList1_Impl {
    fn EncodeFrame(&self, pencoder: windows_core::Ref<'_, ID3D12VideoEncoder>, pheap: windows_core::Ref<'_, ID3D12VideoEncoderHeap>, pinputarguments: *const D3D12_VIDEO_ENCODER_ENCODEFRAME_INPUT_ARGUMENTS, poutputarguments: *const D3D12_VIDEO_ENCODER_ENCODEFRAME_OUTPUT_ARGUMENTS);
    fn ResolveEncoderOutputMetadata(&self, pinputarguments: *const D3D12_VIDEO_ENCODER_RESOLVE_METADATA_INPUT_ARGUMENTS, poutputarguments: *const D3D12_VIDEO_ENCODER_RESOLVE_METADATA_OUTPUT_ARGUMENTS);
}
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
impl ID3D12VideoEncodeCommandList2_Vtbl {
    pub const fn new<Identity: ID3D12VideoEncodeCommandList2_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn EncodeFrame<Identity: ID3D12VideoEncodeCommandList2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pencoder: *mut core::ffi::c_void, pheap: *mut core::ffi::c_void, pinputarguments: *const D3D12_VIDEO_ENCODER_ENCODEFRAME_INPUT_ARGUMENTS, poutputarguments: *const D3D12_VIDEO_ENCODER_ENCODEFRAME_OUTPUT_ARGUMENTS) {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoEncodeCommandList2_Impl::EncodeFrame(this, core::mem::transmute_copy(&pencoder), core::mem::transmute_copy(&pheap), core::mem::transmute_copy(&pinputarguments), core::mem::transmute_copy(&poutputarguments))
            }
        }
        unsafe extern "system" fn ResolveEncoderOutputMetadata<Identity: ID3D12VideoEncodeCommandList2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pinputarguments: *const D3D12_VIDEO_ENCODER_RESOLVE_METADATA_INPUT_ARGUMENTS, poutputarguments: *const D3D12_VIDEO_ENCODER_RESOLVE_METADATA_OUTPUT_ARGUMENTS) {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoEncodeCommandList2_Impl::ResolveEncoderOutputMetadata(this, core::mem::transmute_copy(&pinputarguments), core::mem::transmute_copy(&poutputarguments))
            }
        }
        Self {
            base__: ID3D12VideoEncodeCommandList1_Vtbl::new::<Identity, OFFSET>(),
            EncodeFrame: EncodeFrame::<Identity, OFFSET>,
            ResolveEncoderOutputMetadata: ResolveEncoderOutputMetadata::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<ID3D12VideoEncodeCommandList2 as windows_core::Interface>::IID || iid == &<super::super::Graphics::Direct3D12::ID3D12Object as windows_core::Interface>::IID || iid == &<super::super::Graphics::Direct3D12::ID3D12DeviceChild as windows_core::Interface>::IID || iid == &<super::super::Graphics::Direct3D12::ID3D12CommandList as windows_core::Interface>::IID || iid == &<ID3D12VideoEncodeCommandList as windows_core::Interface>::IID || iid == &<ID3D12VideoEncodeCommandList1 as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
impl windows_core::RuntimeName for ID3D12VideoEncodeCommandList2 {}
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
unsafe impl Send for ID3D12VideoEncodeCommandList2 {}
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
unsafe impl Sync for ID3D12VideoEncodeCommandList2 {}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
windows_core::imp::define_interface!(ID3D12VideoEncodeCommandList3, ID3D12VideoEncodeCommandList3_Vtbl, 0x7f027b22_1515_4e85_aa0d_026486580576);
#[cfg(feature = "Win32_Graphics_Direct3D12")]
impl core::ops::Deref for ID3D12VideoEncodeCommandList3 {
    type Target = ID3D12VideoEncodeCommandList2;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
windows_core::imp::interface_hierarchy!(ID3D12VideoEncodeCommandList3, windows_core::IUnknown, super::super::Graphics::Direct3D12::ID3D12Object, super::super::Graphics::Direct3D12::ID3D12DeviceChild, super::super::Graphics::Direct3D12::ID3D12CommandList, ID3D12VideoEncodeCommandList, ID3D12VideoEncodeCommandList1, ID3D12VideoEncodeCommandList2);
#[cfg(feature = "Win32_Graphics_Direct3D12")]
impl ID3D12VideoEncodeCommandList3 {
    #[cfg(feature = "Win32_Graphics_Direct3D12")]
    pub unsafe fn Barrier(&self, pbarriergroups: &[super::super::Graphics::Direct3D12::D3D12_BARRIER_GROUP]) {
        unsafe { (windows_core::Interface::vtable(self).Barrier)(windows_core::Interface::as_raw(self), pbarriergroups.len().try_into().unwrap(), core::mem::transmute(pbarriergroups.as_ptr())) }
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
#[repr(C)]
pub struct ID3D12VideoEncodeCommandList3_Vtbl {
    pub base__: ID3D12VideoEncodeCommandList2_Vtbl,
    #[cfg(feature = "Win32_Graphics_Direct3D12")]
    pub Barrier: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const super::super::Graphics::Direct3D12::D3D12_BARRIER_GROUP),
    #[cfg(not(feature = "Win32_Graphics_Direct3D12"))]
    Barrier: usize,
}
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
pub trait ID3D12VideoEncodeCommandList3_Impl: ID3D12VideoEncodeCommandList2_Impl {
    fn Barrier(&self, numbarriergroups: u32, pbarriergroups: *const super::super::Graphics::Direct3D12::D3D12_BARRIER_GROUP);
}
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
impl ID3D12VideoEncodeCommandList3_Vtbl {
    pub const fn new<Identity: ID3D12VideoEncodeCommandList3_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn Barrier<Identity: ID3D12VideoEncodeCommandList3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, numbarriergroups: u32, pbarriergroups: *const super::super::Graphics::Direct3D12::D3D12_BARRIER_GROUP) {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoEncodeCommandList3_Impl::Barrier(this, core::mem::transmute_copy(&numbarriergroups), core::mem::transmute_copy(&pbarriergroups))
            }
        }
        Self { base__: ID3D12VideoEncodeCommandList2_Vtbl::new::<Identity, OFFSET>(), Barrier: Barrier::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<ID3D12VideoEncodeCommandList3 as windows_core::Interface>::IID || iid == &<super::super::Graphics::Direct3D12::ID3D12Object as windows_core::Interface>::IID || iid == &<super::super::Graphics::Direct3D12::ID3D12DeviceChild as windows_core::Interface>::IID || iid == &<super::super::Graphics::Direct3D12::ID3D12CommandList as windows_core::Interface>::IID || iid == &<ID3D12VideoEncodeCommandList as windows_core::Interface>::IID || iid == &<ID3D12VideoEncodeCommandList1 as windows_core::Interface>::IID || iid == &<ID3D12VideoEncodeCommandList2 as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
impl windows_core::RuntimeName for ID3D12VideoEncodeCommandList3 {}
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
unsafe impl Send for ID3D12VideoEncodeCommandList3 {}
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
unsafe impl Sync for ID3D12VideoEncodeCommandList3 {}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
windows_core::imp::define_interface!(ID3D12VideoEncoder, ID3D12VideoEncoder_Vtbl, 0x2e0d212d_8df9_44a6_a770_bb289b182737);
#[cfg(feature = "Win32_Graphics_Direct3D12")]
impl core::ops::Deref for ID3D12VideoEncoder {
    type Target = super::super::Graphics::Direct3D12::ID3D12Pageable;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
windows_core::imp::interface_hierarchy!(ID3D12VideoEncoder, windows_core::IUnknown, super::super::Graphics::Direct3D12::ID3D12Object, super::super::Graphics::Direct3D12::ID3D12DeviceChild, super::super::Graphics::Direct3D12::ID3D12Pageable);
#[cfg(feature = "Win32_Graphics_Direct3D12")]
impl ID3D12VideoEncoder {
    pub unsafe fn GetNodeMask(&self) -> u32 {
        unsafe { (windows_core::Interface::vtable(self).GetNodeMask)(windows_core::Interface::as_raw(self)) }
    }
    pub unsafe fn GetEncoderFlags(&self) -> D3D12_VIDEO_ENCODER_FLAGS {
        unsafe { (windows_core::Interface::vtable(self).GetEncoderFlags)(windows_core::Interface::as_raw(self)) }
    }
    pub unsafe fn GetCodec(&self) -> D3D12_VIDEO_ENCODER_CODEC {
        unsafe { (windows_core::Interface::vtable(self).GetCodec)(windows_core::Interface::as_raw(self)) }
    }
    pub unsafe fn GetCodecProfile(&self, dstprofile: D3D12_VIDEO_ENCODER_PROFILE_DESC) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetCodecProfile)(windows_core::Interface::as_raw(self), core::mem::transmute(dstprofile)).ok() }
    }
    pub unsafe fn GetCodecConfiguration(&self, dstcodecconfig: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetCodecConfiguration)(windows_core::Interface::as_raw(self), core::mem::transmute(dstcodecconfig)).ok() }
    }
    #[cfg(feature = "Win32_Graphics_Dxgi_Common")]
    pub unsafe fn GetInputFormat(&self) -> super::super::Graphics::Dxgi::Common::DXGI_FORMAT {
        unsafe { (windows_core::Interface::vtable(self).GetInputFormat)(windows_core::Interface::as_raw(self)) }
    }
    pub unsafe fn GetMaxMotionEstimationPrecision(&self) -> D3D12_VIDEO_ENCODER_MOTION_ESTIMATION_PRECISION_MODE {
        unsafe { (windows_core::Interface::vtable(self).GetMaxMotionEstimationPrecision)(windows_core::Interface::as_raw(self)) }
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
#[repr(C)]
pub struct ID3D12VideoEncoder_Vtbl {
    pub base__: super::super::Graphics::Direct3D12::ID3D12Pageable_Vtbl,
    pub GetNodeMask: unsafe extern "system" fn(*mut core::ffi::c_void) -> u32,
    pub GetEncoderFlags: unsafe extern "system" fn(*mut core::ffi::c_void) -> D3D12_VIDEO_ENCODER_FLAGS,
    pub GetCodec: unsafe extern "system" fn(*mut core::ffi::c_void) -> D3D12_VIDEO_ENCODER_CODEC,
    pub GetCodecProfile: unsafe extern "system" fn(*mut core::ffi::c_void, D3D12_VIDEO_ENCODER_PROFILE_DESC) -> windows_core::HRESULT,
    pub GetCodecConfiguration: unsafe extern "system" fn(*mut core::ffi::c_void, D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_Graphics_Dxgi_Common")]
    pub GetInputFormat: unsafe extern "system" fn(*mut core::ffi::c_void) -> super::super::Graphics::Dxgi::Common::DXGI_FORMAT,
    #[cfg(not(feature = "Win32_Graphics_Dxgi_Common"))]
    GetInputFormat: usize,
    pub GetMaxMotionEstimationPrecision: unsafe extern "system" fn(*mut core::ffi::c_void) -> D3D12_VIDEO_ENCODER_MOTION_ESTIMATION_PRECISION_MODE,
}
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
pub trait ID3D12VideoEncoder_Impl: super::super::Graphics::Direct3D12::ID3D12Pageable_Impl {
    fn GetNodeMask(&self) -> u32;
    fn GetEncoderFlags(&self) -> D3D12_VIDEO_ENCODER_FLAGS;
    fn GetCodec(&self) -> D3D12_VIDEO_ENCODER_CODEC;
    fn GetCodecProfile(&self, dstprofile: &D3D12_VIDEO_ENCODER_PROFILE_DESC) -> windows_core::Result<()>;
    fn GetCodecConfiguration(&self, dstcodecconfig: &D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION) -> windows_core::Result<()>;
    fn GetInputFormat(&self) -> super::super::Graphics::Dxgi::Common::DXGI_FORMAT;
    fn GetMaxMotionEstimationPrecision(&self) -> D3D12_VIDEO_ENCODER_MOTION_ESTIMATION_PRECISION_MODE;
}
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
impl ID3D12VideoEncoder_Vtbl {
    pub const fn new<Identity: ID3D12VideoEncoder_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetNodeMask<Identity: ID3D12VideoEncoder_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> u32 {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoEncoder_Impl::GetNodeMask(this)
            }
        }
        unsafe extern "system" fn GetEncoderFlags<Identity: ID3D12VideoEncoder_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> D3D12_VIDEO_ENCODER_FLAGS {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoEncoder_Impl::GetEncoderFlags(this)
            }
        }
        unsafe extern "system" fn GetCodec<Identity: ID3D12VideoEncoder_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> D3D12_VIDEO_ENCODER_CODEC {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoEncoder_Impl::GetCodec(this)
            }
        }
        unsafe extern "system" fn GetCodecProfile<Identity: ID3D12VideoEncoder_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dstprofile: D3D12_VIDEO_ENCODER_PROFILE_DESC) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoEncoder_Impl::GetCodecProfile(this, core::mem::transmute(&dstprofile)).into()
            }
        }
        unsafe extern "system" fn GetCodecConfiguration<Identity: ID3D12VideoEncoder_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dstcodecconfig: D3D12_VIDEO_ENCODER_CODEC_CONFIGURATION) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoEncoder_Impl::GetCodecConfiguration(this, core::mem::transmute(&dstcodecconfig)).into()
            }
        }
        unsafe extern "system" fn GetInputFormat<Identity: ID3D12VideoEncoder_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> super::super::Graphics::Dxgi::Common::DXGI_FORMAT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoEncoder_Impl::GetInputFormat(this)
            }
        }
        unsafe extern "system" fn GetMaxMotionEstimationPrecision<Identity: ID3D12VideoEncoder_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> D3D12_VIDEO_ENCODER_MOTION_ESTIMATION_PRECISION_MODE {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoEncoder_Impl::GetMaxMotionEstimationPrecision(this)
            }
        }
        Self {
            base__: super::super::Graphics::Direct3D12::ID3D12Pageable_Vtbl::new::<Identity, OFFSET>(),
            GetNodeMask: GetNodeMask::<Identity, OFFSET>,
            GetEncoderFlags: GetEncoderFlags::<Identity, OFFSET>,
            GetCodec: GetCodec::<Identity, OFFSET>,
            GetCodecProfile: GetCodecProfile::<Identity, OFFSET>,
            GetCodecConfiguration: GetCodecConfiguration::<Identity, OFFSET>,
            GetInputFormat: GetInputFormat::<Identity, OFFSET>,
            GetMaxMotionEstimationPrecision: GetMaxMotionEstimationPrecision::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<ID3D12VideoEncoder as windows_core::Interface>::IID || iid == &<super::super::Graphics::Direct3D12::ID3D12Object as windows_core::Interface>::IID || iid == &<super::super::Graphics::Direct3D12::ID3D12DeviceChild as windows_core::Interface>::IID || iid == &<super::super::Graphics::Direct3D12::ID3D12Pageable as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
impl windows_core::RuntimeName for ID3D12VideoEncoder {}
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
unsafe impl Send for ID3D12VideoEncoder {}
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
unsafe impl Sync for ID3D12VideoEncoder {}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
windows_core::imp::define_interface!(ID3D12VideoEncoderHeap, ID3D12VideoEncoderHeap_Vtbl, 0x22b35d96_876a_44c0_b25e_fb8c9c7f1c4a);
#[cfg(feature = "Win32_Graphics_Direct3D12")]
impl core::ops::Deref for ID3D12VideoEncoderHeap {
    type Target = super::super::Graphics::Direct3D12::ID3D12Pageable;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
windows_core::imp::interface_hierarchy!(ID3D12VideoEncoderHeap, windows_core::IUnknown, super::super::Graphics::Direct3D12::ID3D12Object, super::super::Graphics::Direct3D12::ID3D12DeviceChild, super::super::Graphics::Direct3D12::ID3D12Pageable);
#[cfg(feature = "Win32_Graphics_Direct3D12")]
impl ID3D12VideoEncoderHeap {
    pub unsafe fn GetNodeMask(&self) -> u32 {
        unsafe { (windows_core::Interface::vtable(self).GetNodeMask)(windows_core::Interface::as_raw(self)) }
    }
    pub unsafe fn GetEncoderHeapFlags(&self) -> D3D12_VIDEO_ENCODER_HEAP_FLAGS {
        unsafe { (windows_core::Interface::vtable(self).GetEncoderHeapFlags)(windows_core::Interface::as_raw(self)) }
    }
    pub unsafe fn GetCodec(&self) -> D3D12_VIDEO_ENCODER_CODEC {
        unsafe { (windows_core::Interface::vtable(self).GetCodec)(windows_core::Interface::as_raw(self)) }
    }
    pub unsafe fn GetCodecProfile(&self, dstprofile: D3D12_VIDEO_ENCODER_PROFILE_DESC) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetCodecProfile)(windows_core::Interface::as_raw(self), core::mem::transmute(dstprofile)).ok() }
    }
    pub unsafe fn GetCodecLevel(&self, dstlevel: D3D12_VIDEO_ENCODER_LEVEL_SETTING) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetCodecLevel)(windows_core::Interface::as_raw(self), core::mem::transmute(dstlevel)).ok() }
    }
    pub unsafe fn GetResolutionListCount(&self) -> u32 {
        unsafe { (windows_core::Interface::vtable(self).GetResolutionListCount)(windows_core::Interface::as_raw(self)) }
    }
    pub unsafe fn GetResolutionList(&self, presolutionlist: &mut [D3D12_VIDEO_ENCODER_PICTURE_RESOLUTION_DESC]) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetResolutionList)(windows_core::Interface::as_raw(self), presolutionlist.len().try_into().unwrap(), core::mem::transmute(presolutionlist.as_ptr())).ok() }
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
#[repr(C)]
pub struct ID3D12VideoEncoderHeap_Vtbl {
    pub base__: super::super::Graphics::Direct3D12::ID3D12Pageable_Vtbl,
    pub GetNodeMask: unsafe extern "system" fn(*mut core::ffi::c_void) -> u32,
    pub GetEncoderHeapFlags: unsafe extern "system" fn(*mut core::ffi::c_void) -> D3D12_VIDEO_ENCODER_HEAP_FLAGS,
    pub GetCodec: unsafe extern "system" fn(*mut core::ffi::c_void) -> D3D12_VIDEO_ENCODER_CODEC,
    pub GetCodecProfile: unsafe extern "system" fn(*mut core::ffi::c_void, D3D12_VIDEO_ENCODER_PROFILE_DESC) -> windows_core::HRESULT,
    pub GetCodecLevel: unsafe extern "system" fn(*mut core::ffi::c_void, D3D12_VIDEO_ENCODER_LEVEL_SETTING) -> windows_core::HRESULT,
    pub GetResolutionListCount: unsafe extern "system" fn(*mut core::ffi::c_void) -> u32,
    pub GetResolutionList: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut D3D12_VIDEO_ENCODER_PICTURE_RESOLUTION_DESC) -> windows_core::HRESULT,
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
pub trait ID3D12VideoEncoderHeap_Impl: super::super::Graphics::Direct3D12::ID3D12Pageable_Impl {
    fn GetNodeMask(&self) -> u32;
    fn GetEncoderHeapFlags(&self) -> D3D12_VIDEO_ENCODER_HEAP_FLAGS;
    fn GetCodec(&self) -> D3D12_VIDEO_ENCODER_CODEC;
    fn GetCodecProfile(&self, dstprofile: &D3D12_VIDEO_ENCODER_PROFILE_DESC) -> windows_core::Result<()>;
    fn GetCodecLevel(&self, dstlevel: &D3D12_VIDEO_ENCODER_LEVEL_SETTING) -> windows_core::Result<()>;
    fn GetResolutionListCount(&self) -> u32;
    fn GetResolutionList(&self, resolutionslistcount: u32, presolutionlist: *mut D3D12_VIDEO_ENCODER_PICTURE_RESOLUTION_DESC) -> windows_core::Result<()>;
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
impl ID3D12VideoEncoderHeap_Vtbl {
    pub const fn new<Identity: ID3D12VideoEncoderHeap_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetNodeMask<Identity: ID3D12VideoEncoderHeap_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> u32 {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoEncoderHeap_Impl::GetNodeMask(this)
            }
        }
        unsafe extern "system" fn GetEncoderHeapFlags<Identity: ID3D12VideoEncoderHeap_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> D3D12_VIDEO_ENCODER_HEAP_FLAGS {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoEncoderHeap_Impl::GetEncoderHeapFlags(this)
            }
        }
        unsafe extern "system" fn GetCodec<Identity: ID3D12VideoEncoderHeap_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> D3D12_VIDEO_ENCODER_CODEC {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoEncoderHeap_Impl::GetCodec(this)
            }
        }
        unsafe extern "system" fn GetCodecProfile<Identity: ID3D12VideoEncoderHeap_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dstprofile: D3D12_VIDEO_ENCODER_PROFILE_DESC) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoEncoderHeap_Impl::GetCodecProfile(this, core::mem::transmute(&dstprofile)).into()
            }
        }
        unsafe extern "system" fn GetCodecLevel<Identity: ID3D12VideoEncoderHeap_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dstlevel: D3D12_VIDEO_ENCODER_LEVEL_SETTING) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoEncoderHeap_Impl::GetCodecLevel(this, core::mem::transmute(&dstlevel)).into()
            }
        }
        unsafe extern "system" fn GetResolutionListCount<Identity: ID3D12VideoEncoderHeap_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> u32 {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoEncoderHeap_Impl::GetResolutionListCount(this)
            }
        }
        unsafe extern "system" fn GetResolutionList<Identity: ID3D12VideoEncoderHeap_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, resolutionslistcount: u32, presolutionlist: *mut D3D12_VIDEO_ENCODER_PICTURE_RESOLUTION_DESC) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoEncoderHeap_Impl::GetResolutionList(this, core::mem::transmute_copy(&resolutionslistcount), core::mem::transmute_copy(&presolutionlist)).into()
            }
        }
        Self {
            base__: super::super::Graphics::Direct3D12::ID3D12Pageable_Vtbl::new::<Identity, OFFSET>(),
            GetNodeMask: GetNodeMask::<Identity, OFFSET>,
            GetEncoderHeapFlags: GetEncoderHeapFlags::<Identity, OFFSET>,
            GetCodec: GetCodec::<Identity, OFFSET>,
            GetCodecProfile: GetCodecProfile::<Identity, OFFSET>,
            GetCodecLevel: GetCodecLevel::<Identity, OFFSET>,
            GetResolutionListCount: GetResolutionListCount::<Identity, OFFSET>,
            GetResolutionList: GetResolutionList::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<ID3D12VideoEncoderHeap as windows_core::Interface>::IID || iid == &<super::super::Graphics::Direct3D12::ID3D12Object as windows_core::Interface>::IID || iid == &<super::super::Graphics::Direct3D12::ID3D12DeviceChild as windows_core::Interface>::IID || iid == &<super::super::Graphics::Direct3D12::ID3D12Pageable as windows_core::Interface>::IID
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
impl windows_core::RuntimeName for ID3D12VideoEncoderHeap {}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
unsafe impl Send for ID3D12VideoEncoderHeap {}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
unsafe impl Sync for ID3D12VideoEncoderHeap {}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
windows_core::imp::define_interface!(ID3D12VideoExtensionCommand, ID3D12VideoExtensionCommand_Vtbl, 0x554e41e8_ae8e_4a8c_b7d2_5b4f274a30e4);
#[cfg(feature = "Win32_Graphics_Direct3D12")]
impl core::ops::Deref for ID3D12VideoExtensionCommand {
    type Target = super::super::Graphics::Direct3D12::ID3D12Pageable;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
windows_core::imp::interface_hierarchy!(ID3D12VideoExtensionCommand, windows_core::IUnknown, super::super::Graphics::Direct3D12::ID3D12Object, super::super::Graphics::Direct3D12::ID3D12DeviceChild, super::super::Graphics::Direct3D12::ID3D12Pageable);
#[cfg(feature = "Win32_Graphics_Direct3D12")]
impl ID3D12VideoExtensionCommand {
    pub unsafe fn GetDesc(&self) -> D3D12_VIDEO_EXTENSION_COMMAND_DESC {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetDesc)(windows_core::Interface::as_raw(self), &mut result__);
            result__
        }
    }
    pub unsafe fn GetProtectedResourceSession<T>(&self, result__: *mut Option<T>) -> windows_core::Result<()>
    where
        T: windows_core::Interface,
    {
        unsafe { (windows_core::Interface::vtable(self).GetProtectedResourceSession)(windows_core::Interface::as_raw(self), &T::IID, result__ as *mut _ as *mut _).ok() }
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
#[repr(C)]
pub struct ID3D12VideoExtensionCommand_Vtbl {
    pub base__: super::super::Graphics::Direct3D12::ID3D12Pageable_Vtbl,
    pub GetDesc: unsafe extern "system" fn(*mut core::ffi::c_void, *mut D3D12_VIDEO_EXTENSION_COMMAND_DESC),
    pub GetProtectedResourceSession: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
pub trait ID3D12VideoExtensionCommand_Impl: super::super::Graphics::Direct3D12::ID3D12Pageable_Impl {
    fn GetDesc(&self) -> D3D12_VIDEO_EXTENSION_COMMAND_DESC;
    fn GetProtectedResourceSession(&self, riid: *const windows_core::GUID, ppprotectedsession: *mut *mut core::ffi::c_void) -> windows_core::Result<()>;
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
impl ID3D12VideoExtensionCommand_Vtbl {
    pub const fn new<Identity: ID3D12VideoExtensionCommand_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetDesc<Identity: ID3D12VideoExtensionCommand_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, result__: *mut D3D12_VIDEO_EXTENSION_COMMAND_DESC) {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                *result__ = ID3D12VideoExtensionCommand_Impl::GetDesc(this)
            }
        }
        unsafe extern "system" fn GetProtectedResourceSession<Identity: ID3D12VideoExtensionCommand_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, riid: *const windows_core::GUID, ppprotectedsession: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoExtensionCommand_Impl::GetProtectedResourceSession(this, core::mem::transmute_copy(&riid), core::mem::transmute_copy(&ppprotectedsession)).into()
            }
        }
        Self {
            base__: super::super::Graphics::Direct3D12::ID3D12Pageable_Vtbl::new::<Identity, OFFSET>(),
            GetDesc: GetDesc::<Identity, OFFSET>,
            GetProtectedResourceSession: GetProtectedResourceSession::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<ID3D12VideoExtensionCommand as windows_core::Interface>::IID || iid == &<super::super::Graphics::Direct3D12::ID3D12Object as windows_core::Interface>::IID || iid == &<super::super::Graphics::Direct3D12::ID3D12DeviceChild as windows_core::Interface>::IID || iid == &<super::super::Graphics::Direct3D12::ID3D12Pageable as windows_core::Interface>::IID
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
impl windows_core::RuntimeName for ID3D12VideoExtensionCommand {}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
unsafe impl Send for ID3D12VideoExtensionCommand {}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
unsafe impl Sync for ID3D12VideoExtensionCommand {}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
windows_core::imp::define_interface!(ID3D12VideoMotionEstimator, ID3D12VideoMotionEstimator_Vtbl, 0x33fdae0e_098b_428f_87bb_34b695de08f8);
#[cfg(feature = "Win32_Graphics_Direct3D12")]
impl core::ops::Deref for ID3D12VideoMotionEstimator {
    type Target = super::super::Graphics::Direct3D12::ID3D12Pageable;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
windows_core::imp::interface_hierarchy!(ID3D12VideoMotionEstimator, windows_core::IUnknown, super::super::Graphics::Direct3D12::ID3D12Object, super::super::Graphics::Direct3D12::ID3D12DeviceChild, super::super::Graphics::Direct3D12::ID3D12Pageable);
#[cfg(feature = "Win32_Graphics_Direct3D12")]
impl ID3D12VideoMotionEstimator {
    #[cfg(feature = "Win32_Graphics_Dxgi_Common")]
    pub unsafe fn GetDesc(&self) -> D3D12_VIDEO_MOTION_ESTIMATOR_DESC {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetDesc)(windows_core::Interface::as_raw(self), &mut result__);
            result__
        }
    }
    pub unsafe fn GetProtectedResourceSession<T>(&self, result__: *mut Option<T>) -> windows_core::Result<()>
    where
        T: windows_core::Interface,
    {
        unsafe { (windows_core::Interface::vtable(self).GetProtectedResourceSession)(windows_core::Interface::as_raw(self), &T::IID, result__ as *mut _ as *mut _).ok() }
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
#[repr(C)]
pub struct ID3D12VideoMotionEstimator_Vtbl {
    pub base__: super::super::Graphics::Direct3D12::ID3D12Pageable_Vtbl,
    #[cfg(feature = "Win32_Graphics_Dxgi_Common")]
    pub GetDesc: unsafe extern "system" fn(*mut core::ffi::c_void, *mut D3D12_VIDEO_MOTION_ESTIMATOR_DESC),
    #[cfg(not(feature = "Win32_Graphics_Dxgi_Common"))]
    GetDesc: usize,
    pub GetProtectedResourceSession: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
pub trait ID3D12VideoMotionEstimator_Impl: super::super::Graphics::Direct3D12::ID3D12Pageable_Impl {
    fn GetDesc(&self) -> D3D12_VIDEO_MOTION_ESTIMATOR_DESC;
    fn GetProtectedResourceSession(&self, riid: *const windows_core::GUID, ppprotectedsession: *mut *mut core::ffi::c_void) -> windows_core::Result<()>;
}
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
impl ID3D12VideoMotionEstimator_Vtbl {
    pub const fn new<Identity: ID3D12VideoMotionEstimator_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetDesc<Identity: ID3D12VideoMotionEstimator_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, result__: *mut D3D12_VIDEO_MOTION_ESTIMATOR_DESC) {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                *result__ = ID3D12VideoMotionEstimator_Impl::GetDesc(this)
            }
        }
        unsafe extern "system" fn GetProtectedResourceSession<Identity: ID3D12VideoMotionEstimator_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, riid: *const windows_core::GUID, ppprotectedsession: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoMotionEstimator_Impl::GetProtectedResourceSession(this, core::mem::transmute_copy(&riid), core::mem::transmute_copy(&ppprotectedsession)).into()
            }
        }
        Self {
            base__: super::super::Graphics::Direct3D12::ID3D12Pageable_Vtbl::new::<Identity, OFFSET>(),
            GetDesc: GetDesc::<Identity, OFFSET>,
            GetProtectedResourceSession: GetProtectedResourceSession::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<ID3D12VideoMotionEstimator as windows_core::Interface>::IID || iid == &<super::super::Graphics::Direct3D12::ID3D12Object as windows_core::Interface>::IID || iid == &<super::super::Graphics::Direct3D12::ID3D12DeviceChild as windows_core::Interface>::IID || iid == &<super::super::Graphics::Direct3D12::ID3D12Pageable as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
impl windows_core::RuntimeName for ID3D12VideoMotionEstimator {}
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
unsafe impl Send for ID3D12VideoMotionEstimator {}
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
unsafe impl Sync for ID3D12VideoMotionEstimator {}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
windows_core::imp::define_interface!(ID3D12VideoMotionVectorHeap, ID3D12VideoMotionVectorHeap_Vtbl, 0x5be17987_743a_4061_834b_23d22daea505);
#[cfg(feature = "Win32_Graphics_Direct3D12")]
impl core::ops::Deref for ID3D12VideoMotionVectorHeap {
    type Target = super::super::Graphics::Direct3D12::ID3D12Pageable;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
windows_core::imp::interface_hierarchy!(ID3D12VideoMotionVectorHeap, windows_core::IUnknown, super::super::Graphics::Direct3D12::ID3D12Object, super::super::Graphics::Direct3D12::ID3D12DeviceChild, super::super::Graphics::Direct3D12::ID3D12Pageable);
#[cfg(feature = "Win32_Graphics_Direct3D12")]
impl ID3D12VideoMotionVectorHeap {
    #[cfg(feature = "Win32_Graphics_Dxgi_Common")]
    pub unsafe fn GetDesc(&self) -> D3D12_VIDEO_MOTION_VECTOR_HEAP_DESC {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetDesc)(windows_core::Interface::as_raw(self), &mut result__);
            result__
        }
    }
    pub unsafe fn GetProtectedResourceSession<T>(&self, result__: *mut Option<T>) -> windows_core::Result<()>
    where
        T: windows_core::Interface,
    {
        unsafe { (windows_core::Interface::vtable(self).GetProtectedResourceSession)(windows_core::Interface::as_raw(self), &T::IID, result__ as *mut _ as *mut _).ok() }
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
#[repr(C)]
pub struct ID3D12VideoMotionVectorHeap_Vtbl {
    pub base__: super::super::Graphics::Direct3D12::ID3D12Pageable_Vtbl,
    #[cfg(feature = "Win32_Graphics_Dxgi_Common")]
    pub GetDesc: unsafe extern "system" fn(*mut core::ffi::c_void, *mut D3D12_VIDEO_MOTION_VECTOR_HEAP_DESC),
    #[cfg(not(feature = "Win32_Graphics_Dxgi_Common"))]
    GetDesc: usize,
    pub GetProtectedResourceSession: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
pub trait ID3D12VideoMotionVectorHeap_Impl: super::super::Graphics::Direct3D12::ID3D12Pageable_Impl {
    fn GetDesc(&self) -> D3D12_VIDEO_MOTION_VECTOR_HEAP_DESC;
    fn GetProtectedResourceSession(&self, riid: *const windows_core::GUID, ppprotectedsession: *mut *mut core::ffi::c_void) -> windows_core::Result<()>;
}
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
impl ID3D12VideoMotionVectorHeap_Vtbl {
    pub const fn new<Identity: ID3D12VideoMotionVectorHeap_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetDesc<Identity: ID3D12VideoMotionVectorHeap_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, result__: *mut D3D12_VIDEO_MOTION_VECTOR_HEAP_DESC) {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                *result__ = ID3D12VideoMotionVectorHeap_Impl::GetDesc(this)
            }
        }
        unsafe extern "system" fn GetProtectedResourceSession<Identity: ID3D12VideoMotionVectorHeap_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, riid: *const windows_core::GUID, ppprotectedsession: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoMotionVectorHeap_Impl::GetProtectedResourceSession(this, core::mem::transmute_copy(&riid), core::mem::transmute_copy(&ppprotectedsession)).into()
            }
        }
        Self {
            base__: super::super::Graphics::Direct3D12::ID3D12Pageable_Vtbl::new::<Identity, OFFSET>(),
            GetDesc: GetDesc::<Identity, OFFSET>,
            GetProtectedResourceSession: GetProtectedResourceSession::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<ID3D12VideoMotionVectorHeap as windows_core::Interface>::IID || iid == &<super::super::Graphics::Direct3D12::ID3D12Object as windows_core::Interface>::IID || iid == &<super::super::Graphics::Direct3D12::ID3D12DeviceChild as windows_core::Interface>::IID || iid == &<super::super::Graphics::Direct3D12::ID3D12Pageable as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
impl windows_core::RuntimeName for ID3D12VideoMotionVectorHeap {}
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
unsafe impl Send for ID3D12VideoMotionVectorHeap {}
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
unsafe impl Sync for ID3D12VideoMotionVectorHeap {}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
windows_core::imp::define_interface!(ID3D12VideoProcessCommandList, ID3D12VideoProcessCommandList_Vtbl, 0xaeb2543a_167f_4682_acc8_d159ed4a6209);
#[cfg(feature = "Win32_Graphics_Direct3D12")]
impl core::ops::Deref for ID3D12VideoProcessCommandList {
    type Target = super::super::Graphics::Direct3D12::ID3D12CommandList;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
windows_core::imp::interface_hierarchy!(ID3D12VideoProcessCommandList, windows_core::IUnknown, super::super::Graphics::Direct3D12::ID3D12Object, super::super::Graphics::Direct3D12::ID3D12DeviceChild, super::super::Graphics::Direct3D12::ID3D12CommandList);
#[cfg(feature = "Win32_Graphics_Direct3D12")]
impl ID3D12VideoProcessCommandList {
    pub unsafe fn Close(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Close)(windows_core::Interface::as_raw(self)).ok() }
    }
    #[cfg(feature = "Win32_Graphics_Direct3D12")]
    pub unsafe fn Reset<P0>(&self, pallocator: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Graphics::Direct3D12::ID3D12CommandAllocator>,
    {
        unsafe { (windows_core::Interface::vtable(self).Reset)(windows_core::Interface::as_raw(self), pallocator.param().abi()).ok() }
    }
    pub unsafe fn ClearState(&self) {
        unsafe { (windows_core::Interface::vtable(self).ClearState)(windows_core::Interface::as_raw(self)) }
    }
    #[cfg(feature = "Win32_Graphics_Direct3D12")]
    pub unsafe fn ResourceBarrier(&self, pbarriers: &[super::super::Graphics::Direct3D12::D3D12_RESOURCE_BARRIER]) {
        unsafe { (windows_core::Interface::vtable(self).ResourceBarrier)(windows_core::Interface::as_raw(self), pbarriers.len().try_into().unwrap(), core::mem::transmute(pbarriers.as_ptr())) }
    }
    #[cfg(feature = "Win32_Graphics_Direct3D12")]
    pub unsafe fn DiscardResource<P0>(&self, presource: P0, pregion: Option<*const super::super::Graphics::Direct3D12::D3D12_DISCARD_REGION>)
    where
        P0: windows_core::Param<super::super::Graphics::Direct3D12::ID3D12Resource>,
    {
        unsafe { (windows_core::Interface::vtable(self).DiscardResource)(windows_core::Interface::as_raw(self), presource.param().abi(), pregion.unwrap_or(core::mem::zeroed()) as _) }
    }
    #[cfg(feature = "Win32_Graphics_Direct3D12")]
    pub unsafe fn BeginQuery<P0>(&self, pqueryheap: P0, r#type: super::super::Graphics::Direct3D12::D3D12_QUERY_TYPE, index: u32)
    where
        P0: windows_core::Param<super::super::Graphics::Direct3D12::ID3D12QueryHeap>,
    {
        unsafe { (windows_core::Interface::vtable(self).BeginQuery)(windows_core::Interface::as_raw(self), pqueryheap.param().abi(), r#type, index) }
    }
    #[cfg(feature = "Win32_Graphics_Direct3D12")]
    pub unsafe fn EndQuery<P0>(&self, pqueryheap: P0, r#type: super::super::Graphics::Direct3D12::D3D12_QUERY_TYPE, index: u32)
    where
        P0: windows_core::Param<super::super::Graphics::Direct3D12::ID3D12QueryHeap>,
    {
        unsafe { (windows_core::Interface::vtable(self).EndQuery)(windows_core::Interface::as_raw(self), pqueryheap.param().abi(), r#type, index) }
    }
    #[cfg(feature = "Win32_Graphics_Direct3D12")]
    pub unsafe fn ResolveQueryData<P0, P4>(&self, pqueryheap: P0, r#type: super::super::Graphics::Direct3D12::D3D12_QUERY_TYPE, startindex: u32, numqueries: u32, pdestinationbuffer: P4, aligneddestinationbufferoffset: u64)
    where
        P0: windows_core::Param<super::super::Graphics::Direct3D12::ID3D12QueryHeap>,
        P4: windows_core::Param<super::super::Graphics::Direct3D12::ID3D12Resource>,
    {
        unsafe { (windows_core::Interface::vtable(self).ResolveQueryData)(windows_core::Interface::as_raw(self), pqueryheap.param().abi(), r#type, startindex, numqueries, pdestinationbuffer.param().abi(), aligneddestinationbufferoffset) }
    }
    #[cfg(feature = "Win32_Graphics_Direct3D12")]
    pub unsafe fn SetPredication<P0>(&self, pbuffer: P0, alignedbufferoffset: u64, operation: super::super::Graphics::Direct3D12::D3D12_PREDICATION_OP)
    where
        P0: windows_core::Param<super::super::Graphics::Direct3D12::ID3D12Resource>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetPredication)(windows_core::Interface::as_raw(self), pbuffer.param().abi(), alignedbufferoffset, operation) }
    }
    pub unsafe fn SetMarker(&self, metadata: u32, pdata: Option<*const core::ffi::c_void>, size: u32) {
        unsafe { (windows_core::Interface::vtable(self).SetMarker)(windows_core::Interface::as_raw(self), metadata, pdata.unwrap_or(core::mem::zeroed()) as _, size) }
    }
    pub unsafe fn BeginEvent(&self, metadata: u32, pdata: Option<*const core::ffi::c_void>, size: u32) {
        unsafe { (windows_core::Interface::vtable(self).BeginEvent)(windows_core::Interface::as_raw(self), metadata, pdata.unwrap_or(core::mem::zeroed()) as _, size) }
    }
    pub unsafe fn EndEvent(&self) {
        unsafe { (windows_core::Interface::vtable(self).EndEvent)(windows_core::Interface::as_raw(self)) }
    }
    #[cfg(feature = "Win32_Graphics_Direct3D12")]
    pub unsafe fn ProcessFrames<P0>(&self, pvideoprocessor: P0, poutputarguments: *const D3D12_VIDEO_PROCESS_OUTPUT_STREAM_ARGUMENTS, pinputarguments: &[D3D12_VIDEO_PROCESS_INPUT_STREAM_ARGUMENTS])
    where
        P0: windows_core::Param<ID3D12VideoProcessor>,
    {
        unsafe { (windows_core::Interface::vtable(self).ProcessFrames)(windows_core::Interface::as_raw(self), pvideoprocessor.param().abi(), core::mem::transmute(poutputarguments), pinputarguments.len().try_into().unwrap(), core::mem::transmute(pinputarguments.as_ptr())) }
    }
    #[cfg(feature = "Win32_Graphics_Direct3D12")]
    pub unsafe fn WriteBufferImmediate(&self, count: u32, pparams: *const super::super::Graphics::Direct3D12::D3D12_WRITEBUFFERIMMEDIATE_PARAMETER, pmodes: Option<*const super::super::Graphics::Direct3D12::D3D12_WRITEBUFFERIMMEDIATE_MODE>) {
        unsafe { (windows_core::Interface::vtable(self).WriteBufferImmediate)(windows_core::Interface::as_raw(self), count, pparams, pmodes.unwrap_or(core::mem::zeroed()) as _) }
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
#[repr(C)]
pub struct ID3D12VideoProcessCommandList_Vtbl {
    pub base__: super::super::Graphics::Direct3D12::ID3D12CommandList_Vtbl,
    pub Close: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_Graphics_Direct3D12")]
    pub Reset: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Direct3D12"))]
    Reset: usize,
    pub ClearState: unsafe extern "system" fn(*mut core::ffi::c_void),
    #[cfg(feature = "Win32_Graphics_Direct3D12")]
    pub ResourceBarrier: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const super::super::Graphics::Direct3D12::D3D12_RESOURCE_BARRIER),
    #[cfg(not(feature = "Win32_Graphics_Direct3D12"))]
    ResourceBarrier: usize,
    #[cfg(feature = "Win32_Graphics_Direct3D12")]
    pub DiscardResource: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *const super::super::Graphics::Direct3D12::D3D12_DISCARD_REGION),
    #[cfg(not(feature = "Win32_Graphics_Direct3D12"))]
    DiscardResource: usize,
    #[cfg(feature = "Win32_Graphics_Direct3D12")]
    pub BeginQuery: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, super::super::Graphics::Direct3D12::D3D12_QUERY_TYPE, u32),
    #[cfg(not(feature = "Win32_Graphics_Direct3D12"))]
    BeginQuery: usize,
    #[cfg(feature = "Win32_Graphics_Direct3D12")]
    pub EndQuery: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, super::super::Graphics::Direct3D12::D3D12_QUERY_TYPE, u32),
    #[cfg(not(feature = "Win32_Graphics_Direct3D12"))]
    EndQuery: usize,
    #[cfg(feature = "Win32_Graphics_Direct3D12")]
    pub ResolveQueryData: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, super::super::Graphics::Direct3D12::D3D12_QUERY_TYPE, u32, u32, *mut core::ffi::c_void, u64),
    #[cfg(not(feature = "Win32_Graphics_Direct3D12"))]
    ResolveQueryData: usize,
    #[cfg(feature = "Win32_Graphics_Direct3D12")]
    pub SetPredication: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, u64, super::super::Graphics::Direct3D12::D3D12_PREDICATION_OP),
    #[cfg(not(feature = "Win32_Graphics_Direct3D12"))]
    SetPredication: usize,
    pub SetMarker: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const core::ffi::c_void, u32),
    pub BeginEvent: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const core::ffi::c_void, u32),
    pub EndEvent: unsafe extern "system" fn(*mut core::ffi::c_void),
    #[cfg(feature = "Win32_Graphics_Direct3D12")]
    pub ProcessFrames: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *const D3D12_VIDEO_PROCESS_OUTPUT_STREAM_ARGUMENTS, u32, *const D3D12_VIDEO_PROCESS_INPUT_STREAM_ARGUMENTS),
    #[cfg(not(feature = "Win32_Graphics_Direct3D12"))]
    ProcessFrames: usize,
    #[cfg(feature = "Win32_Graphics_Direct3D12")]
    pub WriteBufferImmediate: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const super::super::Graphics::Direct3D12::D3D12_WRITEBUFFERIMMEDIATE_PARAMETER, *const super::super::Graphics::Direct3D12::D3D12_WRITEBUFFERIMMEDIATE_MODE),
    #[cfg(not(feature = "Win32_Graphics_Direct3D12"))]
    WriteBufferImmediate: usize,
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
pub trait ID3D12VideoProcessCommandList_Impl: super::super::Graphics::Direct3D12::ID3D12CommandList_Impl {
    fn Close(&self) -> windows_core::Result<()>;
    fn Reset(&self, pallocator: windows_core::Ref<'_, super::super::Graphics::Direct3D12::ID3D12CommandAllocator>) -> windows_core::Result<()>;
    fn ClearState(&self);
    fn ResourceBarrier(&self, numbarriers: u32, pbarriers: *const super::super::Graphics::Direct3D12::D3D12_RESOURCE_BARRIER);
    fn DiscardResource(&self, presource: windows_core::Ref<'_, super::super::Graphics::Direct3D12::ID3D12Resource>, pregion: *const super::super::Graphics::Direct3D12::D3D12_DISCARD_REGION);
    fn BeginQuery(&self, pqueryheap: windows_core::Ref<'_, super::super::Graphics::Direct3D12::ID3D12QueryHeap>, r#type: super::super::Graphics::Direct3D12::D3D12_QUERY_TYPE, index: u32);
    fn EndQuery(&self, pqueryheap: windows_core::Ref<'_, super::super::Graphics::Direct3D12::ID3D12QueryHeap>, r#type: super::super::Graphics::Direct3D12::D3D12_QUERY_TYPE, index: u32);
    fn ResolveQueryData(&self, pqueryheap: windows_core::Ref<'_, super::super::Graphics::Direct3D12::ID3D12QueryHeap>, r#type: super::super::Graphics::Direct3D12::D3D12_QUERY_TYPE, startindex: u32, numqueries: u32, pdestinationbuffer: windows_core::Ref<'_, super::super::Graphics::Direct3D12::ID3D12Resource>, aligneddestinationbufferoffset: u64);
    fn SetPredication(&self, pbuffer: windows_core::Ref<'_, super::super::Graphics::Direct3D12::ID3D12Resource>, alignedbufferoffset: u64, operation: super::super::Graphics::Direct3D12::D3D12_PREDICATION_OP);
    fn SetMarker(&self, metadata: u32, pdata: *const core::ffi::c_void, size: u32);
    fn BeginEvent(&self, metadata: u32, pdata: *const core::ffi::c_void, size: u32);
    fn EndEvent(&self);
    fn ProcessFrames(&self, pvideoprocessor: windows_core::Ref<'_, ID3D12VideoProcessor>, poutputarguments: *const D3D12_VIDEO_PROCESS_OUTPUT_STREAM_ARGUMENTS, numinputstreams: u32, pinputarguments: *const D3D12_VIDEO_PROCESS_INPUT_STREAM_ARGUMENTS);
    fn WriteBufferImmediate(&self, count: u32, pparams: *const super::super::Graphics::Direct3D12::D3D12_WRITEBUFFERIMMEDIATE_PARAMETER, pmodes: *const super::super::Graphics::Direct3D12::D3D12_WRITEBUFFERIMMEDIATE_MODE);
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
impl ID3D12VideoProcessCommandList_Vtbl {
    pub const fn new<Identity: ID3D12VideoProcessCommandList_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn Close<Identity: ID3D12VideoProcessCommandList_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoProcessCommandList_Impl::Close(this).into()
            }
        }
        unsafe extern "system" fn Reset<Identity: ID3D12VideoProcessCommandList_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pallocator: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoProcessCommandList_Impl::Reset(this, core::mem::transmute_copy(&pallocator)).into()
            }
        }
        unsafe extern "system" fn ClearState<Identity: ID3D12VideoProcessCommandList_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoProcessCommandList_Impl::ClearState(this)
            }
        }
        unsafe extern "system" fn ResourceBarrier<Identity: ID3D12VideoProcessCommandList_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, numbarriers: u32, pbarriers: *const super::super::Graphics::Direct3D12::D3D12_RESOURCE_BARRIER) {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoProcessCommandList_Impl::ResourceBarrier(this, core::mem::transmute_copy(&numbarriers), core::mem::transmute_copy(&pbarriers))
            }
        }
        unsafe extern "system" fn DiscardResource<Identity: ID3D12VideoProcessCommandList_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, presource: *mut core::ffi::c_void, pregion: *const super::super::Graphics::Direct3D12::D3D12_DISCARD_REGION) {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoProcessCommandList_Impl::DiscardResource(this, core::mem::transmute_copy(&presource), core::mem::transmute_copy(&pregion))
            }
        }
        unsafe extern "system" fn BeginQuery<Identity: ID3D12VideoProcessCommandList_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pqueryheap: *mut core::ffi::c_void, r#type: super::super::Graphics::Direct3D12::D3D12_QUERY_TYPE, index: u32) {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoProcessCommandList_Impl::BeginQuery(this, core::mem::transmute_copy(&pqueryheap), core::mem::transmute_copy(&r#type), core::mem::transmute_copy(&index))
            }
        }
        unsafe extern "system" fn EndQuery<Identity: ID3D12VideoProcessCommandList_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pqueryheap: *mut core::ffi::c_void, r#type: super::super::Graphics::Direct3D12::D3D12_QUERY_TYPE, index: u32) {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoProcessCommandList_Impl::EndQuery(this, core::mem::transmute_copy(&pqueryheap), core::mem::transmute_copy(&r#type), core::mem::transmute_copy(&index))
            }
        }
        unsafe extern "system" fn ResolveQueryData<Identity: ID3D12VideoProcessCommandList_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pqueryheap: *mut core::ffi::c_void, r#type: super::super::Graphics::Direct3D12::D3D12_QUERY_TYPE, startindex: u32, numqueries: u32, pdestinationbuffer: *mut core::ffi::c_void, aligneddestinationbufferoffset: u64) {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoProcessCommandList_Impl::ResolveQueryData(this, core::mem::transmute_copy(&pqueryheap), core::mem::transmute_copy(&r#type), core::mem::transmute_copy(&startindex), core::mem::transmute_copy(&numqueries), core::mem::transmute_copy(&pdestinationbuffer), core::mem::transmute_copy(&aligneddestinationbufferoffset))
            }
        }
        unsafe extern "system" fn SetPredication<Identity: ID3D12VideoProcessCommandList_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbuffer: *mut core::ffi::c_void, alignedbufferoffset: u64, operation: super::super::Graphics::Direct3D12::D3D12_PREDICATION_OP) {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoProcessCommandList_Impl::SetPredication(this, core::mem::transmute_copy(&pbuffer), core::mem::transmute_copy(&alignedbufferoffset), core::mem::transmute_copy(&operation))
            }
        }
        unsafe extern "system" fn SetMarker<Identity: ID3D12VideoProcessCommandList_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, metadata: u32, pdata: *const core::ffi::c_void, size: u32) {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoProcessCommandList_Impl::SetMarker(this, core::mem::transmute_copy(&metadata), core::mem::transmute_copy(&pdata), core::mem::transmute_copy(&size))
            }
        }
        unsafe extern "system" fn BeginEvent<Identity: ID3D12VideoProcessCommandList_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, metadata: u32, pdata: *const core::ffi::c_void, size: u32) {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoProcessCommandList_Impl::BeginEvent(this, core::mem::transmute_copy(&metadata), core::mem::transmute_copy(&pdata), core::mem::transmute_copy(&size))
            }
        }
        unsafe extern "system" fn EndEvent<Identity: ID3D12VideoProcessCommandList_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoProcessCommandList_Impl::EndEvent(this)
            }
        }
        unsafe extern "system" fn ProcessFrames<Identity: ID3D12VideoProcessCommandList_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pvideoprocessor: *mut core::ffi::c_void, poutputarguments: *const D3D12_VIDEO_PROCESS_OUTPUT_STREAM_ARGUMENTS, numinputstreams: u32, pinputarguments: *const D3D12_VIDEO_PROCESS_INPUT_STREAM_ARGUMENTS) {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoProcessCommandList_Impl::ProcessFrames(this, core::mem::transmute_copy(&pvideoprocessor), core::mem::transmute_copy(&poutputarguments), core::mem::transmute_copy(&numinputstreams), core::mem::transmute_copy(&pinputarguments))
            }
        }
        unsafe extern "system" fn WriteBufferImmediate<Identity: ID3D12VideoProcessCommandList_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, count: u32, pparams: *const super::super::Graphics::Direct3D12::D3D12_WRITEBUFFERIMMEDIATE_PARAMETER, pmodes: *const super::super::Graphics::Direct3D12::D3D12_WRITEBUFFERIMMEDIATE_MODE) {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoProcessCommandList_Impl::WriteBufferImmediate(this, core::mem::transmute_copy(&count), core::mem::transmute_copy(&pparams), core::mem::transmute_copy(&pmodes))
            }
        }
        Self {
            base__: super::super::Graphics::Direct3D12::ID3D12CommandList_Vtbl::new::<Identity, OFFSET>(),
            Close: Close::<Identity, OFFSET>,
            Reset: Reset::<Identity, OFFSET>,
            ClearState: ClearState::<Identity, OFFSET>,
            ResourceBarrier: ResourceBarrier::<Identity, OFFSET>,
            DiscardResource: DiscardResource::<Identity, OFFSET>,
            BeginQuery: BeginQuery::<Identity, OFFSET>,
            EndQuery: EndQuery::<Identity, OFFSET>,
            ResolveQueryData: ResolveQueryData::<Identity, OFFSET>,
            SetPredication: SetPredication::<Identity, OFFSET>,
            SetMarker: SetMarker::<Identity, OFFSET>,
            BeginEvent: BeginEvent::<Identity, OFFSET>,
            EndEvent: EndEvent::<Identity, OFFSET>,
            ProcessFrames: ProcessFrames::<Identity, OFFSET>,
            WriteBufferImmediate: WriteBufferImmediate::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<ID3D12VideoProcessCommandList as windows_core::Interface>::IID || iid == &<super::super::Graphics::Direct3D12::ID3D12Object as windows_core::Interface>::IID || iid == &<super::super::Graphics::Direct3D12::ID3D12DeviceChild as windows_core::Interface>::IID || iid == &<super::super::Graphics::Direct3D12::ID3D12CommandList as windows_core::Interface>::IID
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
impl windows_core::RuntimeName for ID3D12VideoProcessCommandList {}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
unsafe impl Send for ID3D12VideoProcessCommandList {}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
unsafe impl Sync for ID3D12VideoProcessCommandList {}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
windows_core::imp::define_interface!(ID3D12VideoProcessCommandList1, ID3D12VideoProcessCommandList1_Vtbl, 0x542c5c4d_7596_434f_8c93_4efa6766f267);
#[cfg(feature = "Win32_Graphics_Direct3D12")]
impl core::ops::Deref for ID3D12VideoProcessCommandList1 {
    type Target = ID3D12VideoProcessCommandList;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
windows_core::imp::interface_hierarchy!(ID3D12VideoProcessCommandList1, windows_core::IUnknown, super::super::Graphics::Direct3D12::ID3D12Object, super::super::Graphics::Direct3D12::ID3D12DeviceChild, super::super::Graphics::Direct3D12::ID3D12CommandList, ID3D12VideoProcessCommandList);
#[cfg(feature = "Win32_Graphics_Direct3D12")]
impl ID3D12VideoProcessCommandList1 {
    #[cfg(feature = "Win32_Graphics_Direct3D12")]
    pub unsafe fn ProcessFrames1<P0>(&self, pvideoprocessor: P0, poutputarguments: *const D3D12_VIDEO_PROCESS_OUTPUT_STREAM_ARGUMENTS, pinputarguments: &[D3D12_VIDEO_PROCESS_INPUT_STREAM_ARGUMENTS1])
    where
        P0: windows_core::Param<ID3D12VideoProcessor>,
    {
        unsafe { (windows_core::Interface::vtable(self).ProcessFrames1)(windows_core::Interface::as_raw(self), pvideoprocessor.param().abi(), core::mem::transmute(poutputarguments), pinputarguments.len().try_into().unwrap(), core::mem::transmute(pinputarguments.as_ptr())) }
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
#[repr(C)]
pub struct ID3D12VideoProcessCommandList1_Vtbl {
    pub base__: ID3D12VideoProcessCommandList_Vtbl,
    #[cfg(feature = "Win32_Graphics_Direct3D12")]
    pub ProcessFrames1: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *const D3D12_VIDEO_PROCESS_OUTPUT_STREAM_ARGUMENTS, u32, *const D3D12_VIDEO_PROCESS_INPUT_STREAM_ARGUMENTS1),
    #[cfg(not(feature = "Win32_Graphics_Direct3D12"))]
    ProcessFrames1: usize,
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
pub trait ID3D12VideoProcessCommandList1_Impl: ID3D12VideoProcessCommandList_Impl {
    fn ProcessFrames1(&self, pvideoprocessor: windows_core::Ref<'_, ID3D12VideoProcessor>, poutputarguments: *const D3D12_VIDEO_PROCESS_OUTPUT_STREAM_ARGUMENTS, numinputstreams: u32, pinputarguments: *const D3D12_VIDEO_PROCESS_INPUT_STREAM_ARGUMENTS1);
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
impl ID3D12VideoProcessCommandList1_Vtbl {
    pub const fn new<Identity: ID3D12VideoProcessCommandList1_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn ProcessFrames1<Identity: ID3D12VideoProcessCommandList1_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pvideoprocessor: *mut core::ffi::c_void, poutputarguments: *const D3D12_VIDEO_PROCESS_OUTPUT_STREAM_ARGUMENTS, numinputstreams: u32, pinputarguments: *const D3D12_VIDEO_PROCESS_INPUT_STREAM_ARGUMENTS1) {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoProcessCommandList1_Impl::ProcessFrames1(this, core::mem::transmute_copy(&pvideoprocessor), core::mem::transmute_copy(&poutputarguments), core::mem::transmute_copy(&numinputstreams), core::mem::transmute_copy(&pinputarguments))
            }
        }
        Self { base__: ID3D12VideoProcessCommandList_Vtbl::new::<Identity, OFFSET>(), ProcessFrames1: ProcessFrames1::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<ID3D12VideoProcessCommandList1 as windows_core::Interface>::IID || iid == &<super::super::Graphics::Direct3D12::ID3D12Object as windows_core::Interface>::IID || iid == &<super::super::Graphics::Direct3D12::ID3D12DeviceChild as windows_core::Interface>::IID || iid == &<super::super::Graphics::Direct3D12::ID3D12CommandList as windows_core::Interface>::IID || iid == &<ID3D12VideoProcessCommandList as windows_core::Interface>::IID
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
impl windows_core::RuntimeName for ID3D12VideoProcessCommandList1 {}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
unsafe impl Send for ID3D12VideoProcessCommandList1 {}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
unsafe impl Sync for ID3D12VideoProcessCommandList1 {}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
windows_core::imp::define_interface!(ID3D12VideoProcessCommandList2, ID3D12VideoProcessCommandList2_Vtbl, 0xdb525ae4_6ad6_473c_baa7_59b2e37082e4);
#[cfg(feature = "Win32_Graphics_Direct3D12")]
impl core::ops::Deref for ID3D12VideoProcessCommandList2 {
    type Target = ID3D12VideoProcessCommandList1;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
windows_core::imp::interface_hierarchy!(ID3D12VideoProcessCommandList2, windows_core::IUnknown, super::super::Graphics::Direct3D12::ID3D12Object, super::super::Graphics::Direct3D12::ID3D12DeviceChild, super::super::Graphics::Direct3D12::ID3D12CommandList, ID3D12VideoProcessCommandList, ID3D12VideoProcessCommandList1);
#[cfg(feature = "Win32_Graphics_Direct3D12")]
impl ID3D12VideoProcessCommandList2 {
    #[cfg(feature = "Win32_Graphics_Direct3D12")]
    pub unsafe fn SetProtectedResourceSession<P0>(&self, pprotectedresourcesession: P0)
    where
        P0: windows_core::Param<super::super::Graphics::Direct3D12::ID3D12ProtectedResourceSession>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetProtectedResourceSession)(windows_core::Interface::as_raw(self), pprotectedresourcesession.param().abi()) }
    }
    #[cfg(feature = "Win32_Graphics_Direct3D12")]
    pub unsafe fn InitializeExtensionCommand<P0>(&self, pextensioncommand: P0, pinitializationparameters: *const core::ffi::c_void, initializationparameterssizeinbytes: usize)
    where
        P0: windows_core::Param<ID3D12VideoExtensionCommand>,
    {
        unsafe { (windows_core::Interface::vtable(self).InitializeExtensionCommand)(windows_core::Interface::as_raw(self), pextensioncommand.param().abi(), pinitializationparameters, initializationparameterssizeinbytes) }
    }
    #[cfg(feature = "Win32_Graphics_Direct3D12")]
    pub unsafe fn ExecuteExtensionCommand<P0>(&self, pextensioncommand: P0, pexecutionparameters: *const core::ffi::c_void, executionparameterssizeinbytes: usize)
    where
        P0: windows_core::Param<ID3D12VideoExtensionCommand>,
    {
        unsafe { (windows_core::Interface::vtable(self).ExecuteExtensionCommand)(windows_core::Interface::as_raw(self), pextensioncommand.param().abi(), pexecutionparameters, executionparameterssizeinbytes) }
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
#[repr(C)]
pub struct ID3D12VideoProcessCommandList2_Vtbl {
    pub base__: ID3D12VideoProcessCommandList1_Vtbl,
    #[cfg(feature = "Win32_Graphics_Direct3D12")]
    pub SetProtectedResourceSession: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void),
    #[cfg(not(feature = "Win32_Graphics_Direct3D12"))]
    SetProtectedResourceSession: usize,
    #[cfg(feature = "Win32_Graphics_Direct3D12")]
    pub InitializeExtensionCommand: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *const core::ffi::c_void, usize),
    #[cfg(not(feature = "Win32_Graphics_Direct3D12"))]
    InitializeExtensionCommand: usize,
    #[cfg(feature = "Win32_Graphics_Direct3D12")]
    pub ExecuteExtensionCommand: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *const core::ffi::c_void, usize),
    #[cfg(not(feature = "Win32_Graphics_Direct3D12"))]
    ExecuteExtensionCommand: usize,
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
pub trait ID3D12VideoProcessCommandList2_Impl: ID3D12VideoProcessCommandList1_Impl {
    fn SetProtectedResourceSession(&self, pprotectedresourcesession: windows_core::Ref<'_, super::super::Graphics::Direct3D12::ID3D12ProtectedResourceSession>);
    fn InitializeExtensionCommand(&self, pextensioncommand: windows_core::Ref<'_, ID3D12VideoExtensionCommand>, pinitializationparameters: *const core::ffi::c_void, initializationparameterssizeinbytes: usize);
    fn ExecuteExtensionCommand(&self, pextensioncommand: windows_core::Ref<'_, ID3D12VideoExtensionCommand>, pexecutionparameters: *const core::ffi::c_void, executionparameterssizeinbytes: usize);
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
impl ID3D12VideoProcessCommandList2_Vtbl {
    pub const fn new<Identity: ID3D12VideoProcessCommandList2_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn SetProtectedResourceSession<Identity: ID3D12VideoProcessCommandList2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pprotectedresourcesession: *mut core::ffi::c_void) {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoProcessCommandList2_Impl::SetProtectedResourceSession(this, core::mem::transmute_copy(&pprotectedresourcesession))
            }
        }
        unsafe extern "system" fn InitializeExtensionCommand<Identity: ID3D12VideoProcessCommandList2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pextensioncommand: *mut core::ffi::c_void, pinitializationparameters: *const core::ffi::c_void, initializationparameterssizeinbytes: usize) {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoProcessCommandList2_Impl::InitializeExtensionCommand(this, core::mem::transmute_copy(&pextensioncommand), core::mem::transmute_copy(&pinitializationparameters), core::mem::transmute_copy(&initializationparameterssizeinbytes))
            }
        }
        unsafe extern "system" fn ExecuteExtensionCommand<Identity: ID3D12VideoProcessCommandList2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pextensioncommand: *mut core::ffi::c_void, pexecutionparameters: *const core::ffi::c_void, executionparameterssizeinbytes: usize) {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoProcessCommandList2_Impl::ExecuteExtensionCommand(this, core::mem::transmute_copy(&pextensioncommand), core::mem::transmute_copy(&pexecutionparameters), core::mem::transmute_copy(&executionparameterssizeinbytes))
            }
        }
        Self {
            base__: ID3D12VideoProcessCommandList1_Vtbl::new::<Identity, OFFSET>(),
            SetProtectedResourceSession: SetProtectedResourceSession::<Identity, OFFSET>,
            InitializeExtensionCommand: InitializeExtensionCommand::<Identity, OFFSET>,
            ExecuteExtensionCommand: ExecuteExtensionCommand::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<ID3D12VideoProcessCommandList2 as windows_core::Interface>::IID || iid == &<super::super::Graphics::Direct3D12::ID3D12Object as windows_core::Interface>::IID || iid == &<super::super::Graphics::Direct3D12::ID3D12DeviceChild as windows_core::Interface>::IID || iid == &<super::super::Graphics::Direct3D12::ID3D12CommandList as windows_core::Interface>::IID || iid == &<ID3D12VideoProcessCommandList as windows_core::Interface>::IID || iid == &<ID3D12VideoProcessCommandList1 as windows_core::Interface>::IID
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
impl windows_core::RuntimeName for ID3D12VideoProcessCommandList2 {}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
unsafe impl Send for ID3D12VideoProcessCommandList2 {}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
unsafe impl Sync for ID3D12VideoProcessCommandList2 {}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
windows_core::imp::define_interface!(ID3D12VideoProcessCommandList3, ID3D12VideoProcessCommandList3_Vtbl, 0x1a0a4ca4_9f08_40ce_9558_b411fd2666ff);
#[cfg(feature = "Win32_Graphics_Direct3D12")]
impl core::ops::Deref for ID3D12VideoProcessCommandList3 {
    type Target = ID3D12VideoProcessCommandList2;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
windows_core::imp::interface_hierarchy!(ID3D12VideoProcessCommandList3, windows_core::IUnknown, super::super::Graphics::Direct3D12::ID3D12Object, super::super::Graphics::Direct3D12::ID3D12DeviceChild, super::super::Graphics::Direct3D12::ID3D12CommandList, ID3D12VideoProcessCommandList, ID3D12VideoProcessCommandList1, ID3D12VideoProcessCommandList2);
#[cfg(feature = "Win32_Graphics_Direct3D12")]
impl ID3D12VideoProcessCommandList3 {
    #[cfg(feature = "Win32_Graphics_Direct3D12")]
    pub unsafe fn Barrier(&self, pbarriergroups: &[super::super::Graphics::Direct3D12::D3D12_BARRIER_GROUP]) {
        unsafe { (windows_core::Interface::vtable(self).Barrier)(windows_core::Interface::as_raw(self), pbarriergroups.len().try_into().unwrap(), core::mem::transmute(pbarriergroups.as_ptr())) }
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
#[repr(C)]
pub struct ID3D12VideoProcessCommandList3_Vtbl {
    pub base__: ID3D12VideoProcessCommandList2_Vtbl,
    #[cfg(feature = "Win32_Graphics_Direct3D12")]
    pub Barrier: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const super::super::Graphics::Direct3D12::D3D12_BARRIER_GROUP),
    #[cfg(not(feature = "Win32_Graphics_Direct3D12"))]
    Barrier: usize,
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
pub trait ID3D12VideoProcessCommandList3_Impl: ID3D12VideoProcessCommandList2_Impl {
    fn Barrier(&self, numbarriergroups: u32, pbarriergroups: *const super::super::Graphics::Direct3D12::D3D12_BARRIER_GROUP);
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
impl ID3D12VideoProcessCommandList3_Vtbl {
    pub const fn new<Identity: ID3D12VideoProcessCommandList3_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn Barrier<Identity: ID3D12VideoProcessCommandList3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, numbarriergroups: u32, pbarriergroups: *const super::super::Graphics::Direct3D12::D3D12_BARRIER_GROUP) {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoProcessCommandList3_Impl::Barrier(this, core::mem::transmute_copy(&numbarriergroups), core::mem::transmute_copy(&pbarriergroups))
            }
        }
        Self { base__: ID3D12VideoProcessCommandList2_Vtbl::new::<Identity, OFFSET>(), Barrier: Barrier::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<ID3D12VideoProcessCommandList3 as windows_core::Interface>::IID || iid == &<super::super::Graphics::Direct3D12::ID3D12Object as windows_core::Interface>::IID || iid == &<super::super::Graphics::Direct3D12::ID3D12DeviceChild as windows_core::Interface>::IID || iid == &<super::super::Graphics::Direct3D12::ID3D12CommandList as windows_core::Interface>::IID || iid == &<ID3D12VideoProcessCommandList as windows_core::Interface>::IID || iid == &<ID3D12VideoProcessCommandList1 as windows_core::Interface>::IID || iid == &<ID3D12VideoProcessCommandList2 as windows_core::Interface>::IID
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
impl windows_core::RuntimeName for ID3D12VideoProcessCommandList3 {}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
unsafe impl Send for ID3D12VideoProcessCommandList3 {}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
unsafe impl Sync for ID3D12VideoProcessCommandList3 {}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
windows_core::imp::define_interface!(ID3D12VideoProcessor, ID3D12VideoProcessor_Vtbl, 0x304fdb32_bede_410a_8545_943ac6a46138);
#[cfg(feature = "Win32_Graphics_Direct3D12")]
impl core::ops::Deref for ID3D12VideoProcessor {
    type Target = super::super::Graphics::Direct3D12::ID3D12Pageable;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
windows_core::imp::interface_hierarchy!(ID3D12VideoProcessor, windows_core::IUnknown, super::super::Graphics::Direct3D12::ID3D12Object, super::super::Graphics::Direct3D12::ID3D12DeviceChild, super::super::Graphics::Direct3D12::ID3D12Pageable);
#[cfg(feature = "Win32_Graphics_Direct3D12")]
impl ID3D12VideoProcessor {
    pub unsafe fn GetNodeMask(&self) -> u32 {
        unsafe { (windows_core::Interface::vtable(self).GetNodeMask)(windows_core::Interface::as_raw(self)) }
    }
    pub unsafe fn GetNumInputStreamDescs(&self) -> u32 {
        unsafe { (windows_core::Interface::vtable(self).GetNumInputStreamDescs)(windows_core::Interface::as_raw(self)) }
    }
    #[cfg(feature = "Win32_Graphics_Dxgi_Common")]
    pub unsafe fn GetInputStreamDescs(&self, pinputstreamdescs: &mut [D3D12_VIDEO_PROCESS_INPUT_STREAM_DESC]) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetInputStreamDescs)(windows_core::Interface::as_raw(self), pinputstreamdescs.len().try_into().unwrap(), core::mem::transmute(pinputstreamdescs.as_ptr())).ok() }
    }
    #[cfg(feature = "Win32_Graphics_Dxgi_Common")]
    pub unsafe fn GetOutputStreamDesc(&self) -> D3D12_VIDEO_PROCESS_OUTPUT_STREAM_DESC {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetOutputStreamDesc)(windows_core::Interface::as_raw(self), &mut result__);
            result__
        }
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
#[repr(C)]
pub struct ID3D12VideoProcessor_Vtbl {
    pub base__: super::super::Graphics::Direct3D12::ID3D12Pageable_Vtbl,
    pub GetNodeMask: unsafe extern "system" fn(*mut core::ffi::c_void) -> u32,
    pub GetNumInputStreamDescs: unsafe extern "system" fn(*mut core::ffi::c_void) -> u32,
    #[cfg(feature = "Win32_Graphics_Dxgi_Common")]
    pub GetInputStreamDescs: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut D3D12_VIDEO_PROCESS_INPUT_STREAM_DESC) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Dxgi_Common"))]
    GetInputStreamDescs: usize,
    #[cfg(feature = "Win32_Graphics_Dxgi_Common")]
    pub GetOutputStreamDesc: unsafe extern "system" fn(*mut core::ffi::c_void, *mut D3D12_VIDEO_PROCESS_OUTPUT_STREAM_DESC),
    #[cfg(not(feature = "Win32_Graphics_Dxgi_Common"))]
    GetOutputStreamDesc: usize,
}
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
pub trait ID3D12VideoProcessor_Impl: super::super::Graphics::Direct3D12::ID3D12Pageable_Impl {
    fn GetNodeMask(&self) -> u32;
    fn GetNumInputStreamDescs(&self) -> u32;
    fn GetInputStreamDescs(&self, numinputstreamdescs: u32, pinputstreamdescs: *mut D3D12_VIDEO_PROCESS_INPUT_STREAM_DESC) -> windows_core::Result<()>;
    fn GetOutputStreamDesc(&self) -> D3D12_VIDEO_PROCESS_OUTPUT_STREAM_DESC;
}
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
impl ID3D12VideoProcessor_Vtbl {
    pub const fn new<Identity: ID3D12VideoProcessor_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetNodeMask<Identity: ID3D12VideoProcessor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> u32 {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoProcessor_Impl::GetNodeMask(this)
            }
        }
        unsafe extern "system" fn GetNumInputStreamDescs<Identity: ID3D12VideoProcessor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> u32 {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoProcessor_Impl::GetNumInputStreamDescs(this)
            }
        }
        unsafe extern "system" fn GetInputStreamDescs<Identity: ID3D12VideoProcessor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, numinputstreamdescs: u32, pinputstreamdescs: *mut D3D12_VIDEO_PROCESS_INPUT_STREAM_DESC) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoProcessor_Impl::GetInputStreamDescs(this, core::mem::transmute_copy(&numinputstreamdescs), core::mem::transmute_copy(&pinputstreamdescs)).into()
            }
        }
        unsafe extern "system" fn GetOutputStreamDesc<Identity: ID3D12VideoProcessor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, result__: *mut D3D12_VIDEO_PROCESS_OUTPUT_STREAM_DESC) {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                *result__ = ID3D12VideoProcessor_Impl::GetOutputStreamDesc(this)
            }
        }
        Self {
            base__: super::super::Graphics::Direct3D12::ID3D12Pageable_Vtbl::new::<Identity, OFFSET>(),
            GetNodeMask: GetNodeMask::<Identity, OFFSET>,
            GetNumInputStreamDescs: GetNumInputStreamDescs::<Identity, OFFSET>,
            GetInputStreamDescs: GetInputStreamDescs::<Identity, OFFSET>,
            GetOutputStreamDesc: GetOutputStreamDesc::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<ID3D12VideoProcessor as windows_core::Interface>::IID || iid == &<super::super::Graphics::Direct3D12::ID3D12Object as windows_core::Interface>::IID || iid == &<super::super::Graphics::Direct3D12::ID3D12DeviceChild as windows_core::Interface>::IID || iid == &<super::super::Graphics::Direct3D12::ID3D12Pageable as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
impl windows_core::RuntimeName for ID3D12VideoProcessor {}
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
unsafe impl Send for ID3D12VideoProcessor {}
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
unsafe impl Sync for ID3D12VideoProcessor {}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
windows_core::imp::define_interface!(ID3D12VideoProcessor1, ID3D12VideoProcessor1_Vtbl, 0xf3cfe615_553f_425c_86d8_ee8c1b1fb01c);
#[cfg(feature = "Win32_Graphics_Direct3D12")]
impl core::ops::Deref for ID3D12VideoProcessor1 {
    type Target = ID3D12VideoProcessor;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
windows_core::imp::interface_hierarchy!(ID3D12VideoProcessor1, windows_core::IUnknown, super::super::Graphics::Direct3D12::ID3D12Object, super::super::Graphics::Direct3D12::ID3D12DeviceChild, super::super::Graphics::Direct3D12::ID3D12Pageable, ID3D12VideoProcessor);
#[cfg(feature = "Win32_Graphics_Direct3D12")]
impl ID3D12VideoProcessor1 {
    pub unsafe fn GetProtectedResourceSession<T>(&self, result__: *mut Option<T>) -> windows_core::Result<()>
    where
        T: windows_core::Interface,
    {
        unsafe { (windows_core::Interface::vtable(self).GetProtectedResourceSession)(windows_core::Interface::as_raw(self), &T::IID, result__ as *mut _ as *mut _).ok() }
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D12")]
#[repr(C)]
pub struct ID3D12VideoProcessor1_Vtbl {
    pub base__: ID3D12VideoProcessor_Vtbl,
    pub GetProtectedResourceSession: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
pub trait ID3D12VideoProcessor1_Impl: ID3D12VideoProcessor_Impl {
    fn GetProtectedResourceSession(&self, riid: *const windows_core::GUID, ppprotectedsession: *mut *mut core::ffi::c_void) -> windows_core::Result<()>;
}
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
impl ID3D12VideoProcessor1_Vtbl {
    pub const fn new<Identity: ID3D12VideoProcessor1_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetProtectedResourceSession<Identity: ID3D12VideoProcessor1_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, riid: *const windows_core::GUID, ppprotectedsession: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ID3D12VideoProcessor1_Impl::GetProtectedResourceSession(this, core::mem::transmute_copy(&riid), core::mem::transmute_copy(&ppprotectedsession)).into()
            }
        }
        Self { base__: ID3D12VideoProcessor_Vtbl::new::<Identity, OFFSET>(), GetProtectedResourceSession: GetProtectedResourceSession::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<ID3D12VideoProcessor1 as windows_core::Interface>::IID || iid == &<super::super::Graphics::Direct3D12::ID3D12Object as windows_core::Interface>::IID || iid == &<super::super::Graphics::Direct3D12::ID3D12DeviceChild as windows_core::Interface>::IID || iid == &<super::super::Graphics::Direct3D12::ID3D12Pageable as windows_core::Interface>::IID || iid == &<ID3D12VideoProcessor as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
impl windows_core::RuntimeName for ID3D12VideoProcessor1 {}
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
unsafe impl Send for ID3D12VideoProcessor1 {}
#[cfg(all(feature = "Win32_Graphics_Direct3D12", feature = "Win32_Graphics_Dxgi_Common"))]
unsafe impl Sync for ID3D12VideoProcessor1 {}
windows_core::imp::define_interface!(IDXVAHD_Device, IDXVAHD_Device_Vtbl, 0x95f12dfd_d77e_49be_815f_57d579634d6d);
windows_core::imp::interface_hierarchy!(IDXVAHD_Device, windows_core::IUnknown);
impl IDXVAHD_Device {
    #[cfg(feature = "Win32_Graphics_Direct3D9")]
    pub unsafe fn CreateVideoSurface(&self, width: u32, height: u32, format: super::super::Graphics::Direct3D9::D3DFORMAT, pool: super::super::Graphics::Direct3D9::D3DPOOL, usage: u32, r#type: DXVAHD_SURFACE_TYPE, ppsurfaces: &mut [Option<super::super::Graphics::Direct3D9::IDirect3DSurface9>], psharedhandle: Option<*mut super::super::Foundation::HANDLE>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).CreateVideoSurface)(windows_core::Interface::as_raw(self), width, height, format, pool, usage, r#type, ppsurfaces.len().try_into().unwrap(), core::mem::transmute(ppsurfaces.as_ptr()), psharedhandle.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    #[cfg(feature = "Win32_Graphics_Direct3D9")]
    pub unsafe fn GetVideoProcessorDeviceCaps(&self, pcaps: *mut DXVAHD_VPDEVCAPS) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetVideoProcessorDeviceCaps)(windows_core::Interface::as_raw(self), pcaps as _).ok() }
    }
    #[cfg(feature = "Win32_Graphics_Direct3D9")]
    pub unsafe fn GetVideoProcessorOutputFormats(&self, pformats: &mut [super::super::Graphics::Direct3D9::D3DFORMAT]) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetVideoProcessorOutputFormats)(windows_core::Interface::as_raw(self), pformats.len().try_into().unwrap(), core::mem::transmute(pformats.as_ptr())).ok() }
    }
    #[cfg(feature = "Win32_Graphics_Direct3D9")]
    pub unsafe fn GetVideoProcessorInputFormats(&self, pformats: &mut [super::super::Graphics::Direct3D9::D3DFORMAT]) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetVideoProcessorInputFormats)(windows_core::Interface::as_raw(self), pformats.len().try_into().unwrap(), core::mem::transmute(pformats.as_ptr())).ok() }
    }
    pub unsafe fn GetVideoProcessorCaps(&self, pcaps: &mut [DXVAHD_VPCAPS]) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetVideoProcessorCaps)(windows_core::Interface::as_raw(self), pcaps.len().try_into().unwrap(), core::mem::transmute(pcaps.as_ptr())).ok() }
    }
    pub unsafe fn GetVideoProcessorCustomRates(&self, pvpguid: *const windows_core::GUID, prates: &mut [DXVAHD_CUSTOM_RATE_DATA]) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetVideoProcessorCustomRates)(windows_core::Interface::as_raw(self), pvpguid, prates.len().try_into().unwrap(), core::mem::transmute(prates.as_ptr())).ok() }
    }
    pub unsafe fn GetVideoProcessorFilterRange(&self, filter: DXVAHD_FILTER) -> windows_core::Result<DXVAHD_FILTER_RANGE_DATA> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetVideoProcessorFilterRange)(windows_core::Interface::as_raw(self), filter, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn CreateVideoProcessor(&self, pvpguid: *const windows_core::GUID) -> windows_core::Result<IDXVAHD_VideoProcessor> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).CreateVideoProcessor)(windows_core::Interface::as_raw(self), pvpguid, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
}
#[repr(C)]
pub struct IDXVAHD_Device_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Graphics_Direct3D9")]
    pub CreateVideoSurface: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, super::super::Graphics::Direct3D9::D3DFORMAT, super::super::Graphics::Direct3D9::D3DPOOL, u32, DXVAHD_SURFACE_TYPE, u32, *mut *mut core::ffi::c_void, *mut super::super::Foundation::HANDLE) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Direct3D9"))]
    CreateVideoSurface: usize,
    #[cfg(feature = "Win32_Graphics_Direct3D9")]
    pub GetVideoProcessorDeviceCaps: unsafe extern "system" fn(*mut core::ffi::c_void, *mut DXVAHD_VPDEVCAPS) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Direct3D9"))]
    GetVideoProcessorDeviceCaps: usize,
    #[cfg(feature = "Win32_Graphics_Direct3D9")]
    pub GetVideoProcessorOutputFormats: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut super::super::Graphics::Direct3D9::D3DFORMAT) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Direct3D9"))]
    GetVideoProcessorOutputFormats: usize,
    #[cfg(feature = "Win32_Graphics_Direct3D9")]
    pub GetVideoProcessorInputFormats: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut super::super::Graphics::Direct3D9::D3DFORMAT) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Direct3D9"))]
    GetVideoProcessorInputFormats: usize,
    pub GetVideoProcessorCaps: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut DXVAHD_VPCAPS) -> windows_core::HRESULT,
    pub GetVideoProcessorCustomRates: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID, u32, *mut DXVAHD_CUSTOM_RATE_DATA) -> windows_core::HRESULT,
    pub GetVideoProcessorFilterRange: unsafe extern "system" fn(*mut core::ffi::c_void, DXVAHD_FILTER, *mut DXVAHD_FILTER_RANGE_DATA) -> windows_core::HRESULT,
    pub CreateVideoProcessor: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
pub trait IDXVAHD_Device_Impl: windows_core::IUnknownImpl {
    fn CreateVideoSurface(&self, width: u32, height: u32, format: super::super::Graphics::Direct3D9::D3DFORMAT, pool: super::super::Graphics::Direct3D9::D3DPOOL, usage: u32, r#type: DXVAHD_SURFACE_TYPE, numsurfaces: u32, ppsurfaces: windows_core::OutRef<'_, super::super::Graphics::Direct3D9::IDirect3DSurface9>, psharedhandle: *mut super::super::Foundation::HANDLE) -> windows_core::Result<()>;
    fn GetVideoProcessorDeviceCaps(&self, pcaps: *mut DXVAHD_VPDEVCAPS) -> windows_core::Result<()>;
    fn GetVideoProcessorOutputFormats(&self, count: u32, pformats: *mut super::super::Graphics::Direct3D9::D3DFORMAT) -> windows_core::Result<()>;
    fn GetVideoProcessorInputFormats(&self, count: u32, pformats: *mut super::super::Graphics::Direct3D9::D3DFORMAT) -> windows_core::Result<()>;
    fn GetVideoProcessorCaps(&self, count: u32, pcaps: *mut DXVAHD_VPCAPS) -> windows_core::Result<()>;
    fn GetVideoProcessorCustomRates(&self, pvpguid: *const windows_core::GUID, count: u32, prates: *mut DXVAHD_CUSTOM_RATE_DATA) -> windows_core::Result<()>;
    fn GetVideoProcessorFilterRange(&self, filter: DXVAHD_FILTER) -> windows_core::Result<DXVAHD_FILTER_RANGE_DATA>;
    fn CreateVideoProcessor(&self, pvpguid: *const windows_core::GUID) -> windows_core::Result<IDXVAHD_VideoProcessor>;
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl IDXVAHD_Device_Vtbl {
    pub const fn new<Identity: IDXVAHD_Device_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn CreateVideoSurface<Identity: IDXVAHD_Device_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, width: u32, height: u32, format: super::super::Graphics::Direct3D9::D3DFORMAT, pool: super::super::Graphics::Direct3D9::D3DPOOL, usage: u32, r#type: DXVAHD_SURFACE_TYPE, numsurfaces: u32, ppsurfaces: *mut *mut core::ffi::c_void, psharedhandle: *mut super::super::Foundation::HANDLE) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDXVAHD_Device_Impl::CreateVideoSurface(this, core::mem::transmute_copy(&width), core::mem::transmute_copy(&height), core::mem::transmute_copy(&format), core::mem::transmute_copy(&pool), core::mem::transmute_copy(&usage), core::mem::transmute_copy(&r#type), core::mem::transmute_copy(&numsurfaces), core::mem::transmute_copy(&ppsurfaces), core::mem::transmute_copy(&psharedhandle)).into()
            }
        }
        unsafe extern "system" fn GetVideoProcessorDeviceCaps<Identity: IDXVAHD_Device_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pcaps: *mut DXVAHD_VPDEVCAPS) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDXVAHD_Device_Impl::GetVideoProcessorDeviceCaps(this, core::mem::transmute_copy(&pcaps)).into()
            }
        }
        unsafe extern "system" fn GetVideoProcessorOutputFormats<Identity: IDXVAHD_Device_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, count: u32, pformats: *mut super::super::Graphics::Direct3D9::D3DFORMAT) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDXVAHD_Device_Impl::GetVideoProcessorOutputFormats(this, core::mem::transmute_copy(&count), core::mem::transmute_copy(&pformats)).into()
            }
        }
        unsafe extern "system" fn GetVideoProcessorInputFormats<Identity: IDXVAHD_Device_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, count: u32, pformats: *mut super::super::Graphics::Direct3D9::D3DFORMAT) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDXVAHD_Device_Impl::GetVideoProcessorInputFormats(this, core::mem::transmute_copy(&count), core::mem::transmute_copy(&pformats)).into()
            }
        }
        unsafe extern "system" fn GetVideoProcessorCaps<Identity: IDXVAHD_Device_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, count: u32, pcaps: *mut DXVAHD_VPCAPS) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDXVAHD_Device_Impl::GetVideoProcessorCaps(this, core::mem::transmute_copy(&count), core::mem::transmute_copy(&pcaps)).into()
            }
        }
        unsafe extern "system" fn GetVideoProcessorCustomRates<Identity: IDXVAHD_Device_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pvpguid: *const windows_core::GUID, count: u32, prates: *mut DXVAHD_CUSTOM_RATE_DATA) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDXVAHD_Device_Impl::GetVideoProcessorCustomRates(this, core::mem::transmute_copy(&pvpguid), core::mem::transmute_copy(&count), core::mem::transmute_copy(&prates)).into()
            }
        }
        unsafe extern "system" fn GetVideoProcessorFilterRange<Identity: IDXVAHD_Device_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, filter: DXVAHD_FILTER, prange: *mut DXVAHD_FILTER_RANGE_DATA) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDXVAHD_Device_Impl::GetVideoProcessorFilterRange(this, core::mem::transmute_copy(&filter)) {
                    Ok(ok__) => {
                        prange.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn CreateVideoProcessor<Identity: IDXVAHD_Device_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pvpguid: *const windows_core::GUID, ppvideoprocessor: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDXVAHD_Device_Impl::CreateVideoProcessor(this, core::mem::transmute_copy(&pvpguid)) {
                    Ok(ok__) => {
                        ppvideoprocessor.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            CreateVideoSurface: CreateVideoSurface::<Identity, OFFSET>,
            GetVideoProcessorDeviceCaps: GetVideoProcessorDeviceCaps::<Identity, OFFSET>,
            GetVideoProcessorOutputFormats: GetVideoProcessorOutputFormats::<Identity, OFFSET>,
            GetVideoProcessorInputFormats: GetVideoProcessorInputFormats::<Identity, OFFSET>,
            GetVideoProcessorCaps: GetVideoProcessorCaps::<Identity, OFFSET>,
            GetVideoProcessorCustomRates: GetVideoProcessorCustomRates::<Identity, OFFSET>,
            GetVideoProcessorFilterRange: GetVideoProcessorFilterRange::<Identity, OFFSET>,
            CreateVideoProcessor: CreateVideoProcessor::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDXVAHD_Device as windows_core::Interface>::IID
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl windows_core::RuntimeName for IDXVAHD_Device {}
windows_core::imp::define_interface!(IDXVAHD_VideoProcessor, IDXVAHD_VideoProcessor_Vtbl, 0x95f4edf4_6e03_4cd7_be1b_3075d665aa52);
windows_core::imp::interface_hierarchy!(IDXVAHD_VideoProcessor, windows_core::IUnknown);
impl IDXVAHD_VideoProcessor {
    pub unsafe fn SetVideoProcessBltState(&self, state: DXVAHD_BLT_STATE, datasize: u32, pdata: *const core::ffi::c_void) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetVideoProcessBltState)(windows_core::Interface::as_raw(self), state, datasize, pdata).ok() }
    }
    pub unsafe fn GetVideoProcessBltState(&self, state: DXVAHD_BLT_STATE, datasize: u32, pdata: *mut core::ffi::c_void) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetVideoProcessBltState)(windows_core::Interface::as_raw(self), state, datasize, pdata as _).ok() }
    }
    pub unsafe fn SetVideoProcessStreamState(&self, streamnumber: u32, state: DXVAHD_STREAM_STATE, datasize: u32, pdata: *const core::ffi::c_void) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetVideoProcessStreamState)(windows_core::Interface::as_raw(self), streamnumber, state, datasize, pdata).ok() }
    }
    pub unsafe fn GetVideoProcessStreamState(&self, streamnumber: u32, state: DXVAHD_STREAM_STATE, datasize: u32, pdata: *mut core::ffi::c_void) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetVideoProcessStreamState)(windows_core::Interface::as_raw(self), streamnumber, state, datasize, pdata as _).ok() }
    }
    #[cfg(feature = "Win32_Graphics_Direct3D9")]
    pub unsafe fn VideoProcessBltHD<P0>(&self, poutputsurface: P0, outputframe: u32, pstreams: &[DXVAHD_STREAM_DATA]) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Graphics::Direct3D9::IDirect3DSurface9>,
    {
        unsafe { (windows_core::Interface::vtable(self).VideoProcessBltHD)(windows_core::Interface::as_raw(self), poutputsurface.param().abi(), outputframe, pstreams.len().try_into().unwrap(), core::mem::transmute(pstreams.as_ptr())).ok() }
    }
}
#[repr(C)]
pub struct IDXVAHD_VideoProcessor_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub SetVideoProcessBltState: unsafe extern "system" fn(*mut core::ffi::c_void, DXVAHD_BLT_STATE, u32, *const core::ffi::c_void) -> windows_core::HRESULT,
    pub GetVideoProcessBltState: unsafe extern "system" fn(*mut core::ffi::c_void, DXVAHD_BLT_STATE, u32, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetVideoProcessStreamState: unsafe extern "system" fn(*mut core::ffi::c_void, u32, DXVAHD_STREAM_STATE, u32, *const core::ffi::c_void) -> windows_core::HRESULT,
    pub GetVideoProcessStreamState: unsafe extern "system" fn(*mut core::ffi::c_void, u32, DXVAHD_STREAM_STATE, u32, *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_Graphics_Direct3D9")]
    pub VideoProcessBltHD: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, u32, u32, *const DXVAHD_STREAM_DATA) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Direct3D9"))]
    VideoProcessBltHD: usize,
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
pub trait IDXVAHD_VideoProcessor_Impl: windows_core::IUnknownImpl {
    fn SetVideoProcessBltState(&self, state: DXVAHD_BLT_STATE, datasize: u32, pdata: *const core::ffi::c_void) -> windows_core::Result<()>;
    fn GetVideoProcessBltState(&self, state: DXVAHD_BLT_STATE, datasize: u32, pdata: *mut core::ffi::c_void) -> windows_core::Result<()>;
    fn SetVideoProcessStreamState(&self, streamnumber: u32, state: DXVAHD_STREAM_STATE, datasize: u32, pdata: *const core::ffi::c_void) -> windows_core::Result<()>;
    fn GetVideoProcessStreamState(&self, streamnumber: u32, state: DXVAHD_STREAM_STATE, datasize: u32, pdata: *mut core::ffi::c_void) -> windows_core::Result<()>;
    fn VideoProcessBltHD(&self, poutputsurface: windows_core::Ref<'_, super::super::Graphics::Direct3D9::IDirect3DSurface9>, outputframe: u32, streamcount: u32, pstreams: *const DXVAHD_STREAM_DATA) -> windows_core::Result<()>;
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl IDXVAHD_VideoProcessor_Vtbl {
    pub const fn new<Identity: IDXVAHD_VideoProcessor_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn SetVideoProcessBltState<Identity: IDXVAHD_VideoProcessor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, state: DXVAHD_BLT_STATE, datasize: u32, pdata: *const core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDXVAHD_VideoProcessor_Impl::SetVideoProcessBltState(this, core::mem::transmute_copy(&state), core::mem::transmute_copy(&datasize), core::mem::transmute_copy(&pdata)).into()
            }
        }
        unsafe extern "system" fn GetVideoProcessBltState<Identity: IDXVAHD_VideoProcessor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, state: DXVAHD_BLT_STATE, datasize: u32, pdata: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDXVAHD_VideoProcessor_Impl::GetVideoProcessBltState(this, core::mem::transmute_copy(&state), core::mem::transmute_copy(&datasize), core::mem::transmute_copy(&pdata)).into()
            }
        }
        unsafe extern "system" fn SetVideoProcessStreamState<Identity: IDXVAHD_VideoProcessor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, streamnumber: u32, state: DXVAHD_STREAM_STATE, datasize: u32, pdata: *const core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDXVAHD_VideoProcessor_Impl::SetVideoProcessStreamState(this, core::mem::transmute_copy(&streamnumber), core::mem::transmute_copy(&state), core::mem::transmute_copy(&datasize), core::mem::transmute_copy(&pdata)).into()
            }
        }
        unsafe extern "system" fn GetVideoProcessStreamState<Identity: IDXVAHD_VideoProcessor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, streamnumber: u32, state: DXVAHD_STREAM_STATE, datasize: u32, pdata: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDXVAHD_VideoProcessor_Impl::GetVideoProcessStreamState(this, core::mem::transmute_copy(&streamnumber), core::mem::transmute_copy(&state), core::mem::transmute_copy(&datasize), core::mem::transmute_copy(&pdata)).into()
            }
        }
        unsafe extern "system" fn VideoProcessBltHD<Identity: IDXVAHD_VideoProcessor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, poutputsurface: *mut core::ffi::c_void, outputframe: u32, streamcount: u32, pstreams: *const DXVAHD_STREAM_DATA) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDXVAHD_VideoProcessor_Impl::VideoProcessBltHD(this, core::mem::transmute_copy(&poutputsurface), core::mem::transmute_copy(&outputframe), core::mem::transmute_copy(&streamcount), core::mem::transmute_copy(&pstreams)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            SetVideoProcessBltState: SetVideoProcessBltState::<Identity, OFFSET>,
            GetVideoProcessBltState: GetVideoProcessBltState::<Identity, OFFSET>,
            SetVideoProcessStreamState: SetVideoProcessStreamState::<Identity, OFFSET>,
            GetVideoProcessStreamState: GetVideoProcessStreamState::<Identity, OFFSET>,
            VideoProcessBltHD: VideoProcessBltHD::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDXVAHD_VideoProcessor as windows_core::Interface>::IID
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl windows_core::RuntimeName for IDXVAHD_VideoProcessor {}
windows_core::imp::define_interface!(IDirect3D9ExOverlayExtension, IDirect3D9ExOverlayExtension_Vtbl, 0x187aeb13_aaf5_4c59_876d_e059088c0df8);
windows_core::imp::interface_hierarchy!(IDirect3D9ExOverlayExtension, windows_core::IUnknown);
impl IDirect3D9ExOverlayExtension {
    #[cfg(feature = "Win32_Graphics_Direct3D9")]
    pub unsafe fn CheckDeviceOverlayType(&self, adapter: u32, devtype: super::super::Graphics::Direct3D9::D3DDEVTYPE, overlaywidth: u32, overlayheight: u32, overlayformat: super::super::Graphics::Direct3D9::D3DFORMAT, pdisplaymode: *mut super::super::Graphics::Direct3D9::D3DDISPLAYMODEEX, displayrotation: super::super::Graphics::Direct3D9::D3DDISPLAYROTATION, poverlaycaps: *mut D3DOVERLAYCAPS) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).CheckDeviceOverlayType)(windows_core::Interface::as_raw(self), adapter, devtype, overlaywidth, overlayheight, overlayformat, pdisplaymode as _, displayrotation, poverlaycaps as _).ok() }
    }
}
#[repr(C)]
pub struct IDirect3D9ExOverlayExtension_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Graphics_Direct3D9")]
    pub CheckDeviceOverlayType: unsafe extern "system" fn(*mut core::ffi::c_void, u32, super::super::Graphics::Direct3D9::D3DDEVTYPE, u32, u32, super::super::Graphics::Direct3D9::D3DFORMAT, *mut super::super::Graphics::Direct3D9::D3DDISPLAYMODEEX, super::super::Graphics::Direct3D9::D3DDISPLAYROTATION, *mut D3DOVERLAYCAPS) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Direct3D9"))]
    CheckDeviceOverlayType: usize,
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
pub trait IDirect3D9ExOverlayExtension_Impl: windows_core::IUnknownImpl {
    fn CheckDeviceOverlayType(&self, adapter: u32, devtype: super::super::Graphics::Direct3D9::D3DDEVTYPE, overlaywidth: u32, overlayheight: u32, overlayformat: super::super::Graphics::Direct3D9::D3DFORMAT, pdisplaymode: *mut super::super::Graphics::Direct3D9::D3DDISPLAYMODEEX, displayrotation: super::super::Graphics::Direct3D9::D3DDISPLAYROTATION, poverlaycaps: *mut D3DOVERLAYCAPS) -> windows_core::Result<()>;
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl IDirect3D9ExOverlayExtension_Vtbl {
    pub const fn new<Identity: IDirect3D9ExOverlayExtension_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn CheckDeviceOverlayType<Identity: IDirect3D9ExOverlayExtension_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, adapter: u32, devtype: super::super::Graphics::Direct3D9::D3DDEVTYPE, overlaywidth: u32, overlayheight: u32, overlayformat: super::super::Graphics::Direct3D9::D3DFORMAT, pdisplaymode: *mut super::super::Graphics::Direct3D9::D3DDISPLAYMODEEX, displayrotation: super::super::Graphics::Direct3D9::D3DDISPLAYROTATION, poverlaycaps: *mut D3DOVERLAYCAPS) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDirect3D9ExOverlayExtension_Impl::CheckDeviceOverlayType(this, core::mem::transmute_copy(&adapter), core::mem::transmute_copy(&devtype), core::mem::transmute_copy(&overlaywidth), core::mem::transmute_copy(&overlayheight), core::mem::transmute_copy(&overlayformat), core::mem::transmute_copy(&pdisplaymode), core::mem::transmute_copy(&displayrotation), core::mem::transmute_copy(&poverlaycaps)).into()
            }
        }
        Self { base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(), CheckDeviceOverlayType: CheckDeviceOverlayType::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDirect3D9ExOverlayExtension as windows_core::Interface>::IID
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl windows_core::RuntimeName for IDirect3D9ExOverlayExtension {}
windows_core::imp::define_interface!(IDirect3DAuthenticatedChannel9, IDirect3DAuthenticatedChannel9_Vtbl, 0xff24beee_da21_4beb_98b5_d2f899f98af9);
windows_core::imp::interface_hierarchy!(IDirect3DAuthenticatedChannel9, windows_core::IUnknown);
impl IDirect3DAuthenticatedChannel9 {
    pub unsafe fn GetCertificateSize(&self, pcertificatesize: *mut u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetCertificateSize)(windows_core::Interface::as_raw(self), pcertificatesize as _).ok() }
    }
    pub unsafe fn GetCertificate(&self, certifactesize: u32, ppcertificate: *mut u8) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetCertificate)(windows_core::Interface::as_raw(self), certifactesize, ppcertificate as _).ok() }
    }
    pub unsafe fn NegotiateKeyExchange(&self, datasize: u32, pdata: *mut core::ffi::c_void) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).NegotiateKeyExchange)(windows_core::Interface::as_raw(self), datasize, pdata as _).ok() }
    }
    pub unsafe fn Query(&self, inputsize: u32, pinput: *const core::ffi::c_void, outputsize: u32, poutput: *mut core::ffi::c_void) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Query)(windows_core::Interface::as_raw(self), inputsize, pinput, outputsize, poutput as _).ok() }
    }
    #[cfg(feature = "Win32_Graphics_Direct3D9")]
    pub unsafe fn Configure(&self, inputsize: u32, pinput: *const core::ffi::c_void, poutput: *mut super::super::Graphics::Direct3D9::D3DAUTHENTICATEDCHANNEL_CONFIGURE_OUTPUT) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Configure)(windows_core::Interface::as_raw(self), inputsize, pinput, poutput as _).ok() }
    }
}
#[repr(C)]
pub struct IDirect3DAuthenticatedChannel9_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetCertificateSize: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetCertificate: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut u8) -> windows_core::HRESULT,
    pub NegotiateKeyExchange: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub Query: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const core::ffi::c_void, u32, *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_Graphics_Direct3D9")]
    pub Configure: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const core::ffi::c_void, *mut super::super::Graphics::Direct3D9::D3DAUTHENTICATEDCHANNEL_CONFIGURE_OUTPUT) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Direct3D9"))]
    Configure: usize,
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
pub trait IDirect3DAuthenticatedChannel9_Impl: windows_core::IUnknownImpl {
    fn GetCertificateSize(&self, pcertificatesize: *mut u32) -> windows_core::Result<()>;
    fn GetCertificate(&self, certifactesize: u32, ppcertificate: *mut u8) -> windows_core::Result<()>;
    fn NegotiateKeyExchange(&self, datasize: u32, pdata: *mut core::ffi::c_void) -> windows_core::Result<()>;
    fn Query(&self, inputsize: u32, pinput: *const core::ffi::c_void, outputsize: u32, poutput: *mut core::ffi::c_void) -> windows_core::Result<()>;
    fn Configure(&self, inputsize: u32, pinput: *const core::ffi::c_void, poutput: *mut super::super::Graphics::Direct3D9::D3DAUTHENTICATEDCHANNEL_CONFIGURE_OUTPUT) -> windows_core::Result<()>;
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl IDirect3DAuthenticatedChannel9_Vtbl {
    pub const fn new<Identity: IDirect3DAuthenticatedChannel9_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetCertificateSize<Identity: IDirect3DAuthenticatedChannel9_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pcertificatesize: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDirect3DAuthenticatedChannel9_Impl::GetCertificateSize(this, core::mem::transmute_copy(&pcertificatesize)).into()
            }
        }
        unsafe extern "system" fn GetCertificate<Identity: IDirect3DAuthenticatedChannel9_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, certifactesize: u32, ppcertificate: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDirect3DAuthenticatedChannel9_Impl::GetCertificate(this, core::mem::transmute_copy(&certifactesize), core::mem::transmute_copy(&ppcertificate)).into()
            }
        }
        unsafe extern "system" fn NegotiateKeyExchange<Identity: IDirect3DAuthenticatedChannel9_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, datasize: u32, pdata: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDirect3DAuthenticatedChannel9_Impl::NegotiateKeyExchange(this, core::mem::transmute_copy(&datasize), core::mem::transmute_copy(&pdata)).into()
            }
        }
        unsafe extern "system" fn Query<Identity: IDirect3DAuthenticatedChannel9_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, inputsize: u32, pinput: *const core::ffi::c_void, outputsize: u32, poutput: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDirect3DAuthenticatedChannel9_Impl::Query(this, core::mem::transmute_copy(&inputsize), core::mem::transmute_copy(&pinput), core::mem::transmute_copy(&outputsize), core::mem::transmute_copy(&poutput)).into()
            }
        }
        unsafe extern "system" fn Configure<Identity: IDirect3DAuthenticatedChannel9_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, inputsize: u32, pinput: *const core::ffi::c_void, poutput: *mut super::super::Graphics::Direct3D9::D3DAUTHENTICATEDCHANNEL_CONFIGURE_OUTPUT) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDirect3DAuthenticatedChannel9_Impl::Configure(this, core::mem::transmute_copy(&inputsize), core::mem::transmute_copy(&pinput), core::mem::transmute_copy(&poutput)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetCertificateSize: GetCertificateSize::<Identity, OFFSET>,
            GetCertificate: GetCertificate::<Identity, OFFSET>,
            NegotiateKeyExchange: NegotiateKeyExchange::<Identity, OFFSET>,
            Query: Query::<Identity, OFFSET>,
            Configure: Configure::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDirect3DAuthenticatedChannel9 as windows_core::Interface>::IID
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl windows_core::RuntimeName for IDirect3DAuthenticatedChannel9 {}
windows_core::imp::define_interface!(IDirect3DCryptoSession9, IDirect3DCryptoSession9_Vtbl, 0xfa0ab799_7a9c_48ca_8c5b_237e71a54434);
windows_core::imp::interface_hierarchy!(IDirect3DCryptoSession9, windows_core::IUnknown);
impl IDirect3DCryptoSession9 {
    pub unsafe fn GetCertificateSize(&self, pcertificatesize: *mut u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetCertificateSize)(windows_core::Interface::as_raw(self), pcertificatesize as _).ok() }
    }
    pub unsafe fn GetCertificate(&self, certifactesize: u32, ppcertificate: *mut u8) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetCertificate)(windows_core::Interface::as_raw(self), certifactesize, ppcertificate as _).ok() }
    }
    pub unsafe fn NegotiateKeyExchange(&self, datasize: u32, pdata: *mut core::ffi::c_void) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).NegotiateKeyExchange)(windows_core::Interface::as_raw(self), datasize, pdata as _).ok() }
    }
    #[cfg(feature = "Win32_Graphics_Direct3D9")]
    pub unsafe fn EncryptionBlt<P0, P1>(&self, psrcsurface: P0, pdstsurface: P1, dstsurfacesize: u32, piv: *mut core::ffi::c_void) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Graphics::Direct3D9::IDirect3DSurface9>,
        P1: windows_core::Param<super::super::Graphics::Direct3D9::IDirect3DSurface9>,
    {
        unsafe { (windows_core::Interface::vtable(self).EncryptionBlt)(windows_core::Interface::as_raw(self), psrcsurface.param().abi(), pdstsurface.param().abi(), dstsurfacesize, piv as _).ok() }
    }
    #[cfg(feature = "Win32_Graphics_Direct3D9")]
    pub unsafe fn DecryptionBlt<P0, P1>(&self, psrcsurface: P0, pdstsurface: P1, srcsurfacesize: u32, pencryptedblockinfo: *mut super::super::Graphics::Direct3D9::D3DENCRYPTED_BLOCK_INFO, pcontentkey: *mut core::ffi::c_void, piv: *mut core::ffi::c_void) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Graphics::Direct3D9::IDirect3DSurface9>,
        P1: windows_core::Param<super::super::Graphics::Direct3D9::IDirect3DSurface9>,
    {
        unsafe { (windows_core::Interface::vtable(self).DecryptionBlt)(windows_core::Interface::as_raw(self), psrcsurface.param().abi(), pdstsurface.param().abi(), srcsurfacesize, pencryptedblockinfo as _, pcontentkey as _, piv as _).ok() }
    }
    #[cfg(feature = "Win32_Graphics_Direct3D9")]
    pub unsafe fn GetSurfacePitch<P0>(&self, psrcsurface: P0, psurfacepitch: *mut u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Graphics::Direct3D9::IDirect3DSurface9>,
    {
        unsafe { (windows_core::Interface::vtable(self).GetSurfacePitch)(windows_core::Interface::as_raw(self), psrcsurface.param().abi(), psurfacepitch as _).ok() }
    }
    pub unsafe fn StartSessionKeyRefresh(&self, prandomnumber: *mut core::ffi::c_void, randomnumbersize: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).StartSessionKeyRefresh)(windows_core::Interface::as_raw(self), prandomnumber as _, randomnumbersize).ok() }
    }
    pub unsafe fn FinishSessionKeyRefresh(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).FinishSessionKeyRefresh)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn GetEncryptionBltKey(&self, preadbackkey: *mut core::ffi::c_void, keysize: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetEncryptionBltKey)(windows_core::Interface::as_raw(self), preadbackkey as _, keysize).ok() }
    }
}
#[repr(C)]
pub struct IDirect3DCryptoSession9_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetCertificateSize: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetCertificate: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut u8) -> windows_core::HRESULT,
    pub NegotiateKeyExchange: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_Graphics_Direct3D9")]
    pub EncryptionBlt: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut core::ffi::c_void, u32, *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Direct3D9"))]
    EncryptionBlt: usize,
    #[cfg(feature = "Win32_Graphics_Direct3D9")]
    pub DecryptionBlt: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut core::ffi::c_void, u32, *mut super::super::Graphics::Direct3D9::D3DENCRYPTED_BLOCK_INFO, *mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Direct3D9"))]
    DecryptionBlt: usize,
    #[cfg(feature = "Win32_Graphics_Direct3D9")]
    pub GetSurfacePitch: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Direct3D9"))]
    GetSurfacePitch: usize,
    pub StartSessionKeyRefresh: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub FinishSessionKeyRefresh: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetEncryptionBltKey: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, u32) -> windows_core::HRESULT,
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
pub trait IDirect3DCryptoSession9_Impl: windows_core::IUnknownImpl {
    fn GetCertificateSize(&self, pcertificatesize: *mut u32) -> windows_core::Result<()>;
    fn GetCertificate(&self, certifactesize: u32, ppcertificate: *mut u8) -> windows_core::Result<()>;
    fn NegotiateKeyExchange(&self, datasize: u32, pdata: *mut core::ffi::c_void) -> windows_core::Result<()>;
    fn EncryptionBlt(&self, psrcsurface: windows_core::Ref<'_, super::super::Graphics::Direct3D9::IDirect3DSurface9>, pdstsurface: windows_core::Ref<'_, super::super::Graphics::Direct3D9::IDirect3DSurface9>, dstsurfacesize: u32, piv: *mut core::ffi::c_void) -> windows_core::Result<()>;
    fn DecryptionBlt(&self, psrcsurface: windows_core::Ref<'_, super::super::Graphics::Direct3D9::IDirect3DSurface9>, pdstsurface: windows_core::Ref<'_, super::super::Graphics::Direct3D9::IDirect3DSurface9>, srcsurfacesize: u32, pencryptedblockinfo: *mut super::super::Graphics::Direct3D9::D3DENCRYPTED_BLOCK_INFO, pcontentkey: *mut core::ffi::c_void, piv: *mut core::ffi::c_void) -> windows_core::Result<()>;
    fn GetSurfacePitch(&self, psrcsurface: windows_core::Ref<'_, super::super::Graphics::Direct3D9::IDirect3DSurface9>, psurfacepitch: *mut u32) -> windows_core::Result<()>;
    fn StartSessionKeyRefresh(&self, prandomnumber: *mut core::ffi::c_void, randomnumbersize: u32) -> windows_core::Result<()>;
    fn FinishSessionKeyRefresh(&self) -> windows_core::Result<()>;
    fn GetEncryptionBltKey(&self, preadbackkey: *mut core::ffi::c_void, keysize: u32) -> windows_core::Result<()>;
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl IDirect3DCryptoSession9_Vtbl {
    pub const fn new<Identity: IDirect3DCryptoSession9_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetCertificateSize<Identity: IDirect3DCryptoSession9_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pcertificatesize: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDirect3DCryptoSession9_Impl::GetCertificateSize(this, core::mem::transmute_copy(&pcertificatesize)).into()
            }
        }
        unsafe extern "system" fn GetCertificate<Identity: IDirect3DCryptoSession9_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, certifactesize: u32, ppcertificate: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDirect3DCryptoSession9_Impl::GetCertificate(this, core::mem::transmute_copy(&certifactesize), core::mem::transmute_copy(&ppcertificate)).into()
            }
        }
        unsafe extern "system" fn NegotiateKeyExchange<Identity: IDirect3DCryptoSession9_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, datasize: u32, pdata: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDirect3DCryptoSession9_Impl::NegotiateKeyExchange(this, core::mem::transmute_copy(&datasize), core::mem::transmute_copy(&pdata)).into()
            }
        }
        unsafe extern "system" fn EncryptionBlt<Identity: IDirect3DCryptoSession9_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, psrcsurface: *mut core::ffi::c_void, pdstsurface: *mut core::ffi::c_void, dstsurfacesize: u32, piv: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDirect3DCryptoSession9_Impl::EncryptionBlt(this, core::mem::transmute_copy(&psrcsurface), core::mem::transmute_copy(&pdstsurface), core::mem::transmute_copy(&dstsurfacesize), core::mem::transmute_copy(&piv)).into()
            }
        }
        unsafe extern "system" fn DecryptionBlt<Identity: IDirect3DCryptoSession9_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, psrcsurface: *mut core::ffi::c_void, pdstsurface: *mut core::ffi::c_void, srcsurfacesize: u32, pencryptedblockinfo: *mut super::super::Graphics::Direct3D9::D3DENCRYPTED_BLOCK_INFO, pcontentkey: *mut core::ffi::c_void, piv: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDirect3DCryptoSession9_Impl::DecryptionBlt(this, core::mem::transmute_copy(&psrcsurface), core::mem::transmute_copy(&pdstsurface), core::mem::transmute_copy(&srcsurfacesize), core::mem::transmute_copy(&pencryptedblockinfo), core::mem::transmute_copy(&pcontentkey), core::mem::transmute_copy(&piv)).into()
            }
        }
        unsafe extern "system" fn GetSurfacePitch<Identity: IDirect3DCryptoSession9_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, psrcsurface: *mut core::ffi::c_void, psurfacepitch: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDirect3DCryptoSession9_Impl::GetSurfacePitch(this, core::mem::transmute_copy(&psrcsurface), core::mem::transmute_copy(&psurfacepitch)).into()
            }
        }
        unsafe extern "system" fn StartSessionKeyRefresh<Identity: IDirect3DCryptoSession9_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, prandomnumber: *mut core::ffi::c_void, randomnumbersize: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDirect3DCryptoSession9_Impl::StartSessionKeyRefresh(this, core::mem::transmute_copy(&prandomnumber), core::mem::transmute_copy(&randomnumbersize)).into()
            }
        }
        unsafe extern "system" fn FinishSessionKeyRefresh<Identity: IDirect3DCryptoSession9_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDirect3DCryptoSession9_Impl::FinishSessionKeyRefresh(this).into()
            }
        }
        unsafe extern "system" fn GetEncryptionBltKey<Identity: IDirect3DCryptoSession9_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, preadbackkey: *mut core::ffi::c_void, keysize: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDirect3DCryptoSession9_Impl::GetEncryptionBltKey(this, core::mem::transmute_copy(&preadbackkey), core::mem::transmute_copy(&keysize)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetCertificateSize: GetCertificateSize::<Identity, OFFSET>,
            GetCertificate: GetCertificate::<Identity, OFFSET>,
            NegotiateKeyExchange: NegotiateKeyExchange::<Identity, OFFSET>,
            EncryptionBlt: EncryptionBlt::<Identity, OFFSET>,
            DecryptionBlt: DecryptionBlt::<Identity, OFFSET>,
            GetSurfacePitch: GetSurfacePitch::<Identity, OFFSET>,
            StartSessionKeyRefresh: StartSessionKeyRefresh::<Identity, OFFSET>,
            FinishSessionKeyRefresh: FinishSessionKeyRefresh::<Identity, OFFSET>,
            GetEncryptionBltKey: GetEncryptionBltKey::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDirect3DCryptoSession9 as windows_core::Interface>::IID
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl windows_core::RuntimeName for IDirect3DCryptoSession9 {}
windows_core::imp::define_interface!(IDirect3DDevice9Video, IDirect3DDevice9Video_Vtbl, 0x26dc4561_a1ee_4ae7_96da_118a36c0ec95);
windows_core::imp::interface_hierarchy!(IDirect3DDevice9Video, windows_core::IUnknown);
impl IDirect3DDevice9Video {
    pub unsafe fn GetContentProtectionCaps(&self, pcryptotype: *const windows_core::GUID, pdecodeprofile: *const windows_core::GUID, pcaps: *mut D3DCONTENTPROTECTIONCAPS) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetContentProtectionCaps)(windows_core::Interface::as_raw(self), pcryptotype, pdecodeprofile, pcaps as _).ok() }
    }
    #[cfg(feature = "Win32_Graphics_Direct3D9")]
    pub unsafe fn CreateAuthenticatedChannel(&self, channeltype: super::super::Graphics::Direct3D9::D3DAUTHENTICATEDCHANNELTYPE, ppauthenticatedchannel: *mut Option<IDirect3DAuthenticatedChannel9>, pchannelhandle: *mut super::super::Foundation::HANDLE) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).CreateAuthenticatedChannel)(windows_core::Interface::as_raw(self), channeltype, core::mem::transmute(ppauthenticatedchannel), pchannelhandle as _).ok() }
    }
    pub unsafe fn CreateCryptoSession(&self, pcryptotype: *const windows_core::GUID, pdecodeprofile: *const windows_core::GUID, ppcryptosession: *mut Option<IDirect3DCryptoSession9>, pcryptohandle: *mut super::super::Foundation::HANDLE) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).CreateCryptoSession)(windows_core::Interface::as_raw(self), pcryptotype, pdecodeprofile, core::mem::transmute(ppcryptosession), pcryptohandle as _).ok() }
    }
}
#[repr(C)]
pub struct IDirect3DDevice9Video_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetContentProtectionCaps: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID, *const windows_core::GUID, *mut D3DCONTENTPROTECTIONCAPS) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_Graphics_Direct3D9")]
    pub CreateAuthenticatedChannel: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Graphics::Direct3D9::D3DAUTHENTICATEDCHANNELTYPE, *mut *mut core::ffi::c_void, *mut super::super::Foundation::HANDLE) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Direct3D9"))]
    CreateAuthenticatedChannel: usize,
    pub CreateCryptoSession: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID, *const windows_core::GUID, *mut *mut core::ffi::c_void, *mut super::super::Foundation::HANDLE) -> windows_core::HRESULT,
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
pub trait IDirect3DDevice9Video_Impl: windows_core::IUnknownImpl {
    fn GetContentProtectionCaps(&self, pcryptotype: *const windows_core::GUID, pdecodeprofile: *const windows_core::GUID, pcaps: *mut D3DCONTENTPROTECTIONCAPS) -> windows_core::Result<()>;
    fn CreateAuthenticatedChannel(&self, channeltype: super::super::Graphics::Direct3D9::D3DAUTHENTICATEDCHANNELTYPE, ppauthenticatedchannel: windows_core::OutRef<'_, IDirect3DAuthenticatedChannel9>, pchannelhandle: *mut super::super::Foundation::HANDLE) -> windows_core::Result<()>;
    fn CreateCryptoSession(&self, pcryptotype: *const windows_core::GUID, pdecodeprofile: *const windows_core::GUID, ppcryptosession: windows_core::OutRef<'_, IDirect3DCryptoSession9>, pcryptohandle: *mut super::super::Foundation::HANDLE) -> windows_core::Result<()>;
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl IDirect3DDevice9Video_Vtbl {
    pub const fn new<Identity: IDirect3DDevice9Video_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetContentProtectionCaps<Identity: IDirect3DDevice9Video_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pcryptotype: *const windows_core::GUID, pdecodeprofile: *const windows_core::GUID, pcaps: *mut D3DCONTENTPROTECTIONCAPS) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDirect3DDevice9Video_Impl::GetContentProtectionCaps(this, core::mem::transmute_copy(&pcryptotype), core::mem::transmute_copy(&pdecodeprofile), core::mem::transmute_copy(&pcaps)).into()
            }
        }
        unsafe extern "system" fn CreateAuthenticatedChannel<Identity: IDirect3DDevice9Video_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, channeltype: super::super::Graphics::Direct3D9::D3DAUTHENTICATEDCHANNELTYPE, ppauthenticatedchannel: *mut *mut core::ffi::c_void, pchannelhandle: *mut super::super::Foundation::HANDLE) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDirect3DDevice9Video_Impl::CreateAuthenticatedChannel(this, core::mem::transmute_copy(&channeltype), core::mem::transmute_copy(&ppauthenticatedchannel), core::mem::transmute_copy(&pchannelhandle)).into()
            }
        }
        unsafe extern "system" fn CreateCryptoSession<Identity: IDirect3DDevice9Video_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pcryptotype: *const windows_core::GUID, pdecodeprofile: *const windows_core::GUID, ppcryptosession: *mut *mut core::ffi::c_void, pcryptohandle: *mut super::super::Foundation::HANDLE) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDirect3DDevice9Video_Impl::CreateCryptoSession(this, core::mem::transmute_copy(&pcryptotype), core::mem::transmute_copy(&pdecodeprofile), core::mem::transmute_copy(&ppcryptosession), core::mem::transmute_copy(&pcryptohandle)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetContentProtectionCaps: GetContentProtectionCaps::<Identity, OFFSET>,
            CreateAuthenticatedChannel: CreateAuthenticatedChannel::<Identity, OFFSET>,
            CreateCryptoSession: CreateCryptoSession::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDirect3DDevice9Video as windows_core::Interface>::IID
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl windows_core::RuntimeName for IDirect3DDevice9Video {}
windows_core::imp::define_interface!(IDirect3DDeviceManager9, IDirect3DDeviceManager9_Vtbl, 0xa0cade0f_06d5_4cf4_a1c7_f3cdd725aa75);
windows_core::imp::interface_hierarchy!(IDirect3DDeviceManager9, windows_core::IUnknown);
impl IDirect3DDeviceManager9 {
    #[cfg(feature = "Win32_Graphics_Direct3D9")]
    pub unsafe fn ResetDevice<P0>(&self, pdevice: P0, resettoken: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Graphics::Direct3D9::IDirect3DDevice9>,
    {
        unsafe { (windows_core::Interface::vtable(self).ResetDevice)(windows_core::Interface::as_raw(self), pdevice.param().abi(), resettoken).ok() }
    }
    pub unsafe fn OpenDeviceHandle(&self) -> windows_core::Result<super::super::Foundation::HANDLE> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).OpenDeviceHandle)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn CloseDeviceHandle(&self, hdevice: super::super::Foundation::HANDLE) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).CloseDeviceHandle)(windows_core::Interface::as_raw(self), hdevice).ok() }
    }
    pub unsafe fn TestDevice(&self, hdevice: super::super::Foundation::HANDLE) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).TestDevice)(windows_core::Interface::as_raw(self), hdevice).ok() }
    }
    #[cfg(feature = "Win32_Graphics_Direct3D9")]
    pub unsafe fn LockDevice(&self, hdevice: super::super::Foundation::HANDLE, ppdevice: *mut Option<super::super::Graphics::Direct3D9::IDirect3DDevice9>, fblock: bool) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).LockDevice)(windows_core::Interface::as_raw(self), hdevice, core::mem::transmute(ppdevice), fblock.into()).ok() }
    }
    pub unsafe fn UnlockDevice(&self, hdevice: super::super::Foundation::HANDLE, fsavestate: bool) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).UnlockDevice)(windows_core::Interface::as_raw(self), hdevice, fsavestate.into()).ok() }
    }
    pub unsafe fn GetVideoService(&self, hdevice: super::super::Foundation::HANDLE, riid: *const windows_core::GUID, ppservice: *mut *mut core::ffi::c_void) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetVideoService)(windows_core::Interface::as_raw(self), hdevice, riid, ppservice as _).ok() }
    }
}
#[repr(C)]
pub struct IDirect3DDeviceManager9_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Graphics_Direct3D9")]
    pub ResetDevice: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Direct3D9"))]
    ResetDevice: usize,
    pub OpenDeviceHandle: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::HANDLE) -> windows_core::HRESULT,
    pub CloseDeviceHandle: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::HANDLE) -> windows_core::HRESULT,
    pub TestDevice: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::HANDLE) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_Graphics_Direct3D9")]
    pub LockDevice: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::HANDLE, *mut *mut core::ffi::c_void, super::super::Foundation::BOOL) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Direct3D9"))]
    LockDevice: usize,
    pub UnlockDevice: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::HANDLE, super::super::Foundation::BOOL) -> windows_core::HRESULT,
    pub GetVideoService: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::HANDLE, *const windows_core::GUID, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
pub trait IDirect3DDeviceManager9_Impl: windows_core::IUnknownImpl {
    fn ResetDevice(&self, pdevice: windows_core::Ref<'_, super::super::Graphics::Direct3D9::IDirect3DDevice9>, resettoken: u32) -> windows_core::Result<()>;
    fn OpenDeviceHandle(&self) -> windows_core::Result<super::super::Foundation::HANDLE>;
    fn CloseDeviceHandle(&self, hdevice: super::super::Foundation::HANDLE) -> windows_core::Result<()>;
    fn TestDevice(&self, hdevice: super::super::Foundation::HANDLE) -> windows_core::Result<()>;
    fn LockDevice(&self, hdevice: super::super::Foundation::HANDLE, ppdevice: windows_core::OutRef<'_, super::super::Graphics::Direct3D9::IDirect3DDevice9>, fblock: super::super::Foundation::BOOL) -> windows_core::Result<()>;
    fn UnlockDevice(&self, hdevice: super::super::Foundation::HANDLE, fsavestate: super::super::Foundation::BOOL) -> windows_core::Result<()>;
    fn GetVideoService(&self, hdevice: super::super::Foundation::HANDLE, riid: *const windows_core::GUID, ppservice: *mut *mut core::ffi::c_void) -> windows_core::Result<()>;
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl IDirect3DDeviceManager9_Vtbl {
    pub const fn new<Identity: IDirect3DDeviceManager9_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn ResetDevice<Identity: IDirect3DDeviceManager9_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pdevice: *mut core::ffi::c_void, resettoken: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDirect3DDeviceManager9_Impl::ResetDevice(this, core::mem::transmute_copy(&pdevice), core::mem::transmute_copy(&resettoken)).into()
            }
        }
        unsafe extern "system" fn OpenDeviceHandle<Identity: IDirect3DDeviceManager9_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, phdevice: *mut super::super::Foundation::HANDLE) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDirect3DDeviceManager9_Impl::OpenDeviceHandle(this) {
                    Ok(ok__) => {
                        phdevice.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn CloseDeviceHandle<Identity: IDirect3DDeviceManager9_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, hdevice: super::super::Foundation::HANDLE) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDirect3DDeviceManager9_Impl::CloseDeviceHandle(this, core::mem::transmute_copy(&hdevice)).into()
            }
        }
        unsafe extern "system" fn TestDevice<Identity: IDirect3DDeviceManager9_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, hdevice: super::super::Foundation::HANDLE) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDirect3DDeviceManager9_Impl::TestDevice(this, core::mem::transmute_copy(&hdevice)).into()
            }
        }
        unsafe extern "system" fn LockDevice<Identity: IDirect3DDeviceManager9_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, hdevice: super::super::Foundation::HANDLE, ppdevice: *mut *mut core::ffi::c_void, fblock: super::super::Foundation::BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDirect3DDeviceManager9_Impl::LockDevice(this, core::mem::transmute_copy(&hdevice), core::mem::transmute_copy(&ppdevice), core::mem::transmute_copy(&fblock)).into()
            }
        }
        unsafe extern "system" fn UnlockDevice<Identity: IDirect3DDeviceManager9_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, hdevice: super::super::Foundation::HANDLE, fsavestate: super::super::Foundation::BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDirect3DDeviceManager9_Impl::UnlockDevice(this, core::mem::transmute_copy(&hdevice), core::mem::transmute_copy(&fsavestate)).into()
            }
        }
        unsafe extern "system" fn GetVideoService<Identity: IDirect3DDeviceManager9_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, hdevice: super::super::Foundation::HANDLE, riid: *const windows_core::GUID, ppservice: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDirect3DDeviceManager9_Impl::GetVideoService(this, core::mem::transmute_copy(&hdevice), core::mem::transmute_copy(&riid), core::mem::transmute_copy(&ppservice)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            ResetDevice: ResetDevice::<Identity, OFFSET>,
            OpenDeviceHandle: OpenDeviceHandle::<Identity, OFFSET>,
            CloseDeviceHandle: CloseDeviceHandle::<Identity, OFFSET>,
            TestDevice: TestDevice::<Identity, OFFSET>,
            LockDevice: LockDevice::<Identity, OFFSET>,
            UnlockDevice: UnlockDevice::<Identity, OFFSET>,
            GetVideoService: GetVideoService::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDirect3DDeviceManager9 as windows_core::Interface>::IID
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl windows_core::RuntimeName for IDirect3DDeviceManager9 {}
windows_core::imp::define_interface!(IDirectXVideoAccelerationService, IDirectXVideoAccelerationService_Vtbl, 0xfc51a550_d5e7_11d9_af55_00054e43ff02);
windows_core::imp::interface_hierarchy!(IDirectXVideoAccelerationService, windows_core::IUnknown);
impl IDirectXVideoAccelerationService {
    #[cfg(feature = "Win32_Graphics_Direct3D9")]
    pub unsafe fn CreateSurface(&self, width: u32, height: u32, backbuffers: u32, format: super::super::Graphics::Direct3D9::D3DFORMAT, pool: super::super::Graphics::Direct3D9::D3DPOOL, usage: u32, dxvatype: DXVA2_VideoRenderTargetType, ppsurface: *mut Option<super::super::Graphics::Direct3D9::IDirect3DSurface9>, psharedhandle: Option<*mut super::super::Foundation::HANDLE>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).CreateSurface)(windows_core::Interface::as_raw(self), width, height, backbuffers, format, pool, usage, dxvatype.0 as _, core::mem::transmute(ppsurface), psharedhandle.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
}
#[repr(C)]
pub struct IDirectXVideoAccelerationService_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Graphics_Direct3D9")]
    pub CreateSurface: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, u32, super::super::Graphics::Direct3D9::D3DFORMAT, super::super::Graphics::Direct3D9::D3DPOOL, u32, u32, *mut *mut core::ffi::c_void, *mut super::super::Foundation::HANDLE) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Direct3D9"))]
    CreateSurface: usize,
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
pub trait IDirectXVideoAccelerationService_Impl: windows_core::IUnknownImpl {
    fn CreateSurface(&self, width: u32, height: u32, backbuffers: u32, format: super::super::Graphics::Direct3D9::D3DFORMAT, pool: super::super::Graphics::Direct3D9::D3DPOOL, usage: u32, dxvatype: &DXVA2_VideoRenderTargetType, ppsurface: windows_core::OutRef<'_, super::super::Graphics::Direct3D9::IDirect3DSurface9>, psharedhandle: *mut super::super::Foundation::HANDLE) -> windows_core::Result<()>;
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl IDirectXVideoAccelerationService_Vtbl {
    pub const fn new<Identity: IDirectXVideoAccelerationService_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn CreateSurface<Identity: IDirectXVideoAccelerationService_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, width: u32, height: u32, backbuffers: u32, format: super::super::Graphics::Direct3D9::D3DFORMAT, pool: super::super::Graphics::Direct3D9::D3DPOOL, usage: u32, dxvatype: u32, ppsurface: *mut *mut core::ffi::c_void, psharedhandle: *mut super::super::Foundation::HANDLE) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDirectXVideoAccelerationService_Impl::CreateSurface(this, core::mem::transmute_copy(&width), core::mem::transmute_copy(&height), core::mem::transmute_copy(&backbuffers), core::mem::transmute_copy(&format), core::mem::transmute_copy(&pool), core::mem::transmute_copy(&usage), core::mem::transmute(&dxvatype), core::mem::transmute_copy(&ppsurface), core::mem::transmute_copy(&psharedhandle)).into()
            }
        }
        Self { base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(), CreateSurface: CreateSurface::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDirectXVideoAccelerationService as windows_core::Interface>::IID
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl windows_core::RuntimeName for IDirectXVideoAccelerationService {}
windows_core::imp::define_interface!(IDirectXVideoDecoder, IDirectXVideoDecoder_Vtbl, 0xf2b0810a_fd00_43c9_918c_df94e2d8ef7d);
windows_core::imp::interface_hierarchy!(IDirectXVideoDecoder, windows_core::IUnknown);
impl IDirectXVideoDecoder {
    pub unsafe fn GetVideoDecoderService(&self) -> windows_core::Result<IDirectXVideoDecoderService> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetVideoDecoderService)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Win32_Graphics_Direct3D9")]
    pub unsafe fn GetCreationParameters(&self, pdeviceguid: Option<*mut windows_core::GUID>, pvideodesc: Option<*mut DXVA2_VideoDesc>, pconfig: Option<*mut DXVA2_ConfigPictureDecode>, pdecoderrendertargets: *mut *mut Option<super::super::Graphics::Direct3D9::IDirect3DSurface9>, pnumsurfaces: Option<*mut u32>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetCreationParameters)(windows_core::Interface::as_raw(self), pdeviceguid.unwrap_or(core::mem::zeroed()) as _, pvideodesc.unwrap_or(core::mem::zeroed()) as _, pconfig.unwrap_or(core::mem::zeroed()) as _, pdecoderrendertargets as _, pnumsurfaces.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn GetBuffer(&self, buffertype: DXVA2_BufferfType, ppbuffer: *mut *mut core::ffi::c_void, pbuffersize: *mut u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetBuffer)(windows_core::Interface::as_raw(self), buffertype.0 as _, ppbuffer as _, pbuffersize as _).ok() }
    }
    pub unsafe fn ReleaseBuffer(&self, buffertype: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).ReleaseBuffer)(windows_core::Interface::as_raw(self), buffertype).ok() }
    }
    #[cfg(feature = "Win32_Graphics_Direct3D9")]
    pub unsafe fn BeginFrame<P0>(&self, prendertarget: P0, pvpvpdata: Option<*const core::ffi::c_void>) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Graphics::Direct3D9::IDirect3DSurface9>,
    {
        unsafe { (windows_core::Interface::vtable(self).BeginFrame)(windows_core::Interface::as_raw(self), prendertarget.param().abi(), pvpvpdata.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn EndFrame(&self, phandlecomplete: Option<*mut super::super::Foundation::HANDLE>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).EndFrame)(windows_core::Interface::as_raw(self), phandlecomplete.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn Execute(&self, pexecuteparams: *const DXVA2_DecodeExecuteParams) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Execute)(windows_core::Interface::as_raw(self), pexecuteparams).ok() }
    }
}
#[repr(C)]
pub struct IDirectXVideoDecoder_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetVideoDecoderService: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_Graphics_Direct3D9")]
    pub GetCreationParameters: unsafe extern "system" fn(*mut core::ffi::c_void, *mut windows_core::GUID, *mut DXVA2_VideoDesc, *mut DXVA2_ConfigPictureDecode, *mut *mut *mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Direct3D9"))]
    GetCreationParameters: usize,
    pub GetBuffer: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut *mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub ReleaseBuffer: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_Graphics_Direct3D9")]
    pub BeginFrame: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *const core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Direct3D9"))]
    BeginFrame: usize,
    pub EndFrame: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::HANDLE) -> windows_core::HRESULT,
    pub Execute: unsafe extern "system" fn(*mut core::ffi::c_void, *const DXVA2_DecodeExecuteParams) -> windows_core::HRESULT,
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
pub trait IDirectXVideoDecoder_Impl: windows_core::IUnknownImpl {
    fn GetVideoDecoderService(&self) -> windows_core::Result<IDirectXVideoDecoderService>;
    fn GetCreationParameters(&self, pdeviceguid: *mut windows_core::GUID, pvideodesc: *mut DXVA2_VideoDesc, pconfig: *mut DXVA2_ConfigPictureDecode, pdecoderrendertargets: *mut *mut Option<super::super::Graphics::Direct3D9::IDirect3DSurface9>, pnumsurfaces: *mut u32) -> windows_core::Result<()>;
    fn GetBuffer(&self, buffertype: &DXVA2_BufferfType, ppbuffer: *mut *mut core::ffi::c_void, pbuffersize: *mut u32) -> windows_core::Result<()>;
    fn ReleaseBuffer(&self, buffertype: u32) -> windows_core::Result<()>;
    fn BeginFrame(&self, prendertarget: windows_core::Ref<'_, super::super::Graphics::Direct3D9::IDirect3DSurface9>, pvpvpdata: *const core::ffi::c_void) -> windows_core::Result<()>;
    fn EndFrame(&self, phandlecomplete: *mut super::super::Foundation::HANDLE) -> windows_core::Result<()>;
    fn Execute(&self, pexecuteparams: *const DXVA2_DecodeExecuteParams) -> windows_core::Result<()>;
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl IDirectXVideoDecoder_Vtbl {
    pub const fn new<Identity: IDirectXVideoDecoder_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetVideoDecoderService<Identity: IDirectXVideoDecoder_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppservice: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDirectXVideoDecoder_Impl::GetVideoDecoderService(this) {
                    Ok(ok__) => {
                        ppservice.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetCreationParameters<Identity: IDirectXVideoDecoder_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pdeviceguid: *mut windows_core::GUID, pvideodesc: *mut DXVA2_VideoDesc, pconfig: *mut DXVA2_ConfigPictureDecode, pdecoderrendertargets: *mut *mut *mut core::ffi::c_void, pnumsurfaces: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDirectXVideoDecoder_Impl::GetCreationParameters(this, core::mem::transmute_copy(&pdeviceguid), core::mem::transmute_copy(&pvideodesc), core::mem::transmute_copy(&pconfig), core::mem::transmute_copy(&pdecoderrendertargets), core::mem::transmute_copy(&pnumsurfaces)).into()
            }
        }
        unsafe extern "system" fn GetBuffer<Identity: IDirectXVideoDecoder_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, buffertype: u32, ppbuffer: *mut *mut core::ffi::c_void, pbuffersize: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDirectXVideoDecoder_Impl::GetBuffer(this, core::mem::transmute(&buffertype), core::mem::transmute_copy(&ppbuffer), core::mem::transmute_copy(&pbuffersize)).into()
            }
        }
        unsafe extern "system" fn ReleaseBuffer<Identity: IDirectXVideoDecoder_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, buffertype: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDirectXVideoDecoder_Impl::ReleaseBuffer(this, core::mem::transmute_copy(&buffertype)).into()
            }
        }
        unsafe extern "system" fn BeginFrame<Identity: IDirectXVideoDecoder_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, prendertarget: *mut core::ffi::c_void, pvpvpdata: *const core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDirectXVideoDecoder_Impl::BeginFrame(this, core::mem::transmute_copy(&prendertarget), core::mem::transmute_copy(&pvpvpdata)).into()
            }
        }
        unsafe extern "system" fn EndFrame<Identity: IDirectXVideoDecoder_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, phandlecomplete: *mut super::super::Foundation::HANDLE) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDirectXVideoDecoder_Impl::EndFrame(this, core::mem::transmute_copy(&phandlecomplete)).into()
            }
        }
        unsafe extern "system" fn Execute<Identity: IDirectXVideoDecoder_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pexecuteparams: *const DXVA2_DecodeExecuteParams) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDirectXVideoDecoder_Impl::Execute(this, core::mem::transmute_copy(&pexecuteparams)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetVideoDecoderService: GetVideoDecoderService::<Identity, OFFSET>,
            GetCreationParameters: GetCreationParameters::<Identity, OFFSET>,
            GetBuffer: GetBuffer::<Identity, OFFSET>,
            ReleaseBuffer: ReleaseBuffer::<Identity, OFFSET>,
            BeginFrame: BeginFrame::<Identity, OFFSET>,
            EndFrame: EndFrame::<Identity, OFFSET>,
            Execute: Execute::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDirectXVideoDecoder as windows_core::Interface>::IID
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl windows_core::RuntimeName for IDirectXVideoDecoder {}
windows_core::imp::define_interface!(IDirectXVideoDecoderService, IDirectXVideoDecoderService_Vtbl, 0xfc51a551_d5e7_11d9_af55_00054e43ff02);
impl core::ops::Deref for IDirectXVideoDecoderService {
    type Target = IDirectXVideoAccelerationService;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IDirectXVideoDecoderService, windows_core::IUnknown, IDirectXVideoAccelerationService);
impl IDirectXVideoDecoderService {
    pub unsafe fn GetDecoderDeviceGuids(&self, pcount: *mut u32, pguids: *mut *mut windows_core::GUID) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetDecoderDeviceGuids)(windows_core::Interface::as_raw(self), pcount as _, pguids as _).ok() }
    }
    #[cfg(feature = "Win32_Graphics_Direct3D9")]
    pub unsafe fn GetDecoderRenderTargets(&self, guid: *const windows_core::GUID, pcount: *mut u32, pformats: *mut *mut super::super::Graphics::Direct3D9::D3DFORMAT) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetDecoderRenderTargets)(windows_core::Interface::as_raw(self), guid, pcount as _, pformats as _).ok() }
    }
    #[cfg(feature = "Win32_Graphics_Direct3D9")]
    pub unsafe fn GetDecoderConfigurations(&self, guid: *const windows_core::GUID, pvideodesc: *const DXVA2_VideoDesc, preserved: Option<*const core::ffi::c_void>, pcount: *mut u32, ppconfigs: *mut *mut DXVA2_ConfigPictureDecode) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetDecoderConfigurations)(windows_core::Interface::as_raw(self), guid, pvideodesc, preserved.unwrap_or(core::mem::zeroed()) as _, pcount as _, ppconfigs as _).ok() }
    }
    #[cfg(feature = "Win32_Graphics_Direct3D9")]
    pub unsafe fn CreateVideoDecoder(&self, guid: *const windows_core::GUID, pvideodesc: *const DXVA2_VideoDesc, pconfig: *const DXVA2_ConfigPictureDecode, ppdecoderrendertargets: &[Option<super::super::Graphics::Direct3D9::IDirect3DSurface9>]) -> windows_core::Result<IDirectXVideoDecoder> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).CreateVideoDecoder)(windows_core::Interface::as_raw(self), guid, pvideodesc, pconfig, core::mem::transmute(ppdecoderrendertargets.as_ptr()), ppdecoderrendertargets.len().try_into().unwrap(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
}
#[repr(C)]
pub struct IDirectXVideoDecoderService_Vtbl {
    pub base__: IDirectXVideoAccelerationService_Vtbl,
    pub GetDecoderDeviceGuids: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut *mut windows_core::GUID) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_Graphics_Direct3D9")]
    pub GetDecoderRenderTargets: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID, *mut u32, *mut *mut super::super::Graphics::Direct3D9::D3DFORMAT) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Direct3D9"))]
    GetDecoderRenderTargets: usize,
    #[cfg(feature = "Win32_Graphics_Direct3D9")]
    pub GetDecoderConfigurations: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID, *const DXVA2_VideoDesc, *const core::ffi::c_void, *mut u32, *mut *mut DXVA2_ConfigPictureDecode) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Direct3D9"))]
    GetDecoderConfigurations: usize,
    #[cfg(feature = "Win32_Graphics_Direct3D9")]
    pub CreateVideoDecoder: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID, *const DXVA2_VideoDesc, *const DXVA2_ConfigPictureDecode, *const *mut core::ffi::c_void, u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Direct3D9"))]
    CreateVideoDecoder: usize,
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
pub trait IDirectXVideoDecoderService_Impl: IDirectXVideoAccelerationService_Impl {
    fn GetDecoderDeviceGuids(&self, pcount: *mut u32, pguids: *mut *mut windows_core::GUID) -> windows_core::Result<()>;
    fn GetDecoderRenderTargets(&self, guid: *const windows_core::GUID, pcount: *mut u32, pformats: *mut *mut super::super::Graphics::Direct3D9::D3DFORMAT) -> windows_core::Result<()>;
    fn GetDecoderConfigurations(&self, guid: *const windows_core::GUID, pvideodesc: *const DXVA2_VideoDesc, preserved: *const core::ffi::c_void, pcount: *mut u32, ppconfigs: *mut *mut DXVA2_ConfigPictureDecode) -> windows_core::Result<()>;
    fn CreateVideoDecoder(&self, guid: *const windows_core::GUID, pvideodesc: *const DXVA2_VideoDesc, pconfig: *const DXVA2_ConfigPictureDecode, ppdecoderrendertargets: *const Option<super::super::Graphics::Direct3D9::IDirect3DSurface9>, numrendertargets: u32) -> windows_core::Result<IDirectXVideoDecoder>;
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl IDirectXVideoDecoderService_Vtbl {
    pub const fn new<Identity: IDirectXVideoDecoderService_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetDecoderDeviceGuids<Identity: IDirectXVideoDecoderService_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pcount: *mut u32, pguids: *mut *mut windows_core::GUID) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDirectXVideoDecoderService_Impl::GetDecoderDeviceGuids(this, core::mem::transmute_copy(&pcount), core::mem::transmute_copy(&pguids)).into()
            }
        }
        unsafe extern "system" fn GetDecoderRenderTargets<Identity: IDirectXVideoDecoderService_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, guid: *const windows_core::GUID, pcount: *mut u32, pformats: *mut *mut super::super::Graphics::Direct3D9::D3DFORMAT) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDirectXVideoDecoderService_Impl::GetDecoderRenderTargets(this, core::mem::transmute_copy(&guid), core::mem::transmute_copy(&pcount), core::mem::transmute_copy(&pformats)).into()
            }
        }
        unsafe extern "system" fn GetDecoderConfigurations<Identity: IDirectXVideoDecoderService_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, guid: *const windows_core::GUID, pvideodesc: *const DXVA2_VideoDesc, preserved: *const core::ffi::c_void, pcount: *mut u32, ppconfigs: *mut *mut DXVA2_ConfigPictureDecode) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDirectXVideoDecoderService_Impl::GetDecoderConfigurations(this, core::mem::transmute_copy(&guid), core::mem::transmute_copy(&pvideodesc), core::mem::transmute_copy(&preserved), core::mem::transmute_copy(&pcount), core::mem::transmute_copy(&ppconfigs)).into()
            }
        }
        unsafe extern "system" fn CreateVideoDecoder<Identity: IDirectXVideoDecoderService_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, guid: *const windows_core::GUID, pvideodesc: *const DXVA2_VideoDesc, pconfig: *const DXVA2_ConfigPictureDecode, ppdecoderrendertargets: *const *mut core::ffi::c_void, numrendertargets: u32, ppdecode: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDirectXVideoDecoderService_Impl::CreateVideoDecoder(this, core::mem::transmute_copy(&guid), core::mem::transmute_copy(&pvideodesc), core::mem::transmute_copy(&pconfig), core::mem::transmute_copy(&ppdecoderrendertargets), core::mem::transmute_copy(&numrendertargets)) {
                    Ok(ok__) => {
                        ppdecode.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: IDirectXVideoAccelerationService_Vtbl::new::<Identity, OFFSET>(),
            GetDecoderDeviceGuids: GetDecoderDeviceGuids::<Identity, OFFSET>,
            GetDecoderRenderTargets: GetDecoderRenderTargets::<Identity, OFFSET>,
            GetDecoderConfigurations: GetDecoderConfigurations::<Identity, OFFSET>,
            CreateVideoDecoder: CreateVideoDecoder::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDirectXVideoDecoderService as windows_core::Interface>::IID || iid == &<IDirectXVideoAccelerationService as windows_core::Interface>::IID
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl windows_core::RuntimeName for IDirectXVideoDecoderService {}
windows_core::imp::define_interface!(IDirectXVideoMemoryConfiguration, IDirectXVideoMemoryConfiguration_Vtbl, 0xb7f916dd_db3b_49c1_84d7_e45ef99ec726);
windows_core::imp::interface_hierarchy!(IDirectXVideoMemoryConfiguration, windows_core::IUnknown);
impl IDirectXVideoMemoryConfiguration {
    pub unsafe fn GetAvailableSurfaceTypeByIndex(&self, dwtypeindex: u32) -> windows_core::Result<DXVA2_SurfaceType> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetAvailableSurfaceTypeByIndex)(windows_core::Interface::as_raw(self), dwtypeindex, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetSurfaceType(&self, dwtype: DXVA2_SurfaceType) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetSurfaceType)(windows_core::Interface::as_raw(self), dwtype).ok() }
    }
}
#[repr(C)]
pub struct IDirectXVideoMemoryConfiguration_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetAvailableSurfaceTypeByIndex: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut DXVA2_SurfaceType) -> windows_core::HRESULT,
    pub SetSurfaceType: unsafe extern "system" fn(*mut core::ffi::c_void, DXVA2_SurfaceType) -> windows_core::HRESULT,
}
pub trait IDirectXVideoMemoryConfiguration_Impl: windows_core::IUnknownImpl {
    fn GetAvailableSurfaceTypeByIndex(&self, dwtypeindex: u32) -> windows_core::Result<DXVA2_SurfaceType>;
    fn SetSurfaceType(&self, dwtype: DXVA2_SurfaceType) -> windows_core::Result<()>;
}
impl IDirectXVideoMemoryConfiguration_Vtbl {
    pub const fn new<Identity: IDirectXVideoMemoryConfiguration_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetAvailableSurfaceTypeByIndex<Identity: IDirectXVideoMemoryConfiguration_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwtypeindex: u32, pdwtype: *mut DXVA2_SurfaceType) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDirectXVideoMemoryConfiguration_Impl::GetAvailableSurfaceTypeByIndex(this, core::mem::transmute_copy(&dwtypeindex)) {
                    Ok(ok__) => {
                        pdwtype.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetSurfaceType<Identity: IDirectXVideoMemoryConfiguration_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwtype: DXVA2_SurfaceType) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDirectXVideoMemoryConfiguration_Impl::SetSurfaceType(this, core::mem::transmute_copy(&dwtype)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetAvailableSurfaceTypeByIndex: GetAvailableSurfaceTypeByIndex::<Identity, OFFSET>,
            SetSurfaceType: SetSurfaceType::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDirectXVideoMemoryConfiguration as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IDirectXVideoMemoryConfiguration {}
windows_core::imp::define_interface!(IDirectXVideoProcessor, IDirectXVideoProcessor_Vtbl, 0x8c3a39f0_916e_4690_804f_4c8001355d25);
windows_core::imp::interface_hierarchy!(IDirectXVideoProcessor, windows_core::IUnknown);
impl IDirectXVideoProcessor {
    pub unsafe fn GetVideoProcessorService(&self) -> windows_core::Result<IDirectXVideoProcessorService> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetVideoProcessorService)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Win32_Graphics_Direct3D9")]
    pub unsafe fn GetCreationParameters(&self, pdeviceguid: Option<*mut windows_core::GUID>, pvideodesc: Option<*mut DXVA2_VideoDesc>, prendertargetformat: Option<*mut super::super::Graphics::Direct3D9::D3DFORMAT>, pmaxnumsubstreams: Option<*mut u32>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetCreationParameters)(windows_core::Interface::as_raw(self), pdeviceguid.unwrap_or(core::mem::zeroed()) as _, pvideodesc.unwrap_or(core::mem::zeroed()) as _, prendertargetformat.unwrap_or(core::mem::zeroed()) as _, pmaxnumsubstreams.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    #[cfg(feature = "Win32_Graphics_Direct3D9")]
    pub unsafe fn GetVideoProcessorCaps(&self, pcaps: *mut DXVA2_VideoProcessorCaps) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetVideoProcessorCaps)(windows_core::Interface::as_raw(self), pcaps as _).ok() }
    }
    pub unsafe fn GetProcAmpRange(&self, procampcap: u32) -> windows_core::Result<DXVA2_ValueRange> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetProcAmpRange)(windows_core::Interface::as_raw(self), procampcap, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetFilterPropertyRange(&self, filtersetting: u32) -> windows_core::Result<DXVA2_ValueRange> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetFilterPropertyRange)(windows_core::Interface::as_raw(self), filtersetting, &mut result__).map(|| result__)
        }
    }
    #[cfg(feature = "Win32_Graphics_Direct3D9")]
    pub unsafe fn VideoProcessBlt<P0>(&self, prendertarget: P0, pbltparams: *const DXVA2_VideoProcessBltParams, psamples: &[DXVA2_VideoSample], phandlecomplete: Option<*mut super::super::Foundation::HANDLE>) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Graphics::Direct3D9::IDirect3DSurface9>,
    {
        unsafe { (windows_core::Interface::vtable(self).VideoProcessBlt)(windows_core::Interface::as_raw(self), prendertarget.param().abi(), pbltparams, core::mem::transmute(psamples.as_ptr()), psamples.len().try_into().unwrap(), phandlecomplete.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
}
#[repr(C)]
pub struct IDirectXVideoProcessor_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetVideoProcessorService: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_Graphics_Direct3D9")]
    pub GetCreationParameters: unsafe extern "system" fn(*mut core::ffi::c_void, *mut windows_core::GUID, *mut DXVA2_VideoDesc, *mut super::super::Graphics::Direct3D9::D3DFORMAT, *mut u32) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Direct3D9"))]
    GetCreationParameters: usize,
    #[cfg(feature = "Win32_Graphics_Direct3D9")]
    pub GetVideoProcessorCaps: unsafe extern "system" fn(*mut core::ffi::c_void, *mut DXVA2_VideoProcessorCaps) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Direct3D9"))]
    GetVideoProcessorCaps: usize,
    pub GetProcAmpRange: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut DXVA2_ValueRange) -> windows_core::HRESULT,
    pub GetFilterPropertyRange: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut DXVA2_ValueRange) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_Graphics_Direct3D9")]
    pub VideoProcessBlt: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *const DXVA2_VideoProcessBltParams, *const DXVA2_VideoSample, u32, *mut super::super::Foundation::HANDLE) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Direct3D9"))]
    VideoProcessBlt: usize,
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
pub trait IDirectXVideoProcessor_Impl: windows_core::IUnknownImpl {
    fn GetVideoProcessorService(&self) -> windows_core::Result<IDirectXVideoProcessorService>;
    fn GetCreationParameters(&self, pdeviceguid: *mut windows_core::GUID, pvideodesc: *mut DXVA2_VideoDesc, prendertargetformat: *mut super::super::Graphics::Direct3D9::D3DFORMAT, pmaxnumsubstreams: *mut u32) -> windows_core::Result<()>;
    fn GetVideoProcessorCaps(&self, pcaps: *mut DXVA2_VideoProcessorCaps) -> windows_core::Result<()>;
    fn GetProcAmpRange(&self, procampcap: u32) -> windows_core::Result<DXVA2_ValueRange>;
    fn GetFilterPropertyRange(&self, filtersetting: u32) -> windows_core::Result<DXVA2_ValueRange>;
    fn VideoProcessBlt(&self, prendertarget: windows_core::Ref<'_, super::super::Graphics::Direct3D9::IDirect3DSurface9>, pbltparams: *const DXVA2_VideoProcessBltParams, psamples: *const DXVA2_VideoSample, numsamples: u32, phandlecomplete: *mut super::super::Foundation::HANDLE) -> windows_core::Result<()>;
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl IDirectXVideoProcessor_Vtbl {
    pub const fn new<Identity: IDirectXVideoProcessor_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetVideoProcessorService<Identity: IDirectXVideoProcessor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppservice: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDirectXVideoProcessor_Impl::GetVideoProcessorService(this) {
                    Ok(ok__) => {
                        ppservice.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetCreationParameters<Identity: IDirectXVideoProcessor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pdeviceguid: *mut windows_core::GUID, pvideodesc: *mut DXVA2_VideoDesc, prendertargetformat: *mut super::super::Graphics::Direct3D9::D3DFORMAT, pmaxnumsubstreams: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDirectXVideoProcessor_Impl::GetCreationParameters(this, core::mem::transmute_copy(&pdeviceguid), core::mem::transmute_copy(&pvideodesc), core::mem::transmute_copy(&prendertargetformat), core::mem::transmute_copy(&pmaxnumsubstreams)).into()
            }
        }
        unsafe extern "system" fn GetVideoProcessorCaps<Identity: IDirectXVideoProcessor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pcaps: *mut DXVA2_VideoProcessorCaps) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDirectXVideoProcessor_Impl::GetVideoProcessorCaps(this, core::mem::transmute_copy(&pcaps)).into()
            }
        }
        unsafe extern "system" fn GetProcAmpRange<Identity: IDirectXVideoProcessor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, procampcap: u32, prange: *mut DXVA2_ValueRange) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDirectXVideoProcessor_Impl::GetProcAmpRange(this, core::mem::transmute_copy(&procampcap)) {
                    Ok(ok__) => {
                        prange.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetFilterPropertyRange<Identity: IDirectXVideoProcessor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, filtersetting: u32, prange: *mut DXVA2_ValueRange) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDirectXVideoProcessor_Impl::GetFilterPropertyRange(this, core::mem::transmute_copy(&filtersetting)) {
                    Ok(ok__) => {
                        prange.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn VideoProcessBlt<Identity: IDirectXVideoProcessor_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, prendertarget: *mut core::ffi::c_void, pbltparams: *const DXVA2_VideoProcessBltParams, psamples: *const DXVA2_VideoSample, numsamples: u32, phandlecomplete: *mut super::super::Foundation::HANDLE) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDirectXVideoProcessor_Impl::VideoProcessBlt(this, core::mem::transmute_copy(&prendertarget), core::mem::transmute_copy(&pbltparams), core::mem::transmute_copy(&psamples), core::mem::transmute_copy(&numsamples), core::mem::transmute_copy(&phandlecomplete)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetVideoProcessorService: GetVideoProcessorService::<Identity, OFFSET>,
            GetCreationParameters: GetCreationParameters::<Identity, OFFSET>,
            GetVideoProcessorCaps: GetVideoProcessorCaps::<Identity, OFFSET>,
            GetProcAmpRange: GetProcAmpRange::<Identity, OFFSET>,
            GetFilterPropertyRange: GetFilterPropertyRange::<Identity, OFFSET>,
            VideoProcessBlt: VideoProcessBlt::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDirectXVideoProcessor as windows_core::Interface>::IID
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl windows_core::RuntimeName for IDirectXVideoProcessor {}
windows_core::imp::define_interface!(IDirectXVideoProcessorService, IDirectXVideoProcessorService_Vtbl, 0xfc51a552_d5e7_11d9_af55_00054e43ff02);
impl core::ops::Deref for IDirectXVideoProcessorService {
    type Target = IDirectXVideoAccelerationService;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IDirectXVideoProcessorService, windows_core::IUnknown, IDirectXVideoAccelerationService);
impl IDirectXVideoProcessorService {
    pub unsafe fn RegisterVideoProcessorSoftwareDevice(&self, pcallbacks: *const core::ffi::c_void) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).RegisterVideoProcessorSoftwareDevice)(windows_core::Interface::as_raw(self), pcallbacks).ok() }
    }
    #[cfg(feature = "Win32_Graphics_Direct3D9")]
    pub unsafe fn GetVideoProcessorDeviceGuids(&self, pvideodesc: *const DXVA2_VideoDesc, pcount: *mut u32, pguids: *mut *mut windows_core::GUID) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetVideoProcessorDeviceGuids)(windows_core::Interface::as_raw(self), pvideodesc, pcount as _, pguids as _).ok() }
    }
    #[cfg(feature = "Win32_Graphics_Direct3D9")]
    pub unsafe fn GetVideoProcessorRenderTargets(&self, videoprocdeviceguid: *const windows_core::GUID, pvideodesc: *const DXVA2_VideoDesc, pcount: *mut u32, pformats: *mut *mut super::super::Graphics::Direct3D9::D3DFORMAT) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetVideoProcessorRenderTargets)(windows_core::Interface::as_raw(self), videoprocdeviceguid, pvideodesc, pcount as _, pformats as _).ok() }
    }
    #[cfg(feature = "Win32_Graphics_Direct3D9")]
    pub unsafe fn GetVideoProcessorSubStreamFormats(&self, videoprocdeviceguid: *const windows_core::GUID, pvideodesc: *const DXVA2_VideoDesc, rendertargetformat: super::super::Graphics::Direct3D9::D3DFORMAT, pcount: *mut u32, pformats: *mut *mut super::super::Graphics::Direct3D9::D3DFORMAT) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetVideoProcessorSubStreamFormats)(windows_core::Interface::as_raw(self), videoprocdeviceguid, pvideodesc, rendertargetformat, pcount as _, pformats as _).ok() }
    }
    #[cfg(feature = "Win32_Graphics_Direct3D9")]
    pub unsafe fn GetVideoProcessorCaps(&self, videoprocdeviceguid: *const windows_core::GUID, pvideodesc: *const DXVA2_VideoDesc, rendertargetformat: super::super::Graphics::Direct3D9::D3DFORMAT, pcaps: *mut DXVA2_VideoProcessorCaps) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetVideoProcessorCaps)(windows_core::Interface::as_raw(self), videoprocdeviceguid, pvideodesc, rendertargetformat, pcaps as _).ok() }
    }
    #[cfg(feature = "Win32_Graphics_Direct3D9")]
    pub unsafe fn GetProcAmpRange(&self, videoprocdeviceguid: *const windows_core::GUID, pvideodesc: *const DXVA2_VideoDesc, rendertargetformat: super::super::Graphics::Direct3D9::D3DFORMAT, procampcap: u32) -> windows_core::Result<DXVA2_ValueRange> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetProcAmpRange)(windows_core::Interface::as_raw(self), videoprocdeviceguid, pvideodesc, rendertargetformat, procampcap, &mut result__).map(|| result__)
        }
    }
    #[cfg(feature = "Win32_Graphics_Direct3D9")]
    pub unsafe fn GetFilterPropertyRange(&self, videoprocdeviceguid: *const windows_core::GUID, pvideodesc: *const DXVA2_VideoDesc, rendertargetformat: super::super::Graphics::Direct3D9::D3DFORMAT, filtersetting: u32) -> windows_core::Result<DXVA2_ValueRange> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetFilterPropertyRange)(windows_core::Interface::as_raw(self), videoprocdeviceguid, pvideodesc, rendertargetformat, filtersetting, &mut result__).map(|| result__)
        }
    }
    #[cfg(feature = "Win32_Graphics_Direct3D9")]
    pub unsafe fn CreateVideoProcessor(&self, videoprocdeviceguid: *const windows_core::GUID, pvideodesc: *const DXVA2_VideoDesc, rendertargetformat: super::super::Graphics::Direct3D9::D3DFORMAT, maxnumsubstreams: u32) -> windows_core::Result<IDirectXVideoProcessor> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).CreateVideoProcessor)(windows_core::Interface::as_raw(self), videoprocdeviceguid, pvideodesc, rendertargetformat, maxnumsubstreams, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
}
#[repr(C)]
pub struct IDirectXVideoProcessorService_Vtbl {
    pub base__: IDirectXVideoAccelerationService_Vtbl,
    pub RegisterVideoProcessorSoftwareDevice: unsafe extern "system" fn(*mut core::ffi::c_void, *const core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_Graphics_Direct3D9")]
    pub GetVideoProcessorDeviceGuids: unsafe extern "system" fn(*mut core::ffi::c_void, *const DXVA2_VideoDesc, *mut u32, *mut *mut windows_core::GUID) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Direct3D9"))]
    GetVideoProcessorDeviceGuids: usize,
    #[cfg(feature = "Win32_Graphics_Direct3D9")]
    pub GetVideoProcessorRenderTargets: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID, *const DXVA2_VideoDesc, *mut u32, *mut *mut super::super::Graphics::Direct3D9::D3DFORMAT) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Direct3D9"))]
    GetVideoProcessorRenderTargets: usize,
    #[cfg(feature = "Win32_Graphics_Direct3D9")]
    pub GetVideoProcessorSubStreamFormats: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID, *const DXVA2_VideoDesc, super::super::Graphics::Direct3D9::D3DFORMAT, *mut u32, *mut *mut super::super::Graphics::Direct3D9::D3DFORMAT) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Direct3D9"))]
    GetVideoProcessorSubStreamFormats: usize,
    #[cfg(feature = "Win32_Graphics_Direct3D9")]
    pub GetVideoProcessorCaps: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID, *const DXVA2_VideoDesc, super::super::Graphics::Direct3D9::D3DFORMAT, *mut DXVA2_VideoProcessorCaps) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Direct3D9"))]
    GetVideoProcessorCaps: usize,
    #[cfg(feature = "Win32_Graphics_Direct3D9")]
    pub GetProcAmpRange: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID, *const DXVA2_VideoDesc, super::super::Graphics::Direct3D9::D3DFORMAT, u32, *mut DXVA2_ValueRange) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Direct3D9"))]
    GetProcAmpRange: usize,
    #[cfg(feature = "Win32_Graphics_Direct3D9")]
    pub GetFilterPropertyRange: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID, *const DXVA2_VideoDesc, super::super::Graphics::Direct3D9::D3DFORMAT, u32, *mut DXVA2_ValueRange) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Direct3D9"))]
    GetFilterPropertyRange: usize,
    #[cfg(feature = "Win32_Graphics_Direct3D9")]
    pub CreateVideoProcessor: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID, *const DXVA2_VideoDesc, super::super::Graphics::Direct3D9::D3DFORMAT, u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Direct3D9"))]
    CreateVideoProcessor: usize,
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
pub trait IDirectXVideoProcessorService_Impl: IDirectXVideoAccelerationService_Impl {
    fn RegisterVideoProcessorSoftwareDevice(&self, pcallbacks: *const core::ffi::c_void) -> windows_core::Result<()>;
    fn GetVideoProcessorDeviceGuids(&self, pvideodesc: *const DXVA2_VideoDesc, pcount: *mut u32, pguids: *mut *mut windows_core::GUID) -> windows_core::Result<()>;
    fn GetVideoProcessorRenderTargets(&self, videoprocdeviceguid: *const windows_core::GUID, pvideodesc: *const DXVA2_VideoDesc, pcount: *mut u32, pformats: *mut *mut super::super::Graphics::Direct3D9::D3DFORMAT) -> windows_core::Result<()>;
    fn GetVideoProcessorSubStreamFormats(&self, videoprocdeviceguid: *const windows_core::GUID, pvideodesc: *const DXVA2_VideoDesc, rendertargetformat: super::super::Graphics::Direct3D9::D3DFORMAT, pcount: *mut u32, pformats: *mut *mut super::super::Graphics::Direct3D9::D3DFORMAT) -> windows_core::Result<()>;
    fn GetVideoProcessorCaps(&self, videoprocdeviceguid: *const windows_core::GUID, pvideodesc: *const DXVA2_VideoDesc, rendertargetformat: super::super::Graphics::Direct3D9::D3DFORMAT, pcaps: *mut DXVA2_VideoProcessorCaps) -> windows_core::Result<()>;
    fn GetProcAmpRange(&self, videoprocdeviceguid: *const windows_core::GUID, pvideodesc: *const DXVA2_VideoDesc, rendertargetformat: super::super::Graphics::Direct3D9::D3DFORMAT, procampcap: u32) -> windows_core::Result<DXVA2_ValueRange>;
    fn GetFilterPropertyRange(&self, videoprocdeviceguid: *const windows_core::GUID, pvideodesc: *const DXVA2_VideoDesc, rendertargetformat: super::super::Graphics::Direct3D9::D3DFORMAT, filtersetting: u32) -> windows_core::Result<DXVA2_ValueRange>;
    fn CreateVideoProcessor(&self, videoprocdeviceguid: *const windows_core::GUID, pvideodesc: *const DXVA2_VideoDesc, rendertargetformat: super::super::Graphics::Direct3D9::D3DFORMAT, maxnumsubstreams: u32) -> windows_core::Result<IDirectXVideoProcessor>;
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl IDirectXVideoProcessorService_Vtbl {
    pub const fn new<Identity: IDirectXVideoProcessorService_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn RegisterVideoProcessorSoftwareDevice<Identity: IDirectXVideoProcessorService_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pcallbacks: *const core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDirectXVideoProcessorService_Impl::RegisterVideoProcessorSoftwareDevice(this, core::mem::transmute_copy(&pcallbacks)).into()
            }
        }
        unsafe extern "system" fn GetVideoProcessorDeviceGuids<Identity: IDirectXVideoProcessorService_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pvideodesc: *const DXVA2_VideoDesc, pcount: *mut u32, pguids: *mut *mut windows_core::GUID) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDirectXVideoProcessorService_Impl::GetVideoProcessorDeviceGuids(this, core::mem::transmute_copy(&pvideodesc), core::mem::transmute_copy(&pcount), core::mem::transmute_copy(&pguids)).into()
            }
        }
        unsafe extern "system" fn GetVideoProcessorRenderTargets<Identity: IDirectXVideoProcessorService_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, videoprocdeviceguid: *const windows_core::GUID, pvideodesc: *const DXVA2_VideoDesc, pcount: *mut u32, pformats: *mut *mut super::super::Graphics::Direct3D9::D3DFORMAT) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDirectXVideoProcessorService_Impl::GetVideoProcessorRenderTargets(this, core::mem::transmute_copy(&videoprocdeviceguid), core::mem::transmute_copy(&pvideodesc), core::mem::transmute_copy(&pcount), core::mem::transmute_copy(&pformats)).into()
            }
        }
        unsafe extern "system" fn GetVideoProcessorSubStreamFormats<Identity: IDirectXVideoProcessorService_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, videoprocdeviceguid: *const windows_core::GUID, pvideodesc: *const DXVA2_VideoDesc, rendertargetformat: super::super::Graphics::Direct3D9::D3DFORMAT, pcount: *mut u32, pformats: *mut *mut super::super::Graphics::Direct3D9::D3DFORMAT) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDirectXVideoProcessorService_Impl::GetVideoProcessorSubStreamFormats(this, core::mem::transmute_copy(&videoprocdeviceguid), core::mem::transmute_copy(&pvideodesc), core::mem::transmute_copy(&rendertargetformat), core::mem::transmute_copy(&pcount), core::mem::transmute_copy(&pformats)).into()
            }
        }
        unsafe extern "system" fn GetVideoProcessorCaps<Identity: IDirectXVideoProcessorService_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, videoprocdeviceguid: *const windows_core::GUID, pvideodesc: *const DXVA2_VideoDesc, rendertargetformat: super::super::Graphics::Direct3D9::D3DFORMAT, pcaps: *mut DXVA2_VideoProcessorCaps) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDirectXVideoProcessorService_Impl::GetVideoProcessorCaps(this, core::mem::transmute_copy(&videoprocdeviceguid), core::mem::transmute_copy(&pvideodesc), core::mem::transmute_copy(&rendertargetformat), core::mem::transmute_copy(&pcaps)).into()
            }
        }
        unsafe extern "system" fn GetProcAmpRange<Identity: IDirectXVideoProcessorService_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, videoprocdeviceguid: *const windows_core::GUID, pvideodesc: *const DXVA2_VideoDesc, rendertargetformat: super::super::Graphics::Direct3D9::D3DFORMAT, procampcap: u32, prange: *mut DXVA2_ValueRange) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDirectXVideoProcessorService_Impl::GetProcAmpRange(this, core::mem::transmute_copy(&videoprocdeviceguid), core::mem::transmute_copy(&pvideodesc), core::mem::transmute_copy(&rendertargetformat), core::mem::transmute_copy(&procampcap)) {
                    Ok(ok__) => {
                        prange.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetFilterPropertyRange<Identity: IDirectXVideoProcessorService_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, videoprocdeviceguid: *const windows_core::GUID, pvideodesc: *const DXVA2_VideoDesc, rendertargetformat: super::super::Graphics::Direct3D9::D3DFORMAT, filtersetting: u32, prange: *mut DXVA2_ValueRange) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDirectXVideoProcessorService_Impl::GetFilterPropertyRange(this, core::mem::transmute_copy(&videoprocdeviceguid), core::mem::transmute_copy(&pvideodesc), core::mem::transmute_copy(&rendertargetformat), core::mem::transmute_copy(&filtersetting)) {
                    Ok(ok__) => {
                        prange.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn CreateVideoProcessor<Identity: IDirectXVideoProcessorService_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, videoprocdeviceguid: *const windows_core::GUID, pvideodesc: *const DXVA2_VideoDesc, rendertargetformat: super::super::Graphics::Direct3D9::D3DFORMAT, maxnumsubstreams: u32, ppvidprocess: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDirectXVideoProcessorService_Impl::CreateVideoProcessor(this, core::mem::transmute_copy(&videoprocdeviceguid), core::mem::transmute_copy(&pvideodesc), core::mem::transmute_copy(&rendertargetformat), core::mem::transmute_copy(&maxnumsubstreams)) {
                    Ok(ok__) => {
                        ppvidprocess.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: IDirectXVideoAccelerationService_Vtbl::new::<Identity, OFFSET>(),
            RegisterVideoProcessorSoftwareDevice: RegisterVideoProcessorSoftwareDevice::<Identity, OFFSET>,
            GetVideoProcessorDeviceGuids: GetVideoProcessorDeviceGuids::<Identity, OFFSET>,
            GetVideoProcessorRenderTargets: GetVideoProcessorRenderTargets::<Identity, OFFSET>,
            GetVideoProcessorSubStreamFormats: GetVideoProcessorSubStreamFormats::<Identity, OFFSET>,
            GetVideoProcessorCaps: GetVideoProcessorCaps::<Identity, OFFSET>,
            GetProcAmpRange: GetProcAmpRange::<Identity, OFFSET>,
            GetFilterPropertyRange: GetFilterPropertyRange::<Identity, OFFSET>,
            CreateVideoProcessor: CreateVideoProcessor::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDirectXVideoProcessorService as windows_core::Interface>::IID || iid == &<IDirectXVideoAccelerationService as windows_core::Interface>::IID
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D9")]
impl windows_core::RuntimeName for IDirectXVideoProcessorService {}
windows_core::imp::define_interface!(IEVRFilterConfig, IEVRFilterConfig_Vtbl, 0x83e91e85_82c1_4ea7_801d_85dc50b75086);
windows_core::imp::interface_hierarchy!(IEVRFilterConfig, windows_core::IUnknown);
impl IEVRFilterConfig {
    pub unsafe fn SetNumberOfStreams(&self, dwmaxstreams: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetNumberOfStreams)(windows_core::Interface::as_raw(self), dwmaxstreams).ok() }
    }
    pub unsafe fn GetNumberOfStreams(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetNumberOfStreams)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
}
#[repr(C)]
pub struct IEVRFilterConfig_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub SetNumberOfStreams: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetNumberOfStreams: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
}
pub trait IEVRFilterConfig_Impl: windows_core::IUnknownImpl {
    fn SetNumberOfStreams(&self, dwmaxstreams: u32) -> windows_core::Result<()>;
    fn GetNumberOfStreams(&self) -> windows_core::Result<u32>;
}
impl IEVRFilterConfig_Vtbl {
    pub const fn new<Identity: IEVRFilterConfig_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn SetNumberOfStreams<Identity: IEVRFilterConfig_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwmaxstreams: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IEVRFilterConfig_Impl::SetNumberOfStreams(this, core::mem::transmute_copy(&dwmaxstreams)).into()
            }
        }
        unsafe extern "system" fn GetNumberOfStreams<Identity: IEVRFilterConfig_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pdwmaxstreams: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IEVRFilterConfig_Impl::GetNumberOfStreams(this) {
                    Ok(ok__) => {
                        pdwmaxstreams.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            SetNumberOfStreams: SetNumberOfStreams::<Identity, OFFSET>,
            GetNumberOfStreams: GetNumberOfStreams::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IEVRFilterConfig as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IEVRFilterConfig {}
windows_core::imp::define_interface!(IEVRFilterConfigEx, IEVRFilterConfigEx_Vtbl, 0xaea36028_796d_454f_beee_b48071e24304);
impl core::ops::Deref for IEVRFilterConfigEx {
    type Target = IEVRFilterConfig;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IEVRFilterConfigEx, windows_core::IUnknown, IEVRFilterConfig);
impl IEVRFilterConfigEx {
    pub unsafe fn SetConfigPrefs(&self, dwconfigflags: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetConfigPrefs)(windows_core::Interface::as_raw(self), dwconfigflags).ok() }
    }
    pub unsafe fn GetConfigPrefs(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetConfigPrefs)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
}
#[repr(C)]
pub struct IEVRFilterConfigEx_Vtbl {
    pub base__: IEVRFilterConfig_Vtbl,
    pub SetConfigPrefs: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetConfigPrefs: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
}
pub trait IEVRFilterConfigEx_Impl: IEVRFilterConfig_Impl {
    fn SetConfigPrefs(&self, dwconfigflags: u32) -> windows_core::Result<()>;
    fn GetConfigPrefs(&self) -> windows_core::Result<u32>;
}
impl IEVRFilterConfigEx_Vtbl {
    pub const fn new<Identity: IEVRFilterConfigEx_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn SetConfigPrefs<Identity: IEVRFilterConfigEx_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwconfigflags: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IEVRFilterConfigEx_Impl::SetConfigPrefs(this, core::mem::transmute_copy(&dwconfigflags)).into()
            }
        }
        unsafe extern "system" fn GetConfigPrefs<Identity: IEVRFilterConfigEx_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pdwconfigflags: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IEVRFilterConfigEx_Impl::GetConfigPrefs(this) {
                    Ok(ok__) => {
                        pdwconfigflags.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: IEVRFilterConfig_Vtbl::new::<Identity, OFFSET>(),
            SetConfigPrefs: SetConfigPrefs::<Identity, OFFSET>,
            GetConfigPrefs: GetConfigPrefs::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IEVRFilterConfigEx as windows_core::Interface>::IID || iid == &<IEVRFilterConfig as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IEVRFilterConfigEx {}
windows_core::imp::define_interface!(IEVRTrustedVideoPlugin, IEVRTrustedVideoPlugin_Vtbl, 0x83a4ce40_7710_494b_a893_a472049af630);
windows_core::imp::interface_hierarchy!(IEVRTrustedVideoPlugin, windows_core::IUnknown);
impl IEVRTrustedVideoPlugin {
    pub unsafe fn IsInTrustedVideoMode(&self) -> windows_core::Result<super::super::Foundation::BOOL> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).IsInTrustedVideoMode)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn CanConstrict(&self) -> windows_core::Result<super::super::Foundation::BOOL> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).CanConstrict)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetConstriction(&self, dwkpix: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetConstriction)(windows_core::Interface::as_raw(self), dwkpix).ok() }
    }
    pub unsafe fn DisableImageExport(&self, bdisable: bool) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).DisableImageExport)(windows_core::Interface::as_raw(self), bdisable.into()).ok() }
    }
}
#[repr(C)]
pub struct IEVRTrustedVideoPlugin_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub IsInTrustedVideoMode: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::BOOL) -> windows_core::HRESULT,
    pub CanConstrict: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::BOOL) -> windows_core::HRESULT,
    pub SetConstriction: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub DisableImageExport: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::BOOL) -> windows_core::HRESULT,
}
pub trait IEVRTrustedVideoPlugin_Impl: windows_core::IUnknownImpl {
    fn IsInTrustedVideoMode(&self) -> windows_core::Result<super::super::Foundation::BOOL>;
    fn CanConstrict(&self) -> windows_core::Result<super::super::Foundation::BOOL>;
    fn SetConstriction(&self, dwkpix: u32) -> windows_core::Result<()>;
    fn DisableImageExport(&self, bdisable: super::super::Foundation::BOOL) -> windows_core::Result<()>;
}
impl IEVRTrustedVideoPlugin_Vtbl {
    pub const fn new<Identity: IEVRTrustedVideoPlugin_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn IsInTrustedVideoMode<Identity: IEVRTrustedVideoPlugin_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pyes: *mut super::super::Foundation::BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IEVRTrustedVideoPlugin_Impl::IsInTrustedVideoMode(this) {
                    Ok(ok__) => {
                        pyes.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn CanConstrict<Identity: IEVRTrustedVideoPlugin_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pyes: *mut super::super::Foundation::BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IEVRTrustedVideoPlugin_Impl::CanConstrict(this) {
                    Ok(ok__) => {
                        pyes.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetConstriction<Identity: IEVRTrustedVideoPlugin_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwkpix: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IEVRTrustedVideoPlugin_Impl::SetConstriction(this, core::mem::transmute_copy(&dwkpix)).into()
            }
        }
        unsafe extern "system" fn DisableImageExport<Identity: IEVRTrustedVideoPlugin_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, bdisable: super::super::Foundation::BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IEVRTrustedVideoPlugin_Impl::DisableImageExport(this, core::mem::transmute_copy(&bdisable)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            IsInTrustedVideoMode: IsInTrustedVideoMode::<Identity, OFFSET>,
            CanConstrict: CanConstrict::<Identity, OFFSET>,
            SetConstriction: SetConstriction::<Identity, OFFSET>,
            DisableImageExport: DisableImageExport::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IEVRTrustedVideoPlugin as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IEVRTrustedVideoPlugin {}
windows_core::imp::define_interface!(IEVRVideoStreamControl, IEVRVideoStreamControl_Vtbl, 0xd0cfe38b_93e7_4772_8957_0400c49a4485);
windows_core::imp::interface_hierarchy!(IEVRVideoStreamControl, windows_core::IUnknown);
impl IEVRVideoStreamControl {
    pub unsafe fn SetStreamActiveState(&self, factive: bool) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetStreamActiveState)(windows_core::Interface::as_raw(self), factive.into()).ok() }
    }
    pub unsafe fn GetStreamActiveState(&self) -> windows_core::Result<super::super::Foundation::BOOL> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetStreamActiveState)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
}
#[repr(C)]
pub struct IEVRVideoStreamControl_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub SetStreamActiveState: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::BOOL) -> windows_core::HRESULT,
    pub GetStreamActiveState: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::BOOL) -> windows_core::HRESULT,
}
pub trait IEVRVideoStreamControl_Impl: windows_core::IUnknownImpl {
    fn SetStreamActiveState(&self, factive: super::super::Foundation::BOOL) -> windows_core::Result<()>;
    fn GetStreamActiveState(&self) -> windows_core::Result<super::super::Foundation::BOOL>;
}
impl IEVRVideoStreamControl_Vtbl {
    pub const fn new<Identity: IEVRVideoStreamControl_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn SetStreamActiveState<Identity: IEVRVideoStreamControl_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, factive: super::super::Foundation::BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IEVRVideoStreamControl_Impl::SetStreamActiveState(this, core::mem::transmute_copy(&factive)).into()
            }
        }
        unsafe extern "system" fn GetStreamActiveState<Identity: IEVRVideoStreamControl_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, lpfactive: *mut super::super::Foundation::BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IEVRVideoStreamControl_Impl::GetStreamActiveState(this) {
                    Ok(ok__) => {
                        lpfactive.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            SetStreamActiveState: SetStreamActiveState::<Identity, OFFSET>,
            GetStreamActiveState: GetStreamActiveState::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IEVRVideoStreamControl as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IEVRVideoStreamControl {}
windows_core::imp::define_interface!(IFileClient, IFileClient_Vtbl, 0xbfccd196_1244_4840_ab44_480975c4ffe4);
windows_core::imp::interface_hierarchy!(IFileClient, windows_core::IUnknown);
impl IFileClient {
    pub unsafe fn GetObjectDiskSize(&self, pqwsize: *mut u64) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetObjectDiskSize)(windows_core::Interface::as_raw(self), pqwsize as _).ok() }
    }
    pub unsafe fn Write<P0>(&self, pfio: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IFileIo>,
    {
        unsafe { (windows_core::Interface::vtable(self).Write)(windows_core::Interface::as_raw(self), pfio.param().abi()).ok() }
    }
    pub unsafe fn Read<P0>(&self, pfio: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IFileIo>,
    {
        unsafe { (windows_core::Interface::vtable(self).Read)(windows_core::Interface::as_raw(self), pfio.param().abi()).ok() }
    }
}
#[repr(C)]
pub struct IFileClient_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetObjectDiskSize: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u64) -> windows_core::HRESULT,
    pub Write: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub Read: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
}
pub trait IFileClient_Impl: windows_core::IUnknownImpl {
    fn GetObjectDiskSize(&self, pqwsize: *mut u64) -> windows_core::Result<()>;
    fn Write(&self, pfio: windows_core::Ref<'_, IFileIo>) -> windows_core::Result<()>;
    fn Read(&self, pfio: windows_core::Ref<'_, IFileIo>) -> windows_core::Result<()>;
}
impl IFileClient_Vtbl {
    pub const fn new<Identity: IFileClient_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetObjectDiskSize<Identity: IFileClient_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pqwsize: *mut u64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IFileClient_Impl::GetObjectDiskSize(this, core::mem::transmute_copy(&pqwsize)).into()
            }
        }
        unsafe extern "system" fn Write<Identity: IFileClient_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pfio: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IFileClient_Impl::Write(this, core::mem::transmute_copy(&pfio)).into()
            }
        }
        unsafe extern "system" fn Read<Identity: IFileClient_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pfio: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IFileClient_Impl::Read(this, core::mem::transmute_copy(&pfio)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetObjectDiskSize: GetObjectDiskSize::<Identity, OFFSET>,
            Write: Write::<Identity, OFFSET>,
            Read: Read::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IFileClient as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IFileClient {}
windows_core::imp::define_interface!(IFileIo, IFileIo_Vtbl, 0x11993196_1244_4840_ab44_480975c4ffe4);
windows_core::imp::interface_hierarchy!(IFileIo, windows_core::IUnknown);
impl IFileIo {
    pub unsafe fn Initialize<P2>(&self, eaccessmode: FILE_ACCESSMODE, eopenmode: FILE_OPENMODE, pwszfilename: P2) -> windows_core::Result<()>
    where
        P2: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).Initialize)(windows_core::Interface::as_raw(self), eaccessmode, eopenmode, pwszfilename.param().abi()).ok() }
    }
    pub unsafe fn GetLength(&self, pqwlength: *mut u64) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetLength)(windows_core::Interface::as_raw(self), pqwlength as _).ok() }
    }
    pub unsafe fn SetLength(&self, qwlength: u64) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetLength)(windows_core::Interface::as_raw(self), qwlength).ok() }
    }
    pub unsafe fn GetCurrentPosition(&self, pqwposition: *mut u64) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetCurrentPosition)(windows_core::Interface::as_raw(self), pqwposition as _).ok() }
    }
    pub unsafe fn SetCurrentPosition(&self, qwposition: u64) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetCurrentPosition)(windows_core::Interface::as_raw(self), qwposition).ok() }
    }
    pub unsafe fn IsEndOfStream(&self, pbendofstream: *mut super::super::Foundation::BOOL) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).IsEndOfStream)(windows_core::Interface::as_raw(self), pbendofstream as _).ok() }
    }
    pub unsafe fn Read(&self, pbt: *mut u8, ul: u32, pulread: *mut u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Read)(windows_core::Interface::as_raw(self), pbt as _, ul, pulread as _).ok() }
    }
    pub unsafe fn Write(&self, pbt: *mut u8, ul: u32, pulwritten: *mut u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Write)(windows_core::Interface::as_raw(self), pbt as _, ul, pulwritten as _).ok() }
    }
    pub unsafe fn Seek(&self, eseekorigin: SEEK_ORIGIN, qwseekoffset: u64, dwseekflags: u32, pqwcurrentposition: *mut u64) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Seek)(windows_core::Interface::as_raw(self), eseekorigin, qwseekoffset, dwseekflags, pqwcurrentposition as _).ok() }
    }
    pub unsafe fn Close(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Close)(windows_core::Interface::as_raw(self)).ok() }
    }
}
#[repr(C)]
pub struct IFileIo_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub Initialize: unsafe extern "system" fn(*mut core::ffi::c_void, FILE_ACCESSMODE, FILE_OPENMODE, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub GetLength: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u64) -> windows_core::HRESULT,
    pub SetLength: unsafe extern "system" fn(*mut core::ffi::c_void, u64) -> windows_core::HRESULT,
    pub GetCurrentPosition: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u64) -> windows_core::HRESULT,
    pub SetCurrentPosition: unsafe extern "system" fn(*mut core::ffi::c_void, u64) -> windows_core::HRESULT,
    pub IsEndOfStream: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::BOOL) -> windows_core::HRESULT,
    pub Read: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8, u32, *mut u32) -> windows_core::HRESULT,
    pub Write: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8, u32, *mut u32) -> windows_core::HRESULT,
    pub Seek: unsafe extern "system" fn(*mut core::ffi::c_void, SEEK_ORIGIN, u64, u32, *mut u64) -> windows_core::HRESULT,
    pub Close: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
}
pub trait IFileIo_Impl: windows_core::IUnknownImpl {
    fn Initialize(&self, eaccessmode: FILE_ACCESSMODE, eopenmode: FILE_OPENMODE, pwszfilename: &windows_core::PCWSTR) -> windows_core::Result<()>;
    fn GetLength(&self, pqwlength: *mut u64) -> windows_core::Result<()>;
    fn SetLength(&self, qwlength: u64) -> windows_core::Result<()>;
    fn GetCurrentPosition(&self, pqwposition: *mut u64) -> windows_core::Result<()>;
    fn SetCurrentPosition(&self, qwposition: u64) -> windows_core::Result<()>;
    fn IsEndOfStream(&self, pbendofstream: *mut super::super::Foundation::BOOL) -> windows_core::Result<()>;
    fn Read(&self, pbt: *mut u8, ul: u32, pulread: *mut u32) -> windows_core::Result<()>;
    fn Write(&self, pbt: *mut u8, ul: u32, pulwritten: *mut u32) -> windows_core::Result<()>;
    fn Seek(&self, eseekorigin: SEEK_ORIGIN, qwseekoffset: u64, dwseekflags: u32, pqwcurrentposition: *mut u64) -> windows_core::Result<()>;
    fn Close(&self) -> windows_core::Result<()>;
}
impl IFileIo_Vtbl {
    pub const fn new<Identity: IFileIo_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn Initialize<Identity: IFileIo_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, eaccessmode: FILE_ACCESSMODE, eopenmode: FILE_OPENMODE, pwszfilename: windows_core::PCWSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IFileIo_Impl::Initialize(this, core::mem::transmute_copy(&eaccessmode), core::mem::transmute_copy(&eopenmode), core::mem::transmute(&pwszfilename)).into()
            }
        }
        unsafe extern "system" fn GetLength<Identity: IFileIo_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pqwlength: *mut u64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IFileIo_Impl::GetLength(this, core::mem::transmute_copy(&pqwlength)).into()
            }
        }
        unsafe extern "system" fn SetLength<Identity: IFileIo_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, qwlength: u64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IFileIo_Impl::SetLength(this, core::mem::transmute_copy(&qwlength)).into()
            }
        }
        unsafe extern "system" fn GetCurrentPosition<Identity: IFileIo_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pqwposition: *mut u64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IFileIo_Impl::GetCurrentPosition(this, core::mem::transmute_copy(&pqwposition)).into()
            }
        }
        unsafe extern "system" fn SetCurrentPosition<Identity: IFileIo_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, qwposition: u64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IFileIo_Impl::SetCurrentPosition(this, core::mem::transmute_copy(&qwposition)).into()
            }
        }
        unsafe extern "system" fn IsEndOfStream<Identity: IFileIo_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbendofstream: *mut super::super::Foundation::BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IFileIo_Impl::IsEndOfStream(this, core::mem::transmute_copy(&pbendofstream)).into()
            }
        }
        unsafe extern "system" fn Read<Identity: IFileIo_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbt: *mut u8, ul: u32, pulread: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IFileIo_Impl::Read(this, core::mem::transmute_copy(&pbt), core::mem::transmute_copy(&ul), core::mem::transmute_copy(&pulread)).into()
            }
        }
        unsafe extern "system" fn Write<Identity: IFileIo_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbt: *mut u8, ul: u32, pulwritten: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IFileIo_Impl::Write(this, core::mem::transmute_copy(&pbt), core::mem::transmute_copy(&ul), core::mem::transmute_copy(&pulwritten)).into()
            }
        }
        unsafe extern "system" fn Seek<Identity: IFileIo_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, eseekorigin: SEEK_ORIGIN, qwseekoffset: u64, dwseekflags: u32, pqwcurrentposition: *mut u64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IFileIo_Impl::Seek(this, core::mem::transmute_copy(&eseekorigin), core::mem::transmute_copy(&qwseekoffset), core::mem::transmute_copy(&dwseekflags), core::mem::transmute_copy(&pqwcurrentposition)).into()
            }
        }
        unsafe extern "system" fn Close<Identity: IFileIo_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IFileIo_Impl::Close(this).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            Initialize: Initialize::<Identity, OFFSET>,
            GetLength: GetLength::<Identity, OFFSET>,
            SetLength: SetLength::<Identity, OFFSET>,
            GetCurrentPosition: GetCurrentPosition::<Identity, OFFSET>,
            SetCurrentPosition: SetCurrentPosition::<Identity, OFFSET>,
            IsEndOfStream: IsEndOfStream::<Identity, OFFSET>,
            Read: Read::<Identity, OFFSET>,
            Write: Write::<Identity, OFFSET>,
            Seek: Seek::<Identity, OFFSET>,
            Close: Close::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IFileIo as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IFileIo {}
windows_core::imp::define_interface!(IMF2DBuffer, IMF2DBuffer_Vtbl, 0x7dc9d5f9_9ed9_44ec_9bbf_0600bb589fbb);
windows_core::imp::interface_hierarchy!(IMF2DBuffer, windows_core::IUnknown);
impl IMF2DBuffer {
    pub unsafe fn Lock2D(&self, ppbscanline0: *mut *mut u8, plpitch: *mut i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Lock2D)(windows_core::Interface::as_raw(self), ppbscanline0 as _, plpitch as _).ok() }
    }
    pub unsafe fn Unlock2D(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Unlock2D)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn GetScanline0AndPitch(&self, pbscanline0: *mut *mut u8, plpitch: *mut i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetScanline0AndPitch)(windows_core::Interface::as_raw(self), pbscanline0 as _, plpitch as _).ok() }
    }
    pub unsafe fn IsContiguousFormat(&self) -> windows_core::Result<super::super::Foundation::BOOL> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).IsContiguousFormat)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetContiguousLength(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetContiguousLength)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn ContiguousCopyTo(&self, pbdestbuffer: &mut [u8]) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).ContiguousCopyTo)(windows_core::Interface::as_raw(self), core::mem::transmute(pbdestbuffer.as_ptr()), pbdestbuffer.len().try_into().unwrap()).ok() }
    }
    pub unsafe fn ContiguousCopyFrom(&self, pbsrcbuffer: &[u8]) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).ContiguousCopyFrom)(windows_core::Interface::as_raw(self), core::mem::transmute(pbsrcbuffer.as_ptr()), pbsrcbuffer.len().try_into().unwrap()).ok() }
    }
}
#[repr(C)]
pub struct IMF2DBuffer_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub Lock2D: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut u8, *mut i32) -> windows_core::HRESULT,
    pub Unlock2D: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetScanline0AndPitch: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut u8, *mut i32) -> windows_core::HRESULT,
    pub IsContiguousFormat: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::BOOL) -> windows_core::HRESULT,
    pub GetContiguousLength: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub ContiguousCopyTo: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8, u32) -> windows_core::HRESULT,
    pub ContiguousCopyFrom: unsafe extern "system" fn(*mut core::ffi::c_void, *const u8, u32) -> windows_core::HRESULT,
}
pub trait IMF2DBuffer_Impl: windows_core::IUnknownImpl {
    fn Lock2D(&self, ppbscanline0: *mut *mut u8, plpitch: *mut i32) -> windows_core::Result<()>;
    fn Unlock2D(&self) -> windows_core::Result<()>;
    fn GetScanline0AndPitch(&self, pbscanline0: *mut *mut u8, plpitch: *mut i32) -> windows_core::Result<()>;
    fn IsContiguousFormat(&self) -> windows_core::Result<super::super::Foundation::BOOL>;
    fn GetContiguousLength(&self) -> windows_core::Result<u32>;
    fn ContiguousCopyTo(&self, pbdestbuffer: *mut u8, cbdestbuffer: u32) -> windows_core::Result<()>;
    fn ContiguousCopyFrom(&self, pbsrcbuffer: *const u8, cbsrcbuffer: u32) -> windows_core::Result<()>;
}
impl IMF2DBuffer_Vtbl {
    pub const fn new<Identity: IMF2DBuffer_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn Lock2D<Identity: IMF2DBuffer_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppbscanline0: *mut *mut u8, plpitch: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IMF2DBuffer_Impl::Lock2D(this, core::mem::transmute_copy(&ppbscanline0), core::mem::transmute_copy(&plpitch)).into()
            }
        }
        unsafe extern "system" fn Unlock2D<Identity: IMF2DBuffer_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IMF2DBuffer_Impl::Unlock2D(this).into()
            }
        }
        unsafe extern "system" fn GetScanline0AndPitch<Identity: IMF2DBuffer_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbscanline0: *mut *mut u8, plpitch: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IMF2DBuffer_Impl::GetScanline0AndPitch(this, core::mem::transmute_copy(&pbscanline0), core::mem::transmute_copy(&plpitch)).into()
            }
        }
        unsafe extern "system" fn IsContiguousFormat<Identity: IMF2DBuffer_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pfiscontiguous: *mut super::super::Foundation::BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IMF2DBuffer_Impl::IsContiguousFormat(this) {
                    Ok(ok__) => {
                        pfiscontiguous.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetContiguousLength<Identity: IMF2DBuffer_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pcblength: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IMF2DBuffer_Impl::GetContiguousLength(this) {
                    Ok(ok__) => {
                        pcblength.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn ContiguousCopyTo<Identity: IMF2DBuffer_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbdestbuffer: *mut u8, cbdestbuffer: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IMF2DBuffer_Impl::ContiguousCopyTo(this, core::mem::transmute_copy(&pbdestbuffer), core::mem::transmute_copy(&cbdestbuffer)).into()
            }
        }
        unsafe extern "system" fn ContiguousCopyFrom<Identity: IMF2DBuffer_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbsrcbuffer: *const u8, cbsrcbuffer: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IMF2DBuffer_Impl::ContiguousCopyFrom(this, core::mem::transmute_copy(&pbsrcbuffer), core::mem::transmute_copy(&cbsrcbuffer)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            Lock2D: Lock2D::<Identity, OFFSET>,
            Unlock2D: Unlock2D::<Identity, OFFSET>,
            GetScanline0AndPitch: GetScanline0AndPitch::<Identity, OFFSET>,
            IsContiguousFormat: IsContiguousFormat::<Identity, OFFSET>,
            GetContiguousLength: GetContiguousLength::<Identity, OFFSET>,
            ContiguousCopyTo: ContiguousCopyTo::<Identity, OFFSET>,
            ContiguousCopyFrom: ContiguousCopyFrom::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IMF2DBuffer as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IMF2DBuffer {}
windows_core::imp::define_interface!(IMF2DBuffer2, IMF2DBuffer2_Vtbl, 0x33ae5ea6_4316_436f_8ddd_d73d22f829ec);
impl core::ops::Deref for IMF2DBuffer2 {
    type Target = IMF2DBuffer;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IMF2DBuffer2, windows_core::IUnknown, IMF2DBuffer);
impl IMF2DBuffer2 {
    pub unsafe fn Lock2DSize(&self, lockflags: MF2DBuffer_LockFlags, ppbscanline0: *mut *mut u8, plpitch: *mut i32, ppbbufferstart: *mut *mut u8, pcbbufferlength: *mut u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Lock2DSize)(windows_core::Interface::as_raw(self), lockflags, ppbscanline0 as _, plpitch as _, ppbbufferstart as _, pcbbufferlength as _).ok() }
    }
    pub unsafe fn Copy2DTo<P0>(&self, pdestbuffer: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IMF2DBuffer2>,
    {
        unsafe { (windows_core::Interface::vtable(self).Copy2DTo)(windows_core::Interface::as_raw(self), pdestbuffer.param().abi()).ok() }
    }
}
#[repr(C)]
pub struct IMF2DBuffer2_Vtbl {
    pub base__: IMF2DBuffer_Vtbl,
    pub Lock2DSize: unsafe extern "system" fn(*mut core::ffi::c_void, MF2DBuffer_LockFlags, *mut *mut u8, *mut i32, *mut *mut u8, *mut u32) -> windows_core::HRESULT,
    pub Copy2DTo: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
}
pub trait IMF2DBuffer2_Impl: IMF2DBuffer_Impl {
    fn Lock2DSize(&self, lockflags: MF2DBuffer_LockFlags, ppbscanline0: *mut *mut u8, plpitch: *mut i32, ppbbufferstart: *mut *mut u8, pcbbufferlength: *mut u32) -> windows_core::Result<()>;
    fn Copy2DTo(&self, pdestbuffer: windows_core::Ref<'_, IMF2DBuffer2>) -> windows_core::Result<()>;
}
impl IMF2DBuffer2_Vtbl {
    pub const fn new<Identity: IMF2DBuffer2_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn Lock2DSize<Identity: IMF2DBuffer2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, lockflags: MF2DBuffer_LockFlags, ppbscanline0: *mut *mut u8, plpitch: *mut i32, ppbbufferstart: *mut *mut u8, pcbbufferlength: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IMF2DBuffer2_Impl::Lock2DSize(this, core::mem::transmute_copy(&lockflags), core::mem::transmute_copy(&ppbscanline0), core::mem::transmute_copy(&plpitch), core::mem::transmute_copy(&ppbbufferstart), core::mem::transmute_copy(&pcbbufferlength)).into()
            }
        }
        unsafe extern "system" fn Copy2DTo<Identity: IMF2DBuffer2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pdestbuffer: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IMF2DBuffer2_Impl::Copy2DTo(this, core::mem::transmute_copy(&pdestbuffer)).into()
            }
        }
        Self { base__: IMF2DBuffer_Vtbl::new::<Identity, OFFSET>(), Lock2DSize: Lock2DSize::<Identity, OFFSET>, Copy2DTo: Copy2DTo::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IMF2DBuffer2 as windows_core::Interface>::IID || iid == &<IMF2DBuffer as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IMF2DBuffer2 {}
windows_core::imp::define_interface!(IMFASFContentInfo, IMFASFContentInfo_Vtbl, 0xb1dca5cd_d5da_4451_8e9e_db5c59914ead);
windows_core::imp::interface_hierarchy!(IMFASFContentInfo, windows_core::IUnknown);
impl IMFASFContentInfo {
    pub unsafe fn GetHeaderSize<P0>(&self, pistartofcontent: P0) -> windows_core::Result<u64>
    where
        P0: windows_core::Param<IMFMediaBuffer>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetHeaderSize)(windows_core::Interface::as_raw(self), pistartofcontent.param().abi(), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn ParseHeader<P0>(&self, piheaderbuffer: P0, cboffsetwithinheader: u64) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IMFMediaBuffer>,
    {
        unsafe { (windows_core::Interface::vtable(self).ParseHeader)(windows_core::Interface::as_raw(self), piheaderbuffer.param().abi(), cboffsetwithinheader).ok() }
    }
    pub unsafe fn GenerateHeader<P0>(&self, piheader: P0) -> windows_core::Result<u32>
    where
        P0: windows_core::Param<IMFMediaBuffer>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GenerateHeader)(windows_core::Interface::as_raw(self), piheader.param().abi(), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetProfile(&self) -> windows_core::Result<IMFASFProfile> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetProfile)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn SetProfile<P0>(&self, piprofile: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IMFASFProfile>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetProfile)(windows_core::Interface::as_raw(self), piprofile.param().abi()).ok() }
    }
    pub unsafe fn GeneratePresentationDescriptor(&self) -> windows_core::Result<IMFPresentationDescriptor> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GeneratePresentationDescriptor)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub unsafe fn GetEncodingConfigurationPropertyStore(&self, wstreamnumber: u16) -> windows_core::Result<super::super::UI::Shell::PropertiesSystem::IPropertyStore> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetEncodingConfigurationPropertyStore)(windows_core::Interface::as_raw(self), wstreamnumber, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
}
#[repr(C)]
pub struct IMFASFContentInfo_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetHeaderSize: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut u64) -> windows_core::HRESULT,
    pub ParseHeader: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, u64) -> windows_core::HRESULT,
    pub GenerateHeader: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetProfile: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetProfile: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GeneratePresentationDescriptor: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub GetEncodingConfigurationPropertyStore: unsafe extern "system" fn(*mut core::ffi::c_void, u16, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_PropertiesSystem"))]
    GetEncodingConfigurationPropertyStore: usize,
}
#[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
pub trait IMFASFContentInfo_Impl: windows_core::IUnknownImpl {
    fn GetHeaderSize(&self, pistartofcontent: windows_core::Ref<'_, IMFMediaBuffer>) -> windows_core::Result<u64>;
    fn ParseHeader(&self, piheaderbuffer: windows_core::Ref<'_, IMFMediaBuffer>, cboffsetwithinheader: u64) -> windows_core::Result<()>;
    fn GenerateHeader(&self, piheader: windows_core::Ref<'_, IMFMediaBuffer>) -> windows_core::Result<u32>;
    fn GetProfile(&self) -> windows_core::Result<IMFASFProfile>;
    fn SetProfile(&self, piprofile: windows_core::Ref<'_, IMFASFProfile>) -> windows_core::Result<()>;
    fn GeneratePresentationDescriptor(&self) -> windows_core::Result<IMFPresentationDescriptor>;
    fn GetEncodingConfigurationPropertyStore(&self, wstreamnumber: u16) -> windows_core::Result<super::super::UI::Shell::PropertiesSystem::IPropertyStore>;
}
#[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
impl IMFASFContentInfo_Vtbl {
    pub const fn new<Identity: IMFASFContentInfo_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetHeaderSize<Identity: IMFASFContentInfo_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pistartofcontent: *mut core::ffi::c_void, cbheadersize: *mut u64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IMFASFContentInfo_Impl::GetHeaderSize(this, core::mem::transmute_copy(&pistartofcontent)) {
                    Ok(ok__) => {
                        cbheadersize.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn ParseHeader<Identity: IMFASFContentInfo_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, piheaderbuffer: *mut core::ffi::c_void, cboffsetwithinheader: u64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IMFASFContentInfo_Impl::ParseHeader(this, core::mem::transmute_copy(&piheaderbuffer), core::mem::transmute_copy(&cboffsetwithinheader)).into()
            }
        }
        unsafe extern "system" fn GenerateHeader<Identity: IMFASFContentInfo_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, piheader: *mut core::ffi::c_void, pcbheader: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IMFASFContentInfo_Impl::GenerateHeader(this, core::mem::transmute_copy(&piheader)) {
                    Ok(ok__) => {
                        pcbheader.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetProfile<Identity: IMFASFContentInfo_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppiprofile: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IMFASFContentInfo_Impl::GetProfile(this) {
                    Ok(ok__) => {
                        ppiprofile.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetProfile<Identity: IMFASFContentInfo_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, piprofile: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IMFASFContentInfo_Impl::SetProfile(this, core::mem::transmute_copy(&piprofile)).into()
            }
        }
        unsafe extern "system" fn GeneratePresentationDescriptor<Identity: IMFASFContentInfo_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppipresentationdescriptor: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IMFASFContentInfo_Impl::GeneratePresentationDescriptor(this) {
                    Ok(ok__) => {
                        ppipresentationdescriptor.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetEncodingConfigurationPropertyStore<Identity: IMFASFContentInfo_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, wstreamnumber: u16, ppistore: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IMFASFContentInfo_Impl::GetEncodingConfigurationPropertyStore(this, core::mem::transmute_copy(&wstreamnumber)) {
                    Ok(ok__) => {
                        ppistore.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetHeaderSize: GetHeaderSize::<Identity, OFFSET>,
            ParseHeader: ParseHeader::<Identity, OFFSET>,
            GenerateHeader: GenerateHeader::<Identity, OFFSET>,
            GetProfile: GetProfile::<Identity, OFFSET>,
            SetProfile: SetProfile::<Identity, OFFSET>,
            GeneratePresentationDescriptor: GeneratePresentationDescriptor::<Identity, OFFSET>,
            GetEncodingConfigurationPropertyStore: GetEncodingConfigurationPropertyStore::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IMFASFContentInfo as windows_core::Interface>::IID
    }
}
#[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
impl windows_core::RuntimeName for IMFASFContentInfo {}
windows_core::imp::define_interface!(IMFASFIndexer, IMFASFIndexer_Vtbl, 0x53590f48_dc3b_4297_813f_787761ad7b3e);
windows_core::imp::interface_hierarchy!(IMFASFIndexer, windows_core::IUnknown);
impl IMFASFIndexer {
    pub unsafe fn SetFlags(&self, dwflags: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetFlags)(windows_core::Interface::as_raw(self), dwflags).ok() }
    }
    pub unsafe fn GetFlags(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetFlags)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn Initialize<P0>(&self, picontentinfo: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IMFASFContentInfo>,
    {
        unsafe { (windows_core::Interface::vtable(self).Initialize)(windows_core::Interface::as_raw(self), picontentinfo.param().abi()).ok() }
    }
    pub unsafe fn GetIndexPosition<P0>(&self, picontentinfo: P0) -> windows_core::Result<u64>
    where
        P0: windows_core::Param<IMFASFContentInfo>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetIndexPosition)(windows_core::Interface::as_raw(self), picontentinfo.param().abi(), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetIndexByteStreams(&self, ppibytestreams: *const Option<IMFByteStream>, cbytestreams: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetIndexByteStreams)(windows_core::Interface::as_raw(self), core::mem::transmute(ppibytestreams), cbytestreams).ok() }
    }
    pub unsafe fn GetIndexByteStreamCount(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetIndexByteStreamCount)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetIndexStatus(&self, pindexidentifier: *const ASF_INDEX_IDENTIFIER, pfisindexed: *mut super::super::Foundation::BOOL, pbindexdescriptor: *mut u8, pcbindexdescriptor: *mut u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetIndexStatus)(windows_core::Interface::as_raw(self), pindexidentifier, pfisindexed as _, pbindexdescriptor as _, pcbindexdescriptor as _).ok() }
    }
    pub unsafe fn SetIndexStatus(&self, pbindexdescriptor: *const u8, cbindexdescriptor: u32, fgenerateindex: bool) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetIndexStatus)(windows_core::Interface::as_raw(self), pbindexdescriptor, cbindexdescriptor, fgenerateindex.into()).ok() }
    }
    #[cfg(all(feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Variant"))]
    pub unsafe fn GetSeekPositionForValue(&self, pvarvalue: *const super::super::System::Com::StructuredStorage::PROPVARIANT, pindexidentifier: *const ASF_INDEX_IDENTIFIER, pcboffsetwithindata: *mut u64, phnsapproxtime: *mut i64, pdwpayloadnumberofstreamwithinpacket: *mut u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetSeekPositionForValue)(windows_core::Interface::as_raw(self), core::mem::transmute(pvarvalue), pindexidentifier, pcboffsetwithindata as _, phnsapproxtime as _, pdwpayloadnumberofstreamwithinpacket as _).ok() }
    }
    pub unsafe fn GenerateIndexEntries<P0>(&self, piasfpacketsample: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IMFSample>,
    {
        unsafe { (windows_core::Interface::vtable(self).GenerateIndexEntries)(windows_core::Interface::as_raw(self), piasfpacketsample.param().abi()).ok() }
    }
    pub unsafe fn CommitIndex<P0>(&self, picontentinfo: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IMFASFContentInfo>,
    {
        unsafe { (windows_core::Interface::vtable(self).CommitIndex)(windows_core::Interface::as_raw(self), picontentinfo.param().abi()).ok() }
    }
    pub unsafe fn GetIndexWriteSpace(&self) -> windows_core::Result<u64> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetIndexWriteSpace)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetCompletedIndex<P0>(&self, piindexbuffer: P0, cboffsetwithinindex: u64) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IMFMediaBuffer>,
    {
        unsafe { (windows_core::Interface::vtable(self).GetCompletedIndex)(windows_core::Interface::as_raw(self), piindexbuffer.param().abi(), cboffsetwithinindex).ok() }
    }
}
#[repr(C)]
pub struct IMFASFIndexer_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub SetFlags: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetFlags: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub Initialize: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetIndexPosition: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut u64) -> windows_core::HRESULT,
    pub SetIndexByteStreams: unsafe extern "system" fn(*mut core::ffi::c_void, *const *mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetIndexByteStreamCount: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetIndexStatus: unsafe extern "system" fn(*mut core::ffi::c_void, *const ASF_INDEX_IDENTIFIER, *mut super::super::Foundation::BOOL, *mut u8, *mut u32) -> windows_core::HRESULT,
    pub SetIndexStatus: unsafe extern "system" fn(*mut core::ffi::c_void, *const u8, u32, super::super::Foundation::BOOL) -> windows_core::HRESULT,
    #[cfg(all(feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Variant"))]
    pub GetSeekPositionForValue: unsafe extern "system" fn(*mut core::ffi::c_void, *const super::super::System::Com::StructuredStorage::PROPVARIANT, *const ASF_INDEX_IDENTIFIER, *mut u64, *mut i64, *mut u32) -> windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Variant")))]
    GetSeekPositionForValue: usize,
    pub GenerateIndexEntries: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub CommitIndex: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetIndexWriteSpace: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u64) -> windows_core::HRESULT,
    pub GetCompletedIndex: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, u64) -> windows_core::HRESULT,
}
#[cfg(all(feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Variant"))]
pub trait IMFASFIndexer_Impl: windows_core::IUnknownImpl {
    fn SetFlags(&self, dwflags: u32) -> windows_core::Result<()>;
    fn GetFlags(&self) -> windows_core::Result<u32>;
    fn Initialize(&self, picontentinfo: windows_core::Ref<'_, IMFASFContentInfo>) -> windows_core::Result<()>;
    fn GetIndexPosition(&self, picontentinfo: windows_core::Ref<'_, IMFASFContentInfo>) -> windows_core::Result<u64>;
    fn SetIndexByteStreams(&self, ppibytestreams: *const Option<IMFByteStream>, cbytestreams: u32) -> windows_core::Result<()>;
    fn GetIndexByteStreamCount(&self) -> windows_core::Result<u32>;
    fn GetIndexStatus(&self, pindexidentifier: *const ASF_INDEX_IDENTIFIER, pfisindexed: *mut super::super::Foundation::BOOL, pbindexdescriptor: *mut u8, pcbindexdescriptor: *mut u32) -> windows_core::Result<()>;
    fn SetIndexStatus(&self, pbindexdescriptor: *const u8, cbindexdescriptor: u32, fgenerateindex: super::super::Foundation::BOOL) -> windows_core::Result<()>;
    fn GetSeekPositionForValue(&self, pvarvalue: *const super::super::System::Com::StructuredStorage::PROPVARIANT, pindexidentifier: *const ASF_INDEX_IDENTIFIER, pcboffsetwithindata: *mut u64, phnsapproxtime: *mut i64, pdwpayloadnumberofstreamwithinpacket: *mut u32) -> windows_core::Result<()>;
    fn GenerateIndexEntries(&self, piasfpacketsample: windows_core::Ref<'_, IMFSample>) -> windows_core::Result<()>;
    fn CommitIndex(&self, picontentinfo: windows_core::Ref<'_, IMFASFContentInfo>) -> windows_core::Result<()>;
    fn GetIndexWriteSpace(&self) -> windows_core::Result<u64>;
    fn GetCompletedIndex(&self, piindexbuffer: windows_core::Ref<'_, IMFMediaBuffer>, cboffsetwithinindex: u64) -> windows_core::Result<()>;
}
#[cfg(all(feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Variant"))]
impl IMFASFIndexer_Vtbl {
    pub const fn new<Identity: IMFASFIndexer_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn SetFlags<Identity: IMFASFIndexer_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwflags: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IMFASFIndexer_Impl::SetFlags(this, core::mem::transmute_copy(&dwflags)).into()
            }
        }
        unsafe extern "system" fn GetFlags<Identity: IMFASFIndexer_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pdwflags: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IMFASFIndexer_Impl::GetFlags(this) {
                    Ok(ok__) => {
                        pdwflags.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn Initialize<Identity: IMFASFIndexer_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, picontentinfo: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IMFASFIndexer_Impl::Initialize(this, core::mem::transmute_copy(&picontentinfo)).into()
            }
        }
        unsafe extern "system" fn GetIndexPosition<Identity: IMFASFIndexer_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, picontentinfo: *mut core::ffi::c_void, pcbindexoffset: *mut u64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IMFASFIndexer_Impl::GetIndexPosition(this, core::mem::transmute_copy(&picontentinfo)) {
                    Ok(ok__) => {
                        pcbindexoffset.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetIndexByteStreams<Identity: IMFASFIndexer_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppibytestreams: *const *mut core::ffi::c_void, cbytestreams: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IMFASFIndexer_Impl::SetIndexByteStreams(this, core::mem::transmute_copy(&ppibytestreams), core::mem::transmute_copy(&cbytestreams)).into()
            }
        }
        unsafe extern "system" fn GetIndexByteStreamCount<Identity: IMFASFIndexer_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pcbytestreams: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IMFASFIndexer_Impl::GetIndexByteStreamCount(this) {
                    Ok(ok__) => {
                        pcbytestreams.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetIndexStatus<Identity: IMFASFIndexer_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pindexidentifier: *const ASF_INDEX_IDENTIFIER, pfisindexed: *mut super::super::Foundation::BOOL, pbindexdescriptor: *mut u8, pcbindexdescriptor: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IMFASFIndexer_Impl::GetIndexStatus(this, core::mem::transmute_copy(&pindexidentifier), core::mem::transmute_copy(&pfisindexed), core::mem::transmute_copy(&pbindexdescriptor), core::mem::transmute_copy(&pcbindexdescriptor)).into()
            }
        }
        unsafe extern "system" fn SetIndexStatus<Identity: IMFASFIndexer_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbindexdescriptor: *const u8, cbindexdescriptor: u32, fgenerateindex: super::super::Foundation::BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IMFASFIndexer_Impl::SetIndexStatus(this, core::mem::transmute_copy(&pbindexdescriptor), core::mem::transmute_copy(&cbindexdescriptor), core::mem::transmute_copy(&fgenerateindex)).into()
            }
        }
        unsafe extern "system" fn GetSeekPositionForValue<Identity: IMFASFIndexer_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pvarvalue: *const super::super::System::Com::StructuredStorage::PROPVARIANT, pindexidentifier: *const ASF_INDEX_IDENTIFIER, pcboffsetwithindata: *mut u64, phnsapproxtime: *mut i64, pdwpayloadnumberofstreamwithinpacket: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IMFASFIndexer_Impl::GetSeekPositionForValue(this, core::mem::transmute_copy(&pvarvalue), core::mem::transmute_copy(&pindexidentifier), core::mem::transmute_copy(&pcboffsetwithindata), core::mem::transmute_copy(&phnsapproxtime), core::mem::transmute_copy(&pdwpayloadnumberofstreamwithinpacket)).into()
            }
        }
        unsafe extern "system" fn GenerateIndexEntries<Identity: IMFASFIndexer_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, piasfpacketsample: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IMFASFIndexer_Impl::GenerateIndexEntries(this, core::mem::transmute_copy(&piasfpacketsample)).into()
            }
        }
        unsafe extern "system" fn CommitIndex<Identity: IMFASFIndexer_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, picontentinfo: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IMFASFIndexer_Impl::CommitIndex(this, core::mem::transmute_copy(&picontentinfo)).into()
            }
        }
        unsafe extern "system" fn GetIndexWriteSpace<Identity: IMFASFIndexer_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pcbindexwritespace: *mut u64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IMFASFIndexer_Impl::GetIndexWriteSpace(this) {
                    Ok(ok__) => {
                        pcbindexwritespace.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetCompletedIndex<Identity: IMFASFIndexer_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, piindexbuffer: *mut core::ffi::c_void, cboffsetwithinindex: u64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IMFASFIndexer_Impl::GetCompletedIndex(this, core::mem::transmute_copy(&piindexbuffer), core::mem::transmute_copy(&cboffsetwithinindex)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            SetFlags: SetFlags::<Identity, OFFSET>,
            GetFlags: GetFlags::<Identity, OFFSET>,
            Initialize: Initialize::<Identity, OFFSET>,
            GetIndexPosition: GetIndexPosition::<Identity, OFFSET>,
            SetIndexByteStreams: SetIndexByteStreams::<Identity, OFFSET>,
            GetIndexByteStreamCount: GetIndexByteStreamCount::<Identity, OFFSET>,
            GetIndexStatus: GetIndexStatus::<Identity, OFFSET>,
            SetIndexStatus: SetIndexStatus::<Identity, OFFSET>,
            GetSeekPositionForValue: GetSeekPositionForValue::<Identity, OFFSET>,
            GenerateIndexEntries: GenerateIndexEntries::<Identity, OFFSET>,
            CommitIndex: CommitIndex::<Identity, OFFSET>,
            GetIndexWriteSpace: GetIndexWriteSpace::<Identity, OFFSET>,
            GetCompletedIndex: GetCompletedIndex::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IMFASFIndexer as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Variant"))]
impl windows_core::RuntimeName for IMFASFIndexer {}
windows_core::imp::define_interface!(IMFASFMultiplexer, IMFASFMultiplexer_Vtbl, 0x57bdd80a_9b38_4838_b737_c58f670d7d4f);
windows_core::imp::interface_hierarchy!(IMFASFMultiplexer, windows_core::IUnknown);
impl IMFASFMultiplexer {
    pub unsafe fn Initialize<P0>(&self, picontentinfo: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IMFASFContentInfo>,
    {
        unsafe { (windows_core::Interface::vtable(self).Initialize)(windows_core::Interface::as_raw(self), picontentinfo.param().abi()).ok() }
    }
    pub unsafe fn SetFlags(&self, dwflags: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetFlags)(windows_core::Interface::as_raw(self), dwflags).ok() }
    }
    pub unsafe fn GetFlags(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetFlags)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn ProcessSample<P1>(&self, wstreamnumber: u16, pisample: P1, hnstimestampadjust: i64) -> windows_core::Result<()>
    where
        P1: windows_core::Param<IMFSample>,
    {
        unsafe { (windows_core::Interface::vtable(self).ProcessSample)(windows_core::Interface::as_raw(self), wstreamnumber, pisample.param().abi(), hnstimestampadjust).ok() }
    }
    pub unsafe fn GetNextPacket(&self, pdwstatusflags: *mut u32, ppipacket: *mut Option<IMFSample>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetNextPacket)(windows_core::Interface::as_raw(self), pdwstatusflags as _, core::mem::transmute(ppipacket)).ok() }
    }
    pub unsafe fn Flush(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Flush)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn End<P0>(&self, picontentinfo: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IMFASFContentInfo>,
    {
        unsafe { (windows_core::Interface::vtable(self).End)(windows_core::Interface::as_raw(self), picontentinfo.param().abi()).ok() }
    }
    pub unsafe fn GetStatistics(&self, wstreamnumber: u16) -> windows_core::Result<ASF_MUX_STATISTICS> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetStatistics)(windows_core::Interface::as_raw(self), wstreamnumber, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetSyncTolerance(&self, mssynctolerance: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetSyncTolerance)(windows_core::Interface::as_raw(self), mssynctolerance).ok() }
    }
}
#[repr(C)]
pub struct IMFASFMultiplexer_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub Initialize: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetFlags: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetFlags: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub ProcessSample: unsafe extern "system" fn(*mut core::ffi::c_void, u16, *mut core::ffi::c_void, i64) -> windows_core::HRESULT,
    pub GetNextPacket: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub Flush: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub End: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetStatistics: unsafe extern "system" fn(*mut core::ffi::c_void, u16, *mut ASF_MUX_STATISTICS) -> windows_core::HRESULT,
    pub SetSyncTolerance: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
}
pub trait IMFASFMultiplexer_Impl: windows_core::IUnknownImpl {
    fn Initialize(&self, picontentinfo: windows_core::Ref<'_, IMFASFContentInfo>) -> windows_core::Result<()>;
    fn SetFlags(&self, dwflags: u32) -> windows_core::Result<()>;
    fn GetFlags(&self) -> windows_core::Result<u32>;
    fn ProcessSample(&self, wstreamnumber: u16, pisample: windows_core::Ref<'_, IMFSample>, hnstimestampadjust: i64) -> windows_core::Result<()>;
    fn GetNextPacket(&self, pdwstatusflags: *mut u32, ppipacket: windows_core::OutRef<'_, IMFSample>) -> windows_core::Result<()>;
    fn Flush(&self) -> windows_core::Result<()>;
    fn End(&self, picontentinfo: windows_core::Ref<'_, IMFASFContentInfo>) -> windows_core::Result<()>;
    fn GetStatistics(&self, wstreamnumber: u16) -> windows_core::Result<ASF_MUX_STATISTICS>;
    fn SetSyncTolerance(&self, mssynctolerance: u32) -> windows_core::Result<()>;
}
impl IMFASFMultiplexer_Vtbl {
    pub const fn new<Identity: IMFASFMultiplexer_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn Initialize<Identity: IMFASFMultiplexer_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, picontentinfo: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IMFASFMultiplexer_Impl::Initialize(this, core::mem::transmute_copy(&picontentinfo)).into()
            }
        }
        unsafe extern "system" fn SetFlags<Identity: IMFASFMultiplexer_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwflags: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IMFASFMultiplexer_Impl::SetFlags(this, core::mem::transmute_copy(&dwflags)).into()
            }
        }
        unsafe extern "system" fn GetFlags<Identity: IMFASFMultiplexer_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pdwflags: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IMFASFMultiplexer_Impl::GetFlags(this) {
                    Ok(ok__) => {
                        pdwflags.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn ProcessSample<Identity: IMFASFMultiplexer_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, wstreamnumber: u16, pisample: *mut core::ffi::c_void, hnstimestampadjust: i64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IMFASFMultiplexer_Impl::ProcessSample(this, core::mem::transmute_copy(&wstreamnumber), core::mem::transmute_copy(&pisample), core::mem::transmute_copy(&hnstimestampadjust)).into()
            }
        }
        unsafe extern "system" fn GetNextPacket<Identity: IMFASFMultiplexer_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pdwstatusflags: *mut u32, ppipacket: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IMFASFMultiplexer_Impl::GetNextPacket(this, core::mem::transmute_copy(&pdwstatusflags), core::mem::transmute_copy(&ppipacket)).into()
            }
        }
        unsafe extern "system" fn Flush<Identity: IMFASFMultiplexer_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IMFASFMultiplexer_Impl::Flush(this).into()
            }
        }
        unsafe extern "system" fn End<Identity: IMFASFMultiplexer_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, picontentinfo: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IMFASFMultiplexer_Impl::End(this, core::mem::transmute_copy(&picontentinfo)).into()
            }
        }
        unsafe extern "system" fn GetStatistics<Identity: IMFASFMultiplexer_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, wstreamnumber: u16, pmuxstats: *mut ASF_MUX_STATISTICS) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IMFASFMultiplexer_Impl::GetStatistics(this, core::mem::transmute_copy(&wstreamnumber)) {
                    Ok(ok__) => {
                        pmuxstats.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetSyncTolerance<Identity: IMFASFMultiplexer_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, mssynctolerance: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IMFASFMultiplexer_Impl::SetSyncTolerance(this, core::mem::transmute_copy(&mssynctolerance)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            Initialize: Initialize::<Identity, OFFSET>,
            SetFlags: SetFlags::<Identity, OFFSET>,
            GetFlags: GetFlags::<Identity, OFFSET>,
            ProcessSample: ProcessSample::<Identity, OFFSET>,
            GetNextPacket: GetNextPacket::<Identity, OFFSET>,
            Flush: Flush::<Identity, OFFSET>,
            End: End::<Identity, OFFSET>,
            GetStatistics: GetStatistics::<Identity, OFFSET>,
            SetSyncTolerance: SetSyncTolerance::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IMFASFMultiplexer as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IMFASFMultiplexer {}
windows_core::imp::define_interface!(IMFASFMutualExclusion, IMFASFMutualExclusion_Vtbl, 0x12558291_e399_11d5_bc2a_00b0d0f3f4ab);
windows_core::imp::interface_hierarchy!(IMFASFMutualExclusion, windows_core::IUnknown);
impl IMFASFMutualExclusion {
    pub unsafe fn GetType(&self) -> windows_core::Result<windows_core::GUID> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetType)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetType(&self, guidtype: *const windows_core::GUID) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetType)(windows_core::Interface::as_raw(self), guidtype).ok() }
    }
    pub unsafe fn GetRecordCount(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRecordCount)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetStreamsForRecord(&self, dwrecordnumber: u32, pwstreamnumarray: *mut u16, pcstreams: *mut u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetStreamsForRecord)(windows_core::Interface::as_raw(self), dwrecordnumber, pwstreamnumarray as _, pcstreams as _).ok() }
    }
    pub unsafe fn AddStreamForRecord(&self, dwrecordnumber: u32, wstreamnumber: u16) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).AddStreamForRecord)(windows_core::Interface::as_raw(self), dwrecordnumber, wstreamnumber).ok() }
    }
    pub unsafe fn RemoveStreamFromRecord(&self, dwrecordnumber: u32, wstreamnumber: u16) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).RemoveStreamFromRecord)(windows_core::Interface::as_raw(self), dwrecordnumber, wstreamnumber).ok() }
    }
    pub unsafe fn RemoveRecord(&self, dwrecordnumber: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).RemoveRecord)(windows_core::Interface::as_raw(self), dwrecordnumber).ok() }
    }
    pub unsafe fn AddRecord(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).AddRecord)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn Clone(&self) -> windows_core::Result<IMFASFMutualExclusion> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).Clone)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
}
#[repr(C)]
pub struct IMFASFMutualExclusion_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetType: unsafe extern "system" fn(*mut core::ffi::c_void, *mut windows_core::GUID) -> windows_core::HRESULT,
    pub SetType: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID) -> windows_core::HRESULT,
    pub GetRecordCount: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetStreamsForRecord: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut u16, *mut u32) -> windows_core::HRESULT,
    pub AddStreamForRecord: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u16) -> windows_core::HRESULT,
    pub RemoveStreamFromRecord: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u16) -> windows_core::HRESULT,
    pub RemoveRecord: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub AddRecord: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub Clone: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
pub trait IMFASFMutualExclusion_Impl: windows_core::IUnknownImpl {
    fn GetType(&self) -> windows_core::Result<windows_core::GUID>;
    fn SetType(&self, guidtype: *const windows_core::GUID) -> windows_core::Result<()>;
    fn GetRecordCount(&self) -> windows_core::Result<u32>;
    fn GetStreamsForRecord(&self, dwrecordnumber: u32, pwstreamnumarray: *mut u16, pcstreams: *mut u32) -> windows_core::Result<()>;
    fn AddStreamForRecord(&self, dwrecordnumber: u32, wstreamnumber: u16) -> windows_core::Result<()>;
    fn RemoveStreamFromRecord(&self, dwrecordnumber: u32, wstreamnumber: u16) -> windows_core::Result<()>;
    fn RemoveRecord(&self, dwrecordnumber: u32) -> windows_core::Result<()>;
    fn AddRecord(&self) -> windows_core::Result<u32>;
    fn Clone(&self) -> windows_core::Result<IMFASFMutualExclusion>;
}
impl IMFASFMutualExclusion_Vtbl {
    pub const fn new<Identity: IMFASFMutualExclusion_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetType<Identity: IMFASFMutualExclusion_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pguidtype: *mut windows_core::GUID) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IMFASFMutualExclusion_Impl::GetType(this) {
                    Ok(ok__) => {
                        pguidtype.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetType<Identity: IMFASFMutualExclusion_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, guidtype: *const windows_core::GUID) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IMFASFMutualExclusion_Impl::SetType(this, core::mem::transmute_copy(&guidtype)).into()
            }
        }
        unsafe extern "system" fn GetRecordCount<Identity: IMFASFMutualExclusion_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pdwrecordcount: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IMFASFMutualExclusion_Impl::GetRecordCount(this) {
                    Ok(ok__) => {
                        pdwrecordcount.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetStreamsForRecord<Identity: IMFASFMutualExclusion_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwrecordnumber: u32, pwstreamnumarray: *mut u16, pcstreams: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IMFASFMutualExclusion_Impl::GetStreamsForRecord(this, core::mem::transmute_copy(&dwrecordnumber), core::mem::transmute_copy(&pwstreamnumarray), core::mem::transmute_copy(&pcstreams)).into()
            }
        }
        unsafe extern "system" fn AddStreamForRecord<Identity: IMFASFMutualExclusion_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwrecordnumber: u32, wstreamnumber: u16) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IMFASFMutualExclusion_Impl::AddStreamForRecord(this, core::mem::transmute_copy(&dwrecordnumber), core::mem::transmute_copy(&wstreamnumber)).into()
            }
        }
        unsafe extern "system" fn RemoveStreamFromRecord<Identity: IMFASFMutualExclusion_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwrecordnumber: u32, wstreamnumber: u16) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IMFASFMutualExclusion_Impl::RemoveStreamFromRecord(this, core::mem::transmute_copy(&dwrecordnumber), core::mem::transmute_copy(&wstreamnumber)).into()
            }
        }
        unsafe extern "system" fn RemoveRecord<Identity: IMFASFMutualExclusion_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwrecordnumber: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IMFASFMutualExclusion_Impl::RemoveRecord(this, core::mem::transmute_copy(&dwrecordnumber)).into()
            }
        }
        unsafe extern "system" fn AddRecord<Identity: IMFASFMutualExclusion_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pdwrecordnumber: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IMFASFMutualExclusion_Impl::AddRecord(this) {
                    Ok(ok__) => {
                        pdwrecordnumber.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn Clone<Identity: IMFASFMutualExclusion_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppimutex: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IMFASFMutualExclusion_Impl::Clone(this) {
                    Ok(ok__) => {
                        ppimutex.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetType: GetType::<Identity, OFFSET>,
            SetType: SetType::<Identity, OFFSET>,
            GetRecordCount: GetRecordCount::<Identity, OFFSET>,
            GetStreamsForRecord: GetStreamsForRecord::<Identity, OFFSET>,
            AddStreamForRecord: AddStreamForRecord::<Identity, OFFSET>,
            RemoveStreamFromRecord: RemoveStreamFromRecord::<Identity, OFFSET>,
            RemoveRecord: RemoveRecord::<Identity, OFFSET>,
            AddRecord: AddRecord::<Identity, OFFSET>,
            Clone: Clone::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IMFASFMutualExclusion as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IMFASFMutualExclusion {}
windows_core::imp::define_interface!(IMFASFProfile, IMFASFProfile_Vtbl, 0xd267bf6a_028b_4e0d_903d_43f0ef82d0d4);
i