#include "YODA/Utils/MathUtils.h"
#include "YODA/Utils/StringUtils.h"
#include <cmath>
#include <iostream>
#include <sstream>
#include <stdexcept>
#include <string>

using namespace std;
using namespace YODA;


class CustomType {
public:
    int value;

    friend std::istream& operator>>(std::istream& is, CustomType& obj) {
        int temp;
        if (!(is >> temp)) {
            throw std::runtime_error("Invalid input for CustomType!");
        }
        obj.value = temp;
        return is;
    }
};

int main() {


  double val = Utils::lexical_cast<double>("1.23");
  if (!fuzzyEquals(val, 1.23))  return EXIT_FAILURE;

  bool fail = true;
  try {
    Utils::lexical_cast<CustomType>("not_a_number");
  }
  catch (const Utils::bad_lexical_cast&) {
    fail = false;
  }
  if (fail)  return EXIT_FAILURE;

  if ( !isnan(Utils::toDbl("not_a_number")) )  return EXIT_FAILURE;

  return EXIT_SUCCESS;
}
