/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.navigator.resources;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ltk.core.refactoring.PerformRefactoringOperation;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringContribution;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.resource.MoveResourcesDescriptor;
import org.eclipse.ltk.ui.refactoring.RefactoringUI;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CopyFilesAndFoldersOperation;
import org.eclipse.ui.actions.MoveFilesAndFoldersOperation;
import org.eclipse.ui.actions.ReadOnlyStateChecker;
import org.eclipse.ui.ide.dialogs.ImportTypeDialog;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.navigator.Policy;
import org.eclipse.ui.internal.navigator.resources.plugin.WorkbenchNavigatorMessages;
import org.eclipse.ui.internal.navigator.resources.plugin.WorkbenchNavigatorPlugin;
import org.eclipse.ui.navigator.CommonDropAdapter;
import org.eclipse.ui.navigator.CommonDropAdapterAssistant;
import org.eclipse.ui.part.ResourceTransfer;

public class ResourceDropAdapterAssistant
extends CommonDropAdapterAssistant {
    private static final IResource[] NO_RESOURCES = new IResource[0];
    private RefactoringStatus refactoringStatus;
    private IStatus returnStatus;

    public boolean isSupportedType(TransferData aTransferType) {
        return super.isSupportedType(aTransferType) || FileTransfer.getInstance().isSupportedType(aTransferType);
    }

    public IStatus validateDrop(Object target, int aDropOperation, TransferData transferType) {
        if (!(target instanceof IResource)) {
            return WorkbenchNavigatorPlugin.createStatus(1, 0, WorkbenchNavigatorMessages.DropAdapter_targetMustBeResource, null);
        }
        IResource resource = (IResource)target;
        if (!resource.isAccessible()) {
            return WorkbenchNavigatorPlugin.createErrorStatus(0, WorkbenchNavigatorMessages.DropAdapter_canNotDropIntoClosedProject, null);
        }
        IContainer destination = this.getActualTarget(resource);
        if (destination.getType() == 8) {
            return WorkbenchNavigatorPlugin.createErrorStatus(0, WorkbenchNavigatorMessages.DropAdapter_resourcesCanNotBeSiblings, null);
        }
        String message = null;
        if (LocalSelectionTransfer.getTransfer().isSupportedType(transferType)) {
            IResource[] selectedResources = this.getSelectedResources();
            boolean bProjectDrop = false;
            IResource[] iResourceArray = selectedResources;
            int n = selectedResources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource res = iResourceArray[n2];
                if (res instanceof IProject) {
                    bProjectDrop = true;
                    break;
                }
                ++n2;
            }
            if (bProjectDrop) {
                message = WorkbenchNavigatorMessages.DropAdapter_canNotDropProjectIntoProject;
            } else if (selectedResources.length == 0) {
                message = WorkbenchNavigatorMessages.DropAdapter_dropOperationErrorOther;
            } else {
                CopyFilesAndFoldersOperation operation;
                if (aDropOperation == 1) {
                    if (Policy.DEBUG_DND) {
                        System.out.println("ResourceDropAdapterAssistant.validateDrop validating COPY.");
                    }
                    operation = new CopyFilesAndFoldersOperation(this.getShell());
                } else {
                    if (Policy.DEBUG_DND) {
                        System.out.println("ResourceDropAdapterAssistant.validateDrop validating MOVE.");
                    }
                    operation = new MoveFilesAndFoldersOperation(this.getShell());
                }
                if (operation.validateDestination(destination, selectedResources) != null) {
                    operation.setVirtualFolders(true);
                    message = operation.validateDestination(destination, selectedResources);
                }
            }
        } else if (FileTransfer.getInstance().isSupportedType(transferType)) {
            String[] sourceNames = (String[])FileTransfer.getInstance().nativeToJava(transferType);
            if (sourceNames == null) {
                sourceNames = new String[]{};
            }
            CopyFilesAndFoldersOperation copyOperation = new CopyFilesAndFoldersOperation(this.getShell());
            message = copyOperation.validateImportDestination(destination, sourceNames);
        }
        if (message != null) {
            return WorkbenchNavigatorPlugin.createErrorStatus(0, message, null);
        }
        return Status.OK_STATUS;
    }

    public IStatus handleDrop(CommonDropAdapter aDropAdapter, DropTargetEvent aDropTargetEvent, Object aTarget) {
        if (Policy.DEBUG_DND) {
            System.out.println("ResourceDropAdapterAssistant.handleDrop (begin)");
        }
        if (aTarget == null || aDropTargetEvent.data == null) {
            return Status.CANCEL_STATUS;
        }
        IStatus status = null;
        IResource[] resources = null;
        TransferData currentTransfer = aDropAdapter.getCurrentTransfer();
        if (LocalSelectionTransfer.getTransfer().isSupportedType(currentTransfer)) {
            resources = this.getSelectedResources();
        } else if (ResourceTransfer.getInstance().isSupportedType(currentTransfer)) {
            resources = (IResource[])aDropTargetEvent.data;
        }
        if (FileTransfer.getInstance().isSupportedType(currentTransfer)) {
            status = this.performFileDrop(aDropAdapter, aDropTargetEvent.data);
        } else if (resources != null && resources.length > 0) {
            if (aDropAdapter.getCurrentOperation() == 1 || aDropAdapter.getCurrentOperation() == 4) {
                if (Policy.DEBUG_DND) {
                    System.out.println("ResourceDropAdapterAssistant.handleDrop executing COPY.");
                }
                status = this.performResourceCopy(aDropAdapter, this.getShell(), resources);
            } else {
                if (Policy.DEBUG_DND) {
                    System.out.println("ResourceDropAdapterAssistant.handleDrop executing MOVE.");
                }
                status = this.performResourceMove(aDropAdapter, resources);
            }
        }
        this.openError(status);
        IContainer target = this.getActualTarget((IResource)aTarget);
        if (target != null && target.isAccessible()) {
            try {
                target.refreshLocal(1, null);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return status;
    }

    public IStatus validatePluginTransferDrop(IStructuredSelection aDragSelection, Object aDropTarget) {
        if (!(aDropTarget instanceof IResource)) {
            return WorkbenchNavigatorPlugin.createStatus(1, 0, WorkbenchNavigatorMessages.DropAdapter_targetMustBeResource, null);
        }
        IResource resource = (IResource)aDropTarget;
        if (!resource.isAccessible()) {
            return WorkbenchNavigatorPlugin.createErrorStatus(0, WorkbenchNavigatorMessages.DropAdapter_canNotDropIntoClosedProject, null);
        }
        IContainer destination = this.getActualTarget(resource);
        if (destination.getType() == 8) {
            return WorkbenchNavigatorPlugin.createErrorStatus(0, WorkbenchNavigatorMessages.DropAdapter_resourcesCanNotBeSiblings, null);
        }
        IResource[] selectedResources = this.getSelectedResources(aDragSelection);
        String message = null;
        if (selectedResources.length == 0) {
            message = WorkbenchNavigatorMessages.DropAdapter_dropOperationErrorOther;
        } else {
            MoveFilesAndFoldersOperation operation = new MoveFilesAndFoldersOperation(this.getShell());
            message = operation.validateDestination(destination, selectedResources);
        }
        if (message != null) {
            return WorkbenchNavigatorPlugin.createErrorStatus(0, message, null);
        }
        return Status.OK_STATUS;
    }

    public IStatus handlePluginTransferDrop(IStructuredSelection aDragSelection, Object aDropTarget) {
        IContainer target = this.getActualTarget((IResource)aDropTarget);
        IResource[] resources = this.getSelectedResources(aDragSelection);
        MoveFilesAndFoldersOperation operation = new MoveFilesAndFoldersOperation(this.getShell());
        operation.copyResources(resources, target);
        if (target != null && target.isAccessible()) {
            try {
                target.refreshLocal(1, null);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return Status.OK_STATUS;
    }

    private IContainer getActualTarget(IResource mouseTarget) {
        if (mouseTarget.getType() == 1) {
            return mouseTarget.getParent();
        }
        return (IContainer)mouseTarget;
    }

    private IResource[] getSelectedResources() {
        ISelection selection = LocalSelectionTransfer.getTransfer().getSelection();
        if (selection instanceof IStructuredSelection) {
            return this.getSelectedResources((IStructuredSelection)selection);
        }
        return NO_RESOURCES;
    }

    private IResource[] getSelectedResources(IStructuredSelection selection) {
        ArrayList<IResource> selectedResources = new ArrayList<IResource>();
        for (Object o : selection) {
            IResource resource = (IResource)Adapters.adapt(o, IResource.class);
            if (resource == null) continue;
            selectedResources.add(resource);
        }
        return selectedResources.toArray(new IResource[selectedResources.size()]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IStatus performResourceCopy(CommonDropAdapter dropAdapter, Shell shell, IResource[] sources) {
        MultiStatus problems = new MultiStatus("org.eclipse.ui", 1, WorkbenchNavigatorMessages.DropAdapter_problemsMoving, null);
        this.mergeStatus(problems, this.validateTarget(dropAdapter.getCurrentTarget(), dropAdapter.getCurrentTransfer(), dropAdapter.getCurrentOperation()));
        IContainer target = this.getActualTarget((IResource)dropAdapter.getCurrentTarget());
        boolean shouldLinkAutomatically = false;
        if (target.isVirtual()) {
            shouldLinkAutomatically = true;
            IResource[] iResourceArray = sources;
            int n = sources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource source = iResourceArray[n2];
                if (source.getType() != 1 && source.getLocation() != null) {
                    shouldLinkAutomatically = false;
                    break;
                }
                ++n2;
            }
        }
        CopyFilesAndFoldersOperation operation = new CopyFilesAndFoldersOperation(shell);
        if (shouldLinkAutomatically) {
            operation.setCreateLinks(true);
            operation.copyResources(sources, target);
            return problems;
        } else {
            boolean allSourceAreLinksOrVirtualFolders = true;
            IResource[] iResourceArray = sources;
            int n = sources.length;
            int n3 = 0;
            while (n3 < n) {
                IResource source = iResourceArray[n3];
                if (!source.isVirtual() && !source.isLinked()) {
                    allSourceAreLinksOrVirtualFolders = false;
                    break;
                }
                ++n3;
            }
            if (!allSourceAreLinksOrVirtualFolders) {
                IPreferenceStore store = IDEWorkbenchPlugin.getDefault().getPreferenceStore();
                String dndPreference = store.getString(target.isVirtual() ? "IMPORT_FILES_AND_FOLDERS_VIRTUAL_FOLDER_MODE" : "IMPORT_FILES_AND_FOLDERS_MODE");
                if (dndPreference.equals("prompt")) {
                    ImportTypeDialog dialog = new ImportTypeDialog(this.getShell(), dropAdapter.getCurrentOperation(), sources, target);
                    dialog.setResource((IResource)target);
                    if (dialog.open() != 0) return problems;
                    if (dialog.getSelection() == 2) {
                        operation.setVirtualFolders(true);
                    }
                    if (dialog.getSelection() == 4) {
                        operation.setCreateLinks(true);
                    }
                    if (dialog.getVariable() != null) {
                        operation.setRelativeVariable(dialog.getVariable());
                    }
                    operation.copyResources(sources, target);
                    return problems;
                } else {
                    operation.copyResources(sources, target);
                }
                return problems;
            } else {
                operation.copyResources(sources, target);
            }
        }
        return problems;
    }

    private IStatus performResourceMove(CommonDropAdapter dropAdapter, IResource[] sources) {
        MultiStatus problems = new MultiStatus("org.eclipse.ui", 1, WorkbenchNavigatorMessages.DropAdapter_problemsMoving, null);
        this.mergeStatus(problems, this.validateTarget(dropAdapter.getCurrentTarget(), dropAdapter.getCurrentTransfer(), dropAdapter.getCurrentOperation()));
        IContainer target = this.getActualTarget((IResource)dropAdapter.getCurrentTarget());
        boolean shouldLinkAutomatically = false;
        if (target.isVirtual()) {
            shouldLinkAutomatically = true;
            IResource[] iResourceArray = sources;
            int n = sources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource source = iResourceArray[n2];
                if (source.isVirtual() || source.isLinked()) {
                    shouldLinkAutomatically = false;
                    break;
                }
                ++n2;
            }
        }
        if (shouldLinkAutomatically) {
            CopyFilesAndFoldersOperation operation = new CopyFilesAndFoldersOperation(this.getShell());
            operation.setCreateLinks(true);
            operation.copyResources(sources, target);
        } else {
            ReadOnlyStateChecker checker = new ReadOnlyStateChecker(this.getShell(), WorkbenchNavigatorMessages.MoveResourceAction_title, WorkbenchNavigatorMessages.MoveResourceAction_checkMoveMessage);
            sources = checker.checkReadOnlyResources(sources);
            try {
                Dialog dialog;
                int result;
                RefactoringContribution contribution = RefactoringCore.getRefactoringContribution((String)"org.eclipse.ltk.core.refactoring.move.resources");
                MoveResourcesDescriptor descriptor = (MoveResourcesDescriptor)contribution.createDescriptor();
                descriptor.setResourcesToMove(sources);
                descriptor.setDestination(target);
                this.refactoringStatus = new RefactoringStatus();
                Refactoring refactoring = descriptor.createRefactoring(this.refactoringStatus);
                this.returnStatus = null;
                IRunnableWithProgress checkOp = monitor -> {
                    try {
                        this.refactoringStatus = refactoring.checkAllConditions(monitor);
                    }
                    catch (CoreException ex) {
                        this.returnStatus = WorkbenchNavigatorPlugin.createErrorStatus(0, ex.getLocalizedMessage(), ex);
                    }
                };
                try {
                    PlatformUI.getWorkbench().getProgressService().run(false, false, checkOp);
                }
                catch (InterruptedException e) {
                    return Status.CANCEL_STATUS;
                }
                catch (InvocationTargetException e) {
                    return WorkbenchNavigatorPlugin.createErrorStatus(0, e.getLocalizedMessage(), e);
                }
                if (this.returnStatus != null) {
                    return this.returnStatus;
                }
                if (this.refactoringStatus.hasEntries() && (result = (dialog = RefactoringUI.createLightWeightStatusDialog((RefactoringStatus)this.refactoringStatus, (Shell)this.getShell(), (String)WorkbenchNavigatorMessages.MoveResourceAction_title)).open()) != 0) {
                    return Status.CANCEL_STATUS;
                }
                PerformRefactoringOperation op = new PerformRefactoringOperation(refactoring, 6);
                IWorkspaceRunnable r = arg_0 -> ((PerformRefactoringOperation)op).run(arg_0);
                this.returnStatus = null;
                IRunnableWithProgress refactorOp = monitor -> {
                    try {
                        ResourcesPlugin.getWorkspace().run(r, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), 1, monitor);
                    }
                    catch (CoreException ex) {
                        this.returnStatus = WorkbenchNavigatorPlugin.createErrorStatus(0, ex.getLocalizedMessage(), ex);
                    }
                };
                try {
                    PlatformUI.getWorkbench().getProgressService().run(false, false, refactorOp);
                }
                catch (InterruptedException e) {
                    return Status.CANCEL_STATUS;
                }
                catch (InvocationTargetException e) {
                    return WorkbenchNavigatorPlugin.createErrorStatus(0, e.getLocalizedMessage(), e);
                }
                if (this.returnStatus != null) {
                    return this.returnStatus;
                }
            }
            catch (CoreException ex) {
                return WorkbenchNavigatorPlugin.createErrorStatus(0, ex.getLocalizedMessage(), ex);
            }
            catch (OperationCanceledException operationCanceledException) {
                // empty catch block
            }
        }
        return problems;
    }

    private IStatus performFileDrop(CommonDropAdapter anAdapter, Object data) {
        int currentOperation = anAdapter.getCurrentOperation();
        MultiStatus problems = new MultiStatus("org.eclipse.ui", 0, WorkbenchNavigatorMessages.DropAdapter_problemImporting, null);
        this.mergeStatus(problems, this.validateTarget(anAdapter.getCurrentTarget(), anAdapter.getCurrentTransfer(), currentOperation));
        IContainer target = this.getActualTarget((IResource)anAdapter.getCurrentTarget());
        String[] names = (String[])data;
        Display.getCurrent().asyncExec(() -> {
            this.getShell().forceActive();
            new CopyFilesAndFoldersOperation(this.getShell()).copyOrLinkFiles(names, target, currentOperation);
        });
        return problems;
    }

    private IStatus validateTarget(Object target, TransferData transferType, int dropOperation) {
        if (!(target instanceof IResource)) {
            return WorkbenchNavigatorPlugin.createInfoStatus(WorkbenchNavigatorMessages.DropAdapter_targetMustBeResource);
        }
        IResource resource = (IResource)target;
        if (!resource.isAccessible()) {
            return WorkbenchNavigatorPlugin.createErrorStatus(WorkbenchNavigatorMessages.DropAdapter_canNotDropIntoClosedProject);
        }
        IContainer destination = this.getActualTarget(resource);
        if (destination.getType() == 8) {
            return WorkbenchNavigatorPlugin.createErrorStatus(WorkbenchNavigatorMessages.DropAdapter_resourcesCanNotBeSiblings);
        }
        String message = null;
        if (LocalSelectionTransfer.getTransfer().isSupportedType(transferType)) {
            IResource[] selectedResources = this.getSelectedResources();
            if (selectedResources.length == 0) {
                message = WorkbenchNavigatorMessages.DropAdapter_dropOperationErrorOther;
            } else if (dropOperation == 1 || dropOperation == 4) {
                CopyFilesAndFoldersOperation operation = new CopyFilesAndFoldersOperation(this.getShell());
                if (operation.validateDestination(destination, selectedResources) != null) {
                    operation.setVirtualFolders(true);
                    message = operation.validateDestination(destination, selectedResources);
                }
            } else {
                MoveFilesAndFoldersOperation operation = new MoveFilesAndFoldersOperation(this.getShell());
                if (operation.validateDestination(destination, selectedResources) != null) {
                    operation.setVirtualFolders(true);
                    message = operation.validateDestination(destination, selectedResources);
                }
            }
        } else if (FileTransfer.getInstance().isSupportedType(transferType)) {
            String[] sourceNames = (String[])FileTransfer.getInstance().nativeToJava(transferType);
            if (sourceNames == null) {
                sourceNames = new String[]{};
            }
            CopyFilesAndFoldersOperation copyOperation = new CopyFilesAndFoldersOperation(this.getShell());
            message = copyOperation.validateImportDestination(destination, sourceNames);
        }
        if (message != null) {
            return WorkbenchNavigatorPlugin.createErrorStatus(message);
        }
        return Status.OK_STATUS;
    }

    private void mergeStatus(MultiStatus status, IStatus toMerge) {
        if (!toMerge.isOK()) {
            status.merge(toMerge);
        }
    }

    private void openError(IStatus status) {
        if (status == null) {
            return;
        }
        String genericTitle = WorkbenchNavigatorMessages.DropAdapter_title;
        int codes = 6;
        if (!status.isMultiStatus()) {
            ErrorDialog.openError((Shell)this.getShell(), (String)genericTitle, null, (IStatus)status, (int)codes);
            return;
        }
        IStatus[] children = status.getChildren();
        if (children.length == 1) {
            ErrorDialog.openError((Shell)this.getShell(), (String)status.getMessage(), null, (IStatus)children[0], (int)codes);
            return;
        }
        ErrorDialog.openError((Shell)this.getShell(), (String)genericTitle, null, (IStatus)status, (int)codes);
    }
}

