#pragma once

#include "DimFileRecovery.h"
#include "utils/DimFileTransTask.h"
#include <QObject>
#include <QTime>
//class DimFileTransTask;

class CheckTask;

class DimFileHandle : public DimFileRecovery
{
    Q_OBJECT

public:
    DimFileHandle();
    ~DimFileHandle();

    bool dimFileTrans(const QString &dimFilePath, const QString &imgFilePath) override;
    bool clearDimFileRestoreCfg(const QString &imgFilePath) override;
    bool hasInitBackDimFile() override;
    ErrorCode checkDimFileSpace(const QString &dimFilesPath) override;

private:
    bool getLoopDevice(QString &loopDevice);
    bool checkDimFiles(const QList<QJsonObject> &dimFileObjInfos);
    bool writeRestoreConf();
    bool getImgFileListOut(const QList<QJsonObject> &allPartJsonObjInfo, const QString &realImgFilePath, QStringList &imgFileListOut);
    void getTarFileListOut(const QList<QJsonObject> &allPartJsonObjInfo, QStringList &tarFileListOut);
    int updateTimeRemain(int progress);

private slots:
    void subTimeSlot();

private:
    DimFileTransTask *m_dimFileTransTask = nullptr;
    CheckTask *m_checkTask = nullptr;
    QStringList m_dimFiles = {};
    QStringList m_imgFiles = {};
    QString m_loopDevice = "";
    QString m_dimFilePath = "";
    QString m_imgFilePath = "";
    QTimer *m_subTimer = nullptr;
    int m_fileIndex = 0;
    int m_preProgress = 0;
    int m_totalTimeNeed = 0;
    int m_timeUsed = 0;
    int m_timeIndex = 0;
};
