#include "DeviceTest.h"
#include "utils/Process.h"
#include <QDir>
#include <QJsonObject>

TEST_F(DeviceTest, md5)
{
    QString dimPath = "/home/zxm/Downloads/boot.dim";
    QString dimMD5Path = dimPath + ".md5";
    QString out, err;
    QStringList args;
    bool ret = Process::spawnCmd("md5sum", {dimPath},out, err);
    qInfo()<<"out = "<<out<<", err = "<<err;
    EXPECT_TRUE(ret);
}

TEST_F(DeviceTest, getAllMediaMountPoint)
{
    QList<QString> mountPointList;
    bool retcode = Device::getAllMediaMountPoint(mountPointList);
    EXPECT_TRUE(retcode);
}

TEST_F(DeviceTest, findSuitablePartition)
{
    QDir dir("/media/zxm/ab   12");
    bool exist = dir.exists();
    bool b = dir.cd("/media/zxm/ab   12/a  b");
    QString name = dir.dirName();
    auto absName = dir.absolutePath();

    quint64 dimTotalBytes = 10 * 1024 * 1024 * 1024L;
    quint64 thresholdBytes = 500 * 1024 * 1024L;
    QString partitionPath;
    bool ret = Device::findSuitablePartition(dimTotalBytes, partitionPath, thresholdBytes);
    EXPECT_TRUE(ret);
}

TEST_F(DeviceTest, getDeviceInfoByLsblkOut)
{
 //   QString lsblkOut = Device::getLsblkByOutput();
//    DeviceInfoList allDeviceInfo = Device::getDeviceInfoByLsblkOut(lsblkOut);

    DeviceInfoList allDeviceInfo = Device::getAllDeviceByLsblk();
    EXPECT_TRUE(!allDeviceInfo.isEmpty());
}

TEST_F(DeviceTest, getSysDevicesByFstab)
{
    QString fstabFile = "/etc/fstab";
    QStringList allDevices = Device::getSysDevicesByFstab(fstabFile);
    EXPECT_TRUE(!allDevices.isEmpty());
}

TEST_F(DeviceTest, exportPartitionInfoByLsblk)
{
    QString path = "/home/zxm/Desktop/20221104-100548/partition_policy.json";
    QStringList devLList;
    QString err;
    bool ret = Device::exportPartitionInfoByLsblk(path, devLList, err);
    EXPECT_TRUE(ret);
}

TEST_F(DeviceTest, getMountPointByUUID)
{
    QString dev = "";
    // 自己先构造一个挂载点带空格的外接设备
    QString uuid = "1470645c-e372-499a-ae05-39a9e7ef4e2f";
    QString mountPoint;
    QString path = "/dev/sdc1";
    QString partUuid;
    Device::getUUIDByPartitionPath(path, partUuid);
    bool retcode = Device::getMountPointByUUID(uuid, mountPoint);
    EXPECT_TRUE(retcode);
}

TEST_F(DeviceTest, getVGNames)
{
    QStringList vgs;
    bool retCode = Device::getVGNames(vgs);
    EXPECT_TRUE(retCode);
}

TEST_F(DeviceTest, getPvDisplay)
{
 //   DeviceInfoList allDevices = Device::getAllDeviceByLsblk();
    QMap<QString, QString> pvVgMap;
    bool retCode = Device::getPvDisplay(pvVgMap);

    for (auto vgName : pvVgMap.values()) {
        QStringList lvPathList;
        Device::getLvPathsByVgName(vgName, lvPathList);
    }

    EXPECT_TRUE(retCode);
}

TEST_F(DeviceTest, deleteLVM)
{
    QStringList devices;
    devices<<"/dev/sdc";

    QMap<QString, QString> pvVgMaps;
    bool retCode = Device::getPvDisplay(pvVgMaps);
    EXPECT_TRUE(retCode);

    retCode = Device::deleteLVM(devices, pvVgMaps);
    EXPECT_TRUE(retCode);
}

TEST_F(DeviceTest, deleteVG)
{
    QStringList devices;
    devices<<"/dev/sdd";

    QMap<QString, QString> pvVgMaps;
    bool retCode = Device::getPvDisplay(pvVgMaps);
    EXPECT_TRUE(retCode);

    retCode = Device::deleteVG(devices, pvVgMaps);
    EXPECT_TRUE(retCode);
}

TEST_F(DeviceTest, renameVG)
{
    QStringList sysVgNames;
    bool retCode = Device::getVGNames(sysVgNames);
    EXPECT_TRUE(retCode);
    QMap<QString, QString> vgMap = {
            {"group1", "group1"},
            {"group2", "group2"},
            {"group10", "group10"}
    };
    retCode = Device::renameVG(sysVgNames, vgMap);
    EXPECT_TRUE(retCode);
}

TEST_F(DeviceTest, isMultiFullDiskEncrypt)
{
    QString fstabFile = "/etc/fstab";
    bool retCode = Device::isMultiFullDiskEncrypt(fstabFile);
    EXPECT_TRUE(retCode);
}

TEST_F(DeviceTest, getOrganizedDiskList)
{
    QList<GhostDiskInfo> m_diskInfoList;
    QString fstabPath = "/etc/fstab";
    Device::getGhostDiskInfo(fstabPath, m_diskInfoList);

    DeviceInfoList diskList;
    DeviceInfoList cryptDevList;
    DeviceInfoList noCryptDevList;
    DeviceInfoList partitionList;
    DeviceInfoList lvmList;
    DeviceInfoList fileCryptDevList;
    DeviceInfoList dmDevList;
    Device::getAllTypeDevice(diskList, cryptDevList, noCryptDevList, partitionList, lvmList,
                             fileCryptDevList, dmDevList);
    DeviceInfoList orgDevList = Device::getOrganizedDiskList(diskList, cryptDevList, noCryptDevList, partitionList,
                                                             lvmList, fileCryptDevList, dmDevList);

    bool retCode = !orgDevList.isEmpty();
    EXPECT_TRUE(retCode);
}

TEST_F(DeviceTest, getGhostDiskInfo)
{
    QString fstabFile = "/etc/fstab";
    QList<GhostDiskInfo> diskInfoList;
    Device::getGhostDiskInfo(fstabFile, diskInfoList);
    for (auto &disk : diskInfoList) {
        QJsonObject job = disk.marshal();
        GhostDiskInfo tmp;
        tmp.unmarshal(job);
    }

    bool retCode = !diskInfoList.isEmpty();
    EXPECT_TRUE(retCode);
}

TEST_F(DeviceTest, isFullInstall)
{
    QString fstabFile = "/etc/fstab";
    QStringList sysMountPointList;
    bool retCode = Device::isFullDiskInstall(fstabFile, sysMountPointList);
    EXPECT_TRUE(retCode);
}

TEST_F(DeviceTest, AppVersion)
{
    AppVersion v = AppVersion::getAppVersion();
    bool retCode = (v.major != -1);
    EXPECT_TRUE(retCode);
}
