#!/bin/bash
#
# 写这个脚本的原因：因为批量推送ts到翻译平台没有真正覆盖平台上的文件所以需要单独推送
#
# 功能：
# 1. 逐个推送所有语言的ts文件到翻译平台
# 2. 逐个拉取所有语言的ts文件到本地
#
# 使用方法：
# 1. 在项目根目录下执行 ./push_pull_ts.sh push
# 2. 在项目根目录下执行 ./push_pull_ts.sh pull
#

# 定义颜色变量
BLUE='\033[34m'
GREEN='\033[32m'
RED='\033[31m'
NC='\033[0m' # 重置颜色

info() {
    echo ""
    echo -e "${BLUE}$1${NC}"
    echo ""
}

warning() {
    echo ""
    echo -e "${RED}$1${NC}"
    echo ""
}

LANGUAGES="ady,af,af_ZA,ak,am_ET,am,ar_EG,ar,ast,az,bg,bn,bo,bqi,br,ca,cgg,cs,da,\
de_CH,de_DE,de,el_GR,el,en_AU,en_GB,en_NO,en_US,eo,es,et,eu,fa,fil,fi,fr,gl_ES,gl,\
he,hi_IN,hr,hu,hy,id_ID,id,it,ja,kab,ka,kk,km_KH,kn_IN,ko,ku_IQ,ku,ky@Arab,ky,la,\
lo,lt,lv,ml,mn,mr,ms,nb,ne,nl,pam,pa,pl,ps,pt_BR,pt,qu,ro,ru,ru_UA,sc,si,sk,sl,sq,\
sr,sv_SE,sv,sw,ta,te,th,tr,tzm,ug,uk,ur,uz,vi,zh_CN,zh_HK,zh_TW,"

push_pull_ts() {
    local typeCmd=$1
    if [ "${typeCmd}" = "push" ] || [ "${typeCmd}" = "pull" ]; then
        local languages=${LANGUAGES}
        local currentIndex=1
        local total=$(echo -n "$LANGUAGES" | grep -o ',' | wc -l)
        while [ -n "${languages}" ]; do
            echo "languages is : ${languages}"
            local languageItem=${languages%%,*}
            languages=${languages#*,}
            local result=0
            tx ${typeCmd} -f -t -l ${languageItem} || result=$?
            if [ ${result} -eq 0 ]; then
                info "tx ${typeCmd} -f -t -l ${languageItem} ok currentIndex: ${currentIndex} total: ${total}"
            else
                warning "tx ${typeCmd} -f -t -l ${languageItem} failed currentIndex: ${currentIndex} total: ${total}"
            fi
            currentIndex=$(( currentIndex + 1 ))
        done
    fi
}

push_pull_ts $@