# 2024-07-30 Triage Log

There were some notable regressions this week. Some of them are being
addressed via follow-up PRs (such as the change to whitespace
diagnostic reporting), and some via reverts (such as the dead code
analysis that tried to flag pub structs without pub constructors). A
few regressions have not yet been addressed. See report for details.

Triage done by **@pnkfelix**.
Revision range: [9629b90b..7e3a9718](https://perf.rust-lang.org/?start=9629b90b3f7dd8f5626ec9d3b42556f39f09e214&end=7e3a971870f23c94f7aceb53b490fb37333150ff&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.3%  | [0.2%, 6.1%]   | 43    |
| Regressions ❌ <br /> (secondary)  | 1.9%  | [0.1%, 10.4%]  | 46    |
| Improvements ✅ <br /> (primary)   | -1.0% | [-3.9%, -0.2%] | 27    |
| Improvements ✅ <br /> (secondary) | -1.6% | [-6.8%, -0.2%] | 43    |
| All ❌✅ (primary)                 | 0.4%  | [-3.9%, 6.1%]  | 70    |


5 Regressions, 6 Improvements, 6 Mixed; 8 of them in rollups
65 artifact comparisons made in total

#### Regressions

Do not use global caches if opaque types can be defined [#126024](https://github.com/rust-lang/rust/pull/126024) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=d24930ceb473b7b361d108d573308e3529cb5ef7&end=2ccafed862f6906707a390caf180449dd64cad2e&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 3.4% | [1.6%, 5.5%] | 6     |
| Regressions ❌ <br /> (secondary)  | 3.1% | [0.4%, 5.4%] | 11    |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 3.4% | [1.6%, 5.5%] | 6     |

* This PR says it is fixing a soundness problem. (Its not clear to me if the wrong issue was linked; the linked one is an ICE that was not actually resolved.)
* All six of the regressions are to hyper: {check,debug,opt} x {incr-full, full}.
* we probably should just accept this cost

Rollup of 5 pull requests [#128169](https://github.com/rust-lang/rust/pull/128169) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=e7d66eac5e8e8f60370c98d186aee9fa0ebd7845&end=004e155c46a2083d4f73212cc47a6f7fb98fcbd1&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.9% | [0.2%, 3.0%] | 26    |
| Regressions ❌ <br /> (secondary)  | 0.5% | [0.3%, 2.2%] | 13    |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.9% | [0.2%, 3.0%] | 26    |

* the bulk of the regressions are to syn (i.e. 8 out of the 9 that are > 1%).
* this was due to a change in how diagnostics handle certain "whitespace" characters (PR #127528); there is a revert proposed in PR #128179, but there is also a PR to address the issue itself as a followup in PR #128200
* not marking as triaged until either PR #128179 or PR #128200 is landed.

Rollup of 7 pull requests [#128186](https://github.com/rust-lang/rust/pull/128186) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=54be9ad5eb47207d155904f6c912a9526133f75f&end=eb10639928a2781cf0a12440007fbcc1e3a6888f&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3% | [0.2%, 0.5%] | 11    |
| Regressions ❌ <br /> (secondary)  | -    | -            | 0     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.3% | [0.2%, 0.5%] | 11    |

* already marked as triaged

Rollup of 9 pull requests [#128253](https://github.com/rust-lang/rust/pull/128253) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=7c2012d0ec3aae89fefc40e5d6b317a0949cda36&end=8b6b8574f6f2fcc71ec500a52d7bf74fdaff0ed6&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.5% | [0.4%, 0.5%] | 3     |
| Regressions ❌ <br /> (secondary)  | -    | -            | 0     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.5% | [0.4%, 0.5%] | 3     |

* regressed incr-full for bitmaps-{check,opt} and typenum-check
* seems like noise from the graph over time; marking as triaged.


Document 0x10.checked_shl(BITS - 1) does not overflow [#128255](https://github.com/rust-lang/rust/pull/128255) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=a526d7ce45fd2284e0e7c7556ccba2425b9d25e5&end=ad3c5a330173a4a6446c1ed90c72a3f5f9106888&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.5% | [0.5%, 0.6%] | 4     |
| Regressions ❌ <br /> (secondary)  | 2.2% | [2.2%, 2.2%] | 1     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.5% | [0.5%, 0.6%] | 4     |

* noise, already marked as triaged

#### Improvements

Remove unnecessary impl sorting in queries and metadata [#120812](https://github.com/rust-lang/rust/pull/120812) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=92c6c03805408a1a261b98013304e9bbf59ee428&end=0f8534e79e4cfbda7421017047d1f5021235b0ac&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -1.2% | [-2.1%, -0.4%] | 2     |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.4%, -0.3%] | 2     |
| All ❌✅ (primary)                 | -1.2% | [-2.1%, -0.4%] | 2     |


rustdoc: clean up and fix ord violations in item sorting [#128146](https://github.com/rust-lang/rust/pull/128146) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=6106b05b27988f4b946d7af219a6db95fb4477a1&end=c1a6199e9d92bb785c17a6d7ffd8b8b552f79c10&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.7% | [-1.6%, -0.2%] | 4     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -0.7% | [-1.6%, -0.2%] | 4     |


Rollup of 6 pull requests [#128195](https://github.com/rust-lang/rust/pull/128195) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=eb10639928a2781cf0a12440007fbcc1e3a6888f&end=aa877bc71c8c8082122bee23d17c8669f30f275d&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.4% | [-0.5%, -0.4%] | 5     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -0.4% | [-0.5%, -0.4%] | 5     |

* (just noise I think)

Switch from `derivative` to `derive-where` [#127042](https://github.com/rust-lang/rust/pull/127042) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=7120fdac7a6e55a5e4b606256042890b36067052&end=2f26b2a99ab976c43d12cf57ef4a3a2c82ede286&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.2% | [-0.3%, -0.2%] | 16    |
| Improvements ✅ <br /> (secondary) | -0.5% | [-0.6%, -0.4%] | 8     |
| All ❌✅ (primary)                 | -0.2% | [-0.3%, -0.2%] | 16    |


Always set `result` during `finish()` in debug builders [#127946](https://github.com/rust-lang/rust/pull/127946) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=8b6b8574f6f2fcc71ec500a52d7bf74fdaff0ed6&end=a526d7ce45fd2284e0e7c7556ccba2425b9d25e5&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.5% | [-0.6%, -0.5%] | 6     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -0.5% | [-0.6%, -0.5%] | 6     |

* (just noise I think)

Rollup of 6 pull requests [#128313](https://github.com/rust-lang/rust/pull/128313) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=188ddf4d6a694fa263c2ff8be8f8eade659599d6&end=2cbbe8b8bb2be672b14cf741a2f0ec24a49f3f0b&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -1.0% | [-1.1%, -1.0%] | 2     |
| Improvements ✅ <br /> (secondary) | -0.9% | [-1.9%, -0.2%] | 10    |
| All ❌✅ (primary)                 | -1.0% | [-1.1%, -1.0%] | 2     |


#### Mixed

Try to fix ICE from re-interning an AllocId with different allocation contents [#127442](https://github.com/rust-lang/rust/pull/127442) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=ee0fd6caf770e8b3baa403b4da3ef0c7e274dc21&end=ae7b1c191695f351e69ef7ad32c0897048bba73e&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.8%  | [0.2%, 2.5%]   | 4     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.7% | [-1.4%, -0.3%] | 7     |
| All ❌✅ (primary)                 | -     | -              | 0     |

* the regressions are to secondary benchmarks and this is fixing a subtle ICE that arises from a race condition (and may actually represent a chance of miscompilation, maybe?)
* marked as triaged

Rollup of 8 pull requests [#128155](https://github.com/rust-lang/rust/pull/128155) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=c1a6199e9d92bb785c17a6d7ffd8b8b552f79c10&end=e7d66eac5e8e8f60370c98d186aee9fa0ebd7845&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.5%  | [0.2%, 0.8%]   | 6     |
| Regressions ❌ <br /> (secondary)  | 0.9%  | [0.7%, 1.0%]   | 7     |
| Improvements ✅ <br /> (primary)   | -0.5% | [-0.6%, -0.4%] | 4     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | 0.1%  | [-0.6%, 0.8%]  | 10    |

* regressions are to hyper and exa. Mostly in hyper check-full, check-incr-full, and debug-incr-full.
* bulk of time might be from spike in time spent in `mir_const_qualif` query ?
* not marking as triaged, (though it is, to be clear, a relatively minor regression).

Allow optimizing `u32::from::<char>`. [#124905](https://github.com/rust-lang/rust/pull/124905) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=ad3c5a330173a4a6446c1ed90c72a3f5f9106888&end=3942254d00bf95cd5920980f85ebea57a1e6ce2a&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2%  | [0.2%, 0.3%]   | 4     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.2% | [-0.2%, -0.2%] | 1     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | 0.1%  | [-0.2%, 0.3%]  | 5     |


* regressions are to image opt {full, incr-full}, cargo opt {full, incr-full}, and syn opt incr-unchanged
* It appears that its due to extra time spent in LLVM opt, especially lto optimize, which makes sense given that this is meant to be enabling LLVM to attempt more such optimizations?
* marked as triaged.

Rollup of 3 pull requests [#128301](https://github.com/rust-lang/rust/pull/128301) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=1b51d80027919563004918eaadfa0d890ac0eb93&end=78c857394ec8c01f06cb1df260c51178180a40e5&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 2.1%  | [2.1%, 2.1%]   | 1     |
| Improvements ✅ <br /> (primary)   | -0.2% | [-0.3%, -0.2%] | 2     |
| Improvements ✅ <br /> (secondary) | -1.6% | [-3.0%, -0.2%] | 2     |
| All ❌✅ (primary)                 | -0.2% | [-0.3%, -0.2%] | 2     |

* sole regression is to secondary benchmark coercions debug-full.
* seems like noise.
* marked as triaged

 Perform instsimplify before inline to eliminate some trivial calls  [#128265](https://github.com/rust-lang/rust/pull/128265) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=56c698c71130de6fe55ba703a161405b6145b90e&end=4db3d12e6f395babed53dee1d209a5c8699a5ae6&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.2%  | [0.2%, 2.6%]   | 4     |
| Regressions ❌ <br /> (secondary)  | 0.5%  | [0.5%, 0.5%]   | 1     |
| Improvements ✅ <br /> (primary)   | -0.5% | [-0.8%, -0.2%] | 12    |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.4%, -0.3%] | 2     |
| All ❌✅ (primary)                 | -0.0% | [-0.8%, 2.6%]  | 16    |

* main primary regressions are to ripgrep opt full and image opt-full
* these changes were anticipated during review, seems likely result of changes to inlining decisions
* marked as triaged

Rollup of 6 pull requests [#128360](https://github.com/rust-lang/rust/pull/128360) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=612a33f20b9b2c27380edbc4b26a01433ed114bc&end=368e2fd458a22d0cc133d0c254f2612ee999744f&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.6%  | [0.4%, 0.7%]   | 4     |
| Regressions ❌ <br /> (secondary)  | 4.4%  | [0.3%, 12.0%]  | 10    |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.3%, -0.3%] | 4     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | 0.1%  | [-0.3%, 0.7%]  | 8     |


* primary regressions are to doc-full for html5ever, stm32f4, libc, and typenum
* those are presumably due to PR [#126247](https://github.com/rust-lang/rust/issues/126247); pnkfelix thinks the above not worth further investigation
* however, Kobzol has pointed out that the secondary regressions are significant, and has identified the root cause as PR [#128104](https://github.com/rust-lang/rust/issues/128104)
* we are in any case planning to revert the changes to dead code analysis (see PR [#128404](https://github.com/rust-lang/rust/issues/128404)) which should address those regressions.
* marked as triaged.
