/* automatically generated by rust-bindgen 0.70.1 */

#[repr(transparent)]
#[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
#[cfg_attr(
    feature = "serde",
    derive(zerocopy::AsBytes, zerocopy::FromBytes, zerocopy::FromZeroes)
)]
pub struct __BindgenBitfieldUnit<Storage> {
    storage: Storage,
}
impl<Storage> __BindgenBitfieldUnit<Storage> {
    #[inline]
    pub const fn new(storage: Storage) -> Self {
        Self { storage }
    }
}
impl<Storage> __BindgenBitfieldUnit<Storage>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    #[inline]
    pub fn get_bit(&self, index: usize) -> bool {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = self.storage.as_ref()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        byte & mask == mask
    }
    #[inline]
    pub fn set_bit(&mut self, index: usize, val: bool) {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = &mut self.storage.as_mut()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        if val {
            *byte |= mask;
        } else {
            *byte &= !mask;
        }
    }
    #[inline]
    pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if self.get_bit(i + bit_offset) {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            self.set_bit(index + bit_offset, val_bit_is_set);
        }
    }
}
#[repr(transparent)]
#[derive(Default)]
#[cfg_attr(
    feature = "serde",
    derive(zerocopy::AsBytes, zerocopy::FromBytes, zerocopy::FromZeroes)
)]
pub struct __IncompleteArrayField<T>(::std::marker::PhantomData<T>, [T; 0]);
impl<T> __IncompleteArrayField<T> {
    #[inline]
    pub const fn new() -> Self {
        __IncompleteArrayField(::std::marker::PhantomData, [])
    }
    #[inline]
    pub fn as_ptr(&self) -> *const T {
        self as *const _ as *const T
    }
    #[inline]
    pub fn as_mut_ptr(&mut self) -> *mut T {
        self as *mut _ as *mut T
    }
    #[inline]
    pub unsafe fn as_slice(&self, len: usize) -> &[T] {
        ::std::slice::from_raw_parts(self.as_ptr(), len)
    }
    #[inline]
    pub unsafe fn as_mut_slice(&mut self, len: usize) -> &mut [T] {
        ::std::slice::from_raw_parts_mut(self.as_mut_ptr(), len)
    }
}
impl<T> ::std::fmt::Debug for __IncompleteArrayField<T> {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.write_str("__IncompleteArrayField")
    }
}
#[repr(C)]
pub struct __BindgenUnionField<T>(::std::marker::PhantomData<T>);
impl<T> __BindgenUnionField<T> {
    #[inline]
    pub const fn new() -> Self {
        __BindgenUnionField(::std::marker::PhantomData)
    }
    #[inline]
    pub unsafe fn as_ref(&self) -> &T {
        ::std::mem::transmute(self)
    }
    #[inline]
    pub unsafe fn as_mut(&mut self) -> &mut T {
        ::std::mem::transmute(self)
    }
}
impl<T> ::std::default::Default for __BindgenUnionField<T> {
    #[inline]
    fn default() -> Self {
        Self::new()
    }
}
impl<T> ::std::clone::Clone for __BindgenUnionField<T> {
    #[inline]
    fn clone(&self) -> Self {
        *self
    }
}
impl<T> ::std::marker::Copy for __BindgenUnionField<T> {}
impl<T> ::std::fmt::Debug for __BindgenUnionField<T> {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.write_str("__BindgenUnionField")
    }
}
impl<T> ::std::hash::Hash for __BindgenUnionField<T> {
    fn hash<H: ::std::hash::Hasher>(&self, _state: &mut H) {}
}
impl<T> ::std::cmp::PartialEq for __BindgenUnionField<T> {
    fn eq(&self, _other: &__BindgenUnionField<T>) -> bool {
        true
    }
}
impl<T> ::std::cmp::Eq for __BindgenUnionField<T> {}
pub const __BITS_PER_LONG: u32 = 64;
pub const __BITS_PER_LONG_LONG: u32 = 64;
pub const __FD_SETSIZE: u32 = 1024;
pub const _IOC_NRBITS: u32 = 8;
pub const _IOC_TYPEBITS: u32 = 8;
pub const _IOC_SIZEBITS: u32 = 14;
pub const _IOC_DIRBITS: u32 = 2;
pub const _IOC_NRMASK: u32 = 255;
pub const _IOC_TYPEMASK: u32 = 255;
pub const _IOC_SIZEMASK: u32 = 16383;
pub const _IOC_DIRMASK: u32 = 3;
pub const _IOC_NRSHIFT: u32 = 0;
pub const _IOC_TYPESHIFT: u32 = 8;
pub const _IOC_SIZESHIFT: u32 = 16;
pub const _IOC_DIRSHIFT: u32 = 30;
pub const _IOC_NONE: u32 = 0;
pub const _IOC_WRITE: u32 = 1;
pub const _IOC_READ: u32 = 2;
pub const IOC_IN: u32 = 1073741824;
pub const IOC_OUT: u32 = 2147483648;
pub const IOC_INOUT: u32 = 3221225472;
pub const IOCSIZE_MASK: u32 = 1073676288;
pub const IOCSIZE_SHIFT: u32 = 16;
pub const KVM_PIO_PAGE_OFFSET: u32 = 1;
pub const KVM_COALESCED_MMIO_PAGE_OFFSET: u32 = 2;
pub const KVM_DIRTY_LOG_PAGE_OFFSET: u32 = 64;
pub const DE_VECTOR: u32 = 0;
pub const DB_VECTOR: u32 = 1;
pub const BP_VECTOR: u32 = 3;
pub const OF_VECTOR: u32 = 4;
pub const BR_VECTOR: u32 = 5;
pub const UD_VECTOR: u32 = 6;
pub const NM_VECTOR: u32 = 7;
pub const DF_VECTOR: u32 = 8;
pub const TS_VECTOR: u32 = 10;
pub const NP_VECTOR: u32 = 11;
pub const SS_VECTOR: u32 = 12;
pub const GP_VECTOR: u32 = 13;
pub const PF_VECTOR: u32 = 14;
pub const MF_VECTOR: u32 = 16;
pub const AC_VECTOR: u32 = 17;
pub const MC_VECTOR: u32 = 18;
pub const XM_VECTOR: u32 = 19;
pub const VE_VECTOR: u32 = 20;
pub const KVM_NR_INTERRUPTS: u32 = 256;
pub const KVM_IOAPIC_NUM_PINS: u32 = 24;
pub const KVM_IRQCHIP_PIC_MASTER: u32 = 0;
pub const KVM_IRQCHIP_PIC_SLAVE: u32 = 1;
pub const KVM_IRQCHIP_IOAPIC: u32 = 2;
pub const KVM_NR_IRQCHIPS: u32 = 3;
pub const KVM_RUN_X86_SMM: u32 = 1;
pub const KVM_RUN_X86_BUS_LOCK: u32 = 2;
pub const KVM_APIC_REG_SIZE: u32 = 1024;
pub const KVM_SREGS2_FLAGS_PDPTRS_VALID: u32 = 1;
pub const KVM_MSR_FILTER_MAX_BITMAP_SIZE: u32 = 1536;
pub const KVM_MSR_FILTER_READ: u32 = 1;
pub const KVM_MSR_FILTER_WRITE: u32 = 2;
pub const KVM_MSR_FILTER_RANGE_VALID_MASK: u32 = 3;
pub const KVM_MSR_FILTER_MAX_RANGES: u32 = 16;
pub const KVM_MSR_FILTER_DEFAULT_ALLOW: u32 = 0;
pub const KVM_MSR_FILTER_DEFAULT_DENY: u32 = 1;
pub const KVM_MSR_FILTER_VALID_MASK: u32 = 1;
pub const KVM_CPUID_FLAG_SIGNIFCANT_INDEX: u32 = 1;
pub const KVM_CPUID_FLAG_STATEFUL_FUNC: u32 = 2;
pub const KVM_CPUID_FLAG_STATE_READ_NEXT: u32 = 4;
pub const KVM_GUESTDBG_USE_SW_BP: u32 = 65536;
pub const KVM_GUESTDBG_USE_HW_BP: u32 = 131072;
pub const KVM_GUESTDBG_INJECT_DB: u32 = 262144;
pub const KVM_GUESTDBG_INJECT_BP: u32 = 524288;
pub const KVM_GUESTDBG_BLOCKIRQ: u32 = 1048576;
pub const KVM_PIT_FLAGS_HPET_LEGACY: u32 = 1;
pub const KVM_PIT_FLAGS_SPEAKER_DATA_ON: u32 = 2;
pub const KVM_VCPUEVENT_VALID_NMI_PENDING: u32 = 1;
pub const KVM_VCPUEVENT_VALID_SIPI_VECTOR: u32 = 2;
pub const KVM_VCPUEVENT_VALID_SHADOW: u32 = 4;
pub const KVM_VCPUEVENT_VALID_SMM: u32 = 8;
pub const KVM_VCPUEVENT_VALID_PAYLOAD: u32 = 16;
pub const KVM_VCPUEVENT_VALID_TRIPLE_FAULT: u32 = 32;
pub const KVM_X86_SHADOW_INT_MOV_SS: u32 = 1;
pub const KVM_X86_SHADOW_INT_STI: u32 = 2;
pub const KVM_MAX_XCRS: u32 = 16;
pub const KVM_SYNC_X86_REGS: u32 = 1;
pub const KVM_SYNC_X86_SREGS: u32 = 2;
pub const KVM_SYNC_X86_EVENTS: u32 = 4;
pub const KVM_SYNC_X86_VALID_FIELDS: u32 = 7;
pub const KVM_X86_QUIRK_LINT0_REENABLED: u32 = 1;
pub const KVM_X86_QUIRK_CD_NW_CLEARED: u32 = 2;
pub const KVM_X86_QUIRK_LAPIC_MMIO_HOLE: u32 = 4;
pub const KVM_X86_QUIRK_OUT_7E_INC_RIP: u32 = 8;
pub const KVM_X86_QUIRK_MISC_ENABLE_NO_MWAIT: u32 = 16;
pub const KVM_X86_QUIRK_FIX_HYPERCALL_INSN: u32 = 32;
pub const KVM_X86_QUIRK_MWAIT_NEVER_UD_FAULTS: u32 = 64;
pub const KVM_STATE_NESTED_FORMAT_VMX: u32 = 0;
pub const KVM_STATE_NESTED_FORMAT_SVM: u32 = 1;
pub const KVM_STATE_NESTED_GUEST_MODE: u32 = 1;
pub const KVM_STATE_NESTED_RUN_PENDING: u32 = 2;
pub const KVM_STATE_NESTED_EVMCS: u32 = 4;
pub const KVM_STATE_NESTED_MTF_PENDING: u32 = 8;
pub const KVM_STATE_NESTED_GIF_SET: u32 = 256;
pub const KVM_STATE_NESTED_SMM_GUEST_MODE: u32 = 1;
pub const KVM_STATE_NESTED_SMM_VMXON: u32 = 2;
pub const KVM_STATE_NESTED_VMX_VMCS_SIZE: u32 = 4096;
pub const KVM_STATE_NESTED_SVM_VMCB_SIZE: u32 = 4096;
pub const KVM_STATE_VMX_PREEMPTION_TIMER_DEADLINE: u32 = 1;
pub const KVM_X86_XCOMP_GUEST_SUPP: u32 = 0;
pub const KVM_PMU_EVENT_ALLOW: u32 = 0;
pub const KVM_PMU_EVENT_DENY: u32 = 1;
pub const KVM_XEN_HVM_CONFIG_HYPERCALL_MSR: u32 = 1;
pub const KVM_XEN_HVM_CONFIG_INTERCEPT_HCALL: u32 = 2;
pub const KVM_XEN_HVM_CONFIG_SHARED_INFO: u32 = 4;
pub const KVM_XEN_HVM_CONFIG_RUNSTATE: u32 = 8;
pub const KVM_XEN_HVM_CONFIG_EVTCHN_2LEVEL: u32 = 16;
pub const KVM_XEN_HVM_CONFIG_EVTCHN_SEND: u32 = 32;
pub const KVM_XEN_HVM_CONFIG_RUNSTATE_UPDATE_FLAG: u32 = 64;
pub const KVM_XEN_HVM_CONFIG_PVCLOCK_TSC_UNSTABLE: u32 = 128;
pub const KVM_XEN_HVM_CONFIG_SHARED_INFO_HVA: u32 = 256;
pub const KVM_XEN_EVTCHN_DEASSIGN: u32 = 1;
pub const KVM_XEN_EVTCHN_UPDATE: u32 = 2;
pub const KVM_XEN_EVTCHN_RESET: u32 = 4;
pub const KVM_XEN_ATTR_TYPE_LONG_MODE: u32 = 0;
pub const KVM_XEN_ATTR_TYPE_SHARED_INFO: u32 = 1;
pub const KVM_XEN_ATTR_TYPE_UPCALL_VECTOR: u32 = 2;
pub const KVM_XEN_ATTR_TYPE_EVTCHN: u32 = 3;
pub const KVM_XEN_ATTR_TYPE_XEN_VERSION: u32 = 4;
pub const KVM_XEN_ATTR_TYPE_RUNSTATE_UPDATE_FLAG: u32 = 5;
pub const KVM_XEN_ATTR_TYPE_SHARED_INFO_HVA: u32 = 6;
pub const KVM_XEN_VCPU_ATTR_TYPE_VCPU_INFO: u32 = 0;
pub const KVM_XEN_VCPU_ATTR_TYPE_VCPU_TIME_INFO: u32 = 1;
pub const KVM_XEN_VCPU_ATTR_TYPE_RUNSTATE_ADDR: u32 = 2;
pub const KVM_XEN_VCPU_ATTR_TYPE_RUNSTATE_CURRENT: u32 = 3;
pub const KVM_XEN_VCPU_ATTR_TYPE_RUNSTATE_DATA: u32 = 4;
pub const KVM_XEN_VCPU_ATTR_TYPE_RUNSTATE_ADJUST: u32 = 5;
pub const KVM_XEN_VCPU_ATTR_TYPE_VCPU_ID: u32 = 6;
pub const KVM_XEN_VCPU_ATTR_TYPE_TIMER: u32 = 7;
pub const KVM_XEN_VCPU_ATTR_TYPE_UPCALL_VECTOR: u32 = 8;
pub const KVM_XEN_VCPU_ATTR_TYPE_VCPU_INFO_HVA: u32 = 9;
pub const KVM_X2APIC_API_USE_32BIT_IDS: u32 = 1;
pub const KVM_X2APIC_API_DISABLE_BROADCAST_QUIRK: u32 = 2;
pub const KVM_HYPERV_CONN_ID_MASK: u32 = 16777215;
pub const KVM_HYPERV_EVENTFD_DEASSIGN: u32 = 1;
pub const KVM_PMU_MASKED_ENTRY_UMASK_MASK_SHIFT: u32 = 56;
pub const KVM_VCPU_TSC_CTRL: u32 = 0;
pub const KVM_VCPU_TSC_OFFSET: u32 = 0;
pub const KVM_X86_DEFAULT_VM: u32 = 0;
pub const KVM_X86_SW_PROTECTED_VM: u32 = 1;
pub const KVM_API_VERSION: u32 = 12;
pub const KVM_MEM_LOG_DIRTY_PAGES: u32 = 1;
pub const KVM_MEM_READONLY: u32 = 2;
pub const KVM_MEM_GUEST_MEMFD: u32 = 4;
pub const KVM_PIT_SPEAKER_DUMMY: u32 = 1;
pub const KVM_EXIT_HYPERV_SYNIC: u32 = 1;
pub const KVM_EXIT_HYPERV_HCALL: u32 = 2;
pub const KVM_EXIT_HYPERV_SYNDBG: u32 = 3;
pub const KVM_EXIT_XEN_HCALL: u32 = 1;
pub const KVM_S390_GET_SKEYS_NONE: u32 = 1;
pub const KVM_S390_SKEYS_MAX: u32 = 1048576;
pub const KVM_EXIT_UNKNOWN: u32 = 0;
pub const KVM_EXIT_EXCEPTION: u32 = 1;
pub const KVM_EXIT_IO: u32 = 2;
pub const KVM_EXIT_HYPERCALL: u32 = 3;
pub const KVM_EXIT_DEBUG: u32 = 4;
pub const KVM_EXIT_HLT: u32 = 5;
pub const KVM_EXIT_MMIO: u32 = 6;
pub const KVM_EXIT_IRQ_WINDOW_OPEN: u32 = 7;
pub const KVM_EXIT_SHUTDOWN: u32 = 8;
pub const KVM_EXIT_FAIL_ENTRY: u32 = 9;
pub const KVM_EXIT_INTR: u32 = 10;
pub const KVM_EXIT_SET_TPR: u32 = 11;
pub const KVM_EXIT_TPR_ACCESS: u32 = 12;
pub const KVM_EXIT_S390_SIEIC: u32 = 13;
pub const KVM_EXIT_S390_RESET: u32 = 14;
pub const KVM_EXIT_DCR: u32 = 15;
pub const KVM_EXIT_NMI: u32 = 16;
pub const KVM_EXIT_INTERNAL_ERROR: u32 = 17;
pub const KVM_EXIT_OSI: u32 = 18;
pub const KVM_EXIT_PAPR_HCALL: u32 = 19;
pub const KVM_EXIT_S390_UCONTROL: u32 = 20;
pub const KVM_EXIT_WATCHDOG: u32 = 21;
pub const KVM_EXIT_S390_TSCH: u32 = 22;
pub const KVM_EXIT_EPR: u32 = 23;
pub const KVM_EXIT_SYSTEM_EVENT: u32 = 24;
pub const KVM_EXIT_S390_STSI: u32 = 25;
pub const KVM_EXIT_IOAPIC_EOI: u32 = 26;
pub const KVM_EXIT_HYPERV: u32 = 27;
pub const KVM_EXIT_ARM_NISV: u32 = 28;
pub const KVM_EXIT_X86_RDMSR: u32 = 29;
pub const KVM_EXIT_X86_WRMSR: u32 = 30;
pub const KVM_EXIT_DIRTY_RING_FULL: u32 = 31;
pub const KVM_EXIT_AP_RESET_HOLD: u32 = 32;
pub const KVM_EXIT_X86_BUS_LOCK: u32 = 33;
pub const KVM_EXIT_XEN: u32 = 34;
pub const KVM_EXIT_RISCV_SBI: u32 = 35;
pub const KVM_EXIT_RISCV_CSR: u32 = 36;
pub const KVM_EXIT_NOTIFY: u32 = 37;
pub const KVM_EXIT_LOONGARCH_IOCSR: u32 = 38;
pub const KVM_EXIT_MEMORY_FAULT: u32 = 39;
pub const KVM_INTERNAL_ERROR_EMULATION: u32 = 1;
pub const KVM_INTERNAL_ERROR_SIMUL_EX: u32 = 2;
pub const KVM_INTERNAL_ERROR_DELIVERY_EV: u32 = 3;
pub const KVM_INTERNAL_ERROR_UNEXPECTED_EXIT_REASON: u32 = 4;
pub const KVM_INTERNAL_ERROR_EMULATION_FLAG_INSTRUCTION_BYTES: u32 = 1;
pub const KVM_EXIT_IO_IN: u32 = 0;
pub const KVM_EXIT_IO_OUT: u32 = 1;
pub const KVM_SYSTEM_EVENT_SHUTDOWN: u32 = 1;
pub const KVM_SYSTEM_EVENT_RESET: u32 = 2;
pub const KVM_SYSTEM_EVENT_CRASH: u32 = 3;
pub const KVM_SYSTEM_EVENT_WAKEUP: u32 = 4;
pub const KVM_SYSTEM_EVENT_SUSPEND: u32 = 5;
pub const KVM_SYSTEM_EVENT_SEV_TERM: u32 = 6;
pub const KVM_MSR_EXIT_REASON_INVAL: u32 = 1;
pub const KVM_MSR_EXIT_REASON_UNKNOWN: u32 = 2;
pub const KVM_MSR_EXIT_REASON_FILTER: u32 = 4;
pub const KVM_MSR_EXIT_REASON_VALID_MASK: u32 = 7;
pub const KVM_NOTIFY_CONTEXT_INVALID: u32 = 1;
pub const KVM_MEMORY_EXIT_FLAG_PRIVATE: u32 = 8;
pub const SYNC_REGS_SIZE_BYTES: u32 = 2048;
pub const KVM_MP_STATE_RUNNABLE: u32 = 0;
pub const KVM_MP_STATE_UNINITIALIZED: u32 = 1;
pub const KVM_MP_STATE_INIT_RECEIVED: u32 = 2;
pub const KVM_MP_STATE_HALTED: u32 = 3;
pub const KVM_MP_STATE_SIPI_RECEIVED: u32 = 4;
pub const KVM_MP_STATE_STOPPED: u32 = 5;
pub const KVM_MP_STATE_CHECK_STOP: u32 = 6;
pub const KVM_MP_STATE_OPERATING: u32 = 7;
pub const KVM_MP_STATE_LOAD: u32 = 8;
pub const KVM_MP_STATE_AP_RESET_HOLD: u32 = 9;
pub const KVM_MP_STATE_SUSPENDED: u32 = 10;
pub const KVM_GUESTDBG_ENABLE: u32 = 1;
pub const KVM_GUESTDBG_SINGLESTEP: u32 = 2;
pub const KVM_X86_DISABLE_EXITS_MWAIT: u32 = 1;
pub const KVM_X86_DISABLE_EXITS_HLT: u32 = 2;
pub const KVM_X86_DISABLE_EXITS_PAUSE: u32 = 4;
pub const KVM_X86_DISABLE_EXITS_CSTATE: u32 = 8;
pub const KVM_X86_DISABLE_VALID_EXITS: u32 = 15;
pub const KVMIO: u32 = 174;
pub const KVM_VM_S390_UCONTROL: u32 = 1;
pub const KVM_VM_PPC_HV: u32 = 1;
pub const KVM_VM_PPC_PR: u32 = 2;
pub const KVM_VM_MIPS_AUTO: u32 = 0;
pub const KVM_VM_MIPS_VZ: u32 = 1;
pub const KVM_VM_MIPS_TE: u32 = 2;
pub const KVM_S390_SIE_PAGE_OFFSET: u32 = 1;
pub const KVM_VM_TYPE_ARM_IPA_SIZE_MASK: u32 = 255;
pub const KVM_CAP_IRQCHIP: u32 = 0;
pub const KVM_CAP_HLT: u32 = 1;
pub const KVM_CAP_MMU_SHADOW_CACHE_CONTROL: u32 = 2;
pub const KVM_CAP_USER_MEMORY: u32 = 3;
pub const KVM_CAP_SET_TSS_ADDR: u32 = 4;
pub const KVM_CAP_VAPIC: u32 = 6;
pub const KVM_CAP_EXT_CPUID: u32 = 7;
pub const KVM_CAP_CLOCKSOURCE: u32 = 8;
pub const KVM_CAP_NR_VCPUS: u32 = 9;
pub const KVM_CAP_NR_MEMSLOTS: u32 = 10;
pub const KVM_CAP_PIT: u32 = 11;
pub const KVM_CAP_NOP_IO_DELAY: u32 = 12;
pub const KVM_CAP_PV_MMU: u32 = 13;
pub const KVM_CAP_MP_STATE: u32 = 14;
pub const KVM_CAP_COALESCED_MMIO: u32 = 15;
pub const KVM_CAP_SYNC_MMU: u32 = 16;
pub const KVM_CAP_IOMMU: u32 = 18;
pub const KVM_CAP_DESTROY_MEMORY_REGION_WORKS: u32 = 21;
pub const KVM_CAP_USER_NMI: u32 = 22;
pub const KVM_CAP_SET_GUEST_DEBUG: u32 = 23;
pub const KVM_CAP_REINJECT_CONTROL: u32 = 24;
pub const KVM_CAP_IRQ_ROUTING: u32 = 25;
pub const KVM_CAP_IRQ_INJECT_STATUS: u32 = 26;
pub const KVM_CAP_ASSIGN_DEV_IRQ: u32 = 29;
pub const KVM_CAP_JOIN_MEMORY_REGIONS_WORKS: u32 = 30;
pub const KVM_CAP_MCE: u32 = 31;
pub const KVM_CAP_IRQFD: u32 = 32;
pub const KVM_CAP_PIT2: u32 = 33;
pub const KVM_CAP_SET_BOOT_CPU_ID: u32 = 34;
pub const KVM_CAP_PIT_STATE2: u32 = 35;
pub const KVM_CAP_IOEVENTFD: u32 = 36;
pub const KVM_CAP_SET_IDENTITY_MAP_ADDR: u32 = 37;
pub const KVM_CAP_XEN_HVM: u32 = 38;
pub const KVM_CAP_ADJUST_CLOCK: u32 = 39;
pub const KVM_CAP_INTERNAL_ERROR_DATA: u32 = 40;
pub const KVM_CAP_VCPU_EVENTS: u32 = 41;
pub const KVM_CAP_S390_PSW: u32 = 42;
pub const KVM_CAP_PPC_SEGSTATE: u32 = 43;
pub const KVM_CAP_HYPERV: u32 = 44;
pub const KVM_CAP_HYPERV_VAPIC: u32 = 45;
pub const KVM_CAP_HYPERV_SPIN: u32 = 46;
pub const KVM_CAP_PCI_SEGMENT: u32 = 47;
pub const KVM_CAP_PPC_PAIRED_SINGLES: u32 = 48;
pub const KVM_CAP_INTR_SHADOW: u32 = 49;
pub const KVM_CAP_DEBUGREGS: u32 = 50;
pub const KVM_CAP_X86_ROBUST_SINGLESTEP: u32 = 51;
pub const KVM_CAP_PPC_OSI: u32 = 52;
pub const KVM_CAP_PPC_UNSET_IRQ: u32 = 53;
pub const KVM_CAP_ENABLE_CAP: u32 = 54;
pub const KVM_CAP_XSAVE: u32 = 55;
pub const KVM_CAP_XCRS: u32 = 56;
pub const KVM_CAP_PPC_GET_PVINFO: u32 = 57;
pub const KVM_CAP_PPC_IRQ_LEVEL: u32 = 58;
pub const KVM_CAP_ASYNC_PF: u32 = 59;
pub const KVM_CAP_TSC_CONTROL: u32 = 60;
pub const KVM_CAP_GET_TSC_KHZ: u32 = 61;
pub const KVM_CAP_PPC_BOOKE_SREGS: u32 = 62;
pub const KVM_CAP_SPAPR_TCE: u32 = 63;
pub const KVM_CAP_PPC_SMT: u32 = 64;
pub const KVM_CAP_PPC_RMA: u32 = 65;
pub const KVM_CAP_MAX_VCPUS: u32 = 66;
pub const KVM_CAP_PPC_HIOR: u32 = 67;
pub const KVM_CAP_PPC_PAPR: u32 = 68;
pub const KVM_CAP_SW_TLB: u32 = 69;
pub const KVM_CAP_ONE_REG: u32 = 70;
pub const KVM_CAP_S390_GMAP: u32 = 71;
pub const KVM_CAP_TSC_DEADLINE_TIMER: u32 = 72;
pub const KVM_CAP_S390_UCONTROL: u32 = 73;
pub const KVM_CAP_SYNC_REGS: u32 = 74;
pub const KVM_CAP_PCI_2_3: u32 = 75;
pub const KVM_CAP_KVMCLOCK_CTRL: u32 = 76;
pub const KVM_CAP_SIGNAL_MSI: u32 = 77;
pub const KVM_CAP_PPC_GET_SMMU_INFO: u32 = 78;
pub const KVM_CAP_S390_COW: u32 = 79;
pub const KVM_CAP_PPC_ALLOC_HTAB: u32 = 80;
pub const KVM_CAP_READONLY_MEM: u32 = 81;
pub const KVM_CAP_IRQFD_RESAMPLE: u32 = 82;
pub const KVM_CAP_PPC_BOOKE_WATCHDOG: u32 = 83;
pub const KVM_CAP_PPC_HTAB_FD: u32 = 84;
pub const KVM_CAP_S390_CSS_SUPPORT: u32 = 85;
pub const KVM_CAP_PPC_EPR: u32 = 86;
pub const KVM_CAP_ARM_PSCI: u32 = 87;
pub const KVM_CAP_ARM_SET_DEVICE_ADDR: u32 = 88;
pub const KVM_CAP_DEVICE_CTRL: u32 = 89;
pub const KVM_CAP_IRQ_MPIC: u32 = 90;
pub const KVM_CAP_PPC_RTAS: u32 = 91;
pub const KVM_CAP_IRQ_XICS: u32 = 92;
pub const KVM_CAP_ARM_EL1_32BIT: u32 = 93;
pub const KVM_CAP_SPAPR_MULTITCE: u32 = 94;
pub const KVM_CAP_EXT_EMUL_CPUID: u32 = 95;
pub const KVM_CAP_HYPERV_TIME: u32 = 96;
pub const KVM_CAP_IOAPIC_POLARITY_IGNORED: u32 = 97;
pub const KVM_CAP_ENABLE_CAP_VM: u32 = 98;
pub const KVM_CAP_S390_IRQCHIP: u32 = 99;
pub const KVM_CAP_IOEVENTFD_NO_LENGTH: u32 = 100;
pub const KVM_CAP_VM_ATTRIBUTES: u32 = 101;
pub const KVM_CAP_ARM_PSCI_0_2: u32 = 102;
pub const KVM_CAP_PPC_FIXUP_HCALL: u32 = 103;
pub const KVM_CAP_PPC_ENABLE_HCALL: u32 = 104;
pub const KVM_CAP_CHECK_EXTENSION_VM: u32 = 105;
pub const KVM_CAP_S390_USER_SIGP: u32 = 106;
pub const KVM_CAP_S390_VECTOR_REGISTERS: u32 = 107;
pub const KVM_CAP_S390_MEM_OP: u32 = 108;
pub const KVM_CAP_S390_USER_STSI: u32 = 109;
pub const KVM_CAP_S390_SKEYS: u32 = 110;
pub const KVM_CAP_MIPS_FPU: u32 = 111;
pub const KVM_CAP_MIPS_MSA: u32 = 112;
pub const KVM_CAP_S390_INJECT_IRQ: u32 = 113;
pub const KVM_CAP_S390_IRQ_STATE: u32 = 114;
pub const KVM_CAP_PPC_HWRNG: u32 = 115;
pub const KVM_CAP_DISABLE_QUIRKS: u32 = 116;
pub const KVM_CAP_X86_SMM: u32 = 117;
pub const KVM_CAP_MULTI_ADDRESS_SPACE: u32 = 118;
pub const KVM_CAP_GUEST_DEBUG_HW_BPS: u32 = 119;
pub const KVM_CAP_GUEST_DEBUG_HW_WPS: u32 = 120;
pub const KVM_CAP_SPLIT_IRQCHIP: u32 = 121;
pub const KVM_CAP_IOEVENTFD_ANY_LENGTH: u32 = 122;
pub const KVM_CAP_HYPERV_SYNIC: u32 = 123;
pub const KVM_CAP_S390_RI: u32 = 124;
pub const KVM_CAP_SPAPR_TCE_64: u32 = 125;
pub const KVM_CAP_ARM_PMU_V3: u32 = 126;
pub const KVM_CAP_VCPU_ATTRIBUTES: u32 = 127;
pub const KVM_CAP_MAX_VCPU_ID: u32 = 128;
pub const KVM_CAP_X2APIC_API: u32 = 129;
pub const KVM_CAP_S390_USER_INSTR0: u32 = 130;
pub const KVM_CAP_MSI_DEVID: u32 = 131;
pub const KVM_CAP_PPC_HTM: u32 = 132;
pub const KVM_CAP_SPAPR_RESIZE_HPT: u32 = 133;
pub const KVM_CAP_PPC_MMU_RADIX: u32 = 134;
pub const KVM_CAP_PPC_MMU_HASH_V3: u32 = 135;
pub const KVM_CAP_IMMEDIATE_EXIT: u32 = 136;
pub const KVM_CAP_MIPS_VZ: u32 = 137;
pub const KVM_CAP_MIPS_TE: u32 = 138;
pub const KVM_CAP_MIPS_64BIT: u32 = 139;
pub const KVM_CAP_S390_GS: u32 = 140;
pub const KVM_CAP_S390_AIS: u32 = 141;
pub const KVM_CAP_SPAPR_TCE_VFIO: u32 = 142;
pub const KVM_CAP_X86_DISABLE_EXITS: u32 = 143;
pub const KVM_CAP_ARM_USER_IRQ: u32 = 144;
pub const KVM_CAP_S390_CMMA_MIGRATION: u32 = 145;
pub const KVM_CAP_PPC_FWNMI: u32 = 146;
pub const KVM_CAP_PPC_SMT_POSSIBLE: u32 = 147;
pub const KVM_CAP_HYPERV_SYNIC2: u32 = 148;
pub const KVM_CAP_HYPERV_VP_INDEX: u32 = 149;
pub const KVM_CAP_S390_AIS_MIGRATION: u32 = 150;
pub const KVM_CAP_PPC_GET_CPU_CHAR: u32 = 151;
pub const KVM_CAP_S390_BPB: u32 = 152;
pub const KVM_CAP_GET_MSR_FEATURES: u32 = 153;
pub const KVM_CAP_HYPERV_EVENTFD: u32 = 154;
pub const KVM_CAP_HYPERV_TLBFLUSH: u32 = 155;
pub const KVM_CAP_S390_HPAGE_1M: u32 = 156;
pub const KVM_CAP_NESTED_STATE: u32 = 157;
pub const KVM_CAP_ARM_INJECT_SERROR_ESR: u32 = 158;
pub const KVM_CAP_MSR_PLATFORM_INFO: u32 = 159;
pub const KVM_CAP_PPC_NESTED_HV: u32 = 160;
pub const KVM_CAP_HYPERV_SEND_IPI: u32 = 161;
pub const KVM_CAP_COALESCED_PIO: u32 = 162;
pub const KVM_CAP_HYPERV_ENLIGHTENED_VMCS: u32 = 163;
pub const KVM_CAP_EXCEPTION_PAYLOAD: u32 = 164;
pub const KVM_CAP_ARM_VM_IPA_SIZE: u32 = 165;
pub const KVM_CAP_MANUAL_DIRTY_LOG_PROTECT: u32 = 166;
pub const KVM_CAP_HYPERV_CPUID: u32 = 167;
pub const KVM_CAP_MANUAL_DIRTY_LOG_PROTECT2: u32 = 168;
pub const KVM_CAP_PPC_IRQ_XIVE: u32 = 169;
pub const KVM_CAP_ARM_SVE: u32 = 170;
pub const KVM_CAP_ARM_PTRAUTH_ADDRESS: u32 = 171;
pub const KVM_CAP_ARM_PTRAUTH_GENERIC: u32 = 172;
pub const KVM_CAP_PMU_EVENT_FILTER: u32 = 173;
pub const KVM_CAP_ARM_IRQ_LINE_LAYOUT_2: u32 = 174;
pub const KVM_CAP_HYPERV_DIRECT_TLBFLUSH: u32 = 175;
pub const KVM_CAP_PPC_GUEST_DEBUG_SSTEP: u32 = 176;
pub const KVM_CAP_ARM_NISV_TO_USER: u32 = 177;
pub const KVM_CAP_ARM_INJECT_EXT_DABT: u32 = 178;
pub const KVM_CAP_S390_VCPU_RESETS: u32 = 179;
pub const KVM_CAP_S390_PROTECTED: u32 = 180;
pub const KVM_CAP_PPC_SECURE_GUEST: u32 = 181;
pub const KVM_CAP_HALT_POLL: u32 = 182;
pub const KVM_CAP_ASYNC_PF_INT: u32 = 183;
pub const KVM_CAP_LAST_CPU: u32 = 184;
pub const KVM_CAP_SMALLER_MAXPHYADDR: u32 = 185;
pub const KVM_CAP_S390_DIAG318: u32 = 186;
pub const KVM_CAP_STEAL_TIME: u32 = 187;
pub const KVM_CAP_X86_USER_SPACE_MSR: u32 = 188;
pub const KVM_CAP_X86_MSR_FILTER: u32 = 189;
pub const KVM_CAP_ENFORCE_PV_FEATURE_CPUID: u32 = 190;
pub const KVM_CAP_SYS_HYPERV_CPUID: u32 = 191;
pub const KVM_CAP_DIRTY_LOG_RING: u32 = 192;
pub const KVM_CAP_X86_BUS_LOCK_EXIT: u32 = 193;
pub const KVM_CAP_PPC_DAWR1: u32 = 194;
pub const KVM_CAP_SET_GUEST_DEBUG2: u32 = 195;
pub const KVM_CAP_SGX_ATTRIBUTE: u32 = 196;
pub const KVM_CAP_VM_COPY_ENC_CONTEXT_FROM: u32 = 197;
pub const KVM_CAP_PTP_KVM: u32 = 198;
pub const KVM_CAP_HYPERV_ENFORCE_CPUID: u32 = 199;
pub const KVM_CAP_SREGS2: u32 = 200;
pub const KVM_CAP_EXIT_HYPERCALL: u32 = 201;
pub const KVM_CAP_PPC_RPT_INVALIDATE: u32 = 202;
pub const KVM_CAP_BINARY_STATS_FD: u32 = 203;
pub const KVM_CAP_EXIT_ON_EMULATION_FAILURE: u32 = 204;
pub const KVM_CAP_ARM_MTE: u32 = 205;
pub const KVM_CAP_VM_MOVE_ENC_CONTEXT_FROM: u32 = 206;
pub const KVM_CAP_VM_GPA_BITS: u32 = 207;
pub const KVM_CAP_XSAVE2: u32 = 208;
pub const KVM_CAP_SYS_ATTRIBUTES: u32 = 209;
pub const KVM_CAP_PPC_AIL_MODE_3: u32 = 210;
pub const KVM_CAP_S390_MEM_OP_EXTENSION: u32 = 211;
pub const KVM_CAP_PMU_CAPABILITY: u32 = 212;
pub const KVM_CAP_DISABLE_QUIRKS2: u32 = 213;
pub const KVM_CAP_VM_TSC_CONTROL: u32 = 214;
pub const KVM_CAP_SYSTEM_EVENT_DATA: u32 = 215;
pub const KVM_CAP_ARM_SYSTEM_SUSPEND: u32 = 216;
pub const KVM_CAP_S390_PROTECTED_DUMP: u32 = 217;
pub const KVM_CAP_X86_TRIPLE_FAULT_EVENT: u32 = 218;
pub const KVM_CAP_X86_NOTIFY_VMEXIT: u32 = 219;
pub const KVM_CAP_VM_DISABLE_NX_HUGE_PAGES: u32 = 220;
pub const KVM_CAP_S390_ZPCI_OP: u32 = 221;
pub const KVM_CAP_S390_CPU_TOPOLOGY: u32 = 222;
pub const KVM_CAP_DIRTY_LOG_RING_ACQ_REL: u32 = 223;
pub const KVM_CAP_S390_PROTECTED_ASYNC_DISABLE: u32 = 224;
pub const KVM_CAP_DIRTY_LOG_RING_WITH_BITMAP: u32 = 225;
pub const KVM_CAP_PMU_EVENT_MASKED_EVENTS: u32 = 226;
pub const KVM_CAP_COUNTER_OFFSET: u32 = 227;
pub const KVM_CAP_ARM_EAGER_SPLIT_CHUNK_SIZE: u32 = 228;
pub const KVM_CAP_ARM_SUPPORTED_BLOCK_SIZES: u32 = 229;
pub const KVM_CAP_ARM_SUPPORTED_REG_MASK_RANGES: u32 = 230;
pub const KVM_CAP_USER_MEMORY2: u32 = 231;
pub const KVM_CAP_MEMORY_FAULT_INFO: u32 = 232;
pub const KVM_CAP_MEMORY_ATTRIBUTES: u32 = 233;
pub const KVM_CAP_GUEST_MEMFD: u32 = 234;
pub const KVM_CAP_VM_TYPES: u32 = 235;
pub const KVM_IRQ_ROUTING_IRQCHIP: u32 = 1;
pub const KVM_IRQ_ROUTING_MSI: u32 = 2;
pub const KVM_IRQ_ROUTING_S390_ADAPTER: u32 = 3;
pub const KVM_IRQ_ROUTING_HV_SINT: u32 = 4;
pub const KVM_IRQ_ROUTING_XEN_EVTCHN: u32 = 5;
pub const KVM_IRQFD_FLAG_DEASSIGN: u32 = 1;
pub const KVM_IRQFD_FLAG_RESAMPLE: u32 = 2;
pub const KVM_CLOCK_TSC_STABLE: u32 = 2;
pub const KVM_CLOCK_REALTIME: u32 = 4;
pub const KVM_CLOCK_HOST_TSC: u32 = 8;
pub const KVM_MMU_FSL_BOOKE_NOHV: u32 = 0;
pub const KVM_MMU_FSL_BOOKE_HV: u32 = 1;
pub const KVM_REG_ARCH_MASK: i64 = -72057594037927936;
pub const KVM_REG_GENERIC: u32 = 0;
pub const KVM_REG_PPC: u64 = 1152921504606846976;
pub const KVM_REG_X86: u64 = 2305843009213693952;
pub const KVM_REG_IA64: u64 = 3458764513820540928;
pub const KVM_REG_ARM: u64 = 4611686018427387904;
pub const KVM_REG_S390: u64 = 5764607523034234880;
pub const KVM_REG_ARM64: u64 = 6917529027641081856;
pub const KVM_REG_MIPS: u64 = 8070450532247928832;
pub const KVM_REG_RISCV: i64 = -9223372036854775808;
pub const KVM_REG_LOONGARCH: i64 = -8070450532247928832;
pub const KVM_REG_SIZE_SHIFT: u32 = 52;
pub const KVM_REG_SIZE_MASK: u64 = 67553994410557440;
pub const KVM_REG_SIZE_U8: u32 = 0;
pub const KVM_REG_SIZE_U16: u64 = 4503599627370496;
pub const KVM_REG_SIZE_U32: u64 = 9007199254740992;
pub const KVM_REG_SIZE_U64: u64 = 13510798882111488;
pub const KVM_REG_SIZE_U128: u64 = 18014398509481984;
pub const KVM_REG_SIZE_U256: u64 = 22517998136852480;
pub const KVM_REG_SIZE_U512: u64 = 27021597764222976;
pub const KVM_REG_SIZE_U1024: u64 = 31525197391593472;
pub const KVM_REG_SIZE_U2048: u64 = 36028797018963968;
pub const KVM_MSI_VALID_DEVID: u32 = 1;
pub const KVM_CREATE_DEVICE_TEST: u32 = 1;
pub const KVM_DEV_VFIO_FILE: u32 = 1;
pub const KVM_DEV_VFIO_FILE_ADD: u32 = 1;
pub const KVM_DEV_VFIO_FILE_DEL: u32 = 2;
pub const KVM_DEV_VFIO_GROUP: u32 = 1;
pub const KVM_DEV_VFIO_GROUP_ADD: u32 = 1;
pub const KVM_DEV_VFIO_GROUP_DEL: u32 = 2;
pub const KVM_DEV_VFIO_GROUP_SET_SPAPR_TCE: u32 = 3;
pub const KVM_S390_STORE_STATUS_NOADDR: i32 = -1;
pub const KVM_S390_STORE_STATUS_PREFIXED: i32 = -2;
pub const KVM_DIRTY_LOG_MANUAL_PROTECT_ENABLE: u32 = 1;
pub const KVM_DIRTY_LOG_INITIALLY_SET: u32 = 2;
pub const KVM_DIRTY_GFN_F_MASK: u32 = 3;
pub const KVM_BUS_LOCK_DETECTION_OFF: u32 = 1;
pub const KVM_BUS_LOCK_DETECTION_EXIT: u32 = 2;
pub const KVM_PMU_CAP_DISABLE: u32 = 1;
pub const KVM_STATS_TYPE_SHIFT: u32 = 0;
pub const KVM_STATS_TYPE_MASK: u32 = 15;
pub const KVM_STATS_TYPE_CUMULATIVE: u32 = 0;
pub const KVM_STATS_TYPE_INSTANT: u32 = 1;
pub const KVM_STATS_TYPE_PEAK: u32 = 2;
pub const KVM_STATS_TYPE_LINEAR_HIST: u32 = 3;
pub const KVM_STATS_TYPE_LOG_HIST: u32 = 4;
pub const KVM_STATS_TYPE_MAX: u32 = 4;
pub const KVM_STATS_UNIT_SHIFT: u32 = 4;
pub const KVM_STATS_UNIT_MASK: u32 = 240;
pub const KVM_STATS_UNIT_NONE: u32 = 0;
pub const KVM_STATS_UNIT_BYTES: u32 = 16;
pub const KVM_STATS_UNIT_SECONDS: u32 = 32;
pub const KVM_STATS_UNIT_CYCLES: u32 = 48;
pub const KVM_STATS_UNIT_BOOLEAN: u32 = 64;
pub const KVM_STATS_UNIT_MAX: u32 = 64;
pub const KVM_STATS_BASE_SHIFT: u32 = 8;
pub const KVM_STATS_BASE_MASK: u32 = 3840;
pub const KVM_STATS_BASE_POW10: u32 = 0;
pub const KVM_STATS_BASE_POW2: u32 = 256;
pub const KVM_STATS_BASE_MAX: u32 = 256;
pub const KVM_X86_NOTIFY_VMEXIT_ENABLED: u32 = 1;
pub const KVM_X86_NOTIFY_VMEXIT_USER: u32 = 2;
pub const KVM_MEMORY_ATTRIBUTE_PRIVATE: u32 = 8;
pub type __s8 = ::std::os::raw::c_schar;
pub type __u8 = ::std::os::raw::c_uchar;
pub type __s16 = ::std::os::raw::c_short;
pub type __u16 = ::std::os::raw::c_ushort;
pub type __s32 = ::std::os::raw::c_int;
pub type __u32 = ::std::os::raw::c_uint;
pub type __s64 = ::std::os::raw::c_longlong;
pub type __u64 = ::std::os::raw::c_ulonglong;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct __kernel_fd_set {
    pub fds_bits: [::std::os::raw::c_ulong; 16usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of __kernel_fd_set"][::std::mem::size_of::<__kernel_fd_set>() - 128usize];
    ["Alignment of __kernel_fd_set"][::std::mem::align_of::<__kernel_fd_set>() - 8usize];
    ["Offset of field: __kernel_fd_set::fds_bits"]
        [::std::mem::offset_of!(__kernel_fd_set, fds_bits) - 0usize];
};
pub type __kernel_sighandler_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>;
pub type __kernel_key_t = ::std::os::raw::c_int;
pub type __kernel_mqd_t = ::std::os::raw::c_int;
pub type __kernel_old_uid_t = ::std::os::raw::c_ushort;
pub type __kernel_old_gid_t = ::std::os::raw::c_ushort;
pub type __kernel_old_dev_t = ::std::os::raw::c_ulong;
pub type __kernel_long_t = ::std::os::raw::c_long;
pub type __kernel_ulong_t = ::std::os::raw::c_ulong;
pub type __kernel_ino_t = __kernel_ulong_t;
pub type __kernel_mode_t = ::std::os::raw::c_uint;
pub type __kernel_pid_t = ::std::os::raw::c_int;
pub type __kernel_ipc_pid_t = ::std::os::raw::c_int;
pub type __kernel_uid_t = ::std::os::raw::c_uint;
pub type __kernel_gid_t = ::std::os::raw::c_uint;
pub type __kernel_suseconds_t = __kernel_long_t;
pub type __kernel_daddr_t = ::std::os::raw::c_int;
pub type __kernel_uid32_t = ::std::os::raw::c_uint;
pub type __kernel_gid32_t = ::std::os::raw::c_uint;
pub type __kernel_size_t = __kernel_ulong_t;
pub type __kernel_ssize_t = __kernel_long_t;
pub type __kernel_ptrdiff_t = __kernel_long_t;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct __kernel_fsid_t {
    pub val: [::std::os::raw::c_int; 2usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of __kernel_fsid_t"][::std::mem::size_of::<__kernel_fsid_t>() - 8usize];
    ["Alignment of __kernel_fsid_t"][::std::mem::align_of::<__kernel_fsid_t>() - 4usize];
    ["Offset of field: __kernel_fsid_t::val"]
        [::std::mem::offset_of!(__kernel_fsid_t, val) - 0usize];
};
pub type __kernel_off_t = __kernel_long_t;
pub type __kernel_loff_t = ::std::os::raw::c_longlong;
pub type __kernel_old_time_t = __kernel_long_t;
pub type __kernel_time_t = __kernel_long_t;
pub type __kernel_time64_t = ::std::os::raw::c_longlong;
pub type __kernel_clock_t = __kernel_long_t;
pub type __kernel_timer_t = ::std::os::raw::c_int;
pub type __kernel_clockid_t = ::std::os::raw::c_int;
pub type __kernel_caddr_t = *mut ::std::os::raw::c_char;
pub type __kernel_uid16_t = ::std::os::raw::c_ushort;
pub type __kernel_gid16_t = ::std::os::raw::c_ushort;
pub type __s128 = i128;
pub type __u128 = u128;
pub type __le16 = __u16;
pub type __be16 = __u16;
pub type __le32 = __u32;
pub type __be32 = __u32;
pub type __le64 = __u64;
pub type __be64 = __u64;
pub type __sum16 = __u16;
pub type __wsum = __u32;
pub type __poll_t = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
#[cfg_attr(
    feature = "serde",
    derive(zerocopy::AsBytes, zerocopy::FromBytes, zerocopy::FromZeroes)
)]
pub struct kvm_pic_state {
    pub last_irr: __u8,
    pub irr: __u8,
    pub imr: __u8,
    pub isr: __u8,
    pub priority_add: __u8,
    pub irq_base: __u8,
    pub read_reg_select: __u8,
    pub poll: __u8,
    pub special_mask: __u8,
    pub init_state: __u8,
    pub auto_eoi: __u8,
    pub rotate_on_auto_eoi: __u8,
    pub special_fully_nested_mode: __u8,
    pub init4: __u8,
    pub elcr: __u8,
    pub elcr_mask: __u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_pic_state"][::std::mem::size_of::<kvm_pic_state>() - 16usize];
    ["Alignment of kvm_pic_state"][::std::mem::align_of::<kvm_pic_state>() - 1usize];
    ["Offset of field: kvm_pic_state::last_irr"]
        [::std::mem::offset_of!(kvm_pic_state, last_irr) - 0usize];
    ["Offset of field: kvm_pic_state::irr"][::std::mem::offset_of!(kvm_pic_state, irr) - 1usize];
    ["Offset of field: kvm_pic_state::imr"][::std::mem::offset_of!(kvm_pic_state, imr) - 2usize];
    ["Offset of field: kvm_pic_state::isr"][::std::mem::offset_of!(kvm_pic_state, isr) - 3usize];
    ["Offset of field: kvm_pic_state::priority_add"]
        [::std::mem::offset_of!(kvm_pic_state, priority_add) - 4usize];
    ["Offset of field: kvm_pic_state::irq_base"]
        [::std::mem::offset_of!(kvm_pic_state, irq_base) - 5usize];
    ["Offset of field: kvm_pic_state::read_reg_select"]
        [::std::mem::offset_of!(kvm_pic_state, read_reg_select) - 6usize];
    ["Offset of field: kvm_pic_state::poll"][::std::mem::offset_of!(kvm_pic_state, poll) - 7usize];
    ["Offset of field: kvm_pic_state::special_mask"]
        [::std::mem::offset_of!(kvm_pic_state, special_mask) - 8usize];
    ["Offset of field: kvm_pic_state::init_state"]
        [::std::mem::offset_of!(kvm_pic_state, init_state) - 9usize];
    ["Offset of field: kvm_pic_state::auto_eoi"]
        [::std::mem::offset_of!(kvm_pic_state, auto_eoi) - 10usize];
    ["Offset of field: kvm_pic_state::rotate_on_auto_eoi"]
        [::std::mem::offset_of!(kvm_pic_state, rotate_on_auto_eoi) - 11usize];
    ["Offset of field: kvm_pic_state::special_fully_nested_mode"]
        [::std::mem::offset_of!(kvm_pic_state, special_fully_nested_mode) - 12usize];
    ["Offset of field: kvm_pic_state::init4"]
        [::std::mem::offset_of!(kvm_pic_state, init4) - 13usize];
    ["Offset of field: kvm_pic_state::elcr"][::std::mem::offset_of!(kvm_pic_state, elcr) - 14usize];
    ["Offset of field: kvm_pic_state::elcr_mask"]
        [::std::mem::offset_of!(kvm_pic_state, elcr_mask) - 15usize];
};
#[repr(C)]
#[derive(Copy, Clone)]
#[cfg_attr(
    feature = "serde",
    derive(zerocopy::AsBytes, zerocopy::FromBytes, zerocopy::FromZeroes)
)]
pub struct kvm_ioapic_state {
    pub base_address: __u64,
    pub ioregsel: __u32,
    pub id: __u32,
    pub irr: __u32,
    pub pad: __u32,
    pub redirtbl: [kvm_ioapic_state__bindgen_ty_1; 24usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
#[cfg_attr(
    feature = "serde",
    derive(zerocopy::AsBytes, zerocopy::FromBytes, zerocopy::FromZeroes)
)]
pub union kvm_ioapic_state__bindgen_ty_1 {
    pub bits: __u64,
    pub fields: kvm_ioapic_state__bindgen_ty_1__bindgen_ty_1,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
#[cfg_attr(
    feature = "serde",
    derive(zerocopy::AsBytes, zerocopy::FromBytes, zerocopy::FromZeroes)
)]
pub struct kvm_ioapic_state__bindgen_ty_1__bindgen_ty_1 {
    pub vector: __u8,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 2usize]>,
    pub reserved: [__u8; 4usize],
    pub dest_id: __u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_ioapic_state__bindgen_ty_1__bindgen_ty_1"]
        [::std::mem::size_of::<kvm_ioapic_state__bindgen_ty_1__bindgen_ty_1>() - 8usize];
    ["Alignment of kvm_ioapic_state__bindgen_ty_1__bindgen_ty_1"]
        [::std::mem::align_of::<kvm_ioapic_state__bindgen_ty_1__bindgen_ty_1>() - 1usize];
    ["Offset of field: kvm_ioapic_state__bindgen_ty_1__bindgen_ty_1::vector"]
        [::std::mem::offset_of!(kvm_ioapic_state__bindgen_ty_1__bindgen_ty_1, vector) - 0usize];
    ["Offset of field: kvm_ioapic_state__bindgen_ty_1__bindgen_ty_1::reserved"]
        [::std::mem::offset_of!(kvm_ioapic_state__bindgen_ty_1__bindgen_ty_1, reserved) - 3usize];
    ["Offset of field: kvm_ioapic_state__bindgen_ty_1__bindgen_ty_1::dest_id"]
        [::std::mem::offset_of!(kvm_ioapic_state__bindgen_ty_1__bindgen_ty_1, dest_id) - 7usize];
};
impl kvm_ioapic_state__bindgen_ty_1__bindgen_ty_1 {
    #[inline]
    pub fn delivery_mode(&self) -> __u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 3u8) as u8) }
    }
    #[inline]
    pub fn set_delivery_mode(&mut self, val: __u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub fn dest_mode(&self) -> __u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_dest_mode(&mut self, val: __u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn delivery_status(&self) -> __u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_delivery_status(&mut self, val: __u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn polarity(&self) -> __u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_polarity(&mut self, val: __u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn remote_irr(&self) -> __u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_remote_irr(&mut self, val: __u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn trig_mode(&self) -> __u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_trig_mode(&mut self, val: __u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn mask(&self) -> __u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_mask(&mut self, val: __u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn reserve(&self) -> __u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(9usize, 7u8) as u8) }
    }
    #[inline]
    pub fn set_reserve(&mut self, val: __u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(9usize, 7u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        delivery_mode: __u8,
        dest_mode: __u8,
        delivery_status: __u8,
        polarity: __u8,
        remote_irr: __u8,
        trig_mode: __u8,
        mask: __u8,
        reserve: __u8,
    ) -> __BindgenBitfieldUnit<[u8; 2usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 2usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 3u8, {
            let delivery_mode: u8 = unsafe { ::std::mem::transmute(delivery_mode) };
            delivery_mode as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let dest_mode: u8 = unsafe { ::std::mem::transmute(dest_mode) };
            dest_mode as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let delivery_status: u8 = unsafe { ::std::mem::transmute(delivery_status) };
            delivery_status as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let polarity: u8 = unsafe { ::std::mem::transmute(polarity) };
            polarity as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let remote_irr: u8 = unsafe { ::std::mem::transmute(remote_irr) };
            remote_irr as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let trig_mode: u8 = unsafe { ::std::mem::transmute(trig_mode) };
            trig_mode as u64
        });
        __bindgen_bitfield_unit.set(8usize, 1u8, {
            let mask: u8 = unsafe { ::std::mem::transmute(mask) };
            mask as u64
        });
        __bindgen_bitfield_unit.set(9usize, 7u8, {
            let reserve: u8 = unsafe { ::std::mem::transmute(reserve) };
            reserve as u64
        });
        __bindgen_bitfield_unit
    }
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_ioapic_state__bindgen_ty_1"]
        [::std::mem::size_of::<kvm_ioapic_state__bindgen_ty_1>() - 8usize];
    ["Alignment of kvm_ioapic_state__bindgen_ty_1"]
        [::std::mem::align_of::<kvm_ioapic_state__bindgen_ty_1>() - 8usize];
    ["Offset of field: kvm_ioapic_state__bindgen_ty_1::bits"]
        [::std::mem::offset_of!(kvm_ioapic_state__bindgen_ty_1, bits) - 0usize];
    ["Offset of field: kvm_ioapic_state__bindgen_ty_1::fields"]
        [::std::mem::offset_of!(kvm_ioapic_state__bindgen_ty_1, fields) - 0usize];
};
impl Default for kvm_ioapic_state__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for kvm_ioapic_state__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "kvm_ioapic_state__bindgen_ty_1 {{ union }}")
    }
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_ioapic_state"][::std::mem::size_of::<kvm_ioapic_state>() - 216usize];
    ["Alignment of kvm_ioapic_state"][::std::mem::align_of::<kvm_ioapic_state>() - 8usize];
    ["Offset of field: kvm_ioapic_state::base_address"]
        [::std::mem::offset_of!(kvm_ioapic_state, base_address) - 0usize];
    ["Offset of field: kvm_ioapic_state::ioregsel"]
        [::std::mem::offset_of!(kvm_ioapic_state, ioregsel) - 8usize];
    ["Offset of field: kvm_ioapic_state::id"]
        [::std::mem::offset_of!(kvm_ioapic_state, id) - 12usize];
    ["Offset of field: kvm_ioapic_state::irr"]
        [::std::mem::offset_of!(kvm_ioapic_state, irr) - 16usize];
    ["Offset of field: kvm_ioapic_state::pad"]
        [::std::mem::offset_of!(kvm_ioapic_state, pad) - 20usize];
    ["Offset of field: kvm_ioapic_state::redirtbl"]
        [::std::mem::offset_of!(kvm_ioapic_state, redirtbl) - 24usize];
};
impl Default for kvm_ioapic_state {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for kvm_ioapic_state {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write ! (f , "kvm_ioapic_state {{ base_address: {:?}, ioregsel: {:?}, id: {:?}, irr: {:?}, pad: {:?}, redirtbl: {:?} }}" , self . base_address , self . ioregsel , self . id , self . irr , self . pad , self . redirtbl)
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
#[cfg_attr(
    feature = "serde",
    derive(zerocopy::AsBytes, zerocopy::FromBytes, zerocopy::FromZeroes)
)]
pub struct kvm_regs {
    pub rax: __u64,
    pub rbx: __u64,
    pub rcx: __u64,
    pub rdx: __u64,
    pub rsi: __u64,
    pub rdi: __u64,
    pub rsp: __u64,
    pub rbp: __u64,
    pub r8: __u64,
    pub r9: __u64,
    pub r10: __u64,
    pub r11: __u64,
    pub r12: __u64,
    pub r13: __u64,
    pub r14: __u64,
    pub r15: __u64,
    pub rip: __u64,
    pub rflags: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_regs"][::std::mem::size_of::<kvm_regs>() - 144usize];
    ["Alignment of kvm_regs"][::std::mem::align_of::<kvm_regs>() - 8usize];
    ["Offset of field: kvm_regs::rax"][::std::mem::offset_of!(kvm_regs, rax) - 0usize];
    ["Offset of field: kvm_regs::rbx"][::std::mem::offset_of!(kvm_regs, rbx) - 8usize];
    ["Offset of field: kvm_regs::rcx"][::std::mem::offset_of!(kvm_regs, rcx) - 16usize];
    ["Offset of field: kvm_regs::rdx"][::std::mem::offset_of!(kvm_regs, rdx) - 24usize];
    ["Offset of field: kvm_regs::rsi"][::std::mem::offset_of!(kvm_regs, rsi) - 32usize];
    ["Offset of field: kvm_regs::rdi"][::std::mem::offset_of!(kvm_regs, rdi) - 40usize];
    ["Offset of field: kvm_regs::rsp"][::std::mem::offset_of!(kvm_regs, rsp) - 48usize];
    ["Offset of field: kvm_regs::rbp"][::std::mem::offset_of!(kvm_regs, rbp) - 56usize];
    ["Offset of field: kvm_regs::r8"][::std::mem::offset_of!(kvm_regs, r8) - 64usize];
    ["Offset of field: kvm_regs::r9"][::std::mem::offset_of!(kvm_regs, r9) - 72usize];
    ["Offset of field: kvm_regs::r10"][::std::mem::offset_of!(kvm_regs, r10) - 80usize];
    ["Offset of field: kvm_regs::r11"][::std::mem::offset_of!(kvm_regs, r11) - 88usize];
    ["Offset of field: kvm_regs::r12"][::std::mem::offset_of!(kvm_regs, r12) - 96usize];
    ["Offset of field: kvm_regs::r13"][::std::mem::offset_of!(kvm_regs, r13) - 104usize];
    ["Offset of field: kvm_regs::r14"][::std::mem::offset_of!(kvm_regs, r14) - 112usize];
    ["Offset of field: kvm_regs::r15"][::std::mem::offset_of!(kvm_regs, r15) - 120usize];
    ["Offset of field: kvm_regs::rip"][::std::mem::offset_of!(kvm_regs, rip) - 128usize];
    ["Offset of field: kvm_regs::rflags"][::std::mem::offset_of!(kvm_regs, rflags) - 136usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq)]
#[cfg_attr(
    feature = "serde",
    derive(zerocopy::AsBytes, zerocopy::FromBytes, zerocopy::FromZeroes)
)]
pub struct kvm_lapic_state {
    pub regs: [::std::os::raw::c_char; 1024usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_lapic_state"][::std::mem::size_of::<kvm_lapic_state>() - 1024usize];
    ["Alignment of kvm_lapic_state"][::std::mem::align_of::<kvm_lapic_state>() - 1usize];
    ["Offset of field: kvm_lapic_state::regs"]
        [::std::mem::offset_of!(kvm_lapic_state, regs) - 0usize];
};
impl Default for kvm_lapic_state {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
#[cfg_attr(
    feature = "serde",
    derive(zerocopy::AsBytes, zerocopy::FromBytes, zerocopy::FromZeroes)
)]
pub struct kvm_segment {
    pub base: __u64,
    pub limit: __u32,
    pub selector: __u16,
    pub type_: __u8,
    pub present: __u8,
    pub dpl: __u8,
    pub db: __u8,
    pub s: __u8,
    pub l: __u8,
    pub g: __u8,
    pub avl: __u8,
    pub unusable: __u8,
    pub padding: __u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_segment"][::std::mem::size_of::<kvm_segment>() - 24usize];
    ["Alignment of kvm_segment"][::std::mem::align_of::<kvm_segment>() - 8usize];
    ["Offset of field: kvm_segment::base"][::std::mem::offset_of!(kvm_segment, base) - 0usize];
    ["Offset of field: kvm_segment::limit"][::std::mem::offset_of!(kvm_segment, limit) - 8usize];
    ["Offset of field: kvm_segment::selector"]
        [::std::mem::offset_of!(kvm_segment, selector) - 12usize];
    ["Offset of field: kvm_segment::type_"][::std::mem::offset_of!(kvm_segment, type_) - 14usize];
    ["Offset of field: kvm_segment::present"]
        [::std::mem::offset_of!(kvm_segment, present) - 15usize];
    ["Offset of field: kvm_segment::dpl"][::std::mem::offset_of!(kvm_segment, dpl) - 16usize];
    ["Offset of field: kvm_segment::db"][::std::mem::offset_of!(kvm_segment, db) - 17usize];
    ["Offset of field: kvm_segment::s"][::std::mem::offset_of!(kvm_segment, s) - 18usize];
    ["Offset of field: kvm_segment::l"][::std::mem::offset_of!(kvm_segment, l) - 19usize];
    ["Offset of field: kvm_segment::g"][::std::mem::offset_of!(kvm_segment, g) - 20usize];
    ["Offset of field: kvm_segment::avl"][::std::mem::offset_of!(kvm_segment, avl) - 21usize];
    ["Offset of field: kvm_segment::unusable"]
        [::std::mem::offset_of!(kvm_segment, unusable) - 22usize];
    ["Offset of field: kvm_segment::padding"]
        [::std::mem::offset_of!(kvm_segment, padding) - 23usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
#[cfg_attr(
    feature = "serde",
    derive(zerocopy::AsBytes, zerocopy::FromBytes, zerocopy::FromZeroes)
)]
pub struct kvm_dtable {
    pub base: __u64,
    pub limit: __u16,
    pub padding: [__u16; 3usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_dtable"][::std::mem::size_of::<kvm_dtable>() - 16usize];
    ["Alignment of kvm_dtable"][::std::mem::align_of::<kvm_dtable>() - 8usize];
    ["Offset of field: kvm_dtable::base"][::std::mem::offset_of!(kvm_dtable, base) - 0usize];
    ["Offset of field: kvm_dtable::limit"][::std::mem::offset_of!(kvm_dtable, limit) - 8usize];
    ["Offset of field: kvm_dtable::padding"][::std::mem::offset_of!(kvm_dtable, padding) - 10usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
#[cfg_attr(
    feature = "serde",
    derive(zerocopy::AsBytes, zerocopy::FromBytes, zerocopy::FromZeroes)
)]
pub struct kvm_sregs {
    pub cs: kvm_segment,
    pub ds: kvm_segment,
    pub es: kvm_segment,
    pub fs: kvm_segment,
    pub gs: kvm_segment,
    pub ss: kvm_segment,
    pub tr: kvm_segment,
    pub ldt: kvm_segment,
    pub gdt: kvm_dtable,
    pub idt: kvm_dtable,
    pub cr0: __u64,
    pub cr2: __u64,
    pub cr3: __u64,
    pub cr4: __u64,
    pub cr8: __u64,
    pub efer: __u64,
    pub apic_base: __u64,
    pub interrupt_bitmap: [__u64; 4usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_sregs"][::std::mem::size_of::<kvm_sregs>() - 312usize];
    ["Alignment of kvm_sregs"][::std::mem::align_of::<kvm_sregs>() - 8usize];
    ["Offset of field: kvm_sregs::cs"][::std::mem::offset_of!(kvm_sregs, cs) - 0usize];
    ["Offset of field: kvm_sregs::ds"][::std::mem::offset_of!(kvm_sregs, ds) - 24usize];
    ["Offset of field: kvm_sregs::es"][::std::mem::offset_of!(kvm_sregs, es) - 48usize];
    ["Offset of field: kvm_sregs::fs"][::std::mem::offset_of!(kvm_sregs, fs) - 72usize];
    ["Offset of field: kvm_sregs::gs"][::std::mem::offset_of!(kvm_sregs, gs) - 96usize];
    ["Offset of field: kvm_sregs::ss"][::std::mem::offset_of!(kvm_sregs, ss) - 120usize];
    ["Offset of field: kvm_sregs::tr"][::std::mem::offset_of!(kvm_sregs, tr) - 144usize];
    ["Offset of field: kvm_sregs::ldt"][::std::mem::offset_of!(kvm_sregs, ldt) - 168usize];
    ["Offset of field: kvm_sregs::gdt"][::std::mem::offset_of!(kvm_sregs, gdt) - 192usize];
    ["Offset of field: kvm_sregs::idt"][::std::mem::offset_of!(kvm_sregs, idt) - 208usize];
    ["Offset of field: kvm_sregs::cr0"][::std::mem::offset_of!(kvm_sregs, cr0) - 224usize];
    ["Offset of field: kvm_sregs::cr2"][::std::mem::offset_of!(kvm_sregs, cr2) - 232usize];
    ["Offset of field: kvm_sregs::cr3"][::std::mem::offset_of!(kvm_sregs, cr3) - 240usize];
    ["Offset of field: kvm_sregs::cr4"][::std::mem::offset_of!(kvm_sregs, cr4) - 248usize];
    ["Offset of field: kvm_sregs::cr8"][::std::mem::offset_of!(kvm_sregs, cr8) - 256usize];
    ["Offset of field: kvm_sregs::efer"][::std::mem::offset_of!(kvm_sregs, efer) - 264usize];
    ["Offset of field: kvm_sregs::apic_base"]
        [::std::mem::offset_of!(kvm_sregs, apic_base) - 272usize];
    ["Offset of field: kvm_sregs::interrupt_bitmap"]
        [::std::mem::offset_of!(kvm_sregs, interrupt_bitmap) - 280usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_sregs2 {
    pub cs: kvm_segment,
    pub ds: kvm_segment,
    pub es: kvm_segment,
    pub fs: kvm_segment,
    pub gs: kvm_segment,
    pub ss: kvm_segment,
    pub tr: kvm_segment,
    pub ldt: kvm_segment,
    pub gdt: kvm_dtable,
    pub idt: kvm_dtable,
    pub cr0: __u64,
    pub cr2: __u64,
    pub cr3: __u64,
    pub cr4: __u64,
    pub cr8: __u64,
    pub efer: __u64,
    pub apic_base: __u64,
    pub flags: __u64,
    pub pdptrs: [__u64; 4usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_sregs2"][::std::mem::size_of::<kvm_sregs2>() - 320usize];
    ["Alignment of kvm_sregs2"][::std::mem::align_of::<kvm_sregs2>() - 8usize];
    ["Offset of field: kvm_sregs2::cs"][::std::mem::offset_of!(kvm_sregs2, cs) - 0usize];
    ["Offset of field: kvm_sregs2::ds"][::std::mem::offset_of!(kvm_sregs2, ds) - 24usize];
    ["Offset of field: kvm_sregs2::es"][::std::mem::offset_of!(kvm_sregs2, es) - 48usize];
    ["Offset of field: kvm_sregs2::fs"][::std::mem::offset_of!(kvm_sregs2, fs) - 72usize];
    ["Offset of field: kvm_sregs2::gs"][::std::mem::offset_of!(kvm_sregs2, gs) - 96usize];
    ["Offset of field: kvm_sregs2::ss"][::std::mem::offset_of!(kvm_sregs2, ss) - 120usize];
    ["Offset of field: kvm_sregs2::tr"][::std::mem::offset_of!(kvm_sregs2, tr) - 144usize];
    ["Offset of field: kvm_sregs2::ldt"][::std::mem::offset_of!(kvm_sregs2, ldt) - 168usize];
    ["Offset of field: kvm_sregs2::gdt"][::std::mem::offset_of!(kvm_sregs2, gdt) - 192usize];
    ["Offset of field: kvm_sregs2::idt"][::std::mem::offset_of!(kvm_sregs2, idt) - 208usize];
    ["Offset of field: kvm_sregs2::cr0"][::std::mem::offset_of!(kvm_sregs2, cr0) - 224usize];
    ["Offset of field: kvm_sregs2::cr2"][::std::mem::offset_of!(kvm_sregs2, cr2) - 232usize];
    ["Offset of field: kvm_sregs2::cr3"][::std::mem::offset_of!(kvm_sregs2, cr3) - 240usize];
    ["Offset of field: kvm_sregs2::cr4"][::std::mem::offset_of!(kvm_sregs2, cr4) - 248usize];
    ["Offset of field: kvm_sregs2::cr8"][::std::mem::offset_of!(kvm_sregs2, cr8) - 256usize];
    ["Offset of field: kvm_sregs2::efer"][::std::mem::offset_of!(kvm_sregs2, efer) - 264usize];
    ["Offset of field: kvm_sregs2::apic_base"]
        [::std::mem::offset_of!(kvm_sregs2, apic_base) - 272usize];
    ["Offset of field: kvm_sregs2::flags"][::std::mem::offset_of!(kvm_sregs2, flags) - 280usize];
    ["Offset of field: kvm_sregs2::pdptrs"][::std::mem::offset_of!(kvm_sregs2, pdptrs) - 288usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_fpu {
    pub fpr: [[__u8; 16usize]; 8usize],
    pub fcw: __u16,
    pub fsw: __u16,
    pub ftwx: __u8,
    pub pad1: __u8,
    pub last_opcode: __u16,
    pub last_ip: __u64,
    pub last_dp: __u64,
    pub xmm: [[__u8; 16usize]; 16usize],
    pub mxcsr: __u32,
    pub pad2: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_fpu"][::std::mem::size_of::<kvm_fpu>() - 416usize];
    ["Alignment of kvm_fpu"][::std::mem::align_of::<kvm_fpu>() - 8usize];
    ["Offset of field: kvm_fpu::fpr"][::std::mem::offset_of!(kvm_fpu, fpr) - 0usize];
    ["Offset of field: kvm_fpu::fcw"][::std::mem::offset_of!(kvm_fpu, fcw) - 128usize];
    ["Offset of field: kvm_fpu::fsw"][::std::mem::offset_of!(kvm_fpu, fsw) - 130usize];
    ["Offset of field: kvm_fpu::ftwx"][::std::mem::offset_of!(kvm_fpu, ftwx) - 132usize];
    ["Offset of field: kvm_fpu::pad1"][::std::mem::offset_of!(kvm_fpu, pad1) - 133usize];
    ["Offset of field: kvm_fpu::last_opcode"]
        [::std::mem::offset_of!(kvm_fpu, last_opcode) - 134usize];
    ["Offset of field: kvm_fpu::last_ip"][::std::mem::offset_of!(kvm_fpu, last_ip) - 136usize];
    ["Offset of field: kvm_fpu::last_dp"][::std::mem::offset_of!(kvm_fpu, last_dp) - 144usize];
    ["Offset of field: kvm_fpu::xmm"][::std::mem::offset_of!(kvm_fpu, xmm) - 152usize];
    ["Offset of field: kvm_fpu::mxcsr"][::std::mem::offset_of!(kvm_fpu, mxcsr) - 408usize];
    ["Offset of field: kvm_fpu::pad2"][::std::mem::offset_of!(kvm_fpu, pad2) - 412usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
#[cfg_attr(
    feature = "serde",
    derive(zerocopy::AsBytes, zerocopy::FromBytes, zerocopy::FromZeroes)
)]
pub struct kvm_msr_entry {
    pub index: __u32,
    pub reserved: __u32,
    pub data: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_msr_entry"][::std::mem::size_of::<kvm_msr_entry>() - 16usize];
    ["Alignment of kvm_msr_entry"][::std::mem::align_of::<kvm_msr_entry>() - 8usize];
    ["Offset of field: kvm_msr_entry::index"]
        [::std::mem::offset_of!(kvm_msr_entry, index) - 0usize];
    ["Offset of field: kvm_msr_entry::reserved"]
        [::std::mem::offset_of!(kvm_msr_entry, reserved) - 4usize];
    ["Offset of field: kvm_msr_entry::data"][::std::mem::offset_of!(kvm_msr_entry, data) - 8usize];
};
#[repr(C)]
#[derive(Debug, Default)]
#[cfg_attr(
    feature = "serde",
    derive(zerocopy::AsBytes, zerocopy::FromBytes, zerocopy::FromZeroes)
)]
pub struct kvm_msrs {
    pub nmsrs: __u32,
    pub pad: __u32,
    pub entries: __IncompleteArrayField<kvm_msr_entry>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_msrs"][::std::mem::size_of::<kvm_msrs>() - 8usize];
    ["Alignment of kvm_msrs"][::std::mem::align_of::<kvm_msrs>() - 8usize];
    ["Offset of field: kvm_msrs::nmsrs"][::std::mem::offset_of!(kvm_msrs, nmsrs) - 0usize];
    ["Offset of field: kvm_msrs::pad"][::std::mem::offset_of!(kvm_msrs, pad) - 4usize];
    ["Offset of field: kvm_msrs::entries"][::std::mem::offset_of!(kvm_msrs, entries) - 8usize];
};
#[repr(C)]
#[derive(Debug, Default)]
pub struct kvm_msr_list {
    pub nmsrs: __u32,
    pub indices: __IncompleteArrayField<__u32>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_msr_list"][::std::mem::size_of::<kvm_msr_list>() - 4usize];
    ["Alignment of kvm_msr_list"][::std::mem::align_of::<kvm_msr_list>() - 4usize];
    ["Offset of field: kvm_msr_list::nmsrs"][::std::mem::offset_of!(kvm_msr_list, nmsrs) - 0usize];
    ["Offset of field: kvm_msr_list::indices"]
        [::std::mem::offset_of!(kvm_msr_list, indices) - 4usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq)]
pub struct kvm_msr_filter_range {
    pub flags: __u32,
    pub nmsrs: __u32,
    pub base: __u32,
    pub bitmap: *mut __u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_msr_filter_range"][::std::mem::size_of::<kvm_msr_filter_range>() - 24usize];
    ["Alignment of kvm_msr_filter_range"][::std::mem::align_of::<kvm_msr_filter_range>() - 8usize];
    ["Offset of field: kvm_msr_filter_range::flags"]
        [::std::mem::offset_of!(kvm_msr_filter_range, flags) - 0usize];
    ["Offset of field: kvm_msr_filter_range::nmsrs"]
        [::std::mem::offset_of!(kvm_msr_filter_range, nmsrs) - 4usize];
    ["Offset of field: kvm_msr_filter_range::base"]
        [::std::mem::offset_of!(kvm_msr_filter_range, base) - 8usize];
    ["Offset of field: kvm_msr_filter_range::bitmap"]
        [::std::mem::offset_of!(kvm_msr_filter_range, bitmap) - 16usize];
};
impl Default for kvm_msr_filter_range {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq)]
pub struct kvm_msr_filter {
    pub flags: __u32,
    pub ranges: [kvm_msr_filter_range; 16usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_msr_filter"][::std::mem::size_of::<kvm_msr_filter>() - 392usize];
    ["Alignment of kvm_msr_filter"][::std::mem::align_of::<kvm_msr_filter>() - 8usize];
    ["Offset of field: kvm_msr_filter::flags"]
        [::std::mem::offset_of!(kvm_msr_filter, flags) - 0usize];
    ["Offset of field: kvm_msr_filter::ranges"]
        [::std::mem::offset_of!(kvm_msr_filter, ranges) - 8usize];
};
impl Default for kvm_msr_filter {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_cpuid_entry {
    pub function: __u32,
    pub eax: __u32,
    pub ebx: __u32,
    pub ecx: __u32,
    pub edx: __u32,
    pub padding: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_cpuid_entry"][::std::mem::size_of::<kvm_cpuid_entry>() - 24usize];
    ["Alignment of kvm_cpuid_entry"][::std::mem::align_of::<kvm_cpuid_entry>() - 4usize];
    ["Offset of field: kvm_cpuid_entry::function"]
        [::std::mem::offset_of!(kvm_cpuid_entry, function) - 0usize];
    ["Offset of field: kvm_cpuid_entry::eax"]
        [::std::mem::offset_of!(kvm_cpuid_entry, eax) - 4usize];
    ["Offset of field: kvm_cpuid_entry::ebx"]
        [::std::mem::offset_of!(kvm_cpuid_entry, ebx) - 8usize];
    ["Offset of field: kvm_cpuid_entry::ecx"]
        [::std::mem::offset_of!(kvm_cpuid_entry, ecx) - 12usize];
    ["Offset of field: kvm_cpuid_entry::edx"]
        [::std::mem::offset_of!(kvm_cpuid_entry, edx) - 16usize];
    ["Offset of field: kvm_cpuid_entry::padding"]
        [::std::mem::offset_of!(kvm_cpuid_entry, padding) - 20usize];
};
#[repr(C)]
#[derive(Debug, Default)]
pub struct kvm_cpuid {
    pub nent: __u32,
    pub padding: __u32,
    pub entries: __IncompleteArrayField<kvm_cpuid_entry>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_cpuid"][::std::mem::size_of::<kvm_cpuid>() - 8usize];
    ["Alignment of kvm_cpuid"][::std::mem::align_of::<kvm_cpuid>() - 4usize];
    ["Offset of field: kvm_cpuid::nent"][::std::mem::offset_of!(kvm_cpuid, nent) - 0usize];
    ["Offset of field: kvm_cpuid::padding"][::std::mem::offset_of!(kvm_cpuid, padding) - 4usize];
    ["Offset of field: kvm_cpuid::entries"][::std::mem::offset_of!(kvm_cpuid, entries) - 8usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
#[cfg_attr(
    feature = "serde",
    derive(zerocopy::AsBytes, zerocopy::FromBytes, zerocopy::FromZeroes)
)]
pub struct kvm_cpuid_entry2 {
    pub function: __u32,
    pub index: __u32,
    pub flags: __u32,
    pub eax: __u32,
    pub ebx: __u32,
    pub ecx: __u32,
    pub edx: __u32,
    pub padding: [__u32; 3usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_cpuid_entry2"][::std::mem::size_of::<kvm_cpuid_entry2>() - 40usize];
    ["Alignment of kvm_cpuid_entry2"][::std::mem::align_of::<kvm_cpuid_entry2>() - 4usize];
    ["Offset of field: kvm_cpuid_entry2::function"]
        [::std::mem::offset_of!(kvm_cpuid_entry2, function) - 0usize];
    ["Offset of field: kvm_cpuid_entry2::index"]
        [::std::mem::offset_of!(kvm_cpuid_entry2, index) - 4usize];
    ["Offset of field: kvm_cpuid_entry2::flags"]
        [::std::mem::offset_of!(kvm_cpuid_entry2, flags) - 8usize];
    ["Offset of field: kvm_cpuid_entry2::eax"]
        [::std::mem::offset_of!(kvm_cpuid_entry2, eax) - 12usize];
    ["Offset of field: kvm_cpuid_entry2::ebx"]
        [::std::mem::offset_of!(kvm_cpuid_entry2, ebx) - 16usize];
    ["Offset of field: kvm_cpuid_entry2::ecx"]
        [::std::mem::offset_of!(kvm_cpuid_entry2, ecx) - 20usize];
    ["Offset of field: kvm_cpuid_entry2::edx"]
        [::std::mem::offset_of!(kvm_cpuid_entry2, edx) - 24usize];
    ["Offset of field: kvm_cpuid_entry2::padding"]
        [::std::mem::offset_of!(kvm_cpuid_entry2, padding) - 28usize];
};
#[repr(C)]
#[derive(Debug, Default)]
#[cfg_attr(
    feature = "serde",
    derive(zerocopy::AsBytes, zerocopy::FromBytes, zerocopy::FromZeroes)
)]
pub struct kvm_cpuid2 {
    pub nent: __u32,
    pub padding: __u32,
    pub entries: __IncompleteArrayField<kvm_cpuid_entry2>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_cpuid2"][::std::mem::size_of::<kvm_cpuid2>() - 8usize];
    ["Alignment of kvm_cpuid2"][::std::mem::align_of::<kvm_cpuid2>() - 4usize];
    ["Offset of field: kvm_cpuid2::nent"][::std::mem::offset_of!(kvm_cpuid2, nent) - 0usize];
    ["Offset of field: kvm_cpuid2::padding"][::std::mem::offset_of!(kvm_cpuid2, padding) - 4usize];
    ["Offset of field: kvm_cpuid2::entries"][::std::mem::offset_of!(kvm_cpuid2, entries) - 8usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
#[cfg_attr(
    feature = "serde",
    derive(zerocopy::AsBytes, zerocopy::FromBytes, zerocopy::FromZeroes)
)]
pub struct kvm_pit_channel_state {
    pub count: __u32,
    pub latched_count: __u16,
    pub count_latched: __u8,
    pub status_latched: __u8,
    pub status: __u8,
    pub read_state: __u8,
    pub write_state: __u8,
    pub write_latch: __u8,
    pub rw_mode: __u8,
    pub mode: __u8,
    pub bcd: __u8,
    pub gate: __u8,
    pub count_load_time: __s64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_pit_channel_state"][::std::mem::size_of::<kvm_pit_channel_state>() - 24usize];
    ["Alignment of kvm_pit_channel_state"]
        [::std::mem::align_of::<kvm_pit_channel_state>() - 8usize];
    ["Offset of field: kvm_pit_channel_state::count"]
        [::std::mem::offset_of!(kvm_pit_channel_state, count) - 0usize];
    ["Offset of field: kvm_pit_channel_state::latched_count"]
        [::std::mem::offset_of!(kvm_pit_channel_state, latched_count) - 4usize];
    ["Offset of field: kvm_pit_channel_state::count_latched"]
        [::std::mem::offset_of!(kvm_pit_channel_state, count_latched) - 6usize];
    ["Offset of field: kvm_pit_channel_state::status_latched"]
        [::std::mem::offset_of!(kvm_pit_channel_state, status_latched) - 7usize];
    ["Offset of field: kvm_pit_channel_state::status"]
        [::std::mem::offset_of!(kvm_pit_channel_state, status) - 8usize];
    ["Offset of field: kvm_pit_channel_state::read_state"]
        [::std::mem::offset_of!(kvm_pit_channel_state, read_state) - 9usize];
    ["Offset of field: kvm_pit_channel_state::write_state"]
        [::std::mem::offset_of!(kvm_pit_channel_state, write_state) - 10usize];
    ["Offset of field: kvm_pit_channel_state::write_latch"]
        [::std::mem::offset_of!(kvm_pit_channel_state, write_latch) - 11usize];
    ["Offset of field: kvm_pit_channel_state::rw_mode"]
        [::std::mem::offset_of!(kvm_pit_channel_state, rw_mode) - 12usize];
    ["Offset of field: kvm_pit_channel_state::mode"]
        [::std::mem::offset_of!(kvm_pit_channel_state, mode) - 13usize];
    ["Offset of field: kvm_pit_channel_state::bcd"]
        [::std::mem::offset_of!(kvm_pit_channel_state, bcd) - 14usize];
    ["Offset of field: kvm_pit_channel_state::gate"]
        [::std::mem::offset_of!(kvm_pit_channel_state, gate) - 15usize];
    ["Offset of field: kvm_pit_channel_state::count_load_time"]
        [::std::mem::offset_of!(kvm_pit_channel_state, count_load_time) - 16usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_debug_exit_arch {
    pub exception: __u32,
    pub pad: __u32,
    pub pc: __u64,
    pub dr6: __u64,
    pub dr7: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_debug_exit_arch"][::std::mem::size_of::<kvm_debug_exit_arch>() - 32usize];
    ["Alignment of kvm_debug_exit_arch"][::std::mem::align_of::<kvm_debug_exit_arch>() - 8usize];
    ["Offset of field: kvm_debug_exit_arch::exception"]
        [::std::mem::offset_of!(kvm_debug_exit_arch, exception) - 0usize];
    ["Offset of field: kvm_debug_exit_arch::pad"]
        [::std::mem::offset_of!(kvm_debug_exit_arch, pad) - 4usize];
    ["Offset of field: kvm_debug_exit_arch::pc"]
        [::std::mem::offset_of!(kvm_debug_exit_arch, pc) - 8usize];
    ["Offset of field: kvm_debug_exit_arch::dr6"]
        [::std::mem::offset_of!(kvm_debug_exit_arch, dr6) - 16usize];
    ["Offset of field: kvm_debug_exit_arch::dr7"]
        [::std::mem::offset_of!(kvm_debug_exit_arch, dr7) - 24usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_guest_debug_arch {
    pub debugreg: [__u64; 8usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_guest_debug_arch"][::std::mem::size_of::<kvm_guest_debug_arch>() - 64usize];
    ["Alignment of kvm_guest_debug_arch"][::std::mem::align_of::<kvm_guest_debug_arch>() - 8usize];
    ["Offset of field: kvm_guest_debug_arch::debugreg"]
        [::std::mem::offset_of!(kvm_guest_debug_arch, debugreg) - 0usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_pit_state {
    pub channels: [kvm_pit_channel_state; 3usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_pit_state"][::std::mem::size_of::<kvm_pit_state>() - 72usize];
    ["Alignment of kvm_pit_state"][::std::mem::align_of::<kvm_pit_state>() - 8usize];
    ["Offset of field: kvm_pit_state::channels"]
        [::std::mem::offset_of!(kvm_pit_state, channels) - 0usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
#[cfg_attr(
    feature = "serde",
    derive(zerocopy::AsBytes, zerocopy::FromBytes, zerocopy::FromZeroes)
)]
pub struct kvm_pit_state2 {
    pub channels: [kvm_pit_channel_state; 3usize],
    pub flags: __u32,
    pub reserved: [__u32; 9usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_pit_state2"][::std::mem::size_of::<kvm_pit_state2>() - 112usize];
    ["Alignment of kvm_pit_state2"][::std::mem::align_of::<kvm_pit_state2>() - 8usize];
    ["Offset of field: kvm_pit_state2::channels"]
        [::std::mem::offset_of!(kvm_pit_state2, channels) - 0usize];
    ["Offset of field: kvm_pit_state2::flags"]
        [::std::mem::offset_of!(kvm_pit_state2, flags) - 72usize];
    ["Offset of field: kvm_pit_state2::reserved"]
        [::std::mem::offset_of!(kvm_pit_state2, reserved) - 76usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_reinject_control {
    pub pit_reinject: __u8,
    pub reserved: [__u8; 31usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_reinject_control"][::std::mem::size_of::<kvm_reinject_control>() - 32usize];
    ["Alignment of kvm_reinject_control"][::std::mem::align_of::<kvm_reinject_control>() - 1usize];
    ["Offset of field: kvm_reinject_control::pit_reinject"]
        [::std::mem::offset_of!(kvm_reinject_control, pit_reinject) - 0usize];
    ["Offset of field: kvm_reinject_control::reserved"]
        [::std::mem::offset_of!(kvm_reinject_control, reserved) - 1usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
#[cfg_attr(
    feature = "serde",
    derive(zerocopy::AsBytes, zerocopy::FromBytes, zerocopy::FromZeroes)
)]
pub struct kvm_vcpu_events {
    pub exception: kvm_vcpu_events__bindgen_ty_1,
    pub interrupt: kvm_vcpu_events__bindgen_ty_2,
    pub nmi: kvm_vcpu_events__bindgen_ty_3,
    pub sipi_vector: __u32,
    pub flags: __u32,
    pub smi: kvm_vcpu_events__bindgen_ty_4,
    pub triple_fault: kvm_vcpu_events__bindgen_ty_5,
    pub reserved: [__u8; 26usize],
    pub exception_has_payload: __u8,
    pub exception_payload: __u64,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
#[cfg_attr(
    feature = "serde",
    derive(zerocopy::AsBytes, zerocopy::FromBytes, zerocopy::FromZeroes)
)]
pub struct kvm_vcpu_events__bindgen_ty_1 {
    pub injected: __u8,
    pub nr: __u8,
    pub has_error_code: __u8,
    pub pending: __u8,
    pub error_code: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_vcpu_events__bindgen_ty_1"]
        [::std::mem::size_of::<kvm_vcpu_events__bindgen_ty_1>() - 8usize];
    ["Alignment of kvm_vcpu_events__bindgen_ty_1"]
        [::std::mem::align_of::<kvm_vcpu_events__bindgen_ty_1>() - 4usize];
    ["Offset of field: kvm_vcpu_events__bindgen_ty_1::injected"]
        [::std::mem::offset_of!(kvm_vcpu_events__bindgen_ty_1, injected) - 0usize];
    ["Offset of field: kvm_vcpu_events__bindgen_ty_1::nr"]
        [::std::mem::offset_of!(kvm_vcpu_events__bindgen_ty_1, nr) - 1usize];
    ["Offset of field: kvm_vcpu_events__bindgen_ty_1::has_error_code"]
        [::std::mem::offset_of!(kvm_vcpu_events__bindgen_ty_1, has_error_code) - 2usize];
    ["Offset of field: kvm_vcpu_events__bindgen_ty_1::pending"]
        [::std::mem::offset_of!(kvm_vcpu_events__bindgen_ty_1, pending) - 3usize];
    ["Offset of field: kvm_vcpu_events__bindgen_ty_1::error_code"]
        [::std::mem::offset_of!(kvm_vcpu_events__bindgen_ty_1, error_code) - 4usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
#[cfg_attr(
    feature = "serde",
    derive(zerocopy::AsBytes, zerocopy::FromBytes, zerocopy::FromZeroes)
)]
pub struct kvm_vcpu_events__bindgen_ty_2 {
    pub injected: __u8,
    pub nr: __u8,
    pub soft: __u8,
    pub shadow: __u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_vcpu_events__bindgen_ty_2"]
        [::std::mem::size_of::<kvm_vcpu_events__bindgen_ty_2>() - 4usize];
    ["Alignment of kvm_vcpu_events__bindgen_ty_2"]
        [::std::mem::align_of::<kvm_vcpu_events__bindgen_ty_2>() - 1usize];
    ["Offset of field: kvm_vcpu_events__bindgen_ty_2::injected"]
        [::std::mem::offset_of!(kvm_vcpu_events__bindgen_ty_2, injected) - 0usize];
    ["Offset of field: kvm_vcpu_events__bindgen_ty_2::nr"]
        [::std::mem::offset_of!(kvm_vcpu_events__bindgen_ty_2, nr) - 1usize];
    ["Offset of field: kvm_vcpu_events__bindgen_ty_2::soft"]
        [::std::mem::offset_of!(kvm_vcpu_events__bindgen_ty_2, soft) - 2usize];
    ["Offset of field: kvm_vcpu_events__bindgen_ty_2::shadow"]
        [::std::mem::offset_of!(kvm_vcpu_events__bindgen_ty_2, shadow) - 3usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
#[cfg_attr(
    feature = "serde",
    derive(zerocopy::AsBytes, zerocopy::FromBytes, zerocopy::FromZeroes)
)]
pub struct kvm_vcpu_events__bindgen_ty_3 {
    pub injected: __u8,
    pub pending: __u8,
    pub masked: __u8,
    pub pad: __u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_vcpu_events__bindgen_ty_3"]
        [::std::mem::size_of::<kvm_vcpu_events__bindgen_ty_3>() - 4usize];
    ["Alignment of kvm_vcpu_events__bindgen_ty_3"]
        [::std::mem::align_of::<kvm_vcpu_events__bindgen_ty_3>() - 1usize];
    ["Offset of field: kvm_vcpu_events__bindgen_ty_3::injected"]
        [::std::mem::offset_of!(kvm_vcpu_events__bindgen_ty_3, injected) - 0usize];
    ["Offset of field: kvm_vcpu_events__bindgen_ty_3::pending"]
        [::std::mem::offset_of!(kvm_vcpu_events__bindgen_ty_3, pending) - 1usize];
    ["Offset of field: kvm_vcpu_events__bindgen_ty_3::masked"]
        [::std::mem::offset_of!(kvm_vcpu_events__bindgen_ty_3, masked) - 2usize];
    ["Offset of field: kvm_vcpu_events__bindgen_ty_3::pad"]
        [::std::mem::offset_of!(kvm_vcpu_events__bindgen_ty_3, pad) - 3usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
#[cfg_attr(
    feature = "serde",
    derive(zerocopy::AsBytes, zerocopy::FromBytes, zerocopy::FromZeroes)
)]
pub struct kvm_vcpu_events__bindgen_ty_4 {
    pub smm: __u8,
    pub pending: __u8,
    pub smm_inside_nmi: __u8,
    pub latched_init: __u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_vcpu_events__bindgen_ty_4"]
        [::std::mem::size_of::<kvm_vcpu_events__bindgen_ty_4>() - 4usize];
    ["Alignment of kvm_vcpu_events__bindgen_ty_4"]
        [::std::mem::align_of::<kvm_vcpu_events__bindgen_ty_4>() - 1usize];
    ["Offset of field: kvm_vcpu_events__bindgen_ty_4::smm"]
        [::std::mem::offset_of!(kvm_vcpu_events__bindgen_ty_4, smm) - 0usize];
    ["Offset of field: kvm_vcpu_events__bindgen_ty_4::pending"]
        [::std::mem::offset_of!(kvm_vcpu_events__bindgen_ty_4, pending) - 1usize];
    ["Offset of field: kvm_vcpu_events__bindgen_ty_4::smm_inside_nmi"]
        [::std::mem::offset_of!(kvm_vcpu_events__bindgen_ty_4, smm_inside_nmi) - 2usize];
    ["Offset of field: kvm_vcpu_events__bindgen_ty_4::latched_init"]
        [::std::mem::offset_of!(kvm_vcpu_events__bindgen_ty_4, latched_init) - 3usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
#[cfg_attr(
    feature = "serde",
    derive(zerocopy::AsBytes, zerocopy::FromBytes, zerocopy::FromZeroes)
)]
pub struct kvm_vcpu_events__bindgen_ty_5 {
    pub pending: __u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_vcpu_events__bindgen_ty_5"]
        [::std::mem::size_of::<kvm_vcpu_events__bindgen_ty_5>() - 1usize];
    ["Alignment of kvm_vcpu_events__bindgen_ty_5"]
        [::std::mem::align_of::<kvm_vcpu_events__bindgen_ty_5>() - 1usize];
    ["Offset of field: kvm_vcpu_events__bindgen_ty_5::pending"]
        [::std::mem::offset_of!(kvm_vcpu_events__bindgen_ty_5, pending) - 0usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_vcpu_events"][::std::mem::size_of::<kvm_vcpu_events>() - 64usize];
    ["Alignment of kvm_vcpu_events"][::std::mem::align_of::<kvm_vcpu_events>() - 8usize];
    ["Offset of field: kvm_vcpu_events::exception"]
        [::std::mem::offset_of!(kvm_vcpu_events, exception) - 0usize];
    ["Offset of field: kvm_vcpu_events::interrupt"]
        [::std::mem::offset_of!(kvm_vcpu_events, interrupt) - 8usize];
    ["Offset of field: kvm_vcpu_events::nmi"]
        [::std::mem::offset_of!(kvm_vcpu_events, nmi) - 12usize];
    ["Offset of field: kvm_vcpu_events::sipi_vector"]
        [::std::mem::offset_of!(kvm_vcpu_events, sipi_vector) - 16usize];
    ["Offset of field: kvm_vcpu_events::flags"]
        [::std::mem::offset_of!(kvm_vcpu_events, flags) - 20usize];
    ["Offset of field: kvm_vcpu_events::smi"]
        [::std::mem::offset_of!(kvm_vcpu_events, smi) - 24usize];
    ["Offset of field: kvm_vcpu_events::triple_fault"]
        [::std::mem::offset_of!(kvm_vcpu_events, triple_fault) - 28usize];
    ["Offset of field: kvm_vcpu_events::reserved"]
        [::std::mem::offset_of!(kvm_vcpu_events, reserved) - 29usize];
    ["Offset of field: kvm_vcpu_events::exception_has_payload"]
        [::std::mem::offset_of!(kvm_vcpu_events, exception_has_payload) - 55usize];
    ["Offset of field: kvm_vcpu_events::exception_payload"]
        [::std::mem::offset_of!(kvm_vcpu_events, exception_payload) - 56usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
#[cfg_attr(
    feature = "serde",
    derive(zerocopy::AsBytes, zerocopy::FromBytes, zerocopy::FromZeroes)
)]
pub struct kvm_debugregs {
    pub db: [__u64; 4usize],
    pub dr6: __u64,
    pub dr7: __u64,
    pub flags: __u64,
    pub reserved: [__u64; 9usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_debugregs"][::std::mem::size_of::<kvm_debugregs>() - 128usize];
    ["Alignment of kvm_debugregs"][::std::mem::align_of::<kvm_debugregs>() - 8usize];
    ["Offset of field: kvm_debugregs::db"][::std::mem::offset_of!(kvm_debugregs, db) - 0usize];
    ["Offset of field: kvm_debugregs::dr6"][::std::mem::offset_of!(kvm_debugregs, dr6) - 32usize];
    ["Offset of field: kvm_debugregs::dr7"][::std::mem::offset_of!(kvm_debugregs, dr7) - 40usize];
    ["Offset of field: kvm_debugregs::flags"]
        [::std::mem::offset_of!(kvm_debugregs, flags) - 48usize];
    ["Offset of field: kvm_debugregs::reserved"]
        [::std::mem::offset_of!(kvm_debugregs, reserved) - 56usize];
};
#[repr(C)]
#[derive(Debug)]
#[cfg_attr(
    feature = "serde",
    derive(zerocopy::AsBytes, zerocopy::FromBytes, zerocopy::FromZeroes)
)]
pub struct kvm_xsave {
    pub region: [__u32; 1024usize],
    pub extra: __IncompleteArrayField<__u32>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_xsave"][::std::mem::size_of::<kvm_xsave>() - 4096usize];
    ["Alignment of kvm_xsave"][::std::mem::align_of::<kvm_xsave>() - 4usize];
    ["Offset of field: kvm_xsave::region"][::std::mem::offset_of!(kvm_xsave, region) - 0usize];
    ["Offset of field: kvm_xsave::extra"][::std::mem::offset_of!(kvm_xsave, extra) - 4096usize];
};
impl Default for kvm_xsave {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
#[cfg_attr(
    feature = "serde",
    derive(zerocopy::AsBytes, zerocopy::FromBytes, zerocopy::FromZeroes)
)]
pub struct kvm_xcr {
    pub xcr: __u32,
    pub reserved: __u32,
    pub value: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_xcr"][::std::mem::size_of::<kvm_xcr>() - 16usize];
    ["Alignment of kvm_xcr"][::std::mem::align_of::<kvm_xcr>() - 8usize];
    ["Offset of field: kvm_xcr::xcr"][::std::mem::offset_of!(kvm_xcr, xcr) - 0usize];
    ["Offset of field: kvm_xcr::reserved"][::std::mem::offset_of!(kvm_xcr, reserved) - 4usize];
    ["Offset of field: kvm_xcr::value"][::std::mem::offset_of!(kvm_xcr, value) - 8usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
#[cfg_attr(
    feature = "serde",
    derive(zerocopy::AsBytes, zerocopy::FromBytes, zerocopy::FromZeroes)
)]
pub struct kvm_xcrs {
    pub nr_xcrs: __u32,
    pub flags: __u32,
    pub xcrs: [kvm_xcr; 16usize],
    pub padding: [__u64; 16usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_xcrs"][::std::mem::size_of::<kvm_xcrs>() - 392usize];
    ["Alignment of kvm_xcrs"][::std::mem::align_of::<kvm_xcrs>() - 8usize];
    ["Offset of field: kvm_xcrs::nr_xcrs"][::std::mem::offset_of!(kvm_xcrs, nr_xcrs) - 0usize];
    ["Offset of field: kvm_xcrs::flags"][::std::mem::offset_of!(kvm_xcrs, flags) - 4usize];
    ["Offset of field: kvm_xcrs::xcrs"][::std::mem::offset_of!(kvm_xcrs, xcrs) - 8usize];
    ["Offset of field: kvm_xcrs::padding"][::std::mem::offset_of!(kvm_xcrs, padding) - 264usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_sync_regs {
    pub regs: kvm_regs,
    pub sregs: kvm_sregs,
    pub events: kvm_vcpu_events,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_sync_regs"][::std::mem::size_of::<kvm_sync_regs>() - 520usize];
    ["Alignment of kvm_sync_regs"][::std::mem::align_of::<kvm_sync_regs>() - 8usize];
    ["Offset of field: kvm_sync_regs::regs"][::std::mem::offset_of!(kvm_sync_regs, regs) - 0usize];
    ["Offset of field: kvm_sync_regs::sregs"]
        [::std::mem::offset_of!(kvm_sync_regs, sregs) - 144usize];
    ["Offset of field: kvm_sync_regs::events"]
        [::std::mem::offset_of!(kvm_sync_regs, events) - 456usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq)]
pub struct kvm_vmx_nested_state_data {
    pub vmcs12: [__u8; 4096usize],
    pub shadow_vmcs12: [__u8; 4096usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_vmx_nested_state_data"]
        [::std::mem::size_of::<kvm_vmx_nested_state_data>() - 8192usize];
    ["Alignment of kvm_vmx_nested_state_data"]
        [::std::mem::align_of::<kvm_vmx_nested_state_data>() - 1usize];
    ["Offset of field: kvm_vmx_nested_state_data::vmcs12"]
        [::std::mem::offset_of!(kvm_vmx_nested_state_data, vmcs12) - 0usize];
    ["Offset of field: kvm_vmx_nested_state_data::shadow_vmcs12"]
        [::std::mem::offset_of!(kvm_vmx_nested_state_data, shadow_vmcs12) - 4096usize];
};
impl Default for kvm_vmx_nested_state_data {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_vmx_nested_state_hdr {
    pub vmxon_pa: __u64,
    pub vmcs12_pa: __u64,
    pub smm: kvm_vmx_nested_state_hdr__bindgen_ty_1,
    pub pad: __u16,
    pub flags: __u32,
    pub preemption_timer_deadline: __u64,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_vmx_nested_state_hdr__bindgen_ty_1 {
    pub flags: __u16,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_vmx_nested_state_hdr__bindgen_ty_1"]
        [::std::mem::size_of::<kvm_vmx_nested_state_hdr__bindgen_ty_1>() - 2usize];
    ["Alignment of kvm_vmx_nested_state_hdr__bindgen_ty_1"]
        [::std::mem::align_of::<kvm_vmx_nested_state_hdr__bindgen_ty_1>() - 2usize];
    ["Offset of field: kvm_vmx_nested_state_hdr__bindgen_ty_1::flags"]
        [::std::mem::offset_of!(kvm_vmx_nested_state_hdr__bindgen_ty_1, flags) - 0usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_vmx_nested_state_hdr"]
        [::std::mem::size_of::<kvm_vmx_nested_state_hdr>() - 32usize];
    ["Alignment of kvm_vmx_nested_state_hdr"]
        [::std::mem::align_of::<kvm_vmx_nested_state_hdr>() - 8usize];
    ["Offset of field: kvm_vmx_nested_state_hdr::vmxon_pa"]
        [::std::mem::offset_of!(kvm_vmx_nested_state_hdr, vmxon_pa) - 0usize];
    ["Offset of field: kvm_vmx_nested_state_hdr::vmcs12_pa"]
        [::std::mem::offset_of!(kvm_vmx_nested_state_hdr, vmcs12_pa) - 8usize];
    ["Offset of field: kvm_vmx_nested_state_hdr::smm"]
        [::std::mem::offset_of!(kvm_vmx_nested_state_hdr, smm) - 16usize];
    ["Offset of field: kvm_vmx_nested_state_hdr::pad"]
        [::std::mem::offset_of!(kvm_vmx_nested_state_hdr, pad) - 18usize];
    ["Offset of field: kvm_vmx_nested_state_hdr::flags"]
        [::std::mem::offset_of!(kvm_vmx_nested_state_hdr, flags) - 20usize];
    ["Offset of field: kvm_vmx_nested_state_hdr::preemption_timer_deadline"]
        [::std::mem::offset_of!(kvm_vmx_nested_state_hdr, preemption_timer_deadline) - 24usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq)]
pub struct kvm_svm_nested_state_data {
    pub vmcb12: [__u8; 4096usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_svm_nested_state_data"]
        [::std::mem::size_of::<kvm_svm_nested_state_data>() - 4096usize];
    ["Alignment of kvm_svm_nested_state_data"]
        [::std::mem::align_of::<kvm_svm_nested_state_data>() - 1usize];
    ["Offset of field: kvm_svm_nested_state_data::vmcb12"]
        [::std::mem::offset_of!(kvm_svm_nested_state_data, vmcb12) - 0usize];
};
impl Default for kvm_svm_nested_state_data {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_svm_nested_state_hdr {
    pub vmcb_pa: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_svm_nested_state_hdr"]
        [::std::mem::size_of::<kvm_svm_nested_state_hdr>() - 8usize];
    ["Alignment of kvm_svm_nested_state_hdr"]
        [::std::mem::align_of::<kvm_svm_nested_state_hdr>() - 8usize];
    ["Offset of field: kvm_svm_nested_state_hdr::vmcb_pa"]
        [::std::mem::offset_of!(kvm_svm_nested_state_hdr, vmcb_pa) - 0usize];
};
#[repr(C)]
pub struct kvm_nested_state {
    pub flags: __u16,
    pub format: __u16,
    pub size: __u32,
    pub hdr: kvm_nested_state__bindgen_ty_1,
    pub data: kvm_nested_state__bindgen_ty_2,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union kvm_nested_state__bindgen_ty_1 {
    pub vmx: kvm_vmx_nested_state_hdr,
    pub svm: kvm_svm_nested_state_hdr,
    pub pad: [__u8; 120usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_nested_state__bindgen_ty_1"]
        [::std::mem::size_of::<kvm_nested_state__bindgen_ty_1>() - 120usize];
    ["Alignment of kvm_nested_state__bindgen_ty_1"]
        [::std::mem::align_of::<kvm_nested_state__bindgen_ty_1>() - 8usize];
    ["Offset of field: kvm_nested_state__bindgen_ty_1::vmx"]
        [::std::mem::offset_of!(kvm_nested_state__bindgen_ty_1, vmx) - 0usize];
    ["Offset of field: kvm_nested_state__bindgen_ty_1::svm"]
        [::std::mem::offset_of!(kvm_nested_state__bindgen_ty_1, svm) - 0usize];
    ["Offset of field: kvm_nested_state__bindgen_ty_1::pad"]
        [::std::mem::offset_of!(kvm_nested_state__bindgen_ty_1, pad) - 0usize];
};
impl Default for kvm_nested_state__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for kvm_nested_state__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "kvm_nested_state__bindgen_ty_1 {{ union }}")
    }
}
#[repr(C)]
pub struct kvm_nested_state__bindgen_ty_2 {
    pub __bindgen_anon_1: __BindgenUnionField<kvm_nested_state__bindgen_ty_2__bindgen_ty_1>,
    pub __bindgen_anon_2: __BindgenUnionField<kvm_nested_state__bindgen_ty_2__bindgen_ty_2>,
    pub bindgen_union_field: [u8; 0usize],
}
#[repr(C)]
#[derive(Debug)]
pub struct kvm_nested_state__bindgen_ty_2__bindgen_ty_1 {
    pub __empty_vmx: kvm_nested_state__bindgen_ty_2__bindgen_ty_1__bindgen_ty_1,
    pub vmx: __IncompleteArrayField<kvm_vmx_nested_state_data>,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_nested_state__bindgen_ty_2__bindgen_ty_1__bindgen_ty_1 {}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_nested_state__bindgen_ty_2__bindgen_ty_1__bindgen_ty_1"][::std::mem::size_of::<
        kvm_nested_state__bindgen_ty_2__bindgen_ty_1__bindgen_ty_1,
    >() - 0usize];
    ["Alignment of kvm_nested_state__bindgen_ty_2__bindgen_ty_1__bindgen_ty_1"][::std::mem::align_of::<
        kvm_nested_state__bindgen_ty_2__bindgen_ty_1__bindgen_ty_1,
    >() - 1usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_nested_state__bindgen_ty_2__bindgen_ty_1"]
        [::std::mem::size_of::<kvm_nested_state__bindgen_ty_2__bindgen_ty_1>() - 0usize];
    ["Alignment of kvm_nested_state__bindgen_ty_2__bindgen_ty_1"]
        [::std::mem::align_of::<kvm_nested_state__bindgen_ty_2__bindgen_ty_1>() - 1usize];
    ["Offset of field: kvm_nested_state__bindgen_ty_2__bindgen_ty_1::__empty_vmx"][::std::mem::offset_of!(
        kvm_nested_state__bindgen_ty_2__bindgen_ty_1,
        __empty_vmx
    ) - 0usize];
    ["Offset of field: kvm_nested_state__bindgen_ty_2__bindgen_ty_1::vmx"]
        [::std::mem::offset_of!(kvm_nested_state__bindgen_ty_2__bindgen_ty_1, vmx) - 0usize];
};
impl Default for kvm_nested_state__bindgen_ty_2__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug)]
pub struct kvm_nested_state__bindgen_ty_2__bindgen_ty_2 {
    pub __empty_svm: kvm_nested_state__bindgen_ty_2__bindgen_ty_2__bindgen_ty_1,
    pub svm: __IncompleteArrayField<kvm_svm_nested_state_data>,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_nested_state__bindgen_ty_2__bindgen_ty_2__bindgen_ty_1 {}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_nested_state__bindgen_ty_2__bindgen_ty_2__bindgen_ty_1"][::std::mem::size_of::<
        kvm_nested_state__bindgen_ty_2__bindgen_ty_2__bindgen_ty_1,
    >() - 0usize];
    ["Alignment of kvm_nested_state__bindgen_ty_2__bindgen_ty_2__bindgen_ty_1"][::std::mem::align_of::<
        kvm_nested_state__bindgen_ty_2__bindgen_ty_2__bindgen_ty_1,
    >() - 1usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_nested_state__bindgen_ty_2__bindgen_ty_2"]
        [::std::mem::size_of::<kvm_nested_state__bindgen_ty_2__bindgen_ty_2>() - 0usize];
    ["Alignment of kvm_nested_state__bindgen_ty_2__bindgen_ty_2"]
        [::std::mem::align_of::<kvm_nested_state__bindgen_ty_2__bindgen_ty_2>() - 1usize];
    ["Offset of field: kvm_nested_state__bindgen_ty_2__bindgen_ty_2::__empty_svm"][::std::mem::offset_of!(
        kvm_nested_state__bindgen_ty_2__bindgen_ty_2,
        __empty_svm
    ) - 0usize];
    ["Offset of field: kvm_nested_state__bindgen_ty_2__bindgen_ty_2::svm"]
        [::std::mem::offset_of!(kvm_nested_state__bindgen_ty_2__bindgen_ty_2, svm) - 0usize];
};
impl Default for kvm_nested_state__bindgen_ty_2__bindgen_ty_2 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_nested_state__bindgen_ty_2"]
        [::std::mem::size_of::<kvm_nested_state__bindgen_ty_2>() - 0usize];
    ["Alignment of kvm_nested_state__bindgen_ty_2"]
        [::std::mem::align_of::<kvm_nested_state__bindgen_ty_2>() - 1usize];
};
impl Default for kvm_nested_state__bindgen_ty_2 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for kvm_nested_state__bindgen_ty_2 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "kvm_nested_state__bindgen_ty_2 {{ union }}")
    }
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_nested_state"][::std::mem::size_of::<kvm_nested_state>() - 128usize];
    ["Alignment of kvm_nested_state"][::std::mem::align_of::<kvm_nested_state>() - 8usize];
    ["Offset of field: kvm_nested_state::flags"]
        [::std::mem::offset_of!(kvm_nested_state, flags) - 0usize];
    ["Offset of field: kvm_nested_state::format"]
        [::std::mem::offset_of!(kvm_nested_state, format) - 2usize];
    ["Offset of field: kvm_nested_state::size"]
        [::std::mem::offset_of!(kvm_nested_state, size) - 4usize];
    ["Offset of field: kvm_nested_state::hdr"]
        [::std::mem::offset_of!(kvm_nested_state, hdr) - 8usize];
    ["Offset of field: kvm_nested_state::data"]
        [::std::mem::offset_of!(kvm_nested_state, data) - 128usize];
};
impl Default for kvm_nested_state {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for kvm_nested_state {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(
            f,
            "kvm_nested_state {{ flags: {:?}, format: {:?}, size: {:?}, hdr: {:?}, data: {:?} }}",
            self.flags, self.format, self.size, self.hdr, self.data
        )
    }
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct kvm_pmu_event_filter {
    pub action: __u32,
    pub nevents: __u32,
    pub fixed_counter_bitmap: __u32,
    pub flags: __u32,
    pub pad: [__u32; 4usize],
    pub events: __IncompleteArrayField<__u64>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_pmu_event_filter"][::std::mem::size_of::<kvm_pmu_event_filter>() - 32usize];
    ["Alignment of kvm_pmu_event_filter"][::std::mem::align_of::<kvm_pmu_event_filter>() - 8usize];
    ["Offset of field: kvm_pmu_event_filter::action"]
        [::std::mem::offset_of!(kvm_pmu_event_filter, action) - 0usize];
    ["Offset of field: kvm_pmu_event_filter::nevents"]
        [::std::mem::offset_of!(kvm_pmu_event_filter, nevents) - 4usize];
    ["Offset of field: kvm_pmu_event_filter::fixed_counter_bitmap"]
        [::std::mem::offset_of!(kvm_pmu_event_filter, fixed_counter_bitmap) - 8usize];
    ["Offset of field: kvm_pmu_event_filter::flags"]
        [::std::mem::offset_of!(kvm_pmu_event_filter, flags) - 12usize];
    ["Offset of field: kvm_pmu_event_filter::pad"]
        [::std::mem::offset_of!(kvm_pmu_event_filter, pad) - 16usize];
    ["Offset of field: kvm_pmu_event_filter::events"]
        [::std::mem::offset_of!(kvm_pmu_event_filter, events) - 32usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_x86_mce {
    pub status: __u64,
    pub addr: __u64,
    pub misc: __u64,
    pub mcg_status: __u64,
    pub bank: __u8,
    pub pad1: [__u8; 7usize],
    pub pad2: [__u64; 3usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_x86_mce"][::std::mem::size_of::<kvm_x86_mce>() - 64usize];
    ["Alignment of kvm_x86_mce"][::std::mem::align_of::<kvm_x86_mce>() - 8usize];
    ["Offset of field: kvm_x86_mce::status"][::std::mem::offset_of!(kvm_x86_mce, status) - 0usize];
    ["Offset of field: kvm_x86_mce::addr"][::std::mem::offset_of!(kvm_x86_mce, addr) - 8usize];
    ["Offset of field: kvm_x86_mce::misc"][::std::mem::offset_of!(kvm_x86_mce, misc) - 16usize];
    ["Offset of field: kvm_x86_mce::mcg_status"]
        [::std::mem::offset_of!(kvm_x86_mce, mcg_status) - 24usize];
    ["Offset of field: kvm_x86_mce::bank"][::std::mem::offset_of!(kvm_x86_mce, bank) - 32usize];
    ["Offset of field: kvm_x86_mce::pad1"][::std::mem::offset_of!(kvm_x86_mce, pad1) - 33usize];
    ["Offset of field: kvm_x86_mce::pad2"][::std::mem::offset_of!(kvm_x86_mce, pad2) - 40usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_xen_hvm_config {
    pub flags: __u32,
    pub msr: __u32,
    pub blob_addr_32: __u64,
    pub blob_addr_64: __u64,
    pub blob_size_32: __u8,
    pub blob_size_64: __u8,
    pub pad2: [__u8; 30usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_xen_hvm_config"][::std::mem::size_of::<kvm_xen_hvm_config>() - 56usize];
    ["Alignment of kvm_xen_hvm_config"][::std::mem::align_of::<kvm_xen_hvm_config>() - 8usize];
    ["Offset of field: kvm_xen_hvm_config::flags"]
        [::std::mem::offset_of!(kvm_xen_hvm_config, flags) - 0usize];
    ["Offset of field: kvm_xen_hvm_config::msr"]
        [::std::mem::offset_of!(kvm_xen_hvm_config, msr) - 4usize];
    ["Offset of field: kvm_xen_hvm_config::blob_addr_32"]
        [::std::mem::offset_of!(kvm_xen_hvm_config, blob_addr_32) - 8usize];
    ["Offset of field: kvm_xen_hvm_config::blob_addr_64"]
        [::std::mem::offset_of!(kvm_xen_hvm_config, blob_addr_64) - 16usize];
    ["Offset of field: kvm_xen_hvm_config::blob_size_32"]
        [::std::mem::offset_of!(kvm_xen_hvm_config, blob_size_32) - 24usize];
    ["Offset of field: kvm_xen_hvm_config::blob_size_64"]
        [::std::mem::offset_of!(kvm_xen_hvm_config, blob_size_64) - 25usize];
    ["Offset of field: kvm_xen_hvm_config::pad2"]
        [::std::mem::offset_of!(kvm_xen_hvm_config, pad2) - 26usize];
};
#[repr(C)]
#[derive(Copy, Clone)]
pub struct kvm_xen_hvm_attr {
    pub type_: __u16,
    pub pad: [__u16; 3usize],
    pub u: kvm_xen_hvm_attr__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union kvm_xen_hvm_attr__bindgen_ty_1 {
    pub long_mode: __u8,
    pub vector: __u8,
    pub runstate_update_flag: __u8,
    pub shared_info: kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_1,
    pub evtchn: kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2,
    pub xen_version: __u32,
    pub pad: [__u64; 8usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_1 {
    pub gfn: __u64,
    pub hva: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_1"]
        [::std::mem::size_of::<kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_1>() - 8usize];
    ["Alignment of kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_1"]
        [::std::mem::align_of::<kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_1>() - 8usize];
    ["Offset of field: kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_1::gfn"]
        [::std::mem::offset_of!(kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_1, gfn) - 0usize];
    ["Offset of field: kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_1::hva"]
        [::std::mem::offset_of!(kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_1, hva) - 0usize];
};
impl Default for kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(
            f,
            "kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_1 {{ union }}"
        )
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2 {
    pub send_port: __u32,
    pub type_: __u32,
    pub flags: __u32,
    pub deliver: kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1 {
    pub port: kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1__bindgen_ty_1,
    pub eventfd: kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1__bindgen_ty_2,
    pub padding: [__u32; 4usize],
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1__bindgen_ty_1 {
    pub port: __u32,
    pub vcpu: __u32,
    pub priority: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1__bindgen_ty_1"]
        [::std::mem::size_of::<
            kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1__bindgen_ty_1,
        >() - 12usize];
    ["Alignment of kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1__bindgen_ty_1"]
        [::std::mem::align_of::<
            kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1__bindgen_ty_1,
        >() - 4usize];
    ["Offset of field: kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1__bindgen_ty_1::port"] [:: std :: mem :: offset_of ! (kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1__bindgen_ty_1 , port) - 0usize] ;
    ["Offset of field: kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1__bindgen_ty_1::vcpu"] [:: std :: mem :: offset_of ! (kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1__bindgen_ty_1 , vcpu) - 4usize] ;
    ["Offset of field: kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1__bindgen_ty_1::priority"] [:: std :: mem :: offset_of ! (kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1__bindgen_ty_1 , priority) - 8usize] ;
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1__bindgen_ty_2 {
    pub port: __u32,
    pub fd: __s32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1__bindgen_ty_2"]
        [::std::mem::size_of::<
            kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1__bindgen_ty_2,
        >() - 8usize];
    ["Alignment of kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1__bindgen_ty_2"]
        [::std::mem::align_of::<
            kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1__bindgen_ty_2,
        >() - 4usize];
    ["Offset of field: kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1__bindgen_ty_2::port"] [:: std :: mem :: offset_of ! (kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1__bindgen_ty_2 , port) - 0usize] ;
    ["Offset of field: kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1__bindgen_ty_2::fd"] [:: std :: mem :: offset_of ! (kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1__bindgen_ty_2 , fd) - 4usize] ;
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1"][::std::mem::size_of::<
        kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1,
    >() - 16usize];
    ["Alignment of kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1"][::std::mem::align_of::<
        kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1,
    >() - 4usize];
    ["Offset of field: kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1::port"][::std::mem::offset_of!(
        kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1,
        port
    )
        - 0usize];
    ["Offset of field: kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1::eventfd"][::std::mem::offset_of!(
        kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1,
        eventfd
    )
        - 0usize];
    ["Offset of field: kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1::padding"][::std::mem::offset_of!(
        kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1,
        padding
    )
        - 0usize];
};
impl Default for kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(
            f,
            "kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2__bindgen_ty_1 {{ union }}"
        )
    }
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2"]
        [::std::mem::size_of::<kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2>() - 28usize];
    ["Alignment of kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2"]
        [::std::mem::align_of::<kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2>() - 4usize];
    ["Offset of field: kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2::send_port"]
        [::std::mem::offset_of!(kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2, send_port) - 0usize];
    ["Offset of field: kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2::type_"]
        [::std::mem::offset_of!(kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2, type_) - 4usize];
    ["Offset of field: kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2::flags"]
        [::std::mem::offset_of!(kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2, flags) - 8usize];
    ["Offset of field: kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2::deliver"]
        [::std::mem::offset_of!(kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2, deliver) - 12usize];
};
impl Default for kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write ! (f , "kvm_xen_hvm_attr__bindgen_ty_1__bindgen_ty_2 {{ send_port: {:?}, type: {:?}, flags: {:?}, deliver: {:?} }}" , self . send_port , self . type_ , self . flags , self . deliver)
    }
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_xen_hvm_attr__bindgen_ty_1"]
        [::std::mem::size_of::<kvm_xen_hvm_attr__bindgen_ty_1>() - 64usize];
    ["Alignment of kvm_xen_hvm_attr__bindgen_ty_1"]
        [::std::mem::align_of::<kvm_xen_hvm_attr__bindgen_ty_1>() - 8usize];
    ["Offset of field: kvm_xen_hvm_attr__bindgen_ty_1::long_mode"]
        [::std::mem::offset_of!(kvm_xen_hvm_attr__bindgen_ty_1, long_mode) - 0usize];
    ["Offset of field: kvm_xen_hvm_attr__bindgen_ty_1::vector"]
        [::std::mem::offset_of!(kvm_xen_hvm_attr__bindgen_ty_1, vector) - 0usize];
    ["Offset of field: kvm_xen_hvm_attr__bindgen_ty_1::runstate_update_flag"]
        [::std::mem::offset_of!(kvm_xen_hvm_attr__bindgen_ty_1, runstate_update_flag) - 0usize];
    ["Offset of field: kvm_xen_hvm_attr__bindgen_ty_1::shared_info"]
        [::std::mem::offset_of!(kvm_xen_hvm_attr__bindgen_ty_1, shared_info) - 0usize];
    ["Offset of field: kvm_xen_hvm_attr__bindgen_ty_1::evtchn"]
        [::std::mem::offset_of!(kvm_xen_hvm_attr__bindgen_ty_1, evtchn) - 0usize];
    ["Offset of field: kvm_xen_hvm_attr__bindgen_ty_1::xen_version"]
        [::std::mem::offset_of!(kvm_xen_hvm_attr__bindgen_ty_1, xen_version) - 0usize];
    ["Offset of field: kvm_xen_hvm_attr__bindgen_ty_1::pad"]
        [::std::mem::offset_of!(kvm_xen_hvm_attr__bindgen_ty_1, pad) - 0usize];
};
impl Default for kvm_xen_hvm_attr__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for kvm_xen_hvm_attr__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "kvm_xen_hvm_attr__bindgen_ty_1 {{ union }}")
    }
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_xen_hvm_attr"][::std::mem::size_of::<kvm_xen_hvm_attr>() - 72usize];
    ["Alignment of kvm_xen_hvm_attr"][::std::mem::align_of::<kvm_xen_hvm_attr>() - 8usize];
    ["Offset of field: kvm_xen_hvm_attr::type_"]
        [::std::mem::offset_of!(kvm_xen_hvm_attr, type_) - 0usize];
    ["Offset of field: kvm_xen_hvm_attr::pad"]
        [::std::mem::offset_of!(kvm_xen_hvm_attr, pad) - 2usize];
    ["Offset of field: kvm_xen_hvm_attr::u"][::std::mem::offset_of!(kvm_xen_hvm_attr, u) - 8usize];
};
impl Default for kvm_xen_hvm_attr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for kvm_xen_hvm_attr {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(
            f,
            "kvm_xen_hvm_attr {{ type: {:?}, pad: {:?}, u: {:?} }}",
            self.type_, self.pad, self.u
        )
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct kvm_xen_vcpu_attr {
    pub type_: __u16,
    pub pad: [__u16; 3usize],
    pub u: kvm_xen_vcpu_attr__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union kvm_xen_vcpu_attr__bindgen_ty_1 {
    pub gpa: __u64,
    pub hva: __u64,
    pub pad: [__u64; 8usize],
    pub runstate: kvm_xen_vcpu_attr__bindgen_ty_1__bindgen_ty_1,
    pub vcpu_id: __u32,
    pub timer: kvm_xen_vcpu_attr__bindgen_ty_1__bindgen_ty_2,
    pub vector: __u8,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_xen_vcpu_attr__bindgen_ty_1__bindgen_ty_1 {
    pub state: __u64,
    pub state_entry_time: __u64,
    pub time_running: __u64,
    pub time_runnable: __u64,
    pub time_blocked: __u64,
    pub time_offline: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_xen_vcpu_attr__bindgen_ty_1__bindgen_ty_1"]
        [::std::mem::size_of::<kvm_xen_vcpu_attr__bindgen_ty_1__bindgen_ty_1>() - 48usize];
    ["Alignment of kvm_xen_vcpu_attr__bindgen_ty_1__bindgen_ty_1"]
        [::std::mem::align_of::<kvm_xen_vcpu_attr__bindgen_ty_1__bindgen_ty_1>() - 8usize];
    ["Offset of field: kvm_xen_vcpu_attr__bindgen_ty_1__bindgen_ty_1::state"]
        [::std::mem::offset_of!(kvm_xen_vcpu_attr__bindgen_ty_1__bindgen_ty_1, state) - 0usize];
    ["Offset of field: kvm_xen_vcpu_attr__bindgen_ty_1__bindgen_ty_1::state_entry_time"][::std::mem::offset_of!(
        kvm_xen_vcpu_attr__bindgen_ty_1__bindgen_ty_1,
        state_entry_time
    )
        - 8usize];
    ["Offset of field: kvm_xen_vcpu_attr__bindgen_ty_1__bindgen_ty_1::time_running"][::std::mem::offset_of!(
        kvm_xen_vcpu_attr__bindgen_ty_1__bindgen_ty_1,
        time_running
    ) - 16usize];
    ["Offset of field: kvm_xen_vcpu_attr__bindgen_ty_1__bindgen_ty_1::time_runnable"][::std::mem::offset_of!(
        kvm_xen_vcpu_attr__bindgen_ty_1__bindgen_ty_1,
        time_runnable
    ) - 24usize];
    ["Offset of field: kvm_xen_vcpu_attr__bindgen_ty_1__bindgen_ty_1::time_blocked"][::std::mem::offset_of!(
        kvm_xen_vcpu_attr__bindgen_ty_1__bindgen_ty_1,
        time_blocked
    ) - 32usize];
    ["Offset of field: kvm_xen_vcpu_attr__bindgen_ty_1__bindgen_ty_1::time_offline"][::std::mem::offset_of!(
        kvm_xen_vcpu_attr__bindgen_ty_1__bindgen_ty_1,
        time_offline
    ) - 40usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_xen_vcpu_attr__bindgen_ty_1__bindgen_ty_2 {
    pub port: __u32,
    pub priority: __u32,
    pub expires_ns: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_xen_vcpu_attr__bindgen_ty_1__bindgen_ty_2"]
        [::std::mem::size_of::<kvm_xen_vcpu_attr__bindgen_ty_1__bindgen_ty_2>() - 16usize];
    ["Alignment of kvm_xen_vcpu_attr__bindgen_ty_1__bindgen_ty_2"]
        [::std::mem::align_of::<kvm_xen_vcpu_attr__bindgen_ty_1__bindgen_ty_2>() - 8usize];
    ["Offset of field: kvm_xen_vcpu_attr__bindgen_ty_1__bindgen_ty_2::port"]
        [::std::mem::offset_of!(kvm_xen_vcpu_attr__bindgen_ty_1__bindgen_ty_2, port) - 0usize];
    ["Offset of field: kvm_xen_vcpu_attr__bindgen_ty_1__bindgen_ty_2::priority"]
        [::std::mem::offset_of!(kvm_xen_vcpu_attr__bindgen_ty_1__bindgen_ty_2, priority) - 4usize];
    ["Offset of field: kvm_xen_vcpu_attr__bindgen_ty_1__bindgen_ty_2::expires_ns"][::std::mem::offset_of!(
        kvm_xen_vcpu_attr__bindgen_ty_1__bindgen_ty_2,
        expires_ns
    ) - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_xen_vcpu_attr__bindgen_ty_1"]
        [::std::mem::size_of::<kvm_xen_vcpu_attr__bindgen_ty_1>() - 64usize];
    ["Alignment of kvm_xen_vcpu_attr__bindgen_ty_1"]
        [::std::mem::align_of::<kvm_xen_vcpu_attr__bindgen_ty_1>() - 8usize];
    ["Offset of field: kvm_xen_vcpu_attr__bindgen_ty_1::gpa"]
        [::std::mem::offset_of!(kvm_xen_vcpu_attr__bindgen_ty_1, gpa) - 0usize];
    ["Offset of field: kvm_xen_vcpu_attr__bindgen_ty_1::hva"]
        [::std::mem::offset_of!(kvm_xen_vcpu_attr__bindgen_ty_1, hva) - 0usize];
    ["Offset of field: kvm_xen_vcpu_attr__bindgen_ty_1::pad"]
        [::std::mem::offset_of!(kvm_xen_vcpu_attr__bindgen_ty_1, pad) - 0usize];
    ["Offset of field: kvm_xen_vcpu_attr__bindgen_ty_1::runstate"]
        [::std::mem::offset_of!(kvm_xen_vcpu_attr__bindgen_ty_1, runstate) - 0usize];
    ["Offset of field: kvm_xen_vcpu_attr__bindgen_ty_1::vcpu_id"]
        [::std::mem::offset_of!(kvm_xen_vcpu_attr__bindgen_ty_1, vcpu_id) - 0usize];
    ["Offset of field: kvm_xen_vcpu_attr__bindgen_ty_1::timer"]
        [::std::mem::offset_of!(kvm_xen_vcpu_attr__bindgen_ty_1, timer) - 0usize];
    ["Offset of field: kvm_xen_vcpu_attr__bindgen_ty_1::vector"]
        [::std::mem::offset_of!(kvm_xen_vcpu_attr__bindgen_ty_1, vector) - 0usize];
};
impl Default for kvm_xen_vcpu_attr__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for kvm_xen_vcpu_attr__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "kvm_xen_vcpu_attr__bindgen_ty_1 {{ union }}")
    }
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_xen_vcpu_attr"][::std::mem::size_of::<kvm_xen_vcpu_attr>() - 72usize];
    ["Alignment of kvm_xen_vcpu_attr"][::std::mem::align_of::<kvm_xen_vcpu_attr>() - 8usize];
    ["Offset of field: kvm_xen_vcpu_attr::type_"]
        [::std::mem::offset_of!(kvm_xen_vcpu_attr, type_) - 0usize];
    ["Offset of field: kvm_xen_vcpu_attr::pad"]
        [::std::mem::offset_of!(kvm_xen_vcpu_attr, pad) - 2usize];
    ["Offset of field: kvm_xen_vcpu_attr::u"]
        [::std::mem::offset_of!(kvm_xen_vcpu_attr, u) - 8usize];
};
impl Default for kvm_xen_vcpu_attr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for kvm_xen_vcpu_attr {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(
            f,
            "kvm_xen_vcpu_attr {{ type: {:?}, pad: {:?}, u: {:?} }}",
            self.type_, self.pad, self.u
        )
    }
}
pub const sev_cmd_id_KVM_SEV_INIT: sev_cmd_id = 0;
pub const sev_cmd_id_KVM_SEV_ES_INIT: sev_cmd_id = 1;
pub const sev_cmd_id_KVM_SEV_LAUNCH_START: sev_cmd_id = 2;
pub const sev_cmd_id_KVM_SEV_LAUNCH_UPDATE_DATA: sev_cmd_id = 3;
pub const sev_cmd_id_KVM_SEV_LAUNCH_UPDATE_VMSA: sev_cmd_id = 4;
pub const sev_cmd_id_KVM_SEV_LAUNCH_SECRET: sev_cmd_id = 5;
pub const sev_cmd_id_KVM_SEV_LAUNCH_MEASURE: sev_cmd_id = 6;
pub const sev_cmd_id_KVM_SEV_LAUNCH_FINISH: sev_cmd_id = 7;
pub const sev_cmd_id_KVM_SEV_SEND_START: sev_cmd_id = 8;
pub const sev_cmd_id_KVM_SEV_SEND_UPDATE_DATA: sev_cmd_id = 9;
pub const sev_cmd_id_KVM_SEV_SEND_UPDATE_VMSA: sev_cmd_id = 10;
pub const sev_cmd_id_KVM_SEV_SEND_FINISH: sev_cmd_id = 11;
pub const sev_cmd_id_KVM_SEV_RECEIVE_START: sev_cmd_id = 12;
pub const sev_cmd_id_KVM_SEV_RECEIVE_UPDATE_DATA: sev_cmd_id = 13;
pub const sev_cmd_id_KVM_SEV_RECEIVE_UPDATE_VMSA: sev_cmd_id = 14;
pub const sev_cmd_id_KVM_SEV_RECEIVE_FINISH: sev_cmd_id = 15;
pub const sev_cmd_id_KVM_SEV_GUEST_STATUS: sev_cmd_id = 16;
pub const sev_cmd_id_KVM_SEV_DBG_DECRYPT: sev_cmd_id = 17;
pub const sev_cmd_id_KVM_SEV_DBG_ENCRYPT: sev_cmd_id = 18;
pub const sev_cmd_id_KVM_SEV_CERT_EXPORT: sev_cmd_id = 19;
pub const sev_cmd_id_KVM_SEV_GET_ATTESTATION_REPORT: sev_cmd_id = 20;
pub const sev_cmd_id_KVM_SEV_SEND_CANCEL: sev_cmd_id = 21;
pub const sev_cmd_id_KVM_SEV_NR_MAX: sev_cmd_id = 22;
pub type sev_cmd_id = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_sev_cmd {
    pub id: __u32,
    pub pad0: __u32,
    pub data: __u64,
    pub error: __u32,
    pub sev_fd: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_sev_cmd"][::std::mem::size_of::<kvm_sev_cmd>() - 24usize];
    ["Alignment of kvm_sev_cmd"][::std::mem::align_of::<kvm_sev_cmd>() - 8usize];
    ["Offset of field: kvm_sev_cmd::id"][::std::mem::offset_of!(kvm_sev_cmd, id) - 0usize];
    ["Offset of field: kvm_sev_cmd::pad0"][::std::mem::offset_of!(kvm_sev_cmd, pad0) - 4usize];
    ["Offset of field: kvm_sev_cmd::data"][::std::mem::offset_of!(kvm_sev_cmd, data) - 8usize];
    ["Offset of field: kvm_sev_cmd::error"][::std::mem::offset_of!(kvm_sev_cmd, error) - 16usize];
    ["Offset of field: kvm_sev_cmd::sev_fd"][::std::mem::offset_of!(kvm_sev_cmd, sev_fd) - 20usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_sev_launch_start {
    pub handle: __u32,
    pub policy: __u32,
    pub dh_uaddr: __u64,
    pub dh_len: __u32,
    pub pad0: __u32,
    pub session_uaddr: __u64,
    pub session_len: __u32,
    pub pad1: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_sev_launch_start"][::std::mem::size_of::<kvm_sev_launch_start>() - 40usize];
    ["Alignment of kvm_sev_launch_start"][::std::mem::align_of::<kvm_sev_launch_start>() - 8usize];
    ["Offset of field: kvm_sev_launch_start::handle"]
        [::std::mem::offset_of!(kvm_sev_launch_start, handle) - 0usize];
    ["Offset of field: kvm_sev_launch_start::policy"]
        [::std::mem::offset_of!(kvm_sev_launch_start, policy) - 4usize];
    ["Offset of field: kvm_sev_launch_start::dh_uaddr"]
        [::std::mem::offset_of!(kvm_sev_launch_start, dh_uaddr) - 8usize];
    ["Offset of field: kvm_sev_launch_start::dh_len"]
        [::std::mem::offset_of!(kvm_sev_launch_start, dh_len) - 16usize];
    ["Offset of field: kvm_sev_launch_start::pad0"]
        [::std::mem::offset_of!(kvm_sev_launch_start, pad0) - 20usize];
    ["Offset of field: kvm_sev_launch_start::session_uaddr"]
        [::std::mem::offset_of!(kvm_sev_launch_start, session_uaddr) - 24usize];
    ["Offset of field: kvm_sev_launch_start::session_len"]
        [::std::mem::offset_of!(kvm_sev_launch_start, session_len) - 32usize];
    ["Offset of field: kvm_sev_launch_start::pad1"]
        [::std::mem::offset_of!(kvm_sev_launch_start, pad1) - 36usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_sev_launch_update_data {
    pub uaddr: __u64,
    pub len: __u32,
    pub pad0: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_sev_launch_update_data"]
        [::std::mem::size_of::<kvm_sev_launch_update_data>() - 16usize];
    ["Alignment of kvm_sev_launch_update_data"]
        [::std::mem::align_of::<kvm_sev_launch_update_data>() - 8usize];
    ["Offset of field: kvm_sev_launch_update_data::uaddr"]
        [::std::mem::offset_of!(kvm_sev_launch_update_data, uaddr) - 0usize];
    ["Offset of field: kvm_sev_launch_update_data::len"]
        [::std::mem::offset_of!(kvm_sev_launch_update_data, len) - 8usize];
    ["Offset of field: kvm_sev_launch_update_data::pad0"]
        [::std::mem::offset_of!(kvm_sev_launch_update_data, pad0) - 12usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_sev_launch_secret {
    pub hdr_uaddr: __u64,
    pub hdr_len: __u32,
    pub pad0: __u32,
    pub guest_uaddr: __u64,
    pub guest_len: __u32,
    pub pad1: __u32,
    pub trans_uaddr: __u64,
    pub trans_len: __u32,
    pub pad2: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_sev_launch_secret"][::std::mem::size_of::<kvm_sev_launch_secret>() - 48usize];
    ["Alignment of kvm_sev_launch_secret"]
        [::std::mem::align_of::<kvm_sev_launch_secret>() - 8usize];
    ["Offset of field: kvm_sev_launch_secret::hdr_uaddr"]
        [::std::mem::offset_of!(kvm_sev_launch_secret, hdr_uaddr) - 0usize];
    ["Offset of field: kvm_sev_launch_secret::hdr_len"]
        [::std::mem::offset_of!(kvm_sev_launch_secret, hdr_len) - 8usize];
    ["Offset of field: kvm_sev_launch_secret::pad0"]
        [::std::mem::offset_of!(kvm_sev_launch_secret, pad0) - 12usize];
    ["Offset of field: kvm_sev_launch_secret::guest_uaddr"]
        [::std::mem::offset_of!(kvm_sev_launch_secret, guest_uaddr) - 16usize];
    ["Offset of field: kvm_sev_launch_secret::guest_len"]
        [::std::mem::offset_of!(kvm_sev_launch_secret, guest_len) - 24usize];
    ["Offset of field: kvm_sev_launch_secret::pad1"]
        [::std::mem::offset_of!(kvm_sev_launch_secret, pad1) - 28usize];
    ["Offset of field: kvm_sev_launch_secret::trans_uaddr"]
        [::std::mem::offset_of!(kvm_sev_launch_secret, trans_uaddr) - 32usize];
    ["Offset of field: kvm_sev_launch_secret::trans_len"]
        [::std::mem::offset_of!(kvm_sev_launch_secret, trans_len) - 40usize];
    ["Offset of field: kvm_sev_launch_secret::pad2"]
        [::std::mem::offset_of!(kvm_sev_launch_secret, pad2) - 44usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_sev_launch_measure {
    pub uaddr: __u64,
    pub len: __u32,
    pub pad0: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_sev_launch_measure"][::std::mem::size_of::<kvm_sev_launch_measure>() - 16usize];
    ["Alignment of kvm_sev_launch_measure"]
        [::std::mem::align_of::<kvm_sev_launch_measure>() - 8usize];
    ["Offset of field: kvm_sev_launch_measure::uaddr"]
        [::std::mem::offset_of!(kvm_sev_launch_measure, uaddr) - 0usize];
    ["Offset of field: kvm_sev_launch_measure::len"]
        [::std::mem::offset_of!(kvm_sev_launch_measure, len) - 8usize];
    ["Offset of field: kvm_sev_launch_measure::pad0"]
        [::std::mem::offset_of!(kvm_sev_launch_measure, pad0) - 12usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_sev_guest_status {
    pub handle: __u32,
    pub policy: __u32,
    pub state: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_sev_guest_status"][::std::mem::size_of::<kvm_sev_guest_status>() - 12usize];
    ["Alignment of kvm_sev_guest_status"][::std::mem::align_of::<kvm_sev_guest_status>() - 4usize];
    ["Offset of field: kvm_sev_guest_status::handle"]
        [::std::mem::offset_of!(kvm_sev_guest_status, handle) - 0usize];
    ["Offset of field: kvm_sev_guest_status::policy"]
        [::std::mem::offset_of!(kvm_sev_guest_status, policy) - 4usize];
    ["Offset of field: kvm_sev_guest_status::state"]
        [::std::mem::offset_of!(kvm_sev_guest_status, state) - 8usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_sev_dbg {
    pub src_uaddr: __u64,
    pub dst_uaddr: __u64,
    pub len: __u32,
    pub pad0: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_sev_dbg"][::std::mem::size_of::<kvm_sev_dbg>() - 24usize];
    ["Alignment of kvm_sev_dbg"][::std::mem::align_of::<kvm_sev_dbg>() - 8usize];
    ["Offset of field: kvm_sev_dbg::src_uaddr"]
        [::std::mem::offset_of!(kvm_sev_dbg, src_uaddr) - 0usize];
    ["Offset of field: kvm_sev_dbg::dst_uaddr"]
        [::std::mem::offset_of!(kvm_sev_dbg, dst_uaddr) - 8usize];
    ["Offset of field: kvm_sev_dbg::len"][::std::mem::offset_of!(kvm_sev_dbg, len) - 16usize];
    ["Offset of field: kvm_sev_dbg::pad0"][::std::mem::offset_of!(kvm_sev_dbg, pad0) - 20usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_sev_attestation_report {
    pub mnonce: [__u8; 16usize],
    pub uaddr: __u64,
    pub len: __u32,
    pub pad0: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_sev_attestation_report"]
        [::std::mem::size_of::<kvm_sev_attestation_report>() - 32usize];
    ["Alignment of kvm_sev_attestation_report"]
        [::std::mem::align_of::<kvm_sev_attestation_report>() - 8usize];
    ["Offset of field: kvm_sev_attestation_report::mnonce"]
        [::std::mem::offset_of!(kvm_sev_attestation_report, mnonce) - 0usize];
    ["Offset of field: kvm_sev_attestation_report::uaddr"]
        [::std::mem::offset_of!(kvm_sev_attestation_report, uaddr) - 16usize];
    ["Offset of field: kvm_sev_attestation_report::len"]
        [::std::mem::offset_of!(kvm_sev_attestation_report, len) - 24usize];
    ["Offset of field: kvm_sev_attestation_report::pad0"]
        [::std::mem::offset_of!(kvm_sev_attestation_report, pad0) - 28usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_sev_send_start {
    pub policy: __u32,
    pub pad0: __u32,
    pub pdh_cert_uaddr: __u64,
    pub pdh_cert_len: __u32,
    pub pad1: __u32,
    pub plat_certs_uaddr: __u64,
    pub plat_certs_len: __u32,
    pub pad2: __u32,
    pub amd_certs_uaddr: __u64,
    pub amd_certs_len: __u32,
    pub pad3: __u32,
    pub session_uaddr: __u64,
    pub session_len: __u32,
    pub pad4: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_sev_send_start"][::std::mem::size_of::<kvm_sev_send_start>() - 72usize];
    ["Alignment of kvm_sev_send_start"][::std::mem::align_of::<kvm_sev_send_start>() - 8usize];
    ["Offset of field: kvm_sev_send_start::policy"]
        [::std::mem::offset_of!(kvm_sev_send_start, policy) - 0usize];
    ["Offset of field: kvm_sev_send_start::pad0"]
        [::std::mem::offset_of!(kvm_sev_send_start, pad0) - 4usize];
    ["Offset of field: kvm_sev_send_start::pdh_cert_uaddr"]
        [::std::mem::offset_of!(kvm_sev_send_start, pdh_cert_uaddr) - 8usize];
    ["Offset of field: kvm_sev_send_start::pdh_cert_len"]
        [::std::mem::offset_of!(kvm_sev_send_start, pdh_cert_len) - 16usize];
    ["Offset of field: kvm_sev_send_start::pad1"]
        [::std::mem::offset_of!(kvm_sev_send_start, pad1) - 20usize];
    ["Offset of field: kvm_sev_send_start::plat_certs_uaddr"]
        [::std::mem::offset_of!(kvm_sev_send_start, plat_certs_uaddr) - 24usize];
    ["Offset of field: kvm_sev_send_start::plat_certs_len"]
        [::std::mem::offset_of!(kvm_sev_send_start, plat_certs_len) - 32usize];
    ["Offset of field: kvm_sev_send_start::pad2"]
        [::std::mem::offset_of!(kvm_sev_send_start, pad2) - 36usize];
    ["Offset of field: kvm_sev_send_start::amd_certs_uaddr"]
        [::std::mem::offset_of!(kvm_sev_send_start, amd_certs_uaddr) - 40usize];
    ["Offset of field: kvm_sev_send_start::amd_certs_len"]
        [::std::mem::offset_of!(kvm_sev_send_start, amd_certs_len) - 48usize];
    ["Offset of field: kvm_sev_send_start::pad3"]
        [::std::mem::offset_of!(kvm_sev_send_start, pad3) - 52usize];
    ["Offset of field: kvm_sev_send_start::session_uaddr"]
        [::std::mem::offset_of!(kvm_sev_send_start, session_uaddr) - 56usize];
    ["Offset of field: kvm_sev_send_start::session_len"]
        [::std::mem::offset_of!(kvm_sev_send_start, session_len) - 64usize];
    ["Offset of field: kvm_sev_send_start::pad4"]
        [::std::mem::offset_of!(kvm_sev_send_start, pad4) - 68usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_sev_send_update_data {
    pub hdr_uaddr: __u64,
    pub hdr_len: __u32,
    pub pad0: __u32,
    pub guest_uaddr: __u64,
    pub guest_len: __u32,
    pub pad1: __u32,
    pub trans_uaddr: __u64,
    pub trans_len: __u32,
    pub pad2: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_sev_send_update_data"]
        [::std::mem::size_of::<kvm_sev_send_update_data>() - 48usize];
    ["Alignment of kvm_sev_send_update_data"]
        [::std::mem::align_of::<kvm_sev_send_update_data>() - 8usize];
    ["Offset of field: kvm_sev_send_update_data::hdr_uaddr"]
        [::std::mem::offset_of!(kvm_sev_send_update_data, hdr_uaddr) - 0usize];
    ["Offset of field: kvm_sev_send_update_data::hdr_len"]
        [::std::mem::offset_of!(kvm_sev_send_update_data, hdr_len) - 8usize];
    ["Offset of field: kvm_sev_send_update_data::pad0"]
        [::std::mem::offset_of!(kvm_sev_send_update_data, pad0) - 12usize];
    ["Offset of field: kvm_sev_send_update_data::guest_uaddr"]
        [::std::mem::offset_of!(kvm_sev_send_update_data, guest_uaddr) - 16usize];
    ["Offset of field: kvm_sev_send_update_data::guest_len"]
        [::std::mem::offset_of!(kvm_sev_send_update_data, guest_len) - 24usize];
    ["Offset of field: kvm_sev_send_update_data::pad1"]
        [::std::mem::offset_of!(kvm_sev_send_update_data, pad1) - 28usize];
    ["Offset of field: kvm_sev_send_update_data::trans_uaddr"]
        [::std::mem::offset_of!(kvm_sev_send_update_data, trans_uaddr) - 32usize];
    ["Offset of field: kvm_sev_send_update_data::trans_len"]
        [::std::mem::offset_of!(kvm_sev_send_update_data, trans_len) - 40usize];
    ["Offset of field: kvm_sev_send_update_data::pad2"]
        [::std::mem::offset_of!(kvm_sev_send_update_data, pad2) - 44usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_sev_receive_start {
    pub handle: __u32,
    pub policy: __u32,
    pub pdh_uaddr: __u64,
    pub pdh_len: __u32,
    pub pad0: __u32,
    pub session_uaddr: __u64,
    pub session_len: __u32,
    pub pad1: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_sev_receive_start"][::std::mem::size_of::<kvm_sev_receive_start>() - 40usize];
    ["Alignment of kvm_sev_receive_start"]
        [::std::mem::align_of::<kvm_sev_receive_start>() - 8usize];
    ["Offset of field: kvm_sev_receive_start::handle"]
        [::std::mem::offset_of!(kvm_sev_receive_start, handle) - 0usize];
    ["Offset of field: kvm_sev_receive_start::policy"]
        [::std::mem::offset_of!(kvm_sev_receive_start, policy) - 4usize];
    ["Offset of field: kvm_sev_receive_start::pdh_uaddr"]
        [::std::mem::offset_of!(kvm_sev_receive_start, pdh_uaddr) - 8usize];
    ["Offset of field: kvm_sev_receive_start::pdh_len"]
        [::std::mem::offset_of!(kvm_sev_receive_start, pdh_len) - 16usize];
    ["Offset of field: kvm_sev_receive_start::pad0"]
        [::std::mem::offset_of!(kvm_sev_receive_start, pad0) - 20usize];
    ["Offset of field: kvm_sev_receive_start::session_uaddr"]
        [::std::mem::offset_of!(kvm_sev_receive_start, session_uaddr) - 24usize];
    ["Offset of field: kvm_sev_receive_start::session_len"]
        [::std::mem::offset_of!(kvm_sev_receive_start, session_len) - 32usize];
    ["Offset of field: kvm_sev_receive_start::pad1"]
        [::std::mem::offset_of!(kvm_sev_receive_start, pad1) - 36usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_sev_receive_update_data {
    pub hdr_uaddr: __u64,
    pub hdr_len: __u32,
    pub pad0: __u32,
    pub guest_uaddr: __u64,
    pub guest_len: __u32,
    pub pad1: __u32,
    pub trans_uaddr: __u64,
    pub trans_len: __u32,
    pub pad2: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_sev_receive_update_data"]
        [::std::mem::size_of::<kvm_sev_receive_update_data>() - 48usize];
    ["Alignment of kvm_sev_receive_update_data"]
        [::std::mem::align_of::<kvm_sev_receive_update_data>() - 8usize];
    ["Offset of field: kvm_sev_receive_update_data::hdr_uaddr"]
        [::std::mem::offset_of!(kvm_sev_receive_update_data, hdr_uaddr) - 0usize];
    ["Offset of field: kvm_sev_receive_update_data::hdr_len"]
        [::std::mem::offset_of!(kvm_sev_receive_update_data, hdr_len) - 8usize];
    ["Offset of field: kvm_sev_receive_update_data::pad0"]
        [::std::mem::offset_of!(kvm_sev_receive_update_data, pad0) - 12usize];
    ["Offset of field: kvm_sev_receive_update_data::guest_uaddr"]
        [::std::mem::offset_of!(kvm_sev_receive_update_data, guest_uaddr) - 16usize];
    ["Offset of field: kvm_sev_receive_update_data::guest_len"]
        [::std::mem::offset_of!(kvm_sev_receive_update_data, guest_len) - 24usize];
    ["Offset of field: kvm_sev_receive_update_data::pad1"]
        [::std::mem::offset_of!(kvm_sev_receive_update_data, pad1) - 28usize];
    ["Offset of field: kvm_sev_receive_update_data::trans_uaddr"]
        [::std::mem::offset_of!(kvm_sev_receive_update_data, trans_uaddr) - 32usize];
    ["Offset of field: kvm_sev_receive_update_data::trans_len"]
        [::std::mem::offset_of!(kvm_sev_receive_update_data, trans_len) - 40usize];
    ["Offset of field: kvm_sev_receive_update_data::pad2"]
        [::std::mem::offset_of!(kvm_sev_receive_update_data, pad2) - 44usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_hyperv_eventfd {
    pub conn_id: __u32,
    pub fd: __s32,
    pub flags: __u32,
    pub padding: [__u32; 3usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_hyperv_eventfd"][::std::mem::size_of::<kvm_hyperv_eventfd>() - 24usize];
    ["Alignment of kvm_hyperv_eventfd"][::std::mem::align_of::<kvm_hyperv_eventfd>() - 4usize];
    ["Offset of field: kvm_hyperv_eventfd::conn_id"]
        [::std::mem::offset_of!(kvm_hyperv_eventfd, conn_id) - 0usize];
    ["Offset of field: kvm_hyperv_eventfd::fd"]
        [::std::mem::offset_of!(kvm_hyperv_eventfd, fd) - 4usize];
    ["Offset of field: kvm_hyperv_eventfd::flags"]
        [::std::mem::offset_of!(kvm_hyperv_eventfd, flags) - 8usize];
    ["Offset of field: kvm_hyperv_eventfd::padding"]
        [::std::mem::offset_of!(kvm_hyperv_eventfd, padding) - 12usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_userspace_memory_region {
    pub slot: __u32,
    pub flags: __u32,
    pub guest_phys_addr: __u64,
    pub memory_size: __u64,
    pub userspace_addr: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_userspace_memory_region"]
        [::std::mem::size_of::<kvm_userspace_memory_region>() - 32usize];
    ["Alignment of kvm_userspace_memory_region"]
        [::std::mem::align_of::<kvm_userspace_memory_region>() - 8usize];
    ["Offset of field: kvm_userspace_memory_region::slot"]
        [::std::mem::offset_of!(kvm_userspace_memory_region, slot) - 0usize];
    ["Offset of field: kvm_userspace_memory_region::flags"]
        [::std::mem::offset_of!(kvm_userspace_memory_region, flags) - 4usize];
    ["Offset of field: kvm_userspace_memory_region::guest_phys_addr"]
        [::std::mem::offset_of!(kvm_userspace_memory_region, guest_phys_addr) - 8usize];
    ["Offset of field: kvm_userspace_memory_region::memory_size"]
        [::std::mem::offset_of!(kvm_userspace_memory_region, memory_size) - 16usize];
    ["Offset of field: kvm_userspace_memory_region::userspace_addr"]
        [::std::mem::offset_of!(kvm_userspace_memory_region, userspace_addr) - 24usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_userspace_memory_region2 {
    pub slot: __u32,
    pub flags: __u32,
    pub guest_phys_addr: __u64,
    pub memory_size: __u64,
    pub userspace_addr: __u64,
    pub guest_memfd_offset: __u64,
    pub guest_memfd: __u32,
    pub pad1: __u32,
    pub pad2: [__u64; 14usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_userspace_memory_region2"]
        [::std::mem::size_of::<kvm_userspace_memory_region2>() - 160usize];
    ["Alignment of kvm_userspace_memory_region2"]
        [::std::mem::align_of::<kvm_userspace_memory_region2>() - 8usize];
    ["Offset of field: kvm_userspace_memory_region2::slot"]
        [::std::mem::offset_of!(kvm_userspace_memory_region2, slot) - 0usize];
    ["Offset of field: kvm_userspace_memory_region2::flags"]
        [::std::mem::offset_of!(kvm_userspace_memory_region2, flags) - 4usize];
    ["Offset of field: kvm_userspace_memory_region2::guest_phys_addr"]
        [::std::mem::offset_of!(kvm_userspace_memory_region2, guest_phys_addr) - 8usize];
    ["Offset of field: kvm_userspace_memory_region2::memory_size"]
        [::std::mem::offset_of!(kvm_userspace_memory_region2, memory_size) - 16usize];
    ["Offset of field: kvm_userspace_memory_region2::userspace_addr"]
        [::std::mem::offset_of!(kvm_userspace_memory_region2, userspace_addr) - 24usize];
    ["Offset of field: kvm_userspace_memory_region2::guest_memfd_offset"]
        [::std::mem::offset_of!(kvm_userspace_memory_region2, guest_memfd_offset) - 32usize];
    ["Offset of field: kvm_userspace_memory_region2::guest_memfd"]
        [::std::mem::offset_of!(kvm_userspace_memory_region2, guest_memfd) - 40usize];
    ["Offset of field: kvm_userspace_memory_region2::pad1"]
        [::std::mem::offset_of!(kvm_userspace_memory_region2, pad1) - 44usize];
    ["Offset of field: kvm_userspace_memory_region2::pad2"]
        [::std::mem::offset_of!(kvm_userspace_memory_region2, pad2) - 48usize];
};
#[repr(C)]
#[derive(Copy, Clone)]
pub struct kvm_irq_level {
    pub __bindgen_anon_1: kvm_irq_level__bindgen_ty_1,
    pub level: __u32,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union kvm_irq_level__bindgen_ty_1 {
    pub irq: __u32,
    pub status: __s32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_irq_level__bindgen_ty_1"]
        [::std::mem::size_of::<kvm_irq_level__bindgen_ty_1>() - 4usize];
    ["Alignment of kvm_irq_level__bindgen_ty_1"]
        [::std::mem::align_of::<kvm_irq_level__bindgen_ty_1>() - 4usize];
    ["Offset of field: kvm_irq_level__bindgen_ty_1::irq"]
        [::std::mem::offset_of!(kvm_irq_level__bindgen_ty_1, irq) - 0usize];
    ["Offset of field: kvm_irq_level__bindgen_ty_1::status"]
        [::std::mem::offset_of!(kvm_irq_level__bindgen_ty_1, status) - 0usize];
};
impl Default for kvm_irq_level__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for kvm_irq_level__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "kvm_irq_level__bindgen_ty_1 {{ union }}")
    }
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_irq_level"][::std::mem::size_of::<kvm_irq_level>() - 8usize];
    ["Alignment of kvm_irq_level"][::std::mem::align_of::<kvm_irq_level>() - 4usize];
    ["Offset of field: kvm_irq_level::level"]
        [::std::mem::offset_of!(kvm_irq_level, level) - 4usize];
};
impl Default for kvm_irq_level {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for kvm_irq_level {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(
            f,
            "kvm_irq_level {{ __bindgen_anon_1: {:?}, level: {:?} }}",
            self.__bindgen_anon_1, self.level
        )
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
#[cfg_attr(
    feature = "serde",
    derive(zerocopy::AsBytes, zerocopy::FromBytes, zerocopy::FromZeroes)
)]
pub struct kvm_irqchip {
    pub chip_id: __u32,
    pub pad: __u32,
    pub chip: kvm_irqchip__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union kvm_irqchip__bindgen_ty_1 {
    pub dummy: [::std::os::raw::c_char; 512usize],
    pub pic: kvm_pic_state,
    pub ioapic: kvm_ioapic_state,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_irqchip__bindgen_ty_1"]
        [::std::mem::size_of::<kvm_irqchip__bindgen_ty_1>() - 512usize];
    ["Alignment of kvm_irqchip__bindgen_ty_1"]
        [::std::mem::align_of::<kvm_irqchip__bindgen_ty_1>() - 8usize];
    ["Offset of field: kvm_irqchip__bindgen_ty_1::dummy"]
        [::std::mem::offset_of!(kvm_irqchip__bindgen_ty_1, dummy) - 0usize];
    ["Offset of field: kvm_irqchip__bindgen_ty_1::pic"]
        [::std::mem::offset_of!(kvm_irqchip__bindgen_ty_1, pic) - 0usize];
    ["Offset of field: kvm_irqchip__bindgen_ty_1::ioapic"]
        [::std::mem::offset_of!(kvm_irqchip__bindgen_ty_1, ioapic) - 0usize];
};
impl Default for kvm_irqchip__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for kvm_irqchip__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "kvm_irqchip__bindgen_ty_1 {{ union }}")
    }
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_irqchip"][::std::mem::size_of::<kvm_irqchip>() - 520usize];
    ["Alignment of kvm_irqchip"][::std::mem::align_of::<kvm_irqchip>() - 8usize];
    ["Offset of field: kvm_irqchip::chip_id"]
        [::std::mem::offset_of!(kvm_irqchip, chip_id) - 0usize];
    ["Offset of field: kvm_irqchip::pad"][::std::mem::offset_of!(kvm_irqchip, pad) - 4usize];
    ["Offset of field: kvm_irqchip::chip"][::std::mem::offset_of!(kvm_irqchip, chip) - 8usize];
};
impl Default for kvm_irqchip {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for kvm_irqchip {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(
            f,
            "kvm_irqchip {{ chip_id: {:?}, pad: {:?}, chip: {:?} }}",
            self.chip_id, self.pad, self.chip
        )
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_pit_config {
    pub flags: __u32,
    pub pad: [__u32; 15usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_pit_config"][::std::mem::size_of::<kvm_pit_config>() - 64usize];
    ["Alignment of kvm_pit_config"][::std::mem::align_of::<kvm_pit_config>() - 4usize];
    ["Offset of field: kvm_pit_config::flags"]
        [::std::mem::offset_of!(kvm_pit_config, flags) - 0usize];
    ["Offset of field: kvm_pit_config::pad"][::std::mem::offset_of!(kvm_pit_config, pad) - 4usize];
};
#[repr(C)]
#[derive(Copy, Clone)]
pub struct kvm_hyperv_exit {
    pub type_: __u32,
    pub pad1: __u32,
    pub u: kvm_hyperv_exit__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union kvm_hyperv_exit__bindgen_ty_1 {
    pub synic: kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_1,
    pub hcall: kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_2,
    pub syndbg: kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_3,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_1 {
    pub msr: __u32,
    pub pad2: __u32,
    pub control: __u64,
    pub evt_page: __u64,
    pub msg_page: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_1"]
        [::std::mem::size_of::<kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_1>() - 32usize];
    ["Alignment of kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_1"]
        [::std::mem::align_of::<kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_1>() - 8usize];
    ["Offset of field: kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_1::msr"]
        [::std::mem::offset_of!(kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_1, msr) - 0usize];
    ["Offset of field: kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_1::pad2"]
        [::std::mem::offset_of!(kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_1, pad2) - 4usize];
    ["Offset of field: kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_1::control"]
        [::std::mem::offset_of!(kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_1, control) - 8usize];
    ["Offset of field: kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_1::evt_page"]
        [::std::mem::offset_of!(kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_1, evt_page) - 16usize];
    ["Offset of field: kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_1::msg_page"]
        [::std::mem::offset_of!(kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_1, msg_page) - 24usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_2 {
    pub input: __u64,
    pub result: __u64,
    pub params: [__u64; 2usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_2"]
        [::std::mem::size_of::<kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_2>() - 32usize];
    ["Alignment of kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_2"]
        [::std::mem::align_of::<kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_2>() - 8usize];
    ["Offset of field: kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_2::input"]
        [::std::mem::offset_of!(kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_2, input) - 0usize];
    ["Offset of field: kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_2::result"]
        [::std::mem::offset_of!(kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_2, result) - 8usize];
    ["Offset of field: kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_2::params"]
        [::std::mem::offset_of!(kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_2, params) - 16usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_3 {
    pub msr: __u32,
    pub pad2: __u32,
    pub control: __u64,
    pub status: __u64,
    pub send_page: __u64,
    pub recv_page: __u64,
    pub pending_page: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_3"]
        [::std::mem::size_of::<kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_3>() - 48usize];
    ["Alignment of kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_3"]
        [::std::mem::align_of::<kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_3>() - 8usize];
    ["Offset of field: kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_3::msr"]
        [::std::mem::offset_of!(kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_3, msr) - 0usize];
    ["Offset of field: kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_3::pad2"]
        [::std::mem::offset_of!(kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_3, pad2) - 4usize];
    ["Offset of field: kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_3::control"]
        [::std::mem::offset_of!(kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_3, control) - 8usize];
    ["Offset of field: kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_3::status"]
        [::std::mem::offset_of!(kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_3, status) - 16usize];
    ["Offset of field: kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_3::send_page"]
        [::std::mem::offset_of!(kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_3, send_page) - 24usize];
    ["Offset of field: kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_3::recv_page"]
        [::std::mem::offset_of!(kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_3, recv_page) - 32usize];
    ["Offset of field: kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_3::pending_page"][::std::mem::offset_of!(
        kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_3,
        pending_page
    ) - 40usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_hyperv_exit__bindgen_ty_1"]
        [::std::mem::size_of::<kvm_hyperv_exit__bindgen_ty_1>() - 48usize];
    ["Alignment of kvm_hyperv_exit__bindgen_ty_1"]
        [::std::mem::align_of::<kvm_hyperv_exit__bindgen_ty_1>() - 8usize];
    ["Offset of field: kvm_hyperv_exit__bindgen_ty_1::synic"]
        [::std::mem::offset_of!(kvm_hyperv_exit__bindgen_ty_1, synic) - 0usize];
    ["Offset of field: kvm_hyperv_exit__bindgen_ty_1::hcall"]
        [::std::mem::offset_of!(kvm_hyperv_exit__bindgen_ty_1, hcall) - 0usize];
    ["Offset of field: kvm_hyperv_exit__bindgen_ty_1::syndbg"]
        [::std::mem::offset_of!(kvm_hyperv_exit__bindgen_ty_1, syndbg) - 0usize];
};
impl Default for kvm_hyperv_exit__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for kvm_hyperv_exit__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "kvm_hyperv_exit__bindgen_ty_1 {{ union }}")
    }
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_hyperv_exit"][::std::mem::size_of::<kvm_hyperv_exit>() - 56usize];
    ["Alignment of kvm_hyperv_exit"][::std::mem::align_of::<kvm_hyperv_exit>() - 8usize];
    ["Offset of field: kvm_hyperv_exit::type_"]
        [::std::mem::offset_of!(kvm_hyperv_exit, type_) - 0usize];
    ["Offset of field: kvm_hyperv_exit::pad1"]
        [::std::mem::offset_of!(kvm_hyperv_exit, pad1) - 4usize];
    ["Offset of field: kvm_hyperv_exit::u"][::std::mem::offset_of!(kvm_hyperv_exit, u) - 8usize];
};
impl Default for kvm_hyperv_exit {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for kvm_hyperv_exit {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(
            f,
            "kvm_hyperv_exit {{ type: {:?}, pad1: {:?}, u: {:?} }}",
            self.type_, self.pad1, self.u
        )
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct kvm_xen_exit {
    pub type_: __u32,
    pub u: kvm_xen_exit__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union kvm_xen_exit__bindgen_ty_1 {
    pub hcall: kvm_xen_exit__bindgen_ty_1__bindgen_ty_1,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_xen_exit__bindgen_ty_1__bindgen_ty_1 {
    pub longmode: __u32,
    pub cpl: __u32,
    pub input: __u64,
    pub result: __u64,
    pub params: [__u64; 6usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_xen_exit__bindgen_ty_1__bindgen_ty_1"]
        [::std::mem::size_of::<kvm_xen_exit__bindgen_ty_1__bindgen_ty_1>() - 72usize];
    ["Alignment of kvm_xen_exit__bindgen_ty_1__bindgen_ty_1"]
        [::std::mem::align_of::<kvm_xen_exit__bindgen_ty_1__bindgen_ty_1>() - 8usize];
    ["Offset of field: kvm_xen_exit__bindgen_ty_1__bindgen_ty_1::longmode"]
        [::std::mem::offset_of!(kvm_xen_exit__bindgen_ty_1__bindgen_ty_1, longmode) - 0usize];
    ["Offset of field: kvm_xen_exit__bindgen_ty_1__bindgen_ty_1::cpl"]
        [::std::mem::offset_of!(kvm_xen_exit__bindgen_ty_1__bindgen_ty_1, cpl) - 4usize];
    ["Offset of field: kvm_xen_exit__bindgen_ty_1__bindgen_ty_1::input"]
        [::std::mem::offset_of!(kvm_xen_exit__bindgen_ty_1__bindgen_ty_1, input) - 8usize];
    ["Offset of field: kvm_xen_exit__bindgen_ty_1__bindgen_ty_1::result"]
        [::std::mem::offset_of!(kvm_xen_exit__bindgen_ty_1__bindgen_ty_1, result) - 16usize];
    ["Offset of field: kvm_xen_exit__bindgen_ty_1__bindgen_ty_1::params"]
        [::std::mem::offset_of!(kvm_xen_exit__bindgen_ty_1__bindgen_ty_1, params) - 24usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_xen_exit__bindgen_ty_1"]
        [::std::mem::size_of::<kvm_xen_exit__bindgen_ty_1>() - 72usize];
    ["Alignment of kvm_xen_exit__bindgen_ty_1"]
        [::std::mem::align_of::<kvm_xen_exit__bindgen_ty_1>() - 8usize];
    ["Offset of field: kvm_xen_exit__bindgen_ty_1::hcall"]
        [::std::mem::offset_of!(kvm_xen_exit__bindgen_ty_1, hcall) - 0usize];
};
impl Default for kvm_xen_exit__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for kvm_xen_exit__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "kvm_xen_exit__bindgen_ty_1 {{ union }}")
    }
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_xen_exit"][::std::mem::size_of::<kvm_xen_exit>() - 80usize];
    ["Alignment of kvm_xen_exit"][::std::mem::align_of::<kvm_xen_exit>() - 8usize];
    ["Offset of field: kvm_xen_exit::type_"][::std::mem::offset_of!(kvm_xen_exit, type_) - 0usize];
    ["Offset of field: kvm_xen_exit::u"][::std::mem::offset_of!(kvm_xen_exit, u) - 8usize];
};
impl Default for kvm_xen_exit {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for kvm_xen_exit {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(
            f,
            "kvm_xen_exit {{ type: {:?}, u: {:?} }}",
            self.type_, self.u
        )
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct kvm_run {
    pub request_interrupt_window: __u8,
    pub immediate_exit: __u8,
    pub padding1: [__u8; 6usize],
    pub exit_reason: __u32,
    pub ready_for_interrupt_injection: __u8,
    pub if_flag: __u8,
    pub flags: __u16,
    pub cr8: __u64,
    pub apic_base: __u64,
    pub __bindgen_anon_1: kvm_run__bindgen_ty_1,
    pub kvm_valid_regs: __u64,
    pub kvm_dirty_regs: __u64,
    pub s: kvm_run__bindgen_ty_2,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union kvm_run__bindgen_ty_1 {
    pub hw: kvm_run__bindgen_ty_1__bindgen_ty_1,
    pub fail_entry: kvm_run__bindgen_ty_1__bindgen_ty_2,
    pub ex: kvm_run__bindgen_ty_1__bindgen_ty_3,
    pub io: kvm_run__bindgen_ty_1__bindgen_ty_4,
    pub debug: kvm_run__bindgen_ty_1__bindgen_ty_5,
    pub mmio: kvm_run__bindgen_ty_1__bindgen_ty_6,
    pub iocsr_io: kvm_run__bindgen_ty_1__bindgen_ty_7,
    pub hypercall: kvm_run__bindgen_ty_1__bindgen_ty_8,
    pub tpr_access: kvm_run__bindgen_ty_1__bindgen_ty_9,
    pub s390_sieic: kvm_run__bindgen_ty_1__bindgen_ty_10,
    pub s390_reset_flags: __u64,
    pub s390_ucontrol: kvm_run__bindgen_ty_1__bindgen_ty_11,
    pub dcr: kvm_run__bindgen_ty_1__bindgen_ty_12,
    pub internal: kvm_run__bindgen_ty_1__bindgen_ty_13,
    pub emulation_failure: kvm_run__bindgen_ty_1__bindgen_ty_14,
    pub osi: kvm_run__bindgen_ty_1__bindgen_ty_15,
    pub papr_hcall: kvm_run__bindgen_ty_1__bindgen_ty_16,
    pub s390_tsch: kvm_run__bindgen_ty_1__bindgen_ty_17,
    pub epr: kvm_run__bindgen_ty_1__bindgen_ty_18,
    pub system_event: kvm_run__bindgen_ty_1__bindgen_ty_19,
    pub s390_stsi: kvm_run__bindgen_ty_1__bindgen_ty_20,
    pub eoi: kvm_run__bindgen_ty_1__bindgen_ty_21,
    pub hyperv: kvm_hyperv_exit,
    pub arm_nisv: kvm_run__bindgen_ty_1__bindgen_ty_22,
    pub msr: kvm_run__bindgen_ty_1__bindgen_ty_23,
    pub xen: kvm_xen_exit,
    pub riscv_sbi: kvm_run__bindgen_ty_1__bindgen_ty_24,
    pub riscv_csr: kvm_run__bindgen_ty_1__bindgen_ty_25,
    pub notify: kvm_run__bindgen_ty_1__bindgen_ty_26,
    pub memory_fault: kvm_run__bindgen_ty_1__bindgen_ty_27,
    pub padding: [::std::os::raw::c_char; 256usize],
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_1 {
    pub hardware_exit_reason: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_run__bindgen_ty_1__bindgen_ty_1"]
        [::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_1>() - 8usize];
    ["Alignment of kvm_run__bindgen_ty_1__bindgen_ty_1"]
        [::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_1>() - 8usize];
    ["Offset of field: kvm_run__bindgen_ty_1__bindgen_ty_1::hardware_exit_reason"][::std::mem::offset_of!(
        kvm_run__bindgen_ty_1__bindgen_ty_1,
        hardware_exit_reason
    ) - 0usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_2 {
    pub hardware_entry_failure_reason: __u64,
    pub cpu: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_run__bindgen_ty_1__bindgen_ty_2"]
        [::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_2>() - 16usize];
    ["Alignment of kvm_run__bindgen_ty_1__bindgen_ty_2"]
        [::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_2>() - 8usize];
    ["Offset of field: kvm_run__bindgen_ty_1__bindgen_ty_2::hardware_entry_failure_reason"][::std::mem::offset_of!(
        kvm_run__bindgen_ty_1__bindgen_ty_2,
        hardware_entry_failure_reason
    )
        - 0usize];
    ["Offset of field: kvm_run__bindgen_ty_1__bindgen_ty_2::cpu"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1__bindgen_ty_2, cpu) - 8usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_3 {
    pub exception: __u32,
    pub error_code: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_run__bindgen_ty_1__bindgen_ty_3"]
        [::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_3>() - 8usize];
    ["Alignment of kvm_run__bindgen_ty_1__bindgen_ty_3"]
        [::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_3>() - 4usize];
    ["Offset of field: kvm_run__bindgen_ty_1__bindgen_ty_3::exception"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1__bindgen_ty_3, exception) - 0usize];
    ["Offset of field: kvm_run__bindgen_ty_1__bindgen_ty_3::error_code"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1__bindgen_ty_3, error_code) - 4usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_4 {
    pub direction: __u8,
    pub size: __u8,
    pub port: __u16,
    pub count: __u32,
    pub data_offset: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_run__bindgen_ty_1__bindgen_ty_4"]
        [::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_4>() - 16usize];
    ["Alignment of kvm_run__bindgen_ty_1__bindgen_ty_4"]
        [::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_4>() - 8usize];
    ["Offset of field: kvm_run__bindgen_ty_1__bindgen_ty_4::direction"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1__bindgen_ty_4, direction) - 0usize];
    ["Offset of field: kvm_run__bindgen_ty_1__bindgen_ty_4::size"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1__bindgen_ty_4, size) - 1usize];
    ["Offset of field: kvm_run__bindgen_ty_1__bindgen_ty_4::port"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1__bindgen_ty_4, port) - 2usize];
    ["Offset of field: kvm_run__bindgen_ty_1__bindgen_ty_4::count"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1__bindgen_ty_4, count) - 4usize];
    ["Offset of field: kvm_run__bindgen_ty_1__bindgen_ty_4::data_offset"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1__bindgen_ty_4, data_offset) - 8usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_5 {
    pub arch: kvm_debug_exit_arch,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_run__bindgen_ty_1__bindgen_ty_5"]
        [::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_5>() - 32usize];
    ["Alignment of kvm_run__bindgen_ty_1__bindgen_ty_5"]
        [::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_5>() - 8usize];
    ["Offset of field: kvm_run__bindgen_ty_1__bindgen_ty_5::arch"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1__bindgen_ty_5, arch) - 0usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_6 {
    pub phys_addr: __u64,
    pub data: [__u8; 8usize],
    pub len: __u32,
    pub is_write: __u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_run__bindgen_ty_1__bindgen_ty_6"]
        [::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_6>() - 24usize];
    ["Alignment of kvm_run__bindgen_ty_1__bindgen_ty_6"]
        [::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_6>() - 8usize];
    ["Offset of field: kvm_run__bindgen_ty_1__bindgen_ty_6::phys_addr"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1__bindgen_ty_6, phys_addr) - 0usize];
    ["Offset of field: kvm_run__bindgen_ty_1__bindgen_ty_6::data"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1__bindgen_ty_6, data) - 8usize];
    ["Offset of field: kvm_run__bindgen_ty_1__bindgen_ty_6::len"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1__bindgen_ty_6, len) - 16usize];
    ["Offset of field: kvm_run__bindgen_ty_1__bindgen_ty_6::is_write"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1__bindgen_ty_6, is_write) - 20usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_7 {
    pub phys_addr: __u64,
    pub data: [__u8; 8usize],
    pub len: __u32,
    pub is_write: __u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_run__bindgen_ty_1__bindgen_ty_7"]
        [::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_7>() - 24usize];
    ["Alignment of kvm_run__bindgen_ty_1__bindgen_ty_7"]
        [::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_7>() - 8usize];
    ["Offset of field: kvm_run__bindgen_ty_1__bindgen_ty_7::phys_addr"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1__bindgen_ty_7, phys_addr) - 0usize];
    ["Offset of field: kvm_run__bindgen_ty_1__bindgen_ty_7::data"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1__bindgen_ty_7, data) - 8usize];
    ["Offset of field: kvm_run__bindgen_ty_1__bindgen_ty_7::len"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1__bindgen_ty_7, len) - 16usize];
    ["Offset of field: kvm_run__bindgen_ty_1__bindgen_ty_7::is_write"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1__bindgen_ty_7, is_write) - 20usize];
};
#[repr(C)]
#[derive(Copy, Clone)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_8 {
    pub nr: __u64,
    pub args: [__u64; 6usize],
    pub ret: __u64,
    pub __bindgen_anon_1: kvm_run__bindgen_ty_1__bindgen_ty_8__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union kvm_run__bindgen_ty_1__bindgen_ty_8__bindgen_ty_1 {
    pub longmode: __u32,
    pub flags: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_run__bindgen_ty_1__bindgen_ty_8__bindgen_ty_1"]
        [::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_8__bindgen_ty_1>() - 8usize];
    ["Alignment of kvm_run__bindgen_ty_1__bindgen_ty_8__bindgen_ty_1"]
        [::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_8__bindgen_ty_1>() - 8usize];
    ["Offset of field: kvm_run__bindgen_ty_1__bindgen_ty_8__bindgen_ty_1::longmode"][::std::mem::offset_of!(
        kvm_run__bindgen_ty_1__bindgen_ty_8__bindgen_ty_1,
        longmode
    ) - 0usize];
    ["Offset of field: kvm_run__bindgen_ty_1__bindgen_ty_8__bindgen_ty_1::flags"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1__bindgen_ty_8__bindgen_ty_1, flags) - 0usize];
};
impl Default for kvm_run__bindgen_ty_1__bindgen_ty_8__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for kvm_run__bindgen_ty_1__bindgen_ty_8__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(
            f,
            "kvm_run__bindgen_ty_1__bindgen_ty_8__bindgen_ty_1 {{ union }}"
        )
    }
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_run__bindgen_ty_1__bindgen_ty_8"]
        [::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_8>() - 72usize];
    ["Alignment of kvm_run__bindgen_ty_1__bindgen_ty_8"]
        [::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_8>() - 8usize];
    ["Offset of field: kvm_run__bindgen_ty_1__bindgen_ty_8::nr"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1__bindgen_ty_8, nr) - 0usize];
    ["Offset of field: kvm_run__bindgen_ty_1__bindgen_ty_8::args"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1__bindgen_ty_8, args) - 8usize];
    ["Offset of field: kvm_run__bindgen_ty_1__bindgen_ty_8::ret"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1__bindgen_ty_8, ret) - 56usize];
};
impl Default for kvm_run__bindgen_ty_1__bindgen_ty_8 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for kvm_run__bindgen_ty_1__bindgen_ty_8 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write ! (f , "kvm_run__bindgen_ty_1__bindgen_ty_8 {{ nr: {:?}, args: {:?}, ret: {:?}, __bindgen_anon_1: {:?} }}" , self . nr , self . args , self . ret , self . __bindgen_anon_1)
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_9 {
    pub rip: __u64,
    pub is_write: __u32,
    pub pad: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_run__bindgen_ty_1__bindgen_ty_9"]
        [::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_9>() - 16usize];
    ["Alignment of kvm_run__bindgen_ty_1__bindgen_ty_9"]
        [::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_9>() - 8usize];
    ["Offset of field: kvm_run__bindgen_ty_1__bindgen_ty_9::rip"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1__bindgen_ty_9, rip) - 0usize];
    ["Offset of field: kvm_run__bindgen_ty_1__bindgen_ty_9::is_write"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1__bindgen_ty_9, is_write) - 8usize];
    ["Offset of field: kvm_run__bindgen_ty_1__bindgen_ty_9::pad"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1__bindgen_ty_9, pad) - 12usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_10 {
    pub icptcode: __u8,
    pub ipa: __u16,
    pub ipb: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_run__bindgen_ty_1__bindgen_ty_10"]
        [::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_10>() - 8usize];
    ["Alignment of kvm_run__bindgen_ty_1__bindgen_ty_10"]
        [::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_10>() - 4usize];
    ["Offset of field: kvm_run__bindgen_ty_1__bindgen_ty_10::icptcode"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1__bindgen_ty_10, icptcode) - 0usize];
    ["Offset of field: kvm_run__bindgen_ty_1__bindgen_ty_10::ipa"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1__bindgen_ty_10, ipa) - 2usize];
    ["Offset of field: kvm_run__bindgen_ty_1__bindgen_ty_10::ipb"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1__bindgen_ty_10, ipb) - 4usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_11 {
    pub trans_exc_code: __u64,
    pub pgm_code: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_run__bindgen_ty_1__bindgen_ty_11"]
        [::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_11>() - 16usize];
    ["Alignment of kvm_run__bindgen_ty_1__bindgen_ty_11"]
        [::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_11>() - 8usize];
    ["Offset of field: kvm_run__bindgen_ty_1__bindgen_ty_11::trans_exc_code"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1__bindgen_ty_11, trans_exc_code) - 0usize];
    ["Offset of field: kvm_run__bindgen_ty_1__bindgen_ty_11::pgm_code"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1__bindgen_ty_11, pgm_code) - 8usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_12 {
    pub dcrn: __u32,
    pub data: __u32,
    pub is_write: __u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_run__bindgen_ty_1__bindgen_ty_12"]
        [::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_12>() - 12usize];
    ["Alignment of kvm_run__bindgen_ty_1__bindgen_ty_12"]
        [::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_12>() - 4usize];
    ["Offset of field: kvm_run__bindgen_ty_1__bindgen_ty_12::dcrn"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1__bindgen_ty_12, dcrn) - 0usize];
    ["Offset of field: kvm_run__bindgen_ty_1__bindgen_ty_12::data"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1__bindgen_ty_12, data) - 4usize];
    ["Offset of field: kvm_run__bindgen_ty_1__bindgen_ty_12::is_write"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1__bindgen_ty_12, is_write) - 8usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_13 {
    pub suberror: __u32,
    pub ndata: __u32,
    pub data: [__u64; 16usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_run__bindgen_ty_1__bindgen_ty_13"]
        [::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_13>() - 136usize];
    ["Alignment of kvm_run__bindgen_ty_1__bindgen_ty_13"]
        [::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_13>() - 8usize];
    ["Offset of field: kvm_run__bindgen_ty_1__bindgen_ty_13::suberror"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1__bindgen_ty_13, suberror) - 0usize];
    ["Offset of field: kvm_run__bindgen_ty_1__bindgen_ty_13::ndata"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1__bindgen_ty_13, ndata) - 4usize];
    ["Offset of field: kvm_run__bindgen_ty_1__bindgen_ty_13::data"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1__bindgen_ty_13, data) - 8usize];
};
#[repr(C)]
#[derive(Copy, Clone)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_14 {
    pub suberror: __u32,
    pub ndata: __u32,
    pub flags: __u64,
    pub __bindgen_anon_1: kvm_run__bindgen_ty_1__bindgen_ty_14__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union kvm_run__bindgen_ty_1__bindgen_ty_14__bindgen_ty_1 {
    pub __bindgen_anon_1: kvm_run__bindgen_ty_1__bindgen_ty_14__bindgen_ty_1__bindgen_ty_1,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_14__bindgen_ty_1__bindgen_ty_1 {
    pub insn_size: __u8,
    pub insn_bytes: [__u8; 15usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_run__bindgen_ty_1__bindgen_ty_14__bindgen_ty_1__bindgen_ty_1"][::std::mem::size_of::<
        kvm_run__bindgen_ty_1__bindgen_ty_14__bindgen_ty_1__bindgen_ty_1,
    >() - 16usize];
    ["Alignment of kvm_run__bindgen_ty_1__bindgen_ty_14__bindgen_ty_1__bindgen_ty_1"]
        [::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_14__bindgen_ty_1__bindgen_ty_1>(
        ) - 1usize];
    ["Offset of field: kvm_run__bindgen_ty_1__bindgen_ty_14__bindgen_ty_1__bindgen_ty_1::insn_size"] [:: std :: mem :: offset_of ! (kvm_run__bindgen_ty_1__bindgen_ty_14__bindgen_ty_1__bindgen_ty_1 , insn_size) - 0usize] ;
    ["Offset of field: kvm_run__bindgen_ty_1__bindgen_ty_14__bindgen_ty_1__bindgen_ty_1::insn_bytes"] [:: std :: mem :: offset_of ! (kvm_run__bindgen_ty_1__bindgen_ty_14__bindgen_ty_1__bindgen_ty_1 , insn_bytes) - 1usize] ;
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_run__bindgen_ty_1__bindgen_ty_14__bindgen_ty_1"]
        [::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_14__bindgen_ty_1>() - 16usize];
    ["Alignment of kvm_run__bindgen_ty_1__bindgen_ty_14__bindgen_ty_1"]
        [::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_14__bindgen_ty_1>() - 1usize];
};
impl Default for kvm_run__bindgen_ty_1__bindgen_ty_14__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for kvm_run__bindgen_ty_1__bindgen_ty_14__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(
            f,
            "kvm_run__bindgen_ty_1__bindgen_ty_14__bindgen_ty_1 {{ union }}"
        )
    }
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_run__bindgen_ty_1__bindgen_ty_14"]
        [::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_14>() - 32usize];
    ["Alignment of kvm_run__bindgen_ty_1__bindgen_ty_14"]
        [::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_14>() - 8usize];
    ["Offset of field: kvm_run__bindgen_ty_1__bindgen_ty_14::suberror"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1__bindgen_ty_14, suberror) - 0usize];
    ["Offset of field: kvm_run__bindgen_ty_1__bindgen_ty_14::ndata"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1__bindgen_ty_14, ndata) - 4usize];
    ["Offset of field: kvm_run__bindgen_ty_1__bindgen_ty_14::flags"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1__bindgen_ty_14, flags) - 8usize];
};
impl Default for kvm_run__bindgen_ty_1__bindgen_ty_14 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for kvm_run__bindgen_ty_1__bindgen_ty_14 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write ! (f , "kvm_run__bindgen_ty_1__bindgen_ty_14 {{ suberror: {:?}, ndata: {:?}, flags: {:?}, __bindgen_anon_1: {:?} }}" , self . suberror , self . ndata , self . flags , self . __bindgen_anon_1)
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_15 {
    pub gprs: [__u64; 32usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_run__bindgen_ty_1__bindgen_ty_15"]
        [::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_15>() - 256usize];
    ["Alignment of kvm_run__bindgen_ty_1__bindgen_ty_15"]
        [::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_15>() - 8usize];
    ["Offset of field: kvm_run__bindgen_ty_1__bindgen_ty_15::gprs"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1__bindgen_ty_15, gprs) - 0usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_16 {
    pub nr: __u64,
    pub ret: __u64,
    pub args: [__u64; 9usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_run__bindgen_ty_1__bindgen_ty_16"]
        [::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_16>() - 88usize];
    ["Alignment of kvm_run__bindgen_ty_1__bindgen_ty_16"]
        [::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_16>() - 8usize];
    ["Offset of field: kvm_run__bindgen_ty_1__bindgen_ty_16::nr"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1__bindgen_ty_16, nr) - 0usize];
    ["Offset of field: kvm_run__bindgen_ty_1__bindgen_ty_16::ret"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1__bindgen_ty_16, ret) - 8usize];
    ["Offset of field: kvm_run__bindgen_ty_1__bindgen_ty_16::args"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1__bindgen_ty_16, args) - 16usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_17 {
    pub subchannel_id: __u16,
    pub subchannel_nr: __u16,
    pub io_int_parm: __u32,
    pub io_int_word: __u32,
    pub ipb: __u32,
    pub dequeued: __u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_run__bindgen_ty_1__bindgen_ty_17"]
        [::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_17>() - 20usize];
    ["Alignment of kvm_run__bindgen_ty_1__bindgen_ty_17"]
        [::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_17>() - 4usize];
    ["Offset of field: kvm_run__bindgen_ty_1__bindgen_ty_17::subchannel_id"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1__bindgen_ty_17, subchannel_id) - 0usize];
    ["Offset of field: kvm_run__bindgen_ty_1__bindgen_ty_17::subchannel_nr"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1__bindgen_ty_17, subchannel_nr) - 2usize];
    ["Offset of field: kvm_run__bindgen_ty_1__bindgen_ty_17::io_int_parm"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1__bindgen_ty_17, io_int_parm) - 4usize];
    ["Offset of field: kvm_run__bindgen_ty_1__bindgen_ty_17::io_int_word"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1__bindgen_ty_17, io_int_word) - 8usize];
    ["Offset of field: kvm_run__bindgen_ty_1__bindgen_ty_17::ipb"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1__bindgen_ty_17, ipb) - 12usize];
    ["Offset of field: kvm_run__bindgen_ty_1__bindgen_ty_17::dequeued"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1__bindgen_ty_17, dequeued) - 16usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_18 {
    pub epr: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_run__bindgen_ty_1__bindgen_ty_18"]
        [::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_18>() - 4usize];
    ["Alignment of kvm_run__bindgen_ty_1__bindgen_ty_18"]
        [::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_18>() - 4usize];
    ["Offset of field: kvm_run__bindgen_ty_1__bindgen_ty_18::epr"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1__bindgen_ty_18, epr) - 0usize];
};
#[repr(C)]
#[derive(Copy, Clone)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_19 {
    pub type_: __u32,
    pub ndata: __u32,
    pub __bindgen_anon_1: kvm_run__bindgen_ty_1__bindgen_ty_19__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union kvm_run__bindgen_ty_1__bindgen_ty_19__bindgen_ty_1 {
    pub flags: __u64,
    pub data: [__u64; 16usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_run__bindgen_ty_1__bindgen_ty_19__bindgen_ty_1"]
        [::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_19__bindgen_ty_1>() - 128usize];
    ["Alignment of kvm_run__bindgen_ty_1__bindgen_ty_19__bindgen_ty_1"]
        [::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_19__bindgen_ty_1>() - 8usize];
    ["Offset of field: kvm_run__bindgen_ty_1__bindgen_ty_19__bindgen_ty_1::flags"][::std::mem::offset_of!(
        kvm_run__bindgen_ty_1__bindgen_ty_19__bindgen_ty_1,
        flags
    ) - 0usize];
    ["Offset of field: kvm_run__bindgen_ty_1__bindgen_ty_19__bindgen_ty_1::data"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1__bindgen_ty_19__bindgen_ty_1, data) - 0usize];
};
impl Default for kvm_run__bindgen_ty_1__bindgen_ty_19__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for kvm_run__bindgen_ty_1__bindgen_ty_19__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(
            f,
            "kvm_run__bindgen_ty_1__bindgen_ty_19__bindgen_ty_1 {{ union }}"
        )
    }
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_run__bindgen_ty_1__bindgen_ty_19"]
        [::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_19>() - 136usize];
    ["Alignment of kvm_run__bindgen_ty_1__bindgen_ty_19"]
        [::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_19>() - 8usize];
    ["Offset of field: kvm_run__bindgen_ty_1__bindgen_ty_19::type_"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1__bindgen_ty_19, type_) - 0usize];
    ["Offset of field: kvm_run__bindgen_ty_1__bindgen_ty_19::ndata"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1__bindgen_ty_19, ndata) - 4usize];
};
impl Default for kvm_run__bindgen_ty_1__bindgen_ty_19 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for kvm_run__bindgen_ty_1__bindgen_ty_19 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write ! (f , "kvm_run__bindgen_ty_1__bindgen_ty_19 {{ type: {:?}, ndata: {:?}, __bindgen_anon_1: {:?} }}" , self . type_ , self . ndata , self . __bindgen_anon_1)
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_20 {
    pub addr: __u64,
    pub ar: __u8,
    pub reserved: __u8,
    pub fc: __u8,
    pub sel1: __u8,
    pub sel2: __u16,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_run__bindgen_ty_1__bindgen_ty_20"]
        [::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_20>() - 16usize];
    ["Alignment of kvm_run__bindgen_ty_1__bindgen_ty_20"]
        [::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_20>() - 8usize];
    ["Offset of field: kvm_run__bindgen_ty_1__bindgen_ty_20::addr"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1__bindgen_ty_20, addr) - 0usize];
    ["Offset of field: kvm_run__bindgen_ty_1__bindgen_ty_20::ar"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1__bindgen_ty_20, ar) - 8usize];
    ["Offset of field: kvm_run__bindgen_ty_1__bindgen_ty_20::reserved"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1__bindgen_ty_20, reserved) - 9usize];
    ["Offset of field: kvm_run__bindgen_ty_1__bindgen_ty_20::fc"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1__bindgen_ty_20, fc) - 10usize];
    ["Offset of field: kvm_run__bindgen_ty_1__bindgen_ty_20::sel1"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1__bindgen_ty_20, sel1) - 11usize];
    ["Offset of field: kvm_run__bindgen_ty_1__bindgen_ty_20::sel2"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1__bindgen_ty_20, sel2) - 12usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_21 {
    pub vector: __u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_run__bindgen_ty_1__bindgen_ty_21"]
        [::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_21>() - 1usize];
    ["Alignment of kvm_run__bindgen_ty_1__bindgen_ty_21"]
        [::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_21>() - 1usize];
    ["Offset of field: kvm_run__bindgen_ty_1__bindgen_ty_21::vector"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1__bindgen_ty_21, vector) - 0usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_22 {
    pub esr_iss: __u64,
    pub fault_ipa: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_run__bindgen_ty_1__bindgen_ty_22"]
        [::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_22>() - 16usize];
    ["Alignment of kvm_run__bindgen_ty_1__bindgen_ty_22"]
        [::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_22>() - 8usize];
    ["Offset of field: kvm_run__bindgen_ty_1__bindgen_ty_22::esr_iss"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1__bindgen_ty_22, esr_iss) - 0usize];
    ["Offset of field: kvm_run__bindgen_ty_1__bindgen_ty_22::fault_ipa"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1__bindgen_ty_22, fault_ipa) - 8usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_23 {
    pub error: __u8,
    pub pad: [__u8; 7usize],
    pub reason: __u32,
    pub index: __u32,
    pub data: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_run__bindgen_ty_1__bindgen_ty_23"]
        [::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_23>() - 24usize];
    ["Alignment of kvm_run__bindgen_ty_1__bindgen_ty_23"]
        [::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_23>() - 8usize];
    ["Offset of field: kvm_run__bindgen_ty_1__bindgen_ty_23::error"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1__bindgen_ty_23, error) - 0usize];
    ["Offset of field: kvm_run__bindgen_ty_1__bindgen_ty_23::pad"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1__bindgen_ty_23, pad) - 1usize];
    ["Offset of field: kvm_run__bindgen_ty_1__bindgen_ty_23::reason"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1__bindgen_ty_23, reason) - 8usize];
    ["Offset of field: kvm_run__bindgen_ty_1__bindgen_ty_23::index"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1__bindgen_ty_23, index) - 12usize];
    ["Offset of field: kvm_run__bindgen_ty_1__bindgen_ty_23::data"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1__bindgen_ty_23, data) - 16usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_24 {
    pub extension_id: ::std::os::raw::c_ulong,
    pub function_id: ::std::os::raw::c_ulong,
    pub args: [::std::os::raw::c_ulong; 6usize],
    pub ret: [::std::os::raw::c_ulong; 2usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_run__bindgen_ty_1__bindgen_ty_24"]
        [::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_24>() - 80usize];
    ["Alignment of kvm_run__bindgen_ty_1__bindgen_ty_24"]
        [::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_24>() - 8usize];
    ["Offset of field: kvm_run__bindgen_ty_1__bindgen_ty_24::extension_id"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1__bindgen_ty_24, extension_id) - 0usize];
    ["Offset of field: kvm_run__bindgen_ty_1__bindgen_ty_24::function_id"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1__bindgen_ty_24, function_id) - 8usize];
    ["Offset of field: kvm_run__bindgen_ty_1__bindgen_ty_24::args"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1__bindgen_ty_24, args) - 16usize];
    ["Offset of field: kvm_run__bindgen_ty_1__bindgen_ty_24::ret"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1__bindgen_ty_24, ret) - 64usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_25 {
    pub csr_num: ::std::os::raw::c_ulong,
    pub new_value: ::std::os::raw::c_ulong,
    pub write_mask: ::std::os::raw::c_ulong,
    pub ret_value: ::std::os::raw::c_ulong,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_run__bindgen_ty_1__bindgen_ty_25"]
        [::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_25>() - 32usize];
    ["Alignment of kvm_run__bindgen_ty_1__bindgen_ty_25"]
        [::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_25>() - 8usize];
    ["Offset of field: kvm_run__bindgen_ty_1__bindgen_ty_25::csr_num"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1__bindgen_ty_25, csr_num) - 0usize];
    ["Offset of field: kvm_run__bindgen_ty_1__bindgen_ty_25::new_value"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1__bindgen_ty_25, new_value) - 8usize];
    ["Offset of field: kvm_run__bindgen_ty_1__bindgen_ty_25::write_mask"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1__bindgen_ty_25, write_mask) - 16usize];
    ["Offset of field: kvm_run__bindgen_ty_1__bindgen_ty_25::ret_value"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1__bindgen_ty_25, ret_value) - 24usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_26 {
    pub flags: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_run__bindgen_ty_1__bindgen_ty_26"]
        [::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_26>() - 4usize];
    ["Alignment of kvm_run__bindgen_ty_1__bindgen_ty_26"]
        [::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_26>() - 4usize];
    ["Offset of field: kvm_run__bindgen_ty_1__bindgen_ty_26::flags"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1__bindgen_ty_26, flags) - 0usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_27 {
    pub flags: __u64,
    pub gpa: __u64,
    pub size: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_run__bindgen_ty_1__bindgen_ty_27"]
        [::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_27>() - 24usize];
    ["Alignment of kvm_run__bindgen_ty_1__bindgen_ty_27"]
        [::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_27>() - 8usize];
    ["Offset of field: kvm_run__bindgen_ty_1__bindgen_ty_27::flags"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1__bindgen_ty_27, flags) - 0usize];
    ["Offset of field: kvm_run__bindgen_ty_1__bindgen_ty_27::gpa"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1__bindgen_ty_27, gpa) - 8usize];
    ["Offset of field: kvm_run__bindgen_ty_1__bindgen_ty_27::size"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1__bindgen_ty_27, size) - 16usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_run__bindgen_ty_1"][::std::mem::size_of::<kvm_run__bindgen_ty_1>() - 256usize];
    ["Alignment of kvm_run__bindgen_ty_1"]
        [::std::mem::align_of::<kvm_run__bindgen_ty_1>() - 8usize];
    ["Offset of field: kvm_run__bindgen_ty_1::hw"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1, hw) - 0usize];
    ["Offset of field: kvm_run__bindgen_ty_1::fail_entry"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1, fail_entry) - 0usize];
    ["Offset of field: kvm_run__bindgen_ty_1::ex"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1, ex) - 0usize];
    ["Offset of field: kvm_run__bindgen_ty_1::io"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1, io) - 0usize];
    ["Offset of field: kvm_run__bindgen_ty_1::debug"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1, debug) - 0usize];
    ["Offset of field: kvm_run__bindgen_ty_1::mmio"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1, mmio) - 0usize];
    ["Offset of field: kvm_run__bindgen_ty_1::iocsr_io"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1, iocsr_io) - 0usize];
    ["Offset of field: kvm_run__bindgen_ty_1::hypercall"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1, hypercall) - 0usize];
    ["Offset of field: kvm_run__bindgen_ty_1::tpr_access"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1, tpr_access) - 0usize];
    ["Offset of field: kvm_run__bindgen_ty_1::s390_sieic"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1, s390_sieic) - 0usize];
    ["Offset of field: kvm_run__bindgen_ty_1::s390_reset_flags"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1, s390_reset_flags) - 0usize];
    ["Offset of field: kvm_run__bindgen_ty_1::s390_ucontrol"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1, s390_ucontrol) - 0usize];
    ["Offset of field: kvm_run__bindgen_ty_1::dcr"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1, dcr) - 0usize];
    ["Offset of field: kvm_run__bindgen_ty_1::internal"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1, internal) - 0usize];
    ["Offset of field: kvm_run__bindgen_ty_1::emulation_failure"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1, emulation_failure) - 0usize];
    ["Offset of field: kvm_run__bindgen_ty_1::osi"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1, osi) - 0usize];
    ["Offset of field: kvm_run__bindgen_ty_1::papr_hcall"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1, papr_hcall) - 0usize];
    ["Offset of field: kvm_run__bindgen_ty_1::s390_tsch"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1, s390_tsch) - 0usize];
    ["Offset of field: kvm_run__bindgen_ty_1::epr"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1, epr) - 0usize];
    ["Offset of field: kvm_run__bindgen_ty_1::system_event"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1, system_event) - 0usize];
    ["Offset of field: kvm_run__bindgen_ty_1::s390_stsi"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1, s390_stsi) - 0usize];
    ["Offset of field: kvm_run__bindgen_ty_1::eoi"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1, eoi) - 0usize];
    ["Offset of field: kvm_run__bindgen_ty_1::hyperv"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1, hyperv) - 0usize];
    ["Offset of field: kvm_run__bindgen_ty_1::arm_nisv"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1, arm_nisv) - 0usize];
    ["Offset of field: kvm_run__bindgen_ty_1::msr"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1, msr) - 0usize];
    ["Offset of field: kvm_run__bindgen_ty_1::xen"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1, xen) - 0usize];
    ["Offset of field: kvm_run__bindgen_ty_1::riscv_sbi"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1, riscv_sbi) - 0usize];
    ["Offset of field: kvm_run__bindgen_ty_1::riscv_csr"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1, riscv_csr) - 0usize];
    ["Offset of field: kvm_run__bindgen_ty_1::notify"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1, notify) - 0usize];
    ["Offset of field: kvm_run__bindgen_ty_1::memory_fault"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1, memory_fault) - 0usize];
    ["Offset of field: kvm_run__bindgen_ty_1::padding"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_1, padding) - 0usize];
};
impl Default for kvm_run__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for kvm_run__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "kvm_run__bindgen_ty_1 {{ union }}")
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union kvm_run__bindgen_ty_2 {
    pub regs: kvm_sync_regs,
    pub padding: [::std::os::raw::c_char; 2048usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_run__bindgen_ty_2"][::std::mem::size_of::<kvm_run__bindgen_ty_2>() - 2048usize];
    ["Alignment of kvm_run__bindgen_ty_2"]
        [::std::mem::align_of::<kvm_run__bindgen_ty_2>() - 8usize];
    ["Offset of field: kvm_run__bindgen_ty_2::regs"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_2, regs) - 0usize];
    ["Offset of field: kvm_run__bindgen_ty_2::padding"]
        [::std::mem::offset_of!(kvm_run__bindgen_ty_2, padding) - 0usize];
};
impl Default for kvm_run__bindgen_ty_2 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for kvm_run__bindgen_ty_2 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "kvm_run__bindgen_ty_2 {{ union }}")
    }
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_run"][::std::mem::size_of::<kvm_run>() - 2352usize];
    ["Alignment of kvm_run"][::std::mem::align_of::<kvm_run>() - 8usize];
    ["Offset of field: kvm_run::request_interrupt_window"]
        [::std::mem::offset_of!(kvm_run, request_interrupt_window) - 0usize];
    ["Offset of field: kvm_run::immediate_exit"]
        [::std::mem::offset_of!(kvm_run, immediate_exit) - 1usize];
    ["Offset of field: kvm_run::padding1"][::std::mem::offset_of!(kvm_run, padding1) - 2usize];
    ["Offset of field: kvm_run::exit_reason"]
        [::std::mem::offset_of!(kvm_run, exit_reason) - 8usize];
    ["Offset of field: kvm_run::ready_for_interrupt_injection"]
        [::std::mem::offset_of!(kvm_run, ready_for_interrupt_injection) - 12usize];
    ["Offset of field: kvm_run::if_flag"][::std::mem::offset_of!(kvm_run, if_flag) - 13usize];
    ["Offset of field: kvm_run::flags"][::std::mem::offset_of!(kvm_run, flags) - 14usize];
    ["Offset of field: kvm_run::cr8"][::std::mem::offset_of!(kvm_run, cr8) - 16usize];
    ["Offset of field: kvm_run::apic_base"][::std::mem::offset_of!(kvm_run, apic_base) - 24usize];
    ["Offset of field: kvm_run::kvm_valid_regs"]
        [::std::mem::offset_of!(kvm_run, kvm_valid_regs) - 288usize];
    ["Offset of field: kvm_run::kvm_dirty_regs"]
        [::std::mem::offset_of!(kvm_run, kvm_dirty_regs) - 296usize];
    ["Offset of field: kvm_run::s"][::std::mem::offset_of!(kvm_run, s) - 304usize];
};
impl Default for kvm_run {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for kvm_run {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write ! (f , "kvm_run {{ request_interrupt_window: {:?}, immediate_exit: {:?}, padding1: {:?}, exit_reason: {:?}, ready_for_interrupt_injection: {:?}, if_flag: {:?}, flags: {:?}, cr8: {:?}, apic_base: {:?}, __bindgen_anon_1: {:?}, kvm_valid_regs: {:?}, kvm_dirty_regs: {:?}, s: {:?} }}" , self . request_interrupt_window , self . immediate_exit , self . padding1 , self . exit_reason , self . ready_for_interrupt_injection , self . if_flag , self . flags , self . cr8 , self . apic_base , self . __bindgen_anon_1 , self . kvm_valid_regs , self . kvm_dirty_regs , self . s)
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct kvm_coalesced_mmio_zone {
    pub addr: __u64,
    pub size: __u32,
    pub __bindgen_anon_1: kvm_coalesced_mmio_zone__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union kvm_coalesced_mmio_zone__bindgen_ty_1 {
    pub pad: __u32,
    pub pio: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_coalesced_mmio_zone__bindgen_ty_1"]
        [::std::mem::size_of::<kvm_coalesced_mmio_zone__bindgen_ty_1>() - 4usize];
    ["Alignment of kvm_coalesced_mmio_zone__bindgen_ty_1"]
        [::std::mem::align_of::<kvm_coalesced_mmio_zone__bindgen_ty_1>() - 4usize];
    ["Offset of field: kvm_coalesced_mmio_zone__bindgen_ty_1::pad"]
        [::std::mem::offset_of!(kvm_coalesced_mmio_zone__bindgen_ty_1, pad) - 0usize];
    ["Offset of field: kvm_coalesced_mmio_zone__bindgen_ty_1::pio"]
        [::std::mem::offset_of!(kvm_coalesced_mmio_zone__bindgen_ty_1, pio) - 0usize];
};
impl Default for kvm_coalesced_mmio_zone__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for kvm_coalesced_mmio_zone__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "kvm_coalesced_mmio_zone__bindgen_ty_1 {{ union }}")
    }
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_coalesced_mmio_zone"][::std::mem::size_of::<kvm_coalesced_mmio_zone>() - 16usize];
    ["Alignment of kvm_coalesced_mmio_zone"]
        [::std::mem::align_of::<kvm_coalesced_mmio_zone>() - 8usize];
    ["Offset of field: kvm_coalesced_mmio_zone::addr"]
        [::std::mem::offset_of!(kvm_coalesced_mmio_zone, addr) - 0usize];
    ["Offset of field: kvm_coalesced_mmio_zone::size"]
        [::std::mem::offset_of!(kvm_coalesced_mmio_zone, size) - 8usize];
};
impl Default for kvm_coalesced_mmio_zone {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for kvm_coalesced_mmio_zone {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(
            f,
            "kvm_coalesced_mmio_zone {{ addr: {:?}, size: {:?}, __bindgen_anon_1: {:?} }}",
            self.addr, self.size, self.__bindgen_anon_1
        )
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct kvm_coalesced_mmio {
    pub phys_addr: __u64,
    pub len: __u32,
    pub __bindgen_anon_1: kvm_coalesced_mmio__bindgen_ty_1,
    pub data: [__u8; 8usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union kvm_coalesced_mmio__bindgen_ty_1 {
    pub pad: __u32,
    pub pio: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_coalesced_mmio__bindgen_ty_1"]
        [::std::mem::size_of::<kvm_coalesced_mmio__bindgen_ty_1>() - 4usize];
    ["Alignment of kvm_coalesced_mmio__bindgen_ty_1"]
        [::std::mem::align_of::<kvm_coalesced_mmio__bindgen_ty_1>() - 4usize];
    ["Offset of field: kvm_coalesced_mmio__bindgen_ty_1::pad"]
        [::std::mem::offset_of!(kvm_coalesced_mmio__bindgen_ty_1, pad) - 0usize];
    ["Offset of field: kvm_coalesced_mmio__bindgen_ty_1::pio"]
        [::std::mem::offset_of!(kvm_coalesced_mmio__bindgen_ty_1, pio) - 0usize];
};
impl Default for kvm_coalesced_mmio__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for kvm_coalesced_mmio__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "kvm_coalesced_mmio__bindgen_ty_1 {{ union }}")
    }
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_coalesced_mmio"][::std::mem::size_of::<kvm_coalesced_mmio>() - 24usize];
    ["Alignment of kvm_coalesced_mmio"][::std::mem::align_of::<kvm_coalesced_mmio>() - 8usize];
    ["Offset of field: kvm_coalesced_mmio::phys_addr"]
        [::std::mem::offset_of!(kvm_coalesced_mmio, phys_addr) - 0usize];
    ["Offset of field: kvm_coalesced_mmio::len"]
        [::std::mem::offset_of!(kvm_coalesced_mmio, len) - 8usize];
    ["Offset of field: kvm_coalesced_mmio::data"]
        [::std::mem::offset_of!(kvm_coalesced_mmio, data) - 16usize];
};
impl Default for kvm_coalesced_mmio {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for kvm_coalesced_mmio {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write ! (f , "kvm_coalesced_mmio {{ phys_addr: {:?}, len: {:?}, __bindgen_anon_1: {:?}, data: {:?} }}" , self . phys_addr , self . len , self . __bindgen_anon_1 , self . data)
    }
}
#[repr(C)]
pub struct kvm_coalesced_mmio_ring {
    pub first: __u32,
    pub last: __u32,
    pub coalesced_mmio: __IncompleteArrayField<kvm_coalesced_mmio>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_coalesced_mmio_ring"][::std::mem::size_of::<kvm_coalesced_mmio_ring>() - 8usize];
    ["Alignment of kvm_coalesced_mmio_ring"]
        [::std::mem::align_of::<kvm_coalesced_mmio_ring>() - 8usize];
    ["Offset of field: kvm_coalesced_mmio_ring::first"]
        [::std::mem::offset_of!(kvm_coalesced_mmio_ring, first) - 0usize];
    ["Offset of field: kvm_coalesced_mmio_ring::last"]
        [::std::mem::offset_of!(kvm_coalesced_mmio_ring, last) - 4usize];
    ["Offset of field: kvm_coalesced_mmio_ring::coalesced_mmio"]
        [::std::mem::offset_of!(kvm_coalesced_mmio_ring, coalesced_mmio) - 8usize];
};
impl Default for kvm_coalesced_mmio_ring {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for kvm_coalesced_mmio_ring {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(
            f,
            "kvm_coalesced_mmio_ring {{ first: {:?}, last: {:?}, coalesced_mmio: {:?} }}",
            self.first, self.last, self.coalesced_mmio
        )
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_translation {
    pub linear_address: __u64,
    pub physical_address: __u64,
    pub valid: __u8,
    pub writeable: __u8,
    pub usermode: __u8,
    pub pad: [__u8; 5usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_translation"][::std::mem::size_of::<kvm_translation>() - 24usize];
    ["Alignment of kvm_translation"][::std::mem::align_of::<kvm_translation>() - 8usize];
    ["Offset of field: kvm_translation::linear_address"]
        [::std::mem::offset_of!(kvm_translation, linear_address) - 0usize];
    ["Offset of field: kvm_translation::physical_address"]
        [::std::mem::offset_of!(kvm_translation, physical_address) - 8usize];
    ["Offset of field: kvm_translation::valid"]
        [::std::mem::offset_of!(kvm_translation, valid) - 16usize];
    ["Offset of field: kvm_translation::writeable"]
        [::std::mem::offset_of!(kvm_translation, writeable) - 17usize];
    ["Offset of field: kvm_translation::usermode"]
        [::std::mem::offset_of!(kvm_translation, usermode) - 18usize];
    ["Offset of field: kvm_translation::pad"]
        [::std::mem::offset_of!(kvm_translation, pad) - 19usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_interrupt {
    pub irq: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_interrupt"][::std::mem::size_of::<kvm_interrupt>() - 4usize];
    ["Alignment of kvm_interrupt"][::std::mem::align_of::<kvm_interrupt>() - 4usize];
    ["Offset of field: kvm_interrupt::irq"][::std::mem::offset_of!(kvm_interrupt, irq) - 0usize];
};
#[repr(C)]
#[derive(Copy, Clone)]
pub struct kvm_dirty_log {
    pub slot: __u32,
    pub padding1: __u32,
    pub __bindgen_anon_1: kvm_dirty_log__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union kvm_dirty_log__bindgen_ty_1 {
    pub dirty_bitmap: *mut ::std::os::raw::c_void,
    pub padding2: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_dirty_log__bindgen_ty_1"]
        [::std::mem::size_of::<kvm_dirty_log__bindgen_ty_1>() - 8usize];
    ["Alignment of kvm_dirty_log__bindgen_ty_1"]
        [::std::mem::align_of::<kvm_dirty_log__bindgen_ty_1>() - 8usize];
    ["Offset of field: kvm_dirty_log__bindgen_ty_1::dirty_bitmap"]
        [::std::mem::offset_of!(kvm_dirty_log__bindgen_ty_1, dirty_bitmap) - 0usize];
    ["Offset of field: kvm_dirty_log__bindgen_ty_1::padding2"]
        [::std::mem::offset_of!(kvm_dirty_log__bindgen_ty_1, padding2) - 0usize];
};
impl Default for kvm_dirty_log__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for kvm_dirty_log__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "kvm_dirty_log__bindgen_ty_1 {{ union }}")
    }
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_dirty_log"][::std::mem::size_of::<kvm_dirty_log>() - 16usize];
    ["Alignment of kvm_dirty_log"][::std::mem::align_of::<kvm_dirty_log>() - 8usize];
    ["Offset of field: kvm_dirty_log::slot"][::std::mem::offset_of!(kvm_dirty_log, slot) - 0usize];
    ["Offset of field: kvm_dirty_log::padding1"]
        [::std::mem::offset_of!(kvm_dirty_log, padding1) - 4usize];
};
impl Default for kvm_dirty_log {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for kvm_dirty_log {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(
            f,
            "kvm_dirty_log {{ slot: {:?}, padding1: {:?}, __bindgen_anon_1: {:?} }}",
            self.slot, self.padding1, self.__bindgen_anon_1
        )
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct kvm_clear_dirty_log {
    pub slot: __u32,
    pub num_pages: __u32,
    pub first_page: __u64,
    pub __bindgen_anon_1: kvm_clear_dirty_log__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union kvm_clear_dirty_log__bindgen_ty_1 {
    pub dirty_bitmap: *mut ::std::os::raw::c_void,
    pub padding2: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_clear_dirty_log__bindgen_ty_1"]
        [::std::mem::size_of::<kvm_clear_dirty_log__bindgen_ty_1>() - 8usize];
    ["Alignment of kvm_clear_dirty_log__bindgen_ty_1"]
        [::std::mem::align_of::<kvm_clear_dirty_log__bindgen_ty_1>() - 8usize];
    ["Offset of field: kvm_clear_dirty_log__bindgen_ty_1::dirty_bitmap"]
        [::std::mem::offset_of!(kvm_clear_dirty_log__bindgen_ty_1, dirty_bitmap) - 0usize];
    ["Offset of field: kvm_clear_dirty_log__bindgen_ty_1::padding2"]
        [::std::mem::offset_of!(kvm_clear_dirty_log__bindgen_ty_1, padding2) - 0usize];
};
impl Default for kvm_clear_dirty_log__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for kvm_clear_dirty_log__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "kvm_clear_dirty_log__bindgen_ty_1 {{ union }}")
    }
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_clear_dirty_log"][::std::mem::size_of::<kvm_clear_dirty_log>() - 24usize];
    ["Alignment of kvm_clear_dirty_log"][::std::mem::align_of::<kvm_clear_dirty_log>() - 8usize];
    ["Offset of field: kvm_clear_dirty_log::slot"]
        [::std::mem::offset_of!(kvm_clear_dirty_log, slot) - 0usize];
    ["Offset of field: kvm_clear_dirty_log::num_pages"]
        [::std::mem::offset_of!(kvm_clear_dirty_log, num_pages) - 4usize];
    ["Offset of field: kvm_clear_dirty_log::first_page"]
        [::std::mem::offset_of!(kvm_clear_dirty_log, first_page) - 8usize];
};
impl Default for kvm_clear_dirty_log {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for kvm_clear_dirty_log {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write ! (f , "kvm_clear_dirty_log {{ slot: {:?}, num_pages: {:?}, first_page: {:?}, __bindgen_anon_1: {:?} }}" , self . slot , self . num_pages , self . first_page , self . __bindgen_anon_1)
    }
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct kvm_signal_mask {
    pub len: __u32,
    pub sigset: __IncompleteArrayField<__u8>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_signal_mask"][::std::mem::size_of::<kvm_signal_mask>() - 4usize];
    ["Alignment of kvm_signal_mask"][::std::mem::align_of::<kvm_signal_mask>() - 4usize];
    ["Offset of field: kvm_signal_mask::len"]
        [::std::mem::offset_of!(kvm_signal_mask, len) - 0usize];
    ["Offset of field: kvm_signal_mask::sigset"]
        [::std::mem::offset_of!(kvm_signal_mask, sigset) - 4usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_tpr_access_ctl {
    pub enabled: __u32,
    pub flags: __u32,
    pub reserved: [__u32; 8usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_tpr_access_ctl"][::std::mem::size_of::<kvm_tpr_access_ctl>() - 40usize];
    ["Alignment of kvm_tpr_access_ctl"][::std::mem::align_of::<kvm_tpr_access_ctl>() - 4usize];
    ["Offset of field: kvm_tpr_access_ctl::enabled"]
        [::std::mem::offset_of!(kvm_tpr_access_ctl, enabled) - 0usize];
    ["Offset of field: kvm_tpr_access_ctl::flags"]
        [::std::mem::offset_of!(kvm_tpr_access_ctl, flags) - 4usize];
    ["Offset of field: kvm_tpr_access_ctl::reserved"]
        [::std::mem::offset_of!(kvm_tpr_access_ctl, reserved) - 8usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_vapic_addr {
    pub vapic_addr: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_vapic_addr"][::std::mem::size_of::<kvm_vapic_addr>() - 8usize];
    ["Alignment of kvm_vapic_addr"][::std::mem::align_of::<kvm_vapic_addr>() - 8usize];
    ["Offset of field: kvm_vapic_addr::vapic_addr"]
        [::std::mem::offset_of!(kvm_vapic_addr, vapic_addr) - 0usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
#[cfg_attr(
    feature = "serde",
    derive(zerocopy::AsBytes, zerocopy::FromBytes, zerocopy::FromZeroes)
)]
pub struct kvm_mp_state {
    pub mp_state: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_mp_state"][::std::mem::size_of::<kvm_mp_state>() - 4usize];
    ["Alignment of kvm_mp_state"][::std::mem::align_of::<kvm_mp_state>() - 4usize];
    ["Offset of field: kvm_mp_state::mp_state"]
        [::std::mem::offset_of!(kvm_mp_state, mp_state) - 0usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_guest_debug {
    pub control: __u32,
    pub pad: __u32,
    pub arch: kvm_guest_debug_arch,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_guest_debug"][::std::mem::size_of::<kvm_guest_debug>() - 72usize];
    ["Alignment of kvm_guest_debug"][::std::mem::align_of::<kvm_guest_debug>() - 8usize];
    ["Offset of field: kvm_guest_debug::control"]
        [::std::mem::offset_of!(kvm_guest_debug, control) - 0usize];
    ["Offset of field: kvm_guest_debug::pad"]
        [::std::mem::offset_of!(kvm_guest_debug, pad) - 4usize];
    ["Offset of field: kvm_guest_debug::arch"]
        [::std::mem::offset_of!(kvm_guest_debug, arch) - 8usize];
};
pub const kvm_ioeventfd_flag_nr_datamatch: _bindgen_ty_1 = 0;
pub const kvm_ioeventfd_flag_nr_pio: _bindgen_ty_1 = 1;
pub const kvm_ioeventfd_flag_nr_deassign: _bindgen_ty_1 = 2;
pub const kvm_ioeventfd_flag_nr_virtio_ccw_notify: _bindgen_ty_1 = 3;
pub const kvm_ioeventfd_flag_nr_fast_mmio: _bindgen_ty_1 = 4;
pub const kvm_ioeventfd_flag_nr_max: _bindgen_ty_1 = 5;
pub type _bindgen_ty_1 = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq)]
pub struct kvm_ioeventfd {
    pub datamatch: __u64,
    pub addr: __u64,
    pub len: __u32,
    pub fd: __s32,
    pub flags: __u32,
    pub pad: [__u8; 36usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_ioeventfd"][::std::mem::size_of::<kvm_ioeventfd>() - 64usize];
    ["Alignment of kvm_ioeventfd"][::std::mem::align_of::<kvm_ioeventfd>() - 8usize];
    ["Offset of field: kvm_ioeventfd::datamatch"]
        [::std::mem::offset_of!(kvm_ioeventfd, datamatch) - 0usize];
    ["Offset of field: kvm_ioeventfd::addr"][::std::mem::offset_of!(kvm_ioeventfd, addr) - 8usize];
    ["Offset of field: kvm_ioeventfd::len"][::std::mem::offset_of!(kvm_ioeventfd, len) - 16usize];
    ["Offset of field: kvm_ioeventfd::fd"][::std::mem::offset_of!(kvm_ioeventfd, fd) - 20usize];
    ["Offset of field: kvm_ioeventfd::flags"]
        [::std::mem::offset_of!(kvm_ioeventfd, flags) - 24usize];
    ["Offset of field: kvm_ioeventfd::pad"][::std::mem::offset_of!(kvm_ioeventfd, pad) - 28usize];
};
impl Default for kvm_ioeventfd {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq)]
pub struct kvm_enable_cap {
    pub cap: __u32,
    pub flags: __u32,
    pub args: [__u64; 4usize],
    pub pad: [__u8; 64usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_enable_cap"][::std::mem::size_of::<kvm_enable_cap>() - 104usize];
    ["Alignment of kvm_enable_cap"][::std::mem::align_of::<kvm_enable_cap>() - 8usize];
    ["Offset of field: kvm_enable_cap::cap"][::std::mem::offset_of!(kvm_enable_cap, cap) - 0usize];
    ["Offset of field: kvm_enable_cap::flags"]
        [::std::mem::offset_of!(kvm_enable_cap, flags) - 4usize];
    ["Offset of field: kvm_enable_cap::args"]
        [::std::mem::offset_of!(kvm_enable_cap, args) - 8usize];
    ["Offset of field: kvm_enable_cap::pad"][::std::mem::offset_of!(kvm_enable_cap, pad) - 40usize];
};
impl Default for kvm_enable_cap {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_irq_routing_irqchip {
    pub irqchip: __u32,
    pub pin: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_irq_routing_irqchip"][::std::mem::size_of::<kvm_irq_routing_irqchip>() - 8usize];
    ["Alignment of kvm_irq_routing_irqchip"]
        [::std::mem::align_of::<kvm_irq_routing_irqchip>() - 4usize];
    ["Offset of field: kvm_irq_routing_irqchip::irqchip"]
        [::std::mem::offset_of!(kvm_irq_routing_irqchip, irqchip) - 0usize];
    ["Offset of field: kvm_irq_routing_irqchip::pin"]
        [::std::mem::offset_of!(kvm_irq_routing_irqchip, pin) - 4usize];
};
#[repr(C)]
#[derive(Copy, Clone)]
pub struct kvm_irq_routing_msi {
    pub address_lo: __u32,
    pub address_hi: __u32,
    pub data: __u32,
    pub __bindgen_anon_1: kvm_irq_routing_msi__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union kvm_irq_routing_msi__bindgen_ty_1 {
    pub pad: __u32,
    pub devid: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_irq_routing_msi__bindgen_ty_1"]
        [::std::mem::size_of::<kvm_irq_routing_msi__bindgen_ty_1>() - 4usize];
    ["Alignment of kvm_irq_routing_msi__bindgen_ty_1"]
        [::std::mem::align_of::<kvm_irq_routing_msi__bindgen_ty_1>() - 4usize];
    ["Offset of field: kvm_irq_routing_msi__bindgen_ty_1::pad"]
        [::std::mem::offset_of!(kvm_irq_routing_msi__bindgen_ty_1, pad) - 0usize];
    ["Offset of field: kvm_irq_routing_msi__bindgen_ty_1::devid"]
        [::std::mem::offset_of!(kvm_irq_routing_msi__bindgen_ty_1, devid) - 0usize];
};
impl Default for kvm_irq_routing_msi__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for kvm_irq_routing_msi__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "kvm_irq_routing_msi__bindgen_ty_1 {{ union }}")
    }
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_irq_routing_msi"][::std::mem::size_of::<kvm_irq_routing_msi>() - 16usize];
    ["Alignment of kvm_irq_routing_msi"][::std::mem::align_of::<kvm_irq_routing_msi>() - 4usize];
    ["Offset of field: kvm_irq_routing_msi::address_lo"]
        [::std::mem::offset_of!(kvm_irq_routing_msi, address_lo) - 0usize];
    ["Offset of field: kvm_irq_routing_msi::address_hi"]
        [::std::mem::offset_of!(kvm_irq_routing_msi, address_hi) - 4usize];
    ["Offset of field: kvm_irq_routing_msi::data"]
        [::std::mem::offset_of!(kvm_irq_routing_msi, data) - 8usize];
};
impl Default for kvm_irq_routing_msi {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for kvm_irq_routing_msi {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write ! (f , "kvm_irq_routing_msi {{ address_lo: {:?}, address_hi: {:?}, data: {:?}, __bindgen_anon_1: {:?} }}" , self . address_lo , self . address_hi , self . data , self . __bindgen_anon_1)
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_irq_routing_s390_adapter {
    pub ind_addr: __u64,
    pub summary_addr: __u64,
    pub ind_offset: __u64,
    pub summary_offset: __u32,
    pub adapter_id: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_irq_routing_s390_adapter"]
        [::std::mem::size_of::<kvm_irq_routing_s390_adapter>() - 32usize];
    ["Alignment of kvm_irq_routing_s390_adapter"]
        [::std::mem::align_of::<kvm_irq_routing_s390_adapter>() - 8usize];
    ["Offset of field: kvm_irq_routing_s390_adapter::ind_addr"]
        [::std::mem::offset_of!(kvm_irq_routing_s390_adapter, ind_addr) - 0usize];
    ["Offset of field: kvm_irq_routing_s390_adapter::summary_addr"]
        [::std::mem::offset_of!(kvm_irq_routing_s390_adapter, summary_addr) - 8usize];
    ["Offset of field: kvm_irq_routing_s390_adapter::ind_offset"]
        [::std::mem::offset_of!(kvm_irq_routing_s390_adapter, ind_offset) - 16usize];
    ["Offset of field: kvm_irq_routing_s390_adapter::summary_offset"]
        [::std::mem::offset_of!(kvm_irq_routing_s390_adapter, summary_offset) - 24usize];
    ["Offset of field: kvm_irq_routing_s390_adapter::adapter_id"]
        [::std::mem::offset_of!(kvm_irq_routing_s390_adapter, adapter_id) - 28usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_irq_routing_hv_sint {
    pub vcpu: __u32,
    pub sint: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_irq_routing_hv_sint"][::std::mem::size_of::<kvm_irq_routing_hv_sint>() - 8usize];
    ["Alignment of kvm_irq_routing_hv_sint"]
        [::std::mem::align_of::<kvm_irq_routing_hv_sint>() - 4usize];
    ["Offset of field: kvm_irq_routing_hv_sint::vcpu"]
        [::std::mem::offset_of!(kvm_irq_routing_hv_sint, vcpu) - 0usize];
    ["Offset of field: kvm_irq_routing_hv_sint::sint"]
        [::std::mem::offset_of!(kvm_irq_routing_hv_sint, sint) - 4usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_irq_routing_xen_evtchn {
    pub port: __u32,
    pub vcpu: __u32,
    pub priority: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_irq_routing_xen_evtchn"]
        [::std::mem::size_of::<kvm_irq_routing_xen_evtchn>() - 12usize];
    ["Alignment of kvm_irq_routing_xen_evtchn"]
        [::std::mem::align_of::<kvm_irq_routing_xen_evtchn>() - 4usize];
    ["Offset of field: kvm_irq_routing_xen_evtchn::port"]
        [::std::mem::offset_of!(kvm_irq_routing_xen_evtchn, port) - 0usize];
    ["Offset of field: kvm_irq_routing_xen_evtchn::vcpu"]
        [::std::mem::offset_of!(kvm_irq_routing_xen_evtchn, vcpu) - 4usize];
    ["Offset of field: kvm_irq_routing_xen_evtchn::priority"]
        [::std::mem::offset_of!(kvm_irq_routing_xen_evtchn, priority) - 8usize];
};
#[repr(C)]
#[derive(Copy, Clone)]
pub struct kvm_irq_routing_entry {
    pub gsi: __u32,
    pub type_: __u32,
    pub flags: __u32,
    pub pad: __u32,
    pub u: kvm_irq_routing_entry__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union kvm_irq_routing_entry__bindgen_ty_1 {
    pub irqchip: kvm_irq_routing_irqchip,
    pub msi: kvm_irq_routing_msi,
    pub adapter: kvm_irq_routing_s390_adapter,
    pub hv_sint: kvm_irq_routing_hv_sint,
    pub xen_evtchn: kvm_irq_routing_xen_evtchn,
    pub pad: [__u32; 8usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_irq_routing_entry__bindgen_ty_1"]
        [::std::mem::size_of::<kvm_irq_routing_entry__bindgen_ty_1>() - 32usize];
    ["Alignment of kvm_irq_routing_entry__bindgen_ty_1"]
        [::std::mem::align_of::<kvm_irq_routing_entry__bindgen_ty_1>() - 8usize];
    ["Offset of field: kvm_irq_routing_entry__bindgen_ty_1::irqchip"]
        [::std::mem::offset_of!(kvm_irq_routing_entry__bindgen_ty_1, irqchip) - 0usize];
    ["Offset of field: kvm_irq_routing_entry__bindgen_ty_1::msi"]
        [::std::mem::offset_of!(kvm_irq_routing_entry__bindgen_ty_1, msi) - 0usize];
    ["Offset of field: kvm_irq_routing_entry__bindgen_ty_1::adapter"]
        [::std::mem::offset_of!(kvm_irq_routing_entry__bindgen_ty_1, adapter) - 0usize];
    ["Offset of field: kvm_irq_routing_entry__bindgen_ty_1::hv_sint"]
        [::std::mem::offset_of!(kvm_irq_routing_entry__bindgen_ty_1, hv_sint) - 0usize];
    ["Offset of field: kvm_irq_routing_entry__bindgen_ty_1::xen_evtchn"]
        [::std::mem::offset_of!(kvm_irq_routing_entry__bindgen_ty_1, xen_evtchn) - 0usize];
    ["Offset of field: kvm_irq_routing_entry__bindgen_ty_1::pad"]
        [::std::mem::offset_of!(kvm_irq_routing_entry__bindgen_ty_1, pad) - 0usize];
};
impl Default for kvm_irq_routing_entry__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for kvm_irq_routing_entry__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "kvm_irq_routing_entry__bindgen_ty_1 {{ union }}")
    }
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_irq_routing_entry"][::std::mem::size_of::<kvm_irq_routing_entry>() - 48usize];
    ["Alignment of kvm_irq_routing_entry"]
        [::std::mem::align_of::<kvm_irq_routing_entry>() - 8usize];
    ["Offset of field: kvm_irq_routing_entry::gsi"]
        [::std::mem::offset_of!(kvm_irq_routing_entry, gsi) - 0usize];
    ["Offset of field: kvm_irq_routing_entry::type_"]
        [::std::mem::offset_of!(kvm_irq_routing_entry, type_) - 4usize];
    ["Offset of field: kvm_irq_routing_entry::flags"]
        [::std::mem::offset_of!(kvm_irq_routing_entry, flags) - 8usize];
    ["Offset of field: kvm_irq_routing_entry::pad"]
        [::std::mem::offset_of!(kvm_irq_routing_entry, pad) - 12usize];
    ["Offset of field: kvm_irq_routing_entry::u"]
        [::std::mem::offset_of!(kvm_irq_routing_entry, u) - 16usize];
};
impl Default for kvm_irq_routing_entry {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for kvm_irq_routing_entry {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(
            f,
            "kvm_irq_routing_entry {{ gsi: {:?}, type: {:?}, flags: {:?}, pad: {:?}, u: {:?} }}",
            self.gsi, self.type_, self.flags, self.pad, self.u
        )
    }
}
#[repr(C)]
pub struct kvm_irq_routing {
    pub nr: __u32,
    pub flags: __u32,
    pub entries: __IncompleteArrayField<kvm_irq_routing_entry>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_irq_routing"][::std::mem::size_of::<kvm_irq_routing>() - 8usize];
    ["Alignment of kvm_irq_routing"][::std::mem::align_of::<kvm_irq_routing>() - 8usize];
    ["Offset of field: kvm_irq_routing::nr"][::std::mem::offset_of!(kvm_irq_routing, nr) - 0usize];
    ["Offset of field: kvm_irq_routing::flags"]
        [::std::mem::offset_of!(kvm_irq_routing, flags) - 4usize];
    ["Offset of field: kvm_irq_routing::entries"]
        [::std::mem::offset_of!(kvm_irq_routing, entries) - 8usize];
};
impl Default for kvm_irq_routing {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for kvm_irq_routing {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(
            f,
            "kvm_irq_routing {{ nr: {:?}, flags: {:?}, entries: {:?} }}",
            self.nr, self.flags, self.entries
        )
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_irqfd {
    pub fd: __u32,
    pub gsi: __u32,
    pub flags: __u32,
    pub resamplefd: __u32,
    pub pad: [__u8; 16usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_irqfd"][::std::mem::size_of::<kvm_irqfd>() - 32usize];
    ["Alignment of kvm_irqfd"][::std::mem::align_of::<kvm_irqfd>() - 4usize];
    ["Offset of field: kvm_irqfd::fd"][::std::mem::offset_of!(kvm_irqfd, fd) - 0usize];
    ["Offset of field: kvm_irqfd::gsi"][::std::mem::offset_of!(kvm_irqfd, gsi) - 4usize];
    ["Offset of field: kvm_irqfd::flags"][::std::mem::offset_of!(kvm_irqfd, flags) - 8usize];
    ["Offset of field: kvm_irqfd::resamplefd"]
        [::std::mem::offset_of!(kvm_irqfd, resamplefd) - 12usize];
    ["Offset of field: kvm_irqfd::pad"][::std::mem::offset_of!(kvm_irqfd, pad) - 16usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
#[cfg_attr(
    feature = "serde",
    derive(zerocopy::AsBytes, zerocopy::FromBytes, zerocopy::FromZeroes)
)]
pub struct kvm_clock_data {
    pub clock: __u64,
    pub flags: __u32,
    pub pad0: __u32,
    pub realtime: __u64,
    pub host_tsc: __u64,
    pub pad: [__u32; 4usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_clock_data"][::std::mem::size_of::<kvm_clock_data>() - 48usize];
    ["Alignment of kvm_clock_data"][::std::mem::align_of::<kvm_clock_data>() - 8usize];
    ["Offset of field: kvm_clock_data::clock"]
        [::std::mem::offset_of!(kvm_clock_data, clock) - 0usize];
    ["Offset of field: kvm_clock_data::flags"]
        [::std::mem::offset_of!(kvm_clock_data, flags) - 8usize];
    ["Offset of field: kvm_clock_data::pad0"]
        [::std::mem::offset_of!(kvm_clock_data, pad0) - 12usize];
    ["Offset of field: kvm_clock_data::realtime"]
        [::std::mem::offset_of!(kvm_clock_data, realtime) - 16usize];
    ["Offset of field: kvm_clock_data::host_tsc"]
        [::std::mem::offset_of!(kvm_clock_data, host_tsc) - 24usize];
    ["Offset of field: kvm_clock_data::pad"][::std::mem::offset_of!(kvm_clock_data, pad) - 32usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_config_tlb {
    pub params: __u64,
    pub array: __u64,
    pub mmu_type: __u32,
    pub array_len: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_config_tlb"][::std::mem::size_of::<kvm_config_tlb>() - 24usize];
    ["Alignment of kvm_config_tlb"][::std::mem::align_of::<kvm_config_tlb>() - 8usize];
    ["Offset of field: kvm_config_tlb::params"]
        [::std::mem::offset_of!(kvm_config_tlb, params) - 0usize];
    ["Offset of field: kvm_config_tlb::array"]
        [::std::mem::offset_of!(kvm_config_tlb, array) - 8usize];
    ["Offset of field: kvm_config_tlb::mmu_type"]
        [::std::mem::offset_of!(kvm_config_tlb, mmu_type) - 16usize];
    ["Offset of field: kvm_config_tlb::array_len"]
        [::std::mem::offset_of!(kvm_config_tlb, array_len) - 20usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_dirty_tlb {
    pub bitmap: __u64,
    pub num_dirty: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_dirty_tlb"][::std::mem::size_of::<kvm_dirty_tlb>() - 16usize];
    ["Alignment of kvm_dirty_tlb"][::std::mem::align_of::<kvm_dirty_tlb>() - 8usize];
    ["Offset of field: kvm_dirty_tlb::bitmap"]
        [::std::mem::offset_of!(kvm_dirty_tlb, bitmap) - 0usize];
    ["Offset of field: kvm_dirty_tlb::num_dirty"]
        [::std::mem::offset_of!(kvm_dirty_tlb, num_dirty) - 8usize];
};
#[repr(C)]
#[derive(Debug, Default)]
pub struct kvm_reg_list {
    pub n: __u64,
    pub reg: __IncompleteArrayField<__u64>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_reg_list"][::std::mem::size_of::<kvm_reg_list>() - 8usize];
    ["Alignment of kvm_reg_list"][::std::mem::align_of::<kvm_reg_list>() - 8usize];
    ["Offset of field: kvm_reg_list::n"][::std::mem::offset_of!(kvm_reg_list, n) - 0usize];
    ["Offset of field: kvm_reg_list::reg"][::std::mem::offset_of!(kvm_reg_list, reg) - 8usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_one_reg {
    pub id: __u64,
    pub addr: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_one_reg"][::std::mem::size_of::<kvm_one_reg>() - 16usize];
    ["Alignment of kvm_one_reg"][::std::mem::align_of::<kvm_one_reg>() - 8usize];
    ["Offset of field: kvm_one_reg::id"][::std::mem::offset_of!(kvm_one_reg, id) - 0usize];
    ["Offset of field: kvm_one_reg::addr"][::std::mem::offset_of!(kvm_one_reg, addr) - 8usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_msi {
    pub address_lo: __u32,
    pub address_hi: __u32,
    pub data: __u32,
    pub flags: __u32,
    pub devid: __u32,
    pub pad: [__u8; 12usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_msi"][::std::mem::size_of::<kvm_msi>() - 32usize];
    ["Alignment of kvm_msi"][::std::mem::align_of::<kvm_msi>() - 4usize];
    ["Offset of field: kvm_msi::address_lo"][::std::mem::offset_of!(kvm_msi, address_lo) - 0usize];
    ["Offset of field: kvm_msi::address_hi"][::std::mem::offset_of!(kvm_msi, address_hi) - 4usize];
    ["Offset of field: kvm_msi::data"][::std::mem::offset_of!(kvm_msi, data) - 8usize];
    ["Offset of field: kvm_msi::flags"][::std::mem::offset_of!(kvm_msi, flags) - 12usize];
    ["Offset of field: kvm_msi::devid"][::std::mem::offset_of!(kvm_msi, devid) - 16usize];
    ["Offset of field: kvm_msi::pad"][::std::mem::offset_of!(kvm_msi, pad) - 20usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_arm_device_addr {
    pub id: __u64,
    pub addr: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_arm_device_addr"][::std::mem::size_of::<kvm_arm_device_addr>() - 16usize];
    ["Alignment of kvm_arm_device_addr"][::std::mem::align_of::<kvm_arm_device_addr>() - 8usize];
    ["Offset of field: kvm_arm_device_addr::id"]
        [::std::mem::offset_of!(kvm_arm_device_addr, id) - 0usize];
    ["Offset of field: kvm_arm_device_addr::addr"]
        [::std::mem::offset_of!(kvm_arm_device_addr, addr) - 8usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_create_device {
    pub type_: __u32,
    pub fd: __u32,
    pub flags: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_create_device"][::std::mem::size_of::<kvm_create_device>() - 12usize];
    ["Alignment of kvm_create_device"][::std::mem::align_of::<kvm_create_device>() - 4usize];
    ["Offset of field: kvm_create_device::type_"]
        [::std::mem::offset_of!(kvm_create_device, type_) - 0usize];
    ["Offset of field: kvm_create_device::fd"]
        [::std::mem::offset_of!(kvm_create_device, fd) - 4usize];
    ["Offset of field: kvm_create_device::flags"]
        [::std::mem::offset_of!(kvm_create_device, flags) - 8usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_device_attr {
    pub flags: __u32,
    pub group: __u32,
    pub attr: __u64,
    pub addr: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_device_attr"][::std::mem::size_of::<kvm_device_attr>() - 24usize];
    ["Alignment of kvm_device_attr"][::std::mem::align_of::<kvm_device_attr>() - 8usize];
    ["Offset of field: kvm_device_attr::flags"]
        [::std::mem::offset_of!(kvm_device_attr, flags) - 0usize];
    ["Offset of field: kvm_device_attr::group"]
        [::std::mem::offset_of!(kvm_device_attr, group) - 4usize];
    ["Offset of field: kvm_device_attr::attr"]
        [::std::mem::offset_of!(kvm_device_attr, attr) - 8usize];
    ["Offset of field: kvm_device_attr::addr"]
        [::std::mem::offset_of!(kvm_device_attr, addr) - 16usize];
};
pub const kvm_device_type_KVM_DEV_TYPE_FSL_MPIC_20: kvm_device_type = 1;
pub const kvm_device_type_KVM_DEV_TYPE_FSL_MPIC_42: kvm_device_type = 2;
pub const kvm_device_type_KVM_DEV_TYPE_XICS: kvm_device_type = 3;
pub const kvm_device_type_KVM_DEV_TYPE_VFIO: kvm_device_type = 4;
pub const kvm_device_type_KVM_DEV_TYPE_ARM_VGIC_V2: kvm_device_type = 5;
pub const kvm_device_type_KVM_DEV_TYPE_FLIC: kvm_device_type = 6;
pub const kvm_device_type_KVM_DEV_TYPE_ARM_VGIC_V3: kvm_device_type = 7;
pub const kvm_device_type_KVM_DEV_TYPE_ARM_VGIC_ITS: kvm_device_type = 8;
pub const kvm_device_type_KVM_DEV_TYPE_XIVE: kvm_device_type = 9;
pub const kvm_device_type_KVM_DEV_TYPE_ARM_PV_TIME: kvm_device_type = 10;
pub const kvm_device_type_KVM_DEV_TYPE_RISCV_AIA: kvm_device_type = 11;
pub const kvm_device_type_KVM_DEV_TYPE_MAX: kvm_device_type = 12;
pub type kvm_device_type = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_vfio_spapr_tce {
    pub groupfd: __s32,
    pub tablefd: __s32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_vfio_spapr_tce"][::std::mem::size_of::<kvm_vfio_spapr_tce>() - 8usize];
    ["Alignment of kvm_vfio_spapr_tce"][::std::mem::align_of::<kvm_vfio_spapr_tce>() - 4usize];
    ["Offset of field: kvm_vfio_spapr_tce::groupfd"]
        [::std::mem::offset_of!(kvm_vfio_spapr_tce, groupfd) - 0usize];
    ["Offset of field: kvm_vfio_spapr_tce::tablefd"]
        [::std::mem::offset_of!(kvm_vfio_spapr_tce, tablefd) - 4usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_enc_region {
    pub addr: __u64,
    pub size: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_enc_region"][::std::mem::size_of::<kvm_enc_region>() - 16usize];
    ["Alignment of kvm_enc_region"][::std::mem::align_of::<kvm_enc_region>() - 8usize];
    ["Offset of field: kvm_enc_region::addr"]
        [::std::mem::offset_of!(kvm_enc_region, addr) - 0usize];
    ["Offset of field: kvm_enc_region::size"]
        [::std::mem::offset_of!(kvm_enc_region, size) - 8usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_dirty_gfn {
    pub flags: __u32,
    pub slot: __u32,
    pub offset: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_dirty_gfn"][::std::mem::size_of::<kvm_dirty_gfn>() - 16usize];
    ["Alignment of kvm_dirty_gfn"][::std::mem::align_of::<kvm_dirty_gfn>() - 8usize];
    ["Offset of field: kvm_dirty_gfn::flags"]
        [::std::mem::offset_of!(kvm_dirty_gfn, flags) - 0usize];
    ["Offset of field: kvm_dirty_gfn::slot"][::std::mem::offset_of!(kvm_dirty_gfn, slot) - 4usize];
    ["Offset of field: kvm_dirty_gfn::offset"]
        [::std::mem::offset_of!(kvm_dirty_gfn, offset) - 8usize];
};
#[doc = " struct kvm_stats_header - Header of per vm/vcpu binary statistics data.\n @flags: Some extra information for header, always 0 for now.\n @name_size: The size in bytes of the memory which contains statistics\n             name string including trailing '\\0'. The memory is allocated\n             at the send of statistics descriptor.\n @num_desc: The number of statistics the vm or vcpu has.\n @id_offset: The offset of the vm/vcpu stats' id string in the file pointed\n             by vm/vcpu stats fd.\n @desc_offset: The offset of the vm/vcpu stats' descriptor block in the file\n               pointd by vm/vcpu stats fd.\n @data_offset: The offset of the vm/vcpu stats' data block in the file\n               pointed by vm/vcpu stats fd.\n\n This is the header userspace needs to read from stats fd before any other\n readings. It is used by userspace to discover all the information about the\n vm/vcpu's binary statistics.\n Userspace reads this header from the start of the vm/vcpu's stats fd."]
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_stats_header {
    pub flags: __u32,
    pub name_size: __u32,
    pub num_desc: __u32,
    pub id_offset: __u32,
    pub desc_offset: __u32,
    pub data_offset: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_stats_header"][::std::mem::size_of::<kvm_stats_header>() - 24usize];
    ["Alignment of kvm_stats_header"][::std::mem::align_of::<kvm_stats_header>() - 4usize];
    ["Offset of field: kvm_stats_header::flags"]
        [::std::mem::offset_of!(kvm_stats_header, flags) - 0usize];
    ["Offset of field: kvm_stats_header::name_size"]
        [::std::mem::offset_of!(kvm_stats_header, name_size) - 4usize];
    ["Offset of field: kvm_stats_header::num_desc"]
        [::std::mem::offset_of!(kvm_stats_header, num_desc) - 8usize];
    ["Offset of field: kvm_stats_header::id_offset"]
        [::std::mem::offset_of!(kvm_stats_header, id_offset) - 12usize];
    ["Offset of field: kvm_stats_header::desc_offset"]
        [::std::mem::offset_of!(kvm_stats_header, desc_offset) - 16usize];
    ["Offset of field: kvm_stats_header::data_offset"]
        [::std::mem::offset_of!(kvm_stats_header, data_offset) - 20usize];
};
#[doc = " struct kvm_stats_desc - Descriptor of a KVM statistics.\n @flags: Annotations of the stats, like type, unit, etc.\n @exponent: Used together with @flags to determine the unit.\n @size: The number of data items for this stats.\n        Every data item is of type __u64.\n @offset: The offset of the stats to the start of stat structure in\n          structure kvm or kvm_vcpu.\n @bucket_size: A parameter value used for histogram stats. It is only used\n\t\tfor linear histogram stats, specifying the size of the bucket;\n @name: The name string for the stats. Its size is indicated by the\n        &kvm_stats_header->name_size."]
#[repr(C)]
#[derive(Debug, Default)]
pub struct kvm_stats_desc {
    pub flags: __u32,
    pub exponent: __s16,
    pub size: __u16,
    pub offset: __u32,
    pub bucket_size: __u32,
    pub name: __IncompleteArrayField<::std::os::raw::c_char>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_stats_desc"][::std::mem::size_of::<kvm_stats_desc>() - 16usize];
    ["Alignment of kvm_stats_desc"][::std::mem::align_of::<kvm_stats_desc>() - 4usize];
    ["Offset of field: kvm_stats_desc::flags"]
        [::std::mem::offset_of!(kvm_stats_desc, flags) - 0usize];
    ["Offset of field: kvm_stats_desc::exponent"]
        [::std::mem::offset_of!(kvm_stats_desc, exponent) - 4usize];
    ["Offset of field: kvm_stats_desc::size"]
        [::std::mem::offset_of!(kvm_stats_desc, size) - 6usize];
    ["Offset of field: kvm_stats_desc::offset"]
        [::std::mem::offset_of!(kvm_stats_desc, offset) - 8usize];
    ["Offset of field: kvm_stats_desc::bucket_size"]
        [::std::mem::offset_of!(kvm_stats_desc, bucket_size) - 12usize];
    ["Offset of field: kvm_stats_desc::name"]
        [::std::mem::offset_of!(kvm_stats_desc, name) - 16usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_memory_attributes {
    pub address: __u64,
    pub size: __u64,
    pub attributes: __u64,
    pub flags: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_memory_attributes"][::std::mem::size_of::<kvm_memory_attributes>() - 32usize];
    ["Alignment of kvm_memory_attributes"]
        [::std::mem::align_of::<kvm_memory_attributes>() - 8usize];
    ["Offset of field: kvm_memory_attributes::address"]
        [::std::mem::offset_of!(kvm_memory_attributes, address) - 0usize];
    ["Offset of field: kvm_memory_attributes::size"]
        [::std::mem::offset_of!(kvm_memory_attributes, size) - 8usize];
    ["Offset of field: kvm_memory_attributes::attributes"]
        [::std::mem::offset_of!(kvm_memory_attributes, attributes) - 16usize];
    ["Offset of field: kvm_memory_attributes::flags"]
        [::std::mem::offset_of!(kvm_memory_attributes, flags) - 24usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_create_guest_memfd {
    pub size: __u64,
    pub flags: __u64,
    pub reserved: [__u64; 6usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of kvm_create_guest_memfd"][::std::mem::size_of::<kvm_create_guest_memfd>() - 64usize];
    ["Alignment of kvm_create_guest_memfd"]
        [::std::mem::align_of::<kvm_create_guest_memfd>() - 8usize];
    ["Offset of field: kvm_create_guest_memfd::size"]
        [::std::mem::offset_of!(kvm_create_guest_memfd, size) - 0usize];
    ["Offset of field: kvm_create_guest_memfd::flags"]
        [::std::mem::offset_of!(kvm_create_guest_memfd, flags) - 8usize];
    ["Offset of field: kvm_create_guest_memfd::reserved"]
        [::std::mem::offset_of!(kvm_create_guest_memfd, reserved) - 16usize];
};
