% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dic.fit.mcmc.R
\name{dic.fit.mcmc}
\alias{dic.fit.mcmc}
\title{Fits the distribution to the passed-in data using MCMC
as implemented in MCMCpack.}
\usage{
dic.fit.mcmc(
  dat,
  prior.par1 = NULL,
  prior.par2 = NULL,
  init.pars = c(1, 1),
  ptiles = c(0.05, 0.95, 0.99),
  verbose = 1000,
  burnin = 3000,
  n.samples = 5000,
  dist = "L",
  seed = NULL,
  ...
)
}
\arguments{
\item{dat}{the data}

\item{prior.par1}{vector of first prior parameters for each model parameter. If \code{NULL} then default parameters are used (as described in Details section).}

\item{prior.par2}{vector of second prior parameters for each model parameter. If \code{NULL} then default parameters are used (as described in Details section).}

\item{init.pars}{the initial parameter values (vector length = 2 )}

\item{ptiles}{returned percentiles of the survival survival distribution}

\item{verbose}{how often do you want a print out from MCMCpack on iteration number and M-H acceptance rate}

\item{burnin}{number of burnin samples}

\item{n.samples}{number of samples to draw from the posterior (after the burnin)}

\item{dist}{distribution to be used (L for log-normal,W for weibull, G for Gamma, and E for erlang, off1G for 1 day right shifted gamma)}

\item{seed}{seed for the random number generator for MCMC}

\item{...}{additional parameters to \link[MCMCpack]{MCMCmetrop1R}}
}
\value{
a cd.fit.mcmc S4 object
}
\description{
Similar to \code{\link{dic.fit}} but uses MCMC instead of a direct likelihood optimization routine to fit the model. Currently, four distributions are supported: log-normal, gamma, Weibull, and Erlang. See Details for prior specification.
}
\details{
The following models are used:
\deqn{Log-normal model: f(x) = \frac{1}{x*\sigma \sqrt{2 * \pi}} exp\{-\frac{(\log x - \mu)^2}{2 * \sigma^2}\}}
\deqn{Log-normal Default Prior: \mu ~ N(0, 1000), log(\sigma) ~ N(0,1000)}
\deqn{Weibull model: f(x) = \frac{\alpha}{\beta}(\frac{x}{\beta})^{\alpha-1} exp\{-(\frac{x}{\beta})^{\alpha}\}}
\deqn{Weibull Default Prior Specification: log(\alpha) ~ N( 0, 1000), \beta ~ Gamma(0.001,0.001)}
\deqn{Gamma model: f(x) = \frac{1}{\theta^k \Gamma(k)} x^{k-1} exp\{-\frac{x}{\theta}\}}

\deqn{Gamma Default Prior Specification: p(k,\theta) \propto \frac{1}{\theta} * \sqrt{k*TriGamma(k)-1}}
(Note: this is Jeffery's Prior when both parameters are unknown), and
\deqn{Trigamma(x) = \frac{\partial}{\partial x^2} ln(\Gamma(x))}.)
\deqn{Erlang model: f(x) = \frac{1}{\theta^k (k-1)!} x^{k-1} exp\{-\frac{x}{\theta}\}}
\deqn{Erlang Default Prior Specification: k \sim NBinom(100,1), log(\theta) \sim N(0,1000)}
(Note: parameters in the negative binomial distribution above represent mean and size, respectively)
}
