% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelAvg.R
\name{modelAvg}
\alias{modelAvg}
\title{Model Averaging for Linear Mixed Models}
\usage{
modelAvg(models, opt = TRUE)
}
\arguments{
\item{models}{A list object containing all considered candidate models fitted by
\code{\link[lme4]{lmer}} of the lme4-package or of class
\code{\link[nlme]{lme}}.}

\item{opt}{logical. If TRUE (the default) the model averaging approach based 
on Zhang et al. is applied. If FALSE the underlying weights are calculated 
as smoothed weights as proposed by Buckland et al. (1997).}
}
\value{
An object containing the function calls of the underlying candidate models,
the values of the model averaged fixed effects, the values of the model averaged random effects,
the results of the weight optimization process, as well as a list of the candidate models themselves.
}
\description{
Function to perform model averaging for linear mixed models based
on the weight selection criterion as proposed by Zhang et al. (2014).
}
\examples{
data(Orthodont, package = "nlme")
models <- list(
    model1 <- lmer(formula = distance ~ age + Sex + (1 | Subject) + age:Sex,
               data = Orthodont),
    model2 <- lmer(formula = distance ~ age + Sex + (1 | Subject),
               data = Orthodont),
    model3 <- lmer(formula = distance ~ age + (1 | Subject),
                 data = Orthodont),
    model4 <- lmer(formula = distance ~ Sex + (1 | Subject),
                data = Orthodont))
foo <- modelAvg(models = models)
foo


}
\references{
Greven, S. and Kneib T. (2010) On the behaviour of marginal and
conditional AIC in linear mixed models. Biometrika 97(4), 773-789.

Zhang, X., Zou, G., & Liang, H. (2014). Model averaging and
weight choice in linear mixed-effects models. Biometrika, 101(1), 205-218.
}
\seealso{
\code{\link[lme4]{lme4-package}}, \code{\link[lme4]{lmer}}
}
\author{
Benjamin Saefken & Rene-Marcel Kruse
}
