"""
Tsitouras's 5/4 order Runge-Kutta method

Runge–Kutta pairs of order 5(4) satisfying only the first column
simplifying assumption,
Ch. Tsitouras,
Computers & Mathematics with Applications, Vol 62, Issue 2, 770-775
Jan 2011
"""

__all__ = ["tsit5_coeff"]
import numpy as np
order = 5
rk_step = 7

a = np.zeros((rk_step, rk_step), dtype=np.float64)
b = np.zeros(rk_step, dtype=np.float64)
c = np.zeros(rk_step, dtype=np.float64)
e = np.zeros(rk_step, dtype=np.float64)
bi = np.zeros((rk_step, rk_step), dtype=np.float64)

c[0] = 0.
c[1] = .161
c[2] = .327
c[3] = .9
c[4] = .9800255409045097
c[5] = 1.
c[6] = 1.

b[0] =  .09646076681806523
b[1] =  .01
b[2] =  .4798896504144996
b[3] =  1.379008574103742
b[4] = -3.290069515436081
b[5] =  2.324710524099774
b[6] = 0.

e[0] =  .17800110522257773e-2
e[1] =  .8164344596567463e-3
e[2] = -.7880878010261994e-2
e[3] =  .1447110071732629
e[4] = -.5823571654525552
e[5] =  .45808210592918686
e[6] = -1/66

a[1, 0] = c[1]

a[2, 1] = 0.3354806554923570
a[2, 0] = c[2] - a[2, 1]

a[3, 1] = -6.359448489975075
a[3, 2] = 4.362295432869581
a[3, 0] = c[3] - a[3, 2] - a[3, 1]

a[4, 1] = -11.74888356406283
a[4, 2] = 7.495539342889836
a[4, 3] = -0.09249506636175525
a[4, 0] = c[4] - a[4, 3] - a[4, 2] - a[4, 1]

a[5, 1] = -12.92096931784711
a[5, 2] = 8.159367898576159
a[5, 3] = -0.071584973281401
a[5, 4] = -0.02826905039406838
a[5, 0] = c[5] - a[5, 4] - a[5, 3] - a[5, 2] - a[5, 1]

a[6, 0] =  .09646076681806523
a[6, 1] =  .01
a[6, 2] =  .4798896504144996
a[6, 3] =  1.379008574103742
a[6, 4] = -3.290069515436081
a[6, 5] =  2.324710524099774

bi[0, 0] = 1.
bi[0, 1] = -2.763706197274826
bi[0, 2] = 2.9132554618219126
bi[0, 3] = -1.0530884977290216

bi[1, 1] = 0.13169999999999998
bi[1, 2] = -0.2234
bi[1, 3] = 0.1017

bi[2, 1] = 3.930296236894751
bi[2, 2] = -5.941033872131505
bi[2, 3] = 2.490627285651253

bi[3, 1] = -12.411077166933676
bi[3, 2] = 30.338188630282318
bi[3, 3] = -16.548102889244902

bi[4, 1] = 37.50931341651104
bi[4, 2] = -88.1789048947664
bi[4, 3] = 47.37952196281928

bi[5, 1] = -27.896526289197286
bi[5, 2] = 65.09189467479368
bi[5, 3] = -34.87065786149661

bi[6, 1] = 1.5
bi[6, 2] = -4.0
bi[6, 3] = 2.5


tsit5_coeff = {'order': order, 'a': a, 'b': b, 'c': c, 'e': e, 'bi': bi}
