// SPDX-License-Identifier: (Apache-2.0 OR MIT)
// Copyright ijl (2024-2025)
// the constants and SIMD approach are adapted from cloudwego's sonic-rs

#[cfg(feature = "inline_int")]
macro_rules! write_escape {
    ($byte:expr, $dst:expr) => {
        debug_assert!($byte < 96);
        let escape = u64::from_ne_bytes(
            *crate::serialize::writer::str::escape::QUOTE_TAB.get_unchecked($byte as usize),
        );
        core::ptr::write($dst.cast::<u64>(), escape);
        $dst = $dst.add((escape as usize) >> 56);
    };
}

#[cfg(not(feature = "inline_int"))]
macro_rules! write_escape {
    ($byte:expr, $dst:expr) => {
        debug_assert!($byte < 96);
        let escape = crate::serialize::writer::str::escape::QUOTE_TAB.get_unchecked($byte as usize);
        core::ptr::copy_nonoverlapping(escape.as_ptr(), $dst, 8);
        $dst = $dst.add(((*escape.as_ptr().add(7)) as usize));
    };
}

pub(crate) const NEED_ESCAPED: [u8; 256] = [
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
];

pub(crate) const QUOTE_TAB: [[u8; 8]; 96] = [
    [b'\\', b'u', b'0', b'0', b'0', b'0', 0, 6],
    [b'\\', b'u', b'0', b'0', b'0', b'1', 0, 6],
    [b'\\', b'u', b'0', b'0', b'0', b'2', 0, 6],
    [b'\\', b'u', b'0', b'0', b'0', b'3', 0, 6],
    [b'\\', b'u', b'0', b'0', b'0', b'4', 0, 6],
    [b'\\', b'u', b'0', b'0', b'0', b'5', 0, 6],
    [b'\\', b'u', b'0', b'0', b'0', b'6', 0, 6],
    [b'\\', b'u', b'0', b'0', b'0', b'7', 0, 6],
    [b'\\', b'b', b'0', b'0', b'0', b'0', 0, 2],
    [b'\\', b't', b'0', b'0', b'0', b'0', 0, 2],
    [b'\\', b'n', b'0', b'0', b'0', b'0', 0, 2],
    [b'\\', b'u', b'0', b'0', b'0', b'b', 0, 6],
    [b'\\', b'f', b'0', b'0', b'0', b'0', 0, 2],
    [b'\\', b'r', b'0', b'0', b'0', b'0', 0, 2],
    [b'\\', b'u', b'0', b'0', b'0', b'e', 0, 6],
    [b'\\', b'u', b'0', b'0', b'0', b'f', 0, 6],
    [b'\\', b'u', b'0', b'0', b'1', b'0', 0, 6],
    [b'\\', b'u', b'0', b'0', b'1', b'1', 0, 6],
    [b'\\', b'u', b'0', b'0', b'1', b'2', 0, 6],
    [b'\\', b'u', b'0', b'0', b'1', b'3', 0, 6],
    [b'\\', b'u', b'0', b'0', b'1', b'4', 0, 6],
    [b'\\', b'u', b'0', b'0', b'1', b'5', 0, 6],
    [b'\\', b'u', b'0', b'0', b'1', b'6', 0, 6],
    [b'\\', b'u', b'0', b'0', b'1', b'7', 0, 6],
    [b'\\', b'u', b'0', b'0', b'1', b'8', 0, 6],
    [b'\\', b'u', b'0', b'0', b'1', b'9', 0, 6],
    [b'\\', b'u', b'0', b'0', b'1', b'a', 0, 6],
    [b'\\', b'u', b'0', b'0', b'1', b'b', 0, 6],
    [b'\\', b'u', b'0', b'0', b'1', b'c', 0, 6],
    [b'\\', b'u', b'0', b'0', b'1', b'd', 0, 6],
    [b'\\', b'u', b'0', b'0', b'1', b'e', 0, 6],
    [b'\\', b'u', b'0', b'0', b'1', b'f', 0, 6],
    [0; 8],
    [0; 8],
    [b'\\', b'"', 0, 0, 0, 0, 0, 2],
    [0; 8],
    [0; 8],
    [0; 8],
    [0; 8],
    [0; 8],
    [0; 8],
    [0; 8],
    [0; 8],
    [0; 8],
    [0; 8],
    [0; 8],
    [0; 8],
    [0; 8],
    [0; 8],
    [0; 8],
    [0; 8],
    [0; 8],
    [0; 8],
    [0; 8],
    [0; 8],
    [0; 8],
    [0; 8],
    [0; 8],
    [0; 8],
    [0; 8],
    [0; 8],
    [0; 8],
    [0; 8],
    [0; 8],
    [0; 8],
    [0; 8],
    [0; 8],
    [0; 8],
    [0; 8],
    [0; 8],
    [0; 8],
    [0; 8],
    [0; 8],
    [0; 8],
    [0; 8],
    [0; 8],
    [0; 8],
    [0; 8],
    [0; 8],
    [0; 8],
    [0; 8],
    [0; 8],
    [0; 8],
    [0; 8],
    [0; 8],
    [0; 8],
    [0; 8],
    [0; 8],
    [0; 8],
    [0; 8],
    [0; 8],
    [0; 8],
    [b'\\', b'\\', 0, 0, 0, 0, 0, 2],
    [0; 8],
    [0; 8],
    [0; 8],
];
