; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i386-pc-linux-gnu -mattr=+avx512f,+avx512vl,+avx512bw,+avx512dq | FileCheck %s --check-prefixes=CHECK,AVX512,X86-AVX512,AVX512-SLOW,X86-AVX512-SLOW
; RUN: llc < %s -mtriple=x86_64-pc-linux-gnu -mattr=+avx512f,+avx512vl,+avx512bw,+avx512dq | FileCheck %s --check-prefixes=CHECK,AVX512,X64-AVX512,AVX512-SLOW,X64-AVX512-SLOW
; RUN: llc < %s -mtriple=i386-pc-linux-gnu -mattr=+avx512f,+avx512vl,+avx512bw,+avx512dq,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=CHECK,AVX512,X86-AVX512,AVX512-FAST,X86-AVX512-FAST
; RUN: llc < %s -mtriple=x86_64-pc-linux-gnu -mattr=+avx512f,+avx512vl,+avx512bw,+avx512dq,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=CHECK,AVX512,X64-AVX512,AVX512-FAST,X64-AVX512-FAST
; RUN: llc < %s -mtriple=i386-pc-linux-gnu -mattr=+avx512f | FileCheck %s --check-prefixes=CHECK,AVX512F,X86-AVX512F
; RUN: llc < %s -mtriple=x86_64-pc-linux-gnu -mattr=+avx512f | FileCheck %s --check-prefixes=CHECK,AVX512F,X64-AVX512F

;expand 128 -> 256 include <4 x float> <2 x double>
define <8 x float> @expand(<4 x float> %a) {
; AVX512-LABEL: expand:
; AVX512:       # %bb.0:
; AVX512-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; AVX512-NEXT:    movb $5, %al
; AVX512-NEXT:    kmovd %eax, %k1
; AVX512-NEXT:    vexpandps %ymm0, %ymm0 {%k1} {z}
; AVX512-NEXT:    ret{{[l|q]}}
;
; AVX512F-LABEL: expand:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,1,1,3]
; AVX512F-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; AVX512F-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2],ymm1[3,4,5,6,7]
; AVX512F-NEXT:    ret{{[l|q]}}
   %res = shufflevector <4 x float> %a, <4 x float> zeroinitializer, <8 x i32> <i32 0, i32 5, i32 1, i32 5, i32 5, i32 5, i32 5, i32 5>
   ret <8 x float> %res
}

define <8 x float> @expand1(<4 x float> %a ) {
; AVX512-LABEL: expand1:
; AVX512:       # %bb.0:
; AVX512-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; AVX512-NEXT:    movb $-86, %al
; AVX512-NEXT:    kmovd %eax, %k1
; AVX512-NEXT:    vexpandps %ymm0, %ymm0 {%k1} {z}
; AVX512-NEXT:    ret{{[l|q]}}
;
; AVX512F-LABEL: expand1:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-NEXT:    vpmovsxbd {{.*#+}} ymm1 = [16,0,18,1,20,2,22,3]
; AVX512F-NEXT:    vxorps %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpermt2ps %zmm2, %zmm1, %zmm0
; AVX512F-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-NEXT:    ret{{[l|q]}}
   %res = shufflevector <4 x float> zeroinitializer, <4 x float> %a, <8 x i32> <i32 0, i32 4, i32 1, i32 5, i32 2, i32 6, i32 3, i32 7>
   ret <8 x float> %res
}

;Expand 128 -> 256 test <2 x double> -> <4 x double>
define <4 x double> @expand2(<2 x double> %a) {
; CHECK-LABEL: expand2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; CHECK-NEXT:    vperm2f128 {{.*#+}} ymm1 = zero,zero,ymm0[0,1]
; CHECK-NEXT:    vmovaps %xmm0, %xmm0
; CHECK-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5],ymm1[6,7]
; CHECK-NEXT:    ret{{[l|q]}}
   %res = shufflevector <2 x double> %a, <2 x double> zeroinitializer, <4 x i32> <i32 0, i32 2, i32 2, i32 1>
   ret <4 x double> %res
}

;expand 128 -> 256 include case <4 x i32> <8 x i32>
define <8 x i32> @expand3(<4 x i32> %a ) {
; AVX512-LABEL: expand3:
; AVX512:       # %bb.0:
; AVX512-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; AVX512-NEXT:    movb $-127, %al
; AVX512-NEXT:    kmovd %eax, %k1
; AVX512-NEXT:    vpexpandd %ymm0, %ymm0 {%k1} {z}
; AVX512-NEXT:    ret{{[l|q]}}
;
; AVX512F-LABEL: expand3:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vbroadcastsd %xmm0, %ymm0
; AVX512F-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; AVX512F-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1,2,3,4,5,6],ymm0[7]
; AVX512F-NEXT:    ret{{[l|q]}}
   %res = shufflevector <4 x i32> zeroinitializer, <4 x i32> %a, <8 x i32> <i32 4, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0,i32 5>
   ret <8 x i32> %res
}

;expand 128 -> 256 include case <2 x i64> <4 x i64>
define <4 x i64> @expand4(<2 x i64> %a ) {
; AVX512-LABEL: expand4:
; AVX512:       # %bb.0:
; AVX512-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; AVX512-NEXT:    movb $9, %al
; AVX512-NEXT:    kmovd %eax, %k1
; AVX512-NEXT:    vpexpandq %ymm0, %ymm0 {%k1} {z}
; AVX512-NEXT:    ret{{[l|q]}}
;
; AVX512F-LABEL: expand4:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; AVX512F-NEXT:    vperm2f128 {{.*#+}} ymm1 = zero,zero,ymm0[0,1]
; AVX512F-NEXT:    vmovaps %xmm0, %xmm0
; AVX512F-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5],ymm1[6,7]
; AVX512F-NEXT:    ret{{[l|q]}}
   %res = shufflevector <2 x i64> zeroinitializer, <2 x i64> %a, <4 x i32> <i32 2, i32 0, i32 0, i32 3>
   ret <4 x i64> %res
}

;Negative test for 128-> 256
define <8 x float> @expand5(<4 x float> %a ) {
; AVX512-SLOW-LABEL: expand5:
; AVX512-SLOW:       # %bb.0:
; AVX512-SLOW-NEXT:    vbroadcastss %xmm0, %ymm0
; AVX512-SLOW-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; AVX512-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1],ymm1[2],ymm0[3],ymm1[4],ymm0[5],ymm1[6],ymm0[7]
; AVX512-SLOW-NEXT:    ret{{[l|q]}}
;
; AVX512-FAST-LABEL: expand5:
; AVX512-FAST:       # %bb.0:
; AVX512-FAST-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; AVX512-FAST-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; AVX512-FAST-NEXT:    vpmovsxbq {{.*#+}} ymm2 = [8,10,12,14]
; AVX512-FAST-NEXT:    vpermt2ps %ymm1, %ymm2, %ymm0
; AVX512-FAST-NEXT:    ret{{[l|q]}}
;
; AVX512F-LABEL: expand5:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vbroadcastss %xmm0, %ymm0
; AVX512F-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; AVX512F-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1],ymm1[2],ymm0[3],ymm1[4],ymm0[5],ymm1[6],ymm0[7]
; AVX512F-NEXT:    ret{{[l|q]}}
   %res = shufflevector <4 x float> zeroinitializer, <4 x float> %a, <8 x i32> <i32 0, i32 4, i32 1, i32 4, i32 2, i32 4, i32 3, i32 4>
   ret <8 x float> %res
}

;expand 256 -> 512 include <8 x float> <16 x float>
define <8 x float> @expand6(<4 x float> %a ) {
; CHECK-LABEL: expand6:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; CHECK-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; CHECK-NEXT:    ret{{[l|q]}}
   %res = shufflevector <4 x float> zeroinitializer, <4 x float> %a, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
   ret <8 x float> %res
}

define <16 x float> @expand7(<8 x float> %a) {
; AVX512-LABEL: expand7:
; AVX512:       # %bb.0:
; AVX512-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512-NEXT:    movw $1285, %ax # imm = 0x505
; AVX512-NEXT:    kmovd %eax, %k1
; AVX512-NEXT:    vexpandps %zmm0, %zmm0 {%k1} {z}
; AVX512-NEXT:    ret{{[l|q]}}
;
; AVX512F-LABEL: expand7:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-NEXT:    movw $1285, %ax # imm = 0x505
; AVX512F-NEXT:    kmovw %eax, %k1
; AVX512F-NEXT:    vexpandps %zmm0, %zmm0 {%k1} {z}
; AVX512F-NEXT:    ret{{[l|q]}}
   %res = shufflevector <8 x float> %a, <8 x float> zeroinitializer, <16 x i32> <i32 0, i32 8, i32 1, i32 8, i32 8, i32 8, i32 8, i32 8, i32 2, i32 8, i32 3, i32 8, i32 8, i32 8, i32 8, i32 8>
   ret <16 x float> %res
}

define <16 x float> @expand8(<8 x float> %a ) {
; AVX512-LABEL: expand8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512-NEXT:    movw $-21846, %ax # imm = 0xAAAA
; AVX512-NEXT:    kmovd %eax, %k1
; AVX512-NEXT:    vexpandps %zmm0, %zmm0 {%k1} {z}
; AVX512-NEXT:    ret{{[l|q]}}
;
; AVX512F-LABEL: expand8:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-NEXT:    movw $-21846, %ax # imm = 0xAAAA
; AVX512F-NEXT:    kmovw %eax, %k1
; AVX512F-NEXT:    vexpandps %zmm0, %zmm0 {%k1} {z}
; AVX512F-NEXT:    ret{{[l|q]}}
   %res = shufflevector <8 x float> zeroinitializer, <8 x float> %a, <16 x i32> <i32 0, i32 8, i32 1, i32 9, i32 2, i32 10, i32 3, i32 11, i32 4, i32 12, i32 5, i32 13, i32 6, i32 14, i32 7, i32 15>
   ret <16 x float> %res
}

;expand 256 -> 512 include <4 x double> <8 x double>
define <8 x double> @expand9(<4 x double> %a) {
; AVX512-LABEL: expand9:
; AVX512:       # %bb.0:
; AVX512-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512-NEXT:    movb $-127, %al
; AVX512-NEXT:    kmovd %eax, %k1
; AVX512-NEXT:    vexpandpd %zmm0, %zmm0 {%k1} {z}
; AVX512-NEXT:    ret{{[l|q]}}
;
; AVX512F-LABEL: expand9:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-NEXT:    movb $-127, %al
; AVX512F-NEXT:    kmovw %eax, %k1
; AVX512F-NEXT:    vexpandpd %zmm0, %zmm0 {%k1} {z}
; AVX512F-NEXT:    ret{{[l|q]}}
   %res = shufflevector <4 x double> %a, <4 x double> zeroinitializer, <8 x i32> <i32 0, i32 4, i32 4, i32 4, i32 4, i32 4, i32 4, i32 1>
   ret <8 x double> %res
}

define <16 x i32> @expand10(<8 x i32> %a ) {
; AVX512-LABEL: expand10:
; AVX512:       # %bb.0:
; AVX512-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512-NEXT:    movw $-21846, %ax # imm = 0xAAAA
; AVX512-NEXT:    kmovd %eax, %k1
; AVX512-NEXT:    vpexpandd %zmm0, %zmm0 {%k1} {z}
; AVX512-NEXT:    ret{{[l|q]}}
;
; AVX512F-LABEL: expand10:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-NEXT:    movw $-21846, %ax # imm = 0xAAAA
; AVX512F-NEXT:    kmovw %eax, %k1
; AVX512F-NEXT:    vpexpandd %zmm0, %zmm0 {%k1} {z}
; AVX512F-NEXT:    ret{{[l|q]}}
   %res = shufflevector <8 x i32> zeroinitializer, <8 x i32> %a, <16 x i32> <i32 0, i32 8, i32 1, i32 9, i32 2, i32 10, i32 3, i32 11, i32 4, i32 12, i32 5, i32 13, i32 6, i32 14, i32 7, i32 15>
   ret <16 x i32> %res
}

define <8 x i64> @expand11(<4 x i64> %a) {
; AVX512-LABEL: expand11:
; AVX512:       # %bb.0:
; AVX512-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512-NEXT:    movb $-127, %al
; AVX512-NEXT:    kmovd %eax, %k1
; AVX512-NEXT:    vpexpandq %zmm0, %zmm0 {%k1} {z}
; AVX512-NEXT:    ret{{[l|q]}}
;
; AVX512F-LABEL: expand11:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-NEXT:    movb $-127, %al
; AVX512F-NEXT:    kmovw %eax, %k1
; AVX512F-NEXT:    vpexpandq %zmm0, %zmm0 {%k1} {z}
; AVX512F-NEXT:    ret{{[l|q]}}
   %res = shufflevector <4 x i64> %a, <4 x i64> zeroinitializer, <8 x i32> <i32 0, i32 4, i32 4, i32 4, i32 4, i32 4, i32 4, i32 1>
   ret <8 x i64> %res
}

;Negative test for 256-> 512
define <16 x float> @expand12(<8 x float> %a) {
; CHECK-LABEL: expand12:
; CHECK:       # %bb.0:
; CHECK-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; CHECK-NEXT:    vpmovsxbd {{.*#+}} zmm2 = [0,16,2,16,4,16,6,16,0,16,1,16,2,16,3,16]
; CHECK-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; CHECK-NEXT:    vpermt2ps %zmm0, %zmm2, %zmm1
; CHECK-NEXT:    vmovaps %zmm1, %zmm0
; CHECK-NEXT:    ret{{[l|q]}}
   %res = shufflevector <8 x float> zeroinitializer, <8 x float> %a, <16 x i32> <i32 0, i32 8, i32 1, i32 8, i32 2, i32 8, i32 3, i32 8,i32 0, i32 8, i32 1, i32 8, i32 2, i32 8, i32 3, i32 8>
   ret <16 x float> %res
}

define <16 x float> @expand13(<8 x float> %a ) {
; CHECK-LABEL: expand13:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; CHECK-NEXT:    vinsertf64x4 $1, %ymm0, %zmm1, %zmm0
; CHECK-NEXT:    ret{{[l|q]}}
   %res = shufflevector <8 x float> zeroinitializer, <8 x float> %a, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7,i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
   ret <16 x float> %res
}

; The function checks for a case where the vector is mixed values vector ,and the mask points on zero elements from this vector.

define <8 x float> @expand14(<4 x float> %a) {
; AVX512-LABEL: expand14:
; AVX512:       # %bb.0:
; AVX512-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; AVX512-NEXT:    movb $20, %al
; AVX512-NEXT:    kmovd %eax, %k1
; AVX512-NEXT:    vexpandps %ymm0, %ymm0 {%k1} {z}
; AVX512-NEXT:    ret{{[l|q]}}
;
; AVX512F-LABEL: expand14:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-NEXT:    vpmovsxbd {{.*#+}} ymm1 = [16,17,0,19,1,21,22,23]
; AVX512F-NEXT:    vxorps %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpermt2ps %zmm2, %zmm1, %zmm0
; AVX512F-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-NEXT:    ret{{[l|q]}}
   %addV = fadd <4 x float> <float 0.0,float 1.0,float 2.0,float 0.0> , <float 0.0,float 1.0,float 2.0,float 0.0>
   %res = shufflevector <4 x float> %addV, <4 x float> %a, <8 x i32> <i32 3, i32 3, i32 4, i32 0, i32 5, i32 0, i32 0, i32 0>
   ret <8 x float> %res
}

;Negative test.
define <8 x float> @expand15(<4 x float> %a) {
; AVX512-SLOW-LABEL: expand15:
; AVX512-SLOW:       # %bb.0:
; AVX512-SLOW-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,1,1,3]
; AVX512-SLOW-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,0,1,3]
; AVX512-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = mem[0,1],ymm0[2],mem[3],ymm0[4],mem[5,6,7]
; AVX512-SLOW-NEXT:    ret{{[l|q]}}
;
; AVX512-FAST-LABEL: expand15:
; AVX512-FAST:       # %bb.0:
; AVX512-FAST-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; AVX512-FAST-NEXT:    vpmovsxbq {{.*#+}} ymm1 = [0,0,1,0]
; AVX512-FAST-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX512-FAST-NEXT:    vblendps {{.*#+}} ymm0 = mem[0,1],ymm0[2],mem[3],ymm0[4],mem[5,6,7]
; AVX512-FAST-NEXT:    ret{{[l|q]}}
;
; AVX512F-LABEL: expand15:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,1,1,3]
; AVX512F-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,0,1,3]
; AVX512F-NEXT:    vblendps {{.*#+}} ymm0 = mem[0,1],ymm0[2],mem[3],ymm0[4],mem[5,6,7]
; AVX512F-NEXT:    ret{{[l|q]}}
   %addV = fadd <4 x float> <float 0.0,float 1.0,float 2.0,float 0.0> , <float 0.0,float 1.0,float 2.0,float 0.0>
   %res = shufflevector <4 x float> %addV, <4 x float> %a, <8 x i32> <i32 0, i32 1, i32 4, i32 0, i32 5, i32 0, i32 0, i32 0>
   ret <8 x float> %res
}

; Shuffle to blend test

define <64 x i8> @test_mm512_mask_blend_epi8(<64 x i8> %A, <64 x i8> %W){
; X86-AVX512-LABEL: test_mm512_mask_blend_epi8:
; X86-AVX512:       # %bb.0: # %entry
; X86-AVX512-NEXT:    movl $-1431655766, %eax # imm = 0xAAAAAAAA
; X86-AVX512-NEXT:    kmovd %eax, %k0
; X86-AVX512-NEXT:    kunpckdq %k0, %k0, %k1
; X86-AVX512-NEXT:    vpblendmb %zmm0, %zmm1, %zmm0 {%k1}
; X86-AVX512-NEXT:    retl
;
; X64-AVX512-LABEL: test_mm512_mask_blend_epi8:
; X64-AVX512:       # %bb.0: # %entry
; X64-AVX512-NEXT:    movabsq $-6148914691236517206, %rax # imm = 0xAAAAAAAAAAAAAAAA
; X64-AVX512-NEXT:    kmovq %rax, %k1
; X64-AVX512-NEXT:    vpblendmb %zmm0, %zmm1, %zmm0 {%k1}
; X64-AVX512-NEXT:    retq
;
; AVX512F-LABEL: test_mm512_mask_blend_epi8:
; AVX512F:       # %bb.0: # %entry
; AVX512F-NEXT:    vpbroadcastw {{.*#+}} ymm2 = [255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0]
; AVX512F-NEXT:    vinserti64x4 $1, %ymm2, %zmm2, %zmm2
; AVX512F-NEXT:    vpternlogq {{.*#+}} zmm0 = zmm0 ^ (zmm2 & (zmm0 ^ zmm1))
; AVX512F-NEXT:    ret{{[l|q]}}
entry:
  %0 = shufflevector <64 x i8> %A, <64 x i8> %W, <64 x i32>  <i32 64, i32 1, i32 66, i32 3, i32 68, i32 5, i32 70, i32 7, i32 72, i32 9, i32 74, i32 11, i32 76, i32 13, i32 78, i32 15, i32 80, i32 17, i32 82, i32 19, i32 84, i32 21, i32 86, i32 23, i32 88, i32 25, i32 90, i32 27, i32 92, i32 29, i32 94, i32 31, i32 96, i32 33, i32 98, i32 35, i32 100, i32 37, i32 102, i32 39, i32 104, i32 41, i32 106, i32 43, i32 108, i32 45, i32 110, i32 47, i32 112, i32 49, i32 114, i32 51, i32 116, i32 53, i32 118, i32 55, i32 120, i32 57, i32 122, i32 59, i32 124, i32 61, i32 126, i32 63>
  ret <64 x i8> %0
}

define <32 x i16> @test_mm512_mask_blend_epi16(<32 x i16> %A, <32 x i16> %W){
; AVX512-LABEL: test_mm512_mask_blend_epi16:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    movl $-1431655766, %eax # imm = 0xAAAAAAAA
; AVX512-NEXT:    kmovd %eax, %k1
; AVX512-NEXT:    vpblendmw %zmm0, %zmm1, %zmm0 {%k1}
; AVX512-NEXT:    ret{{[l|q]}}
;
; AVX512F-LABEL: test_mm512_mask_blend_epi16:
; AVX512F:       # %bb.0: # %entry
; AVX512F-NEXT:    vpternlogd {{.*#+}} zmm0 = zmm0 ^ (m32bcst & (zmm0 ^ zmm1))
; AVX512F-NEXT:    ret{{[l|q]}}
entry:
  %0 = shufflevector <32 x i16> %A, <32 x i16> %W, <32 x i32>  <i32 32, i32 1, i32 34, i32 3, i32 36, i32 5, i32 38, i32 7, i32 40, i32 9, i32 42, i32 11, i32 44, i32 13, i32 46, i32 15, i32 48, i32 17, i32 50, i32 19, i32 52, i32 21, i32 54, i32 23, i32 56, i32 25, i32 58, i32 27, i32 60, i32 29, i32 62, i32 31>
  ret <32 x i16> %0
}

define <16 x i32> @test_mm512_mask_blend_epi32(<16 x i32> %A, <16 x i32> %W){
; AVX512-LABEL: test_mm512_mask_blend_epi32:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    movw $-21846, %ax # imm = 0xAAAA
; AVX512-NEXT:    kmovd %eax, %k1
; AVX512-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512-NEXT:    ret{{[l|q]}}
;
; AVX512F-LABEL: test_mm512_mask_blend_epi32:
; AVX512F:       # %bb.0: # %entry
; AVX512F-NEXT:    movw $-21846, %ax # imm = 0xAAAA
; AVX512F-NEXT:    kmovw %eax, %k1
; AVX512F-NEXT:    vpblendmd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-NEXT:    ret{{[l|q]}}
entry:
  %0 = shufflevector <16 x i32> %A, <16 x i32> %W, <16 x i32>  <i32 16, i32 1, i32 18, i32 3, i32 20, i32 5, i32 22, i32 7, i32 24, i32 9, i32 26, i32 11, i32 28, i32 13, i32 30, i32 15>
  ret <16 x i32> %0
}

define <8 x i64> @test_mm512_mask_blend_epi64(<8 x i64> %A, <8 x i64> %W){
; AVX512-LABEL: test_mm512_mask_blend_epi64:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    movb $-86, %al
; AVX512-NEXT:    kmovd %eax, %k1
; AVX512-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512-NEXT:    ret{{[l|q]}}
;
; AVX512F-LABEL: test_mm512_mask_blend_epi64:
; AVX512F:       # %bb.0: # %entry
; AVX512F-NEXT:    movb $-86, %al
; AVX512F-NEXT:    kmovw %eax, %k1
; AVX512F-NEXT:    vpblendmq %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-NEXT:    ret{{[l|q]}}
entry:
  %0 = shufflevector <8 x i64> %A, <8 x i64> %W, <8 x i32>  <i32 8, i32 1, i32 10, i32 3, i32 12, i32 5, i32 14, i32 7>
  ret <8 x i64> %0
}

define <16 x float> @test_mm512_mask_blend_ps(<16 x float> %A, <16 x float> %W){
; AVX512-LABEL: test_mm512_mask_blend_ps:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    movw $-21846, %ax # imm = 0xAAAA
; AVX512-NEXT:    kmovd %eax, %k1
; AVX512-NEXT:    vblendmps %zmm0, %zmm1, %zmm0 {%k1}
; AVX512-NEXT:    ret{{[l|q]}}
;
; AVX512F-LABEL: test_mm512_mask_blend_ps:
; AVX512F:       # %bb.0: # %entry
; AVX512F-NEXT:    movw $-21846, %ax # imm = 0xAAAA
; AVX512F-NEXT:    kmovw %eax, %k1
; AVX512F-NEXT:    vblendmps %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-NEXT:    ret{{[l|q]}}
entry:
  %0 = shufflevector <16 x float> %A, <16 x float> %W, <16 x i32>  <i32 16, i32 1, i32 18, i32 3, i32 20, i32 5, i32 22, i32 7, i32 24, i32 9, i32 26, i32 11, i32 28, i32 13, i32 30, i32 15>
  ret <16 x float> %0
}

define <8 x double> @test_mm512_mask_blend_pd(<8 x double> %A, <8 x double> %W){
; AVX512-LABEL: test_mm512_mask_blend_pd:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    movb $-88, %al
; AVX512-NEXT:    kmovd %eax, %k1
; AVX512-NEXT:    vblendmpd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512-NEXT:    ret{{[l|q]}}
;
; AVX512F-LABEL: test_mm512_mask_blend_pd:
; AVX512F:       # %bb.0: # %entry
; AVX512F-NEXT:    movb $-88, %al
; AVX512F-NEXT:    kmovw %eax, %k1
; AVX512F-NEXT:    vblendmpd %zmm0, %zmm1, %zmm0 {%k1}
; AVX512F-NEXT:    ret{{[l|q]}}
entry:
  %0 = shufflevector <8 x double> %A, <8 x double> %W, <8 x i32>  <i32 8, i32 9, i32 10, i32 3, i32 12, i32 5, i32 14, i32 7>
  ret <8 x double> %0
}


define <32 x i8> @test_mm256_mask_blend_epi8(<32 x i8> %A, <32 x i8> %W){
; AVX512-LABEL: test_mm256_mask_blend_epi8:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    movl $-1431655766, %eax # imm = 0xAAAAAAAA
; AVX512-NEXT:    kmovd %eax, %k1
; AVX512-NEXT:    vpblendmb %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-NEXT:    ret{{[l|q]}}
;
; AVX512F-LABEL: test_mm256_mask_blend_epi8:
; AVX512F:       # %bb.0: # %entry
; AVX512F-NEXT:    vpbroadcastw {{.*#+}} ymm2 = [255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0]
; AVX512F-NEXT:    vpblendvb %ymm2, %ymm1, %ymm0, %ymm0
; AVX512F-NEXT:    ret{{[l|q]}}
entry:
  %0 = shufflevector <32 x i8> %A, <32 x i8> %W, <32 x i32>  <i32 32, i32 1, i32 34, i32 3, i32 36, i32 5, i32 38, i32 7, i32 40, i32 9, i32 42, i32 11, i32 44, i32 13, i32 46, i32 15, i32 48, i32 17, i32 50, i32 19, i32 52, i32 21, i32 54, i32 23, i32 56, i32 25, i32 58, i32 27, i32 60, i32 29, i32 62, i32 31>
  ret <32 x i8> %0
}

define <16 x i8> @test_mm_mask_blend_epi8(<16 x i8> %A, <16 x i8> %W){
; AVX512-LABEL: test_mm_mask_blend_epi8:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    movw $-21846, %ax # imm = 0xAAAA
; AVX512-NEXT:    kmovd %eax, %k1
; AVX512-NEXT:    vpblendmb %xmm0, %xmm1, %xmm0 {%k1}
; AVX512-NEXT:    ret{{[l|q]}}
;
; AVX512F-LABEL: test_mm_mask_blend_epi8:
; AVX512F:       # %bb.0: # %entry
; AVX512F-NEXT:    vpbroadcastw {{.*#+}} xmm2 = [255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0]
; AVX512F-NEXT:    vpblendvb %xmm2, %xmm1, %xmm0, %xmm0
; AVX512F-NEXT:    ret{{[l|q]}}
entry:
  %0 = shufflevector <16 x i8> %A, <16 x i8> %W, <16 x i32>  <i32 16, i32 1, i32 18, i32 3, i32 20, i32 5, i32 22, i32 7, i32 24, i32 9, i32 26, i32 11, i32 28, i32 13, i32 30, i32 15>
  ret <16 x i8> %0
}

; PR34370
define <8 x float> @test_masked_permps_v8f32(ptr %vp, <8 x float> %vec2) {
; X86-AVX512-LABEL: test_masked_permps_v8f32:
; X86-AVX512:       # %bb.0:
; X86-AVX512-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-AVX512-NEXT:    vpmovsxbd {{.*#+}} ymm1 = [15,14,11,3,15,14,6,7]
; X86-AVX512-NEXT:    vpermt2ps (%eax), %ymm1, %ymm0
; X86-AVX512-NEXT:    retl
;
; X64-AVX512-LABEL: test_masked_permps_v8f32:
; X64-AVX512:       # %bb.0:
; X64-AVX512-NEXT:    vpmovsxbd {{.*#+}} ymm1 = [15,14,11,3,15,14,6,7]
; X64-AVX512-NEXT:    vpermt2ps (%rdi), %ymm1, %ymm0
; X64-AVX512-NEXT:    retq
;
; X86-AVX512F-LABEL: test_masked_permps_v8f32:
; X86-AVX512F:       # %bb.0:
; X86-AVX512F-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; X86-AVX512F-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-AVX512F-NEXT:    vmovaps (%eax), %ymm1
; X86-AVX512F-NEXT:    vpmovsxbd {{.*#+}} ymm2 = [23,22,19,3,23,22,6,7]
; X86-AVX512F-NEXT:    vpermt2ps %zmm1, %zmm2, %zmm0
; X86-AVX512F-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; X86-AVX512F-NEXT:    retl
;
; X64-AVX512F-LABEL: test_masked_permps_v8f32:
; X64-AVX512F:       # %bb.0:
; X64-AVX512F-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; X64-AVX512F-NEXT:    vmovaps (%rdi), %ymm1
; X64-AVX512F-NEXT:    vpmovsxbd {{.*#+}} ymm2 = [23,22,19,3,23,22,6,7]
; X64-AVX512F-NEXT:    vpermt2ps %zmm1, %zmm2, %zmm0
; X64-AVX512F-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; X64-AVX512F-NEXT:    retq
  %vec = load <8 x float>, ptr %vp
  %shuf = shufflevector <8 x float> %vec, <8 x float> undef, <8 x i32> <i32 7, i32 6, i32 3, i32 0, i32 7, i32 6, i32 3, i32 0>
  %res = select <8 x i1> <i1 1, i1 1, i1 1, i1 0, i1 1, i1 1, i1 0, i1 0>, <8 x float> %shuf, <8 x float> %vec2
  ret <8 x float> %res
}

define <16 x float> @test_masked_permps_v16f32(ptr %vp, <16 x float> %vec2) {
; X86-AVX512-LABEL: test_masked_permps_v16f32:
; X86-AVX512:       # %bb.0:
; X86-AVX512-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm1 = [31,29,27,3,30,28,6,7,23,22,19,11,23,13,19,15]
; X86-AVX512-NEXT:    vpermt2ps (%eax), %zmm1, %zmm0
; X86-AVX512-NEXT:    retl
;
; X64-AVX512-LABEL: test_masked_permps_v16f32:
; X64-AVX512:       # %bb.0:
; X64-AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm1 = [31,29,27,3,30,28,6,7,23,22,19,11,23,13,19,15]
; X64-AVX512-NEXT:    vpermt2ps (%rdi), %zmm1, %zmm0
; X64-AVX512-NEXT:    retq
;
; X86-AVX512F-LABEL: test_masked_permps_v16f32:
; X86-AVX512F:       # %bb.0:
; X86-AVX512F-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-AVX512F-NEXT:    vpmovsxbd {{.*#+}} zmm1 = [31,29,27,3,30,28,6,7,23,22,19,11,23,13,19,15]
; X86-AVX512F-NEXT:    vpermt2ps (%eax), %zmm1, %zmm0
; X86-AVX512F-NEXT:    retl
;
; X64-AVX512F-LABEL: test_masked_permps_v16f32:
; X64-AVX512F:       # %bb.0:
; X64-AVX512F-NEXT:    vpmovsxbd {{.*#+}} zmm1 = [31,29,27,3,30,28,6,7,23,22,19,11,23,13,19,15]
; X64-AVX512F-NEXT:    vpermt2ps (%rdi), %zmm1, %zmm0
; X64-AVX512F-NEXT:    retq
  %vec = load <16 x float>, ptr %vp
  %shuf = shufflevector <16 x float> %vec, <16 x float> undef, <16 x i32> <i32 15, i32 13, i32 11, i32 9, i32 14, i32 12, i32 10, i32 8, i32 7, i32 6, i32 3, i32 0, i32 7, i32 6, i32 3, i32 0>
  %res = select <16 x i1> <i1 1, i1 1, i1 1, i1 0, i1 1, i1 1, i1 0, i1 0, i1 1, i1 1, i1 1, i1 0, i1 1, i1 0, i1 1, i1 0>, <16 x float> %shuf, <16 x float> %vec2
  ret <16 x float> %res
}

define void @test_demandedelts_pshufb_v32i8_v16i8(ptr %src, ptr %dst) {
; X86-AVX512-SLOW-LABEL: test_demandedelts_pshufb_v32i8_v16i8:
; X86-AVX512-SLOW:       # %bb.0:
; X86-AVX512-SLOW-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-AVX512-SLOW-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-AVX512-SLOW-NEXT:    vpbroadcastd 44(%ecx), %xmm0
; X86-AVX512-SLOW-NEXT:    vmovq {{.*#+}} xmm0 = xmm0[0],zero
; X86-AVX512-SLOW-NEXT:    vmovdqa %ymm0, 672(%eax)
; X86-AVX512-SLOW-NEXT:    vpshufd {{.*#+}} xmm0 = mem[1,0,2,3]
; X86-AVX512-SLOW-NEXT:    vmovq {{.*#+}} xmm0 = xmm0[0],zero
; X86-AVX512-SLOW-NEXT:    vmovdqa %ymm0, 832(%eax)
; X86-AVX512-SLOW-NEXT:    vzeroupper
; X86-AVX512-SLOW-NEXT:    retl
;
; X64-AVX512-SLOW-LABEL: test_demandedelts_pshufb_v32i8_v16i8:
; X64-AVX512-SLOW:       # %bb.0:
; X64-AVX512-SLOW-NEXT:    vpbroadcastd 44(%rdi), %xmm0
; X64-AVX512-SLOW-NEXT:    vmovq {{.*#+}} xmm0 = xmm0[0],zero
; X64-AVX512-SLOW-NEXT:    vmovdqa %ymm0, 672(%rsi)
; X64-AVX512-SLOW-NEXT:    vpshufd {{.*#+}} xmm0 = mem[1,0,2,3]
; X64-AVX512-SLOW-NEXT:    vmovq {{.*#+}} xmm0 = xmm0[0],zero
; X64-AVX512-SLOW-NEXT:    vmovdqa %ymm0, 832(%rsi)
; X64-AVX512-SLOW-NEXT:    vzeroupper
; X64-AVX512-SLOW-NEXT:    retq
;
; X86-AVX512-FAST-LABEL: test_demandedelts_pshufb_v32i8_v16i8:
; X86-AVX512-FAST:       # %bb.0:
; X86-AVX512-FAST-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-AVX512-FAST-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-AVX512-FAST-NEXT:    vpbroadcastd 44(%ecx), %xmm0
; X86-AVX512-FAST-NEXT:    vmovq {{.*#+}} xmm0 = xmm0[0],zero
; X86-AVX512-FAST-NEXT:    vmovdqa %ymm0, 672(%eax)
; X86-AVX512-FAST-NEXT:    vmovdqa 208(%ecx), %xmm0
; X86-AVX512-FAST-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[4,5,6,7,0,1,2,3],zero,zero,zero,zero,zero,zero,zero,zero
; X86-AVX512-FAST-NEXT:    vmovdqa %ymm0, 832(%eax)
; X86-AVX512-FAST-NEXT:    vzeroupper
; X86-AVX512-FAST-NEXT:    retl
;
; X64-AVX512-FAST-LABEL: test_demandedelts_pshufb_v32i8_v16i8:
; X64-AVX512-FAST:       # %bb.0:
; X64-AVX512-FAST-NEXT:    vpbroadcastd 44(%rdi), %xmm0
; X64-AVX512-FAST-NEXT:    vmovq {{.*#+}} xmm0 = xmm0[0],zero
; X64-AVX512-FAST-NEXT:    vmovdqa %ymm0, 672(%rsi)
; X64-AVX512-FAST-NEXT:    vmovdqa 208(%rdi), %xmm0
; X64-AVX512-FAST-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[4,5,6,7,0,1,2,3],zero,zero,zero,zero,zero,zero,zero,zero
; X64-AVX512-FAST-NEXT:    vmovdqa %ymm0, 832(%rsi)
; X64-AVX512-FAST-NEXT:    vzeroupper
; X64-AVX512-FAST-NEXT:    retq
;
; X86-AVX512F-LABEL: test_demandedelts_pshufb_v32i8_v16i8:
; X86-AVX512F:       # %bb.0:
; X86-AVX512F-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-AVX512F-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-AVX512F-NEXT:    vpbroadcastd 44(%ecx), %xmm0
; X86-AVX512F-NEXT:    vmovq {{.*#+}} xmm0 = xmm0[0],zero
; X86-AVX512F-NEXT:    vmovdqa %ymm0, 672(%eax)
; X86-AVX512F-NEXT:    vpshufd {{.*#+}} xmm0 = mem[1,0,2,3]
; X86-AVX512F-NEXT:    vmovq {{.*#+}} xmm0 = xmm0[0],zero
; X86-AVX512F-NEXT:    vmovdqa %ymm0, 832(%eax)
; X86-AVX512F-NEXT:    vzeroupper
; X86-AVX512F-NEXT:    retl
;
; X64-AVX512F-LABEL: test_demandedelts_pshufb_v32i8_v16i8:
; X64-AVX512F:       # %bb.0:
; X64-AVX512F-NEXT:    vpbroadcastd 44(%rdi), %xmm0
; X64-AVX512F-NEXT:    vmovq {{.*#+}} xmm0 = xmm0[0],zero
; X64-AVX512F-NEXT:    vmovdqa %ymm0, 672(%rsi)
; X64-AVX512F-NEXT:    vpshufd {{.*#+}} xmm0 = mem[1,0,2,3]
; X64-AVX512F-NEXT:    vmovq {{.*#+}} xmm0 = xmm0[0],zero
; X64-AVX512F-NEXT:    vmovdqa %ymm0, 832(%rsi)
; X64-AVX512F-NEXT:    vzeroupper
; X64-AVX512F-NEXT:    retq
  %t87 = load <16 x i32>, ptr %src, align 64
  %t88 = extractelement <16 x i32> %t87, i64 11
  %t89 = insertelement <8 x i32> <i32 undef, i32 undef, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>, i32 %t88, i64 0
  %t90 = insertelement <8 x i32> %t89, i32 %t88, i64 1
  %ptridx49.i = getelementptr inbounds <8 x i32>, ptr %dst, i64 21
  store <8 x i32> %t90, ptr %ptridx49.i, align 32
  %ptridx56.i = getelementptr inbounds <2 x i32>, ptr %src, i64 24
  %t09 = load <16 x i32>, ptr %ptridx56.i, align 64
  %t10 = extractelement <16 x i32> %t09, i64 5
  %t11 = insertelement <8 x i32> <i32 undef, i32 undef, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>, i32 %t10, i64 0
  %t12 = extractelement <16 x i32> %t09, i64 4
  %t13 = insertelement <8 x i32> %t11, i32 %t12, i64 1
  %ptridx64.i = getelementptr inbounds <8 x i32>, ptr %dst, i64 26
  store <8 x i32> %t13, ptr %ptridx64.i, align 32
  ret void
}

define <32 x float> @PR47534(<8 x float> %tmp) {
; CHECK-LABEL: PR47534:
; CHECK:       # %bb.0:
; CHECK-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; CHECK-NEXT:    vxorps %xmm2, %xmm2, %xmm2
; CHECK-NEXT:    vpmovsxbd {{.*#+}} zmm1 = [7,17,18,19,7,21,22,23,0,25,26,27,0,29,30,31]
; CHECK-NEXT:    vpermi2ps %zmm2, %zmm0, %zmm1
; CHECK-NEXT:    ret{{[l|q]}}
  %tmp1 = shufflevector <8 x float> %tmp, <8 x float> undef, <32 x i32> <i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 7, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %tmp2 = shufflevector <32 x float> <float undef, float undef, float undef, float undef, float undef, float undef, float undef, float undef, float undef, float undef, float undef, float undef, float undef, float undef, float undef, float undef, float undef, float undef, float undef, float undef, float undef, float undef, float undef, float undef, float undef, float undef, float undef, float undef, float undef, float 0.000000e+00, float 0.000000e+00, float 0.000000e+00>, <32 x float> undef, <32 x i32> <i32 39, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 29, i32 30, i32 31>
  %tmp18 = shufflevector <32 x float> %tmp2, <32 x float> %tmp1, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 39, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 29, i32 30, i32 31>
  ret <32 x float> %tmp18
}

%union1= type { <16 x float> }
@src1 = external dso_local local_unnamed_addr global %union1, align 64

define void @PR43170(ptr %a0) {
; X86-AVX512-LABEL: PR43170:
; X86-AVX512:       # %bb.0: # %entry
; X86-AVX512-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-AVX512-NEXT:    vmovaps src1, %ymm0
; X86-AVX512-NEXT:    vmovaps %zmm0, (%eax)
; X86-AVX512-NEXT:    vzeroupper
; X86-AVX512-NEXT:    retl
;
; X64-AVX512-LABEL: PR43170:
; X64-AVX512:       # %bb.0: # %entry
; X64-AVX512-NEXT:    vmovaps src1(%rip), %ymm0
; X64-AVX512-NEXT:    vmovaps %zmm0, (%rdi)
; X64-AVX512-NEXT:    vzeroupper
; X64-AVX512-NEXT:    retq
;
; X86-AVX512F-LABEL: PR43170:
; X86-AVX512F:       # %bb.0: # %entry
; X86-AVX512F-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-AVX512F-NEXT:    vmovaps src1, %ymm0
; X86-AVX512F-NEXT:    vmovaps %zmm0, (%eax)
; X86-AVX512F-NEXT:    vzeroupper
; X86-AVX512F-NEXT:    retl
;
; X64-AVX512F-LABEL: PR43170:
; X64-AVX512F:       # %bb.0: # %entry
; X64-AVX512F-NEXT:    vmovaps src1(%rip), %ymm0
; X64-AVX512F-NEXT:    vmovaps %zmm0, (%rdi)
; X64-AVX512F-NEXT:    vzeroupper
; X64-AVX512F-NEXT:    retq
entry:
  %0 = load <8 x float>, ptr @src1, align 64
  %1 = shufflevector <8 x float> %0, <8 x float> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  store <16 x float> %1, ptr %a0, align 64
  ret void
}
