// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// SPDX-FileCopyrightText: Copyright Contributors to the Kokkos project

#ifndef KOKKOS_THREADS_SPINWAIT_HPP
#define KOKKOS_THREADS_SPINWAIT_HPP

#include <Threads/Kokkos_Threads_State.hpp>

#include <cstdint>
#include <atomic>

namespace Kokkos {
namespace Impl {

enum class WaitMode : int {
  ACTIVE  // Used for tight loops to keep threads active longest
  ,
  PASSIVE  // Used to quickly yield the thread to quite down the system
  ,
  ROOT  // Never sleep or yield the root thread
};

void host_thread_yield(const uint32_t i, const WaitMode mode);

void spinwait_while_equal(std::atomic<ThreadState> const& flag,
                          ThreadState const value);

}  // namespace Impl
}  // namespace Kokkos

#endif
