/*--------------------------------*-C-*---------------------------------*
 * File:	sbar.h
 *
 * ----------------------------------------------------------------------
 * Copyright 1995,1996
 * mj olesen <olesen@me.QueensU.CA> Queen's Univ at Kingston
 *
 * You can do what you like with this source code provided you don't make
 * money from it and you include an unaltered copy of this message
 * (including the copyright).  As usual, the author accepts no
 * responsibility for anything, nor does he guarantee anything whatsoever.
 *----------------------------------------------------------------------*/
#ifndef _SBAR_H
#define _SBAR_H
#include <ctype.h>

typedef struct {
   int beg, end;	/* beg/end of slider window within parent window */
   int top, bot;	/* top/bot of slider */
   int motion;		/* last motion: Up, Down, Motion */
   Window parent, win;
} sBar_t;
extern sBar_t	sBar;

#define sbar_isMotion()	(sBar.motion == 'm')
#define sbar_isUp()	(sBar.motion == 'U')
#define sbar_isDn()	(sBar.motion == 'D')
#define sbar_isUpDn()	isupper (sBar.motion)

#define sbar_setNone()		do { sBar.motion = 0; } while (0)
#define sbar_setMotion()	do { sBar.motion = 'm'; } while (0)
#define sbar_setUp()		do { sBar.motion = 'U'; } while (0)
#define sbar_setDn()		do { sBar.motion = 'D'; } while (0)

#ifdef XTERM_SCROLLBAR
# define SB_SHADOW	0
# define SB_WIDTH	12
#else
# define SB_SHADOW	2
# ifndef SB_WIDTH
#  define SB_WIDTH	14	/* width of scrollBar */
# endif
#endif	/* XTERM_SCROLLBAR */

#ifdef __cplusplus
extern "C" {
#endif
   extern void	sbar_init (void);
   extern int	sbar_show (int update);
#ifdef __cplusplus
}
#endif
#endif	/* whole file */
/*----------------------- end-of-file (C header) -----------------------*/
