#include "FvwmIconMan.h"
#include "readconfig.h"

extern WinData *find_win (WinManager *man, int box);


static int find_selected_manager (void)
{
  int i, index = -1;

  for (i = 0; i < globals.num_managers; i++) {
    if (globals.managers[i].current_box >= 0) {
      index = i;
      break;
    }
  }

  if (i == globals.num_managers) {
    ConsoleDebug ("No selected manager\n");
  }
  
  return index;
}

/* Returns NULL if none found */
static WinManager *get_manager (BuiltinArg *arg)
{
  ButtonType base;
  int offset, index;
  
  if (arg->type != ManagerArg) {
    ConsoleMessage ("Internal error in get_manager: 1\n");
    return NULL;
  }
  
  base = arg->value.button_value.base;
  offset = arg->value.button_value.offset;

  switch (base) {
  case NoButton:
    ConsoleMessage ("Internal error in get_manager: 2\n");
    return NULL;

  case SelectButton:
    index = find_selected_manager();
    break;

  case FocusButton:
    index = globals.focus_win->manager->index;
    break;

  case AbsoluteButton:
    index = 0;
    break;
  }

  index = (index + offset) % globals.num_managers;
  if (index < 0) 
    index += globals.num_managers;

  return &globals.managers[index];
}

/* Returns -1 if none found */
static int get_button (WinManager *man, BuiltinArg *arg)
{
  ButtonType base;
  int offset, index;
  
  if (arg->type != ButtonArg && arg->type != WindowArg) {
    ConsoleMessage ("Internal error in get_button: 1\n");
    return -1;
  }
  
  base = arg->value.button_value.base;
  offset = arg->value.button_value.offset;

  switch (base) {
  case NoButton:
    ConsoleMessage ("Internal error in get_manager: 2\n");
    return -1;

  case SelectButton:
    if (man->current_box >= 0) {
      index = man->current_box;
    }
    else {
      ConsoleDebug ("No selected window\n");
      return -1;
    }
    break;

  case FocusButton:
    if (man->focus_box >= 0) {
      index = man->focus_box;
    }
    else {
      ConsoleDebug ("No focused window\n");
      return -1;
    }
    break;

  case AbsoluteButton:
    index = 0;
    break;
  }

  index = (index + offset) % man->icon_list.n;
  if (index < 0)
    index += man->icon_list.n;

  return index;
}

/* Returns NULL if none */
static WinData *get_window (WinManager *man, BuiltinArg *arg)
{
  int index = get_button (man, arg);
  
  if (index == -1)
    return NULL;

  return find_win (man, index);
}

static WinData *get_window_from_args (BuiltinArg *args)
{
  WinManager *man;
  man = get_manager (args);
  if (man == NULL)
    return NULL;
  return get_window (man, args + 1);
} 

static int get_button_from_args (BuiltinArg *args)
{
  WinManager *man;
  man = get_manager (args);
  if (man == NULL)
    return -1;
  return get_button (man, args + 1);
} 

int builtin_selectbutton (int numargs, BuiltinArg *args)
{
  int button, index;
  WinManager *oldman, *man;

  ConsoleDebug ("selectbutton: ");
  print_args (numargs, args);

  man = get_manager (args);
  if (!man)
    return 0;

  button = get_button (man, args + 1);
  if (button == -1)
    return 0;

  index = find_selected_manager();
  if (index >= 0) {
    oldman = &globals.managers[index];
    if (oldman != man)
      move_highlight (oldman, -1);
  }
  move_highlight (man, button);
  
  return 1;
}

int builtin_sendcommand (int numargs, BuiltinArg *args)
{
  WinData *win;

  ConsoleDebug ("sendcommand: ");
  print_args (numargs, args);

  win = get_window_from_args (args);
  if (win == NULL)
    return 0;
  
  SendFvwmPipe (args[2].value.string_value, win->app_id);

  return 1;
}

int builtin_quit (int numargs, BuiltinArg *args)
{
  ConsoleDebug ("quit: ");
  print_args (numargs, args);
  ShutMeDown (0);
  return 1;
}

int builtin_warp (int numargs, BuiltinArg *args)
{
  WinManager *man;
  int button, x, y;

  man = get_manager (args);
  if (!man)
    return 0;

  button = get_button (man, args + 1);
  if (button == -1)
    return 0;

  x = man->win_width / 2;
  y = button * man->boxheight + man->boxheight / 2;

  XWarpPointer (theDisplay, None, man->theWindow, 0, 0, 0, 0, x, y);
  return 1;
}

int builtin_printdebug (int numargs, BuiltinArg *args)
{
  int i;

  for (i = 0; i < globals.num_managers; i++) {
    ConsoleDebug ("Manager %d\n---------\n");
    ConsoleDebug ("Keys:\n");
    print_bindings (globals.managers[i].bindings[KEYPRESS]);
    ConsoleDebug ("Mice:\n");
    print_bindings (globals.managers[i].bindings[MOUSE]);
    ConsoleDebug ("Select:\n");
    print_bindings (globals.managers[i].bindings[SELECT]);
    ConsoleDebug ("\n");
  }

  return 1;
}

int builtin_raisemanager (int numargs, BuiltinArg *args)
{
  int i;
  
  ConsoleDebug ("raising\n");

  for (i = 0; i < globals.num_managers; i++) {
    if (globals.managers[i].window_mapped)
      XRaiseWindow (theDisplay, globals.managers[i].theWindow);
  }

  XFlush (theDisplay);
  return 1;
}

int builtin_lowermanager (int numargs, BuiltinArg *args)
{
  int i;

  ConsoleDebug ("lowering\n");

  for (i = 0; i < globals.num_managers; i++) {
    if (globals.managers[i].window_mapped)
      XLowerWindow (theDisplay, globals.managers[i].theWindow);
  }

  XFlush (theDisplay);

  return 1;
}
