#include "config.h"

#include <stdio.h>
#include <stdarg.h>
#include <sys/types.h>
#include <fcntl.h>
#include <unistd.h>
#include <malloc.h>
#include <string.h>
#include <sys/stat.h>
#include <stdlib.h>
#include <errno.h>

#include "McApp.h"
#include "McGadget.h"
#include "McSlider.h"
#include "McText.h"
#include "McBitmap.h"
#include "McString.h"
#include "McSelector.h"
#include "McResource.h"
#include "McUtils.h"
#include "McAlloc.h"
#include "McChoice.h"
#include "McInfoRequest.h"

#include "version.h"
#include "xg3.h"
#include "filegui.h"
#include "print.h"
#include "files.h"

/**************************************************************************/

#define WIDTH  320
#define HEIGHT 110

/**************************************************************************/

static void dump_g3(FILE *fp) {
  if (fwrite(current_data, current_size, 1, fp)<=0)
    McError(app, "Can't print: %s\n", strerror(errno));
}

void print_g3(void) {
  if (!current_data || !current_size) {
    McError(app, "No data.\n");
  } else {
    do_print("Print Fax", dump_g3);
  }
}

/**************************************************************************/

void do_print(unsigned char *title, void (callback)(FILE *)) {
  unsigned char *cmd;
  FILE *fp;

  cmd=McGetResource(app, "g3PrintCommand");
  if (!cmd) {
    print_data(title, callback);
    return;
  }

  fp=popen(cmd, "w");
  if (!fp) {
    McError(app, "Cannot pipe into `%s'.\nReason: %s\n", cmd, strerror(errno));
    return;
  }
  (*callback)(fp);
  pclose(fp);
}

/**************************************************************************/

static void cancel_proc(McGadget *gadget);
static void print_proc(McGadget *gadget);
static void string_proc(McGadget *gadget);

void print_data(unsigned char *title, void (callback)(FILE *)) {
  McGadget *gad, *strgad;
  McWindow *mcw;
  unsigned char *printer;

  BeepAssert(old_request);

  /*
   * Create the window
   */
  mcw=McCreateSimpleWindow(app, title,
			   WIDTH, HEIGHT, WIDTH, HEIGHT, WIDTH>>1, HEIGHT-20,
			   NULL, MCAPP_DEFAULT_EVENT_HANDLER);

  MakeText(mcw, 0, 10, 0, "Print to which printer?");
  MakeText(mcw, 0, 25, 0, "(Must understand G3 files)");

  printer=getenv("PRINTER");
  if (!printer) printer=McGetResource(app, "printer");
  if (!printer) printer="";
  strgad=MakeString(mcw, 20, 50, WIDTH-40, 17, 0, printer, NULL, string_proc);
  strgad->customData=callback;

  gad=MakeButton(mcw, -12, -8, 75, 16, 0, "Cancel", cancel_proc);
  gad->topLeftGravity = SouthEastGravity;

  gad=MakeButton(mcw,  12, -8, 75, 16, 0, "Print", print_proc);
  gad->topLeftGravity = SouthWestGravity;
  gad->customData=strgad;

  /*
   * Display the window
   */
  McInitGadgets(mcw);
  XMapWindow(app->display, mcw->window);
  McSetFocus(strgad);
}

/**************************************************************************/

static void cancel_proc(McGadget *gadget) {
  gadget->mcw->flags|=MCW_CLOSEREQUEST;
}

static void print_proc(McGadget *gadget) {
  string_proc((McGadget *)gadget->customData);
}

static void string_proc(McGadget *gadget) {
  unsigned char *in = ((McString *)(gadget->specialInfo))->buf;
  void (*callback)(FILE *);
  unsigned char buf[256], *cmd, *swtch;
  FILE *fp;


  callback = (void (*)(FILE *))(gadget->customData);
  /*         ^^^^^^^^^^^^^^^^^^ Doesn't C look nice? */

  gadget->mcw->flags|=MCW_CLOSEREQUEST;

  cmd=McGetResource(app, "printCommand");
  if (!cmd) cmd = "lpr";

  swtch=McGetResource(app, "printSwitch");
  if (!swtch) swtch="-P";

  if (strlen(in)) {
    sprintf(buf, "%s %s%s", cmd, swtch, in);
  } else {
    strcpy(buf, cmd);
  }

#if 0
  printf("popen(\"%s\");\n", buf);
  return;
#endif

  fp=popen(buf, "w");
  if (!fp) {
    McError(app, "Cannot pipe into `%s'.\nReason: %s\n", buf, strerror(errno));
    return;
  }
  (*callback)(fp);
  pclose(fp);
}

/**************************************************************************/

