#ifndef _McViewText_h_
#define _McViewText_h_

typedef struct McViewLine {
  unsigned char *text;
  int len;
  short width, height;
} McViewLine;

typedef struct McViewText {
  McSpecialInfo specialInfo;
  McGadget *sliderhor, *sliderver;
  XFontStruct *font;
  unsigned int flags;
  unsigned char *text;
  McViewLine *lines;
  int linecnt, linemax;
  int maxwidth, maxheight;
  int firstrow, firstcol;
  struct {
    int rowstart, rowend, rowclick;
    int colstart, colend, colclick;
  } last;
  struct {
    int rowstart, rowend, rowclick;
    int colstart, colend, colclick;
  } now;
} McViewText;

extern McSpecialInfo *McCreateViewText(unsigned int flags, XFontStruct *font,
				       unsigned char *txt);
extern void McViewTextUpdate(McGadget *gadget,int busy,int all);
extern McGadget *MakeViewText(McWindow *mcw, int x, int y, int w, int h,
			      XFontStruct *font, char *text);
extern void McViewTextBindSliders(McGadget *timgad,
				  McGadget *sliderhor, McGadget *sliderver);
extern void McViewTextSetText(McGadget *gadget, unsigned char *text);

#endif /* _McViewText_h_ */
