#include <stdio.h>
#include <string.h>
#include <X11/Xatom.h>
#include "McApp.h"
#include "McGadget.h"
#include "McAlloc.h"
#include "McResource.h"
#include "McSelection.h"

/* How to make lead from gold... :) */
static Atom aurum(Display *display) {
  static Atom plumbum=0;
  if (!plumbum)
    plumbum=XInternAtom(display, "CLIPBOARD", False);
  return plumbum;
}

/**************************************************************************
 *
 * Tries to make gadget the selection owner
 *
 */
int McSetNewSelection(McGadget *gadget, unsigned char *new, int len) {
  McWindow *mcw=gadget->mcw;
  McApp *app=mcw->app;

  XSetSelectionOwner(app->display, XA_PRIMARY, mcw->window, CurrentTime);
  if (XGetSelectionOwner(app->display, XA_PRIMARY)!=mcw->window) {
    XBell(app->display, 0);
    return 0;
  }

  if (mcw->selection) {
    McFree(mcw->selection);
    mcw->selection=NULL;
    mcw->selectionOwner=NULL;
  }

  if (len>0) {
    mcw->selection=(unsigned char *)McAlloc(len+1);
    mcw->selectionOwner=gadget;
    strncpy(mcw->selection, new, len);
    XChangeProperty(app->display, DefaultRootWindow(app->display),
		    XA_CUT_BUFFER0, XA_STRING, 8,
		    PropModeReplace, mcw->selection, len);
  }
  return 1;
}

/*
 * Tells the current selection owner that we want the current selection
 */
void McQuerySelection(McGadget *gadget, Time time) {
  McWindow *mcw=gadget->mcw;
  McApp *app=mcw->app;
  if (XGetSelectionOwner(app->display,XA_PRIMARY) != None) {
    XConvertSelection(app->display, XA_PRIMARY, XA_STRING,
		      aurum(app->display), mcw->window, time);
  }
}

/*
 * We actually got the selection, so read it.
 *
 * Subtitle: Fun things to do with lead and gold...
 *
 * The returned string must be freed with XFree() !
 */
unsigned char *McReadSelection(McGadget *gadget, int max_wanted) {
  Atom plumbum;
  McWindow *mcw=gadget->mcw;
  McApp *app=mcw->app;
  int how;
  unsigned long len, bytes;
  unsigned char *data;

  XGetWindowProperty(app->display, mcw->window, aurum(app->display),
		     0, max_wanted>>2, False,
		     XA_STRING, &plumbum, &how, &len, &bytes, &data);
  if ((plumbum!=XA_STRING) || (how!=8)) {
    XBell(app->display, 0);
    if (data) XFree(data);
    return NULL;
  } else {
    return data;
  }
}

/*
 * Someone requests us to send him the current selection
 */
void McSendSelection(McWindow *mcw, XSelectionRequestEvent *event) {
  XSelectionEvent sel;

  sel.type=SelectionNotify;
  sel.send_event=True;
  sel.display=event->display;
  sel.requestor=event->requestor;
  sel.selection=event->selection;
  sel.target=event->target;
  sel.property=event->property;
  sel.time=event->time;
  if ((!mcw->selection) || (sel.selection!=XA_PRIMARY) ||
      (sel.target!=XA_STRING)) {
    XBell(mcw->app->display, 0);
    sel.property=None;
  } else {
    XChangeProperty(sel.display, sel.requestor,
		    sel.property, sel.target,
		    8, PropModeReplace, mcw->selection,
		    strlen(mcw->selection));
  }
  XSendEvent(sel.display, sel.requestor, True, 0,(XEvent *)&sel);
}

/*
 * We lost the selectionownership
 */
void McClearSelection(McWindow *mcw) {
  mcw->selectionOwner=NULL;
  if (mcw->selection) {
    McFree(mcw->selection);
    mcw->selection=NULL;
  }
}
