#ifndef lint
static char	sccsid[] = "@(#)$Header: xhdr.c,v 1.11 90/12/11 23:59:53 sob Exp $";
#endif

#include "common.h"

#ifdef XHDR

/* forward declarations */
void print_header();
#ifdef XOVER
int over_is_cheap();
int over_find();
void over_print_header();
#endif

/*
 * XHDR header [<messageid>|articlerange]
 *
 * header is a case-insensitive header field, minus any colons.
 *
 * articlerange is one of:
 *	an article number
 *	an article number followed by a dash to indicate all following
 *	an article number followed by a dash followed by another
 *		article number.
 * e.g.,
 * XHDR subject			retrieve subject of current article
 * XHDR subject 5589-6325	retrieve subject of arts 5589 to 6325
 * XHDR subject 5589-		retrieve subject of arts 5589 and up
 * XHDR subject 5589		retrieve subject of art 5589 only
 * XHDR subject <123@ucbvax>	retrieve subject of art <123@ucbvax>
 *
 * This command is an extension, and not included in RFC 977.
 */

void
xhdr(argc, argv)
	int		argc;
	char		*argv[];
{
	char		buf[MAXPATHLEN];
	register int	artptr;
	register int	artnum;
	register int	low, high;
	register FILE	*fp;
#ifdef XOVER
	int		over_candidate, hdr;
#endif

	if (argc < 2 || argc > 3) {
		printf("%d Usage: XHDR headerfield [artrange|<message-id>]\r\n",
			ERR_CMDSYN);
		(void) fflush(stdout);
		return;
	}

	if (!canread) {
		printf("%d You only have permission to transfer, sorry.\r\n",
			ERR_ACCESS);
		(void) fflush(stdout);
		return;
	}

	/* Handle message-id requests */

	if (argc == 3 && *argv[2] == '<') {	/* Message ID */
		fp = openartbyid(argv[2]);
		if (fp == NULL) {
			printf("%d No article by message-id %s, sorry.\r\n",
				ERR_NOART, argv[2]);
			(void) fflush(stdout);
			return;
		}
		printf("%d 0 %s header of article %s.\r\n",
			OK_HEAD, argv[1], argv[2]);
		print_header(fp, argv[1], argv[2]);
		(void) fclose(fp);

		putchar('.');
		putchar('\r');
		putchar('\n');
		(void) fflush(stdout);
		return;
	}

	/*
	 * It must be a range of articles, which means that we need
	 * to be in a newsgroup already.
	 */

	if (!ingroup) {
		printf("%d You are not currently in a newsgroup.\r\n",
			ERR_NCING);
		(void) fflush(stdout);
		return;
	}

	if (argc == 2) {
		if (art_ptr < 0 || art_ptr >= num_arts) {
			printf("%d No article is currently selected.\r\n",
				ERR_NOCRNT);
			(void) fflush(stdout);
			return;
		}
		high = low = art_array[art_ptr];
		artptr = art_ptr;
	} else {
		register char *cp = index(argv[2], '-');
		if (cp == NULL)
			low = high = atoi(argv[2]);
		else {
			*cp++ = '\0';
			low = atoi(argv[2]);
			high = atoi(cp);
			if (high < low)
				if (num_arts > 0)
					high = art_array[num_arts-1];
				else
					high = low;
		}
		artptr = 0;
	}

	printf("%d %s fields follow\r\n", OK_HEAD, argv[1]);

#ifdef XOVER
	if (over_is_cheap(low, high))
		over_candidate = ((hdr = over_header(argv[1])) > 0);
	else
		over_candidate = 0;
#endif
	for (;artptr<num_arts; artptr++) {
		if ((artnum = art_array[artptr]) < low)
			continue;
		if (artnum > high)
			break;

		(void) sprintf(buf, "%d", artnum);
#ifdef XOVER
		if (over_candidate) {
			extern int over_num;
			if (over_find(artnum)) {
				over_print_header(hdr, buf);
				continue;
			} else if (over_num == -1)
				over_candidate = 0;
		}
#endif
		fp = fopen(buf, "r");
		if (fp == NULL)
			continue;
		print_header(fp, argv[1], buf);
		(void) fclose(fp);
	}

	putchar('.');
	putchar('\r');
	putchar('\n');
	(void) fflush(stdout);
}


void
print_header(fp, header, artname)
	register FILE	*fp;
	register char	*header;
	register char	*artname;
{
	char		line[NNTP_STRLEN];
	register char	*cp, *cp2;

	while (fgets(line, sizeof line, fp) != NULL) {
		if (*line == '\n' || *line == '\0') {
			break;
		}
		if (!isspace(*line) && (cp = index(line, ':')) != NULL) {
			*cp = '\0';
			if (!strcasecmp(header, line)) {
				printf("%s ", artname);
				cp += 2;
				for (;;) {
					if ((cp2 = index(cp, '\n')) != NULL)
						*cp2 = '\0';
					printf("%s", cp);
					if (!fgets(line, sizeof line, fp))
					    break;
					cp = line;
					if (!isspace(*cp))
					    break;
					while (isspace(*++cp))
						;
					*--cp = ' ';
				}
				putchar('\r');
				putchar('\n');
				return;
			}
		}
	}
	printf("%s (none)\r\n", artname);
}

#else /* !XHDR */

/* Kludge to get around Greenhills C compiler */

xhdr_greenkluydge()
{
}

#endif
