/* AX.25 Utilities: Run a program, with input and output directed
 *	to a file descriptor.
 *
 * 
 * Bruce Perens, November 1994
 *
 * Copyright 1994 Bruce Perens.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 */
#include <stdlib.h>
#include <unistd.h>
#include <signal.h>

int
execute(
 const char *	file
,char * const *	argv
,char * const *	envp
,int		ioFile)
{
	int	pid;

	signal(SIGCLD, SIG_IGN);	/* No zombies */

	pid = fork();

	if ( pid < 0 )
		return -1;
	else if ( pid == 0 ) {
		/* In the child process */

		int	max = (int)sysconf(_SC_OPEN_MAX);
		int	fd;
		int	n;

		for ( fd = 0; fd < max; fd++ ) {
			if ( fd != ioFile )
				close(fd);
		}
		/*
		 * If the IO file isn't 0, 1, or 2, I'm starting a new
		 * session on some other device.
		 */
		if ( ioFile > 2 )
			setsid();

		for ( fd = 0; fd <= 2; fd++ ) {
			if ( fd != ioFile && dup2(ioFile, fd) != fd )
				_exit(-1);
		}

		if ( ioFile > 2 )
			close(ioFile);

		/*
		 * Try to give the process as pristine an environment
		 * as possible.
		 */
		for ( n = 0; n < NSIG; n++ )
			signal(n, SIG_DFL);

		/*
		 * If I started a new session above, set the tty process
		 * group to match it.
		 */
		if ( ioFile > 2 )
			tcsetpgrp(0, getpgrp());

		execve(file, argv, envp);
		_exit(-1);
	}
	return pid;
}
