#ifndef ZOOM_H
#define ZOOM_H

#include "config.h"
#include "formulas.h"

struct realloc {
    number_t possition;
    int plus;
    int recalculate;
    int symto;
    int symref;
    int dirty;
    char dummy[((32-sizeof(int)*5-((int)(sizeof(number_t)+sizeof(int)-1)/sizeof(int))*sizeof(int))<0?0:
     (32-sizeof(int)*5-((int)(sizeof(number_t)+sizeof(int)-1)/sizeof(int))*sizeof(int)))];	/*make it 32 byte aligned*/
};
typedef struct realloc realloc_t;

typedef struct {
    number_t pre, pim;
    number_t *xpos, *ypos;
    void (*switch_function) (void);
    void (*wait_function) (void);
    char *vbuff, *back;
    realloc_t *reallocx, *reallocy;
    struct formula *currentformula;
    int pass, pos, max;
    int maxiter, coloringmode, incoloringmode;
    int mandelbrot;
    int fullscreen;
    int plane;
    int dirty;
    int num_colors;
    int width, height;
    int interrupt;
    unsigned char colors[MAXCOLORS];
    unsigned char cmap[3][MAXCOLORS];
    vinfo s;
} zoom_context;

void do_fractal(zoom_context *);
void set_formula(zoom_context *, CONST int);
void resize_to(zoom_context *, CONST int, CONST int, char *, char *);
void set_view(zoom_context *, CONST vinfo *);
void free_context(zoom_context *);
void init_tables(zoom_context *);
zoom_context *make_context(CONST int, CONST int, CONST int, CONST int, void (*)(), void (*)(), char *, char *);

#endif				/* ZOOM_H */
