#ifdef _plan9_
#include <u.h>
#include <stdio.h>
#include <libc.h>
#else
#include <string.h>
#include <stdio.h>
#endif
#include "ui.h"
#include "param.h"
/*extern struct params *global_params; */
extern int testik;
extern struct params global_params[];
extern struct ui_driver *drivers[];
extern int ndrivers;

int params_parser(int argc, char **argv)
{
    int i, p = 0, d;
    struct params *par = NULL;
    int error = 0;
    for (i = 1; i < argc && !error; i++) {
	for (d = -1; d < ndrivers; d++) {
	    if (d == -1)
		par = global_params;
	    else
		par = drivers[d]->params;
	    for (p = 0; par[p].name != NULL && !error; p++) {
		if (!strcmp(par[p].name, argv[i])) {
		    switch (par[p].type) {
		    case P_SWITCH:
			*((int *) par[p].value) = 1;
			break;
		    case P_NUMBER:
			{
			    int n;
			    if (i == argc - 1) {
				fprintf(stderr, "parameter %s requires numeric value\n", argv[i]);
				error = 1;
				break;
			    }
			    if (sscanf(argv[i + 1], "%i", &n) != 1) {
				fprintf(stderr, "parameter for %s is not number \n", argv[i]);
				error = 1;
				break;
			    }
			    *((int *) par[p].value) = n;
			    i++;
			}
			break;
		    case P_FLOAT:
			{
			    float n;
			    if (i == argc - 1) {
				fprintf(stderr, "parameter %s requires floating point numeric value\n", argv[i]);
				error = 1;
				break;
			    }
			    if (sscanf(argv[i + 1], "%f", &n) != 1) {
				fprintf(stderr, "parameter for %s is not floating point number \n", argv[i]);
				error = 1;
				break;
			    }
			    *((float *) par[p].value) = n;
			    i++;
			}
			break;
		    case P_STRING:
			{
			    if (i == argc - 1) {
				fprintf(stderr, "parameter %s requires string value\n", argv[i]);
				error = 1;
				break;
			    }
			    i++;
			    *((char **) par[p].value) = *(argv + i);
			}
		    }
		    break;
		}
	    }
	    if (par[p].name != NULL)
		break;
	}
	if (d == ndrivers) {
	    fprintf(stderr, "option %s is unknown\n", argv[i]);
	    error = 1;
	    break;
	}
    }
    if (error) {
	const char *name[] =
	{
	    "",
	    "number",
	    "string",
	    "f.point"
	};
	printf("                 XaoS help text\n");
	printf(" (This help is genereated automagically. I am sorry for all inconvencies)\n");
	printf("option string  value   description\n");
	for (d = -1; d < ndrivers; d++) {
	    if (d == -1)
		par = global_params;
	    else {
		par = drivers[d]->params;
		printf("\n%s driver options:\n\n", drivers[d]->name);
	    }
	    for (p = 0; par[p].name != NULL; p++) {
		printf(" %-11s   %-8s%s\n", par[p].name, name[par[p].type], par[p].help);
	    }
	    if (p == 0)
		printf(" No options avaiable for now\n");
	}
	exit(-1);

    }
    return (1);
}
