/*
 *		     PLEASE DO NOT EDIT THIS FILE
 *		see documentation for more information
 *
 *
 *                  System Independent Trojka Core 
 *                Copyright (c) 1989-1996 Maarten Los
 *                             --------
 */

#ifndef _trojka_core_h_
#define _trojka_core_h_

/*
 *	constants
 */
#define tc_trojka	3	/* the magic number */
#define tc_trojkabonus	3333	/* the magic bonus */
#define tc_spiderbonus  6666	/* the spider bonus */
#define tc_bigspiderbonus 9999	/* the big spider bonus */
#define tc_bottombonus	999	/* bonus if you hit the bottom */


#define tc_min_speed	1	/* minimum speed */
#define tc_max_speed	9	/* maximum speed */
#define tc_speed_switch	100	/* # of blocks at which speed is increased */
#define	tc_pm_top	20	/* these constants are for the matrix */	
#define tc_pm_bottom	 1	/* see tr_core.doc */
#define tc_v_xsize	 5
#define tc_v_ysize	22
#define tc_virt_middle	 2

#define tc_clear	 0	/* clear cell in the playing field */
#define tc_tagged	-1	/* cell is tagged for wiping */

#define tc_blocks	5	/* number of different blocks */

#define tc_layouts	42	/* number of different layouts */
#define tc_layout_mask	0x03	/* for layout magic */
	/*
	 *	return, command and parameter values
	 */

#define		tc_c_init	1
#define		tc_c_blockdown	2
#define		tc_c_blockleft	3
#define		tc_c_blockright	4
#define		tc_c_dropblock	5
#define		tc_c_speedup	6
#define		tc_c_setspeed	7
#define 	tc_c_drawfield	8
#define		tc_c_setwizard	9

#define		tc_i_touchdown	1
#define		tc_i_dropblock	2
#define		tc_i_force	3

#define		tc_res_normal		1
#define		tc_res_gameover		2
#define		tc_res_touchdown	3



/*
 *	types
 */
typedef char		tt_char;
typedef char		tt_bool;
typedef int		tt_int;
typedef unsigned long	tt_long;
typedef int		tt_layout[5];	/* for wizard patterns */
typedef struct _tt_command {
	tt_int	command;
	tt_long param1;
	tt_long param2;
	tt_long reserved_1;
	tt_long reserved_2;
} tt_command;		/* command for the trojka api */




/************************************************************************
 * This part provides the API between the trojka core and the
 * implementation
 ************************************************************************/

/*
 *	the standard call to the trojka api
 */
extern int trojka_api(tt_command*);


/*
 *	these callback functions must be provided by the programmer and
 *	are called from within the trojka core (tr_core.c)
 */
extern void trojka_make_block_callback(tt_int, tt_int, tt_int);
extern void trojka_wipe_block_callback(tt_int, tt_int);
extern void trojka_explode_callback(tt_int, tt_int);
extern void trojka_trojka_callback(tt_long);
extern void trojka_speedup_callback(tt_int);
extern void trojka_spider_callback(tt_long);
extern void trojka_bottom_callback(tt_long);


/*
 *	these are read only!
 */
extern tt_int	tv_ticks;

extern tt_long	tv_score;
extern tt_bool	tv_score_reset;

extern tt_long	tv_blocks;
extern tt_bool	tv_blocks_reset;

extern tt_long	tv_trojkas;
extern tt_bool	tv_trojkas_reset;

extern tt_long	tv_wipes;
extern tt_long 	tv_wipes_reset;

extern tt_long	tv_block_count[tc_blocks];
extern tt_char	tv_field[tc_v_xsize][tc_v_ysize];

extern tt_int	tv_speed;
extern tt_bool	tv_is_wizard;

#endif /* _trojka_core_h_ */
