
/* Some simple graphics routines.... */

DrawSlopedLine(int x1, int y1, int x2, int y2)
{
	int dx, dy;
	int steps;
	float x, y, xinc, yinc;

	dx = (x2-x1);	
	dy = (y2-y1);	
	if ( abs(dx) > abs(dy) )
		steps = abs(dx);
	else
		steps = abs(dy);
	xinc = dx/step;
	x = (float)x1;
	yinc = dy/step;
	y = (float)y1;

	SetPixel(Round(x), Round(y), 1);
	while ( steps-- ) {
		x += xinc;
		y += yinc;
		SetPixel(Round(x), Round(y), 1);
	}
}
	

PlotCirclePoints(int xc, int yc, int x, int y)
{
	SetPixel(xc+x, yc+y, 1);
	SetPixel(xc-x, yc+y, 1);
	SetPixel(xc+x, yc-y, 1);
	SetPixel(xc-x, yc-y, 1);
	SetPixel(xc+y, yc+x, 1);
	SetPixel(xc-y, yc+x, 1);
	SetPixel(xc+y, yc-x, 1);
	SetPixel(xc-y, yc-x, 1);
}

DrawCircle(int xc, int yc, int r)
{
	int p, x, y;

	x = 0;
	y = r;
	p = (1-r);

	PlotCirclePoints(xc, yc, x, y);
	while ( x < y ) {
		if ( p < 0 )
			p = (p + 2 * ++x + 1);
		else
			p = (p + 2 * ((++x)-(--y)) + 1);
		PlotCirclePoints(xc, yc, x, y);
	}
}
			
