#include "wily.h"

static Bitmap	*_dkgrey;

struct Scroll {
	Rectangle	r;
	Bitmap	*b;
	ulong	thumb, extent, max;
};

static Rectangle	getthumb(Scroll *, ulong , ulong , ulong );

/* Initialize bitmaps for scrollbars.  Called once, on system entry.
 */
void
scroll_init(void)
{
	int	x,y;

	_dkgrey = balloc(Rect(0, 0, INSET, INSET), 0);
	bitblt(_dkgrey, _dkgrey->r.min, _dkgrey, _dkgrey->r, F);
	for (x = 0; x < INSET; x += 2)
		for (y = x/2; y < INSET; y += 2)
			point(_dkgrey, Pt(x, y), 0, Zero);
}

void
scroll_setrects(Scroll*s, Bitmap *b, Rectangle r)
{
	if(!s)
		return;
	s->r = r;
	s->b = b;
	s->thumb = s->extent = s->max = 0;
	if(b) {
		bitblt(b, r.min, b, r, Zero);
		border(b, r, 1, F);
	}
	assert(Dx(s->r)<=SCROLLWIDTH);
}

Scroll *
scroll_alloc(Bitmap *b, Rectangle r)
{
	Scroll	*s;

	s = NEW(Scroll);
	scroll_setrects(s,b,r);
	return s;
}

void
scroll_set(Scroll *s, ulong thumb, ulong extent, ulong max)
{
	Rectangle	q, oldr, newr, above, below;

	oldr = getthumb(s, s->extent, s->max, s->thumb);
	above = below = s->r;
	above.max.y = oldr.min.y;
	below.min.y = oldr.max.y;
	
	newr = getthumb(s, extent, max, thumb);

	/* Sections that before were NOT in the thumb, but now are */
	q = newr;
	if (rectclip(&q, above))
		bitblt(s->b, q.min, s->b, q, Zero);
	q = newr;
	if (rectclip(&q, below))
		bitblt(s->b, q.min, s->b, q, Zero);

	above = below = s->r;
	above.max.y = newr.min.y;
	below.min.y = newr.max.y;

	/* Sections that before WERE in the thumb, but now are NOT */
	q = oldr;
	if (rectclip(&q, above))
		texture(s->b, q, _dkgrey, S);
	q = oldr;
	if (rectclip(&q, below))
		texture(s->b, q, _dkgrey, S);
	s->thumb = thumb;
	s->extent = extent;
	s->max = max;
}

static Rectangle
getthumb(Scroll *s, ulong extent, ulong max, ulong thumb)
{
	Rectangle	r;

	r = inset(s->r, 1);
	assert (Dx(s->r)<= SCROLLWIDTH);

	if (extent < max)
	{
		r.min.y += (Dy(s->r)*thumb)/max;
		r.max.y = r.min.y + MAX(2, (Dy(s->r)*extent)/max);
	}
	return r;
}

