#include "wily.h"
#include "text.h"

/****************************************************
	Wrappers to make a Text look like a Sam buffer
****************************************************/

/* Prepare to start reading runes backwards from 'p' */
int
Tbgetcset(Text *t, ulong p)
{
	assert (p>=0 && p <= t->length);

	t->ngetc= Tchars(t, t->getcbuf, p<NGETC? 0 : p-NGETC, p);
	assert(t->ngetc>=0);
	t->getcp=p;
	t->getci=t->ngetc;
	return t->ngetc;
}

/* Grab a bunch of runes from  'p' */
int
Tgetcload(Text *t, ulong p)
{
	if(Tgetcset(t, p)){
		--t->ngetc;
		t->getcp++;
		return t->getcbuf[t->getci++];
	}
	return -1;
}

int
Tbgetcload(Text *t, ulong p)
{
	if(Tbgetcset(t, p)){
		--t->getcp;
		return t->getcbuf[--t->getci];
	}
	return -1;
}

int
Tgetcset(Text *t, ulong p)
{
	assert (p>=0 && p <= t->length);

	t->ngetc= Tchars(t, t->getcbuf, p, p+NGETC);
	assert(t->ngetc>=0);
	t->getcp=p;
	t->getci=0;
	return t->ngetc;
}

long
Tchars(Text *t, Rune *r, ulong p0, ulong p1)
{
	if (p1 > t->length)
		p1 = t->length;
	assert (p1 >= p0);

	text_copy(t, range(p0,p1), r);
	return p1 - p0;
}

