/**
 *
 * $Id: ToggleBG.c,v 1.23 1996/04/22 22:56:05 miers Exp $
 *
 * Copyright (C) 1995 Free Software Foundation, Inc.
 *
 * This file is part of the GNU LessTif Library.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **/

static char rcsid[] = "$Id: ToggleBG.c,v 1.23 1996/04/22 22:56:05 miers Exp $";

#include <LTconfig.h>
#include <Xm/XmP.h>
#include <Xm/XmI.h>
#include <Xm/DebugUtil.h>
#include <Xm/ToggleBGP.h>
#include <Xm/CascadeB.h>
#include <Xm/CascadeBG.h>
#include <Xm/RowColumnP.h>
#include <Xm/MenuShell.h>
#include <Xm/MenuUtilP.h>
#include <Xm/CacheP.h>
#include <stdio.h>
#include <X11/Xfuncs.h>

/* Forward Declarations */

static void class_initialize();
static void class_part_initialize(WidgetClass class);
static void initialize(Widget request, Widget new, ArgList args, Cardinal *num_args);
static void destroy(Widget w);
static void expose(Widget w, XEvent *event, Region region);
static Boolean set_values(Widget current, Widget request, Widget new, ArgList args, Cardinal *num_args);
static void get_values_hook(Widget w, ArgList args, Cardinal *num_args);

static void input_dispatch(Widget gadget, XEvent *event, Mask event_mask);

static void secondary_object_create(Widget request, Widget new, ArgList args, Cardinal *num_args);
static void initialize_prehook(Widget request, Widget new, ArgList args, Cardinal *num_args);
static void initialize_posthook(Widget request, Widget new, ArgList args, Cardinal *num_args);
static Boolean set_values_prehook(Widget old, Widget request, Widget new, ArgList args, Cardinal *num_args);
static Boolean set_values_posthook(Widget old, Widget request, Widget new, ArgList args, Cardinal *num_args);
static void get_values_prehook(Widget new, ArgList args, Cardinal *num_args);
static void get_values_posthook(Widget new, ArgList args, Cardinal *num_args);
static Cardinal get_sec_res_data(WidgetClass wc, XmSecondaryResourceData **data);

/*
 * resources
 */
#define Offset(field) XtOffsetOf(XmToggleButtonGCacheObjRec, toggle_cache.field)
static XtResource cache_resources[] = {
    {
	XmNindicatorSize, XmCIndicatorSize, XmRVerticalDimension,
	sizeof(Dimension), Offset(indicator_dim),
	XmRImmediate,(XtPointer) XmINVALID_DIMENSION
    },
    {
	XmNindicatorType, XmCIndicatorType, XmRIndicatorType,
	sizeof(unsigned char), Offset(ind_type),
	XmRImmediate, (XtPointer)((unsigned char)XmUNSPECIFIED)
    },
    {
	XmNvisibleWhenOff, XmCVisibleWhenOff, XmRBoolean,
	sizeof(Boolean), Offset(visible),
	XmRImmediate,(XtPointer)85 /* if anybody knows why, I'd like to know */
    },
    {
	XmNspacing, XmCSpacing, XmRHorizontalDimension,
	sizeof(Dimension), Offset(spacing),
	XmRImmediate, (XtPointer)4
    },
    {
	XmNselectPixmap, XmCSelectPixmap, XmRGadgetPixmap,
	sizeof(Pixmap), Offset(on_pixmap),
	XmRImmediate, (XtPointer)XmUNSPECIFIED_PIXMAP
    },
    {
	XmNselectInsensitivePixmap, XmCSelectInsensitivePixmap, XmRGadgetPixmap,
	sizeof(Pixmap), Offset(insen_pixmap),
	XmRImmediate, (XtPointer)XmUNSPECIFIED_PIXMAP
    },
    {
	XmNindicatorOn, XmCIndicatorOn, XmRBoolean,
	sizeof(Boolean), Offset(ind_on),
	XmRImmediate,(XtPointer)True
    },
    {
	XmNfillOnSelect, XmCFillOnSelect, XmRBoolean,
	sizeof(Boolean), Offset(fill_on_select),
	XmRImmediate, (XtPointer)85
    },
    {
	XmNselectColor, XmCSelectColor, XmRPixel,
	sizeof(Pixel), Offset(select_color),
	XmRCallProc, (XtPointer)_XmSelectColorDefault
    }
};

static XmSyntheticResource cache_syn_resources[] = {
    {
	XmNspacing,
	sizeof(Dimension), Offset(spacing),
	_XmFromHorizontalPixels, _XmToHorizontalPixels
    },
    {
	XmNindicatorSize,
	sizeof(Dimension), Offset(spacing),
	_XmFromVerticalPixels, _XmToVerticalPixels
    }
};

XmToggleButtonGCacheObjClassRec xmToggleButtonGCacheObjClassRec = {
    /* Object class part */
    {
	/* superclass            */ (WidgetClass) &xmLabelGCacheObjClassRec,
        /* class_name            */ "XmToggleButtonGCacheObjClass",
	/* widget_size           */ sizeof(XmToggleButtonGCacheObjRec),
	/* class_initialize      */ NULL,
	/* class_part_initialize */ NULL,
	/* class_inited          */ FALSE,
	/* initialize            */ NULL,
	/* initialize_hook       */ NULL,
	/* realize               */ NULL,
	/* actions               */ NULL,
	/* num_actions           */ 0,
	/* resources             */ cache_resources,
	/* num_resources         */ XtNumber(cache_resources),
	/* xrm_class             */ NULLQUARK,
	/* compress_motion       */ 0,
	/* compress_exposure     */ 0,
	/* compress_enterleave   */ 0,
	/* visible_interest      */ 0,
	/* destroy               */ NULL,
	/* resize                */ NULL,
	/* expose                */ NULL,
	/* set_values            */ NULL,
	/* set_values_hook       */ NULL,
	/* set_values_almost     */ NULL,
	/* get_values_hook       */ NULL,
	/* accept_focus          */ NULL,
	/* version               */ XtVersion,
	/* callback offsets      */ NULL,
	/* tm_table              */ NULL,
	/* query_geometry        */ NULL,
        /* display_accelerator   */ NULL,
	/* extension             */ NULL
    },
    /* XmExtObject part */
    {
        /* syn_resources      */ cache_syn_resources,
        /* num_syn_resources  */ XtNumber(cache_syn_resources),
        /* extension          */ NULL
    },
    /* LabelGCacheObj part */
    {
	/* foo                */ 0
    },
    /* ToggleButtonGCacheObj part */
    {
	/* foo                */ 0
    }
};

#undef Offset
#define Offset(field) XtOffsetOf(XmToggleButtonGadgetRec, toggle.field)

/* Resources for the togglebutton class */
static XtResource resources[] = {
    {
	XmNset, XmCSet, XmRBoolean,
	sizeof(Boolean), Offset(set),
	XmRImmediate,(XtPointer)False
    },
    {
	XmNvalueChangedCallback, XmCValueChangedCallback, XmRCallback,
	sizeof(XtCallbackList), Offset(value_changed_CB),
	XmRPointer, (XtPointer)NULL
    },
    {
	XmNarmCallback, XmCArmCallback, XmRCallback,
	sizeof(XtCallbackList), Offset(arm_CB),
	XmRPointer, (XtPointer)NULL
    },
    {
	XmNdisarmCallback, XmCDisarmCallback, XmRCallback,
	sizeof(XtCallbackList), Offset(disarm_CB),
	XmRPointer, (XtPointer)NULL
    },
    {
	XmNtraversalOn, XmCTraversalOn, XmRBoolean,
	sizeof(Boolean), XtOffsetOf(XmToggleButtonGadgetRec, gadget.traversal_on),
	XmRImmediate, (XtPointer)True
    },
    {
	XmNhighlightThickness, XmCHighlightThickness, XmRHorizontalDimension,
	sizeof(Dimension), XtOffsetOf(XmToggleButtonGadgetRec,gadget.highlight_thickness),
	XmRImmediate, (XtPointer)2
    }
};

static XmBaseClassExtRec _XmToggleBGRectClassExtRec = {
    /* next_extension            */ NULL,
    /* record_type               */ NULLQUARK,                             
    /* version                   */ XmBaseClassExtVersion,
    /* size                      */ sizeof(XmBaseClassExtRec),
    /* initialize_prehook        */ initialize_prehook,
    /* set_values_prehook        */ set_values_prehook,
    /* initialize_posthook       */ initialize_posthook,
    /* set_values_posthook       */ set_values_posthook,
    /* secondary_object_class    */ (XtPointer)&xmToggleButtonGCacheObjClassRec,
    /* secondary_object_create   */ secondary_object_create,
    /* get_secondary_resources   */ get_sec_res_data,
    /* fast_subclass             */ { 0 },
    /* get_values_prehook        */ get_values_prehook,
    /* get_values_posthook       */ get_values_posthook,
    /* class_part_init_prehook   */ NULL,
    /* class_part_init_posthook  */ NULL,
    /* ext_resources             */ NULL,
    /* compiled_ext_resources    */ NULL,
    /* num_ext_resources         */ 0,
    /* use_sub_resources         */ FALSE,
    /* widget_navigable          */ XmInheritWidgetNavigable,
    /* focus_change              */ XmInheritFocusChange,
    /* wrapper_data              */ NULL
};

static XmCacheClassPart cache_part = {
    /* cache head part */
    {
	/* next         */ NULL,
	/* prev         */ NULL,
	/* ref_count    */ 0
    },
    _XmCacheCopy,
    _XmCacheDelete,
    _XmToggleBCacheCompare
};

static XmGadgetClassExtRec _XmToggleBGadgetClassExtRec = {
    /* next_extension            */ NULL,
    /* record_type               */ NULLQUARK,
    /* version                   */ XmGadgetClassExtVersion,
    /* size                      */ sizeof(XmGadgetClassExtRec),
    /* widget_baseline_proc      */ NULL, /* FIXME */
    /* display_rect_proc         */ NULL, /* FIXME */
};

XmToggleButtonGadgetClassRec xmToggleButtonGadgetClassRec = {
    /* RectObj class part */
    {
	/* superclass            */ (WidgetClass) &xmLabelGadgetClassRec,
	/* class_name            */ "XmToggleButtonGadget",
	/* widget_size           */ sizeof(XmToggleButtonGadgetRec),
	/* class_initialize      */ class_initialize,
	/* class_part_initialize */ class_part_initialize,
	/* class_inited          */ FALSE,
	/* initialize            */ initialize,
	/* initialize_hook       */ NULL,
	/* realize               */ NULL,
	/* actions               */ NULL,
	/* num_actions           */ 0,
	/* resources             */ resources,
	/* num_resources         */ XtNumber(resources),
	/* xrm_class             */ NULLQUARK,
	/* compress_motion       */ FALSE,
	/* compress_exposure     */ XtExposeNoCompress,
	/* compress_enterleave   */ FALSE,
 	/* visible_interest      */ FALSE,
	/* destroy               */ destroy,
	/* resize                */ NULL,
	/* expose                */ expose,
	/* set_values            */ set_values,
	/* set_values_hook       */ NULL,
	/* set_values_almost     */ XtInheritSetValuesAlmost,
	/* get_values_hook       */ get_values_hook,
	/* accept_focus          */ NULL,
	/* version               */ XtVersion,
	/* callback offsets      */ NULL,
	/* tm_table              */ NULL,
	/* query_geometry        */ XtInheritQueryGeometry,
	/* display_accelerator   */ NULL,
	/* extension             */ (XtPointer)&_XmToggleBGRectClassExtRec
    },
    /* XmGadget part */
    {
	/* border_highlight   */ XmInheritBorderHighlight, 
	/* border_unhighlight */ XmInheritBorderUnhighlight, /* fix me */
	/* arm_and_activate   */ NULL, /* fix me */
	/* input_dispatch     */ input_dispatch, /* fix me */
	/* visual_change      */ NULL, /* fix me */
	/* syn_resources      */ NULL,
	/* num_syn_resources  */ 0,
	/* cache_part         */ &cache_part,
	/* extension          */ (XtPointer)&_XmToggleBGadgetClassExtRec
    },
    /* XmLabelGadget part */
    {
        /* setOverrideCallback */ NULL, /* fix me */
        /* menuProcs           */ NULL, /* fix me */
	/* extension           */ NULL
    },
    /* XmToggleButtonGadget part */
    {
	/* extension */ NULL
    },
};

WidgetClass xmToggleButtonGadgetClass = (WidgetClass)&xmToggleButtonGadgetClassRec;

/* 
 *  Some #defines to make the code below more readable
 */

#define IN_MENU(w) (XmIsRowColumn(XtParent(w)) \
                    && (RC_Type(XtParent(w)) == XmMENU_POPUP \
                          || (RC_Type(XtParent(w)) == XmMENU_PULLDOWN)))
#define IN_POPUP(w) (XmIsRowColumn(XtParent(w)) \
                    && ((XmRowColumnWidget)XtParent(w))->row_column.row_column_type == XmMENU_POPUP)

/******************************* CACHE PART *********************************/
static void
secondary_object_create(Widget request,
	   Widget new,
	   ArgList args,
	   Cardinal *num_args)
{
    XmBaseClassExt *bce;
    XtPointer nsec, rsec;
    XmWidgetExtData ed;
    int size;

    XdbDebug(__FILE__, new, "ToggleButtonGCacheRec %s being initialized.\n",
	     XtName(new));

    bce = _XmGetBaseClassExtPtr(XtClass(new), XmQmotif);

    size = (*bce)->secondaryObjectClass->core_class.widget_size;
    nsec = _XmExtObjAlloc(size);
    rsec = _XmExtObjAlloc(size);

    ((XmExtRec *)nsec)->object.self = (Widget)nsec;
    ((XmExtRec *)nsec)->object.widget_class = (*bce)->secondaryObjectClass;
    ((XmExtRec *)nsec)->object.parent = XtParent(new);
    ((XmExtRec *)nsec)->object.xrm_name = new->core.xrm_name;
    ((XmExtRec *)nsec)->object.being_destroyed = False;
    ((XmExtRec *)nsec)->object.destroy_callbacks = NULL;
    ((XmExtRec *)nsec)->object.constraints = NULL;

    ExtObj_LogicalParent(nsec) = new;
    ExtObj_ExtensionType(nsec) = XmCACHE_EXTENSION;

    XtGetSubresources(new, nsec, NULL, NULL,
                      (*bce)->secondaryObjectClass->core_class.resources,
                      (*bce)->secondaryObjectClass->core_class.num_resources,
                      args, *num_args);

    ed = (XmWidgetExtData)XtMalloc(sizeof(XmWidgetExtDataRec));
    ed->widget = (Widget)nsec;
    ed->reqWidget = (Widget)rsec;

    bcopy(nsec, rsec, size);
    ((XmExtRec *)rsec)->object.self = (Widget)rsec;

    _XmPushWidgetExtData(new, ed, XmCACHE_EXTENSION);

    LabG_Cache(new) = &(((XmLabelGCacheObject)nsec)->label_cache);
    LabG_Cache(request) = &(((XmLabelGCacheObject)rsec)->label_cache);

    TBG_Cache(new) = &(((XmToggleButtonGCacheObject)nsec)->toggle_cache);
    TBG_Cache(request) = &(((XmToggleButtonGCacheObject)rsec)->toggle_cache);
}

int
_XmToggleBCacheCompare(XtPointer A, XtPointer B)
{
    return !memcmp(((XmToggleButtonGCacheObjPart *)A),
		   ((XmToggleButtonGCacheObjPart *)B),
		   sizeof(XmToggleButtonGCacheObjPart));
}

/******************************* CACHE PART *********************************/
static void
class_initialize()
{
    XtResourceList combined, labels;
    int ncom; 
    Cardinal nlabels;

    /* don't let the nulls fool you.  look at the header file -- the arg
     * isn't used. */
    ClassCacheHead(TBG_ClassCachePart(NULL)).prev =
	&ClassCacheHead(TBG_ClassCachePart(NULL));
    ClassCacheHead(TBG_ClassCachePart(NULL)).next =
	&ClassCacheHead(TBG_ClassCachePart(NULL));

    _XmToggleBGRectClassExtRec.record_type = XmQmotif;

    /*
     * Label subclasses (ToggleBG, PushBG, CascadeBG) have a problem.  Since
     * we do all the subpart manipulation in the pre- and post- hooks, and
     * since those hooks aren't chained, we have to either make multiple
     * calls to XtGetSubresources/Xt[Get|Set]Subvalues, or merge the resource
     * lists.  Since I just wrote _XmTransformSubresources, seems like a
     * waste not to use it.
     */
    ncom = XtNumber(cache_resources) +
           xmLabelGCacheObjClassRec.object_class.num_resources;

    _XmTransformSubResources(xmLabelGCacheObjClassRec.object_class.resources,
                             xmLabelGCacheObjClassRec.object_class.num_resources,
                             &labels, &nlabels);

    combined = (XtResourceList)XtMalloc(sizeof(XtResource) * ncom);
    bcopy(labels, combined, nlabels * sizeof(XtResource));
    bcopy(cache_resources,
	  &combined[nlabels],
	  XtNumber(cache_resources) * sizeof(XtResource));
    XtFree((char *)labels);

    xmToggleButtonGCacheObjClassRec.object_class.resources = combined;
    xmToggleButtonGCacheObjClassRec.object_class.num_resources = ncom;
}

static void
class_part_initialize(WidgetClass widget_class)
{
    _XmFastSubclassInit(widget_class, XmTOGGLE_BUTTON_GADGET_BIT);
}

static void
initialize_prehook(Widget request,
           Widget new,
           ArgList args,
           Cardinal *num_args)
{
    XdbDebug(__FILE__, new, "ToggleBG InitializePrehook\n");
}

static void
initialize_posthook(Widget request,
           Widget new,
           ArgList args,
           Cardinal *num_args)
{
    XmWidgetExtData ext;

    XdbDebug(__FILE__, new, "ToggleBG InitializePosthook\n");

    /* don't let the null fool you */
    LabG_Cache(new) = _XmCachePart(LabG_ClassCachePart(NULL),
                                   (XtPointer)LabG_Cache(new),
                                   sizeof(XmLabelGCacheObjPart));
    TBG_Cache(new) = _XmCachePart(TBG_ClassCachePart(NULL),
                                  (XtPointer)TBG_Cache(new),
                                  sizeof(XmToggleButtonGCacheObjPart));

    _XmPopWidgetExtData(new, &ext, XmCACHE_EXTENSION);
    _XmExtObjFree((XtPointer)ext->widget);
    _XmExtObjFree((XtPointer)ext->reqWidget);
    XtFree((char *)ext);
}

static void
initialize(Widget request,
	   Widget new,
	   ArgList args,
	   Cardinal *num_args)
{
    Dimension string_width, string_height, margin;

    TBG_SelectGC(new) = XtAllocateGC(new,
				     0,0,
				     NULL,
				     GCForeground,~GCForeground);

    if (!XtIsSubclass(XtParent(new), xmManagerWidgetClass))
        _XmError(new, "parent should be manager.");

    TBG_Armed(new) = False;
    TBG_VisualSet(new) = TBG_IndicatorSet(new) = TBG_Set(new);

    XmStringExtent(LabG_Font(new),
		   LabG_Label(new),
		   &string_width,
		   &string_height);

    if (TBG_IndOn(new))
	TBG_IndicatorDim(new) = 10;
    else
	TBG_IndicatorDim(new) = 0;


    margin = TBG_IndicatorDim(new) + (TBG_IndOn(new)
		? 2 * TBG_Spacing(new)
		: 0);
    LabG_MarginLeft(new) = margin;

    _XmLabelRecomputeSize(new);

    if (IN_MENU(new))
	LabG_Highlight(new) = 0;

    G_EventMask(new) = XmARM_EVENT | XmACTIVATE_EVENT | XmENTER_EVENT |
			XmLEAVE_EVENT | XmMOTION_EVENT | XmFOCUS_IN_EVENT |
			XmFOCUS_OUT_EVENT;

}

static void
destroy(Widget w)
{
    _XmCacheDelete(TBG_Cache(w));
}

static Boolean
set_values_prehook(Widget old,
                   Widget request,
                   Widget new,
                   ArgList args,
                   Cardinal *num_args)
{
    XmBaseClassExt *bce;
    XmWidgetExtData ed;
    int size;
    XtPointer nsec, rsec;

    bce = _XmGetBaseClassExtPtr(XtClass(new), XmQmotif);
    size = (*bce)->secondaryObjectClass->core_class.widget_size;

    nsec = _XmExtObjAlloc(size);
    rsec = _XmExtObjAlloc(size);

    ((XmExtRec *)nsec)->object.self = (Widget)nsec;
    ((XmExtRec *)nsec)->object.widget_class = (*bce)->secondaryObjectClass;
    ((XmExtRec *)nsec)->object.parent = XtParent(new);
    ((XmExtRec *)nsec)->object.xrm_name = new->core.xrm_name;
    ((XmExtRec *)nsec)->object.being_destroyed = False;
    ((XmExtRec *)nsec)->object.constraints = NULL;

    ExtObj_LogicalParent(nsec) = new;
    ExtObj_ExtensionType(nsec) = XmCACHE_EXTENSION;

    bcopy(LabG_Cache(new),
          &((XmLabelGCacheObject)nsec)->label_cache,
          sizeof(XmLabelGCacheObjPart));
    bcopy(TBG_Cache(new),
          &((XmToggleButtonGCacheObject)nsec)->toggle_cache,
          sizeof(XmToggleButtonGCacheObjPart));

    ed = (XmWidgetExtData)XtMalloc(sizeof(XmWidgetExtDataRec));
    ed->widget = (Widget)nsec;
    ed->reqWidget = (Widget)rsec;

    _XmPushWidgetExtData(new, ed, XmCACHE_EXTENSION);

    _XmGadgetImportSecondaryArgs(new, args, num_args);

    XtSetSubvalues((XtPointer)nsec,
                    (*bce)->secondaryObjectClass->core_class.resources,
                    (*bce)->secondaryObjectClass->core_class.num_resources,
                    args, *num_args);

    bcopy(nsec, rsec, size);

    LabG_Cache(new) = &(((XmToggleButtonGCacheObject)nsec)->label_cache);
    LabG_Cache(request) = &(((XmToggleButtonGCacheObject)rsec)->label_cache);
    TBG_Cache(new) = &(((XmToggleButtonGCacheObject)nsec)->toggle_cache);
    TBG_Cache(request) = &(((XmToggleButtonGCacheObject)rsec)->toggle_cache);

    _XmExtImportArgs((Widget)nsec, args, num_args);

    return FALSE;
}

static Boolean
set_values_posthook(Widget old,
                   Widget request,
                   Widget new,
                   ArgList args,
                   Cardinal *num_args)
{
    XmWidgetExtData ext;

    if (!_XmLabelCacheCompare(LabG_Cache(new), LabG_Cache(old))) {

	_XmCacheDelete((XtPointer)LabG_Cache(old));

	LabG_Cache(new) = _XmCachePart(LabG_ClassCachePart(NULL),
				       (XtPointer)LabG_Cache(new),
				       sizeof(XmLabelGCacheObjPart));
    }
    else
	LabG_Cache(new) = LabG_Cache(old);

    if (!_XmToggleBCacheCompare(TBG_Cache(new), TBG_Cache(old))) {

	_XmCacheDelete((XtPointer)TBG_Cache(old));

	TBG_Cache(new) = _XmCachePart(TBG_ClassCachePart(NULL),
				      (XtPointer)TBG_Cache(new),
				      sizeof(XmToggleButtonGCacheObjPart));
    }
    else
	TBG_Cache(new) = TBG_Cache(old);

    _XmPopWidgetExtData(new, &ext, XmCACHE_EXTENSION);

    _XmExtObjFree((XtPointer)ext->widget);
    _XmExtObjFree((XtPointer)ext->reqWidget);

    XtFree( (char *) ext);

    return FALSE;
}

static Boolean
set_values(Widget old,
	   Widget request,
	   Widget new,
	   ArgList args,
	   Cardinal *num_args)
{
    Boolean refresh_needed = True;

    if (XtWidth(request) != XtWidth(new)
	   || XtHeight(request) != XtHeight(new))
    {
	  XtWidth(new) = XtWidth(request);
	  XtHeight(new) = XtHeight(request);
	  refresh_needed = False;
    }

    TBG_VisualSet(new) = TBG_Set(new);
    if (TBG_Set(request) != TBG_Set(new))
	expose(new, NULL, (Region)NULL);

    return refresh_needed;
}

static void
get_values_prehook(Widget new, ArgList args, Cardinal *num_args)
{
    XmBaseClassExt *bce;
    XmWidgetExtData ed;
    int size;
    XtPointer nsec;

    bce = _XmGetBaseClassExtPtr(XtClass(new), XmQmotif);
    size = (*bce)->secondaryObjectClass->core_class.widget_size;

    nsec = _XmExtObjAlloc(size);

    bcopy(LabG_Cache(new),
          &((XmLabelGCacheObject)nsec)->label_cache,
          sizeof(XmLabelGCacheObjPart));
    bcopy(TBG_Cache(new),
          &((XmToggleButtonGCacheObject)nsec)->toggle_cache,
          sizeof(XmToggleButtonGCacheObjPart));

    /*
     * don't do this and ResInd will blow up.
     */
    ((XmExtRec *)nsec)->object.self = (Widget)nsec;
    ((XmExtRec *)nsec)->object.widget_class = (*bce)->secondaryObjectClass;
    ((XmExtRec *)nsec)->object.parent = XtParent(new);
    ((XmExtRec *)nsec)->object.xrm_name = new->core.xrm_name;
    ((XmExtRec *)nsec)->object.being_destroyed = False;
    ((XmExtRec *)nsec)->object.destroy_callbacks = NULL;
    ((XmExtRec *)nsec)->object.constraints = NULL;

    ExtObj_LogicalParent(nsec) = new;
    ExtObj_ExtensionType(nsec) = XmCACHE_EXTENSION;

    ed = (XmWidgetExtData)XtMalloc(sizeof(XmWidgetExtDataRec));
    ed->widget = (Widget)nsec;

    _XmPushWidgetExtData(new, ed, XmCACHE_EXTENSION);

    XtGetSubvalues((XtPointer)nsec,
                    (*bce)->secondaryObjectClass->core_class.resources,
                    (*bce)->secondaryObjectClass->core_class.num_resources,
                    args, *num_args);

    _XmExtGetValuesHook((Widget)nsec, args, num_args);
}

static void
get_values_posthook(Widget new, ArgList args, Cardinal *num_args)
{
     XmWidgetExtData ext;

     _XmPopWidgetExtData(new, &ext, XmCACHE_EXTENSION);

     _XmExtObjFree((XtPointer)ext->widget);

     XtFree( (char *) ext);
}

static void
get_values_hook(Widget w, ArgList args, Cardinal *num_args)
{
    XdbDebug(__FILE__, w, "ToggleButtonGadget: GetValuesHook\n");
}

static void
expose(Widget w,
       XEvent *event,
       Region region)
{
    Boolean   State = TBG_VisualSet(w);
    GC myGC;

    if (XtSensitive(w))
        myGC = TBG_SelectGC(w);
    else
        myGC = LabG_InsensitiveGC(w);

    if (TBG_FillOnSelect(w) && State)
        XSetForeground(XtDisplayOfObject(w),
                       myGC,
                       TBG_SelectColor(w));
    else
        XSetForeground(XtDisplayOfObject(w),
                       myGC,
                       XmParentBackground(w));

    if (!TBG_IndOn(w)) {
	if (TBG_FillOnSelect(w)) {
	    XFillRectangle(XtDisplayOfObject(w), XtWindowOfObject(w),
			   myGC,
			   XtX(w) + LabG_Highlight(w) + LabG_Shadow(w),
			   XtY(w) + LabG_Highlight(w) + LabG_Shadow(w),
			   XtWidth(w) -
				2 * (LabG_Highlight(w) + LabG_Shadow(w)),
			   XtHeight(w) -
				2 * (LabG_Highlight(w) + LabG_Shadow(w)));
	}
        _XmDrawShadows(XtDisplayOfObject(w), XtWindowOfObject(w), 
                       XmParentTopShadowGC(w),
                       XmParentBottomShadowGC(w),
		       LabG_Highlight(w) + XtX(w),
		       LabG_Highlight(w) + XtY(w),
                       XtWidth(w) - 2 * LabG_Highlight(w),
		       XtHeight(w) - 2 * LabG_Highlight(w),
                       LabG_Shadow(w),
                       State ? XmSHADOW_IN : XmSHADOW_OUT);
    }
    else if (TBG_IndType(w) == XmN_OF_MANY){
	XFillRectangle(XtDisplayOfObject(w), XtWindowOfObject(w),
		       myGC,
		       TBG_Spacing(w) + LabG_Highlight(w)
			 + LabG_Shadow(w) + XtX(w),
		       (XtHeight(w) - TBG_IndicatorDim(w)) / 2 + XtY(w),
		       TBG_IndicatorDim(w),
		       TBG_IndicatorDim(w));
	_XmDrawShadows(XtDisplayOfObject(w), XtWindowOfObject(w),
		       XmParentTopShadowGC(w),
		       XmParentBottomShadowGC(w),
		       TBG_Spacing(w) + LabG_Highlight(w)
			 + LabG_Shadow(w) + XtX(w),
		       (XtHeight(w) - TBG_IndicatorDim(w)) / 2 + XtY(w),
		       TBG_IndicatorDim(w), TBG_IndicatorDim(w),
		       2,
		       State ? XmSHADOW_IN : XmSHADOW_OUT);
	_XmDrawShadows(XtDisplayOfObject(w), XtWindowOfObject(w),
		       XmParentTopShadowGC(w),
		       XmParentBottomShadowGC(w),
		       G_HighlightThickness(w) + XtX(w),
		       G_HighlightThickness(w) + XtY(w),
		       XtWidth(w) - 2 * G_HighlightThickness(w),
		       XtHeight(w) - 2 * G_HighlightThickness(w),
		       G_ShadowThickness(w),
		       XmSHADOW_OUT);
    }
    else 
    {
	_XmDrawDiamond(XtDisplayOfObject(w), XtWindowOfObject(w),
		       State
			   ? XmParentTopShadowGC(w)
			   : XmParentBottomShadowGC(w),
		       State
			   ? XmParentBottomShadowGC(w)
			   : XmParentTopShadowGC(w),
                       myGC,
		       TBG_Spacing(w) + LabG_Highlight(w) + XtX(w),
		       (XtHeight(w) - TBG_IndicatorDim(w)) / 2 + XtY(w),
		       TBG_IndicatorDim(w), TBG_IndicatorDim(w),
		       2,
		       True);
	_XmDrawShadows(XtDisplayOfObject(w), XtWindowOfObject(w),
		       XmParentTopShadowGC(w),
		       XmParentBottomShadowGC(w),
		       G_HighlightThickness(w) + XtX(w),
		       G_HighlightThickness(w) + XtY(w),
		       XtWidth(w) - 2 * G_HighlightThickness(w),
		       XtHeight(w) - 2 * G_HighlightThickness(w),
		       G_ShadowThickness(w),
		       XmSHADOW_OUT);
    }

#define superclass (&xmLabelGadgetClassRec)
    (*superclass->rect_class.expose)(w, event, region);
#undef superclass
}

static Cardinal
get_sec_res_data(WidgetClass wc, XmSecondaryResourceData **data)
{
    /* FIXME */

    return _XmSecondaryResourceData(&_XmToggleBGRectClassExtRec,
                                    data, NULL, NULL, NULL, NULL);
}

static void
Arm(Widget w,
    XEvent *event,
    String *params,
    Cardinal *num_params)
{
    XmToggleButtonCallbackStruct cbs;

    TBG_Armed(w) = True;
    TBG_VisualSet(w) = TBG_IndicatorSet(w) = !TBG_Set(w);

    cbs.reason = XmCR_ARM;
    cbs.event = event;
    cbs.set = TBG_Set(w);

    XFlush(XtDisplay(w));

    XtCallCallbackList(w,
		       TBG_ArmCallback(w),
		       (XtPointer)&cbs);

    expose(w, event, (Region)NULL);
}

static void
Select(Widget w,
    XEvent *event,
    String *params,
    Cardinal *num_params)
{
    XmToggleButtonCallbackStruct cbs;
    XButtonEvent *ev = (XButtonEvent *)event;

    if ((ev->x > XtX(w) && ev->x < XtX(w) + XtWidth(w)) &&
	(ev->y > XtY(w) && ev->y < XtY(w) + XtHeight(w))) {
	if (TBG_VisualSet(w) == TBG_IndicatorSet(w)) {
	    TBG_Set(w) = TBG_VisualSet(w);
	    cbs.reason = XmCR_VALUE_CHANGED;
	    cbs.event = event;
	    cbs.set = TBG_Set(w);

	    XFlush(XtDisplay(w));

	    XtCallCallbackList(w,
			       TBG_ValueChangedCallback(w),
			       (XtPointer)&cbs);
	}
	else
	    TBG_IndicatorSet(w) = TBG_Set(w);
    }
}


static void 
Disarm(Widget w,
       XEvent *event,
       String *params,
       Cardinal *num_params)
{
    XmToggleButtonCallbackStruct cbs;

    /* expose(w, NULL, (Region)NULL); */

    TBG_Set(w) = TBG_IndicatorSet(w) = TBG_VisualSet(w);

    cbs.reason = XmCR_DISARM;
    cbs.event = event;
    cbs.set = TBG_Set(w);

    XFlush(XtDisplay(w));

    XtCallCallbackList(w,
		       TBG_DisarmCallback(w),
		       (XtPointer)&cbs);

    TBG_Armed(w) = False;
}

static void
ArmAndActivate(Widget w,
	       XEvent *event,
	       String *params,
	       Cardinal *num_params)
{
    Arm(w, event, params, num_params);
    Select(w, event, params, num_params);
    Disarm(w, event, params, num_params);
}

static void 
Help(Widget w,
     XEvent *event,
     String *params,
     Cardinal *num_params)
{
}

static void
EnterWindow(Widget w,
	    XEvent *event,
	    String *params,
	    Cardinal *num_params)
{
    if (TBG_Armed(w)) {
	TBG_VisualSet(w) = TBG_IndicatorSet(w);
	expose(w, event, (Region)NULL);
    }
}

static void
LeaveWindow(Widget w,
	    XEvent *event,
	    String *params,
	    Cardinal *num_params)
{
    if (TBG_Armed(w)) {
	TBG_VisualSet(w) = TBG_Set(w);
	expose(w, event, (Region)NULL);
    }
}

static void 
ButtonUp(Widget w, 
	 XEvent *event, 
	 String *params, 
	 Cardinal *num_params)
{
    Widget parent,shell;
    Boolean validButton, poppedUp;
    XmToggleButtonCallbackStruct cbs;

    parent = XtParent(w);

    shell = parent;
    while (!XtIsShell(shell))
	shell = XtParent(shell);

    if (event && (event->type == ButtonRelease))
	(* xmLabelGadgetClassRec.label_class.menuProcs) (XmMENU_BUTTON, parent, NULL, event, &validButton);

    if (!validButton)
	return;

    if (IN_MENU(w) && !XmIsMenuShell(shell))
	(* xmLabelGadgetClassRec.label_class.menuProcs) (XmMENU_POPDOWN, w, NULL, event, &poppedUp);
    else
	(* xmLabelGadgetClassRec.label_class.menuProcs) (XmMENU_BUTTON_POPDOWN, w , NULL, event, &poppedUp);

    _XmRecordEvent(event);
    
    if (poppedUp)
	return;

    TBG_Armed(w) = False;
    TBG_Set(w) = TBG_VisualSet(w);
    cbs.reason = XmCR_VALUE_CHANGED;
    cbs.event = event;
    cbs.set = TBG_Set(w);

    XFlush(XtDisplay(w));

    XtCallCallbackList(w, 
		       TBG_ValueChangedCallback(w), 
		       (XtPointer)&cbs);

    _XmSetInDragMode(w, False);
}


static void 
ButtonDown(Widget w, 
	   XEvent *event, 
	   String *params, 
	   Cardinal *num_params)
{
    ShellWidget popupShell;
    int validButton;
    Widget child;
    
    XAllowEvents(XtDisplayOfObject(w), SyncPointer, CurrentTime);
    
    if (event && (event->type == ButtonPress))
    {
	(* xmLabelGadgetClassRec.label_class.menuProcs) (XmMENU_BUTTON, XtParent(w), NULL, event, &validButton);
	if (!validButton)
	    return;
    }

    _XmSetInDragMode(w, TRUE);

    TBG_Armed(w) = True;

    popupShell = (ShellWidget)_XmGetRC_PopupPosted(XtParent(w));
    if  (popupShell)
    {
	if (popupShell->shell.popped_up)
	    (* xmLabelGadgetClassRec.label_class.menuProcs)(XmMENU_SHELL_POPDOWN, (Widget)popupShell, NULL, event, NULL);
	
	child = ((XmManagerWidget)XtParent(w))->manager.active_child;
	if (child && (XmIsCascadeButton(child) || XmIsCascadeButtonGadget(child)))
	    XmCascadeButtonHighlight (child, FALSE);
    }

    _XmSetInDragMode(w, FALSE);

    _XmRecordEvent(event);
}

static void
input_dispatch(Widget gadget, 
	       XEvent *event, 
	       Mask event_mask) 
{
    switch (event_mask)
    {
    case XmARM_EVENT:
	XdbDebug(__FILE__, gadget, "ToggleButtonGadget got arm event\n");
	if (XmIsRowColumn(XtParent(gadget)) 
	    && (RC_Type(XtParent(gadget)) == XmMENU_PULLDOWN))
	    ButtonDown(gadget, event, NULL, NULL);
	else
	    Arm(gadget, event, NULL, NULL);
	break;
    case XmACTIVATE_EVENT:
	XdbDebug(__FILE__, gadget, "ToggleButtonGadget got activate event\n");
	if (XmIsRowColumn(XtParent(gadget)) 
	    && (RC_Type(XtParent(gadget)) == XmMENU_PULLDOWN))
	    ButtonUp(gadget, event, NULL, NULL);
	else
        {
	    Select(gadget, event, NULL, NULL);
	    Disarm(gadget, event, NULL, NULL);
        }
	break;
    case XmENTER_EVENT:
	XdbDebug(__FILE__, gadget, "ToggleButtonGadget enter window\n");
	EnterWindow(gadget, event, NULL, NULL);
	break;
    case XmLEAVE_EVENT:
	XdbDebug(__FILE__, gadget, "ToggleButtonGadget leave window\n");
	LeaveWindow(gadget, event, NULL, NULL);
	break;
    case XmMOTION_EVENT:
	XdbDebug(__FILE__, gadget, "ToggleButtonGadget motion event\n");
	break;
    case XmFOCUS_IN_EVENT:
	_XmFocusInGadget(gadget, event, NULL, NULL);
	break;
    case XmFOCUS_OUT_EVENT:
	_XmFocusOutGadget(gadget, event, NULL, NULL);
	break;
    default:
	_XmWarning(gadget, "ToggleButtonGadget got unknown event\n");
    }
}

Widget
XmCreateToggleButtonGadget(Widget parent,
		    char *name,
		    Arg *arglist,
		    Cardinal argcount)
{
    return XtCreateWidget(name,
			  xmToggleButtonGadgetClass,
			  parent,
			  arglist,
			  argcount);
}

Boolean
XmToggleButtonGadgetGetState(Widget widget)
{
    return TBG_Set(widget);
}

void
XmToggleButtonGadgetSetState(Widget widget, 
			     Boolean state,
			     Boolean notify)
{
    XmToggleButtonCallbackStruct cbs;

    if ((TBG_Set(widget) && !state) || (!TBG_Set(widget) && state)) {
	TBG_VisualSet(widget) = TBG_Set(widget) = state ? True : False;
	if (notify) {
	    cbs.reason = XmCR_VALUE_CHANGED;
	    cbs.event = NULL; /* FIXME -- IS THIS RIGHT? */
	    cbs.set = state;

	    XFlush(XtDisplay(widget));

	    XtCallCallbackList(widget,
			       TBG_ValueChangedCallback(widget),
			       (XtPointer)&cbs);
	}
	if (XtIsRealized(widget))
	    expose(widget, NULL, (Region)NULL);
    }
}
