/**
 *
 * $Id: PushB.c,v 1.43 1996/05/02 07:11:09 u27113 Exp $
 *
 * Copyright (C) 1995 Free Software Foundation, Inc.
 *
 * This file is part of the GNU LessTif Library.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **/

static char rcsid[] = "$Id: PushB.c,v 1.43 1996/05/02 07:11:09 u27113 Exp $";

#include <LTconfig.h>
#include <Xm/XmP.h>
#include <Xm/XmI.h>
#include <Xm/DebugUtil.h>
#include <Xm/PushBP.h>
#include <Xm/RowColumnP.h>
#include <Xm/MenuUtilP.h>
#include <Xm/TransltnsP.h>
#include <Xm/MenuShell.h>
#include <Xm/CascadeB.h>
#include <Xm/CascadeBG.h>

/* Forward Declarations */

static void class_initialize();
static void class_part_initialize(WidgetClass class);
static void initialize(Widget request, Widget new, ArgList args, Cardinal *num_args);
static void destroy(Widget w);
static void expose(Widget w, XEvent *event, Region region);
static Boolean set_values(Widget current, Widget request, Widget new, ArgList args, Cardinal *num_args);

/*
 * Resources for the pushButton class
 */
#define Offset(field) XtOffsetOf(XmPushButtonRec, pushbutton.field)
static XtResource resources[] = {
    {
	XmNmultiClick, XmCMultiClick, XmRMultiClick,
	sizeof(unsigned char), Offset(multiClick),
	XmRImmediate, (XtPointer)((unsigned char)XmUNSPECIFIED)
    },
    {
	XmNfillOnArm, XmCFillOnArm, XmRBoolean,
	sizeof(unsigned char), Offset(fill_on_arm),
	XtRImmediate, (XtPointer)True
    },
    {
	XmNarmColor, XmCArmColor, XmRPixel,
	sizeof(Pixel), Offset(arm_color),
	XmRCallProc, (XtPointer)_XmSelectColorDefault
    },
    {
	XmNarmPixmap, XmCArmPixmap, XmRPrimForegroundPixmap,
	sizeof(Pixmap), Offset(arm_pixmap),
	XmRImmediate, (XtPointer)XmUNSPECIFIED_PIXMAP
    },
    {
	XmNshowAsDefault, XmCShowAsDefault, XmRBooleanDimension,
	sizeof(Dimension), Offset(show_as_default),
	XtRImmediate, (XtPointer)0
    },
    {
	XmNactivateCallback, XmCCallback, XmRCallback,
	sizeof(XtCallbackList), Offset(activate_callback),
	XmRPointer, (XtPointer)NULL
    },
    {
	XmNarmCallback, XmCCallback, XmRCallback,
	sizeof(XtCallbackList), Offset(arm_callback),
	XmRPointer, (XtPointer)NULL
    },
    {
	XmNdisarmCallback, XmCCallback, XmRCallback,
	sizeof(XtCallbackList), Offset(disarm_callback),
	XmRPointer, (XtPointer)NULL
    },
    {
	XmNshadowThickness, XmCShadowThickness, XmRHorizontalDimension,
	sizeof(Dimension), XtOffsetOf(XmPushButtonRec, primitive.shadow_thickness),
	XmRImmediate, (XtPointer)2
    },
    {
	XmNdefaultButtonShadowThickness, XmCDefaultButtonShadowThickness, XmRHorizontalDimension,
	sizeof(Dimension), Offset(default_button_shadow_thickness),
	XmRImmediate, (XtPointer)0
    },
    /* Resources redefined from Primitive/Label */
    {
	XmNtraversalOn, XmCTraversalOn, XmRBoolean,
	sizeof(Boolean), XtOffsetOf(XmPushButtonRec, primitive.traversal_on),
	XmRImmediate, (XtPointer)True
    },
    {
	XmNhighlightThickness, XmCHighlightThickness, XmRHorizontalDimension,
	sizeof(Dimension), XtOffsetOf(XmPushButtonRec, primitive.highlight_thickness),
	XmRImmediate, (XtPointer)2
    },
};

static XmSyntheticResource syn_resources[] = {
    {
	XmNshowAsDefault,
	sizeof(Dimension), Offset(show_as_default),
	NULL /* FIXME */, NULL /* FIXME */
    },
    {
	XmNdefaultButtonShadowThickness,
	sizeof(Dimension), Offset(default_button_shadow_thickness),
	_XmFromHorizontalPixels, _XmToHorizontalPixels
    },
    {
	XmNhighlightThickness,
	sizeof(Dimension), XtOffsetOf(XmPushButtonRec, primitive.highlight_thickness),
	_XmFromHorizontalPixels, _XmToHorizontalPixels
    }
};

static void Arm(Widget w, XEvent *event, String *params, Cardinal *num_params);
static void Activate(Widget w, XEvent *event, String *params, Cardinal *num_params);
static void Disarm(Widget w, XEvent *event, String *params, Cardinal *num_params);
static void ArmAndActivate(Widget w, XEvent *event, String *params, Cardinal *num_params);
static void Help(Widget w, XEvent *event, String *params, Cardinal *num_params);
static void EnterWindow(Widget w, XEvent *event, String *params, Cardinal *num_params);
static void LeaveWindow(Widget w, XEvent *event, String *params, Cardinal *num_params);
static void ButtonUp(Widget w, XEvent *event, String *params, Cardinal *num_params);
static void ButtonDown(Widget w, XEvent *event, String *params, Cardinal *num_params);
static void MultiActivate(Widget w, XEvent *event, String *params, Cardinal *num_params);

char _XmPushB_defaultTranslations[] = 
   "<Key>osfSelect:       ArmAndActivate()\n\
    <Key>osfHelp:         Help()\n\
    <Key>osfActivate:     PrimitiveParentActivate()\n\
    <EnterWindow>:        Enter()\n\
    <LeaveWindow>:        Leave()\n\
    <Btn1Down>:           Arm()\n\
    <Btn1Down>,<Btn1Up>:  Activate() Disarm()\n\
    <Btn1Down>(2+):       MultiArm()\n\
    <Btn1Up>(2+):         MultiActivate()\n\
    <Btn1Up>:             Activate() Disarm()\n\
    <Btn2Down>:           ProcessDrag()\n\
    ~s ~m ~a <Key>Return: PrimitiveParentActivate()\n\
    ~s ~m ~a <Key>space:  ArmAndActivate()";

char _XmPushB_menuTranslations[] =
   "<EnterWindow>:        Enter()\n\
    <LeaveWindow>:        Leave()\n\
    <BtnDown>:            BtnDown()\n\
    <BtnUp>:              BtnUp()\n\
    <Key>osfSelect:       ArmAndActivate()\n\
    <Key>osfActivate:     ArmAndActivate()\n\
    <Key>osfCancel:       MenuEscape()\n\
    <Key>osfHelp:         Help()\n\
    ~s ~m ~a <Key>Return: ArmAndActivate()\n\
    ~s ~m ~a <Key>space:  ArmAndActivate()";

static XtActionsRec actions[] = {
    {"Arm", Arm},
    {"Activate", Activate},
    {"Disarm", Disarm},
    {"ArmAndActivate", ArmAndActivate},
    {"Help", Help},
    {"Enter", EnterWindow},
    {"Leave", LeaveWindow},
    {"BtnDown", ButtonDown},
    {"BtnUp", ButtonUp},
    {"MultiArm", MultiActivate},
    {"MultiActivate", MultiActivate},
};

static XmBaseClassExtRec _XmPushBCoreClassExtRec = {
    /* next_extension            */ NULL,
    /* record_type               */ NULLQUARK,                             
    /* version                   */ XmBaseClassExtVersion,
    /* size                      */ sizeof(XmBaseClassExtRec),
    /* initialize_prehook        */ NULL, /* FIXME */
    /* set_values_prehook        */ NULL, /* FIXME */
    /* initialize_posthook       */ NULL, /* FIXME */
    /* set_values_posthook       */ NULL, /* FIXME */
    /* secondary_object_class    */ NULL, /* FIXME */
    /* secondary_object_create   */ NULL, /* FIXME */
    /* get_secondary_resources   */ NULL, /* FIXME */
    /* fast_subclass             */ { 0 }, /* FIXME */
    /* get_values_prehook        */ NULL, /* FIXME */
    /* get_values_posthook       */ NULL, /* FIXME */
    /* class_part_init_prehook   */ NULL,
    /* class_part_init_posthook  */ NULL,
    /* ext_resources             */ NULL,
    /* compiled_ext_resources    */ NULL,
    /* num_ext_resources         */ 0,
    /* use_sub_resources         */ FALSE,
    /* widget_navigable          */ XmInheritWidgetNavigable,
    /* focus_change              */ XmInheritFocusChange,
    /* wrapper_data              */ NULL
};

XmPrimitiveClassExtRec _XmPushBPrimClassExtRec = {
    /* next_extension      */ NULL,
    /* record_type         */ NULLQUARK,
    /* version             */ XmPrimitiveClassExtVersion,
    /* record_size         */ sizeof(XmPrimitiveClassExtRec),
    /* widget_baseline     */ NULL, /* FIX ME */
    /* widget_display_rect */ NULL, /* FIX ME */
    /* widget_margins      */ NULL  /* FIX ME */
};

XmPushButtonClassRec xmPushButtonClassRec = {
    /* Core class part */
    {
	/* superclass            */ (WidgetClass) &xmLabelClassRec,
        /* class_name            */ "XmPushButton",
	/* widget_size           */ sizeof(XmPushButtonRec),
	/* class_initialize      */ class_initialize,
	/* class_part_initialize */ class_part_initialize,
	/* class_inited          */ FALSE,
	/* initialize            */ initialize,
	/* initialize_hook       */ NULL,
	/* realize               */ XtInheritRealize,
	/* actions               */ actions,
	/* num_actions           */ XtNumber(actions),
	/* resources             */ resources,
	/* num_resources         */ XtNumber(resources),
	/* xrm_class             */ NULLQUARK,
	/* compress_motion       */ TRUE,
	/* compress_exposure     */ XtExposeCompressMultiple,
	/* compress_enterleave   */ TRUE,
	/* visible_interest      */ FALSE,
	/* destroy               */ destroy,
	/* resize                */ XtInheritResize,
	/* expose                */ expose,
	/* set_values            */ set_values,
	/* set_values_hook       */ NULL,
	/* set_values_almost     */ XtInheritSetValuesAlmost,
	/* get_values_hook       */ NULL,
	/* accept_focus          */ NULL,
	/* version               */ XtVersion,
	/* callback offsets      */ NULL,
	/* tm_table              */ _XmPushB_defaultTranslations,
	/* query_geometry        */ XtInheritQueryGeometry,
	/* display_accelerator   */ XtInheritDisplayAccelerator,
	/* extension             */ (XtPointer)&_XmPushBCoreClassExtRec
    },
    /* Primitive Class part */
    {
	/* border_highlight      */ XmInheritBorderHighlight,
       	/* border_unhighlight    */ XmInheritBorderUnhighlight,
       	/* translations          */ XtInheritTranslations,
       	/* arm_and_activate_proc */ ArmAndActivate,
       	/* synthetic resources   */ syn_resources, 
        /* num syn res           */ XtNumber(syn_resources),
	/* extension             */ (XtPointer)&_XmPushBPrimClassExtRec
    },
    /* Label Class part */
    {
        /* setOverrideCallback */ XmInheritSetOverrideCallback,
        /* menuProcs           */ XmInheritMenuProc,
        /* translations        */ XtInheritTranslations,
	/* extension           */ NULL
    },
    /* PushButton Class part */
    {
	/* extension */ NULL
    }
};

WidgetClass xmPushButtonWidgetClass = (WidgetClass)&xmPushButtonClassRec;

/* 
  Some #defines to make the code below more readable
 */

#define IN_MENU(w) (XmIsRowColumn(XtParent(w)) \
                    && (RC_Type(XtParent(w)) == XmMENU_POPUP \
                          || RC_Type(XtParent(w)) == XmMENU_PULLDOWN))
#define IN_POPUP(w) (XmIsRowColumn(XtParent(w)) \
                    && ((XmRowColumnWidget)XtParent(w))->row_column.row_column_type == XmMENU_POPUP)

static void
class_initialize()
{
    _XmPushBCoreClassExtRec.record_type = XmQmotif;
}

static void
class_part_initialize(WidgetClass widget_class)
{
    _XmFastSubclassInit(widget_class, XmPUSH_BUTTON_BIT);
}

void
_XmPushButtonSetTranslation(Widget w, int inmenu)
{
    if (inmenu)
	XtOverrideTranslations(w, XtParseTranslationTable(_XmPushB_menuTranslations));
    else
	XtOverrideTranslations(w, XtParseTranslationTable(_XmPushB_defaultTranslations));
}

static void
initialize(Widget request,
	   Widget new,
	   ArgList args,
	   Cardinal *num_args)
{
    XGCValues values;
    int		margin, margin_extra;
    
    if (!Lab_Font(new))
	Lab_Font(new) = _XmGetDefaultFontList(new,
					      XmBUTTON_FONTLIST);
    
    values.foreground = PB_ArmColor(new);
    PB_FillGC(new) = XtGetGC(new, GCForeground, &values);

    PB_Armed(new) = False;

    if (IN_MENU(new))
    {
	XtOverrideTranslations(new, XtParseTranslationTable(_XmPushB_menuTranslations));
	Lab_Highlight(new) = 0;
    }
    else
    {
	/* take care of the default button shadow stuff */
	/*
	 * This new code adjusts button size in two cases : when ShowAsDefault
	 * is non-zero, and when DefaultButtonShadow is non-zero.
	 */
	margin = 0;
	margin_extra = 0;
	if (PB_DefaultButtonShadow(new)) {
	    margin = 2 * PB_DefaultButtonShadow(new) + Lab_Shadow(new);
	    margin_extra = Xm3D_ENHANCE_PIXEL;
	}
	else if (PB_ShowAsDefault(new)) {
	    margin = 2 * PB_ShowAsDefault(new) + Lab_Shadow(new);
	    margin_extra = Xm3D_ENHANCE_PIXEL;
	}

	Lab_MarginLeft(new) = margin + margin_extra;
	Lab_MarginRight(new) = margin + margin_extra;
	Lab_MarginTop(new) = margin + margin_extra;
	Lab_MarginBottom(new) = margin + margin_extra;

#if 1
	XtWidth(new) += (margin + margin_extra) * 2;
	XtHeight(new) += 2 * margin + margin_extra;
#else
	_XmLabelRecomputeSize(new);
#endif
    }
  
    if (Lab_Accelerator(new))
      _XmManagerInstallAccelerator(XtParent(new), new, Lab_Accelerator(new));
    if (Lab_Mnemonic(new))
      _XmManagerInstallMnemonic(XtParent(new), new, Lab_Mnemonic(new));
}

static void
destroy(Widget w)
{
    XtReleaseGC(w, PB_FillGC(w));
    _XmManagerUninstallAccelerator(XtParent(w), w);
    _XmManagerUninstallMnemonic(XtParent(w), w);
}

static Boolean
set_values(Widget old,
	   Widget request,
	   Widget new,
	   ArgList args,
	   Cardinal *num_args)
{
    Boolean refresh_needed = True;
    Dimension margin, margin_extra;

    XdbDebug(__FILE__, new, "set_values()\n");

    if (!IN_MENU(new) &&
	(PB_DefaultButtonShadow(new) != PB_DefaultButtonShadow(old) ||
	 PB_ShowAsDefault(new) != PB_ShowAsDefault(old))) {

	margin = 0;
	margin_extra = 0;
	if (PB_DefaultButtonShadow(new)) {
	    margin = 2 * PB_DefaultButtonShadow(new) + Lab_Shadow(new);
	    margin_extra = Xm3D_ENHANCE_PIXEL;
	}
	else if (PB_ShowAsDefault(new)) {
	    margin = 2 * PB_ShowAsDefault(new) + Lab_Shadow(new);
	    margin_extra = Xm3D_ENHANCE_PIXEL;
	}

	Lab_MarginLeft(new) = margin + margin_extra;
	Lab_MarginRight(new) = margin + margin_extra;
	Lab_MarginTop(new) = margin + margin_extra;
	Lab_MarginBottom(new) = margin + margin_extra;

#if 1
	XtWidth(new) += (margin + margin_extra) * 2;
	XtHeight(new) += 2 * margin + margin_extra;
#endif

	refresh_needed = True;
    }

/* Accelerator */
    if (Lab_Accelerator(new) != Lab_Accelerator(old)) {
	_XmManagerUninstallAccelerator(XtParent(new), new);
	_XmManagerInstallAccelerator(XtParent(new), new, Lab_Accelerator(new));
	refresh_needed = True;
    }

/* Mnemonic */
    if (Lab_Mnemonic(new) != Lab_Mnemonic(old)) {
	_XmManagerUninstallMnemonic(XtParent(new), new);
	_XmManagerInstallMnemonic(XtParent(new), new, Lab_Mnemonic(new));
	refresh_needed = True;
    }

    return refresh_needed;
}

static void
expose(Widget w,
       XEvent *event,
       Region region)
{
    /* these make it easier to deal with the default button stuff */
    Dimension normal_shadow_x, normal_shadow_y;
    Dimension normal_shadow_width, normal_shadow_height;

    normal_shadow_x = Lab_Highlight(w) + Lab_MarginLeft(w);
    normal_shadow_y = Lab_Highlight(w) + Lab_MarginTop(w);
    
    normal_shadow_width = XtWidth(w) - 2 * Lab_Highlight(w) - Lab_MarginLeft(w) - Lab_MarginRight(w);
    normal_shadow_height = XtHeight(w) - 2 * Lab_Highlight(w) - Lab_MarginTop(w) - Lab_MarginBottom(w);
    
    if (!IN_MENU(w))
    {
	/* take care of the default button stuff */

	if (PB_ShowAsDefault(w) > 0)
	{
	    Dimension shad;

 	    if (PB_DefaultButtonShadow(w) == 0)
 		shad = PB_ShowAsDefault(w);
 	    else
 		shad = PB_DefaultButtonShadow(w);

	    _XmDrawShadows(XtDisplay(w), XtWindow(w),
			   Prim_TopShadowGC(w),
			   Prim_BottomShadowGC(w),
			   normal_shadow_x - (2 * shad + Lab_Shadow(w)),
			   normal_shadow_y - (2 * shad + Lab_Shadow(w)),
			   normal_shadow_width + 2 * (2 * shad + Lab_Shadow(w)),
			   normal_shadow_height + 2 * (2 * shad + Lab_Shadow(w)),
			   shad,
			   XmSHADOW_IN);

	}

	if (XtSensitive(w) && PB_Armed(w) && PB_FillOnArm(w))
	{
	    XFillRectangle(XtDisplay(w), XtWindow(w),
			   PB_FillGC(w),
			   normal_shadow_x + Lab_Shadow(w),
			   normal_shadow_y + Lab_Shadow(w),
			   normal_shadow_width - 2 * Lab_Shadow(w),
			   normal_shadow_height - 2 * Lab_Shadow(w));
	}

	/* now draw the normal shadow */
	_XmDrawShadows(XtDisplay(w), XtWindow(w), 
		       Prim_TopShadowGC(w),
		       Prim_BottomShadowGC(w),
		       normal_shadow_x,
		       normal_shadow_y,
		       normal_shadow_width,
		       normal_shadow_height,
		       Lab_Shadow(w),
		       XtSensitive(w) && PB_Armed(w) ? XmSHADOW_IN : XmSHADOW_OUT);
    }
    else
	_XmDrawShadows(XtDisplay(w), 
		       XtWindow(w), 
		       Prim_TopShadowGC(w),
		       Prim_BottomShadowGC(w),
		       0,
		       0,
		       XtWidth(w),
		       XtHeight(w),
		       Lab_Shadow(w),
		       XtSensitive(w) && PB_Armed(w) ? XmSHADOW_OUT : XmNO_LINE);

#define superclass (&xmLabelClassRec)
    (*superclass->core_class.expose)(w, event, region);
#undef superclass
}

static void
Arm(Widget w,
    XEvent *event,
    String *params,
    Cardinal *num_params)
{
    XmPushButtonCallbackStruct cbs;

    /* these make it easier to deal with the default button stuff */
    Dimension normal_shadow_x, normal_shadow_y;
    Dimension normal_shadow_width, normal_shadow_height;

    XmProcessTraversal(w, XmTRAVERSE_CURRENT);

    PB_Armed(w) = True;

    cbs.reason = XmCR_ARM;
    cbs.event = event;
    cbs.click_count = PB_ClickCount(w);

    normal_shadow_x = Lab_Highlight(w) + Lab_MarginLeft(w);
    normal_shadow_y = Lab_Highlight(w) + Lab_MarginTop(w);

    normal_shadow_width = XtWidth(w) - (2 * Lab_Highlight(w) + Lab_MarginLeft(w) + Lab_MarginRight(w));
    normal_shadow_height = XtHeight(w) - (2 * Lab_Highlight(w) + Lab_MarginTop(w) + Lab_MarginBottom(w));

    _XmDrawShadows(XtDisplay(w),
		   XtWindow(w),
		   Prim_TopShadowGC(w),
		   Prim_BottomShadowGC(w),
		   normal_shadow_x,
		   normal_shadow_y,
		   normal_shadow_width,
		   normal_shadow_height,
		   Lab_Shadow(w),
		   XmSHADOW_IN);

    if (PB_FillOnArm(w))
    {
	XFillRectangle(XtDisplay(w), XtWindow(w),
		       PB_FillGC(w),
		       normal_shadow_x + Lab_Shadow(w),
		       normal_shadow_y + Lab_Shadow(w),
		       normal_shadow_width - 2 * Lab_Shadow(w),
		       normal_shadow_height - 2 * Lab_Shadow(w));

#define superclass (&xmLabelClassRec)
    (*superclass->core_class.expose)(w, NULL, (Region)NULL);
#undef superclass
    }

    XtCallCallbackList(w,
		       PB_ArmCallback(w),
		       (XtPointer)&cbs);
}


static void 
Activate(Widget w,
	 XEvent *event,
	 String *params,
	 Cardinal *num_params)
{
    XmPushButtonCallbackStruct cbs;
    XButtonEvent *ev = (XButtonEvent *)event;

    /* these make it easier to deal with the default button stuff */
    Dimension normal_shadow_x, normal_shadow_y;
    Dimension normal_shadow_width, normal_shadow_height;

    XdbDebug(__FILE__, w, "Activate()\n");

#if 1
/*
 * This test should not be necessary.
 * It happens to break accelerators that trigger a button.
 * Danny 5/4/96
 * MLM: Not having means PB's break if the button is released outside
 * the widget after it is armed. Check testXm/pushbutton/test1.  Arm
 * (click) on the button, move outside the button, and release.  If this
 * isn't here, the arm callback will be executed (and it shouldn't be).
 *
 * Test refined so it doesn't fail for accelerators. -- Danny
 */
    if (ev->type == KeyPress || ev->type == KeyRelease
	|| ((ev->x >= 0 && ev->x < XtWidth(w))
	&& (ev->y >= 0 && ev->y < XtHeight(w))))
#endif
    {
	normal_shadow_x = Lab_Highlight(w) + Lab_MarginLeft(w);
	normal_shadow_y = Lab_Highlight(w) + Lab_MarginTop(w);
	
	normal_shadow_width = XtWidth(w) - (2 * Lab_Highlight(w) + Lab_MarginLeft(w) + Lab_MarginRight(w));
	normal_shadow_height = XtHeight(w) - (2 * Lab_Highlight(w) + Lab_MarginTop(w) + Lab_MarginBottom(w));

	if (XtIsRealized(w)) {
	    _XmDrawShadows(XtDisplay(w),
		       XtWindow(w),
		       Prim_TopShadowGC(w),
		       Prim_BottomShadowGC(w),
		       normal_shadow_x,
		       normal_shadow_y,
		       normal_shadow_width,
		       normal_shadow_height,
		       Lab_Shadow(w),
		       XmSHADOW_OUT);

	    if (PB_FillOnArm(w)) {
		XClearArea(XtDisplay(w),
		       XtWindow(w),
		       normal_shadow_x + Lab_Shadow(w),
		       normal_shadow_y + Lab_Shadow(w),
		       normal_shadow_width - 2 * Lab_Shadow(w),
		       normal_shadow_height - 2 * Lab_Shadow(w),
		       False);
	    
#define superclass (&xmLabelClassRec)
		(*superclass->core_class.expose)(w, NULL, (Region)NULL);
#undef superclass
	    }
	}

	cbs.reason = XmCR_ACTIVATE;
	cbs.event = event;
	cbs.click_count = PB_ClickCount(w);

	XtCallCallbackList(w,
		           PB_ActivateCallback(w),
		           (XtPointer)&cbs);
    }
}

static void 
Disarm(Widget w,
       XEvent *event,
       String *params,
       Cardinal *num_params)
{
    XmPushButtonCallbackStruct cbs;

    PB_Armed(w) = False;

    cbs.reason = XmCR_DISARM;
    cbs.event = event;
    cbs.click_count = PB_ClickCount(w);
 
    XtCallCallbackList(w,
		       PB_DisarmCallback(w),
		       (XtPointer)&cbs);
}

static void
ArmAndActivate(Widget w,
	       XEvent *event,
	       String *params,
	       Cardinal *num_params)
{
    Arm(w, event, params, num_params);
    Activate(w, event, params, num_params);
    Disarm(w, event, params, num_params);
}

static void 
Help(Widget w,
     XEvent *event,
     String *params,
     Cardinal *num_params)
{
}

static void
EnterWindow(Widget w,
	    XEvent *event,
	    String *params,
	    Cardinal *num_params)
{
    XmPushButtonCallbackStruct cbs;

    /* these make it easier to deal with the default button stuff */
    Dimension normal_shadow_x, normal_shadow_y;
    Dimension normal_shadow_width, normal_shadow_height;

    XdbDebug(__FILE__, w, "PushB Enter\n");

    XtCallActionProc(w, "PrimitiveEnter", event, params, *num_params);    

    normal_shadow_x = Lab_Highlight(w) + Lab_MarginLeft(w);
    normal_shadow_y = Lab_Highlight(w) + Lab_MarginTop(w);

    normal_shadow_width = XtWidth(w) - (2 * Lab_Highlight(w) + Lab_MarginLeft(w) + Lab_MarginRight(w));
    normal_shadow_height = XtHeight(w) - (2 * Lab_Highlight(w) + Lab_MarginTop(w) + Lab_MarginBottom(w));

    if (Lab_MenuType(w) == XmWORK_AREA)
    {
	if (PB_Armed(w))
	{
	    _XmDrawShadows(XtDisplay(w),
			   XtWindow(w),
			   Prim_TopShadowGC(w),
			   Prim_BottomShadowGC(w),
			   normal_shadow_x,
			   normal_shadow_y,
			   normal_shadow_width,
			   normal_shadow_height,
			   Lab_Shadow(w),
			   XmSHADOW_IN);
	    
	    if (PB_FillOnArm(w))
	    {
		XFillRectangle(XtDisplay(w), XtWindow(w),
			       PB_FillGC(w),
			       normal_shadow_x + Lab_Shadow(w),
			       normal_shadow_y + Lab_Shadow(w),
			       normal_shadow_width - 2 * Lab_Shadow(w),
			       normal_shadow_height - 2 * Lab_Shadow(w));
		
#define superclass (&xmLabelClassRec)
		(*superclass->core_class.expose)(w, NULL, (Region)NULL);
#undef superclass
	    }
	}
    }
    else /* we're in a menu */
    {
	if (_XmGetInDragMode(w))
	{
	    ShellWidget popupShell;

	    popupShell = (ShellWidget)_XmGetRC_PopupPosted(XtParent(w));
	    if  (popupShell)
	    {
		if (popupShell->shell.popped_up)
		    (* xmLabelClassRec.label_class.menuProcs)(XmMENU_SHELL_POPDOWN, 
							      (Widget)popupShell, 
							      NULL, 
							      event, 
							      NULL);
	    }

	    _XmDrawShadows(XtDisplay(w),
			   XtWindow(w),
			   Prim_TopShadowGC(w),
			   Prim_BottomShadowGC(w),
			   Lab_Highlight(w),
			   Lab_Highlight(w), 
			   XtWidth(w) - 2 * Lab_Highlight(w),
			   XtHeight(w) - 2 * Lab_Highlight(w),
			   Lab_Shadow(w),
			   XmSHADOW_OUT);

	    PB_Armed(w) = True; 

	    cbs.reason = XmCR_ARM;
	    cbs.event = event;
	    cbs.click_count = PB_ClickCount(w);

	    XtCallCallbackList(w,
			       PB_ArmCallback(w),
			       (XtPointer)&cbs);
	}
    }
}

static void
LeaveWindow(Widget w,
	    XEvent *event,
	    String *params,
	    Cardinal *num_params)
{
    XmPushButtonCallbackStruct cbs;

    /* these make it easier to deal with the default button stuff */
    Dimension normal_shadow_x, normal_shadow_y;
    Dimension normal_shadow_width, normal_shadow_height;

    XtCallActionProc(w, "PrimitiveLeave", event, params, *num_params);    

    normal_shadow_x = Lab_Highlight(w) + Lab_MarginLeft(w);
    normal_shadow_y = Lab_Highlight(w) + Lab_MarginTop(w);

    normal_shadow_width = XtWidth(w) - (2 * Lab_Highlight(w) + Lab_MarginLeft(w) + Lab_MarginRight(w));
    normal_shadow_height = XtHeight(w) - (2 * Lab_Highlight(w) + Lab_MarginTop(w) + Lab_MarginBottom(w));

    if (Lab_MenuType(w) == XmWORK_AREA)
    {
	if (PB_Armed(w))
	{
	    _XmDrawShadows(XtDisplay(w),
			   XtWindow(w),
			   Prim_TopShadowGC(w),
			   Prim_BottomShadowGC(w),
			   normal_shadow_x,
			   normal_shadow_y,
			   normal_shadow_width,
			   normal_shadow_height,
			   Lab_Shadow(w),
			   XmSHADOW_OUT);

	    if (PB_FillOnArm(w))
	    {
		XClearArea(XtDisplay(w),
			   XtWindow(w),
			   normal_shadow_x + Lab_Shadow(w),
			   normal_shadow_y + Lab_Shadow(w),
			   normal_shadow_width - 2 * Lab_Shadow(w),
			   normal_shadow_height - 2 * Lab_Shadow(w),
			   False);
		
#define superclass (&xmLabelClassRec)
		(*superclass->core_class.expose)(w, NULL, (Region)NULL);
#undef superclass
	    }
	}
    }
    else /* we're in a menu */
    {
	if (_XmGetInDragMode(w))
	{
	    _XmDrawShadows(XtDisplay(w),
			   XtWindow(w),
			   Prim_TopShadowGC(w),
			   Prim_BottomShadowGC(w),
			   Lab_Highlight(w),
			   Lab_Highlight(w), 
			   XtWidth(w) - 2 * Lab_Highlight(w),
			   XtHeight(w) - 2 * Lab_Highlight(w),
			   Lab_Shadow(w),
			   XmNO_LINE);

	    PB_Armed(w) = False;

	    cbs.reason = XmCR_DISARM;
	    cbs.event = event;
	    cbs.click_count = PB_ClickCount(w);

	    XtCallCallbackList(w,
			       PB_DisarmCallback(w),
			       (XtPointer)&cbs);
	}
    }
}

static void 
ButtonUp(Widget w, 
	 XEvent *event, 
	 String *params, 
	 Cardinal *num_params)
{
    Widget parent,shell;
    Boolean validButton, poppedUp;
    XmPushButtonCallbackStruct cbs;

    XdbDebug(__FILE__, w, "ButtonUp()\n");

    parent = XtParent(w);

    shell = parent;
    while (!XtIsShell(shell))
	shell = XtParent(shell);

    if (event && (event->type == ButtonRelease))
	(* xmLabelClassRec.label_class.menuProcs) (XmMENU_BUTTON, parent, NULL, event, &validButton);

    if (!validButton) {
	XdbDebug(__FILE__, w, "ButtonUp: not a valid button\n");
	return;
    }

    if (IN_MENU(w) && !XmIsMenuShell(shell))
	(* xmLabelClassRec.label_class.menuProcs) (XmMENU_POPDOWN, w, NULL, event, &poppedUp);
    else
	(* xmLabelClassRec.label_class.menuProcs) (XmMENU_BUTTON_POPDOWN, w , NULL, event, &poppedUp);

    _XmRecordEvent(event);
    
    if (poppedUp) {
	XdbDebug(__FILE__, w, "ButtonUp: was not popped up\n");
	return;
    }

    PB_Armed(w) = False;

    cbs.reason = XmCR_ACTIVATE;
    cbs.event = event;
    cbs.click_count = PB_ClickCount(w);
    XtCallCallbackList(w,
		       PB_ActivateCallback(w),
		       &cbs);

    _XmDrawShadows(XtDisplay(w),
		   XtWindow(w),
		   Prim_TopShadowGC(w),
		   Prim_BottomShadowGC(w),
		   Lab_Highlight(w),
		   Lab_Highlight(w),
		   XtWidth(w) - 2 * Lab_Highlight(w),
		   XtHeight(w) - 2 * Lab_Highlight(w),
		   Lab_Shadow(w),
		   XmNO_LINE);

    _XmSetInDragMode(w, False);
}

static void 
ButtonDown(Widget w, 
	   XEvent *event, 
	   String *params, 
	   Cardinal *num_params)
{
    /* modified from the MegaButton widget */
    ShellWidget popupShell;
    int validButton;
    
    XAllowEvents(XtDisplay(w), SyncPointer, CurrentTime);
    
    if (event && (event->type == ButtonPress))
    {
	(* xmLabelClassRec.label_class.menuProcs) (XmMENU_BUTTON, 
						   XtParent(w), 
						   NULL, 
						   event, 
						   &validButton);
	if (!validButton)
	    return;
    }

    _XmSetInDragMode(w, True);

    PB_Armed(w) = True;

    popupShell = (ShellWidget)_XmGetRC_PopupPosted(XtParent(w));
    if  (popupShell)
    {
	if (popupShell->shell.popped_up)
	    (* xmLabelClassRec.label_class.menuProcs)(XmMENU_SHELL_POPDOWN, 
						      (Widget)popupShell, 
						      NULL, 
						      event, 
						      NULL);
    }

    _XmDrawShadows(XtDisplay(w),
		   XtWindow(w),
		   Prim_TopShadowGC(w),
		   Prim_BottomShadowGC(w),
		   Lab_Highlight(w),
		   Lab_Highlight(w),
		   XtWidth(w) - 2 * Lab_Highlight(w),
		   XtHeight(w) - 2 * Lab_Highlight(w),
		   Lab_Shadow(w),
		   XmSHADOW_OUT);

    _XmRecordEvent(event);
}

static void 
MultiActivate(Widget w, 
              XEvent *event, 
              String *params, 
              Cardinal *num_params)
{
}

static void 
MultiArm(Widget w, 
         XEvent *event, 
         String *params, 
         Cardinal *num_params)
{
}

void
_XmClearBCompatibility(Widget pb)
{
}


Widget
XmCreatePushButton(Widget parent,
		   char *name,
		   Arg *arglist,
		   Cardinal argcount)
{
    return XtCreateWidget(name,
			  xmPushButtonWidgetClass,
			  parent,
			  arglist,
			  argcount);
}
