/**
 *
 * $Id: DialogS.c,v 1.21 1996/04/30 23:59:15 toshok Exp $
 *
 * derived from Xt Vendor class.c 
 *
 * Copyright (C) 1995 Free Software Foundation, Inc.
 * Copyright 1989 Massachusetts Institute of Technology
 *
 * This file is part of the GNU LessTif Library.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **/

static char rcsid[] = "$Id: DialogS.c,v 1.21 1996/04/30 23:59:15 toshok Exp $";

/*
 * Define NO_NULL_REALIZE to make the shell have non-zero width/height before
 * realizing.
 */
#undef	NO_NULL_REALIZE
#define	FUNKY_REALIZE


#include <stdio.h>

#include <LTconfig.h>
#include <Xm/XmP.h>
#include <Xm/XmI.h>
#include <Xm/DebugUtil.h>
#include <Xm/DialogSP.h>
#include <X11/StringDefs.h>
#include <X11/ShellP.h>
#include <Xm/VendorSP.h>
#include <Xm/BulletinBP.h>
#include <Xm/DisplayP.h>
#include <Xm/XmI.h>

static void class_initialize();
static void class_part_initialize(WidgetClass class);
static void initialize(Widget request, Widget new, ArgList args, Cardinal *num_args);
static void initialize_posthook(Widget request, Widget new, ArgList args, Cardinal *num_args);
static void change_managed(Widget w);
static void InsertChild(Widget w);

static XmBaseClassExtRec _XmDialogSCoreClassExtRec = {
    /* next_extension            */ NULL,
    /* record_type               */ NULLQUARK,                             
    /* version                   */ XmBaseClassExtVersion,
    /* size                      */ sizeof(XmBaseClassExtRec),
    /* initialize_prehook        */ NULL, /* FIXME */
    /* set_values_prehook        */ NULL, /* FIXME */
    /* initialize_posthook       */ initialize_posthook,
    /* set_values_posthook       */ NULL, /* FIXME */
    /* secondary_object_class    */ NULL, /* FIXME */
    /* secondary_object_create   */ NULL, /* FIXME */
    /* get_secondary_resources   */ NULL, /* FIXME */
    /* fast_subclass             */ { 0 }, /* FIXME */
    /* get_values_prehook        */ NULL, /* FIXME */
    /* get_values_posthook       */ NULL, /* FIXME */
    /* class_part_init_prehook   */ NULL, /* FIXME */
    /* class_part_init_posthook  */ NULL, /* FIXME */
    /* ext_resources             */ NULL, /* FIXME */
    /* compiled_ext_resources    */ NULL, /* FIXME */
    /* num_ext_resources         */ 0, /* FIXME */
    /* use_sub_resources         */ FALSE, /* FIXME */
    /* widget_navigable          */ NULL, /* FIXME */
    /* focus_change              */ NULL, /* FIXME */
    /* wrapper_data              */ NULL
};

XmDialogShellClassRec xmDialogShellClassRec = {
    /* Core class part */
    {
	/* superclass            */ (WidgetClass) &transientShellClassRec,
        /* class_name            */ "DialogShell",
        /* size                  */ sizeof(XmDialogShellRec),
        /* class_initialize      */ class_initialize,
        /* class_part_initialize */ class_part_initialize,
        /* class_inited          */ FALSE,
        /* initialize            */ initialize,
      	/* initialize_hook       */ NULL,		
      	/* realize               */ XtInheritRealize,
      	/* actions               */ NULL,
      	/* num_actions           */ 0,
      	/* resources             */ NULL,
      	/* resource_count        */ 0,
      	/* xrm_class             */ NULLQUARK,
      	/* compress_motion       */ FALSE,
      	/* compress_exposure     */ TRUE,
      	/* compress_enterleave   */ FALSE,
      	/* visible_interest      */ FALSE,
      	/* destroy               */ NULL,
      	/* resize                */ XtInheritResize,
      	/* expose                */ NULL,
      	/* set_values            */ NULL,
      	/* set_values_hook       */ NULL,			
      	/* set_values_almost     */ XtInheritSetValuesAlmost,  
      	/* get_values_hook       */ NULL,
      	/* accept_focus          */ NULL,
      	/* intrinsics version    */ XtVersion,
      	/* callback offsets      */ NULL,
      	/* tm_table              */ XtInheritTranslations,
      	/* query_geometry        */ XtInheritQueryGeometry,
      	/* display_accelerator   */ NULL,
      	/* extension             */ (XtPointer)&_XmDialogSCoreClassExtRec
    },
    /* Composite Class Part */
    {
	/* geometry_manager */ XtInheritGeometryManager,
        /* change_managed   */ change_managed,
        /* insert_child     */ InsertChild,
        /* delete_child     */ XtInheritDeleteChild,
        /* extension        */ NULL
    },
    /* Shell Class Part */
    {
	/* extension */ NULL
    },
    /* WMShell Class Part*/
    {
	/* extension */ NULL
    },
    /* Vendor Shell Class */
    {
	/* extension */	NULL
    },
    /* TransientShell Class Part */
    {
	/* extension */ NULL
    },
    /* XmDialogShell Class Part */
    {
	/* extension */ NULL
    }
};

externaldef(xmdialogshellwidgetclass) WidgetClass xmDialogShellWidgetClass =
	(WidgetClass) (&xmDialogShellClassRec);

static void class_initialize()
{
    _XmDialogSCoreClassExtRec.record_type = XmQmotif;
}

static void class_part_initialize(WidgetClass widget_class)
{
    _XmFastSubclassInit(widget_class, XmDIALOG_SHELL_BIT);
}

static void 
initialize_posthook(Widget request, 
	   Widget new, 
	   ArgList args, 
	   Cardinal *num_args)
{
#ifdef	FUNKY_REALIZE
    /*
     * MLM:
     * Danny, this probably isn't right, but I've found code that depends
     * on it, or something related...  FIXME
     */

    XdbDebug(__FILE__, new, "InitializePostHook: size %d %d\n", XtWidth(new), XtHeight(new));

    if (XtWidth(new) == 0)
	XtWidth(new) = 1;
    if (XtHeight(new) == 0)
	XtHeight(new) = 1;
    XtRealizeWidget(new);
#endif
}

static void 
initialize(Widget request, 
	   Widget new, 
	   ArgList args, 
	   Cardinal *num_args)
{
#ifdef	notdef
/*
 * What is all this ???
 */
  XtInitializeWidgetClass(vendorShellWidgetClass);
  if(XtHeight(request) == 0){
    XtHeight(new) = 30;
  }
  if(XtWidth(request) ==0){
    XtWidth(new) = 50;
  }
#endif
}

static Widget
GetChild(Widget w)
{
	CompositeWidget		cw = (CompositeWidget)w;
	int			i;
	extern WidgetClass	xmVendorShellExtObjectClass;	/* FIX ME */
/*
 * LessTif implementation dependency : vendor shell extension objects must
 * be ignored
 */
	for (i=0; i<cw->composite.num_children; i++)
		if ((! XtIsSubclass(cw->composite.children[i], xmVendorShellExtObjectClass))
		 && (! XtIsSubclass(cw->composite.children[i], xmDisplayClass)))
			return cw->composite.children[i];
	return NULL;
}

static void 
change_managed(Widget w)
{
	XmDialogShellWidget	sw = (XmDialogShellWidget)w;
	Widget			child;
	XmBulletinBoardWidget	bb;
#ifdef	NO_NULL_REALIZE
	Dimension		ww, hh;
#endif

	child = GetChild(w);
	bb = (XmBulletinBoardWidget)child;

	XdbDebug2(__FILE__, w, child, "ChangeManaged\n");

	if (XtIsManaged(child)) {
	    XdbDebug2(__FILE__, w, child, "... was not managed\n");
	    if (! XtIsRealized(child)) {
		XdbDebug(__FILE__, child, "... Realizing\n");

#ifdef	NO_NULL_REALIZE
		ww = XtWidth(child);
		hh = XtHeight(child);
		XtWidth(child) = 1;
		XtHeight(child) = 1;
#endif

		XtRealizeWidget(child);

#ifdef	NO_NULL_REALIZE
		XtWidth(child) = ww;
		XtHeight(child) = hh;
#endif
	    }
	/* Do Sizing etc. here */
	    if (XtIsSubclass(child, xmBulletinBoardWidgetClass)) {
		XdbDebug(__FILE__, (Widget)bb, "MapCallback\n");
		_XmBbMap(child);
	    }

	/* Pick up child size */
	    (void) XtMakeResizeRequest(w, XtWidth(child), XtHeight(child), NULL, NULL);
	    XdbDebug2(__FILE__, w, child, "Shell size %d %d\n", XtWidth(child), XtHeight(child));

	    if (sw->core.mapped_when_managed) {
		XdbDebug(__FILE__, (Widget)sw, "XtPopup\n");
		XtPopup((Widget)sw, XtGrabNone);
	    }
	} else {
	    XdbDebug(__FILE__, (Widget)sw, "XtPopDown\n");
	    XtPopdown((Widget)sw);
	    if (XtIsSubclass(child, xmBulletinBoardWidgetClass)) {
		_XmBbUnmap(child);
		XdbDebug(__FILE__, (Widget)bb, "UnmapCallback\n");
	    }
	}
}



Widget
XmCreateDialogShell(Widget parent,
		    char *name,
		    Arg *arglist,
		    Cardinal argcount)
{
    Widget composite_parent;

    /* First we find the first widget (starting at the parent argument)
       that is a composite subclass. We use this as the parent when
       creating the shell */

    composite_parent = parent;
    while (!XtIsSubclass(composite_parent, compositeWidgetClass))
	composite_parent = XtParent(composite_parent);

    return XtCreatePopupShell(name,
			      xmDialogShellWidgetClass,
			      composite_parent,
			      arglist,
			      argcount);
}

String
_XmMakeDialogName(String name)
{
    String s;

    s = XtMalloc((name ? strlen(name) : 0) + strlen(XmDIALOG_SUFFIX) + 1);
    if (name)
        strcpy(s, name);
    else
        s[0] = '\0';
    strcat(s, XmDIALOG_SUFFIX);

    return s;
}

static void
InsertChild(Widget w)
{
	CompositeWidget	p = (CompositeWidget) XtParent(w);

#define superclass (&transientShellClassRec)    
    (*superclass->composite_class.insert_child)(w);
#undef superclass

	XdbDebug2(__FILE__, (Widget)p, w, "InsertChild\n");

/* Avoid nasty side effects with the shell extension object */
	if (XtIsSubclass(w, xmVendorShellExtObjectClass))
		return;

	if (! XtIsRealized((Widget)p)) {
		/* Avoid Xt errors on zero width/height here by
		 * temporarily setting p's width/height to 1 and
		 * restoring them after realize.
		 */
		Dimension	ww, hh;

		ww = XtWidth(p);
		hh = XtHeight(p);

		XtWidth(p) = XtHeight(p) = 1;

		XtRealizeWidget((Widget)p);

		XtWidth(p) = ww;
		XtHeight(p) = hh;
	}
}
