/**
 *
 * $Id: ScreenP.h,v 1.1 1996/01/08 06:42:20 toshok Exp $
 *
 * Copyright (C) 1995 Free Software Foundation, Inc.
 *
 * This file is part of the GNU LessTif Library.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **/
#ifndef _XM_SCREEN_P_H
#define _XM_SCREEN_P_H

#include <Xm/DesktopP.h>
#include <Xm/Screen.h>
#include <Xm/DragIcon.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef struct _XmScreenClassPart {
    XtPointer extension;
} XmScreenClassPart, *XmScreenClassPartPtr;

typedef struct _XmScreenClassRec {
    CoreClassPart core_class;
    XmDesktopClassPart desktop_class;
    XmScreenClassPart screen_class;
} XmScreenClassRec;

typedef struct _XmDragCursorRec {
    struct _XmDragCursorRec *next;
    Cursor cursor;
    XmDragIconObject stateIcon;
    XmDragIconObject opIcon;
    XmDragIconObject sourceIcon;
} XmDragCursorRec, *XmDragCursorCache;

typedef struct _XmScratchPixmapRec *XmScratchPixmap;

typedef struct _XmScratchPixmapRec {
    XmScratchPixmap next;
    Pixmap pixmap;
    Cardinal depth;
    Dimension width;
    Dimension height;
    Boolean inUse;
} XmScratchPixmapRec;

typedef struct {
    Boolean mwmPresent;
    unsigned short numReparented;
    int darkThreshold;
    int foregroundThreshold;
    int lightThreshold;
    XmDragIconObject defaultNoneCursorIcon;
    XmDragIconObject defaultValidCursorIcon;
    XmDragIconObject defaultInvalidCursorIcon;
    XmDragIconObject defaultMoveCursorIcon;
    XmDragIconObject defaultCopyCursorIcon;
    XmDragIconObject defaultLinkCursorIcon;
    XmDragIconObject defaultSourceCursorIcon;

    Cursor nullCursor;
    XmDragCursorRec *cursorCache;
    Cardinal maxCursorWidth;
    Cardinal maxCursorHeight;

    Cursor menuCursor;
    unsigned char unpostBehavior;
    XFontStruct *font_struct;
    int h_unit;
    int v_unit;
    XmScratchPixmap scratchPixmaps;
    unsigned char moveOpaque;

    XmDragIconObject xmStateCursorIcon;
    XmDragIconObject xmMoveCursorIcon;
    XmDragIconObject xmCopyCursorIcon;
    XmDragIconObject xmLinkCursorIcon;
    XmDragIconObject xmSourceCursorIcon;

    GC imageGC;
    int imageGCDepth;
    Pixel imageForeground;
    Pixel imageBackground;

    XtPointer screenInfo;
} XmScreenPart, *XmScreenPartPtr;

typedef struct _XmScreenInfo {
    XtPointer menu_state;
    Boolean destroyCallbackAdded;
} XmScreenInfo;

extern XmScreenClassRec xmScreenClassRec;

typedef struct _XmScreenRec {
    CorePart core;
    XmDesktopPart desktop;
    XmScreenPart screen;
} XmScreenRec;

extern XrmQuark _XmInvalidCursorIconQuark;
extern XrmQuark _XmValidCursorIconQuark;
extern XrmQuark _XmNoneCursorIconQuark;
extern XrmQuark _XmDefaultDragIconQuark;
extern XrmQuark _XmMoveCursorIconQuark;
extern XrmQuark _XmCopyCursorIconQuark;
extern XrmQuark _XmLinkCursorIconQuark;

/*
 * access macros
 */
#define Screen_Parent(w) \
    (((XmScreen)w)->desktop.parent)

#define Screen_Children(w) \
    (((XmScreen)w)->desktop.children)

#define Screen_NumChildren(w) \
    (((XmScreen)w)->desktop.num_children)

#define Screen_NumSlots(w) \
    (((XmScreen)w)->desktop.num_slots)

#define Screen_MwmPresent(w) \
    (((XmScreen)w)->screen.mwmPresent)

#define Screen_NumReparented(w) \
    (((XmScreen)w)->screen.numReparented)

#define Screen_DarkThreshold(w) \
    (((XmScreen)w)->screen.darkThreshold)

#define Screen_ForegroundThreshold(w) \
    (((XmScreen)w)->screen.foregroundThreshold)

#define Screen_LightThreshold(w) \
    (((XmScreen)w)->screen.lightThreshold)

#define Screen_DefaultNoneCursorIcon(w) \
    (((XmScreen)w)->screen.defaultNoneCursorIcon)

#define Screen_DefaultValidCursorIcon(w) \
    (((XmScreen)w)->screen.defaultValidCursorIcon)

#define Screen_DefaultInvalidCursorIcon(w) \
    (((XmScreen)w)->screen.defaultInvalidCursorIcon)

#define Screen_DefaultMoveCursorIcon(w) \
    (((XmScreen)w)->screen.defaultMoveCursorIcon)

#define Screen_DefaultCopyCursorIcon(w) \
    (((XmScreen)w)->screen.defaultCopyCursorIcon)

#define Screen_DefaultLinkCursorIcon(w) \
    (((XmScreen)w)->screen.defaultLinkCursorIcon)

#define Screen_DefaultSourceCursorIcon(w) \
    (((XmScreen)w)->screen.defaultSourceCursorIcon)

#define Screen_NullCursor(w) \
    (((XmScreen)w)->screen.nullCursor)

#define Screen_CursorCache(w) \
    (((XmScreen)w)->screen.cursorCache)

#define Screen_MaxCursorWidth(w) \
    (((XmScreen)w)->screen.maxCursorWidth)

#define Screen_MaxCursorHeight(w) \
    (((XmScreen)w)->screen.maxCursorHeight)

#define Screen_MenuCursor(w) \
    (((XmScreen)w)->screen.menuCursor)

#define Screen_UnpostBehavior(w) \
    (((XmScreen)w)->screen.unpostBehavior)

#define Screen_FontStruct(w) \
    (((XmScreen)w)->screen.font_struct)

#define Screen_HorizUnit(w) \
    (((XmScreen)w)->screen.h_unit)

#define Screen_VertUnit(w) \
    (((XmScreen)w)->screen.v_unit)

#define Screen_ScratchPixmaps(w) \
    (((XmScreen)w)->screen.scratchPixmaps)

#define Screen_MoveOpaque(w) \
    (((XmScreen)w)->screen.moveOpaque)

#define Screen_StateCursorIcon(w) \
    (((XmScreen)w)->screen.xmStateCursorIcon)

#define Screen_MoveCursorIcon(w) \
    (((XmScreen)w)->screen.xmMoveCursorIcon)

#define Screen_CopyCursorIcon(w) \
    (((XmScreen)w)->screen.xmCopyCursorIcon)

#define Screen_LinkCursorIcon(w) \
    (((XmScreen)w)->screen.xmLinkCursorIcon)

#define Screen_SourceCursorIcon(w) \
    (((XmScreen)w)->screen.xmSourceCursorIcon)

#define Screen_ImageGC(w) \
    (((XmScreen)w)->screen.imageGC)

#define Screen_ImageGCDepth(w) \
    (((XmScreen)w)->screen.imageGCDepth)

#define Screen_ImageForeground(w) \
    (((XmScreen)w)->screen.imageForeground)

#define Screen_ImageBackground(w) \
    (((XmScreen)w)->screen.imageBackground)

#define Screen_ScreenInfo(w) \
    (((XmScreen)w)->screen.screenInfo)

/*
 * protos
 */
extern XmDragIconObject _XmScreenGetOperationIcon(Widget w,
						  unsigned char operation);
extern XmDragIconObject _XmScreenGetStateIcon(Widget w, unsigned char state);
extern XmDragIconObject _XmScreenGetSourceIcon(Widget w);
extern Pixmap _XmAllocScratchPixmap(XmScreen xmScreen,
				    Cardinal depth,
				    Dimension width,
				    Dimension height);
extern void _XmFreeScratchPixmap(XmScreen xmScreen, Pixmap pixmap);
extern XmDragCursorCache * _XmGetDragCursorCachePtr(XmScreen xmScreen);
extern void _XmGetMaxCursorSize(Widget w,
				Dimension *width,
				Dimension *height);
extern Cursor _XmGetNullCursor(Widget w);
extern Cursor _XmGetMenuCursorByScreen(Screen *screen);
extern Boolean _XmGetMoveOpaqueByScreen(Screen *screen);
extern unsigned char _XmGetUnpostBehavior(Widget wid);
extern int _XmGetFontUnit(Screen *screen,
			  int dimension);
extern void _XmScreenRemoveFromCursorCache(XmDragIconObject icon);

#ifdef __cplusplus
}
#endif

#endif
