/**
 *
 * $Id: AtomMgrI.h,v 1.2 1995/10/06 09:06:25 toshok Exp $
 *
 * Copyright (C) 1995 Free Software Foundation, Inc.
 *
 * This file is part of the GNU LessTif Library.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **/

#ifndef XM_ATOMMGR_I
#define XM_ATOMMGR_I

#include <Xm/XmP.h>

#ifdef __cplusplus
extern "C" {
#endif

/*
 * Hey folks! This is internal stuff - so stay away from this! Even many
 * Motif distributions do not have this include file (depending on the
 * release level, I think...)
 */
typedef struct _XmAtomCacheEntryRec {
    String   AtomName;         /* primary key for NamesHashTable */
    Display *Dsp;              /* secondary key */
    Atom     AtomID;           /* primary key for AtomsHashTable */
} XmAtomCacheEntryRec, *XmAtomCacheEntry;

typedef struct _XmAtomCacheRec {
    unsigned int     InUse;    /* number of used entries in the hash table */
    unsigned int     HashMask; /* what bits do we count on?                */
    unsigned int     RehashValue;
    XmAtomCacheEntry Entries;
} XmAtomCacheRec, *XmAtomCache;

#ifdef XM_ATOM_CACHE
extern void _XmInternAtomAndName(Display *display, Atom atom, String name);
#endif

#ifdef __cplusplus
};
#endif

#endif /* XM_ATOMMGR_H */
