
/****************************************************************************
 * This module is all new
 * by Rob Nation
 * A little of it is borrowed from ctwm.
 * Copyright 1993 Robert Nation. No restrictions are placed on this code,
 * as long as the copyright notice is preserved
 ****************************************************************************/
/***********************************************************************
 *
 * mwm window-list popup code
 *
 ***********************************************************************/
#include "mwm.h"

/* I tried to include "limits.h" to get these values, but it
 * didn't work for some reason */
/* Minimum and maximum values a `signed int' can hold.  */
#define MY_INT_MIN (- MY_INT_MAX - 1)
#define MY_INT_MAX 2147483647

extern XContext MenuContext;
extern unsigned PopupCount;
extern MenuRoot *PopupTable[];

/***********************************************************************
 *
 *  Procedure:
 *	AddToMenu - add an item to a root menu
 *
 *  Returned Value:
 *	(MenuItem *)
 *
 *  Inputs:
 *	menu	- pointer to the root menu to add the item
 *	item	- the text to appear in the menu
 *	action	- the string to possibly execute
 *	func	- the numeric function
 *
 ***********************************************************************/
void
AddToMenu(MenuRoot * menu, char *item, char *item2, char *action, int func,
	  long func_val_1, long func_val_2, char unit_1, char unit_2)
{
    MenuItem       *tmp;
    int             width;


    if (item == NULL)
	return;
    tmp = (MenuItem *) XtMalloc(sizeof(MenuItem));
    if (menu->first == NULL) {
	menu->first = tmp;
	tmp->prev = NULL;
    }
    else {
	menu->last->next = tmp;
	tmp->prev = menu->last;
    }
    menu->last = tmp;

    tmp->item = item;
    if (item != (char *) 0) {
	scanForHotKey(tmp, AnyKey);
	tmp->strlen = strlen(item);
    }
    else
	tmp->strlen = 0;
    tmp->item2 = item2;
    if (item2)
	tmp->strlen2 = strlen(item2);
    else
	tmp->strlen2 = 0;

    tmp->menu = 0;

    if ((func == F_POPUP) || (func == F_FUNCTION)) {
	unsigned        i;

	if (action != (char *) 0) {
	    for (i = 0; i < PopupCount; i++)
		if (strcasecmp(PopupTable[i]->name, action) == 0) {
		    tmp->menu = PopupTable[i];
		    break;
		}
	}
	if (tmp->menu == (MenuRoot *) 0) {
	    yyerror("No popup menu %s.", action);
	    func = F_NOP;
	}
    }
    tmp->action = action;
    tmp->next = NULL;
    tmp->state = 0;
    tmp->func = func;
    tmp->val1 = func_val_1;
    tmp->val2 = func_val_2;
    if ((unit_1 == 'p') || (unit_1 == 'P'))
	tmp->val1_unit = 100;
    else
	tmp->val1_unit = Scr.d_width;
    if ((unit_2 == 'p') || (unit_2 == 'P'))
	tmp->val2_unit = 100;
    else
	tmp->val2_unit = Scr.d_height;

    width = XTextWidth(Scr.StdFont.font, item, tmp->strlen);
    if (tmp->func == F_POPUP)
	width += 15;
    if (width <= 0)
	width = 1;
    if (width > menu->width)
	menu->width = width;
    width = XTextWidth(Scr.StdFont.font, item2, tmp->strlen2);
    if (width < 0)
	width = 0;
    if (width > menu->width2)
	menu->width2 = width;
    if ((width == 0) && (tmp->strlen2 > 0))
	menu->width2 = 1;

    tmp->item_num = menu->items++;
}

/*
 * Change by PRB (pete@tecc.co.uk), 31/10/93.  Prepend a hot key
 * specifier to each item in the list.  This means allocating the
 * memory for each item (& freeing it) rather than just using the window
 * title directly.  */
void
do_windowList(int val1, int val2)
{
    MenuRoot       *mr;
    MenuItem       *mi, *tmp;
    MwmWindow      *t;
    char           *tname;
    char            loc[40], *name = NULL;
    int             dwidth, dheight;
    char            tlabel[50];
    int             last_desk_done = MY_INT_MIN;
    int             next_desk;

    char           *t_hot;	/* Menu label with hotkey added */
    char            scut = '0';	/* Current short cut key */

    sprintf(tlabel, "CurrentDesk: %d", Scr.CurrentDesk);
    mr = NewMenuRoot(tlabel);
    AddToMenu(mr, tlabel, "Geometry", NULL, F_TITLE, 0, 0, 's', 's');

    next_desk = 0;
    while (next_desk != MY_INT_MAX) {
	/* Sort window list by desktop number */
	if ((val1 < 2) && (val1 > -2)) {
	    next_desk = MY_INT_MAX;
	    for (t = Scr.MwmRoot.next; t != NULL; t = t->next) {
		if ((t->Desk > last_desk_done) && (t->Desk < next_desk))
		    next_desk = t->Desk;
	    }
	}
	else if ((val1 < 4) && (val1 > -4)) {
	    if (last_desk_done == MY_INT_MIN)
		next_desk = Scr.CurrentDesk;
	    else
		next_desk = MY_INT_MAX;
	}
	else {
	    if (last_desk_done == MY_INT_MIN)
		next_desk = val2;
	    else
		next_desk = MY_INT_MAX;
	}
	last_desk_done = next_desk;
	for (t = Scr.MwmRoot.next; t != NULL; t = t->next) {
	    if ((t->Desk == next_desk) &&
		(!(t->flags & WINDOWLISTSKIP))) {
		if (++scut == ('9' + 1))
		    scut = 'A';	/* Next shortcut key */
		if (val1 % 2 != 0)
		    name = t->icon_image;
		else
		    name = t->name;
		t_hot = XtMalloc(strlen(name) + 8);
		sprintf(t_hot, "%c.  %s", scut, name);		/* Generate label */

		tname = XtMalloc(40);
		tname[0] = 0;
		if (t->flags & ICONIFIED)
		    strcpy(tname, "(");
		sprintf(loc, "%d:", t->Desk);
		strcat(tname, loc);
		if (t->frame_x >= 0)
		    sprintf(loc, "+%d", t->frame_x);
		else
		    sprintf(loc, "%d", t->frame_x);
		strcat(tname, loc);
		if (t->frame_y >= 0)
		    sprintf(loc, "+%d", t->frame_y);
		else
		    sprintf(loc, "%d", t->frame_y);
		strcat(tname, loc);
		dheight = t->frame_height - t->title_height - 2 * t->boundary_width;
		dwidth = t->frame_width - 2 * t->boundary_width;

		dwidth -= t->hints.base_width;
		dheight -= t->hints.base_height;

		dwidth /= t->hints.width_inc;
		dheight /= t->hints.height_inc;

		sprintf(loc, "x%d", dwidth);
		strcat(tname, loc);
		sprintf(loc, "x%d", dheight);
		strcat(tname, loc);
		if (t->flags & ICONIFIED)
		    strcat(tname, ")");

		AddToMenu(mr, t_hot, tname, NULL, F_RAISE_IT,
			  (long) t, (long) (t->w), 's', 's');
	    }
	}
    }
    MakeMenu(mr);

    do_menu(mr);

    XDestroyWindow(dpy, mr->w);
    XDeleteContext(dpy, mr->w, MenuContext);
    /* need to free the window list ? */
    mi = mr->first;
    while (mi != NULL) {
	tmp = mi->next;
	if (mi->func != F_TITLE) {
	    if (mi->item != NULL)
		free(mi->item);
	    if (mi->item2 != NULL)
		free(mi->item2);
	}
	free(mi);
	mi = tmp;
    }
    free(mr);
}
