%{
/**
 *
 * $Id: mwmparse.y,v 1.11 1996/02/16 02:38:44 miers Exp $
 *
 * Copyright (C) 1995 Free Software Foundation, Inc.
 *
 * This file is part of the GNU LessTif Library.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **/
#include "mwm.h"
#include <ctype.h>
#include <stdlib.h>
#ifdef HAVE_FCNTL_H
#include <fcntl.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#ifdef HAVE_PWD_H
#include <pwd.h>
#endif
#ifdef HAVE_SYS_STAT_H
#include <sys/stat.h>
#endif
#include <X11/Xfuncs.h>
#include <X11/keysym.h>

/*
 * this is OS dependent, but this should catch most
 */
#define MAX_PATH_LEN	2048

extern int yydebug;
extern char yytext[];

void yyerror(char *fmt, ...);

char           *IconPath = MWM_ICONDIR;
#ifdef XPM
char           *PixmapPath = MWM_ICONDIR;
#endif

void            initialize_pager(int x, int y);
static int      pager_x = 10000, pager_y = 10000;

MenuRoot       *NewMenuRoot(char *name);
void		scanForHotKey(MenuItem *, KeySym);

unsigned        PopupCount = 0;
MenuRoot       *PopupTable[MAXPOPUPS];
int             dummy;

extern XContext MenuContext;	/* context for mwm menus */
extern Bool     DoHandlePageing;

/* value for the rubberband XORing */
unsigned long   XORvalue;
int             have_the_colors = 0;

static int num_items;
static MenuRoot *cur_menu;
static int AltMask;

%}
%token  ALT_TOK
	APP_TOK
	BACK_TOK
	BORDER_TOK
	BTN1_CLICK2_TOK
	BTN1_CLICK_TOK
	BTN1_DOWN_TOK
	BTN1_UP_TOK
	BTN2_CLICK2_TOK
	BTN2_CLICK_TOK
	BTN2_DOWN_TOK
	BTN2_UP_TOK
	BTN3_CLICK2_TOK
	BTN3_CLICK_TOK
	BTN3_DOWN_TOK
	BTN3_UP_TOK
	BTN4_CLICK2_TOK
	BTN4_CLICK_TOK
	BTN4_DOWN_TOK
	BTN4_UP_TOK
	BTN5_CLICK2_TOK
	BTN5_CLICK_TOK
	BTN5_DOWN_TOK
	BTN5_UP_TOK
	BUTTONS_TOK
	CTRL_TOK
	FBEEP_TOK
	FCIRCLE_DOWN_TOK
	FCIRCLE_UP_TOK
	FEXEC_TOK
	FFOCUS_COLOR_TOK
	FFOCUS_KEY_TOK
	FKILL_TOK
	FLOWER_TOK
	FMAXIMIZE_TOK
	FMENU_TOK
	FMINIMIZE_TOK
	FMOVE_TOK
	FNEXT_CMAP_TOK
	FNEXT_KEY_TOK
	FNOP_TOK
	FNORMALIZE_TOK
	FNORMANDRAISE_TOK
	FPACK_ICONS_TOK
	FPASS_KEYS_TOK
	FPOST_WMENU_TOK
	FPREV_CMAP_TOK
	FPREV_KEY_TOK
	FQUIT_MWM_TOK
	FRAISE_LOWER_TOK
	FRAISE_TOK
	FRAME_TOK
	FREE_FAMILY_TOK
	FREFRESH_TOK
	FREFRESH_WIN_TOK
	FRESIZE_TOK
	FRESTART_TOK
	FRESTOREANDRAISE_TOK
	FRESTORE_TOK
	FSCREEN_TOK
	FSEND_MSG_TOK
	FSEPARATOR_TOK
	FSET_BEHAVIOR_TOK
	FTITLE_TOK
	FWINDOWLIST_TOK
	FDESK_TOK
	FTOGGLE_PAGE_TOK
	FGOTO_PAGE_TOK
	ICON_TOK
	KEY_TOK
	KEYS_TOK
	LOCK_TOK
	MENU_TOK
	MENUB_TOK
	MINIMIZEB_TOK
	MAXIMIZEB_TOK
	MOD1_TOK
	MOD2_TOK
	MOD3_TOK
	MOD4_TOK
	MOD5_TOK
	NEXT_TOK
	PREV_TOK
	ROOT_TOK
	SHIFT_TOK
	TITLE_TOK
	TRANSIENT_TOK
	WINDOW_TOK
	WITHIN_TOK
	STRING_TOK
	NEWLINE_TOK

%type <string>
	STRING_TOK

%type <number>
	FCIRCLE_DOWN_TOK
	FCIRCLE_UP_TOK
	FEXEC_TOK
	FFOCUS_COLOR_TOK
	FFOCUS_KEY_TOK
	FKILL_TOK
	FLOWER_TOK
	FMAXIMIZE_TOK
	FMENU_TOK
	FMINIMIZE_TOK
	FMOVE_TOK
	FNEXT_CMAP_TOK
	FNEXT_KEY_TOK
	FNOP_TOK
	FNORMALIZE_TOK
	FNORMANDRAISE_TOK
	FPACK_ICONS_TOK
	FPASS_KEYS_TOK
	FPOST_WMENU_TOK
	FPREV_CMAP_TOK
	FPREV_KEY_TOK
	FQUIT_MWM_TOK
	FRAISE_LOWER_TOK
	FRAISE_TOK
	FRAME_TOK
	FREE_FAMILY_TOK
	FREFRESH_TOK
	FREFRESH_WIN_TOK
	FRESIZE_TOK
	FRESTART_TOK
	FRESTOREANDRAISE_TOK
	FRESTORE_TOK
	FSCREEN_TOK
	FSEND_MSG_TOK
	FSEPARATOR_TOK
	FSET_BEHAVIOR_TOK
	FTITLE_TOK
	ICON_TOK

%type <string>
	bitmap_file
	string

%type <label>
	label

%type <number>
	context
	object

%type <function>
	function

%type <modifiers>
	modifier_name
	modifier_list

%type <hotkey>
	key

%union {
    char	*string;
    int		number;
    KeySym	key;
    struct {
	int func;
	char *arg;
    } function;
    struct {
	int type;
	char *string;
    } label;
    long	modifiers;
    struct {
	int button;
	int event;
	int count;
	int modifiers;
    } button;
    struct {
	int modifiers;
	KeySym key;
    } hotkey;
};

%%
res_file:		res_file button_binding
	|		res_file key_binding
	|		res_file menu_pane
	|		res_file NEWLINE_TOK
	|		button_binding
	|		key_binding
	|		menu_pane
	|		NEWLINE_TOK
;

button_binding:		BUTTONS_TOK string NEWLINE_TOK
			'{' NEWLINE_TOK button_list '}' NEWLINE_TOK
;

button_list:		button_list button context function NEWLINE_TOK
			{
			    int contexts = $<number>3;
			    int i, j, mods, func;
			    char *ptr = NULL;
			    MenuRoot *mr = NULL;
			    MenuItem *mi = NULL;
			    MouseButton *temp = NULL;

			    mods = $<button>2.modifiers;
			    if ((contexts & C_WINDOW) &&
				(((mods == 0) || mods == AnyModifier))) {
			        Scr.buttons2grab &= ~($<button>2.button);
			    }
			
			    func = $<function>4.func;

			    if ((func == F_POPUP) || (func == F_FUNCTION) ||
				(func == F_W_POPUP)) {
			        unsigned        i;

			        ptr = $<function>4.arg;
				if (func == F_W_POPUP) {
				    func = F_POPUP;
				    if (strlen(ptr) == 0)
					ptr = "DefaultWindowMenu";
				}
			        if (ptr != NULL)
			            for (i = 0; i < PopupCount; i++)
			                if (strcmp(PopupTable[i]->name, ptr)
					     == 0) {
			                    mr = PopupTable[i];
			                    break;
			                }
			        if (!mr) {
				    yyerror("Popup '%s' not defined", ptr);
			            func = F_NOP;
			        }
			    }
			    else if ((func == F_EXEC) ||
				     (func == F_RESTART) ||
			             (func == F_CIRCULATE_UP) ||
				     (func == F_CIRCULATE_DOWN) ||
			             (func == F_WARP)) {
			        mi = (MenuItem *)XtMalloc(sizeof(MenuItem));
			
			        mi->next = (MenuItem *) NULL;
			        mi->prev = (MenuItem *) NULL;
			        mi->item_num = 0;
			        if ((func == F_EXEC) || (func == F_RESTART)) {
			            mi->item = strdup("DOIT");
			            mi->action = $<function>4.arg;
			        }
			        else {
			            mi->item = strdup("DONT DOIT");
			            mi->action = $<function>4.arg;
			        }
				mi->item2 = "";
			        mi->state = 0;
			        mi->func = func;
			        mi->strlen = strlen(mi->item);
				mi->strlen2 = 0;
			        mi->val1 = 0;
			        mi->val2 = 0;
			        mi->val1_unit = 1;
			        mi->val2_unit = 1;
			    }

			    temp = Scr.MouseButtonRoot;
			    Scr.MouseButtonRoot =
				(MouseButton *)XtMalloc(sizeof(MouseButton));
			    Scr.MouseButtonRoot->func = func;
			    Scr.MouseButtonRoot->menu = mr;
			    Scr.MouseButtonRoot->item = mi;
			    Scr.MouseButtonRoot->Button =
				ffs($<button>2.button) - 8;
			    Scr.MouseButtonRoot->Context = contexts;
			    Scr.MouseButtonRoot->Modifier = mods;
			    Scr.MouseButtonRoot->NextButton = temp;
			    Scr.MouseButtonRoot->val1 = 0;
			    Scr.MouseButtonRoot->val2 = 0;
			    Scr.MouseButtonRoot->val1_unit = Scr.d_width;
			    Scr.MouseButtonRoot->val2_unit = Scr.d_height;
			}
	|		NEWLINE_TOK
			{ /* embedded blank line */ }
	|
;

key_binding:		KEYS_TOK string NEWLINE_TOK
			'{' NEWLINE_TOK key_list '}' NEWLINE_TOK
;

key_list:		key_list key context function NEWLINE_TOK
			{
			    MenuRoot *mr = NULL;
			    FuncKey        *tmp = NULL;
			    KeySym          keysym;
			    KeyCode         keycode;
			    int             i, min, max;
			    int func, contexts;
			    char *ptr;

			    ptr = $<function>4.arg;
			    func = $<function>4.func;
			    contexts = $<number>3;

			    /* Make CirculateUp and CirculateDown
			     * take args. by Y.NOMURA */

			    if ((func == F_POPUP) || (func == F_W_POPUP) ||
			 	(func == F_FUNCTION)) {
				unsigned        i;
			
				if (func == F_W_POPUP) {
				    func = F_POPUP;
				    if (strlen(ptr) == 0)
					ptr = "DefaultWindowMenu";
				}
				if (ptr != NULL) {
				    for (i = 0; i < PopupCount; i++)
					if (strcmp(PopupTable[i]->name,
						   ptr) == 0) {
					    mr = PopupTable[i];
					    break;
					}
				}
				if (!mr) {
				    yyerror("Popup '%s' not defined", ptr);
				    func = F_NOP;
				}
			    }
			
			    /*
			     * Don't let a 0 keycode go through, since that
			     * means AnyKey to the XGrabKey call in GrabKeys().
			     */
			    keysym = $<hotkey>2.key;
			    if (keysym == 0)
				break;
			    if ((keycode = XKeysymToKeycode(dpy, $<hotkey>2.key)) == 0)
				break;

			    XDisplayKeycodes(dpy, &min, &max);
			    for (i = min; i <= max; i++) {
				if (XKeycodeToKeysym(dpy, i, 0) == keysym) {
				    tmp = (FuncKey *)XtMalloc(sizeof(FuncKey));
				    tmp->next = Scr.FuncKeyRoot.next;
				    Scr.FuncKeyRoot.next = tmp;

				    tmp->name = "HOTKEY";
				    tmp->keycode = i;
				    tmp->cont = contexts;
				    tmp->mods = $<hotkey>2.modifiers;
				    tmp->func = func;
				    tmp->action = ptr;
				    tmp->val1 = 0;
				    tmp->val2 = 0;
				    tmp->val1_unit = Scr.d_width;
				    tmp->val2_unit = Scr.d_height;
				    tmp->menu = mr;
				}
			    }
			}
	|		NEWLINE_TOK
			{ /* embedded blank line */ }
	|
;

menu_pane:		MENU_TOK string NEWLINE_TOK
			{
			    num_items = 0;
			    cur_menu = NewMenuRoot($<string>2);
			}
			'{' NEWLINE_TOK item_list '}' NEWLINE_TOK
			{
			    if (PopupCount < MAXPOPUPS) {
				PopupTable[PopupCount] = cur_menu;
				PopupCount++;
				if (strcmp(cur_menu->name,
					   "InitFunction") == 0) {
				    Scr.InitFunction = cur_menu;
				}
				else if (strcmp(cur_menu->name,
						"RestartFunction") == 0) {
				    Scr.RestartFunction = cur_menu;
				}
			    }
			    else {
				yyerror("Popup/Function %s ignored.");
				yyerror("You have more than %u\n",
					cur_menu->name, MAXPOPUPS);
				XtFree((char *)cur_menu);
			    }
			    MakeMenu(cur_menu);
			}
;

item_list:		item_list label mnemonic menu_key function NEWLINE_TOK
			{
			    MenuItem *tmp;
			    MenuRoot *mr = NULL;
			    int width;
			    FuncKey        *tmpk = NULL;
			    KeySym          keysym;
			    KeyCode         keycode;
			    int             i, min, max;
			    int func, contexts;
			    char *ptr;

			    tmp = (MenuItem *)XtMalloc(sizeof(MenuItem));
			    if (cur_menu->first == NULL) {
				cur_menu->first = tmp;
				tmp->prev = NULL;
				tmp->next = NULL;
			    }
			    else {
				cur_menu->last->next = tmp;
				tmp->prev = cur_menu->last;
			    }
			    cur_menu->last = tmp;

			    if ($<function>5.func == F_NOP)
				tmp->item = "";
			    else
				tmp->item = $<label>2.string;
			    tmp->item2 = "";
			    scanForHotKey(tmp, $<key>3);
			    if (strcmp(tmp->item, "no-label") == 0)
				tmp->strlen = 0;
			    else
				tmp->strlen = strlen(tmp->item);
			    tmp->strlen2 = 0;

			    if (($<function>5.func == F_POPUP) ||
				($<function>5.func == F_FUNCTION)) {
				unsigned i;

				for (i = 0; i < PopupCount; i++) {
				    if (strcmp(PopupTable[i]->name, $<function>5.arg)
					== 0) {
					tmp->menu = PopupTable[i];
					break;
				    }
				}
				if (tmp->menu == NULL) {
				    yyerror("Can't find requested menu: %s",
					    $<function>5.arg);
				    $<function>5.func = F_NOP;
				}
			    }
			    tmp->action = $<function>5.arg;
			    tmp->next = NULL;
			    tmp->state = 0;
			    tmp->func = $<function>5.func;
			    tmp->val1 = 0;
			    tmp->val2 = 0;
			    tmp->val1_unit = Scr.d_width;
			    tmp->val2_unit = Scr.d_height;
			
			    width = XTextWidth(Scr.StdFont.font, tmp->item, tmp->strlen);
			    if (tmp->func == F_POPUP)
			        width += 15;
			    if (width <= 0)
			        width = 1;
			    if (width > cur_menu->width)
			        cur_menu->width = width;

			    tmp->item_num = cur_menu->items++;

			    ptr = $<function>5.arg;
			    func = $<function>5.func;
			    contexts = C_WINDOW|C_FRAME|C_TITLE|C_LALL|C_RALL|
				       C_SIDEBAR;

			    /* Make CirculateUp and CirculateDown
			     * take args. by Y.NOMURA */
			    if ((func == F_POPUP) || (func == F_FUNCTION)) {
				unsigned        i;
			
				if (ptr != NULL) {
				    for (i = 0; i < PopupCount; i++)
					if (strcmp(PopupTable[i]->name,
						   ptr) == 0) {
					    mr = PopupTable[i];
					    break;
					}
				}
				if (!mr) {
				    yyerror("Popup '%s' not defined", ptr);
				    func = F_NOP;
				}
			    }
			
			    /*
			     * Don't let a 0 keycode go through, since that
			     * means AnyKey to the XGrabKey call in GrabKeys().
			     */
			    keysym = $<hotkey>4.key;
			    if (keysym == 0)
				break;
			    if ((keycode = XKeysymToKeycode(dpy, $<hotkey>4.key)) == 0)
				break;

			    XDisplayKeycodes(dpy, &min, &max);
			    for (i = min; i <= max; i++) {
				if (XKeycodeToKeysym(dpy, i, 0) == keysym) {
				    tmpk = (FuncKey *)XtMalloc(sizeof(FuncKey));
				    tmpk->next = Scr.FuncKeyRoot.next;
				    Scr.FuncKeyRoot.next = tmpk;

				    tmpk->name = "HOTKEY";
				    tmpk->keycode = i;
				    tmpk->cont = contexts;
				    tmpk->mods = $<hotkey>4.modifiers;
				    tmpk->func = func;
				    tmpk->action = ptr;
				    tmpk->val1 = 0;
				    tmpk->val2 = 0;
				    tmpk->val1_unit = Scr.d_width;
				    tmpk->val2_unit = Scr.d_height;
				    tmpk->menu = mr;
				}
			    }
			}
	|		NEWLINE_TOK
			{ /* embedded blank line */ }
	|
;

menu_key:		key
			{ $<hotkey>$ = $<hotkey>1; }
	|
			{ $<hotkey>$.modifiers = 0; $<hotkey>$.key = 0; }
;

context:		context '|' object
			{ $<number>$ = $1 | $3; }
	|		object
			{ $<number>$ = $1; }
;

object:			ROOT_TOK
			{ $<number>$ = C_ROOT; }
	|		ICON_TOK
			{ $<number>$ = C_ICON; }
	|		MENUB_TOK
			{ $<number>$ = C_MENUB; }
	|		MINIMIZEB_TOK
			{ $<number>$ = C_MINIMIZEB; }
	|		MAXIMIZEB_TOK
			{ $<number>$ = C_MAXIMIZEB; }
	|		WINDOW_TOK
			{ $<number>$ = C_WINDOW|C_FRAME|C_TITLE|C_LALL|C_RALL|C_SIDEBAR; }
	|		TITLE_TOK
			{ $<number>$ = C_TITLE; }
	|		FRAME_TOK
			{ $<number>$ = C_FRAME|C_LALL|C_RALL|C_TITLE|C_SIDEBAR; }
	|		BORDER_TOK
			{ $<number>$ = C_FRAME|C_SIDEBAR; }
	|		APP_TOK
			{ $<number>$ = C_ALL; }
	|		error
			{
			    printf("Invalid object: %d\n", yylval);
			    $<number>$ = 0;
			}
;

button:			modifier_list '<' button_event_name '>'
			{
			    $<button>$ = $<button>3;
			    $<button>$.modifiers = $1;
			}
	|		'<' button_event_name '>'
			{
			    $<button>$ = $<button>2;
			    $<button>$.modifiers = 0;
			}
;

key:			modifier_list '<' KEY_TOK '>' STRING_TOK
			{
			    $<hotkey>$.modifiers = $<modifiers>1;
			    $<hotkey>$.key = XStringToKeysym($<string>5);
			}
;

modifier_list:		modifier_list modifier_name
			{ $<modifiers>$ = $1 | $2; }
	|		modifier_name
			{ $<modifiers>$ = $1; }
;

modifier_name:		CTRL_TOK
			{ $<modifiers>$ = ControlMask; }
	|		SHIFT_TOK
			{ $<modifiers>$ = ShiftMask; }
	|		ALT_TOK
			{ $<modifiers>$ = AltMask; }
	|		LOCK_TOK
			{ $<modifiers>$ = LockMask; }
	|		MOD1_TOK
			{ $<modifiers>$ = Mod1Mask; }
	|		MOD2_TOK
			{ $<modifiers>$ = Mod2Mask; }
	|		MOD3_TOK
			{ $<modifiers>$ = Mod3Mask; }
	|		MOD4_TOK
			{ $<modifiers>$ = Mod4Mask; }
	|		MOD5_TOK
			{ $<modifiers>$ = Mod5Mask; }
	|		error
			{ printf("Invalid modifier: %d\n", yylval); }
;

button_event_name:	BTN1_DOWN_TOK
			{
			    $<button>$.button = Button1Mask;
			    $<button>$.event = ButtonPressMask;
			    $<button>$.count = 1;
			}
	|		BTN1_UP_TOK
			{
			    $<button>$.button = Button1Mask;
			    $<button>$.event = ButtonReleaseMask;
			    $<button>$.count = 1;
			}
	|		BTN1_CLICK_TOK
			{
			    $<button>$.button = Button1Mask;
			    $<button>$.event = ButtonPressMask|ButtonReleaseMask;
			    $<button>$.count = 1;
			}
	|		BTN1_CLICK2_TOK
			{
			    $<button>$.button = Button1Mask;
			    $<button>$.event = ButtonPressMask|ButtonReleaseMask;
			    $<button>$.count = 1;
			}
	|		BTN2_DOWN_TOK
			{
			    $<button>$.button = Button2Mask;
			    $<button>$.event = ButtonPressMask;
			    $<button>$.count = 1;
			}
	|		BTN2_UP_TOK
			{
			    $<button>$.button = Button2Mask;
			    $<button>$.event = ButtonReleaseMask;
			    $<button>$.count = 1;
			}
	|		BTN2_CLICK_TOK
			{
			    $<button>$.button = Button2Mask;
			    $<button>$.event = ButtonPressMask|ButtonReleaseMask;
			    $<button>$.count = 1;
			}
	|		BTN2_CLICK2_TOK
			{
			    $<button>$.button = Button2Mask;
			    $<button>$.event = ButtonPressMask|ButtonReleaseMask;
			    $<button>$.count = 1;
			}
	|		BTN3_DOWN_TOK
			{
			    $<button>$.button = Button3Mask;
			    $<button>$.event = ButtonPressMask;
			    $<button>$.count = 1;
			}
	|		BTN3_UP_TOK
			{
			    $<button>$.button = Button3Mask;
			    $<button>$.event = ButtonReleaseMask;
			    $<button>$.count = 1;
			}
	|		BTN3_CLICK_TOK
			{
			    $<button>$.button = Button3Mask;
			    $<button>$.event = ButtonPressMask|ButtonReleaseMask;
			    $<button>$.count = 1;
			}
	|		BTN3_CLICK2_TOK
			{
			    $<button>$.button = Button3Mask;
			    $<button>$.event = ButtonPressMask|ButtonReleaseMask;
			    $<button>$.count = 1;
			}
	|		BTN4_DOWN_TOK
			{
			    $<button>$.button = Button4Mask;
			    $<button>$.event = ButtonPressMask;
			    $<button>$.count = 1;
			}
	|		BTN4_UP_TOK
			{
			    $<button>$.button = Button4Mask;
			    $<button>$.event = ButtonReleaseMask;
			    $<button>$.count = 1;
			}
	|		BTN4_CLICK_TOK
			{
			    $<button>$.button = Button4Mask;
			    $<button>$.event = ButtonPressMask|ButtonReleaseMask;
			    $<button>$.count = 1;
			}
	|		BTN4_CLICK2_TOK
			{
			    $<button>$.button = Button4Mask;
			    $<button>$.event = ButtonPressMask|ButtonReleaseMask;
			    $<button>$.count = 1;
			}
	|		BTN5_DOWN_TOK
			{
			    $<button>$.button = Button5Mask;
			    $<button>$.event = ButtonPressMask;
			    $<button>$.count = 1;
			}
	|		BTN5_UP_TOK
			{
			    $<button>$.button = Button5Mask;
			    $<button>$.event = ButtonReleaseMask;
			    $<button>$.count = 1;
			}
	|		BTN5_CLICK_TOK
			{
			    $<button>$.button = Button5Mask;
			    $<button>$.event = ButtonPressMask|ButtonReleaseMask;
			    $<button>$.count = 1;
			}
	|		BTN5_CLICK2_TOK
			{
			    $<button>$.button = Button5Mask;
			    $<button>$.event = ButtonPressMask|ButtonReleaseMask;
			    $<button>$.count = 2;
			}
	|		error
			{ printf("Invalid button event: %d\n", yylval); }
;

label:			string
			{ $<label>$.type = IS_STRING; $<label>$.string = $1; }
	|		bitmap_file
			{ $<label>$.type = IS_BITMAP; $<label>$.string = $1; }
;

bitmap_file:		'@' string
			{ $<string>$ = $2; }
;

mnemonic:		'_' string
			{
			    if (strlen($<string>2) != 1) {
				yyerror("Invalid mnemonic specification: '%s'.",
					$<string>2);
				$<key>$ = 0;
			    }
			    else {
				$<key>$ = XStringToKeysym($<string>2);
			    }
			}
	|
			{ $<key>$ = 0; }
;

function:		FBEEP_TOK
			{
			    $<function>$.func = F_BEEP;
			    $<function>$.arg = "";
			}
	|		FCIRCLE_DOWN_TOK arg
			{
			    $<function>$.func = F_CIRCULATE_DOWN;
			    $<function>$.arg = $<string>2;
			}
	|		FCIRCLE_UP_TOK arg
			{
			    $<function>$.func = F_CIRCULATE_UP;
			    $<function>$.arg = $<string>2;
			}
	|		FEXEC_TOK required_arg
			{
			    $<function>$.func = F_EXEC;
			    $<function>$.arg = $<string>2;
			}
	|		FFOCUS_COLOR_TOK
			{
			    $<function>$.func = F_NOP;
			    $<function>$.arg = "";
			}
	|		FFOCUS_KEY_TOK
			{
			    $<function>$.func = F_NOP;
			    $<function>$.arg = "";
			}
	|		FKILL_TOK
			{
			    $<function>$.func = F_DESTROY;
			    $<function>$.arg = "";
			}
	|		FLOWER_TOK arg
			{
			    $<function>$.func = F_LOWER;
			    $<function>$.arg = $<string>2;
			}
	|		FMAXIMIZE_TOK
			{
			    $<function>$.func = F_MAXIMIZE;
			    $<function>$.arg = "";
			}
	|		FMENU_TOK arg
			{
			    $<function>$.func = F_POPUP;
			    $<function>$.arg = $<string>2;
			}
	|		FMINIMIZE_TOK
			{
			    $<function>$.func = F_ICONIFY;
			    $<function>$.arg = "";
			}
	|		FMOVE_TOK
			{
			    $<function>$.func = F_MOVE;
			    $<function>$.arg = "";
			}
	|		FNEXT_CMAP_TOK
			{
			    $<function>$.func = F_NOP;
			    $<function>$.arg = "";
			}
	|		FNEXT_KEY_TOK arg
			{
			    $<function>$.func = F_NOP;
			    $<function>$.arg = $<string>2;
			}
	|		FNOP_TOK
			{
			    $<function>$.func = F_NOP;
			    $<function>$.arg = "";
			}
	|		FNORMALIZE_TOK
			{
			    $<function>$.func = F_NOP;
			    $<function>$.arg = "";
			}
	|		FNORMANDRAISE_TOK
			{
			    $<function>$.func = F_NOP;
			    $<function>$.arg = "";
			}
	|		FPACK_ICONS_TOK
			{
			    $<function>$.func = F_NOP;
			    $<function>$.arg = "";
			}
	|		FPASS_KEYS_TOK
			{
			    $<function>$.func = F_NOP;
			    $<function>$.arg = "";
			}
	|		FPOST_WMENU_TOK arg
			{
			    $<function>$.func = F_W_POPUP;
			    $<function>$.arg = $<string>2;
			}
	|		FPREV_CMAP_TOK
			{
			    $<function>$.func = F_NOP;
			    $<function>$.arg = "";
			}
	|		FPREV_KEY_TOK arg
			{
			    $<function>$.func = F_NOP;
			    $<function>$.arg = $<string>2;
			}
	|		FQUIT_MWM_TOK
			{
			    $<function>$.func = F_QUIT;
			    $<function>$.arg = "";
			}
	|		FRAISE_TOK arg
			{
			    $<function>$.func = F_RAISE;
			    $<function>$.arg = $<string>2;
			}
	|		FRAISE_LOWER_TOK arg
			{
			    $<function>$.func = F_RAISELOWER;
			    $<function>$.arg = $<string>2;
			}
	|		FREFRESH_TOK
			{
			    $<function>$.func = F_NOP;
			    $<function>$.arg = "";
			}
	|		FREFRESH_WIN_TOK
			{
			    $<function>$.func = F_NOP;
			    $<function>$.arg = "";
			}
	|		FRESIZE_TOK
			{
			    $<function>$.func = F_RESIZE;
			    $<function>$.arg = "";
			}
	|		FRESTORE_TOK
			{
			    $<function>$.func = F_ICONIFY;
			    $<function>$.arg = "";
			}
	|		FRESTOREANDRAISE_TOK
			{
			    $<function>$.func = F_NOP;
			    $<function>$.arg = "";
			}
	|		FRESTART_TOK
			{
			    $<function>$.func = F_RESTART;
			    $<function>$.arg = "";
			}
	|		FSCREEN_TOK arg
			{
			    $<function>$.func = F_NOP;
			    $<function>$.arg = $<string>2;
			}
	|		FSEND_MSG_TOK arg
			{
			    $<function>$.func = F_NOP;
			    $<function>$.arg = $<string>2;
			}
	|		FSEPARATOR_TOK
			{
			    $<function>$.func = F_NOP;
			    $<function>$.arg = "";
			}
	|		FSET_BEHAVIOR_TOK
			{
			    $<function>$.func = F_NOP;
			    $<function>$.arg = "";
			}
	|		FTITLE_TOK
			{
			    $<function>$.func = F_TITLE;
			    $<function>$.arg = "";
			}
	|		FWINDOWLIST_TOK
			{
			    $<function>$.func = F_WINDOWLIST;
			    $<function>$.arg = "";
			}
	|		error
			{
			    yyerror("Invalid function: %s\n", yytext);
			    $<function>$.func = F_NOP;
			    $<function>$.arg = "";
			}
;

arg:			required_arg
			{ $<string>$ = $<string>1; }
	|
			{ $<string>$ = ""; }
;

required_arg:		'-' string
			{ $<string>$ = $<string>2; }
	|		ROOT_TOK
			{ $<string>$ = "ROOT"; }
	|		WINDOW_TOK
			{ $<string>$ = "WINDOW"; }
	|		TRANSIENT_TOK
			{ $<string>$ = "TRANSIENT"; }
	|		ICON_TOK
			{ $<string>$ = "ICON"; }
	|		WITHIN_TOK
			{ $<string>$ = "WITHIN"; }
	|		FREE_FAMILY_TOK
			{ $<string>$ = "FREE_FAMILY"; }
	|		NEXT_TOK
			{ $<string>$ = "NEXT"; }
	|		PREV_TOK
			{ $<string>$ = "PREV"; }
	|		BACK_TOK
			{ $<string>$ = "BACK"; }
	|		string
			{ $<string>$ = $1; }
;
string:			STRING_TOK
			{ $<string>$ = $<string>1; }
	|		error
			{ yyerror("Invalid string: %s\n", yytext); }
;
%%
#ifdef __STDC__
#include <stdarg.h>
#else
#include <varargs.h>
#endif

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#ifdef HAVE_SYS_STAT_H
#include <sys/stat.h>
#endif
#ifdef HAVE_FCNTL_H
#include <fcntl.h>
#endif

/*
 * Find out what the Alt key is.  This code came from libXm/VirtKeys.
 */
static void
GetModifierMapping(Display *Dsp) {
    XModifierKeymap *mk;
    KeySym           ModifierKeysym;
    int              ModifierSet, SetIndex, SetSize;
    
    /*
     * Ask the server for the current modifier mapping and parse it for
     * the META and ALT keysyms. If one of them is bound to a modifier,
     * then remember the mask of that modifier.
     */
    mk = XGetModifierMapping(Dsp);
    SetSize        = mk->max_keypermod;

    for (ModifierSet = 0; ModifierSet < 8; ModifierSet++) {
        for (SetIndex = 0; SetIndex < SetSize; SetIndex++) {
            ModifierKeysym =
		XKeycodeToKeysym(Dsp,
				 mk->modifiermap[SetIndex+ModifierSet*SetSize],
                                 0);
            switch (ModifierKeysym) {
                /*
                 * If we've found one of the well known modifier keysyms,
                 * we'll remember the modifier - but only if we havn't yet
                 * seen another one.
                 */
                case XK_Meta_L: case XK_Meta_R:
                    AltMask = 1L << ModifierSet;
                    return;
                case XK_Alt_L: case XK_Alt_R:
                    AltMask = 1L << ModifierSet;
                    return;
            }
        }
    }
    /*
     * And don't forget to clean up, we don't want to waste memory here --
     * because we're not the Closed Software Foundation! And then a last
     * paranoic checking for missing ALT modifiers...
     */
    XFreeModifiermap(mk);
    AltMask = Mod1Mask;
}

/****************************************************************************
 * 
 * Generates the window for a menu
 *
 ****************************************************************************/
void
MakeMenu(MenuRoot * mr)
{
    MenuItem       *cur;
    unsigned long   valuemask;
    XSetWindowAttributes attributes;
    int             y;

    /* lets first size the window accordingly */
    mr->width += 10;
    if (mr->width2 > 0)
	mr->width += 5;

    /* allow two pixels for top border */
    for (y = 2, cur = mr->first; cur != NULL; cur = cur->next) {
	cur->y_offset = y;
	cur->x = 5;
	if (cur->func == F_TITLE) {
	    /* Title */
	    if (cur->strlen2 == 0)
		cur->x = (mr->width - XTextWidth(Scr.StdFont.font, cur->item,
						 cur->strlen)) >> 1;

	    cur->y_height = Scr.EntryHeight + HEIGHT_EXTRA_TITLE;
	}
	else if (cur->func == F_NOP && *cur->item == 0)
	    /* Separator */
	    cur->y_height = HEIGHT_SEPARATOR;
	else
	    /* Normal text entry */
	    cur->y_height = Scr.EntryHeight;
	y += cur->y_height;
	if (mr->width2 == 0) {
	    cur->x2 = cur->x;
	}
	else {
	    cur->x2 = mr->width - 5;
	}
    }
    mr->in_use = 0;
    mr->height = y + 2;

    valuemask = (CWBackPixel | CWEventMask | CWCursor | CWSaveUnder);
    attributes.background_pixel = Mwm.components[MWM_MENU].background;
    attributes.event_mask = (ExposureMask | EnterWindowMask);
    attributes.cursor = Scr.MwmCursors[MENU_CURS];
    attributes.save_under = TRUE;
    mr->width = mr->width + mr->width2;
    mr->w = XCreateWindow(dpy, Scr.root_win, 0, 0, (unsigned int) (mr->width),
			  (unsigned int) mr->height, (unsigned int) 0,
			  CopyFromParent, (unsigned int) InputOutput,
			  (Visual *) CopyFromParent,
			  valuemask, &attributes);
    XSaveContext(dpy, mr->w, MenuContext, (_Xconst char *) mr);

    return;
}

/*
 * Procedure:
 *	scanForHotkeys - Look for hotkey markers in a MenuItem
 * 							(pete@tecc.co.uk)
 * 
 * Inputs:
 *	it	- MenuItem to scan
 * 	which 	- +1 to look in it->item1 and -1 to look in it->item2.
 *
 */
void
scanForHotKey(MenuItem *it, KeySym key)
{
    char *str, *ptr;

    if (key != AnyKey) {
	str = XKeysymToString(key);
	for (ptr = it->item; *ptr && *ptr != *str; ptr++)
	    ;
	if (!*ptr)
	    it->hotkey = 0;
	else
	    it->hotkey = ptr - it->item + 1;
    }
    else
	it->hotkey = 0;
}



/***********************************************************************
 *
 *  Procedure:
 *	NewMenuRoot - create a new menu root
 *
 *  Returned Value:
 *	(MenuRoot *)
 *
 *  Inputs:
 *	name	- the name of the menu root
 *
 ***********************************************************************/
MenuRoot       *
NewMenuRoot(char *name)
{
    MenuRoot       *tmp;

    tmp = (MenuRoot *)XtMalloc(sizeof(MenuRoot));
    tmp->name = name;
    tmp->first = NULL;
    tmp->last = NULL;
    tmp->items = 0;
    tmp->width = 0;
    tmp->width2 = 0;
    tmp->w = None;
    return (tmp);
}

/*
 *
 *  Procedure:
 *	CreateGCs - open fonts and create all the needed GC's.  I only
 *		    want to do this once, hence the first_time flag.
 *
 */
#define g_width 2
#define g_height 2
static char     g_bits[] =
{0x02, 0x01};

void
CreateGCs(void)
{
    XGCValues       gcv;
    unsigned long   gcm;

    /* create GC's */
    gcm = GCFunction | GCLineWidth | GCForeground | GCSubwindowMode;
    gcv.function = GXxor;
    gcv.line_width = 0;
    gcv.foreground = XORvalue;
    gcv.subwindow_mode = IncludeInferiors;
    Scr.resize_GC = XCreateGC(dpy, Scr.root_win, gcm, &gcv);

    gcm = GCFunction | GCPlaneMask | GCGraphicsExposures | GCLineWidth |
	  GCForeground | GCBackground | GCFont;
    gcv.line_width = 0;
    gcv.function = GXcopy;
    gcv.plane_mask = AllPlanes;
    gcv.font = Scr.StdFont.font->fid;
    /*
     * Prevent GraphicsExpose and NoExpose events.  We'd only get NoExpose
     * events anyway;  they cause BadWindow errors from XGetWindowAttributes
     * call in FindScreenInfo (events.c) (since drawable is a pixmap).
     */
    gcv.graphics_exposures = False;

    gcv.foreground = Mwm.components[MWM_PAGER].foreground;
    gcv.background = Mwm.components[MWM_PAGER].background;
    Scr.pager_GC = XCreateGC(dpy, Scr.root_win, gcm, &gcv);

    gcv.foreground = Mwm.components[MWM_BORDER].foreground;
    gcv.background = Mwm.components[MWM_BORDER].background;
    Scr.client_GC = XCreateGC(dpy, Scr.root_win, gcm, &gcv);

    gcv.foreground = Mwm.components[MWM_FEEDBACK].foreground;
    gcv.background = Mwm.components[MWM_FEEDBACK].background;
    Scr.feedback_GC = XCreateGC(dpy, Scr.root_win, gcm, &gcv);

    /* GC for pager labels */
    Scr.FontGC = XCreateGC(dpy, Scr.root_win, gcm, &gcv);

    /* the colors we specify for the next two GC's don't really matter;
     * we'll override them before they're used. */
    gcm = GCFunction | GCPlaneMask | GCGraphicsExposures | GCLineWidth |
	  GCForeground | GCBackground | GCFont;
    gcv.foreground = Mwm.components[MWM_BORDER].top_shadow_color;
    gcv.background = Mwm.components[MWM_BORDER].bottom_shadow_color;
    gcv.fill_style = FillSolid;
    Scr.top_GC = XCreateGC(dpy, Scr.root_win, gcm, &gcv);

    gcv.foreground = Mwm.components[MWM_BORDER].bottom_shadow_color;
    gcv.background = Mwm.components[MWM_BORDER].top_shadow_color;
    Scr.bot_GC = XCreateGC(dpy, Scr.root_win, gcm, &gcv);

    gcv.foreground = Mwm.components[MWM_MENU].foreground;
    gcv.background = Mwm.components[MWM_MENU].background;
    Scr.menu_GC = XCreateGC(dpy, Scr.root_win, gcm, &gcv);
}
void
#ifdef __STDC__
yyerror(char *fmt, ...) {
    va_list arg_list;
    char buf[256];

    va_start(arg_list, fmt);
#else
yyerror(fmt, va_alist)
	char *fmt;
	va_dcl
{
    char buf[256];
    va_list arg_list;

    va_start(arg_list);
#endif
    vfprintf(stderr, fmt, arg_list);
    fprintf(stderr, "\n");
    va_end(arg_list);
}

/*
 * find the config file
 */
static Boolean
find_config_file(char *buf, char *cfile) {
    char *ptr, *home, *lang;

    home = getenv("HOME");
    if (!home)
	home = getcwd(NULL, MAX_PATH_LEN);
    lang = getenv("LANG");
    if (!lang)
	lang = "";

    /* check for home dir */
    ptr = cfile;
    if (*ptr == '~' && *(ptr+1) == '/') {
	ptr += 2;
	strcpy(buf, home);
	strcat(buf, "/");
	if (strlen(lang) != 0) {
	    strcat(buf, lang);
	    strcat(buf, "/");
	}
	strcat(buf, ptr);
	if (access(buf, R_OK) == 0) {
	    is_custom = True;
	    return True;
	}

	ptr += 2;
	strcpy(buf, home);
	strcat(buf, "/");
	strcat(buf, ptr);
	if (access(buf, R_OK) == 0) {
	    is_custom = True;
	    return True;
	}
    }

    ptr = HOME_MWMRC;
    strcpy(buf, home);
    strcat(buf, "/");
    if (strlen(lang) != 0) {
	strcat(buf, lang);
	strcat(buf, "/");
    }
    strcat(buf, ptr);
    if (access(buf, R_OK) == 0) {
	is_custom = True;
	return True;
    }

    strcpy(buf, home);
    strcat(buf, "/");
    strcat(buf, ptr);
    if (access(buf, R_OK) == 0) {
	is_custom = True;
	return True;
    }

    ptr = SYSTEM_MWMRC;
    strcpy(buf, XLIB_PATH);
    strcat(buf, "/");
    if (strlen(lang) != 0) {
	strcat(buf, lang);
	strcat(buf, "/");
    }
    strcat(buf, ptr);
    if (access(buf, R_OK) == 0)
	return True;

    ptr += 2;
    strcpy(buf, home);
    strcat(buf, "/");
    strcat(buf, ptr);
    if (access(buf, R_OK) == 0)
	return True;

    return False;
}

/*
 * these to variables are used by the parser to control input
 */
static char *input_buf;
static char *curpos;
static char *endpos;

char
mwm_getc(void) {
    char c;

    if (curpos == endpos)
	return 0;
    c = *curpos; curpos++;
    return c;
}

void
mwm_putc(char c) {
    printf("OUTPUT: %c\n", c);
}

void
mwm_unputc(char c) {
    curpos--;
    if (curpos < input_buf)
	curpos = input_buf;
}

int
parse_buf(char *buffer) {
    char *t;

    curpos = input_buf = buffer;
    endpos = input_buf + strlen(input_buf);
    return yyparse();
}

static char *_MwmWindowMenu = DEFAULT_MWM_WINDOW_MENU;
static char *_MwmRootMenu = DEFAULT_MWM_ROOT_MENU;
static char *_MwmKeyBindings = DEFAULT_MWM_KEY_BINDINGS;
static char *_MwmBehaviorKey = MWM_BEHAVIOR_KEY_BINDINGS;
static char *_MwmButtonBindings = DEFAULT_MWM_BUTTON_BINDINGS;

void
parse_mwmrc() {
    int fd;
    char buf[MAX_PATH_LEN], *ptr;
#if HAVE_SYS_STAT_H
    struct stat st;
#else
#error "you lose (I don't know how to fix this)"
#endif
    extern MwmFont *IconFont;

    XORvalue = (((unsigned long) 1) << Scr.d_depth) - 1;

    /* initialize some lists */
    Scr.MouseButtonRoot = NULL;
    Scr.FuncKeyRoot.next = NULL;
    Scr.DefaultIcon = NULL;

    /* load the font */
    if ((Scr.StdFont.font = XLoadQueryFont(dpy, Scr.StdFont.name)) == NULL) {
	yyerror("can't get font %s", Scr.StdFont.name);
	if ((Scr.StdFont.font = XLoadQueryFont(dpy, "fixed")) == NULL)
	    exit(1);
    }
    Scr.StdFont.height = Scr.StdFont.font->ascent + Scr.StdFont.font->descent;
    Scr.StdFont.y = Scr.StdFont.font->ascent;
    Scr.EntryHeight = Scr.StdFont.height + HEIGHT_EXTRA;

    /* load the window-title font */
    if ((Scr.WindowFont.font = XLoadQueryFont(dpy, Scr.WindowFont.name)) == NULL) {
	yyerror("can't get font %s", Scr.WindowFont.name);
	if ((Scr.WindowFont.font = XLoadQueryFont(dpy, "fixed")) == NULL)
	    exit(1);
    }

    Scr.WindowFont.height =
	Scr.WindowFont.font->ascent + Scr.WindowFont.font->descent;
    Scr.WindowFont.y = Scr.WindowFont.font->ascent;

    /* load the pager-label font */
    if (Scr.PagerFont.name != NULL) {
	if ((Scr.PagerFont.font = XLoadQueryFont(dpy, Scr.PagerFont.name)) != NULL) {
	    Scr.PagerFont.height =
		Scr.PagerFont.font->ascent + Scr.PagerFont.font->descent;
	    Scr.PagerFont.y = Scr.PagerFont.font->ascent;
	}
	else
	    yyerror("can't get pager font %s", Scr.PagerFont.name);
    }

    IconFont = &Scr.StdFont;
    if (Scr.IconFont.name != NULL) {
	if ((Scr.IconFont.font = XLoadQueryFont(dpy, Scr.IconFont.name)) != NULL) {
	    Scr.IconFont.height =
		Scr.IconFont.font->ascent + Scr.IconFont.font->descent;
	    Scr.IconFont.y = Scr.IconFont.font->ascent;
	    IconFont = &Scr.IconFont;
	}
	else
	    yyerror("can't get icon font %s", Scr.IconFont.name);
    }

    /* create graphics contexts */
    CreateGCs();
    XSync(dpy, 0);

    /* find our alt key */
    GetModifierMapping(dpy);

    ptr = Mwm.config_file;

    if (!find_config_file(buf, Mwm.config_file)) {
	yyerror("Cannot find configuration file.  Using builtin defaults.\n");
	parse_buf(_MwmWindowMenu);
	parse_buf(_MwmRootMenu);
	parse_buf(_MwmKeyBindings);
	parse_buf(_MwmBehaviorKey);
	parse_buf(_MwmButtonBindings);
	return;
    }
    if (stat(buf, &st)) {
	yyerror("Cannot stat configuration file '%s'.\nUsing builtin defaults.\n", buf);
	parse_buf(_MwmWindowMenu);
	parse_buf(_MwmRootMenu);
	parse_buf(_MwmKeyBindings);
	parse_buf(_MwmBehaviorKey);
	parse_buf(_MwmButtonBindings);
	return;
    }
    if ((fd = open(buf, O_RDONLY)) < 0) {
	yyerror("Cannot stat configuration file.  Using builtin defaults.\n");
	parse_buf(_MwmWindowMenu);
	parse_buf(_MwmRootMenu);
	parse_buf(_MwmKeyBindings);
	parse_buf(_MwmBehaviorKey);
	parse_buf(_MwmButtonBindings);
	return;
    }
    ptr = XtMalloc(st.st_size + 1);
    if (read(fd, ptr, st.st_size) != st.st_size) {
	parse_buf(_MwmWindowMenu);
	parse_buf(_MwmRootMenu);
	parse_buf(_MwmKeyBindings);
	parse_buf(_MwmBehaviorKey);
	parse_buf(_MwmButtonBindings);
	return;
    }
    ptr[st.st_size] = 0;
    parse_buf(ptr);
    XtFree(ptr);

    if (Mwm.use_pager) {
	pager_x = 0;
	pager_y = 0;
    }

    /* If no edge scroll line is provided in the setup file, use
     * a default */
    if (Scr.EdgeScrollX == -100000)
	Scr.EdgeScrollX = 25;
    if (Scr.EdgeScrollY == -100000)
	Scr.EdgeScrollY = Scr.EdgeScrollX;

    /* if edgescroll >1000 and < 100000m
     * wrap at edges of desktop (a "spherical" desktop) */
    if (Scr.EdgeScrollX >= 1000) {
	Scr.EdgeScrollX /= 1000;
	Scr.flags |= EdgeWrapX;
    }
    if (Scr.EdgeScrollY >= 1000) {
	Scr.EdgeScrollY /= 1000;
	Scr.flags |= EdgeWrapY;
    }

    Scr.EdgeScrollX = Scr.EdgeScrollX * Scr.d_width / 100;
    Scr.EdgeScrollY = Scr.EdgeScrollY * Scr.d_height / 100;

    Scr.VxMax = Scr.VxMax * Scr.d_width - Scr.d_width;
    Scr.VyMax = Scr.VyMax * Scr.d_height - Scr.d_height;
    if (Scr.VxMax < 0)
	Scr.VxMax = 0;
    if (Scr.VyMax < 0)
	Scr.VyMax = 0;

    if (Scr.VxMax == 0)
	Scr.flags &= ~EdgeWrapX;
    if (Scr.VyMax == 0)
	Scr.flags &= ~EdgeWrapY;

    if (pager_x < 10000)
	initialize_pager(pager_x, pager_y);

    return;
}
