/****************************************************************************
 * This module is based on Twm, but has been siginificantly modified 
 * by Rob Nation 
 ****************************************************************************/
/*****************************************************************************/
/**       Copyright 1988 by Evans & Sutherland Computer Corporation,        **/
/**                          Salt Lake City, Utah                           **/
/**  Portions Copyright 1989 by the Massachusetts Institute of Technology   **/
/**                        Cambridge, Massachusetts                         **/
/**                                                                         **/
/**                           All Rights Reserved                           **/
/**                                                                         **/
/**    Permission to use, copy, modify, and distribute this software and    **/
/**    its documentation  for  any  purpose  and  without  fee is hereby    **/
/**    granted, provided that the above copyright notice appear  in  all    **/
/**    copies and that both  that  copyright  notice  and  this  permis-    **/
/**    sion  notice appear in supporting  documentation,  and  that  the    **/
/**    names of Evans & Sutherland and M.I.T. not be used in advertising    **/
/**    in publicity pertaining to distribution of the  software  without    **/
/**    specific, written prior permission.                                  **/
/**                                                                         **/
/**    EVANS & SUTHERLAND AND M.I.T. DISCLAIM ALL WARRANTIES WITH REGARD    **/
/**    TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES  OF  MERCHANT-    **/
/**    ABILITY  AND  FITNESS,  IN  NO  EVENT SHALL EVANS & SUTHERLAND OR    **/
/**    M.I.T. BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL  DAM-    **/
/**    AGES OR  ANY DAMAGES WHATSOEVER  RESULTING FROM LOSS OF USE, DATA    **/
/**    OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER    **/
/**    TORTIOUS ACTION, ARISING OUT OF OR IN  CONNECTION  WITH  THE  USE    **/
/**    OR PERFORMANCE OF THIS SOFTWARE.                                     **/
/*****************************************************************************/

#ifndef _MWM_
#define _MWM_

#include "version.h"
#include "../../include/LTconfig.h"

#include <ctype.h>
#include <stdio.h>
#ifdef HAVE_STRING_H
#include <string.h>
#else
#define ANSI_STRING
#include <strings.h>
#endif
#include <stdlib.h>
#include <signal.h>
#ifdef HAVE_SYS_WAIT_H
#include <sys/wait.h>
#endif
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include <X11/Xresource.h>
#include <X11/Xproto.h>
#include <X11/Intrinsic.h>
#include <X11/IntrinsicP.h>
#include <X11/cursorfont.h>
#include <X11/extensions/shape.h>
#include <Xm/XmP.h>
#include <Xm/MwmUtil.h>

/*
 *#define XPM
 *  if you want color icons, specify #define XPM, and get libXpm
 *  from sunsite.unc.edu. The following files are recommended in addition
 *  to the mwm package (from ftp.x.org)
 *   /pub/R6untarred/contrib/lib/xpm-3.4c
 *   /pub/X11/contrib/xpm3icons.tar.Z,  sample icons
 *   /pub/X11/contrib/ctwm-3.0.tar.Z, pull out the icons. ctwm has really nice
 *                                  color icons.
 *  and this from ftp.x.org:
 *   /contrib/icons.tar.gz, lots of sample icons,
 *
 *   For monochrome, Xpm icons still work, but they're only better than regular
 *   bitmaps because they're shaped
 */
/*#define XPM                      */
/*  linker flags needed to locate and link in the Xpm library, if you use it */
/*#define XPMLIBRARY -L/usr/lib/X11 -lXpm */

/*
 * Please translate the strings into the language which you use for your 
 * pop-up menus
 *
 * Some decisions about where a function is prohibited (based on 
 * mwm-function-hints) is based on a string comparison between the 
 * menu item and the strings below
 */
#define MOVE_STRING		"move"
#define RESIZE_STRING1		"size"
#define RESIZE_STRING2		"resize"
#define MINIMIZE_STRING		"minimize"
#define MINIMIZE_STRING2	"iconify"
#define MAXIMIZE_STRING		"maximize"
#define CLOSE_STRING1		"close"
#define CLOSE_STRING2		"delete"
#define CLOSE_STRING3		"destroy"
#define CLOSE_STRING4		"quit"

/*
 * path components
 */
#define DEFAULT_LIB_PATH	MOTIF_LIB_PATH":"XLIB_PATH
#define MWM_SHELL_NAME		"MWMSHELL"
#define SHELL_NAME		"SHELL"
#define DEFAULT_SHELL		"/bin/sh"
#define DEFAULT_SCREEN		"DISPLAY=:%s.%d"
#define DEFAULT_DISPLAY		"DISPLAY=%s:%s.%d"
#define DEFAULT_DISPLAY_STRING	"DISPLAY=%s"
#define HOME_MWMRC		".mwmrc"	/* precede with $HOME */
#define SYSTEM_MWMRC		"system.mwmrc"	/* precede with XLIB_PATH */
#define HOME_BINDINGS_FILE	".motifbind"
#define MWM_VERSION		"Lesstif mwm Release"
#define OPT_MULTISCREEN		"-multiscreen"
#define OPT_SCREENS		"-screens"
#define MWMDIR			XLIB_PATH"/mwm"
#define MWM_ICONDIR		XINCL_PATH"/bitmaps:"XINCL_PATH"/pixmaps"
#define MWMRC			XLIB_PATH"/mwm/"SYSTEM_MWMRC

/*
 * I don't know what these are for yet
 *
 _MwmWindowMenu_ _MwmWindowMenu_
 _MwmRootMenu_ DefaultRootMenu
 _MwmKeyBindings_ _MwmKeyBindings_
 _MwmBehaviorKey_
 _MwmButtonBindings_ _MwmButtonBindings_
 *
 */

#define DEFAULT_MWM_WINDOW_MENU \
    "Keys DefaultWindowMenu {\n" \
	"Restore	Alt<Key>F5	f.restore\n" \
	"Move		Alt<Key>F7	f.move\n" \
	"Size		Alt<Key>F8	f.resize\n" \
	"Minimize	Alt<Key>F9	f.minimize\n" \
	"Maximize	Alt<Key>F10	f.maximize\n" \
	"Lower		Alt<Key>F3	f.lower\n" \
	"no-label			f.separator\n" \
	"Close		Alt<Key>F4	f.kill\n" \
    "}"

#define DEFAULT_MWM_ROOT_MENU \
    "Menu DefaultRootMenu {\n" \
	"\"Root Menu\"		f.title\n" \
	"\"New Window\"		f.exec		\"xterm &\"\n" \
	"\"Shuffle Up\"		f.circle_up\n" \
	"\"Shuffle Down\"	f.circle_down\n" \
	"\"Refresh\"		f.refresh\n" \
	"\"Pack Icons\"		f.pack_icons\n" \
	"no-label		f.separator\n" \
	"\"Restart...\"		f.restart\n" \
    "}"

#define DEFAULT_MWM_KEY_BINDINGS \
    "Keys DefaultKeyBindings {" \
	"Shift<Key>Escape	window|icon		f.post_wmenu\n" \
	"Alt<Key>space		window|icon		f.post_wmenu\n" \
	"Alt<Key>Tab		root|icon|window	f.next_key\n" \
	"Alt Shift<Key>Tab	root|icon|window	f.prev_key\n" \
	"Alt<Key>Escape		root|icon|window	f.circle_down\n" \
	"Alt Shift<Key>Escape	root|icon|window	f.circle_up\n" \
	"Alt Shift Ctrl<Key>exclam root|icon|window	f.set_behavior\n" \
	"Alt Ctrl<Key>1		root|icon|window	f.set_behavior\n" \
	"Alt<Key>F6		window			f.next_key transient\n" \
	"Alt Shift<Key>F6	window			f.prev_key transient\n" \
	"Shift<Key>F10		icon			f.post_wmenu\n" \
    "}"

#define MWM_BEHAVIOR_KEY_BINDINGS \
    "Keys  _MwmBehaviorKey_ {" \
	"Alt Shift Ctrl<Key>exclam	root|icon|window	f.set_behavior\n" \
	"Alt Ctrl<Key>1			root|icon|window	f.set_behavior\n" \
    "}"

#define DEFAULT_MWM_BUTTON_BINDINGS \
    "Buttons DefaultButtonBindings {" \
	"<Btn1Down>	icon|frame	f.raise\n" \
	"<Btn3Down>	icon|frame	f.post_wmenu\n" \
	"<Btn3Down>	root		f.menu	DefaultRootMenu\n" \
    "}"

typedef struct Size {
    Dimension       width;
    Dimension       height;
} Size;

typedef XRectangle Geometry;

/*
 * decoration components have resources, too...
 */
typedef struct ComponentInfo {
    Pixel           background;
    Pixmap          background_pixmap;
    Pixel           bottom_shadow_color;
    Pixmap          bottom_shadow_pixmap;
    XFontStruct    *font_list;
    Pixel           foreground;
    Boolean         save_under;
    Pixel           top_shadow_color;
    Pixmap          top_shadow_pixmap;

    /* frame and icon components have a few more */
    Pixel           active_background;
    Pixmap          active_background_pixmap;
    Pixel           active_bottom_shadow_color;
    Pixmap          active_bottom_shadow_pixmap;
    Pixel           active_foreground;
    Pixel           active_top_shadow_color;
    Pixmap          active_top_shadow_pixmap;
} ComponentInfo;

/*
 * component types
 */
enum {
    MWM_MENU,
    MWM_ICON,
    MWM_FEEDBACK,
    MWM_PAGER,
    MWM_TITLE_AREA,
    MWM_RESIZE_HANDLES,
    MWM_BORDER,
    MWM_MAXIMIZE_BUTTON,
    MWM_MINIMIZE_BUTTON,
    MWM_MENU_BUTTON,
    MWM_MAX_COMPONENTS
};

/*
 * for focus policies.  Other valus are in Xm/Xm.h
 */
enum {
    XmKEYBOARD = 2
};

/*
 * for icon decorations
 */
#define XmICON_ACTIVELABEL	(1L << 0)
#define XmICON_LABEL		(1L << 1)
#define XmICON_IMAGE		(1L << 2)

/*
 * for icon placement
 */
#define XmICONS_TOP		(1L << 0)
#define XmICONS_BOTTOM		(1L << 1)
#define XmICONS_LEFT		(1L << 2)
#define XmICONS_RIGHT		(1L << 3)
#define XmICONS_TIGHT		(1L << 4)

/*
 * for icon placement
 */
#define XmFEEDBACK_ALL		(1L << 0)
#define XmFEEDBACK_BEHAVIOR	(1L << 1)
#define XmFEEDBACK_KILL		(1L << 2)
#define XmFEEDBACK_MOVE		(1L << 3)
#define XmFEEDBACK_PLACEMENT	(1L << 4)
#define XmFEEDBACK_QUIT		(1L << 5)
#define XmFEEDBACK_RESIZE	(1L << 6)
#define XmFEEDBACK_RESTART	(1L << 7)

enum {
    XmUSE_PPOSITION_NON_ZERO,
    XmUSE_PPOSITION_ON,
    XmUSE_PPOSITION_OFF
};

#ifndef WithdrawnState
#define WithdrawnState 0
#endif

/*
 * frame width
 */
#define PAN_FRAME_THICKNESS 2

/*
 * the maximum number of mouse buttons mwm knows about
 *
 * don't think that upping this to 5 will make everything
 * hunky-dory with 5 button mouses
 */
#define MAX_BUTTONS 3

#define BW 1			/* border width */
#define BOUNDARY_WIDTH 7	/* border width */
#define CORNER_WIDTH 16		/* border width */

#define HEIGHT_EXTRA 4		/* Extra height for texts in popus */
#define HEIGHT_EXTRA_TITLE 4	/* Extra height for underlining title */
#define HEIGHT_SEPARATOR 4	/* Height of separator lines */

#define SCROLL_REGION 2		/* region around screen edge that */
				/* triggers scrolling */

/*
 * menu label types
 */
enum {
   IS_STRING,
   IS_BITMAP
};

#ifndef TRUE
#define TRUE	1
#define FALSE	0
#endif

#define NULLSTR ((char *) NULL)

/*
 * contexts for button presses
 */
#define C_NO_CONTEXT	0x0000
#define C_WINDOW	0x0001
#define C_TITLE		0x0002
#define C_ICON		0x0004
#define C_ROOT		0x0008
#define C_FRAME		0x0010
#define C_SIDEBAR	0x0020
#define C_MENUB		0x0040
#define C_MAXIMIZEB	0x0080
#define C_MINIMIZEB	0x0100
#define C_RALL		(C_MINIMIZEB|C_MAXIMIZEB)
#define C_LALL		(C_MENUB)
#define C_ALL		(C_WINDOW|C_TITLE|C_ICON|C_ROOT|C_FRAME|C_SIDEBAR| \
			 C_MINIMIZEB|C_MAXIMIZEB|C_MENUB)

typedef struct MwmFont {
    char           *name;	/* name of the font */
    XFontStruct    *font;	/* font structure */
    int             height;	/* height of the font */
    int             y;		/* Y coordinate to draw characters */
} MwmFont;

/*
 * for each window that is on the display, one of these structures
 * is allocated and linked into a list 
 */
typedef struct MwmWindow {
    struct MwmWindow *next;	/* next mwm window */
    struct MwmWindow *prev;	/* prev mwm window */

    long            client_decoration;
    long            client_functions;
    Boolean         focus_auto_raise;
    String          icon_image;
    Pixel           icon_image_background;
    Pixel           icon_image_bottom_shadow_color;
    Pixmap          icon_image_bottom_shadow_pixmap;
    Pixel           icon_image_foreground;
    Pixel           icon_image_top_shadow_color;
    Pixmap          icon_image_top_shadow_pixmap;
    Pixel           matte_background;
    Pixel           matte_bottom_shadow_color;
    Pixmap          matte_bottom_shadow_pixmap;
    Pixel           matte_foreground;
    Pixel           matte_top_shadow_color;
    Pixmap          matte_top_shadow_pixmap;
    Dimension       matte_width;
    Size            maximum_client_size;
    Boolean         use_client_icon;
    unsigned char   use_p_position;
    String          window_menu;

    char           *name;	/* name of the window */

    Window          w;		/* the child window */
    Window          frame;	/* the frame window */
    Window          Parent;	/* Ugly Ugly Ugly - it looks like you
				 * HAVE to reparent the app window into
				 * a window whose size = app window,
				 * or else you can't keep xv and matlab
				 * happy at the same time! */
    Window          title_w;	/* the title bar window */
    Window          sides[4];
    Window          corners[4];	/* Corner pieces */
    Window          menub;
    Window          minimizeb;
    Window          maximizeb;
    Window          icon_w;	/* the icon window */
    Window          icon_pixmap_w;	/* the icon window */
    Window          transientfor;
    Window          pager_view;

    int             wShaped;	/* is this a shaped window */

    int             frame_x;	/* x position of frame */
    int             frame_y;	/* y position of frame */
    int             frame_width;	/* width of frame */
    int             frame_height;	/* height of frame */

    int             boundary_width;
    int             corner_width;
    int             old_bw;	/* border width before reparenting */
    int             bw;

    int             title_x;
    int             title_y;
    int             title_height;	/* height of the title bar */
    int             title_width;	/* width of the title bar */

    int             icon_x_loc;		/* icon window x coordinate */
    int             icon_xl_loc;	/* icon label window x coordinate */
    int             icon_y_loc;		/* icon window y coordiante */
    int             icon_w_width;	/* width of the icon window */
    int             icon_w_height;	/* height of the icon window */
    int             icon_t_width;	/* width of the icon title window */
    int             icon_p_width;	/* width of the icon pixmap window */
    int             icon_p_height;	/* height of the icon pixmap window */
    Pixmap          icon_pixmap;	/* pixmap for the icon */
    int             icon_depth;		/* Drawable depth for the icon */
    Pixmap          icon_mask_pixmap;	/* pixmap for the icon mask */

    XWindowAttributes attr;		/* the child window attributes */
    XSizeHints      hints;		/* normal hints */
    XWMHints       *wmhints;		/* WM hints */
    XClassHint      class;

    int             Desk;		/* Tells which desktop this window is on */
    int             FocusDesk;		/* Where (if at all) was it focussed */
    int             DeIconifyDesk;	/* Desk to deiconify to, for StubbornIcons */

    unsigned long   flags;
    char           *icon_bitmap_file;

    int             orig_x;	/* unmaximized x coordinate */
    int             orig_y;	/* unmaximized y coordinate */
    int             orig_wd;	/* unmaximized window width */
    int             orig_ht;	/* unmaximized window height */

    int             xdiff, ydiff;	/* used to restore window position on exit */
    int            *mwm_hints;
    int             functions;
    Window         *cmap_windows;	/* Colormap windows property */
    int             number_cmap_windows;	/* Should generally be 0 */
    int             focus_sequence;

    unsigned long   buttons;
} MwmWindow;

/*
 * window flags definitions 
 */
#define STICKY		0x00000001	/* Does window stick to glass? */
#define ONTOP		0x00000002	/* does window stay on top */
#define CIRCULATESKIP	0x00000004
#define STARTICONIC	0x00000008
#define WINDOWLISTSKIP	0x00000010
#define SUPPRESSICON	0x00000020
#define NOICON_TITLE	0x00000040
#define BORDER		0x00000080	/* Is this decorated with border */
#define TITLE		0x00000100	/* Is this decorated with title */
#define MAPPED		0x00000200	/* is it mapped? */
#define ICONIFIED	0x00000400	/* is it an icon now? */
#define TRANSIENT	0x00000800	/* is it a transient window? */
#define RAISED		0x00001000	/* if a sticky window, does it need to be raised */
#define VISIBLE		0x00002000	/* is the window fully visible */
#define ICON_OURS	0x00004000	/* is the icon window supplied by the app? */
#define XPM_FLAG	0x00008000	/* is the icon window an xpm? */
#define PIXMAP_OURS	0x00010000	/* is the icon pixmap ours to free? */
#define SHAPED_ICON	0x00020000	/* is the icon shaped? */
#define MAXIMIZED	0x00040000	/* is the window maximized? */
#define WM_TAKES_FOCUS	0x00080000
#define WM_DELS_WINDOW	0x00100000
#define ICON_MOVED	0x00200000	/* has the icon been moved by the user? */
#define ICON_UNMAPPED   0x00400000	/* was the icon unmapped, though window is iconified (Transients) */
#define MAP_PENDING	0x00800000	/* Sent an XMapWindow, but didn't receive a MapNotify yet. */

/*
 * flags to suppress/enable title bar buttons
 */
#define BUTTON1		0x0001
#define BUTTON2		0x0002
#define BUTTON3		0x0004
#define BUTTON4		0x0008
#define BUTTON5		0x0010
#define BUTTON6		0x0020
#define BUTTON7		0x0040
#define BUTTON8		0x0080
#define BUTTON9		0x0100
#define BUTTON10	0x0200

#define MAX_FILE_SIZE 4096	/* max chars to read from file for cut */
#define MAXPOPUPS 50

typedef struct MenuItem {
    struct MenuItem *next;	/* next menu item */
    struct MenuItem *prev;	/* prev menu item */
    char           *item;	/* the character string displayed on left */
    char           *item2;	/* the character string displayed on right */
    char           *action;	/* action to be performed */
    short           item_num;	/* item number of this menu */
    short           x;		/* x coordinate for text (item) */
    short           x2;		/* x coordinate for text (item2) */
    short           y_offset;	/* y coordinate for item */
    short           y_height;	/* y height for item */
    short           func;	/* twm built in function */
    long            val1;	/* values needed for F_SCROLL */
    long            val2;
    long            val1_unit;	/* units for val1, val2 */
    long            val2_unit;	/* pixels (unit=1) or percent of screen 
				 * (unit = Scr.d_width/d_height */
    short           state;	/* video state, 0 = normal, 1 = reversed */
    short           strlen;	/* strlen(item) */
    short           strlen2;	/* strlen(item2) */
    short           hotkey;	/* Hot key offset (pete@tecc.co.uk).
				   0 - No hot key
				   +ve - offset to hot key char in item
				   -ve - offset to hot key char in item2
				   (offsets have 1 added, so +1 or -1
				   refer to the *first* character)
				 */
    struct MenuRoot *menu;	/* sub-menu */
} MenuItem;

typedef struct MenuRoot {
    struct MenuItem *first;	/* first item in menu */
    struct MenuItem *last;	/* last item in menu */
    struct MenuRoot *next;	/* next in list of root menus */
    char           *name;	/* name of root */
    Window          w;		/* the window of the menu */
    short           height;	/* height of the menu */
    short           width;	/* width of the menu for 1st col */
    short           width2;	/* width of the menu for 2nd col */
    short           items;	/* number of items in the menu */
    Bool            in_use;
} MenuRoot;

typedef struct MouseButton {
    int             func;	/* the function number */
    MenuRoot       *menu;	/* menu if func is F_POPUP */
    MenuItem       *item;	/* action to perform if func != F_POPUP */
    int             Button;
    int             Context;
    int             Modifier;
    int             val1;
    int             val2;
    long            val1_unit;	/* units for val1, val2 */
    long            val2_unit;	/* pixels (unit=1) or percent of screen 
				 * (unit = Scr.d_width/d_height */
    struct MouseButton *NextButton;
} MouseButton;

typedef struct FuncKey {
    struct FuncKey *next;	/* next in the list of function keys */
    char           *name;	/* key name */
    KeyCode         keycode;	/* X keycode */
    int             cont;	/* context */
    int             mods;	/* modifiers */
    int             func;	/* function to perform */
    int             val1;	/* values needed for F_SCROLL */
    int             val2;
    long            val1_unit;	/* units for val1, val2 */
    long            val2_unit;	/* pixels (unit=1) or percent of screen  */
    MenuRoot       *menu;	/* menu if func is F_POPUP */
    char           *action;	/* action string (if any) */
} FuncKey;

#define MENU_ERROR	-1
#define MENU_NOP	0
#define MENU_DONE	1
#define SUBMENU_DONE	2


/*
 * Types of events for the FUNCTION builtin
 */
#define MOTION			'm'
#define IMMEDIATE		'i'
#define CLICK			'c'
#define DOUBLE_CLICK		'd'
#define ONE_AND_A_HALF_CLICKS	'o'

/*
 * ReapChildren - wait() for all dead child processes
 */
#ifdef HAVE_WAITPID
#define ReapChildren()  while ((waitpid(-1, NULL, WNOHANG)) > 0);
#else
#define ReapChildren()  while ((wait3(NULL, WNOHANG, NULL)) > 0);
#endif

/* values for client behavior flags */
#define STICKY_FLAG		0x0001
#define STAYSONTOP_FLAG		0x0002
#define ICON_FLAG		0x0010
#define CIRCULATESKIP_FLAG	0x0020
#define LISTSKIP_FLAG		0x0040
#define STAYSONDESK_FLAG	0x0080
#define SUPPRESSICON_FLAG	0x0100
#define BW_FLAG			0x0200
#define NOBW_FLAG		0x0400
#define START_ICONIC_FLAG	0x0800
#define FORE_COLOR_FLAG		0x1000
#define BACK_COLOR_FLAG		0x2000
#define NOICON_TITLE_FLAG	0x4000

/* some fancy font handling stuff */
#define NewFontAndColor(newfont,color,backcolor) {\
   Globalgcv.font = newfont;\
   Globalgcv.foreground = color;\
   Globalgcv.background = backcolor;\
   Globalgcm = GCFont | GCForeground | GCBackground; \
   XChangeGC(dpy,Scr.FontGC,Globalgcm,&Globalgcv); \
}

#define ICON_HEIGHT (IconFont->height+6)

#define SIZE_HINDENT 5
#define SIZE_VINDENT 3
#define MAX_WINDOW_WIDTH	32767
#define MAX_WINDOW_HEIGHT	32767


/*
 * Cursor types
 */
#define POSITION_CURS	0	/* upper Left corner cursor */
#define TITLE_CURS	1	/* title-bar cursor */
#define DEFAULT_CURS	2	/* cursor for apps to inherit */
#define SYS_CURS	3	/* sys-menu and iconify boxes cursor */
#define MOVE_CURS	4	/* resize cursor */
#define WAIT_CURS	5	/* wait a while cursor */
#define MENU_CURS	6	/* menu cursor */
#define SELECT_CURS	7	/* dot cursor for f.move, etc. from menus */
#define DESTROY_CURS	8	/* skull and cross bones, f.destroy */
#define TOP_CURS	9
#define RIGHT_CURS	10
#define BOTTOM_CURS	11
#define LEFT_CURS	12
#define TOP_LEFT_CURS	13
#define TOP_RIGHT_CURS	14
#define BOT_LEFT_CURS	15
#define BOT_RIGHT_CURS	16
#define MAX_CURSORS	18

/*
 * Maximum number of icon boxes that are allowed
 */
#define MAX_BOXES 4

typedef struct {
    Window          win;
    int             isMapped;
} PanFrame;

typedef struct ScreenInfo {
    unsigned long   screen;
    int             d_depth;	/* copy of DefaultDepth(dpy, screen) */
    int             d_width;	/* my copy of DisplayWidth(dpy, screen) */
    int             d_height;	/* my copy of DisplayHeight(dpy, screen) */

    MwmWindow       MwmRoot;	/* the head of the mwm window list */

    Window          root_win;	/* the root window */
    Window          size_win;	/* the resize dimensions window */
    Window          no_focus_win;/* Window which will own focus when no other
				  * windows have it */
    PanFrame        PanFrameTop, PanFrameLeft, PanFrameRight, PanFrameBottom;
    int             usePanFrames;	/* toggle to disable them */

    MouseButton    *MouseButtonRoot;
    FuncKey         FuncKeyRoot;

    int             root_pushes;	/* current push level to install root
					   colormap windows */
    MwmWindow      *pushed_window;	/* saved window to install when pushes drops
					   to zero */
    MwmWindow      *MwmPager;
    Window          Pager_w;
    Window          CPagerWin;
    Cursor          MwmCursors[MAX_CURSORS];

    char           *DefaultIcon;	/* Icon to use when no other icons are found */

    MwmFont         StdFont;	/* font structure */
    MwmFont         WindowFont;	/* font structure for window titles */
    MwmFont         PagerFont;	/* font struct for window labels in pager (optional) */
    MwmFont         IconFont;	/* for icon labels */

    GC              FontGC;	/* GC for non-standard fonts */
    GC		    client_GC;  /* for client drawing */
    GC		    pager_GC;  /* for client drawing */
    GC		    menu_GC;
    GC		    icon_GC;
    GC		    feedback_GC;
    GC		    resize_GC;
    GC		    top_GC;
    GC		    bot_GC;

    int             SizeStringWidth;	/* minimum width of size window */
    int             CornerWidth;	/* corner width for decoratedwindows */
    int             BoundaryWidth;	/* frame width for decorated windows */
    int             NoBoundaryWidth;	/* frame width for decorated windows */
    int             TitleHeight;	/* height of the title bar window */
    MwmWindow      *Hilite;	/* the mwm window that is highlighted 
				 * except for networking delays, this is the
				 * window which REALLY has the focus */
    MwmWindow      *Focus;	/* Last window which Mwm gave the focus to 
				 * NOT the window that really has the focus */
    MwmWindow      *Ungrabbed;
    MwmWindow      *PreviousFocus;/* Window which had focus before mwm stole it
				   * to do moves/menus/etc. */
    int             EntryHeight;	/* menu entry height */
    int             EdgeScrollX;	/* #pixels to scroll on screen edge */
    int             EdgeScrollY;	/* #pixels to scroll on screen edge */
    unsigned char   buttons2grab;	/* buttons to grab in click to focus mode */
    unsigned long   flags;
    int             IconBoxes[MAX_BOXES][4];
    int             NumBoxes;
    int             randomx;	/* values used for randomPlacement */
    int             randomy;
    unsigned        VScale;	/* Panner scale factor */
    MwmWindow      *LastWindowRaised;	/* Last window which was raised. Used
					 * for raise lower func. */
    int             VxMax;	/* Max location for top left of virt desk */
    int             VyMax;
    int             Vx;		/* Current loc for top left of virt desk */
    int             Vy;

    int             nr_left_buttons;	/* number of left title-bar buttons */
    int             nr_right_buttons;	/* number of right title-bar buttons */

    int             left_button_styles[2][5];
    int             right_button_styles[2][5];

    int             ClickTime;	/*Max button-click delay for Function built-in */
    int             ScrollResistance;	/* resistance to scrolling in desktop */
    int             MoveResistance;	/* res to moving windows over viewport edge */
    int             OpaqueSize;
    int             CurrentDesk;	/* The current desktop number */
    MenuRoot       *InitFunction;
    MenuRoot       *RestartFunction;
} ScreenInfo;

/*
 * for the flags value - these used to be seperate Bool's
 */
#define DontMoveOff		0x00000004	/* make sure all windows stay on desktop */
#define SuppressIcons		0x00000010	/* prevent generation of icon windows */
#define StickyIcons		0x00000020	/* Icons always sticky? */
#define EdgeWrapX		0x00000040	/* Should EdgeScroll wrap around? */
#define EdgeWrapY		0x00000080
#define CenterOnCirculate	0x00000100	/* center window when circulating? */
#define NoPPosition		0x00000200
#define CirculateSkipIcons	0x00000800
#define StubbornIcons		0x00001000
#define StubbornPlacement	0x00002000
#define StubbornIconPlacement	0x00004000
#define OpaqueResize		0x00008000
#define BackingStore		0x00010000
#define AppsBackingStore	0x00020000
#define SaveUnders		0x00040000

/*
 * management info for the whole window manager
 */
typedef struct MwmInternalInfo {
    Boolean         auto_key_focus;
    Time            auto_raise_delay;
    String          bitmap_directory;
    String          button_bindings;
    Boolean         clean_text;
    Boolean         client_auto_place;
    unsigned char   colormap_focus_policy;
    String          config_file;
    Boolean         deiconify_key_focus;
    Time            double_click_time;
    Boolean         enable_warp;
    Boolean         enforce_key_focus;
    Boolean         fade_normal_icon;
    Geometry        feedback_geometry;
    Dimension       frame_border_width;
    Boolean         icon_auto_place;
    Geometry        icon_box_geometry;
    String          icon_box_name;
    String          icon_box_sb_display_policy;
    XmString        icon_box_title;
    Boolean         icon_click;
    long            icon_decoration;
    Size            icon_image_maximum;
    Size            icon_image_minimum;
    unsigned char   icon_placement;
    Dimension       icon_placement_margin;
    Boolean         interactive_placement;
    String          key_bindings;
    unsigned char   keyboard_focus_policy;
    Boolean         limit_resize;
    Boolean         lower_on_iconify;
    Size            maximum_maximum_size;
    Dimension       move_threshold;
    Boolean         move_opaque;
    Boolean         multi_screen;
    Boolean         pass_buttons;
    Boolean         pass_selection_buttons;
    Boolean         position_is_frame;
    Boolean         position_on_screen;
    Time            quit_timeout;
    Boolean         raise_key_focus;
    Dimension       resize_border_width;
    Boolean         resize_cursors;
    String          screens;
    long            show_feedback;
    Boolean         startup_key_focus;
    long            transient_decoration;
    long            transient_functions;
    Boolean         use_icon_box;
    Boolean         w_menu_button_click;
    Boolean         w_menu_button_click_2;
    Boolean	    use_pager;

    /* instance vars */
    ScreenInfo	    *screen_info;
    int		    number_of_screens;
    ComponentInfo   components[MWM_MAX_COMPONENTS];
} MwmInternalInfo;

/*
 * mwm functions
 */
#define F_NOP			0
#define F_BEEP			1
#define F_QUIT			2
#define F_RESTART               3
#define F_REFRESH		4
#define F_TITLE			5
#define F_SCROLL                6	/* scroll the virtual desktop */
#define F_CIRCULATE_UP          7
#define F_CIRCULATE_DOWN        8
#define F_TOGGLE_PAGE           9
#define F_GOTO_PAGE             10
#define F_WINDOWLIST            11
#define F_MOVECURSOR            12
#define F_FUNCTION              13
#define F_WARP                  14
#define F_DESK                  15
#define F_CHANGE_WINDOWS_DESK   16
#define F_EXEC			17	/* string */
#define F_POPUP			18	/* string */
#define F_WAIT                  19
#define F_CLOSE                 20
#define F_QUICKIE               21
#define F_W_POPUP		22	/* string */

/*
 * Functions which require a target window
 */
#define F_RESIZE		100
#define F_RAISE			101
#define F_LOWER			102
#define F_DESTROY		103
#define F_DELETE		104
#define F_MOVE			105
#define F_ICONIFY		106
#define F_STICK                 107
#define F_RAISELOWER            108
#define F_MAXIMIZE              109
#define F_FOCUS                 110

/*
 * Functions for internal  only!
 */
#define F_RAISE_IT              1000

/*
 * highlighting
 */
#define NO_HILITE     0x0000
#define TOP_HILITE    0x0001
#define RIGHT_HILITE  0x0002
#define BOTTOM_HILITE 0x0004
#define LEFT_HILITE   0x0008
#define FULL_HILITE   0x000F

/*
 * gotta know which way
 */
#define UP 1
#define DOWN 0

extern void     MoveOutline(Window, int, int, int, int);
extern void     DoResize(int, int, MwmWindow *);
extern void     DisplaySize(MwmWindow *, int, int, Bool);
extern void     DisplayPosition(MwmWindow *, int, int, Bool);
extern void     SetupFrame(MwmWindow *, int, int, int, int, Bool);
extern void     CreateGCs(void);
extern void     InstallWindowColormaps(MwmWindow *);
extern void     InstallRootColormap(void);
extern void     UninstallRootColormap(void);
extern void     FetchWmProtocols(MwmWindow *);
extern void     FetchWmColormapWindows(MwmWindow * tmp);
extern void     PaintEntry(MenuRoot *, MenuItem *);
extern void     PaintMenu(MenuRoot *, XEvent *);
extern void     MakeMenus(const char *, char *);
extern void     InitEvents(void);
extern void     DispatchEvent(void);
extern void     HandleEvents(void);
extern void     HandleExpose(void);
extern void     HandleFocusIn(void);
extern void     HandleFocusOut(void);
extern void     HandleDestroyNotify(void);
extern void     HandleMapRequest(void);
extern void     HandleMapNotify(void);
extern void     HandleUnmapNotify(void);
extern void     HandleMotionNotify(void);
extern void     HandleButtonRelease(void);
extern void     HandleButtonPress(void);
extern void     HandleEnterNotify(void);
extern void     HandleLeaveNotify(void);
extern void     HandleConfigureRequest(void);
extern void     HandleClientMessage(void);
extern void     HandlePropertyNotify(void);
extern void     HandleKeyPress(void);
extern void     HandleVisibilityNotify(void);
extern void     HandleColormapNotify(void);
extern void     SetTitleBar(MwmWindow *, Bool, Bool);
extern void     RestoreWithdrawnLocation(MwmWindow *, Bool);
extern void     Destroy(MwmWindow *);
extern void     GetGravityOffsets(MwmWindow *, int *, int *);
extern void     MoveViewport(int newx, int newy, Bool);
extern MwmWindow *AddWindow(Window w);
extern int      MappedNotOverride(Window w);
extern void     GrabButtons(MwmWindow *);
extern void     GrabKeys(MwmWindow *);
extern void     GetWindowSizeHints(MwmWindow *);
extern void     RedrawPager(void);
extern void     ReallyRedrawPager(void);
extern void     SwitchPages(Bool, Bool);
extern void     NextPage(void);
extern void     PrevPage(void);
extern void     moveLoop(MwmWindow *, int, int, int, int, int *, int *, Bool, Bool);
extern void     Keyboard_shortcuts(XEvent *, int);
extern void     RedoIconName(MwmWindow *);
extern void     DrawIconWindow(MwmWindow *);
extern void     CreateIconWindow(MwmWindow * tmp_win, int def_x, int def_y);
#ifdef __GNUC__
extern inline void RelieveWindow(MwmWindow *, Window,
				 int, int, int, int, GC, GC, int);
#else
extern void RelieveWindow(MwmWindow *, Window,
 			  int, int, int, int, GC, GC, int);
#endif
extern void     RelieveParts(MwmWindow * t, int i, GC hor, GC vert);
extern void     sleep_a_little(int);
extern void     PagerMoveWindow(void);
extern void     Maximize(MwmWindow *, int, int, int, int);
extern void     RaiseWindow(MwmWindow * t);
extern void     LowerWindow(MwmWindow * t);
extern Bool     GrabEm(int);
extern void     UngrabEm(void);
extern MenuRoot *NewMenuRoot(char *name);
extern void     AddToMenu(MenuRoot *, char *, char *, char *, int,
			  long, long, char, char);
extern void     MakeMenu(MenuRoot *);
extern void     CaptureAllWindows(void);
extern void     SetTimer(int);
extern int      flush_expose(Window w);
extern void     ExecuteFunction(int, char *, Window, MwmWindow *, XEvent *,
				unsigned long, long, long, int, int,
				MenuRoot *);
extern void     do_windowList(int, int);
extern void     RaiseThisWindow(int);
extern int      GetContext(MwmWindow *, XEvent *, Window * dummy);
extern void     ConstrainSize(MwmWindow *, int *, int *);
extern void     HandlePaging(int, int, int *, int *, int *, int *, Bool);
extern void     SetShape(MwmWindow *, int);
extern void     AutoPlace(MwmWindow *);
extern void     MoveResizePagerView(MwmWindow * t);
extern void     MoveResizeViewPortIndicator(void);
extern void     SetFocus(Window, MwmWindow *);
extern void     CheckAndSetFocus(void);
extern void     GetBitmapFile(MwmWindow * tmp_win);
extern void     GetXPMFile(MwmWindow * tmp_win);
extern void     GetIconWindow(MwmWindow * tmp_win);
extern void     GetIconBitmap(MwmWindow * tmp_win);
extern void     SmartPlacement(MwmWindow * t, int width, int height, int *x, int *y);
extern void     usage(void);
extern void     GetMwmHints(MwmWindow * t);
extern void     SelectDecor(MwmWindow *, unsigned long, int, int);
extern Bool     PopUpMenu(MenuRoot *, int, int);
extern void     ComplexFunction(Window, MwmWindow *, XEvent *, unsigned long, MenuRoot *);
extern int      DeferExecution(XEvent *, Window *, MwmWindow **, unsigned long *, int, int);
extern void     send_clientmessage(Window, Atom, Time);
extern void     SetBorder(MwmWindow *, Bool, Bool, Bool, Window);
extern void     move_window(XEvent *, Window, MwmWindow *, int, int, int, int, int);
extern void     resize_window(Window, MwmWindow *, int, int, int, int);
extern void     CreateIconWindow(MwmWindow *, int, int);
extern void     send_clientmessage(Window, Atom, Time);
extern void     SetMapStateProp(MwmWindow *, int);
extern void     SetStickyProp(MwmWindow *, int, int, int);
extern void     SetClientProp(MwmWindow *);
extern void     Iconify(MwmWindow *, int, int);
extern void     DeIconify(MwmWindow *);
extern void     PopDownMenu(void);
extern void     KeepOnTop(void);
extern void     show_panner(void);
extern void     WaitForButtonsUp(void);
extern void     FocusOn(MwmWindow * t, int DeIconifyOnly);
extern Bool     PlaceWindow(MwmWindow * tmp_win, unsigned long flags, int Desk);
extern void     free_window_names(MwmWindow * tmp, Bool nukename, Bool nukeicon);

extern int      do_menu(MenuRoot * menu);
extern int      check_allowed_function(MenuItem * mi);
extern int      check_allowed_function2(int function, MwmWindow * t);
extern void     ReInstallActiveColormap(void);
#ifdef __GNUC__
extern inline void DrawPattern(Window, GC, GC, int, int, int);
#else
extern void DrawPattern(Window, GC, GC, int, int, int);
#endif
extern MwmWindow *Circulate(MwmWindow * tmp_win, char *action, Bool Direction);
extern void     changeDesks(int val1, int val2);
extern void     changeWindowsDesk(MwmWindow * t, int val1);
extern void     MapIt(MwmWindow * t);
extern void     UnmapIt(MwmWindow * t);
extern void     do_save(void);
extern void     checkPanFrames(void);
extern void     raisePanFrames(void);
extern void     initPanFrames(void);
extern Bool     StashEventTime(XEvent * ev);
extern int      matchWildcards(char *pattern, char *string);
extern int      My_XNextEvent(Display * dpy, XEvent * event);
extern void     ClearCirculatedFlag();
extern void     FlushQueue(int module);
extern void     QuickRestart(void);
extern void     AddFuncKey(char *, int, int, int, char *, int, int, MenuRoot *,
			   char, char);
extern void     InteractiveMove(Window * w, MwmWindow * tmp_win, int *FinalX, int *FinalY,
				XEvent * eventp);
extern void     Reborder(void);
extern void     SigDone(int);
extern void     Restart(int nonsense);
extern void     Done(int, char *);
extern void     AddWmResourceConverters();
extern void     GetClientResources(MwmWindow *win, char *name, char *class);
extern void     GetClientDefaults(MwmWindow *tmp_win, char *name, char *class);
/*
 * mwm resources
 */
extern const char mwm_strings[];

#ifndef XmNautoKeyFocus
#define XmNautoKeyFocus ((char *)&mwm_strings[0])
#endif

#ifndef XmCAutoKeyFocus
#define XmCAutoKeyFocus ((char *)&mwm_strings[13])
#endif

#ifndef XmNautoRaiseDelay
#define XmNautoRaiseDelay ((char *)&mwm_strings[26])
#endif

#ifndef XmCAutoRaiseDelay
#define XmCAutoRaiseDelay ((char *)&mwm_strings[41])
#endif

#ifndef XmNbitmapDirectory
#define XmNbitmapDirectory ((char *)&mwm_strings[56])
#endif

#ifndef XmCBitmapDirectory
#define XmCBitmapDirectory ((char *)&mwm_strings[72])
#endif

#ifndef XmNbuttonBindings
#define XmNbuttonBindings ((char *)&mwm_strings[88])
#endif

#ifndef XmCButtonBindings
#define XmCButtonBindings ((char *)&mwm_strings[103])
#endif

#ifndef XmNcleanText
#define XmNcleanText ((char *)&mwm_strings[118])
#endif

#ifndef XmCCleanText
#define XmCCleanText ((char *)&mwm_strings[128])
#endif

#ifndef XmNclientAutoPlace
#define XmNclientAutoPlace ((char *)&mwm_strings[138])
#endif

#ifndef XmCClientAutoPlace
#define XmCClientAutoPlace ((char *)&mwm_strings[154])
#endif

#ifndef XmNcolormapFocusPolicy
#define XmNcolormapFocusPolicy ((char *)&mwm_strings[170])
#endif

#ifndef XmCColormapFocusPolicy
#define XmCColormapFocusPolicy ((char *)&mwm_strings[190])
#endif

#ifndef XmNconfigFile
#define XmNconfigFile ((char *)&mwm_strings[210])
#endif

#ifndef XmCConfigFile
#define XmCConfigFile ((char *)&mwm_strings[221])
#endif

#ifndef XmNdeiconifyKeyFocus
#define XmNdeiconifyKeyFocus ((char *)&mwm_strings[232])
#endif

#ifndef XmCDeiconifyKeyFocus
#define XmCDeiconifyKeyFocus ((char *)&mwm_strings[250])
#endif

#ifndef XmNdoubleClickTime
#define XmNdoubleClickTime ((char *)&mwm_strings[268])
#endif

#ifndef XmCDoubleClickTime
#define XmCDoubleClickTime ((char *)&mwm_strings[284])
#endif

#ifndef XmNenableWarp
#define XmNenableWarp ((char *)&mwm_strings[300])
#endif

#ifndef XmCEnableWarp
#define XmCEnableWarp ((char *)&mwm_strings[311])
#endif

#ifndef XmNenforceKeyFocus
#define XmNenforceKeyFocus ((char *)&mwm_strings[322])
#endif

#ifndef XmCEnforceKeyFocus
#define XmCEnforceKeyFocus ((char *)&mwm_strings[338])
#endif

#ifndef XmNfadeNormalIcon
#define XmNfadeNormalIcon ((char *)&mwm_strings[354])
#endif

#ifndef XmCFadeNormalIcon
#define XmCFadeNormalIcon ((char *)&mwm_strings[369])
#endif

#ifndef XmNfeedbackGeometry
#define XmNfeedbackGeometry ((char *)&mwm_strings[384])
#endif

#ifndef XmCFeedbackGeometry
#define XmCFeedbackGeometry ((char *)&mwm_strings[401])
#endif

#ifndef XmNfreezeOnConfig
#define XmNfreezeOnConfig ((char *)&mwm_strings[418])
#endif

#ifndef XmCFreezeOnConfig
#define XmCFreezeOnConfig ((char *)&mwm_strings[433])
#endif

#ifndef XmNframeBorderWidth
#define XmNframeBorderWidth ((char *)&mwm_strings[448])
#endif

#ifndef XmCFrameBorderWidth
#define XmCFrameBorderWidth ((char *)&mwm_strings[465])
#endif

#ifndef XmNiconAutoPlace
#define XmNiconAutoPlace ((char *)&mwm_strings[482])
#endif

#ifndef XmCIconAutoPlace
#define XmCIconAutoPlace ((char *)&mwm_strings[496])
#endif

#ifndef XmNiconBoxGeometry
#define XmNiconBoxGeometry ((char *)&mwm_strings[510])
#endif

#ifndef XmCIconBoxGeometry
#define XmCIconBoxGeometry ((char *)&mwm_strings[526])
#endif

#ifndef XmNiconBoxName
#define XmNiconBoxName ((char *)&mwm_strings[542])
#endif

#ifndef XmCIconBoxName
#define XmCIconBoxName ((char *)&mwm_strings[554])
#endif

#ifndef XmNiconBoxSBDisplayPolicy
#define XmNiconBoxSBDisplayPolicy ((char *)&mwm_strings[566])
#endif

#ifndef XmCIconBoxSBDisplayPolicy
#define XmCIconBoxSBDisplayPolicy ((char *)&mwm_strings[589])
#endif

#ifndef XmNiconBoxScheme
#define XmNiconBoxScheme ((char *)&mwm_strings[612])
#endif

#ifndef XmCIconBoxScheme
#define XmCIconBoxScheme ((char *)&mwm_strings[626])
#endif

#ifndef XmNiconBoxTitle
#define XmNiconBoxTitle ((char *)&mwm_strings[640])
#endif

#ifndef XmCIconBoxTitle
#define XmCIconBoxTitle ((char *)&mwm_strings[653])
#endif

#ifndef XmNiconClick
#define XmNiconClick ((char *)&mwm_strings[666])
#endif

#ifndef XmCIconClick
#define XmCIconClick ((char *)&mwm_strings[676])
#endif

#ifndef XmNiconDecoration
#define XmNiconDecoration ((char *)&mwm_strings[686])
#endif

#ifndef XmCIconDecoration
#define XmCIconDecoration ((char *)&mwm_strings[701])
#endif

#ifndef XmNiconImageMaximum
#define XmNiconImageMaximum ((char *)&mwm_strings[716])
#endif

#ifndef XmCIconImageMaximum
#define XmCIconImageMaximum ((char *)&mwm_strings[733])
#endif

#ifndef XmNiconImageMinimum
#define XmNiconImageMinimum ((char *)&mwm_strings[750])
#endif

#ifndef XmCIconImageMinimum
#define XmCIconImageMinimum ((char *)&mwm_strings[767])
#endif

#ifndef XmNiconPlacement
#define XmNiconPlacement ((char *)&mwm_strings[784])
#endif

#ifndef XmCIconPlacement
#define XmCIconPlacement ((char *)&mwm_strings[798])
#endif

#ifndef XmNiconPlacementMargin
#define XmNiconPlacementMargin ((char *)&mwm_strings[812])
#endif

#ifndef XmCIconPlacementMargin
#define XmCIconPlacementMargin ((char *)&mwm_strings[832])
#endif

#ifndef XmNinteractivePlacement
#define XmNinteractivePlacement ((char *)&mwm_strings[852])
#endif

#ifndef XmCInteractivePlacement
#define XmCInteractivePlacement ((char *)&mwm_strings[873])
#endif

#ifndef XmNkeyBindings
#define XmNkeyBindings ((char *)&mwm_strings[894])
#endif

#ifndef XmCKeyBindings
#define XmCKeyBindings ((char *)&mwm_strings[906])
#endif

#ifndef XmNlimitResize
#define XmNlimitResize ((char *)&mwm_strings[918])
#endif

#ifndef XmCLimitResize
#define XmCLimitResize ((char *)&mwm_strings[930])
#endif

#ifndef XmNlowerOnIconify
#define XmNlowerOnIconify ((char *)&mwm_strings[942])
#endif

#ifndef XmCLowerOnIconify
#define XmCLowerOnIconify ((char *)&mwm_strings[957])
#endif

#ifndef XmNmaximumMaximumSize
#define XmNmaximumMaximumSize ((char *)&mwm_strings[972])
#endif

#ifndef XmCMaximumMaximumSize
#define XmCMaximumMaximumSize ((char *)&mwm_strings[991])
#endif

#ifndef XmNmoveThreshold
#define XmNmoveThreshold ((char *)&mwm_strings[1010])
#endif

#ifndef XmCMoveThreshold
#define XmCMoveThreshold ((char *)&mwm_strings[1024])
#endif

#ifndef XmNmultiScreen
#define XmNmultiScreen ((char *)&mwm_strings[1038])
#endif

#ifndef XmCMultiScreen
#define XmCMultiScreen ((char *)&mwm_strings[1050])
#endif

#ifndef XmNpassButtons
#define XmNpassButtons ((char *)&mwm_strings[1062])
#endif

#ifndef XmCPassButtons
#define XmCPassButtons ((char *)&mwm_strings[1074])
#endif

#ifndef XmNpassSelectButton
#define XmNpassSelectButton ((char *)&mwm_strings[1086])
#endif

#ifndef XmCPassSelectButton
#define XmCPassSelectButton ((char *)&mwm_strings[1103])
#endif

#ifndef XmNpositionIsFrame
#define XmNpositionIsFrame ((char *)&mwm_strings[1120])
#endif

#ifndef XmCPositionIsFrame
#define XmCPositionIsFrame ((char *)&mwm_strings[1136])
#endif

#ifndef XmNpositionOnScreen
#define XmNpositionOnScreen ((char *)&mwm_strings[1152])
#endif

#ifndef XmCPositionOnScreen
#define XmCPositionOnScreen ((char *)&mwm_strings[1169])
#endif

#ifndef XmNquitTimeout
#define XmNquitTimeout ((char *)&mwm_strings[1186])
#endif

#ifndef XmCQuitTimeout
#define XmCQuitTimeout ((char *)&mwm_strings[1198])
#endif

#ifndef XmNraiseKeyFocus
#define XmNraiseKeyFocus ((char *)&mwm_strings[1210])
#endif

#ifndef XmCRaiseKeyFocus
#define XmCRaiseKeyFocus ((char *)&mwm_strings[1224])
#endif

#ifndef XmNresizeBorderWidth
#define XmNresizeBorderWidth ((char *)&mwm_strings[1238])
#endif

#ifndef XmCFrameBorderWidth
#define XmCFrameBorderWidth ((char *)&mwm_strings[1256])
#endif

#ifndef XmNresizeCursors
#define XmNresizeCursors ((char *)&mwm_strings[1273])
#endif

#ifndef XmCResizeCursors
#define XmCResizeCursors ((char *)&mwm_strings[1287])
#endif

#ifndef XmNscreens
#define XmNscreens ((char *)&mwm_strings[1301])
#endif

#ifndef XmCScreens
#define XmCScreens ((char *)&mwm_strings[1309])
#endif

#ifndef XmNshowFeedback
#define XmNshowFeedback ((char *)&mwm_strings[1317])
#endif

#ifndef XmCShowFeedback
#define XmCShowFeedback ((char *)&mwm_strings[1330])
#endif

#ifndef XmNstartupKeyFocus
#define XmNstartupKeyFocus ((char *)&mwm_strings[1343])
#endif

#ifndef XmCStartupKeyFocus
#define XmCStartupKeyFocus ((char *)&mwm_strings[1359])
#endif

#ifndef XmNtransientDecoration
#define XmNtransientDecoration ((char *)&mwm_strings[1375])
#endif

#ifndef XmCTransientDecoration
#define XmCTransientDecoration ((char *)&mwm_strings[1395])
#endif

#ifndef XmNtransientFunctions
#define XmNtransientFunctions ((char *)&mwm_strings[1415])
#endif

#ifndef XmCTransientFunctions
#define XmCTransientFunctions ((char *)&mwm_strings[1434])
#endif

#ifndef XmNuseIconBox
#define XmNuseIconBox ((char *)&mwm_strings[1453])
#endif

#ifndef XmCUseIconBox
#define XmCUseIconBox ((char *)&mwm_strings[1464])
#endif

#ifndef XmNwMenuButtonClick
#define XmNwMenuButtonClick ((char *)&mwm_strings[1475])
#endif

#ifndef XmCWMenuButtonClick
#define XmCWMenuButtonClick ((char *)&mwm_strings[1492])
#endif

#ifndef XmNwMenuButtonClick2
#define XmNwMenuButtonClick2 ((char *)&mwm_strings[1509])
#endif

#ifndef XmCWMenuButtonClick2
#define XmCWMenuButtonClick2 ((char *)&mwm_strings[1527])
#endif

#ifndef XmNclientDecoration
#define XmNclientDecoration ((char *)&mwm_strings[1545])
#endif

#ifndef XmCClientDecoration
#define XmCClientDecoration ((char *)&mwm_strings[1562])
#endif

#ifndef XmNclientFunctions
#define XmNclientFunctions ((char *)&mwm_strings[1579])
#endif

#ifndef XmCClientFunctions
#define XmCClientFunctions ((char *)&mwm_strings[1595])
#endif

#ifndef XmNfocusAutoRaise
#define XmNfocusAutoRaise ((char *)&mwm_strings[1611])
#endif

#ifndef XmCFocusAutoRaise
#define XmCFocusAutoRaise ((char *)&mwm_strings[1626])
#endif

#ifndef XmNiconImage
#define XmNiconImage ((char *)&mwm_strings[1641])
#endif

#ifndef XmCIconImage
#define XmCIconImage ((char *)&mwm_strings[1651])
#endif

#ifndef XmNiconImageBackground
#define XmNiconImageBackground ((char *)&mwm_strings[1661])
#endif

#ifndef XmCIconImageBackground
#define XmCIconImageBackground ((char *)&mwm_strings[1681])
#endif

#ifndef XmNiconImageBottomShadowColor
#define XmNiconImageBottomShadowColor ((char *)&mwm_strings[1701])
#endif

#ifndef XmCIconImageBottomShadowColor
#define XmCIconImageBottomShadowColor ((char *)&mwm_strings[1728])
#endif

#ifndef XmNiconImageBottomShadowPixmap
#define XmNiconImageBottomShadowPixmap ((char *)&mwm_strings[1755])
#endif

#ifndef XmCIconImageBottomShadowPixmap
#define XmCIconImageBottomShadowPixmap ((char *)&mwm_strings[1783])
#endif

#ifndef XmNiconImageForeground
#define XmNiconImageForeground ((char *)&mwm_strings[1811])
#endif

#ifndef XmCIconImageForeground
#define XmCIconImageForeground ((char *)&mwm_strings[1831])
#endif

#ifndef XmNiconImageTopShadowColor
#define XmNiconImageTopShadowColor ((char *)&mwm_strings[1851])
#endif

#ifndef XmCIconImageTopShadowColor
#define XmCIconImageTopShadowColor ((char *)&mwm_strings[1875])
#endif

#ifndef XmNiconImageTopShadowPixmap
#define XmNiconImageTopShadowPixmap ((char *)&mwm_strings[1899])
#endif

#ifndef XmCIconImageTopShadowPixmap
#define XmCIconImageTopShadowPixmap ((char *)&mwm_strings[1924])
#endif

#ifndef XmNmatteBackground
#define XmNmatteBackground ((char *)&mwm_strings[1949])
#endif

#ifndef XmCMatteBackground
#define XmCMatteBackground ((char *)&mwm_strings[1965])
#endif

#ifndef XmNmatteBottomShadowColor
#define XmNmatteBottomShadowColor ((char *)&mwm_strings[1981])
#endif

#ifndef XmCMatteBottomShadowColor
#define XmCMatteBottomShadowColor ((char *)&mwm_strings[2004])
#endif

#ifndef XmNmatteBottomShadowPixmap
#define XmNmatteBottomShadowPixmap ((char *)&mwm_strings[2027])
#endif

#ifndef XmCMatteBottomShadowPixmap
#define XmCMatteBottomShadowPixmap ((char *)&mwm_strings[2051])
#endif

#ifndef XmNmatteForeground
#define XmNmatteForeground ((char *)&mwm_strings[2075])
#endif

#ifndef XmCMatteForeground
#define XmCMatteForeground ((char *)&mwm_strings[2091])
#endif

#ifndef XmNmatteTopShadowColor
#define XmNmatteTopShadowColor ((char *)&mwm_strings[2107])
#endif

#ifndef XmCMatteTopShadowColor
#define XmCMatteTopShadowColor ((char *)&mwm_strings[2127])
#endif

#ifndef XmNmatteTopShadowPixmap
#define XmNmatteTopShadowPixmap ((char *)&mwm_strings[2147])
#endif

#ifndef XmCMatteTopShadowPixmap
#define XmCMatteTopShadowPixmap ((char *)&mwm_strings[2168])
#endif

#ifndef XmNmatteWidth
#define XmNmatteWidth ((char *)&mwm_strings[2189])
#endif

#ifndef XmCMatteWidth
#define XmCMatteWidth ((char *)&mwm_strings[2200])
#endif

#ifndef XmNmaximumClientSize
#define XmNmaximumClientSize ((char *)&mwm_strings[2211])
#endif

#ifndef XmCMaximumClientSize
#define XmCMaximumClientSize ((char *)&mwm_strings[2229])
#endif

#ifndef XmNuseClientIcon
#define XmNuseClientIcon ((char *)&mwm_strings[2247])
#endif

#ifndef XmCUseClientIcon
#define XmCUseClientIcon ((char *)&mwm_strings[2261])
#endif

#ifndef XmNusePPosition
#define XmNusePPosition ((char *)&mwm_strings[2275])
#endif

#ifndef XmCUsePPosition
#define XmCUsePPosition ((char *)&mwm_strings[2288])
#endif

#ifndef XmNwindowMenu
#define XmNwindowMenu ((char *)&mwm_strings[2301])
#endif

#ifndef XmCWindowMenu
#define XmCWindowMenu ((char *)&mwm_strings[2312])
#endif

#ifndef XmNactiveBackground
#define XmNactiveBackground ((char *)&mwm_strings[2323])
#endif

#ifndef XmNactiveForeground
#define XmNactiveForeground ((char *)&mwm_strings[2340])
#endif

#ifndef XmNactiveBottomShadowColor
#define XmNactiveBottomShadowColor ((char *)&mwm_strings[2357])
#endif

#ifndef XmNactiveBottomShadowPixmap
#define XmNactiveBottomShadowPixmap ((char *)&mwm_strings[2381])
#endif

#ifndef XmNactiveTopShadowColor
#define XmNactiveTopShadowColor ((char *)&mwm_strings[2406])
#endif

#ifndef XmNactiveBackgroundPixmap
#define XmNactiveBackgroundPixmap ((char *)&mwm_strings[2427])
#endif

#ifndef XmNactiveTopShadowPixmap
#define XmNactiveTopShadowPixmap ((char *)&mwm_strings[2450])
#endif

#ifndef XmRWmCFocus
#define XmRWmCFocus ((char *)&mwm_strings[2472])
#endif

#ifndef XmRWmCDecor
#define XmRWmCDecor ((char *)&mwm_strings[2481])
#endif

#ifndef XmRWmCFunc
#define XmRWmCFunc ((char *)&mwm_strings[2490])
#endif

#ifndef XmRWmIDecor
#define XmRWmIDecor ((char *)&mwm_strings[2498])
#endif

#ifndef XmRWmIPlace
#define XmRWmIPlace ((char *)&mwm_strings[2507])
#endif

#ifndef XmRWmKFocus
#define XmRWmKFocus ((char *)&mwm_strings[2516])
#endif

#ifndef XmRWmSize
#define XmRWmSize ((char *)&mwm_strings[2525])
#endif

#ifndef XmRWmShowFeedback
#define XmRWmShowFeedback ((char *)&mwm_strings[2532])
#endif

#ifndef XmRWmUsePPosition
#define XmRWmUsePPosition ((char *)&mwm_strings[2547])
#endif

#ifndef XmNclientFlags
#define XmNclientFlags ((char *)&mwm_strings[2562])
#endif

#ifndef XmCClientFlags
#define XmCClientFlags ((char *)&mwm_strings[2574])
#endif

#ifndef XmRWmCFlags
#define XmRWmCFlags ((char *)&mwm_strings[2586])
#endif

#ifndef XmNusePager
#define XmNusePager ((char *)&mwm_strings[2595])
#endif

#ifndef XmCUsePager
#define XmCUsePager ((char *)&mwm_strings[2604])
#endif

/*
 * global data
 */
extern MwmInternalInfo Mwm;
extern ScreenInfo Scr;
extern MenuRoot *ActiveMenu;
extern MenuItem *ActiveItem;
extern XGCValues Globalgcv;
extern unsigned long Globalgcm;
extern MwmFont *IconFont;
extern Time     lastTimestamp;
extern XEvent   Event;
extern char     NoName[];
extern Display *dpy;
extern XClassHint NoClass;
extern XContext MwmContext;
extern Window   JunkRoot, JunkChild;
extern int      JunkX, JunkY;
extern unsigned int JunkWidth, JunkHeight, JunkBW, JunkDepth, JunkMask;
extern Widget   toplevel;
extern Widget   quit_mb;
extern Widget   restart_mb;
extern Widget   xmDisplay;
extern WidgetList xmScreens;
extern Boolean  is_custom;

extern Atom     _XA_MIT_PRIORITY_COLORS;
extern Atom     _XA_WM_CHANGE_STATE;
extern Atom     _XA_WM_STATE;
extern Atom     _XA_WM_COLORMAP_WINDOWS;
extern Atom     _XA_WM_PROTOCOLS;
extern Atom     _XA_WM_TAKE_FOCUS;
extern Atom     _XA_WM_SAVE_YOURSELF;
extern Atom     _XA_WM_DELETE_WINDOW;
extern Atom     _XA_WM_DESKTOP;
extern Atom     _XA_MWM_STICKS_TO_GLASS;
extern Atom     _XA_MWM_CLIENT;

#endif /* _MWM_ */
