/**
 *
 * $Id: defaults.c,v 1.2 1996/01/16 12:24:11 miers Exp $
 *
 * Copyright (C) 1995 Free Software Foundation, Inc.
 *
 * This file is part of the GNU LessTif Library.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **/
#include "mwm.h"

/*
 * This stuff will get used as I write stuff
 *
 Toggle to Default Behavior?
 Toggle to Custom Behavior?
 confirmDefaultBehavior
 confirmCustomBehavior
 confirmRestart
 confirmQuit
 ISO8859-1

 Icons
 "Pack Icons" _P  Shift Alt<Key>F7 f.pack_icons
 XBMLANGPATH
 * function names came from running strings against mwm on Solaris
 */
void *working_base = NULL;

#if 0
/* assorted gray bitmaps for decorative borders */
#define g_width 2
#define g_height 2
static char     g_bits[] =
{0x02, 0x01};

#define l_g_width 4
#define l_g_height 2
static char     l_g_bits[] =
{0x08, 0x02};

#define s_g_width 4
#define s_g_height 4
static char     s_g_bits[] =
{0x01, 0x02, 0x04, 0x08};
#endif

void
_WmMultiClickTimeDefault(Widget widget, int offset, XrmValue * val)
{
    static int time;

    time = XtGetMultiClickTime(XtDisplayOfObject(toplevel));
    val->addr = (XtPointer)&time;
}

void
_WmDefaultBorderWidth(Widget widget, int offset, XrmValue * val)
{
    static Dimension border_width;

    border_width = 5;
    val->addr = (XtPointer)&border_width;
}

void
_WmFocusAutoRaiseDefault(Widget widget, int offset, XrmValue * val)
{
    static Boolean raise;

    if (Mwm.keyboard_focus_policy == XmEXPLICIT)
	raise = True;
    else if (Mwm.keyboard_focus_policy == XmPOINTER)
	raise = False;
    else {
	_XmWarning(toplevel, "Keyboard Focus Policy is unknown.\n");
	raise = True;
    }
    val->addr = (XtPointer)&raise;
}

void
_WmIconImageBDefault(Widget widget, int offset, XrmValue * val)
{
    static XColor backgroundColor;

    if (!XParseColor(XtDisplay(toplevel),
                     DefaultColormapOfScreen(XtScreen(toplevel)),
		     "LightGrey",
                     &backgroundColor)) {
	if (!XParseColor(XtDisplay(toplevel),
			 DefaultColormapOfScreen(XtScreen(toplevel)),
			 "#A8A8A8A8A8A8",
			 &backgroundColor)) {
	    backgroundColor.pixel = WhitePixelOfScreen(XtScreen(toplevel));
	}
	else {
	    XAllocColor(XtDisplay(toplevel),
			DefaultColormapOfScreen(XtScreen(toplevel)),
			&backgroundColor);
	}
    }
    else {
	XAllocColor(XtDisplay(toplevel),
		    DefaultColormapOfScreen(XtScreen(toplevel)),
		    &backgroundColor);
    }

    val->addr = (XtPointer)&backgroundColor.pixel;
}

void
_WmIconImageBSCDefault(Widget widget, int offset, XrmValue * val)
{
    XColor _widgetBackground;
    static XColor bottomShadowColor;
    void *w = working_base;

    _widgetBackground.pixel = ((MwmWindow *)w)->icon_image_background;

    XQueryColor(XtDisplay(toplevel),
                DefaultColormapOfScreen(XtScreen(toplevel)),
                &_widgetBackground);

    bottomShadowColor.blue = _widgetBackground.blue * .5;
    bottomShadowColor.green = _widgetBackground.green * .5;
    bottomShadowColor.red = _widgetBackground.red * .5;

    if (!XAllocColor(XtDisplay(toplevel),
                     DefaultColormapOfScreen(XtScreen(toplevel)),
                     &bottomShadowColor))
        bottomShadowColor.pixel = WhitePixelOfScreen(XtScreen(toplevel));

    val->addr = (XtPointer)&bottomShadowColor.pixel;
}

void
_WmIconImageBSPDefault(Widget widget, int offset, XrmValue * val)
{
    static Pixmap pix = XmUNSPECIFIED_PIXMAP;

    val->addr = (XtPointer)&pix;
}

void
_WmIconImageFDefault(Widget widget, int offset, XrmValue * val)
{
    double h,s,v;
    XColor _widgetBackground;
    static XColor foregroundColor;
    void *w = working_base;

    _widgetBackground.pixel = ((MwmWindow *)w)->icon_image_background;

    XQueryColor(XtDisplay(toplevel),
                DefaultColormapOfScreen(XtScreen(toplevel)),
                &_widgetBackground);

    __XmRGB2HSV(_widgetBackground.red,
                _widgetBackground.green,
                _widgetBackground.blue,
                &h,&s,&v);

    if (v<0.5)
        foregroundColor.pixel = WhitePixelOfScreen(XtScreen(toplevel));
    else
        foregroundColor.pixel = BlackPixelOfScreen(XtScreen(toplevel));

    XQueryColor(XtDisplay(toplevel),
                DefaultColormapOfScreen(XtScreen(toplevel)),
                &foregroundColor);

    val->addr = (XtPointer)&foregroundColor.pixel;
}

void
_WmIconImageTSCDefault(Widget widget, int offset, XrmValue * val)
{
    XColor _widgetBackground;
    static XColor topShadowColor;
    void *w = working_base;

    _widgetBackground.pixel = ((MwmWindow *)w)->icon_image_background;

    XQueryColor(XtDisplay(toplevel),
                DefaultColormapOfScreen(XtScreen(toplevel)),
                &_widgetBackground);

    if (_widgetBackground.red > 65535/1.5)
        topShadowColor.red = 65535;
    else
        topShadowColor.red = _widgetBackground.red * 1.5;

    if (_widgetBackground.green > 65535/1.5)
        topShadowColor.green = 65535;
    else
        topShadowColor.green = _widgetBackground.green * 1.5;

    if (_widgetBackground.blue > 65535/1.5)
        topShadowColor.blue = 65535;
    else
        topShadowColor.blue = _widgetBackground.blue * 1.5;


    if (!XAllocColor(XtDisplay(toplevel),
                     DefaultColormapOfScreen(XtScreen(toplevel)),
                     &topShadowColor))
        topShadowColor.pixel = WhitePixelOfScreen(XtScreen(toplevel));

    val->addr = (XtPointer)&topShadowColor.pixel;
}

void
_WmIconImageTSPDefault(Widget widget, int offset, XrmValue * val)
{
    static Pixmap pix = XmUNSPECIFIED_PIXMAP;

    val->addr = (XtPointer)&pix;
}

void
_WmMatteBDefault(Widget widget, int offset, XrmValue * val)
{
    static XColor backgroundColor;
    void *w = working_base;

    if (!XParseColor(XtDisplay(toplevel),
                     DefaultColormapOfScreen(XtScreen(toplevel)),
		     "LightGrey",
                     &backgroundColor)) {
	if (!XParseColor(XtDisplay(toplevel),
			 DefaultColormapOfScreen(XtScreen(toplevel)),
			 "#A8A8A8A8A8A8",
			 &backgroundColor)) {
	    backgroundColor.pixel = WhitePixelOfScreen(XtScreen(toplevel));
	}
	else {
	    XAllocColor(XtDisplay(toplevel),
			DefaultColormapOfScreen(XtScreen(toplevel)),
			&backgroundColor);
	}
    }
    else {
	XAllocColor(XtDisplay(toplevel),
		    DefaultColormapOfScreen(XtScreen(toplevel)),
		    &backgroundColor);
    }

    val->addr = (XtPointer)&backgroundColor.pixel;
}

void
_WmMatteBSCDefault(Widget widget, int offset, XrmValue * val)
{
    XColor _widgetBackground;
    static XColor bottomShadowColor;
    void *w = working_base;

    _widgetBackground.pixel = ((MwmWindow *)w)->matte_background;

    XQueryColor(XtDisplay(toplevel),
                DefaultColormapOfScreen(XtScreen(toplevel)),
                &_widgetBackground);

    bottomShadowColor.blue = _widgetBackground.blue * .5;
    bottomShadowColor.green = _widgetBackground.green * .5;
    bottomShadowColor.red = _widgetBackground.red * .5;

    if (!XAllocColor(XtDisplay(toplevel),
                     DefaultColormapOfScreen(XtScreen(toplevel)),
                     &bottomShadowColor))
        bottomShadowColor.pixel = WhitePixelOfScreen(XtScreen(toplevel));

    val->addr = (XtPointer)&bottomShadowColor.pixel;
}

void
_WmMatteBSPDefault(Widget widget, int offset, XrmValue * val)
{
    static Pixmap pix = XmUNSPECIFIED_PIXMAP;

    val->addr = (XtPointer)&pix;
}

void
_WmMatteFDefault(Widget widget, int offset, XrmValue * val)
{
    double h,s,v;
    XColor _widgetBackground;
    static XColor foregroundColor;
    void *w = working_base;

    _widgetBackground.pixel = ((MwmWindow *)w)->matte_background;

    XQueryColor(XtDisplay(toplevel),
                DefaultColormapOfScreen(XtScreen(toplevel)),
                &_widgetBackground);

    __XmRGB2HSV(_widgetBackground.red,
                _widgetBackground.green,
                _widgetBackground.blue,
                &h,&s,&v);

    if (v<0.5)
        foregroundColor.pixel = WhitePixelOfScreen(XtScreen(toplevel));
    else
        foregroundColor.pixel = BlackPixelOfScreen(XtScreen(toplevel));

    XQueryColor(XtDisplay(toplevel),
                DefaultColormapOfScreen(XtScreen(toplevel)),
                &foregroundColor);

    val->addr = (XtPointer)&foregroundColor.pixel;
}

void
_WmMatteTSCDefault(Widget widget, int offset, XrmValue * val)
{
    XColor _widgetBackground;
    static XColor topShadowColor;
    void *w = working_base;

    _widgetBackground.pixel = ((MwmWindow *)w)->matte_background;

    XQueryColor(XtDisplay(toplevel),
                DefaultColormapOfScreen(XtScreen(toplevel)),
                &_widgetBackground);

    if (_widgetBackground.red > 65535/1.5)
        topShadowColor.red = 65535;
    else
        topShadowColor.red = _widgetBackground.red * 1.5;

    if (_widgetBackground.green > 65535/1.5)
        topShadowColor.green = 65535;
    else
        topShadowColor.green = _widgetBackground.green * 1.5;

    if (_widgetBackground.blue > 65535/1.5)
        topShadowColor.blue = 65535;
    else
        topShadowColor.blue = _widgetBackground.blue * 1.5;


    if (!XAllocColor(XtDisplay(toplevel),
                     DefaultColormapOfScreen(XtScreen(toplevel)),
                     &topShadowColor))
        topShadowColor.pixel = WhitePixelOfScreen(XtScreen(toplevel));

    val->addr = (XtPointer)&topShadowColor.pixel;
}

void
_WmMatteTSPDefault(Widget widget, int offset, XrmValue * val)
{
    static Pixmap pix = XmUNSPECIFIED_PIXMAP;
    void *w = working_base;

    val->addr = (XtPointer)&pix;
}

void
_WmBackgroundDefault(Widget widget, int offset, XrmValue * val)
{
    static XColor backgroundColor;
    void *w = working_base;

    if (!XParseColor(XtDisplay(toplevel),
                     DefaultColormapOfScreen(XtScreen(toplevel)),
		     "LightGrey",
                     &backgroundColor)) {
	if (!XParseColor(XtDisplay(toplevel),
			 DefaultColormapOfScreen(XtScreen(toplevel)),
			 "#A8A8A8A8A8A8",
			 &backgroundColor)) {
	    backgroundColor.pixel = WhitePixelOfScreen(XtScreen(toplevel));
	}
	else {
	    XAllocColor(XtDisplay(toplevel),
			DefaultColormapOfScreen(XtScreen(toplevel)),
			&backgroundColor);
	}
    }
    else {
	XAllocColor(XtDisplay(toplevel),
		    DefaultColormapOfScreen(XtScreen(toplevel)),
		    &backgroundColor);
    }
    val->addr = (XtPointer)&backgroundColor.pixel;
}

void
_WmBackgroundPixmapDefault(Widget widget, int offset, XrmValue * val)
{
    static Pixmap pix = XmUNSPECIFIED_PIXMAP;

    val->addr = (XtPointer)&pix;
}

void
_WmBottomShadowColorDefault(Widget widget, int offset, XrmValue * val)
{
    XColor _widgetBackground;
    static XColor bottomShadowColor;
    void *w = working_base;

    _widgetBackground.pixel = ((ComponentInfo *)w)->background;

    XQueryColor(XtDisplay(toplevel),
                DefaultColormapOfScreen(XtScreen(toplevel)),
                &_widgetBackground);

    bottomShadowColor.blue = _widgetBackground.blue * .5;
    bottomShadowColor.green = _widgetBackground.green * .5;
    bottomShadowColor.red = _widgetBackground.red * .5;
    if (!XAllocColor(XtDisplay(toplevel),
                     DefaultColormapOfScreen(XtScreen(toplevel)),
                     &bottomShadowColor))
        bottomShadowColor.pixel = WhitePixelOfScreen(XtScreen(toplevel));

    val->addr = (XtPointer)&bottomShadowColor.pixel;
}

void
_WmBottomShadowPixmapDefault(Widget widget, int offset, XrmValue * val)
{
    static Pixmap pix = XmUNSPECIFIED_PIXMAP;

    val->addr = (XtPointer)&pix;
}

void
_WmForegroundDefault(Widget widget, int offset, XrmValue * val)
{
    double h,s,v;
    XColor _widgetBackground;
    static XColor foregroundColor;
    void *w = working_base;

    _widgetBackground.pixel = ((ComponentInfo *)w)->background;

    XQueryColor(XtDisplay(toplevel),
                DefaultColormapOfScreen(XtScreen(toplevel)),
                &_widgetBackground);

    __XmRGB2HSV(_widgetBackground.red,
                _widgetBackground.green,
                _widgetBackground.blue,
                &h,&s,&v);

    if (v<0.5)
        foregroundColor.pixel = WhitePixelOfScreen(XtScreen(toplevel));
    else
        foregroundColor.pixel = BlackPixelOfScreen(XtScreen(toplevel));

    XQueryColor(XtDisplay(toplevel),
                DefaultColormapOfScreen(XtScreen(toplevel)),
                &foregroundColor);

    val->addr = (XtPointer)&foregroundColor.pixel;
}

void
_WmTopShadowColorDefault(Widget widget, int offset, XrmValue * val)
{
    XColor _widgetBackground;
    static XColor topShadowColor;
    void *w = working_base;

    _widgetBackground.pixel = ((ComponentInfo *)w)->background;

    XQueryColor(XtDisplay(toplevel),
                DefaultColormapOfScreen(XtScreen(toplevel)),
                &_widgetBackground);

    if (_widgetBackground.red > 65535/1.5)
        topShadowColor.red = 65535;
    else
        topShadowColor.red = _widgetBackground.red * 1.5;

    if (_widgetBackground.green > 65535/1.5)
        topShadowColor.green = 65535;
    else
        topShadowColor.green = _widgetBackground.green * 1.5;

    if (_widgetBackground.blue > 65535/1.5)
        topShadowColor.blue = 65535;
    else
        topShadowColor.blue = _widgetBackground.blue * 1.5;


    if (!XAllocColor(XtDisplay(toplevel),
                     DefaultColormapOfScreen(XtScreen(toplevel)),
                     &topShadowColor))
        topShadowColor.pixel = WhitePixelOfScreen(XtScreen(toplevel));

    val->addr = (XtPointer)&topShadowColor.pixel;
}

void
_WmTopShadowPixmapDefault(Widget widget, int offset, XrmValue * val)
{
    static Pixmap pix = XmUNSPECIFIED_PIXMAP;

    val->addr = (XtPointer)&pix;
}

void
_WmABackgroundDefault(Widget widget, int offset, XrmValue * val)
{
    static XColor backgroundColor;
    void *w = working_base;

    if (!XParseColor(XtDisplay(toplevel),
                     DefaultColormapOfScreen(XtScreen(toplevel)),
		     "Cadet Blue",
                     &backgroundColor)) {
	if (!XParseColor(XtDisplay(toplevel),
			 DefaultColormapOfScreen(XtScreen(toplevel)),
			 "#5F5F92929E9E",
			 &backgroundColor)) {
	    backgroundColor.pixel = WhitePixelOfScreen(XtScreen(toplevel));
	}
	else {
	    XAllocColor(XtDisplay(toplevel),
			DefaultColormapOfScreen(XtScreen(toplevel)),
			&backgroundColor);
	}
    }
    else {
	XAllocColor(XtDisplay(toplevel),
		    DefaultColormapOfScreen(XtScreen(toplevel)),
		    &backgroundColor);
    }

    val->addr = (XtPointer)&backgroundColor.pixel;
}

void
_WmAForegroundDefault(Widget widget, int offset, XrmValue * val)
{
    double h,s,v;
    XColor _widgetBackground;
    static XColor foregroundColor;
    void *w = working_base;

    _widgetBackground.pixel = ((ComponentInfo *)w)->background;

    XQueryColor(XtDisplay(toplevel),
                DefaultColormapOfScreen(XtScreen(toplevel)),
                &_widgetBackground);

    __XmRGB2HSV(_widgetBackground.red,
                _widgetBackground.green,
                _widgetBackground.blue,
                &h,&s,&v);

    if (v<0.5)
        foregroundColor.pixel = WhitePixelOfScreen(XtScreen(toplevel));
    else
        foregroundColor.pixel = BlackPixelOfScreen(XtScreen(toplevel));

    XQueryColor(XtDisplay(toplevel),
                DefaultColormapOfScreen(XtScreen(toplevel)),
                &foregroundColor);

    val->addr = (XtPointer)&foregroundColor.pixel;
}

void
_WmABottomShadowColorDefault(Widget widget, int offset, XrmValue * val)
{
    XColor _widgetBackground;
    static XColor bottomShadowColor;
    void *w = working_base;

    _widgetBackground.pixel = ((ComponentInfo *)w)->background;

    XQueryColor(XtDisplay(toplevel),
                DefaultColormapOfScreen(XtScreen(toplevel)),
                &_widgetBackground);

    bottomShadowColor.blue = _widgetBackground.blue * .5;
    bottomShadowColor.green = _widgetBackground.green * .5;
    bottomShadowColor.red = _widgetBackground.red * .5;

    if (!XAllocColor(XtDisplay(toplevel),
                     DefaultColormapOfScreen(XtScreen(toplevel)),
                     &bottomShadowColor))
        bottomShadowColor.pixel = WhitePixelOfScreen(XtScreen(toplevel));

    val->addr = (XtPointer)&bottomShadowColor.pixel;
}

void
_WmATopShadowColorDefault(Widget widget, int offset, XrmValue * val)
{
    XColor _widgetBackground;
    static XColor topShadowColor;
    void *w = working_base;

    _widgetBackground.pixel = ((ComponentInfo *)w)->background;

    XQueryColor(XtDisplay(toplevel),
                DefaultColormapOfScreen(XtScreen(toplevel)),
                &_widgetBackground);

    if (_widgetBackground.red > 65535/1.5)
        topShadowColor.red = 65535;
    else
        topShadowColor.red = _widgetBackground.red * 1.5;

    if (_widgetBackground.green > 65535/1.5)
        topShadowColor.green = 65535;
    else
        topShadowColor.green = _widgetBackground.green * 1.5;

    if (_widgetBackground.blue > 65535/1.5)
        topShadowColor.blue = 65535;
    else
        topShadowColor.blue = _widgetBackground.blue * 1.5;


    if (!XAllocColor(XtDisplay(toplevel),
                     DefaultColormapOfScreen(XtScreen(toplevel)),
                     &topShadowColor))
        topShadowColor.pixel = WhitePixelOfScreen(XtScreen(toplevel));

    val->addr = (XtPointer)&topShadowColor.pixel;
}

void
_WmABackgroundPixmapDefault(Widget widget, int offset, XrmValue * val)
{
    static Pixmap pix = XmUNSPECIFIED_PIXMAP;

    val->addr = (XtPointer)&pix;
}

void
_WmATopShadowPixmapDefault(Widget widget, int offset, XrmValue * val)
{
    static Pixmap pix = XmUNSPECIFIED_PIXMAP;

    val->addr = (XtPointer)&pix;
}
