------------------------------------------------------------------------------
--                                                                          --
--                         GNAT RUNTIME COMPONENTS                          --
--                                                                          --
--            S Y S T E M . P A R T I T I O N _ I N T E R F A C E           --
--                                                                          --
--                                  B o d y                                 --
--                                                                          --
--                             $Revision: 1.5 $                             --
--                                                                          --
--    Copyright (C) 1991,92,93,94,95,1996 Free Software Foundation, Inc.    --
--                                                                          --
-- GNARL is free software; you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion. GNARL is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNARL; see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- As a special exception,  if other files  instantiate  generics from this --
-- unit, or you link  this unit with other files  to produce an executable, --
-- this  unit  does not  by itself cause  the resulting  executable  to  be --
-- covered  by the  GNU  General  Public  License.  This exception does not --
-- however invalidate  any other reasons why  the executable file  might be --
-- covered by the  GNU Public License.                                      --
--                                                                          --
-- GNAT was originally developed  by the GNAT team at  New York University. --
-- It is now maintained by Ada Core Technologies Inc (http://www.gnat.com). --
--                                                                          --
------------------------------------------------------------------------------


package body System.Partition_Interface is

   function getpid return Integer;
   pragma Import (C, getpid);

   -----------------------------
   -- Get_Active_Partition_Id --
   -----------------------------

   function Get_Active_Partition_ID
     (Name : in Library_Unit_Name)
      return System.RPC.Partition_ID
   is
   begin
      return System.RPC.Partition_ID'First;
   end Get_Active_Partition_ID;

   ----------------------------
   -- Get_Local_Partition_Id --
   ----------------------------

   function Get_Local_Partition_ID return System.RPC.Partition_ID is
   begin
      return System.RPC.Partition_ID (getpid mod 7);
   end Get_Local_Partition_ID;

   ------------------------------
   -- Get_Passive_Partition_Id --
   ------------------------------

   function Get_Passive_Partition_ID
     (Name : in Library_Unit_Name)
      return System.RPC.Partition_ID
   is
   begin
      return System.RPC.Partition_ID (getpid mod 7);
   end Get_Passive_Partition_ID;

   ------------------------------
   -- Get_RCI_Package_Receiver --
   ------------------------------

   function Get_RCI_Package_Receiver
     (Name : in Library_Unit_Name)
      return System.RPC.RPC_Receiver
   is
      x : System.RPC.RPC_Receiver;

   begin
      return x;
   end Get_RCI_Package_Receiver;

   ---------------------------------
   -- Register_Server_Elaboration --
   ---------------------------------

   procedure Register_Server_Elaboration
     (Name     : in Library_Unit_Name;
      Receiver : in System.RPC.RPC_Receiver;
      Version  : in String)
   is
   begin
      null;
   end Register_Server_Elaboration;

end System.Partition_Interface;
