------------------------------------------------------------------------------
--                                                                          --
--                 GNU ADA RUNTIME LIBRARY (GNARL) COMPONENTS               --
--                                                                          --
--          I n t e r f a c e s . C . S Y S T E M _ C o n s t a n t s       --
--                                                                          --
--                                  S p e c                                 --
--                                                                          --
--                             $Revision: 1.1 $                             --
--                                                                          --
--      Copyright (c) 1991,1992,1993,1994,1996 FSU, All Rights Reserved     --
--                                                                          --
-- GNARL is free software; you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion. GNARL is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNARL; see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- As a special exception,  if other files  instantiate  generics from this --
-- unit, or you link  this unit with other files  to produce an executable, --
-- this  unit  does not  by itself cause  the resulting  executable  to  be --
-- covered  by the  GNU  General  Public  License.  This exception does not --
-- however invalidate  any other reasons why  the executable file  might be --
-- covered by the  GNU Public License.                                      --
--                                                                          --
-- GNARL was developed by the GNARL team at Florida State University. It is --
-- now maintained by Ada Core Technologies Inc. in cooperation with Florida --
-- State University (http://www.gnat.com).                                  --
--                                                                          --
------------------------------------------------------------------------------
--  This is a special DJGPP v2 version of this package

package Interfaces.C.System_Constants is

   pthread_t_size : constant Integer := 4;
   pthread_attr_t_size : constant Integer := 52;
   pthread_mutexattr_t_size : constant Integer := 12;
   pthread_mutex_t_size : constant Integer := 32;
   pthread_condattr_t_size : constant Integer := 4;
   pthread_cond_t_size : constant Integer := 20;
   pthread_key_t_size : constant Integer := 4;
   jmp_buf_size : constant Integer := 172;
   sigjmp_buf_size : constant Integer := 172;
   sigset_t_size : constant Integer := 40;

   --  The sizes of structures  (in bytes) and offsets of their components
   --  (in bits).  These are used to lay out the equivalent Ada records.
   siginfo_size : constant Integer := 12;
   si_signo_offset : constant Integer := 0;
   si_code_offset : constant Integer := 32;
   sigaction_size : constant Integer := 48;
   sa_handler_offset : constant Integer := 32;
   sa_mask_offset : constant Integer := 64;
   sa_flags_offset : constant Integer := 0;
   timespec_size : constant Integer := 8;
   tv_sec_offset : constant Integer := 0;
   tv_nsec_offset : constant Integer := 32;

   SIG_BLOCK : constant := 1;
   SIG_UNBLOCK : constant := 3;
   SIG_SETMASK : constant := 2;
   SA_NOCLDSTOP : constant := 1;
   SA_SIGINFO : constant := 0;
   SIG_ERR : constant := 1;
   SIG_DFL : constant := 0;
   SIG_IGN : constant := -1;
   SIGNULL : constant := 0;
   SIGHUP  : constant := 294;
   SIGINT  : constant := 295;
   SIGQUIT : constant := 298;
   SIGILL  : constant := 290;
   SIGABRT : constant := 288;
   SIGFPE  : constant := 289;
   SIGKILL : constant := 296;
   SIGSEGV : constant := 291;
   SIGPIPE : constant := 297;
   SIGALRM : constant := 293;
   SIGTERM : constant := 292;
   SIGSTOP : constant := 0;
   SIGTSTP : constant := 0;
   SIGCONT : constant := 0;
   SIGCHLD : constant := 0;
   SIGTTIN : constant := 0;
   SIGTTOU : constant := 0;
   SIGUSR1 : constant := 299;
   SIGUSR2 : constant := 300;
   NSIG    : constant := 320;
   --  OS specific signals represented as an array
   type Sig_Array is array (positive range <>) of integer;
   OS_Specific_Sync_Sigs : Sig_Array :=
     (NSIG, 302, 0);
   OS_Specific_Async_Sigs : Sig_Array :=
     (NSIG, 304, 0);
   --  End of OS specific signals representation
   E2BIG    : constant := 3;
   EACCES   : constant := 4;
   EAGAIN   : constant := 5;
   EBADF    : constant := 6;
   EBUSY    : constant := 7;
   ECHILD   : constant := 8;
   EDEADLK  : constant := 9;
   EDOM     : constant := 1;
   EEXIST   : constant := 10;
   EFAULT   : constant := 11;
   EFBIG    : constant := 12;
   EINTR    : constant := 13;
   EINVAL   : constant := 14;
   EIO      : constant := 15;
   EISDIR   : constant := 16;
   EMFILE   : constant := 17;
   EMLINK   : constant := 18;
   ENAMETOOLONG : constant := 19;
   ENFILE   : constant := 20;
   ENODEV   : constant := 21;
   ENOENT   : constant := 22;
   ENOEXEC  : constant := 23;
   ENOLCK   : constant := 24;
   ENOMEM   : constant := 25;
   ENOSPC   : constant := 26;
   ENOSYS   : constant := 27;
   ENOTDIR  : constant := 28;
   ENOTEMPTY    : constant := 29;
   ENOTTY   : constant := 30;
   ENXIO    : constant := 31;
   EPERM    : constant := 32;
   EPIPE    : constant := 33;
   ERANGE   : constant := 2;
   EROFS    : constant := 34;
   ESPIPE   : constant := 35;
   ESRCH    : constant := 36;
   EXDEV    : constant := 37;
   ETIME    : constant := 0;  -- ???
   ETIMEDOUT : constant := 0;  -- ???
   NO_PRIO_INHERIT : constant := 0;
   PRIO_INHERIT : constant := 1;
   PRIO_PROTECT : constant := 2;
   Add_Prio : constant Integer := 2;

end Interfaces.C.System_Constants;
