/*
 * tiny-login.h - This file is part of the tiny-utils package for Linux & ELKS,
 * Copyright (C) 1995, 1996 Nat Friedman <ndf@linux.mit.edu>.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#include "config.h"

/****************************** Types ****************************************/
struct settings {
  char username[MAX_USERNAME_LENGTH];
  char password[MAX_PW_LENGTH];
#ifdef SUPPORT_REMOTE
  char hostname[MAX_HOSTNAME_LENGTH];
  struct hostent hostaddr;
  int remote_login;
#endif
  int force;
  int have_username;
};
  
/******************************** Prototypes *********************************/
void report_error(const char * err_str1, const char * err_str2,
		  const int fatal);
void parse_commandline(int argc, char ** argv, struct settings * settings);
int get_username(struct settings * settings);
int get_password(struct settings * settings);
int verify_password(struct settings settings, char * password);
void display_motd(void);
void login_failure(struct settings * settings, int * num_failures);
void check_nologin(void);
void log_in(struct settings settings, struct passwd * passwd_entry);
#ifdef SUPPORT_UTMP
int update_utmp(struct settings settings);
#endif
#ifdef SUPPORT_REMOTE
int get_hostent(struct settings * settings);
#endif






